/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.doughnut;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiPenAlignment;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.doughnut.IStiDoughnutSeries;
import java.util.ArrayList;

public class StiDoughnutSeriesElementGeom
extends StiSeriesElementGeom {
    private final ArrayList<StiSegmentGeom> path;
    private final ArrayList<StiSegmentGeom> pathLight;
    private final ArrayList<StiSegmentGeom> pathDark;
    private final StiColor borderColor;
    private final StiBrush brush;
    private final StiBrush brushLight;
    private final StiBrush brushDark;
    private final double startAngle;
    private final double endAngle;
    private final double radiusFrom;
    private final double radiusTo;
    private Integer beginTime;

    public final ArrayList<StiSegmentGeom> getPath() {
        return this.path;
    }

    public final ArrayList<StiSegmentGeom> getPathLight() {
        return this.pathLight;
    }

    public final ArrayList<StiSegmentGeom> getPathDark() {
        return this.pathDark;
    }

    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    public final StiBrush getBrush() {
        return this.brush;
    }

    public final StiBrush getBrushLight() {
        return this.brushLight;
    }

    public final StiBrush getBrushDark() {
        return this.brushDark;
    }

    public final double getStartAngle() {
        return this.startAngle;
    }

    public final double getEndAngle() {
        return this.endAngle;
    }

    public final double getRadiusFrom() {
        return this.radiusFrom;
    }

    public final double getRadiusTo() {
        return this.radiusTo;
    }

    public Integer getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Integer beginTime) {
        this.beginTime = beginTime;
    }

    @Override
    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        StiPoint center = new StiPoint(this.getClientRectangle().x + this.getClientRectangle().width / 2.0, this.getClientRectangle().y + this.getClientRectangle().height / 2.0);
        double dx = x - center.x;
        double dy = y - center.y;
        float radius = (float)Math.sqrt(dx * dx + dy * dy);
        if ((double)radius < this.getRadiusTo() || (double)radius > this.getRadiusFrom()) {
            return false;
        }
        float alpha = (float)(Math.atan2(dy, dx) * 180.0 / Math.PI);
        if (alpha < 0.0f) {
            alpha += 360.0f;
        }
        return (double)alpha >= this.getStartAngle() && (double)alpha <= this.getEndAngle();
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rectPie = this.getClientRectangle();
        StiPenGeom pen = new StiPenGeom(StiColorUtils.dark((StiColor)this.getBorderColor(), (int)10));
        pen.setAlignment(StiPenAlignment.Inset);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiOpacityAnimation animation = new StiOpacityAnimation(Integer.valueOf(1000), this.beginTime);
            context.FillDrawAnimationPath((Object)this.brush, pen, this.path, (Object)rectPie, (Object)this, (StiAnimation)animation, this.getInteractionData());
        } else {
            context.PushSmoothingModeToAntiAlias();
            if (this.getPath() != null) {
                context.FillPath((Object)this.brush, this.getPath(), (Object)rectPie, this.getInteractionData());
                if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                    context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), this.getPath(), (Object)rectPie, null);
                }
            }
            if (this.getPathLight() != null) {
                context.FillPath((Object)this.getBrushLight(), this.getPathLight(), (Object)rectPie, null);
            }
            if (this.getPathDark() != null) {
                context.FillPath((Object)this.getBrushDark(), this.getPathDark(), (Object)rectPie, null);
            }
            context.DrawPath(pen, this.path, StiPathGeom.GetBoundsState);
            context.PopSmoothingMode();
        }
    }

    public StiDoughnutSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, IStiDoughnutSeries series, StiRectangle clientRectangle, ArrayList<StiSegmentGeom> path, ArrayList<StiSegmentGeom> pathLight, ArrayList<StiSegmentGeom> pathDark, StiColor borderColor, StiBrush brush, StiBrush brushLight, StiBrush brushDark, double startAngle, double endAngle, double radiusFrom, double radiusTo, Integer beginTime) {
        super(areaGeom, value, index, series, clientRectangle);
        this.path = path;
        this.pathLight = pathLight;
        this.pathDark = pathDark;
        this.borderColor = borderColor;
        this.brush = brush;
        this.brushLight = brushLight;
        this.brushDark = brushDark;
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        this.radiusFrom = radiusFrom;
        this.radiusTo = radiusTo;
        this.beginTime = beginTime;
    }
}

