/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.axis.scrollBars;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiHorzScrollBarGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiXAxis;

public class StiHorzTrackBarGeom
extends StiCellGeom {
    private final IStiXAxis axis;
    private final StiHorzScrollBarGeom scrollBar;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        if (!this.getAxis().getCore().getIsMouseOverTrackBar()) {
            this.getAxis().getCore().setIsMouseOverTrackBar(true);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        if (this.getAxis().getCore().getIsMouseOverTrackBar()) {
            this.getAxis().getCore().setIsMouseOverTrackBar(false);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseDown(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        StiAreaCoreXF tempVar = this.getAxis().getArea().getCore();
        StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar instanceof StiAxisAreaCoreXF ? tempVar : null);
        options.setDragEnabled(true);
        axisCore.setScrollDragStartValue(axisCore.getScrollValueX());
    }

    @Override
    public void InvokeDrag(StiInteractionOptions options) {
        if (!this.getAxis().getInteraction().getRangeScrollEnabled()) {
            return;
        }
        StiAreaCoreXF tempVar = this.getAxis().getArea().getCore();
        StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar instanceof StiAxisAreaCoreXF ? tempVar : null);
        axisCore.setBlockScrollValueX(true);
        double buttonSize = this.getScrollBar().getClientRectangle().height;
        double width = this.getScrollBar().getClientRectangle().width - buttonSize * 2.0;
        axisCore.setScrollValueX(options.getDragDelta().width / width * axisCore.getScrollRangeX() + axisCore.getScrollDragStartValue());
        if (axisCore.getScrollValueX() < 0.0) {
            axisCore.setScrollValueX(0.0);
        }
        if (axisCore.getScrollValueX() >= axisCore.getScrollRangeX() - axisCore.getScrollViewX()) {
            axisCore.setScrollValueX(axisCore.getScrollRangeX() - axisCore.getScrollViewX());
        }
        options.setUpdateContext(true);
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        StiPenGeom penLine = new StiPenGeom(this.getAxis().getLineColor());
        StiPenGeom penWhite = new StiPenGeom(StiColor.White);
        StiAreaCoreXF tempVar = this.getAxis().getArea().getCore();
        StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar instanceof StiAxisAreaCoreXF ? tempVar : null);
        IStiXAxis rollAxis = this.getAxis().getArea().getXAxis();
        if (this.getAxis().getCore().getIsMouseOverTrackBar()) {
            context.FillRectangle((Object)StiColorUtils.light((StiColor)this.getAxis().getLineColor(), (int)50), rect.x, rect.y, rect.width, rect.height, null);
        } else {
            context.FillRectangle((Object)this.getAxis().getLineColor(), rect.x, rect.y, rect.width, rect.height, null);
        }
        context.DrawRectangle(penLine, rect.x, rect.y, rect.width, rect.height);
        if (rect.width > 10.0 && rect.height > 4.0) {
            double rollerCenterX = rect.x + rect.width / 2.0;
            context.DrawLine(penWhite, rollerCenterX - 2.0, rect.y + 2.0, rollerCenterX - 2.0, rect.getBottom() - 2.0);
            context.DrawLine(penWhite, rollerCenterX, rect.y + 2.0, rollerCenterX, rect.getBottom() - 2.0);
            context.DrawLine(penWhite, rollerCenterX + 2.0, rect.y + 2.0, rollerCenterX + 2.0, rect.getBottom() - 2.0);
        }
    }

    public final IStiXAxis getAxis() {
        return this.axis;
    }

    public final StiHorzScrollBarGeom getScrollBar() {
        return this.scrollBar;
    }

    public StiHorzTrackBarGeom(IStiXAxis axis, StiRectangle clientRectangle, StiHorzScrollBarGeom scrollBar) {
        super(clientRectangle);
        this.axis = axis;
        this.scrollBar = scrollBar;
    }
}

