/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiGlareBrush;
import com.stimulsoft.base.drawing.StiGradientBrush;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.series.doughnut.StiDoughnutSeriesCoreXF;
import com.stimulsoft.report.chart.core.styles.StiStyleCoreXF;
import com.stimulsoft.report.chart.core.styles.StiStyleCoreXF01;
import com.stimulsoft.report.chart.core.styles.StiStyleCoreXF29;
import com.stimulsoft.report.chart.enums.StiShowSeriesLabels;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyleSeries;
import com.stimulsoft.report.chart.interfaces.IStiSeriesInteraction;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.clusteredBar.IStiClusteredBarArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class StiSeriesCoreXF
implements Cloneable,
IStiApplyStyleSeries {
    private static Object FalseObject = new Object();
    private static Object TrueObject = new Object();
    private Hashtable isMouseOverSeriesElementHashtable = null;
    private boolean isMouseOver = false;
    private boolean isDateTimeValues = false;
    private IStiSeries series;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        if (this.getSeries().getAllowApplyStyle()) {
            this.getSeries().setShowShadow(style.getCore().isSeriesShowShadow());
            if (this.getSeries().getSeriesLabels() != null) {
                this.getSeries().getSeriesLabels().getCore().applyStyle(style);
            }
        }
    }

    protected final StiRectangle CheckLabelsRect(IStiSeriesLabels labels, StiAreaGeom geom, StiRectangle labelsRect) {
        return this.CheckLabelsRect(labels, geom.getClientRectangle(), labelsRect);
    }

    protected final StiRectangle CheckLabelsRect(IStiSeriesLabels labels, StiRectangle rect, StiRectangle labelsRect) {
        if (labels != null && labels.getPreventIntersection()) {
            if (labelsRect.x < 0.0) {
                labelsRect.x = 0.0;
            }
            if (labelsRect.y < 0.0) {
                labelsRect.y = 0.0;
            }
            if (labelsRect.getRight() > rect.width) {
                labelsRect.x = rect.width - labelsRect.width;
            }
            if (labelsRect.getBottom() > rect.height) {
                labelsRect.y = rect.height - labelsRect.height;
            }
            StiRectangle rectangle = this.getDrawRectangle(labelsRect, labels.getAngle());
            if (rectangle.y < 0.0) {
                labelsRect.y = 25.0;
                return labelsRect;
            }
            if (rectangle.y + rectangle.height > rect.height) {
                labelsRect.y -= rectangle.height / 2.0;
            }
        }
        return labelsRect;
    }

    private StiRectangle getDrawRectangle(StiRectangle labelsRect, double angle) {
        StiPoint point1 = new StiPoint(labelsRect.getLeft(), labelsRect.getTop());
        StiPoint point2 = new StiPoint(labelsRect.getRight(), labelsRect.getTop());
        StiPoint point3 = new StiPoint(labelsRect.getRight(), labelsRect.getBottom());
        StiPoint point4 = new StiPoint(labelsRect.getLeft(), labelsRect.getBottom());
        StiPoint pointCenter = new StiPoint((labelsRect.getLeft() + labelsRect.getRight()) / 2.0, (labelsRect.getTop() + labelsRect.getBottom()) / 2.0);
        StiPoint pointRotate1 = this.rotatePoint(point1, pointCenter, angle);
        StiPoint pointRotate2 = this.rotatePoint(point2, pointCenter, angle);
        StiPoint pointRotate3 = this.rotatePoint(point3, pointCenter, angle);
        StiPoint pointRotate4 = this.rotatePoint(point4, pointCenter, angle);
        double minY = Math.min(Math.min(pointRotate1.y, pointRotate2.y), Math.min(pointRotate3.y, pointRotate4.y));
        double maxY = Math.max(Math.max(pointRotate1.y, pointRotate2.y), Math.max(pointRotate3.y, pointRotate4.y));
        double minX = Math.min(Math.min(pointRotate1.x, pointRotate2.x), Math.min(pointRotate3.x, pointRotate4.x));
        double maxX = Math.max(Math.max(pointRotate1.x, pointRotate2.x), Math.max(pointRotate3.x, pointRotate4.x));
        return new StiRectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private StiPoint rotatePoint(StiPoint pointToRotate, StiPoint centerPoint, double angleInDegrees) {
        double angleInRadians = angleInDegrees * (Math.PI / 180);
        double cosTheta = Math.cos(angleInRadians);
        double sinTheta = Math.sin(angleInRadians);
        return new StiPoint(cosTheta * (pointToRotate.x - centerPoint.x) - sinTheta * (pointToRotate.y - centerPoint.y) + centerPoint.x, sinTheta * (pointToRotate.x - centerPoint.x) + cosTheta * (pointToRotate.y - centerPoint.y) + centerPoint.y);
    }

    protected final void CheckIntersectionLabels(StiAreaGeom geom) {
        ArrayList<StiCellGeom> childGeoms = geom.getChildGeoms();
        ArrayList<StiSeriesLabelsGeom> labelGeoms = new ArrayList<StiSeriesLabelsGeom>();
        if (childGeoms != null) {
            for (StiCellGeom cellGeom : childGeoms) {
                if (!(cellGeom instanceof StiSeriesLabelsGeom)) continue;
                labelGeoms.add((StiSeriesLabelsGeom)cellGeom);
            }
        }
        int count = labelGeoms.size();
        boolean intersection = true;
        int indexCheck = 0;
        while (intersection && indexCheck < 29) {
            ++indexCheck;
            for (int index1 = 0; index1 < count; ++index1) {
                for (int index2 = 0; index2 < count; ++index2) {
                    if (index2 == index1) continue;
                    StiRectangle rect1 = this.getDrawRectangle(((StiSeriesLabelsGeom)labelGeoms.get(index1)).getClientRectangle(), ((StiSeriesLabelsGeom)labelGeoms.get(index1)).getSeriesLabels().getAngle());
                    StiRectangle rect2 = this.getDrawRectangle(((StiSeriesLabelsGeom)labelGeoms.get(index2)).getClientRectangle(), ((StiSeriesLabelsGeom)labelGeoms.get(index2)).getSeriesLabels().getAngle());
                    boolean isChanged1 = false;
                    boolean isChanged2 = false;
                    double overlay = rect1.height - Math.abs(rect2.y - rect1.y) + 2.0;
                    if (rect1.IntersectsWith(rect2)) {
                        if (rect1.y > rect2.y) {
                            rect1.y += overlay / 2.0;
                            rect2.y -= overlay / 2.0;
                            isChanged1 = true;
                            isChanged2 = true;
                        } else {
                            rect1.y -= overlay / 2.0;
                            rect2.y += overlay / 2.0;
                            isChanged1 = true;
                            isChanged2 = true;
                        }
                    }
                    if (rect1.y < 0.0) {
                        rect1.y = 2.0;
                        isChanged1 = true;
                    }
                    if (rect2.y < 0.0) {
                        rect2.y = 2.0;
                        isChanged2 = true;
                    }
                    if (rect1.y + rect1.height > geom.getClientRectangle().height) {
                        rect1.y = geom.getClientRectangle().height - rect1.height - 2.0;
                        isChanged1 = true;
                    }
                    if (rect2.y + overlay / 2.0 + rect2.height > geom.getClientRectangle().height) {
                        rect2.y = geom.getClientRectangle().height - rect2.height - 2.0;
                        isChanged2 = true;
                    }
                    if (isChanged1) {
                        ((StiSeriesLabelsGeom)labelGeoms.get(index1)).setClientRectangle(this.getDrawRectangle(rect1, -((StiSeriesLabelsGeom)labelGeoms.get(index1)).getSeriesLabels().getAngle()));
                    }
                    if (!isChanged2) continue;
                    ((StiSeriesLabelsGeom)labelGeoms.get(index2)).setClientRectangle(this.getDrawRectangle(rect2, -((StiSeriesLabelsGeom)labelGeoms.get(index2)).getSeriesLabels().getAngle()));
                }
            }
        }
    }

    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] seriesArray) {
    }

    public StiBrush GetSeriesBrush(int colorIndex, int colorCount) {
        if (this.getSeries().getChart() == null || this.getSeries().getChart().getArea() == null) {
            return null;
        }
        if (this.getSeries().getChart().getArea().getColorEach() || this instanceof StiDoughnutSeriesCoreXF) {
            StiStyleCoreXF01 styleCore = this.getSeries().getChart().getStyle() != null ? this.getSeries().getChart().getStyle().getCore() : new StiStyleCoreXF01();
            StiColor color = styleCore.GetColorByIndex(colorIndex, colorCount, null);
            StiBrush seriesBrush = ((StiStyleCoreXF)styleCore).GetColumnBrush(color);
            if (this.getSeries().getChart().getArea() instanceof IStiClusteredBarArea) {
                if (seriesBrush instanceof StiGradientBrush) {
                    ((StiGradientBrush)seriesBrush).angle += 90.0;
                }
                if (seriesBrush instanceof StiGlareBrush) {
                    ((StiGlareBrush)seriesBrush).angle += 90.0;
                }
            }
            return seriesBrush;
        }
        return null;
    }

    public Object GetSeriesBorderColor(int colorIndex, int colorCount) {
        if (this.getSeries().getChart() == null || this.getSeries().getChart().getArea() == null) {
            return null;
        }
        if (this.getSeries().getChart().getArea().getColorEach() || this instanceof StiDoughnutSeriesCoreXF) {
            StiStyleCoreXF29 styleCore = this.getSeries().getChart().getStyle() != null ? this.getSeries().getChart().getStyle().getCore() : new StiStyleCoreXF29();
            StiColor color = styleCore.GetColorByIndex(colorIndex, colorCount, null);
            return ((StiStyleCoreXF)styleCore).GetColumnBorder(color);
        }
        return null;
    }

    public final IStiAxisSeriesLabels GetSeriesLabels() {
        if (this.getSeries().getShowSeriesLabels() == StiShowSeriesLabels.FromChart) {
            IStiSeriesLabels tempVar = this.getSeries().getChart().getSeriesLabels();
            return (IStiAxisSeriesLabels)(tempVar instanceof IStiAxisSeriesLabels ? tempVar : null);
        }
        if (this.getSeries().getShowSeriesLabels() == StiShowSeriesLabels.FromSeries) {
            IStiSeriesLabels tempVar2 = this.getSeries().getSeriesLabels();
            return (IStiAxisSeriesLabels)(tempVar2 instanceof IStiAxisSeriesLabels ? tempVar2 : null);
        }
        return null;
    }

    public final String GetTag(int tagIndex) {
        if (this.series.getTags() != null && tagIndex < this.series.getTags().length && this.series.getTags()[tagIndex] != null) {
            return this.series.getTags()[tagIndex].toString();
        }
        return "";
    }

    public final boolean GetIsMouseOverSeriesElement(int seriesIndex) {
        if (this.isMouseOverSeriesElementHashtable == null) {
            return false;
        }
        return this.isMouseOverSeriesElementHashtable.get(seriesIndex) == TrueObject;
    }

    public final void SetIsMouseOverSeriesElement(int seriesIndex, boolean value) {
        if (this.isMouseOverSeriesElementHashtable == null) {
            this.isMouseOverSeriesElementHashtable = new Hashtable();
        }
        this.isMouseOverSeriesElementHashtable.put(seriesIndex, value ? TrueObject : FalseObject);
    }

    public final boolean getIsMouseOver() {
        return this.isMouseOver;
    }

    public final void setIsMouseOver(boolean value) {
        this.isMouseOver = value;
    }

    public abstract String getLocalizedName();

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final boolean getIsDateTimeValues() {
        return this.isDateTimeValues;
    }

    public final void setIsDateTimeValues(boolean value) {
        this.isDateTimeValues = value;
    }

    public final IStiSeries getSeries() {
        return this.series;
    }

    public final void setSeries(IStiSeries value) {
        this.series = value;
    }

    public final IStiSeriesInteraction getInteraction() {
        return this.getSeries().getInteraction();
    }

    public final void setInteraction(IStiSeriesInteraction value) {
        this.getSeries().setInteraction(value);
    }

    public StiSeriesCoreXF(IStiSeries series) {
        this.series = series;
    }

    public StiSeriesInteractionData getInteraction(IStiArea area, IStiSeries series, int pointIndex) {
        if (series.getCore().getInteraction() != null && series.getCore().getInteraction().getDrillDownEnabled()) {
            return new StiSeriesInteractionData(area, series, pointIndex);
        }
        return null;
    }
}

