/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.axis;

import com.stimulsoft.base.context.chart.IStiContextPainter;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartOptions;
import com.stimulsoft.report.chart.core.area.StiAreaCoreXF;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.StiAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.StiAxisLabelInfoXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineCalculatorXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripPositionXF;
import com.stimulsoft.report.chart.enums.StiArrowStyle;
import com.stimulsoft.report.chart.enums.StiLabelsPlacement;
import com.stimulsoft.report.chart.enums.StiMarkerAlignment;
import com.stimulsoft.report.chart.enums.StiTimeDateStep;
import com.stimulsoft.report.chart.enums.StiXAxisDock;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.axis.StiAxisLabelGeom;
import com.stimulsoft.report.chart.geoms.axis.StiAxisTitleGeom;
import com.stimulsoft.report.chart.geoms.axis.StiXAxisGeom;
import com.stimulsoft.report.chart.geoms.axis.StiXAxisViewGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiHorzScrollBarGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiHorzTrackBarGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiLeftButtonGeom;
import com.stimulsoft.report.chart.geoms.axis.scrollBars.StiRightButtonGeom;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiXAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiXBottomAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiXTopAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.view.areas.gantt.StiGanttArea;
import com.stimulsoft.report.chart.view.areas.scatter.StiScatterArea;
import com.stimulsoft.report.chart.view.axis.StiXBottomAxis;
import com.stimulsoft.report.components.StiComponent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public abstract class StiXAxisCoreXF
extends StiAxisCoreXF {
    @Override
    public boolean GetStartFromZero() {
        if (this.getAxis().getInfo().LabelsCollection != null && this.IsArgumentDateTime(this.getAxis().getInfo().LabelsCollection) && (this.getAxis().getArea() instanceof StiScatterArea || this.getAxis().getArea() instanceof StiGanttArea)) {
            return false;
        }
        return super.GetStartFromZero();
    }

    @Override
    public StiCellGeom Render(StiContext context, StiRectangle rect) {
        IStiAxis tempVar;
        if (!this.getAxis().getVisible()) {
            return null;
        }
        StiRectangle axisRect = this.GetAxisRect(context, rect, false, false, true, false);
        axisRect.x = 0.0;
        axisRect.y = 0.0;
        if (this.getAxis().getInteraction().getShowScrollBar() && (this.getAxis() instanceof IStiXBottomAxis && !this.getAxis().getArea().getReverseVert() || this.getAxis() instanceof IStiXTopAxis && this.getAxis().getArea().getReverseVert())) {
            axisRect.y += (double)StiAxisCoreXF.DefaultScrollBarSize * context.Options.zoom;
        }
        StiXAxisGeom geom = new StiXAxisGeom((IStiXAxis)((tempVar = this.getAxis()) instanceof IStiXAxis ? tempVar : null), axisRect, false);
        this.RenderLabels(context, axisRect, geom);
        this.RenderTitle(context, axisRect, geom);
        return geom;
    }

    @Override
    public StiCellGeom RenderView(StiContext context, StiRectangle rect) {
        if (!this.getAxis().getVisible()) {
            return null;
        }
        StiRectangle axisRect = this.GetAxisRect(context, rect, false, false, true, true);
        IStiAxis tempVar = this.getAxis();
        return new StiXAxisViewGeom((IStiXAxis)(tempVar instanceof IStiXAxis ? tempVar : null), axisRect, false);
    }

    public final void RenderScrollBar(StiContext context, StiRectangle axisRect, StiXAxisViewGeom axisGeom) {
        if (this.getAxis().getInteraction().getShowScrollBar()) {
            IStiAxis tempVar5;
            StiRectangle scrollBarRect = axisRect;
            scrollBarRect.x = 0.0;
            scrollBarRect.height = (double)StiAxisCoreXF.DefaultScrollBarSize * context.Options.zoom;
            scrollBarRect.y = this.getAxis() instanceof IStiXTopAxis && !this.getAxis().getArea().getReverseVert() || this.getAxis() instanceof IStiXBottomAxis && this.getAxis().getArea().getReverseVert() ? axisRect.height - scrollBarRect.height : 0.0;
            IStiAxis tempVar = this.getAxis();
            StiHorzScrollBarGeom scrollBarGeom = new StiHorzScrollBarGeom((IStiXAxis)(tempVar instanceof IStiXAxis ? tempVar : null), scrollBarRect);
            axisGeom.CreateChildGeoms();
            axisGeom.getChildGeoms().add(scrollBarGeom);
            scrollBarRect.x = 0.0;
            scrollBarRect.y = 0.0;
            scrollBarRect.inflate(-2, -2);
            if (this.getAxis().getInteraction().getRangeScrollEnabled()) {
                StiRectangle leftButtonRect = scrollBarRect;
                leftButtonRect.width = scrollBarRect.height;
                IStiAxis tempVar2 = this.getAxis();
                StiLeftButtonGeom leftButtonGeom = new StiLeftButtonGeom((IStiXAxis)(tempVar2 instanceof IStiXAxis ? tempVar2 : null), leftButtonRect);
                scrollBarGeom.CreateChildGeoms();
                scrollBarGeom.getChildGeoms().add(leftButtonGeom);
                StiRectangle rightButtonRect = scrollBarRect;
                rightButtonRect.width = scrollBarRect.height;
                rightButtonRect.x = scrollBarRect.getRight() - rightButtonRect.width;
                IStiAxis tempVar3 = this.getAxis();
                StiRightButtonGeom rightButtonGeom = new StiRightButtonGeom((IStiXAxis)(tempVar3 instanceof IStiXAxis ? tempVar3 : null), rightButtonRect);
                scrollBarGeom.CreateChildGeoms();
                scrollBarGeom.getChildGeoms().add(rightButtonGeom);
                scrollBarRect.inflate(Double.valueOf(-scrollBarRect.height - 2.0), Double.valueOf(0.0));
            }
            StiRectangle trackBarRect = scrollBarRect;
            IStiXAxis rollAxis = this.getAxis().getArea().getXAxis();
            StiAreaCoreXF tempVar4 = this.getAxis().getArea().getCore();
            StiAxisAreaCoreXF axisCore = (StiAxisAreaCoreXF)(tempVar4 instanceof StiAxisAreaCoreXF ? tempVar4 : null);
            if (!rollAxis.getRange().getAuto()) {
                float dpi = (float)(scrollBarRect.width / axisCore.getScrollRangeX());
                float x = (float)axisCore.getScrollValueX() * dpi;
                double width = axisCore.getScrollViewX() * (double)dpi;
                trackBarRect = new StiRectangle((double)x + scrollBarRect.x, scrollBarRect.y, width, scrollBarRect.height);
            }
            StiHorzTrackBarGeom trackBarGeom = new StiHorzTrackBarGeom((IStiXAxis)((tempVar5 = this.getAxis()) instanceof IStiXAxis ? tempVar5 : null), trackBarRect, scrollBarGeom);
            scrollBarGeom.CreateChildGeoms();
            scrollBarGeom.getChildGeoms().add(trackBarGeom);
        }
    }

    public final StiCellGeom RenderCenter(StiContext context, StiRectangle rect) {
        if (!this.getAxis().getVisible()) {
            return null;
        }
        if (this.getAxis().getArea().getYAxis().getInfo().Minimum >= 0.0) {
            return null;
        }
        StiRectangle axisRect = this.GetCenterAxisRect(context, rect, false, false, true);
        axisRect.x = 0.0;
        axisRect.y = 0.0;
        IStiAxis tempVar = this.getAxis();
        return new StiXAxisGeom((IStiXAxis)(tempVar instanceof IStiXAxis ? tempVar : null), axisRect, true);
    }

    public final StiCellGeom RenderCenterView(StiContext context, StiRectangle rect) {
        if (!this.getAxis().getVisible()) {
            return null;
        }
        if (this.getAxis().getArea().getYAxis().getInfo().Minimum >= 0.0) {
            return null;
        }
        StiRectangle axisRect = this.GetCenterAxisRect(context, rect, false, false, true);
        IStiAxis tempVar = this.getAxis();
        StiXAxisViewGeom axisGeom = new StiXAxisViewGeom((IStiXAxis)(tempVar instanceof IStiXAxis ? tempVar : null), axisRect, true);
        return axisGeom;
    }

    public final String GetLabelText(StiStripLineXF line, IStiSeries series) {
        Object value = line.getValueObject();
        try {
            String format = null;
            if (series != null) {
                format = series.getFormat();
            }
            if (format == null || format.trim().length() == 0) {
                format = this.getAxis().getLabels().getFormat();
            }
            if (format != null && format.trim().length() != 0) {
                if (value instanceof String) {
                    try {
                        value = new BigDecimal(value.toString());
                    }
                    catch (Exception e) {
                        try {
                            value = new Date(Date.parse(value.toString()));
                        }
                        catch (Exception e2) {
                            try {
                                value = new Date(Date.parse(value.toString()));
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else if (value == null) {
                    return "";
                }
                String culture = null;
                try {
                    culture = ((StiComponent)((Object)this.getAxis().getArea().getChart())).getReport().getCulture();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (!StiChartOptions.getOldChartPercentMode() && format.startsWith("P")) {
                    int signs = 0;
                    if (format.length() > 1) {
                        try {
                            signs = Integer.parseInt(format.substring(0, 0) + format.substring(1));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return String.format("%s%s%s%s", this.getAxis().getLabels().getTextBefore(), StiStringUtil.format((String)("{0:" + signs + "}"), (Object)value, (Locale)Locale.ENGLISH, (String)culture), "%", this.getAxis().getLabels().getTextAfter());
                }
                return String.format("%s%s%s", this.getAxis().getLabels().getTextBefore(), StiStringUtil.format((String)("{0:" + format + "}"), (Object)StiTextUtil.toString((Object)value), (Locale)Locale.ENGLISH, (String)culture), this.getAxis().getLabels().getTextAfter());
            }
            return String.format("%1$s%2$s%3$s", this.getAxis().getLabels().getTextBefore(), StiTextUtil.toString((Object)value), this.getAxis().getLabels().getTextAfter());
        }
        catch (Exception exception) {
            return StiTextUtil.toString((Object)value);
        }
    }

    private boolean getIsLabelsAngleByWidth() {
        return this.getAxis().getLabels().getAngle() < 30.0f || this.getAxis().getLabels().getAngle() > 150.0f;
    }

    private List<StiAxisLabelInfoXF> MeasureStripLines(StiContext context, StiRectangle rect) {
        double labelsWidth = this.getAxis().getLabels().getWidth();
        StiRotationMode rotationMode = null;
        boolean wordWrap = this.getAxis().getLabels().getWordWrap();
        float angle = -this.getAxis().getLabels().getAngle();
        boolean isAutoAngleLabels = this.checkAutoAngleLabels(context, rect);
        if (isAutoAngleLabels) {
            angle = -45.0f;
            rotationMode = this.getAxis() instanceof IStiXTopAxis ? StiRotationMode.LeftBottom : StiRotationMode.RightTop;
            wordWrap = false;
            double rootHeight = ((StiChart)this.getAxis().getArea().getChart()).getCore().fullRectangle.height;
            labelsWidth = rootHeight / 4.0;
        }
        List<StiAxisLabelInfoXF> infos = new ArrayList<StiAxisLabelInfoXF>();
        if (this.getAxis().getInfo().LabelsCollection != null && this.getAxis().getLabels().getPlacement() != StiLabelsPlacement.None) {
            StiRefObject maxLabelWidth = new StiRefObject((Object)0.0);
            infos = this.measureAxisLabelInfos(rect, angle, 0, this.getAxis().getInfo().LabelsCollection.size(), context, labelsWidth, rotationMode, wordWrap, (StiRefObject<Double>)maxLabelWidth);
            int labelsStep = 1;
            if (this.getAxis().getRange().getAuto()) {
                double widthPerLabel;
                if (isAutoAngleLabels) {
                    maxLabelWidth.argvalue = this.getAxis().getLabels().getFont().getHeight() * (double)1.2f * context.Options.zoom;
                    widthPerLabel = rect.width / (double)this.getAxis().getInfo().StripLines.size();
                    labelsStep = (int)Math.ceil((Double)maxLabelWidth.argvalue / widthPerLabel);
                } else {
                    if (!this.getIsLabelsAngleByWidth()) {
                        maxLabelWidth.argvalue = this.getAxis().getLabels().getFont().getHeight() * 1.5 * context.Options.zoom;
                    }
                    widthPerLabel = rect.width / (double)this.getAxis().getInfo().StripLines.size();
                    double count = (Double)maxLabelWidth.argvalue / widthPerLabel;
                    if (count > 1.0) {
                        labelsStep = (int)StiStripLineCalculatorXF.GetInterval(0.0, this.getAxis().getInfo().LabelsCollection.size(), 6);
                        if (this.getAxis().getLogarithmicScale()) {
                            labelsStep = 1;
                        }
                    }
                }
            } else {
                labelsStep = (int)Math.max(1.0, this.getAxis().getStep());
            }
            boolean twoLinesLabels = false;
            double posYTwoLine = 0.0;
            double posYOneLine = 0.0;
            if ((isAutoAngleLabels || this.getAxis().getLabels().getPlacement() == StiLabelsPlacement.TwoLines) && infos.size() > 1) {
                posYOneLine = infos.get((int)0).TextPoint.y;
                posYTwoLine = infos.get((int)1).TextPoint.y;
            }
            if (labelsStep == 1) {
                return infos;
            }
            int labelsIndex = 0;
            ArrayList<StiAxisLabelInfoXF> infos2 = new ArrayList<StiAxisLabelInfoXF>();
            for (StiAxisLabelInfoXF info : infos) {
                if (labelsIndex == 0) {
                    if (this.getAxis().getLabels().getPlacement() == StiLabelsPlacement.TwoLines && infos.size() > 1) {
                        if (twoLinesLabels) {
                            info.TextPoint.y = posYTwoLine;
                            twoLinesLabels = false;
                        } else {
                            info.TextPoint.y = posYOneLine;
                            twoLinesLabels = true;
                        }
                    }
                    infos2.add(info);
                }
                if (++labelsIndex != labelsStep) continue;
                labelsIndex = 0;
            }
            return infos2;
        }
        return infos;
    }

    public final StiRectangle GetCenterAxisRect(StiContext context, StiRectangle rect, boolean includeAxisArrow, boolean includeLabelsHeight, boolean isDrawing) {
        if (this.getAxis().getArea().getYAxis().getInfo().Minimum >= 0.0) {
            return StiRectangle.getEmpty();
        }
        double posY = -this.GetTicksMaxLength(context);
        return new StiRectangle(0.0, posY, rect.width, this.GetTicksMaxLength(context));
    }

    public final StiRectangle GetAxisRect(StiContext context, StiRectangle rect, boolean includeAxisArrow, boolean includeLabelsWidth, boolean isDrawing, boolean includeScrollBar) {
        StiSize titleSize;
        StiRectangle axisRect = StiRectangle.getEmpty();
        if (!this.getAxis().getVisible()) {
            return axisRect;
        }
        List<StiAxisLabelInfoXF> infos = this.MeasureStripLines(context, rect);
        if (infos.isEmpty()) {
            axisRect = this.getIsTopSide() ? new StiRectangle(0.0, -this.GetTicksMaxLength(context), rect.width, this.GetTicksMaxLength(context)) : new StiRectangle(0.0, rect.height, rect.width, this.GetTicksMaxLength(context));
        } else {
            for (StiAxisLabelInfoXF info : infos) {
                if (info.getClientRectangle().isEmpty().booleanValue()) continue;
                if (axisRect.isEmpty().booleanValue()) {
                    axisRect = info.getClientRectangle();
                    continue;
                }
                axisRect = StiRectangle.union((StiRectangle)axisRect, (StiRectangle)info.getClientRectangle());
            }
            if (axisRect.y < 0.0 && !this.getIsTopSide() && this.getAxis().getLabels().getTextAlignment() == StiMarkerAlignment.Right) {
                axisRect.height += axisRect.y;
                axisRect.y = 0.0;
            }
            if (this.getAxis().getInteraction().getShowScrollBar() && includeScrollBar) {
                axisRect.height += (double)StiAxisCoreXF.DefaultScrollBarSize * context.Options.zoom;
            }
            axisRect.height += this.GetTicksMaxLength(context) + this.GetLabelsSpaceAxis(context);
            StiRectangle axisRect2 = axisRect.clone();
            if (this.getIsTopSide()) {
                axisRect = new StiRectangle(0.0, -axisRect.height, rect.width, axisRect.height);
            }
            if (this.getIsBottomSide()) {
                axisRect = new StiRectangle(0.0, rect.height, rect.width, axisRect.height);
            }
            if (includeLabelsWidth) {
                axisRect.x = axisRect2.x;
                axisRect.width = axisRect2.width;
            }
        }
        if (this.getAxis().getArrowStyle() != StiArrowStyle.None && includeAxisArrow) {
            double arrowHeight = this.GetArrowHeight(context);
            if (this.getAxis().getArea().getReverseHor()) {
                arrowHeight = -arrowHeight;
            }
            axisRect = StiRectangle.union((StiRectangle)axisRect, (StiRectangle)new StiRectangle(rect.width, axisRect.y + axisRect.height / 2.0, arrowHeight, 1.0));
        }
        if (!(titleSize = this.GetAxisTitleSize(context)).isEmpty().booleanValue()) {
            axisRect.height += titleSize.height;
            if (axisRect.width == 0.0) {
                axisRect.width = titleSize.width;
            }
            if (this.getIsTopSide()) {
                axisRect.y -= titleSize.height;
            }
        }
        return axisRect;
    }

    private void RenderLabels(StiContext context, StiRectangle rect, StiXAxisGeom geom) {
        block8: {
            if (this.getAxis().getInfo().StripLines == null || this.getAxis().getLabels().getPlacement() == StiLabelsPlacement.None) break block8;
            List<StiAxisLabelInfoXF> infos = this.MeasureStripLines(context, rect);
            geom.CreateChildGeoms();
            IStiXAxis tempVar = this.getAxis().getArea().getXAxis();
            StiXBottomAxis axisX = (StiXBottomAxis)(tempVar instanceof StiXBottomAxis ? tempVar : null);
            if (this.IsArgumentDateTime2(infos) && axisX != null && axisX.getDateTimeStep().getStep() != StiTimeDateStep.None) {
                Date date = new Date(0L);
                Date dateNext = new Date(0L);
                ArrayList<StiStripPositionXF> tempLabels = axisX.getInfo().LabelsCollection;
                ArrayList<StiAxisLabelInfoXF> infosFirstLine = new ArrayList<StiAxisLabelInfoXF>();
                String text = "";
                boolean first = true;
                double startX = 0.0;
                for (int index = 0; index < tempLabels.size(); ++index) {
                    if (tempLabels.get((int)index).StripLine.getValueObject() == null) continue;
                    date = (Date)tempLabels.get((int)index).StripLine.getValueObject();
                    dateNext = index != tempLabels.size() - 2 ? (Date)tempLabels.get((int)(index + 1)).StripLine.getValueObject() : date;
                    if (first) {
                        startX = tempLabels.get((int)index).Position;
                        first = false;
                    }
                    if (text.equals("")) continue;
                    StiPoint point = new StiPoint((tempLabels.get((int)index).Position + startX) / 2.0, this.GetTicksMaxLength(context) + this.GetLabelsSpaceAxis(context));
                    float angle = 0.0f;
                    StiAxisLabelInfoXF info = new StiAxisLabelInfoXF();
                    info.Angle = angle;
                    info.setClientRectangle(context.MeasureRotatedString(text, this.GetFontGeom(context), point, this.GetStringFormatGeom(context, info.WordWrap), StiRotationMode.CenterCenter, (double)angle, (int)((double)this.getAxis().getLabels().getWidth() * context.Options.zoom), this.getAxis().getLabels().getWordWrap()));
                    info.RotationMode = StiRotationMode.CenterCenter;
                    info.StripLine = tempLabels.get((int)index).StripLine;
                    info.Text = text;
                    info.TextPoint = point;
                    infosFirstLine.add(info);
                    first = true;
                    text = "";
                }
                first = true;
                ArrayList<StiAxisLabelInfoXF> infosSecondLine = new ArrayList<StiAxisLabelInfoXF>();
                for (int index = 0; index < infosFirstLine.size() - 1; ++index) {
                    date = (Date)((StiAxisLabelInfoXF)infosFirstLine.get((int)index)).StripLine.getValueObject();
                    dateNext = (Date)((StiAxisLabelInfoXF)infosFirstLine.get((int)(index + 1))).StripLine.getValueObject();
                    if (first) {
                        startX = ((StiAxisLabelInfoXF)infosFirstLine.get((int)index)).TextPoint.x;
                        first = false;
                    }
                    if (text.equals("")) continue;
                    StiPoint point = new StiPoint((((StiAxisLabelInfoXF)infosFirstLine.get((int)(index + 1))).TextPoint.x + startX) / 2.0, this.GetTicksMaxLength(context) + 2.0 * this.GetLabelsSpaceAxis(context));
                    float angle = 0.0f;
                    StiAxisLabelInfoXF info = new StiAxisLabelInfoXF();
                    info.Angle = angle;
                    info.setClientRectangle(context.MeasureRotatedString(text, this.GetFontGeom(context), point, this.GetStringFormatGeom(context, info.WordWrap), StiRotationMode.CenterCenter, (double)angle, (int)((double)this.getAxis().getLabels().getWidth() * context.Options.zoom), this.getAxis().getLabels().getWordWrap()));
                    info.RotationMode = StiRotationMode.CenterTop;
                    info.StripLine = ((StiAxisLabelInfoXF)infosFirstLine.get((int)index)).StripLine;
                    info.Text = text;
                    info.TextPoint = point;
                    infosSecondLine.add(info);
                    first = true;
                    text = "";
                }
                infosFirstLine.addAll(infosSecondLine);
                for (StiAxisLabelInfoXF info : infosFirstLine) {
                    if (info.getClientRectangle().isEmpty().booleanValue()) continue;
                    StiAxisLabelGeom labelGeom = new StiAxisLabelGeom(this.getAxis(), info.getClientRectangle(), info.TextPoint, info.Text, info.StripLine, info.Angle, info.Width, info.RotationMode, info.WordWrap);
                    geom.getChildGeoms().add(labelGeom);
                }
            } else {
                for (StiAxisLabelInfoXF info : infos) {
                    if (info.getClientRectangle().isEmpty().booleanValue()) continue;
                    StiAxisLabelGeom labelGeom = new StiAxisLabelGeom(this.getAxis(), info.getClientRectangle(), info.TextPoint, info.Text, info.StripLine, info.Angle, info.Width, info.RotationMode, info.WordWrap);
                    geom.getChildGeoms().add(labelGeom);
                }
            }
        }
    }

    private void RenderTitle(StiContext context, StiRectangle axisRect, StiXAxisGeom geom) {
        if (StiValidationUtil.isNullOrEmpty((String)this.getAxis().getTitle().getText())) {
            return;
        }
        StiSize titleSize = this.GetAxisTitleSize(context);
        StiRectangle titleRect = StiRectangle.getEmpty();
        if (this.getIsTopSide()) {
            switch (this.getAxis().getTitle().getAlignment()) {
                case Near: {
                    titleRect = new StiRectangle(0.0, 0.0, titleSize.width, titleSize.height);
                    break;
                }
                case Center: {
                    titleRect = new StiRectangle((axisRect.width - titleSize.width) / 2.0, 0.0, titleSize.width, titleSize.height);
                    break;
                }
                case Far: {
                    titleRect = new StiRectangle(axisRect.width - titleSize.width, 0.0, titleSize.width, titleSize.height);
                }
            }
        }
        if (this.getIsBottomSide()) {
            switch (this.getAxis().getTitle().getAlignment()) {
                case Near: {
                    titleRect = new StiRectangle(0.0, axisRect.height - titleSize.height, titleSize.width, titleSize.height);
                    break;
                }
                case Center: {
                    titleRect = new StiRectangle((axisRect.width - titleSize.width) / 2.0, axisRect.height - titleSize.height, titleSize.width, titleSize.height);
                    break;
                }
                case Far: {
                    titleRect = new StiRectangle(axisRect.width - titleSize.width, axisRect.height - titleSize.height, titleSize.width, titleSize.height);
                }
            }
        }
        float angle = 0.0f;
        switch (this.getAxis().getTitle().getDirection()) {
            case LeftToRight: {
                angle = 0.0f;
                break;
            }
            case RightToLeft: {
                angle = 180.0f;
                break;
            }
            case BottomToTop: {
                angle = -90.0f;
                break;
            }
            case TopToBottom: {
                angle = 90.0f;
            }
        }
        StiAxisTitleGeom titleGeom = new StiAxisTitleGeom(this.getAxis(), titleRect, angle, this.getAxis().getTitle().getAlignment());
        geom.CreateChildGeoms();
        geom.getChildGeoms().add(titleGeom);
    }

    private boolean IsArgumentDateTime(List<StiStripPositionXF> positions) {
        for (StiStripPositionXF position : positions) {
            if (!(position.StripLine.getValueObject() instanceof Date)) continue;
            return true;
        }
        return false;
    }

    private boolean IsArgumentDateTime2(List<StiAxisLabelInfoXF> infos) {
        for (StiAxisLabelInfoXF info : infos) {
            if (!(info.StripLine.getValueObject() instanceof Date)) continue;
            return true;
        }
        return false;
    }

    static String getMeasureText(StiContext context, String text, StiFont font, double maxWidth) {
        for (int index = 0; text.length() > index; ++index) {
            String currentText = text.substring(0, index);
            StiFontGeom stiFontGeom = new StiFontGeom(font);
            if (!(maxWidth < context.MeasureString((String)currentText, (StiFontGeom)stiFontGeom).width)) continue;
            if (currentText.length() > 4) {
                return currentText.substring(0, currentText.length() - 3) + "...";
            }
            if (currentText.length() <= 1) continue;
            return currentText.substring(0, 1) + "...";
        }
        return text;
    }

    private List<StiAxisLabelInfoXF> measureAxisLabelInfos(StiRectangle rect, float angle, int start, int end, StiContext context, double labelsWidth, StiRotationMode rotation, boolean wordWrap, StiRefObject<Double> maxLabelWidth) {
        ArrayList<StiAxisLabelInfoXF> infos1 = new ArrayList<StiAxisLabelInfoXF>();
        maxLabelWidth.argvalue = 0.0;
        IStiContextPainter contextClone = context.getContextPainter().clone();
        StiStringFormatGeom sf = this.GetStringFormatGeom(context, wordWrap);
        StiFontGeom font = this.GetFontGeom(context);
        StiMarkerAlignment alignment = this.GetTextAlignment();
        StiRotationMode rotationMode = StiRotationMode.CenterCenter;
        StiPoint point = StiPoint.getEmpty();
        rotationMode = rotation != null ? rotation : (this.getIsTopSide() ? (angle == 0.0f ? StiRotationMode.CenterBottom : (this.getAxis().getLabels().getTextAlignment() == StiMarkerAlignment.Center ? StiRotationMode.CenterCenter : StiRotationMode.LeftCenter)) : (angle == 0.0f ? StiRotationMode.CenterTop : (this.getAxis().getLabels().getTextAlignment() == StiMarkerAlignment.Center ? StiRotationMode.CenterCenter : StiRotationMode.RightCenter)));
        boolean sideFlag = this.getAxis().getArea().getReverseVert() ? this.getIsBottomSide() : this.getIsTopSide();
        for (int index = start; index < end && index < this.getAxis().getInfo().LabelsCollection.size(); ++index) {
            if (sideFlag && this.getAxis().getArea().getYRightAxis().getArrowStyle() != StiArrowStyle.None && index == 0) {
                infos1.add(new StiAxisLabelInfoXF());
                ++index;
                continue;
            }
            if (sideFlag && this.getAxis().getArea().getYAxis().getArrowStyle() != StiArrowStyle.None && index == this.getAxis().getInfo().StripLines.size() - 1) {
                infos1.add(new StiAxisLabelInfoXF());
                ++index;
                continue;
            }
            StiStripPositionXF label = this.getAxis().getInfo().LabelsCollection.get(index);
            String text = this.GetLabelText(label.StripLine, null);
            if (!wordWrap && labelsWidth > 0.0) {
                text = StiXAxisCoreXF.getMeasureText(context, text, this.getAxis().getLabels().getFont(), labelsWidth);
            }
            double posX = label.Position;
            point = this.getIsTopSide() ? new StiPoint(posX, rect.height - (this.GetTicksMaxLength(context) + this.GetLabelsSpaceAxis(context))) : new StiPoint(posX, this.GetTicksMaxLength(context) + this.GetLabelsSpaceAxis(context));
            if (this.getAxis().getLabels().getPlacement() != StiLabelsPlacement.None) {
                if (this.getAxis().getLabels().getPlacement() == StiLabelsPlacement.TwoLines && (index & 1) != 0) {
                    if (this.getIsTopSide()) {
                        point.y -= this.GetLabelsTwoLinesDestination(context);
                    }
                    if (this.getIsBottomSide()) {
                        point.y += this.GetLabelsTwoLinesDestination(context);
                    }
                }
                StiRectangle textRectF = contextClone.measureRotatedString(text, font, point, sf, rotationMode, (double)angle, (int)(labelsWidth * context.Options.zoom), false);
                StiPoint textPoint = StiPoint.getEmpty();
                if (rotationMode == StiRotationMode.CenterCenter) {
                    point.y = this.getIsTopSide() ? point.y - textRectF.height / 2.0 : point.y + textRectF.height / 2.0;
                }
                StiAxisLabelInfoXF info = new StiAxisLabelInfoXF();
                info.Angle = angle;
                info.Width = (float)labelsWidth;
                info.WordWrap = wordWrap;
                info.clientRectangle = StiRectangle.round((StiRectangle)textRectF);
                info.RotationMode = rotationMode;
                info.TextPoint = point;
                info.Text = text;
                info.StripLine = label.StripLine;
                infos1.add(info);
                if (!this.getIsLabelsAngleByWidth()) continue;
                maxLabelWidth.argvalue = Math.max((Double)maxLabelWidth.argvalue, textRectF.width);
                continue;
            }
            infos1.add(new StiAxisLabelInfoXF());
        }
        return infos1;
    }

    private List<StiAxisLabelInfoXF> measureAxisLabelInfos(StiRectangle rect, int start, int end, StiContext context) {
        ArrayList<StiAxisLabelInfoXF> infos1 = new ArrayList<StiAxisLabelInfoXF>();
        IStiContextPainter contextClone = context.getContextPainter().clone();
        StiStringFormatGeom sf = this.GetStringFormatGeom(context, this.getAxis().getLabels().getWordWrap());
        StiFontGeom font = this.GetFontGeom(context);
        StiRotationMode rotationMode = StiRotationMode.CenterCenter;
        float angle = -this.getAxis().getLabels().getAngle();
        StiPoint point = StiPoint.getEmpty();
        rotationMode = this.getIsTopSide() ? StiRotationMode.CenterBottom : StiRotationMode.CenterTop;
        boolean sideFlag = this.getAxis().getArea().getReverseVert() ? this.getIsBottomSide() : this.getIsTopSide();
        for (int index = start; index < end && index < this.getAxis().getInfo().LabelsCollection.size(); ++index) {
            if (sideFlag && this.getAxis().getArea().getYRightAxis().getArrowStyle() != StiArrowStyle.None && index == 0) {
                infos1.add(new StiAxisLabelInfoXF());
                ++index;
                continue;
            }
            if (sideFlag && this.getAxis().getArea().getYAxis().getArrowStyle() != StiArrowStyle.None && index == this.getAxis().getInfo().StripLines.size() - 1) {
                infos1.add(new StiAxisLabelInfoXF());
                ++index;
                continue;
            }
            StiStripPositionXF label = this.getAxis().getInfo().LabelsCollection.get(index);
            String text = this.GetLabelText(label.StripLine, null);
            double posX = label.Position;
            point = this.getIsTopSide() ? new StiPoint(posX, rect.height - (this.GetTicksMaxLength(context) + this.GetLabelsSpaceAxis(context))) : new StiPoint(posX, this.GetTicksMaxLength(context) + this.GetLabelsSpaceAxis(context));
            if (this.getAxis().getLabels().getPlacement() != StiLabelsPlacement.None) {
                StiRectangle textRectF = contextClone.measureRotatedString(text, font, point, sf, rotationMode, (double)angle, (int)((double)this.getAxis().getLabels().getWidth() * context.Options.zoom), false);
                StiAxisLabelInfoXF info = new StiAxisLabelInfoXF();
                info.Angle = angle;
                info.clientRectangle = StiRectangle.round((StiRectangle)textRectF);
                info.RotationMode = rotationMode;
                info.TextPoint = point;
                info.Text = text;
                info.StripLine = label.StripLine;
                infos1.add(info);
                continue;
            }
            infos1.add(new StiAxisLabelInfoXF());
        }
        return infos1;
    }

    private boolean checkAutoAngleLabels(StiContext context, StiRectangle rect) {
        if (this.getAxis().getLabels().getPlacement() != StiLabelsPlacement.AutoRotation) {
            return false;
        }
        List<Object> infos = new ArrayList();
        if (this.getAxis().getInfo().LabelsCollection != null && this.getAxis().getLabels().getPlacement() != StiLabelsPlacement.None) {
            infos = this.measureAxisLabelInfos(rect, 0, this.getAxis().getInfo().LabelsCollection.size(), context);
            for (int index = 1; index < infos.size(); ++index) {
                StiRectangle rect1 = ((StiAxisLabelInfoXF)infos.get((int)(index - 1))).clientRectangle;
                StiRectangle rect2 = ((StiAxisLabelInfoXF)infos.get((int)index)).clientRectangle;
                StiRectangle rectIntersect = StiRectangle.intersect((StiRectangle)rect1, (StiRectangle)rect2);
                if (!(rectIntersect.width > 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract StiXAxisDock getDock();

    public final boolean getIsTopSide() {
        return this.getDock() == StiXAxisDock.Top && !this.getAxis().getArea().getReverseVert() || this.getDock() == StiXAxisDock.Bottom && this.getAxis().getArea().getReverseVert();
    }

    public final boolean getIsBottomSide() {
        return this.getDock() == StiXAxisDock.Bottom && !this.getAxis().getArea().getReverseVert() || this.getDock() == StiXAxisDock.Top && this.getAxis().getArea().getReverseVert();
    }

    public StiXAxisCoreXF(IStiAxis axis) {
        super(axis);
    }
}

