/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area.scatter;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.chart.core.area.clusteredColumn.StiClusteredColumnAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineCalculatorXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLinesXF;
import com.stimulsoft.report.chart.enums.StiChartAreaPosition;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterSeries;
import java.util.ArrayList;
import java.util.Date;

public class StiScatterAreaCoreXF
extends StiClusteredColumnAreaCoreXF {
    private boolean isArgumentDateTime = false;

    private boolean IsXAxisAutoRange(IStiAxis xAxis) {
        IStiArea tempVar = this.getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        return xAxis.getRange().getAuto() || axisArea.getXAxis().getRange().getMaximum() == axisArea.getXAxis().getRange().getMinimum() || xAxis.getLogarithmicScale();
    }

    @Override
    protected void PrepareRange(IStiAxis specXAxis, IStiAxis specXTopAxis, IStiAxis specYAxis, IStiAxis specYRightAxis) {
        super.PrepareRange(specXAxis, specXTopAxis, specYAxis, specYRightAxis);
        boolean first = true;
        specXAxis.getInfo().Maximum = 0.0;
        specXAxis.getInfo().Minimum = 0.0;
        this.isArgumentDateTime = false;
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        for (IStiSeries series1 : seriesCollection) {
            Object tempVar;
            String st;
            IStiScatterSeries series = (IStiScatterSeries)series1;
            if (series.getArguments().length > 0 && series.getArguments()[0] instanceof String && ((st = (String)((tempVar = series.getArguments()[0]) instanceof String ? tempVar : null)).endsWith("AM") || st.endsWith("PM"))) {
                for (int index = 0; index < series.getArguments().length; ++index) {
                    Object tempVar2 = series.getArguments()[index];
                    series.getArguments()[index] = new Date(Date.parse(String.format((String)(tempVar2 instanceof String ? tempVar2 : null), new Object[0])));
                }
            }
            for (Object argument : series.getArguments()) {
                double value = 0.0;
                if (argument instanceof Date) {
                    this.isArgumentDateTime = true;
                    value = ((Date)argument).getDate();
                } else {
                    try {
                        value = Func.Convert.toDouble(argument);
                    }
                    catch (Exception e2) {
                        value = 0.0;
                    }
                }
                if (first) {
                    first = false;
                    specXAxis.getInfo().Maximum = value;
                    specXAxis.getInfo().Minimum = value;
                    continue;
                }
                specXAxis.getInfo().Maximum = Math.max(specXAxis.getInfo().Maximum, value);
                specXAxis.getInfo().Minimum = Math.min(specXAxis.getInfo().Minimum, value);
            }
        }
    }

    @Override
    protected void CheckStripLinesAndMaximumMinimumXAxis(IStiAxis axis) {
        if (axis.getInfo().StripLines.size() > 0) {
            axis.getInfo().Minimum = ((StiStripLineXF)axis.getInfo().StripLines.get(0)).getValue();
            axis.getInfo().Maximum = ((StiStripLineXF)axis.getInfo().StripLines.get(axis.getInfo().StripLines.size() - 1)).getValue();
        } else {
            axis.getInfo().Minimum = 0.0;
            axis.getInfo().Maximum = 1.0;
        }
    }

    @Override
    protected void CreateStripLinesXAxis(IStiAxis axis) {
        double step;
        if (!this.isArgumentDateTime && !axis.getLogarithmicScale() && this.IsXAxisAutoRange(axis)) {
            double range = Math.abs(axis.getInfo().Maximum - axis.getInfo().Minimum);
            if (range != 0.0) {
                axis.getInfo().Maximum += range * 0.05;
                axis.getInfo().Minimum -= range * 0.05;
            } else {
                axis.getInfo().Maximum *= 1.05;
                axis.getInfo().Minimum = axis.getInfo().Minimum < 0.0 ? (axis.getInfo().Minimum *= 1.05) : (axis.getInfo().Minimum *= 0.95);
            }
            if (axis.getCore().GetStartFromZero()) {
                axis.getInfo().Minimum = 0.0;
            }
            if (axis.getInfo().Minimum == axis.getInfo().Maximum) {
                if (axis.getInfo().Maximum == 0.0) {
                    axis.getInfo().Maximum = 100.0;
                } else {
                    axis.getInfo().Minimum -= axis.getInfo().Minimum * 0.1;
                    axis.getInfo().Maximum -= axis.getInfo().Maximum * 0.1;
                }
            }
        }
        boolean isDateTimeValues = false;
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        for (int index = 0; index < seriesCollection.size(); ++index) {
            if (!seriesCollection.get(index).getCore().getIsDateTimeValues()) continue;
            isDateTimeValues = true;
            break;
        }
        if ((step = axis.getLabels().getStep()) == 0.0) {
            step = StiStripLineCalculatorXF.GetInterval(axis.getInfo().Minimum, axis.getInfo().Maximum, 6);
        }
        StiStripLinesXF xStripLines = axis.getLogarithmicScale() ? StiStripLineCalculatorXF.GetStripLinesLogScale(axis.getInfo().Minimum, axis.getInfo().Maximum) : StiStripLineCalculatorXF.GetStripLines(axis.getInfo().Minimum, axis.getInfo().Maximum, step, isDateTimeValues);
        axis.getInfo().StripLines.clear();
        for (int id = xStripLines.size() - 1; id >= 0; --id) {
            double value = ((StiStripLineXF)xStripLines.get(id)).getValue();
            Object valueObject = ((StiStripLineXF)xStripLines.get(id)).getValueObject();
            if (this.isArgumentDateTime) {
                valueObject = new Date((long)value);
            }
            axis.getInfo().StripLines.add(new StiStripLineXF(valueObject, value));
        }
    }

    @Override
    protected void CreateStripLinesYAxis(IStiAxis axis, boolean isDateTimeValues) {
        if (this.getArea().getIsDefaultSeriesTypeFullStackedColumnSeries() || this.getArea().getIsDefaultSeriesTypeFullStackedBarSeries()) {
            boolean positivePresent = false;
            boolean negativePresent = false;
            ArrayList<IStiSeries> seriesCollection = this.GetSeries();
            for (IStiSeries series : seriesCollection) {
                for (Double value : series.getValues()) {
                    if (value > 0.0) {
                        positivePresent = true;
                    }
                    if (!(value < 0.0)) continue;
                    negativePresent = true;
                }
            }
            double minimum = negativePresent ? -100.0 : 0.0;
            double maximum = positivePresent ? 100.0 : 0.0;
            double step = axis.getLabels().getStep();
            if (step == 0.0) {
                step = StiStripLineCalculatorXF.GetInterval(minimum, maximum, 6);
            }
            axis.getInfo().StripLines = StiStripLineCalculatorXF.GetStripLines(minimum, maximum, step, false);
            for (StiStripLineXF stripLine : axis.getInfo().StripLines) {
                stripLine.setValueObject(String.format("%1$s%%", stripLine.getValueObject()));
            }
        } else {
            double step = axis.getLabels().getStep();
            if (step > 0.0 && axis.getInfo().getRange() > 0.0 && axis.getInfo().getRange() / step > 500.0) {
                step = 0.0;
            }
            if (step == 0.0) {
                step = StiStripLineCalculatorXF.GetInterval(axis.getInfo().Minimum, axis.getInfo().Maximum, 6);
            }
            axis.getInfo().StripLines = axis.getLogarithmicScale() ? StiStripLineCalculatorXF.GetStripLinesLogScale(axis.getInfo().Minimum, axis.getInfo().Maximum) : StiStripLineCalculatorXF.GetStripLines(axis.getInfo().Minimum, axis.getInfo().Maximum, step, isDateTimeValues);
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Scatter");
    }

    @Override
    public int getPosition() {
        return StiChartAreaPosition.Scatter.getValue();
    }

    public StiScatterAreaCoreXF(IStiArea area) {
        super(area);
    }
}

