/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.area.clusteredColumn;

import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.enums.StiChartAreaPosition;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import java.util.ArrayList;

public class StiClusteredColumnAreaCoreXF
extends StiAxisAreaCoreXF {
    @Override
    protected void PrepareRange(IStiAxis specXAxis, IStiAxis specXTopAxis, IStiAxis specYAxis, IStiAxis specYRightAxis) {
        boolean firstLeft = true;
        boolean firstRight = true;
        boolean seriesLeftAxisY = false;
        boolean seriesRightAxisY = false;
        specYAxis.getInfo().Maximum = 0.0;
        specYAxis.getInfo().Minimum = 0.0;
        specYRightAxis.getInfo().Maximum = 0.0;
        specYRightAxis.getInfo().Minimum = 0.0;
        ArrayList<IStiSeries> seriesCollection = this.GetSeries();
        for (int index = 0; index < seriesCollection.size(); ++index) {
            Double[] values;
            IStiSeries series = seriesCollection.get(index);
            for (Double value : values = series.getValues()) {
                if (series.getYAxis() == StiSeriesYAxis.LeftYAxis) {
                    if (value == null) continue;
                    if (firstLeft) {
                        seriesLeftAxisY = true;
                        specYAxis.getInfo().Maximum = value;
                        specYAxis.getInfo().Minimum = value;
                        firstLeft = false;
                        continue;
                    }
                    seriesLeftAxisY = true;
                    specYAxis.getInfo().Maximum = Math.max(value, specYAxis.getInfo().Maximum);
                    specYAxis.getInfo().Minimum = Math.min(value, specYAxis.getInfo().Minimum);
                    continue;
                }
                if (value == null) continue;
                if (firstRight) {
                    seriesRightAxisY = true;
                    specYRightAxis.getInfo().Maximum = value;
                    specYRightAxis.getInfo().Minimum = value;
                    firstRight = false;
                    continue;
                }
                seriesRightAxisY = true;
                specYRightAxis.getInfo().Maximum = Math.max(value, specYRightAxis.getInfo().Maximum);
                specYRightAxis.getInfo().Minimum = Math.min(value, specYRightAxis.getInfo().Minimum);
            }
        }
        if (!seriesLeftAxisY) {
            specYAxis.getInfo().Maximum = specYRightAxis.getInfo().Maximum;
            specYAxis.getInfo().Minimum = specYRightAxis.getInfo().Minimum;
        }
        if (!seriesRightAxisY) {
            specYRightAxis.getInfo().Maximum = specYAxis.getInfo().Maximum;
            specYRightAxis.getInfo().Minimum = specYAxis.getInfo().Minimum;
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"ClusteredColumn");
    }

    @Override
    public int getPosition() {
        return StiChartAreaPosition.ClusteredColumn.getValue();
    }

    public StiClusteredColumnAreaCoreXF(IStiArea area) {
        super(area);
    }
}

