/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.system.StiDateTime;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiSeriesPoint;
import com.stimulsoft.report.chart.StiSeriesPointCollection;
import com.stimulsoft.report.chart.StiSimplifyHelper;
import com.stimulsoft.report.chart.enums.StiSeriesSortDirection;
import com.stimulsoft.report.chart.enums.StiSeriesSortType;
import com.stimulsoft.report.chart.enums.StiTimeDateStep;
import com.stimulsoft.report.chart.enums.StiTopNMode;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxisDateTimeStep;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.bubble.IStiBubbleSeries;
import com.stimulsoft.report.chart.interfaces.series.clusteredColumn.IStiBaseLineSeries;
import com.stimulsoft.report.chart.interfaces.series.radar.IStiRadarSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiRangeSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedColumn.IStiStackedBaseLineSeries;
import com.stimulsoft.report.chart.interfaces.topN.IStiSeriesTopN;
import com.stimulsoft.report.chart.view.areas.StiAxisArea;
import com.stimulsoft.report.chart.view.axis.StiXAxis;
import com.stimulsoft.report.chart.view.events.StiGetTitleEventArgs;
import com.stimulsoft.report.chart.view.events.StiNewAutoSeriesEventArgs;
import com.stimulsoft.report.chart.view.filter.StiChartFilter;
import com.stimulsoft.report.chart.view.filter.StiDataItem;
import com.stimulsoft.report.chart.view.filter.StiDataItemComparer;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.chart.view.series.bubble.StiBubbleSeries;
import com.stimulsoft.report.chart.view.series.candlestick.StiCandlestickSeries;
import com.stimulsoft.report.chart.view.series.clusteredBar.StiClusteredBarSeries;
import com.stimulsoft.report.chart.view.series.gantt.StiGanttSeries;
import com.stimulsoft.report.chart.view.series.pie.StiPieSeries;
import com.stimulsoft.report.chart.view.series.range.StiRangeBarSeries;
import com.stimulsoft.report.chart.view.series.range.StiRangeSeries;
import com.stimulsoft.report.chart.view.series.range.StiSplineRangeSeries;
import com.stimulsoft.report.chart.view.series.range.StiSteppedRangeSeries;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiFilterDataType;
import com.stimulsoft.report.components.enums.StiFilterItem;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.interfaces.IStiInvokeGetListOfValuesEnd;
import com.stimulsoft.report.interfaces.IStiInvokeGetValueEnd;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class StiChartHelper {
    public static Integer GlobalDurationElement = 1000;
    public static Integer GlobalBeginTimeElement = 1000;

    public static void FillSeriesData(StiSeries series, ArrayList items) {
        series.setValues(new Double[items.size()]);
        series.setArguments(new Object[items.size()]);
        for (int index = 0; index < items.size(); ++index) {
            StiDataItem item = items.get(index) instanceof StiDataItem ? items.get(index) : null;
            series.getValues()[index] = item.Value instanceof Double ? item.getValue() : 0.0;
            series.getArguments()[index] = item.Argument;
        }
    }

    public static Object GetFilterData(StiReport report, StiChartFilter filter, String filterMethodName) {
        if (filter.getItem() == StiFilterItem.Expression) {
            StiText tempTxt = new StiText();
            tempTxt.setName("*Chart_Filter*");
            tempTxt.setPage(report.getPages().get(0));
            return StiParser.ParseTextValue("{" + filter.getValue() + "}", (StiComponent)tempTxt);
        }
        switch (filter.getDataType()) {
            case String: {
                return filter.getValue();
            }
            case Numeric: {
                return Double.parseDouble(filter.getValue().replace(",", "."));
            }
            case DateTime: {
                try {
                    return new Date(Date.parse(filter.getValue()));
                }
                catch (Exception e) {
                    return new Date();
                }
            }
            case Boolean: {
                return filter.getValue().toLowerCase().equals("true");
            }
        }
        return null;
    }

    public static boolean GetFilterResult(StiChartFilter filter, Object itemArgument, Object itemValue, Object itemValueEnd, Object itemValueOpen, Object itemValueClose, Object itemValueLow, Object itemValueHigh, Object data) {
        boolean result;
        block32: {
            if (filter.getItem() == StiFilterItem.Expression) {
                return (Boolean)data;
            }
            Object itemData = null;
            if (filter.getItem() == StiFilterItem.Argument) {
                itemData = itemArgument;
            } else if (filter.getItem() == StiFilterItem.Value) {
                itemData = itemValue;
            } else if (filter.getItem() == StiFilterItem.ValueEnd) {
                itemData = itemValueEnd;
            } else if (filter.getItem() == StiFilterItem.ValueOpen) {
                itemData = itemValueOpen;
            } else if (filter.getItem() == StiFilterItem.ValueClose) {
                itemData = itemValueClose;
            } else if (filter.getItem() == StiFilterItem.ValueLow) {
                itemData = itemValueLow;
            } else if (filter.getItem() == StiFilterItem.ValueHigh) {
                itemData = itemValueHigh;
            }
            result = false;
            if (itemData != null) {
                Comparable comparable;
                if (filter.getDataType() == StiFilterDataType.Numeric) {
                    itemData = Double.parseDouble(itemData.toString());
                }
                if ((comparable = (Comparable)(itemData instanceof Comparable ? itemData : null)) != null && data != null) {
                    if (itemData.getClass() != data.getClass()) {
                        itemData = itemData.toString();
                        data = data.toString();
                        comparable = (Comparable)(itemData instanceof Comparable ? itemData : null);
                    }
                    try {
                        switch (filter.getCondition()) {
                            case EqualTo: {
                                return comparable.compareTo(data) == 0;
                            }
                            case NotEqualTo: {
                                return comparable.compareTo(data) != 0;
                            }
                            case GreaterThan: {
                                return comparable.compareTo(data) == 1;
                            }
                            case GreaterThanOrEqualTo: {
                                return comparable.compareTo(data) >= 0;
                            }
                            case LessThan: {
                                return comparable.compareTo(data) == -1;
                            }
                            case LessThanOrEqualTo: {
                                return comparable.compareTo(data) <= 0;
                            }
                            case Containing: {
                                String str1 = itemData.toString();
                                String str2 = data.toString();
                                return str1.indexOf(str2) != -1;
                            }
                            case NotContaining: {
                                String str3 = itemData.toString();
                                String str4 = data.toString();
                                return str3.indexOf(str4) == -1;
                            }
                            case BeginningWith: {
                                String str5 = itemData.toString();
                                String str6 = data.toString();
                                return str5.startsWith(str6);
                            }
                            case EndingWith: {
                                String str7 = itemData.toString();
                                String str8 = data.toString();
                                return str7.endsWith(str8);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (StiOptions.Engine.logLevel <= 10) break block32;
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static StiImage GetImageFromChart(StiChart masterChart) {
        StiImage imageComp = new StiImage();
        imageComp.setLeft(masterChart.getLeft());
        imageComp.setTop(masterChart.getTop());
        imageComp.setWidth(masterChart.getWidth());
        imageComp.setHeight(masterChart.getHeight());
        imageComp.setPage(masterChart.getPage());
        imageComp.setSmoothing(false);
        imageComp.setStretch(true);
        imageComp.setName(masterChart.getName());
        StiRectangle rect = masterChart.getPaintRectangle();
        rect.setX(0.0);
        rect.setY(0.0);
        double zoom = StiOptions.Engine.getRenderChartAsBitmapZoom();
        StiRefObject tempRef_zoom = new StiRefObject((Object)zoom);
        zoom = (Double)tempRef_zoom.argvalue;
        return imageComp;
    }

    public static Object ConvertStringToColor(String colorStr) {
        StiColor color = null;
        if (colorStr != null) {
            String[] rgb;
            colorStr = colorStr.trim();
            char separator = ',';
            for (int index = 0; index < colorStr.length(); ++index) {
                if (Character.isDigit(colorStr.charAt(index)) || Character.isWhitespace(colorStr.charAt(index))) continue;
                separator = colorStr.charAt(index);
                break;
            }
            if ((rgb = colorStr.split(String.valueOf(separator))).length == 3 || rgb.length == 4) {
                try {
                    if (rgb.length == 3) {
                        color = StiColor.fromArgb((int)Integer.parseInt(rgb[0].trim()), (int)Integer.parseInt(rgb[1].trim()), (int)Integer.parseInt(rgb[2].trim()));
                    }
                    color = StiColor.fromArgb((int)Integer.parseInt(rgb[0].trim()), (int)Integer.parseInt(rgb[1].trim()), (int)Integer.parseInt(rgb[2].trim()), (int)Integer.parseInt(rgb[3].trim()));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                try {
                    boolean isNumber = StiValidationUtil.isNumber((Object)colorStr);
                    if (isNumber) {
                        int result = Integer.valueOf(colorStr);
                        StiColor color2 = StiColor.FromArgb((int)result);
                        if (result < 0xFFFFFF) {
                            color2 = StiColor.FromArgb((int)255, (StiColor)color2);
                        }
                        return color2;
                    }
                    return StiColorEnum.valueOf((String)colorStr).color();
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException(e2);
                }
            }
        }
        return color;
    }

    public static void CreateChart(StiChart masterChart, StiChart chartComp) {
        HashMap<StiSeries, String> seriesToColor = new HashMap<StiSeries, String>();
        boolean applyStyle = false;
        for (int seriesIndex = 0; seriesIndex < chartComp.getSeries().size(); ++seriesIndex) {
            StiSeries series;
            block87: {
                ArrayList<StiDataItem> items;
                block88: {
                    ArrayList<String> argumentKeys;
                    HashMap<StiDataItem, String> itemToArgument;
                    String[] autoSeriesKeys;
                    StiBubbleSeries bubbleSeries;
                    block90: {
                        block89: {
                            StiPieSeries pieSeries;
                            IStiSeries tempVar8;
                            IStiSeries tempVar7;
                            StiCandlestickSeries candlestickSeries;
                            IStiSeries tempVar6;
                            StiSplineRangeSeries splineRangeSeries;
                            IStiSeries tempVar5;
                            StiRangeBarSeries rangeBarSeries;
                            IStiSeries tempVar4;
                            StiSteppedRangeSeries steppedRangeSeries;
                            IStiSeries tempVar3;
                            StiRangeSeries rangSeries;
                            series = (StiSeries)chartComp.getSeries().get(seriesIndex);
                            StiChartHelper.SetTitle(masterChart, seriesIndex, series);
                            series.setValues(StiChartHelper.GetValues(masterChart, series));
                            IStiSeries tempVar2 = (IStiSeries)chartComp.getSeries().get(seriesIndex);
                            StiGanttSeries ganttSeries = (StiGanttSeries)(tempVar2 instanceof StiGanttSeries ? tempVar2 : null);
                            if (ganttSeries != null) {
                                ganttSeries.setValuesEnd(StiChartHelper.GetValuesEnd(masterChart, ganttSeries, ganttSeries.getValueDataColumnEnd(), ganttSeries, ganttSeries));
                            }
                            if ((rangSeries = (StiRangeSeries)((tempVar3 = (IStiSeries)chartComp.getSeries().get(seriesIndex)) instanceof StiRangeSeries ? tempVar3 : null)) != null) {
                                rangSeries.setValuesEnd(StiChartHelper.GetValuesEnd(masterChart, rangSeries, rangSeries.getValueDataColumnEnd(), rangSeries, rangSeries));
                            }
                            if ((steppedRangeSeries = (StiSteppedRangeSeries)((tempVar4 = chartComp.getSeries().getItem(seriesIndex)) instanceof StiSteppedRangeSeries ? tempVar4 : null)) != null) {
                                steppedRangeSeries.setValuesEnd(StiChartHelper.GetValuesEnd(masterChart, steppedRangeSeries, steppedRangeSeries.getValueDataColumnEnd(), steppedRangeSeries, steppedRangeSeries));
                            }
                            if ((rangeBarSeries = (StiRangeBarSeries)((tempVar5 = chartComp.getSeries().getItem(seriesIndex)) instanceof StiRangeBarSeries ? tempVar5 : null)) != null) {
                                rangeBarSeries.setValuesEnd(StiChartHelper.GetValuesEnd(masterChart, rangeBarSeries, rangeBarSeries.getValueDataColumnEnd(), rangeBarSeries, rangeBarSeries));
                            }
                            if ((splineRangeSeries = (StiSplineRangeSeries)((tempVar6 = chartComp.getSeries().getItem(seriesIndex)) instanceof StiSplineRangeSeries ? tempVar6 : null)) != null) {
                                splineRangeSeries.setValuesEnd(StiChartHelper.GetValuesEnd(masterChart, rangeBarSeries, splineRangeSeries.getValueDataColumnEnd(), splineRangeSeries, splineRangeSeries));
                            }
                            if ((candlestickSeries = (StiCandlestickSeries)((tempVar7 = chartComp.getSeries().getItem(seriesIndex)) instanceof StiCandlestickSeries ? tempVar7 : null)) != null) {
                                candlestickSeries.setValuesHigh(StiChartHelper.GetValuesHigh(masterChart, candlestickSeries));
                                candlestickSeries.setValuesLow(StiChartHelper.GetValuesLow(masterChart, candlestickSeries));
                                candlestickSeries.setValuesClose(StiChartHelper.GetValuesClose(masterChart, candlestickSeries));
                                candlestickSeries.setValuesOpen(StiChartHelper.GetValuesOpen(masterChart, candlestickSeries));
                            }
                            if ((bubbleSeries = (StiBubbleSeries)((tempVar8 = chartComp.getSeries().getItem(seriesIndex)) instanceof StiBubbleSeries ? tempVar8 : null)) != null) {
                                bubbleSeries.setWeights(StiChartHelper.GetWeights(masterChart, bubbleSeries));
                            }
                            if ((pieSeries = (StiPieSeries)(series instanceof StiPieSeries ? series : null)) != null) {
                                StiChartHelper.SetCutPieList(masterChart, pieSeries);
                            }
                            series.setArguments(StiChartHelper.GetArguments(masterChart, series));
                            series.setTags(StiChartHelper.GetTags(masterChart, series));
                            series.setHyperlinks(StiChartHelper.GetHyperlinks(masterChart, series));
                            series.setToolTips(StiChartHelper.GetToolTips(masterChart, series));
                            autoSeriesKeys = StiChartHelper.GetAutoSeriesKeysFromAutoSeriesKeyDataColumn(masterChart, series);
                            String[] autoSeriesTitles = StiChartHelper.GetAutoSeriesTitleFromAutoSeriesTitleDataColumn(masterChart, series);
                            String[] autoSeriesColors = StiChartHelper.GetAutoSeriesColorFromAutoSeriesColorDataColumn(masterChart, series);
                            if (series.getSortBy() == StiSeriesSortType.None && series.getFilters().size() <= 0 && autoSeriesKeys.length <= 0) break block87;
                            int count = series.getValues().length > series.getArguments().length ? series.getValues().length : series.getArguments().length;
                            items = new ArrayList<StiDataItem>();
                            for (int index = 0; index < count; ++index) {
                                Double value = series.getValues().length > index ? series.getValues()[index] : 0.0;
                                Iterator argument = series.getArguments().length > index ? series.getArguments()[index] : null;
                                String key = autoSeriesKeys.length > index ? autoSeriesKeys[index] : null;
                                String title = autoSeriesTitles.length > index ? autoSeriesTitles[index] : null;
                                String color = autoSeriesColors.length > index ? autoSeriesColors[index] : null;
                                Integer tag = series.getTags().length > index ? series.getTags()[index] : Integer.valueOf(0);
                                Double valueEnd = null;
                                if (series instanceof IStiRangeSeries) {
                                    valueEnd = ((IStiRangeSeries)((Object)series)).getValuesEnd().length > index ? ((IStiRangeSeries)((Object)series)).getValuesEnd()[index] : 0.0;
                                }
                                Integer weight = null;
                                if (bubbleSeries != null) {
                                    weight = bubbleSeries.getWeights().size() > index ? (Number)bubbleSeries.getWeights().get(index) : (Number)0;
                                }
                                String toolTip = series.getToolTips().length > index ? series.getToolTips()[index] : "";
                                items.add(new StiDataItem(argument, value, valueEnd, weight, title, key, color, toolTip, tag));
                            }
                            if (series.getSortBy() != StiSeriesSortType.None) {
                                StiDataItemComparer comparer = new StiDataItemComparer(series.getSortBy(), series.getSortDirection());
                                Collections.sort(items, comparer);
                            }
                            HashMap<StiChartFilter, Object> filterToValue = new HashMap<StiChartFilter, Object>();
                            int filterIndex = 0;
                            for (StiChartFilter filter : series.getFilters()) {
                                String filterMethodName = String.format("%1$sFilters_%2$s_%3$s", chartComp.getName(), seriesIndex, filterIndex);
                                filterToValue.put(filter, StiChartHelper.GetFilterData(chartComp.getReport(), filter, filterMethodName));
                                ++filterIndex;
                            }
                            ArrayList<StiDataItem> filteredItems = new ArrayList<StiDataItem>();
                            StiDataSource filterSource = null;
                            StiBusinessObject filterBusinessObject = null;
                            if (series.getFilters().size() > 0) {
                                try {
                                    filterSource = StiDataColumn.GetDataSourceFromDataColumn(chartComp.getReport().getDictionary(), series.getValueDataColumn());
                                }
                                catch (Exception color) {
                                    // empty catch block
                                }
                                if (filterSource == null) {
                                    try {
                                        filterSource = StiDataColumn.GetDataSourceFromDataColumn(chartComp.getReport().getDictionary(), series.getArgumentDataColumn());
                                    }
                                    catch (Exception color) {
                                        // empty catch block
                                    }
                                }
                                if (filterSource == null) {
                                    filterSource = chartComp.getDataSource();
                                }
                                try {
                                    filterBusinessObject = StiDataColumn.GetBusinessObjectFromDataColumn(chartComp.getReport().getDictionary(), series.getValueDataColumn());
                                }
                                catch (Exception color) {
                                    // empty catch block
                                }
                                if (filterBusinessObject == null) {
                                    try {
                                        filterBusinessObject = StiDataColumn.GetBusinessObjectFromDataColumn(chartComp.getReport().getDictionary(), series.getArgumentDataColumn());
                                    }
                                    catch (Exception color) {
                                        // empty catch block
                                    }
                                }
                                if (filterBusinessObject == null) {
                                    filterBusinessObject = chartComp.getBusinessObject();
                                }
                            }
                            if (filterSource != null) {
                                filterSource.saveState("ChartFilter");
                                filterSource.First();
                            }
                            if (filterBusinessObject != null) {
                                filterBusinessObject.SaveState("ChartFilter");
                                filterBusinessObject.CreateEnumerator();
                            }
                            for (StiDataItem item : items) {
                                boolean[] results = new boolean[series.getFilters().size()];
                                int index = 0;
                                for (Object filter : series.getFilters()) {
                                    results[index] = StiChartHelper.GetFilterResult((StiChartFilter)filter, item.Argument, item.Value, item.ValueEnd, item.ValueOpen, item.ValueClose, item.ValueLow, item.ValueHigh, filterToValue.get(filter));
                                    if (((StiChartFilter)filter).getItem() == StiFilterItem.Expression) {
                                        String filterMethodName = String.format("%1$sFilters_%2$s_%3$s", chartComp.getName(), seriesIndex, index);
                                        try {
                                            results[index] = (Boolean)StiChartHelper.GetFilterData(chartComp.getReport(), (StiChartFilter)filter, filterMethodName);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    ++index;
                                }
                                boolean result2 = true;
                                if (series.getFilterMode() == StiFilterMode.And) {
                                    for (Object rs : (Object)results) {
                                        if (rs != false) continue;
                                        result2 = false;
                                        break;
                                    }
                                } else {
                                    result2 = false;
                                    for (Object rs : (Object)results) {
                                        if (rs == false) continue;
                                        result2 = true;
                                        break;
                                    }
                                }
                                if (result2) {
                                    filteredItems.add(item);
                                }
                                if (filterSource != null) {
                                    filterSource.Next();
                                }
                                if (filterBusinessObject == null) continue;
                                filterBusinessObject.next();
                            }
                            if (filterSource != null) {
                                filterSource.RestoreState("ChartFilter");
                            }
                            if (filterBusinessObject != null) {
                                filterBusinessObject.RestoreState("ChartFilter");
                            }
                            items = filteredItems;
                            if (autoSeriesKeys.length <= 0) break block88;
                            itemToArgument = new HashMap<StiDataItem, String>();
                            argumentKeys = null;
                            if (series.getArgumentDataColumn() == null || series.getArgumentDataColumn().length() <= 0) break block89;
                            ArrayList<Object> arrayArgumentKeys = new ArrayList<Object>();
                            for (StiDataItem item : items) {
                                Object argument = item.Argument;
                                if (arrayArgumentKeys.contains(argument)) continue;
                                arrayArgumentKeys.add(argument);
                            }
                            argumentKeys = (ArrayList<String>)arrayArgumentKeys.clone();
                            if (series.getSortBy() != StiSeriesSortType.Argument) break block90;
                            Collections.sort(argumentKeys);
                            if (series.getSortDirection() != StiSeriesSortDirection.Descending) break block90;
                            Collections.reverse(argumentKeys);
                            break block90;
                        }
                        HashMap lenghtOfItemsPerKey = new HashMap();
                        for (StiDataItem item : items) {
                            ArrayList<StiDataItem> list;
                            ArrayList<StiDataItem> arrayList = list = lenghtOfItemsPerKey.get(item.Key) instanceof ArrayList ? (ArrayList<StiDataItem>)lenghtOfItemsPerKey.get(item.Key) : null;
                            if (list == null) {
                                list = new ArrayList<StiDataItem>();
                                lenghtOfItemsPerKey.put(item.Key, list);
                            }
                            list.add(item);
                        }
                        int maxValue = 0;
                        for (ArrayList value : lenghtOfItemsPerKey.values()) {
                            maxValue = Math.max(maxValue, value.size());
                            int index = 0;
                            for (StiDataItem item : value) {
                                itemToArgument.put(item, new Integer(index).toString());
                                ++index;
                            }
                        }
                        argumentKeys = new ArrayList<String>();
                        for (int index = 0; index < maxValue; ++index) {
                            argumentKeys.add(new Integer(index).toString());
                        }
                    }
                    HashSet<String> hashKeys = new HashSet<String>();
                    for (String key : autoSeriesKeys) {
                        hashKeys.add(key);
                    }
                    ArrayList keys = new ArrayList(hashKeys);
                    Collections.sort(keys);
                    ArrayList[][] itemsArray = new ArrayList[argumentKeys.size()][keys.size()];
                    HashMap argumentToIndex = new HashMap();
                    for (int index = 0; index < argumentKeys.size(); ++index) {
                        argumentToIndex.put(argumentKeys.get(index), index);
                    }
                    HashMap keyToIndex = new HashMap();
                    for (int index = 0; index < keys.size(); ++index) {
                        keyToIndex.put(keys.get(index), index);
                    }
                    HashMap<Object, Object> keyToTitle = new HashMap<Object, Object>();
                    HashMap<Object, Object> keyToColor = new HashMap<Object, Object>();
                    for (StiDataItem item : items) {
                        Object argument = item.Argument;
                        if (series.getArguments() == null || series.getArguments().length == 0) {
                            argument = itemToArgument.get(item);
                        }
                        int indexKey = (Integer)keyToIndex.get(item.Key);
                        int indexArgument = (Integer)argumentToIndex.get(argument);
                        if (item.Title != null) {
                            keyToTitle.put(item.Key, item.Title);
                        } else {
                            keyToTitle.put(item.Key, item.Key);
                        }
                        keyToColor.put(item.Key, item.Color);
                        if (itemsArray[indexArgument][indexKey] != null) {
                            itemsArray[indexArgument][indexKey].add(item);
                            continue;
                        }
                        ArrayList<StiDataItem> list = new ArrayList<StiDataItem>();
                        list.add(item);
                        itemsArray[indexArgument][indexKey] = list;
                    }
                    StiBubbleSeries newBubbleSeries = null;
                    if (bubbleSeries != null) {
                        IStiBubbleSeries tempVar9 = bubbleSeries.clone();
                        newBubbleSeries = (StiBubbleSeries)(tempVar9 instanceof StiBubbleSeries ? tempVar9 : null);
                    }
                    for (int index = 0; index < keys.size(); ++index) {
                        String key = (String)keys.get(index);
                        StiSeries newSeries = null;
                        if (index == 0) {
                            newSeries = series;
                        } else {
                            IStiSeries tempVar10 = series.clone();
                            newSeries = (StiSeries)(tempVar10 instanceof StiSeries ? tempVar10 : null);
                            chartComp.getSeries().add(seriesIndex + index, newSeries);
                        }
                        newSeries.setCoreTitle(keyToTitle.get(key) instanceof String ? keyToTitle.get(key) : null);
                        String color = keyToColor.get(key) instanceof String ? keyToColor.get(key) : null;
                        seriesToColor.put(newSeries, color);
                        ArrayList<Double> values = new ArrayList<Double>();
                        ArrayList<Double> valuesEnd = new ArrayList<Double>();
                        ArrayList arguments = new ArrayList();
                        ArrayList<Double> weights = new ArrayList<Double>();
                        ArrayList<String> toolTips = new ArrayList<String>();
                        ArrayList<Object> tags = new ArrayList<Object>();
                        for (int argumentIndex = 0; argumentIndex < argumentKeys.size(); ++argumentIndex) {
                            ArrayList list = itemsArray[argumentIndex][index];
                            if (list == null) {
                                if (newSeries instanceof IStiScatterSeries) continue;
                                values.add(null);
                                weights.add(0.0);
                                toolTips.add(null);
                                tags.add(null);
                                if (newSeries instanceof IStiRangeSeries) {
                                    valuesEnd.add(null);
                                }
                                arguments.add(argumentKeys.get(argumentIndex));
                                continue;
                            }
                            for (int i = 0; i < list.size(); ++i) {
                                StiDataItem dataItem = (StiDataItem)list.get(i);
                                Double value = null;
                                boolean isNullArgument = newSeries instanceof IStiScatterSeries;
                                if (dataItem != null && dataItem.Value instanceof Double) {
                                    value = (Double)dataItem.Value;
                                    isNullArgument = false;
                                }
                                if (newSeries instanceof IStiScatterSeries && argumentKeys.get(argumentIndex) == null) continue;
                                values.add(value);
                                if (!isNullArgument) {
                                    arguments.add(argumentKeys.get(argumentIndex));
                                }
                                if (newSeries instanceof IStiRangeSeries) {
                                    valuesEnd.add((Double)dataItem.ValueEnd);
                                }
                                if (newBubbleSeries != null) {
                                    weights.add((Double)dataItem.Weight);
                                }
                                if (dataItem.ToolTip != null) {
                                    toolTips.add(dataItem.ToolTip.toString());
                                }
                                if (dataItem.Tag == null) continue;
                                tags.add(dataItem.Tag);
                            }
                        }
                        newSeries.setValues(values.toArray(new Double[0]));
                        newSeries.setArguments(arguments.toArray(new Object[0]));
                        if (newSeries instanceof IStiRangeSeries) {
                            ((IStiRangeSeries)((Object)newSeries)).setValuesEnd(valuesEnd.toArray(new Double[0]));
                        }
                        if (newSeries instanceof StiBubbleSeries) {
                            ((StiBubbleSeries)newSeries).setWeights(weights);
                        }
                        newSeries.setToolTips(toolTips.toArray(new String[0]));
                        newSeries.setTags(tags.toArray(new Object[0]));
                        StiChartHelper.checkArgumentsDateTimeStep(newSeries);
                        StiChartHelper.createValuesTopN(newSeries);
                        newSeries.setFilters(series.getFilters());
                        applyStyle = true;
                    }
                    seriesIndex += keys.size() - 1;
                    break block87;
                }
                StiChartHelper.FillSeriesData(series, items);
            }
            Object[] objects = series.getArguments();
            if (series.getChart().getArea() instanceof StiAxisArea) {
                StiTimeDateStep step = ((StiAxisArea)series.getChart().getArea()).getXAxis().getDateTimeStep().getStep();
                int countValues = ((StiAxisArea)series.getChart().getArea()).getXAxis().getDateTimeStep().getNumberOfValues();
                if (StiChartHelper.IsArgumentsDateTime(objects) && step != StiTimeDateStep.None) {
                    ArrayList<Object> arguments = new ArrayList<Object>(Arrays.asList(objects));
                    Collections.sort(arguments);
                    ZonedDateTime dateMin = (ZonedDateTime)arguments.get(0);
                    ZonedDateTime dateMax = (ZonedDateTime)arguments.get(arguments.size() - 1);
                    int totalStep = StiChartHelper.getTotalTimeSpans(step, dateMax, dateMin) * countValues + 1;
                    ArrayList<ZonedDateTime> listArguments = new ArrayList<ZonedDateTime>();
                    ArrayList<Double> listValues = new ArrayList<Double>();
                    StiTimeSpan span = StiChartHelper.GetDateStep(step);
                    long ticks = span.getTicks() / (long)countValues;
                    StiTimeSpan newSpan = new StiTimeSpan(ticks);
                    StiTimeSpan halfNewSpan = new StiTimeSpan(ticks / 2L);
                    boolean first = true;
                    for (int index = 0; index < totalStep; ++index) {
                        boolean addValue = false;
                        if (first) {
                            listArguments.add(dateMin);
                            addValue = true;
                            first = false;
                        } else {
                            Instant inst = Instant.ofEpochMilli(((ZonedDateTime)listArguments.get(listArguments.size() - 1)).toInstant().toEpochMilli() + newSpan.getTicks());
                            ZonedDateTime arg = ZonedDateTime.ofInstant(inst, ZoneId.systemDefault());
                            if (arg.compareTo(dateMax) <= 0) {
                                listArguments.add(arg);
                                addValue = true;
                            }
                        }
                        if (!addValue) continue;
                        Instant inst = Instant.ofEpochMilli(((ZonedDateTime)listArguments.get(index)).toInstant().toEpochMilli() - halfNewSpan.getTicks());
                        ZonedDateTime firstDate = ZonedDateTime.ofInstant(inst, ZoneId.systemDefault());
                        inst = Instant.ofEpochMilli(((ZonedDateTime)listArguments.get(index)).toInstant().toEpochMilli() + halfNewSpan.getTicks());
                        ZonedDateTime secondDate = ZonedDateTime.ofInstant(inst, ZoneId.systemDefault());
                        Double val = StiChartHelper.GetValueForDate(firstDate, secondDate, arguments, series.getValues());
                        listValues.add(val);
                    }
                    ArrayList newArguments = (ArrayList)listArguments.clone();
                    ArrayList newValues = (ArrayList)listValues.clone();
                    int firstIndexRealValue = 0;
                    int lastIndexRealValue = 0;
                    Double firstValue = null;
                    Double lastValue = null;
                    for (int index = 0; index < newValues.size(); ++index) {
                        if (newValues.get(index) != null && firstValue == null) {
                            firstIndexRealValue = index;
                            firstValue = (Double)newValues.get(index);
                            continue;
                        }
                        if (newValues.get(index) == null || firstValue == null) continue;
                        lastIndexRealValue = index;
                        firstValue = (Double)newValues.get(firstIndexRealValue);
                        lastValue = (Double)newValues.get(lastIndexRealValue);
                        double stepRealValue = ((firstValue == null ? 0.0 : firstValue) - (lastValue == null ? 0.0 : lastValue)) / (double)(lastIndexRealValue - firstIndexRealValue);
                        for (int indexRealValue = firstIndexRealValue + 1; indexRealValue < lastIndexRealValue; ++indexRealValue) {
                            newValues.set(indexRealValue, (Double)newValues.get(indexRealValue - 1) - stepRealValue);
                        }
                        firstIndexRealValue = 0;
                        lastIndexRealValue = 0;
                        firstValue = null;
                        lastValue = null;
                        --index;
                    }
                    series.setArguments(newArguments.toArray());
                    series.setValues(newValues.toArray(new Double[0]));
                }
            }
            if (series.getTopN().getMode() == StiTopNMode.None || series.getValues().length <= series.getTopN().getCount()) continue;
            StiChartHelper.topNMode(series);
        }
        if (StiOptions.Engine.isAllowSimplifyChartValues()) {
            chartComp.simplifyValues();
        }
        if (StiOptions.Engine.getAllowInvokeProcessChartEventForTemplateOfChart()) {
            chartComp.invokeEvents();
        }
        if (applyStyle && StiOptions.Engine.getApplyStylesInAutoSeries()) {
            chartComp.getSeries().applyStyle(chartComp.getStyle());
            int index = 0;
            for (IStiSeries iSeries : chartComp.getSeries()) {
                StiSeries series = (StiSeries)iSeries;
                Object color = StiChartHelper.ConvertStringToColor(seriesToColor.get(series) instanceof String ? seriesToColor.get(series) : null);
                StiNewAutoSeriesEventArgs arg = new StiNewAutoSeriesEventArgs(index, series, null);
                if (color != null) {
                    arg.setColor(color);
                }
                series.InvokeNewAutoSeries(arg);
                if (arg.getColor() instanceof StiColor) {
                    series.getCore().ApplyStyle(chartComp.getStyle(), (StiColor)arg.getColor());
                }
                ++index;
            }
        }
    }

    public static List<StiPoint> getShorterListPoints(StiSeries series) {
        StiPoint[] points = new StiPoint[series.getValues().length];
        for (int index = 0; index < series.getValues().length; ++index) {
            points[index] = new StiPoint(series.getValues()[index].doubleValue(), (double)index);
        }
        double[] deltaArray = new double[]{0.3, 0.6, 1.0, 5.0, 9.0, 15.0, 20.0, 25.0, 30.0, 40.0};
        List<StiPoint> shorterListPoints = null;
        List<StiPoint> prevShorterListPoints = null;
        for (int index = 0; index < deltaArray.length; ++index) {
            shorterListPoints = StiSimplifyHelper.simplify(points, deltaArray[index], true);
            if ((double)shorterListPoints.size() / (double)points.length < 0.02 && shorterListPoints.size() < 900 && prevShorterListPoints != null) {
                shorterListPoints = prevShorterListPoints;
                break;
            }
            prevShorterListPoints = shorterListPoints;
        }
        return shorterListPoints;
    }

    private static void topNMode(StiSeries series) {
        IStiSeriesTopN topN = series.getTopN();
        StiSeriesPointCollection seriesPoints = StiSeriesPointCollection.create(series);
        if (topN.getMode() == StiTopNMode.Bottom) {
            seriesPoints.sortByValues();
        } else if (topN.getMode() == StiTopNMode.Top) {
            seriesPoints.sortByValuesReverse();
        }
        int count = topN.getCount();
        StiSeriesPointCollection result = seriesPoints.subList(0, count);
        if (topN.getShowOthers()) {
            double otherValue = seriesPoints.getSummValue(count, seriesPoints.size());
            StiSeriesPoint otherSeriesPoint = new StiSeriesPoint(seriesPoints.size() + 1, otherValue, topN.getOthersText());
            result.add(otherSeriesPoint);
        }
        result.sortByIndex();
        result.setValuesAndArgumentsInSeries(series);
    }

    private static Double GetValueForDate(ZonedDateTime dateStart, ZonedDateTime dateEnd, ArrayList<ZonedDateTime> arguments, Double[] values) {
        int count = 0;
        double sum = 0.0;
        Double valueForDate = null;
        for (int index = 0; index < arguments.size(); ++index) {
            ZonedDateTime currentDate = arguments.get(index);
            if (currentDate.compareTo(dateStart) <= 0 || currentDate.compareTo(dateEnd) > 0) continue;
            ++count;
            sum += values[index] == null ? 0.0 : values[index];
        }
        if (count != 0) {
            valueForDate = sum / (double)count;
        }
        return valueForDate;
    }

    private static StiTimeSpan GetDateStep(StiTimeDateStep step) {
        StiTimeSpan span = new StiTimeSpan();
        switch (step) {
            case Day: {
                span = new StiTimeSpan(1, 0, 0, 0);
                break;
            }
            case Hour: {
                span = new StiTimeSpan(1, 0, 0);
                break;
            }
            case Minute: {
                span = new StiTimeSpan(0, 1, 0);
                break;
            }
            case Month: {
                span = new StiTimeSpan(30, 0, 0, 0);
                break;
            }
            case Second: {
                span = new StiTimeSpan(0, 0, 0, 1);
                break;
            }
            case Year: {
                span = new StiTimeSpan(365, 0, 0, 0);
            }
        }
        return span;
    }

    private static int getTotalTimeSpans(StiTimeDateStep step, ZonedDateTime dateMax, ZonedDateTime dateMin) {
        double total;
        StiTimeSpan span = StiTimeSpan.fromInterval((ZonedDateTime)dateMin, (ZonedDateTime)dateMax);
        switch (step) {
            case Day: {
                total = span.getTotalDays();
                break;
            }
            case Hour: {
                total = span.getTotalHours();
                break;
            }
            case Minute: {
                total = span.getTotalMinutes();
                break;
            }
            case Month: {
                total = span.getTotalMonth();
                break;
            }
            case Second: {
                total = span.getTotalSeconds();
                break;
            }
            case Year: {
                total = span.getTotalYear();
                break;
            }
            default: {
                total = 0.0;
            }
        }
        return (int)Math.ceil(total);
    }

    private static boolean IsArgumentsDateTime(Object[] arguments) {
        for (Object argument : arguments) {
            if (argument != null && argument instanceof Calendar) continue;
            return false;
        }
        return true;
    }

    private static String[] GetAutoSeriesColorFromAutoSeriesColorDataColumn(StiChart masterChart, StiSeries series) {
        if (series.getAutoSeriesColorDataColumn() != null && series.getAutoSeriesColorDataColumn().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getAutoSeriesColorDataColumn());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                String[] autoSeriesColors = new String[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object valueObject = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getAutoSeriesColorDataColumn());
                    valueObject = valueObject == null ? "" : valueObject.toString();
                    autoSeriesColors[posIndex] = (String)(valueObject instanceof String ? valueObject : null);
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return autoSeriesColors;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getAutoSeriesColorDataColumn());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                String[] autoSeriesColors = new String[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object valueObject = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getAutoSeriesColorDataColumn());
                    valueObject = valueObject == null ? "" : valueObject.toString();
                    autoSeriesColors[posIndex] = (String)(valueObject instanceof String ? valueObject : null);
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return autoSeriesColors;
            }
        }
        return new String[0];
    }

    private static String[] GetAutoSeriesTitleFromAutoSeriesTitleDataColumn(StiChart masterChart, StiSeries series) {
        if (series.getAutoSeriesTitleDataColumn() != null && series.getAutoSeriesTitleDataColumn().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getAutoSeriesTitleDataColumn());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                String[] autoSeriesTitles = new String[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object valueObject = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getAutoSeriesTitleDataColumn());
                    valueObject = valueObject == null ? "" : valueObject.toString();
                    autoSeriesTitles[posIndex] = (String)(valueObject instanceof String ? valueObject : null);
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return autoSeriesTitles;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getAutoSeriesTitleDataColumn());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                String[] autoSeriesTitles = new String[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object valueObject = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getAutoSeriesTitleDataColumn());
                    valueObject = valueObject == null ? "" : valueObject.toString();
                    autoSeriesTitles[posIndex] = (String)(valueObject instanceof String ? valueObject : null);
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return autoSeriesTitles;
            }
        }
        return new String[0];
    }

    private static String[] GetAutoSeriesKeysFromAutoSeriesKeyDataColumn(StiChart masterChart, StiSeries series) {
        if (series.getAutoSeriesKeyDataColumn() != null && series.getAutoSeriesKeyDataColumn().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getAutoSeriesKeyDataColumn());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                String[] autoSeriesKeys = new String[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object valueObject = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getAutoSeriesKeyDataColumn());
                    valueObject = valueObject == null ? "" : valueObject.toString();
                    autoSeriesKeys[posIndex] = (String)(valueObject instanceof String ? valueObject : null);
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return autoSeriesKeys;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getAutoSeriesKeyDataColumn());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                String[] autoSeriesKeys = new String[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object valueObject = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getAutoSeriesKeyDataColumn());
                    valueObject = valueObject == null ? "" : valueObject.toString();
                    autoSeriesKeys[posIndex] = (String)(valueObject instanceof String ? valueObject : null);
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return autoSeriesKeys;
            }
        }
        return new String[0];
    }

    private static void SetTitle(StiChart masterChart, int seriesIndex, StiSeries series) {
        StiGetTitleEventArgs eTitle = new StiGetTitleEventArgs();
        eTitle.setSeries(series);
        eTitle.setIndex(seriesIndex);
        series.InvokeGetTitle(masterChart, eTitle);
        if (eTitle.getValue() != null && eTitle.getValue().length() > 0) {
            series.setCoreTitle(eTitle.getValue());
        }
    }

    private static void SetCutPieList(StiChart masterChart, StiPieSeries series) {
        StiGetValueEventArgs ep = new StiGetValueEventArgs();
        series.InvokeGetCutPieList(masterChart, ep);
        if (ep.getValue() != null && ep.getValue().length() > 0) {
            series.setCutPieListValues(StiSeries.GetValuesFromString(ep.getValue()));
        }
    }

    private static Object[] GetArguments(StiChart masterChart, StiSeries series) {
        Object[] arguments = StiChartHelper.GetArgumentsFromListOfArguments(masterChart, series);
        if (arguments != null) {
            return arguments;
        }
        arguments = StiChartHelper.GetArgumentsFromArgumentDataColumn(masterChart, series);
        if (arguments != null) {
            return arguments;
        }
        arguments = StiChartHelper.GetArgumentsFromArgumentExpression(masterChart, series);
        if (arguments != null) {
            return arguments;
        }
        return new Object[0];
    }

    private static Object[] GetArgumentsFromArgumentExpression(StiChart masterChart, StiSeries series) {
        Object[] arguments = new Object[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiValueEventArgs ee = new StiValueEventArgs();
            series.InvokeGetArgument(masterChart, ee);
            arguments[posIndex] = ee.getValue();
            masterChart.Next();
        }
        return arguments;
    }

    private static Object[] GetArgumentsFromArgumentDataColumn(StiChart masterChart, StiSeries series) {
        if (series.getArgumentDataColumn() != null && series.getArgumentDataColumn().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getArgumentDataColumn());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                Object[] arguments = new Object[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    arguments[posIndex] = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getArgumentDataColumn());
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return arguments;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getArgumentDataColumn());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                Object[] arguments = new Object[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    arguments[posIndex] = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getArgumentDataColumn());
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return arguments;
            }
        }
        return null;
    }

    private static Object[] GetArgumentsFromListOfArguments(StiChart masterChart, StiSeries series) {
        StiGetValueEventArgs e2 = new StiGetValueEventArgs();
        series.InvokeGetListOfArguments(masterChart, e2);
        if (e2.getValue() != null && e2.getValue().length() > 0) {
            return StiSeries.GetArgumentsFromString(e2.getValue());
        }
        return null;
    }

    private static Double[] GetValues(StiChart masterChart, StiSeries series) {
        Double[] values = StiChartHelper.GetValuesFromListOfValues(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesFromValueDataColumn(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesFromValueExpression(masterChart, series);
        if (values != null) {
            return values;
        }
        return new Double[0];
    }

    private static Double[] GetValuesFromValueExpression(StiChart masterChart, StiSeries series) {
        Double[] values = new Double[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiGetValueEventArgs ee = new StiGetValueEventArgs();
            ee.setValue("0");
            series.InvokeGetValue(masterChart, ee);
            values[posIndex] = Double.valueOf(ee != null && ee.getValue() != null ? ee.getValue().toString() : "0");
            masterChart.Next();
        }
        return values;
    }

    private static Double[] GetValuesFromValueDataColumn(StiChart masterChart, StiSeries series) {
        if (series.getValueDataColumn() != null && series.getValueDataColumn().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumn());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                Double[] values = new Double[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumn());
                    Double value = 0.0;
                    if (series instanceof IStiBaseLineSeries && !((IStiBaseLineSeries)((Object)series)).getShowNulls() || series instanceof IStiStackedBaseLineSeries && !((IStiStackedBaseLineSeries)((Object)series)).getShowNulls() || series instanceof IStiRadarSeries && !((IStiRadarSeries)((Object)series)).getShowNulls()) {
                        value = null;
                    }
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else if (data != null && data != DBNull.getValue()) {
                        try {
                            value = Double.valueOf(data.toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    values[posIndex] = value;
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumn());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                Double[] values = new Double[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getValueDataColumn());
                    Double value = null;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else if (data != null && data != DBNull.getValue()) {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static Double[] GetValuesFromListOfValues(StiChart masterChart, StiSeries series) {
        StiGetValueEventArgs e = new StiGetValueEventArgs();
        series.InvokeGetListOfValues(masterChart, e);
        if (e.getValue() != null && e.getValue().length() > 0) {
            return StiSeries.GetNullableValuesFromString(e.getValue());
        }
        return null;
    }

    private static Double[] GetValuesEnd(StiChart masterChart, StiSeries series, String valueDataColumnEnd, IStiInvokeGetListOfValuesEnd listValuesEnd, IStiInvokeGetValueEnd valuesEnd) {
        Double[] values = StiChartHelper.GetValuesEndFromListOfValuesEnd(masterChart, listValuesEnd);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesEndFromValueDataColumnEnd(masterChart, series, valueDataColumnEnd);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesEndFromValueEndExpression(masterChart, valuesEnd);
        if (values != null) {
            return values;
        }
        return new Double[0];
    }

    private static Double[] GetValuesEndFromValueEndExpression(StiChart masterChart, IStiInvokeGetValueEnd valuesEnd) {
        Double[] values = new Double[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiGetValueEventArgs eeg = new StiGetValueEventArgs();
            eeg.setValue("0");
            valuesEnd.InvokeGetValueEnd(masterChart, eeg);
            values[posIndex] = Double.valueOf(StiValidationUtil.isEmpty((String)eeg.getValue().toString()) ? "0" : eeg.getValue().toString());
            masterChart.Next();
        }
        return values;
    }

    private static Double[] GetValuesEndFromValueDataColumnEnd(StiChart masterChart, StiSeries series, String valueDataColumnEnd) {
        if (valueDataColumnEnd != null && valueDataColumnEnd.trim().length() > 0) {
            StiDataSource dataSourceGantt = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), valueDataColumnEnd);
            if (dataSourceGantt != null) {
                dataSourceGantt.saveState("ChartRender_DataColumn");
                Double[] values = new Double[dataSourceGantt.size()];
                dataSourceGantt.First();
                for (int posIndex = 0; posIndex < dataSourceGantt.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), valueDataColumnEnd);
                    Double value = null;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else if (data != null && data != DBNull.Value) {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    dataSourceGantt.Next();
                }
                dataSourceGantt.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObjectGantt = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), valueDataColumnEnd);
            if (businessObjectGantt != null) {
                businessObjectGantt.SaveState("ChartRender_DataColumn");
                Double[] values = new Double[businessObjectGantt.size()];
                businessObjectGantt.first();
                for (int posIndex = 0; posIndex < businessObjectGantt.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), valueDataColumnEnd);
                    Double value = null;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else if (data != null && data != DBNull.Value) {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    businessObjectGantt.next();
                }
                businessObjectGantt.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static Double[] GetValuesEndFromListOfValuesEnd(StiChart masterChart, IStiInvokeGetListOfValuesEnd listValues) {
        StiGetValueEventArgs eg = new StiGetValueEventArgs();
        listValues.InvokeGetListOfValuesEnd(masterChart, eg);
        if (eg.getValue() != null && eg.getValue().length() > 0) {
            return StiSeries.GetNullableValuesFromString(eg.getValue());
        }
        return null;
    }

    private static Double[] GetValuesOpen(StiChart masterChart, StiCandlestickSeries series) {
        Double[] values = StiChartHelper.GetValuesOpenFromListOfValuesOpen(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesOpenFromValueDataColumnOpen(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesOpenFromValuesOpenExpression(masterChart, series);
        if (values != null) {
            return values;
        }
        return new Double[0];
    }

    private static Double[] GetValuesOpenFromValuesOpenExpression(StiChart masterChart, StiCandlestickSeries series) {
        Double[] values = new Double[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiGetValueEventArgs eeg = new StiGetValueEventArgs();
            eeg.setValue("0");
            series.InvokeGetValueOpen(masterChart, eeg);
            values[posIndex] = Double.valueOf(eeg.getValue().toString());
            masterChart.Next();
        }
        return values;
    }

    private static Double[] GetValuesOpenFromValueDataColumnOpen(StiChart masterChart, StiCandlestickSeries series) {
        if (series.getValueDataColumnOpen() != null && series.getValueDataColumnOpen().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnOpen());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                Double[] values = new Double[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnOpen());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnOpen());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                Double[] values = new Double[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getValueDataColumnOpen());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static Double[] GetValuesOpenFromListOfValuesOpen(StiChart masterChart, StiCandlestickSeries series) {
        StiGetValueEventArgs eg = new StiGetValueEventArgs();
        series.InvokeGetListOfValuesOpen(masterChart, eg);
        if (eg.getValue() != null && eg.getValue().length() > 0) {
            return StiSeries.GetNullableValuesFromString(eg.getValue());
        }
        return null;
    }

    private static Double[] GetValuesClose(StiChart masterChart, StiCandlestickSeries series) {
        Double[] values = StiChartHelper.GetValuesCloseFromListOfValuesClose(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesCloseFromValueDataColumnClose(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesCloseFromValuesCloseExpression(masterChart, series);
        if (values != null) {
            return values;
        }
        return new Double[0];
    }

    private static Double[] GetValuesCloseFromValuesCloseExpression(StiChart masterChart, StiCandlestickSeries series) {
        Double[] values = new Double[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiGetValueEventArgs eeg = new StiGetValueEventArgs();
            eeg.setValue("0");
            series.InvokeGetValueClose(masterChart, eeg);
            values[posIndex] = Double.valueOf(eeg.getValue().toString());
            masterChart.Next();
        }
        return values;
    }

    private static Double[] GetValuesCloseFromValueDataColumnClose(StiChart masterChart, StiCandlestickSeries series) {
        if (series.getValueDataColumnClose() != null && series.getValueDataColumnClose().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnClose());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                Double[] values = new Double[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnClose());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnClose());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                Double[] values = new Double[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getValueDataColumnClose());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static Double[] GetValuesCloseFromListOfValuesClose(StiChart masterChart, StiCandlestickSeries series) {
        StiGetValueEventArgs eg = new StiGetValueEventArgs();
        series.InvokeGetListOfValuesClose(masterChart, eg);
        if (eg.getValue() != null && eg.getValue().length() > 0) {
            return StiSeries.GetNullableValuesFromString(eg.getValue());
        }
        return null;
    }

    private static Double[] GetValuesHigh(StiChart masterChart, StiCandlestickSeries series) {
        Double[] values = StiChartHelper.GetValuesHighFromListOfValuesHigh(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesHighFromValueDataColumnHigh(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesHighFromValuesHighExpression(masterChart, series);
        if (values != null) {
            return values;
        }
        return new Double[0];
    }

    private static Double[] GetValuesHighFromValuesHighExpression(StiChart masterChart, StiCandlestickSeries series) {
        Double[] values = new Double[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiGetValueEventArgs eeg = new StiGetValueEventArgs();
            eeg.setValue("0");
            series.InvokeGetValueHigh(masterChart, eeg);
            values[posIndex] = Double.valueOf(eeg.getValue().toString());
            masterChart.Next();
        }
        return values;
    }

    private static Double[] GetValuesHighFromValueDataColumnHigh(StiChart masterChart, StiCandlestickSeries series) {
        if (series.getValueDataColumnHigh() != null && series.getValueDataColumnHigh().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnHigh());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                Double[] values = new Double[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnHigh());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnHigh());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                Double[] values = new Double[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getValueDataColumnHigh());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static Double[] GetValuesHighFromListOfValuesHigh(StiChart masterChart, StiCandlestickSeries series) {
        StiGetValueEventArgs eg = new StiGetValueEventArgs();
        series.InvokeGetListOfValuesHigh(masterChart, eg);
        if (eg.getValue() != null && eg.getValue().length() > 0) {
            return StiSeries.GetNullableValuesFromString(eg.getValue());
        }
        return null;
    }

    private static Double[] GetValuesLow(StiChart masterChart, StiCandlestickSeries series) {
        Double[] values = StiChartHelper.GetValuesLowFromListOfValuesLow(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesLowFromValueDataColumnLow(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetValuesLowFromValuesLowExpression(masterChart, series);
        if (values != null) {
            return values;
        }
        return new Double[0];
    }

    private static Double[] GetValuesLowFromValuesLowExpression(StiChart masterChart, StiCandlestickSeries series) {
        Double[] values = new Double[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiGetValueEventArgs eeg = new StiGetValueEventArgs();
            eeg.setValue("0");
            series.InvokeGetValueLow(masterChart, eeg);
            values[posIndex] = Double.valueOf(eeg.getValue().toString());
            masterChart.Next();
        }
        return values;
    }

    private static Double[] GetValuesLowFromValueDataColumnLow(StiChart masterChart, StiCandlestickSeries series) {
        if (series.getValueDataColumnLow() != null && series.getValueDataColumnLow().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnLow());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                Double[] values = new Double[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnLow());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getValueDataColumnLow());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                Double[] values = new Double[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getValueDataColumnLow());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values[posIndex] = value;
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static Double[] GetValuesLowFromListOfValuesLow(StiChart masterChart, StiCandlestickSeries series) {
        StiGetValueEventArgs eg = new StiGetValueEventArgs();
        series.InvokeGetListOfValuesLow(masterChart, eg);
        if (eg.getValue() != null && eg.getValue().length() > 0) {
            return StiSeries.GetNullableValuesFromString(eg.getValue());
        }
        return null;
    }

    private static ArrayList<Double> GetWeights(StiChart masterChart, StiBubbleSeries series) {
        ArrayList<Double> values = StiChartHelper.GetWeightsFromListOfWeights(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetWeightsFromWeightDataColumn(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetWeightsWeightExpression(masterChart, series);
        if (values != null) {
            return values;
        }
        return new ArrayList<Double>();
    }

    private static ArrayList<Double> GetWeightsWeightExpression(StiChart masterChart, StiBubbleSeries series) {
        ArrayList<Double> values = new ArrayList<Double>(masterChart.getCount());
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiGetValueEventArgs eeg = new StiGetValueEventArgs();
            eeg.setValue("0");
            series.InvokeGetWeight(masterChart, eeg);
            values.set(posIndex, Double.valueOf(eeg.getValue()));
            masterChart.Next();
        }
        return values;
    }

    private static ArrayList<Double> GetWeightsFromWeightDataColumn(StiChart masterChart, StiBubbleSeries series) {
        if (series.getWeightDataColumn() != null && series.getWeightDataColumn().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getWeightDataColumn());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                ArrayList<Double> values = new ArrayList<Double>(dataSource.size());
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getWeightDataColumn());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values.set(posIndex, value);
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getWeightDataColumn());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                ArrayList<Double> values = new ArrayList<Double>(businessObject.size());
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getWeightDataColumn());
                    double value = 0.0;
                    if (data instanceof Date) {
                        series.getCore().setIsDateTimeValues(true);
                        value = ((Date)data).getDate();
                    } else {
                        value = Double.valueOf(data.toString());
                    }
                    values.set(posIndex, value);
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static ArrayList<Double> GetWeightsFromListOfWeights(StiChart masterChart, StiBubbleSeries series) {
        StiGetValueEventArgs eg = new StiGetValueEventArgs();
        series.InvokeGetListOfWeights(masterChart, eg);
        if (eg.getValue() != null && eg.getValue().length() > 0) {
            return StiSeries.GetValuesFromString(eg.getValue());
        }
        return null;
    }

    private static String[] GetHyperlinks(StiChart masterChart, StiSeries series) {
        String[] values = StiChartHelper.GetHyperlinksFromListOfHyperlinks(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetHyperlinksFromHyperlinkDataColumn(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetHyperlinksFromHyperlinkExpression(masterChart, series);
        if (values != null) {
            return values;
        }
        return new String[0];
    }

    private static String[] GetHyperlinksFromHyperlinkExpression(StiChart masterChart, StiSeries series) {
        String[] values = new String[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiValueEventArgs ee = new StiValueEventArgs();
            ee.setValue(null);
            series.InvokeGetHyperlink(masterChart, ee);
            if (ee.getValue() != null) {
                values[posIndex] = ee.getValue().toString();
            }
            masterChart.Next();
        }
        return values;
    }

    private static String[] GetHyperlinksFromHyperlinkDataColumn(StiChart masterChart, StiSeries series) {
        if (series.getHyperlinkDataColumn() != null && series.getHyperlinkDataColumn().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getHyperlinkDataColumn());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                String[] values = new String[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getHyperlinkDataColumn());
                    if (data != null) {
                        values[posIndex] = data.toString();
                    }
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getHyperlinkDataColumn());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                String[] values = new String[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getHyperlinkDataColumn());
                    if (data != null) {
                        values[posIndex] = data.toString();
                    }
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static String[] GetHyperlinksFromListOfHyperlinks(StiChart masterChart, StiSeries series) {
        StiGetValueEventArgs e = new StiGetValueEventArgs();
        series.InvokeGetListOfHyperlinks(masterChart, e);
        if (e.getValue() != null && e.getValue().length() > 0) {
            return StiSeries.GetStringsFromString(e.getValue());
        }
        return null;
    }

    private static Object[] GetTags(StiChart masterChart, StiSeries series) {
        Object[] values = StiChartHelper.GetTagsFromListOfTags(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetTagsFromTagDataColumn(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetTagsFromTagExpression(masterChart, series);
        if (values != null) {
            return values;
        }
        return new Object[0];
    }

    private static Object[] GetTagsFromTagExpression(StiChart masterChart, StiSeries series) {
        Object[] values = new Object[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiValueEventArgs ee = new StiValueEventArgs();
            ee.setValue(null);
            series.InvokeGetTag(masterChart, ee);
            values[posIndex] = ee.getValue();
            masterChart.Next();
        }
        return values;
    }

    private static Object[] GetTagsFromTagDataColumn(StiChart masterChart, StiSeries series) {
        if (series.getTagDataColumn() != null && series.getTagDataColumn().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getTagDataColumn());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                Object[] values = new Object[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object data;
                    values[posIndex] = data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getTagDataColumn());
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getTagDataColumn());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                Object[] values = new String[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object data;
                    values[posIndex] = data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getTagDataColumn());
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static Object[] GetTagsFromListOfTags(StiChart masterChart, StiSeries series) {
        StiGetValueEventArgs e = new StiGetValueEventArgs();
        series.InvokeGetListOfTags(masterChart, e);
        if (e.getValue() != null && e.getValue().length() > 0) {
            return StiSeries.GetStringsFromString(e.getValue());
        }
        return null;
    }

    private static String[] GetToolTips(StiChart masterChart, StiSeries series) {
        String[] values = StiChartHelper.GetToolTipsFromListOfToolTips(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetToolTipsFromToolTipDataColumn(masterChart, series);
        if (values != null) {
            return values;
        }
        values = StiChartHelper.GetToolTipsFromToolTipExpression(masterChart, series);
        if (values != null) {
            return values;
        }
        return new String[0];
    }

    private static String[] GetToolTipsFromToolTipExpression(StiChart masterChart, StiSeries series) {
        String[] values = new String[masterChart.getCount()];
        masterChart.First();
        for (int posIndex = 0; posIndex < masterChart.getCount(); ++posIndex) {
            StiValueEventArgs ee = new StiValueEventArgs();
            ee.setValue(null);
            series.InvokeGetToolTip(masterChart, ee);
            if (ee.getValue() != null) {
                values[posIndex] = ee.getValue().toString();
            }
            masterChart.Next();
        }
        return values;
    }

    private static String[] GetToolTipsFromToolTipDataColumn(StiChart masterChart, StiSeries series) {
        if (series.getToolTipDataColumn() != null && series.getToolTipDataColumn().trim().length() > 0) {
            StiDataSource dataSource = StiDataColumn.GetDataSourceFromDataColumn(masterChart.getReport().getDictionary(), series.getToolTipDataColumn());
            if (dataSource != null) {
                dataSource.saveState("ChartRender_DataColumn");
                String[] values = new String[dataSource.size()];
                dataSource.First();
                for (int posIndex = 0; posIndex < dataSource.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromDataColumn(masterChart.getReport().getDictionary(), series.getToolTipDataColumn());
                    if (data != null) {
                        values[posIndex] = data.toString();
                    }
                    dataSource.Next();
                }
                dataSource.RestoreState("ChartRender_DataColumn");
                return values;
            }
            StiBusinessObject businessObject = StiDataColumn.GetBusinessObjectFromDataColumn(masterChart.getReport().getDictionary(), series.getToolTipDataColumn());
            if (businessObject != null) {
                businessObject.SaveState("ChartRender_DataColumn");
                String[] values = new String[businessObject.size()];
                businessObject.first();
                for (int posIndex = 0; posIndex < businessObject.size(); ++posIndex) {
                    Object data = StiDataColumn.GetDataFromBusinessObject(masterChart.getReport().getDictionary(), series.getToolTipDataColumn());
                    if (data != null) {
                        values[posIndex] = data.toString();
                    }
                    businessObject.next();
                }
                businessObject.RestoreState("ChartRender_DataColumn");
                return values;
            }
        }
        return null;
    }

    private static String[] GetToolTipsFromListOfToolTips(StiChart masterChart, StiSeries series) {
        StiGetValueEventArgs e = new StiGetValueEventArgs();
        series.InvokeGetListOfToolTips(masterChart, e);
        if (e.getValue() != null && e.getValue().length() > 0) {
            return StiSeries.GetStringsFromString(e.getValue());
        }
        return null;
    }

    private static StiDateTime maximumDate(StiDateTime[] dates) {
        StiDateTime maxDate = StiDateTime.MinValue;
        for (int i = 0; i < dates.length; ++i) {
            StiDateTime date = dates[i];
            if (date.compareTo((Object)maxDate) <= 0) continue;
            maxDate = date;
        }
        return maxDate;
    }

    private static StiDateTime minimumDate(StiDateTime[] dates) {
        StiDateTime minDate = StiDateTime.MaxValue;
        for (int i = 0; i < dates.length; ++i) {
            StiDateTime date = dates[i];
            if (date.compareTo((Object)minDate) >= 0) continue;
            minDate = date;
        }
        return minDate;
    }

    private static double getTotalTimeSpans(StiTimeDateStep step, StiDateTime dateMax, StiDateTime dateMin) {
        long span = dateMax.getTicks() - dateMin.getTicks();
        double total = 0.0;
        switch (step) {
            case Second: {
                total = (int)(span / 1000L);
                break;
            }
            case Minute: {
                total = (int)(span / 1000L / 60L);
                break;
            }
            case Hour: {
                total = (int)(span / 1000L / 60L / 60L);
                break;
            }
            case Day: {
                total = (int)(span / 1000L / 60L / 60L / 24L);
                break;
            }
            case Month: {
                ZonedDateTime dateMinC = dateMin.getTicks() < dateMax.getTicks() ? dateMin.zonedDateTime() : dateMax.zonedDateTime();
                ZonedDateTime dateMaxC = dateMin.getTicks() > dateMax.getTicks() ? dateMin.zonedDateTime() : dateMax.zonedDateTime();
                int yearsInBetween = dateMaxC.getYear() - dateMinC.getYear();
                int monthsDiff = dateMaxC.getMonthValue() - dateMinC.getMonthValue();
                total = yearsInBetween * 12 + monthsDiff;
                break;
            }
            case Year: {
                ZonedDateTime dateMinC = dateMin.getTicks() < dateMax.getTicks() ? dateMin.zonedDateTime() : dateMax.zonedDateTime();
                ZonedDateTime dateMaxC = dateMin.getTicks() > dateMax.getTicks() ? dateMin.zonedDateTime() : dateMax.zonedDateTime();
                int yearsInBetween = dateMaxC.getYear() - dateMinC.getYear();
                total = yearsInBetween;
            }
        }
        return total;
    }

    private static StiDateTime getNextDate(StiDateTime firstDate, StiTimeDateStep step) {
        switch (step) {
            case Second: {
                return firstDate.addSeconds(1L);
            }
            case Minute: {
                return firstDate.addMinutes(1L);
            }
            case Day: {
                return firstDate.addDays(1L);
            }
            case Hour: {
                return firstDate.addHours(1L);
            }
            case Month: {
                return firstDate.addMonths(1);
            }
            case Year: {
                return firstDate.addYears(1);
            }
        }
        return firstDate;
    }

    private static void checkArgumentsDateTimeStep(StiSeries series) {
        Object[] objects = series.getArguments();
        if (!(series.getChart().getArea() instanceof StiAxisArea)) {
            return;
        }
        IStiAxisDateTimeStep dateTimeStep = ((StiXAxis)((StiAxisArea)series.getChart().getArea()).getXAxis()).getDateTimeStep();
        StiTimeDateStep step = dateTimeStep.getStep();
        int countValues = dateTimeStep.getNumberOfValues();
        if (StiChartHelper.IsArgumentsDateTime(objects) && step != StiTimeDateStep.None) {
            StiDateTime[] arguments = new StiDateTime[objects.length];
            for (int index = 0; index < objects.length; ++index) {
                arguments[index] = StiDateTime.Parse((String)objects[index].toString());
            }
            StiDateTime dateMax = StiChartHelper.maximumDate(arguments);
            StiDateTime dateMin = StiChartHelper.minimumDate(arguments);
            double totalStep = (int)StiChartHelper.getTotalTimeSpans(step, dateMax, dateMin) + 1;
            ArrayList<StiDateTime> listArguments = new ArrayList<StiDateTime>();
            ArrayList<Double> listValues = new ArrayList<Double>();
            StiDateTime firstDate = dateMin.clone();
            StiDateTime secondDate = StiChartHelper.getNextDate(dateMin, step);
            int index = 0;
            while ((double)index < totalStep) {
                double ticks = (secondDate.getTicks() - firstDate.getTicks()) / (long)countValues;
                StiTimeSpan halfNewSpan = new StiTimeSpan((long)(ticks / 2.0));
                for (long indexNumberOfValues = 0L; indexNumberOfValues < (long)countValues; ++indexNumberOfValues) {
                    StiTimeSpan arg = new StiTimeSpan((long)(ticks * (double)indexNumberOfValues));
                    if (arg.getTicks() > dateMax.getTicks()) continue;
                    listArguments.add(firstDate.addMilliseconds(arg.getTicks()));
                    Instant firstHalf = Instant.ofEpochMilli(((StiDateTime)listArguments.get(listArguments.size() - 1)).getTicks() - halfNewSpan.getTicks());
                    ZonedDateTime firstHalfDate = ZonedDateTime.ofInstant(firstHalf, ZoneId.systemDefault());
                    Instant secondHalf = Instant.ofEpochMilli(((StiDateTime)listArguments.get(listArguments.size() - 1)).getTicks() + halfNewSpan.getTicks());
                    ZonedDateTime secondHalfDate = ZonedDateTime.ofInstant(secondHalf, ZoneId.systemDefault());
                    ArrayList<ZonedDateTime> argumentsC = new ArrayList<ZonedDateTime>();
                    for (StiDateTime dt : arguments) {
                        argumentsC.add(dt.zonedDateTime());
                    }
                    Double val = StiChartHelper.GetValueForDate(firstHalfDate, secondHalfDate, argumentsC, series.getValues());
                    listValues.add(val);
                }
                firstDate = secondDate;
                secondDate = StiChartHelper.getNextDate(secondDate, step);
                ++index;
            }
            Object[] newArguments = listArguments.toArray(new Object[0]);
            Double[] newValues = listValues.toArray(new Double[0]);
            int firstIndexRealValue = 0;
            Double firstValue = null;
            for (int index2 = 0; index2 < newValues.length; ++index2) {
                if (newValues[index2] != null && firstValue == null) {
                    firstIndexRealValue = index2;
                    firstValue = newValues[index2];
                    continue;
                }
                if (newValues[index2] == null || firstValue == null) continue;
                int lastIndexRealValue = index2;
                firstValue = newValues[firstIndexRealValue];
                Double lastValue = newValues[lastIndexRealValue];
                double stepRealValue = ((firstValue == null ? 0.0 : firstValue) - (lastValue == null ? 0.0 : lastValue)) / (double)(lastIndexRealValue - firstIndexRealValue);
                for (int indexRealValue = firstIndexRealValue + 1; indexRealValue < lastIndexRealValue; ++indexRealValue) {
                    newValues[indexRealValue] = 0.0;
                }
                firstIndexRealValue = 0;
                firstValue = null;
                --index2;
            }
            series.setArguments(newArguments);
            series.setValues(newValues);
        }
    }

    private static void createValuesTopN(StiSeries series) {
        if (series.getTopN().getMode() == StiTopNMode.None || series.getValues().length <= series.getTopN().getCount()) {
            return;
        }
        int count = series.getTopN().getCount();
        double[] newValues = new double[series.getValues().length];
        System.arraycopy(series.getValues(), 0, newValues, 0, series.getValues().length);
        int[] newIndex = new int[series.getValues().length];
        for (int indexValues = 0; indexValues < series.getValues().length; ++indexValues) {
            newIndex[indexValues] = indexValues;
        }
        ArrayList<Double> listValues = new ArrayList<Double>();
        ArrayList<Object> listArguments = new ArrayList<Object>();
        Double otherValue = 0.0;
        for (int index = 0; index < series.getValues().length; ++index) {
            if (StiChartHelper.findIndex(newIndex, index)) {
                listValues.add(series.getValues()[index]);
                if (index >= series.getArguments().length) continue;
                listArguments.add(series.getArguments()[index]);
                continue;
            }
            otherValue = otherValue + series.getValues()[index];
        }
        if (series.getTopN().getShowOthers()) {
            if (series instanceof StiClusteredBarSeries) {
                listValues.add(0, otherValue);
                listArguments.add(0, series.getTopN().getOthersText());
            } else {
                listValues.add(otherValue);
                listArguments.add(series.getTopN().getOthersText());
            }
        }
        series.setValues(listValues.toArray(new Double[0]));
        series.setArguments(listArguments.toArray(new Object[0]));
    }

    private static boolean findIndex(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return true;
        }
        return false;
    }
}

