/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes.aztec;

import com.stimulsoft.base.utils.StiCharsetHelper;
import com.stimulsoft.report.barCodes.aztec.AztecCode;
import com.stimulsoft.report.barCodes.aztec.Encoder;
import com.stimulsoft.report.barCodes.aztec.StiAztecException;
import com.stimulsoft.report.barCodes.enums.StiAztecSize;

public class StiAztec {
    public static final int Default_EC_Percent = 33;
    public static final StiAztecSize Default_Aztec_Layers = StiAztecSize.Automatic;
    public static final int Default_Aztec_CodePage = 28591;

    public static AztecCode encode(String contents) throws StiAztecException {
        return StiAztec.encode(contents, 33, Default_Aztec_Layers, 28591, false);
    }

    public static AztecCode encode(String contents, int eccPercent, StiAztecSize layers, int codePage, boolean useEci) throws StiAztecException {
        eccPercent = Math.max(25, Math.min(eccPercent, 95));
        int eci = 0;
        if (useEci) {
            // empty if block
        }
        byte[] byteContent = contents.getBytes(StiCharsetHelper.findCharset((int)codePage));
        return Encoder.encode(byteContent, eci, eccPercent, layers);
    }
}

