/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes.aztec;

import com.stimulsoft.report.barCodes.BitMatrix;
import com.stimulsoft.report.barCodes.GaloisField;
import com.stimulsoft.report.barCodes.ReedSolomonEncoder;
import com.stimulsoft.report.barCodes.aztec.AztecCode;
import com.stimulsoft.report.barCodes.aztec.BitArray;
import com.stimulsoft.report.barCodes.aztec.HighLevelEncoder;
import com.stimulsoft.report.barCodes.aztec.StiAztec;
import com.stimulsoft.report.barCodes.aztec.StiAztecException;
import com.stimulsoft.report.barCodes.enums.StiAztecSize;

public class Encoder {
    private static final int MAX_NB_BITS = 32;
    private static final int MAX_NB_BITS_COMPACT = 4;
    private static final int[] WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    public static AztecCode encode(byte[] data, int eci, int minECCPercent, StiAztecSize userSpecifiedLayers) throws StiAztecException {
        int i;
        int matrixSize;
        BitArray stuffedBits;
        int wordSize;
        int totalBitsInLayer;
        int layers;
        boolean compact;
        BitArray bits = new HighLevelEncoder(data, eci).Encode();
        int eccBits = bits.size * minECCPercent / 100 + 11;
        int totalSizeBits = bits.size + eccBits;
        if (userSpecifiedLayers != StiAztec.Default_Aztec_Layers) {
            compact = userSpecifiedLayers.toString().indexOf("Compact") >= 0;
            layers = Math.abs(userSpecifiedLayers.intValue);
            if (layers > (compact ? 4 : 32)) {
                layers = compact ? 4 : 32;
            }
            totalBitsInLayer = Encoder.TotalBitsInLayer(layers, compact);
            wordSize = WORD_SIZE[layers];
            int usableBitsInLayers = totalBitsInLayer - totalBitsInLayer % wordSize;
            stuffedBits = Encoder.StuffBits(bits, wordSize);
            if (stuffedBits.size + eccBits > usableBitsInLayers || compact && stuffedBits.size > wordSize * 64) {
                throw new StiAztecException("Too many data for specified layer");
            }
        } else {
            wordSize = 0;
            stuffedBits = null;
            int i2 = 0;
            while (true) {
                if (i2 > 32) {
                    throw new StiAztecException("Too many data for an Aztec code");
                }
                compact = i2 <= 3;
                layers = compact ? i2 + 1 : i2;
                totalBitsInLayer = Encoder.TotalBitsInLayer(layers, compact);
                if (totalSizeBits <= totalBitsInLayer) {
                    if (stuffedBits == null || wordSize != WORD_SIZE[layers]) {
                        wordSize = WORD_SIZE[layers];
                        stuffedBits = Encoder.StuffBits(bits, wordSize);
                    }
                    int usableBitsInLayers = totalBitsInLayer - totalBitsInLayer % wordSize;
                    if ((!compact || stuffedBits.size <= wordSize * 64) && stuffedBits.size + eccBits <= usableBitsInLayers) break;
                }
                ++i2;
            }
        }
        BitArray messageBits = Encoder.GenerateCheckWords(stuffedBits, totalBitsInLayer, wordSize);
        int messageSizeInWords = stuffedBits.size / wordSize;
        BitArray modeMessage = Encoder.GenerateModeMessage(compact, layers, messageSizeInWords);
        int baseMatrixSize = (compact ? 11 : 14) + layers * 4;
        int[] alignmentMap = new int[baseMatrixSize];
        if (compact) {
            matrixSize = baseMatrixSize;
            for (int i3 = 0; i3 < alignmentMap.length; ++i3) {
                alignmentMap[i3] = i3;
            }
        } else {
            matrixSize = baseMatrixSize + 1 + 2 * ((baseMatrixSize / 2 - 1) / 15);
            int origCenter = baseMatrixSize / 2;
            int center = matrixSize / 2;
            for (int i4 = 0; i4 < origCenter; ++i4) {
                int newOffset = i4 + i4 / 15;
                alignmentMap[origCenter - i4 - 1] = center - newOffset - 1;
                alignmentMap[origCenter + i4] = center + newOffset + 1;
            }
        }
        BitMatrix matrix = new BitMatrix(matrixSize);
        int rowOffset = 0;
        for (i = 0; i < layers; ++i) {
            int rowSize = (layers - i) * 4 + (compact ? 9 : 12);
            for (int j = 0; j < rowSize; ++j) {
                int columnOffset = j * 2;
                for (int k = 0; k < 2; ++k) {
                    if (messageBits.get(rowOffset + columnOffset + k)) {
                        matrix.set(alignmentMap[i * 2 + k], alignmentMap[i * 2 + j], true);
                    }
                    if (messageBits.get(rowOffset + rowSize * 2 + columnOffset + k)) {
                        matrix.set(alignmentMap[i * 2 + j], alignmentMap[baseMatrixSize - 1 - i * 2 - k], true);
                    }
                    if (messageBits.get(rowOffset + rowSize * 4 + columnOffset + k)) {
                        matrix.set(alignmentMap[baseMatrixSize - 1 - i * 2 - k], alignmentMap[baseMatrixSize - 1 - i * 2 - j], true);
                    }
                    if (!messageBits.get(rowOffset + rowSize * 6 + columnOffset + k)) continue;
                    matrix.set(alignmentMap[baseMatrixSize - 1 - i * 2 - j], alignmentMap[i * 2 + k], true);
                }
            }
            rowOffset += rowSize * 8;
        }
        Encoder.DrawModeMessage(matrix, compact, matrixSize, modeMessage);
        if (compact) {
            Encoder.DrawBullsEye(matrix, matrixSize / 2, 5);
        } else {
            Encoder.DrawBullsEye(matrix, matrixSize / 2, 7);
            i = 0;
            int j = 0;
            while (i < baseMatrixSize / 2 - 1) {
                for (int k = matrixSize / 2 & 1; k < matrixSize; k += 2) {
                    matrix.set(matrixSize / 2 - j, k, true);
                    matrix.set(matrixSize / 2 + j, k, true);
                    matrix.set(k, matrixSize / 2 - j, true);
                    matrix.set(k, matrixSize / 2 + j, true);
                }
                i += 15;
                j += 16;
            }
        }
        return new AztecCode(compact, matrixSize, layers, messageSizeInWords, matrix);
    }

    private static void DrawBullsEye(BitMatrix matrix, int center, int size) {
        for (int i = 0; i < size; i += 2) {
            for (int j = center - i; j <= center + i; ++j) {
                matrix.set(j, center - i, true);
                matrix.set(j, center + i, true);
                matrix.set(center - i, j, true);
                matrix.set(center + i, j, true);
            }
        }
        matrix.set(center - size, center - size, true);
        matrix.set(center - size + 1, center - size, true);
        matrix.set(center - size, center - size + 1, true);
        matrix.set(center + size, center - size, true);
        matrix.set(center + size, center - size + 1, true);
        matrix.set(center + size, center + size - 1, true);
    }

    static BitArray GenerateModeMessage(boolean compact, int layers, int messageSizeInWords) throws StiAztecException {
        BitArray modeMessage = new BitArray();
        if (compact) {
            modeMessage.AppendBits(layers - 1, 2);
            modeMessage.AppendBits(messageSizeInWords - 1, 6);
            modeMessage = Encoder.GenerateCheckWords(modeMessage, 28, 4);
        } else {
            modeMessage.AppendBits(layers - 1, 5);
            modeMessage.AppendBits(messageSizeInWords - 1, 11);
            modeMessage = Encoder.GenerateCheckWords(modeMessage, 40, 4);
        }
        return modeMessage;
    }

    private static void DrawModeMessage(BitMatrix matrix, boolean compact, int matrixSize, BitArray modeMessage) {
        int center = matrixSize / 2;
        if (compact) {
            for (int i = 0; i < 7; ++i) {
                int offset = center - 3 + i;
                if (modeMessage.get(i)) {
                    matrix.set(offset, center - 5, true);
                }
                if (modeMessage.get(i + 7)) {
                    matrix.set(center + 5, offset, true);
                }
                if (modeMessage.get(20 - i)) {
                    matrix.set(offset, center + 5, true);
                }
                if (!modeMessage.get(27 - i)) continue;
                matrix.set(center - 5, offset, true);
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                int offset = center - 5 + i + i / 5;
                if (modeMessage.get(i)) {
                    matrix.set(offset, center - 7, true);
                }
                if (modeMessage.get(i + 10)) {
                    matrix.set(center + 7, offset, true);
                }
                if (modeMessage.get(29 - i)) {
                    matrix.set(offset, center + 7, true);
                }
                if (!modeMessage.get(39 - i)) continue;
                matrix.set(center - 7, offset, true);
            }
        }
    }

    private static BitArray GenerateCheckWords(BitArray bitArray, int totalBits, int wordSize) throws StiAztecException {
        if (bitArray.size % wordSize != 0) {
            throw new StiAztecException("size of bit array is not a multiple of the word size");
        }
        int messageSizeInWords = bitArray.size / wordSize;
        ReedSolomonEncoder rs = new ReedSolomonEncoder(Encoder.GetGF(wordSize));
        int totalWords = totalBits / wordSize;
        int[] messageWords = Encoder.BitsToWords(bitArray, wordSize, totalWords);
        rs.Encode(messageWords, totalWords - messageSizeInWords);
        int startPad = totalBits % wordSize;
        BitArray messageBits = new BitArray();
        messageBits.AppendBits(0, startPad);
        for (int messageWord : messageWords) {
            messageBits.AppendBits(messageWord, wordSize);
        }
        return messageBits;
    }

    private static int[] BitsToWords(BitArray stuffedBits, int wordSize, int totalWords) {
        int[] message = new int[totalWords];
        int n = stuffedBits.size / wordSize;
        for (int i = 0; i < n; ++i) {
            int value = 0;
            for (int j = 0; j < wordSize; ++j) {
                value |= stuffedBits.get(i * wordSize + j) ? 1 << wordSize - j - 1 : 0;
            }
            message[i] = value;
        }
        return message;
    }

    private static GaloisField GetGF(int wordSize) throws StiAztecException {
        switch (wordSize) {
            case 4: {
                return GaloisField.Aztec_Param;
            }
            case 6: {
                return GaloisField.Aztec_Data_6;
            }
            case 8: {
                return GaloisField.Aztec_Data_8;
            }
            case 10: {
                return GaloisField.Aztec_Data_10;
            }
            case 12: {
                return GaloisField.Aztec_Data_12;
            }
        }
        throw new StiAztecException("Unsupported word size " + wordSize);
    }

    static BitArray StuffBits(BitArray bits, int wordSize) throws StiAztecException {
        BitArray res = new BitArray();
        int n = bits.size;
        int mask = (1 << wordSize) - 2;
        for (int i = 0; i < n; i += wordSize) {
            int word = 0;
            for (int j = 0; j < wordSize; ++j) {
                if (i + j < n && !bits.get(i + j)) continue;
                word |= 1 << wordSize - 1 - j;
            }
            if ((word & mask) == mask) {
                res.AppendBits(word & mask, wordSize);
                --i;
                continue;
            }
            if ((word & mask) == 0) {
                res.AppendBits(word | 1, wordSize);
                --i;
                continue;
            }
            res.AppendBits(word, wordSize);
        }
        return res;
    }

    private static int TotalBitsInLayer(int layers, boolean compact) {
        return ((compact ? 88 : 112) + 16 * layers) * layers;
    }
}

