/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiEAN13BarCodeType;
import com.stimulsoft.report.barCodes.enums.StiEanSupplementType;
import java.util.ArrayList;

public class StiUpcEBarCodeType
extends StiEAN13BarCodeType {
    protected String[] symParitySet = new String[]{"eeeooo", "eeoeoo", "eeooeo", "eeoooe", "eoeeoo", "eooeeo", "eoooee", "eoeoeo", "eoeooe", "eooeoe"};

    public StiUpcEBarCodeType() {
        this(13.0, 1.0, StiEanSupplementType.None, null, false);
    }

    public StiUpcEBarCodeType(double module, double height, StiEanSupplementType supplementType, String supplementCodeValue, boolean showQuietZoneIndicator) {
        super(module, height, supplementType, supplementCodeValue, showQuietZoneIndicator);
    }

    @Override
    public String getServiceName() {
        return "UPC-E";
    }

    @Override
    protected double getEanSpaceLeft() {
        return 9.0;
    }

    @Override
    protected double getEanSpaceRight() {
        return 7.0;
    }

    @Override
    public boolean getShowQuietZoneIndicator() {
        return false;
    }

    @Override
    public void setShowQuietZoneIndicator(boolean value) {
    }

    protected final ArrayList MakeUpcEBars(String code, boolean isLast) {
        ArrayList<StiEAN13BarCodeType.EanBarInfo> barsArray = new ArrayList<StiEAN13BarCodeType.EanBarInfo>();
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.SpaceLeft, code.charAt(0), false));
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.GuardLeft, ' ', false));
        String symbolParity = this.symParitySet[Integer.parseInt(String.valueOf(code.charAt(7)))];
        for (int index = 0; index < 6; ++index) {
            int currentNumber = Integer.parseInt(String.valueOf(code.charAt(1 + index)));
            int parity = symbolParity.charAt(index);
            if (code.charAt(0) != '0') {
                parity = parity == 111 ? 101 : 111;
            }
            StiEAN13BarCodeType.EanBarInfo sym = new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.forValue(StiEAN13BarCodeType.Ean13Symbol.ComboA0.getValue() + currentNumber), code.charAt(1 + index), false);
            if (parity != 111) {
                sym.SymbolType = StiEAN13BarCodeType.Ean13Symbol.forValue(StiEAN13BarCodeType.Ean13Symbol.ComboB0.getValue() + currentNumber);
            }
            barsArray.add(sym);
        }
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.GuardSpecial, ' ', false));
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(isLast ? StiEAN13BarCodeType.Ean13Symbol.SpaceRight : StiEAN13BarCodeType.Ean13Symbol.SpaceBeforeAdd, code.charAt(7), false));
        return barsArray;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, "0123456789") + "00000000";
        String suppCode = this.CheckCodeSymbols(this.getSupplementCode(), "0123456789") + "00000";
        ArrayList barsArray = null;
        if (this.getSupplementType() == StiEanSupplementType.None) {
            barsArray = this.MakeUpcEBars(code, true);
        } else {
            barsArray = this.MakeUpcEBars(code, false);
            if (this.getSupplementType() == StiEanSupplementType.TwoDigit) {
                this.MakeEanAdd2Bars(suppCode, barsArray, true);
            } else {
                this.MakeEanAdd5Bars(suppCode, barsArray, true);
            }
        }
        this.CalculateSizeEan(0.0, zoom, barsArray, rect, barCode);
        this.translateRect(context, rect, barCode);
        this.drawEanBars(context, barsArray, barCode);
        this.rollbackTransform(context);
    }

    @Override
    public String getDefaultCodeValue() {
        return "01234567";
    }
}

