/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiIntelligentMail4StateBarCodeType
extends StiBarCodeTypeService {
    private double module = 20.0;
    private double height = 1.0;
    protected static final double IntelligentMail4StateSpaceLeft = 7.0;
    protected static final double IntelligentMail4StateSpaceRight = 7.0;
    protected static final double IntelligentMail4StateSpaceTop = 8.5;
    protected static final double IntelligentMail4StateSpaceBottom = 1.5;
    protected static final double IntelligentMail4StateLineHeightLong = 7.25;
    protected static final double IntelligentMail4StateLineHeightShort = 4.748749792575836;
    protected static final double IntelligentMail4StateTextPosition = 1.0;
    protected static final double IntelligentMail4StateTextHeight = 5.5;
    protected static final double IntelligentMail4StateMainHeight = 17.25;
    protected static final double IntelligentMail4StateLineHeightForCut = 7.25;
    protected static final double IntelligentMail4StateWideToNarrowRatio = 1.25;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 20.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Height")) continue;
            this.height = property.floatValue().floatValue();
        }
    }

    public String getServiceName() {
        return "Intelligent Mail 4-State";
    }

    @Override
    public String getDefaultCodeValue() {
        return "01 234 567094 987654321 01234 5678 91";
    }

    @Override
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 20.0) {
            this.module = 20.0;
        }
        if (value > 20.0) {
            this.module = 20.0;
        }
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 1.0) {
            this.height = 1.0;
        }
        if (value > 1.0) {
            this.height = 1.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 5.5;
    }

    @Override
    protected StiTextHorAlignment getTextAlignment() {
        return StiTextHorAlignment.Left;
    }

    protected boolean isPreserveAspectRatio() {
        return true;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        String text = this.CheckCodeSymbols(code, "0123456789 ");
        code = this.CheckCodeSymbols(code, "0123456789");
        String barsArray = null;
        StiRefObject tempRefBarsArray = new StiRefObject(barsArray);
        String errorString = IntelligentMail4State.Encode(code, (StiRefObject<String>)tempRefBarsArray);
        barsArray = (String)tempRefBarsArray.argvalue;
        if (!StiValidationUtil.isNullOrEmpty((String)barsArray)) {
            this.CalculateSizeFull(7.0, 7.0, 8.5, 1.5, 4.748749792575836, 7.25, 1.0, 5.5, 17.25, 7.25, 1.25, zoom, code, text, barsArray, rect, barCode);
            this.drawBarCode(context, rect, barCode);
        } else if (!StiValidationUtil.isNullOrEmpty((String)errorString)) {
            this.drawBarCodeError(context, rect, barCode, errorString);
        } else {
            this.drawBarCodeError(context, rect, barCode);
        }
    }

    public StiIntelligentMail4StateBarCodeType() {
        this(20.0, 1.0);
    }

    public StiIntelligentMail4StateBarCodeType(double module, double height) {
        this.module = module;
        this.height = height;
    }

    public static final class IntelligentMail4State {
        private static int table2Of13Size = 78;
        private static int table5Of13Size = 1287;
        private static int entries2Of13;
        private static int entries5Of13;
        private static int[] table2Of13;
        private static int[] table5Of13;
        private static int[][] codewordArray;
        private static int[] barTopCharIndexArray;
        private static int[] barBottomCharIndexArray;
        private static int[] barTopCharShiftArray;
        private static int[] barBottomCharShiftArray;

        public static String Encode(String source, StiRefObject<String> bars) {
            int i;
            if (StiValidationUtil.isNullOrEmpty((String)source)) {
                return "No input data.";
            }
            if (source.length() < 20) {
                return "Invalid tracking code length.";
            }
            if (source.length() > 31) {
                return "Input data too long.";
            }
            String zip = source.substring(20);
            if (zip.length() != 11 && zip.length() != 9 && zip.length() != 5 && zip.length() != 0) {
                return "Invalid ZIP code.";
            }
            int fcs = 0;
            long l = 0L;
            long v = 0L;
            String ds = "";
            int[] byteArray = new int[14];
            int[] ai = new int[66];
            int[] ai1 = new int[66];
            int[][] ad = new int[11][];
            if (zip.length() > 0) {
                l = Long.parseLong(zip) + (long)(zip.length() == 5 ? 1 : (zip.length() == 9 ? 100001 : (zip.length() == 11 ? 1000100001 : 0)));
            }
            v = l * 10L + (long)Integer.parseInt(source.substring(0, 1));
            v = v * 5L + (long)Integer.parseInt(source.substring(1, 2));
            ds = new Long(v).toString() + source.substring(2, 20);
            byteArray[12] = (int)(l & 0xFFL);
            byteArray[11] = (int)(l >> 8 & 0xFFL);
            byteArray[10] = (int)(l >> 16 & 0xFFL);
            byteArray[9] = (int)(l >> 24 & 0xFFL);
            byteArray[8] = (int)(l >> 32 & 0xFFL);
            IntelligentMail4State.mathMultiply(byteArray, 13, 10);
            IntelligentMail4State.mathAdd(byteArray, 13, Integer.parseInt(source.substring(0, 1)));
            IntelligentMail4State.mathMultiply(byteArray, 13, 5);
            IntelligentMail4State.mathAdd(byteArray, 13, Integer.parseInt(source.substring(1, 2)));
            for (i = 2; i <= 19; i = (int)((short)(i + 1))) {
                IntelligentMail4State.mathMultiply(byteArray, 13, 10);
                IntelligentMail4State.mathAdd(byteArray, 13, Integer.parseInt(source.substring(i, i + 1)));
            }
            fcs = IntelligentMail4State.mathFcs(byteArray);
            for (i = 0; i <= 9; i = (int)((short)(i + 1))) {
                IntelligentMail4State.codewordArray[i][0] = entries2Of13 + entries5Of13;
                IntelligentMail4State.codewordArray[i][1] = 0;
            }
            IntelligentMail4State.codewordArray[0][0] = 659;
            IntelligentMail4State.codewordArray[9][0] = 636;
            IntelligentMail4State.mathDivide(ds);
            int[] nArray = codewordArray[9];
            nArray[1] = nArray[1] * 2;
            if (fcs >> 10 != 0) {
                int[] nArray2 = codewordArray[0];
                nArray2[1] = nArray2[1] + 659;
            }
            for (i = 0; i <= 9; i = (int)((short)(i + 1))) {
                ad[i] = new int[3];
            }
            for (i = 0; i <= 9; i = (int)((short)(i + 1))) {
                if (codewordArray[i][1] >= entries2Of13 + entries5Of13) {
                    return "Something went wrong. Calculation error!";
                }
                ad[i][0] = 8192;
                ad[i][1] = codewordArray[i][1] >= entries2Of13 ? table2Of13[codewordArray[i][1] - entries2Of13] : table5Of13[codewordArray[i][1]];
            }
            for (i = 0; i <= 9; i = (int)((short)(i + 1))) {
                if ((fcs & 1 << i) == 0) continue;
                ad[i][1] = ~ad[i][1] & 0x1FFF;
            }
            for (i = 0; i <= 64; i = (int)((short)(i + 1))) {
                ai[i] = ad[barTopCharIndexArray[i]][1] >> barTopCharShiftArray[i] & 1;
                ai1[i] = ad[barBottomCharIndexArray[i]][1] >> barBottomCharShiftArray[i] & 1;
            }
            String encoded = "";
            for (int i2 = 0; i2 <= 64; ++i2) {
                encoded = ai[i2] == 0 ? encoded + (ai1[i2] == 0 ? "f" : "e") : encoded + (ai1[i2] == 0 ? "d" : "c");
                encoded = encoded + "1";
            }
            bars.argvalue = encoded;
            return null;
        }

        private static boolean mathAdd(int[] bytearray, int i, int j) {
            if (bytearray == null) {
                return false;
            }
            if (i < 1) {
                return false;
            }
            int x = (bytearray[i - 1] | bytearray[i - 2] << 8) + j;
            int l = x | 0xFFFF;
            bytearray[i - 1] = x & 0xFF;
            bytearray[i - 2] = x >> 8 & 0xFF;
            for (int k = i - 3; l == 1 && k > 0; --k) {
                x = l + bytearray[k];
                bytearray[k] = x & 0xFF;
                l = x | 0xFF;
            }
            return true;
        }

        private static boolean mathDivide(String v) {
            int j = 10;
            String n = v;
            for (int k = j - 1; k >= 1; --k) {
                String r = "";
                int divider = codewordArray[k][0];
                String copy = n;
                String left = "0";
                int l = copy.length();
                for (int i = 1; i <= l; ++i) {
                    int divident = Integer.parseInt(copy.substring(0, i));
                    while (divident < divider & i < l - 1) {
                        r = r + "0";
                        divident = Integer.parseInt(copy.substring(0, ++i));
                    }
                    r = r + String.valueOf(divident / divider);
                    left = StiStringUtil.padLeft((String)String.valueOf(divident % divider).toString(), (int)i, (String)"0");
                    copy = left + copy.substring(i);
                }
                n = StiStringUtil.trimStart((String)r, (String)"0");
                if (StiValidationUtil.isNullOrEmpty((String)n)) {
                    n = "0";
                }
                IntelligentMail4State.codewordArray[k][1] = Integer.parseInt(left);
                if (k != 1) continue;
                IntelligentMail4State.codewordArray[0][1] = Integer.parseInt(r);
            }
            return true;
        }

        private static int mathFcs(int[] bytearray) {
            int c = 3893;
            int i = 2047;
            int j = bytearray[0] << 5;
            for (int b = 2; b <= 7; b = (int)((short)(b + 1))) {
                i = ((i ^ j) & 0x400) != 0 ? i << 1 ^ c : (i <<= 1);
                i &= 0x7FF;
                j <<= 1;
            }
            for (int l = 1; l <= 12; ++l) {
                int k = bytearray[l] << 3;
                for (int b = 0; b <= 7; b = (int)((short)(b + 1))) {
                    i = ((i ^ k) & 0x400) != 0 ? i << 1 ^ c : (i <<= 1);
                    i &= 0x7FF;
                    k <<= 1;
                }
            }
            return i;
        }

        private static boolean mathMultiply(int[] bytearray, int i, int j) {
            if (bytearray == null) {
                return false;
            }
            if (i < 1) {
                return false;
            }
            int l = 0;
            int k = 0;
            for (k = i - 1; k >= 1; k -= 2) {
                int x = (bytearray[k] | bytearray[k - 1] << 8) * j + l;
                bytearray[k] = x & 0xFF;
                bytearray[k - 1] = x >> 8 & 0xFF;
                l = x >> 16;
            }
            if (k == 0) {
                bytearray[0] = bytearray[0] * j + l & 0xFF;
            }
            return true;
        }

        private static int mathReverse(int i) {
            int j = 0;
            for (int k = 0; k <= 15; k = (int)((short)(k + 1))) {
                j <<= 1;
                j |= i & 1;
                i >>= 1;
            }
            return j;
        }

        private static boolean initializeNof13Table(int[] ai, int i, int j) {
            int i1 = 0;
            int j1 = j - 1;
            for (int k = 0; k <= 8191; k = (int)((short)(k + 1))) {
                boolean flag;
                int k1 = 0;
                for (int l1 = 0; l1 <= 12; ++l1) {
                    if ((k & 1 << l1) == 0) continue;
                    ++k1;
                }
                if (k1 != i) continue;
                int l = IntelligentMail4State.mathReverse(k) >> 3;
                boolean bl = flag = k == l;
                if (l < k) continue;
                if (flag) {
                    ai[j1] = k;
                    --j1;
                    continue;
                }
                ai[i1] = k;
                ai[++i1] = l;
                ++i1;
            }
            return i1 == j1 + 1;
        }

        static {
            barTopCharIndexArray = new int[]{4, 0, 2, 6, 3, 5, 1, 9, 8, 7, 1, 2, 0, 6, 4, 8, 2, 9, 5, 3, 0, 1, 3, 7, 4, 6, 8, 9, 2, 0, 5, 1, 9, 4, 3, 8, 6, 7, 1, 2, 4, 3, 9, 5, 7, 8, 3, 0, 2, 1, 4, 0, 9, 1, 7, 0, 2, 4, 6, 3, 7, 1, 9, 5, 8};
            barBottomCharIndexArray = new int[]{7, 1, 9, 5, 8, 0, 2, 4, 6, 3, 5, 8, 9, 7, 3, 0, 6, 1, 7, 4, 6, 8, 9, 2, 5, 1, 7, 5, 4, 3, 8, 7, 6, 0, 2, 5, 4, 9, 3, 0, 1, 6, 8, 2, 0, 4, 5, 9, 6, 7, 5, 2, 6, 3, 8, 5, 1, 9, 8, 7, 4, 0, 2, 6, 3};
            barTopCharShiftArray = new int[]{3, 0, 8, 11, 1, 12, 8, 11, 10, 6, 4, 12, 2, 7, 9, 6, 7, 9, 2, 8, 4, 0, 12, 7, 10, 9, 0, 7, 10, 5, 7, 9, 6, 8, 2, 12, 1, 4, 2, 0, 1, 5, 4, 6, 12, 1, 0, 9, 4, 7, 5, 10, 2, 6, 9, 11, 2, 12, 6, 7, 5, 11, 0, 3, 2};
            barBottomCharShiftArray = new int[]{2, 10, 12, 5, 9, 1, 5, 4, 3, 9, 11, 5, 10, 1, 6, 3, 4, 1, 10, 0, 2, 11, 8, 6, 1, 12, 3, 8, 6, 4, 4, 11, 0, 6, 1, 9, 11, 5, 3, 7, 3, 10, 7, 11, 8, 2, 10, 3, 5, 8, 0, 3, 12, 11, 8, 4, 5, 1, 3, 0, 7, 12, 9, 8, 10};
            table2Of13 = new int[table2Of13Size + 1];
            IntelligentMail4State.initializeNof13Table(table2Of13, 2, table2Of13Size);
            entries5Of13 = table2Of13Size;
            table5Of13 = new int[table5Of13Size + 1];
            IntelligentMail4State.initializeNof13Table(table5Of13, 5, table5Of13Size);
            entries2Of13 = table5Of13Size;
            codewordArray = new int[11][];
            for (int i = 0; i <= 9; i = (int)((short)(i + 1))) {
                IntelligentMail4State.codewordArray[i] = new int[3];
            }
        }
    }
}

