/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.StiGS1ApplicationIdentifiers;
import com.stimulsoft.report.barCodes.StiQRCodeBarCodeType;
import com.stimulsoft.report.barCodes.StiQRCodeBodyShapeType;
import com.stimulsoft.report.barCodes.StiQRCodeEyeBallShapeType;
import com.stimulsoft.report.barCodes.StiQRCodeEyeFrameShapeType;
import com.stimulsoft.report.barCodes.enums.StiQRCodeErrorCorrectionLevel;
import com.stimulsoft.report.barCodes.enums.StiQRCodeSize;

public class StiGS1QRCodeBarCodeType
extends StiQRCodeBarCodeType {
    public double imageMultipleFactor = 1.0;

    @Override
    public String getServiceName() {
        return "GS1 QR Code";
    }

    @Override
    public String getDefaultCodeValue() {
        return "[21]012345[3103]000123";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        StringBuilder sbText;
        StringBuilder sbCode;
        String errorMessage;
        String code = this.GetCode(barCode);
        if ("System.Byte[]".equals(code)) {
            code = "";
        }
        if ((errorMessage = StiGS1ApplicationIdentifiers.ParseCode(code = this.CheckCodeSymbols(code, "!\"%&'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz[]"), sbCode = new StringBuilder(), sbText = new StringBuilder(), StiBarCodeTypeService.BarcodeCommandCode.Fnc1, false)) != null && barCode.getCodeValue() == null && barCode.getCode().getValue().contains("{")) {
            errorMessage = null;
            sbCode = new StringBuilder(barCode.getCode().getValue());
            sbText = new StringBuilder(barCode.getCode().getValue());
        }
        this.getBarCodeData().Code = sbCode.toString();
        StiQRCodeBarCodeType.StiQRCode.ErrorCorrectionLevel errorCorrectionLevel2 = StiQRCodeBarCodeType.StiQRCode.ErrorCorrectionLevel.L;
        if (this.errorCorrectionLevel == StiQRCodeErrorCorrectionLevel.Level2) {
            errorCorrectionLevel2 = StiQRCodeBarCodeType.StiQRCode.ErrorCorrectionLevel.M;
        }
        if (this.errorCorrectionLevel == StiQRCodeErrorCorrectionLevel.Level3) {
            errorCorrectionLevel2 = StiQRCodeBarCodeType.StiQRCode.ErrorCorrectionLevel.Q;
        }
        if (this.errorCorrectionLevel == StiQRCodeErrorCorrectionLevel.Level4) {
            errorCorrectionLevel2 = StiQRCodeBarCodeType.StiQRCode.ErrorCorrectionLevel.H;
        }
        try {
            StiQRCodeBarCodeType.StiQRCode qrCode = new StiQRCodeBarCodeType.StiQRCode();
            boolean assembleData = false;
            if (!assembleData) {
                StiQRCodeBarCodeType.StiQRCode.QREncoder.Encode(sbCode.toString(), errorCorrectionLevel2, qrCode, this.getMatrixSize(), this.isProcessTilde(), true);
            } else {
                StiQRCodeBarCodeType.StiQRCode.ByteMatrix matrix1 = new StiQRCodeBarCodeType.StiQRCode.ByteMatrix(1, 1);
                matrix1.Set(0, 0, 1);
                qrCode.SetMatrix(matrix1);
            }
            StiQRCodeBarCodeType.StiQRCode.ByteMatrix bm = qrCode.GetMatrix();
            int[] matrix = new int[bm.GetWidth() * bm.GetHeight()];
            for (int y = 0; y < bm.GetHeight(); ++y) {
                int offset = y * bm.GetWidth();
                for (int x = 0; x < bm.GetWidth(); ++x) {
                    matrix[offset + x] = (byte)bm.Get(x, y);
                }
            }
            this.getBarCodeData().MatrixGrid = matrix;
            this.getBarCodeData().MatrixWidth = bm.GetWidth();
            this.getBarCodeData().MatrixHeight = bm.GetHeight();
            this.getBarCodeData().MatrixRatioY = 1;
            if (errorMessage == null) {
                this.drawQRCode(context, rect, barCode, zoom, this.bodyShape, this.eyeFrameShape, this.eyeBallShape);
            } else {
                this.drawBarCodeError(context, rect, barCode, errorMessage);
            }
        }
        catch (Exception e) {
            this.drawBarCodeError(context, rect, barCode);
        }
    }

    public StiGS1QRCodeBarCodeType() {
        this(40.0f, StiQRCodeErrorCorrectionLevel.Level1, StiQRCodeSize.Automatic);
    }

    public StiGS1QRCodeBarCodeType(float module, StiQRCodeErrorCorrectionLevel errorCorrectionLevel, StiQRCodeSize matrixSize) {
        this.setModule(module);
        this.setErrorCorrectionLevel(errorCorrectionLevel);
        this.setMatrixSize(matrixSize);
    }

    public StiGS1QRCodeBarCodeType(float module, StiQRCodeErrorCorrectionLevel errorCorrectionLevel, StiQRCodeSize matrixSize, String image, double imageMultipleFactor, StiQRCodeBodyShapeType bodyShape, StiQRCodeEyeFrameShapeType eyeFrameShape, StiQRCodeEyeBallShapeType eyeBallShape, StiBrush bodyBrush, StiBrush eyeFrameBrush, StiBrush eyeBallBrush, boolean processTilde) {
        this.setModule(module);
        this.setErrorCorrectionLevel(errorCorrectionLevel);
        this.setMatrixSize(matrixSize);
        this.image = image;
        this.imageMultipleFactor = imageMultipleFactor;
        this.bodyShape = bodyShape;
        this.eyeFrameShape = eyeFrameShape;
        this.eyeBallShape = eyeBallShape;
        this.bodyBrush = bodyBrush;
        this.eyeFrameBrush = eyeFrameBrush;
        this.eyeBallBrush = eyeBallBrush;
        this.processTilde = processTilde;
    }
}

