/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.StiDataMatrixBarCodeType;
import com.stimulsoft.report.barCodes.StiGS1ApplicationIdentifiers;
import com.stimulsoft.report.barCodes.enums.StiDataMatrixEncodingType;
import com.stimulsoft.report.barCodes.enums.StiDataMatrixSize;

public class StiGS1DataMatrixBarCodeType
extends StiDataMatrixBarCodeType {
    public StiDataMatrixEncodingType encodingType = StiDataMatrixEncodingType.Ascii;

    @Override
    public String getServiceName() {
        return "GS1 DataMatrix";
    }

    @Override
    public String getDefaultCodeValue() {
        return "[21]012345[3103]000123";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        StringBuilder sbText;
        StringBuilder sbCode;
        String code = this.GetCode(barCode);
        String errorMessage = StiGS1ApplicationIdentifiers.ParseCode(code = this.CheckCodeSymbols(code, "!\"%&'()*+,-./0123456789:;<=>?ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz[]#"), sbCode = new StringBuilder(), sbText = new StringBuilder(), StiBarCodeTypeService.BarcodeCommandCode.Fnc1, true);
        if (errorMessage != null && barCode.getCodeValue() == null && barCode.getCode().getValue().contains("{")) {
            errorMessage = null;
            sbCode = new StringBuilder(barCode.getCode().getValue());
            sbText = new StringBuilder(barCode.getCode().getValue());
        }
        this.getBarCodeData().Code = sbCode.toString();
        if (errorMessage == null) {
            StiDataMatrixBarCodeType.StiDataMatrix dm = new StiDataMatrixBarCodeType.StiDataMatrix(sbCode.toString(), this.encodingType, this.getUseRectangularSymbols(), this.getMatrixSize(), this.processTilde);
            this.getBarCodeData().MatrixGrid = dm.getMatrix();
            this.getBarCodeData().MatrixWidth = dm.getWidth();
            this.getBarCodeData().MatrixHeight = dm.getHeight();
            this.getBarCodeData().MatrixRatioY = 1;
            errorMessage = dm.getErrorMessage();
        }
        if (errorMessage == null) {
            this.draw2DBarCode(context, rect, barCode, zoom);
        } else {
            this.drawBarCodeError(context, rect, barCode, errorMessage);
        }
    }

    public StiGS1DataMatrixBarCodeType() {
        this(40.0f, StiDataMatrixEncodingType.Ascii, false, StiDataMatrixSize.Automatic, false);
    }

    public StiGS1DataMatrixBarCodeType(float module, StiDataMatrixEncodingType encodingType, boolean useRectangularSymbols, StiDataMatrixSize matrixSize, boolean processTilde) {
        this.setModule(module);
        this.setEncodingType(encodingType);
        this.setUseRectangularSymbols(useRectangularSymbols);
        this.setMatrixSize(matrixSize);
        this.processTilde = processTilde;
    }
}

