/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

public class BitMatrix {
    public final int width;
    public final int height;
    private final int rowSize;
    private final int[] bits;

    public BitMatrix(int dimension) {
        this(dimension, dimension);
    }

    public BitMatrix(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = width;
        this.height = height;
        this.rowSize = width + 31 >> 5;
        this.bits = new int[this.rowSize * height];
    }

    public boolean get(int x, int y) {
        int offset = y * this.rowSize + (x >> 5);
        return (this.bits[offset] >> (x & 0x1F) & 1) != 0;
    }

    public void set(int x, int y, boolean value) {
        if (value) {
            int offset;
            int n = offset = y * this.rowSize + (x >> 5);
            this.bits[n] = this.bits[n] | 1 << (x & 0x1F);
        } else {
            int offset;
            int n = offset = y * this.rowSize + x / 32;
            this.bits[n] = this.bits[n] & ~(1 << (x & 0x1F));
        }
    }
}

