/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.engine.parser.StiParser;
import java.util.Map;

public class StiReportParser {
    public static String parse(String expression, StiReport report, boolean allowCache, Map<String, Object> constants, boolean allowDataLoading, boolean onlyExpression) {
        return StiReportParser.parse(expression, report.getPages().get(0), allowCache, constants, allowDataLoading, onlyExpression);
    }

    public static String parse(String expression, StiComponent component, boolean allowCache, Map<String, Object> constants, boolean allowDataLoading, boolean onlyExpression) {
        Object value = StiReportParser.parseObject(expression, component, allowCache, constants, allowDataLoading, onlyExpression);
        return value != null ? value.toString() : "";
    }

    public static Object parseObject(String expression, StiComponent component, boolean allowCache, Map<String, Object> constants, boolean allowDataLoading, boolean onlyExpression) {
        if (component == null) {
            return expression;
        }
        if (onlyExpression && expression != null) {
            expression = StiReportParser.prepareExpression(expression);
        }
        if (expression != null && !expression.contains("{")) {
            return expression;
        }
        return StiReportParser.parseOrDefault(expression, component, constants, allowDataLoading);
    }

    private static Object parseOrDefault(String expression, StiComponent component, Map<String, Object> constants, boolean allowDataLoading) {
        StiRefObject str = new StiRefObject(null);
        return !StiReportParser.TryParse(expression, (StiRefObject<Object>)str, component, constants, allowDataLoading) ? expression : str.argvalue;
    }

    private static boolean TryParse(String expression, StiRefObject<Object> result, StiComponent component, Map<String, Object> constants, boolean allowDataLoading) {
        try {
            if (expression == null || !expression.contains("{")) {
                result.argvalue = expression;
                return true;
            }
            Object value = StiParser.ParseTextValue(expression, component);
            result.argvalue = value != null ? value : "";
            return true;
        }
        catch (Exception e) {
            result.argvalue = "";
            return false;
        }
    }

    private static String prepareExpression(String expression) {
        if (!(expression = expression.trim()).contains("{")) {
            expression = "{" + expression;
        }
        if (!expression.contains("}")) {
            expression = expression + "}";
        }
        return expression;
    }
}

