/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.stiblocks.objects;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiFont;

public class StiSetPropertyToValue
extends IronBlock {
    @Override
    public Object evaluate(Context context) {
        if (this.getValues().evaluate("COMPONENT", context) instanceof StiComponent) {
            StiComponent component = (StiComponent)this.getValues().evaluate("COMPONENT", context);
            String dropdownProperty = this.getFields().get("PROPERTY");
            Object value = this.getValues().evaluate("VALUE", context);
            switch (dropdownProperty) {
                case "ENABLED": {
                    component.setEnabled(((Boolean)value).booleanValue());
                    break;
                }
                case "BACKGROUND": {
                    if (!(component instanceof IStiBrush) || value == null) break;
                    IStiBrush brushComponent = (IStiBrush)component;
                    StiColor color = StiColor.fromHtml((String)value.toString());
                    brushComponent.setBrush((StiBrush)new StiSolidBrush(color));
                    break;
                }
                case "FONT": {
                    if (!(component instanceof IStiFont) || value == null) break;
                    break;
                }
                case "WIDTH": {
                    component.setWidth(((Double)value).doubleValue());
                    break;
                }
                case "HEIGHT": {
                    component.setHeight(((Double)value).doubleValue());
                }
            }
        }
        return super.evaluate(context);
    }
}

