/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.stiblocks.functions;

import com.stimulsoft.report.dictionary.StiUserFunction;
import com.stimulsoft.report.dictionary.StiUserFunctionArgument;
import com.stimulsoft.report.dictionary.StiUserFunctionsCollection;
import com.stimulsoft.report.dictionary.functions.StiFunction;
import com.stimulsoft.report.dictionary.functions.StiFunctions;
import java.util.HashMap;
import java.util.Map;

public final class StiBlocklyFunctionBlockKeyCache {
    private static Map<String, Object> cache;

    public static String createKey(StiFunction function) {
        String key = String.format("%s.", function.getFunctionName());
        if (function.getArgumentNames() != null) {
            for (int index = 0; index < function.getArgumentNames().length; ++index) {
                key = key + String.format("%s.%s", function.getArgumentNames()[index], function.getArgumentTypes()[index].getSerializeValue());
            }
        }
        return key;
    }

    public static String createKey(StiUserFunction userFunction) {
        String key = String.format("%s.", userFunction.getName());
        if (userFunction.getArguments() != null) {
            for (int index = 0; index < userFunction.getArguments().size(); ++index) {
                key = key + String.format("%s.%s", ((StiUserFunctionArgument)userFunction.getArguments().get(index)).getName(), ((StiUserFunctionArgument)userFunction.getArguments().get(index)).getType());
            }
        }
        return key;
    }

    public static Object getFunction(String key, StiUserFunctionsCollection userFunctions) {
        if (cache != null) {
            StiBlocklyFunctionBlockKeyCache.fillCache(userFunctions);
        }
        return cache.get(key);
    }

    private static void fillCache(StiUserFunctionsCollection userFunctions) {
        cache = new HashMap<String, Object>();
        StiFunction[] functions = StiFunctions.getFunctions((boolean)false);
        for (StiFunction func : functions) {
            cache.put(StiBlocklyFunctionBlockKeyCache.createKey(func), func);
        }
        for (StiUserFunction uFunc : userFunctions) {
            cache.put(StiBlocklyFunctionBlockKeyCache.createKey(uFunc), uFunc);
        }
    }

    public static Map<String, Object> getBlockKeyTable(StiUserFunctionsCollection userFunctions) {
        if (cache == null) {
            StiBlocklyFunctionBlockKeyCache.fillCache(userFunctions);
        }
        return cache;
    }
}

