/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.blockly.blocks.logic;

import com.stimulsoft.base.DBNull;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.blockly.StiObjConverter;
import com.stimulsoft.blockly.model.Context;
import com.stimulsoft.blockly.model.IronBlock;
import java.math.BigDecimal;

public class LogicCompare
extends IronBlock {
    @Override
    public Object evaluate(Context context) {
        Object a = StiObjConverter.getValue(this.getValues().evaluate("A", context));
        Object b = StiObjConverter.getValue(this.getValues().evaluate("B", context));
        if (a == DBNull.Value) {
            a = null;
        }
        if (b == DBNull.Value) {
            b = null;
        }
        String opValue = this.getFields().get("OP");
        if (a instanceof String) {
            return this.compare(opValue, a instanceof String ? (String)a : null, b instanceof String ? (String)b : null);
        }
        if (a instanceof Number || a instanceof Float || a instanceof BigDecimal) {
            return this.compare(opValue, ((Number)a).doubleValue(), ((Number)b).doubleValue());
        }
        if (a instanceof Boolean) {
            return this.compare(opValue, (Boolean)a, (Boolean)b);
        }
        if (a instanceof StiColor && b instanceof String) {
            StiColor aValue = (StiColor)a;
            StiColor bValue = StiObjConverter.toColor(b.toString());
            switch (opValue) {
                case "EQ": {
                    return bValue.equals(aValue);
                }
                case "NEQ": {
                    return !bValue.equals(aValue);
                }
            }
        }
        if (a == null && b == null) {
            switch (opValue) {
                case "EQ": {
                    return true;
                }
                case "NEQ": {
                    return false;
                }
            }
        } else if (a == null && b != null) {
            switch (opValue) {
                case "EQ": {
                    return false;
                }
                case "NEQ": {
                    return true;
                }
            }
        } else if (a != null && b == null) {
            switch (opValue) {
                case "EQ": {
                    return false;
                }
                case "NEQ": {
                    return true;
                }
            }
        }
        throw new RuntimeException("unexpected value type");
    }

    private boolean compare(String op, String a, String b) {
        switch (op) {
            case "EQ": {
                return a.equals(b);
            }
            case "NEQ": {
                return !a.equals(b);
            }
            case "LT": {
                return a.compareTo(b) < 0;
            }
            case "LTE": {
                return a.compareTo(b) <= 0;
            }
            case "GT": {
                return a.compareTo(b) > 0;
            }
            case "GTE": {
                return a.compareTo(b) >= 0;
            }
        }
        throw new RuntimeException(String.format("Unknown OP %1$s", op));
    }

    private boolean compare(String op, double a, double b) {
        switch (op) {
            case "EQ": {
                return a == b;
            }
            case "NEQ": {
                return a != b;
            }
            case "LT": {
                return a < b;
            }
            case "LTE": {
                return a <= b;
            }
            case "GT": {
                return a > b;
            }
            case "GTE": {
                return a >= b;
            }
        }
        throw new RuntimeException(String.format("Unknown OP %1$s", op));
    }

    private boolean compare(String op, int a, int b) {
        switch (op) {
            case "EQ": {
                return a == b;
            }
            case "NEQ": {
                return a != b;
            }
            case "LT": {
                return a < b;
            }
            case "LTE": {
                return a <= b;
            }
            case "GT": {
                return a > b;
            }
            case "GTE": {
                return a >= b;
            }
        }
        throw new RuntimeException(String.format("Unknown OP %1$s", op));
    }

    private boolean compare(String op, boolean a, boolean b) {
        switch (op) {
            case "EQ": {
                return a == b;
            }
            case "NEQ": {
                return a != b;
            }
        }
        throw new RuntimeException(String.format("Unknown OP %1$s", op));
    }
}

