﻿
StiMobileDesigner.prototype.ReportViewPropertiesGroup = function () {
    var group = this.PropertiesGroup("reportViewPropertiesGroup", this.loc.PropertyCategory.ViewCategory);
    group.style.display = "none";

    var properties = [];
    properties.push(["PreviewSettings", this.loc.PropertyMain.PreviewSettings, this.PropertyTextBoxWithEditButton("controlReportPropertyPreviewSettings", this.options.propertyControlWidth, true), "TextBoxWithEditButton"]);
    
    var jsObject = this;

    for (var i = 0; i < properties.length; i++) {
        var control = properties[i][2];
        control.propertyName = this.LowerFirstChar(properties[i][0]);
        control.controlType = properties[i][3];
        group.container.appendChild(this.Property(control.propertyName, properties[i][1], control));
        group.jsObject.AddMainMethodsToPropertyControl(control);

        control.action = function () {
            if (this.propertyName == "refreshTime") {
                if (jsObject.options.cloudMode && parseInt(this.key) > 0 && parseInt(this.key) < 30) {
                    this.setKey("30");
                }
                this.textBox.value = this.key;
            }

            jsObject.options.selectedObject.properties[this.propertyName] = this.getValue();
            jsObject.SendCommandSetReportProperties([this.propertyName]);
        }

        if (control.propertyName == "previewSettings") {
            control.textBox.value = "(" + jsObject.loc.PropertyMain.PreviewSettings + ")";
            control.button.action = function () {
                jsObject.InitializePreviewSettingsForm(function (form) {
                    form.show();
                });
            }
        }
    }

    return group;
}