﻿
StiMobileDesigner.prototype.InitializeTableElementExpressionMenu = function (name, expressionControl, dataContainer, form) {
    var menu = this.BaseContextMenu(name, "Down", null, this.GetStyles("MenuStandartItem"));
    var jsObject = this;

    menu.action = function (menuItem) {
        this.changeVisibleState(false);
        var itemIndex = dataContainer.getSelectedItemIndex();

        if (menuItem.key.indexOf("Function_") == 0) {
            form.sendCommand({ command: "SetFunction", itemIndex: itemIndex, function: menuItem.key.replace("Function_", "") },
                function (answer) {
                    dataContainer.updateMeters(answer.elementProperties.meters, itemIndex);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                }
            );
            return;
        }

        switch (menuItem.key) {
            case "removeField": {
                if (dataContainer.selectedItem) dataContainer.selectedItem.remove();
                break;
            }
            case "removeAllFields": {
                dataContainer.clear();
                form.sendCommand({ command: "RemoveAllMeters" },
                    function (answer) {
                        dataContainer.updateMeters(answer.elementProperties.meters);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                    }
                );
                break;
            }
            case "editExpression": {
                jsObject.InitializeExpressionEditorForm(function (expressionEditorForm) {
                    var propertiesPanel = jsObject.options.propertiesPanel;
                    expressionEditorForm.propertiesPanelZIndex = propertiesPanel.style.zIndex;
                    expressionEditorForm.propertiesPanelIsEnabled = propertiesPanel.isEnabled;
                    expressionEditorForm.resultControl = expressionControl;
                    expressionEditorForm.changeVisibleState(true);
                });
                break;
            }
            case "newDimension":
            case "newMeasure": {
                var insertIndex = itemIndex + 1;
                if (insertIndex >= dataContainer.getCountItems()) insertIndex = -1;

                form.sendCommand({ command: "NewMeter", insertIndex: insertIndex, itemType: menuItem.key },
                    function (answer) {
                        dataContainer.updateMeters(answer.elementProperties.meters, insertIndex != -1 ? insertIndex : answer.elementProperties.meters.length - 1);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                    }
                );
                break;
            }
            case "duplicateField": {
                form.sendCommand({ command: "DuplicateMeter", itemIndex: itemIndex },
                    function (answer) {
                        dataContainer.updateMeters(answer.elementProperties.meters, answer.insertIndex);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                    }
                );
                break;
            }
        }
    }

    menu.onshow = function () {
        var items = [];
        items.push(jsObject.Item("newDimension", jsObject.loc.Dashboard.NewDimension, "Meters.Dimension.png", "newDimension"));
        items.push(jsObject.Item("newMeasure", jsObject.loc.Dashboard.NewMeasure, "Meters.Measure.png", "newMeasure"));

        if (dataContainer.selectedItem) {
            items.push("separator1");
            items.push(jsObject.Item("duplicateField", jsObject.loc.Dashboard.DuplicateField, "Duplicate.png", "duplicateField"));
            items.push(jsObject.Item("editExpression", jsObject.loc.Dashboard.EditExpression, "EditButton.png", "editExpression"));
            items.push(jsObject.Item("renameField", jsObject.loc.Buttons.Rename, "DataColumn.png", "renameField"));
            items.push(jsObject.Item("removeField", jsObject.loc.Dashboard.RemoveField, "Remove.png", "removeField"));
            items.push(jsObject.Item("removeAllFields", jsObject.loc.Dashboard.RemoveAllFields, "Empty16.png", "removeAllFields"));

            var functions = dataContainer.selectedItem.itemObject.functions;
            if (functions && functions.length > 0) {
                items.push("separator2");
                for (var i = 0; i < functions.length; i++) {
                    items.push(jsObject.Item("Function_" + functions[i], functions[i], "CheckBox.png", "Function_" + functions[i]));
                }
            }
        }

        this.addItems(items);

        for (var itemName in this.items) {
            if (itemName.indexOf("Function_") == 0) {
                var funcItem = this.items[itemName];
                var isSelected = dataContainer.selectedItem && dataContainer.selectedItem.itemObject.currentFunction &&
                    itemName.toLowerCase() == ("Function_" + dataContainer.selectedItem.itemObject.currentFunction).toLowerCase();

                funcItem.caption.style.fontWeight = isSelected ? "bold" : "normal";
                funcItem.image.style.visibility = isSelected ? "visible" : "hidden";
            }
        }
    }

    return menu;
}