﻿
StiMobileDesigner.prototype.SortFilterMenu = function (headerButton, form) {
    var menu = this.VerticalMenu("sortFilterMenu", headerButton, "Down", [], this.GetStyles("MenuStandartItem"));
    menu.innerContent.style.maxHeight = "1000px";
    var jsObject = this;
        
    menu.action = function(menuItem) {
        if (menuItem.name.indexOf("filterItem") == 0) {
            menuItem.setChecked(!menuItem.isChecked);
            menu.updateSelectAllFiltersState();
            this.dataTransformation.filterRules = this.getFilterRules();
            this.dataGrid.update();
            return;
        }

        switch (menuItem.name) {
            case "selectAll": {
                menu.selectAllFilters(!menuItem.isChecked);
                this.dataTransformation.filterRules = this.getFilterRules();
                this.dataGrid.update();
                return;
            }
            case "removeFilter": {
                menu.selectAllFilters(true);
                this.dataTransformation.filterRules = this.getFilterRules();
                this.dataGrid.update();
                return;
            }
            case "sortAsc":
            case "sortDesc":
            case "noSort": {
                this.items["sortAsc"].setChecked(menuItem.key == "Ascending");
                this.items["sortDesc"].setChecked(menuItem.key == "Descending");
                this.items["noSort"].setChecked(menuItem.key == "None");
                this.setSortDirection(menuItem.key);
                break;
            }
            case "customFilter": {
                jsObject.InitializeFilterRulesForm(function (form) {
                    form.show(menu.columnObject, menu.getThisColumnFilterRules());

                    form.action = function () {
                        this.changeVisibleState(false);
                        var otherFilters = menu.getNotThisColumnFilterRules();
                        var resultFilters = form.filterControl.getFilterRules()
                        menu.dataTransformation.filterRules = otherFilters.concat(resultFilters);
                        menu.dataGrid.update();
                    }
                });
                break;
            }
            case "removeActions": {
                menu.dataTransformation.actionRules = [];
                menu.dataGrid.update();
                break;
            }
            case "limitRows": {
                jsObject.InitializeLimitRowsForm(function (form) {
                    var actionsLimit = menu.getThisColumnActionRules("Limit");
                    form.show(menu.columnObject, actionsLimit);

                    form.action = function () {
                        this.changeVisibleState(false);
                        if (actionsLimit.length == 0) {
                            menu.dataTransformation.actionRules.push(this.actionRule);
                        }
                        else {
                            var index = menu.dataTransformation.actionRules.indexOf(actionsLimit[0]);
                            if (index >= 0) menu.dataTransformation.actionRules[index] = this.actionRule;
                        }
                        menu.dataGrid.update();
                    }
                });
                break;
            }
            case "replaceValues": {
                jsObject.InitializeReplaceValuesForm(function (form) {
                    var thisColumnActionsReplace = menu.getThisColumnActionRules("Replace");                    
                    form.show(menu.columnObject, thisColumnActionsReplace);

                    form.action = function () {
                        this.changeVisibleState(false);
                        for (var i = 0; i < thisColumnActionsReplace.length; i++) {
                            jsObject.RemoveElementFromArray(menu.dataTransformation.actionRules, thisColumnActionsReplace[i]);
                        }
                        menu.dataTransformation.actionRules = menu.dataTransformation.actionRules.concat(form.replaceControl.getReplaceRules());
                        menu.dataGrid.update();
                    }
                });
                break;
            }
            case "runningTotal": {
                jsObject.InitializeRunningTotalForm(function (form) {
                    var actionsRunningTotal = menu.getThisColumnActionRules("RunningTotal");
                    form.show(menu.columnObject, actionsRunningTotal);

                    form.action = function () {
                        this.changeVisibleState(false);

                        if (actionsRunningTotal.length == 0) {
                            if (this.actionRule.initialValue) {
                                menu.dataTransformation.actionRules.push(this.actionRule);
                            }
                        }
                        else {
                            var index = menu.dataTransformation.actionRules.indexOf(actionsRunningTotal[0]);
                            if (index >= 0) {
                                if (this.actionRule.initialValue) {
                                    menu.dataTransformation.actionRules[index] = this.actionRule
                                }
                                else {
                                    menu.dataTransformation.actionRules.splice(index, 1);
                                }
                            };
                        }
                        menu.dataGrid.update();
                    }
                });
                break;
            }
            case "showAsPercentages": {
                menuItem.setChecked(!menuItem.isChecked);
                var actionsPercentage = menu.getThisColumnActionRules("Percentage");
                if (menuItem.isChecked) {
                    if (actionsPercentage.length == 0) {
                        menu.dataTransformation.actionRules.push(jsObject.DataActionRuleObject(menu.columnObject.key, "Percentage"));
                    }
                }
                else if (actionsPercentage.length > 0) {
                    jsObject.RemoveElementFromArray(menu.dataTransformation.actionRules, actionsPercentage[0]);
                }
                menu.dataGrid.update();
                break;
            }
        }

        this.changeVisibleState(false);
    }
    
    menu.onshow = function() {
        this.clear();
        var columnsContainer = form.controls.dataContainer;
        var column = columnsContainer.getItemByIndex(headerButton.columnIndex);
        
        if (column && column.itemObject) {
            this.columnObject = column.itemObject;
            this.dataTransformation = form.dataTransformation;
            this.dataGrid = form.controls.dataGrid;

            var items = [];
            items.push(jsObject.Item("sortAsc", jsObject.ColumnIsNumericType(this.columnObject.type) ? jsObject.loc.Dashboard.SortSmallestToLargest : jsObject.loc.Dashboard.SortAZ, "SortAZ.png", "Ascending"));
            items.push(jsObject.Item("sortDesc", jsObject.ColumnIsNumericType(this.columnObject.type) ? jsObject.loc.Dashboard.SortLargestToSmallest : jsObject.loc.Dashboard.SortZA, "SortZA.png", "Descending"));
            items.push(jsObject.Item("noSort", jsObject.loc.FormBand.NoSort, null, "None"));
            items.push("separatorSort");
            items.push(jsObject.Item("actions", jsObject.loc.FormDictionaryDesigner.Actions, null, "actions", null, true));
            items.push("separatorActions");

            var filterHelper = menu.getFilteredItemsHelperObject(this.dataGrid.data, this.columnObject, headerButton.columnIndex);
            var filterItems = filterHelper.items;
            if (filterHelper.isNulls) filterItems.push(jsObject.Item("filterItemIsNulls", jsObject.loc.Dashboard.Nulls, null, { value: "isNullsValue", filterString: null }));
            if (filterHelper.isBlanks) filterItems.push(jsObject.Item("filterItemIsBlanks", jsObject.loc.Dashboard.Blanks, null, { value: "isBlanksValue", filterString: "" } ));

            if (filterItems.length > 0) {
                if (jsObject.ColumnIsNumericType(this.columnObject.type)) {
                    items.push(jsObject.Item("numberFilters", jsObject.loc.Dashboard.NumberFilters, null, "numberFilters", null, true));
                }
                else if (jsObject.ColumnIsDateType(this.columnObject.type)) {
                    items.push(jsObject.Item("dateFilters", jsObject.loc.Dashboard.DateFilters, null, "dateFilters", null, true));
                }
                else if (this.columnObject.type == "bool") {
                    items.push(jsObject.Item("booleanFilters", jsObject.loc.Dashboard.BooleanFilters, null, "booleanFilters", null, true));
                }
                else {
                    items.push(jsObject.Item("stringFilters", jsObject.loc.Dashboard.StringFilters, null, "stringFilters", null, true));
                }
                items.push(jsObject.Item("customFilter", jsObject.loc.Dashboard.CustomFilter.replace("&", "").replace("...", ""), null, "customFilter", null));                                
                items.push(jsObject.Item("removeFilter", jsObject.loc.FormBand.RemoveFilter.replace("&", ""), null, "removeFilter", null));
                items.push("separatorFilter");

                //Add FilterItems
                items.push(jsObject.Item("selectAll", jsObject.loc.Dashboard.SelectAll.replace("&", ""), null, "selectAll"));

                for (var i = 0; i < filterItems.length; i++) {
                    items.push(filterItems[i]);
                }
            }

            this.addItems(items);

            //Update states
            this.updateItemsStates();
            
            //Add submenus
            if (this.items["actions"]) {
                var actionsItems = [];
                actionsItems.push(jsObject.Item("limitRows", jsObject.loc.Dashboard.LimitRows, null, "limitRows"));

                if (this.columnObject.type == "string") {
                    actionsItems.push(jsObject.Item("replaceValues", jsObject.loc.Dashboard.ReplaceValues, null, "replaceValues"));
                }

                if (jsObject.ColumnIsNumericType(this.columnObject.type)) {
                    actionsItems.push(jsObject.Item("runningTotal", jsObject.loc.FormSystemTextEditor.RunningTotal, null, "runningTotal"));
                    actionsItems.push(jsObject.Item("showAsPercentages", jsObject.loc.Dashboard.ShowAsPercentages, null, "showAsPercentages"));
                }

                actionsItems.push("separator1");
                actionsItems.push(jsObject.Item("removeActions", jsObject.loc.Dashboard.RemoveActions.replace("&", ""), null, "removeActions"));

                var actionsMenu = jsObject.InitializeSubMenu("sortFilterMenuActions", [], this.items["actions"], this, "MenuStandartItem");

                //override
                actionsMenu.addItems = function (items) {
                    this.clear();
                    var itemsContainer = this.innerContent;

                    if (items && items.length) {
                        for (var i = 0; i < items.length; i++) {
                            if (typeof (items[i]) != "string")
                                itemsContainer.appendChild(jsObject.SortFilterMenuItem(this, items[i].name, items[i].caption, items[i].imageName, items[i].key, items[i].haveSubMenu));
                            else
                                itemsContainer.appendChild(jsObject.VerticalMenuSeparator(this, items[i]));
                        }
                    }
                }

                actionsMenu.addItems(actionsItems);

                actionsMenu.onshow = function () {
                    var actionRules = menu.getThisColumnActionRules();
                    actionsMenu.items["removeActions"].setEnabled(actionRules.length > 0);
                    actionsMenu.items["limitRows"].setChecked(actionRules.some(function (r) { return (r.type == "Limit") }));

                    if (actionsMenu.items["replaceValues"]) {
                        actionsMenu.items["replaceValues"].setChecked(actionRules.some(function (r) { return (r.type == "Replace") }));
                    }
                    if (actionsMenu.items["runningTotal"]) {
                        actionsMenu.items["runningTotal"].setChecked(actionRules.some(function (r) { return (r.type == "RunningTotal") }));
                    }
                    if (actionsMenu.items["showAsPercentages"]) {
                        actionsMenu.items["showAsPercentages"].setChecked(actionRules.some(function (r) { return (r.type == "Percentage") }));
                    }
                }
            }

            if (this.items["numberFilters"]) {
                var numberFiltersMenu = jsObject.InitializeSubMenu("sortFilterMenuNumberFilters", jsObject.GetFilterConditionItems("Numeric", false), this.items["numberFilters"], this, "MenuStandartItem");
                numberFiltersMenu.action = function (menuItem) {
                    this.changeVisibleState(false);
                    menu.filterSubMenuAction(menuItem.key);
                }
            }

            if (this.items["dateFilters"]) {
                var dateFiltersMenu = jsObject.InitializeSubMenu("sortFilterMenuDateFilters", jsObject.GetFilterConditionItems("DateTime", false), this.items["dateFilters"], this, "MenuStandartItem");
                dateFiltersMenu.action = function (menuItem) {
                    this.changeVisibleState(false);
                    menu.filterSubMenuAction(menuItem.key);
                }
            }

            if (this.items["booleanFilters"]) {
                var booleanFiltersMenu = jsObject.InitializeSubMenu("sortFilterMenuBooleanFilters", jsObject.GetFilterConditionItems("Boolean", false), this.items["booleanFilters"], this, "MenuStandartItem");
                booleanFiltersMenu.action = function (menuItem) {
                    this.changeVisibleState(false);
                    menu.filterSubMenuAction(menuItem.key);
                }
            }

            if (this.items["stringFilters"]) {
                var stringFiltersMenu = jsObject.InitializeSubMenu("sortFilterMenuStringFilters", jsObject.GetFilterConditionItems("String", false, true), this.items["stringFilters"], this, "MenuStandartItem");
                stringFiltersMenu.action = function (menuItem) {
                    this.changeVisibleState(false);
                    menu.filterSubMenuAction(menuItem.key);
                }
            }
        }
    }

    menu.onhide = function () {
        if (this.dataGrid && this.dataGrid.selectedHeaderButton) {
            this.dataGrid.selectedHeaderButton.setSelected(false);
            this.dataGrid.selectedHeaderButton = null;
        }
    }

    menu.updateItemsStates = function () {
        if (this.items["actions"]) {
            this.items["actions"].setChecked(this.getThisColumnActionRules().length > 0);
        }

        var sortRule = this.getThisColumnSortRule();
        var sortDirection = sortRule ? sortRule.direction : "None";
        this.items["sortAsc"].setChecked(sortDirection == "Ascending");
        this.items["sortDesc"].setChecked(sortDirection == "Descending");
        this.items["noSort"].setChecked(sortDirection == "None");

        if (this.items["customFilter"]) {
            var filterRules = menu.getThisColumnFilterRules(this.dataTransformation, this.columnObject);
            var filterType = menu.getDataFilterConditionGroupType(filterRules);

            if (filterRules.length == 0) {
                this.selectAllFilters(true);
            }
            else {
                for (var itemName in this.items) {
                    var item = this.items[itemName];
                    if (item.name && item.name.indexOf("filterItem") == 0) {
                        var filterString = this.items[itemName].key != null ? this.items[itemName].key.filterString : null;
                        this.items[itemName].setChecked(this.checkCondition(filterType, filterString, filterRules));
                    }
                }
            }

            this.updateSelectAllFiltersState();
        }
    }

    menu.filterSubMenuAction = function (itemKey) {
        this.changeVisibleState(false);

        jsObject.InitializeFilterRulesForm(function (form) {
            form.show(menu.columnObject, [jsObject.DataFilterRuleObject(menu.columnObject.key, itemKey)]);

            form.action = function () {
                this.changeVisibleState(false);
                var filters = menu.getNotThisColumnFilterRules();
                var resultFilters = form.filterControl.getFilterRules()
                menu.dataTransformation.filterRules = filters.concat(resultFilters);
                menu.dataGrid.update();
            }
        });
    }
    
    menu.isTypeCanBeFiltered = function (type) {
        return (
            jsObject.ColumnIsNumericType(type) ||
            jsObject.ColumnIsDateType(type) ||
            type == "string" ||
            type == "bool"
        );
    }

    menu.setSortDirection = function (direction) {
        var currentRule = this.getThisColumnSortRule();
        var columnKey = this.columnObject.key;

        if (currentRule == null && direction != "None") {
            this.dataTransformation.sortRules.push(jsObject.DataSortRuleObject(columnKey, direction));
        }
        else {
            if (direction == "None") {
                jsObject.RemoveElementFromArray(this.dataTransformation.sortRules, currentRule);
            }
            else {
                currentRule.direction = direction;
            }
        }
        this.dataGrid.update();
    }

    menu.getFilterRules = function () {
        var filters = this.getNotThisColumnFilterRules();

        if (this.items["selectAll"].isChecked)
            return filters;

        var itemsCountHelper = this.getFilterItemsCountHelperObject();
        var itemsCheckedCount = itemsCountHelper.checkedCount;
        var conditionGroupType = itemsCheckedCount > 0 && itemsCheckedCount <= itemsCountHelper.count / 2 ? "Equal" : "NotEqual";
        var columnKey = this.columnObject.key;
        var filter;

        for (var itemName in this.items) {
            var item = this.items[itemName];
            if (item.name && item.name.indexOf("filterItem") == 0) {
                var itemValue = item.key.value;
                var filterString = item.key.filterString;

                if (item.isChecked && conditionGroupType == "Equal") {
                    if (itemValue == "isNullsValue")
                        filter = jsObject.DataFilterRuleObject(columnKey, "IsNull");
                    else if (itemValue == "isBlanksValue")
                        filter = jsObject.DataFilterRuleObject(columnKey, "IsBlanks");
                    else
                        filter = jsObject.DataFilterRuleObject(columnKey, "EqualTo", filterString);

                    filters.push(filter);
                }
                else if (!item.isChecked && conditionGroupType == "NotEqual") {
                    if (itemValue == "isNullsValue")
                        filter = jsObject.DataFilterRuleObject(columnKey, "IsNotNull");
                    else if (itemValue == "isBlanksValue")
                        filter = jsObject.DataFilterRuleObject(columnKey, "IsNotBlanks");
                    else
                        filter = jsObject.DataFilterRuleObject(columnKey, "NotEqualTo", filterString);

                    filters.push(filter);
                }
            }
        }

        return filters;
    }

    menu.getThisColumnSortRule = function () {
        var dataTransformation = this.dataTransformation;
        for (var i = 0; i < dataTransformation.sortRules.length; i++) {
            if (dataTransformation.sortRules[i].key == this.columnObject.key) {
                return dataTransformation.sortRules[i];
            }
        }
        return null;
    }

    menu.getThisColumnFilterRules = function () {
        var dataTransformation = this.dataTransformation;
        var filterRules = [];
        for (var i = 0; i < dataTransformation.filterRules.length; i++) {
            if (dataTransformation.filterRules[i].key == this.columnObject.key) {
                filterRules.push(dataTransformation.filterRules[i]);
            }
        }
        return filterRules;
    }

    menu.getNotThisColumnFilterRules = function () {
        var dataTransformation = this.dataTransformation;
        var filterRules = [];
        for (var i = 0; i < dataTransformation.filterRules.length; i++) {
            if (dataTransformation.filterRules[i].key != this.columnObject.key) {
                filterRules.push(dataTransformation.filterRules[i]);
            }
        }
        return filterRules;
    }

    menu.getThisColumnActionRules = function (actionType) {
        var dataTransformation = this.dataTransformation;
        var actionRules = [];
        for (var i = 0; i < dataTransformation.actionRules.length; i++) {
            if (dataTransformation.actionRules[i].key == this.columnObject.key) {
                if (actionType) {
                    if (actionType == dataTransformation.actionRules[i].type) {
                        actionRules.push(dataTransformation.actionRules[i]);
                    }
                }
                else {
                    actionRules.push(dataTransformation.actionRules[i]);
                }
            }
        }
        return actionRules;
    }

    menu.getNotThisColumnActionRules = function () {
        var dataTransformation = this.dataTransformation;
        var actionRules = [];
        for (var i = 0; i < dataTransformation.actionRules.length; i++) {
            if (dataTransformation.actionRules[i].key != this.columnObject.key) {
                actionRules.push(dataTransformation.actionRules[i]);
            }
        }
        return actionRules;
    }

    menu.getDataFilterConditionGroupType = function (filterRules) {

        if (filterRules.length == 0) {
            return "Empty";
        }

        if (filterRules.every(function (r) { return (r.condition == "EqualTo" || r.condition == "IsBlanks" || r.condition == "IsNull") })) {
            return "Equal";
        };

        if (filterRules.every(function (r) { return (r.condition == "NotEqualTo" || r.condition == "IsNotBlanks" || r.condition == "IsNotNull") })) {
            return "NotEqual";
        };

        return "Custom";
    }

    menu.checkCondition = function (filterType, value, filterRules) {

        if (filterType == "Equal") {
            if (value == null)
                return filterRules.some(function (r) { return (r.condition == "IsNull") });

            if (value == "")
                return filterRules.some(function (r) { return (r.condition == "IsBlanks") });

            return filterRules.some(function (r) { return (r.value == value) });
        }

        if (filterType == "NotEqual") {
            if (value == null)
                return !filterRules.some(function (r) { return (r.condition == "IsNotNull") });

            if (value == "")
                return !filterRules.some(function (r) { return (r.condition == "IsNotBlanks") });

            return !filterRules.some(function (r) { return (r.value == value) });
        }

        return false;
    }

    menu.selectAllFilters = function(state) {
        if (this.items["removeFilter"])
            this.items["removeFilter"].setEnabled(!state);

        if (this.items["selectAll"])
            this.items["selectAll"].setChecked(state);

        for (var itemName in this.items) {
            var item = this.items[itemName];
            if (item.name && item.name.indexOf("filterItem") == 0) {
                this.items[itemName].setChecked(state);
            }
        }
    }

    menu.updateSelectAllFiltersState = function () {
        var isChecked = true;

        for (var itemName in this.items) {
            var item = this.items[itemName];
            if (item.name && item.name.indexOf("filterItem") == 0) {
                if (!this.items[itemName].isChecked) {
                    isChecked = false;
                    break;
                }
            }
        }

        if (this.items["removeFilter"])
            this.items["removeFilter"].setEnabled(!isChecked);

        if (this.items["selectAll"])
            this.items["selectAll"].setChecked(isChecked);
    }

    menu.getFilterItemsCountHelperObject = function () {
        var result = {
            count: 0,
            checkedCount: 0
        }

        for (var itemName in this.items) {
            var item = this.items[itemName];
            if (item.name && item.name.indexOf("filterItem") == 0) {                
                if (this.items[itemName].isChecked) {
                    result.checkedCount++;
                }
                result.count++;
            }
        }

        return result;
    }

    menu.getFilteredItemsHelperObject = function (data, columnObject, columnIndex) {
        var result = {
            isNulls: false,
            isBlanks: false,
            items: []
        }
        var resultItems = [];
        var values = [];

        if (data && data.length > 1) {
            for (var i = 1; i < data.length; i++) {
                if (columnIndex < data[i].length) {
                    var value = data[i][columnIndex].value;
                    
                    if (value == null) {
                        result.isNulls = true;
                    }
                    else if (typeof(value) == "string" && value.trim() == "") {
                        result.isBlanks = true;
                    }
                    else if (this.isTypeCanBeFiltered(columnObject.type) && values.indexOf(value) < 0) {
                        values.push(value);
                        var displayValue = data[i][columnIndex].displayValue != null ? data[i][columnIndex].displayValue : value.toString();

                        if (displayValue == "isNullsValue") displayValue = jsObject.loc.Dashboard.Nulls;
                        else if (displayValue == "isBlanksValue") displayValue = jsObject.loc.Dashboard.Blanks;

                        resultItems.push({
                            displayValue: displayValue,
                            filterString: data[i][columnIndex].filterString,
                            value: value
                        });   
                    }
                }
            }

            resultItems.sort(jsObject.SortByDisplayValue);

            for (var i = 0; i < resultItems.length; i++) {
                result.items.push(jsObject.Item("filterItem" + i, resultItems[i].displayValue, null, { value: resultItems[i].value, filterString: resultItems[i].filterString }));
            }
        }

        return result;
    }

    //override
    menu.addItems = function (items) {
        this.clear();
        var itemsContainer = this.innerContent;

        if (items && items.length) {
            for (var i = 0; i < items.length; i++) {
                if (typeof (items[i]) != "string") {
                    itemsContainer.appendChild(jsObject.SortFilterMenuItem(this, items[i].name, items[i].caption, items[i].imageName, items[i].key, items[i].haveSubMenu));

                    if (items[i].name == "selectAll") {
                        filterContainer = document.createElement("div");
                        filterContainer.style.overflowY = "auto";
                        filterContainer.style.overflowX = "visible";
                        filterContainer.style.maxHeight = "250px";
                        filterContainer.style.borderTop = "1px dotted #c6c6c6";
                        this.innerContent.appendChild(filterContainer);
                        itemsContainer = filterContainer;
                    }
                }
                else {
                    itemsContainer.appendChild(jsObject.VerticalMenuSeparator(this, items[i]));
                }
            }
        }
    }
        
    return menu; 
}

StiMobileDesigner.prototype.SortFilterMenuItem = function (menu, itemName, caption, imageName, key, haveSubMenu) {
    var item = this.VerticalMenuItem(menu, itemName, (caption && caption.length > 40) ? caption.substring(0, 40) + "..." : caption,
        imageName || "CheckBox.png", key, this.GetStyles("MenuStandartItem"), haveSubMenu)

    var jsObject = this;
    var imgRect = document.createElement("div");
    item.cellImage.appendChild(imgRect);
    imgRect.style.padding = "2px 0 0 3px";
    imgRect.appendChild(item.image);
    imgRect.style.width = imgRect.style.height = "16px";
    imgRect.style.border = "1px solid transparent";
    if (item.imageName == "CheckBox.png") {
        item.image.style.display = "none";
    }

    item.setChecked = function (state) {
        this.isChecked = state;
        if (this.imageName == "CheckBox.png") {
            this.image.style.display = state ? "" : "none";
        }
        imgRect.style.border = "1px solid " + (state ? "#ababab" : "transparent");
    }

    return item;
}