﻿StiMobileDesigner.prototype.SignaturesMenu = function () {
    var componentTypes = ["StiPdfDigitalSignature"];

    var items = [];

    for (var i = 0; i < componentTypes.length; i++) {
        if (this.options.visibilityComponents[componentTypes[i]] ||
            this.options.visibilityBands[componentTypes[i]] ||
            this.options.visibilityCrossBands[componentTypes[i]]) {
            items.push(this.Item(componentTypes[i], this.loc.Components[componentTypes[i]], "SmallComponents." + componentTypes[i] + ".png", componentTypes[i]));
        }
    }

    if (items.length == 0 && this.options.buttons.insertSignatures)
        this.options.buttons.insertSignatures.style.display = "none";

    var menu = this.VerticalMenu("signaturesMenu", this.options.buttons.insertSignatures, "Down", items, this.GetStyles("MenuStandartItem"));
    
    menu.innerContent.style.maxHeight = "420px";

    for (var itemKey in menu.items) {
        this.AddDragEventsToComponentButton(menu.items[itemKey]);
        //menu.items[itemKey].setAttribute("title", this.loc.HelpComponents[itemKey]);
    }

    menu.action = function (menuItem) {
        this.changeVisibleState(false);
        this.jsObject.options.insertPanel.resetChoose();
        this.jsObject.options.insertPanel.setChoose(menuItem);
    }

    return menu;
}