﻿
StiMobileDesigner.prototype.MapsElementsMenu = function (menuName, parentButton, isToolboxMenu, dashboardElements) {
    var jsObject = this;
    var elementTypes = ["StiRegionMapElement", "StiOnlineMapElement"];
    var items = [];
        
    for (var i = 0; i < elementTypes.length; i++) {
        if (dashboardElements.indexOf(elementTypes[i]) >= 0 && jsObject.options.visibilityDashboardElements[elementTypes[i]]) {
            items.push(this.Item(elementTypes[i], this.loc.Components[elementTypes[i].replace("Element", "")],
                "Dashboards." + (isToolboxMenu ? "SmallComponents." : "BigComponents.") + elementTypes[i] + ".png", elementTypes[i]));
        }
    }

    if (items.length == 0 && parentButton)
        parentButton.style.display = "none";

    var menu = isToolboxMenu
        ? this.HorizontalMenu(menuName, parentButton, "Right", items, this.GetStyles("MenuStandartItem"))
        : this.VerticalMenu(menuName, parentButton, "Down", items, this.GetStyles("MenuMiddleItem"));
        
    var mapsHeader = this.ThemesMenuHeader(this.loc.PropertyMain.Maps);
    menu.innerContent.insertBefore(mapsHeader, menu.innerContent.firstChild);

    for (var itemKey in menu.items) {
        var item = menu.items[itemKey];
        item.isDashboardElement = true;
        this.AddDragEventsToComponentButton(item);

        if (this.loc.HelpComponents[itemKey]) {
            item.setAttribute("title", this.loc.HelpComponents[itemKey]);
        }
    }

    menu.action = function (menuItem) {
        this.changeVisibleState(false);
        var panel = isToolboxMenu ? this.jsObject.options.toolbox : this.jsObject.options.insertPanel;
        panel.resetChoose();
        panel.setChoose(menuItem);
    }

    return menu;
}