﻿
StiMobileDesigner.prototype.InitializeExpressionMenu = function (name, expressionControl, form) {
    var menu = this.BaseContextMenu(name, "Down", null, this.GetStyles("MenuStandartItem"));
    var jsObject = this;

    menu.onshow = function () {
        var currentContainer = expressionControl.currentContainer;
        var items = [];
        items.push(jsObject.Item("newItem", jsObject.loc.FormDictionaryDesigner.NewItem, "Empty16.png", "newItem"));

        if (expressionControl.isEnabled && currentContainer && currentContainer.isSelected) {
            items.push("separator1");
            items.push(jsObject.Item("editExpression", jsObject.loc.Dashboard.EditExpression, "EditButton.png", "editExpression"));
            items.push(jsObject.Item("renameField", jsObject.loc.Buttons.Rename, "DataColumn.png", "renameField"));
            items.push(jsObject.Item("removeField", jsObject.loc.Dashboard.RemoveField, "Remove.png", "removeField"));

            if (currentContainer.dataColumnObject) {
                var functions = currentContainer.dataColumnObject.functions;
                if (functions && functions.length > 0) {
                    items.push("separator2");
                    for (var i = 0; i < functions.length; i++) {
                        items.push(jsObject.Item("Function_" + functions[i], functions[i], "CheckBox.png", "Function_" + functions[i]));
                    }
                }
            }
        }

        this.addItems(items);

        for (var itemName in this.items) {
            if (itemName.indexOf("Function_") == 0) {
                var funcItem = this.items[itemName];
                var isSelected = currentContainer.dataColumnObject && currentContainer.dataColumnObject.currentFunction &&
                    itemName.toLowerCase() == ("Function_" + currentContainer.dataColumnObject.currentFunction).toLowerCase();

                funcItem.caption.style.fontWeight = isSelected ? "bold" : "normal";
                funcItem.image.style.visibility = isSelected ? "visible" : "hidden";
            }
        }
    }

    menu.action = function (menuItem) {
        this.changeVisibleState(false);
        var currentContainer = expressionControl.currentContainer;

        if (menuItem.key.indexOf("Function_") == 0) {
            form.sendCommand(
                {
                    command: "SetFunction",
                    containerName: jsObject.UpperFirstChar(currentContainer.name),
                    function: menuItem.key.replace("Function_", "")
                },
                function (answer) {
                    if (answer.elementProperties) {
                        form.updateControls(answer.elementProperties);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                    }
                }
            );
            return;
        }

        switch (menuItem.key) {
            case "removeField": {
                currentContainer.clear();
                currentContainer.action();
                break;
            }
            case "editExpression": {
                menu.jsObject.InitializeExpressionEditorForm(function (expressionEditorForm) {
                    var propertiesPanel = expressionEditorForm.jsObject.options.propertiesPanel;
                    expressionEditorForm.propertiesPanelZIndex = propertiesPanel.style.zIndex;
                    expressionEditorForm.propertiesPanelIsEnabled = propertiesPanel.isEnabled;
                    expressionEditorForm.resultControl = expressionControl;
                    expressionEditorForm.changeVisibleState(true);
                });
                break;
            }
            case "newItem": {
                form.sendCommand(
                    {
                        command: "NewItem",
                        containerName: jsObject.UpperFirstChar(currentContainer.name)
                    },
                    function (answer) {
                        form.updateControls(answer.elementProperties);
                        form.updateSvgContent(answer.elementProperties.svgContent);
                        form.checkStartMode();
                    }
                );
                break;
            }
        }
    }

    return menu;
}