﻿
StiMobileDesigner.prototype.InitializeReplaceValuesForm_ = function () {

    var form = this.BaseForm("replaceValuesForm", this.loc.Dashboard.ReplaceValues, 2);

    var replaceControl = this.ReplaceValuesControl("dataTransformationReplaceControl", 700, 350);
    form.replaceControl = replaceControl;
    form.container.appendChild(replaceControl);
    
    form.show = function (columnObject, replaceRules) {
        this.changeVisibleState(true);
        replaceControl.columnObject = columnObject;        
        replaceControl.setReplaceRules(this.jsObject.CopyObject(replaceRules));
    }

    return form;
}


StiMobileDesigner.prototype.ReplaceValuesControl = function (name, width, height) {
    var replaceControl = document.createElement("div");
    var jsObject = this;
    replaceControl.controls = {};
    replaceControl.name = name;
    replaceControl.columnObject = null;

    //ToolBar
    var toolBar = this.CreateHTMLTable();
    toolBar.style.margin = "4px";
    replaceControl.appendChild(toolBar);

    var addButton = this.StandartSmallButton(null, null, this.loc.Buttons.Add, "Add.png");
    toolBar.addCell(addButton);

    //Container
    var container = this.ReplaceValuesContainer(replaceControl);
    container.style.width = (width ? width : 600) + "px";
    container.style.height = (height ? height : 300) + "px";
    replaceControl.appendChild(container);

    addButton.action = function () {
        container.addReplaceRule(jsObject.DataActionRuleObject(replaceControl.columnObject.key, "Replace"));
    }

    replaceControl.setReplaceRules = function (replaceRules) {
        container.clear();

        if (!replaceRules) return;

        for (var i = 0; i < replaceRules.length; i++) {
            container.addReplaceRule(replaceRules[i]);
        }
    }

    replaceControl.getReplaceRules = function () {
        var replaceRules = [];

        for (var i = 0; i < container.childNodes.length; i++) {
            var replaceRule = container.childNodes[i].replaceRule;
            if (replaceRule.valueFrom) {
                replaceRules.push(container.childNodes[i].replaceRule)
            }
        }

        return replaceRules;
    }

    return replaceControl;
}

StiMobileDesigner.prototype.ReplaceValuesContainer = function (replaceControl) {
    var container = document.createElement("div");
    var jsObject = this;
    container.className = "stiDesignerFilterContainer";
    container.replaceControl = replaceControl;

    container.addReplaceRule = function (replaceRule) {
        var item = jsObject.ReplaceRuleItem(container, replaceRule);
        this.appendChild(item);
        item.valueFromControl.focus();
    }

    container.clear = function () {
        while (this.childNodes[0]) this.removeChild(this.childNodes[0]);
    }

    return container;
}

StiMobileDesigner.prototype.ReplaceRuleItem = function (replaceContainer, replaceRule) {
    var item = document.createElement("div");
    var columnObject = replaceContainer.replaceControl.columnObject;
    var jsObject = this;
    item.key = this.newGuid().replace(/-/g, '');
    item.isSelected = false;
    item.replaceRule = replaceRule;
    item.className = "stiDesignerFilterPanel";

    //Header
    var header = this.CreateHTMLTable();
    header.className = "stiDesignerFilterPanelHeader";
    header.style.width = "100%";
    item.appendChild(header);

    var headerButton = this.StandartSmallButton(null, null, this.loc.Editor.titleReplace);
    headerButton.style.margin = "2px 0px 2px 2px";    
    headerButton.caption.style.width = "100%";
    headerButton.caption.style.textAlign = "center";
    header.addCell(headerButton).style.width = "100%";

    var removeButton = this.StandartSmallButton(null, null, null, "RemoveBlack.png");
    removeButton.style.margin = "2px 2px 2px 0px";
    header.addCell(removeButton);

    removeButton.action = function () {
        item.remove();
    }

    headerButton.oldonmouseenter = headerButton.onmouseenter;
    headerButton.oldonmouseleave = headerButton.onmouseleave;

    headerButton.onmouseenter = function () {
        headerButton.oldonmouseenter();
        removeButton.onmouseenter();
    }

    headerButton.onmouseleave = function () {
        headerButton.oldonmouseleave();
        removeButton.onmouseleave();
    }

    item.remove = function () {
        replaceContainer.removeChild(this);
    }

    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "7px";
    item.appendChild(innerTable);

    innerTable.addTextCell(this.loc.Editor.FindWhat.replace(":", "")).className = "stiDesignerTextContainer";
    innerTable.addTextCell(this.loc.Editor.ReplaceWith.replace(":", "")).className = "stiDesignerTextContainer";
    innerTable.addCell();

    //Value From
    var valueFromControl = this.TextBox(null, 200);
    innerTable.addCellInNextRow(valueFromControl).style.padding = "7px 7px 0 0";
    valueFromControl.value = item.replaceRule.valueFrom;
    item.valueFromControl = valueFromControl;

    valueFromControl.action = function () {
        item.replaceRule.valueFrom = this.value;
    }

    //Value To
    var valueToControl = this.TextBox(null, 200);
    innerTable.addCellInLastRow(valueToControl).style.padding = "7px 7px 0 0";
    valueToControl.value = item.replaceRule.valueTo;

    valueToControl.action = function () {
        item.replaceRule.valueTo = this.value;
    }

    //MatchCase
    var matchCaseControl = this.CheckBox(null, this.loc.Editor.MatchCase.replace("&", ""));
    innerTable.addCellInLastRow(matchCaseControl).style.padding = "7px 7px 0 0";
    matchCaseControl.setChecked(item.replaceRule.matchCase);

    matchCaseControl.action = function () {
        item.replaceRule.matchCase = this.isChecked;
    }

    return item;
}