﻿
StiMobileDesigner.prototype.FilterRulesControl = function (name, width, height) {
    var filterControl = document.createElement("div");
    var jsObject = this;
    filterControl.controls = {};
    filterControl.name = name;
    filterControl.columnObject = null;

    //ToolBar
    var toolBar = this.CreateHTMLTable();
    toolBar.style.margin = "4px";
    filterControl.appendChild(toolBar);

    var controlProps = [
        ["addFilter", this.StandartSmallButton(null, null, this.loc.FormBand.AddFilter.replace("&", ""), "AddFilter.png")],
        ["separator"],
        ["moveUp", this.StandartSmallButton(null, null, null, "MoveUp.png")],
        ["moveDown", this.StandartSmallButton(null, null, null, "MoveDown.png")],
        ["separator"],
        ["filterOn", this.CheckBox(null, this.loc.PropertyMain.FilterOn)]
    ]

    for (var i = 0; i < controlProps.length; i++) {
        if (controlProps[i][0] == "separator") {
            toolBar.addCell(this.HomePanelSeparator());
            continue;
        }
        var control = controlProps[i][1];
        control.style.margin = "0 2px 0 2px";
        filterControl.controls[controlProps[i][0]] = control;
        if (controlProps[i][0] == "filterOn") {
            control.style.margin = "0 6px 0 6px";
        }
        toolBar.addCell(control);
    }

    //Container
    var container = this.FilterRulesContainer(filterControl);
    container.style.width = (width ? width : 600) + "px";
    container.style.height = (height ? height : 300) + "px";
    filterControl.appendChild(container);

    filterControl.controls.addFilter.action = function () {
        container.addFilterRule(jsObject.DataFilterRuleObject(filterControl.columnObject.key, "EqualTo", filterControl.columnObject.type == "bool" ? "False" : null,
            null, filterControl.controls.filterOn.isChecked));
    }

    filterControl.controls.moveUp.setEnabled(false);
    filterControl.controls.moveDown.setEnabled(false);

    filterControl.controls.moveUp.action = function () {
        if (container.selectedItem) {
            container.selectedItem.move("Up");
        }
    }

    filterControl.controls.moveDown.action = function () {
        if (container.selectedItem) {
            container.selectedItem.move("Down");
        }
    }

    filterControl.controls.filterOn.action = function () {
        for (var i = 0; i < container.childNodes.length; i++) {
            var filterItem = container.childNodes[i];
            filterItem.filterRule.isEnabled = this.isChecked;
        }
    }

    container.onAction = function () {
        var count = container.getCountItems();
        var index = container.selectedItem ? container.selectedItem.getIndex() : -1;
        filterControl.controls.moveUp.setEnabled(index > 0);
        filterControl.controls.moveDown.setEnabled(index != -1 && index < count - 1);
    }

    filterControl.setFilterRules = function (filterRules) {
        container.clear();
        filterControl.controls.filterOn.setChecked(true);

        if (!filterRules) return;

        for (var i = 0; i < filterRules.length; i++) {
            container.addFilterRule(filterRules[i], true);
            if (i == 0) {
                filterControl.controls.filterOn.setChecked(filterRules[i].isEnabled);
            }
        }

        container.onAction();
    }

    filterControl.getFilterRules = function () {
        var filterRules = [];

        for (var i = 0; i < container.childNodes.length; i++) {
            filterRules.push(container.childNodes[i].filterRule)
        }

        return filterRules;
    }

    return filterControl;
}

StiMobileDesigner.prototype.FilterRulesContainer = function (filterControl) {
    var container = document.createElement("div");
    var jsObject = this;
    container.className = "stiDesignerFilterContainer";
    container.selectedItem = null;
    container.filterControl = filterControl;

    container.addFilterRule = function (filterRule, notAction) {
        var filterItem = jsObject.FilterRuleItem(container, filterRule);
        this.appendChild(filterItem);
        if (!notAction) container.onAction();
        if (filterItem.valueControl && filterItem.valueControl.textBox && filterItem.valueControl.textBox["focus"] && !filterItem.valueControl.readOnly) {
            filterItem.valueControl.textBox.focus();
        }
    }

    container.clear = function () {
        while (this.childNodes[0]) this.removeChild(this.childNodes[0]);
    }

    container.getCountItems = function () {
        return this.childNodes.length;
    }

    container.onAction = function () { };

    return container;
}

StiMobileDesigner.prototype.FilterRuleItem = function (filterContainer, filterRule) {
    var filterItem = document.createElement("div");
    var columnObject = filterContainer.filterControl.columnObject;
    var jsObject = this;
    filterItem.key = this.newGuid().replace(/-/g, '');
    filterItem.isSelected = false;
    filterItem.filterRule = filterRule;
    filterItem.className = "stiDesignerFilterPanel";

    //Header
    var header = this.CreateHTMLTable();
    header.className = "stiDesignerFilterPanelHeader";
    header.style.width = "100%";
    filterItem.appendChild(header);

    var headerButton = this.StandartSmallButton(null, null, this.loc.PropertyMain.Filter, "CheckBox.png");
    headerButton.style.margin = "2px 0px 2px 2px";
    headerButton.image.style.visibility = "hidden";
    headerButton.caption.style.width = "100%";
    headerButton.caption.style.textAlign = "center";
    header.addCell(headerButton).style.width = "100%";

    var removeButton = this.StandartSmallButton(null, null, null, "RemoveBlack.png");
    removeButton.style.margin = "2px 2px 2px 0px";
    header.addCell(removeButton);

    removeButton.action = function () {
        filterItem.remove();
    }

    header.onclick = function () {
        if (this.isTouchEndFlag || jsObject.options.isTouchClick) return;
        this.action();
    }

    header.ontouchend = function () {
        if (jsObject.options.fingerIsMoved) return;
        var this_ = this;
        this.isTouchEndFlag = true;
        clearTimeout(this.isTouchEndTimer);
        this.action();
        this.isTouchEndTimer = setTimeout(function () {
            this_.isTouchEndFlag = false;
        }, 1000);
    }

    header.action = function () {
        filterItem.setSelected(!filterItem.isSelected);
        filterContainer.onAction();
    }

    headerButton.oldonmouseenter = headerButton.onmouseenter;
    headerButton.oldonmouseleave = headerButton.onmouseleave;

    headerButton.onmouseenter = function () {
        headerButton.oldonmouseenter();
        removeButton.onmouseenter();
    }

    headerButton.onmouseleave = function () {
        headerButton.oldonmouseleave();
        removeButton.onmouseleave();
    }

    filterItem.setSelected = function (state) {
        if (state) {
            if (filterContainer.selectedItem) filterContainer.selectedItem.setSelected(false);
            filterContainer.selectedItem = this;
        }
        else {
            if (filterContainer.selectedItem && filterContainer.selectedItem == this) filterContainer.selectedItem = null;
        }
        filterItem.isSelected = state;
        headerButton.image.style.visibility = state ? "visible" : "hidden";
    }

    filterItem.remove = function () {
        filterContainer.removeChild(this);
        if (filterContainer.selectedItem == this) filterContainer.selectedItem = null;
        filterContainer.onAction();
    }

    filterItem.getIndex = function () {
        for (var i = 0; i < filterContainer.childNodes.length; i++)
            if (filterContainer.childNodes[i] == this) return i;
    };

    filterItem.move = function (direction) {
        var index = this.getIndex();
        filterContainer.removeChild(this);
        var count = filterContainer.getCountItems();
        var newIndex = direction == "Up" ? index - 1 : index + 1;
        if (direction == "Up" && newIndex == -1) newIndex = 0;
        if (direction == "Down" && newIndex >= count) {
            filterContainer.appendChild(this);
            filterContainer.onAction();
            return;
        }
        filterContainer.insertBefore(this, filterContainer.childNodes[newIndex]);
        filterContainer.onAction();
    }  
   
    var innerTable = this.CreateHTMLTable();
    innerTable.style.margin = "7px";
    filterItem.appendChild(innerTable);

    var conditionItems = [];

    if (jsObject.ColumnIsNumericType(columnObject.type)) {
        conditionItems = jsObject.GetFilterConditionItems("Numeric", false);
    }
    else if (jsObject.ColumnIsDateType(columnObject.type)) {
        conditionItems = jsObject.GetFilterConditionItems("DateTime", false);
    }
    else if (columnObject.type == "bool") {
        conditionItems = jsObject.GetFilterConditionItems("Boolean", false);
    }
    else {
        conditionItems = jsObject.GetFilterConditionItems("String", false, true);
    }

    //Condition
    var conditionControl = this.DinamicDropDownList(filterItem.key + "Condition", 145, null, conditionItems, true, false);
    conditionControl.style.marginRight = "7px";
    innerTable.addCell(conditionControl);
    conditionControl.setKey(filterRule.condition);

    conditionControl.action = function () {
        filterRule.condition = this.key;
        filterItem.updateControls();
    };

    //Value
    var valueControl;

    if (jsObject.ColumnIsDateType(columnObject.type)) {
        valueControl = this.DateControl(null, 130);
        valueControl.setKey(filterRule.value);

        valueControl.action = function () {
            filterRule.value = this.key;
        }
    }
    else if (columnObject.type == "bool") {
        valueControl = this.DinamicDropDownList(filterItem.key + "Value", 160, null, this.GetBoolItems());
        valueControl.setKey(filterRule.value);

        valueControl.action = function () {
            filterRule.value = this.key;
        }
    }
    else {
        valueControl = this.ExpressionControl(null, 130, null, null, true);        
        valueControl.textBox.value = filterRule.value;

        valueControl.action = function () {
            filterRule.value = this.textBox.value;
        }
    }

    valueControl.style.marginRight = "7px";
    innerTable.addCell(valueControl);
    filterItem.valueControl = valueControl;

    //And Caption
    var andCaption = innerTable.addTextCell(this.loc.PropertyEnum.StiFilterModeAnd);

    //Value2
    var value2Control;

    if (jsObject.ColumnIsDateType(columnObject.type)) {
        value2Control = this.DateControl(null, 13);
        value2Control.setKey(filterRule.value2);

        value2Control.action = function () {
            filterRule.value2 = this.key;
        }
    }
    else {
        value2Control = this.ExpressionControl(null, 130, null, null, true);
        value2Control.textBox.value = filterRule.value2;

        value2Control.action = function () {
            filterRule.value2 = this.textBox.value;
        }
    }

    value2Control.style.margin = "0 7px 0 7px";
    innerTable.addCell(value2Control);

    //Expression
    var isExpressionControl = this.CheckBox(null, this.loc.PropertyMain.Expression);
    isExpressionControl.style.marginRight = "7px";
    innerTable.addCell(isExpressionControl);
    isExpressionControl.setChecked(filterRule.isExpression);

    isExpressionControl.action = function () {
        filterRule.isExpression = this.isChecked;
        filterItem.updateControls();
        if (columnObject.type == "bool" && !this.isChecked) {
            if (!this.isChecked)
                valueControl.setKey("False");
            else {
                valueControl.textBox.value = "";
                valueControl.textBox.focus();
            }
        }
    }
    
    filterItem.updateControls = function () {        
        var showValue2 = filterRule.condition == "Between" || filterRule.condition == "NotBetween";
        var showValues = filterRule.condition != "IsNull" && filterRule.condition != "IsNotNull" && filterRule.condition != "IsBlanks" && filterRule.condition != "IsNotBlanks";
        valueControl.style.display = showValues ? "" : "none";
        value2Control.style.display = showValues && showValue2 ? "" : "none";
        andCaption.style.display = showValue2 ? "" : "none";
        isExpressionControl.style.display = showValues ? "" : "none";

        if (!jsObject.ColumnIsDateType(columnObject.type) && columnObject.type != "bool") {
            valueControl.button.parentElement.style.display = filterRule.isExpression ? "" : "none";
            value2Control.button.parentElement.style.display = filterRule.isExpression ? "" : "none";
        }

        if (columnObject.type == "bool") {
            valueControl.button.parentElement.style.display = filterRule.isExpression ? "none" : "";
            valueControl.readOnly = valueControl.textBox.readOnly = !filterRule.isExpression;
        }
    }

    filterItem.updateControls();

    return filterItem;
}