﻿
StiMobileDesigner.prototype.DataGrid = function (width, height) {
    var grid = document.createElement("div");
    grid.jsObject = this;
    grid.className = "stiDataGrid";
    if (width) grid.style.width = width + "px";
    if (height) grid.style.height = height + "px";
    var jsObject = this;

    grid.clear = function () {
        while (this.childNodes[0]) this.removeChild(this.childNodes[0]);
        grid.data = null;
    }

    grid.showData = function (data, sortLabels, filterLabels) {
        grid.displayData = data;
        if (!data) return;
        
        var dataTableHead = jsObject.CreateHTMLTable();
        var tableHeadRow = dataTableHead.tr[0];
        this.appendChild(dataTableHead);

        var scrollContainer = document.createElement("div");
        scrollContainer.style.overflowY = "auto";
        scrollContainer.style.overflowX = "hidden";
        scrollContainer.style.height = "calc(100% - 20px)";
        this.appendChild(scrollContainer);

        var dataTable = jsObject.CreateHTMLTable();
        var tableBodyRow = dataTable.tr[0];
        scrollContainer.appendChild(dataTable);

        var updateCellsWidth = function () {
            if (tableHeadRow.childNodes.length == 0 ||
                tableBodyRow.childNodes.length == 0 ||
                tableHeadRow.childNodes.length != tableBodyRow.childNodes.length)
                return;

            for (i = 0; i < tableBodyRow.childNodes.length; i++) {
                var width = Math.max(tableBodyRow.childNodes[i].offsetWidth, tableHeadRow.childNodes[i].offsetWidth);
                if (width > 300) width = Math.min(tableBodyRow.childNodes[i].offsetWidth, tableHeadRow.childNodes[i].offsetWidth);
                if (width > 300) width = 300;
                var headerButton = tableHeadRow.childNodes[i].firstChild;
                var divBody = document.createElement("div");                
                headerButton.style.width = divBody.style.width = width + "px";
                headerButton.style.padding = "0 4px 0 4px";
                headerButton.style.overflow = divBody.style.overflow = "hidden";
                divBody.innerHTML = tableBodyRow.childNodes[i].innerHTML;
                tableBodyRow.childNodes[i].innerHTML = "";
                tableBodyRow.childNodes[i].appendChild(divBody);
            }

            scrollContainer.style.width = (dataTableHead.offsetWidth) + "px";
        }

        var cuttingCells = {};
        var headerButtons = [];

        for (var i = 0; i < data[0].length; i++) {
            var headerButton = jsObject.GridHeaderButton(data[0][i]);
            headerButton.columnName = data[0][i];
            headerButton.columnIndex = i;
            var headerCell = dataTableHead.addCell(headerButton);
            headerCell.className = "stiDesignerDataGridCell";
            headerCell.style.padding = "0";
            headerCell.style.background = "#f0f0f0";
            headerButtons.push(headerButton);

            headerButton.action = function () {
                grid.action(this);
            }

            headerButton.onclick = null;

            headerButton.onmouseup = function () {
                this.action();
            }

            if (grid.selectedHeaderButton && grid.selectedHeaderButton.columnName == data[0][i]) {
                headerButton.setSelected(true);
                grid.selectedHeaderButton = headerButton;
            }
        }

        //set header sort and filter labels
        if (sortLabels) {
            var sortCounter = 1;
            for (var i = 0; i < sortLabels.length; i++) {
                if (sortLabels[i].columnIndex < headerButtons.length) {
                    headerButtons[sortLabels[i].columnIndex].showSortDirection(sortLabels[i].direction, sortLabels.length > 1 ? sortCounter : null);
                    sortCounter++;
                }
            }
        }

        if (filterLabels) {
            for (var i = 0; i < filterLabels.length; i++) {
                if (filterLabels[i].columnIndex < headerButtons.length) {
                    headerButtons[filterLabels[i].columnIndex].showFilter(true);
                }
            }
        }

        if (data.length > 1) {
            for (var i = 1; i < data.length; i++) {
                for (var k = 0; k < data[i].length; k++) {
                    var cell = dataTable.addCellInLastRow();
                    cell.className = "stiDesignerDataGridCell";
                    cell.style.background = i % 2 == 0 ? "#f5f5f5" : "#ffffff";
                    cell.style.whiteSpace = "nowrap";
                                        
                    if (data[i][k].type == "Image") {
                        var img = document.createElement("img");
                        img.style.maxWidth = img.style.maxHeight = "60px";
                        img.src = data[i][k].value;
                        cell.style.width = cell.style.height = "60px";
                        cell.style.textAlign = "center";
                        cell.appendChild(img);
                    }
                    else if (data[i][k].type == "Boolean") {
                        var checkBox = jsObject.CheckBox();
                        checkBox.setChecked(data[i][k].value && data[i][k].value.toString().toLowerCase() == "true");
                        checkBox.onmouseover = null;
                        checkBox.onmouseout = null;
                        checkBox.onmouseenter = null;
                        checkBox.onmouseleave = null;
                        checkBox.onclick = null;
                        checkBox.style.display = "inline-block";
                        cell.style.width = "50px";
                        cell.style.textAlign = "center";
                        cell.appendChild(checkBox);
                    }
                    else {
                        var displayValue = data[i][k].displayValue != null && data[i][k].displayValue != "isNullsValue" && data[i][k].displayValue != "isBlanksValue"
                            ? data[i][k].displayValue
                            : data[i][k].value != null ? data[i][k].value.toString() : "";
                        
                        if (displayValue.length > 40 || cuttingCells[k] != null) {
                            cuttingCells[k] = true;
                            var div = document.createElement("div");
                            div.style.width = "250px";
                            div.style.overflow = "hidden";
                            div.style.textOverflow = "ellipsis";
                            div.innerHTML = displayValue.substring(0, 150);
                            cell.appendChild(div);
                            cell.style.width = "250px";
                        }
                        else {
                            cell.innerHTML = displayValue;
                        }
                    }
                }
                dataTable.addRow();
            }            
        }

        updateCellsWidth();
    }

    grid.action = function () {

    }

    return grid;
}

StiMobileDesigner.prototype.GridHeaderButton = function (caption) {
    var button = this.SmallButton(null, null, caption, null, null, "Down", this.GetStyles("StandartSmallButton"));
    button.sort = null;
    button.filter = null;

    var innerTable = this.CreateHTMLTable();
    innerTable.style.height = "100%";
    innerTable.style.width = "100%";
    button.removeChild(button.innerTable);
    button.appendChild(innerTable);   

    var sortImage = document.createElement("img");
    sortImage.style.marginLeft = "4px";
    sortImage.src = this.options.images["DataTransformation.SortAsc.png"];
    innerTable.addCell(sortImage);
    sortImage.style.visibility = "hidden";

    var sortNumber = document.createElement("div");
    var numberCell = innerTable.addCell(sortNumber);
    sortNumber.style.width = "6px";
    sortNumber.style.marginRight = "4px";
    sortNumber.style.fontSize = "8px";
    sortNumber.style.color = "#8a8a8a";
    sortNumber.style.textAlign = "right";
    numberCell.style.verticalAlign = "bottom";
    numberCell.style.paddingBottom = "4px";

    button.caption = innerTable.addTextCell(caption);
    button.caption.style.whiteSpace = "nowrap";
    button.caption.style.textAlign = "center";
    button.caption.style.width = "100%";

    var filterImage = document.createElement("img");
    filterImage.style.margin = "0 6px 0 6px";
    filterImage.src = this.options.images["DropDownButton.png"];
    filterImage.style.visibility = "hidden";
    var filterCell = innerTable.addCell(filterImage);

    button.onmouseenter = function () {
        if (this.jsObject.options.isTouchClick) return;
        this.className = this.styles["over"] + (this.jsObject.options.isTouchDevice ? "_Touch" : "_Mouse");
        this.isOver = true;
        filterImage.style.visibility = "visible";
    }

    button.onmouseleave = function () {
        this.isOver = false;
        this.className = (this.isSelected ? this.styles["selected"] : this.styles["default"]) + (this.jsObject.options.isTouchDevice ? "_Touch" : "_Mouse");
        if (!this.filter) filterImage.style.visibility = "hidden";
    }    

    button.showSortDirection = function (sortDirection, number) {
        sortImage.style.visibility = sortDirection == "Ascending" || sortDirection == "Descending" ? "visible" : "hidden";
        sortImage.src = this.jsObject.options.images[sortDirection == "Ascending" ? "DataTransformation.SortAsc.png" : "DataTransformation.SortDesc.png"];
        sortNumber.innerHTML = number || "";
    }

    button.showFilter = function (filter) {
        filterImage.src = this.jsObject.options.images[filter ? "DataTransformation.Filter.png" : "DropDownButton.png"];
        filterImage.style.visibility = filter ? "visible" : "hidden";
        filterImage.style.margin = filter ? "0 5px 0 5px" : "0 6px 0 6px";
        this.filter = filter;
    }

    return button;
}