﻿
StiMobileDesigner.prototype.DataContainer = function (width, height, showItemImage) {
    var container = document.createElement("div");
    container.jsObject = this;
    container.className = "stiDataContainer";
    if (width) {
        container.width = width;
        container.style.width = width + "px";
    }
    if (height) container.style.height = height + "px";
    container.selectedItem = null;

    container.updateHintText = function () {
        if (this.childNodes.length == 0 && !this.hintText) {
            this.hintText = document.createElement("div");
            this.hintText.className = "wizardFormHintText";
            this.hintText.innerHTML = this.jsObject.loc.Dashboard.DragDropDataFromDictionary;
            this.appendChild(this.hintText);
            this.hintText.style.width = "100%";
            this.hintText.style.textAlign = "center";
            this.hintText.style.top = "calc(50% - 9px)";
            this.style.borderStyle = "dashed";
        }
        else {            
            if (this.hintText && this.childNodes.length > 1) {
                this.removeChild(this.hintText);
                this.hintText = null;
            }
            this.style.borderStyle = "solid";
        }
    }

    container.clear = function () {
        while (this.childNodes[0]) this.removeChild(this.childNodes[0]);
        this.selectedItem = null;
        this.style.paddingBottom = "0px";
        this.hintText = null;
        this.onAction("clear");
        this.updateHintText();
    }

    container.addItem = function (caption, imageName, itemObject, insertIndex) {
        var item = this.jsObject.DataContainerItem(caption, showItemImage ? imageName : null, itemObject, this);
        if (insertIndex != null && this.getCountItems() > 0 && insertIndex < this.getCountItems() - 1) {
            this.insertBefore(item, this.childNodes[insertIndex + 1]);
        }
        else {
            this.appendChild(item);
        }
        this.updateHintText();
        this.style.borderColor = "";

        return item;
    }

    container.getItemIndex = function (item) {
        for (var i = 0; i < this.childNodes.length; i++)
            if (this.childNodes[i] == item) return i;

        return null;
    }

    container.getItemByIndex = function (index) {
        if (!this.hintText && index < this.childNodes.length) {
            return this.childNodes[index];
        }

        return null;
    }

    container.getSelectedItemIndex = function () {
        return this.selectedItem ? this.getItemIndex(this.selectedItem) : null;
    }

    container.getOverItemIndex = function () {
        for (var i = 0; i < this.childNodes.length; i++)
            if (this.childNodes[i].isOver) return i;

        return null;
    }

    container.getCountItems = function () {
        return (!this.hintText ? this.childNodes.length : 0);
    }

    container.moveItem = function (fromIndex, toIndex) {
        if (fromIndex < this.childNodes.length && toIndex < this.childNodes.length) {
            var fromItem = this.childNodes[fromIndex];
            //Move Down
            if (fromIndex < toIndex) {
                if (toIndex < this.childNodes.length - 1) {
                    this.insertBefore(fromItem, this.childNodes[toIndex + 1]);
                }
                else {
                    this.appendChild(fromItem);
                }
            }
            //Move Up
            else {
                this.insertBefore(fromItem, this.childNodes[toIndex]);
            }

            return fromItem;
        }
    }

    container.onmouseover = function () {
        if (this.jsObject.options.itemInDrag && this.jsObject.options.itemInDrag.originalItem.itemObject) {
            var typeItem = this.jsObject.options.itemInDrag.originalItem.itemObject.typeItem;
            if (typeItem == "Column" || typeItem == "DataSource" || typeItem == "BusinessObject" || typeItem == "Meter") {
                container.style.borderStyle = "dashed";
                container.style.borderColor = this.jsObject.options.themeColors[this.jsObject.GetThemeColor()];
            }
        }
    }

    container.onmouseout = function () {
        container.style.borderStyle = this.hintText ? "dashed" : "solid";
        container.style.borderColor = "";
    }

    container.onAction = function (actionName) { }
    container.onRemove = function () { }

    return container;
}

StiMobileDesigner.prototype.DataContainerItem = function (caption, imageName, itemObject, container) {
    var item = this.StandartSmallButton(null, null, caption, imageName);
    item.container = container;
    item.itemObject = itemObject;
    if (item.caption) {
        item.caption.style.width = "100%";
        var captCont = document.createElement("div");
        item.captionContainer = captCont;
        captCont.style.position = "relative";
        captCont.style.overflow = "hidden";
        captCont.style.textOverflow = "ellipsis";
        captCont.style.padding = "2px 0 2px 0";
        if (container.width) {
            var textMaxWidth = container.width - 25;
            if (imageName) textMaxWidth -= 25;
            captCont.style.maxWidth = textMaxWidth + "px";
        }
        captCont.innerHTML = caption;
        item.caption.innerHTML = "";
        item.caption.appendChild(captCont);
    }
    item.style.height = "30px";
    item.innerTable.style.width = "100%";
        
    var closeButton = this.StandartSmallButton(null, null, null, "CloseForm.png");
    closeButton.style.position = "absolute";
    closeButton.style.top = "2px";
    closeButton.style.marginLeft = "-28px";
    closeButton.style.background = "white";
    closeButton.style.height = closeButton.style.width = "26px";
    closeButton.style.display = "none";
    closeButton.innerTable.style.width = "100%";
    item.innerTable.addCell(closeButton).style.position = "relative";

    closeButton.onmouseenter = function () {
        if (!this.isEnabled || this.jsObject.options.isTouchClick) return;
        this.className = this.styles["over"] + (this.jsObject.options.isTouchDevice ? "_Touch" : "_Mouse");
        this.isOver = true;
        closeButton.style.background = "lightgray";
    }

    closeButton.onmouseleave = function () {
        this.isOver = false;
        if (!this.isEnabled) return;
        this.className = (this.isSelected ? this.styles["selected"] : this.styles["default"]) + (this.jsObject.options.isTouchDevice ? "_Touch" : "_Mouse");
        this.style.background = "white";
    }

    closeButton.action = function () {
        item.closeButtonAction = true;
        item.remove();
    }

    item.onmousedown = function (event) {
        if (this.isTouchStartFlag || container.editableItem == this) return;
        if (event) event.preventDefault();
        var options = this.jsObject.options;

        if (options.controlsIsFocused && options.controlsIsFocused.action) {
            options.controlsIsFocused.blur();
            options.controlsIsFocused = null;
        }

        if (this.itemObject && event.button != 2 && !options.controlsIsFocused) {
            var itemInDragObject = this.jsObject.TreeItemForDragDrop({ name: caption, typeIcon: imageName ? imageName.replace(".png", "") : "" }, null, !imageName);
            if (itemInDragObject.button.captionCell) itemInDragObject.button.captionCell.style.padding = "3px 15px 3px 5px";
            if (itemInDragObject.button.imageCell) itemInDragObject.button.imageCell.style.padding = "2px 5px 2px 5px";
            itemInDragObject.originalItem = item;
            itemInDragObject.beginingOffset = 0;
            options.itemInDrag = itemInDragObject;
        }
    }

    item.onmouseup = function (event) {
        if (container.editableItem == this) return;
        if (event.button == 2) {
            item.action();
        }
    }

    item.action = function () {
        if (!item.closeButtonAction) item.select();
        item.closeButtonAction = false;
    }

    item.remove = function () {
        if (container.selectedItem == this) {
            var prevItem = this.previousSibling;
            var nextItem = this.nextSibling;
            container.selectedItem = null;
            if (container.childNodes.length > 1) {
                if (nextItem) {
                    nextItem.setSelected(true);
                    container.selectedItem = nextItem;
                }
                else if (prevItem) {
                    prevItem.setSelected(true);
                    container.selectedItem = prevItem;
                }
            }
        }
        container.onRemove(container.getItemIndex(this));
        container.removeChild(this);        
        container.onAction("remove");
        container.updateHintText();
    }

    item.select = function () {
        if (container.selectedItem) container.selectedItem.setSelected(false);
        this.setSelected(true);
        container.selectedItem = this;
        container.onAction("select");
    }

    item.repaint = function (newCaption, newImage, newItemObject) {
        this.itemObject = newItemObject;

        if (newCaption != null && this.caption) {
            this.captionContainer.innerHTML = newCaption;
        }
        if (newImage != null && this.image && this.jsObject.options.images[newImage]) {
            this.image.src = this.jsObject.options.images[newImage];
        }
    }

    item.setEditable = function (state) {        
        if (state) {
            if (this.caption && this.itemObject && this.itemObject.name) {
                var textBox = this.jsObject.TextBox(null);
                this.captionContainer.innerHTML = "";
                this.captionContainer.appendChild(textBox);
                this.captionContainer.style.overflow = "visible";
                this.editableTextBox = textBox;
                textBox.value = this.itemObject.name;
                textBox.style.position = "absolute";
                textBox.style.width = (this.caption.offsetWidth - 15) + "px";
                textBox.style.left = "0px";
                textBox.style.top = "-10px";
                textBox.style.border = "0px";
                textBox.style.height = "20px";
                textBox.focus();
                container.editableItem = this;

                var this_ = this;
                textBox.action = function () {
                    this_.setEditable(false);
                    this_.jsObject.options.controlsIsFocused = null;
                }
            }
        }
        else {
            if (this.editableTextBox) {
                var nameChanged = this.itemObject.name != this.editableTextBox.value;
                if (nameChanged) {                    
                    var newObject = { name: this.editableTextBox.value };
                    if (container["checkColumnName"])
                        newObject = container.checkColumnName(newObject);

                    if (this.itemObject.alias && this.itemObject.name == this.itemObject.alias) {
                        this.itemObject.alias = newObject.name;
                    }
                    this.itemObject.name = newObject.name;
                    container.onAction("rename");
                }
                this.captionContainer.removeChild(this.editableTextBox);
                this.captionContainer.style.overflow = "hidden";
                this.captionContainer.innerHTML = this.jsObject.GetItemCaption(this.itemObject);
            }
            this.editableTextBox = null;
            container.editableItem = null;
        }        
    }
        
    item.onmouseenter = function () {
        if (!this.isEnabled || this.jsObject.options.isTouchClick) return;
        this.className = this.styles["over"] + (this.jsObject.options.isTouchDevice ? "_Touch" : "_Mouse");
        this.isOver = true;
        closeButton.style.display = "";
    }

    item.onmouseleave = function () {
        this.isOver = false;
        if (!this.isEnabled) return;
        this.className = (this.isSelected ? this.styles["selected"] : this.styles["default"]) + (this.jsObject.options.isTouchDevice ? "_Touch" : "_Mouse");
        closeButton.style.display = "none";
    }

    return item;
}
