﻿
StiMobileDesigner.prototype.InitializeEditRegionMapElementForm_ = function () {
    var form = this.DashboardBaseForm("editRegionMapElementForm", this.loc.Components.StiMap, 1);
    form.isDockableToComponent = true;
    form.buttonsSeparator.style.display = "none";
    form.buttonsPanel.style.display = "none";
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    var jsObject = this;

    var controlsTable = this.CreateHTMLTable();
    form.container.appendChild(controlsTable);
    form.container.style.padding = "0 0 6px 0";

    //Data From
    var dataFromControl = this.DropDownList(null, 200, null, this.GetChoroplethDataTypesItems(), true);
    form.addControlRow(controlsTable, this.loc.Adapters.AdapterConnection.replace("{0}", ""), "dataFrom", dataFromControl, "12px");

    dataFromControl.action = function () {
        form.updateControlsVisibleStates();
        form.applyPropertiesToRegionMapElement();
    }

    //DataColumns
    var dataColumns = [
        ["key", this.loc.PropertyMain.Key, 90],
        ["name", this.loc.PropertyMain.Name, 130],
        ["value", this.loc.PropertyMain.Value, 90],
        ["group", this.loc.PropertyEnum.StiMapTypeGroup, 90],
        ["color", this.loc.PropertyMain.Color, 90]
    ];

    for (var i = 0; i < dataColumns.length; i++) {
        var container = this.DashboardDataColumnContainer(form, dataColumns[i][0], dataColumns[i][1]);
        container.allowSelected = true;
        form.addControlRow(controlsTable, null, dataColumns[i][0] + "DataColumn", container, "0px 12px 0 12px");
        form.controls[dataColumns[i][0] + "DataColumnRow"].style.display = "none";

        container.action = function () {
            if (!this.dataColumnObject) {
                form.controls.expression.currentContainer = null;
                form.controls.expression.setEnabled(false);
            }
            form.applyDataColumnPropertyToRegionMapElement(this);
        }

        container.onSelected = function () {
            for (var i = 0; i < dataColumns.length; i++) {
                if (form.controls[dataColumns[i][0] + "DataColumn"] != this)
                    form.controls[dataColumns[i][0] + "DataColumn"].setSelected(false);
            }

            if (this.dataColumnObject && this.dataColumnObject.expression != null) {
                form.controls.expression.currentContainer = this;
                form.controls.expression.setEnabled(true);
                form.controls.expression.textBox.value = Base64.decode(this.dataColumnObject.expression);
            }
        }
    }

    //DataGrid
    var dataGridView = document.createElement("div");
    dataGridView.headers = {};
    dataGridView.columns = {};
    dataGridView.className = "stiMapManualContainer";
    dataGridView.style.height = "254px";
    form.addControlRow(controlsTable, null, "dataGridView", dataGridView, "0 12px 0 12px");

    var dataGridHeader = this.CreateHTMLTable();
    dataGridHeader.className = "stiMapDataGridHeader";
    var dataGridTable = this.CreateHTMLTable();
    dataGridTable.className = "stiMapDataGrid";
    dataGridView.appendChild(dataGridHeader);
    var scrollContainer = document.createElement("div");
    scrollContainer.style.height = "232px";
    scrollContainer.className = "stiMapScrollContainer";
    dataGridView.appendChild(scrollContainer);
    scrollContainer.appendChild(dataGridTable);

    for (var i = 0; i < dataColumns.length; i++) {
        var headerCell = dataGridHeader.addTextCell(dataColumns[i][1]);
        headerCell.style.width = (dataColumns[i][2] + 4) + "px";
        dataGridView.headers[dataColumns[i][0]] = headerCell;

        var columnCell = dataGridTable.addCell();
        columnCell.style.width = "1px";
        dataGridView.columns[dataColumns[i][0]] = columnCell;
    }

    dataGridView.fillData = function (data) {
        //clear columns
        for (var i = 0; i < dataColumns.length; i++) {
            while (dataGridView.columns[dataColumns[i][0]].childNodes[0])
                dataGridView.columns[dataColumns[i][0]].removeChild(dataGridView.columns[dataColumns[i][0]].childNodes[0]);
        }

        //add new data
        if (data) {
            for (var i = 0; i < data.length; i++) {
                for (var k = 0; k < dataColumns.length; k++) {
                    var textBox = jsObject.TextBox(null, dataColumns[k][2]);
                    if (dataColumns[k][0] == "key") textBox.readOnly = true;
                    dataGridView.columns[dataColumns[k][0]].appendChild(textBox);
                    textBox.style.borderLeft = "0";
                    textBox.style.borderTop = "0";
                    if (data[i][dataColumns[k][0]]) textBox.value = data[i][dataColumns[k][0]];
                    textBox.rowIndex = i;
                    textBox.columnName = dataColumns[k][0];

                    textBox.action = function () {
                        form.sendCommand(
                            {
                                command: "UpdateMapData",
                                rowIndex: this.rowIndex,
                                columnName: this.columnName,
                                textValue: this.value
                            },
                            function (answer) {
                                form.updateControls(answer.elementProperties);
                                form.updateSvgContent(answer.elementProperties.svgContent);
                            }
                        );
                    }
                }
            }
        }
    }
    
    //Map ID
    var mapIDControl = this.MapIDControl("editREgionMapFormMapID", 450);
    form.addControlRow(controlsTable, null, "mapID", mapIDControl, "12px 12px 6px 12px");

    mapIDControl.action = function () {
        form.applyPropertiesToRegionMapElement(true);
    }
    
    var expressionControl = this.ExpressionControlWithMenu(null, 200, null, null);
    var mapExpressionMenu = this.options.menus.mapExpressionMenu || this.InitializeExpressionMenu("mapExpressionMenu", expressionControl, form);
    mapExpressionMenu.parentButton = expressionControl.button;
    form.addControlRow(controlsTable, this.loc.PropertyMain.Expression, "expression", expressionControl, "6px 12px 6px 12px");
    expressionControl.menu = mapExpressionMenu;
    
    expressionControl.action = function () {
        if (this.currentContainer) {
            form.applyExpressionPropertyToRegionMapElement(this.currentContainer, this.textBox.value);
        }
    }

    //Map Type
    var mapTypeControl = this.DropDownList(null, 200, null, this.GetChoroplethMapTypesItems(), true);
    form.addControlRow(controlsTable, this.loc.PropertyMain.MapType, "mapType", mapTypeControl, "6px 12px 6px 12px");

    mapTypeControl.action = function () {
        form.updateControlsVisibleStates();
        form.applyPropertiesToRegionMapElement();
    }

    dataGridView.updateColumnsState = function () {
        dataGridView.headers.color.style.display = dataGridView.columns.color.style.display = mapTypeControl.key == "Individual" ? "" : "none";
        dataGridView.headers.group.style.display = dataGridView.columns.group.style.display = mapTypeControl.key == "Group" || mapTypeControl.key == "HeatmapWithGroup" ? "" : "none";
    }

    //Display Name Type
    var displayNameTypeControl = this.DropDownList(null, 200, null, this.GetMapDisplayNameTypeItems(), true);
    form.addControlRow(controlsTable, this.loc.PropertyMain.DisplayNameType, "displayNameType", displayNameTypeControl, "6px 12px 6px 12px");

    displayNameTypeControl.action = function () {
        form.applyPropertiesToRegionMapElement();
    }

    //Show Value
    var showValueCheckBox = this.CheckBox(null, this.loc.PropertyMain.ShowValue);
    form.addControlRow(controlsTable, " ", "showValue", showValueCheckBox, "8px 12px 8px 12px");

    showValueCheckBox.action = function () {
        form.applyPropertiesToRegionMapElement();
    }

    //Color Each
    var colorEachCheckBox = this.CheckBox(null, this.loc.PropertyMain.ColorEach);
    form.addControlRow(controlsTable, " ", "colorEach", colorEachCheckBox, "8px 12px 8px 12px");

    colorEachCheckBox.action = function () {
        form.applyPropertiesToRegionMapElement();
    }

    form.setValues = function () {
        mapTypeControl.setKey(this.mapProperties.mapType);
        mapIDControl.setKey(this.mapProperties.mapID);
        displayNameTypeControl.setKey(this.mapProperties.displayNameType);
        showValueCheckBox.setChecked(this.mapProperties.showValue);
        colorEachCheckBox.setChecked(this.mapProperties.colorEach);
        dataFromControl.setKey(this.mapProperties.dataFrom);
        dataGridView.fillData(this.mapProperties.mapData);
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);

        var meters = this.mapProperties.meters;

        var meterTypes = ["Key", "Name", "Value", "Color", "Group"];
        for (var i = 0; i < meterTypes.length; i++) {
            var meter = meters["Sti" + meterTypes[i] + "MapMeter"];
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];

            if (meter) {
                container.addColumn(meter.label, meter);
                if (container.isSelected && container.item) container.item.action();
            }
            else
                container.clear();
        }
    }

    form.getValues = function () {
        props = {
            mapType: mapTypeControl.key,
            mapID: mapIDControl.key,
            showValue: showValueCheckBox.isChecked,
            colorEach: colorEachCheckBox.isChecked,
            displayNameType: displayNameTypeControl.key,
            mapData: {},
            dataFrom: dataFromControl.key
        }

        return props;
    }

    form.updateControlsVisibleStates = function () {
        this.controls.keyDataColumnRow.style.display = dataFromControl.key == "DataColumns" ? "" : "none";
        this.controls.nameDataColumnRow.style.display = dataFromControl.key == "DataColumns" ? "" : "none";
        this.controls.valueDataColumnRow.style.display = dataFromControl.key == "DataColumns" ? "" : "none";
        this.controls.groupDataColumnRow.style.display = dataFromControl.key == "DataColumns" && (mapTypeControl.key == "Group" || mapTypeControl.key == "HeatmapWithGroup") ? "" : "none";
        this.controls.colorDataColumnRow.style.display = dataFromControl.key == "DataColumns" && mapTypeControl.key == "Individual" ? "" : "none";
        this.controls.expressionRow.style.display = dataFromControl.key == "DataColumns" ? "" : "none";
        this.controls.colorEachRow.style.display = mapTypeControl.key == "Individual" ? "" : "none";
        dataGridView.style.display = dataFromControl.key == "Manual" ? "" : "none";
        dataGridView.updateColumnsState();
    }

    form.onshow = function () {
        form.currentPanelName = form.jsObject.options.propertiesPanel.getCurrentPanelName();
        form.jsObject.options.propertiesPanel.showContainer("Dictionary");
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);
        form.controls.colorEachRow.style.display = "none";

        var meterTypes = ["Key", "Name", "Value", "Color", "Group"];
        for (var i = 0; i < meterTypes.length; i++) {
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];
            container.clear();
            this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumnRow"].style.display = "none";
        }

        form.sendCommand({ command: "GetRegionMapElementProperties" },
            function (answer) {
                form.updateControls(answer.elementProperties);
            }
        );
    }

    form.onhide = function () {
        form.jsObject.options.propertiesPanel.showContainer(form.currentPanelName);
    }

    form.updateControls = function (mapProperties) {
        form.mapProperties = mapProperties;
        form.setValues();
        form.updateControlsVisibleStates();
        for (var propName in mapProperties) {
            form.currentRegionMapElement.properties[propName] = mapProperties[propName];
        }
    }

    form.applyPropertiesToRegionMapElement = function (updateMapData) {
        form.sendCommand(
            {
                command: "SetProperties",
                properties: form.getValues(),
                updateMapData: updateMapData
            },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                if (updateMapData) {
                    jsObject.RemoveStylesFromCache(answer.elementProperties.name);
                    jsObject.options.homePanel.updateControls();
                }
            }
        );
    }

    form.applyDataColumnPropertyToRegionMapElement = function (container) {
        form.sendCommand(
            {
                command: "SetDataColumn",
                containerName: form.jsObject.UpperFirstChar(container.name),
                dataColumnObject: container.dataColumnObject
            },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                if (container.item) container.item.action();
            }
        );
    }

    form.applyExpressionPropertyToRegionMapElement = function (container, expressionValue) {
        if (container) {
            form.sendCommand(
                {
                    command: "SetExpression",
                    containerName: form.jsObject.UpperFirstChar(container.name),
                    expressionValue: Base64.encode(expressionValue)
                },
                function (answer) {
                    form.updateControls(answer.elementProperties);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                }
            );
        }
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        updateParameters.zoom = form.jsObject.options.report.zoom.toString();

        form.jsObject.SendCommandToDesignerServer("UpdateRegionMapElement",
            {
                componentName: form.currentRegionMapElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    form.updateSvgContent = function (svgContent) {
        this.currentRegionMapElement.properties.svgContent = svgContent;
        this.currentRegionMapElement.repaint();
    }

    return form;
}