﻿
StiMobileDesigner.prototype.InitializeEditProgressElementForm_ = function () {
    var form = this.DashboardBaseForm("editProgressElementForm", this.loc.Components.StiProgress, 1);
    form.isDockableToComponent = true;
    form.buttonsSeparator.style.display = "none";
    form.buttonsPanel.style.display = "none";
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    var jsObject = this;

    var controlsTable = this.CreateHTMLTable();
    form.container.appendChild(controlsTable);
    form.container.style.padding = "0 0 6px 0";

    //DataColumns
    var dataColumns = [
        ["value", this.loc.PropertyMain.Value],
        ["target", this.loc.PropertyMain.Target],
        ["series", this.loc.PropertyMain.Series]
    ];

    for (var i = 0; i < dataColumns.length; i++) {
        var container = this.DashboardDataColumnContainer(form, dataColumns[i][0], dataColumns[i][1]);
        container.allowSelected = true;
        form.addControlRow(controlsTable, null, dataColumns[i][0] + "DataColumn", container, "0px 12px 0px 12px");

        container.action = function () {
            if (!this.dataColumnObject) {
                form.controls.expression.currentContainer = null;
                form.controls.expression.setEnabled(false);
            }
            form.applyDataColumnPropertyToProgressElement(this);
        }

        container.onSelected = function () {
            for (var i = 0; i < dataColumns.length; i++) {
                if (form.controls[dataColumns[i][0] + "DataColumn"] != this)
                    form.controls[dataColumns[i][0] + "DataColumn"].setSelected(false);
            }

            if (this.dataColumnObject && this.dataColumnObject.expression != null) {
                form.controls.expression.currentContainer = this;
                form.controls.expression.setEnabled(true);
                form.controls.expression.textBox.value = Base64.decode(this.dataColumnObject.expression);
            }
        }
    }

    var parentValueContainer = form.controls.valueDataColumn.innerContainer.parentElement;
    
    var expressionControl = this.ExpressionControlWithMenu(null, 160, null, null);
    var progressExpressionMenu = this.options.menus.progressExpressionMenu || this.InitializeExpressionMenu("progressExpressionMenu", expressionControl, form);
    expressionControl.menu = progressExpressionMenu;
    progressExpressionMenu.parentButton = expressionControl.button;
    form.addControlRow(controlsTable, this.loc.PropertyMain.Expression, "expression", expressionControl, "12px 12px 6px 12px");
    form.controls.expressionText.style.paddingTop = "6px";

    expressionControl.action = function () {
        if (this.currentContainer) {
            form.applyExpressionPropertyToProgressElement(this.currentContainer, this.textBox.value);
        }
    }

    //Mode Types
    var modeTypes = ["Circle", "Pie", "DataBars"];
    var modeTypesTable = this.CreateHTMLTable();
    modeTypesTable.buttons = {};
    for (var i = 0; i < modeTypes.length; i++) {
        var button = this.SmallImageButtonWithBorder(null, null, "Dashboards.Progress." + modeTypes[i] + ".png", this.loc.PropertyEnum["StiProgressElementMode" + modeTypes[i]]);
        button.modeType = modeTypes[i];
        button.style.marginRight = "5px";
        modeTypesTable.addCell(button);
        modeTypesTable.buttons[modeTypes[i]] = button;

        button.action = function () {
            this.select();
            form.sendCommand({ command: "SetPropertyValue", propertyName: "Mode", propertyValue: this.modeType },
                function (answer) {
                    form.updateControls(answer.elementProperties);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                    jsObject.RemoveStylesFromCache(answer.elementProperties.name);
                    jsObject.options.homePanel.updateControls();
                }
            );
        }

        button.select = function () {
            for (var name in modeTypesTable.buttons) {
                modeTypesTable.buttons[name].setSelected(false);
            }
            this.setSelected(true);
        }
    }
    form.addControlRow(controlsTable, this.loc.PropertyMain.Mode, "modeTypesTable", modeTypesTable, "6px 12px 6px 12px");

    form.setValues = function () {
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);
        if (modeTypesTable.buttons[this.progressProperties.mode]) {
            modeTypesTable.buttons[this.progressProperties.mode].select();
        }

        var meters = this.progressProperties.meters;
        
        var meterTypes = ["Value", "Target", "Series"];
        for (var i = 0; i < meterTypes.length; i++) {
            var meter = meters["Sti" + meterTypes[i] + "ProgressMeter"];
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];

            if (meter) {
                container.addColumn(meter.label, meter);
                if (container.isSelected && container.item) container.item.action();
            }
            else
                container.clear();
        }
    }

    form.checkStartMode = function () {
        var itemsCount = 0;
        for (var i = 0; i < dataColumns.length; i++) {
            var container = form.controls[dataColumns[i][0] + "DataColumn"];
            if (container.dataColumnObject) itemsCount++;
        }

        var valueContainer = form.controls.valueDataColumn.innerContainer;

        if (itemsCount == 0) {
            form.container.appendChild(valueContainer);
            controlsTable.style.display = "none";
            valueContainer.style.height = valueContainer.style.maxHeight = "260px";
            valueContainer.style.width = "267px";
            valueContainer.style.margin = "6px 12px 6px 12px";
        }
        else {
            parentValueContainer.appendChild(valueContainer);
            controlsTable.style.display = "";
            valueContainer.style.height = "30px";
            valueContainer.style.width = "auto";
            valueContainer.style.margin = "0";
        }
    }

    form.onshow = function () {
        form.currentPanelName = form.jsObject.options.propertiesPanel.getCurrentPanelName();
        form.jsObject.options.propertiesPanel.showContainer("Dictionary");
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);
        var meterTypes = ["Value", "Target", "Series"];
        for (var i = 0; i < meterTypes.length; i++) {
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];
            container.clear();
        }
        form.checkStartMode();

        form.sendCommand({ command: "GetProgressElementProperties" },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.checkStartMode();
            }
        );
    }

    form.onhide = function () {
        form.jsObject.options.propertiesPanel.showContainer(form.currentPanelName);
    }

    form.updateControls = function (progressElement) {
        form.progressProperties = progressElement;
        form.setValues();
    }

    form.applyExpressionPropertyToProgressElement = function (container, expressionValue) {
        if (container) {
            form.sendCommand(
                {
                    command: "SetExpression",
                    containerName: form.jsObject.UpperFirstChar(container.name),
                    expressionValue: Base64.encode(expressionValue)
                },
                function (answer) {
                    form.updateControls(answer.elementProperties);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                }
            );
        }
    }

    form.applyDataColumnPropertyToProgressElement = function (container) {
        form.sendCommand(
            {
                command: "SetDataColumn",
                containerName: form.jsObject.UpperFirstChar(container.name),
                dataColumnObject: container.dataColumnObject
            },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                if (container.item) container.item.action();
                form.checkStartMode();
            }
        );
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        updateParameters.zoom = form.jsObject.options.report.zoom.toString();

        form.jsObject.SendCommandToDesignerServer("UpdateProgressElement",
            {
                componentName: form.currentProgressElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    form.updateSvgContent = function (svgContent) {
        this.currentProgressElement.properties.svgContent = svgContent;
        this.currentProgressElement.repaint();
    }

    return form;
}