﻿
StiMobileDesigner.prototype.InitializeEditOnlineMapElementForm_ = function () {
    var form = this.DashboardBaseForm("editOnlineMapElementForm", this.loc.Components.StiMap, 1);
    form.isDockableToComponent = true;
    form.buttonsSeparator.style.display = "none";
    form.buttonsPanel.style.display = "none";
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    var jsObject = this;

    var controlsTable = this.CreateHTMLTable();
    form.container.appendChild(controlsTable);
    form.container.style.padding = "0 0 6px 0";

    //OnlineDataColumns
    var dataColumns = [
        ["latitude", this.loc.PropertyMain.Latitude],
        ["longitude", this.loc.PropertyMain.Longitude]
    ];

    for (var i = 0; i < dataColumns.length; i++) {
        var container = this.DashboardDataColumnContainer(form, dataColumns[i][0], dataColumns[i][1]);
        container.allowSelected = true;
        form.addControlRow(controlsTable, null, dataColumns[i][0] + "DataColumn", container, "0px 12px " + (i == dataColumns.length - 1 ? "12px" : "0px") + " 12px");

        container.action = function () {
            if (!this.dataColumnObject) {
                form.controls.expression.currentContainer = null;
                form.controls.expression.setEnabled(false);
            }
            form.applyDataColumnPropertyToOnlineMapElement(this);
        }

        container.onSelected = function () {
            for (var i = 0; i < dataColumns.length; i++) {
                if (form.controls[dataColumns[i][0] + "DataColumn"] != this)
                    form.controls[dataColumns[i][0] + "DataColumn"].setSelected(false);
            }

            if (this.dataColumnObject && this.dataColumnObject.expression != null) {
                form.controls.expression.currentContainer = this;
                form.controls.expression.setEnabled(true);
                form.controls.expression.textBox.value = Base64.decode(this.dataColumnObject.expression);
            }
        }
    }

    var parentLatitudeContainer = form.controls.latitudeDataColumn.innerContainer.parentElement;

    var expressionControl = this.ExpressionControlWithMenu(null, 200, null, null);
    var onlineMapExpressionMenu = this.options.menus.onlineMapExpressionMenu || this.InitializeExpressionMenu("onlineMapExpressionMenu", expressionControl, form);
    onlineMapExpressionMenu.parentButton = expressionControl.button;
    expressionControl.menu = onlineMapExpressionMenu;
    form.addControlRow(controlsTable, this.loc.PropertyMain.Expression, "expression", expressionControl, "6px 12px 6px 12px");

    expressionControl.action = function () {
        if (this.currentContainer) {
            form.applyExpressionPropertyToOnlineMapElement(this.currentContainer, this.textBox.value);
        }
    }

    form.setValues = function () {
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);

        var meters = this.onlineMapProperties.meters;

        var meterTypes = ["Latitude", "Longitude"];
        for (var i = 0; i < meterTypes.length; i++) {
            var meter = meters["Sti" + meterTypes[i] + "MapMeter"];
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];

            if (meter) {
                container.addColumn(meter.label, meter);
                if (container.isSelected && container.item) container.item.action();
            }
            else
                container.clear();
        }
    }

    form.checkStartMode = function () {
        var itemsCount = 0;
        for (var i = 0; i < dataColumns.length; i++) {
            var container = form.controls[dataColumns[i][0] + "DataColumn"];
            if (container.dataColumnObject) itemsCount++;
        }

        var latitudeContainer = form.controls.latitudeDataColumn.innerContainer;

        if (itemsCount == 0) {
            form.container.appendChild(latitudeContainer);
            controlsTable.style.display = "none";
            latitudeContainer.style.height = latitudeContainer.style.maxHeight = "260px";
            latitudeContainer.style.width = "267px";
            latitudeContainer.style.margin = "6px 12px 6px 12px";
        }
        else {
            parentLatitudeContainer.appendChild(latitudeContainer);
            controlsTable.style.display = "";
            latitudeContainer.style.height = "30px";
            latitudeContainer.style.width = "auto";
            latitudeContainer.style.margin = "0";
        }
    }

    form.onshow = function () {
        form.currentPanelName = form.jsObject.options.propertiesPanel.getCurrentPanelName();
        form.jsObject.options.propertiesPanel.showContainer("Dictionary");
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);
        var meterTypes = ["Latitude", "Longitude"];
        for (var i = 0; i < meterTypes.length; i++) {
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];
            container.clear();
        }
        form.checkStartMode();

        form.sendCommand({ command: "GetOnlineMapElementProperties" },
            function (answer) {
                form.updateControls(answer.elementProperties, true);
                form.checkStartMode();
            }
        );
    }

    form.onhide = function () {
        form.jsObject.options.propertiesPanel.showContainer(form.currentPanelName);
    }

    form.updateControls = function (onlineMapProperties, notRepaintElement) {
        form.onlineMapProperties = onlineMapProperties;
        form.setValues();      
        if (!notRepaintElement) {
            form.currentOnlineMapElement.properties.svgContent = onlineMapProperties.svgContent;
            form.currentOnlineMapElement.repaint();
        }
    }

    form.applyDataColumnPropertyToOnlineMapElement = function (container) {
        form.sendCommand(
            {
                command: "SetDataColumn",
                containerName: form.jsObject.UpperFirstChar(container.name),
                dataColumnObject: container.dataColumnObject
            },
            function (answer) {
                form.updateControls(answer.elementProperties);
                if (container.item) container.item.action();
                form.checkStartMode();
            }
        );
    }

    form.applyExpressionPropertyToOnlineMapElement = function (container, expressionValue) {
        if (container) {
            form.sendCommand(
                {
                    command: "SetExpression",
                    containerName: form.jsObject.UpperFirstChar(container.name),
                    expressionValue: Base64.encode(expressionValue)
                },
                function (answer) {
                    form.updateControls(answer.elementProperties);
                }
            );
        }
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        updateParameters.zoom = form.jsObject.options.report.zoom.toString();

        form.jsObject.SendCommandToDesignerServer("UpdateOnlineMapElement",
            {
                componentName: form.currentOnlineMapElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    return form;
}


