﻿
StiMobileDesigner.prototype.InitializeEditListBoxElementForm_ = function () {
    var form = this.DashboardBaseForm("editListBoxElementForm", this.loc.Components.StiListBox, 1);
    form.isDockableToComponent = true;
    form.buttonsSeparator.style.display = "none";
    form.buttonsPanel.style.display = "none";
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    var jsObject = this;

    var controlsTable = this.CreateHTMLTable();
    form.container.appendChild(controlsTable);
    form.container.style.padding = "0 0 6px 0";

    //DataColumns
    var dataColumns = [
        ["key", this.loc.PropertyMain.Key],
        ["name", this.loc.PropertyMain.Name]
    ];

    for (var i = 0; i < dataColumns.length; i++) {
        var container = this.DashboardDataColumnContainer(form, dataColumns[i][0], dataColumns[i][1]);
        container.allowSelected = true;
        form.addControlRow(controlsTable, null, dataColumns[i][0] + "DataColumn", container, "0px 12px " + (i == dataColumns.length - 1 ? "12px" : "0px" + " 12px"));       

        container.action = function () {
            //if (!this.dataColumnObject) {
            //    form.controls.expression.currentContainer = null;
            //    form.controls.expression.setEnabled(false);
            //}
            form.applyDataColumnPropertyToListBoxElement(this);
        }

        container.onSelected = function () {
            for (var i = 0; i < dataColumns.length; i++) {
                if (form.controls[dataColumns[i][0] + "DataColumn"] != this)
                    form.controls[dataColumns[i][0] + "DataColumn"].setSelected(false);
            }
            //if (this.dataColumnObject && this.dataColumnObject.expression != null) {
            //    form.controls.expression.currentContainer = this;
            //    form.controls.expression.setEnabled(true);
            //    form.controls.expression.textBox.value = Base64.decode(this.dataColumnObject.expression);
            //}
        }
    }

    var parentKeyContainer = form.controls.keyDataColumn.innerContainer.parentElement;

    //Expression
    //var expressionControl = this.ExpressionControlWithMenu(null, 160, null, null);
    //var gaugeExpressionMenu = this.options.menus.gaugeExpressionMenu || this.InitializeExpressionMenu("gaugeExpressionMenu", expressionControl, form);
    //expressionControl.menu = gaugeExpressionMenu;
    //gaugeExpressionMenu.parentButton = expressionControl.button;
    //form.addControlRow(controlsTable, this.loc.PropertyMain.Expression, "expression", expressionControl, "6px 12px 6px 12px");

    //expressionControl.action = function () {
    //    if (this.currentContainer) {
    //        form.applyExpressionPropertyToGaugeElement(this.currentContainer, this.textBox.value);
    //    }
    //}

    //SelectionMode
    var selectionMode = this.DropDownList(null, 155, null, this.GetSelectionModeItems(), true, null, null, true)
    form.addControlRow(controlsTable, this.loc.PropertyMain.SelectionMode, "selectionMode", selectionMode, "6px 12px 6px 12px");
    selectionMode.action = function () {
        form.applyPropertiesToListBoxElement("SelectionMode", this.key);
    }

    //ShowSelectAll
    var showSelectAll = this.CheckBox(null, this.loc.PropertyMain.ShowSelectAll);
    form.addControlRow(controlsTable, " ", "showSelectAll", showSelectAll, "6px 12px 12px 12px");
    showSelectAll.action = function () {
        form.applyPropertiesToListBoxElement("ShowSelectAll", this.isChecked);
    }

    form.setValues = function () {
        //expressionControl.textBox.value = "";
        //expressionControl.setEnabled(false);
        selectionMode.setKey(this.listBoxProperties.selectionMode);
        showSelectAll.setChecked(this.listBoxProperties.showSelectAll);

        var meters = this.listBoxProperties.meters;        
        var meterTypes = ["Key", "Name"];
        for (var i = 0; i < meterTypes.length; i++) {
            var meter = meters["Sti" + meterTypes[i] + "ListBoxMeter"];
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];

            if (meter) {
                container.addColumn(meter.label, meter);
                if (container.isSelected && container.item) container.item.action();
            }
            else
                container.clear();
        }
    }

    form.checkStartMode = function () {
        var itemsCount = 0;
        for (var i = 0; i < dataColumns.length; i++) {
            var container = form.controls[dataColumns[i][0] + "DataColumn"];
            if (container.dataColumnObject) itemsCount++;
        }

        var keyContainer = form.controls.keyDataColumn.innerContainer;

        if (itemsCount == 0) {
            form.container.appendChild(keyContainer);
            controlsTable.style.display = "none";
            keyContainer.style.height = keyContainer.style.maxHeight = "210px";
            keyContainer.style.width = "267px";
            keyContainer.style.margin = "6px 12px 6px 12px";
        }
        else {
            parentKeyContainer.appendChild(keyContainer);
            controlsTable.style.display = "";
            keyContainer.style.height = "30px";
            keyContainer.style.width = "auto";
            keyContainer.style.margin = "0";
        }
    }

    form.onshow = function () {
        form.currentPanelName = form.jsObject.options.propertiesPanel.getCurrentPanelName();
        form.jsObject.options.propertiesPanel.showContainer("Dictionary");
        //expressionControl.textBox.value = "";
        //expressionControl.setEnabled(false);
        var meterTypes = ["Key", "Name"];
        for (var i = 0; i < meterTypes.length; i++) {
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];
            container.clear();
        }
        form.checkStartMode();

        form.sendCommand({ command: "GetListBoxElementProperties" },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.checkStartMode();
            }
        );
    }

    form.onhide = function () {
        form.jsObject.options.propertiesPanel.showContainer(form.currentPanelName);
    }

    form.updateControls = function (listBoxProperties) {
        if (!listBoxProperties) return;
        form.listBoxProperties = listBoxProperties;
        form.setValues();
    }

    //form.applyExpressionPropertyToListBoxElement = function (container, expressionValue) {
    //    if (container) {
    //        form.sendCommand(
    //            {
    //                command: "SetExpression",
    //                containerName: form.jsObject.UpperFirstChar(container.name),
    //                expressionValue: Base64.encode(expressionValue)
    //            },
    //            function (answer) {
    //                form.updateControls(answer.elementProperties);
    //                form.updateSvgContent(answer.elementProperties.svgContent);
    //            }
    //        );
    //    }
    //}

    form.applyDataColumnPropertyToListBoxElement = function (container) {
        form.sendCommand(
            {
                command: "SetDataColumn",
                containerName: form.jsObject.UpperFirstChar(container.name),
                dataColumnObject: container.dataColumnObject
            },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                if (container.item) container.item.action();
                form.checkStartMode();
            }
        );
    }

    form.applyPropertiesToListBoxElement = function (propertyName, propertyValue) {
        form.sendCommand({ command: "SetPropertyValue", propertyName: propertyName, propertyValue: propertyValue },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                //jsObject.RemoveStylesFromCache(answer.elementProperties.name);
                //jsObject.options.homePanel.updateControls();
            }
        );
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        updateParameters.zoom = form.jsObject.options.report.zoom.toString();

        form.jsObject.SendCommandToDesignerServer("UpdateListBoxElement",
            {
                componentName: form.currentListBoxElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    form.updateSvgContent = function (svgContent) {
        this.currentListBoxElement.properties.svgContent = svgContent;
        this.currentListBoxElement.repaint();
    }

    return form;
}