﻿
StiMobileDesigner.prototype.InitializeEditIndicatorElementForm_ = function () {
    var form = this.DashboardBaseForm("editIndicatorElementForm", this.loc.Components.StiIndicator, 1);
    form.isDockableToComponent = true;
    form.buttonsSeparator.style.display = "none";
    form.buttonsPanel.style.display = "none";
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    var jsObject = this;

    var controlsTable = this.CreateHTMLTable();
    form.container.appendChild(controlsTable);
    form.container.style.padding = "0 0 6px 0";

    //DataColumns
    var dataColumns = [
        ["value", this.loc.PropertyMain.Value],
        ["target", this.loc.PropertyMain.Target],
        ["series", this.loc.PropertyMain.Series]
    ];

    for (var i = 0; i < dataColumns.length; i++) {
        var container = this.DashboardDataColumnContainer(form, dataColumns[i][0], dataColumns[i][1]);
        container.allowSelected = true;
        form.addControlRow(controlsTable, null, dataColumns[i][0] + "DataColumn", container, "0px 12px " + (i == dataColumns.length - 1 ? "6px" : "0px" + " 12px"));

        container.action = function () {
            if (!this.dataColumnObject) {
                form.controls.expression.currentContainer = null;
                form.controls.expression.setEnabled(false);
            }
            form.applyDataColumnPropertyToIndicatorElement(this);
        }

        container.onSelected = function () {
            for (var i = 0; i < dataColumns.length; i++) {
                if (form.controls[dataColumns[i][0] + "DataColumn"] != this)
                    form.controls[dataColumns[i][0] + "DataColumn"].setSelected(false);
            }

            if (this.dataColumnObject && this.dataColumnObject.expression != null) {
                form.controls.expression.currentContainer = this;
                form.controls.expression.setEnabled(true);
                form.controls.expression.textBox.value = Base64.decode(this.dataColumnObject.expression);
            }
        }
    }

    var parentValueContainer = form.controls.valueDataColumn.innerContainer.parentElement;
                
    var expressionControl = this.ExpressionControlWithMenu(null, 160, null, null);
    var indicatorExpressionMenu = this.options.menus.indicatorExpressionMenu || this.InitializeExpressionMenu("indicatorExpressionMenu", expressionControl, form);
    expressionControl.menu = indicatorExpressionMenu;
    indicatorExpressionMenu.parentButton = expressionControl.button;
    form.addControlRow(controlsTable, this.loc.PropertyMain.Expression, "expression", expressionControl, "12px 12px 6px 12px");
    form.controls.expressionText.style.paddingTop = "6px";

    expressionControl.action = function () {
        if (this.currentContainer) {
            form.applyExpressionPropertyToIndicatorElement(this.currentContainer, this.textBox.value);
        }
    }

    var iconControl = this.IconControl("indicatorFormIcon", 50);
    form.addControlRow(controlsTable, this.loc.PropertyMain.Icon, "icon", iconControl, "6px 12px 6px 12px");

    iconControl.action = function () {
        form.applyPropertyValueToIndicatorElement("Icon", this.key);
    }

    var iconSetControl = this.IconSetControl("indicatorFormIconSet", 160);
    form.addControlRow(controlsTable, this.loc.PropertyMain.IconSet, "iconSet", iconSetControl, "6px 12px 6px 12px");    

    iconSetControl.action = function () {
        form.applyPropertyValueToIndicatorElement("IconSet", this.key);
    }

    form.setValues = function () {
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);
        iconControl.setKey(this.indicatorProperties.icon);
        iconSetControl.setKey(this.indicatorProperties.iconSet);

        var meters = this.indicatorProperties.meters;
        
        var meterTypes = ["Value", "Target", "Series"];
        for (var i = 0; i < meterTypes.length; i++) {
            var meter = meters["Sti" + meterTypes[i] + "IndicatorMeter"];
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];

            if (meter) {
                container.addColumn(meter.label, meter);
                if (container.isSelected && container.item) container.item.action();
            }
            else
                container.clear();
        }
    }

    form.checkStartMode = function () {
        var itemsCount = 0;
        for (var i = 0; i < dataColumns.length; i++) {
            var container = form.controls[dataColumns[i][0] + "DataColumn"];
            if (container.dataColumnObject) itemsCount++;
        }

        var valueContainer = form.controls.valueDataColumn.innerContainer;

        if (itemsCount == 0) {
            form.container.appendChild(valueContainer);
            controlsTable.style.display = "none";
            valueContainer.style.height = valueContainer.style.maxHeight = "260px";
            valueContainer.style.width = "267px";
            valueContainer.style.margin = "6px 12px 6px 12px";
        }
        else {
            parentValueContainer.appendChild(valueContainer);
            controlsTable.style.display = "";
            valueContainer.style.height = "30px";
            valueContainer.style.width = "auto";
            valueContainer.style.margin = "0";
        }
    }

    form.onshow = function () {
        form.currentPanelName = form.jsObject.options.propertiesPanel.getCurrentPanelName();
        form.jsObject.options.propertiesPanel.showContainer("Dictionary");
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);
        var meterTypes = ["Value", "Target", "Series"];
        for (var i = 0; i < meterTypes.length; i++) {
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];
            container.clear();
        }
        form.checkStartMode();

        form.sendCommand({ command: "GetIndicatorElementProperties" },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.checkStartMode();
            }
        );
    }

    form.onhide = function () {
        form.jsObject.options.propertiesPanel.showContainer(form.currentPanelName);
    }

    form.updateControls = function (indicatorProperties) {
        form.indicatorProperties = indicatorProperties;
        form.setValues();
        form.controls.iconRow.style.display = form.controls.valueDataColumn.dataColumnObject && !form.controls.seriesDataColumn.dataColumnObject ? "" : "none";
        form.controls.iconSetRow.style.display = form.controls.valueDataColumn.dataColumnObject && form.controls.seriesDataColumn.dataColumnObject &&
            !form.controls.targetDataColumn.dataColumnObject ? "" : "none";
        iconControl.textBox.style.color = iconSetControl.textBox.style.color = indicatorProperties.styleColor;
    }

    form.applyPropertyValueToIndicatorElement = function (propertyName, propertyValue) {
        form.sendCommand(
            {
                command: "SetPropertyValue",
                propertyName: propertyName,
                propertyValue: propertyValue
            },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                jsObject.RemoveStylesFromCache(answer.elementProperties.name);
                jsObject.options.homePanel.updateControls();
            }
        );
    }

    form.applyExpressionPropertyToIndicatorElement = function (container, expressionValue) {
        if (container) {
            form.sendCommand(
                {
                    command: "SetExpression",
                    containerName: form.jsObject.UpperFirstChar(container.name),
                    expressionValue: Base64.encode(expressionValue)
                },
                function (answer) {
                    form.updateControls(answer.elementProperties);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                }
            );
        }
    }

    form.applyDataColumnPropertyToIndicatorElement = function (container) {
        form.sendCommand(
            {
                command: "SetDataColumn",
                containerName: form.jsObject.UpperFirstChar(container.name),
                dataColumnObject: container.dataColumnObject
            },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                if (container.item) container.item.action();
                form.checkStartMode();
            }
        );
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        updateParameters.zoom = form.jsObject.options.report.zoom.toString();

        form.jsObject.SendCommandToDesignerServer("UpdateIndicatorElement",
            {
                componentName: form.currentIndicatorElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    form.updateSvgContent = function (svgContent) {
        this.currentIndicatorElement.properties.svgContent = svgContent;
        this.currentIndicatorElement.repaint();
    }

    return form;
}