﻿
StiMobileDesigner.prototype.InitializeEditGaugeElementForm_ = function () {
    var form = this.DashboardBaseForm("editGaugeElementForm", this.loc.Components.StiGauge, 1);
    form.isDockableToComponent = true;
    form.buttonsSeparator.style.display = "none";
    form.buttonsPanel.style.display = "none";
    form.container.style.borderTop = "0px";
    form.caption.style.padding = "0px 10px 0 12px";
    var jsObject = this;

    var controlsTable = this.CreateHTMLTable();
    form.container.appendChild(controlsTable);
    form.container.style.padding = "0 0 6px 0";

    //DataColumns
    var dataColumns = [
        ["value", this.loc.PropertyMain.Value],
        ["series", this.loc.PropertyMain.Series]
    ];

    for (var i = 0; i < dataColumns.length; i++) {
        var container = this.DashboardDataColumnContainer(form, dataColumns[i][0], dataColumns[i][1]);
        container.allowSelected = true;
        form.addControlRow(controlsTable, null, dataColumns[i][0] + "DataColumn", container, "0px 12px " + (i == dataColumns.length - 1 ? "12px" : "0px" + " 12px"));       

        container.action = function () {
            if (!this.dataColumnObject) {
                form.controls.expression.currentContainer = null;
                form.controls.expression.setEnabled(false);
            }
            form.applyDataColumnPropertyToGaugeElement(this);
        }

        container.onSelected = function () {
            for (var i = 0; i < dataColumns.length; i++) {
                if (form.controls[dataColumns[i][0] + "DataColumn"] != this)
                    form.controls[dataColumns[i][0] + "DataColumn"].setSelected(false);
            }

            if (this.dataColumnObject && this.dataColumnObject.expression != null) {
                form.controls.expression.currentContainer = this;
                form.controls.expression.setEnabled(true);
                form.controls.expression.textBox.value = Base64.decode(this.dataColumnObject.expression);
            }
        }
    }

    var parentValueContainer = form.controls.valueDataColumn.innerContainer.parentElement;

    //Type
    var types = ["FullCircular", "HalfCircular", "Linear"];
    var typesTable = this.CreateHTMLTable();
    typesTable.buttons = {};
    for (var i = 0; i < types.length; i++) {
        var button = this.SmallImageButtonWithBorder(null, null, "Dashboards.Gauge." + types[i] + ".png", this.loc.PropertyEnum["StiGaugeType" + types[i]]);
        button.type = types[i];
        button.style.marginRight = "5px";
        typesTable.addCell(button);
        typesTable.buttons[types[i]] = button;

        button.action = function () {
            this.select();
            form.applyPropertiesToGaugeElement("Type", this.type);
        }

        button.select = function () {
            for (var name in typesTable.buttons) {
                typesTable.buttons[name].setSelected(false);
            }
            this.setSelected(true);
        }
    }
    form.addControlRow(controlsTable, this.loc.PropertyMain.Type, "typesTable", typesTable, "6px 12px 6px 12px");

    //Expression
    var expressionControl = this.ExpressionControlWithMenu(null, 160, null, null);
    var gaugeExpressionMenu = this.options.menus.gaugeExpressionMenu || this.InitializeExpressionMenu("gaugeExpressionMenu", expressionControl, form);
    expressionControl.menu = gaugeExpressionMenu;
    gaugeExpressionMenu.parentButton = expressionControl.button;
    form.addControlRow(controlsTable, this.loc.PropertyMain.Expression, "expression", expressionControl, "6px 12px 6px 12px");

    expressionControl.action = function () {
        if (this.currentContainer) {
            form.applyExpressionPropertyToGaugeElement(this.currentContainer, this.textBox.value);
        }
    }

    //CalculationMode
    var calculationMode = this.DropDownList(null, 100, null, this.GetGaugeCalculationModeItems(), true, null, null, true)
    form.addControlRow(controlsTable, this.loc.PropertyMain.Mode, "calculationMode", calculationMode, "6px 12px 6px 12px");
    calculationMode.action = function () {
        form.updateControlsVisibleStates();
        form.applyPropertiesToGaugeElement("CalculationMode", this.key);
    }

    //Min Max
    var minMaxTable = this.CreateHTMLTable();
    minMaxTable.addTextCell(this.loc.PropertyMain.Minimum).className = "stiDesignerTextContainer";
    minMaxTable.addCell();
    minMaxTable.addTextCell(this.loc.PropertyMain.Maximum).className = "stiDesignerTextContainer";

    var minControl = this.TextBoxEnumerator(null, 70);
    minMaxTable.addCellInNextRow(minControl);
    minControl.action = function () {
        form.applyPropertiesToGaugeElement("Minimum", this.textBox.value);
    }

    minMaxTable.addTextCellInLastRow(" - ").style.padding = "7px 5px 7px 5px";
    var maxControl = this.TextBoxEnumerator(null, 70);
    minMaxTable.addCellInLastRow(maxControl);
    maxControl.action = function () {
        form.applyPropertiesToGaugeElement("Maximum", this.textBox.value);
    }

    form.addControlRow(controlsTable, " ", "minMaxTable", minMaxTable, "6px 12px 6px 12px");

    form.setValues = function () {
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);
        if (typesTable.buttons[this.gaugeProperties.type]) {
            typesTable.buttons[this.gaugeProperties.type].select();
        }
        calculationMode.setKey(this.gaugeProperties.calculationMode);
        minControl.setValue(this.gaugeProperties.minimum);
        maxControl.setValue(this.gaugeProperties.maximum);

        var meters = this.gaugeProperties.meters;        
        var meterTypes = ["Value", "Series"];
        for (var i = 0; i < meterTypes.length; i++) {
            var meter = meters["Sti" + meterTypes[i] + "GaugeMeter"];
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];

            if (meter) {
                container.addColumn(meter.label, meter);
                if (container.isSelected && container.item) container.item.action();
            }
            else
                container.clear();
        }
    }

    form.checkStartMode = function () {
        var itemsCount = 0;
        for (var i = 0; i < dataColumns.length; i++) {
            var container = form.controls[dataColumns[i][0] + "DataColumn"];
            if (container.dataColumnObject) itemsCount++;
        }

        var valueContainer = form.controls.valueDataColumn.innerContainer;

        if (itemsCount == 0) {
            form.container.appendChild(valueContainer);
            controlsTable.style.display = "none";
            valueContainer.style.height = valueContainer.style.maxHeight = "260px";
            valueContainer.style.width = "259px";
            valueContainer.style.margin = "6px 12px 6px 12px";
        }
        else {
            parentValueContainer.appendChild(valueContainer);
            controlsTable.style.display = "";
            valueContainer.style.height = "30px";
            valueContainer.style.width = "auto";
            valueContainer.style.margin = "0";
        }
    }

    form.onshow = function () {
        form.currentPanelName = form.jsObject.options.propertiesPanel.getCurrentPanelName();
        form.jsObject.options.propertiesPanel.showContainer("Dictionary");
        expressionControl.textBox.value = "";
        expressionControl.setEnabled(false);
        var meterTypes = ["Value", "Series"];
        for (var i = 0; i < meterTypes.length; i++) {
            var container = this.controls[jsObject.LowerFirstChar(meterTypes[i]) + "DataColumn"];
            container.clear();
        }
        form.checkStartMode();

        form.sendCommand({ command: "GetGaugeElementProperties" },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.checkStartMode();
            }
        );
    }

    form.onhide = function () {
        form.jsObject.options.propertiesPanel.showContainer(form.currentPanelName);
    }

    form.updateControlsVisibleStates = function () {
        minMaxTable.style.display = calculationMode.key == "Custom" ? "" : "none";
    }

    form.updateControls = function (gaugeProperties) {
        if (!gaugeProperties) return;
        form.gaugeProperties = gaugeProperties;
        form.setValues();
        form.updateControlsVisibleStates();
    }

    form.applyExpressionPropertyToGaugeElement = function (container, expressionValue) {
        if (container) {
            form.sendCommand(
                {
                    command: "SetExpression",
                    containerName: form.jsObject.UpperFirstChar(container.name),
                    expressionValue: Base64.encode(expressionValue)
                },
                function (answer) {
                    form.updateControls(answer.elementProperties);
                    form.updateSvgContent(answer.elementProperties.svgContent);
                }
            );
        }
    }

    form.applyDataColumnPropertyToGaugeElement = function (container) {
        form.sendCommand(
            {
                command: "SetDataColumn",
                containerName: form.jsObject.UpperFirstChar(container.name),
                dataColumnObject: container.dataColumnObject
            },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                if (container.item) container.item.action();
                form.checkStartMode();
            }
        );
    }

    form.applyPropertiesToGaugeElement = function (propertyName, propertyValue) {
        form.sendCommand({ command: "SetPropertyValue", propertyName: propertyName, propertyValue: propertyValue },
            function (answer) {
                form.updateControls(answer.elementProperties);
                form.updateSvgContent(answer.elementProperties.svgContent);
                jsObject.RemoveStylesFromCache(answer.elementProperties.name);
                jsObject.options.homePanel.updateControls();
            }
        );
    }

    form.sendCommand = function (updateParameters, callbackFunction) {
        updateParameters.zoom = form.jsObject.options.report.zoom.toString();

        form.jsObject.SendCommandToDesignerServer("UpdateGaugeElement",
            {
                componentName: form.currentGaugeElement.properties.name,
                updateParameters: updateParameters
            },
            function (answer) {
                callbackFunction(answer);
            });
    }

    form.updateSvgContent = function (svgContent) {
        this.currentGaugeElement.properties.svgContent = svgContent;
        this.currentGaugeElement.repaint();
    }

    return form;
}