﻿
StiMobileDesigner.prototype.DashboardDataColumnContainer = function (form, name, headerText, width, showItemImage) {
    var container = this.DataColumnContainer(name, headerText, width, showItemImage);
    var innerContainer = container.innerContainer;
    var jsObject = this;

    innerContainer.oncontextmenu = function (event) {
        return false;
    }

    innerContainer.oldonmouseup = innerContainer.onmouseup;

    innerContainer.onmouseup = function (event) {
        if (innerContainer.canInsert()) {
            var originalItem = jsObject.options.itemInDrag.originalItem;
            var itemObject = jsObject.CopyObject(originalItem.itemObject);
            if (originalItem.closeButton && originalItem.closeButton.clicked) return;

            if (itemObject.typeItem == "Meter") {
                var fromContainerName = jsObject.UpperFirstChar(originalItem.container.name);
                var toContainerName = jsObject.UpperFirstChar(container.name);

                if (toContainerName != fromContainerName) {
                    form.sendCommand(
                        {
                            command: "MoveMeter",
                            toContainerName: toContainerName,
                            fromContainerName: fromContainerName
                        },
                        function (answer) {
                            form.updateControls(answer.elementProperties);

                            if (answer.elementProperties.svgContent) {
                                form.updateSvgContent(answer.elementProperties.svgContent);
                            }
                            if (container.item) {
                                container.item.action();
                            }
                        });
                }
            }
            else {
                innerContainer.oldonmouseup(event);
            }
        }
    }

    return container;
}