/*
Stimulsoft.Reports.JS
Version: 2023.4.4
Build date: 2023.11.21
License: https://www.stimulsoft.com/en/licensing/reports
*/
!function(e){var t;"undefined"!=typeof process&&process.__nwjs||"object"!=typeof exports||"undefined"==typeof module?"function"==typeof define&&define.amd?define(["./stimulsoft.designer"],t=>Object.assign(t,e(t.Stimulsoft))):window.Stimulsoft?window.Stimulsoft.Report?Object.assign(window,e(window.Stimulsoft)):window.Stimulsoft.blocklyFactory=e:window.Stimulsoft={blocklyFactory:e}:module.exports=(t=require("./stimulsoft.designer"),Object.assign(t,e(t.Stimulsoft)))}(function(t){var t,e,o,i,s,n;return t&&(t.__engineVersion&&"2023.4.4"!==t.__engineVersion?console.warn("Scripts versions mismatch: engine ver. = %s; blockly ver. = 2023.4.4",t.__engineVersion):"2023.4.4"!==t.__reportsVersion&&console.warn("Scripts versions mismatch: reports ver. = %s; blockly ver. = 2023.4.4",t.__reportsVersion)),e=t=t||{},i=o=e.ExternalLibrary||(e.ExternalLibrary={}),s=this||window,n=function(){"use strict";var T={connectionTypes:{INPUT_VALUE:1,OUTPUT_VALUE:2,NEXT_STATEMENT:3,PREVIOUS_STATEMENT:4}},t,e;function o(t){return-1!=e.indexOf(t.toUpperCase())}return T.spritesBase64="data:image/png;base64,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",T.constants={},T.LINE_MODE_MULTIPLIER=40,T.PAGE_MODE_MULTIPLIER=125,T.DRAG_RADIUS=5,T.FLYOUT_DRAG_RADIUS=10,T.SNAP_RADIUS=28,T.CONNECTING_SNAP_RADIUS=T.SNAP_RADIUS,T.CURRENT_CONNECTION_PREFERENCE=8,T.BUMP_DELAY=250,T.BUMP_RANDOMNESS=10,T.COLLAPSE_CHARS=30,T.LONGPRESS=750,T.SOUND_LIMIT=100,T.DRAG_STACK=!0,T.HSV_SATURATION=.45,T.HSV_VALUE=.65,T.SPRITE={width:96,height:124,url:"sprites.png"},T.constants.ALIGN={LEFT:-1,CENTRE:0,RIGHT:1},T.DRAG_NONE=0,T.DRAG_STICKY=1,T.DRAG_BEGIN=1,T.DRAG_FREE=2,T.OPPOSITE_TYPE=[],T.OPPOSITE_TYPE[T.connectionTypes.INPUT_VALUE]=T.connectionTypes.OUTPUT_VALUE,T.OPPOSITE_TYPE[T.connectionTypes.OUTPUT_VALUE]=T.connectionTypes.INPUT_VALUE,T.OPPOSITE_TYPE[T.connectionTypes.NEXT_STATEMENT]=T.connectionTypes.PREVIOUS_STATEMENT,T.OPPOSITE_TYPE[T.connectionTypes.PREVIOUS_STATEMENT]=T.connectionTypes.NEXT_STATEMENT,T.DELETE_AREA_NONE=null,T.DELETE_AREA_TRASH=1,T.DELETE_AREA_TOOLBOX=2,T.VARIABLE_CATEGORY_NAME="VARIABLE",T.VARIABLE_DYNAMIC_CATEGORY_NAME="VARIABLE_DYNAMIC",T.PROCEDURE_CATEGORY_NAME="PROCEDURE",T.RENAME_VARIABLE_ID="RENAME_VARIABLE_ID",T.DELETE_VARIABLE_ID="DELETE_VARIABLE_ID",T.constants.COLLAPSED_INPUT_NAME="_TEMP_COLLAPSED_INPUT",T.constants.COLLAPSED_FIELD_NAME="_TEMP_COLLAPSED_FIELD",T.utils={},T.utils.global=function(){return"object"==typeof self?self:"object"==typeof window?window:"object"==typeof global?global:this}(),T.Msg={},T.utils.global.Blockly||(T.utils.global.Blockly={}),T.utils.global.Blockly.Msg||(T.utils.global.Blockly.Msg=T.Msg),T.utils.colour={},T.utils.colour.parse=function(t){t=String(t).toLowerCase().trim();var e=T.utils.colour.names[t];if(e)return e;if(e="#"==(e="0x"==t.substring(0,2)?"#"+t.substring(2):t)[0]?e:"#"+e,/^#[0-9a-f]{6}$/.test(e))return e;if(/^#[0-9a-f]{3}$/.test(e))return["#",e[1],e[1],e[2],e[2],e[3],e[3]].join("");var o=t.match(/^(?:rgb)?\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)$/);return o&&(t=Number(o[1]),e=Number(o[2]),o=Number(o[3]),0<=t)&&t<256&&0<=e&&e<256&&0<=o&&o<256?T.utils.colour.rgbToHex(t,e,o):null},T.utils.colour.rgbToHex=function(t,e,o){return e=t<<16|e<<8|o,t<16?"#"+(16777216|e).toString(16).substr(1):"#"+e.toString(16)},T.utils.colour.hexToRgb=function(t){if(!(t=T.utils.colour.parse(t)))return[0,0,0];return[(t=parseInt(t.substr(1),16))>>16,t>>8&255,255&t]},T.utils.colour.hsvToHex=function(t,e,o){var i=0,s=0,n=0;if(0==e)n=s=i=o;else{var r=Math.floor(t/60),l=t/60-r,a=(t=o*(1-e),o*(1-e*l));switch(e=o*(1-e*(1-l)),r){case 1:i=a,s=o,n=t;break;case 2:i=t,s=o,n=e;break;case 3:i=t,s=a,n=o;break;case 4:i=e,s=t,n=o;break;case 5:i=o,s=t,n=a;break;case 6:case 0:i=o,s=e,n=t}}return T.utils.colour.rgbToHex(Math.floor(i),Math.floor(s),Math.floor(n))},T.utils.colour.blend=function(t,e,o){if(!(t=T.utils.colour.parse(t)))return null;if(!(e=T.utils.colour.parse(e)))return null;return t=T.utils.colour.hexToRgb(t),e=T.utils.colour.hexToRgb(e),T.utils.colour.rgbToHex(Math.round(e[0]+o*(t[0]-e[0])),Math.round(e[1]+o*(t[1]-e[1])),Math.round(e[2]+o*(t[2]-e[2])))},T.utils.colour.names={aqua:"#00ffff",black:"#000000",blue:"#0000ff",fuchsia:"#ff00ff",gray:"#808080",green:"#008000",lime:"#00ff00",maroon:"#800000",navy:"#000080",olive:"#808000",purple:"#800080",red:"#ff0000",silver:"#c0c0c0",teal:"#008080",white:"#ffffff",yellow:"#ffff00"},T.utils.Coordinate=function(t,e){this.x=t,this.y=e},T.utils.Coordinate.equals=function(t,e){return t==e||!(!t||!e)&&t.x==e.x&&t.y==e.y},T.utils.Coordinate.distance=function(t,e){var o=t.x-e.x;return t=t.y-e.y,Math.sqrt(o*o+t*t)},T.utils.Coordinate.magnitude=function(t){return Math.sqrt(t.x*t.x+t.y*t.y)},T.utils.Coordinate.difference=function(t,e){return new T.utils.Coordinate(t.x-e.x,t.y-e.y)},T.utils.Coordinate.sum=function(t,e){return new T.utils.Coordinate(t.x+e.x,t.y+e.y)},T.utils.Coordinate.prototype.scale=function(t){return this.x*=t,this.y*=t,this},T.utils.Coordinate.prototype.translate=function(t,e){return this.x+=t,this.y+=e,this},T.utils.Rect=function(t,e,o,i){this.top=t,this.bottom=e,this.left=o,this.right=i},T.utils.Rect.prototype.contains=function(t,e){return t>=this.left&&t<=this.right&&e>=this.top&&e<=this.bottom},T.utils.Rect.prototype.intersects=function(t){return!(this.left>t.right||this.right<t.left||this.top>t.bottom||this.bottom<t.top)},T.utils.string={},T.utils.string.startsWith=function(t,e){return 0==t.lastIndexOf(e,0)},T.utils.string.shortestStringLength=function(t){return t.length?t.reduce(function(t,e){return t.length<e.length?t:e}).length:0},T.utils.string.commonWordPrefix=function(t,e){if(!t.length)return 0;if(1==t.length)return t[0].length;var o=0;e=e||T.utils.string.shortestStringLength(t);for(var i=0;i<e;i++){for(var s=t[0][i],n=1;n<t.length;n++)if(s!=t[n][i])return o;" "==s&&(o=i+1)}for(n=1;n<t.length;n++)if((s=t[n][i])&&" "!=s)return o;return e},T.utils.string.commonWordSuffix=function(t,e){if(!t.length)return 0;if(1==t.length)return t[0].length;var o=0;e=e||T.utils.string.shortestStringLength(t);for(var i=0;i<e;i++){for(var s=t[0].substr(-i-1,1),n=1;n<t.length;n++)if(s!=t[n].substr(-i-1,1))return o;" "==s&&(o=i+1)}for(n=1;n<t.length;n++)if((s=t[n].charAt(t[n].length-i-1))&&" "!=s)return o;return e},T.utils.string.wrap=function(t,e){t=t.split("\n");for(var o=0;o<t.length;o++)t[o]=T.utils.string.wrapLine_(t[o],e);return t.join("\n")},T.utils.string.wrapLine_=function(t,e){if(t.length<=e)return t;for(var o=t.trim().split(/\s+/),i=0;i<o.length;i++)o[i].length>e&&(e=o[i].length);i=-(1/0);var s=1;do{for(var n=i,r=t,l=(t=[],o.length/s),a=1,i=0;i<o.length-1;i++)a<(i+1.5)/l?(a++,t[i]=!0):t[i]=!1;t=T.utils.string.wrapMutate_(o,t,e),i=T.utils.string.wrapScore_(o,t,e),t=T.utils.string.wrapToText_(o,t),s++}while(n<i);return r},T.utils.string.wrapScore_=function(t,e,o){for(var i=[0],s=[],n=0;n<t.length;n++)i[i.length-1]+=t[n].length,!0===e[n]?(i.push(0),s.push(t[n].charAt(t[n].length-1))):!1===e[n]&&i[i.length-1]++;for(t=Math.max.apply(Math,i),n=e=0;n<i.length;n++)e=(e-=2*Math.pow(Math.abs(o-i[n]),1.5))-Math.pow(t-i[n],1.5),-1!=".?!".indexOf(s[n])?e+=o/3:-1!=",;)]}".indexOf(s[n])&&(e+=o/4);return 1<i.length&&i[i.length-1]<=i[i.length-2]&&(e+=.5),e},T.utils.string.wrapMutate_=function(t,e,o){for(var i=T.utils.string.wrapScore_(t,e,o),s,n=0,r,l;n<e.length-1;n++){e[n]!=e[n+1]&&((r=[].concat(e))[n]=!r[n],r[n+1]=!r[n+1],i<(l=T.utils.string.wrapScore_(t,r,o)))&&(i=l,s=r)}return s?T.utils.string.wrapMutate_(t,s,o):e},T.utils.string.wrapToText_=function(t,e){for(var o=[],i=0;i<t.length;i++)o.push(t[i]),void 0!==e[i]&&o.push(e[i]?"\n":" ");return o.join("")},T.utils.Size=function(t,e){this.width=t,this.height=e},T.utils.Size.equals=function(t,e){return t==e||!(!t||!e)&&t.width==e.width&&t.height==e.height},T.utils.style={},T.utils.style.getSize=function(t){if("none"!=T.utils.style.getStyle_(t,"display"))return T.utils.style.getSizeWithDisplay_(t);var e=t.style,o=e.display,i=e.visibility,s=e.position,n=(e.visibility="hidden",e.position="absolute",e.display="inline",t.offsetWidth);return t=t.offsetHeight,e.display=o,e.position=s,e.visibility=i,new T.utils.Size(n,t)},T.utils.style.getSizeWithDisplay_=function(t){return new T.utils.Size(t.offsetWidth,t.offsetHeight)},T.utils.style.getStyle_=function(t,e){return T.utils.style.getComputedStyle(t,e)||T.utils.style.getCascadedStyle(t,e)||t.style&&t.style[e]},T.utils.style.getComputedStyle=function(t,e){return document.defaultView&&document.defaultView.getComputedStyle&&(t=document.defaultView.getComputedStyle(t,null))&&(t[e]||t.getPropertyValue(e))||""},T.utils.style.getCascadedStyle=function(t,e){return t.currentStyle?t.currentStyle[e]:null},T.utils.style.getPageOffset=function(t){var e=new T.utils.Coordinate(0,0),o=(t=t.getBoundingClientRect(),document.documentElement),o=new T.utils.Coordinate(window.pageXOffset||o.scrollLeft,window.pageYOffset||o.scrollTop);return e.x=t.left+o.x,e.y=t.top+o.y,e},T.utils.style.getViewportPageOffset=function(){var t=document.body,e=document.documentElement;return new T.utils.Coordinate(t.scrollLeft||e.scrollLeft,t.scrollTop||e.scrollTop)},T.utils.style.setElementShown=function(t,e){t.style.display=e?"":"none"},T.utils.style.isRightToLeft=function(t){return"rtl"==T.utils.style.getStyle_(t,"direction")},T.utils.style.getBorderBox=function(t){var e=T.utils.style.getComputedStyle(t,"borderLeftWidth"),o=T.utils.style.getComputedStyle(t,"borderRightWidth"),i=T.utils.style.getComputedStyle(t,"borderTopWidth");return t=T.utils.style.getComputedStyle(t,"borderBottomWidth"),{top:parseFloat(i),right:parseFloat(o),bottom:parseFloat(t),left:parseFloat(e)}},T.utils.style.scrollIntoContainerView=function(t,e,o){t=T.utils.style.getContainerOffsetToScrollInto(t,e,o),e.scrollLeft=t.x,e.scrollTop=t.y},T.utils.style.getContainerOffsetToScrollInto=function(t,e,o){var i=T.utils.style.getPageOffset(t),s=T.utils.style.getPageOffset(e),n=T.utils.style.getBorderBox(e),r=i.x-s.x-n.left,i=i.y-s.y-n.top,s=T.utils.style.getSizeWithDisplay_(t);return t=e.clientWidth-s.width,s=e.clientHeight-s.height,n=e.scrollLeft,e=e.scrollTop,o?(n+=r-t/2,e+=i-s/2):(n+=Math.min(r,Math.max(r-t,0)),e+=Math.min(i,Math.max(i-s,0))),new T.utils.Coordinate(n,e)},T.utils.userAgent={},t=T.utils.global.navigator&&T.utils.global.navigator.userAgent||"",T.utils.userAgent.raw=t,e=T.utils.userAgent.raw.toUpperCase(),T.utils.userAgent.IE=o("Trident")||o("MSIE"),T.utils.userAgent.EDGE=o("Edge"),T.utils.userAgent.JAVA_FX=o("JavaFX"),T.utils.userAgent.CHROME=(o("Chrome")||o("CriOS"))&&!T.utils.userAgent.EDGE,T.utils.userAgent.WEBKIT=o("WebKit")&&!T.utils.userAgent.EDGE,T.utils.userAgent.GECKO=o("Gecko")&&!T.utils.userAgent.WEBKIT&&!T.utils.userAgent.IE&&!T.utils.userAgent.EDGE,T.utils.userAgent.ANDROID=o("Android"),T.utils.userAgent.IPAD=o("iPad"),T.utils.userAgent.IPOD=o("iPod"),T.utils.userAgent.IPHONE=o("iPhone")&&!T.utils.userAgent.IPAD&&!T.utils.userAgent.IPOD,T.utils.userAgent.MAC=o("Macintosh"),T.utils.userAgent.TABLET=T.utils.userAgent.IPAD||T.utils.userAgent.ANDROID&&!o("Mobile")||o("Silk"),T.utils.userAgent.MOBILE=!T.utils.userAgent.TABLET&&(T.utils.userAgent.IPOD||T.utils.userAgent.IPHONE||T.utils.userAgent.ANDROID||o("IEMobile")),T.utils.noEvent=function(t){t.preventDefault(),t.stopPropagation()},T.utils.isTargetInput=function(t){return"textarea"==t.target.type||"text"==t.target.type||"number"==t.target.type||"email"==t.target.type||"password"==t.target.type||"search"==t.target.type||"tel"==t.target.type||"url"==t.target.type||t.target.isContentEditable||t.target.dataset&&"true"==t.target.dataset.isTextInput},T.utils.getRelativeXY=function(t){var e=new T.utils.Coordinate(0,0),o=t.getAttribute("x");return o&&(e.x=parseInt(o,10)),(o=t.getAttribute("y"))&&(e.y=parseInt(o,10)),(o=(o=t.getAttribute("transform"))&&o.match(T.utils.getRelativeXY.XY_REGEX_))&&(e.x+=Number(o[1]),o[3])&&(e.y+=Number(o[3])),(t=t.getAttribute("style"))&&-1<t.indexOf("translate")&&(t=t.match(T.utils.getRelativeXY.XY_STYLE_REGEX_))&&(e.x+=Number(t[1]),t[3])&&(e.y+=Number(t[3])),e},T.utils.getInjectionDivXY_=function(t){for(var e=0,o=0;t;){var i=T.utils.getRelativeXY(t);if(e+=i.x,o+=i.y,-1!=(" "+(t.getAttribute("class")||"")+" ").indexOf(" injectionDiv "))break;t=t.parentNode}return new T.utils.Coordinate(e,o)},T.utils.getRelativeXY.XY_REGEX_=/translate\(\s*([-+\d.e]+)([ ,]\s*([-+\d.e]+)\s*)?/,T.utils.getRelativeXY.XY_STYLE_REGEX_=/transform:\s*translate(?:3d)?\(\s*([-+\d.e]+)\s*px([ ,]\s*([-+\d.e]+)\s*px)?/,T.utils.isRightButton=function(t){return!(!t.ctrlKey||!T.utils.userAgent.MAC)||2==t.button},T.utils.mouseToSvg=function(t,e,o){var i=e.createSVGPoint();return i.x=t.clientX,i.y=t.clientY,o=o||e.getScreenCTM().inverse(),i.matrixTransform(o)},T.utils.getScrollDeltaPixels=function(t){switch(t.deltaMode){default:return{x:t.deltaX,y:t.deltaY};case 1:return{x:t.deltaX*T.LINE_MODE_MULTIPLIER,y:t.deltaY*T.LINE_MODE_MULTIPLIER};case 2:return{x:t.deltaX*T.PAGE_MODE_MULTIPLIER,y:t.deltaY*T.PAGE_MODE_MULTIPLIER}}},T.utils.tokenizeInterpolation=function(t){return T.utils.tokenizeInterpolation_(t,!0)},T.utils.replaceMessageReferences=function(t){if("string"!=typeof t)return t;return(t=T.utils.tokenizeInterpolation_(t,!1)).length?String(t[0]):""},T.utils.checkMessageReferences=function(t){for(var e=!0,o=T.Msg,i=t.match(/%{BKY_[A-Z]\w*}/gi),s=0,n;s<i.length;s++){null==o[i[s].toUpperCase().slice(6,-1)]&&(console.warn("No message string for "+i[s]+" in "+t),e=!1)}return e},T.utils.tokenizeInterpolation_=function(t,e){var o=[],i=t.split(""),s=(i.push(""),0);t=[];for(var n=null,r=0;r<i.length;r++){var l=i[r];0==s?"%"==l?((l=t.join(""))&&o.push(l),t.length=0,s=1):t.push(l):1==s?"%"==l?(t.push(l),s=0):e&&"0"<=l&&l<="9"?(s=2,n=l,(l=t.join(""))&&o.push(l),t.length=0):s="{"==l?3:(t.push("%",l),0):2==s?"0"<=l&&l<="9"?n+=l:(o.push(parseInt(n,10)),r--,s=0):3==s&&(""==l?(t.splice(0,0,"%{"),r--,s=0):"}"!=l?t.push(l):(s=t.join(""),/[A-Z]\w*/i.test(s)&&(l=s.toUpperCase(),l=T.utils.string.startsWith(l,"BKY_")?l.substring(4):null)&&l in T.Msg?"string"==typeof(s=T.Msg[l])?Array.prototype.push.apply(o,T.utils.tokenizeInterpolation_(s,e)):o.push(e?String(s):s):o.push("%{"+s+"}"),s=t.length=0))}for((l=t.join(""))&&o.push(l),e=[],r=t.length=0;r<o.length;++r)("string"==typeof o[r]?t:((l=t.join(""))&&e.push(l),t.length=0,e)).push(o[r]);return(l=t.join(""))&&e.push(l),t.length=0,e},T.utils.genUid=function(){for(var t=T.utils.genUid.soup_.length,e=[],o=0;o<20;o++)e[o]=T.utils.genUid.soup_.charAt(Math.random()*t);return e.join("")},T.utils.genUid.soup_="!#$%()*+,-./:;=?@[]^_`{|}~ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",T.utils.is3dSupported=function(){if(void 0!==T.utils.is3dSupported.cached_)return T.utils.is3dSupported.cached_;if(!T.utils.global.getComputedStyle)return!1;var t=document.createElement("p"),e="none",o={webkitTransform:"-webkit-transform",OTransform:"-o-transform",msTransform:"-ms-transform",MozTransform:"-moz-transform",transform:"transform"},i;for(i in document.body.insertBefore(t,null),o)if(void 0!==t.style[i]){if(t.style[i]="translate3d(1px,1px,1px)",!(e=T.utils.global.getComputedStyle(t)))return document.body.removeChild(t),!1;e=e.getPropertyValue(o[i])}return document.body.removeChild(t),T.utils.is3dSupported.cached_="none"!==e,T.utils.is3dSupported.cached_},T.utils.runAfterPageLoad=function(t){if("object"!=typeof document)throw Error("Blockly.utils.runAfterPageLoad() requires browser document.");var e;"complete"==document.readyState?t():e=setInterval(function(){"complete"==document.readyState&&(clearInterval(e),t())},10)},T.utils.getViewportBBox=function(){var t=T.utils.style.getViewportPageOffset();return new T.utils.Rect(t.y,document.documentElement.clientHeight+t.y,t.x,document.documentElement.clientWidth+t.x)},T.utils.arrayRemove=function(t,e){if(-1==(e=t.indexOf(e)))return!1;return t.splice(e,1),!0},T.utils.getDocumentScroll=function(){var t=document.documentElement,e=window;return T.utils.userAgent.IE&&e.pageYOffset!=t.scrollTop?new T.utils.Coordinate(t.scrollLeft,t.scrollTop):new T.utils.Coordinate(e.pageXOffset||t.scrollLeft,e.pageYOffset||t.scrollTop)},T.utils.getBlockTypeCounts=function(t,e){var o=Object.create(null),i=t.getDescendants(!0);for(e&&(t=t.getNextBlock())&&(t=i.indexOf(t),i.splice(t,i.length-t)),t=0;e=i[t];t++)o[e.type]?o[e.type]++:o[e.type]=1;return o},T.utils.screenToWsCoordinates=function(t,e){var o=e.x,i=(e=e.y,t.getInjectionDiv().getBoundingClientRect()),o=new T.utils.Coordinate(o-i.left,e-i.top);return e=t.getOriginOffsetInPixels(),T.utils.Coordinate.difference(o,e).scale(1/t.scale)},T.utils.parseBlockColour=function(t){var e="string"==typeof t?T.utils.replaceMessageReferences(t):t,o=Number(e);if(!isNaN(o)&&0<=o&&o<=360)return{hue:o,hex:T.utils.colour.hsvToHex(o,T.HSV_SATURATION,255*T.HSV_VALUE)};if(o=T.utils.colour.parse(e))return{hue:null,hex:o};throw o='Invalid colour: "'+e+'"',t!=e&&(o+=' (from "'+t+'")'),Error(o)},T.Touch={},T.Touch.TOUCH_ENABLED="ontouchstart"in T.utils.global||!!(T.utils.global.document&&document.documentElement&&"ontouchstart"in document.documentElement)||!(!T.utils.global.navigator||!T.utils.global.navigator.maxTouchPoints&&!T.utils.global.navigator.msMaxTouchPoints),T.Touch.touchIdentifier_=null,T.Touch.TOUCH_MAP={},T.utils.global.PointerEvent?T.Touch.TOUCH_MAP={mousedown:["pointerdown"],mouseenter:["pointerenter"],mouseleave:["pointerleave"],mousemove:["pointermove"],mouseout:["pointerout"],mouseover:["pointerover"],mouseup:["pointerup","pointercancel"],touchend:["pointerup"],touchcancel:["pointercancel"]}:T.Touch.TOUCH_ENABLED&&(T.Touch.TOUCH_MAP={mousedown:["touchstart"],mousemove:["touchmove"],mouseup:["touchend","touchcancel"]}),T.longPid_=0,T.longStart=function(t,e){T.longStop_(),t.changedTouches&&1!=t.changedTouches.length||(T.longPid_=setTimeout(function(){t.changedTouches&&(t.button=2,t.clientX=t.changedTouches[0].clientX,t.clientY=t.changedTouches[0].clientY),e&&e.handleRightClick(t)},T.LONGPRESS))},T.longStop_=function(){T.longPid_&&(clearTimeout(T.longPid_),T.longPid_=0)},T.Touch.clearTouchIdentifier=function(){T.Touch.touchIdentifier_=null},T.Touch.shouldHandleEvent=function(t){return!T.Touch.isMouseOrTouchEvent(t)||T.Touch.checkTouchIdentifier(t)},T.Touch.getTouchIdentifierFromEvent=function(t){return null!=t.pointerId?t.pointerId:t.changedTouches&&t.changedTouches[0]&&void 0!==t.changedTouches[0].identifier&&null!==t.changedTouches[0].identifier?t.changedTouches[0].identifier:"mouse"},T.Touch.checkTouchIdentifier=function(t){var e=T.Touch.getTouchIdentifierFromEvent(t);return void 0!==T.Touch.touchIdentifier_&&null!==T.Touch.touchIdentifier_?T.Touch.touchIdentifier_==e:("mousedown"==t.type||"touchstart"==t.type||"pointerdown"==t.type)&&(T.Touch.touchIdentifier_=e,!0)},T.Touch.setClientFromTouch=function(t){var e;T.utils.string.startsWith(t.type,"touch")&&(e=t.changedTouches[0],t.clientX=e.clientX,t.clientY=e.clientY)},T.Touch.isMouseOrTouchEvent=function(t){return T.utils.string.startsWith(t.type,"touch")||T.utils.string.startsWith(t.type,"mouse")||T.utils.string.startsWith(t.type,"pointer")},T.Touch.isTouchEvent=function(t){return T.utils.string.startsWith(t.type,"touch")||T.utils.string.startsWith(t.type,"pointer")},T.Touch.splitEventByTouches=function(t){var e=[];if(t.changedTouches)for(var o=0;o<t.changedTouches.length;o++)e[o]={type:t.type,changedTouches:[t.changedTouches[o]],target:t.target,stopPropagation:function(){t.stopPropagation()},preventDefault:function(){t.preventDefault()}};else e.push(t);return e},T.browserEvents={},T.browserEvents.conditionalBind=function(t,e,s,n,r,o){var l=!1,i=function(t){var e=!r;t=T.Touch.splitEventByTouches(t);for(var o=0,i;i=t[o];o++)e&&!T.Touch.shouldHandleEvent(i)||(T.Touch.setClientFromTouch(i),s?n.call(s,i):n(i),l=!0)},a=[];if(T.utils.global.PointerEvent&&e in T.Touch.TOUCH_MAP)for(var c=0,h;h=T.Touch.TOUCH_MAP[e][c];c++)t.addEventListener(h,i,!1),a.push([t,h,i]);else if(t.addEventListener(e,i,!1),a.push([t,e,i]),e in T.Touch.TOUCH_MAP)for(var u=function(t){var e;i(t),l&&!o&&t.preventDefault()},c=0;h=T.Touch.TOUCH_MAP[e][c];c++)t.addEventListener(h,u,!1),a.push([t,h,u]);return a},T.browserEvents.bind=function(t,e,o,i){var s=function(t){o?i.call(o,t):i(t)},n=[];if(T.utils.global.PointerEvent&&e in T.Touch.TOUCH_MAP)for(var r=0,l;l=T.Touch.TOUCH_MAP[e][r];r++)t.addEventListener(l,s,!1),n.push([t,l,s]);else if(t.addEventListener(e,s,!1),n.push([t,e,s]),e in T.Touch.TOUCH_MAP)for(var a=function(t){var e;t.changedTouches&&1==t.changedTouches.length&&(e=t.changedTouches[0],t.clientX=e.clientX,t.clientY=e.clientY),s(t),t.preventDefault()},r=0;l=T.Touch.TOUCH_MAP[e][r];r++)t.addEventListener(l,a,!1),n.push([t,l,a]);return n},T.browserEvents.unbind=function(t){for(;t.length;){var e=t.pop(),o=e[2];e[0].removeEventListener(e[1],o,!1)}return o},T.registry={},T.registry.typeMap_={},T.registry.DEFAULT="default",T.registry.Type=function(t){this.name_=t},T.registry.Type.prototype.toString=function(){return this.name_},T.registry.Type.CONNECTION_CHECKER=new T.registry.Type("connectionChecker"),T.registry.Type.CURSOR=new T.registry.Type("cursor"),T.registry.Type.EVENT=new T.registry.Type("event"),T.registry.Type.FIELD=new T.registry.Type("field"),T.registry.Type.RENDERER=new T.registry.Type("renderer"),T.registry.Type.TOOLBOX=new T.registry.Type("toolbox"),T.registry.Type.THEME=new T.registry.Type("theme"),T.registry.Type.TOOLBOX_ITEM=new T.registry.Type("toolboxItem"),T.registry.Type.FLYOUTS_VERTICAL_TOOLBOX=new T.registry.Type("flyoutsVerticalToolbox"),T.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX=new T.registry.Type("flyoutsHorizontalToolbox"),T.registry.Type.METRICS_MANAGER=new T.registry.Type("metricsManager"),T.registry.register=function(t,e,o,i){if(!(t instanceof T.registry.Type)&&"string"!=typeof t||""==String(t).trim())throw Error('Invalid type "'+t+'". The type must be a non-empty string or a Blockly.registry.Type.');if(t=String(t).toLowerCase(),"string"!=typeof e||""==e.trim())throw Error('Invalid name "'+e+'". The name must be a non-empty string.');if(e=e.toLowerCase(),!o)throw Error("Can not register a null value");var s,s=(s=T.registry.typeMap_[t])||(T.registry.typeMap_[t]={});if(T.registry.validate_(t,o),!i&&s[e])throw Error('Name "'+e+'" with type "'+t+'" already registered.');s[e]=o},T.registry.validate_=function(t,e){switch(t){case String(T.registry.Type.FIELD):if("function"!=typeof e.fromJson)throw Error('Type "'+t+'" must have a fromJson function')}},T.registry.unregister=function(t,e){t=String(t).toLowerCase(),e=e.toLowerCase();var o=T.registry.typeMap_[t];o&&o[e]?delete T.registry.typeMap_[t][e]:console.warn("Unable to unregister ["+e+"]["+t+"] from the registry.")},T.registry.getItem_=function(t,e,o){t=String(t).toLowerCase(),e=e.toLowerCase();var i=T.registry.typeMap_[t];if(!i||!i[e]){if(e="Unable to find ["+e+"]["+t+"] in the registry.",o)throw Error(e+" You must require or register a "+t+" plugin.");return console.warn(e),null}return i[e]},T.registry.hasItem=function(t,e){return t=String(t).toLowerCase(),e=e.toLowerCase(),!!(t=T.registry.typeMap_[t])&&!!t[e]},T.registry.getClass=function(t,e,o){return T.registry.getItem_(t,e,o)},T.registry.getObject=function(t,e,o){return T.registry.getItem_(t,e,o)},T.registry.getClassFromOptions=function(t,e,o){return"function"==typeof(e=e.plugins[t.toString()]||T.registry.DEFAULT)?e:T.registry.getClass(t,e,o)},T.Events={},T.Events.group_="",T.Events.recordUndo=!0,T.Events.disabled_=0,T.Events.CREATE="create",T.Events.BLOCK_CREATE=T.Events.CREATE,T.Events.DELETE="delete",T.Events.BLOCK_DELETE=T.Events.DELETE,T.Events.CHANGE="change",T.Events.BLOCK_CHANGE=T.Events.CHANGE,T.Events.MOVE="move",T.Events.BLOCK_MOVE=T.Events.MOVE,T.Events.VAR_CREATE="var_create",T.Events.VAR_DELETE="var_delete",T.Events.VAR_RENAME="var_rename",T.Events.UI="ui",T.Events.BLOCK_DRAG="drag",T.Events.SELECTED="selected",T.Events.CLICK="click",T.Events.MARKER_MOVE="marker_move",T.Events.BUBBLE_OPEN="bubble_open",T.Events.TRASHCAN_OPEN="trashcan_open",T.Events.TOOLBOX_ITEM_SELECT="toolbox_item_select",T.Events.THEME_CHANGE="theme_change",T.Events.VIEWPORT_CHANGE="viewport_change",T.Events.COMMENT_CREATE="comment_create",T.Events.COMMENT_DELETE="comment_delete",T.Events.COMMENT_CHANGE="comment_change",T.Events.COMMENT_MOVE="comment_move",T.Events.FINISHED_LOADING="finished_loading",T.Events.BUMP_EVENTS=[T.Events.BLOCK_CREATE,T.Events.BLOCK_MOVE,T.Events.COMMENT_CREATE,T.Events.COMMENT_MOVE],T.Events.FIRE_QUEUE_=[],T.Events.fire=function(t){T.Events.isEnabled()&&(T.Events.FIRE_QUEUE_.length||setTimeout(T.Events.fireNow_,0),T.Events.FIRE_QUEUE_.push(t))},T.Events.fireNow_=function(){for(var t=T.Events.filter(T.Events.FIRE_QUEUE_,!0),e=T.Events.FIRE_QUEUE_.length=0,o,i;o=t[e];e++){o.workspaceId&&(i=T.Workspace.getById(o.workspaceId))&&i.fireChangeListener(o)}},T.Events.filter=function(t,e){t=t.slice(),e||t.reverse();for(var o=[],i=Object.create(null),s=0,n,r,l,a;n=t[s];s++){n.isNull()||(a=(l=i[r=[n.isUiEvent?T.Events.UI:n.type,n.blockId,n.workspaceId].join(" ")])?l.event:null,l?n.type==T.Events.MOVE&&l.index==s-1?(a.newParentId=n.newParentId,a.newInputName=n.newInputName,a.newCoordinate=n.newCoordinate,l.index=s):n.type==T.Events.CHANGE&&n.element==a.element&&n.name==a.name?a.newValue=n.newValue:n.type==T.Events.CLICK&&a.type==T.Events.BUBBLE_OPEN||(i[r]={event:n,index:s},o.push(n)):(i[r]={event:n,index:s},o.push(n)))}for(t=o.filter(function(t){return!t.isNull()}),e||t.reverse(),s=1;n=t[s];s++)n.type==T.Events.CHANGE&&"mutation"==n.element&&t.unshift(t.splice(s,1)[0]);return t},T.Events.clearPendingUndo=function(){for(var t=0,e;e=T.Events.FIRE_QUEUE_[t];t++)e.recordUndo=!1},T.Events.disable=function(){T.Events.disabled_++},T.Events.enable=function(){T.Events.disabled_--},T.Events.isEnabled=function(){return 0==T.Events.disabled_},T.Events.getGroup=function(){return T.Events.group_},T.Events.setGroup=function(t){T.Events.group_="boolean"==typeof t?t?T.utils.genUid():"":t},T.Events.getDescendantIds=function(t){var e=[];t=t.getDescendants(!1);for(var o=0,i;i=t[o];o++)e[o]=i.id;return e},T.Events.fromJson=function(t,e){var o=T.Events.get(t.type);if(!o)throw Error("Unknown event type.");return(o=new o).fromJson(t),o.workspaceId=e.id,o},T.Events.get=function(t){return T.registry.getClass(T.registry.Type.EVENT,t)},T.Events.disableOrphans=function(t){if((t.type==T.Events.MOVE||t.type==T.Events.CREATE)&&t.workspaceId){var e,o=(e=T.Workspace.getById(t.workspaceId)).getBlockById(t.blockId);if(o){t=T.Events.recordUndo;try{T.Events.recordUndo=!1;var i=o.getParent();if(i&&i.isEnabled())for(var s=o.getDescendants(!1),e=0,n;n=s[e];e++)n.setEnabled(!0);else if((o.outputConnection||o.previousConnection)&&!e.isDragging())do{o.setEnabled(!1),o=o.getNextBlock()}while(o)}finally{T.Events.recordUndo=t}}}},T.Events.Abstract=function(){this.isBlank=null,this.workspaceId=void 0,this.group=T.Events.getGroup(),this.recordUndo=T.Events.recordUndo},T.Events.Abstract.prototype.isUiEvent=!1,T.Events.Abstract.prototype.toJson=function(){var t={type:this.type};return this.group&&(t.group=this.group),t},T.Events.Abstract.prototype.fromJson=function(t){this.isBlank=!1,this.group=t.group},T.Events.Abstract.prototype.isNull=function(){return!1},T.Events.Abstract.prototype.run=function(t){},T.Events.Abstract.prototype.getEventWorkspace_=function(){var t;if(!(t=this.workspaceId?T.Workspace.getById(this.workspaceId):t))throw Error("Workspace is null. Event must have been generated from real Blockly events.");return t},T.utils.object={},T.utils.object.inherits=function(t,e){t.superClass_=e.prototype,t.prototype=Object.create(e.prototype),t.prototype.constructor=t},T.utils.object.mixin=function(t,e){for(var o in e)t[o]=e[o]},T.utils.object.deepMerge=function(t,e){for(var o in e)t[o]=null!=e[o]&&"object"==typeof e[o]?T.utils.object.deepMerge(t[o]||Object.create(null),e[o]):e[o];return t},T.utils.object.values=function(e){return Object.values?Object.values(e):Object.keys(e).map(function(t){return e[t]})},T.utils.xml={},T.utils.xml.NAME_SPACE="https://developers.google.com/blockly/xml",T.utils.xml.document=function(){return document},T.utils.xml.createElement=function(t){return T.utils.xml.document().createElementNS(T.utils.xml.NAME_SPACE,t)},T.utils.xml.createTextNode=function(t){return T.utils.xml.document().createTextNode(t)},T.utils.xml.textToDomDocument=function(t){return(new DOMParser).parseFromString(t,"text/xml")},T.utils.xml.domToText=function(t){return(new XMLSerializer).serializeToString(t)},T.inputTypes={VALUE:T.connectionTypes.INPUT_VALUE,STATEMENT:T.connectionTypes.NEXT_STATEMENT,DUMMY:5},T.utils.Svg=function(t){this.tagName_=t},T.utils.Svg.prototype.toString=function(){return this.tagName_},T.utils.Svg.ANIMATE=new T.utils.Svg("animate"),T.utils.Svg.CIRCLE=new T.utils.Svg("circle"),T.utils.Svg.CLIPPATH=new T.utils.Svg("clipPath"),T.utils.Svg.DEFS=new T.utils.Svg("defs"),T.utils.Svg.FECOMPOSITE=new T.utils.Svg("feComposite"),T.utils.Svg.FECOMPONENTTRANSFER=new T.utils.Svg("feComponentTransfer"),T.utils.Svg.FEFLOOD=new T.utils.Svg("feFlood"),T.utils.Svg.FEFUNCA=new T.utils.Svg("feFuncA"),T.utils.Svg.FEGAUSSIANBLUR=new T.utils.Svg("feGaussianBlur"),T.utils.Svg.FEPOINTLIGHT=new T.utils.Svg("fePointLight"),T.utils.Svg.FESPECULARLIGHTING=new T.utils.Svg("feSpecularLighting"),T.utils.Svg.FILTER=new T.utils.Svg("filter"),T.utils.Svg.FOREIGNOBJECT=new T.utils.Svg("foreignObject"),T.utils.Svg.G=new T.utils.Svg("g"),T.utils.Svg.IMAGE=new T.utils.Svg("image"),T.utils.Svg.LINE=new T.utils.Svg("line"),T.utils.Svg.PATH=new T.utils.Svg("path"),T.utils.Svg.PATTERN=new T.utils.Svg("pattern"),T.utils.Svg.POLYGON=new T.utils.Svg("polygon"),T.utils.Svg.RECT=new T.utils.Svg("rect"),T.utils.Svg.SVG=new T.utils.Svg("svg"),T.utils.Svg.TEXT=new T.utils.Svg("text"),T.utils.Svg.TSPAN=new T.utils.Svg("tspan"),T.utils.dom={},T.utils.dom.SVG_NS="http://www.w3.org/2000/svg",T.utils.dom.HTML_NS="http://www.w3.org/1999/xhtml",T.utils.dom.XLINK_NS="http://www.w3.org/1999/xlink",T.utils.dom.NodeType={ELEMENT_NODE:1,TEXT_NODE:3,COMMENT_NODE:8,DOCUMENT_POSITION_CONTAINED_BY:16},T.utils.dom.cacheWidths_=null,T.utils.dom.cacheReference_=0,T.utils.dom.canvasContext_=null,T.utils.dom.createSvgElement=function(t,e,o){for(var i in t=document.createElementNS(T.utils.dom.SVG_NS,String(t)),e)t.setAttribute(i,e[i]);return document.body.runtimeStyle&&(t.runtimeStyle=t.currentStyle=t.style),o&&o.appendChild(t),t},T.utils.dom.addClass=function(t,e){var o=t.getAttribute("class")||"";if(-1!=(" "+o+" ").indexOf(" "+e+" "))return!1;return o&&(o+=" "),t.setAttribute("class",o+e),!0},T.utils.dom.removeClasses=function(t,e){e=e.split(" ");for(var o=0;o<e.length;o++)T.utils.dom.removeClass(t,e[o])},T.utils.dom.removeClass=function(t,e){var o;if(-1==(" "+(o=t.getAttribute("class"))+" ").indexOf(" "+e+" "))return!1;for(var o=o.split(/\s+/),i=0;i<o.length;i++)o[i]&&o[i]!=e||(o.splice(i,1),i--);return o.length?t.setAttribute("class",o.join(" ")):t.removeAttribute("class"),!0},T.utils.dom.hasClass=function(t,e){return-1!=(" "+t.getAttribute("class")+" ").indexOf(" "+e+" ")},T.utils.dom.removeNode=function(t){return t&&t.parentNode?t.parentNode.removeChild(t):null},T.utils.dom.insertAfter=function(t,e){var o=e.nextSibling;if(!(e=e.parentNode))throw Error("Reference node has no parent.");o?e.insertBefore(t,o):e.appendChild(t)},T.utils.dom.containsNode=function(t,e){return!!(t.compareDocumentPosition(e)&T.utils.dom.NodeType.DOCUMENT_POSITION_CONTAINED_BY)},T.utils.dom.setCssTransform=function(t,e){t.style.transform=e,t.style["-webkit-transform"]=e},T.utils.dom.startTextWidthCache=function(){T.utils.dom.cacheReference_++,T.utils.dom.cacheWidths_||(T.utils.dom.cacheWidths_={})},T.utils.dom.stopTextWidthCache=function(){T.utils.dom.cacheReference_--,T.utils.dom.cacheReference_||(T.utils.dom.cacheWidths_=null)},T.utils.dom.getTextWidth=function(e){var t=e.textContent+"\n"+e.className.baseVal,o;if(T.utils.dom.cacheWidths_&&(o=T.utils.dom.cacheWidths_[t]))return o;try{o=T.utils.userAgent.IE||T.utils.userAgent.EDGE?e.getBBox().width:e.getComputedTextLength()}catch(t){return 8*e.textContent.length}return T.utils.dom.cacheWidths_&&(T.utils.dom.cacheWidths_[t]=o),o},T.utils.dom.getFastTextWidth=function(t,e,o,i){return T.utils.dom.getFastTextWidthWithSizeString(t,e+"pt",o,i)},T.utils.dom.getFastTextWidthWithSizeString=function(t,e,o,i){var s=t.textContent,n;if(t=s+"\n"+t.className.baseVal,T.utils.dom.cacheWidths_&&(n=T.utils.dom.cacheWidths_[t]))return n;return T.utils.dom.canvasContext_||((n=document.createElement("canvas")).className="blocklyComputeCanvas",document.body.appendChild(n),T.utils.dom.canvasContext_=n.getContext("2d")),T.utils.dom.canvasContext_.font=o+" "+e+" "+i,n=T.utils.dom.canvasContext_.measureText(s).width,T.utils.dom.cacheWidths_&&(T.utils.dom.cacheWidths_[t]=n),n},T.utils.dom.measureFontMetrics=function(t,e,o,i){var s=document.createElement("span");s.style.font=o+" "+e+" "+i,s.textContent=t,(t=document.createElement("div")).style.width="1px",t.style.height="0px",(e=document.createElement("div")).setAttribute("style","position: fixed; top: 0; left: 0; display: flex;"),e.appendChild(s),e.appendChild(t),document.body.appendChild(e);try{o={},e.style.alignItems="baseline",o.baseline=t.offsetTop-s.offsetTop,e.style.alignItems="flex-end",o.height=t.offsetTop-s.offsetTop}finally{document.body.removeChild(e)}return o},T.Xml={},T.Xml.workspaceToDom=function(t,e){for(var o=T.utils.xml.createElement("xml"),i,s=((i=T.Xml.variablesToDom(T.Variables.allUsedVarModels(t))).hasChildNodes()&&o.appendChild(i),t.getTopComments(!0)),i=0,n;n=s[i];i++)o.appendChild(n.toXmlWithXY(e));for(t=t.getTopBlocks(!0),i=0;s=t[i];i++)o.appendChild(T.Xml.blockToDomWithXY(s,e));return o},T.Xml.variablesToDom=function(t){for(var e=T.utils.xml.createElement("variables"),o=0,i;i=t[o];o++){var s=T.utils.xml.createElement("variable");s.appendChild(T.utils.xml.createTextNode(i.name)),i.type&&s.setAttribute("type",i.type),s.id=i.getId(),e.appendChild(s)}return e},T.Xml.blockToDomWithXY=function(t,e){if(t.isInsertionMarker()&&!(t=t.getChildren(!1)[0]))return new DocumentFragment;var o,i=(t.workspace.RTL&&(o=t.workspace.getWidth()),e=T.Xml.blockToDom(t,e),t.getRelativeToSurfaceXY());return e.setAttribute("x",Math.round(t.workspace.RTL?o-i.x:i.x)),e.setAttribute("y",Math.round(i.y)),e},T.Xml.fieldToDom_=function(t){var e;if(t.isSerializable())return(e=T.utils.xml.createElement("field")).setAttribute("name",t.name||""),t.toXml(e);return null},T.Xml.allFieldsToDom_=function(t,e){for(var o=0,i;i=t.inputList[o];o++)for(var s=0,n;n=i.fieldRow[s];s++)(n=T.Xml.fieldToDom_(n))&&e.appendChild(n)},T.Xml.blockToDom=function(t,e){if(t.isInsertionMarker())return(t=t.getChildren(!1)[0])?T.Xml.blockToDom(t):new DocumentFragment;var o=T.utils.xml.createElement(t.isShadow()?"shadow":"block"),i,s,n,r;for(o.setAttribute("type",t.type),e||o.setAttribute("id",t.id),t.mutationToDom&&(i=t.mutationToDom())&&(i.hasChildNodes()||i.hasAttributes())&&o.appendChild(i),T.Xml.allFieldsToDom_(t,o),(i=t.getCommentText())&&(s=t.commentModel.size,n=t.commentModel.pinned,(r=T.utils.xml.createElement("comment")).appendChild(T.utils.xml.createTextNode(i)),r.setAttribute("pinned",n),r.setAttribute("h",s.height),r.setAttribute("w",s.width),o.appendChild(r)),t.data&&((i=T.utils.xml.createElement("data")).appendChild(T.utils.xml.createTextNode(t.data)),o.appendChild(i)),i=0;s=t.inputList[i];i++){var l,a,n=!0;s.type!=T.inputTypes.DUMMY&&(a=s.connection.targetBlock(),s.type==T.inputTypes.VALUE?l=T.utils.xml.createElement("value"):s.type==T.inputTypes.STATEMENT&&(l=T.utils.xml.createElement("statement")),!(r=s.connection.getShadowDom())||a&&a.isShadow()||l.appendChild(T.Xml.cloneShadow_(r,e)),a&&(r=T.Xml.blockToDom(a,e)).nodeType==T.utils.dom.NodeType.ELEMENT_NODE&&(l.appendChild(r),n=!1),l.setAttribute("name",s.name),n||o.appendChild(l))}return null!=t.inputsInline&&t.inputsInline!=t.inputsInlineDefault&&o.setAttribute("inline",t.inputsInline),t.isCollapsed()&&o.setAttribute("collapsed",!0),t.isEnabled()||o.setAttribute("disabled",!0),t.isDeletable()||t.isShadow()||o.setAttribute("deletable",!1),t.isMovable()||t.isShadow()||o.setAttribute("movable",!1),t.isEditable()||o.setAttribute("editable",!1),(i=t.getNextBlock())&&(r=T.Xml.blockToDom(i,e)).nodeType==T.utils.dom.NodeType.ELEMENT_NODE&&((l=T.utils.xml.createElement("next")).appendChild(r),o.appendChild(l)),!(r=t.nextConnection&&t.nextConnection.getShadowDom())||i&&i.isShadow()||l.appendChild(T.Xml.cloneShadow_(r,e)),o},T.Xml.cloneShadow_=function(t,e){for(var o=t=t.cloneNode(!0),i;o;)if(e&&"shadow"==o.nodeName&&o.removeAttribute("id"),o.firstChild)o=o.firstChild;else{for(;o&&!o.nextSibling;)o=(i=o).parentNode,i.nodeType==T.utils.dom.NodeType.TEXT_NODE&&""==i.data.trim()&&o.firstChild!=i&&T.utils.dom.removeNode(i);o&&(o=(i=o).nextSibling,i.nodeType==T.utils.dom.NodeType.TEXT_NODE)&&""==i.data.trim()&&T.utils.dom.removeNode(i)}return t},T.Xml.domToText=function(t){return T.utils.xml.domToText(t).replace(/<(\w+)([^<]*)\/>/g,"<$1$2></$1>")},T.Xml.domToPrettyText=function(t){t=T.Xml.domToText(t).split("<");for(var e="",o=1;o<t.length;o++){var i=t[o];"/"==i[0]&&(e=e.substring(2)),t[o]=e+"<"+i,"/"!=i[0]&&"/>"!=i.slice(-2)&&(e+="  ")}return(t=(t=t.join("\n")).replace(/(<(\w+)\b[^>]*>[^\n]*)\n *<\/\2>/g,"$1</$2>")).replace(/^\n/,"")},T.Xml.textToDom=function(t){var e=T.utils.xml.textToDomDocument(t);if(!e||!e.documentElement||e.getElementsByTagName("parsererror").length)throw Error("textToDom was unable to parse: "+t);return e.documentElement},T.Xml.clearWorkspaceAndLoadFromXml=function(t,e){return e.setResizesEnabled(!1),e.clear(),t=T.Xml.domToWorkspace(t,e),e.setResizesEnabled(!0),t},T.Xml.domToWorkspace=function(t,e){var o,i,s=(t instanceof T.Workspace&&(o=t,t=e,e=o,console.warn("Deprecated call to Blockly.Xml.domToWorkspace, swap the arguments.")),e.RTL&&(i=e.getWidth()),o=[],T.utils.dom.startTextWidthCache(),T.Events.getGroup()),n=(s||T.Events.setGroup(!0),e.setResizesEnabled&&e.setResizesEnabled(!1),!0);try{for(var r=0,l;l=t.childNodes[r];r++){var a=l.nodeName.toLowerCase(),c=l;if("block"==a||"shadow"==a&&!T.Events.recordUndo){var h=T.Xml.domToBlock(c,e),u=(o.push(h.id),c.hasAttribute("x")?parseInt(c.getAttribute("x"),10):10),g=c.hasAttribute("y")?parseInt(c.getAttribute("y"),10):10;isNaN(u)||isNaN(g)||h.moveBy(e.RTL?i-u:u,g),n=!1}else{if("shadow"==a)throw TypeError("Shadow block cannot be a top-level block.");if("comment"==a)e.rendered?T.WorkspaceCommentSvg?T.WorkspaceCommentSvg.fromXml(c,e,i):console.warn("Missing require for Blockly.WorkspaceCommentSvg, ignoring workspace comment."):T.WorkspaceComment?T.WorkspaceComment.fromXml(c,e):console.warn("Missing require for Blockly.WorkspaceComment, ignoring workspace comment.");else if("variables"==a){if(!n)throw Error("'variables' tag must exist once before block and shadow tag elements in the workspace XML, but it was found in another location.");T.Xml.domToVariables(c,e),n=!1}}}}finally{s||T.Events.setGroup(!1),T.utils.dom.stopTextWidthCache()}return e.setResizesEnabled&&e.setResizesEnabled(!0),T.Events.fire(new(T.Events.get(T.Events.FINISHED_LOADING))(e)),o},T.Xml.appendDomToWorkspace=function(t,e){var o;if(Object.prototype.hasOwnProperty.call(e,"scale")&&(o=e.getBlocksBoundingBox()),t=T.Xml.domToWorkspace(t,e),o&&o.top!=o.bottom){for(var i=o.bottom,s=e.RTL?o.right:o.left,n=1/0,r=-(1/0),l=1/0,o=0;o<t.length;o++){var a=e.getBlockById(t[o]).getRelativeToSurfaceXY();a.y<l&&(l=a.y),a.x<n&&(n=a.x),a.x>r&&(r=a.x)}for(i=i-l+10,s=e.RTL?s-r:s-n,o=0;o<t.length;o++)e.getBlockById(t[o]).moveBy(s,i)}return t},T.Xml.domToBlock=function(t,e){var o;t instanceof T.Workspace&&(o=t,t=e,e=o,console.warn("Deprecated call to Blockly.Xml.domToBlock, swap the arguments.")),T.Events.disable(),o=e.getAllVariables();try{var i=T.Xml.domToBlockHeadless_(t,e),s=i.getDescendants(!1);if(e.rendered){i.setConnectionTracking(!1);for(var n=s.length-1;0<=n;n--)s[n].initSvg();for(n=s.length-1;0<=n;n--)s[n].render(!1);setTimeout(function(){i.disposed||i.setConnectionTracking(!0)},1),i.updateDisabled(),e.resizeContents()}else for(n=s.length-1;0<=n;n--)s[n].initModel()}finally{T.Events.enable()}if(T.Events.isEnabled()){for(t=T.Variables.getAddedVariables(e,o),n=0;n<t.length;n++)e=t[n],T.Events.fire(new(T.Events.get(T.Events.VAR_CREATE))(e));T.Events.fire(new(T.Events.get(T.Events.CREATE))(i))}return i},T.Xml.domToVariables=function(t,e){for(var o=0,i,s,n;i=t.childNodes[o];o++){i.nodeType==T.utils.dom.NodeType.ELEMENT_NODE&&(s=i.getAttribute("type"),n=i.getAttribute("id"),e.createVariable(i.textContent,s,n))}},T.Xml.mapSupportedXmlTags_=function(t){for(var e={mutation:[],comment:[],data:[],field:[],input:[],next:[]},o=0,i;i=t.childNodes[o];o++)if(i.nodeType!=T.utils.dom.NodeType.TEXT_NODE)switch(i.nodeName.toLowerCase()){case"mutation":e.mutation.push(i);break;case"comment":if(!T.Comment){console.warn("Missing require for Blockly.Comment, ignoring block comment.");break}e.comment.push(i);break;case"data":e.data.push(i);break;case"title":case"field":e.field.push(i);break;case"value":case"statement":e.input.push(i);break;case"next":e.next.push(i);break;default:console.warn("Ignoring unknown tag: "+i.nodeName)}return e},T.Xml.applyMutationTagNodes_=function(t,e){for(var o=!1,i=0,s;s=t[i];i++)e.domToMutation&&(e.domToMutation(s),e.initSvg)&&(o=!0);return o},T.Xml.applyCommentTagNodes_=function(t,e){for(var o=0,i;i=t[o];o++){var s=i.textContent,n="true"==i.getAttribute("pinned"),r=parseInt(i.getAttribute("w"),10),i=parseInt(i.getAttribute("h"),10);e.setCommentText(s),e.commentModel.pinned=n,isNaN(r)||isNaN(i)||(e.commentModel.size=new T.utils.Size(r,i)),n&&e.getCommentIcon&&!e.isInFlyout&&setTimeout(function(){e.getCommentIcon().setVisible(!0)},1)}},T.Xml.applyDataTagNodes_=function(t,e){for(var o=0,i;i=t[o];o++)e.data=i.textContent},T.Xml.applyFieldTagNodes_=function(t,e){for(var o=0,i;i=t[o];o++){var s=i.getAttribute("name");T.Xml.domToField_(e,s,i)}},T.Xml.findChildBlocks_=function(t){for(var e={childBlockElement:null,childShadowElement:null},o=0,i;i=t.childNodes[o];o++)i.nodeType==T.utils.dom.NodeType.ELEMENT_NODE&&("block"==i.nodeName.toLowerCase()?e.childBlockElement=i:"shadow"==i.nodeName.toLowerCase()&&(e.childShadowElement=i));return e},T.Xml.applyInputTagNodes_=function(t,e,o,i){for(var s=0,n;n=t[s];s++){var r=n.getAttribute("name"),l=o.getInput(r);if(!l){console.warn("Ignoring non-existent input "+r+" in block "+i);break}if((n=T.Xml.findChildBlocks_(n)).childBlockElement){if(!l.connection)throw TypeError("Input connection does not exist.");T.Xml.domToBlockHeadless_(n.childBlockElement,e,l.connection,!1)}n.childShadowElement&&l.connection.setShadowDom(n.childShadowElement)}},T.Xml.applyNextTagNodes_=function(t,e,o){for(var i=0,s;s=t[i];i++){if((s=T.Xml.findChildBlocks_(s)).childBlockElement){if(!o.nextConnection)throw TypeError("Next statement does not exist.");if(o.nextConnection.isConnected())throw TypeError("Next statement is already connected.");T.Xml.domToBlockHeadless_(s.childBlockElement,e,o.nextConnection,!0)}s.childShadowElement&&o.nextConnection&&o.nextConnection.setShadowDom(s.childShadowElement)}},T.Xml.domToBlockHeadless_=function(t,e,o,i){var s=t.getAttribute("type");if(!s)throw TypeError("Block type unspecified: "+t.outerHTML);var n=t.getAttribute("id"),n=e.newBlock(s,n),r=T.Xml.mapSupportedXmlTags_(t),l=T.Xml.applyMutationTagNodes_(r.mutation,n);if(T.Xml.applyCommentTagNodes_(r.comment,n),T.Xml.applyDataTagNodes_(r.data,n),o)if(i){if(!n.previousConnection)throw TypeError("Next block does not have previous statement.");o.connect(n.previousConnection)}else if(n.outputConnection)o.connect(n.outputConnection);else{if(!n.previousConnection)throw TypeError("Child block does not have output or previous statement.");o.connect(n.previousConnection)}if(T.Xml.applyFieldTagNodes_(r.field,n),T.Xml.applyInputTagNodes_(r.input,e,n,s),T.Xml.applyNextTagNodes_(r.next,e,n),l&&n.initSvg(),(e=t.getAttribute("inline"))&&n.setInputsInline("true"==e),(e=t.getAttribute("disabled"))&&n.setEnabled("true"!=e&&"disabled"!=e),(e=t.getAttribute("deletable"))&&n.setDeletable("true"==e),(e=t.getAttribute("movable"))&&n.setMovable("true"==e),(e=t.getAttribute("editable"))&&n.setEditable("true"==e),(e=t.getAttribute("collapsed"))&&n.setCollapsed("true"==e),"shadow"==t.nodeName.toLowerCase()){for(t=n.getChildren(!1),e=0;o=t[e];e++)if(!o.isShadow())throw TypeError("Shadow block not allowed non-shadow child.");if(n.getVarModels().length)throw TypeError("Shadow blocks cannot have variable references.");n.setShadow(!0)}return n},T.Xml.domToField_=function(t,e,o){var i=t.getField(e);i?i.fromXml(o):console.warn("Ignoring non-existent field "+e+" in block "+t.type)},T.Xml.deleteNext=function(t){for(var e=0,o;o=t.childNodes[e];e++)if("next"==o.nodeName.toLowerCase()){t.removeChild(o);break}},T.Events.BlockBase=function(t){T.Events.BlockBase.superClass_.constructor.call(this),this.blockId=(this.isBlank=void 0===t)?"":t.id,this.workspaceId=this.isBlank?"":t.workspace.id},T.utils.object.inherits(T.Events.BlockBase,T.Events.Abstract),T.Events.BlockBase.prototype.toJson=function(){var t=T.Events.BlockBase.superClass_.toJson.call(this);return t.blockId=this.blockId,t},T.Events.BlockBase.prototype.fromJson=function(t){T.Events.BlockBase.superClass_.fromJson.call(this,t),this.blockId=t.blockId},T.Events.Change=function(t,e,o,i,s){T.Events.Change.superClass_.constructor.call(this,t),t&&(this.element=void 0===e?"":e,this.name=void 0===o?"":o,this.oldValue=void 0===i?"":i,this.newValue=void 0===s?"":s)},T.utils.object.inherits(T.Events.Change,T.Events.BlockBase),T.Events.BlockChange=T.Events.Change,T.Events.Change.prototype.type=T.Events.CHANGE,T.Events.Change.prototype.toJson=function(){var t=T.Events.Change.superClass_.toJson.call(this);return t.element=this.element,this.name&&(t.name=this.name),t.oldValue=this.oldValue,t.newValue=this.newValue,t},T.Events.Change.prototype.fromJson=function(t){T.Events.Change.superClass_.fromJson.call(this,t),this.element=t.element,this.name=t.name,this.oldValue=t.oldValue,this.newValue=t.newValue},T.Events.Change.prototype.isNull=function(){return this.oldValue==this.newValue},T.Events.Change.prototype.run=function(t){var e=this.getEventWorkspace_().getBlockById(this.blockId);if(e)switch(e.mutator&&e.mutator.setVisible(!1),t=t?this.newValue:this.oldValue,this.element){case"field":(e=e.getField(this.name))?e.setValue(t):console.warn("Can't set non-existent field: "+this.name);break;case"comment":e.setCommentText(t||null);break;case"collapsed":e.setCollapsed(!!t);break;case"disabled":e.setEnabled(!t);break;case"inline":e.setInputsInline(!!t);break;case"mutation":var o="",i;e.mutationToDom&&(o=(o=e.mutationToDom())&&T.Xml.domToText(o)),e.domToMutation&&(i=T.Xml.textToDom(t||"<mutation/>"),e.domToMutation(i)),T.Events.fire(new(T.Events.get(T.Events.CHANGE))(e,"mutation",null,o,t));break;default:console.warn("Unknown change type: "+this.element)}else console.warn("Can't change non-existent block: "+this.blockId)},T.Events.Create=function(t){T.Events.Create.superClass_.constructor.call(this,t),t&&(t.isShadow()&&(this.recordUndo=!1),this.xml=t.workspace.rendered?T.Xml.blockToDomWithXY(t):T.Xml.blockToDom(t),this.ids=T.Events.getDescendantIds(t))},T.utils.object.inherits(T.Events.Create,T.Events.BlockBase),T.Events.BlockCreate=T.Events.Create,T.Events.Create.prototype.type=T.Events.CREATE,T.Events.Create.prototype.toJson=function(){var t=T.Events.Create.superClass_.toJson.call(this);return t.xml=T.Xml.domToText(this.xml),t.ids=this.ids,this.recordUndo||(t.recordUndo=this.recordUndo),t},T.Events.Create.prototype.fromJson=function(t){T.Events.Create.superClass_.fromJson.call(this,t),this.xml=T.Xml.textToDom(t.xml),this.ids=t.ids,void 0!==t.recordUndo&&(this.recordUndo=t.recordUndo)},T.Events.Create.prototype.run=function(t){var e=this.getEventWorkspace_(),o;if(t)(t=T.utils.xml.createElement("xml")).appendChild(this.xml),T.Xml.domToWorkspace(t,e);else{t=0;for(;o=this.ids[t];t++){var i=e.getBlockById(o);i?i.dispose(!1):o==this.blockId&&console.warn("Can't uncreate non-existent block: "+o)}}},T.Events.Delete=function(t){if(T.Events.Delete.superClass_.constructor.call(this,t),t){if(t.getParent())throw Error("Connected blocks cannot be deleted.");t.isShadow()&&(this.recordUndo=!1),this.oldXml=t.workspace.rendered?T.Xml.blockToDomWithXY(t):T.Xml.blockToDom(t),this.ids=T.Events.getDescendantIds(t)}},T.utils.object.inherits(T.Events.Delete,T.Events.BlockBase),T.Events.BlockDelete=T.Events.Delete,T.Events.Delete.prototype.type=T.Events.DELETE,T.Events.Delete.prototype.toJson=function(){var t=T.Events.Delete.superClass_.toJson.call(this);return t.oldXml=T.Xml.domToText(this.oldXml),t.ids=this.ids,this.recordUndo||(t.recordUndo=this.recordUndo),t},T.Events.Delete.prototype.fromJson=function(t){T.Events.Delete.superClass_.fromJson.call(this,t),this.oldXml=T.Xml.textToDom(t.oldXml),this.ids=t.ids,void 0!==t.recordUndo&&(this.recordUndo=t.recordUndo)},T.Events.Delete.prototype.run=function(t){var e=this.getEventWorkspace_(),o;if(t){t=0;for(;o=this.ids[t];t++){var i=e.getBlockById(o);i?i.dispose(!1):o==this.blockId&&console.warn("Can't delete non-existent block: "+o)}}else(t=T.utils.xml.createElement("xml")).appendChild(this.oldXml),T.Xml.domToWorkspace(t,e)},T.Events.Move=function(t){T.Events.Move.superClass_.constructor.call(this,t),t&&(t.isShadow()&&(this.recordUndo=!1),t=this.currentLocation_(),this.oldParentId=t.parentId,this.oldInputName=t.inputName,this.oldCoordinate=t.coordinate)},T.utils.object.inherits(T.Events.Move,T.Events.BlockBase),T.Events.BlockMove=T.Events.Move,T.Events.Move.prototype.type=T.Events.MOVE,T.Events.Move.prototype.toJson=function(){var t=T.Events.Move.superClass_.toJson.call(this);return this.newParentId&&(t.newParentId=this.newParentId),this.newInputName&&(t.newInputName=this.newInputName),this.newCoordinate&&(t.newCoordinate=Math.round(this.newCoordinate.x)+","+Math.round(this.newCoordinate.y)),this.recordUndo||(t.recordUndo=this.recordUndo),t},T.Events.Move.prototype.fromJson=function(t){var e;T.Events.Move.superClass_.fromJson.call(this,t),this.newParentId=t.newParentId,this.newInputName=t.newInputName,t.newCoordinate&&(e=t.newCoordinate.split(","),this.newCoordinate=new T.utils.Coordinate(Number(e[0]),Number(e[1]))),void 0!==t.recordUndo&&(this.recordUndo=t.recordUndo)},T.Events.Move.prototype.recordNew=function(){var t=this.currentLocation_();this.newParentId=t.parentId,this.newInputName=t.inputName,this.newCoordinate=t.coordinate},T.Events.Move.prototype.currentLocation_=function(){var t=this.getEventWorkspace_().getBlockById(this.blockId),e={},o=t.getParent();return o?(e.parentId=o.id,(t=o.getInputWithBlock(t))&&(e.inputName=t.name)):e.coordinate=t.getRelativeToSurfaceXY(),e},T.Events.Move.prototype.isNull=function(){return this.oldParentId==this.newParentId&&this.oldInputName==this.newInputName&&T.utils.Coordinate.equals(this.oldCoordinate,this.newCoordinate)},T.Events.Move.prototype.run=function(t){var e,o;if(o=(e=this.getEventWorkspace_()).getBlockById(this.blockId)){var i=t?this.newParentId:this.oldParentId,s=t?this.newInputName:this.oldInputName,n=t?this.newCoordinate:this.oldCoordinate,r,o,e;if(t=null,i&&!(t=e.getBlockById(i)))return void console.warn("Can't connect to non-existent block: "+i);o.getParent()&&o.unplug(),n?(s=o.getRelativeToSurfaceXY(),o.moveBy(n.x-s.x,n.y-s.y)):(e=(o=o.outputConnection||o.previousConnection).type,s?(t=t.getInput(s))&&(r=t.connection):e==T.connectionTypes.PREVIOUS_STATEMENT&&(r=t.nextConnection),r?o.connect(r):console.warn("Can't connect to non-existent input: "+s))}else console.warn("Can't move non-existent block: "+this.blockId)},T.registry.register(T.registry.Type.EVENT,T.Events.CREATE,T.Events.Create),T.registry.register(T.registry.Type.EVENT,T.Events.DELETE,T.Events.Delete),T.registry.register(T.registry.Type.EVENT,T.Events.CHANGE,T.Events.Change),T.registry.register(T.registry.Type.EVENT,T.Events.MOVE,T.Events.Move),T.Events.FinishedLoading=function(t){this.isBlank=void 0===t,this.workspaceId=t?t.id:"",this.group=T.Events.getGroup(),this.recordUndo=!1},T.utils.object.inherits(T.Events.FinishedLoading,T.Events.Abstract),T.Events.FinishedLoading.prototype.type=T.Events.FINISHED_LOADING,T.Events.FinishedLoading.prototype.toJson=function(){var t={type:this.type};return this.group&&(t.group=this.group),this.workspaceId&&(t.workspaceId=this.workspaceId),t},T.Events.FinishedLoading.prototype.fromJson=function(t){this.isBlank=!1,this.workspaceId=t.workspaceId,this.group=t.group},T.registry.register(T.registry.Type.EVENT,T.Events.FINISHED_LOADING,T.Events.FinishedLoading),T.Events.UiBase=function(t){T.Events.UiBase.superClass_.constructor.call(this),this.isBlank=void 0===t,this.workspaceId=t||"",this.recordUndo=!1},T.utils.object.inherits(T.Events.UiBase,T.Events.Abstract),T.Events.UiBase.prototype.isUiEvent=!0,T.Events.Ui=function(t,e,o,i){T.Events.Ui.superClass_.constructor.call(this,t?t.workspace.id:void 0),this.blockId=t?t.id:null,this.element=void 0===e?"":e,this.oldValue=void 0===o?"":o,this.newValue=void 0===i?"":i},T.utils.object.inherits(T.Events.Ui,T.Events.UiBase),T.Events.Ui.prototype.type=T.Events.UI,T.Events.Ui.prototype.toJson=function(){var t=T.Events.Ui.superClass_.toJson.call(this);return t.element=this.element,void 0!==this.newValue&&(t.newValue=this.newValue),this.blockId&&(t.blockId=this.blockId),t},T.Events.Ui.prototype.fromJson=function(t){T.Events.Ui.superClass_.fromJson.call(this,t),this.element=t.element,this.newValue=t.newValue,this.blockId=t.blockId},T.registry.register(T.registry.Type.EVENT,T.Events.UI,T.Events.Ui),T.Events.VarBase=function(t){T.Events.VarBase.superClass_.constructor.call(this),this.varId=(this.isBlank=void 0===t)?"":t.getId(),this.workspaceId=this.isBlank?"":t.workspace.id},T.utils.object.inherits(T.Events.VarBase,T.Events.Abstract),T.Events.VarBase.prototype.toJson=function(){var t=T.Events.VarBase.superClass_.toJson.call(this);return t.varId=this.varId,t},T.Events.VarBase.prototype.fromJson=function(t){T.Events.VarBase.superClass_.toJson.call(this),this.varId=t.varId},T.Events.VarCreate=function(t){T.Events.VarCreate.superClass_.constructor.call(this,t),t&&(this.varType=t.type,this.varName=t.name)},T.utils.object.inherits(T.Events.VarCreate,T.Events.VarBase),T.Events.VarCreate.prototype.type=T.Events.VAR_CREATE,T.Events.VarCreate.prototype.toJson=function(){var t=T.Events.VarCreate.superClass_.toJson.call(this);return t.varType=this.varType,t.varName=this.varName,t},T.Events.VarCreate.prototype.fromJson=function(t){T.Events.VarCreate.superClass_.fromJson.call(this,t),this.varType=t.varType,this.varName=t.varName},T.Events.VarCreate.prototype.run=function(t){var e=this.getEventWorkspace_();t?e.createVariable(this.varName,this.varType,this.varId):e.deleteVariableById(this.varId)},T.Events.VarDelete=function(t){T.Events.VarDelete.superClass_.constructor.call(this,t),t&&(this.varType=t.type,this.varName=t.name)},T.utils.object.inherits(T.Events.VarDelete,T.Events.VarBase),T.Events.VarDelete.prototype.type=T.Events.VAR_DELETE,T.Events.VarDelete.prototype.toJson=function(){var t=T.Events.VarDelete.superClass_.toJson.call(this);return t.varType=this.varType,t.varName=this.varName,t},T.Events.VarDelete.prototype.fromJson=function(t){T.Events.VarDelete.superClass_.fromJson.call(this,t),this.varType=t.varType,this.varName=t.varName},T.Events.VarDelete.prototype.run=function(t){var e=this.getEventWorkspace_();t?e.deleteVariableById(this.varId):e.createVariable(this.varName,this.varType,this.varId)},T.Events.VarRename=function(t,e){T.Events.VarRename.superClass_.constructor.call(this,t),t&&(this.oldName=t.name,this.newName=void 0===e?"":e)},T.utils.object.inherits(T.Events.VarRename,T.Events.VarBase),T.Events.VarRename.prototype.type=T.Events.VAR_RENAME,T.Events.VarRename.prototype.toJson=function(){var t=T.Events.VarRename.superClass_.toJson.call(this);return t.oldName=this.oldName,t.newName=this.newName,t},T.Events.VarRename.prototype.fromJson=function(t){T.Events.VarRename.superClass_.fromJson.call(this,t),this.oldName=t.oldName,this.newName=t.newName},T.Events.VarRename.prototype.run=function(t){var e=this.getEventWorkspace_();t?e.renameVariableById(this.varId,this.newName):e.renameVariableById(this.varId,this.oldName)},T.registry.register(T.registry.Type.EVENT,T.Events.VAR_CREATE,T.Events.VarCreate),T.registry.register(T.registry.Type.EVENT,T.Events.VAR_DELETE,T.Events.VarDelete),T.registry.register(T.registry.Type.EVENT,T.Events.VAR_RENAME,T.Events.VarRename),T.BlockDragSurfaceSvg=function(t){this.container_=t,this.createDom()},T.BlockDragSurfaceSvg.prototype.SVG_=null,T.BlockDragSurfaceSvg.prototype.dragGroup_=null,T.BlockDragSurfaceSvg.prototype.container_=null,T.BlockDragSurfaceSvg.prototype.scale_=1,T.BlockDragSurfaceSvg.prototype.surfaceXY_=null,T.BlockDragSurfaceSvg.prototype.createDom=function(){this.SVG_||(this.SVG_=T.utils.dom.createSvgElement(T.utils.Svg.SVG,{xmlns:T.utils.dom.SVG_NS,"xmlns:html":T.utils.dom.HTML_NS,"xmlns:xlink":T.utils.dom.XLINK_NS,version:"1.1",class:"blocklyBlockDragSurface"},this.container_),this.dragGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{},this.SVG_))},T.BlockDragSurfaceSvg.prototype.setBlocksAndShow=function(t){if(this.dragGroup_.childNodes.length)throw Error("Already dragging a block.");this.dragGroup_.appendChild(t),this.SVG_.style.display="block",this.surfaceXY_=new T.utils.Coordinate(0,0)},T.BlockDragSurfaceSvg.prototype.translateAndScaleGroup=function(t,e,o){this.scale_=o,t=t.toFixed(0),e=e.toFixed(0),this.dragGroup_.setAttribute("transform","translate("+t+","+e+") scale("+o+")")},T.BlockDragSurfaceSvg.prototype.translateSurfaceInternal_=function(){var t=this.surfaceXY_.x,e=this.surfaceXY_.y,t=t.toFixed(0),e=e.toFixed(0);this.SVG_.style.display="block",T.utils.dom.setCssTransform(this.SVG_,"translate3d("+t+"px, "+e+"px, 0px)")},T.BlockDragSurfaceSvg.prototype.translateSurface=function(t,e){this.surfaceXY_=new T.utils.Coordinate(t*this.scale_,e*this.scale_),this.translateSurfaceInternal_()},T.BlockDragSurfaceSvg.prototype.getSurfaceTranslation=function(){var t=T.utils.getRelativeXY(this.SVG_);return new T.utils.Coordinate(t.x/this.scale_,t.y/this.scale_)},T.BlockDragSurfaceSvg.prototype.getGroup=function(){return this.dragGroup_},T.BlockDragSurfaceSvg.prototype.getCurrentBlock=function(){return this.dragGroup_.firstChild},T.BlockDragSurfaceSvg.prototype.clearAndHide=function(t){if(t?t.appendChild(this.getCurrentBlock()):this.dragGroup_.removeChild(this.getCurrentBlock()),this.SVG_.style.display="none",this.dragGroup_.childNodes.length)throw Error("Drag group was not cleared.");this.surfaceXY_=null},T.Css={},T.Css.injected_=!1,T.Css.register=function(t){if(T.Css.injected_)throw Error("CSS already injected");Array.prototype.push.apply(T.Css.CONTENT,t),t.length=0},T.Css.inject=function(t,e){var o;T.Css.injected_||(T.Css.injected_=!0,o=T.Css.CONTENT.join("\n"),T.Css.CONTENT.length=0,t&&(t=e.replace(/[\\/]$/,""),o=o.replace(/<<<PATH>>>/g,t),(t=document.createElement("style")).id="blockly-common-style",o=document.createTextNode(o),t.appendChild(o),document.head.insertBefore(t,document.head.firstChild)))},T.Css.CONTENT=[".blocklySvg {","background-color: #fff;","outline: none;","overflow: hidden;","position: absolute;","display: block;","}",".blocklyWidgetDiv {","display: none;","position: absolute;","z-index: 99999;","}",".injectionDiv {","height: 100%;","position: relative;","overflow: hidden;","touch-action: none;","}",".blocklyNonSelectable {","user-select: none;","-ms-user-select: none;","-webkit-user-select: none;","}",".blocklyWsDragSurface {","display: none;","position: absolute;","top: 0;","left: 0;","}",".blocklyWsDragSurface.blocklyOverflowVisible {","overflow: visible;","}",".blocklyBlockDragSurface {","display: none;","position: absolute;","top: 0;","left: 0;","right: 0;","bottom: 0;","overflow: visible !important;","z-index: 50;","}",".blocklyBlockCanvas.blocklyCanvasTransitioning,",".blocklyBubbleCanvas.blocklyCanvasTransitioning {","transition: transform .5s;","}",".blocklyTooltipDiv {","background-color: #ffffc7;","border: 1px solid #ddc;","box-shadow: 4px 4px 20px 1px rgba(0,0,0,.15);","color: #000;","display: none;","font: 9pt sans-serif;","opacity: .9;","padding: 2px;","position: absolute;","z-index: 100000;","}",".blocklyDropDownDiv {","position: absolute;","left: 0;","top: 0;","z-index: 10000;","display: none;","border: 1px solid;","border-color: #dadce0;","background-color: #fff;","border-radius: 2px;","padding: 4px;","box-shadow: 0 0 3px 1px rgba(0,0,0,.3);","}",".blocklyDropDownDiv.blocklyFocused {","box-shadow: 0 0 6px 1px rgba(0,0,0,.3);","}",".blocklyDropDownContent {","max-height: 300px;","overflow: auto;","overflow-x: hidden;","position: relative;","}",".blocklyDropDownArrow {","position: absolute;","left: 0;","top: 0;","width: 16px;","height: 16px;","z-index: -1;","background-color: inherit;","border-color: inherit;","}",".blocklyDropDownButton {","display: inline-block;","float: left;","padding: 0;","margin: 4px;","border-radius: 4px;","outline: none;","border: 1px solid;","transition: box-shadow .1s;","cursor: pointer;","}",".blocklyArrowTop {","border-top: 1px solid;","border-left: 1px solid;","border-top-left-radius: 4px;","border-color: inherit;","}",".blocklyArrowBottom {","border-bottom: 1px solid;","border-right: 1px solid;","border-bottom-right-radius: 4px;","border-color: inherit;","}",".blocklyResizeSE {","cursor: se-resize;","fill: #aaa;","}",".blocklyResizeSW {","cursor: sw-resize;","fill: #aaa;","}",".blocklyResizeLine {","stroke: #515A5A;","stroke-width: 1;","}",".blocklyHighlightedConnectionPath {","fill: none;","stroke: #fc3;","stroke-width: 4px;","}",".blocklyPathLight {","fill: none;","stroke-linecap: round;","stroke-width: 1;","}",".blocklySelected>.blocklyPathLight {","display: none;","}",".blocklyDraggable {",'cursor: url("<<<PATH>>>/handopen.cur"), auto;',"cursor: grab;","cursor: -webkit-grab;","}",".blocklyDragging {",'cursor: url("<<<PATH>>>/handclosed.cur"), auto;',"cursor: grabbing;","cursor: -webkit-grabbing;","}",".blocklyDraggable:active {",'cursor: url("<<<PATH>>>/handclosed.cur"), auto;',"cursor: grabbing;","cursor: -webkit-grabbing;","}",".blocklyBlockDragSurface .blocklyDraggable {",'cursor: url("<<<PATH>>>/handclosed.cur"), auto;',"cursor: grabbing;","cursor: -webkit-grabbing;","}",".blocklyDragging.blocklyDraggingDelete {",'cursor: url("<<<PATH>>>/handdelete.cur"), auto;',"}",".blocklyDragging>.blocklyPath,",".blocklyDragging>.blocklyPathLight {","fill-opacity: .8;","stroke-opacity: .8;","}",".blocklyDragging>.blocklyPathDark {","display: none;","}",".blocklyDisabled>.blocklyPath {","fill-opacity: .5;","stroke-opacity: .5;","}",".blocklyDisabled>.blocklyPathLight,",".blocklyDisabled>.blocklyPathDark {","display: none;","}",".blocklyInsertionMarker>.blocklyPath,",".blocklyInsertionMarker>.blocklyPathLight,",".blocklyInsertionMarker>.blocklyPathDark {","fill-opacity: .2;","stroke: none;","}",".blocklyMultilineText {","font-family: monospace;","}",".blocklyNonEditableText>text {","pointer-events: none;","}",".blocklyFlyout {","position: absolute;","z-index: 20;","}",".blocklyText text {","cursor: default;","}",".blocklySvg text,",".blocklyBlockDragSurface text {","user-select: none;","-ms-user-select: none;","-webkit-user-select: none;","cursor: inherit;","}",".blocklyHidden {","display: none;","}",".blocklyFieldDropdown:not(.blocklyHidden) {","display: block;","}",".blocklyIconGroup {","cursor: default;","}",".blocklyIconGroup:not(:hover),",".blocklyIconGroupReadonly {","opacity: .6;","}",".blocklyIconShape {","fill: #00f;","stroke: #fff;","stroke-width: 1px;","}",".blocklyIconSymbol {","fill: #fff;","}",".blocklyMinimalBody {","margin: 0;","padding: 0;","}",".blocklyHtmlInput {","border: none;","border-radius: 4px;","height: 100%;","margin: 0;","outline: none;","padding: 0;","width: 100%;","text-align: center;","display: block;","box-sizing: border-box;","}",".blocklyHtmlInput::-ms-clear {","display: none;","}",".blocklyMainBackground {","stroke-width: 1;","stroke: #c6c6c6;","}",".blocklyMutatorBackground {","fill: #fff;","stroke: #ddd;","stroke-width: 1;","}",".blocklyFlyoutBackground {","fill: #ddd;","fill-opacity: .8;","}",".blocklyMainWorkspaceScrollbar {","z-index: 20;","}",".blocklyFlyoutScrollbar {","z-index: 30;","}",".blocklyScrollbarHorizontal,",".blocklyScrollbarVertical {","position: absolute;","outline: none;","}",".blocklyScrollbarBackground {","opacity: 0;","}",".blocklyScrollbarHandle {","fill: #ccc;","}",".blocklyScrollbarBackground:hover+.blocklyScrollbarHandle,",".blocklyScrollbarHandle:hover {","fill: #bbb;","}",".blocklyFlyout .blocklyScrollbarHandle {","fill: #bbb;","}",".blocklyFlyout .blocklyScrollbarBackground:hover+.blocklyScrollbarHandle,",".blocklyFlyout .blocklyScrollbarHandle:hover {","fill: #aaa;","}",".blocklyInvalidInput {","background: #faa;","}",".blocklyVerticalMarker {","stroke-width: 3px;","fill: rgba(255,255,255,.5);","pointer-events: none;","}",".blocklyComputeCanvas {","position: absolute;","width: 0;","height: 0;","}",".blocklyNoPointerEvents {","pointer-events: none;","}",".blocklyContextMenu {","border-radius: 4px;","max-height: 100%;","}",".blocklyDropdownMenu {","border-radius: 2px;","padding: 0 !important;","}",".blocklyDropdownMenu .blocklyMenuItem {","padding-left: 28px;","}",".blocklyDropdownMenu .blocklyMenuItemRtl {","padding-left: 5px;","padding-right: 28px;","}",".blocklyWidgetDiv .blocklyMenu {","background: #fff;","border: 1px solid transparent;","box-shadow: 0 0 3px 1px rgba(0,0,0,.3);","font: normal 13px Arial, sans-serif;","margin: 0;","outline: none;","padding: 4px 0;","position: absolute;","overflow-y: auto;","overflow-x: hidden;","max-height: 100%;","z-index: 20000;","}",".blocklyWidgetDiv .blocklyMenu.blocklyFocused {","box-shadow: 0 0 6px 1px rgba(0,0,0,.3);","}",".blocklyDropDownDiv .blocklyMenu {","background: inherit;","border: inherit;",'font: normal 13px "Helvetica Neue", Helvetica, sans-serif;',"outline: none;","position: relative;","z-index: 20000;","}",".blocklyMenuItem {","border: none;","color: #000;","cursor: pointer;","list-style: none;","margin: 0;","min-width: 7em;","padding: 6px 15px;","white-space: nowrap;","}",".blocklyMenuItemDisabled {","color: #ccc;","cursor: inherit;","}",".blocklyMenuItemHighlight {","background-color: rgba(0,0,0,.1);","}",".blocklyMenuItemCheckbox {","height: 16px;","position: absolute;","width: 16px;","}",".blocklyMenuItemSelected .blocklyMenuItemCheckbox {","float: left;","margin-left: -24px;","position: static;","}",".blocklyMenuItemRtl .blocklyMenuItemCheckbox {","float: right;","margin-right: -24px;","}"],T.utils.math={},T.utils.math.toRadians=function(t){return t*Math.PI/180},T.utils.math.toDegrees=function(t){return 180*t/Math.PI},T.utils.math.clamp=function(t,e,o){var i;return o<t&&(i=o,o=t,t=i),Math.max(t,Math.min(e,o))},T.DropDownDiv=function(){},T.DropDownDiv.boundsElement_=null,T.DropDownDiv.owner_=null,T.DropDownDiv.positionToField_=null,T.DropDownDiv.ARROW_SIZE=16,T.DropDownDiv.BORDER_SIZE=1,T.DropDownDiv.ARROW_HORIZONTAL_PADDING=12,T.DropDownDiv.PADDING_Y=16,T.DropDownDiv.ANIMATION_TIME=.25,T.DropDownDiv.animateOutTimer_=null,T.DropDownDiv.onHide_=null,T.DropDownDiv.rendererClassName_="",T.DropDownDiv.themeClassName_="",T.DropDownDiv.createDom=function(){var t,e;T.DropDownDiv.DIV_||((t=document.createElement("div")).className="blocklyDropDownDiv",(T.parentContainer||document.body).appendChild(t),T.DropDownDiv.DIV_=t,(e=document.createElement("div")).className="blocklyDropDownContent",t.appendChild(e),T.DropDownDiv.content_=e,(e=document.createElement("div")).className="blocklyDropDownArrow",t.appendChild(e),T.DropDownDiv.arrow_=e,T.DropDownDiv.DIV_.style.opacity=0,T.DropDownDiv.DIV_.style.transition="transform "+T.DropDownDiv.ANIMATION_TIME+"s, opacity "+T.DropDownDiv.ANIMATION_TIME+"s",t.addEventListener("focusin",function(){T.utils.dom.addClass(t,"blocklyFocused")}),t.addEventListener("focusout",function(){T.utils.dom.removeClass(t,"blocklyFocused")}))},T.DropDownDiv.setBoundsElement=function(t){T.DropDownDiv.boundsElement_=t},T.DropDownDiv.getContentDiv=function(){return T.DropDownDiv.content_},T.DropDownDiv.clearContent=function(){T.DropDownDiv.content_.textContent="",T.DropDownDiv.content_.style.width=""},T.DropDownDiv.setColour=function(t,e){T.DropDownDiv.DIV_.style.backgroundColor=t,T.DropDownDiv.DIV_.style.borderColor=e},T.DropDownDiv.showPositionedByBlock=function(t,e,o,i){return T.DropDownDiv.showPositionedByRect_(T.DropDownDiv.getScaledBboxOfBlock_(e),t,o,i)},T.DropDownDiv.showPositionedByField=function(t,e,o){return T.DropDownDiv.positionToField_=!0,T.DropDownDiv.showPositionedByRect_(T.DropDownDiv.getScaledBboxOfField_(t),t,e,o)},T.DropDownDiv.getScaledBboxOfBlock_=function(t){var e=t.getSvgRoot(),o=e.getBBox(),i=t.workspace.scale;return t=o.height*i,o=o.width*i,e=T.utils.style.getPageOffset(e),new T.utils.Rect(e.y,e.y+t,e.x,e.x+o)},T.DropDownDiv.getScaledBboxOfField_=function(t){return t=t.getScaledBBox(),new T.utils.Rect(t.top,t.bottom,t.left,t.right)},T.DropDownDiv.showPositionedByRect_=function(t,e,o,i){var s=t.left+(t.right-t.left)/2,n=t.bottom;t=t.top,i&&(t+=i);for(var r=(i=e.getSourceBlock()).workspace;r.options.parentWorkspace;)r=r.options.parentWorkspace;return T.DropDownDiv.setBoundsElement(r.getParentSvg().parentNode),T.DropDownDiv.show(e,i.RTL,s,n,s,t,o)},T.DropDownDiv.show=function(t,e,o,i,s,n,r){return T.DropDownDiv.owner_=t,T.DropDownDiv.onHide_=r||null,(t=T.DropDownDiv.DIV_).style.direction=e?"rtl":"ltr",e=T.getMainWorkspace(),T.DropDownDiv.rendererClassName_=e.getRenderer().getClassName(),T.DropDownDiv.themeClassName_=e.getTheme().getClassName(),T.utils.dom.addClass(t,T.DropDownDiv.rendererClassName_),T.utils.dom.addClass(t,T.DropDownDiv.themeClassName_),T.DropDownDiv.positionInternal_(o,i,s,n)},T.DropDownDiv.getBoundsInfo_=function(){var t=T.utils.style.getPageOffset(T.DropDownDiv.boundsElement_),e=T.utils.style.getSize(T.DropDownDiv.boundsElement_);return{left:t.x,right:t.x+e.width,top:t.y,bottom:t.y+e.height,width:e.width,height:e.height}},T.DropDownDiv.getPositionMetrics_=function(t,e,o,i){var s=T.DropDownDiv.getBoundsInfo_(),n=T.utils.style.getSize(T.DropDownDiv.DIV_);return e+n.height<s.bottom?T.DropDownDiv.getPositionBelowMetrics_(t,e,s,n):i-n.height>s.top?T.DropDownDiv.getPositionAboveMetrics_(o,i,s,n):e+n.height<document.documentElement.clientHeight?T.DropDownDiv.getPositionBelowMetrics_(t,e,s,n):i-n.height>document.documentElement.clientTop?T.DropDownDiv.getPositionAboveMetrics_(o,i,s,n):T.DropDownDiv.getPositionTopOfPageMetrics_(t,s,n)},T.DropDownDiv.getPositionBelowMetrics_=function(t,e,o,i){return{initialX:(t=T.DropDownDiv.getPositionX(t,o.left,o.right,i.width)).divX,initialY:e,finalX:t.divX,finalY:e+T.DropDownDiv.PADDING_Y,arrowX:t.arrowX,arrowY:-(T.DropDownDiv.ARROW_SIZE/2+T.DropDownDiv.BORDER_SIZE),arrowAtTop:!0,arrowVisible:!0}},T.DropDownDiv.getPositionAboveMetrics_=function(t,e,o,i){return{initialX:(t=T.DropDownDiv.getPositionX(t,o.left,o.right,i.width)).divX,initialY:e-i.height,finalX:t.divX,finalY:e-i.height-T.DropDownDiv.PADDING_Y,arrowX:t.arrowX,arrowY:i.height-2*T.DropDownDiv.BORDER_SIZE-T.DropDownDiv.ARROW_SIZE/2,arrowAtTop:!1,arrowVisible:!0}},T.DropDownDiv.getPositionTopOfPageMetrics_=function(t,e,o){return{initialX:(t=T.DropDownDiv.getPositionX(t,e.left,e.right,o.width)).divX,initialY:0,finalX:t.divX,finalY:0,arrowAtTop:null,arrowX:null,arrowY:null,arrowVisible:!1}},T.DropDownDiv.getPositionX=function(t,e,o,i){var s=t;return t=T.utils.math.clamp(e,t-i/2,o-i),s-=T.DropDownDiv.ARROW_SIZE/2,e=T.DropDownDiv.ARROW_HORIZONTAL_PADDING,{arrowX:i=T.utils.math.clamp(e,s-t,i-e-T.DropDownDiv.ARROW_SIZE),divX:t}},T.DropDownDiv.isVisible=function(){return!!T.DropDownDiv.owner_},T.DropDownDiv.hideIfOwner=function(t,e){return T.DropDownDiv.owner_===t&&(e?T.DropDownDiv.hideWithoutAnimation():T.DropDownDiv.hide(),!0)},T.DropDownDiv.hide=function(){var t=T.DropDownDiv.DIV_;t.style.transform="translate(0, 0)",t.style.opacity=0,T.DropDownDiv.animateOutTimer_=setTimeout(function(){T.DropDownDiv.hideWithoutAnimation()},1e3*T.DropDownDiv.ANIMATION_TIME),T.DropDownDiv.onHide_&&(T.DropDownDiv.onHide_(),T.DropDownDiv.onHide_=null)},T.DropDownDiv.hideWithoutAnimation=function(){var t;T.DropDownDiv.isVisible()&&(T.DropDownDiv.animateOutTimer_&&clearTimeout(T.DropDownDiv.animateOutTimer_),(t=T.DropDownDiv.DIV_).style.transform="",t.style.left="",t.style.top="",t.style.opacity=0,t.style.display="none",t.style.backgroundColor="",t.style.borderColor="",T.DropDownDiv.onHide_&&(T.DropDownDiv.onHide_(),T.DropDownDiv.onHide_=null),T.DropDownDiv.clearContent(),T.DropDownDiv.owner_=null,T.DropDownDiv.rendererClassName_&&(T.utils.dom.removeClass(t,T.DropDownDiv.rendererClassName_),T.DropDownDiv.rendererClassName_=""),T.DropDownDiv.themeClassName_&&(T.utils.dom.removeClass(t,T.DropDownDiv.themeClassName_),T.DropDownDiv.themeClassName_=""),T.getMainWorkspace().markFocused())},T.DropDownDiv.positionInternal_=function(t,e,o,i){(t=T.DropDownDiv.getPositionMetrics_(t,e,o,i)).arrowVisible?(T.DropDownDiv.arrow_.style.display="",T.DropDownDiv.arrow_.style.transform="translate("+t.arrowX+"px,"+t.arrowY+"px) rotate(45deg)",T.DropDownDiv.arrow_.setAttribute("class",t.arrowAtTop?"blocklyDropDownArrow blocklyArrowTop":"blocklyDropDownArrow blocklyArrowBottom")):T.DropDownDiv.arrow_.style.display="none",e=Math.floor(t.initialX),o=Math.floor(t.initialY),i=Math.floor(t.finalX);var s=Math.floor(t.finalY),n=T.DropDownDiv.DIV_;return n.style.left=e+"px",n.style.top=o+"px",n.style.display="block",n.style.opacity=1,n.style.transform="translate("+(i-e)+"px,"+(s-o)+"px)",!!t.arrowAtTop},T.DropDownDiv.repositionForWindowResize=function(){var t,e,t,e;T.DropDownDiv.owner_?(e=(t=T.DropDownDiv.owner_).getSourceBlock(),e=(t=T.DropDownDiv.positionToField_?T.DropDownDiv.getScaledBboxOfField_(t):T.DropDownDiv.getScaledBboxOfBlock_(e)).left+(t.right-t.left)/2,T.DropDownDiv.positionInternal_(e,t.bottom,e,t.top)):T.DropDownDiv.hide()},T.Grid=function(t,e){this.gridPattern_=t,this.spacing_=e.spacing,this.length_=e.length,this.line2_=(this.line1_=t.firstChild)&&this.line1_.nextSibling,this.snapToGrid_=e.snap},T.Grid.prototype.scale_=1,T.Grid.prototype.dispose=function(){this.gridPattern_=null},T.Grid.prototype.shouldSnap=function(){return this.snapToGrid_},T.Grid.prototype.getSpacing=function(){return this.spacing_},T.Grid.prototype.getPatternId=function(){return this.gridPattern_.id},T.Grid.prototype.update=function(t){this.scale_=t;var e=this.spacing_*t||100,o=(this.gridPattern_.setAttribute("width",e),this.gridPattern_.setAttribute("height",e),(e=Math.floor(this.spacing_/2)+.5)-this.length_/2),i=e+this.length_/2;this.setLineAttributes_(this.line1_,t,o*=t,i*=t,e*=t,e),this.setLineAttributes_(this.line2_,t,e,e,o,i)},T.Grid.prototype.setLineAttributes_=function(t,e,o,i,s,n){t&&(t.setAttribute("stroke-width",e),t.setAttribute("x1",o),t.setAttribute("y1",s),t.setAttribute("x2",i),t.setAttribute("y2",n))},T.Grid.prototype.moveTo=function(t,e){this.gridPattern_.setAttribute("x",t),this.gridPattern_.setAttribute("y",e),(T.utils.userAgent.IE||T.utils.userAgent.EDGE)&&this.update(this.scale_)},T.Grid.createDom=function(t,e,o){return t=T.utils.dom.createSvgElement(T.utils.Svg.PATTERN,{id:"blocklyGridPattern"+t,patternUnits:"userSpaceOnUse"},o),0<e.length&&0<e.spacing?(T.utils.dom.createSvgElement(T.utils.Svg.LINE,{stroke:e.colour},t),1<e.length&&T.utils.dom.createSvgElement(T.utils.Svg.LINE,{stroke:e.colour},t)):T.utils.dom.createSvgElement(T.utils.Svg.LINE,{},t),t},T.Theme=function(t,e,o,i){this.name=t,this.blockStyles=e||Object.create(null),this.categoryStyles=o||Object.create(null),this.componentStyles=i||Object.create(null),this.fontStyle=Object.create(null),this.startHats=null,T.registry.register(T.registry.Type.THEME,t,this)},T.Theme.prototype.getClassName=function(){return this.name+"-theme"},T.Theme.prototype.setBlockStyle=function(t,e){this.blockStyles[t]=e},T.Theme.prototype.setCategoryStyle=function(t,e){this.categoryStyles[t]=e},T.Theme.prototype.getComponentStyle=function(t){return(t=this.componentStyles[t])&&"string"==typeof t&&this.getComponentStyle(t)?this.getComponentStyle(t):t?String(t):null},T.Theme.prototype.setComponentStyle=function(t,e){this.componentStyles[t]=e},T.Theme.prototype.setFontStyle=function(t){this.fontStyle=t},T.Theme.prototype.setStartHats=function(t){this.startHats=t},T.Theme.defineTheme=function(t,e){var o=new T.Theme(t),i=e.base;return i&&(i="string"==typeof i?T.registry.getObject(T.registry.Type.THEME,i):i)instanceof T.Theme&&(T.utils.object.deepMerge(o,i),o.name=t),T.utils.object.deepMerge(o.blockStyles,e.blockStyles),T.utils.object.deepMerge(o.categoryStyles,e.categoryStyles),T.utils.object.deepMerge(o.componentStyles,e.componentStyles),T.utils.object.deepMerge(o.fontStyle,e.fontStyle),null!=e.startHats&&(o.startHats=e.startHats),o},T.Themes={},T.Themes.Classic={},T.Themes.Classic.defaultBlockStyles={colour_blocks:{colourPrimary:"#f3aa60"},list_blocks:{colourPrimary:"#ecc01c"},logic_blocks:{colourPrimary:"#91c854"},loop_blocks:{colourPrimary:"#aa0d43"},math_blocks:{colourPrimary:"#00948a"},procedure_blocks:{colourPrimary:"290"},text_blocks:{colourPrimary:"#9365b8"},variable_blocks:{colourPrimary:"330"},variable_dynamic_blocks:{colourPrimary:"#bf717f"},hat_blocks:{colourPrimary:"330",hat:"cap"}},T.Themes.Classic.categoryStyles={colour_category:{colour:"20"},list_category:{colour:"260"},logic_category:{colour:"210"},loop_category:{colour:"120"},math_category:{colour:"230"},procedure_category:{colour:"290"},text_category:{colour:"160"},variable_category:{colour:"330"},variable_dynamic_category:{colour:"310"}},T.Themes.Classic=new T.Theme("classic",T.Themes.Classic.defaultBlockStyles,T.Themes.Classic.categoryStyles),T.utils.IdGenerator={},T.utils.IdGenerator.nextId_=0,T.utils.IdGenerator.getNextUniqueId=function(){return"blockly-"+(T.utils.IdGenerator.nextId_++).toString(36)},T.utils.Metrics=function(){},T.utils.toolbox={},T.utils.toolbox.CATEGORY_TOOLBOX_KIND="categoryToolbox",T.utils.toolbox.FLYOUT_TOOLBOX_KIND="flyoutToolbox",T.utils.toolbox.Position={TOP:0,BOTTOM:1,LEFT:2,RIGHT:3},T.utils.toolbox.convertToolboxDefToJson=function(t){if(!t)return null;return(t instanceof Element||"string"==typeof t)&&(t=T.utils.toolbox.parseToolboxTree(t),t=T.utils.toolbox.convertToToolboxJson_(t)),T.utils.toolbox.validateToolbox_(t),t},T.utils.toolbox.validateToolbox_=function(t){var e=t.kind;if(t=t.contents,e&&e!=T.utils.toolbox.FLYOUT_TOOLBOX_KIND&&e!=T.utils.toolbox.CATEGORY_TOOLBOX_KIND)throw Error("Invalid toolbox kind "+e+". Please supply either "+T.utils.toolbox.FLYOUT_TOOLBOX_KIND+" or "+T.utils.toolbox.CATEGORY_TOOLBOX_KIND);if(!t)throw Error("Toolbox must have a contents attribute.")},T.utils.toolbox.convertFlyoutDefToJsonArray=function(t){return t?t.contents||(Array.isArray(t)&&0<t.length&&!t[0].nodeType?t:T.utils.toolbox.xmlToJsonArray_(t)):[]},T.utils.toolbox.hasCategories=function(t){if(!t)return!1;var e=t.kind;return e?e==T.utils.toolbox.CATEGORY_TOOLBOX_KIND:!!t.contents.filter(function(t){return"CATEGORY"==t.kind.toUpperCase()}).length},T.utils.toolbox.isCategoryCollapsible=function(t){return!(!t||!t.contents||!t.contents.filter(function(t){return"CATEGORY"==t.kind.toUpperCase()}).length)},T.utils.toolbox.convertToToolboxJson_=function(t){var e={contents:T.utils.toolbox.xmlToJsonArray_(t)};return t instanceof Node&&T.utils.toolbox.addAttributes_(t,e),e},T.utils.toolbox.xmlToJsonArray_=function(t){var e=[],o,o=(o=t.childNodes)||t,i,s,n;for(t=0;i=o[t];t++){i.tagName&&(s={},n=i.tagName.toUpperCase(),"BLOCK"==(s.kind=n)?s.blockxml=i:i.childNodes&&0<i.childNodes.length&&(s.contents=T.utils.toolbox.xmlToJsonArray_(i)),T.utils.toolbox.addAttributes_(i,s),e.push(s))}return e},T.utils.toolbox.addAttributes_=function(t,e){for(var o=0;o<t.attributes.length;o++){var i=t.attributes[o];-1<i.nodeName.indexOf("css-")?(e.cssconfig=e.cssconfig||{},e.cssconfig[i.nodeName.replace("css-","")]=i.value):e[i.nodeName]=i.value}},T.utils.toolbox.parseToolboxTree=function(t){if(t){if("string"!=typeof t&&(T.utils.userAgent.IE&&t.outerHTML?t=t.outerHTML:t instanceof Element||(t=null)),"string"==typeof t&&"xml"!=(t=T.Xml.textToDom(t)).nodeName.toLowerCase())throw TypeError("Toolbox should be an <xml> document.")}else t=null;return t},T.Options=function(t){var e=!!t.readOnly,o,i,s,n,r,l,a,c,h=(e?(o=null,a=l=r=n=s=i=!1):(o=T.utils.toolbox.convertToolboxDefToJson(t.toolbox),i=T.utils.toolbox.hasCategories(o),void 0===(s=t.trashcan)&&(s=i),c=t.maxTrashcanContents,s?void 0===c&&(c=32):c=0,void 0===(n=t.collapse)&&(n=i),void 0===(r=t.comments)&&(r=i),void 0===(l=t.disable)&&(l=i),void 0===(a=t.sounds)&&(a=!0)),!!t.rtl),u=t.horizontalLayout,g,g="end"!==(g=t.toolboxPosition),p=(g=(u=void 0===u?!1:u)?g?T.utils.toolbox.Position.TOP:T.utils.toolbox.Position.BOTTOM:g==h?T.utils.toolbox.Position.RIGHT:T.utils.toolbox.Position.LEFT,t.css),d=(void 0===p&&(p=!0),"https://blockly-demo.appspot.com/static/media/"),_=(t.media?d=t.media:t.path&&(d=t.path+"media/"),void 0===t.oneBasedIndex||!!t.oneBasedIndex),I=t.renderer||"geras",C=t.plugins||{};this.RTL=h,this.oneBasedIndex=_,this.collapse=n,this.comments=r,this.disable=l,this.readOnly=e,this.maxBlocks=t.maxBlocks||1/0,this.maxInstances=t.maxInstances,this.pathToMedia=d,this.hasCategories=i,this.moveOptions=T.Options.parseMoveOptions_(t,i),this.hasScrollbars=!!this.moveOptions.scrollbars,this.hasTrashcan=s,this.maxTrashcanContents=c,this.hasSounds=a,this.hasCss=p,this.horizontalLayout=u,this.languageTree=o,this.gridOptions=T.Options.parseGridOptions_(t),this.zoomOptions=T.Options.parseZoomOptions_(t),this.toolboxPosition=g,this.theme=T.Options.parseThemeOptions_(t),this.renderer=I,this.rendererOverrides=t.rendererOverrides,this.gridPattern=null,this.parentWorkspace=t.parentWorkspace,this.plugins=C},T.BlocklyOptions=function(){},T.Options.parseMoveOptions_=function(t,e){var o=t.move||{},i={};return void 0===o.scrollbars&&void 0===t.scrollbars?i.scrollbars=e:"object"==typeof o.scrollbars?(i.scrollbars={},i.scrollbars.horizontal=!!o.scrollbars.horizontal,i.scrollbars.vertical=!!o.scrollbars.vertical,i.scrollbars.horizontal&&i.scrollbars.vertical?i.scrollbars=!0:i.scrollbars.horizontal||i.scrollbars.vertical||(i.scrollbars=!1)):i.scrollbars=!!o.scrollbars||!!t.scrollbars,i.wheel=i.scrollbars&&void 0!==o.wheel?!!o.wheel:"object"==typeof i.scrollbars,i.drag=!(!i.scrollbars||void 0!==o.drag&&!o.drag),i},T.Options.parseZoomOptions_=function(t){t=t.zoom||{};var e={};return e.controls=void 0!==t.controls&&!!t.controls,e.wheel=void 0!==t.wheel&&!!t.wheel,e.startScale=void 0===t.startScale?1:Number(t.startScale),e.maxScale=void 0===t.maxScale?3:Number(t.maxScale),e.minScale=void 0===t.minScale?.3:Number(t.minScale),e.scaleSpeed=void 0===t.scaleSpeed?1.2:Number(t.scaleSpeed),e.pinch=void 0===t.pinch?e.wheel||e.controls:!!t.pinch,e},T.Options.parseGridOptions_=function(t){t=t.grid||{};var e={};return e.spacing=Number(t.spacing)||0,e.colour=t.colour||"#888",e.length=void 0===t.length?1:Number(t.length),e.snap=0<e.spacing&&!!t.snap,e},T.Options.parseThemeOptions_=function(t){return"string"==typeof(t=t.theme||T.Themes.Classic)?T.registry.getObject(T.registry.Type.THEME,t):t instanceof T.Theme?t:T.Theme.defineTheme(t.name||"builtin"+T.utils.IdGenerator.getNextUniqueId(),t)},T.Options.parseToolboxTree=function(t){return T.utils.deprecation.warn("Blockly.Options.parseToolboxTree","September 2020","September 2021","Blockly.utils.toolbox.parseToolboxTree"),T.utils.toolbox.parseToolboxTree(t)},T.ScrollbarPair=function(t,e,o,i){this.workspace_=t,o=void 0===o||o;var s=(e=void 0===e||e)&&o;e&&(this.hScroll=new T.Scrollbar(t,!0,s,i)),o&&(this.vScroll=new T.Scrollbar(t,!1,s,i)),s&&(this.corner_=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{height:T.Scrollbar.scrollbarThickness,width:T.Scrollbar.scrollbarThickness,class:"blocklyScrollbarBackground"},null),T.utils.dom.insertAfter(this.corner_,t.getBubbleCanvas())),this.oldHostMetrics_=null},T.ScrollbarPair.prototype.dispose=function(){T.utils.dom.removeNode(this.corner_),this.oldHostMetrics_=this.workspace_=this.corner_=null,this.hScroll&&(this.hScroll.dispose(),this.hScroll=null),this.vScroll&&(this.vScroll.dispose(),this.vScroll=null)},T.ScrollbarPair.prototype.resize=function(){var t=this.workspace_.getMetrics();if(t){var e=!1,o=!1;if(this.oldHostMetrics_&&this.oldHostMetrics_.viewWidth==t.viewWidth&&this.oldHostMetrics_.viewHeight==t.viewHeight&&this.oldHostMetrics_.absoluteTop==t.absoluteTop&&this.oldHostMetrics_.absoluteLeft==t.absoluteLeft?(this.oldHostMetrics_&&this.oldHostMetrics_.scrollWidth==t.scrollWidth&&this.oldHostMetrics_.viewLeft==t.viewLeft&&this.oldHostMetrics_.scrollLeft==t.scrollLeft||(e=!0),this.oldHostMetrics_&&this.oldHostMetrics_.scrollHeight==t.scrollHeight&&this.oldHostMetrics_.viewTop==t.viewTop&&this.oldHostMetrics_.scrollTop==t.scrollTop||(o=!0)):o=e=!0,e||o){try{T.Events.disable(),this.hScroll&&e&&this.hScroll.resize(t),this.vScroll&&o&&this.vScroll.resize(t)}finally{T.Events.enable()}this.workspace_.maybeFireViewportChangeEvent()}this.hScroll&&this.vScroll&&(this.oldHostMetrics_&&this.oldHostMetrics_.viewWidth==t.viewWidth&&this.oldHostMetrics_.absoluteLeft==t.absoluteLeft||this.corner_.setAttribute("x",this.vScroll.position.x),this.oldHostMetrics_&&this.oldHostMetrics_.viewHeight==t.viewHeight&&this.oldHostMetrics_.absoluteTop==t.absoluteTop||this.corner_.setAttribute("y",this.hScroll.position.y)),this.oldHostMetrics_=t}},T.ScrollbarPair.prototype.canScrollHorizontally=function(){return!!this.hScroll},T.ScrollbarPair.prototype.canScrollVertically=function(){return!!this.vScroll},T.ScrollbarPair.prototype.setOrigin=function(t,e){this.hScroll&&this.hScroll.setOrigin(t,e),this.vScroll&&this.vScroll.setOrigin(t,e)},T.ScrollbarPair.prototype.set=function(t,e,o){this.hScroll&&this.hScroll.set(t,!1),this.vScroll&&this.vScroll.set(e,!1),!o&&void 0!==o||(t={},this.hScroll&&(t.x=this.hScroll.getRatio_()),this.vScroll&&(t.y=this.vScroll.getRatio_()),this.workspace_.setMetrics(t))},T.ScrollbarPair.prototype.setX=function(t){this.hScroll&&this.hScroll.set(t,!0)},T.ScrollbarPair.prototype.setY=function(t){this.vScroll&&this.vScroll.set(t,!0)},T.ScrollbarPair.prototype.setContainerVisible=function(t){this.hScroll&&this.hScroll.setContainerVisible(t),this.vScroll&&this.vScroll.setContainerVisible(t)},T.ScrollbarPair.prototype.isVisible=function(){var t=!1;return this.hScroll&&(t=this.hScroll.isVisible()),t=this.vScroll?t||this.vScroll.isVisible():t},T.ScrollbarPair.prototype.resizeContent=function(t){this.hScroll&&this.hScroll.resizeContentHorizontal(t),this.vScroll&&this.vScroll.resizeContentVertical(t)},T.ScrollbarPair.prototype.resizeView=function(t){this.hScroll&&this.hScroll.resizeViewHorizontal(t),this.vScroll&&this.vScroll.resizeViewVertical(t)},T.Scrollbar=function(t,e,o,i){this.workspace_=t,this.pair_=o||!1,this.horizontal_=e,this.ratio=this.oldHostMetrics_=null,this.createDom_(i),this.position=new T.utils.Coordinate(0,0),t=T.Scrollbar.scrollbarThickness,e?(this.svgBackground_.setAttribute("height",t),this.outerSvg_.setAttribute("height",t),this.svgHandle_.setAttribute("height",t-5),this.svgHandle_.setAttribute("y",2.5),this.lengthAttribute_="width",this.positionAttribute_="x"):(this.svgBackground_.setAttribute("width",t),this.outerSvg_.setAttribute("width",t),this.svgHandle_.setAttribute("width",t-5),this.svgHandle_.setAttribute("x",2.5),this.lengthAttribute_="height",this.positionAttribute_="y"),this.onMouseDownBarWrapper_=T.browserEvents.conditionalBind(this.svgBackground_,"mousedown",this,this.onMouseDownBar_),this.onMouseDownHandleWrapper_=T.browserEvents.conditionalBind(this.svgHandle_,"mousedown",this,this.onMouseDownHandle_)},T.Scrollbar.prototype.origin_=new T.utils.Coordinate(0,0),T.Scrollbar.prototype.startDragMouse_=0,T.Scrollbar.prototype.scrollbarLength_=0,T.Scrollbar.prototype.handleLength_=0,T.Scrollbar.prototype.handlePosition_=0,T.Scrollbar.prototype.isVisible_=!0,T.Scrollbar.prototype.containerVisible_=!0,T.Scrollbar.scrollbarThickness=15,T.Touch.TOUCH_ENABLED&&(T.Scrollbar.scrollbarThickness=25),T.Scrollbar.SCROLLBAR_MARGIN=.5,T.Scrollbar.metricsAreEquivalent_=function(t,e){return!(!t||!e||t.viewWidth!=e.viewWidth||t.viewHeight!=e.viewHeight||t.viewLeft!=e.viewLeft||t.viewTop!=e.viewTop||t.absoluteTop!=e.absoluteTop||t.absoluteLeft!=e.absoluteLeft||t.scrollWidth!=e.scrollWidth||t.scrollHeight!=e.scrollHeight||t.scrollLeft!=e.scrollLeft||t.scrollTop!=e.scrollTop)},T.Scrollbar.prototype.dispose=function(){this.cleanUp_(),T.browserEvents.unbind(this.onMouseDownBarWrapper_),this.onMouseDownBarWrapper_=null,T.browserEvents.unbind(this.onMouseDownHandleWrapper_),this.onMouseDownHandleWrapper_=null,T.utils.dom.removeNode(this.outerSvg_),this.svgBackground_=this.svgGroup_=this.outerSvg_=null,this.svgHandle_&&(this.workspace_.getThemeManager().unsubscribe(this.svgHandle_),this.svgHandle_=null),this.workspace_=null},T.Scrollbar.prototype.constrainHandleLength_=function(t){return t=t<=0||isNaN(t)?0:Math.min(t,this.scrollbarLength_)},T.Scrollbar.prototype.setHandleLength_=function(t){this.handleLength_=t,this.svgHandle_.setAttribute(this.lengthAttribute_,this.handleLength_)},T.Scrollbar.prototype.constrainHandlePosition_=function(t){return t=t<=0||isNaN(t)?0:Math.min(t,this.scrollbarLength_-this.handleLength_)},T.Scrollbar.prototype.setHandlePosition=function(t){this.handlePosition_=t,this.svgHandle_.setAttribute(this.positionAttribute_,this.handlePosition_)},T.Scrollbar.prototype.setScrollbarLength_=function(t){this.scrollbarLength_=t,this.outerSvg_.setAttribute(this.lengthAttribute_,this.scrollbarLength_),this.svgBackground_.setAttribute(this.lengthAttribute_,this.scrollbarLength_)},T.Scrollbar.prototype.setPosition=function(t,e){this.position.x=t,this.position.y=e,T.utils.dom.setCssTransform(this.outerSvg_,"translate("+(this.position.x+this.origin_.x)+"px,"+(this.position.y+this.origin_.y)+"px)")},T.Scrollbar.prototype.resize=function(t){if(!t&&!(t=this.workspace_.getMetrics()))return;T.Scrollbar.metricsAreEquivalent_(t,this.oldHostMetrics_)||(this.horizontal_?this.resizeHorizontal_(t):this.resizeVertical_(t),this.oldHostMetrics_=t,this.updateMetrics_())},T.Scrollbar.prototype.requiresViewResize_=function(t){return!this.oldHostMetrics_||this.oldHostMetrics_.viewWidth!==t.viewWidth||this.oldHostMetrics_.viewHeight!==t.viewHeight||this.oldHostMetrics_.absoluteLeft!==t.absoluteLeft||this.oldHostMetrics_.absoluteTop!==t.absoluteTop},T.Scrollbar.prototype.resizeHorizontal_=function(t){this.requiresViewResize_(t)?this.resizeViewHorizontal(t):this.resizeContentHorizontal(t)},T.Scrollbar.prototype.resizeViewHorizontal=function(t){var e=t.viewWidth-2*T.Scrollbar.SCROLLBAR_MARGIN;this.pair_&&(e-=T.Scrollbar.scrollbarThickness),this.setScrollbarLength_(Math.max(0,e)),e=t.absoluteLeft+T.Scrollbar.SCROLLBAR_MARGIN,this.pair_&&this.workspace_.RTL&&(e+=T.Scrollbar.scrollbarThickness),this.setPosition(e,t.absoluteTop+t.viewHeight-T.Scrollbar.scrollbarThickness-T.Scrollbar.SCROLLBAR_MARGIN),this.resizeContentHorizontal(t)},T.Scrollbar.prototype.resizeContentHorizontal=function(t){var e,e,o;t.viewWidth>=t.scrollWidth?(this.setHandleLength_(this.scrollbarLength_),this.setHandlePosition(0),this.pair_||this.setVisible(!1)):(this.pair_||this.setVisible(!0),e=this.scrollbarLength_*t.viewWidth/t.scrollWidth,e=this.constrainHandleLength_(e),this.setHandleLength_(e),e=t.scrollWidth-t.viewWidth,o=this.scrollbarLength_-this.handleLength_,t=(t.viewLeft-t.scrollLeft)/e*o,t=this.constrainHandlePosition_(t),this.setHandlePosition(t),this.ratio=o/e)},T.Scrollbar.prototype.resizeVertical_=function(t){this.requiresViewResize_(t)?this.resizeViewVertical(t):this.resizeContentVertical(t)},T.Scrollbar.prototype.resizeViewVertical=function(t){var e=t.viewHeight-2*T.Scrollbar.SCROLLBAR_MARGIN;this.pair_&&(e-=T.Scrollbar.scrollbarThickness),this.setScrollbarLength_(Math.max(0,e)),this.setPosition(this.workspace_.RTL?t.absoluteLeft+T.Scrollbar.SCROLLBAR_MARGIN:t.absoluteLeft+t.viewWidth-T.Scrollbar.scrollbarThickness-T.Scrollbar.SCROLLBAR_MARGIN,t.absoluteTop+T.Scrollbar.SCROLLBAR_MARGIN),this.resizeContentVertical(t)},T.Scrollbar.prototype.resizeContentVertical=function(t){var e,e,o;t.viewHeight>=t.scrollHeight?(this.setHandleLength_(this.scrollbarLength_),this.setHandlePosition(0),this.pair_||this.setVisible(!1)):(this.pair_||this.setVisible(!0),e=this.scrollbarLength_*t.viewHeight/t.scrollHeight,e=this.constrainHandleLength_(e),this.setHandleLength_(e),e=t.scrollHeight-t.viewHeight,o=this.scrollbarLength_-this.handleLength_,t=(t.viewTop-t.scrollTop)/e*o,t=this.constrainHandlePosition_(t),this.setHandlePosition(t),this.ratio=o/e)},T.Scrollbar.prototype.createDom_=function(t){var e="blocklyScrollbar"+(this.horizontal_?"Horizontal":"Vertical");t&&(e+=" "+t),this.outerSvg_=T.utils.dom.createSvgElement(T.utils.Svg.SVG,{class:e},null),this.svgGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{},this.outerSvg_),this.svgBackground_=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blocklyScrollbarBackground"},this.svgGroup_),t=Math.floor((T.Scrollbar.scrollbarThickness-5)/2),this.svgHandle_=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blocklyScrollbarHandle",rx:t,ry:t},this.svgGroup_),this.workspace_.getThemeManager().subscribe(this.svgHandle_,"scrollbarColour","fill"),this.workspace_.getThemeManager().subscribe(this.svgHandle_,"scrollbarOpacity","fill-opacity"),T.utils.dom.insertAfter(this.outerSvg_,this.workspace_.getParentSvg())},T.Scrollbar.prototype.isVisible=function(){return this.isVisible_},T.Scrollbar.prototype.setContainerVisible=function(t){var e=t!=this.containerVisible_;this.containerVisible_=t,e&&this.updateDisplay_()},T.Scrollbar.prototype.setVisible=function(t){var e=t!=this.isVisible();if(this.pair_)throw Error("Unable to toggle visibility of paired scrollbars.");this.isVisible_=t,e&&this.updateDisplay_()},T.Scrollbar.prototype.updateDisplay_=function(){this.containerVisible_&&this.isVisible()?this.outerSvg_.setAttribute("display","block"):this.outerSvg_.setAttribute("display","none")},T.Scrollbar.prototype.onMouseDownBar_=function(t){var e,e,o,o,i,s;this.workspace_.markFocused(),T.Touch.clearTouchIdentifier(),this.cleanUp_(),T.utils.isRightButton(t)?t.stopPropagation():(e=T.utils.mouseToSvg(t,this.workspace_.getParentSvg(),this.workspace_.getInverseScreenCTM()),e=this.horizontal_?e.x:e.y,o=T.utils.getInjectionDivXY_(this.svgHandle_),o=this.horizontal_?o.x:o.y,i=this.handlePosition_,s=.95*this.handleLength_,e<=o?i-=s:e>=o+this.handleLength_&&(i+=s),this.setHandlePosition(this.constrainHandlePosition_(i)),this.updateMetrics_(),t.stopPropagation(),t.preventDefault())},T.Scrollbar.prototype.onMouseDownHandle_=function(t){this.workspace_.markFocused(),this.cleanUp_(),T.utils.isRightButton(t)?t.stopPropagation():(this.startDragHandle=this.handlePosition_,this.workspace_.setupDragSurface(),this.startDragMouse_=this.horizontal_?t.clientX:t.clientY,T.Scrollbar.onMouseUpWrapper_=T.browserEvents.conditionalBind(document,"mouseup",this,this.onMouseUpHandle_),T.Scrollbar.onMouseMoveWrapper_=T.browserEvents.conditionalBind(document,"mousemove",this,this.onMouseMoveHandle_),t.stopPropagation(),t.preventDefault())},T.Scrollbar.prototype.onMouseMoveHandle_=function(t){this.setHandlePosition(this.constrainHandlePosition_(this.startDragHandle+((this.horizontal_?t.clientX:t.clientY)-this.startDragMouse_))),this.updateMetrics_()},T.Scrollbar.prototype.onMouseUpHandle_=function(){this.workspace_.resetDragSurface(),T.Touch.clearTouchIdentifier(),this.cleanUp_()},T.Scrollbar.prototype.cleanUp_=function(){T.hideChaff(!0),T.Scrollbar.onMouseUpWrapper_&&(T.browserEvents.unbind(T.Scrollbar.onMouseUpWrapper_),T.Scrollbar.onMouseUpWrapper_=null),T.Scrollbar.onMouseMoveWrapper_&&(T.browserEvents.unbind(T.Scrollbar.onMouseMoveWrapper_),T.Scrollbar.onMouseMoveWrapper_=null)},T.Scrollbar.prototype.getRatio_=function(){var t=this.handlePosition_/(this.scrollbarLength_-this.handleLength_);return t=isNaN(t)?0:t},T.Scrollbar.prototype.updateMetrics_=function(){var t=this.getRatio_(),e={};this.horizontal_?e.x=t:e.y=t,this.workspace_.setMetrics(e)},T.Scrollbar.prototype.set=function(t,e){this.setHandlePosition(this.constrainHandlePosition_(t*this.ratio)),!e&&void 0!==e||this.updateMetrics_()},T.Scrollbar.prototype.setOrigin=function(t,e){this.origin_=new T.utils.Coordinate(t,e)},T.Tooltip={},T.Tooltip.visible=!1,T.Tooltip.blocked_=!1,T.Tooltip.LIMIT=50,T.Tooltip.mouseOutPid_=0,T.Tooltip.showPid_=0,T.Tooltip.lastX_=0,T.Tooltip.lastY_=0,T.Tooltip.element_=null,T.Tooltip.poisonedElement_=null,T.Tooltip.OFFSET_X=0,T.Tooltip.OFFSET_Y=10,T.Tooltip.RADIUS_OK=10,T.Tooltip.HOVER_MS=750,T.Tooltip.MARGINS=5,T.Tooltip.DIV=null,T.Tooltip.getTooltipOfObject=function(t){if(t=T.Tooltip.getTargetObject_(t)){for(t=t.tooltip;"function"==typeof t;)t=t();if("string"!=typeof t)throw Error("Tooltip function must return a string.");return t}return""},T.Tooltip.getTargetObject_=function(t){for(;t&&t.tooltip;){if("string"==typeof t.tooltip||"function"==typeof t.tooltip)return t;t=t.tooltip}return null},T.Tooltip.createDom=function(){T.Tooltip.DIV||(T.Tooltip.DIV=document.createElement("div"),T.Tooltip.DIV.className="blocklyTooltipDiv",(T.parentContainer||document.body).appendChild(T.Tooltip.DIV))},T.Tooltip.bindMouseEvents=function(t){t.mouseOverWrapper_=T.browserEvents.bind(t,"mouseover",null,T.Tooltip.onMouseOver_),t.mouseOutWrapper_=T.browserEvents.bind(t,"mouseout",null,T.Tooltip.onMouseOut_),t.addEventListener("mousemove",T.Tooltip.onMouseMove_,!1)},T.Tooltip.unbindMouseEvents=function(t){t&&(T.browserEvents.unbind(t.mouseOverWrapper_),T.browserEvents.unbind(t.mouseOutWrapper_),t.removeEventListener("mousemove",T.Tooltip.onMouseMove_))},T.Tooltip.onMouseOver_=function(t){T.Tooltip.blocked_||(t=T.Tooltip.getTargetObject_(t.currentTarget),T.Tooltip.element_!=t&&(T.Tooltip.hide(),T.Tooltip.poisonedElement_=null,T.Tooltip.element_=t),clearTimeout(T.Tooltip.mouseOutPid_))},T.Tooltip.onMouseOut_=function(t){T.Tooltip.blocked_||(T.Tooltip.mouseOutPid_=setTimeout(function(){T.Tooltip.element_=null,T.Tooltip.poisonedElement_=null,T.Tooltip.hide()},1),clearTimeout(T.Tooltip.showPid_))},T.Tooltip.onMouseMove_=function(t){var e;T.Tooltip.element_&&T.Tooltip.element_.tooltip&&!T.Tooltip.blocked_&&(T.Tooltip.visible?(e=T.Tooltip.lastX_-t.pageX,t=T.Tooltip.lastY_-t.pageY,Math.sqrt(e*e+t*t)>T.Tooltip.RADIUS_OK&&T.Tooltip.hide()):T.Tooltip.poisonedElement_!=T.Tooltip.element_&&(clearTimeout(T.Tooltip.showPid_),T.Tooltip.lastX_=t.pageX,T.Tooltip.lastY_=t.pageY,T.Tooltip.showPid_=setTimeout(T.Tooltip.show_,T.Tooltip.HOVER_MS)))},T.Tooltip.dispose=function(){T.Tooltip.element_=null,T.Tooltip.poisonedElement_=null,T.Tooltip.hide()},T.Tooltip.hide=function(){T.Tooltip.visible&&(T.Tooltip.visible=!1,T.Tooltip.DIV)&&(T.Tooltip.DIV.style.display="none"),T.Tooltip.showPid_&&clearTimeout(T.Tooltip.showPid_)},T.Tooltip.block=function(){T.Tooltip.hide(),T.Tooltip.blocked_=!0},T.Tooltip.unblock=function(){T.Tooltip.blocked_=!1},T.Tooltip.show_=function(){if(!T.Tooltip.blocked_&&(T.Tooltip.poisonedElement_=T.Tooltip.element_,T.Tooltip.DIV)){T.Tooltip.DIV.textContent="";var t=T.Tooltip.getTooltipOfObject(T.Tooltip.element_),t;t=(t=T.utils.string.wrap(t,T.Tooltip.LIMIT)).split("\n");for(var e=0;e<t.length;e++){var o=document.createElement("div");o.appendChild(document.createTextNode(t[e])),T.Tooltip.DIV.appendChild(o)}t=T.Tooltip.element_.RTL,e=document.documentElement.clientWidth,o=document.documentElement.clientHeight,T.Tooltip.DIV.style.direction=t?"rtl":"ltr",T.Tooltip.DIV.style.display="block",T.Tooltip.visible=!0;var i=T.Tooltip.lastX_,i=t?i-(T.Tooltip.OFFSET_X+T.Tooltip.DIV.offsetWidth):i+T.Tooltip.OFFSET_X,s=T.Tooltip.lastY_+T.Tooltip.OFFSET_Y;s+T.Tooltip.DIV.offsetHeight>o+window.scrollY&&(s-=T.Tooltip.DIV.offsetHeight+2*T.Tooltip.OFFSET_Y),t?i=Math.max(T.Tooltip.MARGINS-window.scrollX,i):i+T.Tooltip.DIV.offsetWidth>e+window.scrollX-2*T.Tooltip.MARGINS&&(i=e-T.Tooltip.DIV.offsetWidth-2*T.Tooltip.MARGINS),T.Tooltip.DIV.style.top=s+"px",T.Tooltip.DIV.style.left=i+"px"}},T.utils.aria={},T.utils.aria.ARIA_PREFIX_="aria-",T.utils.aria.ROLE_ATTRIBUTE_="role",T.utils.aria.Role={GRID:"grid",GRIDCELL:"gridcell",GROUP:"group",LISTBOX:"listbox",MENU:"menu",MENUITEM:"menuitem",MENUITEMCHECKBOX:"menuitemcheckbox",OPTION:"option",PRESENTATION:"presentation",ROW:"row",TREE:"tree",TREEITEM:"treeitem"},T.utils.aria.State={ACTIVEDESCENDANT:"activedescendant",COLCOUNT:"colcount",DISABLED:"disabled",EXPANDED:"expanded",INVALID:"invalid",LABEL:"label",LABELLEDBY:"labelledby",LEVEL:"level",ORIENTATION:"orientation",POSINSET:"posinset",ROWCOUNT:"rowcount",SELECTED:"selected",SETSIZE:"setsize",VALUEMAX:"valuemax",VALUEMIN:"valuemin"},T.utils.aria.setRole=function(t,e){t.setAttribute(T.utils.aria.ROLE_ATTRIBUTE_,e)},T.utils.aria.setState=function(t,e,o){Array.isArray(o)&&(o=o.join(" ")),t.setAttribute(T.utils.aria.ARIA_PREFIX_+e,o)},T.WorkspaceDragSurfaceSvg=function(t){this.container_=t,this.createDom()},T.WorkspaceDragSurfaceSvg.prototype.SVG_=null,T.WorkspaceDragSurfaceSvg.prototype.container_=null,T.WorkspaceDragSurfaceSvg.prototype.createDom=function(){this.SVG_||(this.SVG_=T.utils.dom.createSvgElement(T.utils.Svg.SVG,{xmlns:T.utils.dom.SVG_NS,"xmlns:html":T.utils.dom.HTML_NS,"xmlns:xlink":T.utils.dom.XLINK_NS,version:"1.1",class:"blocklyWsDragSurface blocklyOverflowVisible"},null),this.container_.appendChild(this.SVG_))},T.WorkspaceDragSurfaceSvg.prototype.translateSurface=function(t,e){t=t.toFixed(0),e=e.toFixed(0),this.SVG_.style.display="block",T.utils.dom.setCssTransform(this.SVG_,"translate3d("+t+"px, "+e+"px, 0px)")},T.WorkspaceDragSurfaceSvg.prototype.getSurfaceTranslation=function(){return T.utils.getRelativeXY(this.SVG_)},T.WorkspaceDragSurfaceSvg.prototype.clearAndHide=function(t){if(!t)throw Error("Couldn't clear and hide the drag surface: missing new surface.");var e=this.SVG_.childNodes[0],o=this.SVG_.childNodes[1];if(!(e&&o&&T.utils.dom.hasClass(e,"blocklyBlockCanvas")&&T.utils.dom.hasClass(o,"blocklyBubbleCanvas")))throw Error("Couldn't clear and hide the drag surface. A node was missing.");if(null!=this.previousSibling_?T.utils.dom.insertAfter(e,this.previousSibling_):t.insertBefore(e,t.firstChild),T.utils.dom.insertAfter(o,e),this.SVG_.style.display="none",this.SVG_.childNodes.length)throw Error("Drag surface was not cleared.");T.utils.dom.setCssTransform(this.SVG_,""),this.previousSibling_=null},T.WorkspaceDragSurfaceSvg.prototype.setContentsAndShow=function(t,e,o,i,s,n){if(this.SVG_.childNodes.length)throw Error("Already dragging a block.");this.previousSibling_=o,t.setAttribute("transform","translate(0, 0) scale("+n+")"),e.setAttribute("transform","translate(0, 0) scale("+n+")"),this.SVG_.setAttribute("width",i),this.SVG_.setAttribute("height",s),this.SVG_.appendChild(t),this.SVG_.appendChild(e),this.SVG_.style.display="block"},T.blockRendering={},T.blockRendering.useDebugger=!1,T.blockRendering.register=function(t,e){T.registry.register(T.registry.Type.RENDERER,t,e)},T.blockRendering.unregister=function(t){T.registry.unregister(T.registry.Type.RENDERER,t)},T.blockRendering.startDebugger=function(){T.blockRendering.useDebugger=!0},T.blockRendering.stopDebugger=function(){T.blockRendering.useDebugger=!1},T.blockRendering.init=function(t,e,o){return(t=new(T.registry.getClass(T.registry.Type.RENDERER,t))(t)).init(e,o),t},T.ASTNode=function(t,e,o){if(!e)throw Error("Cannot create a node without a location.");this.type_=t,this.isConnection_=T.ASTNode.isConnectionType_(t),this.location_=e,this.wsCoordinate_=null,this.processParams_(o||null)},T.ASTNode.types={FIELD:"field",BLOCK:"block",INPUT:"input",OUTPUT:"output",NEXT:"next",PREVIOUS:"previous",STACK:"stack",WORKSPACE:"workspace"},T.ASTNode.NAVIGATE_ALL_FIELDS=!1,T.ASTNode.DEFAULT_OFFSET_Y=-20,T.ASTNode.isConnectionType_=function(t){switch(t){case T.ASTNode.types.PREVIOUS:case T.ASTNode.types.NEXT:case T.ASTNode.types.INPUT:case T.ASTNode.types.OUTPUT:return!0}return!1},T.ASTNode.createFieldNode=function(t){return t?new T.ASTNode(T.ASTNode.types.FIELD,t):null},T.ASTNode.createConnectionNode=function(t){if(!t)return null;var e=t.type;return e==T.connectionTypes.INPUT_VALUE||e==T.connectionTypes.NEXT_STATEMENT&&t.getParentInput()?T.ASTNode.createInputNode(t.getParentInput()):e==T.connectionTypes.NEXT_STATEMENT?new T.ASTNode(T.ASTNode.types.NEXT,t):e==T.connectionTypes.OUTPUT_VALUE?new T.ASTNode(T.ASTNode.types.OUTPUT,t):e==T.connectionTypes.PREVIOUS_STATEMENT?new T.ASTNode(T.ASTNode.types.PREVIOUS,t):null},T.ASTNode.createInputNode=function(t){return t&&t.connection?new T.ASTNode(T.ASTNode.types.INPUT,t.connection):null},T.ASTNode.createBlockNode=function(t){return t?new T.ASTNode(T.ASTNode.types.BLOCK,t):null},T.ASTNode.createStackNode=function(t){return t?new T.ASTNode(T.ASTNode.types.STACK,t):null},T.ASTNode.createWorkspaceNode=function(t,e){return e&&t?new T.ASTNode(T.ASTNode.types.WORKSPACE,t,{wsCoordinate:e}):null},T.ASTNode.createTopNode=function(t){var e=t.previousConnection||t.outputConnection;return e?T.ASTNode.createConnectionNode(e):T.ASTNode.createBlockNode(t)},T.ASTNode.prototype.processParams_=function(t){t&&t.wsCoordinate&&(this.wsCoordinate_=t.wsCoordinate)},T.ASTNode.prototype.getLocation=function(){return this.location_},T.ASTNode.prototype.getType=function(){return this.type_},T.ASTNode.prototype.getWsCoordinate=function(){return this.wsCoordinate_},T.ASTNode.prototype.isConnection=function(){return this.isConnection_},T.ASTNode.prototype.findNextForInput_=function(){for(var t,e=(t=this.location_.getParentInput()).getSourceBlock(),t=e.inputList.indexOf(t)+1,o;o=e.inputList[t];t++){for(var i=o.fieldRow,s=0,n;n=i[s];s++)if(n.isClickable()||T.ASTNode.NAVIGATE_ALL_FIELDS)return T.ASTNode.createFieldNode(n);if(o.connection)return T.ASTNode.createInputNode(o)}return null},T.ASTNode.prototype.findNextForField_=function(){for(var t,e=(t=this.location_).getParentInput(),o=t.getSourceBlock(),i=o.inputList.indexOf(e),t=e.fieldRow.indexOf(t)+1;e=o.inputList[i];i++){for(var s=e.fieldRow;t<s.length;){if(s[t].isClickable()||T.ASTNode.NAVIGATE_ALL_FIELDS)return T.ASTNode.createFieldNode(s[t]);t++}if(t=0,e.connection)return T.ASTNode.createInputNode(e)}return null},T.ASTNode.prototype.findPrevForInput_=function(){for(var t=this.location_.getParentInput(),e=t.getSourceBlock(),o=e.inputList.indexOf(t),i;i=e.inputList[o];o--){if(i.connection&&i!==t)return T.ASTNode.createInputNode(i);for(var i,s=(i=i.fieldRow).length-1,n;n=i[s];s--)if(n.isClickable()||T.ASTNode.NAVIGATE_ALL_FIELDS)return T.ASTNode.createFieldNode(n)}return null},T.ASTNode.prototype.findPrevForField_=function(){for(var t,e=(t=this.location_).getParentInput(),o=t.getSourceBlock(),i=o.inputList.indexOf(e),t=e.fieldRow.indexOf(t)-1,s;s=o.inputList[i];i--){if(s.connection&&s!==e)return T.ASTNode.createInputNode(s);for(s=s.fieldRow;-1<t;){if(s[t].isClickable()||T.ASTNode.NAVIGATE_ALL_FIELDS)return T.ASTNode.createFieldNode(s[t]);t--}0<=i-1&&(t=o.inputList[i-1].fieldRow.length-1)}return null},T.ASTNode.prototype.navigateBetweenStacks_=function(t){var e;if(!(e=(e=this.getLocation())instanceof T.Block?e:e.getSourceBlock())||!e.workspace)return null;for(var o=e.getRootBlock(),e=o.workspace.getTopBlocks(!0),i=0,s;s=e[i];i++)if(o.id==s.id)return-1==(t=i+(t?1:-1))||t==e.length?null:T.ASTNode.createStackNode(e[t]);throw Error("Couldn't find "+(t?"next":"previous")+" stack?!")},T.ASTNode.prototype.findTopASTNodeForBlock_=function(t){var e=t.previousConnection||t.outputConnection;return e?T.ASTNode.createConnectionNode(e):T.ASTNode.createBlockNode(t)},T.ASTNode.prototype.getOutAstNodeForBlock_=function(t){if(!t)return null;var e=(t=t.getTopStackBlock()).previousConnection||t.outputConnection;return e&&e.targetConnection&&e.targetConnection.getParentInput()?T.ASTNode.createInputNode(e.targetConnection.getParentInput()):T.ASTNode.createStackNode(t)},T.ASTNode.prototype.findFirstFieldOrInput_=function(t){t=t.inputList;for(var e=0,o;o=t[e];e++){for(var i=o.fieldRow,s=0,n;n=i[s];s++)if(n.isClickable()||T.ASTNode.NAVIGATE_ALL_FIELDS)return T.ASTNode.createFieldNode(n);if(o.connection)return T.ASTNode.createInputNode(o)}return null},T.ASTNode.prototype.getSourceBlock=function(){return this.getType()===T.ASTNode.types.BLOCK||this.getType()===T.ASTNode.types.STACK?this.getLocation():this.getType()===T.ASTNode.types.WORKSPACE?null:this.getLocation().getSourceBlock()},T.ASTNode.prototype.next=function(){switch(this.type_){case T.ASTNode.types.STACK:return this.navigateBetweenStacks_(!0);case T.ASTNode.types.OUTPUT:var t=this.location_;return T.ASTNode.createBlockNode(t.getSourceBlock());case T.ASTNode.types.FIELD:return this.findNextForField_();case T.ASTNode.types.INPUT:return this.findNextForInput_();case T.ASTNode.types.BLOCK:return T.ASTNode.createConnectionNode(this.location_.nextConnection);case T.ASTNode.types.PREVIOUS:return t=this.location_,T.ASTNode.createBlockNode(t.getSourceBlock());case T.ASTNode.types.NEXT:return t=this.location_,T.ASTNode.createConnectionNode(t.targetConnection)}return null},T.ASTNode.prototype.in=function(){switch(this.type_){case T.ASTNode.types.WORKSPACE:var t=this.location_.getTopBlocks(!0);if(0<t.length)return T.ASTNode.createStackNode(t[0]);break;case T.ASTNode.types.STACK:return t=this.location_,this.findTopASTNodeForBlock_(t);case T.ASTNode.types.BLOCK:return t=this.location_,this.findFirstFieldOrInput_(t);case T.ASTNode.types.INPUT:return T.ASTNode.createConnectionNode(this.location_.targetConnection)}return null},T.ASTNode.prototype.prev=function(){switch(this.type_){case T.ASTNode.types.STACK:return this.navigateBetweenStacks_(!1);case T.ASTNode.types.FIELD:return this.findPrevForField_();case T.ASTNode.types.INPUT:return this.findPrevForInput_();case T.ASTNode.types.BLOCK:var t=this.location_;return T.ASTNode.createConnectionNode(t.previousConnection||t.outputConnection);case T.ASTNode.types.PREVIOUS:if((t=(t=this.location_).targetConnection)&&!t.getParentInput())return T.ASTNode.createConnectionNode(t);break;case T.ASTNode.types.NEXT:return t=this.location_,T.ASTNode.createBlockNode(t.getSourceBlock())}return null},T.ASTNode.prototype.out=function(){switch(this.type_){case T.ASTNode.types.STACK:var t=this.location_,e=t.getRelativeToSurfaceXY(),e=new T.utils.Coordinate(e.x,e.y+T.ASTNode.DEFAULT_OFFSET_Y);return T.ASTNode.createWorkspaceNode(t.workspace,e);case T.ASTNode.types.OUTPUT:return(e=(t=this.location_).targetConnection)?T.ASTNode.createConnectionNode(e):T.ASTNode.createStackNode(t.getSourceBlock());case T.ASTNode.types.FIELD:return T.ASTNode.createBlockNode(this.location_.getSourceBlock());case T.ASTNode.types.INPUT:return t=this.location_,T.ASTNode.createBlockNode(t.getSourceBlock());case T.ASTNode.types.BLOCK:return t=this.location_,this.getOutAstNodeForBlock_(t);case T.ASTNode.types.PREVIOUS:return t=this.location_,this.getOutAstNodeForBlock_(t.getSourceBlock());case T.ASTNode.types.NEXT:return t=this.location_,this.getOutAstNodeForBlock_(t.getSourceBlock())}return null},T.Blocks=Object.create(null),T.utils.deprecation={},T.utils.deprecation.warn=function(t,e,o,i){t=t+" was deprecated on "+e+" and will be deleted on "+o+".",i&&(t+="\nUse "+i+" instead."),console.warn(t)},T.Connection=function(t,e){this.sourceBlock_=t,this.type=e},T.Connection.CAN_CONNECT=0,T.Connection.REASON_SELF_CONNECTION=1,T.Connection.REASON_WRONG_TYPE=2,T.Connection.REASON_TARGET_NULL=3,T.Connection.REASON_CHECKS_FAILED=4,T.Connection.REASON_DIFFERENT_WORKSPACES=5,T.Connection.REASON_SHADOW_PARENT=6,T.Connection.REASON_DRAG_CHECKS_FAILED=7,T.Connection.prototype.targetConnection=null,T.Connection.prototype.disposed=!1,T.Connection.prototype.check_=null,T.Connection.prototype.shadowDom_=null,T.Connection.prototype.x=0,T.Connection.prototype.y=0,T.Connection.prototype.connect_=function(t){var e=this,o=e.getSourceBlock(),i=t.getSourceBlock(),s;if(t.isConnected()&&t.disconnect(),e.isConnected()){var n=e.targetBlock(),r=e.getShadowDom(),l;if(e.shadowDom_=null,n.isShadow())r=T.Xml.blockToDom(n),n.dispose(!1),n=null;else if(e.type==T.connectionTypes.INPUT_VALUE){if(!n.outputConnection)throw Error("Orphan block does not have an output connection.");var a=T.Connection.lastConnectionInRow(i,n);a&&(n.outputConnection.connect(a),n=null)}else if(e.type==T.connectionTypes.NEXT_STATEMENT){if(!n.previousConnection)throw Error("Orphan block does not have a previous connection.");for(a=i;a.nextConnection;){var c=a.getNextBlock();if(!c||c.isShadow()){n.workspace.connectionChecker.canConnect(n.previousConnection,a.nextConnection,!1)&&(a.nextConnection.connect(n.previousConnection),n=null);break}a=c}}n&&(e.disconnect(),T.Events.recordUndo)&&(l=T.Events.getGroup(),setTimeout(function(){n.workspace&&!n.getParent()&&(T.Events.setGroup(l),n.outputConnection?n.outputConnection.onFailedConnect(e):n.previousConnection&&n.previousConnection.onFailedConnect(e),T.Events.setGroup(!1))},T.BUMP_DELAY)),e.shadowDom_=r}T.Events.isEnabled()&&(s=new(T.Events.get(T.Events.BLOCK_MOVE))(i)),T.Connection.connectReciprocally_(e,t),i.setParent(o),s&&(s.recordNew(),T.Events.fire(s))},T.Connection.prototype.dispose=function(){var t;this.isConnected()&&(this.setShadowDom(null),t=this.targetBlock())&&t.unplug(),this.disposed=!0},T.Connection.prototype.getSourceBlock=function(){return this.sourceBlock_},T.Connection.prototype.isSuperior=function(){return this.type==T.connectionTypes.INPUT_VALUE||this.type==T.connectionTypes.NEXT_STATEMENT},T.Connection.prototype.isConnected=function(){return!!this.targetConnection},T.Connection.prototype.canConnectWithReason=function(t){return T.utils.deprecation.warn("Connection.prototype.canConnectWithReason","July 2020","July 2021","the workspace's connection checker"),this.getConnectionChecker().canConnectWithReason(this,t,!1)},T.Connection.prototype.checkConnection=function(t){T.utils.deprecation.warn("Connection.prototype.checkConnection","July 2020","July 2021","the workspace's connection checker");var e=this.getConnectionChecker(),o=e.canConnectWithReason(this,t,!1);if(o!=T.Connection.CAN_CONNECT)throw Error(e.getErrorMessage(o,this,t))},T.Connection.prototype.getConnectionChecker=function(){return this.sourceBlock_.workspace.connectionChecker},T.Connection.prototype.isConnectionAllowed=function(t){return T.utils.deprecation.warn("Connection.prototype.isConnectionAllowed","July 2020","July 2021","the workspace's connection checker"),this.getConnectionChecker().canConnect(this,t,!0)},T.Connection.prototype.onFailedConnect=function(t){},T.Connection.prototype.connect=function(t){var e;this.targetConnection!=t&&this.getConnectionChecker().canConnect(this,t,!1)&&((e=T.Events.getGroup())||T.Events.setGroup(!0),this.isSuperior()?this.connect_(t):t.connect_(this),e||T.Events.setGroup(!1))},T.Connection.connectReciprocally_=function(t,e){if(!t||!e)throw Error("Cannot connect null connections.");(t.targetConnection=e).targetConnection=t},T.Connection.singleConnection_=function(t,e){var o=null;e=e.outputConnection;for(var i=0;i<t.inputList.length;i++){var s=t.inputList[i].connection,n=e.getConnectionChecker();if(s&&s.type==T.connectionTypes.INPUT_VALUE&&n.canConnect(e,s,!1)){if(o)return null;o=s}}return o},T.Connection.lastConnectionInRow=function(t,e){for(var o;o=T.Connection.singleConnection_(t,e);)if(!(t=o.targetBlock())||t.isShadow())return o;return null},T.Connection.prototype.disconnect=function(){var t=this.targetConnection,e,o,t;if(!t)throw Error("Source connection not connected.");if(t.targetConnection!=this)throw Error("Target connection not connected to source connection.");this.isSuperior()?(e=this.sourceBlock_,o=t.getSourceBlock(),t=this):(e=t.getSourceBlock(),o=this.sourceBlock_);var i=T.Events.getGroup();i||T.Events.setGroup(!0),this.disconnectInternal_(e,o),o.isShadow()||t.respawnShadow_(),i||T.Events.setGroup(!1)},T.Connection.prototype.disconnectInternal_=function(t,e){var o;T.Events.isEnabled()&&(o=new(T.Events.get(T.Events.BLOCK_MOVE))(e)),this.targetConnection=this.targetConnection.targetConnection=null,e.setParent(null),o&&(o.recordNew(),T.Events.fire(o))},T.Connection.prototype.respawnShadow_=function(){var t=this.getSourceBlock(),e=this.getShadowDom();if(t.workspace&&e)if((t=T.Xml.domToBlock(e,t.workspace)).outputConnection)this.connect(t.outputConnection);else{if(!t.previousConnection)throw Error("Child block does not have output or previous statement.");this.connect(t.previousConnection)}},T.Connection.prototype.targetBlock=function(){return this.isConnected()?this.targetConnection.getSourceBlock():null},T.Connection.prototype.checkType=function(t){return T.utils.deprecation.warn("Connection.prototype.checkType","October 2019","January 2021","the workspace's connection checker"),this.getConnectionChecker().canConnect(this,t,!1)},T.Connection.prototype.checkType_=function(t){return T.utils.deprecation.warn("Connection.prototype.checkType_","October 2019","January 2021","the workspace's connection checker"),this.checkType(t)},T.Connection.prototype.onCheckChanged_=function(){!this.isConnected()||this.targetConnection&&this.getConnectionChecker().canConnect(this,this.targetConnection,!1)||(this.isSuperior()?this.targetBlock():this.sourceBlock_).unplug()},T.Connection.prototype.setCheck=function(t){return t?(Array.isArray(t)||(t=[t]),this.check_=t,this.onCheckChanged_()):this.check_=null,this},T.Connection.prototype.getCheck=function(){return this.check_},T.Connection.prototype.setShadowDom=function(t){this.shadowDom_=t,(t=this.targetBlock())?t.isShadow()&&(t.dispose(!1),this.respawnShadow_()):this.respawnShadow_()},T.Connection.prototype.getShadowDom=function(){return this.shadowDom_},T.Connection.prototype.neighbours=function(t){return[]},T.Connection.prototype.getParentInput=function(){for(var t=null,e=this.sourceBlock_,o=e.inputList,i=0;i<e.inputList.length;i++)if(o[i].connection===this){t=o[i];break}return t},T.Connection.prototype.toString=function(){var t=this.sourceBlock_;if(!t)return"Orphan Connection";if(t.outputConnection==this)var e="Output Connection of ";else if(t.previousConnection==this)e="Previous Connection of ";else if(t.nextConnection==this)e="Next Connection of ";else{for(var e=null,o=0,i;i=t.inputList[o];o++)if(i.connection==this){e=i;break}if(!e)return console.warn("Connection not actually connected to sourceBlock_"),"Orphan Connection";e='Input "'+e.name+'" connection on '}return e+t.toDevString()},T.Extensions={},T.Extensions.ALL_={},T.Extensions.register=function(t,e){if("string"!=typeof t||""==t.trim())throw Error('Error: Invalid extension name "'+t+'"');if(T.Extensions.ALL_[t])throw Error('Error: Extension "'+t+'" is already registered.');if("function"!=typeof e)throw Error('Error: Extension "'+t+'" must be a function');T.Extensions.ALL_[t]=e},T.Extensions.registerMixin=function(t,e){if(!e||"object"!=typeof e)throw Error('Error: Mixin "'+t+'" must be a object');T.Extensions.register(t,function(){this.mixin(e)})},T.Extensions.registerMutator=function(t,e,o,i){var s='Error when registering mutator "'+t+'": ',n=(T.Extensions.checkHasFunction_(s,e.domToMutation,"domToMutation"),T.Extensions.checkHasFunction_(s,e.mutationToDom,"mutationToDom"),T.Extensions.checkMutatorDialog_(e,s));if(o&&"function"!=typeof o)throw Error('Extension "'+t+'" is not a function');T.Extensions.register(t,function(){if(n){if(!T.Mutator)throw Error(s+"Missing require for Blockly.Mutator");this.setMutator(new T.Mutator(i||[]))}this.mixin(e),o&&o.apply(this)})},T.Extensions.unregister=function(t){T.Extensions.ALL_[t]?delete T.Extensions.ALL_[t]:console.warn('No extension mapping for name "'+t+'" found to unregister')},T.Extensions.apply=function(t,e,o){var i=T.Extensions.ALL_[t],s;if("function"!=typeof i)throw Error('Error: Extension "'+t+'" not found.');if(o?T.Extensions.checkNoMutatorProperties_(t,e):s=T.Extensions.getMutatorProperties_(e),i.apply(e),o)T.Extensions.checkBlockHasMutatorProperties_('Error after applying mutator "'+t+'": ',e);else if(!T.Extensions.mutatorPropertiesMatch_(s,e))throw Error('Error when applying extension "'+t+'": mutation properties changed when applying a non-mutator extension.')},T.Extensions.checkHasFunction_=function(t,e,o){if(!e)throw Error(t+'missing required property "'+o+'"');if("function"!=typeof e)throw Error(t+'" required property "'+o+'" must be a function')},T.Extensions.checkNoMutatorProperties_=function(t,e){if(T.Extensions.getMutatorProperties_(e).length)throw Error('Error: tried to apply mutation "'+t+'" to a block that already has mutator functions.  Block id: '+e.id)},T.Extensions.checkMutatorDialog_=function(t,e){var o=void 0!==t.compose,i=void 0!==t.decompose;if(o&&i){if("function"!=typeof t.compose)throw Error(e+"compose must be a function.");if("function"!=typeof t.decompose)throw Error(e+"decompose must be a function.");return!0}if(o||i)throw Error(e+'Must have both or neither of "compose" and "decompose"');return!1},T.Extensions.checkBlockHasMutatorProperties_=function(t,e){if("function"!=typeof e.domToMutation)throw Error(t+'Applying a mutator didn\'t add "domToMutation"');if("function"!=typeof e.mutationToDom)throw Error(t+'Applying a mutator didn\'t add "mutationToDom"');T.Extensions.checkMutatorDialog_(e,t)},T.Extensions.getMutatorProperties_=function(t){var e=[];return void 0!==t.domToMutation&&e.push(t.domToMutation),void 0!==t.mutationToDom&&e.push(t.mutationToDom),void 0!==t.compose&&e.push(t.compose),void 0!==t.decompose&&e.push(t.decompose),e},T.Extensions.mutatorPropertiesMatch_=function(t,e){if((e=T.Extensions.getMutatorProperties_(e)).length!=t.length)return!1;for(var o=0;o<e.length;o++)if(t[o]!=e[o])return!1;return!0},T.Extensions.buildTooltipForDropdown=function(o,i){var s=[];return"object"==typeof document&&T.utils.runAfterPageLoad(function(){for(var t in i)T.utils.checkMessageReferences(i[t])}),function(){this.type&&-1==s.indexOf(this.type)&&(T.Extensions.checkDropdownOptionsInTable_(this,o,i),s.push(this.type)),this.setTooltip(function(){var t=String(this.getFieldValue(o)),e=i[t];return null==e?-1==s.indexOf(this.type)&&(t="No tooltip mapping for value "+t+" of field "+o,null!=this.type&&(t+=" of block type "+this.type),console.warn(t+".")):e=T.utils.replaceMessageReferences(e),e}.bind(this))}},T.Extensions.checkDropdownOptionsInTable_=function(t,e,o){var i;if(!(i=t.getField(e)).isOptionListDynamic())for(var i=i.getOptions(),s=0;s<i.length;++s){var n=i[s][1];null==o[n]&&console.warn("No tooltip mapping for value "+n+" of field "+e+" of block type "+t.type)}},T.Extensions.buildTooltipWithFieldText=function(e,o){return"object"==typeof document&&T.utils.runAfterPageLoad(function(){T.utils.checkMessageReferences(e)}),function(){this.setTooltip(function(){var t=this.getField(o);return T.utils.replaceMessageReferences(e).replace("%1",t?t.getText():"")}.bind(this))}},T.Extensions.extensionParentTooltip_=function(){this.tooltipWhenNotConnected_=this.tooltip,this.setTooltip(function(){var t=this.getParent();return t&&t.getInputsInline()&&t.tooltip||this.tooltipWhenNotConnected_}.bind(this))},T.Extensions.register("parent_tooltip_when_inline",T.Extensions.extensionParentTooltip_),T.fieldRegistry={},T.fieldRegistry.register=function(t,e){T.registry.register(T.registry.Type.FIELD,t,e)},T.fieldRegistry.unregister=function(t){T.registry.unregister(T.registry.Type.FIELD,t)},T.fieldRegistry.fromJson=function(t){var e=T.registry.getObject(T.registry.Type.FIELD,t.type);return e?e.fromJson(t):(console.warn("Blockly could not create a field of type "+t.type+". The field is probably not being registered. This could be because the file is not loaded, the field does not register itself (Issue #1584), or the registration is not being reached."),null)},T.blockAnimations={},T.blockAnimations.disconnectPid_=0,T.blockAnimations.disconnectGroup_=null,T.blockAnimations.disposeUiEffect=function(t){var e=t.workspace,o=t.getSvgRoot();e.getAudioManager().play("delete"),t=e.getSvgXY(o),(o=o.cloneNode(!0)).translateX_=t.x,o.translateY_=t.y,o.setAttribute("transform","translate("+t.x+","+t.y+")"),e.getParentSvg().appendChild(o),o.bBox_=o.getBBox(),T.blockAnimations.disposeUiStep_(o,e.RTL,new Date,e.scale)},T.blockAnimations.disposeUiStep_=function(t,e,o,i){var s=(new Date-o)/150;1<s?T.utils.dom.removeNode(t):(t.setAttribute("transform","translate("+(t.translateX_+(e?-1:1)*t.bBox_.width*i/2*s)+","+(t.translateY_+t.bBox_.height*i*s)+") scale("+(1-s)*i+")"),setTimeout(T.blockAnimations.disposeUiStep_,10,t,e,o,i))},T.blockAnimations.connectionUiEffect=function(t){var e=t.workspace,o=e.scale,i;e.getAudioManager().play("click"),o<1||(i=e.getSvgXY(t.getSvgRoot()),t.outputConnection?(i.x+=(t.RTL?3:-3)*o,i.y+=13*o):t.previousConnection&&(i.x+=(t.RTL?-23:23)*o,i.y+=3*o),t=T.utils.dom.createSvgElement(T.utils.Svg.CIRCLE,{cx:i.x,cy:i.y,r:0,fill:"none",stroke:"#888","stroke-width":10},e.getParentSvg()),T.blockAnimations.connectionUiStep_(t,new Date,o))},T.blockAnimations.connectionUiStep_=function(t,e,o){var i=(new Date-e)/150;1<i?T.utils.dom.removeNode(t):(t.setAttribute("r",25*i*o),t.style.opacity=1-i,T.blockAnimations.disconnectPid_=setTimeout(T.blockAnimations.connectionUiStep_,10,t,e,o))},T.blockAnimations.disconnectUiEffect=function(t){var e,e;t.workspace.getAudioManager().play("disconnect"),t.workspace.scale<1||(e=t.getHeightWidth().height,e=Math.atan(10/e)/Math.PI*180,t.RTL||(e*=-1),T.blockAnimations.disconnectUiStep_(t.getSvgRoot(),e,new Date))},T.blockAnimations.disconnectUiStep_=function(t,e,o){var i=(new Date-o)/200;1<i?t.skew_="":(t.skew_="skewX("+Math.round(Math.sin(i*Math.PI*3)*(1-i)*e)+")",T.blockAnimations.disconnectGroup_=t,T.blockAnimations.disconnectPid_=setTimeout(T.blockAnimations.disconnectUiStep_,10,t,e,o)),t.setAttribute("transform",t.translate_+t.skew_)},T.blockAnimations.disconnectUiStop=function(){var t;T.blockAnimations.disconnectGroup_&&(clearTimeout(T.blockAnimations.disconnectPid_),(t=T.blockAnimations.disconnectGroup_).skew_="",t.setAttribute("transform",t.translate_),T.blockAnimations.disconnectGroup_=null)},T.Events.BlockDrag=function(t,e,o){T.Events.BlockDrag.superClass_.constructor.call(this,t?t.workspace.id:void 0),this.blockId=t?t.id:null,this.isStart=e,this.blocks=o},T.utils.object.inherits(T.Events.BlockDrag,T.Events.UiBase),T.Events.BlockDrag.prototype.type=T.Events.BLOCK_DRAG,T.Events.BlockDrag.prototype.toJson=function(){var t=T.Events.BlockDrag.superClass_.toJson.call(this);return t.isStart=this.isStart,t.blockId=this.blockId,t.blocks=this.blocks,t},T.Events.BlockDrag.prototype.fromJson=function(t){T.Events.BlockDrag.superClass_.fromJson.call(this,t),this.isStart=t.isStart,this.blockId=t.blockId,this.blocks=t.blocks},T.registry.register(T.registry.Type.EVENT,T.Events.BLOCK_DRAG,T.Events.BlockDrag),T.InsertionMarkerManager=function(t){this.topBlock_=T.selected=t,this.workspace_=t.workspace,this.lastMarker_=this.lastOnStack_=null,this.firstMarker_=this.createMarkerBlock_(this.topBlock_),this.localConnection_=this.closestConnection_=null,this.wouldDeleteBlock_=!1,this.fadedBlock_=this.highlightedBlock_=this.markerConnection_=null,this.availableConnections_=this.initAvailableConnections_()},T.InsertionMarkerManager.PREVIEW_TYPE={INSERTION_MARKER:0,INPUT_OUTLINE:1,REPLACEMENT_FADE:2},T.InsertionMarkerManager.prototype.dispose=function(){this.availableConnections_.length=0,T.Events.disable();try{this.firstMarker_&&this.firstMarker_.dispose(),this.lastMarker_&&this.lastMarker_.dispose()}finally{T.Events.enable()}},T.InsertionMarkerManager.prototype.updateAvailableConnections=function(){this.availableConnections_=this.initAvailableConnections_()},T.InsertionMarkerManager.prototype.wouldDeleteBlock=function(){return this.wouldDeleteBlock_},T.InsertionMarkerManager.prototype.wouldConnectBlock=function(){return!!this.closestConnection_},T.InsertionMarkerManager.prototype.applyConnections=function(){var t;this.closestConnection_&&(T.Events.disable(),this.hidePreview_(),T.Events.enable(),this.localConnection_.connect(this.closestConnection_),this.topBlock_.rendered)&&(t=this.localConnection_.isSuperior()?this.closestConnection_:this.localConnection_,T.blockAnimations.connectionUiEffect(t.getSourceBlock()),this.topBlock_.getRootBlock().bringToFront())},T.InsertionMarkerManager.prototype.update=function(t,e){var o=this.getCandidate_(t);((this.wouldDeleteBlock_=this.shouldDelete_(o,e))||this.shouldUpdatePreviews_(o,t))&&(T.Events.disable(),this.maybeHidePreview_(o),this.maybeShowPreview_(o),T.Events.enable())},T.InsertionMarkerManager.prototype.createMarkerBlock_=function(t){var e=t.type;T.Events.disable();try{var o=this.workspace_.newBlock(e),i;for(o.setInsertionMarker(!0),t.mutationToDom&&(i=t.mutationToDom())&&o.domToMutation(i),e=0;e<t.inputList.length;e++){var s=t.inputList[e];if(s.name!=T.constants.COLLAPSED_INPUT_NAME)for(var n=o.inputList[e],i=0;i<s.fieldRow.length;i++)n.fieldRow[i].setValue(s.fieldRow[i].getValue())}o.setCollapsed(t.isCollapsed()),o.setInputsInline(t.getInputsInline()),o.initSvg(),o.getSvgRoot().setAttribute("visibility","hidden")}finally{T.Events.enable()}return o},T.InsertionMarkerManager.prototype.initAvailableConnections_=function(){var t=this.topBlock_.getConnections_(!1),e=this.topBlock_.lastConnectionInStack();if(e&&e!=this.topBlock_.nextConnection){if(t.push(e),this.lastOnStack_=e,this.lastMarker_){T.Events.disable();try{this.lastMarker_.dispose()}finally{T.Events.enable()}}this.lastMarker_=this.createMarkerBlock_(e.getSourceBlock())}return t},T.InsertionMarkerManager.prototype.shouldUpdatePreviews_=function(t,e){var o=t.local,i=t.closest;if(t=t.radius,!o||!i)return!(!this.localConnection_||!this.closestConnection_);if(this.localConnection_&&this.closestConnection_){if(this.closestConnection_==i&&this.localConnection_==o)return!1;return o=this.localConnection_.x+e.x-this.closestConnection_.x,e=this.localConnection_.y+e.y-this.closestConnection_.y,e=Math.sqrt(o*o+e*e),!(i&&e-T.CURRENT_CONNECTION_PREFERENCE<t)}if(!this.localConnection_&&!this.closestConnection_)return!0;return console.error("Only one of localConnection_ and closestConnection_ was set."),console.error("Returning true from shouldUpdatePreviews, but it's not clear why."),!0},T.InsertionMarkerManager.prototype.getCandidate_=function(t){for(var e=this.getStartRadius_(),o=null,i=null,s=0;s<this.availableConnections_.length;s++){var n=this.availableConnections_[s],r=n.closest(e,t);r.connection&&(o=r.connection,i=n,e=r.radius)}return{closest:o,local:i,radius:e}},T.InsertionMarkerManager.prototype.getStartRadius_=function(){return this.closestConnection_&&this.localConnection_?T.CONNECTING_SNAP_RADIUS:T.SNAP_RADIUS},T.InsertionMarkerManager.prototype.shouldDelete_=function(t,e){return t=t&&!!t.closest&&e!=T.DELETE_AREA_TOOLBOX,!!e&&!this.topBlock_.getParent()&&this.topBlock_.isDeletable()&&!t},T.InsertionMarkerManager.prototype.maybeShowPreview_=function(t){var e;this.wouldDeleteBlock_||(e=t.closest,t=t.local,e&&(e==this.closestConnection_||e.getSourceBlock().isInsertionMarker()?console.log("Trying to connect to an insertion marker"):(this.closestConnection_=e,this.localConnection_=t,this.showPreview_())))},T.InsertionMarkerManager.prototype.showPreview_=function(){var t=this.closestConnection_,e=this.workspace_.getRenderer();switch(e.getConnectionPreviewMethod(t,this.localConnection_,this.topBlock_)){case T.InsertionMarkerManager.PREVIEW_TYPE.INPUT_OUTLINE:this.showInsertionInputOutline_();break;case T.InsertionMarkerManager.PREVIEW_TYPE.INSERTION_MARKER:this.showInsertionMarker_();break;case T.InsertionMarkerManager.PREVIEW_TYPE.REPLACEMENT_FADE:this.showReplacementFade_()}t&&e.shouldHighlightConnection(t)&&t.highlight()},T.InsertionMarkerManager.prototype.maybeHidePreview_=function(t){var e;(!t.closest||(e=this.closestConnection_!=t.closest,t=this.localConnection_!=t.local,this.closestConnection_&&this.localConnection_&&(e||t||this.wouldDeleteBlock_)))&&this.hidePreview_(),this.localConnection_=this.closestConnection_=this.markerConnection_=null},T.InsertionMarkerManager.prototype.hidePreview_=function(){this.closestConnection_&&this.closestConnection_.targetBlock()&&this.workspace_.getRenderer().shouldHighlightConnection(this.closestConnection_)&&this.closestConnection_.unhighlight(),this.fadedBlock_?this.hideReplacementFade_():this.highlightedBlock_?this.hideInsertionInputOutline_():this.markerConnection_&&this.hideInsertionMarker_()},T.InsertionMarkerManager.prototype.showInsertionMarker_=function(){var t=this.localConnection_,e=this.closestConnection_,o=this.lastOnStack_&&t==this.lastOnStack_?this.lastMarker_:this.firstMarker_,t;if((t=o.getMatchingConnection(t.getSourceBlock(),t))==this.markerConnection_)throw Error("Made it to showInsertionMarker_ even though the marker isn't changing");o.render(),o.rendered=!0,o.getSvgRoot().setAttribute("visibility","visible"),t&&e&&o.positionNearConnection(t,e),e&&t.connect(e),this.markerConnection_=t},T.InsertionMarkerManager.prototype.hideInsertionMarker_=function(){if(this.markerConnection_){var t=this.markerConnection_,e=t.getSourceBlock(),o=e.nextConnection,i=e.previousConnection,s=e.outputConnection,s=t.type==T.connectionTypes.INPUT_VALUE&&!(s&&s.targetConnection);if(!(t!=o||i&&i.targetConnection)||s?t.targetBlock().unplug(!1):t.type==T.connectionTypes.NEXT_STATEMENT&&t!=o?((o=t.targetConnection).getSourceBlock().unplug(!1),i=i?i.targetConnection:null,e.unplug(!0),i&&i.connect(o)):e.unplug(!0),t.targetConnection)throw Error("markerConnection_ still connected at the end of disconnectInsertionMarker");this.markerConnection_=null,e.getSvgRoot().setAttribute("visibility","hidden")}else console.log("No insertion marker connection to disconnect")},T.InsertionMarkerManager.prototype.showInsertionInputOutline_=function(){var t=this.closestConnection_;this.highlightedBlock_=t.getSourceBlock(),this.highlightedBlock_.highlightShapeForInput(t,!0)},T.InsertionMarkerManager.prototype.hideInsertionInputOutline_=function(){this.highlightedBlock_.highlightShapeForInput(this.closestConnection_,!1),this.highlightedBlock_=null},T.InsertionMarkerManager.prototype.showReplacementFade_=function(){this.fadedBlock_=this.closestConnection_.targetBlock(),this.fadedBlock_.fadeForReplacement(!0)},T.InsertionMarkerManager.prototype.hideReplacementFade_=function(){this.fadedBlock_.fadeForReplacement(!1),this.fadedBlock_=null},T.InsertionMarkerManager.prototype.getInsertionMarkers=function(){var t=[];return this.firstMarker_&&t.push(this.firstMarker_),this.lastMarker_&&t.push(this.lastMarker_),t},T.BlockDragger=function(t,e){this.draggingBlock_=t,this.workspace_=e,this.draggedConnectionManager_=new T.InsertionMarkerManager(this.draggingBlock_),this.deleteArea_=null,this.wouldDeleteBlock_=!1,this.startXY_=this.draggingBlock_.getRelativeToSurfaceXY(),this.dragIconData_=T.BlockDragger.initIconData_(t)},T.BlockDragger.prototype.dispose=function(){this.dragIconData_.length=0,this.draggedConnectionManager_&&this.draggedConnectionManager_.dispose()},T.BlockDragger.initIconData_=function(t){var e=[];t=t.getDescendants(!1);for(var o=0,i;i=t[o];o++)for(var i=i.getIcons(),s=0;s<i.length;s++){var n={location:i[s].getIconLocation(),icon:i[s]};e.push(n)}return e},T.BlockDragger.prototype.startBlockDrag=function(t,e){T.Events.getGroup()||T.Events.setGroup(!0),this.fireDragStartEvent_(),this.workspace_.isMutator&&this.draggingBlock_.bringToFront(),T.utils.dom.startTextWidthCache(),this.workspace_.setResizesEnabled(!1),T.blockAnimations.disconnectUiStop(),(this.draggingBlock_.getParent()||e&&this.draggingBlock_.nextConnection&&this.draggingBlock_.nextConnection.targetBlock())&&(this.draggingBlock_.unplug(e),t=this.pixelsToWorkspaceUnits_(t),t=T.utils.Coordinate.sum(this.startXY_,t),this.draggingBlock_.translate(t.x,t.y),T.blockAnimations.disconnectUiEffect(this.draggingBlock_),this.draggedConnectionManager_.updateAvailableConnections()),this.draggingBlock_.setDragging(!0),this.draggingBlock_.moveToDragSurface(),(t=this.workspace_.getToolbox())&&"function"==typeof t.addStyle&&(e=this.draggingBlock_.isDeletable()?"blocklyToolboxDelete":"blocklyToolboxGrab",t.addStyle(e))},T.BlockDragger.prototype.fireDragStartEvent_=function(){var t=new(T.Events.get(T.Events.BLOCK_DRAG))(this.draggingBlock_,!0,this.draggingBlock_.getDescendants(!1));T.Events.fire(t)},T.BlockDragger.prototype.dragBlock=function(t,e){e=this.pixelsToWorkspaceUnits_(e);var o=T.utils.Coordinate.sum(this.startXY_,e);this.draggingBlock_.moveDuringDrag(o),this.dragIcons_(e),this.deleteArea_=this.workspace_.isDeleteArea(t),this.draggedConnectionManager_.update(e,this.deleteArea_),this.updateCursorDuringBlockDrag_()},T.BlockDragger.prototype.endBlockDrag=function(t,e){this.dragBlock(t,e),this.dragIconData_=[],this.fireDragEndEvent_(),T.utils.dom.stopTextWidthCache(),T.blockAnimations.disconnectUiStop(),t=this.pixelsToWorkspaceUnits_(e),e=T.utils.Coordinate.sum(this.startXY_,t),this.draggingBlock_.moveOffDragSurface(e),this.maybeDeleteBlock_()||(this.draggingBlock_.moveConnections(t.x,t.y),this.draggingBlock_.setDragging(!1),this.fireMoveEvent_(),this.draggedConnectionManager_.wouldConnectBlock()?this.draggedConnectionManager_.applyConnections():this.draggingBlock_.render(),this.draggingBlock_.scheduleSnapAndBump()),this.workspace_.setResizesEnabled(!0),(t=this.workspace_.getToolbox())&&"function"==typeof t.removeStyle&&(e=this.draggingBlock_.isDeletable()?"blocklyToolboxDelete":"blocklyToolboxGrab",t.removeStyle(e)),T.Events.setGroup(!1)},T.BlockDragger.prototype.fireDragEndEvent_=function(){var t=new(T.Events.get(T.Events.BLOCK_DRAG))(this.draggingBlock_,!1,this.draggingBlock_.getDescendants(!1));T.Events.fire(t)},T.BlockDragger.prototype.fireMoveEvent_=function(){var t=new(T.Events.get(T.Events.BLOCK_MOVE))(this.draggingBlock_);t.oldCoordinate=this.startXY_,t.recordNew(),T.Events.fire(t)},T.BlockDragger.prototype.maybeDeleteBlock_=function(){var t=this.workspace_.trashcan;return this.wouldDeleteBlock_?(t&&setTimeout(t.closeLid.bind(t),100),this.fireMoveEvent_(),this.draggingBlock_.dispose(!1,!0),T.draggingConnections=[]):t&&t.closeLid(),this.wouldDeleteBlock_},T.BlockDragger.prototype.updateCursorDuringBlockDrag_=function(){this.wouldDeleteBlock_=this.draggedConnectionManager_.wouldDeleteBlock();var t=this.workspace_.trashcan;this.wouldDeleteBlock_?(this.draggingBlock_.setDeleteStyle(!0),this.deleteArea_==T.DELETE_AREA_TRASH&&t&&t.setLidOpen(!0)):(this.draggingBlock_.setDeleteStyle(!1),t&&t.setLidOpen(!1))},T.BlockDragger.prototype.pixelsToWorkspaceUnits_=function(t){return t=new T.utils.Coordinate(t.x/this.workspace_.scale,t.y/this.workspace_.scale),this.workspace_.isMutator&&t.scale(1/this.workspace_.options.parentWorkspace.scale),t},T.BlockDragger.prototype.dragIcons_=function(t){for(var e=0;e<this.dragIconData_.length;e++){var o=this.dragIconData_[e];o.icon.setIconLocation(T.utils.Coordinate.sum(o.location,t))}},T.BlockDragger.prototype.getInsertionMarkers=function(){return this.draggedConnectionManager_&&this.draggedConnectionManager_.getInsertionMarkers?this.draggedConnectionManager_.getInsertionMarkers():[]},T.IConnectionChecker=function(){},T.ConnectionChecker=function(){},T.ConnectionChecker.prototype.canConnect=function(t,e,o,i){return this.canConnectWithReason(t,e,o,i)==T.Connection.CAN_CONNECT},T.ConnectionChecker.prototype.canConnectWithReason=function(t,e,o,i){var s=this.doSafetyChecks(t,e);return s!=T.Connection.CAN_CONNECT?s:this.doTypeChecks(t,e)?o&&!this.doDragChecks(t,e,i||0)?T.Connection.REASON_DRAG_CHECKS_FAILED:T.Connection.CAN_CONNECT:T.Connection.REASON_CHECKS_FAILED},T.ConnectionChecker.prototype.getErrorMessage=function(t,e,o){switch(t){case T.Connection.REASON_SELF_CONNECTION:return"Attempted to connect a block to itself.";case T.Connection.REASON_DIFFERENT_WORKSPACES:return"Blocks not on same workspace.";case T.Connection.REASON_WRONG_TYPE:return"Attempt to connect incompatible types.";case T.Connection.REASON_TARGET_NULL:return"Target connection is null.";case T.Connection.REASON_CHECKS_FAILED:return"Connection checks failed. "+e+" expected "+e.getCheck()+", found "+o.getCheck();case T.Connection.REASON_SHADOW_PARENT:return"Connecting non-shadow to shadow block.";case T.Connection.REASON_DRAG_CHECKS_FAILED:return"Drag checks failed.";default:return"Unknown connection failure: this should never happen!"}},T.ConnectionChecker.prototype.doSafetyChecks=function(t,e){if(!t||!e)return T.Connection.REASON_TARGET_NULL;var o,i;return t.isSuperior()?(o=t.getSourceBlock(),i=e.getSourceBlock()):(i=t.getSourceBlock(),o=e.getSourceBlock()),o==i?T.Connection.REASON_SELF_CONNECTION:e.type!=T.OPPOSITE_TYPE[t.type]?T.Connection.REASON_WRONG_TYPE:o.workspace!==i.workspace?T.Connection.REASON_DIFFERENT_WORKSPACES:o.isShadow()&&!i.isShadow()?T.Connection.REASON_SHADOW_PARENT:T.Connection.CAN_CONNECT},T.ConnectionChecker.prototype.doTypeChecks=function(t,e){if(t=t.getCheck(),e=e.getCheck(),!t||!e)return!0;for(var o=0;o<t.length;o++)if(-1!=e.indexOf(t[o]))return!0;return!1},T.ConnectionChecker.prototype.doDragChecks=function(t,e,o){if(t.distanceFrom(e)>o||e.getSourceBlock().isInsertionMarker())return!1;switch(e.type){case T.connectionTypes.PREVIOUS_STATEMENT:return this.canConnectToPrevious_(t,e);case T.connectionTypes.OUTPUT_VALUE:if(e.isConnected()&&!e.targetBlock().isInsertionMarker()||t.isConnected())return!1;break;case T.connectionTypes.INPUT_VALUE:if(e.isConnected()&&!e.targetBlock().isMovable()&&!e.targetBlock().isShadow())return!1;break;case T.connectionTypes.NEXT_STATEMENT:if(e.isConnected()&&!t.getSourceBlock().nextConnection&&!e.targetBlock().isShadow()&&e.targetBlock().nextConnection)return!1;break;default:return!1}return-1==T.draggingConnections.indexOf(e)},T.ConnectionChecker.prototype.canConnectToPrevious_=function(t,e){if(t.targetConnection||-1!=T.draggingConnections.indexOf(e))return!1;if(!e.targetConnection)return!0;return!!(t=e.targetBlock()).isInsertionMarker()&&!t.getPreviousBlock()},T.registry.register(T.registry.Type.CONNECTION_CHECKER,T.registry.DEFAULT,T.ConnectionChecker),T.VariableMap=function(t){this.variableMap_=Object.create(null),this.workspace=t},T.VariableMap.prototype.clear=function(){this.variableMap_=Object.create(null)},T.VariableMap.prototype.renameVariable=function(t,e){var o=this.getVariable(e,t.type),i=this.workspace.getAllBlocks(!1);T.Events.setGroup(!0);try{o&&o.getId()!=t.getId()?this.renameVariableWithConflict_(t,e,o,i):this.renameVariableAndUses_(t,e,i)}finally{T.Events.setGroup(!1)}},T.VariableMap.prototype.renameVariableById=function(t,e){var o=this.getVariableById(t);if(!o)throw Error("Tried to rename a variable that didn't exist. ID: "+t);this.renameVariable(o,e)},T.VariableMap.prototype.renameVariableAndUses_=function(t,e,o){for(T.Events.fire(new(T.Events.get(T.Events.VAR_RENAME))(t,e)),t.name=e,e=0;e<o.length;e++)o[e].updateVarName(t)},T.VariableMap.prototype.renameVariableWithConflict_=function(t,e,o,i){var s=t.type;for(e!=o.name&&this.renameVariableAndUses_(o,e,i),e=0;e<i.length;e++)i[e].renameVarById(t.getId(),o.getId());T.Events.fire(new(T.Events.get(T.Events.VAR_DELETE))(t)),t=this.getVariablesOfType(s).indexOf(t),this.variableMap_[s].splice(t,1)},T.VariableMap.prototype.createVariable=function(t,e,o){var i=this.getVariable(t,e);if(i){if(o&&i.getId()!=o)throw Error('Variable "'+t+'" is already in use and its id is "'+i.getId()+'" which conflicts with the passed in id, "'+o+'".');return i}if(o&&this.getVariableById(o))throw Error('Variable id, "'+o+'", is already in use.');return i=o||T.utils.genUid(),i=new T.VariableModel(this.workspace,t,e=e||"",i),(t=this.variableMap_[e]||[]).push(i),delete this.variableMap_[e],this.variableMap_[e]=t,i},T.VariableMap.prototype.deleteVariable=function(t){for(var e=this.variableMap_[t.type],o=0,i;i=e[o];o++)if(i.getId()==t.getId()){e.splice(o,1),T.Events.fire(new(T.Events.get(T.Events.VAR_DELETE))(t));break}},T.VariableMap.prototype.deleteVariableById=function(t){var e=this.getVariableById(t);if(e){var o=e.name,i=this.getVariableUsesById(t),s;for(t=0;s=i[t];t++)if("procedures_defnoreturn"==s.type||"procedures_defreturn"==s.type)return t=s.getFieldValue("NAME"),o=T.Msg.CANNOT_DELETE_VARIABLE_PROCEDURE.replace("%1",o).replace("%2",t),void T.alert(o);var n=this;1<i.length?(o=T.Msg.DELETE_VARIABLE_CONFIRMATION.replace("%1",String(i.length)).replace("%2",o),T.confirm(o,function(t){t&&e&&n.deleteVariableInternal(e,i)})):n.deleteVariableInternal(e,i)}else console.warn("Can't delete non-existent variable: "+t)},T.VariableMap.prototype.deleteVariableInternal=function(t,e){var o=T.Events.getGroup();o||T.Events.setGroup(!0);try{for(var i=0;i<e.length;i++)e[i].dispose(!0);this.deleteVariable(t)}finally{o||T.Events.setGroup(!1)}},T.VariableMap.prototype.getVariable=function(t,e){if(e=this.variableMap_[e||""])for(var o=0,i;i=e[o];o++)if(T.Names.equals(i.name,t))return i;return null},T.VariableMap.prototype.getVariableById=function(t){for(var e=Object.keys(this.variableMap_),o=0;o<e.length;o++)for(var i=e[o],s=0,n;n=this.variableMap_[i][s];s++)if(n.getId()==t)return n;return null},T.VariableMap.prototype.getVariablesOfType=function(t){return(t=this.variableMap_[t||""])?t.slice():[]},T.VariableMap.prototype.getVariableTypes=function(t){var e={};T.utils.object.mixin(e,this.variableMap_),t&&t.getPotentialVariableMap()&&T.utils.object.mixin(e,t.getPotentialVariableMap().variableMap_),t=Object.keys(e);for(var e=!1,o=0;o<t.length;o++)""==t[o]&&(e=!0);return e||t.push(""),t},T.VariableMap.prototype.getAllVariables=function(){var t=[],e;for(e in this.variableMap_)t=t.concat(this.variableMap_[e]);return t},T.VariableMap.prototype.getAllVariableNames=function(){var t=[],e;for(e in this.variableMap_)for(var o=this.variableMap_[e],i=0,s;s=o[i];i++)t.push(s.name);return t},T.VariableMap.prototype.getVariableUsesById=function(t){for(var e=[],o=this.workspace.getAllBlocks(!1),i=0;i<o.length;i++){var s=o[i].getVarModels();if(s)for(var n=0;n<s.length;n++)s[n].getId()==t&&e.push(o[i])}return e},T.Workspace=function(t){this.id=T.utils.genUid(),(T.Workspace.WorkspaceDB_[this.id]=this).options=t||new T.Options({}),this.RTL=!!this.options.RTL,this.horizontalLayout=!!this.options.horizontalLayout,this.toolboxPosition=this.options.toolboxPosition,this.connectionChecker=new(T.registry.getClassFromOptions(T.registry.Type.CONNECTION_CHECKER,this.options,!0))(this),this.topBlocks_=[],this.topComments_=[],this.commentDB_=Object.create(null),this.listeners_=[],this.undoStack_=[],this.redoStack_=[],this.blockDB_=Object.create(null),this.typedBlocksDB_=Object.create(null),this.variableMap_=new T.VariableMap(this),this.potentialVariableMap_=null},T.Workspace.prototype.rendered=!1,T.Workspace.prototype.isClearing=!1,T.Workspace.prototype.MAX_UNDO=1024,T.Workspace.prototype.connectionDBList=null,T.Workspace.prototype.dispose=function(){this.listeners_.length=0,this.clear(),delete T.Workspace.WorkspaceDB_[this.id]},T.Workspace.SCAN_ANGLE=3,T.Workspace.prototype.sortObjects_=function(t,e){return t=t.getRelativeToSurfaceXY(),e=e.getRelativeToSurfaceXY(),t.y+T.Workspace.prototype.sortObjects_.offset*t.x-(e.y+T.Workspace.prototype.sortObjects_.offset*e.x)},T.Workspace.prototype.addTopBlock=function(t){this.topBlocks_.push(t)},T.Workspace.prototype.removeTopBlock=function(t){if(!T.utils.arrayRemove(this.topBlocks_,t))throw Error("Block not present in workspace's list of top-most blocks.")},T.Workspace.prototype.getTopBlocks=function(t){var e=[].concat(this.topBlocks_);return t&&1<e.length&&(this.sortObjects_.offset=Math.sin(T.utils.math.toRadians(T.Workspace.SCAN_ANGLE)),this.RTL&&(this.sortObjects_.offset*=-1),e.sort(this.sortObjects_)),e},T.Workspace.prototype.addTypedBlock=function(t){this.typedBlocksDB_[t.type]||(this.typedBlocksDB_[t.type]=[]),this.typedBlocksDB_[t.type].push(t)},T.Workspace.prototype.removeTypedBlock=function(t){this.typedBlocksDB_[t.type].splice(this.typedBlocksDB_[t.type].indexOf(t),1),this.typedBlocksDB_[t.type].length||delete this.typedBlocksDB_[t.type]},T.Workspace.prototype.getBlocksByType=function(t,e){if(!this.typedBlocksDB_[t])return[];return t=this.typedBlocksDB_[t].slice(0),e&&1<t.length&&(this.sortObjects_.offset=Math.sin(T.utils.math.toRadians(T.Workspace.SCAN_ANGLE)),this.RTL&&(this.sortObjects_.offset*=-1),t.sort(this.sortObjects_)),t},T.Workspace.prototype.addTopComment=function(t){this.topComments_.push(t),this.commentDB_[t.id]&&console.warn('Overriding an existing comment on this workspace, with id "'+t.id+'"'),this.commentDB_[t.id]=t},T.Workspace.prototype.removeTopComment=function(t){if(!T.utils.arrayRemove(this.topComments_,t))throw Error("Comment not present in workspace's list of top-most comments.");delete this.commentDB_[t.id]},T.Workspace.prototype.getTopComments=function(t){var e=[].concat(this.topComments_);return t&&1<e.length&&(this.sortObjects_.offset=Math.sin(T.utils.math.toRadians(T.Workspace.SCAN_ANGLE)),this.RTL&&(this.sortObjects_.offset*=-1),e.sort(this.sortObjects_)),e},T.Workspace.prototype.getAllBlocks=function(t){if(t){t=this.getTopBlocks(!0);for(var e=[],o=0;o<t.length;o++)e.push.apply(e,t[o].getDescendants(!0))}else for(e=this.getTopBlocks(!1),o=0;o<e.length;o++)e.push.apply(e,e[o].getChildren(!1));return e.filter(function(t){return!t.isInsertionMarker()})},T.Workspace.prototype.clear=function(){this.isClearing=!0;try{var t=T.Events.getGroup();for(t||T.Events.setGroup(!0);this.topBlocks_.length;)this.topBlocks_[0].dispose(!1);for(;this.topComments_.length;)this.topComments_[this.topComments_.length-1].dispose(!1);t||T.Events.setGroup(!1),this.variableMap_.clear(),this.potentialVariableMap_&&this.potentialVariableMap_.clear()}finally{this.isClearing=!1}},T.Workspace.prototype.renameVariableById=function(t,e){this.variableMap_.renameVariableById(t,e)},T.Workspace.prototype.createVariable=function(t,e,o){return this.variableMap_.createVariable(t,e,o)},T.Workspace.prototype.getVariableUsesById=function(t){return this.variableMap_.getVariableUsesById(t)},T.Workspace.prototype.deleteVariableById=function(t){this.variableMap_.deleteVariableById(t)},T.Workspace.prototype.getVariable=function(t,e){return this.variableMap_.getVariable(t,e)},T.Workspace.prototype.getVariableById=function(t){return this.variableMap_.getVariableById(t)},T.Workspace.prototype.getVariablesOfType=function(t){return this.variableMap_.getVariablesOfType(t)},T.Workspace.prototype.getVariableTypes=function(){return this.variableMap_.getVariableTypes(this)},T.Workspace.prototype.getAllVariables=function(){return this.variableMap_.getAllVariables()},T.Workspace.prototype.getAllVariableNames=function(){return this.variableMap_.getAllVariableNames()},T.Workspace.prototype.getWidth=function(){return 0},T.Workspace.prototype.newBlock=function(t,e){return new T.Block(this,t,e)},T.Workspace.prototype.remainingCapacity=function(){return isNaN(this.options.maxBlocks)?1/0:this.options.maxBlocks-this.getAllBlocks(!1).length},T.Workspace.prototype.remainingCapacityOfType=function(t){return this.options.maxInstances?(void 0!==this.options.maxInstances[t]?this.options.maxInstances[t]:1/0)-this.getBlocksByType(t,!1).length:1/0},T.Workspace.prototype.isCapacityAvailable=function(t){if(!this.hasBlockLimits())return!0;var e=0,o;for(o in t){if(t[o]>this.remainingCapacityOfType(o))return!1;e+=t[o]}return!(e>this.remainingCapacity())},T.Workspace.prototype.hasBlockLimits=function(){return 1/0!=this.options.maxBlocks||!!this.options.maxInstances},T.Workspace.prototype.getUndoStack=function(){return this.undoStack_},T.Workspace.prototype.getRedoStack=function(){return this.redoStack_},T.Workspace.prototype.undo=function(t){var e=t?this.redoStack_:this.undoStack_,o=t?this.undoStack_:this.redoStack_,i=e.pop();if(i){for(var s=[i];e.length&&i.group&&i.group==e[e.length-1].group;)s.push(e.pop());for(e=0;i=s[e];e++)o.push(i);s=T.Events.filter(s,t),T.Events.recordUndo=!1;try{for(e=0;i=s[e];e++)i.run(t)}finally{T.Events.recordUndo=!0}}},T.Workspace.prototype.clearUndo=function(){this.undoStack_.length=0,this.redoStack_.length=0,T.Events.clearPendingUndo()},T.Workspace.prototype.addChangeListener=function(t){return this.listeners_.push(t),t},T.Workspace.prototype.removeChangeListener=function(t){T.utils.arrayRemove(this.listeners_,t)},T.Workspace.prototype.fireChangeListener=function(t){if(t.recordUndo)for(this.undoStack_.push(t),this.redoStack_.length=0;this.undoStack_.length>this.MAX_UNDO&&0<=this.MAX_UNDO;)this.undoStack_.shift();for(var e=0,o;o=this.listeners_[e];e++)o(t)},T.Workspace.prototype.getBlockById=function(t){return this.blockDB_[t]||null},T.Workspace.prototype.setBlockById=function(t,e){this.blockDB_[t]=e},T.Workspace.prototype.removeBlockById=function(t){delete this.blockDB_[t]},T.Workspace.prototype.getCommentById=function(t){return this.commentDB_[t]||null},T.Workspace.prototype.allInputsFilled=function(t){for(var e=this.getTopBlocks(!1),o=0,i;i=e[o];o++)if(!i.allInputsFilled(t))return!1;return!0},T.Workspace.prototype.getPotentialVariableMap=function(){return this.potentialVariableMap_},T.Workspace.prototype.createPotentialVariableMap=function(){this.potentialVariableMap_=new T.VariableMap(this)},T.Workspace.prototype.getVariableMap=function(){return this.variableMap_},T.Workspace.prototype.setVariableMap=function(t){this.variableMap_=t},T.Workspace.WorkspaceDB_=Object.create(null),T.Workspace.getById=function(t){return T.Workspace.WorkspaceDB_[t]||null},T.Workspace.getAll=function(){var t=[],e;for(e in T.Workspace.WorkspaceDB_)t.push(T.Workspace.WorkspaceDB_[e]);return t},T.Bubble=function(t,e,o,i,s,n){this.workspace_=t,this.content_=e,this.shape_=o,this.onMouseDownResizeWrapper_=this.onMouseDownBubbleWrapper_=this.moveCallback_=this.resizeCallback_=null,this.disposed=!1,o=T.Bubble.ARROW_ANGLE,this.workspace_.RTL&&(o=-o),this.arrow_radians_=T.utils.math.toRadians(o),t.getBubbleCanvas().appendChild(this.createDom_(e,!(!s||!n))),this.setAnchorLocation(i),s&&n||(s=(t=this.content_.getBBox()).width+2*T.Bubble.BORDER_WIDTH,n=t.height+2*T.Bubble.BORDER_WIDTH),this.setBubbleSize(s,n),this.positionBubble_(),this.renderArrow_(),this.rendered_=!0},T.Bubble.BORDER_WIDTH=6,T.Bubble.ARROW_THICKNESS=5,T.Bubble.ARROW_ANGLE=20,T.Bubble.ARROW_BEND=4,T.Bubble.ANCHOR_RADIUS=8,T.Bubble.onMouseUpWrapper_=null,T.Bubble.onMouseMoveWrapper_=null,T.Bubble.unbindDragEvents_=function(){T.Bubble.onMouseUpWrapper_&&(T.browserEvents.unbind(T.Bubble.onMouseUpWrapper_),T.Bubble.onMouseUpWrapper_=null),T.Bubble.onMouseMoveWrapper_&&(T.browserEvents.unbind(T.Bubble.onMouseMoveWrapper_),T.Bubble.onMouseMoveWrapper_=null)},T.Bubble.bubbleMouseUp_=function(t){T.Touch.clearTouchIdentifier(),T.Bubble.unbindDragEvents_()},T.Bubble.prototype.rendered_=!1,T.Bubble.prototype.anchorXY_=null,T.Bubble.prototype.relativeLeft_=0,T.Bubble.prototype.relativeTop_=0,T.Bubble.prototype.width_=0,T.Bubble.prototype.height_=0,T.Bubble.prototype.autoLayout_=!0,T.Bubble.prototype.createDom_=function(t,e){this.bubbleGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{},null);var o={filter:"url(#"+this.workspace_.getRenderer().getConstants().embossFilterId+")"};return T.utils.userAgent.JAVA_FX&&(o={}),o=T.utils.dom.createSvgElement(T.utils.Svg.G,o,this.bubbleGroup_),this.bubbleArrow_=T.utils.dom.createSvgElement(T.utils.Svg.PATH,{},o),this.bubbleBack_=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blocklyDraggable",x:0,y:0,rx:T.Bubble.BORDER_WIDTH,ry:T.Bubble.BORDER_WIDTH},o),e?(this.resizeGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:this.workspace_.RTL?"blocklyResizeSW":"blocklyResizeSE"},this.bubbleGroup_),e=2*T.Bubble.BORDER_WIDTH,T.utils.dom.createSvgElement(T.utils.Svg.POLYGON,{points:"0,x x,x x,0".replace(/x/g,e.toString())},this.resizeGroup_),T.utils.dom.createSvgElement(T.utils.Svg.LINE,{class:"blocklyResizeLine",x1:e/3,y1:e-1,x2:e-1,y2:e/3},this.resizeGroup_),T.utils.dom.createSvgElement(T.utils.Svg.LINE,{class:"blocklyResizeLine",x1:2*e/3,y1:e-1,x2:e-1,y2:2*e/3},this.resizeGroup_)):this.resizeGroup_=null,this.workspace_.options.readOnly||(this.onMouseDownBubbleWrapper_=T.browserEvents.conditionalBind(this.bubbleBack_,"mousedown",this,this.bubbleMouseDown_),this.resizeGroup_&&(this.onMouseDownResizeWrapper_=T.browserEvents.conditionalBind(this.resizeGroup_,"mousedown",this,this.resizeMouseDown_))),this.bubbleGroup_.appendChild(t),this.bubbleGroup_},T.Bubble.prototype.getSvgRoot=function(){return this.bubbleGroup_},T.Bubble.prototype.setSvgId=function(t){this.bubbleGroup_.dataset&&(this.bubbleGroup_.dataset.blockId=t)},T.Bubble.prototype.bubbleMouseDown_=function(t){var e=this.workspace_.getGesture(t);e&&e.handleBubbleStart(t,this)},T.Bubble.prototype.showContextMenu=function(t){},T.Bubble.prototype.isDeletable=function(){return!1},T.Bubble.prototype.setDeleteStyle=function(t){},T.Bubble.prototype.resizeMouseDown_=function(t){this.promote(),T.Bubble.unbindDragEvents_(),T.utils.isRightButton(t)||(this.workspace_.startDrag(t,new T.utils.Coordinate(this.workspace_.RTL?-this.width_:this.width_,this.height_)),T.Bubble.onMouseUpWrapper_=T.browserEvents.conditionalBind(document,"mouseup",this,T.Bubble.bubbleMouseUp_),T.Bubble.onMouseMoveWrapper_=T.browserEvents.conditionalBind(document,"mousemove",this,this.resizeMouseMove_),T.hideChaff()),t.stopPropagation()},T.Bubble.prototype.resizeMouseMove_=function(t){this.autoLayout_=!1,t=this.workspace_.moveDrag(t),this.setBubbleSize(this.workspace_.RTL?-t.x:t.x,t.y),this.workspace_.RTL&&this.positionBubble_()},T.Bubble.prototype.registerResizeEvent=function(t){this.resizeCallback_=t},T.Bubble.prototype.registerMoveEvent=function(t){this.moveCallback_=t},T.Bubble.prototype.promote=function(){var t=this.bubbleGroup_.parentNode;return t.lastChild!==this.bubbleGroup_&&(t.appendChild(this.bubbleGroup_),!0)},T.Bubble.prototype.setAnchorLocation=function(t){this.anchorXY_=t,this.rendered_&&this.positionBubble_()},T.Bubble.prototype.layoutBubble_=function(){var t=this.workspace_.getMetricsManager().getViewMetrics(!0),e=this.getOptimalRelativeLeft_(t),o=this.getOptimalRelativeTop_(t),i=this.shape_.getBBox(),s={x:e,y:-this.height_-this.workspace_.getRenderer().getConstants().MIN_BLOCK_HEIGHT},n={x:-this.width_-30,y:o},o={x:i.width,y:o},r={x:e,y:i.height},e=i.width<i.height?o:r,i=i.width<i.height?r:o,r=(o=this.getOverlap_(s,t),this.getOverlap_(n,t)),l=this.getOverlap_(e,t),t=this.getOverlap_(i,t);o==(t=Math.max(o,r,l,t))?(this.relativeLeft_=s.x,this.relativeTop_=s.y):r==t?(this.relativeLeft_=n.x,this.relativeTop_=n.y):l==t?(this.relativeLeft_=e.x,this.relativeTop_=e.y):(this.relativeLeft_=i.x,this.relativeTop_=i.y)},T.Bubble.prototype.getOverlap_=function(t,e){var o=this.workspace_.RTL?this.anchorXY_.x-t.x-this.width_:t.x+this.anchorXY_.x;return t=t.y+this.anchorXY_.y,Math.max(0,Math.min(1,(Math.min(o+this.width_,e.left+e.width)-Math.max(o,e.left))*(Math.min(t+this.height_,e.top+e.height)-Math.max(t,e.top))/(this.width_*this.height_)))},T.Bubble.prototype.getOptimalRelativeLeft_=function(t){var e=-this.width_/4,o,i,s,n;if(this.width_>t.width)return e;return this.workspace_.RTL?(i=(o=this.anchorXY_.x-e)-this.width_,s=t.left+t.width,n=t.left+T.Scrollbar.scrollbarThickness/this.workspace_.scale):(o=(i=e+this.anchorXY_.x)+this.width_,n=t.left,s=t.left+t.width-T.Scrollbar.scrollbarThickness/this.workspace_.scale),this.workspace_.RTL?i<n?e=-(n-this.anchorXY_.x+this.width_):s<o&&(e=-(s-this.anchorXY_.x)):i<n?e=n-this.anchorXY_.x:s<o&&(e=s-this.anchorXY_.x-this.width_),e},T.Bubble.prototype.getOptimalRelativeTop_=function(t){var e=-this.height_/4;if(this.height_>t.height)return e;var o=this.anchorXY_.y+e,i=o+this.height_,s=t.top,n=(t=t.top+t.height-T.Scrollbar.scrollbarThickness/this.workspace_.scale,this.anchorXY_.y);return o<s?e=s-n:t<i&&(e=t-n-this.height_),e},T.Bubble.prototype.positionBubble_=function(){var t=this.anchorXY_.x,t=this.workspace_.RTL?t-(this.relativeLeft_+this.width_):t+this.relativeLeft_;this.moveTo(t,this.relativeTop_+this.anchorXY_.y)},T.Bubble.prototype.moveTo=function(t,e){this.bubbleGroup_.setAttribute("transform","translate("+t+","+e+")")},T.Bubble.prototype.setDragging=function(t){!t&&this.moveCallback_&&this.moveCallback_()},T.Bubble.prototype.getBubbleSize=function(){return new T.utils.Size(this.width_,this.height_)},T.Bubble.prototype.setBubbleSize=function(t,e){var o=2*T.Bubble.BORDER_WIDTH;t=Math.max(t,o+45),e=Math.max(e,o+20),this.width_=t,this.height_=e,this.bubbleBack_.setAttribute("width",t),this.bubbleBack_.setAttribute("height",e),this.resizeGroup_&&(this.workspace_.RTL?this.resizeGroup_.setAttribute("transform","translate("+2*T.Bubble.BORDER_WIDTH+","+(e-o)+") scale(-1 1)"):this.resizeGroup_.setAttribute("transform","translate("+(t-o)+","+(e-o)+")")),this.autoLayout_&&this.layoutBubble_(),this.positionBubble_(),this.renderArrow_(),this.resizeCallback_&&this.resizeCallback_()},T.Bubble.prototype.renderArrow_=function(){var t=[],e=this.width_/2,o=this.height_/2,i=-this.relativeLeft_,s=-this.relativeTop_,n,r,l,a,c,h,l,i,s,h,u;e==i&&o==s?t.push("M "+e+","+o):(s-=o,i-=e,this.workspace_.RTL&&(i*=-1),n=Math.sqrt(s*s+i*i),r=Math.acos(i/n),(l=(r=s<0?2*Math.PI-r:r)+Math.PI/2)>2*Math.PI&&(l-=2*Math.PI),a=Math.sin(l),c=Math.cos(l),l=((h=this.getBubbleSize()).width+h.height)/T.Bubble.ARROW_THICKNESS,l=Math.min(l,h.width,h.height)/4,i=e+(h=1-T.Bubble.ANCHOR_RADIUS/n)*i,s=o+h*s,h=e+l*c,u=o+l*a,e-=l*c,o-=l*a,(a=r+this.arrow_radians_)>2*Math.PI&&(a-=2*Math.PI),r=Math.sin(a)*n/T.Bubble.ARROW_BEND,n=Math.cos(a)*n/T.Bubble.ARROW_BEND,t.push("M"+h+","+u),t.push("C"+(h+n)+","+(u+r)+" "+i+","+s+" "+i+","+s),t.push("C"+i+","+s+" "+(e+n)+","+(o+r)+" "+e+","+o)),t.push("z"),this.bubbleArrow_.setAttribute("d",t.join(" "))},T.Bubble.prototype.setColour=function(t){this.bubbleBack_.setAttribute("fill",t),this.bubbleArrow_.setAttribute("fill",t)},T.Bubble.prototype.dispose=function(){this.onMouseDownBubbleWrapper_&&T.browserEvents.unbind(this.onMouseDownBubbleWrapper_),this.onMouseDownResizeWrapper_&&T.browserEvents.unbind(this.onMouseDownResizeWrapper_),T.Bubble.unbindDragEvents_(),T.utils.dom.removeNode(this.bubbleGroup_),this.disposed=!0},T.Bubble.prototype.moveDuringDrag=function(t,e){t?t.translateSurface(e.x,e.y):this.moveTo(e.x,e.y),this.relativeLeft_=this.workspace_.RTL?this.anchorXY_.x-e.x-this.width_:e.x-this.anchorXY_.x,this.relativeTop_=e.y-this.anchorXY_.y,this.renderArrow_()},T.Bubble.prototype.getRelativeToSurfaceXY=function(){return new T.utils.Coordinate(this.workspace_.RTL?-this.relativeLeft_+this.anchorXY_.x-this.width_:this.anchorXY_.x+this.relativeLeft_,this.anchorXY_.y+this.relativeTop_)},T.Bubble.prototype.setAutoLayout=function(t){this.autoLayout_=t},T.Bubble.textToDom=function(t){var e=T.utils.dom.createSvgElement(T.utils.Svg.TEXT,{class:"blocklyText blocklyBubbleText blocklyNoPointerEvents",y:T.Bubble.BORDER_WIDTH},null);t=t.split("\n");for(var o=0;o<t.length;o++){var i=T.utils.dom.createSvgElement(T.utils.Svg.TSPAN,{dy:"1em",x:T.Bubble.BORDER_WIDTH},e),s=document.createTextNode(t[o]);i.appendChild(s)}return e},T.Bubble.createNonEditableBubble=function(t,e,o){if((o=new T.Bubble(e.workspace,t,e.pathObject.svgPath,o,null,null)).setSvgId(e.id),e.RTL){e=t.getBBox().width;for(var i=0,s;s=t.childNodes[i];i++)s.setAttribute("text-anchor","end"),s.setAttribute("x",e+T.Bubble.BORDER_WIDTH)}return o},T.Events.CommentBase=function(t){this.commentId=(this.isBlank=void 0===t)?"":t.id,this.workspaceId=this.isBlank?"":t.workspace.id,this.group=T.Events.getGroup(),this.recordUndo=T.Events.recordUndo},T.utils.object.inherits(T.Events.CommentBase,T.Events.Abstract),T.Events.CommentBase.prototype.toJson=function(){var t=T.Events.CommentBase.superClass_.toJson.call(this);return this.commentId&&(t.commentId=this.commentId),t},T.Events.CommentBase.prototype.fromJson=function(t){T.Events.CommentBase.superClass_.fromJson.call(this,t),this.commentId=t.commentId},T.Events.CommentChange=function(t,e,o){T.Events.CommentChange.superClass_.constructor.call(this,t),t&&(this.oldContents_=void 0===e?"":e,this.newContents_=void 0===o?"":o)},T.utils.object.inherits(T.Events.CommentChange,T.Events.CommentBase),T.Events.CommentChange.prototype.type=T.Events.COMMENT_CHANGE,T.Events.CommentChange.prototype.toJson=function(){var t=T.Events.CommentChange.superClass_.toJson.call(this);return t.oldContents=this.oldContents_,t.newContents=this.newContents_,t},T.Events.CommentChange.prototype.fromJson=function(t){T.Events.CommentChange.superClass_.fromJson.call(this,t),this.oldContents_=t.oldContents,this.newContents_=t.newContents},T.Events.CommentChange.prototype.isNull=function(){return this.oldContents_==this.newContents_},T.Events.CommentChange.prototype.run=function(t){var e=this.getEventWorkspace_().getCommentById(this.commentId);e?e.setContent(t?this.newContents_:this.oldContents_):console.warn("Can't change non-existent comment: "+this.commentId)},T.Events.CommentCreate=function(t){T.Events.CommentCreate.superClass_.constructor.call(this,t),t&&(this.xml=t.toXmlWithXY())},T.utils.object.inherits(T.Events.CommentCreate,T.Events.CommentBase),T.Events.CommentCreate.prototype.type=T.Events.COMMENT_CREATE,T.Events.CommentCreate.prototype.toJson=function(){var t=T.Events.CommentCreate.superClass_.toJson.call(this);return t.xml=T.Xml.domToText(this.xml),t},T.Events.CommentCreate.prototype.fromJson=function(t){T.Events.CommentCreate.superClass_.fromJson.call(this,t),this.xml=T.Xml.textToDom(t.xml)},T.Events.CommentCreate.prototype.run=function(t){T.Events.CommentCreateDeleteHelper(this,t)},T.Events.CommentCreateDeleteHelper=function(t,e){var o=t.getEventWorkspace_();e?((e=T.utils.xml.createElement("xml")).appendChild(t.xml),T.Xml.domToWorkspace(e,o)):(o=o.getCommentById(t.commentId))?o.dispose(!1,!1):console.warn("Can't uncreate non-existent comment: "+t.commentId)},T.Events.CommentDelete=function(t){T.Events.CommentDelete.superClass_.constructor.call(this,t),t&&(this.xml=t.toXmlWithXY())},T.utils.object.inherits(T.Events.CommentDelete,T.Events.CommentBase),T.Events.CommentDelete.prototype.type=T.Events.COMMENT_DELETE,T.Events.CommentDelete.prototype.toJson=function(){return T.Events.CommentDelete.superClass_.toJson.call(this)},T.Events.CommentDelete.prototype.fromJson=function(t){T.Events.CommentDelete.superClass_.fromJson.call(this,t)},T.Events.CommentDelete.prototype.run=function(t){T.Events.CommentCreateDeleteHelper(this,!t)},T.Events.CommentMove=function(t){T.Events.CommentMove.superClass_.constructor.call(this,t),t&&(this.comment_=t,this.oldCoordinate_=t.getXY(),this.newCoordinate_=null)},T.utils.object.inherits(T.Events.CommentMove,T.Events.CommentBase),T.Events.CommentMove.prototype.recordNew=function(){if(!this.comment_)throw Error("Tried to record the new position of a comment on the same event twice.");this.newCoordinate_=this.comment_.getXY(),this.comment_=null},T.Events.CommentMove.prototype.type=T.Events.COMMENT_MOVE,T.Events.CommentMove.prototype.setOldCoordinate=function(t){this.oldCoordinate_=t},T.Events.CommentMove.prototype.toJson=function(){var t=T.Events.CommentMove.superClass_.toJson.call(this);return this.oldCoordinate_&&(t.oldCoordinate=Math.round(this.oldCoordinate_.x)+","+Math.round(this.oldCoordinate_.y)),this.newCoordinate_&&(t.newCoordinate=Math.round(this.newCoordinate_.x)+","+Math.round(this.newCoordinate_.y)),t},T.Events.CommentMove.prototype.fromJson=function(t){var e;T.Events.CommentMove.superClass_.fromJson.call(this,t),t.oldCoordinate&&(e=t.oldCoordinate.split(","),this.oldCoordinate_=new T.utils.Coordinate(Number(e[0]),Number(e[1]))),t.newCoordinate&&(e=t.newCoordinate.split(","),this.newCoordinate_=new T.utils.Coordinate(Number(e[0]),Number(e[1])))},T.Events.CommentMove.prototype.isNull=function(){return T.utils.Coordinate.equals(this.oldCoordinate_,this.newCoordinate_)},T.Events.CommentMove.prototype.run=function(t){var e=this.getEventWorkspace_().getCommentById(this.commentId),o;e?(t=t?this.newCoordinate_:this.oldCoordinate_,o=e.getXY(),e.moveBy(t.x-o.x,t.y-o.y)):console.warn("Can't move non-existent comment: "+this.commentId)},T.registry.register(T.registry.Type.EVENT,T.Events.COMMENT_CREATE,T.Events.CommentCreate),T.registry.register(T.registry.Type.EVENT,T.Events.COMMENT_CHANGE,T.Events.CommentChange),T.registry.register(T.registry.Type.EVENT,T.Events.COMMENT_MOVE,T.Events.CommentMove),T.registry.register(T.registry.Type.EVENT,T.Events.COMMENT_DELETE,T.Events.CommentDelete),T.BubbleDragger=function(t,e){this.draggingBubble_=t,this.workspace_=e,this.deleteArea_=null,this.wouldDeleteBubble_=!1,this.startXY_=this.draggingBubble_.getRelativeToSurfaceXY(),this.dragSurface_=T.utils.is3dSupported()&&e.getBlockDragSurface()?e.getBlockDragSurface():null},T.BubbleDragger.prototype.dispose=function(){this.dragSurface_=this.workspace_=this.draggingBubble_=null},T.BubbleDragger.prototype.startBubbleDrag=function(){T.Events.getGroup()||T.Events.setGroup(!0),this.workspace_.setResizesEnabled(!1),this.draggingBubble_.setAutoLayout(!1),this.dragSurface_&&this.moveToDragSurface_(),this.draggingBubble_.setDragging&&this.draggingBubble_.setDragging(!0);var t=this.workspace_.getToolbox(),e;t&&"function"==typeof t.addStyle&&(e=this.draggingBubble_.isDeletable()?"blocklyToolboxDelete":"blocklyToolboxGrab",t.addStyle(e))},T.BubbleDragger.prototype.dragBubble=function(t,e){e=this.pixelsToWorkspaceUnits_(e),e=T.utils.Coordinate.sum(this.startXY_,e),this.draggingBubble_.moveDuringDrag(this.dragSurface_,e),this.draggingBubble_.isDeletable()&&(this.deleteArea_=this.workspace_.isDeleteArea(t),this.updateCursorDuringBubbleDrag_())},T.BubbleDragger.prototype.maybeDeleteBubble_=function(){var t=this.workspace_.trashcan;return this.wouldDeleteBubble_?(t&&setTimeout(t.closeLid.bind(t),100),this.fireMoveEvent_(),this.draggingBubble_.dispose(!1,!0)):t&&t.closeLid(),this.wouldDeleteBubble_},T.BubbleDragger.prototype.updateCursorDuringBubbleDrag_=function(){this.wouldDeleteBubble_=this.deleteArea_!=T.DELETE_AREA_NONE;var t=this.workspace_.trashcan;this.wouldDeleteBubble_?(this.draggingBubble_.setDeleteStyle(!0),this.deleteArea_==T.DELETE_AREA_TRASH&&t&&t.setLidOpen(!0)):(this.draggingBubble_.setDeleteStyle(!1),t&&t.setLidOpen(!1))},T.BubbleDragger.prototype.endBubbleDrag=function(t,e){this.dragBubble(t,e),t=this.pixelsToWorkspaceUnits_(e),t=T.utils.Coordinate.sum(this.startXY_,t),this.draggingBubble_.moveTo(t.x,t.y),this.maybeDeleteBubble_()||(this.dragSurface_&&this.dragSurface_.clearAndHide(this.workspace_.getBubbleCanvas()),this.draggingBubble_.setDragging&&this.draggingBubble_.setDragging(!1),this.fireMoveEvent_()),this.workspace_.setResizesEnabled(!0),(t=this.workspace_.getToolbox())&&"function"==typeof t.removeStyle&&(e=this.draggingBubble_.isDeletable()?"blocklyToolboxDelete":"blocklyToolboxGrab",t.removeStyle(e)),T.Events.setGroup(!1)},T.BubbleDragger.prototype.fireMoveEvent_=function(){var t;this.draggingBubble_.isComment&&((t=new(T.Events.get(T.Events.COMMENT_MOVE))(this.draggingBubble_)).setOldCoordinate(this.startXY_),t.recordNew(),T.Events.fire(t))},T.BubbleDragger.prototype.pixelsToWorkspaceUnits_=function(t){return t=new T.utils.Coordinate(t.x/this.workspace_.scale,t.y/this.workspace_.scale),this.workspace_.isMutator&&t.scale(1/this.workspace_.options.parentWorkspace.scale),t},T.BubbleDragger.prototype.moveToDragSurface_=function(){this.draggingBubble_.moveTo(0,0),this.dragSurface_.translateSurface(this.startXY_.x,this.startXY_.y),this.dragSurface_.setBlocksAndShow(this.draggingBubble_.getSvgRoot())},T.Events.Click=function(t,e,o){T.Events.Click.superClass_.constructor.call(this,t?t.workspace.id:e),this.blockId=t?t.id:null,this.targetType=o},T.utils.object.inherits(T.Events.Click,T.Events.UiBase),T.Events.Click.prototype.type=T.Events.CLICK,T.Events.Click.prototype.toJson=function(){var t=T.Events.Click.superClass_.toJson.call(this);return t.targetType=this.targetType,this.blockId&&(t.blockId=this.blockId),t},T.Events.Click.prototype.fromJson=function(t){T.Events.Click.superClass_.fromJson.call(this,t),this.targetType=t.targetType,this.blockId=t.blockId},T.registry.register(T.registry.Type.EVENT,T.Events.CLICK,T.Events.Click),T.WorkspaceDragger=function(t){this.workspace_=t,this.horizontalScrollEnabled_=this.workspace_.isMovableHorizontally(),this.verticalScrollEnabled_=this.workspace_.isMovableVertically(),this.startScrollXY_=new T.utils.Coordinate(t.scrollX,t.scrollY)},T.WorkspaceDragger.prototype.dispose=function(){this.workspace_=null},T.WorkspaceDragger.prototype.startDrag=function(){T.selected&&T.selected.unselect(),this.workspace_.setupDragSurface()},T.WorkspaceDragger.prototype.endDrag=function(t){this.drag(t),this.workspace_.resetDragSurface()},T.WorkspaceDragger.prototype.drag=function(t){if(t=T.utils.Coordinate.sum(this.startScrollXY_,t),this.horizontalScrollEnabled_&&this.verticalScrollEnabled_)this.workspace_.scroll(t.x,t.y);else if(this.horizontalScrollEnabled_)this.workspace_.scroll(t.x,this.workspace_.scrollY);else{if(!this.verticalScrollEnabled_)throw new TypeError("Invalid state.");this.workspace_.scroll(this.workspace_.scrollX,t.y)}},T.Gesture=function(t,e){this.mouseDownXY_=null,this.currentDragDeltaXY_=new T.utils.Coordinate(0,0),this.startWorkspace_=this.targetBlock_=this.startBlock_=this.startField_=this.startBubble_=null,this.creatorWorkspace_=e,this.isDraggingBubble_=this.isDraggingBlock_=this.isDraggingWorkspace_=this.hasExceededDragRadius_=!1,this.mostRecentEvent_=t,this.flyout_=this.workspaceDragger_=this.blockDragger_=this.bubbleDragger_=this.onUpWrapper_=this.onMoveWrapper_=null,this.isEnding_=this.hasStarted_=this.calledUpdateIsDragging_=!1,this.healStack_=!T.DRAG_STACK},T.Gesture.prototype.dispose=function(){T.Touch.clearTouchIdentifier(),T.Tooltip.unblock(),this.creatorWorkspace_.clearGesture(),this.onMoveWrapper_&&T.browserEvents.unbind(this.onMoveWrapper_),this.onUpWrapper_&&T.browserEvents.unbind(this.onUpWrapper_),this.blockDragger_&&this.blockDragger_.dispose(),this.workspaceDragger_&&this.workspaceDragger_.dispose(),this.bubbleDragger_&&this.bubbleDragger_.dispose()},T.Gesture.prototype.updateFromEvent_=function(t){var e=new T.utils.Coordinate(t.clientX,t.clientY);this.updateDragDelta_(e)&&(this.updateIsDragging_(),T.longStop_()),this.mostRecentEvent_=t},T.Gesture.prototype.updateDragDelta_=function(t){return this.currentDragDeltaXY_=T.utils.Coordinate.difference(t,this.mouseDownXY_),!this.hasExceededDragRadius_&&(this.hasExceededDragRadius_=T.utils.Coordinate.magnitude(this.currentDragDeltaXY_)>(this.flyout_?T.FLYOUT_DRAG_RADIUS:T.DRAG_RADIUS))},T.Gesture.prototype.updateIsDraggingFromFlyout_=function(){return!(!this.targetBlock_||!this.flyout_.isBlockCreatable_(this.targetBlock_)||this.flyout_.isScrollable()&&!this.flyout_.isDragTowardWorkspace(this.currentDragDeltaXY_)||(this.startWorkspace_=this.flyout_.targetWorkspace,this.startWorkspace_.updateScreenCalculationsIfScrolled(),T.Events.getGroup()||T.Events.setGroup(!0),this.startBlock_=null,this.targetBlock_=this.flyout_.createBlock(this.targetBlock_),this.targetBlock_.select(),0))},T.Gesture.prototype.updateIsDraggingBubble_=function(){if(!this.startBubble_)return!1;return this.isDraggingBubble_=!0,this.startDraggingBubble_(),!0},T.Gesture.prototype.updateIsDraggingBlock_=function(){if(!this.targetBlock_)return!1;return this.flyout_?this.isDraggingBlock_=this.updateIsDraggingFromFlyout_():this.targetBlock_.isMovable()&&(this.isDraggingBlock_=!0),!!this.isDraggingBlock_&&(this.startDraggingBlock_(),!0)},T.Gesture.prototype.updateIsDraggingWorkspace_=function(){(this.flyout_?this.flyout_.isScrollable():this.startWorkspace_&&this.startWorkspace_.isDraggable())&&(this.workspaceDragger_=new T.WorkspaceDragger(this.startWorkspace_),this.isDraggingWorkspace_=!0,this.workspaceDragger_.startDrag())},T.Gesture.prototype.updateIsDragging_=function(){if(this.calledUpdateIsDragging_)throw Error("updateIsDragging_ should only be called once per gesture.");this.calledUpdateIsDragging_=!0,this.updateIsDraggingBubble_()||this.updateIsDraggingBlock_()||this.updateIsDraggingWorkspace_()},T.Gesture.prototype.startDraggingBlock_=function(){this.blockDragger_=new T.BlockDragger(this.targetBlock_,this.startWorkspace_),this.blockDragger_.startBlockDrag(this.currentDragDeltaXY_,this.healStack_),this.blockDragger_.dragBlock(this.mostRecentEvent_,this.currentDragDeltaXY_)},T.Gesture.prototype.startDraggingBubble_=function(){this.bubbleDragger_=new T.BubbleDragger(this.startBubble_,this.startWorkspace_),this.bubbleDragger_.startBubbleDrag(),this.bubbleDragger_.dragBubble(this.mostRecentEvent_,this.currentDragDeltaXY_)},T.Gesture.prototype.doStart=function(t){T.utils.isTargetInput(t)?this.cancel():(this.hasStarted_=!0,T.blockAnimations.disconnectUiStop(),this.startWorkspace_.updateScreenCalculationsIfScrolled(),this.startWorkspace_.isMutator&&this.startWorkspace_.resize(),T.hideChaff(!!this.flyout_),this.startWorkspace_.markFocused(),this.mostRecentEvent_=t,T.Tooltip.block(),this.targetBlock_&&this.targetBlock_.select(),T.utils.isRightButton(t)?this.handleRightClick(t):("touchstart"!=t.type.toLowerCase()&&"pointerdown"!=t.type.toLowerCase()||"mouse"==t.pointerType||T.longStart(t,this),this.mouseDownXY_=new T.utils.Coordinate(t.clientX,t.clientY),this.healStack_=t.altKey||t.ctrlKey||t.metaKey,this.bindMouseEvents(t)))},T.Gesture.prototype.bindMouseEvents=function(t){this.onMoveWrapper_=T.browserEvents.conditionalBind(document,"mousemove",null,this.handleMove.bind(this)),this.onUpWrapper_=T.browserEvents.conditionalBind(document,"mouseup",null,this.handleUp.bind(this)),t.preventDefault(),t.stopPropagation()},T.Gesture.prototype.handleMove=function(t){this.updateFromEvent_(t),this.isDraggingWorkspace_?this.workspaceDragger_.drag(this.currentDragDeltaXY_):this.isDraggingBlock_?this.blockDragger_.dragBlock(this.mostRecentEvent_,this.currentDragDeltaXY_):this.isDraggingBubble_&&this.bubbleDragger_.dragBubble(this.mostRecentEvent_,this.currentDragDeltaXY_),t.preventDefault(),t.stopPropagation()},T.Gesture.prototype.handleUp=function(t){this.updateFromEvent_(t),T.longStop_(),this.isEnding_?console.log("Trying to end a gesture recursively."):(this.isEnding_=!0,this.isDraggingBubble_?this.bubbleDragger_.endBubbleDrag(t,this.currentDragDeltaXY_):this.isDraggingBlock_?this.blockDragger_.endBlockDrag(t,this.currentDragDeltaXY_):this.isDraggingWorkspace_?this.workspaceDragger_.endDrag(this.currentDragDeltaXY_):this.isBubbleClick_()?this.doBubbleClick_():this.isFieldClick_()?this.doFieldClick_():this.isBlockClick_()?this.doBlockClick_():this.isWorkspaceClick_()&&this.doWorkspaceClick_(t),t.preventDefault(),t.stopPropagation(),this.dispose())},T.Gesture.prototype.cancel=function(){this.isEnding_||(T.longStop_(),this.isDraggingBubble_?this.bubbleDragger_.endBubbleDrag(this.mostRecentEvent_,this.currentDragDeltaXY_):this.isDraggingBlock_?this.blockDragger_.endBlockDrag(this.mostRecentEvent_,this.currentDragDeltaXY_):this.isDraggingWorkspace_&&this.workspaceDragger_.endDrag(this.currentDragDeltaXY_),this.dispose())},T.Gesture.prototype.handleRightClick=function(t){this.targetBlock_?(this.bringBlockToFront_(),T.hideChaff(!!this.flyout_),this.targetBlock_.showContextMenu(t)):this.startBubble_?this.startBubble_.showContextMenu(t):this.startWorkspace_&&!this.flyout_&&(T.hideChaff(),this.startWorkspace_.showContextMenu(t)),t.preventDefault(),t.stopPropagation(),this.dispose()},T.Gesture.prototype.handleWsStart=function(t,e){if(this.hasStarted_)throw Error("Tried to call gesture.handleWsStart, but the gesture had already been started.");this.setStartWorkspace_(e),this.mostRecentEvent_=t,this.doStart(t)},T.Gesture.prototype.fireWorkspaceClick_=function(t){T.Events.fire(new(T.Events.get(T.Events.CLICK))(null,t.id,"workspace"))},T.Gesture.prototype.handleFlyoutStart=function(t,e){if(this.hasStarted_)throw Error("Tried to call gesture.handleFlyoutStart, but the gesture had already been started.");this.setStartFlyout_(e),this.handleWsStart(t,e.getWorkspace())},T.Gesture.prototype.handleBlockStart=function(t,e){if(this.hasStarted_)throw Error("Tried to call gesture.handleBlockStart, but the gesture had already been started.");this.setStartBlock(e),this.mostRecentEvent_=t},T.Gesture.prototype.handleBubbleStart=function(t,e){if(this.hasStarted_)throw Error("Tried to call gesture.handleBubbleStart, but the gesture had already been started.");this.setStartBubble(e),this.mostRecentEvent_=t},T.Gesture.prototype.doBubbleClick_=function(){this.startBubble_.setFocus&&this.startBubble_.setFocus(),this.startBubble_.select&&this.startBubble_.select()},T.Gesture.prototype.doFieldClick_=function(){this.startField_.showEditor(this.mostRecentEvent_),this.bringBlockToFront_()},T.Gesture.prototype.doBlockClick_=function(){var t;this.flyout_&&this.flyout_.autoClose?this.targetBlock_.isEnabled()&&(T.Events.getGroup()||T.Events.setGroup(!0),this.flyout_.createBlock(this.targetBlock_).scheduleSnapAndBump()):(t=new(T.Events.get(T.Events.CLICK))(this.startBlock_,this.startWorkspace_.id,"block"),T.Events.fire(t)),this.bringBlockToFront_(),T.Events.setGroup(!1)},T.Gesture.prototype.doWorkspaceClick_=function(t){t=this.creatorWorkspace_,T.selected&&T.selected.unselect(),this.fireWorkspaceClick_(this.startWorkspace_||t)},T.Gesture.prototype.bringBlockToFront_=function(){this.targetBlock_&&!this.flyout_&&this.targetBlock_.bringToFront()},T.Gesture.prototype.setStartField=function(t){if(this.hasStarted_)throw Error("Tried to call gesture.setStartField, but the gesture had already been started.");this.startField_||(this.startField_=t)},T.Gesture.prototype.setStartBubble=function(t){this.startBubble_||(this.startBubble_=t)},T.Gesture.prototype.setStartBlock=function(t){this.startBlock_||this.startBubble_||((this.startBlock_=t).isInFlyout&&t!=t.getRootBlock()?this.setTargetBlock_(t.getRootBlock()):this.setTargetBlock_(t))},T.Gesture.prototype.setTargetBlock_=function(t){t.isShadow()?this.setTargetBlock_(t.getParent()):this.targetBlock_=t},T.Gesture.prototype.setStartWorkspace_=function(t){this.startWorkspace_||(this.startWorkspace_=t)},T.Gesture.prototype.setStartFlyout_=function(t){this.flyout_||(this.flyout_=t)},T.Gesture.prototype.isBubbleClick_=function(){return!!this.startBubble_&&!this.hasExceededDragRadius_},T.Gesture.prototype.isBlockClick_=function(){return!!this.startBlock_&&!this.hasExceededDragRadius_&&!this.isFieldClick_()},T.Gesture.prototype.isFieldClick_=function(){return!!this.startField_&&this.startField_.isClickable()&&!this.hasExceededDragRadius_&&(!this.flyout_||!this.flyout_.autoClose)},T.Gesture.prototype.isWorkspaceClick_=function(){return!(this.startBlock_||this.startBubble_||this.startField_||this.hasExceededDragRadius_)},T.Gesture.prototype.isDragging=function(){return this.isDraggingWorkspace_||this.isDraggingBlock_||this.isDraggingBubble_},T.Gesture.prototype.hasStarted=function(){return this.hasStarted_},T.Gesture.prototype.getInsertionMarkers=function(){return this.blockDragger_?this.blockDragger_.getInsertionMarkers():[]},T.Gesture.inProgress=function(){for(var t=T.Workspace.getAll(),e=0,o;o=t[e];e++)if(o.currentGesture_)return!0;return!1},T.Field=function(t,e,o){this.value_=this.DEFAULT_VALUE,this.tooltip_=this.validator_=null,this.size_=new T.utils.Size(0,0),this.constants_=this.mouseDownWrapper_=this.textContent_=this.textElement_=this.borderRect_=this.fieldGroup_=this.markerSvg_=this.cursorSvg_=null,o&&this.configure_(o),this.setValue(t),e&&this.setValidator(e)},T.Field.prototype.DEFAULT_VALUE=null,T.Field.prototype.name=void 0,T.Field.prototype.disposed=!1,T.Field.prototype.maxDisplayLength=50,T.Field.prototype.sourceBlock_=null,T.Field.prototype.isDirty_=!0,T.Field.prototype.visible_=!0,T.Field.prototype.clickTarget_=null,T.Field.NBSP=" ",T.Field.prototype.EDITABLE=!0,T.Field.prototype.SERIALIZABLE=!1,T.Field.prototype.configure_=function(t){var e=t.tooltip;(e="string"==typeof e?T.utils.replaceMessageReferences(t.tooltip):e)&&this.setTooltip(e)},T.Field.prototype.setSourceBlock=function(t){if(this.sourceBlock_)throw Error("Field already bound to a block.");this.sourceBlock_=t},T.Field.prototype.getConstants=function(){return!this.constants_&&this.sourceBlock_&&this.sourceBlock_.workspace&&this.sourceBlock_.workspace.rendered&&(this.constants_=this.sourceBlock_.workspace.getRenderer().getConstants()),this.constants_},T.Field.prototype.getSourceBlock=function(){return this.sourceBlock_},T.Field.prototype.init=function(){this.fieldGroup_||(this.fieldGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{},null),this.isVisible()||(this.fieldGroup_.style.display="none"),this.sourceBlock_.getSvgRoot().appendChild(this.fieldGroup_),this.initView(),this.updateEditable(),this.setTooltip(this.tooltip_),this.bindEvents_(),this.initModel())},T.Field.prototype.initView=function(){this.createBorderRect_(),this.createTextElement_()},T.Field.prototype.initModel=function(){},T.Field.prototype.createBorderRect_=function(){this.borderRect_=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{rx:this.getConstants().FIELD_BORDER_RECT_RADIUS,ry:this.getConstants().FIELD_BORDER_RECT_RADIUS,x:0,y:0,height:this.size_.height,width:this.size_.width,class:"blocklyFieldRect"},this.fieldGroup_)},T.Field.prototype.createTextElement_=function(){this.textElement_=T.utils.dom.createSvgElement(T.utils.Svg.TEXT,{class:"blocklyText"},this.fieldGroup_),this.getConstants().FIELD_TEXT_BASELINE_CENTER&&this.textElement_.setAttribute("dominant-baseline","central"),this.textContent_=document.createTextNode(""),this.textElement_.appendChild(this.textContent_)},T.Field.prototype.bindEvents_=function(){T.Tooltip.bindMouseEvents(this.getClickTarget_()),this.mouseDownWrapper_=T.browserEvents.conditionalBind(this.getClickTarget_(),"mousedown",this,this.onMouseDown_)},T.Field.prototype.fromXml=function(t){this.setValue(t.textContent)},T.Field.prototype.toXml=function(t){return t.textContent=this.getValue(),t},T.Field.prototype.dispose=function(){T.DropDownDiv.hideIfOwner(this),T.WidgetDiv.hideIfOwner(this),T.Tooltip.unbindMouseEvents(this.getClickTarget_()),this.mouseDownWrapper_&&T.browserEvents.unbind(this.mouseDownWrapper_),T.utils.dom.removeNode(this.fieldGroup_),this.disposed=!0},T.Field.prototype.updateEditable=function(){var t=this.fieldGroup_;this.EDITABLE&&t&&(this.sourceBlock_.isEditable()?(T.utils.dom.addClass(t,"blocklyEditableText"),T.utils.dom.removeClass(t,"blocklyNonEditableText"),t.style.cursor=this.CURSOR):(T.utils.dom.addClass(t,"blocklyNonEditableText"),T.utils.dom.removeClass(t,"blocklyEditableText"),t.style.cursor=""))},T.Field.prototype.isClickable=function(){return!!this.sourceBlock_&&this.sourceBlock_.isEditable()&&!!this.showEditor_&&"function"==typeof this.showEditor_},T.Field.prototype.isCurrentlyEditable=function(){return this.EDITABLE&&!!this.sourceBlock_&&this.sourceBlock_.isEditable()},T.Field.prototype.isSerializable=function(){var t=!1;return this.name&&(this.SERIALIZABLE?t=!0:this.EDITABLE&&(console.warn("Detected an editable field that was not serializable. Please define SERIALIZABLE property as true on all editable custom fields. Proceeding with serialization."),t=!0)),t},T.Field.prototype.isVisible=function(){return this.visible_},T.Field.prototype.setVisible=function(t){var e;this.visible_!=t&&(this.visible_=t,e=this.getSvgRoot())&&(e.style.display=t?"block":"none")},T.Field.prototype.setValidator=function(t){this.validator_=t},T.Field.prototype.getValidator=function(){return this.validator_},T.Field.prototype.getSvgRoot=function(){return this.fieldGroup_},T.Field.prototype.applyColour=function(){},T.Field.prototype.render_=function(){this.textContent_&&(this.textContent_.nodeValue=this.getDisplayText_()),this.updateSize_()},T.Field.prototype.showEditor=function(t){this.isClickable()&&this.showEditor_(t)},T.Field.prototype.updateSize_=function(t){var e=this.getConstants(),o=2*(t=null!=t?t:this.borderRect_?this.getConstants().FIELD_BORDER_RECT_X_PADDING:0),i=e.FIELD_TEXT_HEIGHT,s=0;this.textElement_&&(o+=s=T.utils.dom.getFastTextWidth(this.textElement_,e.FIELD_TEXT_FONTSIZE,e.FIELD_TEXT_FONTWEIGHT,e.FIELD_TEXT_FONTFAMILY)),this.borderRect_&&(i=Math.max(i,e.FIELD_BORDER_RECT_HEIGHT)),this.size_.height=i,this.size_.width=o,this.positionTextElement_(t,s),this.positionBorderRect_()},T.Field.prototype.positionTextElement_=function(t,e){var o,i;this.textElement_&&(o=this.getConstants(),i=this.size_.height/2,this.textElement_.setAttribute("x",this.sourceBlock_.RTL?this.size_.width-e-t:t),this.textElement_.setAttribute("y",o.FIELD_TEXT_BASELINE_CENTER?i:i-o.FIELD_TEXT_HEIGHT/2+o.FIELD_TEXT_BASELINE))},T.Field.prototype.positionBorderRect_=function(){this.borderRect_&&(this.borderRect_.setAttribute("width",this.size_.width),this.borderRect_.setAttribute("height",this.size_.height),this.borderRect_.setAttribute("rx",this.getConstants().FIELD_BORDER_RECT_RADIUS),this.borderRect_.setAttribute("ry",this.getConstants().FIELD_BORDER_RECT_RADIUS))},T.Field.prototype.getSize=function(){if(!this.isVisible())return new T.utils.Size(0,0);return this.isDirty_?(this.render_(),this.isDirty_=!1):this.visible_&&0==this.size_.width&&(console.warn("Deprecated use of setting size_.width to 0 to rerender a field. Set field.isDirty_ to true instead."),this.render_()),this.size_},T.Field.prototype.getScaledBBox=function(){var t,e,o,i,t;return this.borderRect_?(t=this.borderRect_.getBoundingClientRect(),o=T.utils.style.getPageOffset(this.borderRect_),i=t.width,t=t.height):(t=this.sourceBlock_.getHeightWidth(),e=this.sourceBlock_.workspace.scale,o=this.getAbsoluteXY_(),i=t.width*e,t=t.height*e,T.utils.userAgent.GECKO?(o.x+=1.5*e,o.y+=1.5*e):T.utils.userAgent.EDGE||T.utils.userAgent.IE||(o.x-=.5*e,o.y-=.5*e),i+=1*e,t+=1*e),new T.utils.Rect(o.y,o.y+t,o.x,o.x+i)},T.Field.prototype.getDisplayText_=function(){var t=this.getText();if(!t)return T.Field.NBSP;return t=(t=t.length>this.maxDisplayLength?t.substring(0,this.maxDisplayLength-2)+"…":t).replace(/\s/g,T.Field.NBSP),this.sourceBlock_&&this.sourceBlock_.RTL&&(t+="‏"),t},T.Field.prototype.getText=function(){if(this.getText_){var t=this.getText_.call(this);if(null!==t)return String(t)}return String(this.getValue())},T.Field.prototype.markDirty=function(){this.isDirty_=!0,this.constants_=null},T.Field.prototype.forceRerender=function(){this.isDirty_=!0,this.sourceBlock_&&this.sourceBlock_.rendered&&(this.sourceBlock_.render(),this.sourceBlock_.bumpNeighbours(),this.updateMarkers_())},T.Field.prototype.setValue=function(t){if(null!==t){var e=this.doClassValidation_(t),o,e;if(!((t=this.processValidation_(t,e))instanceof Error)){if((e=this.getValidator())&&(e=e.call(this,t),(t=this.processValidation_(t,e))instanceof Error))return;(e=this.sourceBlock_)&&e.disposed||((o=this.getValue())===t?this.doValueUpdate_(t):(e&&T.Events.isEnabled()&&T.Events.fire(new(T.Events.get(T.Events.BLOCK_CHANGE))(e,"field",this.name||null,o,t)),this.doValueUpdate_(t),this.isDirty_&&this.forceRerender()))}}},T.Field.prototype.processValidation_=function(t,e){if(null===e)return this.doValueInvalid_(t),this.isDirty_&&this.forceRerender(),Error();return t=void 0!==e?e:t},T.Field.prototype.getValue=function(){return this.value_},T.Field.prototype.doClassValidation_=function(t){return null==t?null:t},T.Field.prototype.doValueUpdate_=function(t){this.value_=t,this.isDirty_=!0},T.Field.prototype.doValueInvalid_=function(t){},T.Field.prototype.onMouseDown_=function(t){this.sourceBlock_&&this.sourceBlock_.workspace&&(t=this.sourceBlock_.workspace.getGesture(t))&&t.setStartField(this)},T.Field.prototype.setTooltip=function(t){t||""===t||(t=this.sourceBlock_);var e=this.getClickTarget_();e?e.tooltip=t:this.tooltip_=t},T.Field.prototype.getTooltip=function(){var t=this.getClickTarget_();return t?T.Tooltip.getTooltipOfObject(t):T.Tooltip.getTooltipOfObject({tooltip:this.tooltip_})},T.Field.prototype.getClickTarget_=function(){return this.clickTarget_||this.getSvgRoot()},T.Field.prototype.getAbsoluteXY_=function(){return T.utils.style.getPageOffset(this.getClickTarget_())},T.Field.prototype.referencesVariables=function(){return!1},T.Field.prototype.getParentInput=function(){for(var t=null,e=this.sourceBlock_,o=e.inputList,i=0;i<e.inputList.length;i++)for(var s=o[i],n=s.fieldRow,r=0;r<n.length;r++)if(n[r]===this){t=s;break}return t},T.Field.prototype.getFlipRtl=function(){return!1},T.Field.prototype.isTabNavigable=function(){return!1},T.Field.prototype.onShortcut=function(t){return!1},T.Field.prototype.setCursorSvg=function(t){t?(this.fieldGroup_.appendChild(t),this.cursorSvg_=t):this.cursorSvg_=null},T.Field.prototype.setMarkerSvg=function(t){t?(this.fieldGroup_.appendChild(t),this.markerSvg_=t):this.markerSvg_=null},T.Field.prototype.updateMarkers_=function(){var t=this.sourceBlock_.workspace;t.keyboardAccessibilityMode&&this.cursorSvg_&&t.getCursor().draw(),t.keyboardAccessibilityMode&&this.markerSvg_&&t.getMarker(T.MarkerManager.LOCAL_MARKER).draw()},T.FieldLabel=function(t,e,o){this.class_=null,T.FieldLabel.superClass_.constructor.call(this,t,null,o),o||(this.class_=e||null)},T.utils.object.inherits(T.FieldLabel,T.Field),T.FieldLabel.prototype.DEFAULT_VALUE="",T.FieldLabel.fromJson=function(t){var e=T.utils.replaceMessageReferences(t.text);return new T.FieldLabel(e,void 0,t)},T.FieldLabel.prototype.EDITABLE=!1,T.FieldLabel.prototype.configure_=function(t){T.FieldLabel.superClass_.configure_.call(this,t),this.class_=t["class"]},T.FieldLabel.prototype.initView=function(){this.createTextElement_(),this.class_&&T.utils.dom.addClass(this.textElement_,this.class_)},T.FieldLabel.prototype.doClassValidation_=function(t){return null==t?null:String(t)},T.FieldLabel.prototype.setClass=function(t){this.textElement_&&(this.class_&&T.utils.dom.removeClass(this.textElement_,this.class_),t)&&T.utils.dom.addClass(this.textElement_,t),this.class_=t},T.fieldRegistry.register("field_label",T.FieldLabel),T.Input=function(t,e,o,i){if(t!=T.inputTypes.DUMMY&&!e)throw Error("Value inputs and statement inputs must have non-empty name.");this.type=t,this.name=e,this.sourceBlock_=o,this.connection=i,this.fieldRow=[]},T.Input.prototype.align=T.constants.ALIGN.LEFT,T.Input.prototype.visible_=!0,T.Input.prototype.getSourceBlock=function(){return this.sourceBlock_},T.Input.prototype.appendField=function(t,e){return this.insertFieldAt(this.fieldRow.length,t,e),this},T.Input.prototype.insertFieldAt=function(t,e,o){if(t<0||t>this.fieldRow.length)throw Error("index "+t+" out of bounds.");if(!(e||""==e&&o))return t;return(e="string"==typeof e?T.fieldRegistry.fromJson({type:"field_label",text:e}):e).setSourceBlock(this.sourceBlock_),this.sourceBlock_.rendered&&(e.init(),e.applyColour()),e.name=o,e.setVisible(this.isVisible()),e.prefixField&&(t=this.insertFieldAt(t,e.prefixField)),this.fieldRow.splice(t,0,e),++t,e.suffixField&&(t=this.insertFieldAt(t,e.suffixField)),this.sourceBlock_.rendered&&(this.sourceBlock_=this.sourceBlock_,this.sourceBlock_.render(),this.sourceBlock_.bumpNeighbours()),t},T.Input.prototype.removeField=function(t,e){for(var o=0,i;i=this.fieldRow[o];o++)if(i.name===t)return i.dispose(),this.fieldRow.splice(o,1),this.sourceBlock_.rendered&&(this.sourceBlock_=this.sourceBlock_,this.sourceBlock_.render(),this.sourceBlock_.bumpNeighbours()),!0;if(e)return!1;throw Error('Field "'+t+'" not found.')},T.Input.prototype.isVisible=function(){return this.visible_},T.Input.prototype.setVisible=function(t){var e=[];if(this.visible_==t)return e;this.visible_=t;for(var o=0,i;i=this.fieldRow[o];o++)i.setVisible(t);return this.connection&&(this.connection=this.connection,t?e=this.connection.startTrackingAll():this.connection.stopTrackingAll(),o=this.connection.targetBlock())&&(o.getSvgRoot().style.display=t?"block":"none"),e},T.Input.prototype.markDirty=function(){for(var t=0,e;e=this.fieldRow[t];t++)e.markDirty()},T.Input.prototype.setCheck=function(t){if(!this.connection)throw Error("This input does not have a connection.");return this.connection.setCheck(t),this},T.Input.prototype.setAlign=function(t){return this.align=t,this.sourceBlock_.rendered&&(this.sourceBlock_=this.sourceBlock_,this.sourceBlock_.render()),this},T.Input.prototype.setShadowDom=function(t){if(!this.connection)throw Error("This input does not have a connection.");return this.connection.setShadowDom(t),this},T.Input.prototype.getShadowDom=function(){if(!this.connection)throw Error("This input does not have a connection.");return this.connection.getShadowDom()},T.Input.prototype.init=function(){if(this.sourceBlock_.workspace.rendered)for(var t=0;t<this.fieldRow.length;t++)this.fieldRow[t].init()},T.Input.prototype.dispose=function(){for(var t=0,e;e=this.fieldRow[t];t++)e.dispose();this.connection&&this.connection.dispose(),this.sourceBlock_=null},T.Block=function(t,e,o){if(T.Generator&&void 0!==T.Generator.prototype[e])throw Error('Block prototypeName "'+e+'" conflicts with Blockly.Generator members.');if(this.id=o&&!t.getBlockById(o)?o:T.utils.genUid(),t.setBlockById(this.id,this),this.previousConnection=this.nextConnection=this.outputConnection=null,this.inputList=[],this.inputsInline=void 0,this.disabled=!1,this.tooltip="",this.contextMenu=!0,this.parentBlock_=null,this.childBlocks_=[],this.editable_=this.movable_=this.deletable_=!0,this.collapsed_=this.isShadow_=!1,this.comment=this.outputShape_=null,this.commentModel={text:null,pinned:!1,size:new T.utils.Size(160,80)},this.xy_=new T.utils.Coordinate(0,0),this.workspace=t,this.isInFlyout=t.isFlyout,this.isInMutator=t.isMutator,this.RTL=t.RTL,this.isInsertionMarker_=!1,this.hat=void 0,this.rendered=null,this.statementInputCount=0,e){if(this.type=e,!(o=T.Blocks[e])||"object"!=typeof o)throw TypeError("Unknown block type: "+e);T.utils.object.mixin(this,o)}t.addTopBlock(this),t.addTypedBlock(this),(t=T.Events.getGroup())||T.Events.setGroup(!0),e=T.Events.recordUndo;try{"function"==typeof this.init&&(T.Events.recordUndo=!1,this.init(),T.Events.recordUndo=e),T.Events.isEnabled()&&T.Events.fire(new(T.Events.get(T.Events.BLOCK_CREATE))(this))}finally{t||T.Events.setGroup(!1),T.Events.recordUndo=e}this.inputsInlineDefault=this.inputsInline,"function"==typeof this.onchange&&this.setOnChange(this.onchange)},T.Block.COLLAPSED_INPUT_NAME=T.constants.COLLAPSED_INPUT_NAME,T.Block.COLLAPSED_FIELD_NAME=T.constants.COLLAPSED_FIELD_NAME,T.Block.prototype.data=null,T.Block.prototype.disposed=!1,T.Block.prototype.hue_=null,T.Block.prototype.colour_="#000000",T.Block.prototype.styleName_=null,T.Block.prototype.dispose=function(t){if(this.workspace){this.onchangeWrapper_&&this.workspace.removeChangeListener(this.onchangeWrapper_),this.unplug(t),T.Events.isEnabled()&&T.Events.fire(new(T.Events.get(T.Events.BLOCK_DELETE))(this)),T.Events.disable();try{this.workspace&&(this.workspace.removeTopBlock(this),this.workspace.removeTypedBlock(this),this.workspace.removeBlockById(this.id),this.workspace=null),T.selected==this&&(T.selected=null);for(var e=this.childBlocks_.length-1,o;0<=e;e--)this.childBlocks_[e].dispose(!1);for(e=0;o=this.inputList[e];e++)o.dispose();this.inputList.length=0;for(var i=this.getConnections_(!0),e=0,s;s=i[e];e++)s.dispose()}finally{T.Events.enable(),this.disposed=!0}}},T.Block.prototype.initModel=function(){for(var t=0,e;e=this.inputList[t];t++)for(var o=0,i;i=e.fieldRow[o];o++)i.initModel&&i.initModel()},T.Block.prototype.unplug=function(t){this.outputConnection?this.unplugFromRow_(t):this.previousConnection&&this.unplugFromStack_(t)},T.Block.prototype.unplugFromRow_=function(t){var e=null;this.outputConnection.isConnected()&&(e=this.outputConnection.targetConnection,this.outputConnection.disconnect()),e&&(t=t&&this.getOnlyValueConnection_())&&t.isConnected()&&!t.targetBlock().isShadow()&&((t=t.targetConnection).disconnect(),this.workspace.connectionChecker.canConnect(t,e,!1)?e.connect(t):t.onFailedConnect(e))},T.Block.prototype.getOnlyValueConnection_=function(){for(var t=null,e=0;e<this.inputList.length;e++){var o=this.inputList[e].connection;if(o&&o.type==T.connectionTypes.INPUT_VALUE&&o.targetConnection){if(t)return null;t=o}}return t},T.Block.prototype.unplugFromStack_=function(t){var e=null,o=(this.previousConnection.isConnected()&&(e=this.previousConnection.targetConnection,this.previousConnection.disconnect()),this.getNextBlock());t&&o&&!o.isShadow()&&((t=this.nextConnection.targetConnection).disconnect(),e)&&this.workspace.connectionChecker.canConnect(e,t,!1)&&e.connect(t)},T.Block.prototype.getConnections_=function(t){t=[],this.outputConnection&&t.push(this.outputConnection),this.previousConnection&&t.push(this.previousConnection),this.nextConnection&&t.push(this.nextConnection);for(var e=0,o;o=this.inputList[e];e++)o.connection&&t.push(o.connection);return t},T.Block.prototype.lastConnectionInStack=function(){for(var t=this.nextConnection;t;){var e=t.targetBlock();if(!e)return t;t=e.nextConnection}return null},T.Block.prototype.bumpNeighbours=function(){},T.Block.prototype.getParent=function(){return this.parentBlock_},T.Block.prototype.getInputWithBlock=function(t){for(var e=0,o;o=this.inputList[e];e++)if(o.connection&&o.connection.targetBlock()==t)return o;return null},T.Block.prototype.getSurroundParent=function(){var t=this;do{var e=t,t;if(!(t=t.getParent()))return null}while(t.getNextBlock()==e);return t},T.Block.prototype.getNextBlock=function(){return this.nextConnection&&this.nextConnection.targetBlock()},T.Block.prototype.getPreviousBlock=function(){return this.previousConnection&&this.previousConnection.targetBlock()},T.Block.prototype.getFirstStatementConnection=function(){for(var t=0,e;e=this.inputList[t];t++)if(e.connection&&e.connection.type==T.connectionTypes.NEXT_STATEMENT)return e.connection;return null},T.Block.prototype.getRootBlock=function(){var t=this;do{var e=t,t=e.parentBlock_}while(t);return e},T.Block.prototype.getTopStackBlock=function(){var t=this;do{var e=t.getPreviousBlock()}while(e&&e.getNextBlock()==t&&(t=e));return t},T.Block.prototype.getChildren=function(t){if(!t)return this.childBlocks_;t=[];for(var e=0,o;o=this.inputList[e];e++)o.connection&&(o=o.connection.targetBlock())&&t.push(o);return(e=this.getNextBlock())&&t.push(e),t},T.Block.prototype.setParent=function(t){if(t!=this.parentBlock_){if(this.parentBlock_){if(T.utils.arrayRemove(this.parentBlock_.childBlocks_,this),this.previousConnection&&this.previousConnection.isConnected())throw Error("Still connected to previous block.");if(this.outputConnection&&this.outputConnection.isConnected())throw Error("Still connected to parent block.");this.parentBlock_=null}else this.workspace.removeTopBlock(this);(this.parentBlock_=t)?t.childBlocks_.push(this):this.workspace.addTopBlock(this)}},T.Block.prototype.getDescendants=function(t){for(var e=[this],o=this.getChildren(t),i,s=0;i=o[s];s++)e.push.apply(e,i.getDescendants(t));return e},T.Block.prototype.isDeletable=function(){return this.deletable_&&!this.isShadow_&&!(this.workspace&&this.workspace.options.readOnly)},T.Block.prototype.setDeletable=function(t){this.deletable_=t},T.Block.prototype.isMovable=function(){return this.movable_&&!this.isShadow_&&!(this.workspace&&this.workspace.options.readOnly)},T.Block.prototype.setMovable=function(t){this.movable_=t},T.Block.prototype.isDuplicatable=function(){return!this.workspace.hasBlockLimits()||this.workspace.isCapacityAvailable(T.utils.getBlockTypeCounts(this,!0))},T.Block.prototype.isShadow=function(){return this.isShadow_},T.Block.prototype.setShadow=function(t){this.isShadow_=t},T.Block.prototype.isInsertionMarker=function(){return this.isInsertionMarker_},T.Block.prototype.setInsertionMarker=function(t){this.isInsertionMarker_=t},T.Block.prototype.isEditable=function(){return this.editable_&&!(this.workspace&&this.workspace.options.readOnly)},T.Block.prototype.setEditable=function(t){this.editable_=t,t=0;for(var e;e=this.inputList[t];t++)for(var o=0,i;i=e.fieldRow[o];o++)i.updateEditable()},T.Block.prototype.isDisposed=function(){return this.disposed},T.Block.prototype.getMatchingConnection=function(t,e){var o=this.getConnections_(!0);if(t=t.getConnections_(!0),o.length!=t.length)throw Error("Connection lists did not match in length.");for(var i=0;i<t.length;i++)if(t[i]==e)return o[i];return null},T.Block.prototype.setHelpUrl=function(t){this.helpUrl=t},T.Block.prototype.setTooltip=function(t){this.tooltip=t},T.Block.prototype.getTooltip=function(){return T.Tooltip.getTooltipOfObject(this)},T.Block.prototype.getColour=function(){return this.colour_},T.Block.prototype.getStyleName=function(){return this.styleName_},T.Block.prototype.getHue=function(){return this.hue_},T.Block.prototype.setColour=function(t){t=T.utils.parseBlockColour(t),this.hue_=t.hue,this.colour_=t.hex},T.Block.prototype.setStyle=function(t){this.styleName_=t},T.Block.prototype.setOnChange=function(t){if(t&&"function"!=typeof t)throw Error("onchange must be a function.");this.onchangeWrapper_&&this.workspace.removeChangeListener(this.onchangeWrapper_),(this.onchange=t)&&(this.onchangeWrapper_=t.bind(this),this.workspace.addChangeListener(this.onchangeWrapper_))},T.Block.prototype.getField=function(t){for(var e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)if(s.name==t)return s;return null},T.Block.prototype.getVars=function(){for(var t=[],e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)s.referencesVariables()&&t.push(s.getValue());return t},T.Block.prototype.getVarModels=function(){for(var t=[],e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)s.referencesVariables()&&(s=this.workspace.getVariableById(s.getValue()))&&t.push(s);return t},T.Block.prototype.updateVarName=function(t){for(var e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)s.referencesVariables()&&t.getId()==s.getValue()&&s.refreshVariableName()},T.Block.prototype.renameVarById=function(t,e){for(var o=0,i;i=this.inputList[o];o++)for(var s=0,n;n=i.fieldRow[s];s++)n.referencesVariables()&&t==n.getValue()&&n.setValue(e)},T.Block.prototype.getFieldValue=function(t){return(t=this.getField(t))?t.getValue():null},T.Block.prototype.setFieldValue=function(t,e){var o=this.getField(e);if(!o)throw Error('Field "'+e+'" not found.');o.setValue(t)},T.Block.prototype.setPreviousStatement=function(t,e){if(t){if(void 0===e&&(e=null),!this.previousConnection){if(this.outputConnection)throw Error("Remove output connection prior to adding previous connection.");this.previousConnection=this.makeConnection_(T.connectionTypes.PREVIOUS_STATEMENT)}this.previousConnection.setCheck(e)}else if(this.previousConnection){if(this.previousConnection.isConnected())throw Error("Must disconnect previous statement before removing connection.");this.previousConnection.dispose(),this.previousConnection=null}},T.Block.prototype.setNextStatement=function(t,e){if(t)void 0===e&&(e=null),this.nextConnection||(this.nextConnection=this.makeConnection_(T.connectionTypes.NEXT_STATEMENT)),this.nextConnection.setCheck(e);else if(this.nextConnection){if(this.nextConnection.isConnected())throw Error("Must disconnect next statement before removing connection.");this.nextConnection.dispose(),this.nextConnection=null}},T.Block.prototype.setOutput=function(t,e){if(t){if(void 0===e&&(e=null),!this.outputConnection){if(this.previousConnection)throw Error("Remove previous connection prior to adding output connection.");this.outputConnection=this.makeConnection_(T.connectionTypes.OUTPUT_VALUE)}this.outputConnection.setCheck(e)}else if(this.outputConnection){if(this.outputConnection.isConnected())throw Error("Must disconnect output value before removing connection.");this.outputConnection.dispose(),this.outputConnection=null}},T.Block.prototype.setInputsInline=function(t){this.inputsInline!=t&&(T.Events.fire(new(T.Events.get(T.Events.BLOCK_CHANGE))(this,"inline",null,this.inputsInline,t)),this.inputsInline=t)},T.Block.prototype.getInputsInline=function(){if(null!=this.inputsInline)return this.inputsInline;for(var t=1;t<this.inputList.length;t++)if(this.inputList[t-1].type==T.inputTypes.DUMMY&&this.inputList[t].type==T.inputTypes.DUMMY)return!1;for(t=1;t<this.inputList.length;t++)if(this.inputList[t-1].type==T.inputTypes.VALUE&&this.inputList[t].type==T.inputTypes.DUMMY)return!0;return!1},T.Block.prototype.setOutputShape=function(t){this.outputShape_=t},T.Block.prototype.getOutputShape=function(){return this.outputShape_},T.Block.prototype.isEnabled=function(){return!this.disabled},T.Block.prototype.setEnabled=function(t){this.isEnabled()!=t&&(T.Events.fire(new(T.Events.get(T.Events.BLOCK_CHANGE))(this,"disabled",null,this.disabled,!t)),this.disabled=!t)},T.Block.prototype.getInheritedDisabled=function(){for(var t=this.getSurroundParent();t;){if(t.disabled)return!0;t=t.getSurroundParent()}return!1},T.Block.prototype.isCollapsed=function(){return this.collapsed_},T.Block.prototype.setCollapsed=function(t){this.collapsed_!=t&&(T.Events.fire(new(T.Events.get(T.Events.BLOCK_CHANGE))(this,"collapsed",null,this.collapsed_,t)),this.collapsed_=t)},T.Block.prototype.toString=function(t,e){function o(t){var e=t.getCheck();return(e=!e&&t.targetConnection?t.targetConnection.getCheck():e)&&(-1!=e.indexOf("Boolean")||-1!=e.indexOf("Number"))}function i(){r&&r.getType()==l.getType()&&r.getLocation()==l.getLocation()&&(r=null)}var s=[],n=(e=e||"?",T.ASTNode.NAVIGATE_ALL_FIELDS);T.ASTNode.NAVIGATE_ALL_FIELDS=!0;for(var r=T.ASTNode.createBlockNode(this),l=r;r;){switch(r.getType()){case T.ASTNode.types.INPUT:var a=r.getLocation();r.in()?o(a)&&s.push("("):s.push(e);break;case T.ASTNode.types.FIELD:(a=r.getLocation()).name!=T.constants.COLLAPSED_FIELD_NAME&&s.push(a.getText())}if(!(r=(a=r).in()||a.next())){for(r=a.out(),i();r&&!r.next();)r=r.out(),i(),r&&r.getType()==T.ASTNode.types.INPUT&&o(r.getLocation())&&s.push(")");r=r&&r.next()}}for(T.ASTNode.NAVIGATE_ALL_FIELDS=n,e=2,n=s.length;e<n;e++)"("==s[e-2]&&")"==s[e]&&(s[e-2]=s[e-1],s.splice(e-1,2),n-=2);return s=s.join(" ").replace(/(\() | (\))/gim,"$1$2").trim()||"???",s=t&&s.length>t?s.substring(0,t-3)+"...":s},T.Block.prototype.appendValueInput=function(t){return this.appendInput_(T.inputTypes.VALUE,t)},T.Block.prototype.appendStatementInput=function(t){return this.appendInput_(T.inputTypes.STATEMENT,t)},T.Block.prototype.appendDummyInput=function(t){return this.appendInput_(T.inputTypes.DUMMY,t||"")},T.Block.prototype.jsonInit=function(t){var e=t.type?'Block "'+t.type+'": ':"";if(t.output&&t.previousStatement)throw Error(e+"Must not have both an output and a previousStatement.");if(t.style&&t.style.hat&&(this.hat=t.style.hat,t.style=null),t.style&&t.colour)throw Error(e+"Must not have both a colour and a style.");t.style?this.jsonInitStyle_(t,e):this.jsonInitColour_(t,e);for(var o=0;void 0!==t["message"+o];)this.interpolate_(t["message"+o],t["args"+o]||[],t["lastDummyAlign"+o],e),o++;if(void 0!==t.inputsInline&&this.setInputsInline(t.inputsInline),void 0!==t.output&&this.setOutput(!0,t.output),void 0!==t.outputShape&&this.setOutputShape(t.outputShape),void 0!==t.previousStatement&&this.setPreviousStatement(!0,t.previousStatement),void 0!==t.nextStatement&&this.setNextStatement(!0,t.nextStatement),void 0!==t.tooltip&&(o=t.tooltip,o=T.utils.replaceMessageReferences(o),this.setTooltip(o)),void 0!==t.enableContextMenu&&(o=t.enableContextMenu,this.contextMenu=!!o),void 0!==t.helpUrl&&(o=t.helpUrl,o=T.utils.replaceMessageReferences(o),this.setHelpUrl(o)),"string"==typeof t.extensions&&(console.warn(e+"JSON attribute 'extensions' should be an array of strings. Found raw string in JSON for '"+t.type+"' block."),t.extensions=[t.extensions]),void 0!==t.mutator&&T.Extensions.apply(t.mutator,this,!0),Array.isArray(t.extensions))for(t=t.extensions,e=0;e<t.length;++e)T.Extensions.apply(t[e],this,!1)},T.Block.prototype.jsonInitColour_=function(e,o){if("colour"in e)if(void 0===e.colour)console.warn(o+"Undefined colour value.");else{e=e.colour;try{this.setColour(e)}catch(t){console.warn(o+"Illegal colour value: ",e)}}},T.Block.prototype.jsonInitStyle_=function(e,o){e=e.style;try{this.setStyle(e)}catch(t){console.warn(o+"Style does not exist: ",e)}},T.Block.prototype.mixin=function(t,e){if(void 0!==e&&"boolean"!=typeof e)throw Error("opt_disableCheck must be a boolean if provided");if(!e){for(var o in e=[],t)void 0!==this[o]&&e.push(o);if(e.length)throw Error("Mixin will overwrite block members: "+JSON.stringify(e))}T.utils.object.mixin(this,t)},T.Block.prototype.interpolate_=function(t,e,o,i){t=T.utils.tokenizeInterpolation(t),this.validateTokens_(t,e.length),e=this.interpolateArguments_(t,e,o),o=[],t=0;for(var s;s=e[t];t++)if(this.isInputKeyword_(s.type)){if(s=this.inputFromJson_(s,i)){for(var n=0,r;r=o[n];n++)s.appendField(r[0],r[1]);o.length=0}}else(n=this.fieldFromJson_(s))&&o.push([n,s.name])},T.Block.prototype.validateTokens_=function(t,e){for(var o=[],i=0,s=0;s<t.length;s++){var n=t[s];if("number"==typeof n){if(n<1||e<n)throw Error('Block "'+this.type+'": Message index %'+n+" out of range.");if(o[n])throw Error('Block "'+this.type+'": Message index %'+n+" duplicated.");o[n]=!0,i++}}if(i!=e)throw Error('Block "'+this.type+'": Message does not reference all '+e+" arg(s).")},T.Block.prototype.interpolateArguments_=function(t,e,o){for(var i=[],s=0;s<t.length;s++){var n=t[s];if("string"==typeof(n="number"==typeof n?e[n-1]:n)&&!(n=this.stringToFieldJson_(n)))continue;i.push(n)}return(t=i.length)&&!this.isInputKeyword_(i[t-1].type)&&(t={type:"input_dummy"},o&&(t.align=o),i.push(t)),i},T.Block.prototype.fieldFromJson_=function(t){var e=T.fieldRegistry.fromJson(t);return!e&&t.alt?"string"==typeof t.alt?(t=this.stringToFieldJson_(t.alt))?this.fieldFromJson_(t):null:this.fieldFromJson_(t.alt):e},T.Block.prototype.inputFromJson_=function(t,e){var o={LEFT:T.constants.ALIGN.LEFT,RIGHT:T.constants.ALIGN.RIGHT,CENTRE:T.constants.ALIGN.CENTRE,CENTER:T.constants.ALIGN.CENTRE},i=null;switch(t.type){case"input_value":i=this.appendValueInput(t.name);break;case"input_statement":i=this.appendStatementInput(t.name);break;case"input_dummy":i=this.appendDummyInput(t.name)}if(!i)return null;return t.check&&i.setCheck(t.check),t.align&&(void 0===(o=o[t.align.toUpperCase()])?console.warn(e+"Illegal align value: ",t.align):i.setAlign(o)),i},T.Block.prototype.isInputKeyword_=function(t){return"input_value"==t||"input_statement"==t||"input_dummy"==t},T.Block.prototype.stringToFieldJson_=function(t){return(t=t.trim())?{type:"field_label",text:t}:null},T.Block.prototype.appendInput_=function(t,e){var o=null;return t!=T.inputTypes.VALUE&&t!=T.inputTypes.STATEMENT||(o=this.makeConnection_(t)),t==T.inputTypes.STATEMENT&&this.statementInputCount++,t=new T.Input(t,e,this,o),this.inputList.push(t),t},T.Block.prototype.moveInputBefore=function(t,e){if(t!=e){for(var o=-1,i=e?-1:this.inputList.length,s=0,n;n=this.inputList[s];s++)if(n.name==t){if(o=s,-1!=i)break}else if(e&&n.name==e&&(i=s,-1!=o))break;if(-1==o)throw Error('Named input "'+t+'" not found.');if(-1==i)throw Error('Reference input "'+e+'" not found.');this.moveNumberedInputBefore(o,i)}},T.Block.prototype.moveNumberedInputBefore=function(t,e){if(t==e)throw Error("Can't move input to itself.");if(t>=this.inputList.length)throw RangeError("Input index "+t+" out of bounds.");if(e>this.inputList.length)throw RangeError("Reference input "+e+" out of bounds.");var o=this.inputList[t];this.inputList.splice(t,1),t<e&&e--,this.inputList.splice(e,0,o)},T.Block.prototype.removeInput=function(t,e){for(var o=0,i;i=this.inputList[o];o++)if(i.name==t)return i.type==T.inputTypes.STATEMENT&&this.statementInputCount--,i.dispose(),this.inputList.splice(o,1),!0;if(e)return!1;throw Error("Input not found: "+t)},T.Block.prototype.getInput=function(t){for(var e=0,o;o=this.inputList[e];e++)if(o.name==t)return o;return null},T.Block.prototype.getInputTargetBlock=function(t){return(t=this.getInput(t))&&t.connection&&t.connection.targetBlock()},T.Block.prototype.getCommentText=function(){return this.commentModel.text},T.Block.prototype.setCommentText=function(t){this.commentModel.text!=t&&(T.Events.fire(new(T.Events.get(T.Events.BLOCK_CHANGE))(this,"comment",null,this.commentModel.text,t)),this.comment=this.commentModel.text=t)},T.Block.prototype.setWarningText=function(t,e){},T.Block.prototype.setMutator=function(t){},T.Block.prototype.getRelativeToSurfaceXY=function(){return this.xy_},T.Block.prototype.moveBy=function(t,e){if(this.parentBlock_)throw Error("Block has parent.");var o=new(T.Events.get(T.Events.BLOCK_MOVE))(this);this.xy_.translate(t,e),o.recordNew(),T.Events.fire(o)},T.Block.prototype.makeConnection_=function(t){return new T.Connection(this,t)},T.Block.prototype.allInputsFilled=function(t){if(!(t=void 0===t?!0:t)&&this.isShadow())return!1;for(var e=0,o;o=this.inputList[e];e++)if(o.connection&&(!(o=o.connection.targetBlock())||!o.allInputsFilled(t)))return!1;return!(e=this.getNextBlock())||e.allInputsFilled(t)},T.Block.prototype.toDevString=function(){var t=this.type?'"'+this.type+'" block':"Block";return this.id&&(t+=' (id="'+this.id+'")'),t},T.blockRendering.IPathObject=function(t,e){},T.utils.KeyCodes={WIN_KEY_FF_LINUX:0,MAC_ENTER:3,BACKSPACE:8,TAB:9,NUM_CENTER:12,ENTER:13,SHIFT:16,CTRL:17,ALT:18,PAUSE:19,CAPS_LOCK:20,ESC:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,PLUS_SIGN:43,PRINT_SCREEN:44,INSERT:45,DELETE:46,ZERO:48,ONE:49,TWO:50,THREE:51,FOUR:52,FIVE:53,SIX:54,SEVEN:55,EIGHT:56,NINE:57,FF_SEMICOLON:59,FF_EQUALS:61,FF_DASH:173,FF_HASH:163,QUESTION_MARK:63,AT_SIGN:64,A:65,B:66,C:67,D:68,E:69,F:70,G:71,H:72,I:73,J:74,K:75,L:76,M:77,N:78,O:79,P:80,Q:81,R:82,S:83,T:84,U:85,V:86,W:87,X:88,Y:89,Z:90,META:91,WIN_KEY_RIGHT:92,CONTEXT_MENU:93,NUM_ZERO:96,NUM_ONE:97,NUM_TWO:98,NUM_THREE:99,NUM_FOUR:100,NUM_FIVE:101,NUM_SIX:102,NUM_SEVEN:103,NUM_EIGHT:104,NUM_NINE:105,NUM_MULTIPLY:106,NUM_PLUS:107,NUM_MINUS:109,NUM_PERIOD:110,NUM_DIVISION:111,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,NUMLOCK:144,SCROLL_LOCK:145,FIRST_MEDIA_KEY:166,LAST_MEDIA_KEY:183,SEMICOLON:186,DASH:189,EQUALS:187,COMMA:188,PERIOD:190,SLASH:191,APOSTROPHE:192,TILDE:192,SINGLE_QUOTE:222,OPEN_SQUARE_BRACKET:219,BACKSLASH:220,CLOSE_SQUARE_BRACKET:221,WIN_KEY:224,MAC_FF_META:224,MAC_WK_CMD_LEFT:91,MAC_WK_CMD_RIGHT:93,WIN_IME:229,VK_NONAME:252,PHANTOM:255},T.Menu=function(){this.menuItems_=[],this.roleName_=this.element_=this.onKeyDownHandler_=this.mouseLeaveHandler_=this.mouseEnterHandler_=this.clickHandler_=this.mouseOverHandler_=this.highlightedItem_=this.openingCoords=null},T.Menu.prototype.addChild=function(t){this.menuItems_.push(t)},T.Menu.prototype.render=function(t){var e=document.createElement("div");e.className="blocklyMenu goog-menu blocklyNonSelectable",e.tabIndex=0,this.roleName_&&T.utils.aria.setRole(e,this.roleName_),this.element_=e;for(var o=0,i;i=this.menuItems_[o];o++)e.appendChild(i.createDom());this.mouseOverHandler_=T.browserEvents.conditionalBind(e,"mouseover",this,this.handleMouseOver_,!0),this.clickHandler_=T.browserEvents.conditionalBind(e,"click",this,this.handleClick_,!0),this.mouseEnterHandler_=T.browserEvents.conditionalBind(e,"mouseenter",this,this.handleMouseEnter_,!0),this.mouseLeaveHandler_=T.browserEvents.conditionalBind(e,"mouseleave",this,this.handleMouseLeave_,!0),this.onKeyDownHandler_=T.browserEvents.conditionalBind(e,"keydown",this,this.handleKeyEvent_),t.appendChild(e)},T.Menu.prototype.getElement=function(){return this.element_},T.Menu.prototype.focus=function(){var t=this.getElement();t&&(t.focus({preventScroll:!0}),T.utils.dom.addClass(t,"blocklyFocused"))},T.Menu.prototype.blur_=function(){var t=this.getElement();t&&(t.blur(),T.utils.dom.removeClass(t,"blocklyFocused"))},T.Menu.prototype.setRole=function(t){this.roleName_=t},T.Menu.prototype.dispose=function(){this.mouseOverHandler_&&(T.browserEvents.unbind(this.mouseOverHandler_),this.mouseOverHandler_=null),this.clickHandler_&&(T.browserEvents.unbind(this.clickHandler_),this.clickHandler_=null),this.mouseEnterHandler_&&(T.browserEvents.unbind(this.mouseEnterHandler_),this.mouseEnterHandler_=null),this.mouseLeaveHandler_&&(T.browserEvents.unbind(this.mouseLeaveHandler_),this.mouseLeaveHandler_=null),this.onKeyDownHandler_&&(T.browserEvents.unbind(this.onKeyDownHandler_),this.onKeyDownHandler_=null);for(var t=0,e;e=this.menuItems_[t];t++)e.dispose();this.element_=null},T.Menu.prototype.getMenuItem_=function(t){for(var e=this.getElement();t&&t!=e;){if(T.utils.dom.hasClass(t,"blocklyMenuItem"))for(var o=0,i;i=this.menuItems_[o];o++)if(i.getElement()==t)return i;t=t.parentElement}return null},T.Menu.prototype.setHighlighted=function(t){var e=this.highlightedItem_;e&&(e.setHighlighted(!1),this.highlightedItem_=null),t&&(t.setHighlighted(!0),this.highlightedItem_=t,e=this.getElement(),T.utils.style.scrollIntoContainerView(t.getElement(),e),T.utils.aria.setState(e,T.utils.aria.State.ACTIVEDESCENDANT,t.getId()))},T.Menu.prototype.highlightNext=function(){var t=this.menuItems_.indexOf(this.highlightedItem_);this.highlightHelper_(t,1)},T.Menu.prototype.highlightPrevious=function(){var t=this.menuItems_.indexOf(this.highlightedItem_);this.highlightHelper_(t<0?this.menuItems_.length:t,-1)},T.Menu.prototype.highlightFirst_=function(){this.highlightHelper_(-1,1)},T.Menu.prototype.highlightLast_=function(){this.highlightHelper_(this.menuItems_.length,-1)},T.Menu.prototype.highlightHelper_=function(t,e){t+=e;for(var o;o=this.menuItems_[t];){if(o.isEnabled()){this.setHighlighted(o);break}t+=e}},T.Menu.prototype.handleMouseOver_=function(t){(t=this.getMenuItem_(t.target))&&(t.isEnabled()?this.highlightedItem_!=t&&this.setHighlighted(t):this.setHighlighted(null))},T.Menu.prototype.handleClick_=function(t){var e=this.openingCoords;if(this.openingCoords=null,e&&"number"==typeof t.clientX){var o=new T.utils.Coordinate(t.clientX,t.clientY);if(T.utils.Coordinate.distance(e,o)<1)return}(t=this.getMenuItem_(t.target))&&t.performAction()},T.Menu.prototype.handleMouseEnter_=function(t){this.focus()},T.Menu.prototype.handleMouseLeave_=function(t){this.getElement()&&(this.blur_(),this.setHighlighted(null))},T.Menu.prototype.handleKeyEvent_=function(t){if(this.menuItems_.length&&!(t.shiftKey||t.ctrlKey||t.metaKey||t.altKey)){var e=this.highlightedItem_;switch(t.keyCode){case T.utils.KeyCodes.ENTER:case T.utils.KeyCodes.SPACE:e&&e.performAction();break;case T.utils.KeyCodes.UP:this.highlightPrevious();break;case T.utils.KeyCodes.DOWN:this.highlightNext();break;case T.utils.KeyCodes.PAGE_UP:case T.utils.KeyCodes.HOME:this.highlightFirst_();break;case T.utils.KeyCodes.PAGE_DOWN:case T.utils.KeyCodes.END:this.highlightLast_();break;default:return}t.preventDefault(),t.stopPropagation()}},T.Menu.prototype.getSize=function(){var t=this.getElement(),e=T.utils.style.getSize(t);return e.height=t.scrollHeight,e},T.MenuItem=function(t,e){this.content_=t,this.value_=e,this.enabled_=!0,this.element_=null,this.rightToLeft_=!1,this.roleName_=null,this.highlight_=this.checked_=this.checkable_=!1,this.actionHandler_=null},T.MenuItem.prototype.createDom=function(){var t=document.createElement("div"),e=(t.id=T.utils.IdGenerator.getNextUniqueId(),(this.element_=t).className="blocklyMenuItem goog-menuitem "+(this.enabled_?"":"blocklyMenuItemDisabled goog-menuitem-disabled ")+(this.checked_?"blocklyMenuItemSelected goog-option-selected ":"")+(this.highlight_?"blocklyMenuItemHighlight goog-menuitem-highlight ":"")+(this.rightToLeft_?"blocklyMenuItemRtl goog-menuitem-rtl ":""),document.createElement("div")),o;return e.className="blocklyMenuItemContent goog-menuitem-content",this.checkable_&&((o=document.createElement("div")).className="blocklyMenuItemCheckbox goog-menuitem-checkbox",e.appendChild(o)),o=this.content_,"string"==typeof this.content_&&(o=document.createTextNode(this.content_)),e.appendChild(o),t.appendChild(e),this.roleName_&&T.utils.aria.setRole(t,this.roleName_),T.utils.aria.setState(t,T.utils.aria.State.SELECTED,this.checkable_&&this.checked_||!1),T.utils.aria.setState(t,T.utils.aria.State.DISABLED,!this.enabled_),t},T.MenuItem.prototype.dispose=function(){this.element_=null},T.MenuItem.prototype.getElement=function(){return this.element_},T.MenuItem.prototype.getId=function(){return this.element_.id},T.MenuItem.prototype.getValue=function(){return this.value_},T.MenuItem.prototype.setRightToLeft=function(t){this.rightToLeft_=t},T.MenuItem.prototype.setRole=function(t){this.roleName_=t},T.MenuItem.prototype.setCheckable=function(t){this.checkable_=t},T.MenuItem.prototype.setChecked=function(t){this.checked_=t},T.MenuItem.prototype.setHighlighted=function(t){this.highlight_=t;var e=this.getElement();e&&this.isEnabled()&&(t?(T.utils.dom.addClass(e,"blocklyMenuItemHighlight"),T.utils.dom.addClass(e,"goog-menuitem-highlight")):(T.utils.dom.removeClass(e,"blocklyMenuItemHighlight"),T.utils.dom.removeClass(e,"goog-menuitem-highlight")))},T.MenuItem.prototype.isEnabled=function(){return this.enabled_},T.MenuItem.prototype.setEnabled=function(t){this.enabled_=t},T.MenuItem.prototype.performAction=function(){this.isEnabled()&&this.actionHandler_&&this.actionHandler_(this)},T.MenuItem.prototype.onAction=function(t,e){this.actionHandler_=t.bind(e)},T.WidgetDiv={},T.WidgetDiv.owner_=null,T.WidgetDiv.dispose_=null,T.WidgetDiv.rendererClassName_="",T.WidgetDiv.themeClassName_="",T.WidgetDiv.createDom=function(){T.WidgetDiv.DIV||(T.WidgetDiv.DIV=document.createElement("div"),T.WidgetDiv.DIV.className="blocklyWidgetDiv",(T.parentContainer||document.body).appendChild(T.WidgetDiv.DIV))},T.WidgetDiv.show=function(t,e,o){T.WidgetDiv.hide(),T.WidgetDiv.owner_=t,T.WidgetDiv.dispose_=o,(t=T.WidgetDiv.DIV).style.direction=e?"rtl":"ltr",t.style.display="block",e=T.getMainWorkspace(),T.WidgetDiv.rendererClassName_=e.getRenderer().getClassName(),T.WidgetDiv.themeClassName_=e.getTheme().getClassName(),T.utils.dom.addClass(t,T.WidgetDiv.rendererClassName_),T.utils.dom.addClass(t,T.WidgetDiv.themeClassName_)},T.WidgetDiv.hide=function(){var t;T.WidgetDiv.isVisible()&&(T.WidgetDiv.owner_=null,(t=T.WidgetDiv.DIV).style.display="none",t.style.left="",t.style.top="",T.WidgetDiv.dispose_&&T.WidgetDiv.dispose_(),T.WidgetDiv.dispose_=null,t.textContent="",T.WidgetDiv.rendererClassName_&&(T.utils.dom.removeClass(t,T.WidgetDiv.rendererClassName_),T.WidgetDiv.rendererClassName_=""),T.WidgetDiv.themeClassName_&&(T.utils.dom.removeClass(t,T.WidgetDiv.themeClassName_),T.WidgetDiv.themeClassName_=""),T.getMainWorkspace().markFocused())},T.WidgetDiv.isVisible=function(){return!!T.WidgetDiv.owner_},T.WidgetDiv.hideIfOwner=function(t){T.WidgetDiv.owner_==t&&T.WidgetDiv.hide()},T.WidgetDiv.positionInternal_=function(t,e,o){T.WidgetDiv.DIV.style.left=t+"px",T.WidgetDiv.DIV.style.top=e+"px",T.WidgetDiv.DIV.style.height=o+"px"},T.WidgetDiv.positionWithAnchor=function(t,e,o,i){var s=T.WidgetDiv.calculateY_(t,e,o);t=T.WidgetDiv.calculateX_(t,e,o,i),s<0?T.WidgetDiv.positionInternal_(t,0,o.height+s):T.WidgetDiv.positionInternal_(t,s,o.height)},T.WidgetDiv.calculateX_=function(t,e,o,i){if(i)return e=Math.max(e.right-o.width,t.left),Math.min(e,t.right-o.width);return e=Math.min(e.left,t.right-o.width),Math.max(e,t.left)},T.WidgetDiv.calculateY_=function(t,e,o){return e.bottom+o.height>=t.bottom?e.top-o.height:e.bottom},T.ContextMenu={},T.ContextMenu.currentBlock=null,T.ContextMenu.menu_=null,T.ContextMenu.show=function(t,e,o){var i;T.WidgetDiv.show(T.ContextMenu,o,T.ContextMenu.dispose),e.length?(i=T.ContextMenu.populate_(e,o),T.ContextMenu.menu_=i,T.ContextMenu.position_(i,t,o),setTimeout(function(){i.focus()},1),T.ContextMenu.currentBlock=null):T.ContextMenu.hide()},T.ContextMenu.populate_=function(t,e){var o=new T.Menu;o.setRole(T.utils.aria.Role.MENU);for(var i=0,s;s=t[i];i++){var n=new T.MenuItem(s.text);n.setRightToLeft(e),n.setRole(T.utils.aria.Role.MENUITEM),o.addChild(n),n.setEnabled(s.enabled),s.enabled&&n.onAction(function(t){T.ContextMenu.hide(),this.callback(this.scope)},s)}return o},T.ContextMenu.position_=function(t,e,o){var i=T.utils.getViewportBBox(),s=(e=new T.utils.Rect(e.clientY+i.top,e.clientY+i.top,e.clientX+i.left,e.clientX+i.left),T.ContextMenu.createWidget_(t),t.getSize());o&&(e.left+=s.width,e.right+=s.width,i.left+=s.width,i.right+=s.width),T.WidgetDiv.positionWithAnchor(i,e,s,o),t.focus()},T.ContextMenu.createWidget_=function(t){t.render(T.WidgetDiv.DIV);var e=t.getElement();T.utils.dom.addClass(e,"blocklyContextMenu"),T.browserEvents.conditionalBind(e,"contextmenu",null,T.utils.noEvent),t.focus()},T.ContextMenu.hide=function(){T.WidgetDiv.hideIfOwner(T.ContextMenu),T.ContextMenu.currentBlock=null},T.ContextMenu.dispose=function(){T.ContextMenu.menu_&&(T.ContextMenu.menu_.dispose(),T.ContextMenu.menu_=null)},T.ContextMenu.callbackFactory=function(o,i){return function(){T.Events.disable();try{var t=T.Xml.domToBlock(i,o.workspace),e=o.getRelativeToSurfaceXY();e.x=o.RTL?e.x-T.SNAP_RADIUS:e.x+T.SNAP_RADIUS,e.y+=2*T.SNAP_RADIUS,t.moveBy(e.x,e.y)}finally{T.Events.enable()}T.Events.isEnabled()&&!t.isShadow()&&T.Events.fire(new(T.Events.get(T.Events.BLOCK_CREATE))(t)),t.select()}},T.ContextMenu.commentDeleteOption=function(t){return{text:T.Msg.REMOVE_COMMENT,enabled:!0,callback:function(){T.Events.setGroup(!0),t.dispose(!0,!0),T.Events.setGroup(!1)}}},T.ContextMenu.commentDuplicateOption=function(t){return{text:T.Msg.DUPLICATE_COMMENT,enabled:!0,callback:function(){T.duplicate(t)}}},T.ContextMenu.workspaceCommentOption=function(i,s){if(!T.WorkspaceCommentSvg)throw Error("Missing require for Blockly.WorkspaceCommentSvg");var t={enabled:!T.utils.userAgent.IE};return t.text=T.Msg.ADD_COMMENT,t.callback=function(){var t=new T.WorkspaceCommentSvg(i,T.Msg.WORKSPACE_COMMENT_DEFAULT_TEXT,T.WorkspaceCommentSvg.DEFAULT_SIZE,T.WorkspaceCommentSvg.DEFAULT_SIZE),e=i.getInjectionDiv().getBoundingClientRect(),e=new T.utils.Coordinate(s.clientX-e.left,s.clientY-e.top),o=i.getOriginOffsetInPixels();(e=T.utils.Coordinate.difference(e,o)).scale(1/i.scale),t.moveBy(e.x,e.y),i.rendered&&(t.initSvg(),t.render(),t.select())},t},T.ContextMenuRegistry=function(){(T.ContextMenuRegistry.registry=this).registry_={}},T.ContextMenuRegistry.ScopeType={BLOCK:"block",WORKSPACE:"workspace"},T.ContextMenuRegistry.registry=null,T.ContextMenuRegistry.prototype.register=function(t){if(this.registry_[t.id])throw Error('Menu item with id "'+t.id+'" is already registered.');this.registry_[t.id]=t},T.ContextMenuRegistry.prototype.unregister=function(t){if(!this.registry_[t])throw Error('Menu item with id "'+t+'" not found.');delete this.registry_[t]},T.ContextMenuRegistry.prototype.getItem=function(t){return this.registry_[t]||null},T.ContextMenuRegistry.prototype.getContextMenuOptions=function(o,i){var s=[],n=this.registry_;return Object.keys(n).forEach(function(t){var e;t=n[t],o==t.scopeType&&"hidden"!=(e=t.preconditionFn(i))&&(t={text:"function"==typeof t.displayText?t.displayText(i):t.displayText,enabled:"enabled"==e,callback:t.callback,scope:i,weight:t.weight},s.push(t))}),s.sort(function(t,e){return t.weight-e.weight}),s},new T.ContextMenuRegistry,T.Events.Selected=function(t,e,o){T.Events.Selected.superClass_.constructor.call(this,o),this.oldElementId=t,this.newElementId=e},T.utils.object.inherits(T.Events.Selected,T.Events.UiBase),T.Events.Selected.prototype.type=T.Events.SELECTED,T.Events.Selected.prototype.toJson=function(){var t=T.Events.Selected.superClass_.toJson.call(this);return t.oldElementId=this.oldElementId,t.newElementId=this.newElementId,t},T.Events.Selected.prototype.fromJson=function(t){T.Events.Selected.superClass_.fromJson.call(this,t),this.oldElementId=t.oldElementId,this.newElementId=t.newElementId},T.registry.register(T.registry.Type.EVENT,T.Events.SELECTED,T.Events.Selected),T.RenderedConnection=function(t,e){T.RenderedConnection.superClass_.constructor.call(this,t,e),this.db_=t.workspace.connectionDBList[e],this.dbOpposite_=t.workspace.connectionDBList[T.OPPOSITE_TYPE[e]],this.offsetInBlock_=new T.utils.Coordinate(0,0),this.trackedState_=T.RenderedConnection.TrackedState.WILL_TRACK,this.targetConnection=null},T.utils.object.inherits(T.RenderedConnection,T.Connection),T.RenderedConnection.TrackedState={WILL_TRACK:-1,UNTRACKED:0,TRACKED:1},T.RenderedConnection.prototype.dispose=function(){T.RenderedConnection.superClass_.dispose.call(this),this.trackedState_==T.RenderedConnection.TrackedState.TRACKED&&this.db_.removeConnection(this,this.y)},T.RenderedConnection.prototype.getSourceBlock=function(){return T.RenderedConnection.superClass_.getSourceBlock.call(this)},T.RenderedConnection.prototype.targetBlock=function(){return T.RenderedConnection.superClass_.targetBlock.call(this)},T.RenderedConnection.prototype.distanceFrom=function(t){var e=this.x-t.x;return t=this.y-t.y,Math.sqrt(e*e+t*t)},T.RenderedConnection.prototype.bumpAwayFrom=function(t){if(!this.sourceBlock_.workspace.isDragging()){var e=this.sourceBlock_.getRootBlock();if(!e.isInFlyout){var o=!1;if(!e.isMovable()){if(!(e=t.getSourceBlock().getRootBlock()).isMovable())return;t=this,o=!0}var i=T.selected==e,s=(i||e.addSelect(),t.x+T.SNAP_RADIUS+Math.floor(Math.random()*T.BUMP_RANDOMNESS)-this.x),n=t.y+T.SNAP_RADIUS+Math.floor(Math.random()*T.BUMP_RANDOMNESS)-this.y;o&&(n=-n),e.RTL&&(s=t.x-T.SNAP_RADIUS-Math.floor(Math.random()*T.BUMP_RANDOMNESS)-this.x),e.moveBy(s,n),i||e.removeSelect()}}},T.RenderedConnection.prototype.moveTo=function(t,e){this.trackedState_==T.RenderedConnection.TrackedState.WILL_TRACK?(this.db_.addConnection(this,e),this.trackedState_=T.RenderedConnection.TrackedState.TRACKED):this.trackedState_==T.RenderedConnection.TrackedState.TRACKED&&(this.db_.removeConnection(this,this.y),this.db_.addConnection(this,e)),this.x=t,this.y=e},T.RenderedConnection.prototype.moveBy=function(t,e){this.moveTo(this.x+t,this.y+e)},T.RenderedConnection.prototype.moveToOffset=function(t){this.moveTo(t.x+this.offsetInBlock_.x,t.y+this.offsetInBlock_.y)},T.RenderedConnection.prototype.setOffsetInBlock=function(t,e){this.offsetInBlock_.x=t,this.offsetInBlock_.y=e},T.RenderedConnection.prototype.getOffsetInBlock=function(){return this.offsetInBlock_},T.RenderedConnection.prototype.tighten=function(){var t=this.targetConnection.x-this.x,e=this.targetConnection.y-this.y;if(0!=t||0!=e){var o=this.targetBlock(),i=o.getSvgRoot();if(!i)throw Error("block is not rendered.");i=T.utils.getRelativeXY(i),o.getSvgRoot().setAttribute("transform","translate("+(i.x-t)+","+(i.y-e)+")"),o.moveConnections(-t,-e)}},T.RenderedConnection.prototype.closest=function(t,e){return this.dbOpposite_.searchForClosest(this,t,e)},T.RenderedConnection.prototype.highlight=function(){var t,e=(t=this.sourceBlock_.workspace.getRenderer().getConstants()).shapeFor(this),e=this.type==T.connectionTypes.INPUT_VALUE||this.type==T.connectionTypes.OUTPUT_VALUE?(t=t.TAB_OFFSET_FROM_TOP,T.utils.svgPaths.moveBy(0,-t)+T.utils.svgPaths.lineOnAxis("v",t)+e.pathDown+T.utils.svgPaths.lineOnAxis("v",t)):(t=t.NOTCH_OFFSET_LEFT-t.CORNER_RADIUS,T.utils.svgPaths.moveBy(-t,0)+T.utils.svgPaths.lineOnAxis("h",t)+e.pathLeft+T.utils.svgPaths.lineOnAxis("h",t)),t=this.sourceBlock_.getRelativeToSurfaceXY();T.Connection.highlightedPath_=T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyHighlightedConnectionPath",d:e,transform:"translate("+(this.x-t.x)+","+(this.y-t.y)+")"+(this.sourceBlock_.RTL?" scale(-1 1)":"")},this.sourceBlock_.getSvgRoot())},T.RenderedConnection.prototype.unhighlight=function(){T.utils.dom.removeNode(T.Connection.highlightedPath_),delete T.Connection.highlightedPath_},T.RenderedConnection.prototype.setTracking=function(t){t&&this.trackedState_==T.RenderedConnection.TrackedState.TRACKED||!t&&this.trackedState_==T.RenderedConnection.TrackedState.UNTRACKED||this.sourceBlock_.isInFlyout||(t?(this.db_.addConnection(this,this.y),this.trackedState_=T.RenderedConnection.TrackedState.TRACKED):(this.trackedState_==T.RenderedConnection.TrackedState.TRACKED&&this.db_.removeConnection(this,this.y),this.trackedState_=T.RenderedConnection.TrackedState.UNTRACKED))},T.RenderedConnection.prototype.stopTrackingAll=function(){if(this.setTracking(!1),this.targetConnection)for(var t=this.targetBlock().getDescendants(!1),e=0;e<t.length;e++){for(var o=t[e],i=o.getConnections_(!0),s=0;s<i.length;s++)i[s].setTracking(!1);for(o=o.getIcons(),s=0;s<o.length;s++)o[s].setVisible(!1)}},T.RenderedConnection.prototype.startTrackingAll=function(){this.setTracking(!0);var t=[];if(this.type!=T.connectionTypes.INPUT_VALUE&&this.type!=T.connectionTypes.NEXT_STATEMENT)return t;var e=this.targetBlock(),o;if(e){e.isCollapsed()?(o=[],e.outputConnection&&o.push(e.outputConnection),e.nextConnection&&o.push(e.nextConnection),e.previousConnection&&o.push(e.previousConnection)):o=e.getConnections_(!0);for(var i=0;i<o.length;i++)t.push.apply(t,o[i].startTrackingAll());t.length||(t[0]=e)}return t},T.RenderedConnection.prototype.isConnectionAllowed=function(t,e){return T.utils.deprecation.warn("RenderedConnection.prototype.isConnectionAllowed","July 2020","July 2021","Blockly.Workspace.prototype.getConnectionChecker().canConnect"),!(this.distanceFrom(t)>e)&&T.RenderedConnection.superClass_.isConnectionAllowed.call(this,t)},T.RenderedConnection.prototype.onFailedConnect=function(t){this.bumpAwayFrom(t)},T.RenderedConnection.prototype.disconnectInternal_=function(t,e){T.RenderedConnection.superClass_.disconnectInternal_.call(this,t,e),t.rendered&&t.render(),e.rendered&&(e.updateDisabled(),e.render(),e.getSvgRoot().style.display="block")},T.RenderedConnection.prototype.respawnShadow_=function(){T.RenderedConnection.superClass_.respawnShadow_.call(this);var t=this.targetBlock();t&&(t.initSvg(),t.render(!1),(t=this.getSourceBlock()).rendered)&&t.render()},T.RenderedConnection.prototype.neighbours=function(t){return this.dbOpposite_.getNeighbours(this,t)},T.RenderedConnection.prototype.connect_=function(t){T.RenderedConnection.superClass_.connect_.call(this,t);var e=this.getSourceBlock(),o=(t=t.getSourceBlock(),e.rendered),i=t.rendered;o&&e.updateDisabled(),i&&t.updateDisabled(),o&&i&&(this.type==T.connectionTypes.NEXT_STATEMENT||this.type==T.connectionTypes.PREVIOUS_STATEMENT?t:e).render(),(e=e.getInputWithBlock(t))&&(e=e.isVisible(),t.getSvgRoot().style.display=e?"block":"none")},T.RenderedConnection.prototype.onCheckChanged_=function(){!this.isConnected()||this.targetConnection&&this.getConnectionChecker().canConnect(this,this.targetConnection,!1)||((this.isSuperior()?this.targetBlock():this.sourceBlock_).unplug(),this.sourceBlock_.bumpNeighbours())},T.Marker=function(){this.drawer_=this.curNode_=this.colour=null,this.type="marker"},T.Marker.prototype.setDrawer=function(t){this.drawer_=t},T.Marker.prototype.getDrawer=function(){return this.drawer_},T.Marker.prototype.getCurNode=function(){return this.curNode_},T.Marker.prototype.setCurNode=function(t){var e=this.curNode_;this.curNode_=t,this.drawer_&&this.drawer_.draw(e,this.curNode_)},T.Marker.prototype.draw=function(){this.drawer_&&this.drawer_.draw(this.curNode_,this.curNode_)},T.Marker.prototype.hide=function(){this.drawer_&&this.drawer_.hide()},T.Marker.prototype.dispose=function(){this.getDrawer()&&this.getDrawer().dispose()},T.Cursor=function(){T.Cursor.superClass_.constructor.call(this),this.type="cursor"},T.utils.object.inherits(T.Cursor,T.Marker),T.Cursor.prototype.next=function(){var t=this.getCurNode();if(!t)return null;for(t=t.next();t&&t.next()&&(t.getType()==T.ASTNode.types.NEXT||t.getType()==T.ASTNode.types.BLOCK);)t=t.next();return t&&this.setCurNode(t),t},T.Cursor.prototype.in=function(){var t=this.getCurNode();if(!t)return null;return(t=(t=t.getType()!=T.ASTNode.types.PREVIOUS&&t.getType()!=T.ASTNode.types.OUTPUT?t:t.next()).in())&&this.setCurNode(t),t},T.Cursor.prototype.prev=function(){var t=this.getCurNode();if(!t)return null;for(t=t.prev();t&&t.prev()&&(t.getType()==T.ASTNode.types.NEXT||t.getType()==T.ASTNode.types.BLOCK);)t=t.prev();return t&&this.setCurNode(t),t},T.Cursor.prototype.out=function(){var t=this.getCurNode();if(!t)return null;return(t=(t=t.out())&&t.getType()==T.ASTNode.types.BLOCK?t.prev()||t:t)&&this.setCurNode(t),t},T.registry.register(T.registry.Type.CURSOR,T.registry.DEFAULT,T.Cursor),T.BasicCursor=function(){T.BasicCursor.superClass_.constructor.call(this)},T.utils.object.inherits(T.BasicCursor,T.Cursor),T.BasicCursor.registrationName="basicCursor",T.BasicCursor.prototype.next=function(){var t=this.getCurNode();if(!t)return null;return(t=this.getNextNode_(t,this.validNode_))&&this.setCurNode(t),t},T.BasicCursor.prototype.in=function(){return this.next()},T.BasicCursor.prototype.prev=function(){var t=this.getCurNode();if(!t)return null;return(t=this.getPreviousNode_(t,this.validNode_))&&this.setCurNode(t),t},T.BasicCursor.prototype.out=function(){return this.prev()},T.BasicCursor.prototype.getNextNode_=function(t,e){if(!t)return null;var o=t.in()||t.next();if(e(o))return o;if(o)return this.getNextNode_(o,e);return e(t=this.findSiblingOrParent_(t.out()))?t:t?this.getNextNode_(t,e):null},T.BasicCursor.prototype.getPreviousNode_=function(t,e){if(!t)return null;var o=t.prev(),o;return e(o=o?this.getRightMostChild_(o):t.out())?o:o?this.getPreviousNode_(o,e):null},T.BasicCursor.prototype.validNode_=function(t){var e=!1;return e=(t=t&&t.getType())!=T.ASTNode.types.OUTPUT&&t!=T.ASTNode.types.INPUT&&t!=T.ASTNode.types.FIELD&&t!=T.ASTNode.types.NEXT&&t!=T.ASTNode.types.PREVIOUS&&t!=T.ASTNode.types.WORKSPACE?e:!0},T.BasicCursor.prototype.findSiblingOrParent_=function(t){if(!t)return null;var e=t.next();return e||this.findSiblingOrParent_(t.out())},T.BasicCursor.prototype.getRightMostChild_=function(t){if(!t.in())return t;for(t=t.in();t.next();)t=t.next();return this.getRightMostChild_(t)},T.registry.register(T.registry.Type.CURSOR,T.BasicCursor.registrationName,T.BasicCursor),T.TabNavigateCursor=function(){T.TabNavigateCursor.superClass_.constructor.call(this)},T.utils.object.inherits(T.TabNavigateCursor,T.BasicCursor),T.TabNavigateCursor.prototype.validNode_=function(t){var e=!1,o=t&&t.getType();return e=t&&(t=t.getLocation(),o==T.ASTNode.types.FIELD)&&t&&t.isTabNavigable()&&t.isClickable()?!0:e},T.BlockSvg=function(t,e,o){this.svgGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{},null),this.svgGroup_.translate_="",this.style=t.getRenderer().getConstants().getBlockStyle(null),this.pathObject=t.getRenderer().makePathObject(this.svgGroup_,this.style),this.renderIsInProgress_=this.rendered=!1,this.workspace=t,this.previousConnection=this.nextConnection=this.outputConnection=null,this.useDragSurface_=T.utils.is3dSupported()&&!!t.getBlockDragSurface();var i=this.pathObject.svgPath;i.tooltip=this,T.Tooltip.bindMouseEvents(i),T.BlockSvg.superClass_.constructor.call(this,t,e,o),this.svgGroup_.dataset?this.svgGroup_.dataset.id=this.id:T.utils.userAgent.IE&&this.svgGroup_.setAttribute("data-id",this.id)},T.utils.object.inherits(T.BlockSvg,T.Block),T.BlockSvg.prototype.height=0,T.BlockSvg.prototype.width=0,T.BlockSvg.prototype.warningTextDb_=null,T.BlockSvg.INLINE=-1,T.BlockSvg.COLLAPSED_WARNING_ID="TEMP_COLLAPSED_WARNING_",T.BlockSvg.prototype.initSvg=function(){if(!this.workspace.rendered)throw TypeError("Workspace is headless.");for(var t=0,e;e=this.inputList[t];t++)e.init();for(e=this.getIcons(),t=0;t<e.length;t++)e[t].createIcon();this.applyColour(),this.pathObject.updateMovable(this.isMovable()),t=this.getSvgRoot(),this.workspace.options.readOnly||this.eventsInit_||!t||T.browserEvents.conditionalBind(t,"mousedown",this,this.onMouseDown_),this.eventsInit_=!0,t.parentNode||this.workspace.getCanvas().appendChild(t)},T.BlockSvg.prototype.getColourSecondary=function(){return this.style.colourSecondary},T.BlockSvg.prototype.getColourTertiary=function(){return this.style.colourTertiary},T.BlockSvg.prototype.getColourShadow=function(){return T.utils.deprecation.warn("BlockSvg.prototype.getColourShadow","January 2020","January 2021","style.colourSecondary"),this.getColourSecondary()},T.BlockSvg.prototype.getColourBorder=function(){return T.utils.deprecation.warn("BlockSvg.prototype.getColourBorder","January 2020","January 2021","style.colourTertiary"),{colourBorder:this.getColourTertiary(),colourLight:null,colourDark:null}},T.BlockSvg.prototype.select=function(){if(this.isShadow()&&this.getParent())this.getParent().select();else if(T.selected!=this){var t=null;if(T.selected){t=T.selected.id,T.Events.disable();try{T.selected.unselect()}finally{T.Events.enable()}}t=new(T.Events.get(T.Events.SELECTED))(t,this.id,this.workspace.id),T.Events.fire(t),(T.selected=this).addSelect()}},T.BlockSvg.prototype.unselect=function(){var t;T.selected==this&&((t=new(T.Events.get(T.Events.SELECTED))(this.id,null,this.workspace.id)).workspaceId=this.workspace.id,T.Events.fire(t),T.selected=null,this.removeSelect())},T.BlockSvg.prototype.mutator=null,T.BlockSvg.prototype.comment=null,T.BlockSvg.prototype.commentIcon_=null,T.BlockSvg.prototype.warning=null,T.BlockSvg.prototype.getIcons=function(){var t=[];return this.mutator&&t.push(this.mutator),this.commentIcon_&&t.push(this.commentIcon_),this.warning&&t.push(this.warning),t},T.BlockSvg.prototype.setParent=function(t){var e=this.parentBlock_,o,i;t!=e&&(T.utils.dom.startTextWidthCache(),T.BlockSvg.superClass_.setParent.call(this,t),T.utils.dom.stopTextWidthCache(),o=this.getSvgRoot(),!this.workspace.isClearing)&&o&&(i=this.getRelativeToSurfaceXY(),t?(t.getSvgRoot().appendChild(o),t=this.getRelativeToSurfaceXY(),this.moveConnections(t.x-i.x,t.y-i.y)):e&&(this.workspace.getCanvas().appendChild(o),this.translate(i.x,i.y)),this.applyColour())},T.BlockSvg.prototype.getRelativeToSurfaceXY=function(){var t=0,e=0,o=this.useDragSurface_?this.workspace.getBlockDragSurface().getGroup():null,i=this.getSvgRoot();if(i)do{var s=T.utils.getRelativeXY(i);t+=s.x,e+=s.y,this.useDragSurface_&&this.workspace.getBlockDragSurface().getCurrentBlock()==i&&(t+=(s=this.workspace.getBlockDragSurface().getSurfaceTranslation()).x,e+=s.y),i=i.parentNode}while(i&&i!=this.workspace.getCanvas()&&i!=o);return new T.utils.Coordinate(t,e)},T.BlockSvg.prototype.moveBy=function(t,e){if(this.parentBlock_)throw Error("Block has parent.");var o=T.Events.isEnabled(),i,s=(o&&(i=new(T.Events.get(T.Events.BLOCK_MOVE))(this)),this.getRelativeToSurfaceXY());this.translate(s.x+t,s.y+e),this.moveConnections(t,e),o&&(i.recordNew(),T.Events.fire(i)),this.workspace.resizeContents()},T.BlockSvg.prototype.translate=function(t,e){this.getSvgRoot().setAttribute("transform","translate("+t+","+e+")")},T.BlockSvg.prototype.moveToDragSurface=function(){var t;this.useDragSurface_&&(t=this.getRelativeToSurfaceXY(),this.clearTransformAttributes_(),this.workspace.getBlockDragSurface().translateSurface(t.x,t.y),t=this.getSvgRoot())&&this.workspace.getBlockDragSurface().setBlocksAndShow(t)},T.BlockSvg.prototype.moveTo=function(t){var e=this.getRelativeToSurfaceXY();this.moveBy(t.x-e.x,t.y-e.y)},T.BlockSvg.prototype.moveOffDragSurface=function(t){this.useDragSurface_&&(this.translate(t.x,t.y),this.workspace.getBlockDragSurface().clearAndHide(this.workspace.getCanvas()))},T.BlockSvg.prototype.moveDuringDrag=function(t){this.useDragSurface_?this.workspace.getBlockDragSurface().translateSurface(t.x,t.y):(this.svgGroup_.translate_="translate("+t.x+","+t.y+")",this.svgGroup_.setAttribute("transform",this.svgGroup_.translate_+this.svgGroup_.skew_))},T.BlockSvg.prototype.clearTransformAttributes_=function(){this.getSvgRoot().removeAttribute("transform")},T.BlockSvg.prototype.snapToGrid=function(){var t,e,o,i,t,e;!this.workspace||this.workspace.isDragging()||this.getParent()||this.isInFlyout||(t=this.workspace.getGrid())&&t.shouldSnap()&&(o=(e=t.getSpacing())/2,i=this.getRelativeToSurfaceXY(),t=Math.round((i.x-o)/e)*e+o-i.x,e=Math.round((i.y-o)/e)*e+o-i.y,t=Math.round(t),e=Math.round(e),0==t&&0==e||this.moveBy(t,e))},T.BlockSvg.prototype.getBoundingRectangle=function(){var t=this.getRelativeToSurfaceXY(),e=this.getHeightWidth(),o,i,i=this.RTL?(o=t.x-e.width,t.x):(o=t.x,t.x+e.width);return new T.utils.Rect(t.y,t.y+e.height,o,i)},T.BlockSvg.prototype.markDirty=function(){this.pathObject.constants=this.workspace.getRenderer().getConstants();for(var t=0,e;e=this.inputList[t];t++)e.markDirty()},T.BlockSvg.prototype.setCollapsed=function(t){this.collapsed_!=t&&(T.BlockSvg.superClass_.setCollapsed.call(this,t),t?this.rendered&&this.render():this.updateCollapsed_())},T.BlockSvg.prototype.updateCollapsed_=function(){for(var t=this.isCollapsed(),e=T.constants.COLLAPSED_INPUT_NAME,o=T.constants.COLLAPSED_FIELD_NAME,i=0,s;s=this.inputList[i];i++)s.name!=e&&s.setVisible(!t);if(t){for(s=this.getIcons(),i=0;t=s[i];i++)t.setVisible(!1);i=this.toString(T.COLLAPSE_CHARS),(s=this.getField(o))?s.setValue(i):(s=this.getInput(e)||this.appendDummyInput(e)).appendField(new T.FieldLabel(i),o)}else this.updateDisabled(),this.removeInput(e)},T.BlockSvg.prototype.tab=function(t,e){var o=new T.TabNavigateCursor;o.setCurNode(T.ASTNode.createFieldNode(t)),t=o.getCurNode(),e?o.next():o.prev(),(e=o.getCurNode())&&e!==t&&(e.getLocation().showEditor(),this.workspace.keyboardAccessibilityMode)&&this.workspace.getCursor().setCurNode(e)},T.BlockSvg.prototype.onMouseDown_=function(t){var e=this.workspace&&this.workspace.getGesture(t);e&&e.handleBlockStart(t,this)},T.BlockSvg.prototype.showHelp=function(){var t="function"==typeof this.helpUrl?this.helpUrl():this.helpUrl;t&&window.open(t)},T.BlockSvg.prototype.generateContextMenu=function(){if(this.workspace.options.readOnly||!this.contextMenu)return null;var t=T.ContextMenuRegistry.registry.getContextMenuOptions(T.ContextMenuRegistry.ScopeType.BLOCK,{block:this});return this.customContextMenu&&this.customContextMenu(t),t},T.BlockSvg.prototype.showContextMenu=function(t){var e=this.generateContextMenu();e&&e.length&&(T.ContextMenu.show(t,e,this.RTL),T.ContextMenu.currentBlock=this)},T.BlockSvg.prototype.moveConnections=function(t,e){if(this.rendered){for(var o=this.getConnections_(!1),i=0;i<o.length;i++)o[i].moveBy(t,e);for(o=this.getIcons(),i=0;i<o.length;i++)o[i].computeIconLocation();for(i=0;i<this.childBlocks_.length;i++)this.childBlocks_[i].moveConnections(t,e)}},T.BlockSvg.prototype.setDragging=function(t){var e;for(t?((e=this.getSvgRoot()).translate_="",e.skew_="",T.draggingConnections=T.draggingConnections.concat(this.getConnections_(!0)),T.utils.dom.addClass(this.svgGroup_,"blocklyDragging")):(T.draggingConnections=[],T.utils.dom.removeClass(this.svgGroup_,"blocklyDragging")),e=0;e<this.childBlocks_.length;e++)this.childBlocks_[e].setDragging(t)},T.BlockSvg.prototype.setMovable=function(t){T.BlockSvg.superClass_.setMovable.call(this,t),this.pathObject.updateMovable(t)},T.BlockSvg.prototype.setEditable=function(t){T.BlockSvg.superClass_.setEditable.call(this,t),t=this.getIcons();for(var e=0;e<t.length;e++)t[e].updateEditable()},T.BlockSvg.prototype.setShadow=function(t){T.BlockSvg.superClass_.setShadow.call(this,t),this.applyColour()},T.BlockSvg.prototype.setInsertionMarker=function(t){this.isInsertionMarker_!=t&&(this.isInsertionMarker_=t)&&(this.setColour(this.workspace.getRenderer().getConstants().INSERTION_MARKER_COLOUR),this.pathObject.updateInsertionMarker(!0))},T.BlockSvg.prototype.getSvgRoot=function(){return this.svgGroup_},T.BlockSvg.prototype.dispose=function(t,e){if(this.workspace){T.Tooltip.dispose(),T.Tooltip.unbindMouseEvents(this.pathObject.svgPath),T.utils.dom.startTextWidthCache();var o=this.workspace;if(T.selected==this&&(this.unselect(),this.workspace.cancelCurrentGesture()),T.ContextMenu.currentBlock==this&&T.ContextMenu.hide(),e&&this.rendered&&(this.unplug(t),T.blockAnimations.disposeUiEffect(this)),this.rendered=!1,this.warningTextDb_){for(var i in this.warningTextDb_)clearTimeout(this.warningTextDb_[i]);this.warningTextDb_=null}for(e=this.getIcons(),i=0;i<e.length;i++)e[i].dispose();T.BlockSvg.superClass_.dispose.call(this,!!t),T.utils.dom.removeNode(this.svgGroup_),o.resizeContents(),this.svgGroup_=null,T.utils.dom.stopTextWidthCache()}},T.BlockSvg.prototype.toCopyData=function(){if(this.isInsertionMarker_)return null;var t=T.Xml.blockToDom(this,!0),e=(T.Xml.deleteNext(t),this.getRelativeToSurfaceXY());return t.setAttribute("x",this.RTL?-e.x:e.x),t.setAttribute("y",e.y),{xml:t,source:this.workspace,typeCounts:T.utils.getBlockTypeCounts(this,!0)}},T.BlockSvg.prototype.applyColour=function(){this.pathObject.applyColour(this);for(var t=this.getIcons(),e=0;e<t.length;e++)t[e].applyColour();for(t=0;e=this.inputList[t];t++)for(var o=0,i;i=e.fieldRow[o];o++)i.applyColour()},T.BlockSvg.prototype.updateDisabled=function(){var t=this.getChildren(!1);if(this.applyColour(),!this.isCollapsed())for(var e=0,o;o=t[e];e++)o.rendered&&o.updateDisabled()},T.BlockSvg.prototype.getCommentIcon=function(){return this.commentIcon_},T.BlockSvg.prototype.setCommentText=function(t){if(!T.Comment)throw Error("Missing require for Blockly.Comment");this.commentModel.text!=t&&(T.BlockSvg.superClass_.setCommentText.call(this,t),!!this.commentIcon_==(t=null!=t)?this.commentIcon_.updateText():(t?this.comment=this.commentIcon_=new T.Comment(this):(this.commentIcon_.dispose(),this.comment=this.commentIcon_=null),this.rendered&&(this.render(),this.bumpNeighbours())))},T.BlockSvg.prototype.setWarningText=function(t,e){if(!T.Warning)throw Error("Missing require for Blockly.Warning");this.warningTextDb_||(this.warningTextDb_=Object.create(null));var o=e||"";if(o)this.warningTextDb_[o]&&(clearTimeout(this.warningTextDb_[o]),delete this.warningTextDb_[o]);else for(var i in this.warningTextDb_)clearTimeout(this.warningTextDb_[i]),delete this.warningTextDb_[i];if(this.workspace.isDragging()){var s=this;this.warningTextDb_[o]=setTimeout(function(){s.workspace&&(delete s.warningTextDb_[o],s.setWarningText(t,o))},100)}else{if(e=!1,"string"==typeof(t=this.isInFlyout?null:t)){for(var i=this.getSurroundParent(),n=null;i;)i.isCollapsed()&&(n=i),i=i.getSurroundParent();n&&n.setWarningText(T.Msg.COLLAPSED_WARNINGS_WARNING,T.BlockSvg.COLLAPSED_WARNING_ID),this.warning||(this.warning=new T.Warning(this),e=!0),this.warning.setText(t,o)}else this.warning&&!o?(this.warning.dispose(),e=!0):this.warning&&(e=this.warning.getText(),this.warning.setText("",o),(i=this.warning.getText())||this.warning.dispose(),e=e!=i);e&&this.rendered&&(this.render(),this.bumpNeighbours())}},T.BlockSvg.prototype.setMutator=function(t){this.mutator&&this.mutator!==t&&this.mutator.dispose(),t&&(t.setBlock(this),(this.mutator=t).createIcon()),this.rendered&&(this.render(),this.bumpNeighbours())},T.BlockSvg.prototype.setEnabled=function(t){this.isEnabled()!=t&&(T.BlockSvg.superClass_.setEnabled.call(this,t),this.rendered)&&!this.getInheritedDisabled()&&this.updateDisabled()},T.BlockSvg.prototype.setHighlighted=function(t){this.rendered&&this.pathObject.updateHighlighted(t)},T.BlockSvg.prototype.addSelect=function(){this.pathObject.updateSelected(!0)},T.BlockSvg.prototype.removeSelect=function(){this.pathObject.updateSelected(!1)},T.BlockSvg.prototype.setDeleteStyle=function(t){this.pathObject.updateDraggingDelete(t)},T.BlockSvg.prototype.getColour=function(){return this.style.colourPrimary},T.BlockSvg.prototype.setColour=function(t){T.BlockSvg.superClass_.setColour.call(this,t),t=this.workspace.getRenderer().getConstants().getBlockStyleForColour(this.colour_),this.pathObject.setStyle(t.style),this.style=t.style,this.styleName_=t.name,this.applyColour()},T.BlockSvg.prototype.setStyle=function(t){var e=this.workspace.getRenderer().getConstants().getBlockStyle(t);if(this.styleName_=t,!e)throw Error("Invalid style name: "+t);this.hat=e.hat,this.pathObject.setStyle(e),this.colour_=e.colourPrimary,this.style=e,this.applyColour()},T.BlockSvg.prototype.bringToFront=function(){var t=this;do{var e=t.getSvgRoot(),o=e.parentNode,i=o.childNodes;i[i.length-1]!==e&&o.appendChild(e),t=t.getParent()}while(t)},T.BlockSvg.prototype.setPreviousStatement=function(t,e){T.BlockSvg.superClass_.setPreviousStatement.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours())},T.BlockSvg.prototype.setNextStatement=function(t,e){T.BlockSvg.superClass_.setNextStatement.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours())},T.BlockSvg.prototype.setOutput=function(t,e){T.BlockSvg.superClass_.setOutput.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours())},T.BlockSvg.prototype.setInputsInline=function(t){T.BlockSvg.superClass_.setInputsInline.call(this,t),this.rendered&&(this.render(),this.bumpNeighbours())},T.BlockSvg.prototype.removeInput=function(t,e){return t=T.BlockSvg.superClass_.removeInput.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours()),t},T.BlockSvg.prototype.moveNumberedInputBefore=function(t,e){T.BlockSvg.superClass_.moveNumberedInputBefore.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours())},T.BlockSvg.prototype.appendInput_=function(t,e){return t=T.BlockSvg.superClass_.appendInput_.call(this,t,e),this.rendered&&(this.render(),this.bumpNeighbours()),t},T.BlockSvg.prototype.setConnectionTracking=function(t){var e;if(this.previousConnection&&this.previousConnection.setTracking(t),this.outputConnection&&this.outputConnection.setTracking(t),this.nextConnection&&(this.nextConnection.setTracking(t),e=this.nextConnection.targetBlock())&&e.setConnectionTracking(t),!this.collapsed_)for(e=0;e<this.inputList.length;e++){var o=this.inputList[e].connection;o&&(o.setTracking(t),o=o.targetBlock())&&o.setConnectionTracking(t)}},T.BlockSvg.prototype.getConnections_=function(t){var e=[],o;if((t||this.rendered)&&(this.outputConnection&&e.push(this.outputConnection),this.previousConnection&&e.push(this.previousConnection),this.nextConnection&&e.push(this.nextConnection),t||!this.collapsed_)){t=0;for(;o=this.inputList[t];t++)o.connection&&e.push(o.connection)}return e},T.BlockSvg.prototype.lastConnectionInStack=function(){return T.BlockSvg.superClass_.lastConnectionInStack.call(this)},T.BlockSvg.prototype.getMatchingConnection=function(t,e){return T.BlockSvg.superClass_.getMatchingConnection.call(this,t,e)},T.BlockSvg.prototype.makeConnection_=function(t){return new T.RenderedConnection(this,t)},T.BlockSvg.prototype.bumpNeighbours=function(){if(this.workspace&&!this.workspace.isDragging()){var t=this.getRootBlock();if(!t.isInFlyout)for(var e=this.getConnections_(!1),o=0,i;i=e[o];o++){i.isConnected()&&i.isSuperior()&&i.targetBlock().bumpNeighbours();for(var s=i.neighbours(T.SNAP_RADIUS),n=0,r;r=s[n];n++)i.isConnected()&&r.isConnected()||r.getSourceBlock().getRootBlock()!=t&&(i.isSuperior()?r.bumpAwayFrom(i):i.bumpAwayFrom(r))}}},T.BlockSvg.prototype.scheduleSnapAndBump=function(){var t=this,e=T.Events.getGroup();setTimeout(function(){T.Events.setGroup(e),t.snapToGrid(),T.Events.setGroup(!1)},T.BUMP_DELAY/2),setTimeout(function(){T.Events.setGroup(e),t.bumpNeighbours(),T.Events.setGroup(!1)},T.BUMP_DELAY)},T.BlockSvg.prototype.positionNearConnection=function(t,e){t.type!=T.connectionTypes.NEXT_STATEMENT&&t.type!=T.connectionTypes.INPUT_VALUE||this.moveBy(e.x-t.x,e.y-t.y)},T.BlockSvg.prototype.getParent=function(){return T.BlockSvg.superClass_.getParent.call(this)},T.BlockSvg.prototype.getRootBlock=function(){return T.BlockSvg.superClass_.getRootBlock.call(this)},T.BlockSvg.prototype.render=function(t){if(!this.renderIsInProgress_){this.renderIsInProgress_=!0;try{var e;this.rendered=!0,T.utils.dom.startTextWidthCache(),this.isCollapsed()&&this.updateCollapsed_(),this.workspace.getRenderer().render(this),this.updateConnectionLocations_(),!1!==t&&((e=this.getParent())?e.render(!0):this.workspace.resizeContents()),T.utils.dom.stopTextWidthCache(),this.updateMarkers_()}finally{this.renderIsInProgress_=!1}}},T.BlockSvg.prototype.updateMarkers_=function(){this.workspace.keyboardAccessibilityMode&&this.pathObject.cursorSvg&&this.workspace.getCursor().draw(),this.workspace.keyboardAccessibilityMode&&this.pathObject.markerSvg&&this.workspace.getMarker(T.MarkerManager.LOCAL_MARKER).draw()},T.BlockSvg.prototype.updateConnectionLocations_=function(){var t=this.getRelativeToSurfaceXY();this.previousConnection&&this.previousConnection.moveToOffset(t),this.outputConnection&&this.outputConnection.moveToOffset(t);for(var e=0;e<this.inputList.length;e++){var o=this.inputList[e].connection;o&&(o.moveToOffset(t),o.isConnected())&&o.tighten()}this.nextConnection&&(this.nextConnection.moveToOffset(t),this.nextConnection.isConnected())&&this.nextConnection.tighten()},T.BlockSvg.prototype.setCursorSvg=function(t){this.pathObject.setCursorSvg(t)},T.BlockSvg.prototype.setMarkerSvg=function(t){this.pathObject.setMarkerSvg(t)},T.BlockSvg.prototype.getHeightWidth=function(){var t=this.height,e=this.width,o=this.getNextBlock(),o,i;return o&&(o=o.getHeightWidth(),i=this.workspace.getRenderer().getConstants().NOTCH_HEIGHT,t+=o.height-i,e=Math.max(e,o.width)),{height:t,width:e}},T.BlockSvg.prototype.fadeForReplacement=function(t){this.pathObject.updateReplacementFade(t)},T.BlockSvg.prototype.highlightShapeForInput=function(t,e){this.pathObject.updateShapeForInputHighlight(t,e)},T.ConnectionDB=function(t){this.connections_=[],this.connectionChecker_=t},T.ConnectionDB.prototype.addConnection=function(t,e){e=this.calculateIndexForYPos_(e),this.connections_.splice(e,0,t)},T.ConnectionDB.prototype.findIndexOfConnection_=function(t,e){if(!this.connections_.length)return-1;var o=this.calculateIndexForYPos_(e);if(o>=this.connections_.length)return-1;e=t.y;for(var i=o;0<=i&&this.connections_[i].y==e;){if(this.connections_[i]==t)return i;i--}for(;o<this.connections_.length&&this.connections_[o].y==e;){if(this.connections_[o]==t)return o;o++}return-1},T.ConnectionDB.prototype.calculateIndexForYPos_=function(t){if(!this.connections_.length)return 0;for(var e=0,o=this.connections_.length;e<o;){var i=Math.floor((e+o)/2);if(this.connections_[i].y<t)e=i+1;else{if(!(this.connections_[i].y>t)){e=i;break}o=i}}return e},T.ConnectionDB.prototype.removeConnection=function(t,e){if(-1==(t=this.findIndexOfConnection_(t,e)))throw Error("Unable to find connection in connectionDB.");this.connections_.splice(t,1)},T.ConnectionDB.prototype.getNeighbours=function(t,i){function e(t){var e=n-s[t].x,o=r-s[t].y;return Math.sqrt(e*e+o*o)<=i&&a.push(s[t]),o<i}var s=this.connections_,n=t.x,r=t.y;t=0;for(var o,l=o=s.length-2;t<l;)s[l].y<r?t=l:o=l,l=Math.floor((t+o)/2);var a=[],o=t=l;if(s.length){for(;0<=t&&e(t);)t--;do{o++}while(o<s.length&&e(o))}return a},T.ConnectionDB.prototype.isInYRange_=function(t,e,o){return Math.abs(this.connections_[t].y-e)<=o},T.ConnectionDB.prototype.searchForClosest=function(t,e,o){if(!this.connections_.length)return{connection:null,radius:e};var i=t.y,s=t.x,n=(t.x=s+o.x,t.y=i+o.y,this.calculateIndexForYPos_(t.y));o=null;for(var r=e,l,a=n-1;0<=a&&this.isInYRange_(a,t.y,e);)l=this.connections_[a],this.connectionChecker_.canConnect(t,l,!0,r)&&(r=(o=l).distanceFrom(t)),a--;for(;n<this.connections_.length&&this.isInYRange_(n,t.y,e);)l=this.connections_[n],this.connectionChecker_.canConnect(t,l,!0,r)&&(r=(o=l).distanceFrom(t)),n++;return t.x=s,t.y=i,{connection:o,radius:r}},T.ConnectionDB.init=function(t){var e=[];return e[T.connectionTypes.INPUT_VALUE]=new T.ConnectionDB(t),e[T.connectionTypes.OUTPUT_VALUE]=new T.ConnectionDB(t),e[T.connectionTypes.NEXT_STATEMENT]=new T.ConnectionDB(t),e[T.connectionTypes.PREVIOUS_STATEMENT]=new T.ConnectionDB(t),e},T.Events.ThemeChange=function(t,e){T.Events.ThemeChange.superClass_.constructor.call(this,e),this.themeName=t},T.utils.object.inherits(T.Events.ThemeChange,T.Events.UiBase),T.Events.ThemeChange.prototype.type=T.Events.THEME_CHANGE,T.Events.ThemeChange.prototype.toJson=function(){var t=T.Events.ThemeChange.superClass_.toJson.call(this);return t.themeName=this.themeName,t},T.Events.ThemeChange.prototype.fromJson=function(t){T.Events.ThemeChange.superClass_.fromJson.call(this,t),this.themeName=t.themeName},T.registry.register(T.registry.Type.EVENT,T.Events.THEME_CHANGE,T.Events.ThemeChange),T.Events.ViewportChange=function(t,e,o,i,s){T.Events.ViewportChange.superClass_.constructor.call(this,i),this.viewTop=t,this.viewLeft=e,this.scale=o,this.oldScale=s},T.utils.object.inherits(T.Events.ViewportChange,T.Events.UiBase),T.Events.ViewportChange.prototype.type=T.Events.VIEWPORT_CHANGE,T.Events.ViewportChange.prototype.toJson=function(){var t=T.Events.ViewportChange.superClass_.toJson.call(this);return t.viewTop=this.viewTop,t.viewLeft=this.viewLeft,t.scale=this.scale,t.oldScale=this.oldScale,t},T.Events.ViewportChange.prototype.fromJson=function(t){T.Events.ViewportChange.superClass_.fromJson.call(this,t),this.viewTop=t.viewTop,this.viewLeft=t.viewLeft,this.scale=t.scale,this.oldScale=t.oldScale},T.registry.register(T.registry.Type.EVENT,T.Events.VIEWPORT_CHANGE,T.Events.ViewportChange),T.MarkerManager=function(t){this.cursorSvg_=this.cursor_=null,this.markers_={},this.workspace_=t},T.MarkerManager.LOCAL_MARKER="local_marker_1",T.MarkerManager.prototype.registerMarker=function(t,e){this.markers_[t]&&this.unregisterMarker(t),e.setDrawer(this.workspace_.getRenderer().makeMarkerDrawer(this.workspace_,e)),this.setMarkerSvg(e.getDrawer().createDom()),this.markers_[t]=e},T.MarkerManager.prototype.unregisterMarker=function(t){var e=this.markers_[t];if(!e)throw Error("Marker with id "+t+" does not exist. Can only unregistermarkers that exist.");e.dispose(),delete this.markers_[t]},T.MarkerManager.prototype.getCursor=function(){return this.cursor_},T.MarkerManager.prototype.getMarker=function(t){return this.markers_[t]},T.MarkerManager.prototype.setCursor=function(t){this.cursor_&&this.cursor_.getDrawer()&&this.cursor_.getDrawer().dispose(),(this.cursor_=t)&&(t=this.workspace_.getRenderer().makeMarkerDrawer(this.workspace_,this.cursor_),this.cursor_.setDrawer(t),this.setCursorSvg(this.cursor_.getDrawer().createDom()))},T.MarkerManager.prototype.setCursorSvg=function(t){t?(this.workspace_.getBlockCanvas().appendChild(t),this.cursorSvg_=t):this.cursorSvg_=null},T.MarkerManager.prototype.setMarkerSvg=function(t){t?this.workspace_.getBlockCanvas()&&(this.cursorSvg_?this.workspace_.getBlockCanvas().insertBefore(t,this.cursorSvg_):this.workspace_.getBlockCanvas().appendChild(t)):this.markerSvg_=null},T.MarkerManager.prototype.updateMarkers=function(){this.workspace_.keyboardAccessibilityMode&&this.cursorSvg_&&this.workspace_.getCursor().draw()},T.MarkerManager.prototype.dispose=function(){for(var t=Object.keys(this.markers_),e=0,o;o=t[e];e++)this.unregisterMarker(o);this.markers_=null,this.cursor_&&(this.cursor_.dispose(),this.cursor_=null)},T.IMetricsManager=function(){},T.MetricsManager=function(t){this.workspace_=t},T.MetricsManager.prototype.getDimensionsPx_=function(t){var e=0,o=0;return t&&(e=t.getWidth(),o=t.getHeight()),new T.utils.Size(e,o)},T.MetricsManager.prototype.getFlyoutMetrics=function(t){return{width:(t=this.getDimensionsPx_(this.workspace_.getFlyout(t))).width,height:t.height,position:this.workspace_.toolboxPosition}},T.MetricsManager.prototype.getToolboxMetrics=function(){var t=this.getDimensionsPx_(this.workspace_.getToolbox());return{width:t.width,height:t.height,position:this.workspace_.toolboxPosition}},T.MetricsManager.prototype.getSvgMetrics=function(){return this.workspace_.getCachedParentSvgSize()},T.MetricsManager.prototype.getAbsoluteMetrics=function(){var t=0,e=this.getToolboxMetrics(),o=this.getFlyoutMetrics(!0),i=!!this.workspace_.getToolbox(),s=!!this.workspace_.getFlyout(!0),n,r=(n=(i?e:o).position)==T.utils.toolbox.Position.LEFT,n=n==T.utils.toolbox.Position.TOP;return i&&r?t=e.width:s&&r&&(t=o.width),r=0,i&&n?r=e.height:s&&n&&(r=o.height),{top:r,left:t}},T.MetricsManager.prototype.getViewMetrics=function(t){t=t?this.workspace_.scale:1;var e=this.getSvgMetrics(),o=this.getToolboxMetrics(),i=this.getFlyoutMetrics(!0),s=(this.workspace_.getToolbox()?o:i).position;return this.workspace_.getToolbox()?s==T.utils.toolbox.Position.TOP||s==T.utils.toolbox.Position.BOTTOM?e.height-=o.height:s!=T.utils.toolbox.Position.LEFT&&s!=T.utils.toolbox.Position.RIGHT||(e.width-=o.width):this.workspace_.getFlyout(!0)&&(s==T.utils.toolbox.Position.TOP||s==T.utils.toolbox.Position.BOTTOM?e.height-=i.height:s!=T.utils.toolbox.Position.LEFT&&s!=T.utils.toolbox.Position.RIGHT||(e.width-=i.width)),{height:e.height/t,width:e.width/t,top:-this.workspace_.scrollY/t,left:-this.workspace_.scrollX/t}},T.MetricsManager.prototype.getContentMetrics=function(t){t=t?1:this.workspace_.scale;var e=this.workspace_.getBlocksBoundingBox();return{height:(e.bottom-e.top)*t,width:(e.right-e.left)*t,top:e.top*t,left:e.left*t}},T.MetricsManager.prototype.hasFixedEdges=function(){return!this.workspace_.isMovableHorizontally()||!this.workspace_.isMovableVertically()},T.MetricsManager.prototype.getComputedFixedEdges_=function(t){if(!this.hasFixedEdges())return{};var e=this.workspace_.isMovableHorizontally(),o=this.workspace_.isMovableVertically(),i=(t=t||this.getViewMetrics(!1),{});return o||(i.top=t.top,i.bottom=t.top+t.height),e||(i.left=t.left,i.right=t.left+t.width),i},T.MetricsManager.prototype.getPaddedContent_=function(t,e){var o=e.top+e.height,i=e.left+e.width,s=t.width,n=s/2,r=(t=t.height)/2;return{top:Math.min(e.top-r,o-t),bottom:Math.max(o+r,e.top+t),left:Math.min(e.left-n,i-s),right:Math.max(i+n,e.left+s)}},T.MetricsManager.prototype.getScrollMetrics=function(t,e,o){t=t?this.workspace_.scale:1,e=e||this.getViewMetrics(!1);var i=o||this.getContentMetrics(),s=(o=this.getComputedFixedEdges_(e),e=this.getPaddedContent_(e,i),i=(void 0!==o.top?o:e).top,(void 0!==o.left?o:e).left);return{top:i/t,left:s/t,width:((void 0!==o.right?o:e).right-s)/t,height:((void 0!==o.bottom?o:e).bottom-i)/t}},T.MetricsManager.prototype.getUiMetrics=function(){return{viewMetrics:this.getViewMetrics(),absoluteMetrics:this.getAbsoluteMetrics(),toolboxMetrics:this.getToolboxMetrics()}},T.MetricsManager.prototype.getMetrics=function(){var t=this.getToolboxMetrics(),e=this.getFlyoutMetrics(!0),o=this.getSvgMetrics(),i=this.getAbsoluteMetrics(),s=this.getViewMetrics(),n=this.getContentMetrics(),r=this.getScrollMetrics(!1,s,n);return{contentHeight:n.height,contentWidth:n.width,contentTop:n.top,contentLeft:n.left,scrollHeight:r.height,scrollWidth:r.width,scrollTop:r.top,scrollLeft:r.left,viewHeight:s.height,viewWidth:s.width,viewTop:s.top,viewLeft:s.left,absoluteTop:i.top,absoluteLeft:i.left,svgHeight:o.height,svgWidth:o.width,toolboxWidth:t.width,toolboxHeight:t.height,toolboxPosition:t.position,flyoutWidth:e.width,flyoutHeight:e.height}},T.registry.register(T.registry.Type.METRICS_MANAGER,T.registry.DEFAULT,T.MetricsManager),T.FlyoutMetricsManager=function(t,e){this.flyout_=e,T.FlyoutMetricsManager.superClass_.constructor.call(this,t)},T.utils.object.inherits(T.FlyoutMetricsManager,T.MetricsManager),T.FlyoutMetricsManager.prototype.getBoundingBox_=function(){try{var e=this.workspace_.getCanvas().getBBox()}catch(t){e={height:0,y:0,width:0,x:0}}return e},T.FlyoutMetricsManager.prototype.getContentMetrics=function(t){var e=this.getBoundingBox_();return t=t?1:this.workspace_.scale,{height:e.height*t,width:e.width*t,top:e.y*t,left:e.x*t}},T.FlyoutMetricsManager.prototype.getScrollMetrics=function(t,e,o){return e=o||this.getContentMetrics(),o=this.flyout_.MARGIN*this.workspace_.scale,t=t?this.workspace_.scale:1,{height:(e.height+2*o)/t,width:(e.width+e.left+o)/t,top:0,left:0}},T.FlyoutMetricsManager.prototype.getViewMetrics=function(t){var e=this.getSvgMetrics(),o,e;return t=t?this.workspace_.scale:1,{height:(e=this.flyout_.horizontalLayout?(o=e.width-2*this.flyout_.SCROLLBAR_PADDING,e.height-this.flyout_.SCROLLBAR_PADDING):(o=e.width-this.flyout_.SCROLLBAR_PADDING,e.height-2*this.flyout_.SCROLLBAR_PADDING))/t,width:o/t,top:-this.workspace_.scrollY/t,left:-this.workspace_.scrollX/t}},T.FlyoutMetricsManager.prototype.getAbsoluteMetrics=function(){var t=this.flyout_.SCROLLBAR_PADDING;return this.flyout_.horizontalLayout?{top:0,left:t}:{top:t,left:0}},T.PluginManager=function(){this.pluginData_={},this.typeToPluginIds_={}},T.PluginManager.prototype.addPlugin=function(t){this.pluginData_[t.id]=t;for(var e=0,o;o=t.types[e];e++)o=String(o).toLowerCase(),void 0===this.typeToPluginIds_[o]?this.typeToPluginIds_[o]=[t.id]:this.typeToPluginIds_[o].push(t.id)},T.PluginManager.prototype.getPlugin=function(t){return this.pluginData_[t]&&this.pluginData_[t].plugin},T.PluginManager.prototype.getPlugins=function(t,e){if(t=String(t).toLowerCase(),!(t=this.typeToPluginIds_[t]))return[];var o=[],i,s;return e?(i=[],s=this.pluginData_,t.forEach(function(t){i.push(s[t])}),i.sort(function(t,e){return t.weight-e.weight}),i.forEach(function(t){o.push(t.plugin)})):(s=this.pluginData_,t.forEach(function(t){o.push(s[t].plugin)})),o},T.PluginManager.Type=function(t){this.name_=t},T.PluginManager.Type.prototype.toString=function(){return this.name_},T.PluginManager.Type.POSITIONABLE=new T.PluginManager.Type("positionable"),T.ThemeManager=function(t,e){this.workspace_=t,this.theme_=e,this.subscribedWorkspaces_=[],this.componentDB_=Object.create(null)},T.ThemeManager.prototype.getTheme=function(){return this.theme_},T.ThemeManager.prototype.setTheme=function(t){var e=this.theme_,o;for(this.theme_=t,(t=this.workspace_.getInjectionDiv())&&(e&&T.utils.dom.removeClass(t,e.getClassName()),T.utils.dom.addClass(t,this.theme_.getClassName())),e=0;t=this.subscribedWorkspaces_[e];e++)t.refreshTheme();for(e=0,t=Object.keys(this.componentDB_);o=t[e];e++)for(var i=0,s;s=this.componentDB_[o][i];i++){var n=s.element,s=s.propertyName,r=this.theme_&&this.theme_.getComponentStyle(o);n.style[s]=r||""}T.hideChaff()},T.ThemeManager.prototype.subscribeWorkspace=function(t){this.subscribedWorkspaces_.push(t)},T.ThemeManager.prototype.unsubscribeWorkspace=function(t){if((t=this.subscribedWorkspaces_.indexOf(t))<0)throw Error("Cannot unsubscribe a workspace that hasn't been subscribed.");this.subscribedWorkspaces_.splice(t,1)},T.ThemeManager.prototype.subscribe=function(t,e,o){this.componentDB_[e]||(this.componentDB_[e]=[]),this.componentDB_[e].push({element:t,propertyName:o}),e=this.theme_&&this.theme_.getComponentStyle(e),t.style[o]=e||""},T.ThemeManager.prototype.unsubscribe=function(t){if(t)for(var e=Object.keys(this.componentDB_),o=0,i;i=e[o];o++){for(var s=this.componentDB_[i],n=s.length-1;0<=n;n--)s[n].element===t&&s.splice(n,1);this.componentDB_[i].length||delete this.componentDB_[i]}},T.ThemeManager.prototype.dispose=function(){this.componentDB_=this.subscribedWorkspaces_=this.theme_=this.owner_=null},T.TouchGesture=function(t,e){T.TouchGesture.superClass_.constructor.call(this,t,e),this.isMultiTouch_=!1,this.cachedPoints_=Object.create(null),this.startDistance_=this.previousScale_=0,this.isPinchZoomEnabled_=this.onStartWrapper_=null},T.utils.object.inherits(T.TouchGesture,T.Gesture),T.TouchGesture.ZOOM_IN_MULTIPLIER=5,T.TouchGesture.ZOOM_OUT_MULTIPLIER=6,T.TouchGesture.prototype.doStart=function(t){this.isPinchZoomEnabled_=this.startWorkspace_.options.zoomOptions&&this.startWorkspace_.options.zoomOptions.pinch,T.TouchGesture.superClass_.doStart.call(this,t),!this.isEnding_&&T.Touch.isTouchEvent(t)&&this.handleTouchStart(t)},T.TouchGesture.prototype.bindMouseEvents=function(t){this.onStartWrapper_=T.browserEvents.conditionalBind(document,"mousedown",null,this.handleStart.bind(this),!0),this.onMoveWrapper_=T.browserEvents.conditionalBind(document,"mousemove",null,this.handleMove.bind(this),!0),this.onUpWrapper_=T.browserEvents.conditionalBind(document,"mouseup",null,this.handleUp.bind(this),!0),t.preventDefault(),t.stopPropagation()},T.TouchGesture.prototype.handleStart=function(t){!this.isDragging()&&T.Touch.isTouchEvent(t)&&(this.handleTouchStart(t),this.isMultiTouch())&&T.longStop_()},T.TouchGesture.prototype.handleMove=function(t){this.isDragging()?T.Touch.shouldHandleEvent(t)&&T.TouchGesture.superClass_.handleMove.call(this,t):this.isMultiTouch()?(T.Touch.isTouchEvent(t)&&this.handleTouchMove(t),T.longStop_()):T.TouchGesture.superClass_.handleMove.call(this,t)},T.TouchGesture.prototype.handleUp=function(t){T.Touch.isTouchEvent(t)&&!this.isDragging()&&this.handleTouchEnd(t),!this.isMultiTouch()||this.isDragging()?T.Touch.shouldHandleEvent(t)&&T.TouchGesture.superClass_.handleUp.call(this,t):(t.preventDefault(),t.stopPropagation(),this.dispose())},T.TouchGesture.prototype.isMultiTouch=function(){return this.isMultiTouch_},T.TouchGesture.prototype.dispose=function(){T.TouchGesture.superClass_.dispose.call(this),this.onStartWrapper_&&T.browserEvents.unbind(this.onStartWrapper_)},T.TouchGesture.prototype.handleTouchStart=function(t){var e=T.Touch.getTouchIdentifierFromEvent(t);this.cachedPoints_[e]=this.getTouchPoint(t),2==(e=Object.keys(this.cachedPoints_)).length&&(this.startDistance_=T.utils.Coordinate.distance(this.cachedPoints_[e[0]],this.cachedPoints_[e[1]]),this.isMultiTouch_=!0,t.preventDefault())},T.TouchGesture.prototype.handleTouchMove=function(t){var e=T.Touch.getTouchIdentifierFromEvent(t);this.cachedPoints_[e]=this.getTouchPoint(t),e=Object.keys(this.cachedPoints_),this.isPinchZoomEnabled_&&2===e.length?this.handlePinch_(t):T.TouchGesture.superClass_.handleMove.call(this,t)},T.TouchGesture.prototype.handlePinch_=function(t){var e=Object.keys(this.cachedPoints_),o,o,i,s,e=T.utils.Coordinate.distance(this.cachedPoints_[e[0]],this.cachedPoints_[e[1]])/this.startDistance_;0<this.previousScale_&&1/0>this.previousScale_&&(o=0<(o=e-this.previousScale_)?o*T.TouchGesture.ZOOM_IN_MULTIPLIER:o*T.TouchGesture.ZOOM_OUT_MULTIPLIER,i=this.startWorkspace_,s=T.utils.mouseToSvg(t,i.getParentSvg(),i.getInverseScreenCTM()),i.zoom(s.x,s.y,o)),this.previousScale_=e,t.preventDefault()},T.TouchGesture.prototype.handleTouchEnd=function(t){t=T.Touch.getTouchIdentifierFromEvent(t),this.cachedPoints_[t]&&delete this.cachedPoints_[t],Object.keys(this.cachedPoints_).length<2&&(this.cachedPoints_=Object.create(null),this.previousScale_=0)},T.TouchGesture.prototype.getTouchPoint=function(t){return this.startWorkspace_?new T.utils.Coordinate(t.pageX||t.changedTouches[0].pageX,t.pageY||t.changedTouches[0].pageY):null},T.WorkspaceAudio=function(t){this.parentWorkspace_=t,this.SOUNDS_=Object.create(null)},T.WorkspaceAudio.prototype.lastSound_=null,T.WorkspaceAudio.prototype.dispose=function(){this.SOUNDS_=this.parentWorkspace_=null},T.WorkspaceAudio.prototype.load=function(t,e){if(t.length){try{var o=new T.utils.global.Audio}catch(t){return}for(var i,s=0;s<t.length;s++){var n=t[s],r=n.match(/\.(\w+)$/);if(r&&o.canPlayType("audio/"+r[1])){i=new T.utils.global.Audio(n);break}}i&&i.play&&(this.SOUNDS_[e]=i)}},T.WorkspaceAudio.prototype.preload=function(){for(var t in this.SOUNDS_){var e=this.SOUNDS_[t],o=(e.volume=.01,e.play());if(void 0!==o?o.then(e.pause).catch(function(){}):e.pause(),T.utils.userAgent.IPAD||T.utils.userAgent.IPHONE)break}},T.WorkspaceAudio.prototype.play=function(t,e){var o=this.SOUNDS_[t];o?(t=new Date,null!=this.lastSound_&&t-this.lastSound_<T.SOUND_LIMIT||(this.lastSound_=t,(o=T.utils.userAgent.IPAD||T.utils.userAgent.ANDROID?o:o.cloneNode()).volume=void 0===e?1:e,o.play())):this.parentWorkspace_&&this.parentWorkspace_.getAudioManager().play(t,e)},T.WorkspaceSvg=function(t,e,o){T.WorkspaceSvg.superClass_.constructor.call(this,t),this.metricsManager_=new(T.registry.getClassFromOptions(T.registry.Type.METRICS_MANAGER,t,!0))(this),this.getMetrics=t.getMetrics||this.metricsManager_.getMetrics.bind(this.metricsManager_),this.setMetrics=t.setMetrics||T.WorkspaceSvg.setTopLevelWorkspaceMetrics_,this.pluginManager_=new T.PluginManager,this.connectionDBList=T.ConnectionDB.init(this.connectionChecker),e&&(this.blockDragSurface_=e),o&&(this.workspaceDragSurface_=o),this.useWorkspaceDragSurface_=!!this.workspaceDragSurface_&&T.utils.is3dSupported(),this.highlightedBlocks_=[],this.audioManager_=new T.WorkspaceAudio(t.parentWorkspace),this.grid_=this.options.gridPattern?new T.Grid(this.options.gridPattern,t.gridOptions):null,this.markerManager_=new T.MarkerManager(this),this.toolboxCategoryCallbacks_={},this.flyoutButtonCallbacks_={},T.Variables&&T.Variables.flyoutCategory&&this.registerToolboxCategoryCallback(T.VARIABLE_CATEGORY_NAME,T.Variables.flyoutCategory),T.VariablesDynamic&&T.VariablesDynamic.flyoutCategory&&this.registerToolboxCategoryCallback(T.VARIABLE_DYNAMIC_CATEGORY_NAME,T.VariablesDynamic.flyoutCategory),T.Procedures&&T.Procedures.flyoutCategory&&(this.registerToolboxCategoryCallback(T.PROCEDURE_CATEGORY_NAME,T.Procedures.flyoutCategory),this.addChangeListener(T.Procedures.mutatorOpenListener)),this.themeManager_=this.options.parentWorkspace?this.options.parentWorkspace.getThemeManager():new T.ThemeManager(this,this.options.theme||T.Themes.Classic),this.themeManager_.subscribeWorkspace(this),this.renderer_=T.blockRendering.init(this.options.renderer||"geras",this.getTheme(),this.options.rendererOverrides),this.cachedParentSvg_=null,this.keyboardAccessibilityMode=!1,this.topBoundedElements_=[],this.cachedParentSvgSize_=new T.utils.Size(0,0)},T.utils.object.inherits(T.WorkspaceSvg,T.Workspace),T.WorkspaceSvg.prototype.resizeHandlerWrapper_=null,T.WorkspaceSvg.prototype.rendered=!0,T.WorkspaceSvg.prototype.isVisible_=!0,T.WorkspaceSvg.prototype.isFlyout=!1,T.WorkspaceSvg.prototype.isMutator=!1,T.WorkspaceSvg.prototype.resizesEnabled_=!0,T.WorkspaceSvg.prototype.scrollX=0,T.WorkspaceSvg.prototype.scrollY=0,T.WorkspaceSvg.prototype.startScrollX=0,T.WorkspaceSvg.prototype.startScrollY=0,T.WorkspaceSvg.prototype.dragDeltaXY_=null,T.WorkspaceSvg.prototype.scale=1,T.WorkspaceSvg.prototype.oldScale_=1,T.WorkspaceSvg.prototype.oldTop_=0,T.WorkspaceSvg.prototype.oldLeft_=0,T.WorkspaceSvg.prototype.trashcan=null,T.WorkspaceSvg.prototype.scrollbar=null,T.WorkspaceSvg.prototype.flyout_=null,T.WorkspaceSvg.prototype.toolbox_=null,T.WorkspaceSvg.prototype.currentGesture_=null,T.WorkspaceSvg.prototype.blockDragSurface_=null,T.WorkspaceSvg.prototype.workspaceDragSurface_=null,T.WorkspaceSvg.prototype.useWorkspaceDragSurface_=!1,T.WorkspaceSvg.prototype.isDragSurfaceActive_=!1,T.WorkspaceSvg.prototype.injectionDiv_=null,T.WorkspaceSvg.prototype.lastRecordedPageScroll_=null,T.WorkspaceSvg.prototype.targetWorkspace=null,T.WorkspaceSvg.prototype.inverseScreenCTM_=null,T.WorkspaceSvg.prototype.inverseScreenCTMDirty_=!0,T.WorkspaceSvg.prototype.getMarkerManager=function(){return this.markerManager_},T.WorkspaceSvg.prototype.getMetricsManager=function(){return this.metricsManager_},T.WorkspaceSvg.prototype.setMetricsManager=function(t){this.metricsManager_=t,this.getMetrics=this.metricsManager_.getMetrics.bind(this.metricsManager_)},T.WorkspaceSvg.prototype.getPluginManager=function(){return this.pluginManager_},T.WorkspaceSvg.prototype.setCursorSvg=function(t){this.markerManager_.setCursorSvg(t)},T.WorkspaceSvg.prototype.setMarkerSvg=function(t){this.markerManager_.setMarkerSvg(t)},T.WorkspaceSvg.prototype.getMarker=function(t){return this.markerManager_?this.markerManager_.getMarker(t):null},T.WorkspaceSvg.prototype.getCursor=function(){return this.markerManager_?this.markerManager_.getCursor():null},T.WorkspaceSvg.prototype.getRenderer=function(){return this.renderer_},T.WorkspaceSvg.prototype.getThemeManager=function(){return this.themeManager_},T.WorkspaceSvg.prototype.getTheme=function(){return this.themeManager_.getTheme()},T.WorkspaceSvg.prototype.setTheme=function(t){t=t||T.Themes.Classic,this.themeManager_.setTheme(t)},T.WorkspaceSvg.prototype.refreshTheme=function(){this.svgGroup_&&this.renderer_.refreshDom(this.svgGroup_,this.getTheme()),this.updateBlockStyles_(this.getAllBlocks(!1).filter(function(t){return void 0!==t.getStyleName()})),this.refreshToolboxSelection(),this.toolbox_&&this.toolbox_.refreshTheme(),this.isVisible()&&this.setVisible(!0);var t=new(T.Events.get(T.Events.THEME_CHANGE))(this.getTheme().name,this.id);T.Events.fire(t)},T.WorkspaceSvg.prototype.updateBlockStyles_=function(t){for(var e=0,o;o=t[e];e++){var i=o.getStyleName();i&&(o.setStyle(i),o.mutator)&&o.mutator.updateBlockStyle()}},T.WorkspaceSvg.prototype.getInverseScreenCTM=function(){var t;return this.inverseScreenCTMDirty_&&(t=this.getParentSvg().getScreenCTM())&&(this.inverseScreenCTM_=t.inverse(),this.inverseScreenCTMDirty_=!1),this.inverseScreenCTM_},T.WorkspaceSvg.prototype.updateInverseScreenCTM=function(){this.inverseScreenCTMDirty_=!0},T.WorkspaceSvg.prototype.isVisible=function(){return this.isVisible_},T.WorkspaceSvg.prototype.getSvgXY=function(t){var e=0,o=0,i=1;(T.utils.dom.containsNode(this.getCanvas(),t)||T.utils.dom.containsNode(this.getBubbleCanvas(),t))&&(i=this.scale);do{var s=T.utils.getRelativeXY(t);t!=this.getCanvas()&&t!=this.getBubbleCanvas()||(i=1),e+=s.x*i,o+=s.y*i,t=t.parentNode}while(t&&t!=this.getParentSvg());return new T.utils.Coordinate(e,o)},T.WorkspaceSvg.prototype.getCachedParentSvgSize=function(){var t=this.cachedParentSvgSize_;return new T.utils.Size(t.width,t.height)},T.WorkspaceSvg.prototype.getOriginOffsetInPixels=function(){return T.utils.getInjectionDivXY_(this.getCanvas())},T.WorkspaceSvg.prototype.getInjectionDiv=function(){if(!this.injectionDiv_)for(var t=this.svgGroup_;t;){if(-1!=(" "+(t.getAttribute("class")||"")+" ").indexOf(" injectionDiv ")){this.injectionDiv_=t;break}t=t.parentNode}return this.injectionDiv_},T.WorkspaceSvg.prototype.getBlockCanvas=function(){return this.svgBlockCanvas_},T.WorkspaceSvg.prototype.setResizeHandlerWrapper=function(t){this.resizeHandlerWrapper_=t},T.WorkspaceSvg.prototype.createDom=function(t){return this.svgGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:"blocklyWorkspace"},null),t&&(this.svgBackground_=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{height:"100%",width:"100%",class:t},this.svgGroup_),"blocklyMainBackground"==t&&this.grid_?this.svgBackground_.style.fill="url(#"+this.grid_.getPatternId()+")":this.themeManager_.subscribe(this.svgBackground_,"workspaceBackgroundColour","fill")),this.svgBlockCanvas_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:"blocklyBlockCanvas"},this.svgGroup_),this.svgBubbleCanvas_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:"blocklyBubbleCanvas"},this.svgGroup_),this.isFlyout||(T.browserEvents.conditionalBind(this.svgGroup_,"mousedown",this,this.onMouseDown_,!1,!0),T.browserEvents.conditionalBind(this.svgGroup_,"wheel",this,this.onMouseWheel_)),this.options.hasCategories&&(this.toolbox_=new(T.registry.getClassFromOptions(T.registry.Type.TOOLBOX,this.options,!0))(this)),this.grid_&&this.grid_.update(this.scale),this.recordDeleteAreas(),(t=T.registry.getClassFromOptions(T.registry.Type.CURSOR,this.options))&&this.markerManager_.setCursor(new t),this.renderer_.createDom(this.svgGroup_,this.getTheme()),this.svgGroup_},T.WorkspaceSvg.prototype.dispose=function(){var t;this.rendered=!1,this.currentGesture_&&this.currentGesture_.cancel(),this.svgGroup_&&(T.utils.dom.removeNode(this.svgGroup_),this.svgGroup_=null),this.svgBubbleCanvas_=this.svgBlockCanvas_=null,this.toolbox_&&(this.toolbox_.dispose(),this.toolbox_=null),this.flyout_&&(this.flyout_.dispose(),this.flyout_=null),this.trashcan&&(this.trashcan.dispose(),this.trashcan=null),this.scrollbar&&(this.scrollbar.dispose(),this.scrollbar=null),this.zoomControls_&&(this.zoomControls_.dispose(),this.zoomControls_=null),this.audioManager_&&(this.audioManager_.dispose(),this.audioManager_=null),this.grid_&&(this.grid_.dispose(),this.grid_=null),this.renderer_.dispose(),this.markerManager_&&(this.markerManager_.dispose(),this.markerManager_=null),T.WorkspaceSvg.superClass_.dispose.call(this),this.themeManager_&&(this.themeManager_.unsubscribeWorkspace(this),this.themeManager_.unsubscribe(this.svgBackground_),this.options.parentWorkspace||(this.themeManager_.dispose(),this.themeManager_=null)),this.flyoutButtonCallbacks_=this.toolboxCategoryCallbacks_=this.connectionDBList=null,this.options.parentWorkspace||(t=this.getParentSvg())&&t.parentNode&&T.utils.dom.removeNode(t.parentNode),this.resizeHandlerWrapper_&&(T.browserEvents.unbind(this.resizeHandlerWrapper_),this.resizeHandlerWrapper_=null)},T.WorkspaceSvg.prototype.newBlock=function(t,e){return new T.BlockSvg(this,t,e)},T.WorkspaceSvg.prototype.addTrashcan=function(){if(!T.Trashcan)throw Error("Missing require for Blockly.Trashcan");this.trashcan=new T.Trashcan(this);var t=this.trashcan.createDom();this.svgGroup_.insertBefore(t,this.svgBlockCanvas_),this.pluginManager_.addPlugin({id:"trashcan",plugin:this.trashcan,weight:1,types:[T.PluginManager.Type.POSITIONABLE]})},T.WorkspaceSvg.prototype.addZoomControls=function(){if(!T.ZoomControls)throw Error("Missing require for Blockly.ZoomControls");this.zoomControls_=new T.ZoomControls(this);var t=this.zoomControls_.createDom();this.svgGroup_.appendChild(t),this.pluginManager_.addPlugin({id:"zoomControls",plugin:this.zoomControls_,weight:2,types:[T.PluginManager.Type.POSITIONABLE]})},T.WorkspaceSvg.prototype.addFlyout=function(t){var e=new T.Options({parentWorkspace:this,rtl:this.RTL,oneBasedIndex:this.options.oneBasedIndex,horizontalLayout:this.horizontalLayout,renderer:this.options.renderer,rendererOverrides:this.options.rendererOverrides,move:{scrollbars:!0}});return e.toolboxPosition=this.options.toolboxPosition,this.flyout_=new(this.horizontalLayout?T.registry.getClassFromOptions(T.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX,this.options,!0):T.registry.getClassFromOptions(T.registry.Type.FLYOUTS_VERTICAL_TOOLBOX,this.options,!0))(e),this.flyout_.autoClose=!1,this.flyout_.getWorkspace().setVisible(!0),this.flyout_.createDom(t)},T.WorkspaceSvg.prototype.getFlyout=function(t){return this.flyout_||t?this.flyout_:this.toolbox_?this.toolbox_.getFlyout():null},T.WorkspaceSvg.prototype.getToolbox=function(){return this.toolbox_},T.WorkspaceSvg.prototype.updateScreenCalculations_=function(){this.updateInverseScreenCTM(),this.recordDeleteAreas()},T.WorkspaceSvg.prototype.resizeContents=function(){this.resizesEnabled_&&this.rendered&&(this.scrollbar&&this.scrollbar.resize(),this.updateInverseScreenCTM())},T.WorkspaceSvg.prototype.resize=function(){this.toolbox_&&this.toolbox_.position(),this.flyout_&&this.flyout_.position();for(var t=this.pluginManager_.getPlugins(T.PluginManager.Type.POSITIONABLE,!0),e=this.getMetricsManager().getUiMetrics(),o=[],i=0,s;s=t[i];i++)s.position(e,o),o.push(s.getBoundingRectangle());this.scrollbar&&this.scrollbar.resize(),this.updateScreenCalculations_()},T.WorkspaceSvg.prototype.updateScreenCalculationsIfScrolled=function(){var t=T.utils.getDocumentScroll();T.utils.Coordinate.equals(this.lastRecordedPageScroll_,t)||(this.lastRecordedPageScroll_=t,this.updateScreenCalculations_())},T.WorkspaceSvg.prototype.getCanvas=function(){return this.svgBlockCanvas_},T.WorkspaceSvg.prototype.setCachedParentSvgSize=function(t,e){var o=this.getParentSvg();t&&(this.cachedParentSvgSize_.width=t,o.cachedWidth_=t),e&&(this.cachedParentSvgSize_.height=e,o.cachedHeight_=e)},T.WorkspaceSvg.prototype.getBubbleCanvas=function(){return this.svgBubbleCanvas_},T.WorkspaceSvg.prototype.getParentSvg=function(){if(!this.cachedParentSvg_)for(var t=this.svgGroup_;t;){if("svg"==t.tagName){this.cachedParentSvg_=t;break}t=t.parentNode}return this.cachedParentSvg_},T.WorkspaceSvg.prototype.maybeFireViewportChangeEvent=function(){var t,e,o,i;T.Events.isEnabled()&&(t=this.scale,e=-this.scrollY,o=-this.scrollX,t==this.oldScale_&&Math.abs(e-this.oldTop_)<1&&Math.abs(o-this.oldLeft_)<1||(i=new(T.Events.get(T.Events.VIEWPORT_CHANGE))(e,o,t,this.id,this.oldScale_),this.oldScale_=t,this.oldTop_=e,this.oldLeft_=o,T.Events.fire(i)))},T.WorkspaceSvg.prototype.translate=function(t,e){var o;this.useWorkspaceDragSurface_&&this.isDragSurfaceActive_?this.workspaceDragSurface_.translateSurface(t,e):(o="translate("+t+","+e+") scale("+this.scale+")",this.svgBlockCanvas_.setAttribute("transform",o),this.svgBubbleCanvas_.setAttribute("transform",o)),this.blockDragSurface_&&this.blockDragSurface_.translateAndScaleGroup(t,e,this.scale),this.grid_&&this.grid_.moveTo(t,e),this.maybeFireViewportChangeEvent()},T.WorkspaceSvg.prototype.resetDragSurface=function(){var t;this.useWorkspaceDragSurface_&&(this.isDragSurfaceActive_=!1,t=this.workspaceDragSurface_.getSurfaceTranslation(),this.workspaceDragSurface_.clearAndHide(this.svgGroup_),t="translate("+t.x+","+t.y+") scale("+this.scale+")",this.svgBlockCanvas_.setAttribute("transform",t),this.svgBubbleCanvas_.setAttribute("transform",t))},T.WorkspaceSvg.prototype.setupDragSurface=function(){var t,e,o,i;this.useWorkspaceDragSurface_&&!this.isDragSurfaceActive_&&(this.isDragSurfaceActive_=!0,t=this.svgBlockCanvas_.previousSibling,e=parseInt(this.getParentSvg().getAttribute("width"),10),o=parseInt(this.getParentSvg().getAttribute("height"),10),i=T.utils.getRelativeXY(this.getCanvas()),this.workspaceDragSurface_.setContentsAndShow(this.getCanvas(),this.getBubbleCanvas(),t,e,o,this.scale),this.workspaceDragSurface_.translateSurface(i.x,i.y))},T.WorkspaceSvg.prototype.getBlockDragSurface=function(){return this.blockDragSurface_},T.WorkspaceSvg.prototype.getWidth=function(){var t=this.getMetrics();return t?t.viewWidth/this.scale:0},T.WorkspaceSvg.prototype.setVisible=function(t){if(this.isVisible_=t,this.svgGroup_)if(this.scrollbar&&this.scrollbar.setContainerVisible(t),this.getFlyout()&&this.getFlyout().setContainerVisible(t),this.getParentSvg().style.display=t?"block":"none",this.toolbox_&&this.toolbox_.setVisible(t),t){for(var e=(t=this.getAllBlocks(!1)).length-1;0<=e;e--)t[e].markDirty();this.render(),this.toolbox_&&this.toolbox_.position()}else T.hideChaff(!0)},T.WorkspaceSvg.prototype.render=function(){for(var t=this.getAllBlocks(!1),e=t.length-1;0<=e;e--)t[e].render(!1);if(this.currentGesture_)for(t=this.currentGesture_.getInsertionMarkers(),e=0;e<t.length;e++)t[e].render(!1);this.markerManager_.updateMarkers()},T.WorkspaceSvg.prototype.highlightBlock=function(t,e){if(void 0===e){for(var o=0,i;i=this.highlightedBlocks_[o];o++)i.setHighlighted(!1);this.highlightedBlocks_.length=0}(i=t?this.getBlockById(t):null)&&((t=void 0===e||e)?-1==this.highlightedBlocks_.indexOf(i)&&this.highlightedBlocks_.push(i):T.utils.arrayRemove(this.highlightedBlocks_,i),i.setHighlighted(t))},T.WorkspaceSvg.prototype.paste=function(t){!this.rendered||!t.tagName||t.getElementsByTagName("block").length>=this.remainingCapacity()||(this.currentGesture_&&this.currentGesture_.cancel(),"comment"==t.tagName.toLowerCase()?this.pasteWorkspaceComment_(t):this.pasteBlock_(t))},T.WorkspaceSvg.prototype.pasteBlock_=function(t){T.Events.disable();try{var e=T.Xml.domToBlock(t,this),o=parseInt(t.getAttribute("x"),10),i=parseInt(t.getAttribute("y"),10);if(!isNaN(o)&&!isNaN(i)){this.RTL&&(o=-o);do{t=!1;for(var s=this.getAllBlocks(!1),n=0,r;r=s[n];n++){var l=r.getRelativeToSurfaceXY();if(Math.abs(o-l.x)<=1&&Math.abs(i-l.y)<=1){t=!0;break}}if(!t)for(var a=e.getConnections_(!1),n=0,c;c=a[n];n++)if(c.closest(T.SNAP_RADIUS,new T.utils.Coordinate(o,i)).connection){t=!0;break}t&&(o=this.RTL?o-T.SNAP_RADIUS:o+T.SNAP_RADIUS,i+=2*T.SNAP_RADIUS)}while(t);e.moveBy(o,i)}}finally{T.Events.enable()}T.Events.isEnabled()&&!e.isShadow()&&T.Events.fire(new(T.Events.get(T.Events.BLOCK_CREATE))(e)),e.select()},T.WorkspaceSvg.prototype.pasteWorkspaceComment_=function(t){T.Events.disable();try{var e=T.WorkspaceCommentSvg.fromXml(t,this),o=parseInt(t.getAttribute("x"),10),i=parseInt(t.getAttribute("y"),10);isNaN(o)||isNaN(i)||(this.RTL&&(o=-o),e.moveBy(o+50,i+50))}finally{T.Events.enable()}T.Events.isEnabled()&&T.WorkspaceComment.fireCreateEvent(e),e.select()},T.WorkspaceSvg.prototype.refreshToolboxSelection=function(){var t=this.isFlyout?this.targetWorkspace:this;t&&!t.currentGesture_&&t.toolbox_&&t.toolbox_.getFlyout()&&t.toolbox_.refreshSelection()},T.WorkspaceSvg.prototype.renameVariableById=function(t,e){T.WorkspaceSvg.superClass_.renameVariableById.call(this,t,e),this.refreshToolboxSelection()},T.WorkspaceSvg.prototype.deleteVariableById=function(t){T.WorkspaceSvg.superClass_.deleteVariableById.call(this,t),this.refreshToolboxSelection()},T.WorkspaceSvg.prototype.createVariable=function(t,e,o){return t=T.WorkspaceSvg.superClass_.createVariable.call(this,t,e,o),this.refreshToolboxSelection(),t},T.WorkspaceSvg.prototype.recordDeleteAreas=function(){this.deleteAreaTrash_=this.trashcan&&this.svgGroup_.parentNode?this.trashcan.getClientRect():null,this.deleteAreaToolbox_=this.flyout_?this.flyout_.getClientRect():this.toolbox_&&"function"==typeof this.toolbox_.getClientRect?this.toolbox_.getClientRect():null},T.WorkspaceSvg.prototype.isDeleteArea=function(t){return this.deleteAreaTrash_&&this.deleteAreaTrash_.contains(t.clientX,t.clientY)?T.DELETE_AREA_TRASH:this.deleteAreaToolbox_&&this.deleteAreaToolbox_.contains(t.clientX,t.clientY)?T.DELETE_AREA_TOOLBOX:T.DELETE_AREA_NONE},T.WorkspaceSvg.prototype.onMouseDown_=function(t){var e=this.getGesture(t);e&&e.handleWsStart(t,this)},T.WorkspaceSvg.prototype.startDrag=function(t,e){(t=T.utils.mouseToSvg(t,this.getParentSvg(),this.getInverseScreenCTM())).x/=this.scale,t.y/=this.scale,this.dragDeltaXY_=T.utils.Coordinate.difference(e,t)},T.WorkspaceSvg.prototype.moveDrag=function(t){return(t=T.utils.mouseToSvg(t,this.getParentSvg(),this.getInverseScreenCTM(
))).x/=this.scale,t.y/=this.scale,T.utils.Coordinate.sum(this.dragDeltaXY_,t)},T.WorkspaceSvg.prototype.isDragging=function(){return null!=this.currentGesture_&&this.currentGesture_.isDragging()},T.WorkspaceSvg.prototype.isDraggable=function(){return this.options.moveOptions&&this.options.moveOptions.drag},T.WorkspaceSvg.prototype.isMovable=function(){return this.options.moveOptions&&!!this.options.moveOptions.scrollbars||this.options.moveOptions&&this.options.moveOptions.wheel||this.options.moveOptions&&this.options.moveOptions.drag||this.options.zoomOptions&&this.options.zoomOptions.wheel||this.options.zoomOptions&&this.options.zoomOptions.pinch},T.WorkspaceSvg.prototype.isMovableHorizontally=function(){var t=!!this.scrollbar;return this.isMovable()&&(!t||t&&this.scrollbar.canScrollHorizontally())},T.WorkspaceSvg.prototype.isMovableVertically=function(){var t=!!this.scrollbar;return this.isMovable()&&(!t||t&&this.scrollbar.canScrollVertically())},T.WorkspaceSvg.prototype.onMouseWheel_=function(t){var e,o,i;T.Gesture.inProgress()?(t.preventDefault(),t.stopPropagation()):(e=this.options.zoomOptions&&this.options.zoomOptions.wheel,o=this.options.moveOptions&&this.options.moveOptions.wheel,(e||o)&&(i=T.utils.getScrollDeltaPixels(t),!e||!t.ctrlKey&&o?(e=this.scrollX-i.x,o=this.scrollY-i.y,t.shiftKey&&!i.x&&(e=this.scrollX-i.y,o=this.scrollY),this.scroll(e,o)):(i=-i.y/50,e=T.utils.mouseToSvg(t,this.getParentSvg(),this.getInverseScreenCTM()),this.zoom(e.x,e.y,i)),t.preventDefault()))},T.WorkspaceSvg.prototype.getBlocksBoundingBox=function(){var t=this.getTopBoundedElements();if(!t.length)return new T.utils.Rect(0,0,0,0);for(var e=t[0].getBoundingRectangle(),o=1;o<t.length;o++){var i=t[o];i.isInsertionMarker&&i.isInsertionMarker()||((i=i.getBoundingRectangle()).top<e.top&&(e.top=i.top),i.bottom>e.bottom&&(e.bottom=i.bottom),i.left<e.left&&(e.left=i.left),i.right>e.right&&(e.right=i.right))}return e},T.WorkspaceSvg.prototype.cleanUp=function(){this.setResizesEnabled(!1),T.Events.setGroup(!0);for(var t=this.getTopBlocks(!0),e=0,o=0,i,s;i=t[o];o++){i.isMovable()&&(s=i.getRelativeToSurfaceXY(),i.moveBy(-s.x,e-s.y),i.snapToGrid(),e=i.getRelativeToSurfaceXY().y+i.getHeightWidth().height+this.renderer_.getConstants().MIN_BLOCK_HEIGHT)}T.Events.setGroup(!1),this.setResizesEnabled(!0)},T.WorkspaceSvg.prototype.showContextMenu=function(t){var e;this.options.readOnly||this.isFlyout||(e=T.ContextMenuRegistry.registry.getContextMenuOptions(T.ContextMenuRegistry.ScopeType.WORKSPACE,{workspace:this}),this.configureContextMenu&&this.configureContextMenu(e,t),T.ContextMenu.show(t,e,this.RTL))},T.WorkspaceSvg.prototype.updateToolbox=function(t){if(t=T.utils.toolbox.convertToolboxDefToJson(t)){if(!this.options.languageTree)throw Error("Existing toolbox is null.  Can't create new toolbox.");if(T.utils.toolbox.hasCategories(t)){if(!this.toolbox_)throw Error("Existing toolbox has no categories.  Can't change mode.");this.options.languageTree=t,this.toolbox_.render(t)}else{if(!this.flyout_)throw Error("Existing toolbox has categories.  Can't change mode.");this.options.languageTree=t,this.flyout_.show(t)}}else if(this.options.languageTree)throw Error("Can't nullify an existing toolbox.")},T.WorkspaceSvg.prototype.markFocused=function(){this.options.parentWorkspace?this.options.parentWorkspace.markFocused():(T.mainWorkspace=this).setBrowserFocus()},T.WorkspaceSvg.prototype.setBrowserFocus=function(){document.activeElement&&document.activeElement.blur&&document.activeElement.blur();try{this.getParentSvg().focus({preventScroll:!0})}catch(t){try{this.getParentSvg().parentNode.setActive()}catch(t){this.getParentSvg().parentNode.focus({preventScroll:!0})}}},T.WorkspaceSvg.prototype.zoom=function(t,e,o){o=Math.pow(this.options.zoomOptions.scaleSpeed,o);var i=this.scale*o,s,n;this.scale!=i&&(i>this.options.zoomOptions.maxScale?o=this.options.zoomOptions.maxScale/this.scale:i<this.options.zoomOptions.minScale&&(o=this.options.zoomOptions.minScale/this.scale),s=this.getCanvas().getCTM(),(n=this.getParentSvg().createSVGPoint()).x=t,n.y=e,t=(n=n.matrixTransform(s.inverse())).x,e=n.y,s=s.translate(t*(1-o),e*(1-o)).scale(o),this.scrollX=s.e,this.scrollY=s.f,this.setScale(i))},T.WorkspaceSvg.prototype.zoomCenter=function(t){var e=this.getMetrics(),o,e;e=this.flyout_?(o=e.svgWidth?e.svgWidth/2:0,e.svgHeight?e.svgHeight/2:0):(o=e.viewWidth/2+e.absoluteLeft,e.viewHeight/2+e.absoluteTop),this.zoom(o,e,t)},T.WorkspaceSvg.prototype.zoomToFit=function(){if(this.isMovable()){var t,e=(t=this.getMetrics()).viewWidth,t=t.viewHeight,o,i=(o=this.getBlocksBoundingBox()).right-o.left,o=o.bottom-o.top;if(i){this.flyout_&&(this.horizontalLayout?(t+=this.flyout_.getHeight(),o+=this.flyout_.getHeight()/this.scale):(e+=this.flyout_.getWidth(),i+=this.flyout_.getWidth()/this.scale)),e/=i,t/=o,T.Events.disable();try{this.setScale(Math.min(e,t)),this.scrollCenter()}finally{T.Events.enable()}this.maybeFireViewportChangeEvent()}}else console.warn("Tried to move a non-movable workspace. This could result in blocks becoming inaccessible.")},T.WorkspaceSvg.prototype.beginCanvasTransition=function(){T.utils.dom.addClass(this.svgBlockCanvas_,"blocklyCanvasTransitioning"),T.utils.dom.addClass(this.svgBubbleCanvas_,"blocklyCanvasTransitioning")},T.WorkspaceSvg.prototype.endCanvasTransition=function(){T.utils.dom.removeClass(this.svgBlockCanvas_,"blocklyCanvasTransitioning"),T.utils.dom.removeClass(this.svgBubbleCanvas_,"blocklyCanvasTransitioning")},T.WorkspaceSvg.prototype.scrollCenter=function(){var t,e,o,e,o;this.isMovable()?(e=((t=this.getMetrics()).scrollWidth-t.viewWidth)/2,o=(t.scrollHeight-t.viewHeight)/2,e=-e-t.scrollLeft,o=-o-t.scrollTop,this.scroll(e,o)):console.warn("Tried to move a non-movable workspace. This could result in blocks becoming inaccessible.")},T.WorkspaceSvg.prototype.centerOnBlock=function(t){var e,o,i;this.isMovable()?(t=t?this.getBlockById(t):null)&&(e=t.getRelativeToSurfaceXY(),o=t.getHeightWidth(),i=this.scale,t=(e.x+(this.RTL?-1:1)*o.width/2)*i,e=(e.y+o.height/2)*i,o=this.getMetrics(),this.scroll(-(t-o.viewWidth/2),-(e-o.viewHeight/2))):console.warn("Tried to move a non-movable workspace. This could result in blocks becoming inaccessible.")},T.WorkspaceSvg.prototype.setScale=function(t){this.options.zoomOptions.maxScale&&t>this.options.zoomOptions.maxScale?t=this.options.zoomOptions.maxScale:this.options.zoomOptions.minScale&&t<this.options.zoomOptions.minScale&&(t=this.options.zoomOptions.minScale),this.scale=t,T.hideChaff(!1),this.flyout_&&(this.flyout_.reflow(),this.recordDeleteAreas()),this.grid_&&this.grid_.update(this.scale),t=this.getMetrics(),this.scrollX-=t.absoluteLeft,this.scrollY-=t.absoluteTop,t.viewLeft+=t.absoluteLeft,t.viewTop+=t.absoluteTop,this.scroll(this.scrollX,this.scrollY),this.scrollbar&&(this.flyout_?this.scrollbar.resizeView(t):this.scrollbar.resizeContent(t))},T.WorkspaceSvg.prototype.getScale=function(){return this.options.parentWorkspace?this.options.parentWorkspace.getScale():this.scale},T.WorkspaceSvg.prototype.scroll=function(t,e){T.hideChaff(!0);var o=this.getMetrics(),i=(t=Math.min(t,-o.scrollLeft),e=Math.min(e,-o.scrollTop),o.scrollTop+Math.max(0,o.scrollHeight-o.viewHeight));t=Math.max(t,-(o.scrollLeft+Math.max(0,o.scrollWidth-o.viewWidth))),e=Math.max(e,-i),this.scrollX=t,this.scrollY=e,this.scrollbar&&this.scrollbar.set(-(t+o.scrollLeft),-(e+o.scrollTop),!1),t+=o.absoluteLeft,e+=o.absoluteTop,this.translate(t,e)},T.WorkspaceSvg.setTopLevelWorkspaceMetrics_=function(t){var e=this.getMetrics();"number"==typeof t.x&&(this.scrollX=-(e.scrollLeft+(e.scrollWidth-e.viewWidth)*t.x)),"number"==typeof t.y&&(this.scrollY=-(e.scrollTop+(e.scrollHeight-e.viewHeight)*t.y)),this.translate(this.scrollX+e.absoluteLeft,this.scrollY+e.absoluteTop)},T.WorkspaceSvg.prototype.getBlockById=function(t){return T.WorkspaceSvg.superClass_.getBlockById.call(this,t)},T.WorkspaceSvg.prototype.getTopBlocks=function(t){return T.WorkspaceSvg.superClass_.getTopBlocks.call(this,t)},T.WorkspaceSvg.prototype.addTopBlock=function(t){this.addTopBoundedElement(t),T.WorkspaceSvg.superClass_.addTopBlock.call(this,t)},T.WorkspaceSvg.prototype.removeTopBlock=function(t){this.removeTopBoundedElement(t),T.WorkspaceSvg.superClass_.removeTopBlock.call(this,t)},T.WorkspaceSvg.prototype.addTopComment=function(t){this.addTopBoundedElement(t),T.WorkspaceSvg.superClass_.addTopComment.call(this,t)},T.WorkspaceSvg.prototype.removeTopComment=function(t){this.removeTopBoundedElement(t),T.WorkspaceSvg.superClass_.removeTopComment.call(this,t)},T.WorkspaceSvg.prototype.addTopBoundedElement=function(t){this.topBoundedElements_.push(t)},T.WorkspaceSvg.prototype.removeTopBoundedElement=function(t){T.utils.arrayRemove(this.topBoundedElements_,t)},T.WorkspaceSvg.prototype.getTopBoundedElements=function(){return[].concat(this.topBoundedElements_)},T.WorkspaceSvg.prototype.setResizesEnabled=function(t){var e=!this.resizesEnabled_&&t;this.resizesEnabled_=t,e&&this.resizeContents()},T.WorkspaceSvg.prototype.clear=function(){this.setResizesEnabled(!1),T.WorkspaceSvg.superClass_.clear.call(this),this.topBoundedElements_=[],this.setResizesEnabled(!0)},T.WorkspaceSvg.prototype.registerButtonCallback=function(t,e){if("function"!=typeof e)throw TypeError("Button callbacks must be functions.");this.flyoutButtonCallbacks_[t]=e},T.WorkspaceSvg.prototype.getButtonCallback=function(t){return(t=this.flyoutButtonCallbacks_[t])||null},T.WorkspaceSvg.prototype.removeButtonCallback=function(t){this.flyoutButtonCallbacks_[t]=null},T.WorkspaceSvg.prototype.registerToolboxCategoryCallback=function(t,e){if("function"!=typeof e)throw TypeError("Toolbox category callbacks must be functions.");this.toolboxCategoryCallbacks_[t]=e},T.WorkspaceSvg.prototype.getToolboxCategoryCallback=function(t){return this.toolboxCategoryCallbacks_[t]||null},T.WorkspaceSvg.prototype.removeToolboxCategoryCallback=function(t){this.toolboxCategoryCallbacks_[t]=null},T.WorkspaceSvg.prototype.getGesture=function(t){var e="mousedown"==t.type||"touchstart"==t.type||"pointerdown"==t.type,o=this.currentGesture_;return o?e&&o.hasStarted()?(console.warn("Tried to start the same gesture twice."),o.cancel(),null):o:e?this.currentGesture_=new T.TouchGesture(t,this):null},T.WorkspaceSvg.prototype.clearGesture=function(){this.currentGesture_=null},T.WorkspaceSvg.prototype.cancelCurrentGesture=function(){this.currentGesture_&&this.currentGesture_.cancel()},T.WorkspaceSvg.prototype.getAudioManager=function(){return this.audioManager_},T.WorkspaceSvg.prototype.getGrid=function(){return this.grid_},T.inject=function(t,e){if(T.checkBlockColourConstants(),!(t="string"==typeof t?document.getElementById(t)||document.querySelector(t):t)||!T.utils.dom.containsNode(document,t))throw Error("Error: container is not in current document.");e=new T.Options(e||{});var o=document.createElement("div"),i=(o.className="injectionDiv",o.tabIndex=0,T.utils.aria.setState(o,T.utils.aria.State.LABEL,T.Msg.WORKSPACE_ARIA_LABEL),t.appendChild(o),t=T.createDom_(o,e),new T.BlockDragSurfaceSvg(o)),s=new T.WorkspaceDragSurfaceSvg(o),n=T.createMainWorkspace_(t,e,i,s);return T.init_(n),T.mainWorkspace=n,T.svgResize(n),o.addEventListener("focusin",function(){T.mainWorkspace=n}),n},T.createDom_=function(t,e){t.setAttribute("dir","LTR"),T.Css.inject(e.hasCss,e.pathToMedia),t=T.utils.dom.createSvgElement(T.utils.Svg.SVG,{xmlns:T.utils.dom.SVG_NS,"xmlns:html":T.utils.dom.HTML_NS,"xmlns:xlink":T.utils.dom.XLINK_NS,version:"1.1",class:"blocklySvg",tabindex:"0"},t);var o=T.utils.dom.createSvgElement(T.utils.Svg.DEFS,{},t),i=String(Math.random()).substring(2);return e.gridPattern=T.Grid.createDom(i,e.gridOptions,o),t},T.createMainWorkspace_=function(t,e,o,i){return e.parentWorkspace=null,o=(e=new T.WorkspaceSvg(e,o,i)).options,e.scale=o.zoomOptions.startScale,t.appendChild(e.createDom("blocklyMainBackground")),T.utils.dom.addClass(e.getInjectionDiv(),e.getRenderer().getClassName()),T.utils.dom.addClass(e.getInjectionDiv(),e.getTheme().getClassName()),!o.hasCategories&&o.languageTree&&(i=e.addFlyout(T.utils.Svg.SVG),T.utils.dom.insertAfter(i,t)),o.hasTrashcan&&e.addTrashcan(),o.zoomOptions&&o.zoomOptions.controls&&e.addZoomControls(),e.getThemeManager().subscribe(t,"workspaceBackgroundColour","background-color"),e.translate(0,0),e.addChangeListener(T.bumpIntoBoundsHandler_(e)),T.svgResize(e),T.WidgetDiv.createDom(),T.DropDownDiv.createDom(),T.Tooltip.createDom(),e},T.extractObjectFromEvent_=function(t,e){var o=null;switch(e.type){case T.Events.BLOCK_CREATE:case T.Events.BLOCK_MOVE:o=(o=t.getBlockById(e.blockId))&&o.getRootBlock();break;case T.Events.COMMENT_CREATE:case T.Events.COMMENT_MOVE:o=t.getCommentById(e.commentId)}return o},T.bumpTopObjectsIntoBounds_=function(t){var e;if((e=t.getMetricsManager()).hasFixedEdges()&&!t.isDragging())for(var e=e.getScrollMetrics(!0),o=t.getTopBoundedElements(),i=0,s;s=o[i];i++)T.bumpObjectIntoBounds_(t,e,s)},T.bumpIntoBoundsHandler_=function(s){return function(t){var e=s.getMetricsManager(),e,o,i;e.hasFixedEdges&&!s.isDragging()&&(-1!==T.Events.BUMP_EVENTS.indexOf(t.type)?(e=e.getScrollMetrics(!0),(o=T.extractObjectFromEvent_(s,t))&&(i=T.Events.getGroup(),T.Events.setGroup(t.group),T.bumpObjectIntoBounds_(s,e,o)&&!t.group&&console.warn("Moved object in bounds but there was no event group. This may break undo."),null!==i)&&T.Events.setGroup(i)):t.type===T.Events.VIEWPORT_CHANGE&&t.scale>t.oldScale&&T.bumpTopObjectsIntoBounds_(s))}},T.bumpObjectIntoBounds_=function(t,e,o){var i=o.getBoundingRectangle(),s=i.right-i.left,n=T.utils.math.clamp(e.top,i.top,e.top+e.height-(i.bottom-i.top))-i.top,r=e.left;return e=e.left+e.width-s,t.RTL?r=Math.min(e,r):e=Math.max(r,e),!(!(t=T.utils.math.clamp(r,i.left,e)-i.left)&&!n||(o.moveBy(t,n),0))},T.init_=function(t){var e=t.options,o=t.getParentSvg(),o,i;T.browserEvents.conditionalBind(o.parentNode,"contextmenu",null,function(t){T.utils.isTargetInput(t)||t.preventDefault()}),o=T.browserEvents.conditionalBind(window,"resize",null,function(){T.hideChaff(!0),T.svgResize(t),T.bumpTopObjectsIntoBounds_(t)}),t.setResizeHandlerWrapper(o),T.inject.bindDocumentEvents_(),e.languageTree&&(o=t.getToolbox(),i=t.getFlyout(!0),o?o.init():i&&(i.init(t),i.show(e.languageTree),"function"==typeof i.scrollToStart)&&i.scrollToStart()),o=T.Scrollbar.scrollbarThickness,e.hasTrashcan&&(o=t.trashcan.init(o)),e.zoomOptions&&e.zoomOptions.controls&&t.zoomControls_.init(o),e.moveOptions&&e.moveOptions.scrollbars?(t.scrollbar=new T.ScrollbarPair(t,!0===e.moveOptions.scrollbars||!!e.moveOptions.scrollbars.horizontal,!0===e.moveOptions.scrollbars||!!e.moveOptions.scrollbars.vertical,"blocklyMainWorkspaceScrollbar"),t.scrollbar.resize()):t.setMetrics({x:.5,y:.5}),e.hasSounds&&T.inject.loadSounds_(e.pathToMedia,t)},T.inject.bindDocumentEvents_=function(){T.documentEventsBound_||(T.browserEvents.conditionalBind(document,"scroll",null,function(){for(var t=T.Workspace.getAll(),e=0,o;o=t[e];e++)o.updateInverseScreenCTM&&o.updateInverseScreenCTM()}),T.browserEvents.conditionalBind(document,"keydown",null,T.onKeyDown),T.browserEvents.bind(document,"touchend",null,T.longStop_),T.browserEvents.bind(document,"touchcancel",null,T.longStop_),T.utils.userAgent.IPAD&&T.browserEvents.conditionalBind(window,"orientationchange",document,function(){T.svgResize(T.getMainWorkspace())})),T.documentEventsBound_=!0},T.inject.loadSounds_=function(t,e){var o=e.getAudioManager(),i=(o.load([t+"click.mp3",t+"click.wav",t+"click.ogg"],"click"),o.load([t+"disconnect.wav",t+"disconnect.mp3",t+"disconnect.ogg"],"disconnect"),o.load([t+"delete.mp3",t+"delete.ogg",t+"delete.wav"],"delete"),[]);t=function(){for(;i.length;)T.browserEvents.unbind(i.pop());o.preload()},i.push(T.browserEvents.conditionalBind(document,"mousemove",null,t,!0)),i.push(T.browserEvents.conditionalBind(document,"touchstart",null,t,!0))},T.Names=function(t,e){if(this.variablePrefix_=e||"",this.reservedDict_=Object.create(null),t)for(t=t.split(","),e=0;e<t.length;e++)this.reservedDict_[t[e]]=!0;this.reset()},T.Names.DEVELOPER_VARIABLE_TYPE="DEVELOPER_VARIABLE",T.Names.prototype.reset=function(){this.db_=Object.create(null),this.dbReverse_=Object.create(null),this.variableMap_=null},T.Names.prototype.setVariableMap=function(t){this.variableMap_=t},T.Names.prototype.getNameForUserVariable_=function(t){return this.variableMap_?(t=this.variableMap_.getVariableById(t))?t.name:null:(console.log("Deprecated call to Blockly.Names.prototype.getName without defining a variable map. To fix, add the following code in your generator's init() function:\nBlockly.YourGeneratorName.variableDB_.setVariableMap(workspace.getVariableMap());"),null)},T.Names.prototype.getName=function(t,e){var o,i=(o=(t=e==T.VARIABLE_CATEGORY_NAME&&(o=this.getNameForUserVariable_(t))?o:t).toLowerCase()+"_"+e,e==T.VARIABLE_CATEGORY_NAME||e==T.Names.DEVELOPER_VARIABLE_TYPE?this.variablePrefix_:"");if(o in this.db_)return i+this.db_[o];return t=this.getDistinctName(t,e),this.db_[o]=t.substr(i.length),t},T.Names.prototype.getDistinctName=function(t,e){t=this.safeName_(t);for(var o="";this.dbReverse_[t+o]||t+o in this.reservedDict_;)o=o?o+1:2;return this.dbReverse_[t+=o]=!0,(e==T.VARIABLE_CATEGORY_NAME||e==T.Names.DEVELOPER_VARIABLE_TYPE?this.variablePrefix_:"")+t},T.Names.prototype.safeName_=function(t){return t?(t=encodeURI(t.replace(/ /g,"_")).replace(/[^\w]/g,"_"),-1!="0123456789".indexOf(t[0])&&(t="my_"+t)):t=T.Msg.UNNAMED_KEY||"unnamed",t},T.Names.equals=function(t,e){return t.toLowerCase()==e.toLowerCase()},T.Procedures={},T.Procedures.NAME_TYPE=T.PROCEDURE_CATEGORY_NAME,T.Procedures.DEFAULT_ARG="x",T.Procedures.allProcedures=function(t){var e=t.getBlocksByType("procedures_defnoreturn",!1).map(function(t){return t.getProcedureDef()});return t=t.getBlocksByType("procedures_defreturn",!1).map(function(t){return t.getProcedureDef()}),e.sort(T.Procedures.procTupleComparator_),t.sort(T.Procedures.procTupleComparator_),[e,t]},T.Procedures.procTupleComparator_=function(t,e){return t[0].toLowerCase().localeCompare(e[0].toLowerCase())},T.Procedures.findLegalName=function(t,e){if(e.isInFlyout)return t;for(t=t||T.Msg.UNNAMED_KEY||"unnamed";!T.Procedures.isLegalName_(t,e.workspace,e);){var o=t.match(/^(.*?)(\d+)$/);t=o?o[1]+(parseInt(o[2],10)+1):t+"2"}return t},T.Procedures.isLegalName_=function(t,e,o){return!T.Procedures.isNameUsed(t,e,o)},T.Procedures.isNameUsed=function(t,e,o){e=e.getAllBlocks(!1);for(var i=0;i<e.length;i++)if(e[i]!=o&&e[i].getProcedureDef){var s=e[i].getProcedureDef();if(T.Names.equals(s[0],t))return!0}return!1},T.Procedures.rename=function(t){t=t.trim();var e=T.Procedures.findLegalName(t,this.getSourceBlock()),o=this.getValue();if(o!=t&&o!=e){t=this.getSourceBlock().workspace.getAllBlocks(!1);for(var i=0;i<t.length;i++)t[i].renameProcedure&&t[i].renameProcedure(o,e)}return e},T.Procedures.flyoutCategory=function(t){function e(t,e){for(var o=0;o<t.length;o++){var i=t[o][0],s=t[o][1],n=T.utils.xml.createElement("block"),r=(n.setAttribute("type",e),n.setAttribute("gap",16),T.utils.xml.createElement("mutation"));for(r.setAttribute("name",i),n.appendChild(r),i=0;i<s.length;i++){var l=T.utils.xml.createElement("arg");l.setAttribute("name",s[i]),r.appendChild(l)}a.push(n)}}var a=[],o,i;return T.Blocks.procedures_defnoreturn&&((o=T.utils.xml.createElement("block")).setAttribute("type","procedures_defnoreturn"),o.setAttribute("gap",16),(i=T.utils.xml.createElement("field")).setAttribute("name","NAME"),i.appendChild(T.utils.xml.createTextNode(T.Msg.PROCEDURES_DEFNORETURN_PROCEDURE)),o.appendChild(i),a.push(o)),T.Blocks.procedures_defreturn&&((o=T.utils.xml.createElement("block")).setAttribute("type","procedures_defreturn"),o.setAttribute("gap",16),(i=T.utils.xml.createElement("field")).setAttribute("name","NAME"),i.appendChild(T.utils.xml.createTextNode(T.Msg.PROCEDURES_DEFRETURN_PROCEDURE)),o.appendChild(i),a.push(o)),T.Blocks.procedures_ifreturn&&((o=T.utils.xml.createElement("block")).setAttribute("type","procedures_ifreturn"),o.setAttribute("gap",16),a.push(o)),a.length&&a[a.length-1].setAttribute("gap",24),e((t=T.Procedures.allProcedures(t))[0],"procedures_callnoreturn"),e(t[1],"procedures_callreturn"),a},T.Procedures.updateMutatorFlyout_=function(t){for(var e=[],o=t.getBlocksByType("procedures_mutatorarg",!1),i=0,s;s=o[i];i++)e.push(s.getFieldValue("NAME"));o=T.utils.xml.createElement("xml"),(i=T.utils.xml.createElement("block")).setAttribute("type","procedures_mutatorarg"),(s=T.utils.xml.createElement("field")).setAttribute("name","NAME"),e=T.Variables.generateUniqueNameFromOptions(T.Procedures.DEFAULT_ARG,e),e=T.utils.xml.createTextNode(e),s.appendChild(e),i.appendChild(s),o.appendChild(i),t.updateToolbox(o)},T.Procedures.mutatorOpenListener=function(t){var e;t.type!=T.Events.BUBBLE_OPEN||"mutator"!==t.bubbleType||!t.isOpen||"procedures_defnoreturn"!=(e=(t=T.Workspace.getById(t.workspaceId).getBlockById(t.blockId)).type)&&"procedures_defreturn"!=e||(t=t.mutator.getWorkspace(),T.Procedures.updateMutatorFlyout_(t),t.addChangeListener(T.Procedures.mutatorChangeListener_))},T.Procedures.mutatorChangeListener_=function(t){t.type!=T.Events.BLOCK_CREATE&&t.type!=T.Events.BLOCK_DELETE&&t.type!=T.Events.BLOCK_CHANGE||(t=T.Workspace.getById(t.workspaceId),T.Procedures.updateMutatorFlyout_(t))},T.Procedures.getCallers=function(t,e){var o=[];e=e.getAllBlocks(!1);for(var i=0,s;i<e.length;i++){e[i].getProcedureCall&&(s=e[i].getProcedureCall())&&T.Names.equals(s,t)&&o.push(e[i])}return o},T.Procedures.mutateCallers=function(t){var e=T.Events.recordUndo,o=t.getProcedureDef()[0],i=t.mutationToDom(!0),s;for(t=T.Procedures.getCallers(o,t.workspace),o=0;s=t[o];o++){var n,n=(n=s.mutationToDom())&&T.Xml.domToText(n),r=(s.domToMutation(i),s.mutationToDom()),r;n!=(r=r&&T.Xml.domToText(r))&&(T.Events.recordUndo=!1,T.Events.fire(new(T.Events.get(T.Events.BLOCK_CHANGE))(s,"mutation",null,n,r)),T.Events.recordUndo=e)}},T.Procedures.getDefinition=function(t,e){e=e.getTopBlocks(!1);for(var o=0;o<e.length;o++)if(e[o].getProcedureDef){var i=e[o].getProcedureDef();if(i&&T.Names.equals(i[0],t))return e[o]}return null},T.ShortcutRegistry=function(){(T.ShortcutRegistry.registry=this).registry_=Object.create(null),this.keyMap_=Object.create(null)},T.ShortcutRegistry.modifierKeys={Shift:T.utils.KeyCodes.SHIFT,Control:T.utils.KeyCodes.CTRL,Alt:T.utils.KeyCodes.ALT,Meta:T.utils.KeyCodes.META},T.ShortcutRegistry.prototype.register=function(t,e){if(this.registry_[t.name]&&!e)throw Error('Shortcut with name "'+t.name+'" already exists.');this.registry_[t.name]=t},T.ShortcutRegistry.prototype.unregister=function(t){if(!this.registry_[t])return console.warn('Keyboard shortcut with name "'+t+'" not found.'),!1;return this.removeAllKeyMappings(t),delete this.registry_[t],!0},T.ShortcutRegistry.prototype.addKeyMapping=function(t,e,o){t=String(t);var i=this.keyMap_[t];if(i&&!o)throw Error('Shortcut with name "'+e+'" collides with shortcuts '+i.toString());i&&o?i.unshift(e):this.keyMap_[t]=[e]},T.ShortcutRegistry.prototype.removeKeyMapping=function(t,e,o){var i=this.keyMap_[t];if(!i&&!o)return console.warn('No keyboard shortcut with name "'+e+'" registered with key code "'+t+'"'),!1;var s=i.indexOf(e);if(-1<s)return i.splice(s,1),0==i.length&&delete this.keyMap_[t],!0;return o||console.warn('No keyboard shortcut with name "'+e+'" registered with key code "'+t+'"'),!1},T.ShortcutRegistry.prototype.removeAllKeyMappings=function(t){for(var e in this.keyMap_)this.removeKeyMapping(e,t,!0)},T.ShortcutRegistry.prototype.setKeyMap=function(t){this.keyMap_=t},T.ShortcutRegistry.prototype.getKeyMap=function(){return T.utils.object.deepMerge(Object.create(null),this.keyMap_)},T.ShortcutRegistry.prototype.getRegistry=function(){return T.utils.object.deepMerge(Object.create(null),this.registry_)},T.ShortcutRegistry.prototype.onKeyDown=function(t,e){var o=this.serializeKeyEvent_(e),o;if(!(o=this.getShortcutNamesByKeyCode(o)))return!1;for(var i=0,s;s=o[i];i++)if((!(s=this.registry_[s]).preconditionFn||s.preconditionFn(t))&&s.callback&&s.callback(t,e,s))return!0;return!1},T.ShortcutRegistry.prototype.getShortcutNamesByKeyCode=function(t){return this.keyMap_[t]||[]},T.ShortcutRegistry.prototype.getKeyCodesByShortcutName=function(t){var e=[],o;for(o in this.keyMap_)-1<this.keyMap_[o].indexOf(t)&&e.push(o);return e},T.ShortcutRegistry.prototype.serializeKeyEvent_=function(t){var e="",o;for(o in T.ShortcutRegistry.modifierKeys)t.getModifierState(o)&&(""!=e&&(e+="+"),e+=o);return""!=e&&t.keyCode?e=e+"+"+t.keyCode:t.keyCode&&(e=t.keyCode.toString()),e},T.ShortcutRegistry.prototype.checkModifiers_=function(t){for(var e=T.utils.object.values(T.ShortcutRegistry.modifierKeys),o=0,i;i=t[o];o++)if(e.indexOf(i)<0)throw Error(i+" is not a valid modifier key.")},T.ShortcutRegistry.prototype.createSerializedKey=function(t,e){var o="";if(e)for(var i in this.checkModifiers_(e),T.ShortcutRegistry.modifierKeys)-1<e.indexOf(T.ShortcutRegistry.modifierKeys[i])&&(""!=o&&(o+="+"),o+=i);return""!=o&&t?o=o+"+"+t:t&&(o=t.toString()),o},new T.ShortcutRegistry,T.VariableModel=function(t,e,o,i){this.workspace=t,this.name=e,this.type=o||"",this.id_=i||T.utils.genUid(),T.Events.fire(new(T.Events.get(T.Events.VAR_CREATE))(this))},T.VariableModel.prototype.getId=function(){return this.id_},T.VariableModel.compareByName=function(t,e){return(t=t.name.toLowerCase())<(e=e.name.toLowerCase())?-1:t==e?0:1},T.Variables={},T.Variables.NAME_TYPE=T.VARIABLE_CATEGORY_NAME,T.Variables.allUsedVarModels=function(t){var e=t.getAllBlocks(!1);t=Object.create(null);for(var o=0;o<e.length;o++){var i=e[o].getVarModels();if(i)for(var s=0;s<i.length;s++){var n=i[s],r=n.getId();r&&(t[r]=n)}}for(r in e=[],t)e.push(t[r]);return e},T.Variables.ALL_DEVELOPER_VARS_WARNINGS_BY_BLOCK_TYPE_={},T.Variables.allDeveloperVariables=function(t){t=t.getAllBlocks(!1);for(var e=Object.create(null),o=0,i;i=t[o];o++){var s=i.getDeveloperVariables;if(!s&&i.getDeveloperVars&&(s=i.getDeveloperVars,T.Variables.ALL_DEVELOPER_VARS_WARNINGS_BY_BLOCK_TYPE_[i.type]||(console.warn("Function getDeveloperVars() deprecated. Use getDeveloperVariables() (block type '"+i.type+"')"),T.Variables.ALL_DEVELOPER_VARS_WARNINGS_BY_BLOCK_TYPE_[i.type]=!0)),s)for(i=s(),s=0;s<i.length;s++)e[i[s]]=!0}return Object.keys(e)},T.Variables.flyoutCategory=function(t){var e=[],o=document.createElement("button");return o.setAttribute("text","%{BKY_NEW_VARIABLE}"),o.setAttribute("callbackKey","CREATE_VARIABLE"),t.registerButtonCallback("CREATE_VARIABLE",function(t){T.Variables.createVariableButtonHandler(t.getTargetWorkspace())}),e.push(o),t=T.Variables.flyoutCategoryBlocks(t),e=e.concat(t)},T.Variables.flyoutCategoryBlocks=function(t){var e=[];if(0<(t=t.getVariablesOfType("")).length){var o=t[t.length-1],i,s;if(T.Blocks.variables_set&&((i=T.utils.xml.createElement("block")).setAttribute("type","variables_set"),i.setAttribute("gap",T.Blocks.math_change?8:24),i.appendChild(T.Variables.generateVariableFieldDom(o)),e.push(i)),T.Blocks.math_change&&((i=T.utils.xml.createElement("block")).setAttribute("type","math_change"),i.setAttribute("gap",T.Blocks.variables_get?20:8),i.appendChild(T.Variables.generateVariableFieldDom(o)),o=T.Xml.textToDom('<value name="DELTA"><shadow type="math_number"><field name="NUM">1</field></shadow></value>'),i.appendChild(o),e.push(i)),T.Blocks.variables_get){t.sort(T.VariableModel.compareByName),o=0;for(;s=t[o];o++)(i=T.utils.xml.createElement("block")).setAttribute("type","variables_get"),i.setAttribute("gap",8),i.appendChild(T.Variables.generateVariableFieldDom(s)),e.push(i)}}return e},T.Variables.VAR_LETTER_OPTIONS="ijkmnopqrstuvwxyzabcdefgh",T.Variables.generateUniqueName=function(t){return T.Variables.generateUniqueNameFromOptions(T.Variables.VAR_LETTER_OPTIONS.charAt(0),t.getAllVariableNames())},T.Variables.generateUniqueNameFromOptions=function(t,e){if(!e.length)return t;for(var o=T.Variables.VAR_LETTER_OPTIONS,i="",s=o.indexOf(t);;){for(var n=!1,r=0;r<e.length;r++)if(e[r].toLowerCase()==t){n=!0;break}if(!n)return t;++s==o.length&&(s=0,i=Number(i)+1),t=o.charAt(s)+i}},T.Variables.createVariableButtonHandler=function(i,s,t){var n=t||"",r=function(t){var e=document.getElementById("StiDesigner"),o;e&&e.jsObject.options.standaloneJsMode?(e.jsObject.options.forms.createBlocklyVariableForm||e.jsObject.InitializeCreateBlocklyVariableForm()).show(function(t){var e,o,o;t?(e=T.Variables.nameUsedWithAnyType(t,i))?(o=e.type==n?T.Msg.VARIABLE_ALREADY_EXISTS.replace("%1",e.name):(o=T.Msg.VARIABLE_ALREADY_EXISTS_FOR_ANOTHER_TYPE).replace("%1",e.name).replace("%2",e.type),T.alert(o,function(){r(t)})):(i.createVariable(t,n),s&&s(t)):s&&s(null)}):T.Variables.promptName(T.Msg.NEW_VARIABLE_TITLE,t,function(t){var e,o,o;t?(e=T.Variables.nameUsedWithAnyType(t,i))?(o=e.type==n?T.Msg.VARIABLE_ALREADY_EXISTS.replace("%1",e.name):(o=T.Msg.VARIABLE_ALREADY_EXISTS_FOR_ANOTHER_TYPE).replace("%1",e.name).replace("%2",e.type),T.alert(o,function(){r(t)})):(i.createVariable(t,n),s&&s(t)):s&&s(null)})};r("")},T.Variables.createVariable=T.Variables.createVariableButtonHandler,T.Variables.renameVariable=function(o,i,s){var n=function(t){var e=T.Msg.RENAME_VARIABLE_TITLE.replace("%1",i.name);T.Variables.promptName(e,t,function(t){var e;t?(e=T.Variables.nameUsedWithOtherType_(t,i.type,o))?(e=T.Msg.VARIABLE_ALREADY_EXISTS_FOR_ANOTHER_TYPE.replace("%1",e.name).replace("%2",e.type),T.alert(e,function(){n(t)})):(o.renameVariableById(i.getId(),t),s&&s(t)):s&&s(null)})};n("")},T.Variables.promptName=function(t,e,o){T.prompt(t,e,function(t){!t||(t=t.replace(/[\s\xa0]+/g," ").trim())!=T.Msg.RENAME_VARIABLE&&t!=T.Msg.NEW_VARIABLE||(t=null),o(t)})},T.Variables.nameUsedWithOtherType_=function(t,e,o){o=o.getVariableMap().getAllVariables(),t=t.toLowerCase();for(var i=0,s;s=o[i];i++)if(s.name.toLowerCase()==t&&s.type!=e)return s;return null},T.Variables.nameUsedWithAnyType=function(t,e){e=e.getVariableMap().getAllVariables(),t=t.toLowerCase();for(var o=0,i;i=e[o];o++)if(i.name.toLowerCase()==t)return i;return null},T.Variables.generateVariableFieldDom=function(t){var e=T.utils.xml.createElement("field");return e.setAttribute("name","VAR"),e.setAttribute("id",t.getId()),e.setAttribute("variabletype",t.type),t=T.utils.xml.createTextNode(t.name),e.appendChild(t),e},T.Variables.getOrCreateVariablePackage=function(t,e,o,i){var s,s;return s=(s=T.Variables.getVariable(t,e,o,i))||T.Variables.createVariable_(t,e,o,i)},T.Variables.getVariable=function(t,e,o,i){var s=t.getPotentialVariableMap(),n=null;if(e&&(n=!(n=t.getVariableById(e))&&s?s.getVariableById(e):n))return n;if(o){if(null==i)throw Error("Tried to look up a variable by name without a type");!(n=t.getVariable(o,i))&&s&&(n=s.getVariable(o,i))}return n},T.Variables.createVariable_=function(t,e,o,i){var s=t.getPotentialVariableMap();return o=o||T.Variables.generateUniqueName(t.isFlyout?t.targetWorkspace:t),(s||t).createVariable(o,i,e)},T.Variables.getAddedVariables=function(t,e){t=t.getAllVariables();var o=[];if(e.length!=t.length)for(var i=0;i<t.length;i++){var s=t[i];-1==e.indexOf(s)&&o.push(s)}return o},T.VERSION="5.20210325.1",T.mainWorkspace=null,T.selected=null,T.draggingConnections=[],T.clipboardXml_=null,T.clipboardSource_=null,T.clipboardTypeCounts_=null,T.cache3dSupported_=null,T.parentContainer=null,T.svgSize=function(t){return T.utils.deprecation.warn("Blockly.svgSize","March 2021","March 2022","workspace.getCachedParentSvgSize"),new T.utils.Size(t.cachedWidth_,t.cachedHeight_)},T.resizeSvgContents=function(t){t.resizeContents()},T.svgResize=function(t){for(;t.options.parentWorkspace;)t=t.options.parentWorkspace;var e=t.getParentSvg(),o=t.getCachedParentSvgSize(),i=e.parentNode,s,i;i&&(s=i.offsetWidth,i=i.offsetHeight,o.width!=s&&(e.setAttribute("width",s+"px"),t.setCachedParentSvgSize(s,null)),o.height!=i&&(e.setAttribute("height",i+"px"),t.setCachedParentSvgSize(null,i)),t.resize())},T.onKeyDown=function(t){var e=T.mainWorkspace;e&&!(T.utils.isTargetInput(t)||e.rendered&&!e.isVisible())&&T.ShortcutRegistry.registry.onKeyDown(e,t)},T.deleteBlock=function(t){t.workspace.isFlyout||(T.Events.setGroup(!0),T.hideChaff(),t.dispose(!0,!0),T.Events.setGroup(!1))},T.copy=function(t){(t=t.toCopyData())&&(T.clipboardXml_=t.xml,T.clipboardSource_=t.source,T.clipboardTypeCounts_=t.typeCounts)},T.paste=function(){if(!T.clipboardXml_)return!1;var t=T.clipboardSource_;return t.isFlyout&&(t=t.targetWorkspace),!(!T.clipboardTypeCounts_||!t.isCapacityAvailable(T.clipboardTypeCounts_)||(T.Events.setGroup(!0),t.paste(T.clipboardXml_),T.Events.setGroup(!1),0))},T.duplicate=function(t){var e=T.clipboardXml_,o=T.clipboardSource_;T.copy(t),t.workspace.paste(T.clipboardXml_),T.clipboardXml_=e,T.clipboardSource_=o},T.onContextMenu_=function(t){T.utils.isTargetInput(t)||t.preventDefault()},T.hideChaff=function(t){T.Tooltip.hide(),T.WidgetDiv.hide(),T.DropDownDiv.hideWithoutAnimation(),t||((t=T.getMainWorkspace()).trashcan&&t.trashcan.flyout&&t.trashcan.closeFlyout(),(t=t.getToolbox())&&t.getFlyout()&&t.getFlyout().autoClose&&t.clearSelection())},T.getMainWorkspace=function(){return T.mainWorkspace},T.alert=function(t,e){alert(t),e&&e()},T.confirm=function(t,e){e(confirm(t))},T.prompt=function(t,e,o){o(prompt(t,e))},T.jsonInitFactory_=function(t){return function(){this.jsonInit(t)}},T.defineBlocksWithJsonArray=function(t){for(var e=0;e<t.length;e++){var o=t[e],i;o?null==(i=o.type)||""===i?console.warn("Block definition #"+e+" in JSON array is missing a type attribute. Skipping."):(T.Blocks[i]&&console.warn("Block definition #"+e+' in JSON array overwrites prior definition of "'+i+'".'),T.Blocks[i]={init:T.jsonInitFactory_(o)}):console.warn("Block definition #"+e+" in JSON array is "+o+". Skipping.")}},T.isNumber=function(t){return/^\s*-?\d+(\.\d+)?\s*$/.test(t)},T.hueToHex=function(t){return T.utils.colour.hsvToHex(t,T.HSV_SATURATION,255*T.HSV_VALUE)},T.checkBlockColourConstants=function(){T.checkBlockColourConstant_("LOGIC_HUE",["Blocks","logic","HUE"],void 0),T.checkBlockColourConstant_("LOGIC_HUE",["Constants","Logic","HUE"],210),T.checkBlockColourConstant_("LOOPS_HUE",["Blocks","loops","HUE"],void 0),T.checkBlockColourConstant_("LOOPS_HUE",["Constants","Loops","HUE"],120),T.checkBlockColourConstant_("MATH_HUE",["Blocks","math","HUE"],void 0),T.checkBlockColourConstant_("MATH_HUE",["Constants","Math","HUE"],230),T.checkBlockColourConstant_("TEXTS_HUE",["Blocks","texts","HUE"],void 0),T.checkBlockColourConstant_("TEXTS_HUE",["Constants","Text","HUE"],160),T.checkBlockColourConstant_("LISTS_HUE",["Blocks","lists","HUE"],void 0),T.checkBlockColourConstant_("LISTS_HUE",["Constants","Lists","HUE"],260),T.checkBlockColourConstant_("COLOUR_HUE",["Blocks","colour","HUE"],void 0),T.checkBlockColourConstant_("COLOUR_HUE",["Constants","Colour","HUE"],20),T.checkBlockColourConstant_("VARIABLES_HUE",["Blocks","variables","HUE"],void 0),T.checkBlockColourConstant_("VARIABLES_HUE",["Constants","Variables","HUE"],330),T.checkBlockColourConstant_("VARIABLES_DYNAMIC_HUE",["Constants","VariablesDynamic","HUE"],310),T.checkBlockColourConstant_("PROCEDURES_HUE",["Blocks","procedures","HUE"],void 0)},T.checkBlockColourConstant_=function(t,e,o){for(var i="Blockly",s=T,n=0;n<e.length;++n)i+="."+e[n],s=s&&s[e[n]];s&&s!==o&&(t=(void 0===o?'%1 has been removed. Use Blockly.Msg["%2"].':'%1 is deprecated and unused. Override Blockly.Msg["%2"].').replace("%1",i).replace("%2",t),console.warn(t))},T.setParentContainer=function(t){T.parentContainer=t},T.bindEvent_=T.browserEvents.bind,T.unbindEvent_=T.browserEvents.unbind,T.bindEventWithChecks_=T.browserEvents.conditionalBind,T.ALIGN_LEFT=T.constants.ALIGN.LEFT,T.ALIGN_CENTRE=T.constants.ALIGN.CENTRE,T.ALIGN_RIGHT=T.constants.ALIGN.RIGHT,T.INPUT_VALUE=T.connectionTypes.INPUT_VALUE,T.OUTPUT_VALUE=T.connectionTypes.OUTPUT_VALUE,T.NEXT_STATEMENT=T.connectionTypes.NEXT_STATEMENT,T.PREVIOUS_STATEMENT=T.connectionTypes.PREVIOUS_STATEMENT,T.DUMMY_INPUT=T.inputTypes.DUMMY,T.TOOLBOX_AT_TOP=T.utils.toolbox.Position.TOP,T.TOOLBOX_AT_BOTTOM=T.utils.toolbox.Position.BOTTOM,T.TOOLBOX_AT_LEFT=T.utils.toolbox.Position.LEFT,T.TOOLBOX_AT_RIGHT=T.utils.toolbox.Position.RIGHT,T.Events.BubbleOpen=function(t,e,o){T.Events.BubbleOpen.superClass_.constructor.call(this,t?t.workspace.id:void 0),this.blockId=t?t.id:null,this.isOpen=e,this.bubbleType=o},T.utils.object.inherits(T.Events.BubbleOpen,T.Events.UiBase),T.Events.BubbleOpen.prototype.type=T.Events.BUBBLE_OPEN,T.Events.BubbleOpen.prototype.toJson=function(){var t=T.Events.BubbleOpen.superClass_.toJson.call(this);return t.isOpen=this.isOpen,t.bubbleType=this.bubbleType,t.blockId=this.blockId,t},T.Events.BubbleOpen.prototype.fromJson=function(t){T.Events.BubbleOpen.superClass_.fromJson.call(this,t),this.isOpen=t.isOpen,this.bubbleType=t.bubbleType,this.blockId=t.blockId},T.registry.register(T.registry.Type.EVENT,T.Events.BUBBLE_OPEN,T.Events.BubbleOpen),T.Icon=function(t){this.block_=t,this.iconGroup_=null},T.Icon.prototype.collapseHidden=!0,T.Icon.prototype.SIZE=17,T.Icon.prototype.bubble_=null,T.Icon.prototype.iconXY_=null,T.Icon.prototype.createIcon=function(){this.iconGroup_||(this.iconGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:"blocklyIconGroup"},null),this.block_.isInFlyout&&T.utils.dom.addClass(this.iconGroup_,"blocklyIconGroupReadonly"),this.drawIcon_(this.iconGroup_),this.block_.getSvgRoot().appendChild(this.iconGroup_),T.browserEvents.conditionalBind(this.iconGroup_,"mouseup",this,this.iconClick_),this.updateEditable())},T.Icon.prototype.dispose=function(){T.utils.dom.removeNode(this.iconGroup_),this.iconGroup_=null,this.setVisible(!1),this.block_=null},T.Icon.prototype.updateEditable=function(){},T.Icon.prototype.isVisible=function(){return!!this.bubble_},T.Icon.prototype.iconClick_=function(t){this.block_.workspace.isDragging()||this.block_.isInFlyout||T.utils.isRightButton(t)||this.setVisible(!this.isVisible())},T.Icon.prototype.applyColour=function(){this.isVisible()&&this.bubble_.setColour(this.block_.style.colourPrimary)},T.Icon.prototype.setIconLocation=function(t){this.iconXY_=t,this.isVisible()&&this.bubble_.setAnchorLocation(t)},T.Icon.prototype.computeIconLocation=function(){var t=this.block_.getRelativeToSurfaceXY(),e=T.utils.getRelativeXY(this.iconGroup_),t=new T.utils.Coordinate(t.x+e.x+this.SIZE/2,t.y+e.y+this.SIZE/2);T.utils.Coordinate.equals(this.getIconLocation(),t)||this.setIconLocation(t)},T.Icon.prototype.getIconLocation=function(){return this.iconXY_},T.Icon.prototype.getCorrectedSize=function(){return new T.utils.Size(T.Icon.prototype.SIZE,T.Icon.prototype.SIZE-2)},T.Warning=function(t){T.Warning.superClass_.constructor.call(this,t),this.createIcon(),this.text_={}},T.utils.object.inherits(T.Warning,T.Icon),T.Warning.prototype.collapseHidden=!1,T.Warning.prototype.drawIcon_=function(t){T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyIconShape",d:"M2,15Q-1,15 0.5,12L6.5,1.7Q8,-1 9.5,1.7L15.5,12Q17,15 14,15z"},t),T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyIconSymbol",d:"m7,4.8v3.16l0.27,2.27h1.46l0.27,-2.27v-3.16z"},t),T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blocklyIconSymbol",x:"7",y:"11",height:"2",width:"2"},t)},T.Warning.prototype.setVisible=function(t){t!=this.isVisible()&&(T.Events.fire(new(T.Events.get(T.Events.BUBBLE_OPEN))(this.block_,t,"warning")),t?this.createBubble_():this.disposeBubble_())},T.Warning.prototype.createBubble_=function(){this.paragraphElement_=T.Bubble.textToDom(this.getText()),this.bubble_=T.Bubble.createNonEditableBubble(this.paragraphElement_,this.block_,this.iconXY_),this.applyColour()},T.Warning.prototype.disposeBubble_=function(){this.bubble_.dispose(),this.paragraphElement_=this.bubble_=null},T.Warning.prototype.setText=function(t,e){this.text_[e]!=t&&(t?this.text_[e]=t:delete this.text_[e],this.isVisible())&&(this.setVisible(!1),this.setVisible(!0))},T.Warning.prototype.getText=function(){var t=[],e;for(e in this.text_)t.push(this.text_[e]);return t.join("\n")},T.Warning.prototype.dispose=function(){this.block_.warning=null,T.Icon.prototype.dispose.call(this)},T.Comment=function(t){T.Comment.superClass_.constructor.call(this,t),this.model_=t.commentModel,this.model_.text=this.model_.text||"",this.cachedText_="",this.onInputWrapper_=this.onChangeWrapper_=this.onWheelWrapper_=this.onMouseUpWrapper_=null,this.createIcon()},T.utils.object.inherits(T.Comment,T.Icon),T.Comment.prototype.drawIcon_=function(t){T.utils.dom.createSvgElement(T.utils.Svg.CIRCLE,{class:"blocklyIconShape",r:"8",cx:"8",cy:"8"},t),T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyIconSymbol",d:"m6.8,10h2c0.003,-0.617 0.271,-0.962 0.633,-1.266 2.875,-2.4050.607,-5.534 -3.765,-3.874v1.7c3.12,-1.657 3.698,0.118 2.336,1.25-1.201,0.998 -1.201,1.528 -1.204,2.19z"},t),T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blocklyIconSymbol",x:"6.8",y:"10.78",height:"2",width:"2"},t)},T.Comment.prototype.createEditor_=function(){this.foreignObject_=T.utils.dom.createSvgElement(T.utils.Svg.FOREIGNOBJECT,{x:T.Bubble.BORDER_WIDTH,y:T.Bubble.BORDER_WIDTH},null);var t=document.createElementNS(T.utils.dom.HTML_NS,"body"),e=(t.setAttribute("xmlns",T.utils.dom.HTML_NS),t.className="blocklyMinimalBody",this.textarea_=document.createElementNS(T.utils.dom.HTML_NS,"textarea"));return e.className="blocklyCommentTextarea",e.setAttribute("dir",this.block_.RTL?"RTL":"LTR"),e.value=this.model_.text,this.resizeTextarea_(),t.appendChild(e),this.foreignObject_.appendChild(t),this.onMouseUpWrapper_=T.browserEvents.conditionalBind(e,"mouseup",this,this.startEdit_,!0,!0),this.onWheelWrapper_=T.browserEvents.conditionalBind(e,"wheel",this,function(t){t.stopPropagation()}),this.onChangeWrapper_=T.browserEvents.conditionalBind(e,"change",this,function(t){this.cachedText_!=this.model_.text&&T.Events.fire(new(T.Events.get(T.Events.BLOCK_CHANGE))(this.block_,"comment",null,this.cachedText_,this.model_.text))}),this.onInputWrapper_=T.browserEvents.conditionalBind(e,"input",this,function(t){this.model_.text=e.value}),setTimeout(e.focus.bind(e),0),this.foreignObject_},T.Comment.prototype.updateEditable=function(){T.Comment.superClass_.updateEditable.call(this),this.isVisible()&&(this.disposeBubble_(),this.createBubble_())},T.Comment.prototype.onBubbleResize_=function(){this.isVisible()&&(this.model_.size=this.bubble_.getBubbleSize(),this.resizeTextarea_())},T.Comment.prototype.resizeTextarea_=function(){var t=this.model_.size,e=2*T.Bubble.BORDER_WIDTH,o=t.width-e,t=t.height-e;this.foreignObject_.setAttribute("width",o),this.foreignObject_.setAttribute("height",t),this.textarea_.style.width=o-4+"px",this.textarea_.style.height=t-4+"px"},T.Comment.prototype.setVisible=function(t){t!=this.isVisible()&&(T.Events.fire(new(T.Events.get(T.Events.BUBBLE_OPEN))(this.block_,t,"comment")),(this.model_.pinned=t)?this.createBubble_():this.disposeBubble_())},T.Comment.prototype.createBubble_=function(){!this.block_.isEditable()||T.utils.userAgent.IE?this.createNonEditableBubble_():this.createEditableBubble_()},T.Comment.prototype.createEditableBubble_=function(){this.bubble_=new T.Bubble(this.block_.workspace,this.createEditor_(),this.block_.pathObject.svgPath,this.iconXY_,this.model_.size.width,this.model_.size.height),this.bubble_.setSvgId(this.block_.id),this.bubble_.registerResizeEvent(this.onBubbleResize_.bind(this)),this.applyColour()},T.Comment.prototype.createNonEditableBubble_=function(){this.paragraphElement_=T.Bubble.textToDom(this.block_.getCommentText()),this.bubble_=T.Bubble.createNonEditableBubble(this.paragraphElement_,this.block_,this.iconXY_),this.applyColour()},T.Comment.prototype.disposeBubble_=function(){this.onMouseUpWrapper_&&(T.browserEvents.unbind(this.onMouseUpWrapper_),this.onMouseUpWrapper_=null),this.onWheelWrapper_&&(T.browserEvents.unbind(this.onWheelWrapper_),this.onWheelWrapper_=null),this.onChangeWrapper_&&(T.browserEvents.unbind(this.onChangeWrapper_),this.onChangeWrapper_=null),this.onInputWrapper_&&(T.browserEvents.unbind(this.onInputWrapper_),this.onInputWrapper_=null),this.bubble_.dispose(),this.paragraphElement_=this.foreignObject_=this.textarea_=this.bubble_=null},T.Comment.prototype.startEdit_=function(t){this.bubble_.promote()&&this.textarea_.focus(),this.cachedText_=this.model_.text},T.Comment.prototype.getBubbleSize=function(){return this.model_.size},T.Comment.prototype.setBubbleSize=function(t,e){this.bubble_?this.bubble_.setBubbleSize(t,e):(this.model_.size.width=t,this.model_.size.height=e)},T.Comment.prototype.updateText=function(){this.textarea_?this.textarea_.value=this.model_.text:this.paragraphElement_&&(this.paragraphElement_.firstChild.textContent=this.model_.text)},T.Comment.prototype.dispose=function(){this.block_.comment=null,T.Icon.prototype.dispose.call(this)},T.Css.register(".blocklyCommentTextarea {,background-color: #fef49c;,border: 0;,outline: 0;,margin: 0;,padding: 3px;,resize: none;,display: block;,text-overflow: hidden;,}".split(",")),T.Flyout=function(t){t.setMetrics=this.setMetrics_.bind(this),this.workspace_=new T.WorkspaceSvg(t),this.workspace_.setMetricsManager(new T.FlyoutMetricsManager(this.workspace_,this)),this.workspace_.isFlyout=!0,this.workspace_.setVisible(this.isVisible_),this.RTL=!!t.RTL,this.horizontalLayout=!1,this.toolboxPosition_=t.toolboxPosition,this.eventWrappers_=[],this.mats_=[],this.buttons_=[],this.listeners_=[],this.permanentlyDisabled_=[],this.tabWidth_=this.workspace_.getRenderer().getConstants().TAB_WIDTH,this.targetWorkspace=null},T.Flyout.prototype.autoClose=!0,T.Flyout.prototype.isVisible_=!1,T.Flyout.prototype.containerVisible_=!0,T.Flyout.prototype.CORNER_RADIUS=8,T.Flyout.prototype.MARGIN=T.Flyout.prototype.CORNER_RADIUS,T.Flyout.prototype.GAP_X=3*T.Flyout.prototype.MARGIN,T.Flyout.prototype.GAP_Y=3*T.Flyout.prototype.MARGIN,T.Flyout.prototype.SCROLLBAR_PADDING=2,T.Flyout.prototype.width_=0,T.Flyout.prototype.height_=0,T.Flyout.prototype.dragAngleRange_=70,T.Flyout.prototype.createDom=function(t){return this.svgGroup_=T.utils.dom.createSvgElement(t,{class:"blocklyFlyout",style:"display: none"},null),this.svgBackground_=T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyFlyoutBackground"},this.svgGroup_),this.svgGroup_.appendChild(this.workspace_.createDom()),this.workspace_.getThemeManager().subscribe(this.svgBackground_,"flyoutBackgroundColour","fill"),this.workspace_.getThemeManager().subscribe(this.svgBackground_,"flyoutOpacity","fill-opacity"),this.svgGroup_},T.Flyout.prototype.init=function(t){this.targetWorkspace=t,this.workspace_.targetWorkspace=t,this.workspace_.scrollbar=new T.ScrollbarPair(this.workspace_,this.horizontalLayout,!this.horizontalLayout,"blocklyFlyoutScrollbar"),this.hide(),Array.prototype.push.apply(this.eventWrappers_,T.browserEvents.conditionalBind(this.svgGroup_,"wheel",this,this.wheel_)),this.autoClose||(this.filterWrapper_=this.filterForCapacity_.bind(this),this.targetWorkspace.addChangeListener(this.filterWrapper_)),Array.prototype.push.apply(this.eventWrappers_,T.browserEvents.conditionalBind(this.svgBackground_,"mousedown",this,this.onMouseDown_)),this.workspace_.getGesture=this.targetWorkspace.getGesture.bind(this.targetWorkspace),this.workspace_.setVariableMap(this.targetWorkspace.getVariableMap()),this.workspace_.createPotentialVariableMap()},T.Flyout.prototype.dispose=function(){this.hide(),T.browserEvents.unbind(this.eventWrappers_),this.filterWrapper_&&(this.targetWorkspace.removeChangeListener(this.filterWrapper_),this.filterWrapper_=null),this.workspace_&&(this.workspace_.getThemeManager().unsubscribe(this.svgBackground_),this.workspace_.targetWorkspace=null,this.workspace_.dispose(),this.workspace_=null),this.svgGroup_&&(T.utils.dom.removeNode(this.svgGroup_),this.svgGroup_=null),this.targetWorkspace=this.svgBackground_=null},T.Flyout.prototype.getWidth=function(){return this.width_},T.Flyout.prototype.getHeight=function(){return this.height_},T.Flyout.prototype.getFlyoutScale=function(){return this.targetWorkspace.scale},T.Flyout.prototype.getWorkspace=function(){return this.workspace_},T.Flyout.prototype.isVisible=function(){return this.isVisible_},T.Flyout.prototype.setVisible=function(t){var e=t!=this.isVisible();this.isVisible_=t,e&&this.updateDisplay_()},T.Flyout.prototype.setContainerVisible=function(t){var e=t!=this.containerVisible_;this.containerVisible_=t,e&&this.updateDisplay_()},T.Flyout.prototype.updateDisplay_=function(){var t=!!this.containerVisible_&&this.isVisible();this.svgGroup_.style.display=t?"block":"none",this.workspace_.scrollbar.setContainerVisible(t)},T.Flyout.prototype.positionAt_=function(t,e,o,i){this.svgGroup_.setAttribute("width",t),this.svgGroup_.setAttribute("height",e),this.workspace_.setCachedParentSvgSize(t,e),"svg"==this.svgGroup_.tagName?T.utils.dom.setCssTransform(this.svgGroup_,"translate("+o+"px,"+i+"px)"):this.svgGroup_.setAttribute("transform","translate("+o+","+i+")"),(t=this.workspace_.scrollbar)&&(t.setOrigin(o,i),t.resize(),t.hScroll&&t.hScroll.setPosition(t.hScroll.position.x,t.hScroll.position.y),t.vScroll)&&t.vScroll.setPosition(t.vScroll.position.x,t.vScroll.position.y)},T.Flyout.prototype.hide=function(){if(this.isVisible()){this.setVisible(!1);for(var t=0,e;e=this.listeners_[t];t++)T.browserEvents.unbind(e);this.listeners_.length=0,this.reflowWrapper_&&(this.workspace_.removeChangeListener(this.reflowWrapper_),this.reflowWrapper_=null)}},T.Flyout.prototype.show=function(t){this.workspace_.setResizesEnabled(!1),this.hide(),this.clearOldBlocks_(),"string"==typeof t&&(t=this.getDynamicCategoryContents_(t)),this.setVisible(!0),t=T.utils.toolbox.convertFlyoutDefToJsonArray(t),t=this.createFlyoutInfo_(t),this.layout_(t.contents,t.gaps),this.listeners_.push(T.browserEvents.conditionalBind(this.svgBackground_,"mouseover",this,function(){for(var t=this.workspace_.getTopBlocks(!1),e=0,o;o=t[e];e++)o.removeSelect()})),this.horizontalLayout?this.height_=0:this.width_=0,this.workspace_.setResizesEnabled(!0),this.reflow(),this.filterForCapacity_(),this.position(),this.reflowWrapper_=this.reflow.bind(this),this.workspace_.addChangeListener(this.reflowWrapper_)},T.Flyout.prototype.createFlyoutInfo_=function(t){var e=[],o=[];this.permanentlyDisabled_.length=0;for(var i=this.horizontalLayout?this.GAP_X:this.GAP_Y,s=0,n;n=t[s];s++)switch(n.custom&&(n=this.getDynamicCategoryContents_(n.custom),n=T.utils.toolbox.convertFlyoutDefToJsonArray(n),t.splice.apply(t,[s,1].concat(n)),n=t[s]),n.kind.toUpperCase()){case"BLOCK":var r=n,l=this.getBlockXml_(r),n=this.createBlock_(l),r=parseInt(r.gap||l.getAttribute("gap"),10);o.push(isNaN(r)?i:r),e.push({type:"block",block:n});break;case"SEP":this.addSeparatorGap_(n,o,i);break;case"LABEL":n=this.createButton_(n,!0),e.push({type:"button",button:n}),o.push(i);break;case"BUTTON":n=this.createButton_(n,!1),e.push({type:"button",button:n}),o.push(i)}return{contents:e,gaps:o}},T.Flyout.prototype.getDynamicCategoryContents_=function(t){if("function"!=typeof(t=this.workspace_.targetWorkspace.getToolboxCategoryCallback(t)))throw TypeError("Couldn't find a callback function when opening a toolbox category.");if(t=t(this.workspace_.targetWorkspace),!Array.isArray(t))throw new TypeError("Result of toolbox category callback must be an array.");return t},T.Flyout.prototype.createButton_=function(t,e){if(!T.FlyoutButton)throw Error("Missing require for Blockly.FlyoutButton");return new T.FlyoutButton(this.workspace_,this.targetWorkspace,t,e)},T.Flyout.prototype.createBlock_=function(t){return(t=T.Xml.domToBlock(t,this.workspace_)).isEnabled()||this.permanentlyDisabled_.push(t),t},T.Flyout.prototype.getBlockXml_=function(t){var e=null,o=t.blockxml;if(o&&"string"!=typeof o?e=o:o&&"string"==typeof o?(e=T.Xml.textToDom(o),t.blockxml=e):t.type&&((e=T.utils.xml.createElement("xml")).setAttribute("type",t.type),e.setAttribute("disabled",t.disabled),t.blockxml=e),!e)throw Error("Error: Invalid block definition. Block definition must have blockxml or type.");return e},T.Flyout.prototype.addSeparatorGap_=function(t,e,o){t=parseInt(t.gap,10),!isNaN(t)&&0<e.length?e[e.length-1]=t:e.push(o)},T.Flyout.prototype.clearOldBlocks_=function(){for(var t=this.workspace_.getTopBlocks(!1),e=0,o;o=t[e];e++)o.workspace==this.workspace_&&o.dispose(!1,!1);for(e=0;e<this.mats_.length;e++)(t=this.mats_[e])&&(T.Tooltip.unbindMouseEvents(t),T.utils.dom.removeNode(t));for(e=this.mats_.length=0;t=this.buttons_[e];e++)t.dispose();this.buttons_.length=0,this.workspace_.getPotentialVariableMap().clear()},T.Flyout.prototype.addBlockListeners_=function(t,e,o){this.listeners_.push(T.browserEvents.conditionalBind(t,"mousedown",null,this.blockMouseDown_(e))),this.listeners_.push(T.browserEvents.conditionalBind(o,"mousedown",null,this.blockMouseDown_(e))),this.listeners_.push(T.browserEvents.bind(t,"mouseenter",e,e.addSelect)),this.listeners_.push(T.browserEvents.bind(t,"mouseleave",e,e.removeSelect)),this.listeners_.push(T.browserEvents.bind(o,"mouseenter",e,e.addSelect)),this.listeners_.push(T.browserEvents.bind(o,"mouseleave",e,e.removeSelect))},T.Flyout.prototype.blockMouseDown_=function(o){var i=this;return function(t){var e=i.targetWorkspace.getGesture(t);e&&(e.setStartBlock(o),e.handleFlyoutStart(t,i))}},T.Flyout.prototype.onMouseDown_=function(t){var e=this.targetWorkspace.getGesture(t);e&&e.handleFlyoutStart(t,this)},T.Flyout.prototype.isBlockCreatable_=function(t){return t.isEnabled()},T.Flyout.prototype.createBlock=function(t){var e=null,o=(T.Events.disable(),this.targetWorkspace.getAllVariables());this.targetWorkspace.setResizesEnabled(!1);try{e=this.placeNewBlock_(t)}finally{T.Events.enable()}if(T.hideChaff(),t=T.Variables.getAddedVariables(this.targetWorkspace,o),T.Events.isEnabled()){for(T.Events.setGroup(!0),o=0;o<t.length;o++){var i=t[o];T.Events.fire(new(T.Events.get(T.Events.VAR_CREATE))(i))}T.Events.fire(new(T.Events.get(T.Events.BLOCK_CREATE))(e))}return this.autoClose?this.hide():this.filterForCapacity_(),e},T.Flyout.prototype.initFlyoutButton_=function(t,e,o){var i=t.createDom();t.moveTo(e,o),t.show(),this.listeners_.push(T.browserEvents.conditionalBind(i,"mousedown",this,this.onMouseDown_)),this.buttons_.push(t)},T.Flyout.prototype.createRect_=function(t,e,o,i,s){return(e=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{"fill-opacity":0,x:e,y:o,height:i.height,width:i.width},null)).tooltip=t,T.Tooltip.bindMouseEvents(e),this.workspace_.getCanvas().insertBefore(e,t.getSvgRoot()),t.flyoutRect_=e,this.mats_[s]=e},T.Flyout.prototype.moveRectToBlock_=function(t,e){var o=e.getHeightWidth();t.setAttribute("width",o.width),t.setAttribute("height",o.height),e=e.getRelativeToSurfaceXY(),t.setAttribute("y",e.y),t.setAttribute("x",this.RTL?e.x-o.width:e.x)},T.Flyout.prototype.filterForCapacity_=function(){for(var t=this.workspace_.getTopBlocks(!1),e=0,o;o=t[e];e++)if(-1==this.permanentlyDisabled_.indexOf(o))for(var i=this.targetWorkspace.isCapacityAvailable(T.utils.getBlockTypeCounts(o));o;)o.setEnabled(i),o=o.getNextBlock()},T.Flyout.prototype.reflow=function(){this.reflowWrapper_&&this.workspace_.removeChangeListener(this.reflowWrapper_),this.reflowInternal_(),this.reflowWrapper_&&this.workspace_.addChangeListener(this.reflowWrapper_)},T.Flyout.prototype.isScrollable=function(){return!!this.workspace_.scrollbar&&this.workspace_.scrollbar.isVisible()},T.Flyout.prototype.placeNewBlock_=function(t){var e=this.targetWorkspace;if(!t.getSvgRoot())throw Error("oldBlock is not rendered.");var o=T.Xml.blockToDom(t,!0);if(e.setResizesEnabled(!1),!(o=T.Xml.domToBlock(o,e)).getSvgRoot())throw Error("block is not rendered.");var i=e.getOriginOffsetInPixels(),s=this.workspace_.getOriginOffsetInPixels();return(t=t.getRelativeToSurfaceXY()).scale(this.workspace_.scale),t=T.utils.Coordinate.sum(s,t),(i=T.utils.Coordinate.difference(t,i)).scale(1/e.scale),o.moveBy(i.x,i.y),o},T.HorizontalFlyout=function(t){T.HorizontalFlyout.superClass_.constructor.call(this,t),this.horizontalLayout=!0},T.utils.object.inherits(T.HorizontalFlyout,T.Flyout),T.HorizontalFlyout.prototype.setMetrics_=function(t){var e,o,i,e;this.isVisible()&&(o=(e=this.workspace_.getMetricsManager()).getScrollMetrics(),i=e.getViewMetrics(),e=e.getAbsoluteMetrics(),"number"==typeof t.x&&(this.workspace_.scrollX=-(o.left+(o.width-i.width)*t.x)),this.workspace_.translate(this.workspace_.scrollX+e.left,this.workspace_.scrollY+e.top))},T.HorizontalFlyout.prototype.getX=function(){return 0},T.HorizontalFlyout.prototype.getY=function(){if(!this.isVisible())return 0;var t,e=(t=this.targetWorkspace.getMetricsManager()).getAbsoluteMetrics(),o=t.getViewMetrics(),t=t.getToolboxMetrics(),i=this.toolboxPosition_==T.utils.toolbox.Position.TOP;return this.targetWorkspace.toolboxPosition==this.toolboxPosition_?this.targetWorkspace.getToolbox()?i?t.height:o.height-this.height_:i?0:o.height:i?0:o.height+e.top-this.height_},T.HorizontalFlyout.prototype.position=function(){var t,e;this.isVisible()&&this.targetWorkspace.isVisible()&&(t=this.targetWorkspace.getMetricsManager().getViewMetrics(),this.width_=t.width,this.setBackgroundPath_(t.width-2*this.CORNER_RADIUS,this.height_-this.CORNER_RADIUS),t=this.getX(),e=this.getY(),this.positionAt_(this.width_,this.height_,t,e))},T.HorizontalFlyout.prototype.setBackgroundPath_=function(t,e){var o=this.toolboxPosition_==T.utils.toolbox.Position.TOP,i=["M 0,"+(o?0:this.CORNER_RADIUS)];o?(i.push("h",t+2*this.CORNER_RADIUS),i.push("v",e),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,1,-this.CORNER_RADIUS,this.CORNER_RADIUS),i.push("h",-t),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,1,-this.CORNER_RADIUS,-this.CORNER_RADIUS)):(i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,1,this.CORNER_RADIUS,-this.CORNER_RADIUS),i.push("h",t),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,1,this.CORNER_RADIUS,this.CORNER_RADIUS),i.push("v",e),i.push("h",-t-2*this.CORNER_RADIUS)),i.push("z"),this.svgBackground_.setAttribute("d",i.join(" "))},T.HorizontalFlyout.prototype.scrollToStart=function(){this.workspace_.scrollbar.setX(this.RTL?1/0:0)},T.HorizontalFlyout.prototype.wheel_=function(t){var e=T.utils.getScrollDeltaPixels(t),o,i,e;(e=e.x||e.y)&&(i=(o=this.workspace_.getMetricsManager()).getScrollMetrics(),e=o.getViewMetrics().left-i.left+e,this.workspace_.scrollbar.setX(e),T.WidgetDiv.hide(),T.DropDownDiv.hideWithoutAnimation()),t.preventDefault(),t.stopPropagation()},T.HorizontalFlyout.prototype.layout_=function(t,e){this.workspace_.scale=this.targetWorkspace.scale;var o=this.MARGIN,i=o+this.tabWidth_;this.RTL&&(t=t.reverse());for(var s=0,n;n=t[s];s++)if("block"==n.type){for(var n,r=(n=n.block).getDescendants(!1),l=0,a;a=r[l];l++)a.isInFlyout=!0;n.render(),r=n.getSvgRoot(),l=n.getHeightWidth(),a=n.outputConnection?this.tabWidth_:0,a=this.RTL?i+l.width:i-a,n.moveBy(a,o),a=this.createRect_(n,a,o,l,s),i+=l.width+e[s],this.addBlockListeners_(r,n,a)}else"button"==n.type&&(this.initFlyoutButton_(n.button,i,o),i+=n.button.width+e[s])},T.HorizontalFlyout.prototype.isDragTowardWorkspace=function(t){t=Math.atan2(t.y,t.x)/Math.PI*180;var e=this.dragAngleRange_;return t<90+e&&90-e<t||-90-e<t&&t<-90+e},T.HorizontalFlyout.prototype.getClientRect=function(){if(!this.svgGroup_)return null;var t=this.svgGroup_.getBoundingClientRect(),e=t.top;return this.toolboxPosition_==T.utils.toolbox.Position.TOP?new T.utils.Rect(-1e9,e+t.height,-1e9,1e9):new T.utils.Rect(e,1e9,-1e9,1e9)},T.HorizontalFlyout.prototype.reflowInternal_=function(){this.workspace_.scale=this.getFlyoutScale();for(var t=0,e=this.workspace_.getTopBlocks(!1),o=0,i;i=e[o];o++)t=Math.max(t,i.getHeightWidth().height);if(t=(t=(t+=1.5*this.MARGIN)*this.workspace_.scale)+T.Scrollbar.scrollbarThickness,this.height_!=t){for(o=0;i=e[o];o++)i.flyoutRect_&&this.moveRectToBlock_(i.flyoutRect_,i);this.targetWorkspace.toolboxPosition!=this.toolboxPosition_||this.toolboxPosition_!=T.utils.toolbox.Position.TOP||this.targetWorkspace.getToolbox()||this.targetWorkspace.translate(this.targetWorkspace.scrollX,this.targetWorkspace.scrollY+t),this.height_=t,this.position()}},T.registry.register(T.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX,T.registry.DEFAULT,T.HorizontalFlyout),T.VerticalFlyout=function(t){T.VerticalFlyout.superClass_.constructor.call(this,t)},T.utils.object.inherits(T.VerticalFlyout,T.Flyout),T.VerticalFlyout.registryName="verticalFlyout",T.VerticalFlyout.prototype.setMetrics_=function(t){var e,o,i,e;this.isVisible()&&(o=(e=this.workspace_.getMetricsManager()).getScrollMetrics(),i=e.getViewMetrics(),e=e.getAbsoluteMetrics(),"number"==typeof t.y&&(this.workspace_.scrollY=-(o.top+(o.height-i.height)*t.y)),this.workspace_.translate(this.workspace_.scrollX+e.left,this.workspace_.scrollY+e.top))},T.VerticalFlyout.prototype.getX=function(){if(!this.isVisible())return 0;var t,e=(t=this.targetWorkspace.getMetricsManager()).getAbsoluteMetrics(),o=t.getViewMetrics(),t=t.getToolboxMetrics();return this.targetWorkspace.toolboxPosition==this.toolboxPosition_?this.targetWorkspace.getToolbox()?this.toolboxPosition_==T.utils.toolbox.Position.LEFT?t.width:o.width-this.width_:this.toolboxPosition_==T.utils.toolbox.Position.LEFT?0:o.width:this.toolboxPosition_==T.utils.toolbox.Position.LEFT?0:o.width+e.left-this.width_},T.VerticalFlyout.prototype.getY=function(){return 0},T.VerticalFlyout.prototype.position=function(){var t,e;this.isVisible()&&this.targetWorkspace.isVisible()&&(t=this.targetWorkspace.getMetricsManager().getViewMetrics(),this.height_=t.height,this.setBackgroundPath_(this.width_-this.CORNER_RADIUS,t.height-2*this.CORNER_RADIUS),t=this.getX(),e=this.getY(),this.positionAt_(this.width_,this.height_,t,e))},T.VerticalFlyout.prototype.setBackgroundPath_=function(t,e){var o=this.toolboxPosition_==T.utils.toolbox.Position.RIGHT,i=t+this.CORNER_RADIUS,i;(i=["M "+(o?i:0)+",0"]).push("h",o?-t:t),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,o?0:1,o?-this.CORNER_RADIUS:this.CORNER_RADIUS,this.CORNER_RADIUS),i.push("v",Math.max(0,e)),i.push("a",this.CORNER_RADIUS,this.CORNER_RADIUS,0,0,o?0:1,o?this.CORNER_RADIUS:-this.CORNER_RADIUS,this.CORNER_RADIUS),i.push("h",o?t:-t),i.push("z"),this.svgBackground_.setAttribute("d",i.join(" "))},T.VerticalFlyout.prototype.scrollToStart=function(){this.workspace_.scrollbar.setY(0)},T.VerticalFlyout.prototype.wheel_=function(t){var e=T.utils.getScrollDeltaPixels(t),o,i,e;e.y&&(i=(o=this.workspace_.getMetricsManager()).getScrollMetrics(),e=o.getViewMetrics().top-i.top+e.y,this.workspace_.scrollbar.setY(e),T.WidgetDiv.hide(),T.DropDownDiv.hideWithoutAnimation()),t.preventDefault(),t.stopPropagation()},T.VerticalFlyout.prototype.layout_=function(t,e){this.workspace_.scale=this.targetWorkspace.scale;for(var o=this.MARGIN,i=this.RTL?o:o+this.tabWidth_,s=0,n;n=t[s];s++)if("block"==n.type){for(var n,r=(n=n.block).getDescendants(!1),l=0,a;a=r[l];l++)a.isInFlyout=!0;n.render(),r=n.getSvgRoot(),l=n.getHeightWidth(),a=n.outputConnection?i-this.tabWidth_:i,n.moveBy(a,o),a=this.createRect_(n,this.RTL?a-l.width:a,o,l,s),this.addBlockListeners_(r,n,a),o+=l.height+e[s]}else"button"==n.type&&(this.initFlyoutButton_(n.button,i,o),o+=n.button.height+e[s])},T.VerticalFlyout.prototype.isDragTowardWorkspace=function(t){t=Math.atan2(t.y,t.x)/Math.PI*180;var e=this.dragAngleRange_;return t<e&&-e<t||t<-180+e||180-e<t},T.VerticalFlyout.prototype.getClientRect=function(){if(!this.svgGroup_)return null;var t=this.svgGroup_.getBoundingClientRect(),e=t.left;return this.toolboxPosition_==T.utils.toolbox.Position.LEFT?new T.utils.Rect(-1e9,1e9,-1e9,e+t.width):new T.utils.Rect(-1e9,1e9,e,1e9)},T.VerticalFlyout.prototype.reflowInternal_=function(){this.workspace_.scale=this.getFlyoutScale();for(var t=0,e=this.workspace_.getTopBlocks(!1),o=0,i,s,n;i=e[o];o++){var s=i.getHeightWidth().width;i.outputConnection&&(s-=this.tabWidth_),t=Math.max(t,s)}for(o=0;i=this.buttons_[o];o++)t=Math.max(t,i.width);if(t=(t=(t+=1.5*this.MARGIN+this.tabWidth_)*this.workspace_.scale)+T.Scrollbar.scrollbarThickness,this.width_!=t){for(o=0;i=e[o];o++){this.RTL&&(s=i.getRelativeToSurfaceXY().x,n=t/this.workspace_.scale-this.MARGIN,i.outputConnection||(n-=this.tabWidth_),i.moveBy(n-s,0)),i.flyoutRect_&&this.moveRectToBlock_(i.flyoutRect_,i)}if(this.RTL)for(o=0;i=this.buttons_[o];o++)e=i.getPosition().y,i.moveTo(t/this.workspace_.scale-i.width-this.MARGIN-this.tabWidth_,e);this.targetWorkspace.toolboxPosition!=this.toolboxPosition_||this.toolboxPosition_!=T.utils.toolbox.Position.LEFT||this.targetWorkspace.getToolbox()||this.targetWorkspace.translate(this.targetWorkspace.scrollX+t,this.targetWorkspace.scrollY),this.width_=t,this.position()}},T.registry.register(T.registry.Type.FLYOUTS_VERTICAL_TOOLBOX,T.registry.DEFAULT,T.VerticalFlyout),T.FlyoutButton=function(t,e,o,i){this.workspace_=t,this.targetWorkspace_=e,this.text_=o.text,this.position_=new T.utils.Coordinate(0,0),this.isLabel_=i,this.callbackKey_=o.callbackKey||o.callbackkey,this.cssClass_=o["web-class"]||null,this.onMouseUpWrapper_=null,this.info=o},T.FlyoutButton.MARGIN_X=5,T.FlyoutButton.MARGIN_Y=2,T.FlyoutButton.prototype.width=0,T.FlyoutButton.prototype.height=0,T.FlyoutButton.prototype.createDom=function(){var t=this.isLabel_?"blocklyFlyoutLabel":"blocklyFlyoutButton",e,o=(this.cssClass_&&(t+=" "+this.cssClass_),this.svgGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:t},this.workspace_.getCanvas()),this.isLabel_||(e=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blocklyFlyoutButtonShadow",rx:4,ry:4,x:1,y:1},this.svgGroup_)),t=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:this.isLabel_?"blocklyFlyoutLabelBackground":"blocklyFlyoutButtonBackground",rx:4,ry:4},this.svgGroup_),T.utils.dom.createSvgElement(T.utils.Svg.TEXT,{class:this.isLabel_?"blocklyFlyoutLabelText":"blocklyText",x:0,y:0,"text-anchor":"middle"},this.svgGroup_)),i=T.utils.replaceMessageReferences(this.text_),s=(this.workspace_.RTL&&(i+="‏"),o.textContent=i,this.isLabel_&&(this.svgText_=o,this.workspace_.getThemeManager().subscribe(this.svgText_,"flyoutForegroundColour","fill")),T.utils.style.getComputedStyle(o,"fontSize")),n=T.utils.style.getComputedStyle(o,"fontWeight"),r=T.utils.style.getComputedStyle(o,"fontFamily");return this.width=T.utils.dom.getFastTextWidthWithSizeString(o,s,n,r),i=T.utils.dom.measureFontMetrics(i,s,n,r),this.height=i.height,this.isLabel_||(this.width+=2*T.FlyoutButton.MARGIN_X,this.height+=2*T.FlyoutButton.MARGIN_Y,e.setAttribute("width",this.width),e.setAttribute("height",this.height)),t.setAttribute("width",this.width),t.setAttribute("height",this.height),o.setAttribute("x",this.width/2),o.setAttribute("y",this.height/2-i.height/2+i.baseline),this.updateTransform_(),this.onMouseUpWrapper_=T.browserEvents.conditionalBind(this.svgGroup_,"mouseup",this,this.onMouseUp_),this.svgGroup_},T.FlyoutButton.prototype.show=function(){this.updateTransform_(),this.svgGroup_.setAttribute("display","block")},T.FlyoutButton.prototype.updateTransform_=function(){this.svgGroup_.setAttribute("transform","translate("+this.position_.x+","+this.position_.y+")")},T.FlyoutButton.prototype.moveTo=function(t,e){this.position_.x=t,this.position_.y=e,this.updateTransform_()},T.FlyoutButton.prototype.isLabel=function(){return this.isLabel_},T.FlyoutButton.prototype.getPosition=function(){return this.position_},T.FlyoutButton.prototype.getButtonText=function(){return this.text_},T.FlyoutButton.prototype.getTargetWorkspace=function(){return this.targetWorkspace_},T.FlyoutButton.prototype.dispose=function(){this.onMouseUpWrapper_&&T.browserEvents.unbind(this.onMouseUpWrapper_),this.svgGroup_&&T.utils.dom.removeNode(this.svgGroup_),this.svgText_&&this.workspace_.getThemeManager().unsubscribe(this.svgText_)},T.FlyoutButton.prototype.onMouseUp_=function(t){(t=this.targetWorkspace_.getGesture(t))&&t.cancel(),this.isLabel_&&this.callbackKey_?console.warn("Labels should not have callbacks. Label text: "+this.text_):this.isLabel_||this.callbackKey_&&this.targetWorkspace_.getButtonCallback(this.callbackKey_)?this.isLabel_||this.targetWorkspace_.getButtonCallback(this.callbackKey_)(this):console.warn("Buttons should have callbacks. Button text: "+this.text_)},T.Css.register(".blocklyFlyoutButton {,fill: #888;,cursor: default;,},.blocklyFlyoutButtonShadow {,fill: #666;,},.blocklyFlyoutButton:hover {,fill: #aaa;,},.blocklyFlyoutLabel {,cursor: default;,},.blocklyFlyoutLabelBackground {,opacity: 0;,}".split(",")),T.Generator=function(t){this.name_=t,this.FUNCTION_NAME_PLACEHOLDER_REGEXP_=new RegExp(this.FUNCTION_NAME_PLACEHOLDER_,"g")},T.Generator.NAME_TYPE="generated_function",T.Generator.prototype.INFINITE_LOOP_TRAP=null,T.Generator.prototype.STATEMENT_PREFIX=null,T.Generator.prototype.STATEMENT_SUFFIX=null,T.Generator.prototype.INDENT="  ",T.Generator.prototype.COMMENT_WRAP=60,T.Generator.prototype.ORDER_OVERRIDES=[],T.Generator.prototype.isInitialized=null,T.Generator.prototype.workspaceToCode=function(t){t||(console.warn("No workspace specified in workspaceToCode call.  Guessing."),t=T.getMainWorkspace());var e=[];this.init(t),t=t.getTopBlocks(!0);for(var o=0,i;i=t[o];o++){var s=this.blockToCode(i);(s=Array.isArray(s)?s[0]:s)&&(i.outputConnection&&(s=this.scrubNakedValue(s),this.STATEMENT_PREFIX&&!i.suppressPrefixSuffix&&(s=this.injectId(this.STATEMENT_PREFIX,i)+s),this.STATEMENT_SUFFIX)&&!i.suppressPrefixSuffix&&(s+=this.injectId(this.STATEMENT_SUFFIX,i)),e.push(s))}return e=e.join("\n"),e=(e=(e=(e=this.finish(e)).replace(/^\s+\n/,"")).replace(/\n\s+$/,"\n")).replace(/[ \t]+\n/g,"\n")},T.Generator.prototype.prefixLines=function(t,e){return e+t.replace(/(?!\n$)\n/g,"\n"+e)},T.Generator.prototype.allNestedComments=function(t){var e=[];t=t.getDescendants(!0);for(var o=0;o<t.length;o++){var i=t[o].getCommentText();i&&e.push(i)}return e.length&&e.push(""),e.join("\n")},T.Generator.prototype.blockToCode=function(t,e){if(!1===this.isInitialized&&console.warn("Generator init was not called before blockToCode was called."),!t)return"";if(!t.isEnabled())return e?"":this.blockToCode(t.getNextBlock());if(t.isInsertionMarker())return e?"":this.blockToCode(t.getChildren(!1)[0]);var o=this[t.type];if("function"!=typeof o)throw Error('Language "'+this.name_+'" does not know how to generate  code for block type "'+t.type+'".');if(o=o.call(t,t),Array.isArray(o)){if(!t.outputConnection)throw TypeError("Expecting string from statement block: "+t.type);return[this.scrub_(t,o[0],e),o[1]]}if("string"==typeof o)return this.STATEMENT_PREFIX&&!t.suppressPrefixSuffix&&(o=this.injectId(this.STATEMENT_PREFIX,t)+o),this.STATEMENT_SUFFIX&&!t.suppressPrefixSuffix&&(o+=this.injectId(this.STATEMENT_SUFFIX,t)),this.scrub_(t,o,e);if(null===o)return"";throw SyntaxError("Invalid code generated: "+o)},T.Generator.prototype.valueToCode=function(t,e,o){if(isNaN(o))throw TypeError("Expecting valid order from block: "+t.type);var i;if(!(i=t.getInputTargetBlock(e)))return"";if(""===(e=this.blockToCode(i)))return"";if(!Array.isArray(e))throw TypeError("Expecting tuple from value block: "+i.type);if(t=e[0],e=e[1],isNaN(e))throw TypeError("Expecting valid order from value block: "+i.type);if(!t)return"";var i=!1,s=Math.floor(o),n=Math.floor(e);if(s<=n&&(s!=n||0!=s&&99!=s))for(i=!0,s=0;s<this.ORDER_OVERRIDES.length;s++)if(this.ORDER_OVERRIDES[s][0]==o&&this.ORDER_OVERRIDES[s][1]==e){i=!1;break}return t=i?"("+t+")":t},T.Generator.prototype.statementToCode=function(t,e){if(t=t.getInputTargetBlock(e),"string"!=typeof(e=this.blockToCode(t)))throw TypeError("Expecting code from statement block: "+(t&&t.type));return e=e&&this.prefixLines(e,this.INDENT)},T.Generator.prototype.addLoopTrap=function(t,e){return this.INFINITE_LOOP_TRAP&&(t=this.prefixLines(this.injectId(this.INFINITE_LOOP_TRAP,e),this.INDENT)+t),this.STATEMENT_SUFFIX&&!e.suppressPrefixSuffix&&(t=this.prefixLines(this.injectId(this.STATEMENT_SUFFIX,e),this.INDENT)+t),this.STATEMENT_PREFIX&&!e.suppressPrefixSuffix&&(t+=this.prefixLines(this.injectId(this.STATEMENT_PREFIX,e),this.INDENT)),t},T.Generator.prototype.injectId=function(t,e){return e=e.id.replace(/\$/g,"$$$$"),t.replace(/%1/g,"'"+e+"'")},T.Generator.prototype.RESERVED_WORDS_="",T.Generator.prototype.addReservedWords=function(t){this.RESERVED_WORDS_+=t+","},T.Generator.prototype.FUNCTION_NAME_PLACEHOLDER_="{leCUI8hutHZI4480Dc}",T.Generator.prototype.provideFunction_=function(t,e){if(!this.definitions_[t]){var o=this.variableDB_.getDistinctName(t,T.PROCEDURE_CATEGORY_NAME),i;for(this.functionNames_[t]=o,e=e.join("\n").replace(this.FUNCTION_NAME_PLACEHOLDER_REGEXP_,o);i!=e;)e=(i=e).replace(/^(( {2})*) {2}/gm,"$1\0");e=e.replace(/\0/g,this.INDENT),this.definitions_[t]=e}return this.functionNames_[t]},T.Generator.prototype.init=function(t){},T.Generator.prototype.scrub_=function(t,e,o){return e},T.Generator.prototype.finish=function(t){return t},T.Generator.prototype.scrubNakedValue=function(t){return t},T.ToolboxItem=function(t,e,o){this.id_=t.toolboxitemid||T.utils.IdGenerator.getNextUniqueId(),this.level_=(this.parent_=o||null)?this.parent_.getLevel()+1:0,this.toolboxItemDef_=t,this.parentToolbox_=e,this.workspace_=this.parentToolbox_.getWorkspace()},T.ToolboxItem.prototype.init=function(){},T.ToolboxItem.prototype.getDiv=function(){return null},T.ToolboxItem.prototype.getId=function(){return this.id_},T.ToolboxItem.prototype.getParent=function(){return null},T.ToolboxItem.prototype.getLevel=function(){return this.level_},T.ToolboxItem.prototype.isSelectable=function(){return!1},T.ToolboxItem.prototype.isCollapsible=function(){return!1},T.ToolboxItem.prototype.dispose=function(){},T.ToolboxCategory=function(t,e,o){T.ToolboxCategory.superClass_.constructor.call(this,t,e,o),this.name_=T.utils.replaceMessageReferences(t.name),this.colour_=this.getColour_(t),this.labelDom_=this.iconDom_=this.rowContents_=this.rowDiv_=this.htmlDiv_=null,this.cssConfig_=this.makeDefaultCssConfig_(),T.utils.object.mixin(this.cssConfig_,t.cssconfig||t.cssConfig),this.isDisabled_=this.isHidden_=!1,this.flyoutItems_=[],this.parseContents_(t)},T.utils.object.inherits(T.ToolboxCategory,T.ToolboxItem),T.ToolboxCategory.registrationName="category",T.ToolboxCategory.nestedPadding=19,T.ToolboxCategory.borderWidth=8,T.ToolboxCategory.defaultBackgroundColour="#57e",T.ToolboxCategory.prototype.makeDefaultCssConfig_=function(){return{container:"blocklyToolboxCategory",row:"blocklyTreeRow",rowcontentcontainer:"blocklyTreeRowContentContainer",icon:"blocklyTreeIcon",label:"blocklyTreeLabel",contents:"blocklyToolboxContents",selected:"blocklyTreeSelected",openicon:"blocklyTreeIconOpen",closedicon:"blocklyTreeIconClosed"}},T.ToolboxCategory.prototype.parseContents_=function(t){var e=t.contents,o;if(t.custom)this.flyoutItems_=t.custom;else if(e){t=0;for(;o=e[t];t++)this.flyoutItems_.push(o)}},T.ToolboxCategory.prototype.init=function(){this.createDom_(),"true"==this.toolboxItemDef_.hidden&&this.hide()},T.ToolboxCategory.prototype.createDom_=function(){return this.htmlDiv_=this.createContainer_(),T.utils.aria.setRole(this.htmlDiv_,T.utils.aria.Role.TREEITEM),T.utils.aria.setState(this.htmlDiv_,T.utils.aria.State.SELECTED,!1),T.utils.aria.setState(this.htmlDiv_,T.utils.aria.State.LEVEL,this.level_),this.rowDiv_=this.createRowContainer_(),this.rowDiv_.style.pointerEvents="auto",this.htmlDiv_.appendChild(this.rowDiv_),this.rowContents_=this.createRowContentsContainer_(),this.rowContents_.style.pointerEvents="none",this.rowDiv_.appendChild(this.rowContents_),this.iconDom_=this.createIconDom_(),T.utils.aria.setRole(this.iconDom_,T.utils.aria.Role.PRESENTATION),this.rowContents_.appendChild(this.iconDom_),this.labelDom_=this.createLabelDom_(this.name_),this.rowContents_.appendChild(this.labelDom_),T.utils.aria.setState(this.htmlDiv_,T.utils.aria.State.LABELLEDBY,this.labelDom_.getAttribute("id")),this.addColourBorder_(this.colour_),this.htmlDiv_},T.ToolboxCategory.prototype.createContainer_=function(){var t=document.createElement("div");return T.utils.dom.addClass(t,this.cssConfig_.container),t},T.ToolboxCategory.prototype.createRowContainer_=function(){var t=document.createElement("div");T.utils.dom.addClass(t,this.cssConfig_.row);var e,e=(e=T.ToolboxCategory.nestedPadding*this.getLevel()).toString()+"px";return this.workspace_.RTL?t.style.paddingRight=e:t.style.paddingLeft=e,t},T.ToolboxCategory.prototype.createRowContentsContainer_=function(){var t=document.createElement("div");return T.utils.dom.addClass(t,this.cssConfig_.rowcontentcontainer),t},T.ToolboxCategory.prototype.createIconDom_=function(){var t=document.createElement("span");return this.parentToolbox_.isHorizontal()||T.utils.dom.addClass(t,this.cssConfig_.icon),t.style.display="inline-block",t},T.ToolboxCategory.prototype.createLabelDom_=function(t){var e=document.createElement("span");return e.setAttribute("id",this.getId()+".label"),e.textContent=t,T.utils.dom.addClass(e,this.cssConfig_.label),e},T.ToolboxCategory.prototype.refreshTheme=function(){this.colour_=this.getColour_(this.toolboxItemDef_),this.addColourBorder_(this.colour_)},T.ToolboxCategory.prototype.addColourBorder_=function(t){t&&(t=T.ToolboxCategory.borderWidth+"px solid "+(t||"#ddd"),this.workspace_.RTL?this.rowDiv_.style.borderRight=t:this.rowDiv_.style.borderLeft=t)},T.ToolboxCategory.prototype.getColour_=function(t){var e=t.categorystyle||t.categoryStyle;if(!(t=t.colour)||!e)return e?this.getColourfromStyle_(e):this.parseColour_(t);return console.warn('Toolbox category "'+this.name_+'" must not have both a style and a colour'),""},T.ToolboxCategory.prototype.getColourfromStyle_=function(t){var e=this.workspace_.getTheme();if(t&&e){if((e=e.categoryStyles[t])&&e.colour)return this.parseColour_(e.colour);console.warn('Style "'+t+'" must exist and contain a colour value')}return""},T.ToolboxCategory.prototype.getClickTarget=function(){return this.rowDiv_},T.ToolboxCategory.prototype.parseColour_=function(t){if(null==(t=T.utils.replaceMessageReferences(t))||""===t)return"";var e=Number(t);if(isNaN(e)){if(e=T.utils.colour.parse(t))return e;return console.warn('Toolbox category "'+this.name_+'" has unrecognized colour attribute: '+t),""}return T.hueToHex(e)},T.ToolboxCategory.prototype.openIcon_=function(t){t&&(T.utils.dom.removeClasses(t,this.cssConfig_.closedicon),T.utils.dom.addClass(t,this.cssConfig_.openicon))},T.ToolboxCategory.prototype.closeIcon_=function(t){t&&(T.utils.dom.removeClasses(t,this.cssConfig_.openicon),T.utils.dom.addClass(t,this.cssConfig_.closedicon))},T.ToolboxCategory.prototype.setVisible_=function(t){this.htmlDiv_.style.display=t?"block":"none",this.isHidden_=!t,this.parentToolbox_.getSelectedItem()==this&&this.parentToolbox_.clearSelection()},T.ToolboxCategory.prototype.hide=function(){this.setVisible_(!1)},T.ToolboxCategory.prototype.show=function(){this.setVisible_(!0)},T.ToolboxCategory.prototype.isVisible=function(){return!this.isHidden_&&this.allAncestorsExpanded_()},T.ToolboxCategory.prototype.allAncestorsExpanded_=function(){for(var t=this;t.getParent();)if(!(t=t.getParent()).isExpanded())return!1;return!0},T.ToolboxCategory.prototype.isSelectable=function(){return this.isVisible()&&!this.isDisabled_},T.ToolboxCategory.prototype.onClick=function(t){},T.ToolboxCategory.prototype.setSelected=function(t){var e;t?(e=this.parseColour_(T.ToolboxCategory.defaultBackgroundColour),this.rowDiv_.style.backgroundColor=this.colour_||e,T.utils.dom.addClass(this.rowDiv_,this.cssConfig_.selected)):(this.rowDiv_.style.backgroundColor="",T.utils.dom.removeClass(this.rowDiv_,this.cssConfig_.selected)),T.utils.aria.setState(this.htmlDiv_,T.utils.aria.State.SELECTED,t)},T.ToolboxCategory.prototype.setDisabled=function(t){this.isDisabled_=t,this.getDiv().setAttribute("disabled",t),t?this.getDiv().setAttribute("disabled","true"):this.getDiv().removeAttribute("disabled")},T.ToolboxCategory.prototype.getName=function(){return this.name_},T.ToolboxCategory.prototype.getParent=function(){return this.parent_},T.ToolboxCategory.prototype.getDiv=function(){return this.htmlDiv_},T.ToolboxCategory.prototype.getContents=function(){return this.flyoutItems_},T.ToolboxCategory.prototype.updateFlyoutContents=function(t){this.flyoutItems_=[],"string"==typeof t?this.toolboxItemDef_.custom=t:(delete this.toolboxItemDef_.custom,this.toolboxItemDef_.contents=T.utils.toolbox.convertFlyoutDefToJsonArray(t)),this.parseContents_(this.toolboxItemDef_)},T.ToolboxCategory.prototype.dispose=function(){T.utils.dom.removeNode(this.htmlDiv_)},T.Css.register([".blocklyTreeRow:not(.blocklyTreeSelected):hover {","background-color: rgba(255, 255, 255, 0.2);","}",'.blocklyToolboxDiv[layout="h"] .blocklyToolboxCategory {',"margin: 1px 5px 1px 0;","}",'.blocklyToolboxDiv[dir="RTL"][layout="h"] .blocklyToolboxCategory {',"margin: 1px 0 1px 5px;","}",".blocklyTreeRow {","height: 22px;","line-height: 22px;","margin-bottom: 3px;","padding-right: 8px;","white-space: nowrap;","}",'.blocklyToolboxDiv[dir="RTL"] .blocklyTreeRow {',"margin-left: 8px;","padding-right: 0px","}",".blocklyTreeIcon {","height: 16px;","vertical-align: middle;","visibility: hidden;","width: 16px;","}",".blocklyTreeIconClosed {","background-position: -32px -1px;","}",'.blocklyToolboxDiv[dir="RTL"] .blocklyTreeIconClosed {',"background-position: 0 -1px;","}",".blocklyTreeSelected>.blocklyTreeIconClosed {","background-position: -32px -17px;","}",'.blocklyToolboxDiv[dir="RTL"] .blocklyTreeSelected>.blocklyTreeIconClosed {',"background-position: 0 -17px;","}",".blocklyTreeIconOpen {","background-position: -16px -1px;","}",".blocklyTreeSelected>.blocklyTreeIconOpen {","background-position: -16px -17px;","}",".blocklyTreeLabel {","cursor: default;","font: 16px sans-serif;","padding: 0 3px;","vertical-align: middle;","}",".blocklyToolboxDelete .blocklyTreeLabel {",'cursor: url("<<<PATH>>>/handdelete.cur"), auto;',"}",".blocklyTreeSelected .blocklyTreeLabel {","color: #fff;","}"]),T.registry.register(T.registry.Type.TOOLBOX_ITEM,T.ToolboxCategory.registrationName,T.ToolboxCategory),T.ToolboxSeparator=function(t,e){T.ToolboxSeparator.superClass_.constructor.call(this,t,e),this.cssConfig_={container:"blocklyTreeSeparator"},T.utils.object.mixin(this.cssConfig_,t.cssconfig||t.cssConfig)},T.utils.object.inherits(T.ToolboxSeparator,T.ToolboxItem),T.ToolboxSeparator.registrationName="sep",T.ToolboxSeparator.prototype.init=function(){this.createDom_()},T.ToolboxSeparator.prototype.createDom_=function(){var t=document.createElement("div");return T.utils.dom.addClass(t,this.cssConfig_.container),this.htmlDiv_=t},T.ToolboxSeparator.prototype.getDiv=function(){return this.htmlDiv_},T.ToolboxSeparator.prototype.dispose=function(){T.utils.dom.removeNode(this.htmlDiv_)},T.Css.register('.blocklyTreeSeparator {,border-bottom: solid #e5e5e5 1px;,height: 0;,margin: 5px 0;,},.blocklyToolboxDiv[layout="h"] .blocklyTreeSeparator {,border-right: solid #e5e5e5 1px;,border-bottom: none;,height: auto;,margin: 0 5px 0 5px;,padding: 5px 0;,width: 0;,}'.split(",")),T.registry.register(T.registry.Type.TOOLBOX_ITEM,T.ToolboxSeparator.registrationName,T.ToolboxSeparator),T.CollapsibleToolboxCategory=function(t,e,o){this.subcategoriesDiv_=null,this.expanded_=!1,this.toolboxItems_=[],T.CollapsibleToolboxCategory.superClass_.constructor.call(this,t,e,o)},T.utils.object.inherits(T.CollapsibleToolboxCategory,T.ToolboxCategory),T.CollapsibleToolboxCategory.registrationName="collapsibleCategory",T.CollapsibleToolboxCategory.prototype.makeDefaultCssConfig_=function(){var t=T.CollapsibleToolboxCategory.superClass_.makeDefaultCssConfig_.call(this);return t.contents="blocklyToolboxContents",t},T.CollapsibleToolboxCategory.prototype.parseContents_=function(t){var e=t.contents,o=!0,i;if(t.custom)this.flyoutItems_=t.custom;else if(e){t=0;for(;i=e[t];t++)o=!T.registry.hasItem(T.registry.Type.TOOLBOX_ITEM,i.kind)||i.kind.toLowerCase()==T.ToolboxSeparator.registrationName&&o?(this.flyoutItems_.push(i),!0):(this.createToolboxItem_(i),!1)}},T.CollapsibleToolboxCategory.prototype.createToolboxItem_=function(t){var e=t.kind;"CATEGORY"==e.toUpperCase()&&T.utils.toolbox.isCategoryCollapsible(t)&&(e=T.CollapsibleToolboxCategory.registrationName),t=new(T.registry.getClass(T.registry.Type.TOOLBOX_ITEM,e))(t,this.parentToolbox_,this),this.toolboxItems_.push(t)},T.CollapsibleToolboxCategory.prototype.init=function(){T.CollapsibleToolboxCategory.superClass_.init.call(this),this.setExpanded("true"==this.toolboxItemDef_.expanded||this.toolboxItemDef_.expanded)},T.CollapsibleToolboxCategory.prototype.createDom_=function(){T.CollapsibleToolboxCategory.superClass_.createDom_.call(this);var t=this.getChildToolboxItems();return this.subcategoriesDiv_=this.createSubCategoriesDom_(t),T.utils.aria.setRole(this.subcategoriesDiv_,T.utils.aria.Role.GROUP),this.htmlDiv_.appendChild(this.subcategoriesDiv_),this.htmlDiv_},T.CollapsibleToolboxCategory.prototype.createIconDom_=function(){var t=document.createElement("span");return this.parentToolbox_.isHorizontal()||(T.utils.dom.addClass(t,this.cssConfig_.icon),t.style.visibility="visible"),t.style.display="inline-block",t},T.CollapsibleToolboxCategory.prototype.createSubCategoriesDom_=function(t){var e=document.createElement("div");T.utils.dom.addClass(e,this.cssConfig_.contents);for(var o=0;o<t.length;o++){var i=t[o],s=(i.init(),i.getDiv());e.appendChild(s),i.getClickTarget&&i.getClickTarget().setAttribute("id",i.getId())}return e},T.CollapsibleToolboxCategory.prototype.setExpanded=function(t){this.expanded_!=t&&((this.expanded_=t)?(this.subcategoriesDiv_.style.display="block",this.openIcon_(this.iconDom_)):(this.subcategoriesDiv_.style.display="none",this.closeIcon_(this.iconDom_)),T.utils.aria.setState(this.htmlDiv_,T.utils.aria.State.EXPANDED,t),this.parentToolbox_.handleToolboxItemResize())},T.CollapsibleToolboxCategory.prototype.setVisible_=function(t){this.htmlDiv_.style.display=t?"block":"none";for(var e=0,o;o=this.getChildToolboxItems()[e];e++)o.setVisible_(t);this.isHidden_=!t,this.parentToolbox_.getSelectedItem()==this&&this.parentToolbox_.clearSelection()},T.CollapsibleToolboxCategory.prototype.isExpanded=function(){return this.expanded_},T.CollapsibleToolboxCategory.prototype.isCollapsible=function(){return!0},T.CollapsibleToolboxCategory.prototype.onClick=function(t){this.toggleExpanded()},T.CollapsibleToolboxCategory.prototype.toggleExpanded=function(){this.setExpanded(!this.expanded_)},T.CollapsibleToolboxCategory.prototype.getDiv=function(){return this.htmlDiv_},T.CollapsibleToolboxCategory.prototype.getChildToolboxItems=function(){return this.toolboxItems_},T.registry.register(T.registry.Type.TOOLBOX_ITEM,T.CollapsibleToolboxCategory.registrationName,T.CollapsibleToolboxCategory),T.Events.ToolboxItemSelect=function(t,e,o){T.Events.ToolboxItemSelect.superClass_.constructor.call(this,o),this.oldItem=t,this.newItem=e},T.utils.object.inherits(T.Events.ToolboxItemSelect,T.Events.UiBase),T.Events.ToolboxItemSelect.prototype.type=T.Events.TOOLBOX_ITEM_SELECT,T.Events.ToolboxItemSelect.prototype.toJson=function(){var t=T.Events.ToolboxItemSelect.superClass_.toJson.call(this);return t.oldItem=this.oldItem,t.newItem=this.newItem,t},T.Events.ToolboxItemSelect.prototype.fromJson=function(t){T.Events.ToolboxItemSelect.superClass_.fromJson.call(this,t),this.oldItem=t.oldItem,this.newItem=t.newItem},T.registry.register(T.registry.Type.EVENT,T.Events.TOOLBOX_ITEM_SELECT,T.Events.ToolboxItemSelect),T.Toolbox=function(t){this.workspace_=t,this.toolboxDef_=t.options.languageTree||{contents:[]},this.horizontalLayout_=t.options.horizontalLayout,this.contentsDiv_=this.HtmlDiv=null,this.contents_=[],this.height_=this.width_=0,this.RTL=t.options.RTL,this.flyout_=null,this.contentMap_={},this.toolboxPosition=t.options.toolboxPosition,this.previouslySelectedItem_=this.selectedItem_=null,this.boundEvents_=[]},T.Toolbox.prototype.onShortcut=function(t){return!1},T.Toolbox.prototype.init=function(){var t=this.workspace_,e=t.getParentSvg();this.flyout_=this.createFlyout_(),this.HtmlDiv=this.createDom_(this.workspace_),T.utils.dom.insertAfter(this.flyout_.createDom("svg"),e),this.flyout_.init(t),this.render(this.toolboxDef_),(t=t.getThemeManager()).subscribe(this.HtmlDiv,"toolboxBackgroundColour","background-color"),t.subscribe(this.HtmlDiv,"toolboxForegroundColour","color")},T.Toolbox.prototype.createDom_=function(t){t=t.getParentSvg();var e=this.createContainer_();return this.contentsDiv_=this.createContentsContainer_(),this.contentsDiv_.tabIndex=0,T.utils.aria.setRole(this.contentsDiv_,T.utils.aria.Role.TREE),e.appendChild(this.contentsDiv_),t.parentNode.insertBefore(e,t),this.attachEvents_(e,this.contentsDiv_),e},T.Toolbox.prototype.createContainer_=function(){var t=document.createElement("div");return t.setAttribute("layout",this.isHorizontal()?"h":"v"),T.utils.dom.addClass(t,"blocklyToolboxDiv"),T.utils.dom.addClass(t,"blocklyNonSelectable"),t.setAttribute("dir",this.RTL?"RTL":"LTR"),t},T.Toolbox.prototype.createContentsContainer_=function(){var t=document.createElement("div");return T.utils.dom.addClass(t,"blocklyToolboxContents"),this.isHorizontal()&&(t.style.flexDirection="row"),t},T.Toolbox.prototype.attachEvents_=function(t,e){t=T.browserEvents.conditionalBind(t,"click",this,this.onClick_,!1,!0),this.boundEvents_.push(t),e=T.browserEvents.conditionalBind(e,"keydown",this,this.onKeyDown_,!1,!0),this.boundEvents_.push(e)},T.Toolbox.prototype.onClick_=function(t){var e;T.utils.isRightButton(t)||t.target==this.HtmlDiv?T.hideChaff(!1):((e=t.target.getAttribute("id"))&&(e=this.getToolboxItemById(e)).isSelectable()&&(this.setSelectedItem(e),e.onClick(t)),T.hideChaff(!0)),T.Touch.clearTouchIdentifier()},T.Toolbox.prototype.onKeyDown_=function(t){var e=!1;switch(t.keyCode){case T.utils.KeyCodes.DOWN:e=this.selectNext_();break;case T.utils.KeyCodes.UP:e=this.selectPrevious_();break;case T.utils.KeyCodes.LEFT:e=this.selectParent_();break;case T.utils.KeyCodes.RIGHT:e=this.selectChild_();break;case T.utils.KeyCodes.ENTER:case T.utils.KeyCodes.SPACE:this.selectedItem_&&this.selectedItem_.isCollapsible()&&(this.selectedItem_.toggleExpanded(),e=!0);break;default:e=!1}(e=!e&&this.selectedItem_&&this.selectedItem_.onKeyDown?this.selectedItem_.onKeyDown(t):e)&&t.preventDefault()},T.Toolbox.prototype.createFlyout_=function(){var t=this.workspace_,e=new T.Options({parentWorkspace:t,rtl:t.RTL,oneBasedIndex:t.options.oneBasedIndex,horizontalLayout:t.horizontalLayout,renderer:t.options.renderer,rendererOverrides:t.options.rendererOverrides,move:{scrollbars:!0}});return e.toolboxPosition=t.options.toolboxPosition,new(t.horizontalLayout?T.registry.getClassFromOptions(T.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX,t.options,!0):T.registry.getClassFromOptions(T.registry.Type.FLYOUTS_VERTICAL_TOOLBOX,t.options,!0))(e)},T.Toolbox.prototype.render=function(t){this.toolboxDef_=t;for(var e=0;e<this.contents_.length;e++){var o=this.contents_[e];o&&o.dispose()}this.contents_=[],this.contentMap_={},this.renderContents_(t.contents),this.position()},T.Toolbox.prototype.renderContents_=function(t){for(var e=document.createDocumentFragment(),o=0,i;i=t[o];o++)this.createToolboxItem_(i,e);this.contentsDiv_.appendChild(e)},T.Toolbox.prototype.createToolboxItem_=function(t,e){var o=t.kind;"CATEGORY"==o.toUpperCase()&&T.utils.toolbox.isCategoryCollapsible(t)&&(o=T.CollapsibleToolboxCategory.registrationName),(o=T.registry.getClass(T.registry.Type.TOOLBOX_ITEM,o.toLowerCase()))&&(t=new o(t,this),this.addToolboxItem_(t),t.init(),(o=t.getDiv())&&e.appendChild(o),t.getClickTarget)&&t.getClickTarget().setAttribute("id",t.getId())},T.Toolbox.prototype.addToolboxItem_=function(t){if(this.contents_.push(t),(this.contentMap_[t.getId()]=t).isCollapsible())for(var e=0,o;o=t.getChildToolboxItems()[e];e++)this.addToolboxItem_(o)},T.Toolbox.prototype.getToolboxItems=function(){return this.contents_},T.Toolbox.prototype.addStyle=function(t){T.utils.dom.addClass(this.HtmlDiv,t)},T.Toolbox.prototype.removeStyle=function(t){T.utils.dom.removeClass(this.HtmlDiv,t)},T.Toolbox.prototype.getClientRect=function(){if(!this.HtmlDiv)return null;var t,e=(t=this.HtmlDiv.getBoundingClientRect()).top,o=e+t.height,i=t.left,t=i+t.width;return this.toolboxPosition==T.utils.toolbox.Position.TOP?new T.utils.Rect(-1e7,o,-1e7,1e7):this.toolboxPosition==T.utils.toolbox.Position.BOTTOM?new T.utils.Rect(e,1e7,-1e7,1e7):this.toolboxPosition==T.utils.toolbox.Position.LEFT?new T.utils.Rect(-1e7,1e7,-1e7,t):new T.utils.Rect(-1e7,1e7,i,1e7)},T.Toolbox.prototype.getToolboxItemById=function(t){return this.contentMap_[t]},T.Toolbox.prototype.getWidth=function(){return this.width_},T.Toolbox.prototype.getHeight=function(){return this.height_},T.Toolbox.prototype.getFlyout=function(){return this.flyout_},T.Toolbox.prototype.getWorkspace=function(){return this.workspace_},T.Toolbox.prototype.getSelectedItem=function(){return this.selectedItem_},T.Toolbox.prototype.getPreviouslySelectedItem=function(){return this.previouslySelectedItem_},T.Toolbox.prototype.isHorizontal=function(){return this.horizontalLayout_},T.Toolbox.prototype.position=function(){var t=this.workspace_.getMetrics(),e=this.HtmlDiv;e&&(this.horizontalLayout_?(e.style.left="0",e.style.height="auto",e.style.width="100%",this.height_=e.offsetHeight,this.width_=t.viewWidth,this.toolboxPosition==T.utils.toolbox.Position.TOP?e.style.top="0":e.style.bottom="0"):(this.toolboxPosition==T.utils.toolbox.Position.RIGHT?e.style.right="0":e.style.left="0",e.style.height="100%",this.width_=e.offsetWidth,this.height_=t.viewHeight),this.flyout_.position())},T.Toolbox.prototype.handleToolboxItemResize=function(){var t=this.workspace_,e=this.HtmlDiv.getBoundingClientRect();t.translate(this.toolboxPosition==T.utils.toolbox.Position.LEFT?t.scrollX+e.width:t.scrollX,this.toolboxPosition==T.utils.toolbox.Position.TOP?t.scrollY+e.height:t.scrollY),T.svgResize(t)},T.Toolbox.prototype.clearSelection=function(){this.setSelectedItem(null)},T.Toolbox.prototype.refreshTheme=function(){for(var t=0;t<this.contents_.length;t++){var e=this.contents_[t];e.refreshTheme&&e.refreshTheme()}},T.Toolbox.prototype.refreshSelection=function(){this.selectedItem_&&this.selectedItem_.isSelectable()&&this.selectedItem_.getContents().length&&this.flyout_.show(this.selectedItem_.getContents())},T.Toolbox.prototype.setVisible=function(t){this.HtmlDiv.style.display=t?"block":"none"},T.Toolbox.prototype.setSelectedItem=function(t){var e=this.selectedItem_;!t&&!e||t&&!t.isSelectable()||(this.shouldDeselectItem_(e,t)&&null!=e&&this.deselectItem_(e),this.shouldSelectItem_(e,t)&&null!=t&&this.selectItem_(e,t),this.updateFlyout_(e,t),this.fireSelectEvent_(e,t))},T.Toolbox.prototype.shouldDeselectItem_=function(t,e){return null!=t&&(!t.isCollapsible()||t!=e)},T.Toolbox.prototype.shouldSelectItem_=function(t,e){return null!=e&&e!=t},T.Toolbox.prototype.deselectItem_=function(t){this.selectedItem_=null,(this.previouslySelectedItem_=t).setSelected(!1),T.utils.aria.setState(this.contentsDiv_,T.utils.aria.State.ACTIVEDESCENDANT,"")},T.Toolbox.prototype.selectItem_=function(t,e){this.selectedItem_=e,this.previouslySelectedItem_=t,e.setSelected(!0),T.utils.aria.setState(this.contentsDiv_,T.utils.aria.State.ACTIVEDESCENDANT,e.getId())},T.Toolbox.prototype.selectItemByPosition=function(t){-1<t&&t<this.contents_.length&&(t=this.contents_[t]).isSelectable()&&this.setSelectedItem(t)},T.Toolbox.prototype.updateFlyout_=function(t,e){(t!=e||e.isCollapsible())&&e&&e.getContents().length?(this.flyout_.show(e.getContents()),this.flyout_.scrollToStart()):this.flyout_.hide()},T.Toolbox.prototype.fireSelectEvent_=function(t,e){var o=t&&t.getName(),i=e&&e.getName();t==e&&(i=null),t=new(T.Events.get(T.Events.TOOLBOX_ITEM_SELECT))(o,i,this.workspace_.id),T.Events.fire(t)},T.Toolbox.prototype.selectParent_=function(){return!(!this.selectedItem_||(this.selectedItem_.isCollapsible()&&this.selectedItem_.isExpanded()?(this.selectedItem_.setExpanded(!1),0):!this.selectedItem_.getParent()||!this.selectedItem_.getParent().isSelectable()||(this.setSelectedItem(this.selectedItem_.getParent()),0)))},T.Toolbox.prototype.selectChild_=function(){if(!this.selectedItem_||!this.selectedItem_.isCollapsible())return!1;var t=this.selectedItem_;return t.isExpanded()?this.selectNext_():t.setExpanded(!0),!0},T.Toolbox.prototype.selectNext_=function(){if(!this.selectedItem_)return!1;var t=this.contents_.indexOf(this.selectedItem_)+1;if(-1<t&&t<this.contents_.length){for(var e=this.contents_[t];e&&!e.isSelectable();)e=this.contents_[++t];if(e&&e.isSelectable())return this.setSelectedItem(e),!0}return!1},T.Toolbox.prototype.selectPrevious_=function(){if(!this.selectedItem_)return!1;var t=this.contents_.indexOf(this.selectedItem_)-1;if(-1<t&&t<this.contents_.length){for(var e=this.contents_[t];e&&!e.isSelectable();)e=this.contents_[--t];if(e&&e.isSelectable())return this.setSelectedItem(e),!0}return!1},T.Toolbox.prototype.dispose=function(){this.flyout_.dispose();for(var t=0;t<this.contents_.length;t++)this.contents_[t].dispose();for(t=0;t<this.boundEvents_.length;t++)T.browserEvents.unbind(this.boundEvents_[t]);this.boundEvents_=[],this.contents_=[],this.workspace_.getThemeManager().unsubscribe(this.HtmlDiv),T.utils.dom.removeNode(this.HtmlDiv)},T.Css.register([".blocklyToolboxDelete {",'cursor: url("<<<PATH>>>/handdelete.cur"), auto;',"}",".blocklyToolboxGrab {",'cursor: url("<<<PATH>>>/handclosed.cur"), auto;',"cursor: grabbing;","cursor: -webkit-grabbing;","}",".blocklyToolboxDiv {","background-color: #ddd;","overflow-x: visible;","overflow-y: auto;","padding: 4px 0 4px 0;","position: absolute;","z-index: 70;","-webkit-tap-highlight-color: transparent;","}",".blocklyToolboxContents {","display: flex;","flex-wrap: wrap;","flex-direction: column;","}",".blocklyToolboxContents:focus {","outline: none;","}"]),T.registry.register(T.registry.Type.TOOLBOX,T.registry.DEFAULT,T.Toolbox),T.Events.TrashcanOpen=function(t,e){T.Events.TrashcanOpen.superClass_.constructor.call(this,e),this.isOpen=t},T.utils.object.inherits(T.Events.TrashcanOpen,T.Events.UiBase),T.Events.TrashcanOpen.prototype.type=T.Events.TRASHCAN_OPEN,T.Events.TrashcanOpen.prototype.toJson=function(){var t=T.Events.TrashcanOpen.superClass_.toJson.call(this);return t.isOpen=this.isOpen,t},T.Events.TrashcanOpen.prototype.fromJson=function(t){T.Events.TrashcanOpen.superClass_.fromJson.call(this,t),this.isOpen=t.isOpen},T.registry.register(T.registry.Type.EVENT,T.Events.TRASHCAN_OPEN,T.Events.TrashcanOpen),T.IPlugin=function(){},T.IPositionable=function(){},T.Trashcan=function(t){this.workspace_=t,this.contents_=[],this.flyout=null,this.workspace_.options.maxTrashcanContents<=0||(t=new T.Options({scrollbars:!0,parentWorkspace:this.workspace_,rtl:this.workspace_.RTL,oneBasedIndex:this.workspace_.options.oneBasedIndex,renderer:this.workspace_.options.renderer,rendererOverrides:this.workspace_.options.rendererOverrides,move:{scrollbars:!0}}),this.workspace_.horizontalLayout?(t.toolboxPosition=this.workspace_.toolboxPosition==T.utils.toolbox.Position.TOP?T.utils.toolbox.Position.BOTTOM:T.utils.toolbox.Position.TOP,this.flyout=new(T.registry.getClassFromOptions(T.registry.Type.FLYOUTS_HORIZONTAL_TOOLBOX,this.workspace_.options,!0))(t)):(t.toolboxPosition=this.workspace_.toolboxPosition==T.utils.toolbox.Position.RIGHT?T.utils.toolbox.Position.LEFT:T.utils.toolbox.Position.RIGHT,this.flyout=new(T.registry.getClassFromOptions(T.registry.Type.FLYOUTS_VERTICAL_TOOLBOX,this.workspace_.options,!0))(t)),this.workspace_.addChangeListener(this.onDelete_.bind(this)))},T.Trashcan.prototype.WIDTH_=47,T.Trashcan.prototype.BODY_HEIGHT_=44,T.Trashcan.prototype.LID_HEIGHT_=16,T.Trashcan.prototype.MARGIN_BOTTOM_=20,T.Trashcan.prototype.MARGIN_SIDE_=20,T.Trashcan.prototype.MARGIN_HOTSPOT_=10,T.Trashcan.prototype.SPRITE_LEFT_=0,T.Trashcan.prototype.SPRITE_TOP_=32,T.Trashcan.prototype.HAS_BLOCKS_LID_ANGLE_=.1,T.Trashcan.ANIMATION_LENGTH_=80,T.Trashcan.ANIMATION_FRAMES_=4,T.Trashcan.OPACITY_MIN_=.4,T.Trashcan.OPACITY_MAX_=.8,T.Trashcan.MAX_LID_ANGLE_=45,T.Trashcan.prototype.isLidOpen=!1,T.Trashcan.prototype.minOpenness_=0,T.Trashcan.prototype.svgGroup_=null,T.Trashcan.prototype.svgLid_=null,T.Trashcan.prototype.lidTask_=0,T.Trashcan.prototype.lidOpen_=0,T.Trashcan.prototype.left_=0,T.Trashcan.prototype.top_=0,T.Trashcan.prototype.createDom=function(){this.svgGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:"blocklyTrash"},null);var t=String(Math.random()).substring(2),e=T.utils.dom.createSvgElement(T.utils.Svg.CLIPPATH,{id:"blocklyTrashBodyClipPath"+t},this.svgGroup_),o=(T.utils.dom.createSvgElement(T.utils.Svg.RECT,{width:this.WIDTH_,height:this.BODY_HEIGHT_,y:this.LID_HEIGHT_},e),T.utils.dom.createSvgElement(T.utils.Svg.IMAGE,{width:T.SPRITE.width,x:-this.SPRITE_LEFT_,height:T.SPRITE.height,y:-this.SPRITE_TOP_,"clip-path":"url(#blocklyTrashBodyClipPath"+t+")"},this.svgGroup_));return o.setAttributeNS(T.utils.dom.XLINK_NS,"xlink:href",T.spritesBase64),e=T.utils.dom.createSvgElement(T.utils.Svg.CLIPPATH,{id:"blocklyTrashLidClipPath"+t},this.svgGroup_),T.utils.dom.createSvgElement(T.utils.Svg.RECT,{width:this.WIDTH_,height:this.LID_HEIGHT_},e),this.svgLid_=T.utils.dom.createSvgElement(T.utils.Svg.IMAGE,{width:T.SPRITE.width,x:-this.SPRITE_LEFT_,height:T.SPRITE.height,y:-this.SPRITE_TOP_,"clip-path":"url(#blocklyTrashLidClipPath"+t+")"},this.svgGroup_),this.svgLid_.setAttributeNS(T.utils.dom.XLINK_NS,"xlink:href",T.spritesBase64),T.browserEvents.bind(this.svgGroup_,"mousedown",this,this.blockMouseDownWhenOpenable_),T.browserEvents.bind(this.svgGroup_,"mouseup",this,this.click),T.browserEvents.bind(o,"mouseover",this,this.mouseOver_),T.browserEvents.bind(o,"mouseout",this,this.mouseOut_),this.animateLid_(),this.svgGroup_},T.Trashcan.prototype.init=function(t){return 0<this.workspace_.options.maxTrashcanContents&&(T.utils.dom.insertAfter(this.flyout.createDom(T.utils.Svg.SVG),this.workspace_.getParentSvg()),this.flyout.init(this.workspace_)),this.verticalSpacing_=this.MARGIN_BOTTOM_+t,this.setLidOpen(!1),this.verticalSpacing_+this.BODY_HEIGHT_+this.LID_HEIGHT_},T.Trashcan.prototype.dispose=function(){this.svgGroup_&&(T.utils.dom.removeNode(this.svgGroup_),this.svgGroup_=null),this.workspace_=this.svgLid_=null,clearTimeout(this.lidTask_)},T.Trashcan.prototype.hasContents_=function(){return!!this.contents_.length},T.Trashcan.prototype.contentsIsOpen=function(){return this.flyout.isVisible()},T.Trashcan.prototype.openFlyout=function(){if(!this.contentsIsOpen()){for(var t=[],e=0,o;o=this.contents_[e];e++)t[e]=T.Xml.textToDom(o);this.flyout.show(t),this.fireUiEvent_(!0)}},T.Trashcan.prototype.closeFlyout=function(){this.contentsIsOpen()&&(this.flyout.hide(),this.fireUiEvent_(!1))},T.Trashcan.prototype.emptyContents=function(){this.hasContents_()&&(this.contents_.length=0,this.setMinOpenness_(0),this.closeFlyout())},T.Trashcan.prototype.position=function(t,e){if(this.verticalSpacing_){this.left_=t.toolboxMetrics.position==T.utils.toolbox.Position.LEFT||this.workspace_.horizontalLayout&&!this.workspace_.RTL?t.viewMetrics.width+t.absoluteMetrics.left-this.WIDTH_-this.MARGIN_SIDE_-T.Scrollbar.scrollbarThickness:this.MARGIN_SIDE_+T.Scrollbar.scrollbarThickness;var o=this.BODY_HEIGHT_+this.LID_HEIGHT_,i=this.top_=t.absoluteMetrics.top+this.verticalSpacing_,s=t.absoluteMetrics.top+t.viewMetrics.height-o-this.verticalSpacing_;this.top_=(t=t.toolboxMetrics.position!==T.utils.toolbox.Position.BOTTOM)?s:i;for(var n=this.getBoundingRectangle(),r=0,l;l=e[r];r++)n.intersects(l)&&(this.top_=t?l.top-o-this.MARGIN_BOTTOM_:l.bottom+this.MARGIN_BOTTOM_,n=this.getBoundingRectangle(),r=-1);this.top_=T.utils.math.clamp(i,this.top_,s),this.svgGroup_.setAttribute("transform","translate("+this.left_+","+this.top_+")")}},T.Trashcan.prototype.getBoundingRectangle=function(){return new T.utils.Rect(this.top_,this.top_+this.BODY_HEIGHT_+this.LID_HEIGHT_,this.left_,this.left_+this.WIDTH_)},T.Trashcan.prototype.getClientRect=function(){if(!this.svgGroup_)return null;var t,e=(t=this.svgGroup_.getBoundingClientRect()).top+this.SPRITE_TOP_-this.MARGIN_HOTSPOT_,t=t.left+this.SPRITE_LEFT_-this.MARGIN_HOTSPOT_;return new T.utils.Rect(e,e+this.LID_HEIGHT_+this.BODY_HEIGHT_+2*this.MARGIN_HOTSPOT_,t,t+this.WIDTH_+2*this.MARGIN_HOTSPOT_)},T.Trashcan.prototype.setLidOpen=function(t){this.isLidOpen!=t&&(clearTimeout(this.lidTask_),this.isLidOpen=t,this.animateLid_())},T.Trashcan.prototype.animateLid_=function(){var t=T.Trashcan.ANIMATION_FRAMES_,e=1/(t+1);this.lidOpen_+=this.isLidOpen?e:-e,this.lidOpen_=Math.min(Math.max(this.lidOpen_,this.minOpenness_),1),this.setLidAngle_(this.lidOpen_*T.Trashcan.MAX_LID_ANGLE_),e=T.Trashcan.OPACITY_MIN_,this.svgGroup_.style.opacity=e+this.lidOpen_*(T.Trashcan.OPACITY_MAX_-e),this.lidOpen_>this.minOpenness_&&this.lidOpen_<1&&(this.lidTask_=setTimeout(this.animateLid_.bind(this),T.Trashcan.ANIMATION_LENGTH_/t))},T.Trashcan.prototype.setLidAngle_=function(t){var e=this.workspace_.toolboxPosition==T.utils.toolbox.Position.RIGHT||this.workspace_.horizontalLayout&&this.workspace_.RTL;this.svgLid_.setAttribute("transform","rotate("+(e?-t:t)+","+(e?4:this.WIDTH_-4)+","+(this.LID_HEIGHT_-2)+")")},T.Trashcan.prototype.setMinOpenness_=function(t){this.minOpenness_=t,this.isLidOpen||this.setLidAngle_(t*T.Trashcan.MAX_LID_ANGLE_)},T.Trashcan.prototype.closeLid=function(){this.setLidOpen(!1)},T.Trashcan.prototype.click=function(){this.hasContents_()&&this.openFlyout()},T.Trashcan.prototype.fireUiEvent_=function(t){t=new(T.Events.get(T.Events.TRASHCAN_OPEN))(t,this.workspace_.id),T.Events.fire(t)},T.Trashcan.prototype.blockMouseDownWhenOpenable_=function(t){!this.contentsIsOpen()&&this.hasContents_()&&t.stopPropagation()},T.Trashcan.prototype.mouseOver_=function(){this.hasContents_()&&this.setLidOpen(!0)},T.Trashcan.prototype.mouseOut_=function(){this.setLidOpen(!1)},T.Trashcan.prototype.onDelete_=function(t){if(!(this.workspace_.options.maxTrashcanContents<=0)&&t.type==T.Events.BLOCK_DELETE&&t.oldXml.tagName&&"shadow"!=t.oldXml.tagName.toLowerCase()&&(t=this.cleanBlockXML_(t.oldXml),-1==this.contents_.indexOf(t))){for(this.contents_.unshift(t);this.contents_.length>this.workspace_.options.maxTrashcanContents;)this.contents_.pop();this.setMinOpenness_(this.HAS_BLOCKS_LID_ANGLE_)}},T.Trashcan.prototype.cleanBlockXML_=function(t){for(var e=t=t.cloneNode(!0);e;){e.removeAttribute&&(e.removeAttribute("x"),e.removeAttribute("y"),e.removeAttribute("id"),e.removeAttribute("disabled"),"comment"==e.nodeName)&&(e.removeAttribute("h"),e.removeAttribute("w"),e.removeAttribute("pinned"));var o=e.firstChild||e.nextSibling;if(!o)for(o=e.parentNode;o;){if(o.nextSibling){o=o.nextSibling;break}o=o.parentNode}e=o}return T.Xml.domToText(t)},T.VariablesDynamic={},T.VariablesDynamic.onCreateVariableButtonClick_String=function(t){T.Variables.createVariableButtonHandler(t.getTargetWorkspace(),void 0,"String")},T.VariablesDynamic.onCreateVariableButtonClick_Number=function(t){T.Variables.createVariableButtonHandler(t.getTargetWorkspace(),void 0,"Number")},T.VariablesDynamic.onCreateVariableButtonClick_Colour=function(t){T.Variables.createVariableButtonHandler(t.getTargetWorkspace(),void 0,"Colour")},T.VariablesDynamic.flyoutCategory=function(t){var e=[],o=document.createElement("button");return o.setAttribute("text",T.Msg.NEW_STRING_VARIABLE),o.setAttribute("callbackKey","CREATE_VARIABLE_STRING"),e.push(o),(o=document.createElement("button")).setAttribute("text",T.Msg.NEW_NUMBER_VARIABLE),o.setAttribute("callbackKey","CREATE_VARIABLE_NUMBER"),e.push(o),(o=document.createElement("button")).setAttribute("text",T.Msg.NEW_COLOUR_VARIABLE),o.setAttribute("callbackKey","CREATE_VARIABLE_COLOUR"),e.push(o),t.registerButtonCallback("CREATE_VARIABLE_STRING",T.VariablesDynamic.onCreateVariableButtonClick_String),t.registerButtonCallback("CREATE_VARIABLE_NUMBER",T.VariablesDynamic.onCreateVariableButtonClick_Number),t.registerButtonCallback("CREATE_VARIABLE_COLOUR",T.VariablesDynamic.onCreateVariableButtonClick_Colour),t=T.VariablesDynamic.flyoutCategoryBlocks(t),e=e.concat(t)},T.VariablesDynamic.flyoutCategoryBlocks=function(t){t=t.getAllVariables();var e=[],o,i,s;if(0<t.length&&(T.Blocks.variables_set_dynamic&&(o=t[t.length-1],(i=T.utils.xml.createElement("block")).setAttribute("type","variables_set_dynamic"),i.setAttribute("gap",24),i.appendChild(T.Variables.generateVariableFieldDom(o)),e.push(i)),T.Blocks.variables_get_dynamic)){t.sort(T.VariableModel.compareByName),o=0;for(;s=t[o];o++)(i=T.utils.xml.createElement("block")).setAttribute("type","variables_get_dynamic"),i.setAttribute("gap",8),i.appendChild(T.Variables.generateVariableFieldDom(s)),e.push(i)}return e},T.ZoomControls=function(t){this.workspace_=t,this.zoomResetGroup_=this.zoomOutGroup_=this.zoomInGroup_=this.verticalSpacing_=this.onZoomOutWrapper_=this.onZoomInWrapper_=this.onZoomResetWrapper_=null},T.ZoomControls.prototype.WIDTH_=32,T.ZoomControls.prototype.HEIGHT_=110,T.ZoomControls.prototype.MARGIN_BOTTOM_=20,T.ZoomControls.prototype.MARGIN_SIDE_=20,T.ZoomControls.prototype.svgGroup_=null,T.ZoomControls.prototype.left_=0,T.ZoomControls.prototype.top_=0,T.ZoomControls.prototype.createDom=function(){this.svgGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{},null);var t=String(Math.random()).substring(2);return this.createZoomOutSvg_(t),this.createZoomInSvg_(t),this.workspace_.isMovable()&&this.createZoomResetSvg_(t),this.svgGroup_},T.ZoomControls.prototype.init=function(t){return this.verticalSpacing_=this.MARGIN_BOTTOM_+t,this.verticalSpacing_+this.HEIGHT_},T.ZoomControls.prototype.dispose=function(){this.svgGroup_&&T.utils.dom.removeNode(this.svgGroup_),this.onZoomResetWrapper_&&T.browserEvents.unbind(this.onZoomResetWrapper_),this.onZoomInWrapper_&&T.browserEvents.unbind(this.onZoomInWrapper_),this.onZoomOutWrapper_&&T.browserEvents.unbind(this.onZoomOutWrapper_)},T.ZoomControls.prototype.getBoundingRectangle=function(){return new T.utils.Rect(this.top_,this.top_+this.HEIGHT_,this.left_,this.left_+this.WIDTH_)},T.ZoomControls.prototype.position=function(t,e){if(this.verticalSpacing_){this.left_=t.toolboxMetrics.position==T.utils.toolbox.Position.LEFT||this.workspace_.horizontalLayout&&!this.workspace_.RTL?t.viewMetrics.width+t.absoluteMetrics.left-this.WIDTH_-this.MARGIN_SIDE_-T.Scrollbar.scrollbarThickness:this.MARGIN_SIDE_+T.Scrollbar.scrollbarThickness;var o=this.top_=t.absoluteMetrics.top+this.verticalSpacing_,i=t.absoluteMetrics.top+t.viewMetrics.height-this.HEIGHT_-this.verticalSpacing_;this.top_=(t=t.toolboxMetrics.position!==T.utils.toolbox.Position.BOTTOM)?i:o,t?(this.zoomInGroup_.setAttribute("transform","translate(0, 43)"),this.zoomOutGroup_.setAttribute("transform","translate(0, 77)")):(this.zoomInGroup_.setAttribute("transform","translate(0, 34)"),this.zoomResetGroup_&&this.zoomResetGroup_.setAttribute("transform","translate(0, 77)"));for(var s=this.getBoundingRectangle(),n=0,r;r=e[n];n++)s.intersects(r)&&(this.top_=t?r.top-this.HEIGHT_-this.MARGIN_BOTTOM_:r.bottom+this.MARGIN_BOTTOM_,s=this.getBoundingRectangle(),n=-1);this.top_=T.utils.math.clamp(o,this.top_,i),this.svgGroup_.setAttribute("transform","translate("+this.left_+","+this.top_+")")}},T.ZoomControls.prototype.createZoomOutSvg_=function(t){this.zoomOutGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:"blocklyZoom"},this.svgGroup_);var e=T.utils.dom.createSvgElement(T.utils.Svg.CLIPPATH,{id:"blocklyZoomoutClipPath"+t},this.zoomOutGroup_);T.utils.dom.createSvgElement(T.utils.Svg.RECT,{width:32,height:32},e),T.utils.dom.createSvgElement(T.utils.Svg.IMAGE,{width:T.SPRITE.width,height:T.SPRITE.height,x:-64,y:-92,"clip-path":"url(#blocklyZoomoutClipPath"+t+")"},this.zoomOutGroup_).setAttributeNS(T.utils.dom.XLINK_NS,"xlink:href",T.spritesBase64),this.onZoomOutWrapper_=T.browserEvents.conditionalBind(this.zoomOutGroup_,"mousedown",null,this.zoom_.bind(this,-1))},T.ZoomControls.prototype.createZoomInSvg_=function(t){this.zoomInGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:"blocklyZoom"},this.svgGroup_);var e=T.utils.dom.createSvgElement(T.utils.Svg.CLIPPATH,{id:"blocklyZoominClipPath"+t},this.zoomInGroup_);T.utils.dom.createSvgElement(T.utils.Svg.RECT,{width:32,height:32},e),T.utils.dom.createSvgElement(T.utils.Svg.IMAGE,{width:T.SPRITE.width,height:T.SPRITE.height,x:-32,y:-92,"clip-path":"url(#blocklyZoominClipPath"+t+")"},this.zoomInGroup_).setAttributeNS(T.utils.dom.XLINK_NS,"xlink:href",T.spritesBase64),this.onZoomInWrapper_=T.browserEvents.conditionalBind(this.zoomInGroup_,"mousedown",null,this.zoom_.bind(this,1))},T.ZoomControls.prototype.zoom_=function(t,e){this.workspace_.markFocused(),this.workspace_.zoomCenter(t),this.fireZoomEvent_(),T.Touch.clearTouchIdentifier(),e.stopPropagation(),e.preventDefault()},T.ZoomControls.prototype.createZoomResetSvg_=function(t){this.zoomResetGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:"blocklyZoom"},this.svgGroup_);var e=T.utils.dom.createSvgElement(T.utils.Svg.CLIPPATH,{id:"blocklyZoomresetClipPath"+t},this.zoomResetGroup_);T.utils.dom.createSvgElement(T.utils.Svg.RECT,{width:32,height:32},e)},T.ZoomControls.prototype.resetZoom_=function(t){this.workspace_.markFocused();var e=Math.log(this.workspace_.options.zoomOptions.startScale/this.workspace_.scale)/Math.log(this.workspace_.options.zoomOptions.scaleSpeed);this.workspace_.beginCanvasTransition(),this.workspace_.zoomCenter(e),this.workspace_.scrollCenter(),setTimeout(this.workspace_.endCanvasTransition.bind(this.workspace_),500),this.fireZoomEvent_(),T.Touch.clearTouchIdentifier(),t.stopPropagation(),t.preventDefault()},T.ZoomControls.prototype.fireZoomEvent_=function(){var t=new(T.Events.get(T.Events.CLICK))(null,this.workspace_.id,"zoom_controls");T.Events.fire(t)},T.Css.register([".blocklyZoom>image, .blocklyZoom>svg>image {","opacity: .4;","}",".blocklyZoom>image:hover, .blocklyZoom>svg>image:hover {","opacity: .6;","}",".blocklyZoom>image:active, .blocklyZoom>svg>image:active {","opacity: .8;","}"]),T.ShortcutItems={},T.ShortcutItems.names={ESCAPE:"escape",DELETE:"delete",COPY:"copy",CUT:"cut",PASTE:"paste",UNDO:"undo",REDO:"redo"},T.ShortcutItems.registerEscape=function(){var t={name:T.ShortcutItems.names.ESCAPE,preconditionFn:function(t){return!t.options.readOnly},callback:function(){return T.hideChaff(),!0}};T.ShortcutRegistry.registry.register(t),T.ShortcutRegistry.registry.addKeyMapping(T.utils.KeyCodes.ESC,t.name)},T.ShortcutItems.registerDelete=function(){var t={name:T.ShortcutItems.names.DELETE,preconditionFn:function(t){return!t.options.readOnly&&T.selected&&T.selected.isDeletable()},callback:function(t,e){if(e.preventDefault(),T.Gesture.inProgress())return!1;return T.deleteBlock(T.selected),!0}};T.ShortcutRegistry.registry.register(t),T.ShortcutRegistry.registry.addKeyMapping(T.utils.KeyCodes.DELETE,t.name),T.ShortcutRegistry.registry.addKeyMapping(T.utils.KeyCodes.BACKSPACE,t.name)},T.ShortcutItems.registerCopy=function(){var t={name:T.ShortcutItems.names.COPY,preconditionFn:function(t){return!t.options.readOnly&&!T.Gesture.inProgress()&&T.selected&&T.selected.isDeletable()&&T.selected.isMovable()},callback:function(){return T.hideChaff(),T.copy(T.selected),!0}},e=(T.ShortcutRegistry.registry.register(t),T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.C,[T.utils.KeyCodes.CTRL]));T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.C,[T.utils.KeyCodes.ALT]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.C,[T.utils.KeyCodes.META]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name)},T.ShortcutItems.registerCut=function(){var t={name:T.ShortcutItems.names.CUT,preconditionFn:function(t){return!t.options.readOnly&&!T.Gesture.inProgress()&&T.selected&&T.selected.isDeletable()&&T.selected.isMovable()&&!T.selected.workspace.isFlyout},callback:function(){return T.copy(T.selected),T.deleteBlock(T.selected),!0}},e=(T.ShortcutRegistry.registry.register(t),T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.X,[T.utils.KeyCodes.CTRL]));T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.X,[T.utils.KeyCodes.ALT]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.X,[T.utils.KeyCodes.META]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name)},T.ShortcutItems.registerPaste=function(){var t={name:T.ShortcutItems.names.PASTE,preconditionFn:function(t){return!t.options.readOnly&&!T.Gesture.inProgress()},callback:function(){return T.paste()}},e=(T.ShortcutRegistry.registry.register(t),T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.V,[T.utils.KeyCodes.CTRL]));T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.V,[T.utils.KeyCodes.ALT]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.V,[T.utils.KeyCodes.META]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name)},T.ShortcutItems.registerUndo=function(){var t={name:T.ShortcutItems.names.UNDO,preconditionFn:function(t){return!t.options.readOnly&&!T.Gesture.inProgress()},callback:function(t){return T.hideChaff(),t.undo(!1),!0}},e=(T.ShortcutRegistry.registry.register(t),T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.Z,[T.utils.KeyCodes.CTRL]));T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.Z,[T.utils.KeyCodes.ALT]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.Z,[T.utils.KeyCodes.META]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name)},T.ShortcutItems.registerRedo=function(){var t={name:T.ShortcutItems.names.REDO,preconditionFn:function(t){return!T.Gesture.inProgress()&&!t.options.readOnly},callback:function(t){return T.hideChaff(),t.undo(!0),!0}},e=(T.ShortcutRegistry.registry.register(t),T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.Z,[T.utils.KeyCodes.SHIFT,T.utils.KeyCodes.CTRL]));T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.Z,[T.utils.KeyCodes.SHIFT,T.utils.KeyCodes.ALT]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.Z,[T.utils.KeyCodes.SHIFT,T.utils.KeyCodes.META]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name),e=T.ShortcutRegistry.registry.createSerializedKey(T.utils.KeyCodes.Y,[T.utils.KeyCodes.CTRL]),T.ShortcutRegistry.registry.addKeyMapping(e,t.name)},T.ShortcutItems.registerDefaultShortcuts=function(){T.ShortcutItems.registerEscape(),T.ShortcutItems.registerDelete(),T.ShortcutItems.registerCopy(),T.ShortcutItems.registerCut(),T.ShortcutItems.registerPaste(),T.ShortcutItems.registerUndo(),T.ShortcutItems.registerRedo()},T.ShortcutItems.registerDefaultShortcuts(),T.ContextMenuItems={},T.ContextMenuItems.registerUndo=function(){T.ContextMenuRegistry.registry.register({displayText:function(){return T.Msg.UNDO},preconditionFn:function(t){return 0<t.workspace.getUndoStack().length?"enabled":"disabled"},callback:function(t){t.workspace.undo(!1)},scopeType:T.ContextMenuRegistry.ScopeType.WORKSPACE,id:"undoWorkspace",weight:1})},T.ContextMenuItems.registerRedo=function(){T.ContextMenuRegistry.registry.register({displayText:function(){return T.Msg.REDO},preconditionFn:function(t){return 0<t.workspace.getRedoStack().length?"enabled":"disabled"},callback:function(t){t.workspace.undo(!0)},scopeType:T.ContextMenuRegistry.ScopeType.WORKSPACE,id:"redoWorkspace",weight:2})},T.ContextMenuItems.registerCleanup=function(){T.ContextMenuRegistry.registry.register({displayText:function(){return T.Msg.CLEAN_UP},preconditionFn:function(t){return t.workspace.isMovable()?1<t.workspace.getTopBlocks(!1).length?"enabled":"disabled":"hidden"},callback:function(t){t.workspace.cleanUp()},scopeType:T.ContextMenuRegistry.ScopeType.WORKSPACE,id:"cleanWorkspace",weight:3})},T.ContextMenuItems.toggleOption_=function(t,e){for(var o=0,i=0;i<e.length;i++)for(var s=e[i];s;)setTimeout(s.setCollapsed.bind(s,t),o),s=s.getNextBlock(),o+=10},T.ContextMenuItems.registerCollapse=function(){T.ContextMenuRegistry.registry.register({displayText:function(){return T.Msg.COLLAPSE_ALL},preconditionFn:function(t){if(t.workspace.options.collapse){t=t.workspace.getTopBlocks(!1);for(var e=0;e<t.length;e++)for(var o=t[e];o;){if(!o.isCollapsed())return"enabled";o=o.getNextBlock()}return"disabled"}return"hidden"},callback:function(t){T.ContextMenuItems.toggleOption_(!0,t.workspace.getTopBlocks(!0))},scopeType:T.ContextMenuRegistry.ScopeType.WORKSPACE,id:"collapseWorkspace",weight:4})},T.ContextMenuItems.registerExpand=function(){T.ContextMenuRegistry.registry.register({displayText:function(){return T.Msg.EXPAND_ALL},preconditionFn:function(t){if(t.workspace.options.collapse){t=t.workspace.getTopBlocks(!1);for(var e=0;e<t.length;e++)for(var o=t[e];o;){if(o.isCollapsed())return"enabled";o=o.getNextBlock()}return"disabled"}return"hidden"},callback:function(t){T.ContextMenuItems.toggleOption_(!1,t.workspace.getTopBlocks(!0))},scopeType:T.ContextMenuRegistry.ScopeType.WORKSPACE,id:"expandWorkspace",weight:5})},T.ContextMenuItems.addDeletableBlocks_=function(t,e){if(t.isDeletable())Array.prototype.push.apply(e,t.getDescendants(!1));else{t=t.getChildren(!1);for(var o=0;o<t.length;o++)T.ContextMenuItems.addDeletableBlocks_(t[o],e)}},T.ContextMenuItems.getDeletableBlocks_=function(t){var e=[];t=t.getTopBlocks(!0);for(var o=0;o<t.length;o++)T.ContextMenuItems.addDeletableBlocks_(t[o],e);return e},T.ContextMenuItems.deleteNext_=function(t,e){T.Events.setGroup(e);var o=t.shift();o&&(o.workspace?(o.dispose(!1,!0),setTimeout(T.ContextMenuItems.deleteNext_,10,t,e)):T.ContextMenuItems.deleteNext_(t,e)),T.Events.setGroup(!1)},T.ContextMenuItems.registerDeleteAll=function(){T.ContextMenuRegistry.registry.register({displayText:function(t){if(t.workspace)return 1==(t=T.ContextMenuItems.getDeletableBlocks_(t.workspace).length)?T.Msg.DELETE_BLOCK:T.Msg.DELETE_X_BLOCKS.replace("%1",String(t))},preconditionFn:function(t){if(t.workspace)return 0<T.ContextMenuItems.getDeletableBlocks_(t.workspace).length?"enabled":"disabled"},callback:function(t){var e,o;t.workspace&&(t.workspace.cancelCurrentGesture(),e=T.ContextMenuItems.getDeletableBlocks_(t.workspace),o=T.utils.genUid(),e.length<2?T.ContextMenuItems.deleteNext_(e,o):T.confirm(T.Msg.DELETE_ALL_BLOCKS.replace("%1",e.length),function(t){t&&T.ContextMenuItems.deleteNext_(e,o)}))},scopeType:T.ContextMenuRegistry.ScopeType.WORKSPACE,id:"workspaceDelete",weight:6})},T.ContextMenuItems.registerWorkspaceOptions_=function(){T.ContextMenuItems.registerUndo(),T.ContextMenuItems.registerRedo(),T.ContextMenuItems.registerCleanup(),T.ContextMenuItems.registerCollapse(),T.ContextMenuItems.registerExpand(),T.ContextMenuItems.registerDeleteAll()},T.ContextMenuItems.registerDuplicate=function(){T.ContextMenuRegistry.registry.register({displayText:function(){return T.Msg.DUPLICATE_BLOCK},preconditionFn:function(t){return!(t=t.block).isInFlyout&&t.isDeletable()&&t.isMovable()?t.isDuplicatable()?"enabled":"disabled":"hidden"},callback:function(t){t.block&&T.duplicate(t.block)},scopeType:T.ContextMenuRegistry.ScopeType.BLOCK,id:"blockDuplicate",weight:1})},T.ContextMenuItems.registerComment=function(){T.ContextMenuRegistry.registry.register({displayText:function(t){return t.block.getCommentIcon()?T.Msg.REMOVE_COMMENT:T.Msg.ADD_COMMENT},preconditionFn:function(t){return t=t.block,T.utils.userAgent.IE||t.isInFlyout||!t.workspace.options.comments||t.isCollapsed()||!t.isEditable()?"hidden":"enabled"},callback:function(t){(t=t.block).getCommentIcon()?t.setCommentText(null):t.setCommentText("")},scopeType:T.ContextMenuRegistry.ScopeType.BLOCK,id:"blockComment",weight:2})},T.ContextMenuItems.registerInline=function(){T.ContextMenuRegistry.registry.register({displayText:function(t){return t.block.getInputsInline()?T.Msg.EXTERNAL_INPUTS:T.Msg.INLINE_INPUTS},preconditionFn:function(t){if(!(t=t.block).isInFlyout&&t.isMovable()&&!t.isCollapsed())for(var e=1;e<t.inputList.length;e++)if(t.inputList[e-1].type!=T.inputTypes.STATEMENT&&t.inputList[e].type!=T.inputTypes.STATEMENT)return"enabled";return"hidden"},callback:function(t){t.block.setInputsInline(!t.block.getInputsInline())},scopeType:T.ContextMenuRegistry.ScopeType.BLOCK,id:"blockInline",weight:3})},T.ContextMenuItems.registerCollapseExpandBlock=function(){T.ContextMenuRegistry.registry.register({displayText:function(t){return t.block.isCollapsed()?T.Msg.EXPAND_BLOCK:T.Msg.COLLAPSE_BLOCK},preconditionFn:function(t){return!(t=t.block).isInFlyout&&t.isMovable()?"enabled":"hidden"},callback:function(t){t.block.setCollapsed(!t.block.isCollapsed())},scopeType:T.ContextMenuRegistry.ScopeType.BLOCK,id:"blockCollapseExpand",weight:4})},T.ContextMenuItems.registerDisable=function(){T.ContextMenuRegistry.registry.register({displayText:function(t){return t.block.isEnabled()?T.Msg.DISABLE_BLOCK:T.Msg.ENABLE_BLOCK},preconditionFn:function(t){return!(t=t.block).isInFlyout&&t.workspace.options.disable&&t.isEditable()?t.getInheritedDisabled()?"disabled":"enabled":"hidden"},callback:function(t){t=t.block;var e=T.Events.getGroup();e||T.Events.setGroup(!0),t.setEnabled(!t.isEnabled()),e||T.Events.setGroup(!1)},scopeType:T.ContextMenuRegistry.ScopeType.BLOCK,id:"blockDisable",weight:5})},T.ContextMenuItems.registerDelete=function(){T.ContextMenuRegistry.registry.register({displayText:function(t){var e=t.block;return t=e.getDescendants(!1).length,(e=e.getNextBlock())&&(t-=e.getDescendants(!1).length),1==t?T.Msg.DELETE_BLOCK:T.Msg.DELETE_X_BLOCKS.replace("%1",String(t))},preconditionFn:function(t){return!t.block.isInFlyout&&t.block.isDeletable()?"enabled":"hidden"},callback:function(t){T.Events.setGroup(!0),t.block.dispose(!0,!0),T.Events.setGroup(!1)},scopeType:T.ContextMenuRegistry.ScopeType.BLOCK,id:"blockDelete",weight:6})},T.ContextMenuItems.registerHelp=function(){T.ContextMenuRegistry.registry.register({displayText:function(){return T.Msg.HELP},preconditionFn:function(t){return("function"==typeof(t=t.block).helpUrl?t.helpUrl():t.helpUrl)?"enabled":"hidden"},callback:function(t){t.block.showHelp()},scopeType:T.ContextMenuRegistry.ScopeType.BLOCK,id:"blockHelp",weight:7})},T.ContextMenuItems.registerBlockOptions_=function(){T.ContextMenuItems.registerDuplicate(),T.ContextMenuItems.registerComment(),T.ContextMenuItems.registerInline(),T.ContextMenuItems.registerCollapseExpandBlock(),T.ContextMenuItems.registerDisable(),T.ContextMenuItems.registerDelete(),T.ContextMenuItems.registerHelp()},T.ContextMenuItems.registerDefaultOptions=function(){T.ContextMenuItems.registerWorkspaceOptions_(),T.ContextMenuItems.registerBlockOptions_()},T.ContextMenuItems.registerDefaultOptions(),T.Mutator=function(t){T.Mutator.superClass_.constructor.call(this,null),this.quarkNames_=t},T.utils.object.inherits(T.Mutator,T.Icon),T.Mutator.prototype.workspaceWidth_=0,T.Mutator.prototype.workspaceHeight_=0,T.Mutator.prototype.setBlock=function(t){this.block_=t},T.Mutator.prototype.getWorkspace=function(){return this.workspace_},T.Mutator.prototype.drawIcon_=function(t){T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blocklyIconShape",rx:"4",ry:"4",height:"16",width:"16"},t),T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyIconSymbol",d:"m4.203,7.296 0,1.368 -0.92,0.677 -0.11,0.41 0.9,1.559 0.41,0.11 1.043,-0.457 1.187,0.683 0.127,1.134 0.3,0.3 1.8,0 0.3,-0.299 0.127,-1.138 1.185,-0.682 1.046,0.458 0.409,-0.11 0.9,-1.559 -0.11,-0.41 -0.92,-0.677 0,-1.366 0.92,-0.677 0.11,-0.41 -0.9,-1.559 -0.409,-0.109 -1.046,0.458 -1.185,-0.682 -0.127,-1.138 -0.3,-0.299 -1.8,0 -0.3,0.3 -0.126,1.135 -1.187,0.682 -1.043,-0.457 -0.41,0.11 -0.899,1.559 0.108,0.409z"},t),T.utils.dom.createSvgElement(T.utils.Svg.CIRCLE,{class:"blocklyIconShape",r:"2.7",cx:"8",cy:"8"},t)},T.Mutator.prototype.iconClick_=function(t){this.block_.isEditable()&&T.Icon.prototype.iconClick_.call(this,t)},T.Mutator.prototype.createEditor_=function(){if(this.svgDialog_=T.utils.dom.createSvgElement(T.utils.Svg.SVG,{x:T.Bubble.BORDER_WIDTH,y:T.Bubble.BORDER_WIDTH},null),this.quarkNames_.length)for(var t=T.utils.xml.createElement("xml"),e=0,o;o=this.quarkNames_[e];e++){var i=T.utils.xml.createElement("block");i.setAttribute("type",o),t.appendChild(i)}else t=null;return(e=new T.Options({disable:!1,parentWorkspace:this.block_.workspace,media:this.block_.workspace.options.pathToMedia,rtl:this.block_.RTL,horizontalLayout:!1,renderer:this.block_.workspace.options.renderer,rendererOverrides:this.block_.workspace.options.rendererOverrides})).toolboxPosition=this.block_.RTL?T.utils.toolbox.Position.RIGHT:T.utils.toolbox.Position.LEFT,(o=!!t)&&(e.languageTree=T.utils.toolbox.convertToolboxDefToJson(t)),this.workspace_=new T.WorkspaceSvg(e),this.workspace_.isMutator=!0,this.workspace_.addChangeListener(T.Events.disableOrphans),t=o?this.workspace_.addFlyout(T.utils.Svg.G):null,e=this.workspace_.createDom("blocklyMutatorBackground"),t&&e.insertBefore(t,this.workspace_.svgBlockCanvas_),this.svgDialog_.appendChild(e),this.svgDialog_},T.Mutator.prototype.updateEditable=function(){T.Mutator.superClass_.updateEditable.call(this),this.block_.isInFlyout||(this.block_.isEditable()?this.iconGroup_&&T.utils.dom.removeClass(this.iconGroup_,"blocklyIconGroupReadonly"):(this.setVisible(!1),this.iconGroup_&&T.utils.dom.addClass(this.iconGroup_,"blocklyIconGroupReadonly")))},T.Mutator.prototype.resizeBubble_=function(){var t=2*T.Bubble.BORDER_WIDTH,e=this.workspace_.getCanvas().getBBox(),o=e.width+e.x,i=e.height+3*t,s=this.workspace_.getFlyout(),n,i;s&&(n=s.getWorkspace().getMetricsManager().getScrollMetrics(),i=Math.max(i,n.height+20),o+=s.getWidth()),this.block_.RTL&&(o=-e.x),o+=3*t,(Math.abs(this.workspaceWidth_-o)>t||Math.abs(this.workspaceHeight_-i)>t)&&(this.workspaceWidth_=o,this.workspaceHeight_=i,this.bubble_.setBubbleSize(o+t,i+t),this.svgDialog_.setAttribute("width",this.workspaceWidth_),this.svgDialog_.setAttribute("height",this.workspaceHeight_),this.workspace_.setCachedParentSvgSize(this.workspaceWidth_,this.workspaceHeight_)),this.block_.RTL&&(t="translate("+this.workspaceWidth_+",0)",this.workspace_.getCanvas().setAttribute("transform",t)),this.workspace_.resize()},T.Mutator.prototype.onBubbleMove_=function(){this.workspace_&&this.workspace_.recordDeleteAreas()},T.Mutator.prototype.setVisible=function(t){if(t!=this.isVisible())if(T.Events.fire(new(T.Events.get(T.Events.BUBBLE_OPEN))(this.block_,t,"mutator")),t){this.bubble_=new T.Bubble(this.block_.workspace,this.createEditor_(),this.block_.pathObject.svgPath,this.iconXY_,null,null),this.bubble_.setSvgId(this.block_.id),this.bubble_.registerMoveEvent(this.onBubbleMove_.bind(this));var e=this.workspace_.options.languageTree;t=this.workspace_.getFlyout(),e&&(t.init(this.workspace_),t.show(e)),this.rootBlock_=this.block_.decompose(this.workspace_);for(var e=this.rootBlock_.getDescendants(!1),o=0,i,s,n;i=e[o];o++)i.render();this.rootBlock_.setMovable(!1),this.rootBlock_.setDeletable(!1),t=t?(e=2*t.CORNER_RADIUS,this.rootBlock_.RTL?t.getWidth()+e:e):e=16,this.block_.RTL&&(t=-t),this.rootBlock_.moveBy(t,e),this.block_.saveConnections&&((n=(s=this).block_).saveConnections(this.rootBlock_),this.sourceListener_=function(){n.saveConnections(s.rootBlock_)},this.block_.workspace.addChangeListener(this.sourceListener_)),this.resizeBubble_(),this.workspace_.addChangeListener(this.workspaceChanged_.bind(this)),this.applyColour()}else this.svgDialog_=null,this.workspace_.dispose(),this.rootBlock_=this.workspace_=null,this.bubble_.dispose(),this.bubble_=null,this.workspaceHeight_=this.workspaceWidth_=0,this.sourceListener_&&(this.block_.workspace.removeChangeListener(this.sourceListener_),this.sourceListener_=null)},T.Mutator.prototype.workspaceChanged_=function(t){if(!(t.isUiEvent||t.type==T.Events.CHANGE&&"disabled"==t.element)){if(!this.workspace_.isDragging()){t=this.workspace_.getTopBlocks(!1);for(var e=0,o;o=t[e];e++){var i=o.getRelativeToSurfaceXY(),s,n;i.y<20&&o.moveBy(0,20-i.y),o.RTL?(s=-20,(n=this.workspace_.getFlyout())&&(s-=n.getWidth()),i.x>s&&o.moveBy(s-i.x,0)):i.x<20&&o.moveBy(20-i.x,0)}}var r;this.rootBlock_.workspace==this.workspace_&&(T.Events.setGroup(!0),t=(t=(o=this.block_).mutationToDom())&&T.Xml.domToText(t),e=o.rendered,o.rendered=!1,o.compose(this.rootBlock_),o.rendered=e,o.initSvg(),o.rendered&&o.render(),t!=(e=(e=o.mutationToDom())&&T.Xml.domToText(e))&&(T.Events.fire(new(T.Events.get(T.Events.BLOCK_CHANGE))(o,"mutation",null,t,e)),r=T.Events.getGroup(),setTimeout(function(){T.Events.setGroup(r),o.bumpNeighbours(),T.Events.setGroup(!1)},T.BUMP_DELAY)),this.workspace_.isDragging()||this.resizeBubble_(),T.Events.setGroup(!1))}},T.Mutator.prototype.dispose=function(){this.block_.mutator=null,T.Icon.prototype.dispose.call(this)},T.Mutator.prototype.updateBlockStyle=function(){var t=this.workspace_;if(t&&t.getAllBlocks(!1)){for(var e=t.getAllBlocks(!1),o=0;o<e.length;o++){var i=e[o];i.setStyle(i.getStyleName())}if(o=t.getFlyout())for(t=o.workspace_.getAllBlocks(!1),o=0;o<t.length;o++)(i=t[o]).setStyle(i.getStyleName())}},T.Mutator.reconnect=function(t,e,o){if(!t||!t.getSourceBlock().workspace)return!1;o=e.getInput(o).connection;var i=t.targetBlock();return!(i&&i!=e||o.targetConnection==t||(o.isConnected()&&o.disconnect(),o.connect(t),0))},T.Mutator.findParentWs=function(t){var e=null,o;return t&&t.options&&(o=t.options.parentWorkspace,t.isFlyout?o&&o.options&&(e=o.options.parentWorkspace):o&&(e=o)),e},T.FieldTextInput=function(t,e,o){this.spellcheck_=!0,T.FieldTextInput.superClass_.constructor.call(this,t,e,o),this.onKeyInputWrapper_=this.onKeyDownWrapper_=this.htmlInput_=null,this.fullBlockClickTarget_=!1,this.workspace_=null},T.utils.object.inherits(T.FieldTextInput,T.Field),T.FieldTextInput.prototype.DEFAULT_VALUE="",T.FieldTextInput.fromJson=function(t){var e=T.utils.replaceMessageReferences(t.text);return new T.FieldTextInput(e,void 0,t)},T.FieldTextInput.prototype.SERIALIZABLE=!0,T.FieldTextInput.BORDERRADIUS=4,T.FieldTextInput.prototype.CURSOR="text",T.FieldTextInput.prototype.configure_=function(t){T.FieldTextInput.superClass_.configure_.call(this,t),"boolean"==typeof t.spellcheck&&(this.spellcheck_=t.spellcheck)},T.FieldTextInput.prototype.initView=function(){if(this.getConstants().FULL_BLOCK_FIELDS){for(var t=0,e=0,o=0,i;i=this.sourceBlock_.inputList[o];o++){for(var s=0;i.fieldRow[s];s++)t++;i.connection&&e++}this.fullBlockClickTarget_=t<=1&&this.sourceBlock_.outputConnection&&!e}else this.fullBlockClickTarget_=!1;this.fullBlockClickTarget_?this.clickTarget_=this.sourceBlock_.getSvgRoot():this.createBorderRect_(),this.createTextElement_()},T.FieldTextInput.prototype.doClassValidation_=function(t){return null==t?null:String(t)},T.FieldTextInput.prototype.doValueInvalid_=function(t){this.isBeingEdited_&&(this.isTextValid_=!1,t=this.value_,this.value_=this.htmlInput_.untypedDefaultValue_,this.sourceBlock_)&&T.Events.isEnabled()&&T.Events.fire(new(T.Events.get(T.Events.BLOCK_CHANGE))(this.sourceBlock_,"field",this.name||null,t,this.value_))},T.FieldTextInput.prototype.doValueUpdate_=function(t){this.isTextValid_=!0,this.value_=t,this.isBeingEdited_||(this.isDirty_=!0)},T.FieldTextInput.prototype.applyColour=function(){this.sourceBlock_&&this.getConstants().FULL_BLOCK_FIELDS&&(this.borderRect_?this.borderRect_.setAttribute("stroke",this.sourceBlock_.style.colourTertiary):this.sourceBlock_.pathObject.svgPath.setAttribute("fill",this.getConstants().FIELD_BORDER_RECT_COLOUR))},T.FieldTextInput.prototype.render_=function(){var t;T.FieldTextInput.superClass_.render_.call(this),this.isBeingEdited_&&(this.resizeEditor_(),t=this.htmlInput_,this.isTextValid_?(T.utils.dom.removeClass(t,"blocklyInvalidInput"),T.utils.aria.setState(t,T.utils.aria.State.INVALID,!1)):(T.utils.dom.addClass(t,"blocklyInvalidInput"),T.utils.aria.setState(t,T.utils.aria.State.INVALID,!0)))},T.FieldTextInput.prototype.setSpellcheck=function(t){t!=this.spellcheck_&&(this.spellcheck_=t,this.htmlInput_)&&this.htmlInput_.setAttribute("spellcheck",this.spellcheck_)},T.FieldTextInput.prototype.showEditor_=function(t,e){this.workspace_=this.sourceBlock_.workspace,!(t=e||!1)&&(T.utils.userAgent.MOBILE||T.utils.userAgent.ANDROID||T.utils.userAgent.IPAD)?this.showPromptEditor_():this.showInlineEditor_(t)},T.FieldTextInput.prototype.showPromptEditor_=function(){T.prompt(T.Msg.CHANGE_VALUE_TITLE,this.getText(),function(t){this.setValue(this.getValueFromEditorText_(t))}.bind(this))},T.FieldTextInput.prototype.showInlineEditor_=function(t){T.WidgetDiv.show(this,this.sourceBlock_.RTL,this.widgetDispose_.bind(this)),this.htmlInput_=this.widgetCreate_(),this.isBeingEdited_=!0,t||(this.htmlInput_.focus({preventScroll:!0}),this.htmlInput_.select())},T.FieldTextInput.prototype.widgetCreate_=function(){var t=T.WidgetDiv.DIV,e=(T.utils.dom.addClass(this.getClickTarget_(),"editing"),document.createElement("input")),o=(e.className="blocklyHtmlInput",e.setAttribute("spellcheck",this.spellcheck_),this.workspace_.getScale()),i=this.getConstants().FIELD_TEXT_FONTSIZE*o+"pt",i,s;return t.style.fontSize=i,e.style.fontSize=i,i=T.FieldTextInput.BORDERRADIUS*o+"px",this.fullBlockClickTarget_&&(i=((i=this.getScaledBBox()).bottom-i.top)/2+"px",s=(this.sourceBlock_.getParent()?this.sourceBlock_.getParent():this.sourceBlock_).style.colourTertiary,e.style.border=1*o+"px solid "+s,t.style.borderRadius=i,t.style.transition="box-shadow 0.25s ease 0s",this.getConstants().FIELD_TEXTINPUT_BOX_SHADOW)&&(t.style.boxShadow="rgba(255, 255, 255, 0.3) 0px 0px 0px "+4*o+"px"),e.style.borderRadius=i,t.appendChild(e),e.value=e.defaultValue=this.getEditorText_(this.value_),e.untypedDefaultValue_=this.value_,e.oldValue_=null,this.resizeEditor_(),this.bindInputEvents_(e),e},T.FieldTextInput.prototype.widgetDispose_=function(){this.isBeingEdited_=!1,this.isTextValid_=!0,this.forceRerender(),this.onFinishEditing_&&this.onFinishEditing_(this.value_),this.unbindInputEvents_();var t=T.WidgetDiv.DIV.style;t.width="auto",t.height="auto",t.fontSize="",t.transition="",t.boxShadow="",this.htmlInput_=null,T.utils.dom.removeClass(this.getClickTarget_(),"editing")},T.FieldTextInput.prototype.bindInputEvents_=function(t){this.onKeyDownWrapper_=T.browserEvents.conditionalBind(t,"keydown",this,this.onHtmlInputKeyDown_),this.onKeyInputWrapper_=T.browserEvents.conditionalBind(t,"input",this,this.onHtmlInputChange_)},T.FieldTextInput.prototype.unbindInputEvents_=function(){this.onKeyDownWrapper_&&(T.browserEvents.unbind(this.onKeyDownWrapper_),this.onKeyDownWrapper_=null),this.onKeyInputWrapper_&&(T.browserEvents.unbind(this.onKeyInputWrapper_),this.onKeyInputWrapper_=null)},T.FieldTextInput.prototype.onHtmlInputKeyDown_=function(t){t.keyCode==T.utils.KeyCodes.ENTER?(T.WidgetDiv.hide(),T.DropDownDiv.hideWithoutAnimation()):t.keyCode==T.utils.KeyCodes.ESC?(this.htmlInput_.value=this.htmlInput_.defaultValue,T.WidgetDiv.hide(),T.DropDownDiv.hideWithoutAnimation()):t.keyCode==T.utils.KeyCodes.TAB&&(T.WidgetDiv.hide(),T.DropDownDiv.hideWithoutAnimation(),this.sourceBlock_.tab(this,!t.shiftKey),t.preventDefault())},T.FieldTextInput.prototype.onHtmlInputChange_=function(t){(t=this.htmlInput_.value)!==this.htmlInput_.oldValue_&&(this.htmlInput_.oldValue_=t,T.Events.setGroup(!0),t=this.getValueFromEditorText_(t),this.setValue(t),this.forceRerender(),this.resizeEditor_(),T.Events.setGroup(!1))},T.FieldTextInput.prototype.setEditorValue_=function(t){this.isDirty_=!0,this.isBeingEdited_&&(this.htmlInput_.value=this.getEditorText_(t)),this.setValue(t)},T.FieldTextInput.prototype.resizeEditor_=function(){var t=T.WidgetDiv.DIV,e=this.getScaledBBox();t.style.width=e.right-e.left+"px",t.style.height=e.bottom-e.top+"px",e=new T.utils.Coordinate(this.sourceBlock_.RTL?e.right-t.offsetWidth:e.left,e.top),t.style.left=e.x+"px",t.style.top=e.y+"px"},T.FieldTextInput.prototype.isTabNavigable=function(){return!0},T.FieldTextInput.prototype.getText_=function(){return this.isBeingEdited_&&this.htmlInput_?this.htmlInput_.value:null},T.FieldTextInput.prototype.getEditorText_=function(t){return String(t)},T.FieldTextInput.prototype.getValueFromEditorText_=function(t){return t},T.fieldRegistry.register("field_input",T.FieldTextInput),T.FieldAngle=function(t,e,o){this.clockwise_=T.FieldAngle.CLOCKWISE,this.offset_=T.FieldAngle.OFFSET,this.wrap_=T.FieldAngle.WRAP,this.round_=T.FieldAngle.ROUND,T.FieldAngle.superClass_.constructor.call(this,t,e,o),this.moveSurfaceWrapper_=this.clickSurfaceWrapper_=this.clickWrapper_=this.line_=this.gauge_=null},T.utils.object.inherits(T.FieldAngle,T.FieldTextInput),T.FieldAngle.prototype.DEFAULT_VALUE=0,T.FieldAngle.fromJson=function(t){return new T.FieldAngle(t.angle,void 0,t)},T.FieldAngle.prototype.SERIALIZABLE=!0,T.FieldAngle.ROUND=15,T.FieldAngle.HALF=50,T.FieldAngle.CLOCKWISE=!1,T.FieldAngle.OFFSET=0,T.FieldAngle.WRAP=360,T.FieldAngle.RADIUS=T.FieldAngle.HALF-1,T.FieldAngle.prototype.configure_=function(t){switch(T.FieldAngle.superClass_.configure_.call(this,t),t.mode){case"compass":this.clockwise_=!0,this.offset_=90;break;case"protractor":this.clockwise_=!1,this.offset_=0}var e=t.clockwise;"boolean"==typeof e&&(this.clockwise_=e),null!=(e=t.offset)&&(e=Number(e),isNaN(e)||(this.offset_=e)),null!=(e=t.wrap)&&(e=Number(e),isNaN(e)||(this.wrap_=e)),null!=(t=t.round)&&(t=Number(t),isNaN(t)||(this.round_=t))},T.FieldAngle.prototype.initView=function(){T.FieldAngle.superClass_.initView.call(this),this.symbol_=T.utils.dom.createSvgElement(T.utils.Svg.TSPAN,{},null),this.symbol_.appendChild(document.createTextNode("°")),this.textElement_.appendChild(this.symbol_)},T.FieldAngle.prototype.render_=function(){T.FieldAngle.superClass_.render_.call(this),this.updateGraph_()},T.FieldAngle.prototype.showEditor_=function(t){T.FieldAngle.superClass_.showEditor_.call(this,t,T.utils.userAgent.MOBILE||T.utils.userAgent.ANDROID||T.utils.userAgent.IPAD),t=this.dropdownCreate_(),T.DropDownDiv.getContentDiv().appendChild(t),T.DropDownDiv.setColour(this.sourceBlock_.style.colourPrimary,this.sourceBlock_.style.colourTertiary),T.DropDownDiv.showPositionedByField(this,this.dropdownDispose_.bind(this)),this.updateGraph_()},T.FieldAngle.prototype.dropdownCreate_=function(){var t=T.utils.dom.createSvgElement(T.utils.Svg.SVG,{xmlns:T.utils.dom.SVG_NS,"xmlns:html":T.utils.dom.HTML_NS,"xmlns:xlink":T.utils.dom.XLINK_NS,version:"1.1",height:2*T.FieldAngle.HALF+"px",width:2*T.FieldAngle.HALF+"px",style:"touch-action: none"},null),e=T.utils.dom.createSvgElement(T.utils.Svg.CIRCLE,{cx:T.FieldAngle.HALF,cy:T.FieldAngle.HALF,r:T.FieldAngle.RADIUS,class:"blocklyAngleCircle"},t);this.gauge_=T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyAngleGauge"},t),this.line_=T.utils.dom.createSvgElement(T.utils.Svg.LINE,{x1:T.FieldAngle.HALF,y1:T.FieldAngle.HALF,class:"blocklyAngleLine"},t);for(var o=0;o<360;o+=15)T.utils.dom.createSvgElement(T.utils.Svg.LINE,{x1:T.FieldAngle.HALF+T.FieldAngle.RADIUS,y1:T.FieldAngle.HALF,x2:T.FieldAngle.HALF+T.FieldAngle.RADIUS-(0==o%45?10:5),y2:T.FieldAngle.HALF,class:"blocklyAngleMarks",transform:"rotate("+o+","+T.FieldAngle.HALF+","+T.FieldAngle.HALF+")"},t);return this.clickWrapper_=T.browserEvents.conditionalBind(t,"click",this,this.hide_),this.clickSurfaceWrapper_=T.browserEvents.conditionalBind(e,"click",this,this.onMouseMove_,!0,!0),this.moveSurfaceWrapper_=T.browserEvents.conditionalBind(e,"mousemove",this,this.onMouseMove_,!0,!0),t},T.FieldAngle.prototype.dropdownDispose_=function(){this.clickWrapper_&&(T.browserEvents.unbind(this.clickWrapper_),this.clickWrapper_=null),this.clickSurfaceWrapper_&&(T.browserEvents.unbind(this.clickSurfaceWrapper_),this.clickSurfaceWrapper_=null),this.moveSurfaceWrapper_&&(T.browserEvents.unbind(this.moveSurfaceWrapper_),this.moveSurfaceWrapper_=null),this.line_=this.gauge_=null},T.FieldAngle.prototype.hide_=function(){T.DropDownDiv.hideIfOwner(this),T.WidgetDiv.hide()},T.FieldAngle.prototype.onMouseMove_=function(t){var e=this.gauge_.ownerSVGElement.getBoundingClientRect(),o=t.clientX-e.left-T.FieldAngle.HALF;t=t.clientY-e.top-T.FieldAngle.HALF,e=Math.atan(-t/o),isNaN(e)||(e=T.utils.math.toDegrees(e),o<0?e+=180:0<t&&(e+=360),e=this.clockwise_?this.offset_+360-e:360-(this.offset_-e),this.displayMouseOrKeyboardValue_(e))},T.FieldAngle.prototype.displayMouseOrKeyboardValue_=function(t){this.round_&&(t=Math.round(t/this.round_)*this.round_),(t=this.wrapValue_(t))!=this.value_&&this.setEditorValue_(t)},T.FieldAngle.prototype.updateGraph_=function(){var t,e,t,o,i,s,n,r,l;this.gauge_&&(t=Number(this.getText())+this.offset_,e=T.utils.math.toRadians(t%360),t=["M ",T.FieldAngle.HALF,",",T.FieldAngle.HALF],o=T.FieldAngle.HALF,i=T.FieldAngle.HALF,isNaN(e)||(s=Number(this.clockwise_),n=T.utils.math.toRadians(this.offset_),r=Math.cos(n)*T.FieldAngle.RADIUS,l=Math.sin(n)*-T.FieldAngle.RADIUS,s&&(e=2*n-e),o+=Math.cos(e)*T.FieldAngle.RADIUS,i-=Math.sin(e)*T.FieldAngle.RADIUS,e=Math.abs(Math.floor((e-n)/Math.PI)%2),t.push(" l ",r,",",l," A ",T.FieldAngle.RADIUS,",",T.FieldAngle.RADIUS," 0 ",e=s?1-e:e," ",s," ",o,",",i," z")),this.gauge_.setAttribute("d",t.join("")),this.line_.setAttribute("x2",o),this.line_.setAttribute("y2",i))},T.FieldAngle.prototype.onHtmlInputKeyDown_=function(t){var e,o;T.FieldAngle.superClass_.onHtmlInputKeyDown_.call(this,t),t.keyCode===T.utils.KeyCodes.LEFT?e=this.sourceBlock_.RTL?1:-1:t.keyCode===T.utils.KeyCodes.RIGHT?e=this.sourceBlock_.RTL?-1:1:t.keyCode===T.utils.KeyCodes.DOWN?e=-1:t.keyCode===T.utils.KeyCodes.UP&&(e=1),e&&(o=this.getValue(),this.displayMouseOrKeyboardValue_(o+e*this.round_),t.preventDefault(),t.stopPropagation())},T.FieldAngle.prototype.doClassValidation_=function(t){return t=Number(t),isNaN(t)||!isFinite(t)?null:this.wrapValue_(t)},T.FieldAngle.prototype.wrapValue_=function(t){return(t%=360)<0&&(t+=360),t>this.wrap_&&(t-=360),t},T.Css.register(".blocklyAngleCircle {,stroke: #444;,stroke-width: 1;,fill: #ddd;,fill-opacity: .8;,},.blocklyAngleMarks {,stroke: #444;,stroke-width: 1;,},.blocklyAngleGauge {,fill: #f88;,fill-opacity: .8;,pointer-events: none;,},.blocklyAngleLine {,stroke: #f00;,stroke-width: 2;,stroke-linecap: round;,pointer-events: none;,}".split(",")),T.fieldRegistry.register("field_angle",T.FieldAngle),T.FieldCheckbox=function(t,e,o){this.checkChar_=null,T.FieldCheckbox.superClass_.constructor.call(this,t,e,o)},T.utils.object.inherits(T.FieldCheckbox,T.Field),T.FieldCheckbox.prototype.DEFAULT_VALUE=!1,T.FieldCheckbox.fromJson=function(t){return new T.FieldCheckbox(t.checked,void 0,t)},T.FieldCheckbox.CHECK_CHAR="✓",T.FieldCheckbox.prototype.SERIALIZABLE=!0,T.FieldCheckbox.prototype.CURSOR="default",T.FieldCheckbox.prototype.configure_=function(t){T.FieldCheckbox.superClass_.configure_.call(this,t),t.checkCharacter&&(this.checkChar_=t.checkCharacter)},T.FieldCheckbox.prototype.initView=function(){T.FieldCheckbox.superClass_.initView.call(this),T.utils.dom.addClass(this.textElement_,"blocklyCheckbox"),this.textElement_.style.display=this.value_?"block":"none"},T.FieldCheckbox.prototype.render_=function(){this.textContent_&&(this.textContent_.nodeValue=this.getDisplayText_()),this.updateSize_(this.getConstants().FIELD_CHECKBOX_X_OFFSET)},T.FieldCheckbox.prototype.getDisplayText_=function(){return this.checkChar_||T.FieldCheckbox.CHECK_CHAR},T.FieldCheckbox.prototype.setCheckCharacter=function(t){this.checkChar_=t,this.forceRerender()},T.FieldCheckbox.prototype.showEditor_=function(){this.setValue(!this.value_)},T.FieldCheckbox.prototype.doClassValidation_=function(t){return!0===t||"TRUE"===t?"TRUE":!1===t||"FALSE"===t?"FALSE":null},T.FieldCheckbox.prototype.doValueUpdate_=function(t){this.value_=this.convertValueToBool_(t),this.textElement_&&(this.textElement_.style.display=this.value_?"block":"none")},T.FieldCheckbox.prototype.getValue=function(){return this.value_?"TRUE":"FALSE"},T.FieldCheckbox.prototype.getValueBoolean=function(){return this.value_},T.FieldCheckbox.prototype.getText=function(){return String(this.convertValueToBool_(this.value_))},T.FieldCheckbox.prototype.convertValueToBool_=function(t){return"string"==typeof t?"TRUE"==t:!!t},T.fieldRegistry.register("field_checkbox",T.FieldCheckbox),T.FieldColour=function(t,e,o){T.FieldColour.superClass_.constructor.call(this,t,e,o),this.onKeyDownWrapper_=this.onMouseLeaveWrapper_=this.onMouseEnterWrapper_=this.onMouseMoveWrapper_=this.onClickWrapper_=this.highlightedIndex_=this.picker_=null},T.utils.object.inherits(T.FieldColour,T.Field),T.FieldColour.fromJson=function(t){return new T.FieldColour(t.colour,void 0,t)},T.FieldColour.prototype.SERIALIZABLE=!0,T.FieldColour.prototype.CURSOR="default",T.FieldColour.prototype.isDirty_=!1,T.FieldColour.prototype.colours_=null,T.FieldColour.prototype.titles_=null,T.FieldColour.prototype.columns_=0,T.FieldColour.prototype.configure_=function(t){T.FieldColour.superClass_.configure_.call(this,t),t.colourOptions&&(this.colours_=t.colourOptions,this.titles_=t.colourTitles),t.columns&&(this.columns_=t.columns)},T.FieldColour.prototype.initView=function(){this.size_=new T.utils.Size(this.getConstants().FIELD_COLOUR_DEFAULT_WIDTH,this.getConstants().FIELD_COLOUR_DEFAULT_HEIGHT),this.getConstants().FIELD_COLOUR_FULL_BLOCK?this.clickTarget_=this.sourceBlock_.getSvgRoot():(this.createBorderRect_(),this.borderRect_.style.fillOpacity="1")},T.FieldColour.prototype.applyColour=function(){this.getConstants().FIELD_COLOUR_FULL_BLOCK?(this.sourceBlock_.pathObject.svgPath.setAttribute("fill",this.getValue()),this.sourceBlock_.pathObject.svgPath.setAttribute("stroke","#fff")):this.borderRect_&&(this.borderRect_.style.fill=this.getValue())},T.FieldColour.prototype.doClassValidation_=function(t){return"string"!=typeof t?null:T.utils.colour.parse(t)},T.FieldColour.prototype.doValueUpdate_=function(t){this.value_=t,this.borderRect_?this.borderRect_.style.fill=t:this.sourceBlock_&&this.sourceBlock_.rendered&&(this.sourceBlock_.pathObject.svgPath.setAttribute("fill",t),this.sourceBlock_.pathObject.svgPath.setAttribute("stroke","#fff"))},T.FieldColour.prototype.getText=function(){var t=this.value_;return t=/^#(.)\1(.)\2(.)\3$/.test(t)?"#"+t[1]+t[3]+t[5]:t},T.FieldColour.COLOURS="#ffffff #cccccc #c0c0c0 #999999 #666666 #333333 #000000 #ffcccc #ff6666 #ff0000 #cc0000 #990000 #660000 #330000 #ffcc99 #ff9966 #ff9900 #ff6600 #cc6600 #993300 #663300 #ffff99 #ffff66 #ffcc66 #ffcc33 #cc9933 #996633 #663333 #ffffcc #ffff33 #ffff00 #ffcc00 #999900 #666600 #333300 #99ff99 #66ff99 #33ff33 #33cc00 #009900 #006600 #003300 #99ffff #33ffff #66cccc #00cccc #339999 #336666 #003333 #ccffff #66ffff #33ccff #3366ff #3333ff #000099 #000066 #ccccff #9999ff #6666cc #6633ff #6600cc #333399 #330099 #ffccff #ff99ff #cc66cc #cc33cc #993399 #663366 #330033".split(" "),T.FieldColour.prototype.DEFAULT_VALUE=T.FieldColour.COLOURS[0],T.FieldColour.TITLES=[],T.FieldColour.COLUMNS=7,T.FieldColour.prototype.setColours=function(t,e){return this.colours_=t,e&&(this.titles_=e),this},T.FieldColour.prototype.setColumns=function(t){return this.columns_=t,this},T.FieldColour.prototype.showEditor_=function(){this.picker_=this.dropdownCreate_(),T.DropDownDiv.getContentDiv().appendChild(this.picker_),T.DropDownDiv.showPositionedByField(this,this.dropdownDispose_.bind(this)),this.picker_.focus({preventScroll:!0})},T.FieldColour.prototype.onClick_=function(t){null!==(t=(t=t.target)&&t.label)&&(this.setValue(t),T.DropDownDiv.hideIfOwner(this))},T.FieldColour.prototype.onKeyDown_=function(t){var e=!1;t.keyCode===T.utils.KeyCodes.UP?(this.moveHighlightBy_(0,-1),e=!0):t.keyCode===T.utils.KeyCodes.DOWN?(this.moveHighlightBy_(0,1),e=!0):t.keyCode===T.utils.KeyCodes.LEFT?(this.moveHighlightBy_(-1,0),e=!0):t.keyCode===T.utils.KeyCodes.RIGHT?(this.moveHighlightBy_(1,0),e=!0):t.keyCode===T.utils.KeyCodes.ENTER&&((e=this.getHighlighted_())&&null!==(e=e&&e.label)&&this.setValue(e),T.DropDownDiv.hideWithoutAnimation(),e=!0),e&&t.stopPropagation()},T.FieldColour.prototype.moveHighlightBy_=function(t,e){var o=this.colours_||T.FieldColour.COLOURS,i=this.columns_||T.FieldColour.COLUMNS,s=this.highlightedIndex_%i,n=Math.floor(this.highlightedIndex_/i);s+=t,n+=e,t<0?s<0&&0<n?(s=i-1,n--):s<0&&(s=0):0<t?i-1<s&&n<Math.floor(o.length/i)-1?(s=0,n++):i-1<s&&s--:e<0?n<0&&(n=0):0<e&&n>Math.floor(o.length/i)-1&&(n=Math.floor(o.length/i)-1),this.setHighlightedCell_(this.picker_.childNodes[n].childNodes[s],n*i+s)},T.FieldColour.prototype.onMouseMove_=function(t){var e=(t=t.target)&&Number(t.getAttribute("data-index"));null!==e&&e!==this.highlightedIndex_&&this.setHighlightedCell_(t,e)},T.FieldColour.prototype.onMouseEnter_=function(){this.picker_.focus({preventScroll:!0})},T.FieldColour.prototype.onMouseLeave_=function(){this.picker_.blur();var t=this.getHighlighted_();t&&T.utils.dom.removeClass(t,"blocklyColourHighlighted")},T.FieldColour.prototype.getHighlighted_=function(){var t=this.columns_||T.FieldColour.COLUMNS,e=this.picker_.childNodes[Math.floor(this.highlightedIndex_/t)];return e?e.childNodes[this.highlightedIndex_%t]:null},T.FieldColour.prototype.setHighlightedCell_=function(t,e){var o=this.getHighlighted_();o&&T.utils.dom.removeClass(o,"blocklyColourHighlighted"),T.utils.dom.addClass(t,"blocklyColourHighlighted"),this.highlightedIndex_=e,T.utils.aria.setState(this.picker_,T.utils.aria.State.ACTIVEDESCENDANT,t.getAttribute("id"))},T.FieldColour.prototype.dropdownCreate_=function(){var t=this.columns_||T.FieldColour.COLUMNS,e=this.colours_||T.FieldColour.COLOURS,o=this.titles_||T.FieldColour.TITLES,i=this.getValue(),s=document.createElement("table");s.className="blocklyColourTable",s.tabIndex=0,s.dir="ltr",T.utils.aria.setRole(s,T.utils.aria.Role.GRID),T.utils.aria.setState(s,T.utils.aria.State.EXPANDED,!0),T.utils.aria.setState(s,T.utils.aria.State.ROWCOUNT,Math.floor(e.length/t)),T.utils.aria.setState(s,T.utils.aria.State.COLCOUNT,t);for(var n,r=0;r<e.length;r++){0==r%t&&(n=document.createElement("tr"),T.utils.aria.setRole(n,T.utils.aria.Role.ROW),s.appendChild(n));var l=document.createElement("td");n.appendChild(l),l.label=e[r],l.title=o[r]||e[r],l.id=T.utils.IdGenerator.getNextUniqueId(),l.setAttribute("data-index",r),T.utils.aria.setRole(l,T.utils.aria.Role.GRIDCELL),T.utils.aria.setState(l,T.utils.aria.State.LABEL,e[r]),T.utils.aria.setState(l,T.utils.aria.State.SELECTED,e[r]==i),l.style.backgroundColor=e[r],e[r]==i&&(l.className="blocklyColourSelected",this.highlightedIndex_=r)}return this.onClickWrapper_=T.browserEvents.conditionalBind(s,"click",this,this.onClick_,!0),this.onMouseMoveWrapper_=T.browserEvents.conditionalBind(s,"mousemove",this,this.onMouseMove_,!0),this.onMouseEnterWrapper_=T.browserEvents.conditionalBind(s,"mouseenter",this,this.onMouseEnter_,!0),this.onMouseLeaveWrapper_=T.browserEvents.conditionalBind(s,"mouseleave",this,this.onMouseLeave_,!0),this.onKeyDownWrapper_=T.browserEvents.conditionalBind(s,"keydown",this,this.onKeyDown_),s},T.FieldColour.prototype.dropdownDispose_=function(){this.onClickWrapper_&&(T.browserEvents.unbind(this.onClickWrapper_),this.onClickWrapper_=null),this.onMouseMoveWrapper_&&(T.browserEvents.unbind(this.onMouseMoveWrapper_),this.onMouseMoveWrapper_=null),this.onMouseEnterWrapper_&&(T.browserEvents.unbind(this.onMouseEnterWrapper_),this.onMouseEnterWrapper_=null),this.onMouseLeaveWrapper_&&(T.browserEvents.unbind(this.onMouseLeaveWrapper_),this.onMouseLeaveWrapper_=null),this.onKeyDownWrapper_&&(T.browserEvents.unbind(this.onKeyDownWrapper_),this.onKeyDownWrapper_=null),this.highlightedIndex_=this.picker_=null},T.Css.register([".blocklyColourTable {","border-collapse: collapse;","display: block;","outline: none;","padding: 1px;","}",".blocklyColourTable>tr>td {","border: .5px solid #888;","box-sizing: border-box;","cursor: pointer;","display: inline-block;","height: 20px;","padding: 0;","width: 20px;","}",".blocklyColourTable>tr>td.blocklyColourHighlighted {","border-color: #eee;","box-shadow: 2px 2px 7px 2px rgba(0,0,0,.3);","position: relative;","}",".blocklyColourSelected, .blocklyColourSelected:hover {","border-color: #eee !important;","outline: 1px solid #333;","position: relative;","}"]),T.fieldRegistry.register("field_colour",T.FieldColour),T.FieldDropdown=function(t,e,o){"function"!=typeof t&&T.FieldDropdown.validateOptions_(t),this.menuGenerator_=t,this.suffixField=this.prefixField=this.generatedOptions_=null,this.trimOptions_(),this.selectedOption_=this.getOptions(!1)[0],T.FieldDropdown.superClass_.constructor.call(this,this.selectedOption_[1],e,o),this.svgArrow_=this.arrow_=this.imageElement_=this.menu_=this.selectedMenuItem_=null},T.utils.object.inherits(T.FieldDropdown,T.Field),T.FieldDropdown.fromJson=function(t){return new T.FieldDropdown(t.options,void 0,t)},T.FieldDropdown.prototype.fromXml=function(t){this.isOptionListDynamic()&&this.getOptions(!1),this.setValue(t.textContent)},T.FieldDropdown.prototype.SERIALIZABLE=!0,T.FieldDropdown.CHECKMARK_OVERHANG=25,T.FieldDropdown.MAX_MENU_HEIGHT_VH=.45,T.FieldDropdown.IMAGE_Y_OFFSET=5,T.FieldDropdown.IMAGE_Y_PADDING=2*T.FieldDropdown.IMAGE_Y_OFFSET,T.FieldDropdown.ARROW_CHAR=T.utils.userAgent.ANDROID?"▼":"▾",T.FieldDropdown.prototype.CURSOR="default",T.FieldDropdown.prototype.initView=function(){this.shouldAddBorderRect_()?this.createBorderRect_():this.clickTarget_=this.sourceBlock_.getSvgRoot(),this.createTextElement_(),this.imageElement_=T.utils.dom.createSvgElement(T.utils.Svg.IMAGE,{},this.fieldGroup_),this.getConstants().FIELD_DROPDOWN_SVG_ARROW?this.createSVGArrow_():this.createTextArrow_(),this.borderRect_&&T.utils.dom.addClass(this.borderRect_,"blocklyDropdownRect")},T.FieldDropdown.prototype.shouldAddBorderRect_=function(){return!this.getConstants().FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW||this.getConstants().FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW&&!this.sourceBlock_.isShadow()},T.FieldDropdown.prototype.createTextArrow_=function(){this.arrow_=T.utils.dom.createSvgElement(T.utils.Svg.TSPAN,{},this.textElement_),this.arrow_.appendChild(document.createTextNode(this.sourceBlock_.RTL?T.FieldDropdown.ARROW_CHAR+" ":" "+T.FieldDropdown.ARROW_CHAR)),this.sourceBlock_.RTL?this.textElement_.insertBefore(this.arrow_,this.textContent_):this.textElement_.appendChild(this.arrow_)},T.FieldDropdown.prototype.createSVGArrow_=function(){this.svgArrow_=T.utils.dom.createSvgElement(T.utils.Svg.IMAGE,{height:this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE+"px",width:this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE+"px"},this.fieldGroup_),this.svgArrow_.setAttributeNS(T.utils.dom.XLINK_NS,"xlink:href",this.getConstants().FIELD_DROPDOWN_SVG_ARROW_DATAURI)},T.FieldDropdown.prototype.showEditor_=function(t){var e;this.menu_=this.dropdownCreate_(),this.menu_.openingCoords=t&&"number"==typeof t.clientX?new T.utils.Coordinate(t.clientX,t.clientY):null,this.menu_.render(T.DropDownDiv.getContentDiv()),t=this.menu_.getElement(),T.utils.dom.addClass(t,"blocklyDropdownMenu"),this.getConstants().FIELD_DROPDOWN_COLOURED_DIV&&(t=(this.sourceBlock_.isShadow()?this.sourceBlock_.getParent():this.sourceBlock_).getColour(),e=(this.sourceBlock_.isShadow()?this.sourceBlock_.getParent():this.sourceBlock_).style.colourTertiary,T.DropDownDiv.setColour(t,e)),T.DropDownDiv.showPositionedByField(this,this.dropdownDispose_.bind(this)),this.menu_.focus(),this.selectedMenuItem_&&this.menu_.setHighlighted(this.selectedMenuItem_),this.applyColour()},T.FieldDropdown.prototype.dropdownCreate_=function(){var t=new T.Menu,e=(t.setRole(T.utils.aria.Role.LISTBOX),this.getOptions(!1));this.selectedMenuItem_=null;for(var o=0;o<e.length;o++){var i=e[o][0],s=e[o][1],n;"object"==typeof i&&((n=new Image(i.width,i.height)).src=i.src,n.alt=i.alt||"",i=n),(i=new T.MenuItem(i,s)).setRole(T.utils.aria.Role.OPTION),i.setRightToLeft(this.sourceBlock_.RTL),i.setCheckable(!0),t.addChild(i),i.setChecked(s==this.value_),s==this.value_&&(this.selectedMenuItem_=i),i.onAction(this.handleMenuActionEvent_,this)}return t},T.FieldDropdown.prototype.dropdownDispose_=function(){this.menu_&&this.menu_.dispose(),this.selectedMenuItem_=this.menu_=null,this.applyColour()},T.FieldDropdown.prototype.handleMenuActionEvent_=function(t){T.DropDownDiv.hideIfOwner(this,!0),this.onItemSelected_(this.menu_,t)},T.FieldDropdown.prototype.onItemSelected_=function(t,e){this.setValue(e.getValue())},T.FieldDropdown.prototype.trimOptions_=function(){var t=this.menuGenerator_;if(Array.isArray(t)){for(var e=!1,o=0;o<t.length;o++){var i=t[o][0];"string"==typeof i?t[o][0]=T.utils.replaceMessageReferences(i):(null!=i.alt&&(t[o][0].alt=T.utils.replaceMessageReferences(i.alt)),e=!0)}if(!(e||t.length<2)){for(e=[],o=0;o<t.length;o++)e.push(t[o][0]);var o=T.utils.string.shortestStringLength(e),i=T.utils.string.commonWordPrefix(e,o),s=T.utils.string.commonWordSuffix(e,o);!i&&!s||o<=i+s||(i&&(this.prefixField=e[0].substring(0,i-1)),s&&(this.suffixField=e[0].substr(1-s)),this.menuGenerator_=T.FieldDropdown.applyTrim_(t,i,s))}}},T.FieldDropdown.applyTrim_=function(t,e,o){for(var i=[],s=0;s<t.length;s++){var n=t[s][0],r=t[s][1],n=n.substring(e,n.length-o);i[s]=[n,r]}return i},T.FieldDropdown.prototype.isOptionListDynamic=function(){return"function"==typeof this.menuGenerator_},T.FieldDropdown.prototype.getOptions=function(t){return this.isOptionListDynamic()?(this.generatedOptions_&&t||(this.generatedOptions_=this.menuGenerator_.call(this),T.FieldDropdown.validateOptions_(this.generatedOptions_)),this.generatedOptions_):this.menuGenerator_},T.FieldDropdown.prototype.doClassValidation_=function(t){for(var e=!1,o=this.getOptions(!0),i=0,s;s=o[i];i++)if(s[1]==t){e=!0;break}return e?t:(this.sourceBlock_&&console.warn("Cannot set the dropdown's value to an unavailable option. Block type: "+this.sourceBlock_.type+", Field name: "+this.name+", Value: "+t),null)},T.FieldDropdown.prototype.doValueUpdate_=function(t){T.FieldDropdown.superClass_.doValueUpdate_.call(this,t),t=this.getOptions(!0);for(var e=0,o;o=t[e];e++)o[1]==this.value_&&(this.selectedOption_=o)},T.FieldDropdown.prototype.applyColour=function(){this.borderRect_&&(this.borderRect_.setAttribute("stroke",this.sourceBlock_.style.colourTertiary),this.menu_?this.borderRect_.setAttribute("fill",this.sourceBlock_.style.colourTertiary):this.borderRect_.setAttribute("fill","transparent")),this.sourceBlock_&&this.arrow_&&(this.sourceBlock_.isShadow()?this.arrow_.style.fill=this.sourceBlock_.style.colourSecondary:this.arrow_.style.fill=this.sourceBlock_.style.colourPrimary)},T.FieldDropdown.prototype.render_=function(){this.textContent_.nodeValue="",this.imageElement_.style.display="none";var t=this.selectedOption_&&this.selectedOption_[0];t&&"object"==typeof t?this.renderSelectedImage_(t):this.renderSelectedText_(),this.positionBorderRect_()},T.FieldDropdown.prototype.renderSelectedImage_=function(t){this.imageElement_.style.display="",this.imageElement_.setAttributeNS(T.utils.dom.XLINK_NS,"xlink:href",t.src),this.imageElement_.setAttribute("height",t.height),this.imageElement_.setAttribute("width",t.width);var e=Number(t.height),o=(t=Number(t.width),!!this.borderRect_),i=Math.max(o?this.getConstants().FIELD_DROPDOWN_BORDER_RECT_HEIGHT:0,e+T.FieldDropdown.IMAGE_Y_PADDING),o=o?this.getConstants().FIELD_BORDER_RECT_X_PADDING:0,s=this.svgArrow_?this.positionSVGArrow_(t+o,i/2-this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE/2):T.utils.dom.getFastTextWidth(this.arrow_,this.getConstants().FIELD_TEXT_FONTSIZE,this.getConstants().FIELD_TEXT_FONTWEIGHT,this.getConstants().FIELD_TEXT_FONTFAMILY),n=(this.size_.width=t+s+2*o,this.size_.height=i,0);this.sourceBlock_.RTL?this.imageElement_.setAttribute("x",o+s):(n=t+s,this.textElement_.setAttribute("text-anchor","end"),this.imageElement_.setAttribute("x",o)),this.imageElement_.setAttribute("y",i/2-e/2),this.positionTextElement_(n+o,t+s)},T.FieldDropdown.prototype.renderSelectedText_=function(){this.textContent_.nodeValue=this.getDisplayText_(),T.utils.dom.addClass(this.textElement_,"blocklyDropdownText"),this.textElement_.setAttribute("text-anchor","start");var t=!!this.borderRect_,e=Math.max(t?this.getConstants().FIELD_DROPDOWN_BORDER_RECT_HEIGHT:0,this.getConstants().FIELD_TEXT_HEIGHT),o=T.utils.dom.getFastTextWidth(this.textElement_,this.getConstants().FIELD_TEXT_FONTSIZE,this.getConstants().FIELD_TEXT_FONTWEIGHT,this.getConstants().FIELD_TEXT_FONTFAMILY),t=t?this.getConstants().FIELD_BORDER_RECT_X_PADDING:0,i=0;this.svgArrow_&&(i=this.positionSVGArrow_(o+t,e/2-this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE/2)),this.size_.width=o+i+2*t,this.size_.height=e,this.positionTextElement_(t,o)},T.FieldDropdown.prototype.positionSVGArrow_=function(t,e){if(!this.svgArrow_)return 0;var o=this.borderRect_?this.getConstants().FIELD_BORDER_RECT_X_PADDING:0,i=this.getConstants().FIELD_DROPDOWN_SVG_ARROW_PADDING,s=this.getConstants().FIELD_DROPDOWN_SVG_ARROW_SIZE;return this.svgArrow_.setAttribute("transform","translate("+(this.sourceBlock_.RTL?o:t+i)+","+e+")"),s+i},T.FieldDropdown.prototype.getText_=function(){if(!this.selectedOption_)return null;var t=this.selectedOption_[0];return"object"==typeof t?t.alt:t},T.FieldDropdown.validateOptions_=function(t){if(!Array.isArray(t))throw TypeError("FieldDropdown options must be an array.");if(!t.length)throw TypeError("FieldDropdown options must not be an empty array.");for(var e=!1,o=0;o<t.length;++o){var i=t[o];Array.isArray(i)?"string"!=typeof i[1]?(e=!0,console.error("Invalid option["+o+"]: Each FieldDropdown option id must be a string. Found "+i[1]+" in: ",i)):i[0]&&"string"!=typeof i[0]&&"string"!=typeof i[0].src&&(e=!0,console.error("Invalid option["+o+"]: Each FieldDropdown option must have a string label or image description. Found"+i[0]+" in: ",i)):(e=!0,console.error("Invalid option["+o+"]: Each FieldDropdown option must be an array. Found: ",i))}if(e)throw TypeError("Found invalid FieldDropdown options.")},T.fieldRegistry.register("field_dropdown",T.FieldDropdown),T.FieldLabelSerializable=function(t,e,o){T.FieldLabelSerializable.superClass_.constructor.call(this,t,e,o)},T.utils.object.inherits(T.FieldLabelSerializable,T.FieldLabel),T.FieldLabelSerializable.fromJson=function(t){var e=T.utils.replaceMessageReferences(t.text);return new T.FieldLabelSerializable(e,void 0,t)},T.FieldLabelSerializable.prototype.EDITABLE=!1,T.FieldLabelSerializable.prototype.SERIALIZABLE=!0,T.fieldRegistry.register("field_label_serializable",T.FieldLabelSerializable),T.FieldImage=function(t,e,o,i,s,n,r){if(!t)throw Error("Src value of an image field is required");if(t=T.utils.replaceMessageReferences(t),o=Number(T.utils.replaceMessageReferences(o)),e=Number(T.utils.replaceMessageReferences(e)),isNaN(o)||isNaN(e))throw Error("Height and width values of an image field must cast to numbers.");if(o<=0||e<=0)throw Error("Height and width values of an image field must be greater than 0.");this.flipRtl_=!1,this.altText_="",T.FieldImage.superClass_.constructor.call(this,t,null,r),r||(this.flipRtl_=!!n,this.altText_=T.utils.replaceMessageReferences(i)||""),this.size_=new T.utils.Size(e,o+T.FieldImage.Y_PADDING),this.imageHeight_=o,this.clickHandler_=null,"function"==typeof s&&(this.clickHandler_=s),this.imageElement_=null},T.utils.object.inherits(T.FieldImage,T.Field),T.FieldImage.prototype.DEFAULT_VALUE="",T.FieldImage.fromJson=function(t){return new T.FieldImage(t.src,t.width,t.height,void 0,void 0,void 0,t)},T.FieldImage.Y_PADDING=1,T.FieldImage.prototype.EDITABLE=!1,T.FieldImage.prototype.isDirty_=!1,T.FieldImage.prototype.configure_=function(t){T.FieldImage.superClass_.configure_.call(this,t),this.flipRtl_=!!t.flipRtl,this.altText_=T.utils.replaceMessageReferences(t.alt)||""},T.FieldImage.prototype.initView=function(){this.imageElement_=T.utils.dom.createSvgElement(T.utils.Svg.IMAGE,{height:this.imageHeight_+"px",width:this.size_.width+"px",alt:this.altText_},this.fieldGroup_),this.imageElement_.setAttributeNS(T.utils.dom.XLINK_NS,"xlink:href",this.value_),this.clickHandler_&&(this.imageElement_.style.cursor="pointer")},T.FieldImage.prototype.updateSize_=function(){},T.FieldImage.prototype.doClassValidation_=function(t){return"string"!=typeof t?null:t},T.FieldImage.prototype.doValueUpdate_=function(t){this.value_=t,this.imageElement_&&this.imageElement_.setAttributeNS(T.utils.dom.XLINK_NS,"xlink:href",String(this.value_))},T.FieldImage.prototype.getFlipRtl=function(){return this.flipRtl_},T.FieldImage.prototype.setAlt=function(t){t!=this.altText_&&(this.altText_=t||"",this.imageElement_)&&this.imageElement_.setAttribute("alt",this.altText_)},T.FieldImage.prototype.showEditor_=function(){this.clickHandler_&&this.clickHandler_(this)},T.FieldImage.prototype.setOnClickHandler=function(t){this.clickHandler_=t},T.FieldImage.prototype.getText_=function(){return this.altText_},T.fieldRegistry.register("field_image",T.FieldImage),T.FieldMultilineInput=function(t,e,o){T.FieldMultilineInput.superClass_.constructor.call(this,t,e,o),this.textGroup_=null,this.maxLines_=1/0,this.isOverflowedY_=!1},T.utils.object.inherits(T.FieldMultilineInput,T.FieldTextInput),T.FieldMultilineInput.prototype.configure_=function(t){T.FieldMultilineInput.superClass_.configure_.call(this,t),t.maxLines&&this.setMaxLines(t.maxLines)},T.FieldMultilineInput.fromJson=function(t){var e=T.utils.replaceMessageReferences(t.text);return new T.FieldMultilineInput(e,void 0,t)},T.FieldMultilineInput.prototype.toXml=function(t){return t.textContent=this.getValue().replace(/\n/g,"&#10;"),t},T.FieldMultilineInput.prototype.fromXml=function(t){this.setValue(t.textContent.replace(/&#10;/g,"\n"))},T.FieldMultilineInput.prototype.initView=function(){this.createBorderRect_(),this.textGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:"blocklyEditableText"},this.fieldGroup_)},T.FieldMultilineInput.prototype.getDisplayText_=function(){var t;if(!(t=this.getText()))return T.Field.NBSP;for(var e=t.split("\n"),t="",o=this.isOverflowedY_?this.maxLines_:e.length,i=0;i<o;i++){var s=e[i];s.length>this.maxDisplayLength?s=s.substring(0,this.maxDisplayLength-4)+"...":this.isOverflowedY_&&i===o-1&&(s=s.substring(0,s.length-3)+"..."),t+=s=s.replace(/\s/g,T.Field.NBSP),i!==o-1&&(t+="\n")}return this.sourceBlock_.RTL&&(t+="‏"),t},T.FieldMultilineInput.prototype.doValueUpdate_=function(t){T.FieldMultilineInput.superClass_.doValueUpdate_.call(this,t),this.isOverflowedY_=this.value_.split("\n").length>this.maxLines_},T.FieldMultilineInput.prototype.render_=function(){for(var t;t=this.textGroup_.firstChild;)this.textGroup_.removeChild(t);for(var t=this.getDisplayText_().split("\n"),e=0,o=0;o<t.length;o++){var i=this.getConstants().FIELD_TEXT_HEIGHT+this.getConstants().FIELD_BORDER_RECT_Y_PADDING;T.utils.dom.createSvgElement(T.utils.Svg.TEXT,{class:"blocklyText blocklyMultilineText",x:this.getConstants().FIELD_BORDER_RECT_X_PADDING,y:e+this.getConstants().FIELD_BORDER_RECT_Y_PADDING,dy:this.getConstants().FIELD_TEXT_BASELINE},this.textGroup_).appendChild(document.createTextNode(t[o])),e+=i}this.isBeingEdited_&&(t=this.htmlInput_,this.isOverflowedY_?T.utils.dom.addClass(t,"blocklyHtmlTextAreaInputOverflowedY"):T.utils.dom.removeClass(t,"blocklyHtmlTextAreaInputOverflowedY")),this.updateSize_(),this.isBeingEdited_&&(this.sourceBlock_.RTL?setTimeout(this.resizeEditor_.bind(this),0):this.resizeEditor_(),t=this.htmlInput_,this.isTextValid_?(T.utils.dom.removeClass(t,"blocklyInvalidInput"),T.utils.aria.setState(t,T.utils.aria.State.INVALID,!1)):(T.utils.dom.addClass(t,"blocklyInvalidInput"),T.utils.aria.setState(t,T.utils.aria.State.INVALID,!0)))},T.FieldMultilineInput.prototype.updateSize_=function(){for(var t=this.textGroup_.childNodes,e=0,o=0,i=0;i<t.length;i++){var s=T.utils.dom.getTextWidth(t[i]);e<s&&(e=s),o+=this.getConstants().FIELD_TEXT_HEIGHT+(0<i?this.getConstants().FIELD_BORDER_RECT_Y_PADDING:0)}if(this.isBeingEdited_){for(var t=this.value_.split("\n"),s=T.utils.dom.createSvgElement(T.utils.Svg.TEXT,{class:"blocklyText blocklyMultilineText"}),n=this.getConstants().FIELD_TEXT_FONTSIZE,r=this.getConstants().FIELD_TEXT_FONTWEIGHT,l=this.getConstants().FIELD_TEXT_FONTFAMILY,i=0;i<t.length;i++){t[i].length>this.maxDisplayLength&&(t[i]=t[i].substring(0,this.maxDisplayLength)),s.textContent=t[i];var a=T.utils.dom.getFastTextWidth(s,n,r,l);e<a&&(e=a)}e+=this.htmlInput_.offsetWidth-this.htmlInput_.clientWidth}this.borderRect_&&(o+=2*this.getConstants().FIELD_BORDER_RECT_Y_PADDING,e+=2*this.getConstants().FIELD_BORDER_RECT_X_PADDING,this.borderRect_.setAttribute("width",e),this.borderRect_.setAttribute("height",o)),this.size_.width=e,this.size_.height=o,this.positionBorderRect_()},T.FieldMultilineInput.prototype.showEditor_=function(t,e){T.FieldMultilineInput.superClass_.showEditor_.call(this,t,e),this.forceRerender()},T.FieldMultilineInput.prototype.widgetCreate_=function(){var t=T.WidgetDiv.DIV,e=this.workspace_.getScale(),o=document.createElement("textarea"),i=(o.className="blocklyHtmlInput blocklyHtmlTextAreaInput",o.setAttribute("spellcheck",this.spellcheck_),this.getConstants().FIELD_TEXT_FONTSIZE*e+"pt"),s=(t.style.fontSize=i,o.style.fontSize=i,o.style.borderRadius=T.FieldTextInput.BORDERRADIUS*e+"px",i=this.getConstants().FIELD_BORDER_RECT_X_PADDING*e,this.getConstants().FIELD_BORDER_RECT_Y_PADDING*e/2);return o.style.padding=s+"px "+i+"px "+s+"px "+i+"px",i=this.getConstants().FIELD_TEXT_HEIGHT+this.getConstants().FIELD_BORDER_RECT_Y_PADDING,o.style.lineHeight=i*e+"px",t.appendChild(o),o.value=o.defaultValue=this.getEditorText_(this.value_),o.untypedDefaultValue_=this.value_,o.oldValue_=null,T.utils.userAgent.GECKO?setTimeout(this.resizeEditor_.bind(this),0):this.resizeEditor_(),this.bindInputEvents_(o),o},T.FieldMultilineInput.prototype.setMaxLines=function(t){"number"==typeof t&&0<t&&t!==this.maxLines_&&(this.maxLines_=t,this.forceRerender())},T.FieldMultilineInput.prototype.getMaxLines=function(){return this.maxLines_},T.FieldMultilineInput.prototype.onHtmlInputKeyDown_=function(t){t.keyCode!==T.utils.KeyCodes.ENTER&&T.FieldMultilineInput.superClass_.onHtmlInputKeyDown_.call(this,t)},T.Css.register(".blocklyHtmlTextAreaInput {,font-family: monospace;,resize: none;,overflow: hidden;,height: 100%;,text-align: left;,},.blocklyHtmlTextAreaInputOverflowedY {,overflow-y: scroll;,}".split(",")),T.fieldRegistry.register("field_multilinetext",T.FieldMultilineInput),T.FieldNumber=function(t,e,o,i,s,n){this.min_=-(1/0),this.max_=1/0,this.precision_=0,this.decimalPlaces_=null,T.FieldNumber.superClass_.constructor.call(this,t,s,n),n||this.setConstraints(e,o,i)},T.utils.object.inherits(T.FieldNumber,T.FieldTextInput),T.FieldNumber.prototype.DEFAULT_VALUE=0,T.FieldNumber.fromJson=function(t){return new T.FieldNumber(t.value,void 0,void 0,void 0,void 0,t)},T.FieldNumber.prototype.SERIALIZABLE=!0,T.FieldNumber.prototype.configure_=function(t){T.FieldNumber.superClass_.configure_.call(this,t),this.setMinInternal_(t.min),this.setMaxInternal_(t.max),this.setPrecisionInternal_(t.precision)},T.FieldNumber.prototype.setConstraints=function(t,e,o){this.setMinInternal_(t),this.setMaxInternal_(e),this.setPrecisionInternal_(o),this.setValue(this.getValue())},T.FieldNumber.prototype.setMin=function(t){this.setMinInternal_(t),this.setValue(this.getValue())},T.FieldNumber.prototype.setMinInternal_=function(t){null==t?this.min_=-(1/0):(t=Number(t),isNaN(t)||(this.min_=t))},T.FieldNumber.prototype.getMin=function(){return this.min_},T.FieldNumber.prototype.setMax=function(t){this.setMaxInternal_(t),this.setValue(this.getValue())},T.FieldNumber.prototype.setMaxInternal_=function(t){null==t?this.max_=1/0:(t=Number(t),isNaN(t)||(this.max_=t))},T.FieldNumber.prototype.getMax=function(){return this.max_},T.FieldNumber.prototype.setPrecision=function(t){this.setPrecisionInternal_(t),this.setValue(this.getValue())},T.FieldNumber.prototype.setPrecisionInternal_=function(t){null==t?this.precision_=0:(t=Number(t),isNaN(t)||(this.precision_=t));var e=this.precision_.toLocaleString("en-US",{maximumFractionDigits:20}),o=e.indexOf(".");this.decimalPlaces_=-1==o?t?0:null:e.length-o-1},T.FieldNumber.prototype.getPrecision=function(){return this.precision_},T.FieldNumber.prototype.doClassValidation_=function(t){if(null===t)return null;if(t=(t=(t=(t=String(t)).replace(/O/gi,"0")).replace(/,/g,"")).replace(/infinity/i,"Infinity"),t=Number(t||0),isNaN(t))return null;return t=Math.min(Math.max(t,this.min_),this.max_),this.precision_&&isFinite(t)&&(t=Math.round(t/this.precision_)*this.precision_),t=null!=this.decimalPlaces_?Number(t.toFixed(this.decimalPlaces_)):t},T.FieldNumber.prototype.widgetCreate_=function(){var t=T.FieldNumber.superClass_.widgetCreate_.call(this);return-(1/0)<this.min_&&T.utils.aria.setState(t,T.utils.aria.State.VALUEMIN,this.min_),1/0>this.max_&&T.utils.aria.setState(t,T.utils.aria.State.VALUEMAX,this.max_),t},T.fieldRegistry.register("field_number",T.FieldNumber),T.FieldVariable=function(t,e,o,i,s){this.menuGenerator_=T.FieldVariable.dropdownCreate,this.defaultVariableName="string"==typeof t?t:"",this.size_=new T.utils.Size(0,0),s&&this.configure_(s),e&&this.setValidator(e),s||this.setTypes_(o,i)},T.utils.object.inherits(T.FieldVariable,T.FieldDropdown),T.FieldVariable.fromJson=function(t){var e=T.utils.replaceMessageReferences(t.variable);return new T.FieldVariable(e,void 0,void 0,void 0,t)},T.FieldVariable.prototype.SERIALIZABLE=!0,T.FieldVariable.prototype.configure_=function(t){T.FieldVariable.superClass_.configure_.call(this,t),this.setTypes_(t.variableTypes,t.defaultType)},T.FieldVariable.prototype.initModel=function(){var t;this.variable_||(t=T.Variables.getOrCreateVariablePackage(this.sourceBlock_.workspace,null,this.defaultVariableName,this.defaultType_),this.doValueUpdate_(t.getId()))},T.FieldVariable.prototype.shouldAddBorderRect_=function(){return T.FieldVariable.superClass_.shouldAddBorderRect_.call(this)&&(!this.getConstants().FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW||"variables_get"!=this.sourceBlock_.type)},T.FieldVariable.prototype.fromXml=function(t){var e=t.getAttribute("id"),o=t.textContent,i=t.getAttribute("variabletype")||t.getAttribute("variableType")||"",e=T.Variables.getOrCreateVariablePackage(this.sourceBlock_.workspace,e,o,i);if(null!=i&&i!==e.type)throw Error("Serialized variable type with id '"+e.getId()+"' had type "+e.type+", and does not match variable field that references it: "+T.Xml.domToText(t)+".");this.setValue(e.getId())},T.FieldVariable.prototype.toXml=function(t){return this.initModel(),t.id=this.variable_.getId(),t.textContent=this.variable_.name,this.variable_.type&&t.setAttribute("variabletype",this.variable_.type),t},T.FieldVariable.prototype.setSourceBlock=function(t){if(t.isShadow())throw Error("Variable fields are not allowed to exist on shadow blocks.");T.FieldVariable.superClass_.setSourceBlock.call(this,t)},T.FieldVariable.prototype.getValue=function(){return this.variable_?this.variable_.getId():null},T.FieldVariable.prototype.getText=function(){return this.variable_?this.variable_.name:""},T.FieldVariable.prototype.getVariable=function(){return this.variable_},T.FieldVariable.prototype.getValidator=function(){return this.variable_?this.validator_:null},T.FieldVariable.prototype.doClassValidation_=function(t){if(null===t)return null;var e=T.Variables.getVariable(this.sourceBlock_.workspace,t);if(!e)return console.warn("Variable id doesn't point to a real variable! ID was "+t),null;return e=e.type,this.typeIsAllowed_(e)?t:(console.warn("Variable type doesn't match this field!  Type was "+e),null)},T.FieldVariable.prototype.doValueUpdate_=function(t){this.variable_=T.Variables.getVariable(this.sourceBlock_.workspace,t),T.FieldVariable.superClass_.doValueUpdate_.call(this,t)},T.FieldVariable.prototype.typeIsAllowed_=function(t){var e=this.getVariableTypes_();if(!e)return!0;for(var o=0;o<e.length;o++)if(t==e[o])return!0;return!1},T.FieldVariable.prototype.getVariableTypes_=function(){var t=this.variableTypes;if(null===t&&this.sourceBlock_&&this.sourceBlock_.workspace)return this.sourceBlock_.workspace.getVariableTypes();if(0==(t=t||[""]).length)throw t=this.getText(),Error("'variableTypes' of field variable "+t+" was an empty list");return t},T.FieldVariable.prototype.setTypes_=function(t,e){if(e=e||"",null==t)t=null;else{if(!Array.isArray(t))throw Error("'variableTypes' was not an array in the definition of a FieldVariable");for(var o=!1,i=0;i<t.length;i++)t[i]==e&&(o=!0);if(!o)throw Error("Invalid default type '"+e+"' in the definition of a FieldVariable")}this.defaultType_=e,this.variableTypes=t},T.FieldVariable.prototype.refreshVariableName=function(){this.forceRerender()},T.FieldVariable.dropdownCreate=function(){if(!this.variable_)throw Error("Tried to call dropdownCreate on a variable field with no variable selected.");var t=this.getText(),e=[];if(this.sourceBlock_&&this.sourceBlock_.workspace)for(var o=this.getVariableTypes_(),i=0;i<o.length;i++)var s=this.sourceBlock_.workspace.getVariablesOfType(o[i]),e=e.concat(s);for(e.sort(T.VariableModel.compareByName),o=[],i=0;i<e.length;i++)o[i]=[e[i].name,e[i].getId()];return o.push([T.Msg.RENAME_VARIABLE,T.RENAME_VARIABLE_ID]),T.Msg.DELETE_VARIABLE&&o.push([T.Msg.DELETE_VARIABLE.replace("%1",t),T.DELETE_VARIABLE_ID]),o},T.FieldVariable.prototype.onItemSelected_=function(t,e){if(t=e.getValue(),this.sourceBlock_&&this.sourceBlock_.workspace){if(t==T.RENAME_VARIABLE_ID)return void T.Variables.renameVariable(this.sourceBlock_.workspace,this.variable_);if(t==T.DELETE_VARIABLE_ID)return void this.sourceBlock_.workspace.deleteVariableById(this.variable_.getId())}this.setValue(t)},T.FieldVariable.prototype.referencesVariables=function(){return!0},T.fieldRegistry.register("field_variable",T.FieldVariable),T.utils.svgPaths={},T.utils.svgPaths.point=function(t,e){return" "+t+","+e+" "},T.utils.svgPaths.curve=function(t,e){return" "+t+e.join("")},T.utils.svgPaths.moveTo=function(t,e){return" M "+t+","+e+" "},T.utils.svgPaths.moveBy=function(t,e){return" m "+t+","+e+" "},T.utils.svgPaths.lineTo=function(t,e){return" l "+t+","+e+" "},T.utils.svgPaths.line=function(t){return" l"+t.join("")},T.utils.svgPaths.lineOnAxis=function(t,e){return" "+t+" "+e+" "},T.utils.svgPaths.arc=function(t,e,o,i){return t+" "+o+" "+o+" "+e+i},T.blockRendering.ConstantProvider=function(){this.NO_PADDING=0,this.SMALL_PADDING=3,this.MEDIUM_PADDING=5,this.MEDIUM_LARGE_PADDING=8,this.LARGE_PADDING=10,this.TALL_INPUT_FIELD_OFFSET_Y=this.MEDIUM_PADDING,this.TAB_HEIGHT=15,this.TAB_OFFSET_FROM_TOP=5,this.TAB_VERTICAL_OVERLAP=2.5,this.TAB_WIDTH=8,this.NOTCH_WIDTH=15,this.NOTCH_HEIGHT=4,this.MIN_BLOCK_WIDTH=12,this.EMPTY_BLOCK_SPACER_HEIGHT=16,this.DUMMY_INPUT_SHADOW_MIN_HEIGHT=this.DUMMY_INPUT_MIN_HEIGHT=this.TAB_HEIGHT,this.CORNER_RADIUS=8,this.STATEMENT_INPUT_NOTCH_OFFSET=this.NOTCH_OFFSET_LEFT=15,this.STATEMENT_BOTTOM_SPACER=0,this.STATEMENT_INPUT_PADDING_LEFT=20,this.BETWEEN_STATEMENT_PADDING_Y=4,this.TOP_ROW_MIN_HEIGHT=this.MEDIUM_PADDING,this.TOP_ROW_PRECEDES_STATEMENT_MIN_HEIGHT=this.LARGE_PADDING,this.BOTTOM_ROW_MIN_HEIGHT=this.MEDIUM_PADDING,this.BOTTOM_ROW_AFTER_STATEMENT_MIN_HEIGHT=this.LARGE_PADDING,this.ADD_START_HATS=!1,this.START_HAT_HEIGHT=15,this.START_HAT_WIDTH=100,this.SPACER_DEFAULT_HEIGHT=15,this.MIN_BLOCK_HEIGHT=24,this.EMPTY_INLINE_INPUT_PADDING=14.5,this.EMPTY_INLINE_INPUT_HEIGHT=this.TAB_HEIGHT+11,this.EXTERNAL_VALUE_INPUT_PADDING=2,this.EMPTY_STATEMENT_INPUT_HEIGHT=this.MIN_BLOCK_HEIGHT,this.START_POINT=T.utils.svgPaths.moveBy(0,0),this.JAGGED_TEETH_HEIGHT=12,this.JAGGED_TEETH_WIDTH=6,this.FIELD_TEXT_FONTSIZE=11,this.FIELD_TEXT_FONTWEIGHT="normal",this.FIELD_TEXT_FONTFAMILY="sans-serif",this.FIELD_TEXT_BASELINE=this.FIELD_TEXT_HEIGHT=-1,this.FIELD_BORDER_RECT_RADIUS=4,this.FIELD_BORDER_RECT_HEIGHT=16,this.FIELD_BORDER_RECT_X_PADDING=5,this.FIELD_BORDER_RECT_Y_PADDING=3,this.FIELD_BORDER_RECT_COLOUR="#fff",this.FIELD_TEXT_BASELINE_CENTER=!T.utils.userAgent.IE&&!T.utils.userAgent.EDGE,this.FIELD_DROPDOWN_BORDER_RECT_HEIGHT=this.FIELD_BORDER_RECT_HEIGHT,this.FIELD_DROPDOWN_SVG_ARROW=this.FIELD_DROPDOWN_COLOURED_DIV=this.FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW=!1,this.FIELD_DROPDOWN_SVG_ARROW_PADDING=this.FIELD_BORDER_RECT_X_PADDING,this.FIELD_DROPDOWN_SVG_ARROW_SIZE=12,this.FIELD_DROPDOWN_SVG_ARROW_DATAURI="data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgZGF0YS1uYW1lPSJMYXllciAxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMi43MSIgaGVpZ2h0PSI4Ljc5IiB2aWV3Qm94PSIwIDAgMTIuNzEgOC43OSI+PHRpdGxlPmRyb3Bkb3duLWFycm93PC90aXRsZT48ZyBvcGFjaXR5PSIwLjEiPjxwYXRoIGQ9Ik0xMi43MSwyLjQ0QTIuNDEsMi40MSwwLDAsMSwxMiw0LjE2TDguMDgsOC4wOGEyLjQ1LDIuNDUsMCwwLDEtMy40NSwwTDAuNzIsNC4xNkEyLjQyLDIuNDIsMCwwLDEsMCwyLjQ0LDIuNDgsMi40OCwwLDAsMSwuNzEuNzFDMSwwLjQ3LDEuNDMsMCw2LjM2LDBTMTEuNzUsMC40NiwxMiwuNzFBMi40NCwyLjQ0LDAsMCwxLDEyLjcxLDIuNDRaIiBmaWxsPSIjMjMxZjIwIi8+PC9nPjxwYXRoIGQ9Ik02LjM2LDcuNzlhMS40MywxLjQzLDAsMCwxLTEtLjQyTDEuNDIsMy40NWExLjQ0LDEuNDQsMCwwLDEsMC0yYzAuNTYtLjU2LDkuMzEtMC41Niw5Ljg3LDBhMS40NCwxLjQ0LDAsMCwxLDAsMkw3LjM3LDcuMzdBMS40MywxLjQzLDAsMCwxLDYuMzYsNy43OVoiIGZpbGw9IiNmZmYiLz48L3N2Zz4=",this.FIELD_COLOUR_FULL_BLOCK=this.FIELD_TEXTINPUT_BOX_SHADOW=!1,this.FIELD_COLOUR_DEFAULT_WIDTH=26,this.FIELD_COLOUR_DEFAULT_HEIGHT=this.FIELD_BORDER_RECT_HEIGHT,this.FIELD_CHECKBOX_X_OFFSET=this.FIELD_BORDER_RECT_X_PADDING-3,this.randomIdentifier=String(Math.random()).substring(2),this.embossFilterId="",this.embossFilter_=null,this.disabledPatternId="",this.disabledPattern_=null,this.debugFilterId="",this.cssNode_=this.debugFilter_=null,this.CURSOR_COLOUR="#cc0a0a",this.MARKER_COLOUR="#4286f4",this.CURSOR_WS_WIDTH=100,this.WS_CURSOR_HEIGHT=5,this.CURSOR_STACK_PADDING=10,this.CURSOR_BLOCK_PADDING=2,this.CURSOR_STROKE_WIDTH=4,this.FULL_BLOCK_FIELDS=!1,this.INSERTION_MARKER_COLOUR="#000000",this.INSERTION_MARKER_OPACITY=.2,this.SHAPES={PUZZLE:1,NOTCH:2}},T.blockRendering.ConstantProvider.prototype.init=function(){this.JAGGED_TEETH=this.makeJaggedTeeth(),this.NOTCH=this.makeNotch(),this.START_HAT=this.makeStartHat(),this.PUZZLE_TAB=this.makePuzzleTab(),this.INSIDE_CORNERS=this.makeInsideCorners(),this.OUTSIDE_CORNERS=this.makeOutsideCorners()},T.blockRendering.ConstantProvider.prototype.setTheme=function(t){this.blockStyles={};var e=t.blockStyles,o;for(o in e)this.blockStyles[o]=this.validatedBlockStyle_(e[o]);this.setDynamicProperties_(t)},T.blockRendering.ConstantProvider.prototype.setDynamicProperties_=function(t){this.setFontConstants_(t),this.setComponentConstants_(t),this.ADD_START_HATS=null!=t.startHats?t.startHats:this.ADD_START_HATS},T.blockRendering.ConstantProvider.prototype.setFontConstants_=function(t){this.FIELD_TEXT_FONTFAMILY=t.fontStyle&&null!=t.fontStyle.family?t.fontStyle.family:this.FIELD_TEXT_FONTFAMILY,this.FIELD_TEXT_FONTWEIGHT=t.fontStyle&&null!=t.fontStyle.weight?t.fontStyle.weight:this.FIELD_TEXT_FONTWEIGHT,this.FIELD_TEXT_FONTSIZE=t.fontStyle&&null!=t.fontStyle.size?t.fontStyle.size:this.FIELD_TEXT_FONTSIZE,t=T.utils.dom.measureFontMetrics("Hg",this.FIELD_TEXT_FONTSIZE+"pt",this.FIELD_TEXT_FONTWEIGHT,this.FIELD_TEXT_FONTFAMILY),this.FIELD_TEXT_HEIGHT=t.height,this.FIELD_TEXT_BASELINE=t.baseline},T.blockRendering.ConstantProvider.prototype.setComponentConstants_=function(t){this.CURSOR_COLOUR=t.getComponentStyle("cursorColour")||this.CURSOR_COLOUR,this.MARKER_COLOUR=t.getComponentStyle("markerColour")||this.MARKER_COLOUR,this.INSERTION_MARKER_COLOUR=t.getComponentStyle("insertionMarkerColour")||this.INSERTION_MARKER_COLOUR,this.INSERTION_MARKER_OPACITY=Number(t.getComponentStyle("insertionMarkerOpacity"))||this.INSERTION_MARKER_OPACITY},T.blockRendering.ConstantProvider.prototype.getBlockStyleForColour=function(t){var e="auto_"+t;return this.blockStyles[e]||(this.blockStyles[e]=this.createBlockStyle_(t)),{style:this.blockStyles[e],name:e}},T.blockRendering.ConstantProvider.prototype.getBlockStyle=function(t){return this.blockStyles[t||""]||(t&&0==t.indexOf("auto_")?this.getBlockStyleForColour(t.substring(5)).style:this.createBlockStyle_("#000000"))},T.blockRendering.ConstantProvider.prototype.createBlockStyle_=function(t){return this.validatedBlockStyle_({colourPrimary:t})},T.blockRendering.ConstantProvider.prototype.validatedBlockStyle_=function(t){var e={};return t&&T.utils.object.mixin(e,t),t=T.utils.parseBlockColour(e.colourPrimary||"#000"),e.colourPrimary=t.hex,e.colourSecondary=e.colourSecondary?T.utils.parseBlockColour(e.colourSecondary).hex:this.generateSecondaryColour_(e.colourPrimary),e.colourTertiary=e.colourTertiary?T.utils.parseBlockColour(e.colourTertiary).hex:this.generateTertiaryColour_(e.colourPrimary),e.hat=e.hat||"",e},T.blockRendering.ConstantProvider.prototype.generateSecondaryColour_=function(t){return T.utils.colour.blend("#fff",t,.6)||t},T.blockRendering.ConstantProvider.prototype.generateTertiaryColour_=function(t){return T.utils.colour.blend("#fff",t,.3)||t},T.blockRendering.ConstantProvider.prototype.dispose=function(){this.embossFilter_&&T.utils.dom.removeNode(this.embossFilter_),this.disabledPattern_&&T.utils.dom.removeNode(this.disabledPattern_),this.debugFilter_&&T.utils.dom.removeNode(this.debugFilter_),this.cssNode_=null},T.blockRendering.ConstantProvider.prototype.makeJaggedTeeth=function(){var t=this.JAGGED_TEETH_HEIGHT,e=this.JAGGED_TEETH_WIDTH,o;return{height:t,width:e,path:T.utils.svgPaths.line([T.utils.svgPaths.point(e,t/4),T.utils.svgPaths.point(2*-e,t/2),T.utils.svgPaths.point(e,t/4)])}},T.blockRendering.ConstantProvider.prototype.makeStartHat=function(){var t=this.START_HAT_HEIGHT,e=this.START_HAT_WIDTH,o;return{height:t,width:e,path:T.utils.svgPaths.curve("c",[T.utils.svgPaths.point(30,-t),T.utils.svgPaths.point(70,-t),T.utils.svgPaths.point(e,0)])}},T.blockRendering.ConstantProvider.prototype.makePuzzleTab=function(){function t(t){var e=-(t=t?-1:1),o,i=(o=l/2)+2.5,s=o+.5,n=T.utils.svgPaths.point(-r,t*o),o=T.utils.svgPaths.point(r,t*o);return T.utils.svgPaths.curve("c",[T.utils.svgPaths.point(0,t*i),T.utils.svgPaths.point(-r,e*s),n])+T.utils.svgPaths.curve("s",[T.utils.svgPaths.point(r,2.5*e),o])}var r=this.TAB_WIDTH,l=this.TAB_HEIGHT,e=t(!0),o=t(!1);return{type:this.SHAPES.PUZZLE,width:r,height:l,pathDown:o,pathUp:e}},T.blockRendering.ConstantProvider.prototype.makeNotch=function(){function t(t){return T.utils.svgPaths.line([T.utils.svgPaths.point(t*i,o),T.utils.svgPaths.point(3*t,0),T.utils.svgPaths.point(t*i,-o)])}var e=this.NOTCH_WIDTH,o=this.NOTCH_HEIGHT,i=(e-3)/2,s=t(1),n=t(-1);return{type:this.SHAPES.NOTCH,width:e,height:o,pathLeft:s,pathRight:n}},T.blockRendering.ConstantProvider.prototype.makeInsideCorners=function(){var t=this.CORNER_RADIUS,e,o;return{width:t,height:t,pathTop:T.utils.svgPaths.arc("a","0 0,0",t,T.utils.svgPaths.point(-t,t)),pathBottom:T.utils.svgPaths.arc("a","0 0,0",t,T.utils.svgPaths.point(t,t))}},T.blockRendering.ConstantProvider.prototype.makeOutsideCorners=function(){var t=this.CORNER_RADIUS,e=T.utils.svgPaths.moveBy(0,t)+T.utils.svgPaths.arc("a","0 0,1",t,T.utils.svgPaths.point(t,-t)),o=T.utils.svgPaths.arc("a","0 0,1",t,T.utils.svgPaths.point(t,t)),i=T.utils.svgPaths.arc("a","0 0,1",t,T.utils.svgPaths.point(-t,-t)),s;return{topLeft:e,topRight:o,bottomRight:T.utils.svgPaths.arc("a","0 0,1",t,T.utils.svgPaths.point(-t,t)),bottomLeft:i,rightHeight:t}},T.blockRendering.ConstantProvider.prototype.shapeFor=function(t){switch(t.type){case T.connectionTypes.INPUT_VALUE:case T.connectionTypes.OUTPUT_VALUE:return this.PUZZLE_TAB;case T.connectionTypes.PREVIOUS_STATEMENT:case T.connectionTypes.NEXT_STATEMENT:return this.NOTCH;default:throw Error("Unknown connection type")}},T.blockRendering.ConstantProvider.prototype.createDom=function(t,e,o){this.injectCSS_(e,o),t=T.utils.dom.createSvgElement(T.utils.Svg.DEFS,{},t),e=T.utils.dom.createSvgElement(T.utils.Svg.FILTER,{id:"blocklyEmbossFilter"+this.randomIdentifier},t),T.utils.dom.createSvgElement(T.utils.Svg.FEGAUSSIANBLUR,{in:"SourceAlpha",stdDeviation:1,result:"blur"},e),o=T.utils.dom.createSvgElement(T.utils.Svg.FESPECULARLIGHTING,{in:"blur",surfaceScale:1,specularConstant:.5,specularExponent:10,"lighting-color":"white",result:"specOut"},e),T.utils.dom.createSvgElement(T.utils.Svg.FEPOINTLIGHT,{x:-5e3,y:-1e4,z:2e4},o),T.utils.dom.createSvgElement(T.utils.Svg.FECOMPOSITE,{in:"specOut",in2:"SourceAlpha",operator:"in",result:"specOut"},e),T.utils.dom.createSvgElement(T.utils.Svg.FECOMPOSITE,{in:"SourceGraphic",in2:"specOut",operator:"arithmetic",k1:0,k2:1,k3:1,k4:0},e),this.embossFilterId=e.id,this.embossFilter_=e,e=T.utils.dom.createSvgElement(T.utils.Svg.PATTERN,{id:"blocklyDisabledPattern"+this.randomIdentifier,patternUnits:"userSpaceOnUse",width:10,height:10},t),T.utils.dom.createSvgElement(T.utils.Svg.RECT,{width:10,height:10,fill:"#aaa"},e),T.utils.dom.createSvgElement(T.utils.Svg.PATH,{d:"M 0 0 L 10 10 M 10 0 L 0 10",stroke:"#cc0"},e),this.disabledPatternId=e.id,this.disabledPattern_=e,T.blockRendering.Debug&&(t=T.utils.dom.createSvgElement(T.utils.Svg.FILTER,{id:"blocklyDebugFilter"+this.randomIdentifier,height:"160%",width:"180%",y:"-30%",x:"-40%"},t),e=T.utils.dom.createSvgElement(T.utils.Svg.FECOMPONENTTRANSFER,{result:"outBlur"},t),T.utils.dom.createSvgElement(T.utils.Svg.FEFUNCA,{type:"table",tableValues:"0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"},e),T.utils.dom.createSvgElement(T.utils.Svg.FEFLOOD,{"flood-color":"#ff0000","flood-opacity":.5,result:"outColor"},t),T.utils.dom.createSvgElement(T.utils.Svg.FECOMPOSITE,{in:"outColor",in2:"outBlur",operator:"in",result:"outGlow"},t),this.debugFilterId=t.id,this.debugFilter_=t)},T.blockRendering.ConstantProvider.prototype.injectCSS_=function(t,e){e=this.getCSS_(e),t="blockly-renderer-style-"+t,this.cssNode_=document.getElementById(t);var o=e.join("\n");this.cssNode_?this.cssNode_.firstChild.textContent=o:((e=document.createElement("style")).id=t,t=document.createTextNode(o),e.appendChild(t),document.head.insertBefore(e,document.head.firstChild),this.cssNode_=e)},T.blockRendering.ConstantProvider.prototype.getCSS_=function(t){return[t+" .blocklyText, ",t+" .blocklyFlyoutLabelText {","font: "+this.FIELD_TEXT_FONTWEIGHT+" "+this.FIELD_TEXT_FONTSIZE+"pt "+this.FIELD_TEXT_FONTFAMILY+";","}",t+" .blocklyText {","fill: #fff;","}",t+" .blocklyNonEditableText>rect,",t+" .blocklyEditableText>rect {","fill: "+this.FIELD_BORDER_RECT_COLOUR+";","fill-opacity: .6;","stroke: none;","}",t+" .blocklyNonEditableText>text,",t+" .blocklyEditableText>text {","fill: #000;","}",t+" .blocklyFlyoutLabelText {","fill: #000;","}",t+" .blocklyText.blocklyBubbleText {","fill: #000;","}",t+" .blocklyEditableText:not(.editing):hover>rect {","stroke: #fff;","stroke-width: 2;","}",t+" .blocklyHtmlInput {","font-family: "+this.FIELD_TEXT_FONTFAMILY+";","font-weight: "+this.FIELD_TEXT_FONTWEIGHT+";","}",t+" .blocklySelected>.blocklyPath {","stroke: #fc3;","stroke-width: 3px;","}",t+" .blocklyHighlightedConnectionPath {","stroke: #fc3;","}",t+" .blocklyReplaceable .blocklyPath {","fill-opacity: .5;","}",t+" .blocklyReplaceable .blocklyPathLight,",t+" .blocklyReplaceable .blocklyPathDark {","display: none;","}",t+" .blocklyInsertionMarker>.blocklyPath {","fill-opacity: "+this.INSERTION_MARKER_OPACITY+";","stroke: none;","}"]},T.blockRendering.Types={NONE:0,FIELD:1,HAT:2,ICON:4,SPACER:8,BETWEEN_ROW_SPACER:16,IN_ROW_SPACER:32,EXTERNAL_VALUE_INPUT:64,INPUT:128,INLINE_INPUT:256,STATEMENT_INPUT:512,CONNECTION:1024,PREVIOUS_CONNECTION:2048,NEXT_CONNECTION:4096,OUTPUT_CONNECTION:8192,CORNER:16384,LEFT_SQUARE_CORNER:32768,LEFT_ROUND_CORNER:65536,RIGHT_SQUARE_CORNER:131072,RIGHT_ROUND_CORNER:262144,JAGGED_EDGE:524288,ROW:1048576,TOP_ROW:2097152,BOTTOM_ROW:4194304,INPUT_ROW:8388608},T.blockRendering.Types.LEFT_CORNER=T.blockRendering.Types.LEFT_SQUARE_CORNER|T.blockRendering.Types.LEFT_ROUND_CORNER,T.blockRendering.Types.RIGHT_CORNER=T.blockRendering.Types.RIGHT_SQUARE_CORNER|T.blockRendering.Types.RIGHT_ROUND_CORNER,T.blockRendering.Types.nextTypeValue_=16777216,T.blockRendering.Types.getType=function(t){return Object.prototype.hasOwnProperty.call(T.blockRendering.Types,t)||(T.blockRendering.Types[t]=T.blockRendering.Types.nextTypeValue_,T.blockRendering.Types.nextTypeValue_<<=1),T.blockRendering.Types[t]},T.blockRendering.Types.isField=function(t){return t.type&T.blockRendering.Types.FIELD},T.blockRendering.Types.isHat=function(t){return t.type&T.blockRendering.Types.HAT},T.blockRendering.Types.isIcon=function(t){return t.type&T.blockRendering.Types.ICON},T.blockRendering.Types.isSpacer=function(t){return t.type&T.blockRendering.Types.SPACER},T.blockRendering.Types.isInRowSpacer=function(t){return t.type&T.blockRendering.Types.IN_ROW_SPACER},T.blockRendering.Types.isInput=function(t){return t.type&T.blockRendering.Types.INPUT},T.blockRendering.Types.isExternalInput=function(t){return t.type&T.blockRendering.Types.EXTERNAL_VALUE_INPUT},T.blockRendering.Types.isInlineInput=function(t){return t.type&T.blockRendering.Types.INLINE_INPUT},T.blockRendering.Types.isStatementInput=function(t){return t.type&T.blockRendering.Types.STATEMENT_INPUT},T.blockRendering.Types.isPreviousConnection=function(t){return t.type&T.blockRendering.Types.PREVIOUS_CONNECTION},T.blockRendering.Types.isNextConnection=function(t){return t.type&T.blockRendering.Types.NEXT_CONNECTION},T.blockRendering.Types.isPreviousOrNextConnection=function(t){return t.type&(T.blockRendering.Types.PREVIOUS_CONNECTION|T.blockRendering.Types.NEXT_CONNECTION)},T.blockRendering.Types.isLeftRoundedCorner=function(t){return t.type&T.blockRendering.Types.LEFT_ROUND_CORNER},T.blockRendering.Types.isRightRoundedCorner=function(t){return t.type&T.blockRendering.Types.RIGHT_ROUND_CORNER},T.blockRendering.Types.isLeftSquareCorner=function(t){return t.type&T.blockRendering.Types.LEFT_SQUARE_CORNER},T.blockRendering.Types.isRightSquareCorner=function(t){return t.type&T.blockRendering.Types.RIGHT_SQUARE_CORNER},T.blockRendering.Types.isCorner=function(t){return t.type&T.blockRendering.Types.CORNER},T.blockRendering.Types.isJaggedEdge=function(t){return t.type&T.blockRendering.Types.JAGGED_EDGE},T.blockRendering.Types.isRow=function(t){return t.type&T.blockRendering.Types.ROW},T.blockRendering.Types.isBetweenRowSpacer=function(t){return t.type&T.blockRendering.Types.BETWEEN_ROW_SPACER},T.blockRendering.Types.isTopRow=function(t){return t.type&T.blockRendering.Types.TOP_ROW},T.blockRendering.Types.isBottomRow=function(t){return t.type&T.blockRendering.Types.BOTTOM_ROW},T.blockRendering.Types.isTopOrBottomRow=function(t){return t.type&(T.blockRendering.Types.TOP_ROW|T.blockRendering.Types.BOTTOM_ROW)},T.blockRendering.Types.isInputRow=function(t){return t.type&T.blockRendering.Types.INPUT_ROW},T.blockRendering.Measurable=function(t){this.height=this.width=0,this.type=T.blockRendering.Types.NONE,this.centerline=this.xPos=0,this.constants_=t,this.notchOffset=this.constants_.NOTCH_OFFSET_LEFT},T.blockRendering.Connection=function(t,e){T.blockRendering.Connection.superClass_.constructor.call(this,t),this.connectionModel=e,this.shape=this.constants_.shapeFor(e),this.isDynamicShape=!!this.shape.isDynamic,this.type|=T.blockRendering.Types.CONNECTION},T.utils.object.inherits(T.blockRendering.Connection,T.blockRendering.Measurable),T.blockRendering.OutputConnection=function(t,e){T.blockRendering.OutputConnection.superClass_.constructor.call(this,t,e),this.type|=T.blockRendering.Types.OUTPUT_CONNECTION,this.height=this.isDynamicShape?0:this.shape.height,this.startX=this.width=this.isDynamicShape?0:this.shape.width,this.connectionOffsetY=this.constants_.TAB_OFFSET_FROM_TOP,this.connectionOffsetX=0},T.utils.object.inherits(T.blockRendering.OutputConnection,T.blockRendering.Connection),T.blockRendering.PreviousConnection=function(t,e){T.blockRendering.PreviousConnection.superClass_.constructor.call(this,t,e),this.type|=T.blockRendering.Types.PREVIOUS_CONNECTION,this.height=this.shape.height,this.width=this.shape.width},T.utils.object.inherits(T.blockRendering.PreviousConnection,T.blockRendering.Connection),T.blockRendering.NextConnection=function(t,e){T.blockRendering.NextConnection.superClass_.constructor.call(this,t,e),this.type|=T.blockRendering.Types.NEXT_CONNECTION,this.height=this.shape.height,this.width=this.shape.width},T.utils.object.inherits(T.blockRendering.NextConnection,T.blockRendering.Connection),T.blockRendering.InputConnection=function(t,e){T.blockRendering.InputConnection.superClass_.constructor.call(this,t,e.connection),this.type|=T.blockRendering.Types.INPUT,this.input=e,this.align=e.align,(this.connectedBlock=e.connection&&e.connection.targetBlock()?e.connection.targetBlock():null)?(t=this.connectedBlock.getHeightWidth(),this.connectedBlockWidth=t.width,this.connectedBlockHeight=t.height):this.connectedBlockHeight=this.connectedBlockWidth=0,this.connectionOffsetY=this.connectionOffsetX=0},T.utils.object.inherits(T.blockRendering.InputConnection,T.blockRendering.Connection),T.blockRendering.InlineInput=function(t,e){T.blockRendering.InlineInput.superClass_.constructor.call(this,t,e),this.type|=T.blockRendering.Types.INLINE_INPUT,this.connectedBlock?(this.width=this.connectedBlockWidth,this.height=this.connectedBlockHeight):(this.height=this.constants_.EMPTY_INLINE_INPUT_HEIGHT,this.width=this.constants_.EMPTY_INLINE_INPUT_PADDING),this.connectionHeight=this.isDynamicShape?this.shape.height(this.height):this.shape.height,this.connectionWidth=this.isDynamicShape?this.shape.width(this.height):this.shape.width,this.connectedBlock||(this.width+=this.connectionWidth*(this.isDynamicShape?2:1)),this.connectionOffsetY=this.isDynamicShape?this.shape.connectionOffsetY(this.connectionHeight):this.constants_.TAB_OFFSET_FROM_TOP,this.connectionOffsetX=this.isDynamicShape?this.shape.connectionOffsetX(this.connectionWidth):0},T.utils.object.inherits(T.blockRendering.InlineInput,T.blockRendering.InputConnection),T.blockRendering.StatementInput=function(t,e){T.blockRendering.StatementInput.superClass_.constructor.call(this,t,e),this.type|=T.blockRendering.Types.STATEMENT_INPUT,this.height=this.connectedBlock?this.connectedBlockHeight+this.constants_.STATEMENT_BOTTOM_SPACER:this.constants_.EMPTY_STATEMENT_INPUT_HEIGHT,this.width=this.constants_.STATEMENT_INPUT_NOTCH_OFFSET+this.shape.width},T.utils.object.inherits(T.blockRendering.StatementInput,T.blockRendering.InputConnection),T.blockRendering.ExternalValueInput=function(t,e){T.blockRendering.ExternalValueInput.superClass_.constructor.call(this,t,e),this.type|=T.blockRendering.Types.EXTERNAL_VALUE_INPUT,this.height=this.connectedBlock?this.connectedBlockHeight-this.constants_.TAB_OFFSET_FROM_TOP-this.constants_.MEDIUM_PADDING:this.shape.height,this.width=this.shape.width+this.constants_.EXTERNAL_VALUE_INPUT_PADDING,this.connectionOffsetY=this.constants_.TAB_OFFSET_FROM_TOP,this.connectionHeight=this.shape.height,this.connectionWidth=this.shape.width},T.utils.object.inherits(T.blockRendering.ExternalValueInput,T.blockRendering.InputConnection),T.blockRendering.Icon=function(t,e){T.blockRendering.Icon.superClass_.constructor.call(this,t),this.icon=e,this.isVisible=e.isVisible(),this.type|=T.blockRendering.Types.ICON,t=e.getCorrectedSize(),this.height=t.height,this.width=t.width},T.utils.object.inherits(T.blockRendering.Icon,T.blockRendering.Measurable),T.blockRendering.JaggedEdge=function(t){T.blockRendering.JaggedEdge.superClass_.constructor.call(this,t),this.type|=T.blockRendering.Types.JAGGED_EDGE,this.height=this.constants_.JAGGED_TEETH.height,this.width=this.constants_.JAGGED_TEETH.width},T.utils.object.inherits(T.blockRendering.JaggedEdge,T.blockRendering.Measurable),T.blockRendering.Field=function(t,e,o){T.blockRendering.Field.superClass_.constructor.call(this,t),this.field=e,this.isEditable=e.EDITABLE,this.flipRtl=e.getFlipRtl(),this.type|=T.blockRendering.Types.FIELD,t=this.field.getSize(),this.height=t.height,this.width=t.width,this.parentInput=o},T.utils.object.inherits(T.blockRendering.Field,T.blockRendering.Measurable),T.blockRendering.Hat=function(t){T.blockRendering.Hat.superClass_.constructor.call(this,t),this.type|=T.blockRendering.Types.HAT,this.height=this.constants_.START_HAT.height,this.width=this.constants_.START_HAT.width,this.ascenderHeight=this.height},T.utils.object.inherits(T.blockRendering.Hat,T.blockRendering.Measurable),T.blockRendering.SquareCorner=function(t,e){T.blockRendering.SquareCorner.superClass_.constructor.call(this,t),this.type=(e&&"left"!=e?T.blockRendering.Types.RIGHT_SQUARE_CORNER:T.blockRendering.Types.LEFT_SQUARE_CORNER)|T.blockRendering.Types.CORNER,this.width=this.height=this.constants_.NO_PADDING},T.utils.object.inherits(T.blockRendering.SquareCorner,T.blockRendering.Measurable),T.blockRendering.RoundCorner=function(t,e){T.blockRendering.RoundCorner.superClass_.constructor.call(this,t),this.type=(e&&"left"!=e?T.blockRendering.Types.RIGHT_ROUND_CORNER:T.blockRendering.Types.LEFT_ROUND_CORNER)|T.blockRendering.Types.CORNER,this.width=this.constants_.CORNER_RADIUS,this.height=this.constants_.CORNER_RADIUS/2},T.utils.object.inherits(T.blockRendering.RoundCorner,T.blockRendering.Measurable),T.blockRendering.InRowSpacer=function(t,e){T.blockRendering.InRowSpacer.superClass_.constructor.call(this,t),this.type=this.type|T.blockRendering.Types.SPACER|T.blockRendering.Types.IN_ROW_SPACER,this.width=e,this.height=this.constants_.SPACER_DEFAULT_HEIGHT},T.utils.object.inherits(T.blockRendering.InRowSpacer,T.blockRendering.Measurable),T.blockRendering.Row=function(t){this.type=T.blockRendering.Types.ROW,this.elements=[],this.xPos=this.yPos=this.widthWithConnectedBlocks=this.minWidth=this.minHeight=this.width=this.height=0,this.hasJaggedEdge=this.hasDummyInput=this.hasInlineInput=this.hasStatement=this.hasExternalInput=!1,this.constants_=t,this.notchOffset=this.constants_.NOTCH_OFFSET_LEFT,this.align=null},T.blockRendering.Row.prototype.measure=function(){throw Error("Unexpected attempt to measure a base Row.")},T.blockRendering.Row.prototype.getLastInput=function(){for(var t=this.elements.length-1,e;e=this.elements[t];t--)if(T.blockRendering.Types.isInput(e))return e;return null},T.blockRendering.Row.prototype.startsWithElemSpacer=function(){return!0},T.blockRendering.Row.prototype.endsWithElemSpacer=function(){return!0},T.blockRendering.Row.prototype.getFirstSpacer=function(){for(var t=0,e;e=this.elements[t];t++)if(T.blockRendering.Types.isSpacer(e))return e;return null},T.blockRendering.Row.prototype.getLastSpacer=function(){for(var t=this.elements.length-1,e;e=this.elements[t];t--)if(T.blockRendering.Types.isSpacer(e))return e;return null},T.blockRendering.TopRow=function(t){T.blockRendering.TopRow.superClass_.constructor.call(this,t),this.type|=T.blockRendering.Types.TOP_ROW,this.ascenderHeight=this.capline=0,this.hasPreviousConnection=!1,this.connection=null},T.utils.object.inherits(T.blockRendering.TopRow,T.blockRendering.Row),T.blockRendering.TopRow.prototype.hasLeftSquareCorner=function(t){var e=(t.hat?"cap"===t.hat:this.constants_.ADD_START_HATS)&&!t.outputConnection&&!t.previousConnection,o=t.getPreviousBlock();return!!t.outputConnection||e||!!o&&o.getNextBlock()==t},T.blockRendering.TopRow.prototype.hasRightSquareCorner=function(t){return!0},T.blockRendering.TopRow.prototype.measure=function(){for(var t=0,e=0,o=0,i=0,s;s=this.elements[i];i++)e+=s.width,T.blockRendering.Types.isSpacer(s)||(T.blockRendering.Types.isHat(s)?o=Math.max(o,s.ascenderHeight):t=Math.max(t,s.height));this.width=Math.max(this.minWidth,e),this.height=Math.max(this.minHeight,t)+o,this.capline=this.ascenderHeight=o,this.widthWithConnectedBlocks=this.width},T.blockRendering.TopRow.prototype.startsWithElemSpacer=function(){return!1},T.blockRendering.TopRow.prototype.endsWithElemSpacer=function(){return!1},T.blockRendering.BottomRow=function(t){T.blockRendering.BottomRow.superClass_.constructor.call(this,t),this.type|=T.blockRendering.Types.BOTTOM_ROW,this.hasNextConnection=!1,this.connection=null,this.baseline=this.descenderHeight=0},T.utils.object.inherits(T.blockRendering.BottomRow,T.blockRendering.Row),T.blockRendering.BottomRow.prototype.hasLeftSquareCorner=function(t){return!!t.outputConnection||!!t.getNextBlock()},T.blockRendering.BottomRow.prototype.hasRightSquareCorner=function(t){return!0},T.blockRendering.BottomRow.prototype.measure=function(){for(var t=0,e=0,o=0,i=0,s;s=this.elements[i];i++)e+=s.width,T.blockRendering.Types.isSpacer(s)||(T.blockRendering.Types.isNextConnection(s)?o=Math.max(o,s.height):t=Math.max(t,s.height));this.width=Math.max(this.minWidth,e),this.height=Math.max(this.minHeight,t)+o,this.descenderHeight=o,this.widthWithConnectedBlocks=this.width},T.blockRendering.BottomRow.prototype.startsWithElemSpacer=function(){return!1},T.blockRendering.BottomRow.prototype.endsWithElemSpacer=function(){return!1},T.blockRendering.SpacerRow=function(t,e,o){T.blockRendering.SpacerRow.superClass_.constructor.call(this,t),this.type=this.type|T.blockRendering.Types.SPACER|T.blockRendering.Types.BETWEEN_ROW_SPACER,this.width=o,this.height=e,this.followsStatement=!1,this.widthWithConnectedBlocks=0,this.elements=[new T.blockRendering.InRowSpacer(this.constants_,o)]},T.utils.object.inherits(T.blockRendering.SpacerRow,T.blockRendering.Row),T.blockRendering.SpacerRow.prototype.measure=function(){},T.blockRendering.InputRow=function(t){T.blockRendering.InputRow.superClass_.constructor.call(this,t),this.type|=T.blockRendering.Types.INPUT_ROW,this.connectedBlockWidths=0},T.utils.object.inherits(T.blockRendering.InputRow,T.blockRendering.Row),T.blockRendering.InputRow.prototype.measure=function(){this.width=this.minWidth,this.height=this.minHeight;for(var t=0,e=0,o;o=this.elements[e];e++)this.width+=o.width,T.blockRendering.Types.isInput(o)&&(T.blockRendering.Types.isStatementInput(o)?t+=o.connectedBlockWidth:T.blockRendering.Types.isExternalInput(o)&&0!=o.connectedBlockWidth&&(t+=o.connectedBlockWidth-o.connectionWidth)),T.blockRendering.Types.isSpacer(o)||(this.height=Math.max(this.height,o.height));this.connectedBlockWidths=t,this.widthWithConnectedBlocks=this.width+t},T.blockRendering.InputRow.prototype.endsWithElemSpacer=function(){return!this.hasExternalInput&&!this.hasStatement},T.blockRendering.RenderInfo=function(t,e){this.block_=e,this.renderer_=t,this.constants_=this.renderer_.getConstants(),this.outputConnection=e.outputConnection?new T.blockRendering.OutputConnection(this.constants_,e.outputConnection):null,this.isInline=e.getInputsInline()&&!e.isCollapsed(),this.isCollapsed=e.isCollapsed(),this.isInsertionMarker=e.isInsertionMarker(),this.RTL=e.RTL,this.statementEdge=this.width=this.widthWithChildren=this.height=0,this.rows=[],this.inputRows=[],this.hiddenIcons=[],this.topRow=new T.blockRendering.TopRow(this.constants_),this.bottomRow=new T.blockRendering.BottomRow(this.constants_),this.startY=this.startX=0},T.blockRendering.RenderInfo.prototype.getRenderer=function(){return this.renderer_},T.blockRendering.RenderInfo.prototype.measure=function(){this.createRows_(),this.addElemSpacing_(),this.addRowSpacing_(),this.computeBounds_(),this.alignRowElements_(),this.finalize_()},T.blockRendering.RenderInfo.prototype.createRows_=function(){this.populateTopRow_(),this.rows.push(this.topRow);var t=new T.blockRendering.InputRow(this.constants_),e=(this.inputRows.push(t),this.block_.getIcons());if(e.length)for(var o=0,i;i=e[o];o++){var s=new T.blockRendering.Icon(this.constants_,i);(this.isCollapsed&&i.collapseHidden?this.hiddenIcons:t.elements).push(s)}for(i=null,o=0;e=this.block_.inputList[o];o++)if(e.isVisible()){for(this.shouldStartNewRow_(e,i)&&(this.rows.push(t),t=new T.blockRendering.InputRow(this.constants_),this.inputRows.push(t)),i=0;s=e.fieldRow[i];i++)t.elements.push(new T.blockRendering.Field(this.constants_,s,e));this.addInput_(e,t),i=e}this.isCollapsed&&(t.hasJaggedEdge=!0,t.elements.push(new T.blockRendering.JaggedEdge(this.constants_))),(t.elements.length||t.hasDummyInput)&&this.rows.push(t),this.populateBottomRow_(),this.rows.push(this.bottomRow)},T.blockRendering.RenderInfo.prototype.populateTopRow_=function(){var t=!!this.block_.previousConnection,e=(this.block_.hat?"cap"===this.block_.hat:this.constants_.ADD_START_HATS)&&!this.outputConnection&&!t;this.topRow.hasLeftSquareCorner(this.block_)?this.topRow.elements.push(new T.blockRendering.SquareCorner(this.constants_)):this.topRow.elements.push(new T.blockRendering.RoundCorner(this.constants_)),e?(t=new T.blockRendering.Hat(this.constants_),this.topRow.elements.push(t),this.topRow.capline=t.ascenderHeight):t&&(this.topRow.hasPreviousConnection=!0,this.topRow.connection=new T.blockRendering.PreviousConnection(this.constants_,this.block_.previousConnection),this.topRow.elements.push(this.topRow.connection)),this.block_.inputList.length&&this.block_.inputList[0].type==T.inputTypes.STATEMENT&&!this.block_.isCollapsed()?this.topRow.minHeight=this.constants_.TOP_ROW_PRECEDES_STATEMENT_MIN_HEIGHT:this.topRow.minHeight=this.constants_.TOP_ROW_MIN_HEIGHT,this.topRow.hasRightSquareCorner(this.block_)?this.topRow.elements.push(new T.blockRendering.SquareCorner(this.constants_,"right")):this.topRow.elements.push(new T.blockRendering.RoundCorner(this.constants_,"right"))},T.blockRendering.RenderInfo.prototype.populateBottomRow_=function(){this.bottomRow.hasNextConnection=!!this.block_.nextConnection,this.bottomRow.minHeight=this.block_.inputList.length&&this.block_.inputList[this.block_.inputList.length-1].type==T.inputTypes.STATEMENT?this.constants_.BOTTOM_ROW_AFTER_STATEMENT_MIN_HEIGHT:this.constants_.BOTTOM_ROW_MIN_HEIGHT,this.bottomRow.hasLeftSquareCorner(this.block_)?this.bottomRow.elements.push(new T.blockRendering.SquareCorner(this.constants_)):this.bottomRow.elements.push(new T.blockRendering.RoundCorner(this.constants_)),this.bottomRow.hasNextConnection&&(this.bottomRow.connection=new T.blockRendering.NextConnection(this.constants_,this.block_.nextConnection),this.bottomRow.elements.push(this.bottomRow.connection)),this.bottomRow.hasRightSquareCorner(this.block_)?this.bottomRow.elements.push(new T.blockRendering.SquareCorner(this.constants_,"right")):this.bottomRow.elements.push(new T.blockRendering.RoundCorner(this.constants_,"right"))},T.blockRendering.RenderInfo.prototype.addInput_=function(t,e){this.isInline&&t.type==T.inputTypes.VALUE?(e.elements.push(new T.blockRendering.InlineInput(this.constants_,t)),e.hasInlineInput=!0):t.type==T.inputTypes.STATEMENT?(e.elements.push(new T.blockRendering.StatementInput(this.constants_,t)),e.hasStatement=!0):t.type==T.inputTypes.VALUE?(e.elements.push(new T.blockRendering.ExternalValueInput(this.constants_,t)),e.hasExternalInput=!0):t.type==T.inputTypes.DUMMY&&(e.minHeight=Math.max(e.minHeight,t.getSourceBlock()&&t.getSourceBlock().isShadow()?this.constants_.DUMMY_INPUT_SHADOW_MIN_HEIGHT:this.constants_.DUMMY_INPUT_MIN_HEIGHT),e.hasDummyInput=!0),null==e.align&&(e.align=t.align)},T.blockRendering.RenderInfo.prototype.shouldStartNewRow_=function(t,e){return!(!e||t.type!=T.inputTypes.STATEMENT&&e.type!=T.inputTypes.STATEMENT&&(t.type!=T.inputTypes.VALUE&&t.type!=T.inputTypes.DUMMY||this.isInline))},T.blockRendering.RenderInfo.prototype.addElemSpacing_=function(){for(var t=0,e;e=this.rows[t];t++){var o=e.elements;if(e.elements=[],e.startsWithElemSpacer()&&e.elements.push(new T.blockRendering.InRowSpacer(this.constants_,this.getInRowSpacing_(null,o[0]))),o.length){for(var i=0;i<o.length-1;i++){e.elements.push(o[i]);var s=this.getInRowSpacing_(o[i],o[i+1]);e.elements.push(new T.blockRendering.InRowSpacer(this.constants_,s))}e.elements.push(o[o.length-1]),e.endsWithElemSpacer()&&e.elements.push(new T.blockRendering.InRowSpacer(this.constants_,this.getInRowSpacing_(o[o.length-1],null)))}}},T.blockRendering.RenderInfo.prototype.getInRowSpacing_=function(t,e){if(!t&&e&&T.blockRendering.Types.isStatementInput(e))return this.constants_.STATEMENT_INPUT_PADDING_LEFT;if(t&&T.blockRendering.Types.isInput(t)&&!e){if(T.blockRendering.Types.isExternalInput(t))return this.constants_.NO_PADDING;if(T.blockRendering.Types.isInlineInput(t))return this.constants_.LARGE_PADDING;if(T.blockRendering.Types.isStatementInput(t))return this.constants_.NO_PADDING}return t&&T.blockRendering.Types.isLeftSquareCorner(t)&&e&&(T.blockRendering.Types.isPreviousConnection(e)||T.blockRendering.Types.isNextConnection(e))?e.notchOffset:t&&T.blockRendering.Types.isLeftRoundedCorner(t)&&e&&(T.blockRendering.Types.isPreviousConnection(e)||T.blockRendering.Types.isNextConnection(e))?e.notchOffset-this.constants_.CORNER_RADIUS:this.constants_.MEDIUM_PADDING},T.blockRendering.RenderInfo.prototype.computeBounds_=function(){for(var t=0,e=0,o=0,i=0,s,n,t;s=this.rows[i];i++){s.measure(),e=Math.max(e,s.width),s.hasStatement&&(n=s.getLastInput(),t=Math.max(t,s.width-n.width)),o=Math.max(o,s.widthWithConnectedBlocks)}for(this.statementEdge=t,this.width=e,i=0;s=this.rows[i];i++)s.hasStatement&&(s.statementEdge=this.statementEdge);this.widthWithChildren=Math.max(e,o),this.outputConnection&&(this.startX=this.outputConnection.width,this.width+=this.outputConnection.width,this.widthWithChildren+=this.outputConnection.width)},T.blockRendering.RenderInfo.prototype.alignRowElements_=function(){for(var t=0,e,o,o;e=this.rows[t];t++){e.hasStatement?this.alignStatementRow_(e):(o=e.width,0<(o=this.getDesiredRowWidth_(e)-o)&&this.addAlignmentPadding_(e,o),T.blockRendering.Types.isTopOrBottomRow(e)&&(e.widthWithConnectedBlocks=e.width))}},T.blockRendering.RenderInfo.prototype.getDesiredRowWidth_=function(t){return this.width-this.startX},T.blockRendering.RenderInfo.prototype.addAlignmentPadding_=function(t,e){var o=t.getFirstSpacer(),i=t.getLastSpacer();(t.hasExternalInput||t.hasStatement)&&(t.widthWithConnectedBlocks+=e),t.align==T.constants.ALIGN.LEFT?i.width+=e:t.align==T.constants.ALIGN.CENTRE?(o.width+=e/2,i.width+=e/2):t.align==T.constants.ALIGN.RIGHT?o.width+=e:i.width+=e,t.width+=e},T.blockRendering.RenderInfo.prototype.alignStatementRow_=function(t){var e=t.getLastInput(),o=t.width-e.width,i,o;0<(o=(i=this.statementEdge)-o)&&this.addAlignmentPadding_(t,o),o=t.width,i=this.getDesiredRowWidth_(t),e.width+=i-o,e.height=Math.max(e.height,t.height),t.width+=i-o,t.widthWithConnectedBlocks=Math.max(t.width,this.statementEdge+t.connectedBlockWidths)},T.blockRendering.RenderInfo.prototype.addRowSpacing_=function(){var t=this.rows;this.rows=[];for(var e=0;e<t.length;e++)this.rows.push(t[e]),e!=t.length-1&&this.rows.push(this.makeSpacerRow_(t[e],t[e+1]))},T.blockRendering.RenderInfo.prototype.makeSpacerRow_=function(t,e){var o=this.getSpacerRowHeight_(t,e),i=this.getSpacerRowWidth_(t,e),o=new T.blockRendering.SpacerRow(this.constants_,o,i);return t.hasStatement&&(o.followsStatement=!0),e.hasStatement&&(o.precedesStatement=!0),o},T.blockRendering.RenderInfo.prototype.getSpacerRowWidth_=function(t,e){return this.width-this.startX},T.blockRendering.RenderInfo.prototype.getSpacerRowHeight_=function(t,e){return this.constants_.MEDIUM_PADDING},T.blockRendering.RenderInfo.prototype.getElemCenterline_=function(t,e){return T.blockRendering.Types.isSpacer(e)?t.yPos+e.height/2:T.blockRendering.Types.isBottomRow(t)?(t=t.yPos+t.height-t.descenderHeight,T.blockRendering.Types.isNextConnection(e)?t+e.height/2:t-e.height/2):T.blockRendering.Types.isTopRow(t)?T.blockRendering.Types.isHat(e)?t.capline-e.height/2:t.capline+e.height/2:t.yPos+t.height/2},T.blockRendering.RenderInfo.prototype.recordElemPositions_=function(t){for(var e=t.xPos,o=0,i;i=t.elements[o];o++)T.blockRendering.Types.isSpacer(i)&&(i.height=t.height),i.xPos=e,i.centerline=this.getElemCenterline_(t,i),e+=i.width},T.blockRendering.RenderInfo.prototype.finalize_=function(){for(var t=0,e=0,o=0,i;i=this.rows[o];o++)i.yPos=e,i.xPos=this.startX,e+=i.height,t=Math.max(t,i.widthWithConnectedBlocks),this.recordElemPositions_(i);this.outputConnection&&this.block_.nextConnection&&this.block_.nextConnection.isConnected()&&(t=Math.max(t,this.block_.nextConnection.targetBlock().getHeightWidth().width)),this.widthWithChildren=t+this.startX,this.height=e,this.startY=this.topRow.capline,this.bottomRow.baseline=e-this.bottomRow.descenderHeight},T.blockRendering.Debug=function(t){this.debugElements_=[],this.svgRoot_=null,this.constants_=t},T.blockRendering.Debug.config={rowSpacers:!0,elemSpacers:!0,rows:!0,elems:!0,connections:!0,blockBounds:!0,connectedBlockBounds:!0,render:!0},T.blockRendering.Debug.prototype.clearElems=function(){for(var t=0,e;e=this.debugElements_[t];t++)T.utils.dom.removeNode(e);this.debugElements_=[]},T.blockRendering.Debug.prototype.drawSpacerRow=function(t,e,o){var i,s;T.blockRendering.Debug.config.rowSpacers&&(i=Math.abs(t.height),(s=t.height<0)&&(e-=i),this.debugElements_.push(T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"rowSpacerRect blockRenderDebug",x:o?-(t.xPos+t.width):t.xPos,y:e,width:t.width,height:i,stroke:s?"black":"blue",fill:"blue","fill-opacity":"0.5","stroke-width":"1px"},this.svgRoot_)))},T.blockRendering.Debug.prototype.drawSpacerElem=function(t,e,o){var i,s;T.blockRendering.Debug.config.elemSpacers&&(e=Math.abs(t.width),s=(i=t.width<0)?t.xPos-e:t.xPos,this.debugElements_.push(T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"elemSpacerRect blockRenderDebug",x:s=o?-(s+e):s,y:t.centerline-t.height/2,width:e,height:t.height,stroke:"pink",fill:i?"black":"pink","fill-opacity":"0.5","stroke-width":"1px"},this.svgRoot_)))},T.blockRendering.Debug.prototype.drawRenderedElem=function(t,e){var o;T.blockRendering.Debug.config.elems&&(o=t.xPos,e&&(o=-(o+t.width)),e=t.centerline-t.height/2,this.debugElements_.push(T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"rowRenderingRect blockRenderDebug",x:o,y:e,width:t.width,height:t.height,stroke:"black",fill:"none","stroke-width":"1px"},this.svgRoot_)),T.blockRendering.Types.isField(t))&&t.field instanceof T.FieldLabel&&this.debugElements_.push(T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"rowRenderingRect blockRenderDebug",x:o,y:e+this.constants_.FIELD_TEXT_BASELINE,width:t.width,height:"0.1px",stroke:"red",fill:"none","stroke-width":"0.5px"},this.svgRoot_)),T.blockRendering.Types.isInput(t)&&T.blockRendering.Debug.config.connections&&this.drawConnection(t.connectionModel)},T.blockRendering.Debug.prototype.drawConnection=function(t){var e,o,i;T.blockRendering.Debug.config.connections&&(t.type==T.connectionTypes.INPUT_VALUE?(e=4,o="magenta",i="none"):t.type==T.connectionTypes.OUTPUT_VALUE?(e=2,i=o="magenta"):t.type==T.connectionTypes.NEXT_STATEMENT?(e=4,o="goldenrod",i="none"):t.type==T.connectionTypes.PREVIOUS_STATEMENT&&(e=2,i=o="goldenrod"),this.debugElements_.push(T.utils.dom.createSvgElement(T.utils.Svg.CIRCLE,{class:"blockRenderDebug",cx:t.offsetInBlock_.x,cy:t.offsetInBlock_.y,r:e,fill:i,stroke:o},this.svgRoot_)))},T.blockRendering.Debug.prototype.drawRenderedRow=function(t,e,o){T.blockRendering.Debug.config.rows&&(this.debugElements_.push(T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"elemRenderingRect blockRenderDebug",x:o?-(t.xPos+t.width):t.xPos,y:t.yPos,width:t.width,height:t.height,stroke:"red",fill:"none","stroke-width":"1px"},this.svgRoot_)),T.blockRendering.Types.isTopOrBottomRow(t)||T.blockRendering.Debug.config.connectedBlockBounds&&this.debugElements_.push(T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"connectedBlockWidth blockRenderDebug",x:o?-(t.xPos+t.widthWithConnectedBlocks):t.xPos,y:t.yPos,width:t.widthWithConnectedBlocks,height:t.height,stroke:this.randomColour_,fill:"none","stroke-width":"1px","stroke-dasharray":"3,3"},this.svgRoot_)))},T.blockRendering.Debug.prototype.drawRowWithElements=function(t,e,o){for(var i=0,s=t.elements.length;i<s;i++){var n=t.elements[i];n?T.blockRendering.Types.isSpacer(n)?this.drawSpacerElem(n,t.height,o):this.drawRenderedElem(n,o):console.warn("A row has an undefined or null element.",t,n)}this.drawRenderedRow(t,e,o)},T.blockRendering.Debug.prototype.drawBoundingBox=function(t){var e;T.blockRendering.Debug.config.blockBounds&&(e=t.RTL?-t.width:0,this.debugElements_.push(T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blockBoundingBox blockRenderDebug",x:e,y:0,width:t.width,height:t.height,stroke:"black",fill:"none","stroke-width":"1px","stroke-dasharray":"5,5"},this.svgRoot_)),T.blockRendering.Debug.config.connectedBlockBounds)&&(e=t.RTL?-t.widthWithChildren:0,this.debugElements_.push(T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blockRenderDebug",x:e,y:0,width:t.widthWithChildren,height:t.height,stroke:"#DF57BC",fill:"none","stroke-width":"1px","stroke-dasharray":"3,3"},this.svgRoot_)))},T.blockRendering.Debug.prototype.drawDebug=function(t,e){this.clearElems(),this.svgRoot_=t.getSvgRoot(),this.randomColour_="#"+Math.floor(16777215*Math.random()).toString(16);for(var o=0,i=0,s;s=e.rows[i];i++)T.blockRendering.Types.isBetweenRowSpacer(s)?this.drawSpacerRow(s,o,e.RTL):this.drawRowWithElements(s,o,e.RTL),o+=s.height;t.previousConnection&&this.drawConnection(t.previousConnection),t.nextConnection&&this.drawConnection(t.nextConnection),t.outputConnection&&this.drawConnection(t.outputConnection),e.rightSide&&this.drawRenderedElem(e.rightSide,e.RTL),this.drawBoundingBox(e),this.drawRender(t.pathObject.svgPath)},T.blockRendering.Debug.prototype.drawRender=function(t){T.blockRendering.Debug.config.render&&(t.setAttribute("filter","url(#"+this.constants_.debugFilterId+")"),setTimeout(function(){t.setAttribute("filter","")},100))},T.blockRendering.Drawer=function(t,e){this.block_=t,this.info_=e,this.topLeft_=t.getRelativeToSurfaceXY(),this.inlinePath_=this.outlinePath_="",this.constants_=e.getRenderer().getConstants()},T.blockRendering.Drawer.prototype.draw=function(){this.hideHiddenIcons_(),this.drawOutline_(),this.drawInternals_(),this.block_.pathObject.setPath(this.outlinePath_+"\n"+this.inlinePath_),this.info_.RTL&&this.block_.pathObject.flipRTL(),T.blockRendering.useDebugger&&this.block_.renderingDebugger.drawDebug(this.block_,this.info_),this.recordSizeOnBlock_()},T.blockRendering.Drawer.prototype.recordSizeOnBlock_=function(){this.block_.height=this.info_.height,this.block_.width=this.info_.widthWithChildren},T.blockRendering.Drawer.prototype.hideHiddenIcons_=function(){for(var t=0,e;e=this.info_.hiddenIcons[t];t++)e.icon.iconGroup_.setAttribute("display","none")},T.blockRendering.Drawer.prototype.drawOutline_=function(){this.drawTop_();for(var t=1;t<this.info_.rows.length-1;t++){var e=this.info_.rows[t];e.hasJaggedEdge?this.drawJaggedEdge_(e):e.hasStatement?this.drawStatementInput_(e):e.hasExternalInput?this.drawValueInput_(e):this.drawRightSideRow_(e)}this.drawBottom_(),this.drawLeft_()},T.blockRendering.Drawer.prototype.drawTop_=function(){var t=this.info_.topRow,e=t.elements;this.positionPreviousConnection_(),this.outlinePath_+=T.utils.svgPaths.moveBy(t.xPos,this.info_.startY);for(var o=0,i;i=e[o];o++)T.blockRendering.Types.isLeftRoundedCorner(i)?this.outlinePath_+=this.constants_.OUTSIDE_CORNERS.topLeft:T.blockRendering.Types.isRightRoundedCorner(i)?this.outlinePath_+=this.constants_.OUTSIDE_CORNERS.topRight:T.blockRendering.Types.isPreviousConnection(i)?this.outlinePath_+=i.shape.pathLeft:T.blockRendering.Types.isHat(i)?this.outlinePath_+=this.constants_.START_HAT.path:T.blockRendering.Types.isSpacer(i)&&(this.outlinePath_+=T.utils.svgPaths.lineOnAxis("h",i.width));this.outlinePath_+=T.utils.svgPaths.lineOnAxis("v",t.height)},T.blockRendering.Drawer.prototype.drawJaggedEdge_=function(t){this.outlinePath_+=this.constants_.JAGGED_TEETH.path+T.utils.svgPaths.lineOnAxis("v",t.height-this.constants_.JAGGED_TEETH.height)},T.blockRendering.Drawer.prototype.drawValueInput_=function(t){var e=t.getLastInput(),o=(this.positionExternalValueConnection_(t),"function"==typeof e.shape.pathDown?e.shape.pathDown(e.height):e.shape.pathDown);this.outlinePath_+=T.utils.svgPaths.lineOnAxis("H",e.xPos+e.width)+o+T.utils.svgPaths.lineOnAxis("v",t.height-e.connectionHeight)},T.blockRendering.Drawer.prototype.drawStatementInput_=function(t){var e,o=(e=t.getLastInput()).xPos+e.notchOffset+e.shape.width,e=e.shape.pathRight+T.utils.svgPaths.lineOnAxis("h",-(e.notchOffset-this.constants_.INSIDE_CORNERS.width))+this.constants_.INSIDE_CORNERS.pathTop,i=t.height-2*this.constants_.INSIDE_CORNERS.height;this.outlinePath_+=T.utils.svgPaths.lineOnAxis("H",o)+e+T.utils.svgPaths.lineOnAxis("v",i)+this.constants_.INSIDE_CORNERS.pathBottom+T.utils.svgPaths.lineOnAxis("H",t.xPos+t.width),this.positionStatementInputConnection_(t)},T.blockRendering.Drawer.prototype.drawRightSideRow_=function(t){this.outlinePath_+=T.utils.svgPaths.lineOnAxis("V",t.yPos+t.height)},T.blockRendering.Drawer.prototype.drawBottom_=function(){var t=this.info_.bottomRow,e=t.elements;this.positionNextConnection_();for(var o=0,i="",s=e.length-1,n;n=e[s];s--)T.blockRendering.Types.isNextConnection(n)?i+=n.shape.pathRight:T.blockRendering.Types.isLeftSquareCorner(n)?i+=T.utils.svgPaths.lineOnAxis("H",t.xPos):T.blockRendering.Types.isLeftRoundedCorner(n)?i+=this.constants_.OUTSIDE_CORNERS.bottomLeft:T.blockRendering.Types.isRightRoundedCorner(n)?(i+=this.constants_.OUTSIDE_CORNERS.bottomRight,o=this.constants_.OUTSIDE_CORNERS.rightHeight):T.blockRendering.Types.isSpacer(n)&&(i+=T.utils.svgPaths.lineOnAxis("h",-1*n.width));this.outlinePath_+=T.utils.svgPaths.lineOnAxis("V",t.baseline-o),this.outlinePath_+=i},T.blockRendering.Drawer.prototype.drawLeft_=function(){var t=this.info_.outputConnection,e,t;this.positionOutputConnection_(),t&&(e=t.connectionOffsetY+t.height,t="function"==typeof t.shape.pathUp?t.shape.pathUp(t.height):t.shape.pathUp,this.outlinePath_+=T.utils.svgPaths.lineOnAxis("V",e)+t),this.outlinePath_+="z"},T.blockRendering.Drawer.prototype.drawInternals_=function(){for(var t=0,e;e=this.info_.rows[t];t++)for(var o=0,i;i=e.elements[o];o++)T.blockRendering.Types.isInlineInput(i)?this.drawInlineInput_(i):(T.blockRendering.Types.isIcon(i)||T.blockRendering.Types.isField(i))&&this.layoutField_(i)},T.blockRendering.Drawer.prototype.layoutField_=function(t){var e,o=(T.blockRendering.Types.isField(t)?e=t.field.getSvgRoot():T.blockRendering.Types.isIcon(t)&&(e=t.icon.iconGroup_),t.centerline-t.height/2),i=t.xPos,s="";this.info_.RTL&&(i=-(i+t.width),t.flipRtl)&&(i+=t.width,s="scale(-1 1)"),T.blockRendering.Types.isIcon(t)?(e.setAttribute("display","block"),e.setAttribute("transform","translate("+i+","+o+")"),t.icon.computeIconLocation()):e.setAttribute("transform","translate("+i+","+o+")"+s),this.info_.isInsertionMarker&&e.setAttribute("display","none")},T.blockRendering.Drawer.prototype.drawInlineInput_=function(t){var e=t.width,o=t.height,i=t.connectionOffsetY,s=t.connectionHeight+i;this.inlinePath_+=T.utils.svgPaths.moveTo(t.xPos+t.connectionWidth,t.centerline-o/2)+T.utils.svgPaths.lineOnAxis("v",i)+t.shape.pathDown+T.utils.svgPaths.lineOnAxis("v",o-s)+T.utils.svgPaths.lineOnAxis("h",e-t.connectionWidth)+T.utils.svgPaths.lineOnAxis("v",-o)+"z",this.positionInlineInputConnection_(t)},T.blockRendering.Drawer.prototype.positionInlineInputConnection_=function(t){var e=t.centerline-t.height/2,o;t.connectionModel&&(o=t.xPos+t.connectionWidth+t.connectionOffsetX,this.info_.RTL&&(o*=-1),t.connectionModel.setOffsetInBlock(o,e+t.connectionOffsetY))},T.blockRendering.Drawer.prototype.positionStatementInputConnection_=function(t){var e=t.getLastInput(),o;e.connectionModel&&(o=t.xPos+t.statementEdge+e.notchOffset,this.info_.RTL&&(o*=-1),e.connectionModel.setOffsetInBlock(o,t.yPos))},T.blockRendering.Drawer.prototype.positionExternalValueConnection_=function(t){var e=t.getLastInput(),o;e.connectionModel&&(o=t.xPos+t.width,this.info_.RTL&&(o*=-1),e.connectionModel.setOffsetInBlock(o,t.yPos))},T.blockRendering.Drawer.prototype.positionPreviousConnection_=function(){var t=this.info_.topRow,e;t.connection&&(e=t.xPos+t.notchOffset,t.connection.connectionModel.setOffsetInBlock(this.info_.RTL?-e:e,0))},T.blockRendering.Drawer.prototype.positionNextConnection_=function(){var t=this.info_.bottomRow,e,o;t.connection&&(o=(e=t.connection).xPos,e.connectionModel.setOffsetInBlock(this.info_.RTL?-o:o,t.baseline))},T.blockRendering.Drawer.prototype.positionOutputConnection_=function(){var t;this.info_.outputConnection&&(t=this.info_.startX+this.info_.outputConnection.connectionOffsetX,this.block_.outputConnection.setOffsetInBlock(this.info_.RTL?-t:t,this.info_.outputConnection.connectionOffsetY))},T.Events.MarkerMove=function(t,e,o,i){var s=t?t.workspace.id:void 0;i&&i.getType()==T.ASTNode.types.WORKSPACE&&(s=i.getLocation().id),T.Events.MarkerMove.superClass_.constructor.call(this,s),this.blockId=t?t.id:null,this.oldNode=o,this.newNode=i,this.isCursor=e},T.utils.object.inherits(T.Events.MarkerMove,T.Events.UiBase),T.Events.MarkerMove.prototype.type=T.Events.MARKER_MOVE,T.Events.MarkerMove.prototype.toJson=function(){var t=T.Events.MarkerMove.superClass_.toJson.call(this);return t.isCursor=this.isCursor,t.blockId=this.blockId,t.oldNode=this.oldNode,t.newNode=this.newNode,t},T.Events.MarkerMove.prototype.fromJson=function(t){T.Events.MarkerMove.superClass_.fromJson.call(this,t),this.isCursor=t.isCursor,this.blockId=t.blockId,this.oldNode=t.oldNode,this.newNode=t.newNode},T.registry.register(T.registry.Type.EVENT,T.Events.MARKER_MOVE,T.Events.MarkerMove),T.blockRendering.MarkerSvg=function(t,e,o){this.workspace_=t,this.marker_=o,this.parent_=null,this.constants_=e,this.currentMarkerSvg=null,t=this.isCursor()?this.constants_.CURSOR_COLOUR:this.constants_.MARKER_COLOUR,this.colour_=o.colour||t},T.blockRendering.MarkerSvg.CURSOR_CLASS="blocklyCursor",T.blockRendering.MarkerSvg.MARKER_CLASS="blocklyMarker",T.blockRendering.MarkerSvg.HEIGHT_MULTIPLIER=.75,T.blockRendering.MarkerSvg.prototype.getSvgRoot=function(){return this.svgGroup_},T.blockRendering.MarkerSvg.prototype.getMarker=function(){return this.marker_},T.blockRendering.MarkerSvg.prototype.isCursor=function(){return"cursor"==this.marker_.type},T.blockRendering.MarkerSvg.prototype.createDom=function(){var t=this.isCursor()?T.blockRendering.MarkerSvg.CURSOR_CLASS:T.blockRendering.MarkerSvg.MARKER_CLASS;return this.svgGroup_=T.utils.dom.createSvgElement(T.utils.Svg.G,{class:t},null),this.createDomInternal_(),this.svgGroup_},T.blockRendering.MarkerSvg.prototype.setParent_=function(t){this.isCursor()?(this.parent_&&this.parent_.setCursorSvg(null),t.setCursorSvg(this.getSvgRoot())):(this.parent_&&this.parent_.setMarkerSvg(null),t.setMarkerSvg(this.getSvgRoot())),this.parent_=t},T.blockRendering.MarkerSvg.prototype.draw=function(t,e){var o;e?(this.constants_=this.workspace_.getRenderer().getConstants(),o=this.isCursor()?this.constants_.CURSOR_COLOUR:this.constants_.MARKER_COLOUR,this.colour_=this.marker_.colour||o,this.applyColour_(e),this.showAtLocation_(e),this.fireMarkerEvent_(t,e),void 0!==(t=this.currentMarkerSvg.childNodes[0])&&t.beginElement&&t.beginElement()):this.hide()},T.blockRendering.MarkerSvg.prototype.showAtLocation_=function(t){var e=t.getLocation().type;t.getType()==T.ASTNode.types.BLOCK?this.showWithBlock_(t):t.getType()==T.ASTNode.types.OUTPUT?this.showWithOutput_(t):e==T.connectionTypes.INPUT_VALUE?this.showWithInput_(t):e==T.connectionTypes.NEXT_STATEMENT?this.showWithNext_(t):t.getType()==T.ASTNode.types.PREVIOUS?this.showWithPrevious_(t):t.getType()==T.ASTNode.types.FIELD?this.showWithField_(t):t.getType()==T.ASTNode.types.WORKSPACE?this.showWithCoordinates_(t):t.getType()==T.ASTNode.types.STACK&&this.showWithStack_(t)},T.blockRendering.MarkerSvg.prototype.showWithBlockPrevOutput_=function(t){var e=(t=t.getSourceBlock()).width,o=t.height,i=o*T.blockRendering.MarkerSvg.HEIGHT_MULTIPLIER,s=this.constants_.CURSOR_BLOCK_PADDING,n;t.previousConnection?(n=this.constants_.shapeFor(t.previousConnection),this.positionPrevious_(e,s,i,n)):t.outputConnection?(n=this.constants_.shapeFor(t.outputConnection),this.positionOutput_(e,o,n)):this.positionBlock_(e,s,i),this.setParent_(t),this.showCurrent_()},T.blockRendering.MarkerSvg.prototype.showWithBlock_=function(t){this.showWithBlockPrevOutput_(t)},T.blockRendering.MarkerSvg.prototype.showWithPrevious_=function(t){this.showWithBlockPrevOutput_(t)},T.blockRendering.MarkerSvg.prototype.showWithOutput_=function(t){this.showWithBlockPrevOutput_(t)},T.blockRendering.MarkerSvg.prototype.showWithCoordinates_=function(t){var e=t.getWsCoordinate();t=e.x,e=e.y,this.workspace_.RTL&&(t-=this.constants_.CURSOR_WS_WIDTH),this.positionLine_(t,e,this.constants_.CURSOR_WS_WIDTH),this.setParent_(this.workspace_),this.showCurrent_()},T.blockRendering.MarkerSvg.prototype.showWithField_=function(t){var e=(t=t.getLocation()).getSize().width,o=t.getSize().height;this.positionRect_(0,0,e,o),this.setParent_(t),this.showCurrent_()},T.blockRendering.MarkerSvg.prototype.showWithInput_=function(t){var e=(t=t.getLocation()).getSourceBlock();this.positionInput_(t),this.setParent_(e),this.showCurrent_()},T.blockRendering.MarkerSvg.prototype.showWithNext_=function(t){var e,o=(t=(e=t.getLocation()).getSourceBlock(),0),e=e.getOffsetInBlock().y,i=t.getHeightWidth().width;this.workspace_.RTL&&(o=-i),this.positionLine_(o,e,i),this.setParent_(t),this.showCurrent_()},T.blockRendering.MarkerSvg.prototype.showWithStack_=function(t){var e,o=(e=(t=t.getLocation()).getHeightWidth()).width+this.constants_.CURSOR_STACK_PADDING,e=e.height+this.constants_.CURSOR_STACK_PADDING,i=-this.constants_.CURSOR_STACK_PADDING/2,s=-this.constants_.CURSOR_STACK_PADDING/2,n=i;this.workspace_.RTL&&(n=-(o+i)),this.positionRect_(n,s,o,e),this.setParent_(t),this.showCurrent_()},T.blockRendering.MarkerSvg.prototype.showCurrent_=function(){this.hide(),this.currentMarkerSvg.style.display=""},T.blockRendering.MarkerSvg.prototype.positionBlock_=function(t,e,o){t=T.utils.svgPaths.moveBy(-e,o)+T.utils.svgPaths.lineOnAxis("V",-e)+T.utils.svgPaths.lineOnAxis("H",t+2*e)+T.utils.svgPaths.lineOnAxis("V",o),this.markerBlock_.setAttribute("d",t),this.workspace_.RTL&&this.flipRtl_(this.markerBlock_),this.currentMarkerSvg=this.markerBlock_},T.blockRendering.MarkerSvg.prototype.positionInput_=function(t){var e=t.getOffsetInBlock().x,o=t.getOffsetInBlock().y;t=T.utils.svgPaths.moveTo(0,0)+this.constants_.shapeFor(t).pathDown,this.markerInput_.setAttribute("d",t),this.markerInput_.setAttribute("transform","translate("+e+","+o+")"+(this.workspace_.RTL?" scale(-1 1)":"")),this.currentMarkerSvg=this.markerInput_},T.blockRendering.MarkerSvg.prototype.positionLine_=function(t,e,o){this.markerSvgLine_.setAttribute("x",t),this.markerSvgLine_.setAttribute("y",e),this.markerSvgLine_.setAttribute("width",o),this.currentMarkerSvg=this.markerSvgLine_},T.blockRendering.MarkerSvg.prototype.positionOutput_=function(t,e,o){t=T.utils.svgPaths.moveBy(t,0)+T.utils.svgPaths.lineOnAxis("h",-(t-o.width))+T.utils.svgPaths.lineOnAxis("v",this.constants_.TAB_OFFSET_FROM_TOP)+o.pathDown+T.utils.svgPaths.lineOnAxis("V",e)+T.utils.svgPaths.lineOnAxis("H",t),this.markerBlock_.setAttribute("d",t),this.workspace_.RTL&&this.flipRtl_(this.markerBlock_),this.currentMarkerSvg=this.markerBlock_},T.blockRendering.MarkerSvg.prototype.positionPrevious_=function(t,e,o,i){t=T.utils.svgPaths.moveBy(-e,o)+T.utils.svgPaths.lineOnAxis("V",-e)+T.utils.svgPaths.lineOnAxis("H",this.constants_.NOTCH_OFFSET_LEFT)+i.pathLeft+T.utils.svgPaths.lineOnAxis("H",t+2*e)+T.utils.svgPaths.lineOnAxis("V",o),this.markerBlock_.setAttribute("d",t),this.workspace_.RTL&&this.flipRtl_(this.markerBlock_),this.currentMarkerSvg=this.markerBlock_},T.blockRendering.MarkerSvg.prototype.positionRect_=function(t,e,o,i){this.markerSvgRect_.setAttribute("x",t),this.markerSvgRect_.setAttribute("y",e),this.markerSvgRect_.setAttribute("width",o),this.markerSvgRect_.setAttribute("height",i),this.currentMarkerSvg=this.markerSvgRect_},T.blockRendering.MarkerSvg.prototype.flipRtl_=function(t){t.setAttribute("transform","scale(-1 1)")},T.blockRendering.MarkerSvg.prototype.hide=function(){this.markerSvgLine_.style.display="none",this.markerSvgRect_.style.display="none",this.markerInput_.style.display="none",this.markerBlock_.style.display="none"},T.blockRendering.MarkerSvg.prototype.fireMarkerEvent_=function(t,e){var o=e.getSourceBlock();t=new(T.Events.get(T.Events.MARKER_MOVE))(o,this.isCursor(),t,e),T.Events.fire(t)},T.blockRendering.MarkerSvg.prototype.getBlinkProperties_=function(){return{attributeType:"XML",attributeName:"fill",dur:"1s",values:this.colour_+";transparent;transparent;",repeatCount:"indefinite"}},T.blockRendering.MarkerSvg.prototype.createDomInternal_=function(){var t;return this.markerSvg_=T.utils.dom.createSvgElement(T.utils.Svg.G,{width:this.constants_.CURSOR_WS_WIDTH,height:this.constants_.WS_CURSOR_HEIGHT},this.svgGroup_),this.markerSvgLine_=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{width:this.constants_.CURSOR_WS_WIDTH,height:this.constants_.WS_CURSOR_HEIGHT,style:"display: none"},this.markerSvg_),this.markerSvgRect_=T.utils.dom.createSvgElement(T.utils.Svg.RECT,{class:"blocklyVerticalMarker",rx:10,ry:10,style:"display: none"},this.markerSvg_),this.markerInput_=T.utils.dom.createSvgElement(T.utils.Svg.PATH,{transform:"",style:"display: none"},this.markerSvg_),this.markerBlock_=T.utils.dom.createSvgElement(T.utils.Svg.PATH,{transform:"",style:"display: none",fill:"none","stroke-width":this.constants_.CURSOR_STROKE_WIDTH},this.markerSvg_),this.isCursor()&&(t=this.getBlinkProperties_(),T.utils.dom.createSvgElement(T.utils.Svg.ANIMATE,t,this.markerSvgLine_),T.utils.dom.createSvgElement(T.utils.Svg.ANIMATE,t,this.markerInput_),t.attributeName="stroke",T.utils.dom.createSvgElement(T.utils.Svg.ANIMATE,t,this.markerBlock_)),this.markerSvg_},T.blockRendering.MarkerSvg.prototype.applyColour_=function(t){this.markerSvgLine_.setAttribute("fill",this.colour_),this.markerSvgRect_.setAttribute("stroke",this.colour_),this.markerInput_.setAttribute("fill",this.colour_),this.markerBlock_.setAttribute("stroke",this.colour_),this.isCursor()&&(t=this.colour_+";transparent;transparent;",this.markerSvgLine_.firstChild.setAttribute("values",t),this.markerInput_.firstChild.setAttribute("values",t),this.markerBlock_.firstChild.setAttribute("values",t))},T.blockRendering.MarkerSvg.prototype.dispose=function(){this.svgGroup_&&T.utils.dom.removeNode(this.svgGroup_)},T.blockRendering.PathObject=function(t,e,o){this.constants=o,this.svgRoot=t,this.svgPath=T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyPath"},this.svgRoot),this.style=e,this.markerSvg=this.cursorSvg=null},T.blockRendering.PathObject.prototype.setPath=function(t){this.svgPath.setAttribute("d",t)},T.blockRendering.PathObject.prototype.flipRTL=function(){this.svgPath.setAttribute("transform","scale(-1 1)")},T.blockRendering.PathObject.prototype.setCursorSvg=function(t){t?(this.svgRoot.appendChild(t),this.cursorSvg=t):this.cursorSvg=null},T.blockRendering.PathObject.prototype.setMarkerSvg=function(t){t?(this.cursorSvg?this.svgRoot.insertBefore(t,this.cursorSvg):this.svgRoot.appendChild(t),this.markerSvg=t):this.markerSvg=null},T.blockRendering.PathObject.prototype.applyColour=function(t){this.svgPath.setAttribute("stroke",this.style.colourTertiary),this.svgPath.setAttribute("fill",this.style.colourPrimary),this.updateShadow_(t.isShadow()),this.updateDisabled_(!t.isEnabled()||t.getInheritedDisabled())},T.blockRendering.PathObject.prototype.setStyle=function(t){this.style=t},T.blockRendering.PathObject.prototype.setClass_=function(t,e){e?T.utils.dom.addClass(this.svgRoot,t):T.utils.dom.removeClass(this.svgRoot,t)},T.blockRendering.PathObject.prototype.updateHighlighted=function(t){t?this.svgPath.setAttribute("filter","url(#"+this.constants.embossFilterId+")"):this.svgPath.setAttribute("filter","none")},T.blockRendering.PathObject.prototype.updateShadow_=function(t){t&&(this.svgPath.setAttribute("stroke","none"),this.svgPath.setAttribute("fill",this.style.colourSecondary))},T.blockRendering.PathObject.prototype.updateDisabled_=function(t){this.setClass_("blocklyDisabled",t),t&&this.svgPath.setAttribute("fill","url(#"+this.constants.disabledPatternId+")")},T.blockRendering.PathObject.prototype.updateSelected=function(t){this.setClass_("blocklySelected",t)},T.blockRendering.PathObject.prototype.updateDraggingDelete=function(t){this.setClass_("blocklyDraggingDelete",t)},T.blockRendering.PathObject.prototype.updateInsertionMarker=function(t){this.setClass_("blocklyInsertionMarker",t)},T.blockRendering.PathObject.prototype.updateMovable=function(t){this.setClass_("blocklyDraggable",t)},T.blockRendering.PathObject.prototype.updateReplacementFade=function(t){this.setClass_("blocklyReplaceable",t)},T.blockRendering.PathObject.prototype.updateShapeForInputHighlight=function(t,e){},T.IRegistrable=function(){},T.blockRendering.Renderer=function(t){this.name=t,this.overrides=this.constants_=null},T.blockRendering.Renderer.prototype.getClassName=function(){return this.name+"-renderer"},T.blockRendering.Renderer.prototype.init=function(t,e){this.constants_=this.makeConstants_(),e&&(this.overrides=e,T.utils.object.mixin(this.constants_,e)),this.constants_.setTheme(t),this.constants_.init()},T.blockRendering.Renderer.prototype.createDom=function(t,e){this.constants_.createDom(t,this.name+"-"+e.name,"."+this.getClassName()+"."+e.getClassName())},T.blockRendering.Renderer.prototype.refreshDom=function(t,e){var o=this.getConstants();o.dispose(),this.constants_=this.makeConstants_(),this.overrides&&T.utils.object.mixin(this.constants_,this.overrides),this.constants_.randomIdentifier=o.randomIdentifier,this.constants_.setTheme(e),this.constants_.init(),this.createDom(t,e)},T.blockRendering.Renderer.prototype.dispose=function(){this.constants_&&this.constants_.dispose()},T.blockRendering.Renderer.prototype.makeConstants_=function(){return new T.blockRendering.ConstantProvider},T.blockRendering.Renderer.prototype.makeRenderInfo_=function(t){return new T.blockRendering.RenderInfo(this,t)},T.blockRendering.Renderer.prototype.makeDrawer_=function(t,e){return new T.blockRendering.Drawer(t,e)},T.blockRendering.Renderer.prototype.makeDebugger_=function(){if(!T.blockRendering.Debug)throw Error("Missing require for Blockly.blockRendering.Debug");return new T.blockRendering.Debug(this.getConstants())},T.blockRendering.Renderer.prototype.makeMarkerDrawer=function(t,e){return new T.blockRendering.MarkerSvg(t,this.getConstants(),e)},T.blockRendering.Renderer.prototype.makePathObject=function(t,e){return new T.blockRendering.PathObject(t,e,this.constants_)},T.blockRendering.Renderer.prototype.getConstants=function(){return this.constants_},T.blockRendering.Renderer.prototype.shouldHighlightConnection=function(t){return!0},T.blockRendering.Renderer.prototype.orphanCanConnectAtEnd=function(t,e,o){return!!(t=o==T.connectionTypes.OUTPUT_VALUE?(o=e.outputConnection,T.Connection.lastConnectionInRow(t,e)):(o=e.previousConnection,t.lastConnectionInStack()))&&o.getConnectionChecker().canConnect(t,o,!1)},T.blockRendering.Renderer.prototype.getConnectionPreviewMethod=function(t,e,o){return e.type!=T.connectionTypes.OUTPUT_VALUE&&e.type!=T.connectionTypes.PREVIOUS_STATEMENT||!t.isConnected()||this.orphanCanConnectAtEnd(o,t.targetBlock(),e.type)?T.InsertionMarkerManager.PREVIEW_TYPE.INSERTION_MARKER:T.InsertionMarkerManager.PREVIEW_TYPE.REPLACEMENT_FADE},T.blockRendering.Renderer.prototype.render=function(t){T.blockRendering.useDebugger&&!t.renderingDebugger&&(t.renderingDebugger=this.makeDebugger_());var e=this.makeRenderInfo_(t);e.measure(),this.makeDrawer_(t,e).draw()},T.geras={},T.geras.ConstantProvider=function(){T.geras.ConstantProvider.superClass_.constructor.call(this),this.FIELD_TEXT_BASELINE_CENTER=!1,this.DARK_PATH_OFFSET=1,this.MAX_BOTTOM_WIDTH=30,this.STATEMENT_BOTTOM_SPACER=-this.NOTCH_HEIGHT/2},T.utils.object.inherits(T.geras.ConstantProvider,T.blockRendering.ConstantProvider),T.geras.ConstantProvider.prototype.getCSS_=function(t){return T.geras.ConstantProvider.superClass_.getCSS_.call(this,t).concat([t+" .blocklyInsertionMarker>.blocklyPathLight,",t+" .blocklyInsertionMarker>.blocklyPathDark {","fill-opacity: "+this.INSERTION_MARKER_OPACITY+";","stroke: none;","}"])},T.geras.Highlighter=function(t){this.info_=t,this.inlineSteps_=this.steps_="",this.RTL_=this.info_.RTL,t=t.getRenderer(),this.constants_=t.getConstants(),this.highlightConstants_=t.getHighlightConstants(),this.highlightOffset_=this.highlightConstants_.OFFSET,this.outsideCornerPaths_=this.highlightConstants_.OUTSIDE_CORNER,this.insideCornerPaths_=this.highlightConstants_.INSIDE_CORNER,this.puzzleTabPaths_=this.highlightConstants_.PUZZLE_TAB,this.notchPaths_=this.highlightConstants_.NOTCH,this.startPaths_=this.highlightConstants_.START_HAT,this.jaggedTeethPaths_=this.highlightConstants_.JAGGED_TEETH},T.geras.Highlighter.prototype.getPath=function(){return this.steps_+"\n"+this.inlineSteps_},T.geras.Highlighter.prototype.drawTopCorner=function(t){this.steps_+=T.utils.svgPaths.moveBy(t.xPos,this.info_.startY);for(var e=0,o;o=t.elements[e];e++)T.blockRendering.Types.isLeftSquareCorner(o)?this.steps_+=this.highlightConstants_.START_POINT:T.blockRendering.Types.isLeftRoundedCorner(o)?this.steps_+=this.outsideCornerPaths_.topLeft(this.RTL_):T.blockRendering.Types.isPreviousConnection(o)?this.steps_+=this.notchPaths_.pathLeft:T.blockRendering.Types.isHat(o)?this.steps_+=this.startPaths_.path(this.RTL_):T.blockRendering.Types.isSpacer(o)&&0!=o.width&&(this.steps_+=T.utils.svgPaths.lineOnAxis("H",o.xPos+o.width-this.highlightOffset_));this.steps_+=T.utils.svgPaths.lineOnAxis("H",t.xPos+t.width-this.highlightOffset_)},T.geras.Highlighter.prototype.drawJaggedEdge_=function(t){this.info_.RTL&&(this.steps_+=this.jaggedTeethPaths_.pathLeft+T.utils.svgPaths.lineOnAxis("v",t.height-this.jaggedTeethPaths_.height-this.highlightOffset_))},T.geras.Highlighter.prototype.drawValueInput=function(t){var e=t.getLastInput(),o;this.RTL_?(o=t.height-e.connectionHeight,this.steps_+=T.utils.svgPaths.moveTo(e.xPos+e.width-this.highlightOffset_,t.yPos)+this.puzzleTabPaths_.pathDown(this.RTL_)+T.utils.svgPaths.lineOnAxis("v",o)):this.steps_+=T.utils.svgPaths.moveTo(e.xPos+e.width,t.yPos)+this.puzzleTabPaths_.pathDown(this.RTL_)},T.geras.Highlighter.prototype.drawStatementInput=function(t){var e=t.getLastInput(),o;this.RTL_?(o=t.height-2*this.insideCornerPaths_.height,this.steps_+=T.utils.svgPaths.moveTo(e.xPos,t.yPos)+this.insideCornerPaths_.pathTop(this.RTL_)+T.utils.svgPaths.lineOnAxis("v",o)+this.insideCornerPaths_.pathBottom(this.RTL_)+T.utils.svgPaths.lineTo(t.width-e.xPos-this.insideCornerPaths_.width,0)):this.steps_+=T.utils.svgPaths.moveTo(e.xPos,t.yPos+t.height)+this.insideCornerPaths_.pathBottom(this.RTL_)+T.utils.svgPaths.lineTo(t.width-e.xPos-this.insideCornerPaths_.width,0)},T.geras.Highlighter.prototype.drawRightSideRow=function(t){var e=t.xPos+t.width-this.highlightOffset_;t.followsStatement&&(this.steps_+=T.utils.svgPaths.lineOnAxis("H",e)),this.RTL_&&(this.steps_+=T.utils.svgPaths.lineOnAxis("H",e),t.height>this.highlightOffset_)&&(this.steps_+=T.utils.svgPaths.lineOnAxis("V",t.yPos+t.height-this.highlightOffset_))},T.geras.Highlighter.prototype.drawBottomRow=function(t){var e;this.RTL_?this.steps_+=T.utils.svgPaths.lineOnAxis("V",t.baseline-this.highlightOffset_):(e=this.info_.bottomRow.elements[0],T.blockRendering.Types.isLeftSquareCorner(e)?this.steps_+=T.utils.svgPaths.moveTo(t.xPos+this.highlightOffset_,t.baseline-this.highlightOffset_):T.blockRendering.Types.isLeftRoundedCorner(e)&&(this.steps_+=T.utils.svgPaths.moveTo(t.xPos,t.baseline),this.steps_+=this.outsideCornerPaths_.bottomLeft()))},T.geras.Highlighter.prototype.drawLeft=function(){var t=this.info_.outputConnection;t&&(t=t.connectionOffsetY+t.height,this.RTL_?this.steps_+=T.utils.svgPaths.moveTo(this.info_.startX,t):(this.steps_+=T.utils.svgPaths.moveTo(this.info_.startX+this.highlightOffset_,this.info_.bottomRow.baseline-this.highlightOffset_),this.steps_+=T.utils.svgPaths.lineOnAxis("V",t)),this.steps_+=this.puzzleTabPaths_.pathUp(this.RTL_)),this.RTL_||(t=this.info_.topRow,T.blockRendering.Types.isLeftRoundedCorner(t.elements[0])?this.steps_+=T.utils.svgPaths.lineOnAxis("V",this.outsideCornerPaths_.height):this.steps_+=T.utils.svgPaths.lineOnAxis("V",t.capline+this.highlightOffset_))},T.geras.Highlighter.prototype.drawInlineInput=function(t){var e=this.highlightOffset_,o=t.xPos+t.connectionWidth,i=t.centerline-t.height/2,s=t.width-t.connectionWidth,n=i+e;this.RTL_?(i=t.connectionOffsetY-e,t=t.height-(t.connectionOffsetY+t.connectionHeight)+e,this.inlineSteps_+=T.utils.svgPaths.moveTo(o-e,n)+T.utils.svgPaths.lineOnAxis("v",i)+this.puzzleTabPaths_.pathDown(this.RTL_)+T.utils.svgPaths.lineOnAxis("v",t)+T.utils.svgPaths.lineOnAxis("h",s)):this.inlineSteps_+=T.utils.svgPaths.moveTo(t.xPos+t.width+e,n)+T.utils.svgPaths.lineOnAxis("v",t.height)+T.utils.svgPaths.lineOnAxis("h",-s)+T.utils.svgPaths.moveTo(o,i+t.connectionOffsetY)+this.puzzleTabPaths_.pathDown(this.RTL_)},T.geras.InlineInput=function(t,e){T.geras.InlineInput.superClass_.constructor.call(this,t,e),this.connectedBlock&&(this.width+=this.constants_.DARK_PATH_OFFSET,this.height+=this.constants_.DARK_PATH_OFFSET)},T.utils.object.inherits(T.geras.InlineInput,T.blockRendering.InlineInput),T.geras.StatementInput=function(t,e){T.geras.StatementInput.superClass_.constructor.call(this,t,e),this.connectedBlock&&(this.height+=this.constants_.DARK_PATH_OFFSET)},T.utils.object.inherits(T.geras.StatementInput,T.blockRendering.StatementInput),T.geras.RenderInfo=function(t,e){T.geras.RenderInfo.superClass_.constructor.call(this,t,e)},T.utils.object.inherits(T.geras.RenderInfo,T.blockRendering.RenderInfo),T.geras.RenderInfo.prototype.getRenderer=function(){return this.renderer_},T.geras.RenderInfo.prototype.populateBottomRow_=function(){T.geras.RenderInfo.superClass_.populateBottomRow_.call(this),this.block_.inputList.length&&this.block_.inputList[this.block_.inputList.length-1].type==T.inputTypes.STATEMENT||(this.bottomRow.minHeight=this.constants_.MEDIUM_PADDING-this.constants_.DARK_PATH_OFFSET)},T.geras.RenderInfo.prototype.addInput_=function(t,e){this.isInline&&t.type==T.inputTypes.VALUE?(e.elements.push(new T.geras.InlineInput(this.constants_,t)),e.hasInlineInput=!0):t.type==T.inputTypes.STATEMENT?(e.elements.push(new T.geras.StatementInput(this.constants_,t)),e.hasStatement=!0):t.type==T.inputTypes.VALUE?(e.elements.push(new T.blockRendering.ExternalValueInput(this.constants_,t)),e.hasExternalInput=!0):t.type==T.inputTypes.DUMMY&&(e.minHeight=Math.max(e.minHeight,this.constants_.DUMMY_INPUT_MIN_HEIGHT),e.hasDummyInput=!0),this.isInline||null!=e.align||(e.align=t.align)},T.geras.RenderInfo.prototype.addElemSpacing_=function(){for(var t=!1,e=0,o;o=this.rows[e];e++)o.hasExternalInput&&(t=!0);for(e=0;o=this.rows[e];e++){var i=o.elements;if(o.elements=[],o.startsWithElemSpacer()&&o.elements.push(new T.blockRendering.InRowSpacer(this.constants_,this.getInRowSpacing_(null,i[0]))),i.length){for(var s=0;s<i.length-1;s++){o.elements.push(i[s]);var n=this.getInRowSpacing_(i[s],i[s+1]);o.elements.push(new T.blockRendering.InRowSpacer(this.constants_,n))}o.elements.push(i[i.length-1]),o.endsWithElemSpacer()&&(n=this.getInRowSpacing_(i[i.length-1],null),t&&o.hasDummyInput&&(n+=this.constants_.TAB_WIDTH),o.elements.push(new T.blockRendering.InRowSpacer(this.constants_,n)))}}},T.geras.RenderInfo.prototype.getInRowSpacing_=function(t,e){if(!t)return e&&T.blockRendering.Types.isField(e)&&e.isEditable?this.constants_.MEDIUM_PADDING:e&&T.blockRendering.Types.isInlineInput(e)?this.constants_.MEDIUM_LARGE_PADDING:e&&T.blockRendering.Types.isStatementInput(e)?this.constants_.STATEMENT_INPUT_PADDING_LEFT:this.constants_.LARGE_PADDING;if(!T.blockRendering.Types.isInput(t)&&(!e||T.blockRendering.Types.isStatementInput(e)))return T.blockRendering.Types.isField(t)&&t.isEditable?this.constants_.MEDIUM_PADDING:T.blockRendering.Types.isIcon(t)?2*this.constants_.LARGE_PADDING+1:T.blockRendering.Types.isHat(t)?this.constants_.NO_PADDING:T.blockRendering.Types.isPreviousOrNextConnection(t)?this.constants_.LARGE_PADDING:T.blockRendering.Types.isLeftRoundedCorner(t)?this.constants_.MIN_BLOCK_WIDTH:T.blockRendering.Types.isJaggedEdge(t)?this.constants_.NO_PADDING:this.constants_.LARGE_PADDING;if(T.blockRendering.Types.isInput(t)&&!e){if(T.blockRendering.Types.isExternalInput(t))return this.constants_.NO_PADDING;if(T.blockRendering.Types.isInlineInput(t))return this.constants_.LARGE_PADDING;if(T.blockRendering.Types.isStatementInput(t))return this.constants_.NO_PADDING}if(!T.blockRendering.Types.isInput(t)&&e&&T.blockRendering.Types.isInput(e)){if(T.blockRendering.Types.isField(t)&&t.isEditable){if(T.blockRendering.Types.isInlineInput(e)||T.blockRendering.Types.isExternalInput(e))return this.constants_.SMALL_PADDING}else{if(T.blockRendering.Types.isInlineInput(e)||T.blockRendering.Types.isExternalInput(e))return this.constants_.MEDIUM_LARGE_PADDING;if(T.blockRendering.Types.isStatementInput(e))return this.constants_.LARGE_PADDING}return this.constants_.LARGE_PADDING-1}if(T.blockRendering.Types.isIcon(t)&&e&&!T.blockRendering.Types.isInput(e))return this.constants_.LARGE_PADDING;if(T.blockRendering.Types.isInlineInput(t)&&e&&T.blockRendering.Types.isField(e))return e.isEditable?this.constants_.MEDIUM_PADDING:this.constants_.LARGE_PADDING;if(T.blockRendering.Types.isLeftSquareCorner(t)&&e){if(T.blockRendering.Types.isHat(e))return this.constants_.NO_PADDING;if(T.blockRendering.Types.isPreviousConnection(e))return e.notchOffset;if(T.blockRendering.Types.isNextConnection(e))return t=(this.RTL?1:-1)*this.constants_.DARK_PATH_OFFSET/2,e.notchOffset+t}if(T.blockRendering.Types.isLeftRoundedCorner(t)&&e){if(T.blockRendering.Types.isPreviousConnection(e))return e.notchOffset-this.constants_.CORNER_RADIUS;if(T.blockRendering.Types.isNextConnection(e))return t=(this.RTL?1:-1)*this.constants_.DARK_PATH_OFFSET/2,e.notchOffset-this.constants_.CORNER_RADIUS+t}return T.blockRendering.Types.isField(t)&&e&&T.blockRendering.Types.isField(e)&&t.isEditable==e.isEditable||e&&T.blockRendering.Types.isJaggedEdge(e)?this.constants_.LARGE_PADDING:this.constants_.MEDIUM_PADDING},T.geras.RenderInfo.prototype.getSpacerRowHeight_=function(t,e){return T.blockRendering.Types.isTopRow(t)&&T.blockRendering.Types.isBottomRow(e)?this.constants_.EMPTY_BLOCK_SPACER_HEIGHT:T.blockRendering.Types.isTopRow(t)||T.blockRendering.Types.isBottomRow(e)?this.constants_.NO_PADDING:t.hasExternalInput&&e.hasExternalInput?this.constants_.LARGE_PADDING:!t.hasStatement&&e.hasStatement?this.constants_.BETWEEN_STATEMENT_PADDING_Y:t.hasStatement&&e.hasStatement||!t.hasStatement&&e.hasDummyInput||t.hasDummyInput?this.constants_.LARGE_PADDING:this.constants_.MEDIUM_PADDING},T.geras.RenderInfo.prototype.getElemCenterline_=function(t,e){if(T.blockRendering.Types.isSpacer(e))return t.yPos+e.height/2;if(T.blockRendering.Types.isBottomRow(t))return t=t.yPos+t.height-t.descenderHeight,T.blockRendering.Types.isNextConnection(e)?t+e.height/2:t-e.height/2;if(T.blockRendering.Types.isTopRow(t))return T.blockRendering.Types.isHat(e)?t.capline-e.height/2:t.capline+e.height/2;var o=t.yPos;return T.blockRendering.Types.isField(e)||T.blockRendering.Types.isIcon(e)?(o+=e.height/2,(t.hasInlineInput||t.hasStatement)&&e.height+this.constants_.TALL_INPUT_FIELD_OFFSET_Y<=t.height&&(o+=this.constants_.TALL_INPUT_FIELD_OFFSET_Y)):o=T.blockRendering.Types.isInlineInput(e)?o+e.height/2:o+t.height/2,o},T.geras.RenderInfo.prototype.alignRowElements_=function(){if(this.isInline){for(var t=0,e=null,o=this.rows.length-1,i;i=this.rows[o];o--)i.nextRightEdge=t,T.blockRendering.Types.isInputRow(i)&&(i.hasStatement&&this.alignStatementRow_(i),e&&e.hasStatement&&i.width<e.width?i.nextRightEdge=e.width:t=i.width,e=i);for(o=t=0;i=this.rows[o];o++)i.hasStatement?t=this.getDesiredRowWidth_(i):T.blockRendering.Types.isSpacer(i)?i.width=Math.max(t,i.nextRightEdge):(0<(t=Math.max(t,i.nextRightEdge)-i.width)&&this.addAlignmentPadding_(i,t),t=i.width)}else T.geras.RenderInfo.superClass_.alignRowElements_.call(this)},T.geras.RenderInfo.prototype.getDesiredRowWidth_=function(t){return this.isInline&&t.hasStatement?this.statementEdge+this.constants_.MAX_BOTTOM_WIDTH+this.startX:T.geras.RenderInfo.superClass_.getDesiredRowWidth_.call(this,t)},T.geras.RenderInfo.prototype.finalize_=function(){for(var t=0,e=0,o=0,i;i=this.rows[o];o++){i.yPos=e,i.xPos=this.startX,e+=i.height;var t=Math.max(t,i.widthWithConnectedBlocks),s=e-this.topRow.ascenderHeight;i==this.bottomRow&&s<this.constants_.MIN_BLOCK_HEIGHT&&(s=this.constants_.MIN_BLOCK_HEIGHT-s,this.bottomRow.height+=s,e+=s),this.recordElemPositions_(i)}this.outputConnection&&this.block_.nextConnection&&this.block_.nextConnection.isConnected()&&(t=Math.max(t,this.block_.nextConnection.targetBlock().getHeightWidth().width-this.constants_.DARK_PATH_OFFSET)),this.bottomRow.baseline=e-this.bottomRow.descenderHeight,this.widthWithChildren=t+this.startX+this.constants_.DARK_PATH_OFFSET,this.width+=this.constants_.DARK_PATH_OFFSET,this.height=e+this.constants_.DARK_PATH_OFFSET,this.startY=this.topRow.capline},T.geras.Drawer=function(t,e){T.geras.Drawer.superClass_.constructor.call(this,t,e),this.highlighter_=new T.geras.Highlighter(e)},T.utils.object.inherits(T.geras.Drawer,T.blockRendering.Drawer),T.geras.Drawer.prototype.draw=function(){this.hideHiddenIcons_(),this.drawOutline_(),this.drawInternals_();var t=this.block_.pathObject;t.setPath(this.outlinePath_+"\n"+this.inlinePath_),t.setHighlightPath(this.highlighter_.getPath()),this.info_.RTL&&t.flipRTL(),T.blockRendering.useDebugger&&this.block_.renderingDebugger.drawDebug(this.block_,this.info_),this.recordSizeOnBlock_()},T.geras.Drawer.prototype.drawTop_=function(){this.highlighter_.drawTopCorner(this.info_.topRow),this.highlighter_.drawRightSideRow(this.info_.topRow),T.geras.Drawer.superClass_.drawTop_.call(this)},T.geras.Drawer.prototype.drawJaggedEdge_=function(t){this.highlighter_.drawJaggedEdge_(t),T.geras.Drawer.superClass_.drawJaggedEdge_.call(this,t)},T.geras.Drawer.prototype.drawValueInput_=function(t){this.highlighter_.drawValueInput(t),T.geras.Drawer.superClass_.drawValueInput_.call(this,t)},T.geras.Drawer.prototype.drawStatementInput_=function(t){this.highlighter_.drawStatementInput(t),T.geras.Drawer.superClass_.drawStatementInput_.call(this,t)},T.geras.Drawer.prototype.drawRightSideRow_=function(t){this.highlighter_.drawRightSideRow(t),this.outlinePath_+=T.utils.svgPaths.lineOnAxis("H",t.xPos+t.width)+T.utils.svgPaths.lineOnAxis("V",t.yPos+t.height)},T.geras.Drawer.prototype.drawBottom_=function(){this.highlighter_.drawBottomRow(this.info_.bottomRow),T.geras.Drawer.superClass_.drawBottom_.call(this)},T.geras.Drawer.prototype.drawLeft_=function(){this.highlighter_.drawLeft(),T.geras.Drawer.superClass_.drawLeft_.call(this)},T.geras.Drawer.prototype.drawInlineInput_=function(t){this.highlighter_.drawInlineInput(t),T.geras.Drawer.superClass_.drawInlineInput_.call(this,t)},T.geras.Drawer.prototype.positionInlineInputConnection_=function(t){var e=t.centerline-t.height/2,o;t.connectionModel&&(o=t.xPos+t.connectionWidth+this.constants_.DARK_PATH_OFFSET,this.info_.RTL&&(o*=-1),t.connectionModel.setOffsetInBlock(o,e+t.connectionOffsetY+this.constants_.DARK_PATH_OFFSET))},T.geras.Drawer.prototype.positionStatementInputConnection_=function(t){var e=t.getLastInput(),o,o;e.connectionModel&&(o=t.xPos+t.statementEdge+e.notchOffset,o=this.info_.RTL?-1*o:o+this.constants_.DARK_PATH_OFFSET,e.connectionModel.setOffsetInBlock(o,t.yPos+this.constants_.DARK_PATH_OFFSET))},T.geras.Drawer.prototype.positionExternalValueConnection_=function(t){var e=t.getLastInput(),o;e.connectionModel&&(o=t.xPos+t.width+this.constants_.DARK_PATH_OFFSET,this.info_.RTL&&(o*=-1),e.connectionModel.setOffsetInBlock(o,t.yPos))},T.geras.Drawer.prototype.positionNextConnection_=function(){var t=this.info_.bottomRow,e,o;t.connection&&(o=(e=t.connection).xPos,e.connectionModel.setOffsetInBlock((this.info_.RTL?-o:o)+this.constants_.DARK_PATH_OFFSET/2,t.baseline+this.constants_.DARK_PATH_OFFSET))},T.geras.HighlightConstantProvider=function(t){this.constantProvider=t,this.OFFSET=.5,this.START_POINT=T.utils.svgPaths.moveBy(this.OFFSET,this.OFFSET)},T.geras.HighlightConstantProvider.prototype.init=function(){this.INSIDE_CORNER=this.makeInsideCorner(),this.OUTSIDE_CORNER=this.makeOutsideCorner(),this.PUZZLE_TAB=this.makePuzzleTab(),this.NOTCH=this.makeNotch(),this.JAGGED_TEETH=this.makeJaggedTeeth(),this.START_HAT=this.makeStartHat()},T.geras.HighlightConstantProvider.prototype.makeInsideCorner=function(){var t=this.constantProvider.CORNER_RADIUS,e=this.OFFSET,o=(1-Math.SQRT1_2)*(t+e)-e,i=T.utils.svgPaths.moveBy(o,o)+T.utils.svgPaths.arc("a","0 0,0",t,T.utils.svgPaths.point(-o-e,t-o)),s=T.utils.svgPaths.arc("a","0 0,0",t+e,T.utils.svgPaths.point(t+e,t+e)),n=T.utils.svgPaths.moveBy(o,-o)+T.utils.svgPaths.arc("a","0 0,0",t+e,T.utils.svgPaths.point(t-o,o+e));return{width:t+e,height:t,pathTop:function(t){return t?i:""},pathBottom:function(t){return t?s:n}}},T.geras.HighlightConstantProvider.prototype.makeOutsideCorner=function(){var t=this.constantProvider.CORNER_RADIUS,e=this.OFFSET,o=(1-Math.SQRT1_2)*(t-e)+e,i=T.utils.svgPaths.moveBy(o,o)+T.utils.svgPaths.arc("a","0 0,1",t-e,T.utils.svgPaths.point(t-o,-o+e)),s=T.utils.svgPaths.moveBy(e,t)+T.utils.svgPaths.arc("a","0 0,1",t-e,T.utils.svgPaths.point(t,-t+e)),n=-o,r=T.utils.svgPaths.moveBy(o,n)+T.utils.svgPaths.arc("a","0 0,1",t-e,T.utils.svgPaths.point(-o+e,-n-t));return{height:t,topLeft:function(t){return t?i:s},bottomLeft:function(){return r}}},T.geras.HighlightConstantProvider.prototype.makePuzzleTab=function(){var t=this.constantProvider.TAB_WIDTH,e=this.constantProvider.TAB_HEIGHT,o=T.utils.svgPaths.moveBy(-2,-e+3.4)+T.utils.svgPaths.lineTo(-.45*t,-2.1),i=T.utils.svgPaths.lineOnAxis("v",2.5)+T.utils.svgPaths.moveBy(.97*-t,2.5)+T.utils.svgPaths.curve("q",[T.utils.svgPaths.point(.05*-t,10),T.utils.svgPaths.point(.3*t,9.5)])+T.utils.svgPaths.moveBy(.67*t,-1.9)+T.utils.svgPaths.lineOnAxis("v",2.5),s=T.utils.svgPaths.lineOnAxis("v",-1.5)+T.utils.svgPaths.moveBy(-.92*t,-.5)+T.utils.svgPaths.curve("q",[T.utils.svgPaths.point(-.19*t,-5.5),T.utils.svgPaths.point(0,-11)])+T.utils.svgPaths.moveBy(.92*t,1),n=T.utils.svgPaths.moveBy(-5,e-.7)+T.utils.svgPaths.lineTo(.46*t,-2.1);return{width:t,height:e,pathUp:function(t){return t?o:s},pathDown:function(t){return t?i:n}}},T.geras.HighlightConstantProvider.prototype.makeNotch=function(){return{pathLeft:T.utils.svgPaths.lineOnAxis("h",this.OFFSET)+this.constantProvider.NOTCH.pathLeft}},T.geras.HighlightConstantProvider.prototype.makeJaggedTeeth=function(){return{pathLeft:T.utils.svgPaths.lineTo(5.1,2.6)+T.utils.svgPaths.moveBy(-10.2,6.8)+T.utils.svgPaths.lineTo(5.1,2.6),height:12,width:10.2}},T.geras.HighlightConstantProvider.prototype.makeStartHat=function(){var t=this.constantProvider.START_HAT.height,e=T.utils.svgPaths.moveBy(25,-8.7)+T.utils.svgPaths.curve("c",[T.utils.svgPaths.point(29.7,-6.2),T.utils.svgPaths.point(57.2,-.5),T.utils.svgPaths.point(75,8.7)]),o=T.utils.svgPaths.curve("c",[T.utils.svgPaths.point(17.8,-9.2),T.utils.svgPaths.point(45.3,-14.9),T.utils.svgPaths.point(75,-8.7)])+T.utils.svgPaths.moveTo(100.5,t+.5);return{path:function(t){return t?e:o}}},T.geras.PathObject=function(t,e,o){this.constants=o,this.svgRoot=t,this.svgPathDark=T.utils.dom.createSvgElement(),this.svgPath=T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyPath"},this.svgRoot),this.svgPathLight=T.utils.dom.createSvgElement(),this.colourDark="#000000",this.style=e},T.utils.object.inherits(T.geras.PathObject,T.blockRendering.PathObject),T.geras.PathObject.prototype.setPath=function(t){this.svgPath.setAttribute("d",t),this.svgPathDark.setAttribute("d",t)},T.geras.PathObject.prototype.setHighlightPath=function(t){this.svgPathLight.setAttribute("d",t)},T.geras.PathObject.prototype.flipRTL=function(){this.svgPath.setAttribute("transform","scale(-1 1)"),this.svgPathLight.setAttribute("transform","scale(-1 1)"),this.svgPathDark.setAttribute("transform","translate(1,1) scale(-1 1)")},T.geras.PathObject.prototype.applyColour=function(t){this.svgPathLight.style.display="",this.svgPathDark.style.display="",this.svgPathLight.setAttribute("stroke",this.style.colourTertiary),this.svgPathDark.setAttribute("fill",this.colourDark),T.geras.PathObject.superClass_.applyColour.call(this,t),this.svgPath.setAttribute("stroke","none")},T.geras.PathObject.prototype.setStyle=function(t){this.style=t,this.colourDark=T.utils.colour.blend("#000",this.style.colourPrimary,.2)||this.colourDark},T.geras.PathObject.prototype.updateHighlighted=function(t){t?(this.svgPath.setAttribute("filter","url(#"+this.constants.embossFilterId+")"),this.svgPathLight.style.display="none"):(this.svgPath.setAttribute("filter","none"),this.svgPathLight.style.display="inline")},T.geras.PathObject.prototype.updateShadow_=function(t){t&&(this.svgPathLight.style.display="none",this.svgPathDark.setAttribute("fill",this.style.colourSecondary),this.svgPath.setAttribute("stroke","none"),this.svgPath.setAttribute("fill",this.style.colourSecondary))},T.geras.PathObject.prototype.updateDisabled_=function(t){T.geras.PathObject.superClass_.updateDisabled_.call(this,t),t&&this.svgPath.setAttribute("stroke","none")},T.geras.Renderer=function(t){T.geras.Renderer.superClass_.constructor.call(this,t),this.highlightConstants_=null},T.utils.object.inherits(T.geras.Renderer,T.blockRendering.Renderer),T.geras.Renderer.prototype.init=function(t,e){T.geras.Renderer.superClass_.init.call(this,t,e),this.highlightConstants_=this.makeHighlightConstants_(),this.highlightConstants_.init()},T.geras.Renderer.prototype.refreshDom=function(t,e){T.geras.Renderer.superClass_.refreshDom.call(this,t,e),this.getHighlightConstants().init()},T.geras.Renderer.prototype.makeConstants_=function(){return new T.geras.ConstantProvider},T.geras.Renderer.prototype.makeRenderInfo_=function(t){return new T.geras.RenderInfo(this,t)},T.geras.Renderer.prototype.makeDrawer_=function(t,e){return new T.geras.Drawer(t,e)},T.geras.Renderer.prototype.makePathObject=function(t,e){return new T.geras.PathObject(t,e,this.getConstants())},T.geras.Renderer.prototype.makeHighlightConstants_=function(){return new T.geras.HighlightConstantProvider(this.getConstants())},T.geras.Renderer.prototype.getHighlightConstants=function(){return this.highlightConstants_},T.blockRendering.register("geras",T.geras.Renderer),T.thrasos={},T.thrasos.RenderInfo=function(t,e){T.thrasos.RenderInfo.superClass_.constructor.call(this,t,e)},T.utils.object.inherits(T.thrasos.RenderInfo,T.blockRendering.RenderInfo),T.thrasos.RenderInfo.prototype.getRenderer=function(){return this.renderer_},T.thrasos.RenderInfo.prototype.addElemSpacing_=function(){for(var t=!1,e=0,o;o=this.rows[e];e++)o.hasExternalInput&&(t=!0);for(e=0;o=this.rows[e];e++){var i=o.elements;o.elements=[],o.startsWithElemSpacer()&&o.elements.push(new T.blockRendering.InRowSpacer(this.constants_,this.getInRowSpacing_(null,i[0])));for(var s=0;s<i.length-1;s++){o.elements.push(i[s]);var n=this.getInRowSpacing_(i[s],i[s+1]);o.elements.push(new T.blockRendering.InRowSpacer(this.constants_,n))}o.elements.push(i[i.length-1]),o.endsWithElemSpacer()&&(n=this.getInRowSpacing_(i[i.length-1],null),t&&o.hasDummyInput&&(n+=this.constants_.TAB_WIDTH),o.elements.push(new T.blockRendering.InRowSpacer(this.constants_,n)))}},T.thrasos.RenderInfo.prototype.getInRowSpacing_=function(t,e){if(!t)return e&&T.blockRendering.Types.isField(e)&&e.isEditable?this.constants_.MEDIUM_PADDING:e&&T.blockRendering.Types.isInlineInput(e)?this.constants_.MEDIUM_LARGE_PADDING:e&&T.blockRendering.Types.isStatementInput(e)?this.constants_.STATEMENT_INPUT_PADDING_LEFT:this.constants_.LARGE_PADDING;if(!T.blockRendering.Types.isInput(t)&&!e)return T.blockRendering.Types.isField(t)&&t.isEditable?this.constants_.MEDIUM_PADDING:T.blockRendering.Types.isIcon(t)?2*this.constants_.LARGE_PADDING+1:T.blockRendering.Types.isHat(t)?this.constants_.NO_PADDING:T.blockRendering.Types.isPreviousOrNextConnection(t)?this.constants_.LARGE_PADDING:T.blockRendering.Types.isLeftRoundedCorner(t)?this.constants_.MIN_BLOCK_WIDTH:T.blockRendering.Types.isJaggedEdge(t)?this.constants_.NO_PADDING:this.constants_.LARGE_PADDING;if(T.blockRendering.Types.isInput(t)&&!e){if(T.blockRendering.Types.isExternalInput(t))return this.constants_.NO_PADDING;if(T.blockRendering.Types.isInlineInput(t))return this.constants_.LARGE_PADDING;if(T.blockRendering.Types.isStatementInput(t))return this.constants_.NO_PADDING}if(!T.blockRendering.Types.isInput(t)&&e&&T.blockRendering.Types.isInput(e)){if(T.blockRendering.Types.isField(t)&&t.isEditable){if(T.blockRendering.Types.isInlineInput(e)||T.blockRendering.Types.isExternalInput(e))return this.constants_.SMALL_PADDING}else{if(T.blockRendering.Types.isInlineInput(e)||T.blockRendering.Types.isExternalInput(e))return this.constants_.MEDIUM_LARGE_PADDING;if(T.blockRendering.Types.isStatementInput(e))return this.constants_.LARGE_PADDING}return this.constants_.LARGE_PADDING-1}if(T.blockRendering.Types.isIcon(t)&&e&&!T.blockRendering.Types.isInput(e))return this.constants_.LARGE_PADDING;if(T.blockRendering.Types.isInlineInput(t)&&e&&T.blockRendering.Types.isField(e))return e.isEditable?this.constants_.MEDIUM_PADDING:this.constants_.LARGE_PADDING;if(T.blockRendering.Types.isLeftSquareCorner(t)&&e){if(T.blockRendering.Types.isHat(e))return this.constants_.NO_PADDING;if(T.blockRendering.Types.isPreviousConnection(e)||T.blockRendering.Types.isNextConnection(e))return e.notchOffset}return T.blockRendering.Types.isLeftRoundedCorner(t)&&e?e.notchOffset-this.constants_.CORNER_RADIUS:T.blockRendering.Types.isField(t)&&e&&T.blockRendering.Types.isField(e)&&t.isEditable==e.isEditable||e&&T.blockRendering.Types.isJaggedEdge(e)?this.constants_.LARGE_PADDING:this.constants_.MEDIUM_PADDING},T.thrasos.RenderInfo.prototype.getSpacerRowHeight_=function(t,e){return T.blockRendering.Types.isTopRow(t)&&T.blockRendering.Types.isBottomRow(e)?this.constants_.EMPTY_BLOCK_SPACER_HEIGHT:T.blockRendering.Types.isTopRow(t)||T.blockRendering.Types.isBottomRow(e)?this.constants_.NO_PADDING:t.hasExternalInput&&e.hasExternalInput?this.constants_.LARGE_PADDING:!t.hasStatement&&e.hasStatement?this.constants_.BETWEEN_STATEMENT_PADDING_Y:t.hasStatement&&e.hasStatement||t.hasDummyInput||e.hasDummyInput?this.constants_.LARGE_PADDING:this.constants_.MEDIUM_PADDING},T.thrasos.RenderInfo.prototype.getElemCenterline_=function(t,e){if(T.blockRendering.Types.isSpacer(e))return t.yPos+e.height/2;if(T.blockRendering.Types.isBottomRow(t))return t=t.yPos+t.height-t.descenderHeight,T.blockRendering.Types.isNextConnection(e)?t+e.height/2:t-e.height/2;if(T.blockRendering.Types.isTopRow(t))return T.blockRendering.Types.isHat(e)?t.capline-e.height/2:t.capline+e.height/2;var o=t.yPos;return o=T.blockRendering.Types.isField(e)&&t.hasStatement?o+(this.constants_.TALL_INPUT_FIELD_OFFSET_Y+e.height/2):o+t.height/2},T.thrasos.RenderInfo.prototype.finalize_=function(){for(var t=0,e=0,o=0,i;i=this.rows[o];o++){i.yPos=e,i.xPos=this.startX,e+=i.height;var t=Math.max(t,i.widthWithConnectedBlocks),s=e-this.topRow.ascenderHeight;i==this.bottomRow&&s<this.constants_.MIN_BLOCK_HEIGHT&&(s=this.constants_.MIN_BLOCK_HEIGHT-s,this.bottomRow.height+=s,e+=s),this.recordElemPositions_(i)}this.outputConnection&&this.block_.nextConnection&&this.block_.nextConnection.isConnected()&&(t=Math.max(t,this.block_.nextConnection.targetBlock().getHeightWidth().width)),this.bottomRow.baseline=e-this.bottomRow.descenderHeight,this.widthWithChildren=t+this.startX,this.height=e,this.startY=this.topRow.capline},T.thrasos.Renderer=function(t){T.thrasos.Renderer.superClass_.constructor.call(this,t)},T.utils.object.inherits(T.thrasos.Renderer,T.blockRendering.Renderer),T.thrasos.Renderer.prototype.makeRenderInfo_=function(t){return new T.thrasos.RenderInfo(this,t)},T.blockRendering.register("thrasos",T.thrasos.Renderer),T.zelos={},T.zelos.ConstantProvider=function(){T.zelos.ConstantProvider.superClass_.constructor.call(this),this.SMALL_PADDING=this.GRID_UNIT=4,this.MEDIUM_PADDING=2*this.GRID_UNIT,this.MEDIUM_LARGE_PADDING=3*this.GRID_UNIT,this.LARGE_PADDING=4*this.GRID_UNIT,this.CORNER_RADIUS=1*this.GRID_UNIT,this.NOTCH_WIDTH=9*this.GRID_UNIT,this.NOTCH_HEIGHT=2*this.GRID_UNIT,this.STATEMENT_INPUT_NOTCH_OFFSET=this.NOTCH_OFFSET_LEFT=3*this.GRID_UNIT,this.MIN_BLOCK_WIDTH=2*this.GRID_UNIT,this.MIN_BLOCK_HEIGHT=12*this.GRID_UNIT,this.EMPTY_STATEMENT_INPUT_HEIGHT=6*this.GRID_UNIT,this.TAB_OFFSET_FROM_TOP=0,this.TOP_ROW_MIN_HEIGHT=this.CORNER_RADIUS,this.TOP_ROW_PRECEDES_STATEMENT_MIN_HEIGHT=this.LARGE_PADDING,this.BOTTOM_ROW_MIN_HEIGHT=this.CORNER_RADIUS,this.BOTTOM_ROW_AFTER_STATEMENT_MIN_HEIGHT=6*this.GRID_UNIT,this.STATEMENT_BOTTOM_SPACER=-this.NOTCH_HEIGHT,this.STATEMENT_INPUT_SPACER_MIN_WIDTH=40*this.GRID_UNIT,this.STATEMENT_INPUT_PADDING_LEFT=4*this.GRID_UNIT,this.EMPTY_INLINE_INPUT_PADDING=4*this.GRID_UNIT,this.EMPTY_INLINE_INPUT_HEIGHT=8*this.GRID_UNIT,this.DUMMY_INPUT_MIN_HEIGHT=8*this.GRID_UNIT,this.DUMMY_INPUT_SHADOW_MIN_HEIGHT=6*this.GRID_UNIT,this.CURSOR_WS_WIDTH=20*this.GRID_UNIT,this.CURSOR_COLOUR="#ffa200",this.CURSOR_RADIUS=5,this.JAGGED_TEETH_WIDTH=this.JAGGED_TEETH_HEIGHT=0,this.START_HAT_HEIGHT=22,this.START_HAT_WIDTH=96,this.SHAPES={HEXAGONAL:1,ROUND:2,SQUARE:3,PUZZLE:4,NOTCH:5},this.SHAPE_IN_SHAPE_PADDING={1:{0:5*this.GRID_UNIT,1:2*this.GRID_UNIT,2:5*this.GRID_UNIT,3:5*this.GRID_UNIT},2:{0:3*this.GRID_UNIT,1:3*this.GRID_UNIT,2:1*this.GRID_UNIT,3:2*this.GRID_UNIT},3:{0:2*this.GRID_UNIT,1:2*this.GRID_UNIT,2:2*this.GRID_UNIT,3:2*this.GRID_UNIT}},this.FULL_BLOCK_FIELDS=!0,this.FIELD_TEXT_FONTSIZE=3*this.GRID_UNIT,this.FIELD_TEXT_FONTWEIGHT="bold",this.FIELD_TEXT_FONTFAMILY='"Helvetica Neue", "Segoe UI", Helvetica, sans-serif',this.FIELD_BORDER_RECT_RADIUS=this.CORNER_RADIUS,this.FIELD_BORDER_RECT_X_PADDING=2*this.GRID_UNIT,this.FIELD_BORDER_RECT_Y_PADDING=1.625*this.GRID_UNIT,this.FIELD_BORDER_RECT_HEIGHT=8*this.GRID_UNIT,this.FIELD_DROPDOWN_BORDER_RECT_HEIGHT=8*this.GRID_UNIT,this.FIELD_DROPDOWN_SVG_ARROW=this.FIELD_DROPDOWN_COLOURED_DIV=this.FIELD_DROPDOWN_NO_BORDER_RECT_SHADOW=!0,this.FIELD_DROPDOWN_SVG_ARROW_PADDING=this.FIELD_BORDER_RECT_X_PADDING,this.FIELD_COLOUR_FULL_BLOCK=this.FIELD_TEXTINPUT_BOX_SHADOW=!0,this.FIELD_COLOUR_DEFAULT_WIDTH=2*this.GRID_UNIT,this.FIELD_COLOUR_DEFAULT_HEIGHT=4*this.GRID_UNIT,this.FIELD_CHECKBOX_X_OFFSET=1*this.GRID_UNIT,this.MAX_DYNAMIC_CONNECTION_SHAPE_WIDTH=12*this.GRID_UNIT,this.SELECTED_GLOW_COLOUR="#fff200",this.SELECTED_GLOW_SIZE=.5,this.REPLACEMENT_GLOW_COLOUR="#fff200",this.REPLACEMENT_GLOW_SIZE=2,this.selectedGlowFilterId="",this.selectedGlowFilter_=null,this.replacementGlowFilterId="",this.replacementGlowFilter_=null},T.utils.object.inherits(T.zelos.ConstantProvider,T.blockRendering.ConstantProvider),T.zelos.ConstantProvider.prototype.setFontConstants_=function(t){T.zelos.ConstantProvider.superClass_.setFontConstants_.call(this,t),this.FIELD_DROPDOWN_BORDER_RECT_HEIGHT=this.FIELD_BORDER_RECT_HEIGHT=this.FIELD_TEXT_HEIGHT+2*this.FIELD_BORDER_RECT_Y_PADDING},T.zelos.ConstantProvider.prototype.init=function(){T.zelos.ConstantProvider.superClass_.init.call(this),this.HEXAGONAL=this.makeHexagonal(),this.ROUNDED=this.makeRounded(),this.SQUARED=this.makeSquared(),this.STATEMENT_INPUT_NOTCH_OFFSET=this.NOTCH_OFFSET_LEFT+this.INSIDE_CORNERS.rightWidth},T.zelos.ConstantProvider.prototype.setDynamicProperties_=function(t){T.zelos.ConstantProvider.superClass_.setDynamicProperties_.call(this,t),this.SELECTED_GLOW_COLOUR=t.getComponentStyle("selectedGlowColour")||this.SELECTED_GLOW_COLOUR;var e=Number(t.getComponentStyle("selectedGlowSize"));this.SELECTED_GLOW_SIZE=e&&!isNaN(e)?e:this.SELECTED_GLOW_SIZE,this.REPLACEMENT_GLOW_COLOUR=t.getComponentStyle("replacementGlowColour")||this.REPLACEMENT_GLOW_COLOUR,this.REPLACEMENT_GLOW_SIZE=(t=Number(t.getComponentStyle("replacementGlowSize")))&&!isNaN(t)?t:this.REPLACEMENT_GLOW_SIZE},T.zelos.ConstantProvider.prototype.dispose=function(){T.zelos.ConstantProvider.superClass_.dispose.call(this),this.selectedGlowFilter_&&T.utils.dom.removeNode(this.selectedGlowFilter_),this.replacementGlowFilter_&&T.utils.dom.removeNode(this.replacementGlowFilter_)},T.zelos.ConstantProvider.prototype.makeStartHat=function(){var t=this.START_HAT_HEIGHT,e=this.START_HAT_WIDTH,o;return{height:t,width:e,path:T.utils.svgPaths.curve("c",[T.utils.svgPaths.point(25,-t),T.utils.svgPaths.point(71,-t),T.utils.svgPaths.point(e,0)])}},T.zelos.ConstantProvider.prototype.makeHexagonal=function(){function e(t,e,o){var i=t/2,i;return T.utils.svgPaths.lineTo(-(o=o?-1:1)*(i=s<i?s:i),t=(e?-1:1)*t/2)+T.utils.svgPaths.lineTo(o*i,t)}var s=this.MAX_DYNAMIC_CONNECTION_SHAPE_WIDTH;return{type:this.SHAPES.HEXAGONAL,isDynamic:!0,width:function(t){return s<(t/=2)?s:t},height:function(t){return t},connectionOffsetY:function(t){return t/2},connectionOffsetX:function(t){return-t},pathDown:function(t){return e(t,!1,!1)},pathUp:function(t){return e(t,!0,!1)},pathRightDown:function(t){return e(t,!1,!0)},pathRightUp:function(t){return e(t,!1,!0)}}},T.zelos.ConstantProvider.prototype.makeRounded=function(){function e(t,e,o){var i=s<t?t-s:0;return T.utils.svgPaths.arc("a","0 0,1",t=(s<t?s:t)/2,T.utils.svgPaths.point((e?-1:1)*t,(e?-1:1)*t))+T.utils.svgPaths.lineOnAxis("v",(o?1:-1)*i)+T.utils.svgPaths.arc("a","0 0,1",t,T.utils.svgPaths.point((e?1:-1)*t,(e?-1:1)*t))}var o=this.MAX_DYNAMIC_CONNECTION_SHAPE_WIDTH,s=2*o;return{type:this.SHAPES.ROUND,isDynamic:!0,width:function(t){return o<(t/=2)?o:t},height:function(t){return t},connectionOffsetY:function(t){return t/2},connectionOffsetX:function(t){return-t},pathDown:function(t){return e(t,!1,!1)},pathUp:function(t){return e(t,!0,!1)},pathRightDown:function(t){return e(t,!1,!0)},pathRightUp:function(t){return e(t,!1,!0)}}},T.zelos.ConstantProvider.prototype.makeSquared=function(){function e(t,e,o){return t-=2*i,T.utils.svgPaths.arc("a","0 0,1",i,T.utils.svgPaths.point((e?-1:1)*i,(e?-1:1)*i))+T.utils.svgPaths.lineOnAxis("v",(o?1:-1)*t)+T.utils.svgPaths.arc("a","0 0,1",i,T.utils.svgPaths.point((e?1:-1)*i,(e?-1:1)*i))}var i=this.CORNER_RADIUS;return{type:this.SHAPES.SQUARE,isDynamic:!0,width:function(t){return i},height:function(t){return t},connectionOffsetY:function(t){return t/2},connectionOffsetX:function(t){return-t},pathDown:function(t){return e(t,!1,!1)},pathUp:function(t){return e(t,!0,!1)},pathRightDown:function(t){return e(t,!1,!0)},pathRightUp:function(t){return e(t,!1,!0)}}},T.zelos.ConstantProvider.prototype.shapeFor=function(t){var e=t.getCheck();switch(!e&&t.targetConnection&&(e=t.targetConnection.getCheck()),t.type){case T.connectionTypes.INPUT_VALUE:case T.connectionTypes.OUTPUT_VALUE:if(null!=(t=t.getSourceBlock().getOutputShape()))switch(t){case this.SHAPES.HEXAGONAL:return this.HEXAGONAL;case this.SHAPES.ROUND:return this.ROUNDED;case this.SHAPES.SQUARE:return this.SQUARED}if(e&&-1!=e.indexOf("Boolean"))return this.HEXAGONAL;if(e&&-1!=e.indexOf("Number"))return this.ROUNDED;return e&&e.indexOf("String"),this.ROUNDED;case T.connectionTypes.PREVIOUS_STATEMENT:case T.connectionTypes.NEXT_STATEMENT:return this.NOTCH;default:throw Error("Unknown type")}},T.zelos.ConstantProvider.prototype.makeNotch=function(){function t(t){return T.utils.svgPaths.curve("c",[T.utils.svgPaths.point(t*s/2,0),T.utils.svgPaths.point(t*s*3/4,r/2),T.utils.svgPaths.point(t*s,r)])+T.utils.svgPaths.line([T.utils.svgPaths.point(t*s,n)])+T.utils.svgPaths.curve("c",[T.utils.svgPaths.point(t*s/4,r/2),T.utils.svgPaths.point(t*s/2,r),T.utils.svgPaths.point(t*s,r)])+T.utils.svgPaths.lineOnAxis("h",t*i)+T.utils.svgPaths.curve("c",[T.utils.svgPaths.point(t*s/2,0),T.utils.svgPaths.point(t*s*3/4,-(r/2)),T.utils.svgPaths.point(t*s,-r)])+T.utils.svgPaths.line([T.utils.svgPaths.point(t*s,-n)])+T.utils.svgPaths.curve("c",[T.utils.svgPaths.point(t*s/4,-(r/2)),T.utils.svgPaths.point(t*s/2,-r),T.utils.svgPaths.point(t*s,-r)])}var e=this.NOTCH_WIDTH,o=this.NOTCH_HEIGHT,i=e/3,s=i/3,n=o/2,r=n/2,l=t(1),a=t(-1);return{type:this.SHAPES.NOTCH,width:e,height:o,pathLeft:l,pathRight:a}},T.zelos.ConstantProvider.prototype.makeInsideCorners=function(){var t=this.CORNER_RADIUS,e=T.utils.svgPaths.arc("a","0 0,0",t,T.utils.svgPaths.point(-t,t)),o=T.utils.svgPaths.arc("a","0 0,1",t,T.utils.svgPaths.point(-t,t)),i,s;return{width:t,height:t,pathTop:e,pathBottom:T.utils.svgPaths.arc("a","0 0,0",t,T.utils.svgPaths.point(t,t)),rightWidth:t,rightHeight:t,pathTopRight:o,pathBottomRight:T.utils.svgPaths.arc("a","0 0,1",t,T.utils.svgPaths.point(t,t))}},T.zelos.ConstantProvider.prototype.generateSecondaryColour_=function(t){return T.utils.colour.blend("#000",t,.15)||t},T.zelos.ConstantProvider.prototype.generateTertiaryColour_=function(t){return T.utils.colour.blend("#000",t,.25)||t},T.zelos.ConstantProvider.prototype.createDom=function(t,e,o){T.zelos.ConstantProvider.superClass_.createDom.call(this,t,e,o),t=T.utils.dom.createSvgElement(T.utils.Svg.DEFS,{},t),e=T.utils.dom.createSvgElement(T.utils.Svg.FILTER,{id:"blocklySelectedGlowFilter"+this.randomIdentifier,height:"160%",width:"180%",y:"-30%",x:"-40%"},t),T.utils.dom.createSvgElement(T.utils.Svg.FEGAUSSIANBLUR,{in:"SourceGraphic",stdDeviation:this.SELECTED_GLOW_SIZE},e),o=T.utils.dom.createSvgElement(T.utils.Svg.FECOMPONENTTRANSFER,{result:"outBlur"},e),T.utils.dom.createSvgElement(T.utils.Svg.FEFUNCA,{type:"table",tableValues:"0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"},o),T.utils.dom.createSvgElement(T.utils.Svg.FEFLOOD,{"flood-color":this.SELECTED_GLOW_COLOUR,"flood-opacity":1,result:"outColor"},e),T.utils.dom.createSvgElement(T.utils.Svg.FECOMPOSITE,{in:"outColor",in2:"outBlur",operator:"in",result:"outGlow"},e),this.selectedGlowFilterId=e.id,this.selectedGlowFilter_=e,t=T.utils.dom.createSvgElement(T.utils.Svg.FILTER,{id:"blocklyReplacementGlowFilter"+this.randomIdentifier,height:"160%",width:"180%",y:"-30%",x:"-40%"},t),T.utils.dom.createSvgElement(T.utils.Svg.FEGAUSSIANBLUR,{in:"SourceGraphic",stdDeviation:this.REPLACEMENT_GLOW_SIZE},t),e=T.utils.dom.createSvgElement(T.utils.Svg.FECOMPONENTTRANSFER,{result:"outBlur"},t),T.utils.dom.createSvgElement(T.utils.Svg.FEFUNCA,{type:"table",tableValues:"0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1"},e),T.utils.dom.createSvgElement(T.utils.Svg.FEFLOOD,{"flood-color":this.REPLACEMENT_GLOW_COLOUR,"flood-opacity":1,result:"outColor"},t),T.utils.dom.createSvgElement(T.utils.Svg.FECOMPOSITE,{in:"outColor",in2:"outBlur",operator:"in",result:"outGlow"},t),T.utils.dom.createSvgElement(T.utils.Svg.FECOMPOSITE,{in:"SourceGraphic",in2:"outGlow",operator:"over"},t),this.replacementGlowFilterId=t.id,this.replacementGlowFilter_=t},T.zelos.ConstantProvider.prototype.getCSS_=function(t){return[t+" .blocklyText,",t+" .blocklyFlyoutLabelText {","font: "+this.FIELD_TEXT_FONTWEIGHT+" "+this.FIELD_TEXT_FONTSIZE+"pt "+this.FIELD_TEXT_FONTFAMILY+";","}",t+" .blocklyText {","fill: #fff;","}",t+" .blocklyNonEditableText>rect:not(.blocklyDropdownRect),",t+" .blocklyEditableText>rect:not(.blocklyDropdownRect) {","fill: "+this.FIELD_BORDER_RECT_COLOUR+";","}",t+" .blocklyNonEditableText>text,",t+" .blocklyEditableText>text,",t+" .blocklyNonEditableText>g>text,",t+" .blocklyEditableText>g>text {","fill: #575E75;","}",t+" .blocklyFlyoutLabelText {","fill: #575E75;","}",t+" .blocklyText.blocklyBubbleText {","fill: #575E75;","}",t+" .blocklyDraggable:not(.blocklyDisabled)"," .blocklyEditableText:not(.editing):hover>rect,",t+" .blocklyDraggable:not(.blocklyDisabled)"," .blocklyEditableText:not(.editing):hover>.blocklyPath {","stroke: #fff;","stroke-width: 2;","}",t+" .blocklyHtmlInput {","font-family: "+this.FIELD_TEXT_FONTFAMILY+";","font-weight: "+this.FIELD_TEXT_FONTWEIGHT+";","color: #575E75;","}",t+" .blocklyDropdownText {","fill: #fff !important;","}",t+".blocklyWidgetDiv .goog-menuitem,",t+".blocklyDropDownDiv .goog-menuitem {","font-family: "+this.FIELD_TEXT_FONTFAMILY+";","}",t+".blocklyDropDownDiv .goog-menuitem-content {","color: #fff;","}",t+" .blocklyHighlightedConnectionPath {","stroke: "+this.SELECTED_GLOW_COLOUR+";","}",t+" .blocklyDisabled > .blocklyOutlinePath {","fill: url(#blocklyDisabledPattern"+this.randomIdentifier+")","}",t+" .blocklyInsertionMarker>.blocklyPath {","fill-opacity: "+this.INSERTION_MARKER_OPACITY+";","stroke: none;","}"]},T.zelos.TopRow=function(t){T.zelos.TopRow.superClass_.constructor.call(this,t)},T.utils.object.inherits(T.zelos.TopRow,T.blockRendering.TopRow),T.zelos.TopRow.prototype.endsWithElemSpacer=function(){return!1},T.zelos.TopRow.prototype.hasLeftSquareCorner=function(t){var e=(t.hat?"cap"===t.hat:this.constants_.ADD_START_HATS)&&!t.outputConnection&&!t.previousConnection;return!!t.outputConnection||e},T.zelos.TopRow.prototype.hasRightSquareCorner=function(t){return!!t.outputConnection&&!t.statementInputCount&&!t.nextConnection},T.zelos.BottomRow=function(t){T.zelos.BottomRow.superClass_.constructor.call(this,t)},T.utils.object.inherits(T.zelos.BottomRow,T.blockRendering.BottomRow),T.zelos.BottomRow.prototype.endsWithElemSpacer=function(){return!1},T.zelos.BottomRow.prototype.hasLeftSquareCorner=function(t){return!!t.outputConnection},T.zelos.BottomRow.prototype.hasRightSquareCorner=function(t){return!!t.outputConnection&&!t.statementInputCount&&!t.nextConnection},T.zelos.RightConnectionShape=function(t){T.zelos.RightConnectionShape.superClass_.constructor.call(this,t),this.type|=T.blockRendering.Types.getType("RIGHT_CONNECTION"),this.width=this.height=0},T.utils.object.inherits(T.zelos.RightConnectionShape,T.blockRendering.Measurable),T.zelos.RenderInfo=function(t,e){T.zelos.RenderInfo.superClass_.constructor.call(this,t,e),this.topRow=new T.zelos.TopRow(this.constants_),this.bottomRow=new T.zelos.BottomRow(this.constants_),this.isInline=!0,this.isMultiRow=!e.getInputsInline()||e.isCollapsed(),this.hasStatementInput=0<e.statementInputCount,this.rightSide=this.outputConnection?new T.zelos.RightConnectionShape(this.constants_):null},T.utils.object.inherits(T.zelos.RenderInfo,T.blockRendering.RenderInfo),T.zelos.RenderInfo.prototype.getRenderer=function(){return this.renderer_},T.zelos.RenderInfo.prototype.measure=function(){this.createRows_(),this.addElemSpacing_(),this.addRowSpacing_(),this.adjustXPosition_(),this.computeBounds_(),this.alignRowElements_(),this.finalize_()},T.zelos.RenderInfo.prototype.shouldStartNewRow_=function(t,e){return!!e&&(t.type==T.inputTypes.STATEMENT||e.type==T.inputTypes.STATEMENT||(t.type==T.inputTypes.VALUE||t.type==T.inputTypes.DUMMY)&&(!this.isInline||this.isMultiRow))},T.zelos.RenderInfo.prototype.getDesiredRowWidth_=function(t){return t.hasStatement?this.width-this.startX-(this.constants_.INSIDE_CORNERS.rightWidth||0):T.zelos.RenderInfo.superClass_.getDesiredRowWidth_.call(this,t)},T.zelos.RenderInfo.prototype.getInRowSpacing_=function(t,e){return t&&e||!this.outputConnection||!this.outputConnection.isDynamicShape||this.hasStatementInput||this.bottomRow.hasNextConnection?!t&&e&&T.blockRendering.Types.isStatementInput(e)?this.constants_.STATEMENT_INPUT_PADDING_LEFT:t&&T.blockRendering.Types.isLeftRoundedCorner(t)&&e&&(T.blockRendering.Types.isPreviousConnection(e)||T.blockRendering.Types.isNextConnection(e))?e.notchOffset-this.constants_.CORNER_RADIUS:t&&T.blockRendering.Types.isLeftSquareCorner(t)&&e&&T.blockRendering.Types.isHat(e)?this.constants_.NO_PADDING:this.constants_.MEDIUM_PADDING:this.constants_.NO_PADDING},T.zelos.RenderInfo.prototype.getSpacerRowHeight_=function(t,e){if(T.blockRendering.Types.isTopRow(t)&&T.blockRendering.Types.isBottomRow(e))return this.constants_.EMPTY_BLOCK_SPACER_HEIGHT;var o=T.blockRendering.Types.isInputRow(t)&&t.hasStatement,i=T.blockRendering.Types.isInputRow(e)&&e.hasStatement;return i||o?(t=Math.max(this.constants_.NOTCH_HEIGHT,this.constants_.INSIDE_CORNERS.rightHeight||0),i&&o?Math.max(t,this.constants_.DUMMY_INPUT_MIN_HEIGHT):t):T.blockRendering.Types.isTopRow(t)?t.hasPreviousConnection||this.outputConnection&&!this.hasStatementInput?this.constants_.NO_PADDING:Math.abs(this.constants_.NOTCH_HEIGHT-this.constants_.CORNER_RADIUS):T.blockRendering.Types.isBottomRow(e)?this.outputConnection?!e.hasNextConnection&&this.hasStatementInput?Math.abs(this.constants_.NOTCH_HEIGHT-this.constants_.CORNER_RADIUS):this.constants_.NO_PADDING:Math.max(this.topRow.minHeight,Math.max(this.constants_.NOTCH_HEIGHT,this.constants_.CORNER_RADIUS))-this.constants_.CORNER_RADIUS:this.constants_.MEDIUM_PADDING},T.zelos.RenderInfo.prototype.getSpacerRowWidth_=function(t,e){var o=this.width-this.startX;return T.blockRendering.Types.isInputRow(t)&&t.hasStatement||T.blockRendering.Types.isInputRow(e)&&e.hasStatement?Math.max(o,this.constants_.STATEMENT_INPUT_SPACER_MIN_WIDTH):o},T.zelos.RenderInfo.prototype.getElemCenterline_=function(t,e){if(t.hasStatement&&!T.blockRendering.Types.isSpacer(e)&&!T.blockRendering.Types.isStatementInput(e))return t.yPos+this.constants_.EMPTY_STATEMENT_INPUT_HEIGHT/2;if(T.blockRendering.Types.isInlineInput(e)){var o=e.connectedBlock;if(o&&o.outputConnection&&o.nextConnection)return t.yPos+o.height/2}return T.zelos.RenderInfo.superClass_.getElemCenterline_.call(this,t,e)},T.zelos.RenderInfo.prototype.addInput_=function(t,e){t.type==T.inputTypes.DUMMY&&e.hasDummyInput&&e.align==T.constants.ALIGN.LEFT&&t.align==T.constants.ALIGN.RIGHT&&(e.rightAlignedDummyInput=t),T.zelos.RenderInfo.superClass_.addInput_.call(this,t,e)},T.zelos.RenderInfo.prototype.addAlignmentPadding_=function(t,e){if(t.rightAlignedDummyInput){for(var o,i=0,s;(s=t.elements[i])&&(T.blockRendering.Types.isSpacer(s)&&(o=s),!T.blockRendering.Types.isField(s)||s.parentInput!=t.rightAlignedDummyInput);i++);if(o)return o.width+=e,void(t.width+=e)}T.zelos.RenderInfo.superClass_.addAlignmentPadding_.call(this,t,e)},T.zelos.RenderInfo.prototype.adjustXPosition_=function(){for(var t=this.constants_.NOTCH_OFFSET_LEFT+this.constants_.NOTCH_WIDTH,e=t,o=2;o<this.rows.length-1;o+=2){var i=this.rows[o-1],s=this.rows[o],n=this.rows[o+1];if(i=2==o?!!this.topRow.hasPreviousConnection:!!i.followsStatement,n=o+2>=this.rows.length-1?!!this.bottomRow.hasNextConnection:!!n.precedesStatement,T.blockRendering.Types.isInputRow(s)&&s.hasStatement)s.measure(),e=s.width-s.getLastInput().width+t;else if(i&&(2==o||n)&&T.blockRendering.Types.isInputRow(s)&&!s.hasStatement)for(var n=s.xPos,i=null,r=0,l;l=s.elements[r];r++)!((i=T.blockRendering.Types.isSpacer(l)?l:i)&&(T.blockRendering.Types.isField(l)||T.blockRendering.Types.isInput(l))&&n<e)||T.blockRendering.Types.isField(l)&&(l.field instanceof T.FieldLabel||l.field instanceof T.FieldImage)||(i.width+=e-n),n+=l.width}},T.zelos.RenderInfo.prototype.finalizeOutputConnection_=function(){if(this.outputConnection&&this.outputConnection.isDynamicShape){for(var t=0,e=0,o;o=this.rows[e];e++)o.yPos=t,t+=o.height;this.height=t,e=this.bottomRow.hasNextConnection?this.height-this.bottomRow.descenderHeight:this.height,t=this.outputConnection.shape.height(e),e=this.outputConnection.shape.width(e),this.outputConnection.height=t,this.outputConnection.width=e,this.outputConnection.startX=e,this.outputConnection.connectionOffsetY=this.outputConnection.shape.connectionOffsetY(t),this.outputConnection.connectionOffsetX=this.outputConnection.shape.connectionOffsetX(e),o=0,this.hasStatementInput||this.bottomRow.hasNextConnection||(o=e,this.rightSide.height=t,this.rightSide.width=o,this.rightSide.centerline=t/2,this.rightSide.xPos=this.width+o),this.startX=e,this.width+=e+o,this.widthWithChildren+=e+o}},T.zelos.RenderInfo.prototype.finalizeHorizontalAlignment_=function(){if(this.outputConnection&&!this.hasStatementInput&&!this.bottomRow.hasNextConnection){for(var t=0,e=0,o,t,i,s,n;o=this.rows[e];e++){T.blockRendering.Types.isInputRow(o)&&(t=o.elements[o.elements.length-2],i=this.getNegativeSpacing_(o.elements[1]),s=this.getNegativeSpacing_(t),n=this.constants_.MIN_BLOCK_WIDTH+2*this.outputConnection.width,this.width-(t=i+s)<n&&(s=i=(t=this.width-n)/2),o.elements.unshift(new T.blockRendering.InRowSpacer(this.constants_,-i)),o.elements.push(new T.blockRendering.InRowSpacer(this.constants_,-s)))}if(t)for(this.width-=t,this.widthWithChildren-=t,this.rightSide.xPos-=t,e=0;o=this.rows[e];e++)T.blockRendering.Types.isTopOrBottomRow(o)&&(o.elements[1].width-=t,o.elements[1].widthWithConnectedBlocks-=t),o.width-=t,o.widthWithConnectedBlocks-=t}},T.zelos.RenderInfo.prototype.getNegativeSpacing_=function(t){if(!t)return 0;var e=this.outputConnection.width,o=this.outputConnection.shape.type,i=this.constants_,s;if(this.isMultiRow&&1<this.inputRows.length)switch(o){case i.SHAPES.ROUND:return o=this.constants_.MAX_DYNAMIC_CONNECTION_SHAPE_WIDTH,e-(o=this.height/2>o?o:this.height/2)*(1-Math.sin(Math.acos((o-this.constants_.SMALL_PADDING)/o)));default:return 0}if(T.blockRendering.Types.isInlineInput(t))return t=(s=t.connectedBlock)?s.pathObject.outputShapeType:t.shape.type,s&&s.outputConnection&&(s.statementInputCount||s.nextConnection)||o==i.SHAPES.HEXAGONAL&&o!=t?0:e-this.constants_.SHAPE_IN_SHAPE_PADDING[o][t];return T.blockRendering.Types.isField(t)?o==i.SHAPES.ROUND&&t.field instanceof T.FieldTextInput?e-2.75*i.GRID_UNIT:e-this.constants_.SHAPE_IN_SHAPE_PADDING[o][0]:T.blockRendering.Types.isIcon(t)?this.constants_.SMALL_PADDING:0},T.zelos.RenderInfo.prototype.finalizeVerticalAlignment_=function(){if(!this.outputConnection)for(var t=2;t<this.rows.length-1;t+=2){var e=this.rows[t-1],o=this.rows[t],i=this.rows[t+1],s=2==t,n=t+2>=this.rows.length-1?!!this.bottomRow.hasNextConnection:!!i.precedesStatement;if(s?this.topRow.hasPreviousConnection:e.followsStatement){var r=3==o.elements.length&&(o.elements[1].field instanceof T.FieldLabel||o.elements[1].field instanceof T.FieldImage);if(!s&&r)e.height-=this.constants_.SMALL_PADDING,i.height-=this.constants_.SMALL_PADDING,o.height-=this.constants_.MEDIUM_PADDING;else if(s||n){if(n){for(s=!1,n=0;r=o.elements[n];n++)if(T.blockRendering.Types.isInlineInput(r)&&r.connectedBlock&&!r.connectedBlock.isShadow()&&40<=r.connectedBlock.getHeightWidth().height){s=!0;break}s&&(e.height-=this.constants_.SMALL_PADDING,i.height-=this.constants_.SMALL_PADDING)}}else e.height+=this.constants_.SMALL_PADDING}}},T.zelos.RenderInfo.prototype.finalize_=function(){this.finalizeOutputConnection_(),this.finalizeHorizontalAlignment_(),this.finalizeVerticalAlignment_(),T.zelos.RenderInfo.superClass_.finalize_.call(this),this.rightSide&&(this.widthWithChildren+=this.rightSide.width)},T.zelos.Drawer=function(t,e){T.zelos.Drawer.superClass_.constructor.call(this,t,e)},T.utils.object.inherits(T.zelos.Drawer,T.blockRendering.Drawer),T.zelos.Drawer.prototype.draw=function(){var t=this.block_.pathObject;t.beginDrawing(),this.hideHiddenIcons_(),this.drawOutline_(),this.drawInternals_(),t.setPath(this.outlinePath_+"\n"+this.inlinePath_),this.info_.RTL&&t.flipRTL(),T.blockRendering.useDebugger&&this.block_.renderingDebugger.drawDebug(this.block_,this.info_),this.recordSizeOnBlock_(),this.info_.outputConnection&&(t.outputShapeType=this.info_.outputConnection.shape.type),t.endDrawing()},T.zelos.Drawer.prototype.drawOutline_=function(){this.info_.outputConnection&&this.info_.outputConnection.isDynamicShape&&!this.info_.hasStatementInput&&!this.info_.bottomRow.hasNextConnection?(this.drawFlatTop_(),this.drawRightDynamicConnection_(),this.drawFlatBottom_(),this.drawLeftDynamicConnection_()):T.zelos.Drawer.superClass_.drawOutline_.call(this)},T.zelos.Drawer.prototype.drawLeft_=function(){this.info_.outputConnection&&this.info_.outputConnection.isDynamicShape?this.drawLeftDynamicConnection_():T.zelos.Drawer.superClass_.drawLeft_.call(this)},T.zelos.Drawer.prototype.drawRightSideRow_=function(t){var e,e;t.height<=0||(t.precedesStatement||t.followsStatement?(e=this.constants_.INSIDE_CORNERS.rightHeight,e=t.height-(t.precedesStatement?e:0),this.outlinePath_+=(t.followsStatement?this.constants_.INSIDE_CORNERS.pathBottomRight:"")+(0<e?T.utils.svgPaths.lineOnAxis("V",t.yPos+e):"")+(t.precedesStatement?this.constants_.INSIDE_CORNERS.pathTopRight:"")):this.outlinePath_+=T.utils.svgPaths.lineOnAxis("V",t.yPos+t.height))},T.zelos.Drawer.prototype.drawRightDynamicConnection_=function(){this.outlinePath_+=this.info_.outputConnection.shape.pathRightDown(this.info_.outputConnection.height)},T.zelos.Drawer.prototype.drawLeftDynamicConnection_=function(){this.positionOutputConnection_(),this.outlinePath_+=this.info_.outputConnection.shape.pathUp(this.info_.outputConnection.height),this.outlinePath_+="z"},T.zelos.Drawer.prototype.drawFlatTop_=function(){var t=this.info_.topRow;this.positionPreviousConnection_(),this.outlinePath_+=T.utils.svgPaths.moveBy(
t.xPos,this.info_.startY),this.outlinePath_+=T.utils.svgPaths.lineOnAxis("h",t.width)},T.zelos.Drawer.prototype.drawFlatBottom_=function(){var t=this.info_.bottomRow;this.positionNextConnection_(),this.outlinePath_+=T.utils.svgPaths.lineOnAxis("V",t.baseline),this.outlinePath_+=T.utils.svgPaths.lineOnAxis("h",-t.width)},T.zelos.Drawer.prototype.drawInlineInput_=function(t){this.positionInlineInputConnection_(t);var e=t.input.name,o;t.connectedBlock||this.info_.isInsertionMarker||(o=t.width-2*t.connectionWidth,t=T.utils.svgPaths.moveTo(t.xPos+t.connectionWidth,t.centerline-t.height/2)+T.utils.svgPaths.lineOnAxis("h",o)+t.shape.pathRightDown(t.height)+T.utils.svgPaths.lineOnAxis("h",-o)+t.shape.pathUp(t.height)+"z",this.block_.pathObject.setOutlinePath(e,t))},T.zelos.Drawer.prototype.drawStatementInput_=function(t){var e,o=(e=t.getLastInput()).xPos+e.notchOffset+e.shape.width,i=e.shape.pathRight+T.utils.svgPaths.lineOnAxis("h",-(e.notchOffset-this.constants_.INSIDE_CORNERS.width))+this.constants_.INSIDE_CORNERS.pathTop,s=t.height-2*this.constants_.INSIDE_CORNERS.height,e=this.constants_.INSIDE_CORNERS.pathBottom+T.utils.svgPaths.lineOnAxis("h",e.notchOffset-this.constants_.INSIDE_CORNERS.width)+(e.connectedBottomNextConnection?"":e.shape.pathLeft);this.outlinePath_+=T.utils.svgPaths.lineOnAxis("H",o)+i+T.utils.svgPaths.lineOnAxis("v",s)+e+T.utils.svgPaths.lineOnAxis("H",t.xPos+t.width),this.positionStatementInputConnection_(t)},T.zelos.MarkerSvg=function(t,e,o){T.zelos.MarkerSvg.superClass_.constructor.call(this,t,e,o)},T.utils.object.inherits(T.zelos.MarkerSvg,T.blockRendering.MarkerSvg),T.zelos.MarkerSvg.prototype.showWithInputOutput_=function(t){var e=t.getSourceBlock();t=t.getLocation().getOffsetInBlock(),this.positionCircle_(t.x,t.y),this.setParent_(e),this.showCurrent_()},T.zelos.MarkerSvg.prototype.showWithOutput_=function(t){this.showWithInputOutput_(t)},T.zelos.MarkerSvg.prototype.showWithInput_=function(t){this.showWithInputOutput_(t)},T.zelos.MarkerSvg.prototype.showWithBlock_=function(t){var e=(t=t.getLocation()).getHeightWidth();this.positionRect_(0,0,e.width,e.height),this.setParent_(t),this.showCurrent_()},T.zelos.MarkerSvg.prototype.positionCircle_=function(t,e){this.markerCircle_.setAttribute("cx",t),this.markerCircle_.setAttribute("cy",e),this.currentMarkerSvg=this.markerCircle_},T.zelos.MarkerSvg.prototype.hide=function(){T.zelos.MarkerSvg.superClass_.hide.call(this),this.markerCircle_.style.display="none"},T.zelos.MarkerSvg.prototype.createDomInternal_=function(){var t;return T.zelos.MarkerSvg.superClass_.createDomInternal_.call(this),this.markerCircle_=T.utils.dom.createSvgElement(T.utils.Svg.CIRCLE,{r:this.constants_.CURSOR_RADIUS,style:"display: none","stroke-width":this.constants_.CURSOR_STROKE_WIDTH},this.markerSvg_),this.isCursor()&&(t=this.getBlinkProperties_(),T.utils.dom.createSvgElement(T.utils.Svg.ANIMATE,t,this.markerCircle_)),this.markerSvg_},T.zelos.MarkerSvg.prototype.applyColour_=function(t){T.zelos.MarkerSvg.superClass_.applyColour_.call(this,t),this.markerCircle_.setAttribute("fill",this.colour_),this.markerCircle_.setAttribute("stroke",this.colour_),this.isCursor()&&this.markerCircle_.firstChild.setAttribute("values",this.colour_+";transparent;transparent;")},T.zelos.PathObject=function(t,e,o){T.zelos.PathObject.superClass_.constructor.call(this,t,e,o),this.constants=o,this.svgPathSelected_=null,this.outlines_={},this.outputShapeType=this.remainingOutlines_=null},T.utils.object.inherits(T.zelos.PathObject,T.blockRendering.PathObject),T.zelos.PathObject.prototype.setPath=function(t){T.zelos.PathObject.superClass_.setPath.call(this,t),this.svgPathSelected_&&this.svgPathSelected_.setAttribute("d",t)},T.zelos.PathObject.prototype.applyColour=function(t){T.zelos.PathObject.superClass_.applyColour.call(this,t),t.isShadow()&&t.getParent()&&this.svgPath.setAttribute("stroke",t.getParent().style.colourTertiary),t=0;for(var e=Object.keys(this.outlines_),o;o=e[t];t++)this.outlines_[o].setAttribute("fill",this.style.colourTertiary)},T.zelos.PathObject.prototype.flipRTL=function(){T.zelos.PathObject.superClass_.flipRTL.call(this);for(var t=0,e=Object.keys(this.outlines_),o;o=e[t];t++)this.outlines_[o].setAttribute("transform","scale(-1 1)")},T.zelos.PathObject.prototype.updateSelected=function(t){this.setClass_("blocklySelected",t),t?this.svgPathSelected_||(this.svgPathSelected_=this.svgPath.cloneNode(!0),this.svgPathSelected_.setAttribute("fill","none"),this.svgPathSelected_.setAttribute("filter","url(#"+this.constants.selectedGlowFilterId+")"),this.svgRoot.appendChild(this.svgPathSelected_)):this.svgPathSelected_&&(this.svgRoot.removeChild(this.svgPathSelected_),this.svgPathSelected_=null)},T.zelos.PathObject.prototype.updateReplacementFade=function(t){this.setClass_("blocklyReplaceable",t),t?this.svgPath.setAttribute("filter","url(#"+this.constants.replacementGlowFilterId+")"):this.svgPath.removeAttribute("filter")},T.zelos.PathObject.prototype.updateShapeForInputHighlight=function(t,e){t=t.getParentInput().name,(t=this.getOutlinePath_(t))&&(e?t.setAttribute("filter","url(#"+this.constants.replacementGlowFilterId+")"):t.removeAttribute("filter"))},T.zelos.PathObject.prototype.beginDrawing=function(){this.remainingOutlines_={};for(var t=0,e=Object.keys(this.outlines_),o;o=e[t];t++)this.remainingOutlines_[o]=1},T.zelos.PathObject.prototype.endDrawing=function(){if(this.remainingOutlines_)for(var t=0,e=Object.keys(this.remainingOutlines_),o;o=e[t];t++)this.removeOutlinePath_(o);this.remainingOutlines_=null},T.zelos.PathObject.prototype.setOutlinePath=function(t,e){(t=this.getOutlinePath_(t)).setAttribute("d",e),t.setAttribute("fill",this.style.colourTertiary)},T.zelos.PathObject.prototype.getOutlinePath_=function(t){return this.outlines_[t]||(this.outlines_[t]=T.utils.dom.createSvgElement(T.utils.Svg.PATH,{class:"blocklyOutlinePath",d:""},this.svgRoot)),this.remainingOutlines_&&delete this.remainingOutlines_[t],this.outlines_[t]},T.zelos.PathObject.prototype.removeOutlinePath_=function(t){this.outlines_[t].parentNode.removeChild(this.outlines_[t]),delete this.outlines_[t]},T.zelos.Renderer=function(t){T.zelos.Renderer.superClass_.constructor.call(this,t)},T.utils.object.inherits(T.zelos.Renderer,T.blockRendering.Renderer),T.zelos.Renderer.prototype.makeConstants_=function(){return new T.zelos.ConstantProvider},T.zelos.Renderer.prototype.makeRenderInfo_=function(t){return new T.zelos.RenderInfo(this,t)},T.zelos.Renderer.prototype.makeDrawer_=function(t,e){return new T.zelos.Drawer(t,e)},T.zelos.Renderer.prototype.makeMarkerDrawer=function(t,e){return new T.zelos.MarkerSvg(t,this.getConstants(),e)},T.zelos.Renderer.prototype.makePathObject=function(t,e){return new T.zelos.PathObject(t,e,this.getConstants())},T.zelos.Renderer.prototype.shouldHighlightConnection=function(t){return t.type!=T.connectionTypes.INPUT_VALUE&&t.type!==T.connectionTypes.OUTPUT_VALUE},T.zelos.Renderer.prototype.getConnectionPreviewMethod=function(t,e,o){return e.type==T.connectionTypes.OUTPUT_VALUE?t.isConnected()?T.InsertionMarkerManager.PREVIEW_TYPE.REPLACEMENT_FADE:T.InsertionMarkerManager.PREVIEW_TYPE.INPUT_OUTLINE:T.zelos.Renderer.superClass_.getConnectionPreviewMethod(t,e,o)},T.blockRendering.register("zelos",T.zelos.Renderer),T.Themes.Dark=T.Theme.defineTheme("dark",{base:T.Themes.Classic,componentStyles:{workspaceBackgroundColour:"#1e1e1e",toolboxBackgroundColour:"blackBackground",toolboxForegroundColour:"#fff",flyoutBackgroundColour:"#252526",flyoutForegroundColour:"#ccc",flyoutOpacity:1,scrollbarColour:"#797979",insertionMarkerColour:"#fff",insertionMarkerOpacity:.3,scrollbarOpacity:.4,cursorColour:"#d0d0d0",blackBackground:"#333"}}),T.Themes.Deuteranopia={},T.Themes.Deuteranopia.defaultBlockStyles={colour_blocks:{colourPrimary:"#f2a72c",colourSecondary:"#f1c172",colourTertiary:"#da921c"},list_blocks:{colourPrimary:"#7d65ab",colourSecondary:"#a88be0",colourTertiary:"#66518e"},logic_blocks:{colourPrimary:"#9fd2f1",colourSecondary:"#c0e0f4",colourTertiary:"#74bae5"},loop_blocks:{colourPrimary:"#795a07",colourSecondary:"#ac8726",colourTertiary:"#c4a03f"},math_blocks:{colourPrimary:"#e6da39",colourSecondary:"#f3ec8e",colourTertiary:"#f2eeb7"},procedure_blocks:{colourPrimary:"#590721",colourSecondary:"#8c475d",colourTertiary:"#885464"},text_blocks:{colourPrimary:"#058863",colourSecondary:"#5ecfaf",colourTertiary:"#04684c"},variable_blocks:{colourPrimary:"#47025a",colourSecondary:"#820fa1",colourTertiary:"#8e579d"},variable_dynamic_blocks:{colourPrimary:"#47025a",colourSecondary:"#820fa1",colourTertiary:"#8e579d"}},T.Themes.Deuteranopia.categoryStyles={colour_category:{colour:"#f2a72c"},list_category:{colour:"#7d65ab"},logic_category:{colour:"#9fd2f1"},loop_category:{colour:"#795a07"},math_category:{colour:"#e6da39"},procedure_category:{colour:"#590721"},text_category:{colour:"#058863"},variable_category:{colour:"#47025a"},variable_dynamic_category:{colour:"#47025a"}},T.Themes.Deuteranopia=new T.Theme("deuteranopia",T.Themes.Deuteranopia.defaultBlockStyles,T.Themes.Deuteranopia.categoryStyles),T.Themes.HighContrast={},T.Themes.HighContrast.defaultBlockStyles={colour_blocks:{colourPrimary:"#a52714",colourSecondary:"#FB9B8C",colourTertiary:"#FBE1DD"},list_blocks:{colourPrimary:"#4a148c",colourSecondary:"#AD7BE9",colourTertiary:"#CDB6E9"},logic_blocks:{colourPrimary:"#01579b",colourSecondary:"#64C7FF",colourTertiary:"#C5EAFF"},loop_blocks:{colourPrimary:"#33691e",colourSecondary:"#9AFF78",colourTertiary:"#E1FFD7"},math_blocks:{colourPrimary:"#1a237e",colourSecondary:"#8A9EFF",colourTertiary:"#DCE2FF"},procedure_blocks:{colourPrimary:"#006064",colourSecondary:"#77E6EE",colourTertiary:"#CFECEE"},text_blocks:{colourPrimary:"#004d40",colourSecondary:"#5ae27c",colourTertiary:"#D2FFDD"},variable_blocks:{colourPrimary:"#880e4f",colourSecondary:"#FF73BE",colourTertiary:"#FFD4EB"},variable_dynamic_blocks:{colourPrimary:"#880e4f",colourSecondary:"#FF73BE",colourTertiary:"#FFD4EB"},hat_blocks:{colourPrimary:"#880e4f",colourSecondary:"#FF73BE",colourTertiary:"#FFD4EB",hat:"cap"}},T.Themes.HighContrast.categoryStyles={colour_category:{colour:"#a52714"},list_category:{colour:"#4a148c"},logic_category:{colour:"#01579b"},loop_category:{colour:"#33691e"},math_category:{colour:"#1a237e"},procedure_category:{colour:"#006064"},text_category:{colour:"#004d40"},variable_category:{colour:"#880e4f"},variable_dynamic_category:{colour:"#880e4f"}},T.Themes.HighContrast=new T.Theme("highcontrast",T.Themes.HighContrast.defaultBlockStyles,T.Themes.HighContrast.categoryStyles),T.Themes.HighContrast.setComponentStyle("selectedGlowColour","#000000"),T.Themes.HighContrast.setComponentStyle("selectedGlowSize",1),T.Themes.HighContrast.setComponentStyle("replacementGlowColour","#000000"),T.Themes.HighContrast.setFontStyle({family:null,weight:null,size:16}),T.Themes.Tritanopia={},T.Themes.Tritanopia.defaultBlockStyles={colour_blocks:{colourPrimary:"#05427f",colourSecondary:"#2974c0",colourTertiary:"#2d74bb"},list_blocks:{colourPrimary:"#b69ce8",colourSecondary:"#ccbaef",colourTertiary:"#9176c5"},logic_blocks:{colourPrimary:"#9fd2f1",colourSecondary:"#c0e0f4",colourTertiary:"#74bae5"},loop_blocks:{colourPrimary:"#aa1846",colourSecondary:"#d36185",colourTertiary:"#7c1636"},math_blocks:{colourPrimary:"#e6da39",colourSecondary:"#f3ec8e",colourTertiary:"#f2eeb7"},procedure_blocks:{colourPrimary:"#590721",colourSecondary:"#8c475d",colourTertiary:"#885464"},text_blocks:{colourPrimary:"#058863",colourSecondary:"#5ecfaf",colourTertiary:"#04684c"},variable_blocks:{colourPrimary:"#4b2d84",colourSecondary:"#816ea7",colourTertiary:"#83759e"},variable_dynamic_blocks:{colourPrimary:"#4b2d84",colourSecondary:"#816ea7",colourTertiary:"#83759e"}},T.Themes.Tritanopia.categoryStyles={colour_category:{colour:"#05427f"},list_category:{colour:"#b69ce8"},logic_category:{colour:"#9fd2f1"},loop_category:{colour:"#aa1846"},math_category:{colour:"#e6da39"},procedure_category:{colour:"#590721"},text_category:{colour:"#058863"},variable_category:{colour:"#4b2d84"},variable_dynamic_category:{colour:"#4b2d84"}},T.Themes.Tritanopia=new T.Theme("tritanopia",T.Themes.Tritanopia.defaultBlockStyles,T.Themes.Tritanopia.categoryStyles),T.requires={},T.Blocks.colour={},T.Constants={},T.Constants.Colour={},T.Constants.Colour.HUE=20,T.defineBlocksWithJsonArray([{type:"colour_picker",message0:"%1",args0:[{type:"field_colour",name:"COLOUR",colour:"#ff0000"}],output:"Colour",helpUrl:"%{BKY_COLOUR_PICKER_HELPURL}",style:"colour_blocks",tooltip:"%{BKY_COLOUR_PICKER_TOOLTIP}",extensions:["parent_tooltip_when_inline"]},{type:"colour_random",message0:"%{BKY_COLOUR_RANDOM_TITLE}",output:"Colour",helpUrl:"%{BKY_COLOUR_RANDOM_HELPURL}",style:"colour_blocks",tooltip:"%{BKY_COLOUR_RANDOM_TOOLTIP}"},{type:"colour_rgb",message0:"%{BKY_COLOUR_RGB_TITLE} %{BKY_COLOUR_RGB_RED} %1 %{BKY_COLOUR_RGB_GREEN} %2 %{BKY_COLOUR_RGB_BLUE} %3",args0:[{type:"input_value",name:"RED",check:"Number",align:"RIGHT"},{type:"input_value",name:"GREEN",check:"Number",align:"RIGHT"},{type:"input_value",name:"BLUE",check:"Number",align:"RIGHT"}],output:"Colour",helpUrl:"%{BKY_COLOUR_RGB_HELPURL}",style:"colour_blocks",tooltip:"%{BKY_COLOUR_RGB_TOOLTIP}"},{type:"colour_blend",message0:"%{BKY_COLOUR_BLEND_TITLE} %{BKY_COLOUR_BLEND_COLOUR1} %1 %{BKY_COLOUR_BLEND_COLOUR2} %2 %{BKY_COLOUR_BLEND_RATIO} %3",args0:[{type:"input_value",name:"COLOUR1",check:"Colour",align:"RIGHT"},{type:"input_value",name:"COLOUR2",check:"Colour",align:"RIGHT"},{type:"input_value",name:"RATIO",check:"Number",align:"RIGHT"}],output:"Colour",helpUrl:"%{BKY_COLOUR_BLEND_HELPURL}",style:"colour_blocks",tooltip:"%{BKY_COLOUR_BLEND_TOOLTIP}"}]),T.Blocks.lists={},T.Constants.Lists={},T.Constants.Lists.HUE=260,T.defineBlocksWithJsonArray([{type:"lists_create_empty",message0:"%{BKY_LISTS_CREATE_EMPTY_TITLE}",output:"Array",style:"list_blocks",tooltip:"%{BKY_LISTS_CREATE_EMPTY_TOOLTIP}",helpUrl:"%{BKY_LISTS_CREATE_EMPTY_HELPURL}"},{type:"lists_repeat",message0:"%{BKY_LISTS_REPEAT_TITLE}",args0:[{type:"input_value",name:"ITEM"},{type:"input_value",name:"NUM",check:"Number"}],output:"Array",style:"list_blocks",tooltip:"%{BKY_LISTS_REPEAT_TOOLTIP}",helpUrl:"%{BKY_LISTS_REPEAT_HELPURL}"},{type:"lists_reverse",message0:"%{BKY_LISTS_REVERSE_MESSAGE0}",args0:[{type:"input_value",name:"LIST",check:"Array"}],output:"Array",inputsInline:!0,style:"list_blocks",tooltip:"%{BKY_LISTS_REVERSE_TOOLTIP}",helpUrl:"%{BKY_LISTS_REVERSE_HELPURL}"},{type:"lists_isEmpty",message0:"%{BKY_LISTS_ISEMPTY_TITLE}",args0:[{type:"input_value",name:"VALUE",check:["String","Array"]}],output:"Boolean",style:"list_blocks",tooltip:"%{BKY_LISTS_ISEMPTY_TOOLTIP}",helpUrl:"%{BKY_LISTS_ISEMPTY_HELPURL}"},{type:"lists_length",message0:"%{BKY_LISTS_LENGTH_TITLE}",args0:[{type:"input_value",name:"VALUE",check:["String","Array"]}],output:"Number",style:"list_blocks",tooltip:"%{BKY_LISTS_LENGTH_TOOLTIP}",helpUrl:"%{BKY_LISTS_LENGTH_HELPURL}"}]),T.Blocks.lists_create_with={init:function(){this.setHelpUrl(T.Msg.LISTS_CREATE_WITH_HELPURL),this.setStyle("list_blocks"),this.itemCount_=3,this.updateShape_(),this.setOutput(!0,"Array"),this.setMutator(new T.Mutator(["lists_create_with_item"])),this.setTooltip(T.Msg.LISTS_CREATE_WITH_TOOLTIP)},mutationToDom:function(){var t=T.utils.xml.createElement("mutation");return t.setAttribute("items",this.itemCount_),t},domToMutation:function(t){this.itemCount_=parseInt(t.getAttribute("items"),10),this.updateShape_()},decompose:function(t){var e=t.newBlock("lists_create_with_container");e.initSvg();for(var o=e.getInput("STACK").connection,i=0;i<this.itemCount_;i++){var s=t.newBlock("lists_create_with_item");s.initSvg(),o.connect(s.previousConnection),o=s.nextConnection}return e},compose:function(t){var e=t.getInputTargetBlock("STACK");for(t=[];e&&!e.isInsertionMarker();)t.push(e.valueConnection_),e=e.nextConnection&&e.nextConnection.targetBlock();for(e=0;e<this.itemCount_;e++){var o=this.getInput("ADD"+e).connection.targetConnection;o&&-1==t.indexOf(o)&&o.disconnect()}for(this.itemCount_=t.length,this.updateShape_(),e=0;e<this.itemCount_;e++)T.Mutator.reconnect(t[e],this,"ADD"+e)},saveConnections:function(t){t=t.getInputTargetBlock("STACK");for(var e=0;t;){var o=this.getInput("ADD"+e);t.valueConnection_=o&&o.connection.targetConnection,e++,t=t.nextConnection&&t.nextConnection.targetBlock()}},updateShape_:function(){this.itemCount_&&this.getInput("EMPTY")?this.removeInput("EMPTY"):this.itemCount_||this.getInput("EMPTY")||this.appendDummyInput("EMPTY").appendField(T.Msg.LISTS_CREATE_EMPTY_TITLE);for(var t=0,e;t<this.itemCount_;t++){this.getInput("ADD"+t)||(e=this.appendValueInput("ADD"+t).setAlign(T.ALIGN_RIGHT),0==t&&e.appendField(T.Msg.LISTS_CREATE_WITH_INPUT_WITH))}for(;this.getInput("ADD"+t);)this.removeInput("ADD"+t),t++}},T.Blocks.lists_create_with_container={init:function(){this.setStyle("list_blocks"),this.appendDummyInput().appendField(T.Msg.LISTS_CREATE_WITH_CONTAINER_TITLE_ADD),this.appendStatementInput("STACK"),this.setTooltip(T.Msg.LISTS_CREATE_WITH_CONTAINER_TOOLTIP),this.contextMenu=!1}},T.Blocks.lists_create_with_item={init:function(){this.setStyle("list_blocks"),this.appendDummyInput().appendField(T.Msg.LISTS_CREATE_WITH_ITEM_TITLE),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setTooltip(T.Msg.LISTS_CREATE_WITH_ITEM_TOOLTIP),this.contextMenu=!1}},T.Blocks.lists_indexOf={init:function(){var t=[[T.Msg.LISTS_INDEX_OF_FIRST,"FIRST"],[T.Msg.LISTS_INDEX_OF_LAST,"LAST"]],e=(this.setHelpUrl(T.Msg.LISTS_INDEX_OF_HELPURL),this.setStyle("list_blocks"),this.setOutput(!0,"Number"),this.appendValueInput("VALUE").setCheck("Array").appendField(T.Msg.LISTS_INDEX_OF_INPUT_IN_LIST),this.appendValueInput("FIND").appendField(new T.FieldDropdown(t),"END"),this.setInputsInline(!0),this);this.setTooltip(function(){return T.Msg.LISTS_INDEX_OF_TOOLTIP.replace("%1",e.workspace.options.oneBasedIndex?"0":"-1")})}},T.Blocks.lists_getIndex={init:function(){var t=[[T.Msg.LISTS_GET_INDEX_GET,"GET"],[T.Msg.LISTS_GET_INDEX_GET_REMOVE,"GET_REMOVE"],[T.Msg.LISTS_GET_INDEX_REMOVE,"REMOVE"]],i=(this.WHERE_OPTIONS=[[T.Msg.LISTS_GET_INDEX_FROM_START,"FROM_START"],[T.Msg.LISTS_GET_INDEX_FROM_END,"FROM_END"],[T.Msg.LISTS_GET_INDEX_FIRST,"FIRST"],[T.Msg.LISTS_GET_INDEX_LAST,"LAST"],[T.Msg.LISTS_GET_INDEX_RANDOM,"RANDOM"]],this.setHelpUrl(T.Msg.LISTS_GET_INDEX_HELPURL),this.setStyle("list_blocks"),t=new T.FieldDropdown(t,function(t){t="REMOVE"==t,this.getSourceBlock().updateStatement_(t)}),this.appendValueInput("VALUE").setCheck("Array").appendField(T.Msg.LISTS_GET_INDEX_INPUT_IN_LIST),this.appendDummyInput().appendField(t,"MODE").appendField("","SPACE"),this.appendDummyInput("AT"),T.Msg.LISTS_GET_INDEX_TAIL&&this.appendDummyInput("TAIL").appendField(T.Msg.LISTS_GET_INDEX_TAIL),this.setInputsInline(!0),this.setOutput(!0),this.updateAt_(!0),this);this.setTooltip(function(){var t=i.getFieldValue("MODE"),e=i.getFieldValue("WHERE"),o="";switch(t+" "+e){case"GET FROM_START":case"GET FROM_END":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_GET_FROM;break;case"GET FIRST":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_GET_FIRST;break;case"GET LAST":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_GET_LAST;break;case"GET RANDOM":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_GET_RANDOM;break;case"GET_REMOVE FROM_START":case"GET_REMOVE FROM_END":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_FROM;break;case"GET_REMOVE FIRST":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_FIRST;break;case"GET_REMOVE LAST":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_LAST;break;case"GET_REMOVE RANDOM":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_RANDOM;break;case"REMOVE FROM_START":case"REMOVE FROM_END":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_REMOVE_FROM;break;case"REMOVE FIRST":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_REMOVE_FIRST;break;case"REMOVE LAST":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_REMOVE_LAST;break;case"REMOVE RANDOM":o=T.Msg.LISTS_GET_INDEX_TOOLTIP_REMOVE_RANDOM}return"FROM_START"!=e&&"FROM_END"!=e||(o+="  "+("FROM_START"==e?T.Msg.LISTS_INDEX_FROM_START_TOOLTIP:T.Msg.LISTS_INDEX_FROM_END_TOOLTIP).replace("%1",i.workspace.options.oneBasedIndex?"#1":"#0")),o})},mutationToDom:function(){var t=T.utils.xml.createElement("mutation"),e=(t.setAttribute("statement",!this.outputConnection),this.getInput("AT").type==T.INPUT_VALUE);return t.setAttribute("at",e),t},domToMutation:function(t){var e="true"==t.getAttribute("statement");this.updateStatement_(e),t="false"!=t.getAttribute("at"),this.updateAt_(t)},updateStatement_:function(t){t!=!this.outputConnection&&(this.unplug(!0,!0),t?(this.setOutput(!1),this.setPreviousStatement(!0),this.setNextStatement(!0)):(this.setPreviousStatement(!1),this.setNextStatement(!1),this.setOutput(!0)))},updateAt_:function(i){this.removeInput("AT"),this.removeInput("ORDINAL",!0),i?(this.appendValueInput("AT").setCheck("Number"),T.Msg.ORDINAL_NUMBER_SUFFIX&&this.appendDummyInput("ORDINAL").appendField(T.Msg.ORDINAL_NUMBER_SUFFIX)):this.appendDummyInput("AT");var t=new T.FieldDropdown(this.WHERE_OPTIONS,function(t){var e="FROM_START"==t||"FROM_END"==t,o;if(e!=i)return(o=this.getSourceBlock()).updateAt_(e),o.setFieldValue(t,"WHERE"),null});this.getInput("AT").appendField(t,"WHERE"),T.Msg.LISTS_GET_INDEX_TAIL&&this.moveInputBefore("TAIL",null)}},T.Blocks.lists_setIndex={init:function(){var t=[[T.Msg.LISTS_SET_INDEX_SET,"SET"],[T.Msg.LISTS_SET_INDEX_INSERT,"INSERT"]],i=(this.WHERE_OPTIONS=[[T.Msg.LISTS_GET_INDEX_FROM_START,"FROM_START"],[T.Msg.LISTS_GET_INDEX_FROM_END,"FROM_END"],[T.Msg.LISTS_GET_INDEX_FIRST,"FIRST"],[T.Msg.LISTS_GET_INDEX_LAST,"LAST"],[T.Msg.LISTS_GET_INDEX_RANDOM,"RANDOM"]],this.setHelpUrl(T.Msg.LISTS_SET_INDEX_HELPURL),this.setStyle("list_blocks"),this.appendValueInput("LIST").setCheck("Array").appendField(T.Msg.LISTS_SET_INDEX_INPUT_IN_LIST),this.appendDummyInput().appendField(new T.FieldDropdown(t),"MODE").appendField("","SPACE"),this.appendDummyInput("AT"),this.appendValueInput("TO").appendField(T.Msg.LISTS_SET_INDEX_INPUT_TO),this.setInputsInline(!0),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setTooltip(T.Msg.LISTS_SET_INDEX_TOOLTIP),this.updateAt_(!0),this);this.setTooltip(function(){var t=i.getFieldValue("MODE"),e=i.getFieldValue("WHERE"),o="";switch(t+" "+e){case"SET FROM_START":case"SET FROM_END":o=T.Msg.LISTS_SET_INDEX_TOOLTIP_SET_FROM;break;case"SET FIRST":o=T.Msg.LISTS_SET_INDEX_TOOLTIP_SET_FIRST;break;case"SET LAST":o=T.Msg.LISTS_SET_INDEX_TOOLTIP_SET_LAST;break;case"SET RANDOM":o=T.Msg.LISTS_SET_INDEX_TOOLTIP_SET_RANDOM;break;case"INSERT FROM_START":case"INSERT FROM_END":o=T.Msg.LISTS_SET_INDEX_TOOLTIP_INSERT_FROM;break;case"INSERT FIRST":o=T.Msg.LISTS_SET_INDEX_TOOLTIP_INSERT_FIRST;break;case"INSERT LAST":o=T.Msg.LISTS_SET_INDEX_TOOLTIP_INSERT_LAST;break;case"INSERT RANDOM":o=T.Msg.LISTS_SET_INDEX_TOOLTIP_INSERT_RANDOM}return"FROM_START"!=e&&"FROM_END"!=e||(o+="  "+T.Msg.LISTS_INDEX_FROM_START_TOOLTIP.replace("%1",i.workspace.options.oneBasedIndex?"#1":"#0")),o})},mutationToDom:function(){var t=T.utils.xml.createElement("mutation"),e=this.getInput("AT").type==T.INPUT_VALUE;return t.setAttribute("at",e),t},domToMutation:function(t){t="false"!=t.getAttribute("at"),this.updateAt_(t)},updateAt_:function(i){this.removeInput("AT"),this.removeInput("ORDINAL",!0),i?(this.appendValueInput("AT").setCheck("Number"),T.Msg.ORDINAL_NUMBER_SUFFIX&&this.appendDummyInput("ORDINAL").appendField(T.Msg.ORDINAL_NUMBER_SUFFIX)):this.appendDummyInput("AT");var t=new T.FieldDropdown(this.WHERE_OPTIONS,function(t){var e="FROM_START"==t||"FROM_END"==t,o;if(e!=i)return(o=this.getSourceBlock()).updateAt_(e),o.setFieldValue(t,"WHERE"),null});this.moveInputBefore("AT","TO"),this.getInput("ORDINAL")&&this.moveInputBefore("ORDINAL","TO"),this.getInput("AT").appendField(t,"WHERE")}},T.Blocks.lists_getSublist={init:function(){this.WHERE_OPTIONS_1=[[T.Msg.LISTS_GET_SUBLIST_START_FROM_START,"FROM_START"],[T.Msg.LISTS_GET_SUBLIST_START_FROM_END,"FROM_END"],[T.Msg.LISTS_GET_SUBLIST_START_FIRST,"FIRST"]],this.WHERE_OPTIONS_2=[[T.Msg.LISTS_GET_SUBLIST_END_FROM_START,"FROM_START"],[T.Msg.LISTS_GET_SUBLIST_END_FROM_END,"FROM_END"],[T.Msg.LISTS_GET_SUBLIST_END_LAST,"LAST"]],this.setHelpUrl(T.Msg.LISTS_GET_SUBLIST_HELPURL),this.setStyle("list_blocks"),this.appendValueInput("LIST").setCheck("Array").appendField(T.Msg.LISTS_GET_SUBLIST_INPUT_IN_LIST),this.appendDummyInput("AT1"),this.appendDummyInput("AT2"),T.Msg.LISTS_GET_SUBLIST_TAIL&&this.appendDummyInput("TAIL").appendField(T.Msg.LISTS_GET_SUBLIST_TAIL),this.setInputsInline(!0),this.setOutput(!0,"Array"),this.updateAt_(1,!0),this.updateAt_(2,!0),this.setTooltip(T.Msg.LISTS_GET_SUBLIST_TOOLTIP)},mutationToDom:function(){var t=T.utils.xml.createElement("mutation"),e=this.getInput("AT1").type==T.INPUT_VALUE;return t.setAttribute("at1",e),e=this.getInput("AT2").type==T.INPUT_VALUE,t.setAttribute("at2",e),t},domToMutation:function(t){var e="true"==t.getAttribute("at1");t="true"==t.getAttribute("at2"),this.updateAt_(1,e),this.updateAt_(2,t)},updateAt_:function(i,s){this.removeInput("AT"+i),this.removeInput("ORDINAL"+i,!0),s?(this.appendValueInput("AT"+i).setCheck("Number"),T.Msg.ORDINAL_NUMBER_SUFFIX&&this.appendDummyInput("ORDINAL"+i).appendField(T.Msg.ORDINAL_NUMBER_SUFFIX)):this.appendDummyInput("AT"+i);var t=new T.FieldDropdown(this["WHERE_OPTIONS_"+i],function(t){var e="FROM_START"==t||"FROM_END"==t,o;if(e!=s)return(o=this.getSourceBlock()).updateAt_(i,e),o.setFieldValue(t,"WHERE"+i),null});this.getInput("AT"+i).appendField(t,"WHERE"+i),1==i&&(this.moveInputBefore("AT1","AT2"),this.getInput("ORDINAL1"))&&this.moveInputBefore("ORDINAL1","AT2"),T.Msg.LISTS_GET_SUBLIST_TAIL&&this.moveInputBefore("TAIL",null)}},T.Blocks.lists_sort={init:function(){this.jsonInit({message0:T.Msg.LISTS_SORT_TITLE,args0:[{type:"field_dropdown",name:"TYPE",options:[[T.Msg.LISTS_SORT_TYPE_NUMERIC,"NUMERIC"],[T.Msg.LISTS_SORT_TYPE_TEXT,"TEXT"],[T.Msg.LISTS_SORT_TYPE_IGNORECASE,"IGNORE_CASE"]]},{type:"field_dropdown",name:"DIRECTION",options:[[T.Msg.LISTS_SORT_ORDER_ASCENDING,"1"],[T.Msg.LISTS_SORT_ORDER_DESCENDING,"-1"]]},{type:"input_value",name:"LIST",check:"Array"}],output:"Array",style:"list_blocks",tooltip:T.Msg.LISTS_SORT_TOOLTIP,helpUrl:T.Msg.LISTS_SORT_HELPURL})}},T.Blocks.lists_split={init:function(){var e=this,t=new T.FieldDropdown([[T.Msg.LISTS_SPLIT_LIST_FROM_TEXT,"SPLIT"],[T.Msg.LISTS_SPLIT_TEXT_FROM_LIST,"JOIN"]],function(t){e.updateType_(t)});this.setHelpUrl(T.Msg.LISTS_SPLIT_HELPURL),this.setStyle("list_blocks"),this.appendValueInput("INPUT").setCheck("String").appendField(t,"MODE"),this.appendValueInput("DELIM").setCheck("String").appendField(T.Msg.LISTS_SPLIT_WITH_DELIMITER),this.setInputsInline(!0),this.setOutput(!0,"Array"),this.setTooltip(function(){var t=e.getFieldValue("MODE");if("SPLIT"==t)return T.Msg.LISTS_SPLIT_TOOLTIP_SPLIT;if("JOIN"==t)return T.Msg.LISTS_SPLIT_TOOLTIP_JOIN;throw Error("Unknown mode: "+t)})},updateType_:function(t){var e,o;this.getFieldValue("MODE")!=t&&((e=this.getInput("INPUT").connection).setShadowDom(null),o=e.targetBlock())&&(e.disconnect(),o.isShadow()?o.dispose():this.bumpNeighbours()),"SPLIT"==t?(this.outputConnection.setCheck("Array"),this.getInput("INPUT").setCheck("String")):(this.outputConnection.setCheck("String"),this.getInput("INPUT").setCheck("Array"))},mutationToDom:function(){var t=T.utils.xml.createElement("mutation");return t.setAttribute("mode",this.getFieldValue("MODE")),t},domToMutation:function(t){this.updateType_(t.getAttribute("mode"))}},T.Blocks.logic={},T.Constants.Logic={},T.Constants.Logic.HUE=210,T.defineBlocksWithJsonArray([{type:"logic_boolean",message0:"%1",args0:[{type:"field_dropdown",name:"BOOL",options:[["%{BKY_LOGIC_BOOLEAN_TRUE}","TRUE"],["%{BKY_LOGIC_BOOLEAN_FALSE}","FALSE"]]}],output:"Boolean",style:"logic_blocks",tooltip:"%{BKY_LOGIC_BOOLEAN_TOOLTIP}",helpUrl:"%{BKY_LOGIC_BOOLEAN_HELPURL}"},{type:"controls_if",message0:"%{BKY_CONTROLS_IF_MSG_IF} %1",args0:[{type:"input_value",name:"IF0",check:"Boolean"}],message1:"%{BKY_CONTROLS_IF_MSG_THEN} %1",args1:[{type:"input_statement",name:"DO0"}],previousStatement:null,nextStatement:null,style:"logic_blocks",helpUrl:"%{BKY_CONTROLS_IF_HELPURL}",mutator:"controls_if_mutator",extensions:["controls_if_tooltip"]},{type:"controls_ifelse",message0:"%{BKY_CONTROLS_IF_MSG_IF} %1",args0:[{type:"input_value",name:"IF0",check:"Boolean"}],message1:"%{BKY_CONTROLS_IF_MSG_THEN} %1",args1:[{type:"input_statement",name:"DO0"}],message2:"%{BKY_CONTROLS_IF_MSG_ELSE} %1",args2:[{type:"input_statement",name:"ELSE"}],previousStatement:null,nextStatement:null,style:"logic_blocks",tooltip:"%{BKYCONTROLS_IF_TOOLTIP_2}",helpUrl:"%{BKY_CONTROLS_IF_HELPURL}",extensions:["controls_if_tooltip"]},{type:"logic_compare",message0:"%1 %2 %3",args0:[{type:"input_value",name:"A"},{type:"field_dropdown",name:"OP",options:[["=","EQ"],["≠","NEQ"],["‏<","LT"],["‏≤","LTE"],["‏>","GT"],["‏≥","GTE"]]},{type:"input_value",name:"B"}],inputsInline:!0,output:"Boolean",style:"logic_blocks",helpUrl:"%{BKY_LOGIC_COMPARE_HELPURL}",extensions:["logic_compare","logic_op_tooltip"]},{type:"logic_operation",message0:"%1 %2 %3",args0:[{type:"input_value",name:"A",check:"Boolean"},{type:"field_dropdown",name:"OP",options:[["%{BKY_LOGIC_OPERATION_AND}","AND"],["%{BKY_LOGIC_OPERATION_OR}","OR"]]},{type:"input_value",name:"B",check:"Boolean"}],inputsInline:!0,output:"Boolean",style:"logic_blocks",helpUrl:"%{BKY_LOGIC_OPERATION_HELPURL}",extensions:["logic_op_tooltip"]},{type:"logic_negate",message0:"%{BKY_LOGIC_NEGATE_TITLE}",args0:[{type:"input_value",name:"BOOL",check:"Boolean"}],output:"Boolean",style:"logic_blocks",tooltip:"%{BKY_LOGIC_NEGATE_TOOLTIP}",helpUrl:"%{BKY_LOGIC_NEGATE_HELPURL}"},{type:"logic_null",message0:"%{BKY_LOGIC_NULL}",output:null,style:"logic_blocks",tooltip:"%{BKY_LOGIC_NULL_TOOLTIP}",helpUrl:"%{BKY_LOGIC_NULL_HELPURL}"},{type:"logic_ternary",message0:"%{BKY_LOGIC_TERNARY_CONDITION} %1",args0:[{type:"input_value",name:"IF",check:"Boolean"}],message1:"%{BKY_LOGIC_TERNARY_IF_TRUE} %1",args1:[{type:"input_value",name:"THEN"}],message2:"%{BKY_LOGIC_TERNARY_IF_FALSE} %1",args2:[{type:"input_value",name:"ELSE"}],output:null,style:"logic_blocks",tooltip:"%{BKY_LOGIC_TERNARY_TOOLTIP}",helpUrl:"%{BKY_LOGIC_TERNARY_HELPURL}",extensions:["logic_ternary"]}]),T.defineBlocksWithJsonArray([{type:"controls_if_if",message0:"%{BKY_CONTROLS_IF_IF_TITLE_IF}",nextStatement:null,enableContextMenu:!1,style:"logic_blocks",tooltip:"%{BKY_CONTROLS_IF_IF_TOOLTIP}"},{type:"controls_if_elseif",message0:"%{BKY_CONTROLS_IF_ELSEIF_TITLE_ELSEIF}",previousStatement:null,nextStatement:null,enableContextMenu:!1,style:"logic_blocks",tooltip:"%{BKY_CONTROLS_IF_ELSEIF_TOOLTIP}"},{type:"controls_if_else",message0:"%{BKY_CONTROLS_IF_ELSE_TITLE_ELSE}",previousStatement:null,enableContextMenu:!1,style:"logic_blocks",tooltip:"%{BKY_CONTROLS_IF_ELSE_TOOLTIP}"}]),T.Constants.Logic.TOOLTIPS_BY_OP={EQ:"%{BKY_LOGIC_COMPARE_TOOLTIP_EQ}",NEQ:"%{BKY_LOGIC_COMPARE_TOOLTIP_NEQ}",LT:"%{BKY_LOGIC_COMPARE_TOOLTIP_LT}",LTE:"%{BKY_LOGIC_COMPARE_TOOLTIP_LTE}",GT:"%{BKY_LOGIC_COMPARE_TOOLTIP_GT}",GTE:"%{BKY_LOGIC_COMPARE_TOOLTIP_GTE}",AND:"%{BKY_LOGIC_OPERATION_TOOLTIP_AND}",OR:"%{BKY_LOGIC_OPERATION_TOOLTIP_OR}"},T.Extensions.register("logic_op_tooltip",T.Extensions.buildTooltipForDropdown("OP",T.Constants.Logic.TOOLTIPS_BY_OP)),T.Constants.Logic.CONTROLS_IF_MUTATOR_MIXIN={elseifCount_:0,elseCount_:0,suppressPrefixSuffix:!0,mutationToDom:function(){if(!this.elseifCount_&&!this.elseCount_)return null;var t=T.utils.xml.createElement("mutation");return this.elseifCount_&&t.setAttribute("elseif",this.elseifCount_),this.elseCount_&&t.setAttribute("else",1),t},domToMutation:function(t){this.elseifCount_=parseInt(t.getAttribute("elseif"),10)||0,this.elseCount_=parseInt(t.getAttribute("else"),10)||0,this.rebuildShape_()},decompose:function(t){var e=t.newBlock("controls_if_if");e.initSvg();for(var o=e.nextConnection,i=1;i<=this.elseifCount_;i++){var s=t.newBlock("controls_if_elseif");s.initSvg(),o.connect(s.previousConnection),o=s.nextConnection}return this.elseCount_&&((t=t.newBlock("controls_if_else")).initSvg(),o.connect(t.previousConnection)),e},compose:function(t){t=t.nextConnection.targetBlock(),this.elseCount_=this.elseifCount_=0;for(var e=[null],o=[null],i=null;t&&!t.isInsertionMarker();){switch(t.type){case"controls_if_elseif":this.elseifCount_++,e.push(t.valueConnection_),o.push(t.statementConnection_);break;case"controls_if_else":this.elseCount_++,i=t.statementConnection_;break;default:throw TypeError("Unknown block type: "+t.type)}t=t.nextConnection&&t.nextConnection.targetBlock()}this.updateShape_(),this.reconnectChildBlocks_(e,o,i)},saveConnections:function(t){t=t.nextConnection.targetBlock();for(var e=1;t;){switch(t.type){case"controls_if_elseif":var o=this.getInput("IF"+e),i=this.getInput("DO"+e);t.valueConnection_=o&&o.connection.targetConnection,t.statementConnection_=i&&i.connection.targetConnection,e++;break;case"controls_if_else":i=this.getInput("ELSE"),t.statementConnection_=i&&i.connection.targetConnection;break;default:throw TypeError("Unknown block type: "+t.type)}t=t.nextConnection&&t.nextConnection.targetBlock()}},rebuildShape_:function(){var t=[null],e=[null],o=null;this.getInput("ELSE")&&(o=this.getInput("ELSE").connection.targetConnection);for(var i=1;this.getInput("IF"+i);){var s=this.getInput("IF"+i),n=this.getInput("DO"+i);t.push(s.connection.targetConnection),e.push(n.connection.targetConnection),i++}this.updateShape_(),this.reconnectChildBlocks_(t,e,o)},updateShape_:function(){this.getInput("ELSE")&&this.removeInput("ELSE");for(var t=1;this.getInput("IF"+t);)this.removeInput("IF"+t),this.removeInput("DO"+t),t++;for(t=1;t<=this.elseifCount_;t++)this.appendValueInput("IF"+t).setCheck("Boolean").appendField(T.Msg.CONTROLS_IF_MSG_ELSEIF),this.appendStatementInput("DO"+t).appendField(T.Msg.CONTROLS_IF_MSG_THEN);this.elseCount_&&this.appendStatementInput("ELSE").appendField(T.Msg.CONTROLS_IF_MSG_ELSE)},reconnectChildBlocks_:function(t,e,o){for(var i=1;i<=this.elseifCount_;i++)T.Mutator.reconnect(t[i],this,"IF"+i),T.Mutator.reconnect(e[i],this,"DO"+i);T.Mutator.reconnect(o,this,"ELSE")}},T.Extensions.registerMutator("controls_if_mutator",T.Constants.Logic.CONTROLS_IF_MUTATOR_MIXIN,null,["controls_if_elseif","controls_if_else"]),T.Constants.Logic.CONTROLS_IF_TOOLTIP_EXTENSION=function(){this.setTooltip(function(){if(!this.elseifCount_&&!this.elseCount_)return T.Msg.CONTROLS_IF_TOOLTIP_1;if(!this.elseifCount_&&this.elseCount_)return T.Msg.CONTROLS_IF_TOOLTIP_2;if(this.elseifCount_&&!this.elseCount_)return T.Msg.CONTROLS_IF_TOOLTIP_3;if(this.elseifCount_&&this.elseCount_)return T.Msg.CONTROLS_IF_TOOLTIP_4;return""}.bind(this))},T.Extensions.register("controls_if_tooltip",T.Constants.Logic.CONTROLS_IF_TOOLTIP_EXTENSION),T.Constants.Logic.LOGIC_COMPARE_ONCHANGE_MIXIN={onchange:function(t){this.prevBlocks_||(this.prevBlocks_=[null,null]);var e=this.getInputTargetBlock("A"),o=this.getInputTargetBlock("B");e&&o&&!this.workspace.connectionChecker.doTypeChecks(e.outputConnection,o.outputConnection)&&(T.Events.setGroup(t.group),(t=this.prevBlocks_[0])!==e&&(e.unplug(),!t||t.isDisposed()||t.isShadow()||this.getInput("A").connection.connect(t.outputConnection)),(e=this.prevBlocks_[1])!==o&&(o.unplug(),!e||e.isDisposed()||e.isShadow()||this.getInput("B").connection.connect(e.outputConnection)),this.bumpNeighbours(),T.Events.setGroup(!1)),this.prevBlocks_[0]=this.getInputTargetBlock("A"),this.prevBlocks_[1]=this.getInputTargetBlock("B")}},T.Constants.Logic.LOGIC_COMPARE_EXTENSION=function(){this.mixin(T.Constants.Logic.LOGIC_COMPARE_ONCHANGE_MIXIN)},T.Extensions.register("logic_compare",T.Constants.Logic.LOGIC_COMPARE_EXTENSION),T.Constants.Logic.LOGIC_TERNARY_ONCHANGE_MIXIN={prevParentConnection_:null,onchange:function(t){var e=this.getInputTargetBlock("THEN"),o=this.getInputTargetBlock("ELSE"),i=this.outputConnection.targetConnection;if((e||o)&&i)for(var s=0;s<2;s++){var n=1==s?e:o;n&&!n.workspace.connectionChecker.doTypeChecks(n.outputConnection,i)&&(T.Events.setGroup(t.group),(i===this.prevParentConnection_?(this.unplug(),i.getSourceBlock()):(n.unplug(),n)).bumpNeighbours(),T.Events.setGroup(!1))}this.prevParentConnection_=i}},T.Extensions.registerMixin("logic_ternary",T.Constants.Logic.LOGIC_TERNARY_ONCHANGE_MIXIN),T.Blocks.loops={},T.Constants.Loops={},T.Constants.Loops.HUE=120,T.defineBlocksWithJsonArray([{type:"controls_repeat_ext",message0:"%{BKY_CONTROLS_REPEAT_TITLE}",args0:[{type:"input_value",name:"TIMES",check:"Number"}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],previousStatement:null,nextStatement:null,style:"loop_blocks",tooltip:"%{BKY_CONTROLS_REPEAT_TOOLTIP}",helpUrl:"%{BKY_CONTROLS_REPEAT_HELPURL}"},{type:"controls_repeat",message0:"%{BKY_CONTROLS_REPEAT_TITLE}",args0:[{type:"field_number",name:"TIMES",value:10,min:0,precision:1}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],previousStatement:null,nextStatement:null,style:"loop_blocks",tooltip:"%{BKY_CONTROLS_REPEAT_TOOLTIP}",helpUrl:"%{BKY_CONTROLS_REPEAT_HELPURL}"},{type:"controls_whileUntil",message0:"%1 %2",args0:[{type:"field_dropdown",name:"MODE",options:[["%{BKY_CONTROLS_WHILEUNTIL_OPERATOR_WHILE}","WHILE"],["%{BKY_CONTROLS_WHILEUNTIL_OPERATOR_UNTIL}","UNTIL"]]},{type:"input_value",name:"BOOL",check:"Boolean"}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],previousStatement:null,nextStatement:null,style:"loop_blocks",helpUrl:"%{BKY_CONTROLS_WHILEUNTIL_HELPURL}",extensions:["controls_whileUntil_tooltip"]},{type:"controls_for",message0:"%{BKY_CONTROLS_FOR_TITLE}",args0:[{type:"field_variable",name:"VAR",variable:null},{type:"input_value",name:"FROM",check:"Number",align:"RIGHT"},{type:"input_value",name:"TO",check:"Number",align:"RIGHT"},{type:"input_value",name:"BY",check:"Number",align:"RIGHT"}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],inputsInline:!0,previousStatement:null,nextStatement:null,style:"loop_blocks",helpUrl:"%{BKY_CONTROLS_FOR_HELPURL}",extensions:["contextMenu_newGetVariableBlock","controls_for_tooltip"]},{type:"controls_forEach",message0:"%{BKY_CONTROLS_FOREACH_TITLE}",args0:[{type:"field_variable",name:"VAR",variable:null},{type:"input_value",name:"LIST",check:"Array"}],message1:"%{BKY_CONTROLS_REPEAT_INPUT_DO} %1",args1:[{type:"input_statement",name:"DO"}],previousStatement:null,nextStatement:null,style:"loop_blocks",helpUrl:"%{BKY_CONTROLS_FOREACH_HELPURL}",extensions:["contextMenu_newGetVariableBlock","controls_forEach_tooltip"]},{type:"controls_flow_statements",message0:"%1",args0:[{type:"field_dropdown",name:"FLOW",options:[["%{BKY_CONTROLS_FLOW_STATEMENTS_OPERATOR_BREAK}","BREAK"],["%{BKY_CONTROLS_FLOW_STATEMENTS_OPERATOR_CONTINUE}","CONTINUE"]]}],previousStatement:null,style:"loop_blocks",helpUrl:"%{BKY_CONTROLS_FLOW_STATEMENTS_HELPURL}",extensions:["controls_flow_tooltip","controls_flow_in_loop_check"]}]),T.Constants.Loops.WHILE_UNTIL_TOOLTIPS={WHILE:"%{BKY_CONTROLS_WHILEUNTIL_TOOLTIP_WHILE}",UNTIL:"%{BKY_CONTROLS_WHILEUNTIL_TOOLTIP_UNTIL}"},T.Extensions.register("controls_whileUntil_tooltip",T.Extensions.buildTooltipForDropdown("MODE",T.Constants.Loops.WHILE_UNTIL_TOOLTIPS)),T.Constants.Loops.BREAK_CONTINUE_TOOLTIPS={BREAK:"%{BKY_CONTROLS_FLOW_STATEMENTS_TOOLTIP_BREAK}",CONTINUE:"%{BKY_CONTROLS_FLOW_STATEMENTS_TOOLTIP_CONTINUE}"},T.Extensions.register("controls_flow_tooltip",T.Extensions.buildTooltipForDropdown("FLOW",T.Constants.Loops.BREAK_CONTINUE_TOOLTIPS)),T.Constants.Loops.CUSTOM_CONTEXT_MENU_CREATE_VARIABLES_GET_MIXIN={customContextMenu:function(t){var e,o,i;this.isInFlyout||(o=(e=this.getField("VAR").getVariable()).name,this.isCollapsed())||null==o||((i={enabled:!0}).text=T.Msg.VARIABLES_SET_CREATE_GET.replace("%1",o),e=T.Variables.generateVariableFieldDom(e),(o=T.utils.xml.createElement("block")).setAttribute("type","variables_get"),o.appendChild(e),i.callback=T.ContextMenu.callbackFactory(this,o),t.push(i))}},T.Extensions.registerMixin("contextMenu_newGetVariableBlock",T.Constants.Loops.CUSTOM_CONTEXT_MENU_CREATE_VARIABLES_GET_MIXIN),T.Extensions.register("controls_for_tooltip",T.Extensions.buildTooltipWithFieldText("%{BKY_CONTROLS_FOR_TOOLTIP}","VAR")),T.Extensions.register("controls_forEach_tooltip",T.Extensions.buildTooltipWithFieldText("%{BKY_CONTROLS_FOREACH_TOOLTIP}","VAR")),T.Constants.Loops.CONTROL_FLOW_IN_LOOP_CHECK_MIXIN={LOOP_TYPES:["controls_repeat","controls_repeat_ext","controls_forEach","controls_for","controls_whileUntil"],suppressPrefixSuffix:!0,getSurroundLoop:function(t){do{if(-1!=T.Constants.Loops.CONTROL_FLOW_IN_LOOP_CHECK_MIXIN.LOOP_TYPES.indexOf(t.type))return t;t=t.getSurroundParent()}while(t);return null},onchange:function(t){var e,o;this.workspace.isDragging&&!this.workspace.isDragging()&&t.type==T.Events.BLOCK_MOVE&&(e=T.Constants.Loops.CONTROL_FLOW_IN_LOOP_CHECK_MIXIN.getSurroundLoop(this),this.setWarningText(e?null:T.Msg.CONTROLS_FLOW_STATEMENTS_WARNING),this.isInFlyout||(o=T.Events.getGroup(),T.Events.setGroup(t.group),this.setEnabled(e),T.Events.setGroup(o)))}},T.Extensions.registerMixin("controls_flow_in_loop_check",T.Constants.Loops.CONTROL_FLOW_IN_LOOP_CHECK_MIXIN),T.Blocks.math={},T.Constants.Math={},T.Constants.Math.HUE=230,T.defineBlocksWithJsonArray([{type:"math_number",message0:"%1",args0:[{type:"field_number",name:"NUM",value:0}],output:"Number",helpUrl:"%{BKY_MATH_NUMBER_HELPURL}",style:"math_blocks",tooltip:"%{BKY_MATH_NUMBER_TOOLTIP}",extensions:["parent_tooltip_when_inline"]},{type:"math_arithmetic",message0:"%1 %2 %3",args0:[{type:"input_value",name:"A",check:"Number"},{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_ADDITION_SYMBOL}","ADD"],["%{BKY_MATH_SUBTRACTION_SYMBOL}","MINUS"],["%{BKY_MATH_MULTIPLICATION_SYMBOL}","MULTIPLY"],["%{BKY_MATH_DIVISION_SYMBOL}","DIVIDE"],["%{BKY_MATH_POWER_SYMBOL}","POWER"]]},{type:"input_value",name:"B",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_ARITHMETIC_HELPURL}",extensions:["math_op_tooltip"]},{type:"math_single",message0:"%1 %2",args0:[{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_SINGLE_OP_ROOT}","ROOT"],["%{BKY_MATH_SINGLE_OP_ABSOLUTE}","ABS"],["-","NEG"],["ln","LN"],["log10","LOG10"],["e^","EXP"],["10^","POW10"]]},{type:"input_value",name:"NUM",check:"Number"}],output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_SINGLE_HELPURL}",extensions:["math_op_tooltip"]},{type:"math_trig",message0:"%1 %2",args0:[{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_TRIG_SIN}","SIN"],["%{BKY_MATH_TRIG_COS}","COS"],["%{BKY_MATH_TRIG_TAN}","TAN"],["%{BKY_MATH_TRIG_ASIN}","ASIN"],["%{BKY_MATH_TRIG_ACOS}","ACOS"],["%{BKY_MATH_TRIG_ATAN}","ATAN"]]},{type:"input_value",name:"NUM",check:"Number"}],output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_TRIG_HELPURL}",extensions:["math_op_tooltip"]},{type:"math_constant",message0:"%1",args0:[{type:"field_dropdown",name:"CONSTANT",options:[["π","PI"],["e","E"],["φ","GOLDEN_RATIO"],["sqrt(2)","SQRT2"],["sqrt(½)","SQRT1_2"],["∞","INFINITY"]]}],output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_CONSTANT_TOOLTIP}",helpUrl:"%{BKY_MATH_CONSTANT_HELPURL}"},{type:"math_number_property",message0:"%1 %2",args0:[{type:"input_value",name:"NUMBER_TO_CHECK",check:"Number"},{type:"field_dropdown",name:"PROPERTY",options:[["%{BKY_MATH_IS_EVEN}","EVEN"],["%{BKY_MATH_IS_ODD}","ODD"],["%{BKY_MATH_IS_PRIME}","PRIME"],["%{BKY_MATH_IS_WHOLE}","WHOLE"],["%{BKY_MATH_IS_POSITIVE}","POSITIVE"],["%{BKY_MATH_IS_NEGATIVE}","NEGATIVE"],["%{BKY_MATH_IS_DIVISIBLE_BY}","DIVISIBLE_BY"]]}],inputsInline:!0,output:"Boolean",style:"math_blocks",tooltip:"%{BKY_MATH_IS_TOOLTIP}",mutator:"math_is_divisibleby_mutator"},{type:"math_change",message0:"%{BKY_MATH_CHANGE_TITLE}",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_MATH_CHANGE_TITLE_ITEM}"},{type:"input_value",name:"DELTA",check:"Number"}],previousStatement:null,nextStatement:null,style:"variable_blocks",helpUrl:"%{BKY_MATH_CHANGE_HELPURL}",extensions:["math_change_tooltip"]},{type:"math_round",message0:"%1 %2",args0:[{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_ROUND_OPERATOR_ROUND}","ROUND"],["%{BKY_MATH_ROUND_OPERATOR_ROUNDUP}","ROUNDUP"],["%{BKY_MATH_ROUND_OPERATOR_ROUNDDOWN}","ROUNDDOWN"]]},{type:"input_value",name:"NUM",check:"Number"}],output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_ROUND_HELPURL}",tooltip:"%{BKY_MATH_ROUND_TOOLTIP}"},{type:"math_on_list",message0:"%1 %2",args0:[{type:"field_dropdown",name:"OP",options:[["%{BKY_MATH_ONLIST_OPERATOR_SUM}","SUM"],["%{BKY_MATH_ONLIST_OPERATOR_MIN}","MIN"],["%{BKY_MATH_ONLIST_OPERATOR_MAX}","MAX"],["%{BKY_MATH_ONLIST_OPERATOR_AVERAGE}","AVERAGE"],["%{BKY_MATH_ONLIST_OPERATOR_MEDIAN}","MEDIAN"],["%{BKY_MATH_ONLIST_OPERATOR_MODE}","MODE"],["%{BKY_MATH_ONLIST_OPERATOR_STD_DEV}","STD_DEV"],["%{BKY_MATH_ONLIST_OPERATOR_RANDOM}","RANDOM"]]},{type:"input_value",name:"LIST",check:"Array"}],output:"Number",style:"math_blocks",helpUrl:"%{BKY_MATH_ONLIST_HELPURL}",mutator:"math_modes_of_list_mutator",extensions:["math_op_tooltip"]},{type:"math_modulo",message0:"%{BKY_MATH_MODULO_TITLE}",args0:[{type:"input_value",name:"DIVIDEND",check:"Number"},{type:"input_value",name:"DIVISOR",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_MODULO_TOOLTIP}",helpUrl:"%{BKY_MATH_MODULO_HELPURL}"},{type:"math_constrain",message0:"%{BKY_MATH_CONSTRAIN_TITLE}",args0:[{type:"input_value",name:"VALUE",check:"Number"},{type:"input_value",name:"LOW",check:"Number"},{type:"input_value",name:"HIGH",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_CONSTRAIN_TOOLTIP}",helpUrl:"%{BKY_MATH_CONSTRAIN_HELPURL}"},{type:"math_random_int",message0:"%{BKY_MATH_RANDOM_INT_TITLE}",args0:[{type:"input_value",name:"FROM",check:"Number"},{type:"input_value",name:"TO",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_RANDOM_INT_TOOLTIP}",helpUrl:"%{BKY_MATH_RANDOM_INT_HELPURL}"},{type:"math_random_float",message0:"%{BKY_MATH_RANDOM_FLOAT_TITLE_RANDOM}",output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_RANDOM_FLOAT_TOOLTIP}",helpUrl:"%{BKY_MATH_RANDOM_FLOAT_HELPURL}"},{type:"math_atan2",message0:"%{BKY_MATH_ATAN2_TITLE}",args0:[{type:"input_value",name:"X",check:"Number"},{type:"input_value",name:"Y",check:"Number"}],inputsInline:!0,output:"Number",style:"math_blocks",tooltip:"%{BKY_MATH_ATAN2_TOOLTIP}",helpUrl:"%{BKY_MATH_ATAN2_HELPURL}"}]),T.Constants.Math.TOOLTIPS_BY_OP={ADD:"%{BKY_MATH_ARITHMETIC_TOOLTIP_ADD}",MINUS:"%{BKY_MATH_ARITHMETIC_TOOLTIP_MINUS}",MULTIPLY:"%{BKY_MATH_ARITHMETIC_TOOLTIP_MULTIPLY}",DIVIDE:"%{BKY_MATH_ARITHMETIC_TOOLTIP_DIVIDE}",POWER:"%{BKY_MATH_ARITHMETIC_TOOLTIP_POWER}",ROOT:"%{BKY_MATH_SINGLE_TOOLTIP_ROOT}",ABS:"%{BKY_MATH_SINGLE_TOOLTIP_ABS}",NEG:"%{BKY_MATH_SINGLE_TOOLTIP_NEG}",LN:"%{BKY_MATH_SINGLE_TOOLTIP_LN}",LOG10:"%{BKY_MATH_SINGLE_TOOLTIP_LOG10}",EXP:"%{BKY_MATH_SINGLE_TOOLTIP_EXP}",POW10:"%{BKY_MATH_SINGLE_TOOLTIP_POW10}",SIN:"%{BKY_MATH_TRIG_TOOLTIP_SIN}",COS:"%{BKY_MATH_TRIG_TOOLTIP_COS}",TAN:"%{BKY_MATH_TRIG_TOOLTIP_TAN}",ASIN:"%{BKY_MATH_TRIG_TOOLTIP_ASIN}",ACOS:"%{BKY_MATH_TRIG_TOOLTIP_ACOS}",ATAN:"%{BKY_MATH_TRIG_TOOLTIP_ATAN}",SUM:"%{BKY_MATH_ONLIST_TOOLTIP_SUM}",MIN:"%{BKY_MATH_ONLIST_TOOLTIP_MIN}",MAX:"%{BKY_MATH_ONLIST_TOOLTIP_MAX}",AVERAGE:"%{BKY_MATH_ONLIST_TOOLTIP_AVERAGE}",MEDIAN:"%{BKY_MATH_ONLIST_TOOLTIP_MEDIAN}",MODE:"%{BKY_MATH_ONLIST_TOOLTIP_MODE}",STD_DEV:"%{BKY_MATH_ONLIST_TOOLTIP_STD_DEV}",RANDOM:"%{BKY_MATH_ONLIST_TOOLTIP_RANDOM}"},T.Extensions.register("math_op_tooltip",T.Extensions.buildTooltipForDropdown("OP",T.Constants.Math.TOOLTIPS_BY_OP)),T.Constants.Math.IS_DIVISIBLEBY_MUTATOR_MIXIN={mutationToDom:function(){var t=T.utils.xml.createElement("mutation"),e="DIVISIBLE_BY"==this.getFieldValue("PROPERTY");return t.setAttribute("divisor_input",e),t},domToMutation:function(t){t="true"==t.getAttribute("divisor_input"),this.updateShape_(t)},updateShape_:function(t){var e=this.getInput("DIVISOR");t?e||this.appendValueInput("DIVISOR").setCheck("Number"):e&&this.removeInput("DIVISOR")}},T.Constants.Math.IS_DIVISIBLE_MUTATOR_EXTENSION=function(){this.getField("PROPERTY").setValidator(function(t){t="DIVISIBLE_BY"==t,this.getSourceBlock().updateShape_(t)})},T.Extensions.registerMutator("math_is_divisibleby_mutator",T.Constants.Math.IS_DIVISIBLEBY_MUTATOR_MIXIN,T.Constants.Math.IS_DIVISIBLE_MUTATOR_EXTENSION),T.Extensions.register("math_change_tooltip",T.Extensions.buildTooltipWithFieldText("%{BKY_MATH_CHANGE_TOOLTIP}","VAR")),T.Constants.Math.LIST_MODES_MUTATOR_MIXIN={updateType_:function(t){"MODE"==t?this.outputConnection.setCheck("Array"):this.outputConnection.setCheck("Number")},mutationToDom:function(){var t=T.utils.xml.createElement("mutation");return t.setAttribute("op",this.getFieldValue("OP")),t},domToMutation:function(t){this.updateType_(t.getAttribute("op"))}},T.Constants.Math.LIST_MODES_MUTATOR_EXTENSION=function(){this.getField("OP").setValidator(function(t){this.updateType_(t)}.bind(this))},T.Extensions.registerMutator("math_modes_of_list_mutator",T.Constants.Math.LIST_MODES_MUTATOR_MIXIN,T.Constants.Math.LIST_MODES_MUTATOR_EXTENSION),T.Blocks.procedures={},T.Blocks.procedures_defnoreturn={init:function(){var t=T.Procedures.findLegalName("",this),t;(t=new T.FieldTextInput(t,T.Procedures.rename)).setSpellcheck(!1),this.appendDummyInput().appendField(T.Msg.PROCEDURES_DEFNORETURN_TITLE).appendField(t,"NAME").appendField("","PARAMS"),this.setMutator(new T.Mutator(["procedures_mutatorarg"])),(this.workspace.options.comments||this.workspace.options.parentWorkspace&&this.workspace.options.parentWorkspace.options.comments)&&T.Msg.PROCEDURES_DEFNORETURN_COMMENT&&this.setCommentText(T.Msg.PROCEDURES_DEFNORETURN_COMMENT),this.setStyle("procedure_blocks"),this.setTooltip(T.Msg.PROCEDURES_DEFNORETURN_TOOLTIP),this.setHelpUrl(T.Msg.PROCEDURES_DEFNORETURN_HELPURL),this.arguments_=[],this.argumentVarModels_=[],this.setStatements_(!0),this.statementConnection_=null},setStatements_:function(t){this.hasStatements_!==t&&(t?(this.appendStatementInput("STACK").appendField(T.Msg.PROCEDURES_DEFNORETURN_DO),this.getInput("RETURN")&&this.moveInputBefore("STACK","RETURN")):this.removeInput("STACK",!0),this.hasStatements_=t)},updateParams_:function(){var t="";this.arguments_.length&&(t=T.Msg.PROCEDURES_BEFORE_PARAMS+" "+this.arguments_.join(", ")),T.Events.disable();try{this.setFieldValue(t,"PARAMS")}finally{T.Events.enable()}},mutationToDom:function(t){var e=T.utils.xml.createElement("mutation");t&&e.setAttribute("name",this.getFieldValue("NAME"));for(var o=0;o<this.argumentVarModels_.length;o++){var i=T.utils.xml.createElement("arg"),s=this.argumentVarModels_[o];i.setAttribute("name",s.name),i.setAttribute("varid",s.getId()),t&&this.paramIds_&&i.setAttribute("paramId",this.paramIds_[o]),e.appendChild(i)}return this.hasStatements_||e.setAttribute("statements","false"),e},domToMutation:function(t){this.arguments_=[],this.argumentVarModels_=[];for(var e=0,o,i,o;o=t.childNodes[e];e++){"arg"==o.nodeName.toLowerCase()&&(i=o.getAttribute("name"),o=o.getAttribute("varid")||o.getAttribute("varId"),this.arguments_.push(i),null!=(o=T.Variables.getOrCreateVariablePackage(this.workspace,o,i,""))?this.argumentVarModels_.push(o):console.log("Failed to create a variable with name "+i+", ignoring."))}this.updateParams_(),T.Procedures.mutateCallers(this),this.setStatements_("false"!==t.getAttribute("statements"))},decompose:function(t){var e=T.utils.xml.createElement("block"),o=(e.setAttribute("type","procedures_mutatorcontainer"),T.utils.xml.createElement("statement"));o.setAttribute("name","STACK"),e.appendChild(o);for(var i=0;i<this.arguments_.length;i++){var s=T.utils.xml.createElement("block"),n=(s.setAttribute("type","procedures_mutatorarg"),T.utils.xml.createElement("field")),r=(n.setAttribute("name","NAME"),T.utils.xml.createTextNode(this.arguments_[i]));n.appendChild(r),s.appendChild(n),n=T.utils.xml.createElement("next"),s.appendChild(n),o.appendChild(s),o=n}return t=T.Xml.domToBlock(e,t),"procedures_defreturn"==this.type?t.setFieldValue(this.hasStatements_,"STATEMENTS"):t.removeInput("STATEMENT_INPUT"),T.Procedures.mutateCallers(this),t},compose:function(t){this.arguments_=[],this.paramIds_=[],this.argumentVarModels_=[];for(var e=t.getInputTargetBlock("STACK");e&&!e.isInsertionMarker();){var o=e.getFieldValue("NAME");this.arguments_.push(o),o=this.workspace.getVariable(o,""),this.argumentVarModels_.push(o),this.paramIds_.push(e.id),e=e.nextConnection&&e.nextConnection.targetBlock()}this.updateParams_(),T.Procedures.mutateCallers(this),null!==(t=t.getFieldValue("STATEMENTS"))&&this.hasStatements_!=(t="TRUE"==t)&&(t?(this.setStatements_(!0),T.Mutator.reconnect(this.statementConnection_,this,"STACK"),this.statementConnection_=null):(t=this.getInput("STACK").connection,(this.statementConnection_=t.targetConnection)&&((t=t.targetBlock()).unplug(),t.bumpNeighbours()),this.setStatements_(!1)))},getProcedureDef:function(){return[this.getFieldValue("NAME"),this.arguments_,!1]},getVars:function(){return this.arguments_},getVarModels:function(){return this.argumentVarModels_},renameVarById:function(t,e){var o=this.workspace.getVariableById(t);if(""==o.type){o=o.name,e=this.workspace.getVariableById(e);for(var i=!1,s=0;s<this.argumentVarModels_.length;s++)this.argumentVarModels_[s].getId()==t&&(this.arguments_[s]=e.name,this.argumentVarModels_[s]=e,i=!0);i&&(this.displayRenamedVar_(o,e.name),T.Procedures.mutateCallers(this))}},updateVarName:function(t){for(var e=t.name,o=!1,i=0,s;i<this.argumentVarModels_.length;i++){this.argumentVarModels_[i].getId()==t.getId()&&(s=this.arguments_[i],this.arguments_[i]=e,o=!0)}o&&(this.displayRenamedVar_(s,e),T.Procedures.mutateCallers(this))},displayRenamedVar_:function(t,e){if(this.updateParams_(),this.mutator&&this.mutator.isVisible())for(var o=this.mutator.workspace_.getAllBlocks(!1),i=0,s;s=o[i];i++)"procedures_mutatorarg"==s.type&&T.Names.equals(t,s.getFieldValue("NAME"))&&s.setFieldValue(e,"NAME")},customContextMenu:function(t){if(!this.isInFlyout){var e={enabled:!0},o=this.getFieldValue("NAME"),i=(e.text=T.Msg.PROCEDURES_CREATE_DO.replace("%1",o),T.utils.xml.createElement("mutation"));for(i.setAttribute("name",o),o=0;o<this.arguments_.length;o++){var s=T.utils.xml.createElement("arg");s.setAttribute("name",this.arguments_[o]),i.appendChild(s)}if((o=T.utils.xml.createElement("block")).setAttribute("type",this.callType_),o.appendChild(i),e.callback=T.ContextMenu.callbackFactory(this,o),t.push(e),!this.isCollapsed())for(o=0;o<this.argumentVarModels_.length;o++)i=this.argumentVarModels_[o],(e={enabled:!0}).text=T.Msg.VARIABLES_SET_CREATE_GET.replace("%1",i.name),i=T.Variables.generateVariableFieldDom(i),(s=T.utils.xml.createElement("block")).setAttribute("type","variables_get"),s.appendChild(i),e.callback=T.ContextMenu.callbackFactory(this,s),t.push(e)}},callType_:"procedures_callnoreturn"},T.Blocks.procedures_defreturn={init:function(){var t=T.Procedures.findLegalName("",this),t;(t=new T.FieldTextInput(t,T.Procedures.rename)).setSpellcheck(!1),this.appendDummyInput().appendField(T.Msg.PROCEDURES_DEFRETURN_TITLE).appendField(t,"NAME").appendField("","PARAMS"),this.appendValueInput("RETURN").setAlign(T.ALIGN_RIGHT).appendField(T.Msg.PROCEDURES_DEFRETURN_RETURN),this.setMutator(new T.Mutator(["procedures_mutatorarg"])),(this.workspace.options.comments||this.workspace.options.parentWorkspace&&this.workspace.options.parentWorkspace.options.comments)&&T.Msg.PROCEDURES_DEFRETURN_COMMENT&&this.setCommentText(T.Msg.PROCEDURES_DEFRETURN_COMMENT),this.setStyle("procedure_blocks"),this.setTooltip(T.Msg.PROCEDURES_DEFRETURN_TOOLTIP),this.setHelpUrl(T.Msg.PROCEDURES_DEFRETURN_HELPURL),this.arguments_=[],this.argumentVarModels_=[],this.setStatements_(!0),this.statementConnection_=null},setStatements_:T.Blocks.procedures_defnoreturn.setStatements_,updateParams_:T.Blocks.procedures_defnoreturn.updateParams_,mutationToDom:T.Blocks.procedures_defnoreturn.mutationToDom,domToMutation:T.Blocks.procedures_defnoreturn.domToMutation,decompose:T.Blocks.procedures_defnoreturn.decompose,compose:T.Blocks.procedures_defnoreturn.compose,getProcedureDef:function(){return[this.getFieldValue("NAME"),this.arguments_,!0]},getVars:T.Blocks.procedures_defnoreturn.getVars,getVarModels:T.Blocks.procedures_defnoreturn.getVarModels,renameVarById:T.Blocks.procedures_defnoreturn.renameVarById,updateVarName:T.Blocks.procedures_defnoreturn.updateVarName,displayRenamedVar_:T.Blocks.procedures_defnoreturn.displayRenamedVar_,customContextMenu:T.Blocks.procedures_defnoreturn.customContextMenu,callType_:"procedures_callreturn"},T.Blocks.procedures_mutatorcontainer={init:function(){this.appendDummyInput().appendField(T.Msg.PROCEDURES_MUTATORCONTAINER_TITLE),this.appendStatementInput("STACK"),this.appendDummyInput("STATEMENT_INPUT").appendField(T.Msg.PROCEDURES_ALLOW_STATEMENTS).appendField(new T.FieldCheckbox("TRUE"),"STATEMENTS"),this.setStyle("procedure_blocks"),this.setTooltip(T.Msg.PROCEDURES_MUTATORCONTAINER_TOOLTIP),this.contextMenu=!1}},T.Blocks.procedures_mutatorarg={init:function(){var t=new T.FieldTextInput(T.Procedures.DEFAULT_ARG,this.validator_);t.oldShowEditorFn_=t.showEditor_,t.showEditor_=function(){this.createdVariables_=[],this.oldShowEditorFn_()},this.appendDummyInput().appendField(T.Msg.PROCEDURES_MUTATORARG_TITLE).appendField(t,"NAME"),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setStyle("procedure_blocks"),this.setTooltip(T.Msg.PROCEDURES_MUTATORARG_TOOLTIP),this.contextMenu=!1,t.onFinishEditing_=this.deleteIntermediateVars_,t.createdVariables_=[],t.onFinishEditing_("x")},validator_:function(t){var e=this.getSourceBlock(),o=T.Mutator.findParentWs(e.workspace);if(!(t=t.replace(/[\s\xa0]+/g," ").replace(/^ | $/g,"")))return null;for(var i=(e.workspace.targetWorkspace||e.workspace).getAllBlocks(!1),s=t.toLowerCase(),n=0;n<i.length;n++)if(i[n].id!=this.getSourceBlock().id){var r=i[n].getFieldValue("NAME");if(r&&r.toLowerCase()==s)return null}if(e.isInFlyout)return t;return(e=o.getVariable(t,""))&&e.name!=t&&o.renameVariableById(e.getId(),t),e||(e=o.createVariable(t,""))&&this.createdVariables_&&this.createdVariables_.push(e),t},deleteIntermediateVars_:function(t){var e=T.Mutator.findParentWs(this.getSourceBlock().workspace);if(e)for(var o=0;o<this.createdVariables_.length;o++){var i=this.createdVariables_[o];i.name!=t&&e.deleteVariableById(i.getId())}}},T.Blocks.procedures_callnoreturn={init:function(){this.appendDummyInput("TOPROW").appendField("","NAME"),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setStyle("procedure_blocks"),this.setHelpUrl(T.Msg.PROCEDURES_CALLNORETURN_HELPURL),this.arguments_=[],this.argumentVarModels_=[],this.quarkConnections_={},this.quarkIds_=null,this.previousEnabledState_=!0},getProcedureCall:function(){return this.getFieldValue("NAME")},renameProcedure:function(t,e){T.Names.equals(t,this.getProcedureCall())&&(this.setFieldValue(e,"NAME"),this.setTooltip((this.outputConnection?T.Msg.PROCEDURES_CALLRETURN_TOOLTIP:T.Msg.PROCEDURES_CALLNORETURN_TOOLTIP).replace("%1",e)))},setProcedureParameters_:function(t,e){var o=T.Procedures.getDefinition(this.getProcedureCall(),this.workspace),i=o&&o.mutator&&o.mutator.isVisible();if(i||(this.quarkConnections_={},this.quarkIds_=null),e)if(t.join("\n")==this.arguments_.join("\n"))this.quarkIds_=e;else{if(e.length!=t.length)throw RangeError("paramNames and paramIds must be the same length.");this.setCollapsed(!1),this.quarkIds_||(this.quarkConnections_={},this.quarkIds_=[]),o=this.rendered,this.rendered=!1;for(var s=0;s<this.arguments_.length;s++){var n=this.getInput("ARG"+s);n&&(n=n.connection.targetConnection,this.quarkConnections_[this.quarkIds_[s]]=n,i)&&n&&-1==e.indexOf(this.quarkIds_[s])&&(n.disconnect(),n.getSourceBlock().bumpNeighbours())}for(this.arguments_=[].concat(t),this.argumentVarModels_=[],s=0;s<this.arguments_.length;s++)t=T.Variables.getOrCreateVariablePackage(this.workspace,null,this.arguments_[s],""),this.argumentVarModels_.push(t);if(this.updateShape_(),this.quarkIds_=e)for(s=0;s<this.arguments_.length;s++)(e=this.quarkIds_[s])in this.quarkConnections_&&(n=this.quarkConnections_[e],T.Mutator.reconnect(n,this,"ARG"+s)||delete this.quarkConnections_[e]);(this.rendered=o)&&this.render()}},updateShape_:function(){for(var t=0;t<this.arguments_.length;t++){var e=this.getField("ARGNAME"+t);if(e){T.Events.disable();try{e.setValue(this.arguments_[t])}finally{T.Events.enable()}}else e=new T.FieldLabel(this.arguments_[t]),this.appendValueInput("ARG"+t).setAlign(T.ALIGN_RIGHT).appendField(e,"ARGNAME"+t).init()}for(;this.getInput("ARG"+t);)this.removeInput("ARG"+t),t++;(t=this.getInput("TOPROW"))&&(this.arguments_.length?this.getField("WITH")||(t.appendField(T.Msg.PROCEDURES_CALL_BEFORE_PARAMS,"WITH"),t.init()):this.getField("WITH")&&t.removeField("WITH"))},mutationToDom:function(){var t=T.utils.xml.createElement("mutation");t.setAttribute("name",this.getProcedureCall());for(var e=0;e<this.arguments_.length;e++){var o=T.utils.xml.createElement("arg");o.setAttribute("name",this.arguments_[e]),t.appendChild(o)}return t},domToMutation:function(t){var e=t.getAttribute("name");this.renameProcedure(this.getProcedureCall(),e);for(var e=[],o=[],i=0,s;s=t.childNodes[i];i++)"arg"==s.nodeName.toLowerCase()&&(e.push(s.getAttribute("name")),o.push(s.getAttribute("paramId")));this.setProcedureParameters_(e,o)},getVars:function(){return this.arguments_},getVarModels:function(){return this.argumentVarModels_},onchange:function(t){var e,o,i,e;this.workspace&&!this.workspace.isFlyout&&t.recordUndo&&(t.type==T.Events.BLOCK_CREATE&&-1!=t.ids.indexOf(this.id)?(e=this.getProcedureCall(),(e=!(e=T.Procedures.getDefinition(e,this.workspace))||e.type==this.defType_&&JSON.stringify(e.getVars())==JSON.stringify(this.arguments_)?e:null)||(T.Events.setGroup(t.group),t=T.utils.xml.createElement("xml"),(e=T.utils.xml.createElement("block")).setAttribute("type",this.defType_),i=(o=this.getRelativeToSurfaceXY()).y+2*T.SNAP_RADIUS,e.setAttribute("x",o.x+T.SNAP_RADIUS*(this.RTL?-1:1)),e.setAttribute("y",i),o=this.mutationToDom(),e.appendChild(o),(o=T.utils.xml.createElement("field")).setAttribute("name","NAME"),(i=this.getProcedureCall())||(i=T.Procedures.findLegalName("",this),this.renameProcedure("",i)),o.appendChild(T.utils.xml.createTextNode(i)),e.appendChild(o),t.appendChild(e),T.Xml.domToWorkspace(t,this.workspace),T.Events.setGroup(!1))):t.type==T.Events.BLOCK_DELETE?(e=this.getProcedureCall(),(e=T.Procedures.getDefinition(e,this.workspace))||(T.Events.setGroup(t.group),this.dispose(!0),T.Events.setGroup(!1))):t.type==T.Events.CHANGE&&"disabled"==t.element&&(e=this.getProcedureCall(),e=T.Procedures.getDefinition(e,this.workspace))&&e.id==t.blockId&&((e=T.Events.getGroup())&&console.log("Saw an existing group while responding to a definition change"),T.Events.setGroup(t.group),t.newValue?(this.previousEnabledState_=this.isEnabled(),this.setEnabled(!1)):this.setEnabled(this.previousEnabledState_),T.Events.setGroup(e)))},customContextMenu:function(t){var e,o,i;this.workspace.isMovable()&&((e={enabled:!0}).text=T.Msg.PROCEDURES_HIGHLIGHT_DEF,o=this.getProcedureCall(),i=this.workspace,e.callback=function(){var t=T.Procedures.getDefinition(o,i);t&&(i.centerOnBlock(t.id),t.select())},t.push(e))},defType_:"procedures_defnoreturn"},T.Blocks.procedures_callreturn={init:function(){this.appendDummyInput("TOPROW").appendField("","NAME"),this.setOutput(!0),this.setStyle("procedure_blocks"),this.setHelpUrl(T.Msg.PROCEDURES_CALLRETURN_HELPURL),this.arguments_=[],this.argumentVarModels_=[],this.quarkConnections_={},this.quarkIds_=null,this.previousEnabledState_=!0},getProcedureCall:T.Blocks.procedures_callnoreturn.getProcedureCall,renameProcedure:T.Blocks.procedures_callnoreturn.renameProcedure,setProcedureParameters_:T.Blocks.procedures_callnoreturn.setProcedureParameters_,updateShape_:T.Blocks.procedures_callnoreturn.updateShape_,mutationToDom:T.Blocks.procedures_callnoreturn.mutationToDom,domToMutation:T.Blocks.procedures_callnoreturn.domToMutation,getVars:T.Blocks.procedures_callnoreturn.getVars,getVarModels:T.Blocks.procedures_callnoreturn.getVarModels,onchange:T.Blocks.procedures_callnoreturn.onchange,customContextMenu:T.Blocks.procedures_callnoreturn.customContextMenu,defType_:"procedures_defreturn"},T.Blocks.procedures_ifreturn={init:function(){this.appendValueInput("CONDITION").setCheck("Boolean").appendField(T.Msg.CONTROLS_IF_MSG_IF),this.appendValueInput("VALUE").appendField(T.Msg.PROCEDURES_DEFRETURN_RETURN),this.setInputsInline(!0),this.setPreviousStatement(!0),this.setNextStatement(!0),this.setStyle("procedure_blocks"),this.setTooltip(T.Msg.PROCEDURES_IFRETURN_TOOLTIP),this.setHelpUrl(T.Msg.PROCEDURES_IFRETURN_HELPURL),this.hasReturnValue_=!0},mutationToDom:function(){var t=T.utils.xml.createElement("mutation");return t.setAttribute("value",Number(this.hasReturnValue_)),t},domToMutation:function(t){this.hasReturnValue_=1==t.getAttribute("value"),this.hasReturnValue_||(this.removeInput("VALUE"),this.appendDummyInput("VALUE").appendField(T.Msg.PROCEDURES_DEFRETURN_RETURN))},onchange:function(t){if(this.workspace.isDragging&&!this.workspace.isDragging()){t=!1;var e=this;do{if(-1!=this.FUNCTION_TYPES.indexOf(e.type)){t=!0;break}e=e.getSurroundParent()}while(e);t?("procedures_defnoreturn"==e.type&&this.hasReturnValue_?(this.removeInput("VALUE"),this.appendDummyInput("VALUE").appendField(T.Msg.PROCEDURES_DEFRETURN_RETURN),this.hasReturnValue_=!1):"procedures_defreturn"!=e.type||this.hasReturnValue_||(this.removeInput("VALUE"),this.appendValueInput("VALUE").appendField(T.Msg.PROCEDURES_DEFRETURN_RETURN),this.hasReturnValue_=!0),this.setWarningText(null),this.isInFlyout||this.setEnabled(!0)):(this.setWarningText(T.Msg.PROCEDURES_IFRETURN_WARNING),this.isInFlyout||this.getInheritedDisabled()||this.setEnabled(!1))}},FUNCTION_TYPES:["procedures_defnoreturn","procedures_defreturn"]},T.Blocks.texts={},T.Constants.Text={},T.Constants.Text.HUE=160,T.defineBlocksWithJsonArray([{type:"text",message0:"%1",args0:[{type:"field_input",name:"TEXT",text:""}],output:"String",style:"text_blocks",helpUrl:"%{BKY_TEXT_TEXT_HELPURL}",tooltip:"%{BKY_TEXT_TEXT_TOOLTIP}",extensions:["text_quotes","parent_tooltip_when_inline"]},{type:"text_multiline",message0:"%1 %2",args0:[{type:"field_image",src:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAARCAYAAADpPU2iAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAdhgAAHYYBXaITgQAAABh0RVh0U29mdHdhcmUAcGFpbnQubmV0IDQuMS42/U4J6AAAAP1JREFUOE+Vks0KQUEYhjmRIja4ABtZ2dm5A3t3Ia6AUm7CylYuQRaUhZSlLZJiQbFAyRnPN33y01HOW08z8873zpwzM4F3GWOCruvGIE4/rLaV+Nq1hVGMBqzhqlxgCys4wJA65xnogMHsQ5lujnYHTejBBCK2mE4abjCgMGhNxHgDFWjDSG07kdfVa2pZMf4ZyMAdWmpZMfYOsLiDMYMjlMB+K613QISRhTnITnsYg5yUd0DETmEoMlkFOeIT/A58iyK5E18BuTBfgYXfwNJv4P9/oEBerLylOnRhygmGdPpTTBZAPkde61lbQe4moWUvYUZYLfUNftIY4zwA5X2Z9AYnQrEAAAAASUVORK5CYII=",width:12,height:17,alt:"¶"},{type:"field_multilinetext",name:"TEXT",text:""}],output:"String",style:"text_blocks",helpUrl:"%{BKY_TEXT_TEXT_HELPURL}",tooltip:"%{BKY_TEXT_TEXT_TOOLTIP}",extensions:["parent_tooltip_when_inline"]},{type:"text_join",message0:"",output:"String",style:"text_blocks",helpUrl:"%{BKY_TEXT_JOIN_HELPURL}",tooltip:"%{BKY_TEXT_JOIN_TOOLTIP}",mutator:"text_join_mutator"},{type:"text_create_join_container",message0:"%{BKY_TEXT_CREATE_JOIN_TITLE_JOIN} %1 %2",args0:[{type:"input_dummy"},{type:"input_statement",name:"STACK"}],style:"text_blocks",tooltip:"%{BKY_TEXT_CREATE_JOIN_TOOLTIP}",enableContextMenu:!1},{type:"text_create_join_item",message0:"%{BKY_TEXT_CREATE_JOIN_ITEM_TITLE_ITEM}",previousStatement:null,nextStatement:null,style:"text_blocks",tooltip:"%{BKY_TEXT_CREATE_JOIN_ITEM_TOOLTIP}",enableContextMenu:!1},{type:"text_append",message0:"%{BKY_TEXT_APPEND_TITLE}",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_TEXT_APPEND_VARIABLE}"},{type:"input_value",name:"TEXT"}],previousStatement:null,nextStatement:null,style:"text_blocks",extensions:["text_append_tooltip"]},{type:"text_length",message0:"%{BKY_TEXT_LENGTH_TITLE}",args0:[{type:"input_value",name:"VALUE",check:["String","Array"]}],output:"Number",style:"text_blocks",tooltip:"%{BKY_TEXT_LENGTH_TOOLTIP}",helpUrl:"%{BKY_TEXT_LENGTH_HELPURL}"},{type:"text_isEmpty",message0:"%{BKY_TEXT_ISEMPTY_TITLE}",args0:[{type:"input_value",name:"VALUE",check:["String","Array"]}],output:"Boolean",style:"text_blocks",tooltip:"%{BKY_TEXT_ISEMPTY_TOOLTIP}",helpUrl:"%{BKY_TEXT_ISEMPTY_HELPURL}"},{type:"text_indexOf",message0:"%{BKY_TEXT_INDEXOF_TITLE}",args0:[{type:"input_value",name:"VALUE",check:"String"},{type:"field_dropdown",name:"END",options:[["%{BKY_TEXT_INDEXOF_OPERATOR_FIRST}","FIRST"],["%{BKY_TEXT_INDEXOF_OPERATOR_LAST}","LAST"]]},{type:"input_value",name:"FIND",check:"String"}],output:"Number",style:"text_blocks",helpUrl:"%{BKY_TEXT_INDEXOF_HELPURL}",inputsInline:!0,extensions:["text_indexOf_tooltip"]},{type:"text_charAt",message0:"%{BKY_TEXT_CHARAT_TITLE}",args0:[{type:"input_value",name:"VALUE",check:"String"},{type:"field_dropdown",name:"WHERE",options:[["%{BKY_TEXT_CHARAT_FROM_START}","FROM_START"],["%{BKY_TEXT_CHARAT_FROM_END}","FROM_END"],["%{BKY_TEXT_CHARAT_FIRST}","FIRST"],["%{BKY_TEXT_CHARAT_LAST}","LAST"],["%{BKY_TEXT_CHARAT_RANDOM}","RANDOM"]]}],output:"String",style:"text_blocks",helpUrl:"%{BKY_TEXT_CHARAT_HELPURL}",inputsInline:!0,mutator:"text_charAt_mutator"}]),T.Blocks.text_getSubstring={init:function(){this.WHERE_OPTIONS_1=[[T.Msg.TEXT_GET_SUBSTRING_START_FROM_START,"FROM_START"],[T.Msg.TEXT_GET_SUBSTRING_START_FROM_END,"FROM_END"],[T.Msg.TEXT_GET_SUBSTRING_START_FIRST,"FIRST"]],this.WHERE_OPTIONS_2=[[T.Msg.TEXT_GET_SUBSTRING_END_FROM_START,"FROM_START"],[T.Msg.TEXT_GET_SUBSTRING_END_FROM_END,"FROM_END"],[T.Msg.TEXT_GET_SUBSTRING_END_LAST,"LAST"]],this.setHelpUrl(T.Msg.TEXT_GET_SUBSTRING_HELPURL),this.setStyle("text_blocks"),this.appendValueInput("STRING").setCheck("String").appendField(T.Msg.TEXT_GET_SUBSTRING_INPUT_IN_TEXT),this.appendDummyInput("AT1"),this.appendDummyInput("AT2"),T.Msg.TEXT_GET_SUBSTRING_TAIL&&this.appendDummyInput("TAIL").appendField(T.Msg.TEXT_GET_SUBSTRING_TAIL),this.setInputsInline(!0),this.setOutput(!0,"String"),this.updateAt_(1,!0),this.updateAt_(2,!0),this.setTooltip(T.Msg.TEXT_GET_SUBSTRING_TOOLTIP)},mutationToDom:function(){var t=T.utils.xml.createElement("mutation"),e=this.getInput("AT1").type==T.INPUT_VALUE;return t.setAttribute("at1",e),e=this.getInput("AT2").type==T.INPUT_VALUE,t.setAttribute("at2",e),t},domToMutation:function(t){var e="true"==t.getAttribute("at1");t="true"==t.getAttribute("at2"),this.updateAt_(1,e),this.updateAt_(2,t)},updateAt_:function(i,s){this.removeInput("AT"+i),this.removeInput("ORDINAL"+i,!0),s?(this.appendValueInput("AT"+i).setCheck("Number"),T.Msg.ORDINAL_NUMBER_SUFFIX&&this.appendDummyInput("ORDINAL"+i).appendField(T.Msg.ORDINAL_NUMBER_SUFFIX)):this.appendDummyInput("AT"+i),2==i&&T.Msg.TEXT_GET_SUBSTRING_TAIL&&(this.removeInput("TAIL",!0),this.appendDummyInput("TAIL").appendField(T.Msg.TEXT_GET_SUBSTRING_TAIL));var t=new T.FieldDropdown(this["WHERE_OPTIONS_"+i],function(t){var e="FROM_START"==t||"FROM_END"==t,o;if(e!=s)return(o=this.getSourceBlock()).updateAt_(i,e),o.setFieldValue(t,"WHERE"+i),null});this.getInput("AT"+i).appendField(t,"WHERE"+i),1==i&&(this.moveInputBefore("AT1","AT2"),this.getInput("ORDINAL1"))&&this.moveInputBefore("ORDINAL1","AT2")}},T.Blocks.text_changeCase={init:function(){var t=[[T.Msg.TEXT_CHANGECASE_OPERATOR_UPPERCASE,"UPPERCASE"],[T.Msg.TEXT_CHANGECASE_OPERATOR_LOWERCASE,"LOWERCASE"],[T.Msg.TEXT_CHANGECASE_OPERATOR_TITLECASE,"TITLECASE"]];this.setHelpUrl(T.Msg.TEXT_CHANGECASE_HELPURL),this.setStyle("text_blocks"),this.appendValueInput("TEXT").setCheck("String").appendField(new T.FieldDropdown(t),"CASE"),this.setOutput(!0,"String"),this.setTooltip(T.Msg.TEXT_CHANGECASE_TOOLTIP)}},T.Blocks.text_trim={init:function(){var t=[[T.Msg.TEXT_TRIM_OPERATOR_BOTH,"BOTH"],[T.Msg.TEXT_TRIM_OPERATOR_LEFT,"LEFT"],[T.Msg.TEXT_TRIM_OPERATOR_RIGHT,"RIGHT"]];this.setHelpUrl(T.Msg.TEXT_TRIM_HELPURL),this.setStyle("text_blocks"),this.appendValueInput("TEXT").setCheck("String").appendField(new T.FieldDropdown(t),"MODE"),this.setOutput(!0,"String"),this.setTooltip(T.Msg.TEXT_TRIM_TOOLTIP)}},T.Blocks.text_print={init:function(){this.jsonInit({message0:T.Msg.TEXT_PRINT_TITLE,args0:[{type:"input_value",name:"TEXT"}],previousStatement:null,nextStatement:null,style:"text_blocks",tooltip:T.Msg.TEXT_PRINT_TOOLTIP,helpUrl:T.Msg.TEXT_PRINT_HELPURL})}},T.Blocks.text_prompt_ext={init:function(){var t=[[T.Msg.TEXT_PROMPT_TYPE_TEXT,"TEXT"],[T.Msg.TEXT_PROMPT_TYPE_NUMBER,"NUMBER"]],e=(this.setHelpUrl(T.Msg.TEXT_PROMPT_HELPURL),this.setStyle("text_blocks"),this),t=new T.FieldDropdown(t,function(t){e.updateType_(t)});this.appendValueInput("TEXT").appendField(t,"TYPE"),this.setOutput(!0,"String"),this.setTooltip(function(){return"TEXT"==e.getFieldValue("TYPE")?T.Msg.TEXT_PROMPT_TOOLTIP_TEXT:T.Msg.TEXT_PROMPT_TOOLTIP_NUMBER})},updateType_:function(t){this.outputConnection.setCheck("NUMBER"==t?"Number":"String")},mutationToDom:function(){var t=T.utils.xml.createElement("mutation");return t.setAttribute("type",this.getFieldValue("TYPE")),t},domToMutation:function(t){this.updateType_(t.getAttribute("type"))}},T.Blocks.text_prompt={init:function(){this.mixin(T.Constants.Text.QUOTE_IMAGE_MIXIN);var t=[[T.Msg.TEXT_PROMPT_TYPE_TEXT,"TEXT"],[T.Msg.TEXT_PROMPT_TYPE_NUMBER,"NUMBER"]],e=this;this.setHelpUrl(T.Msg.TEXT_PROMPT_HELPURL),this.setStyle("text_blocks"),t=new T.FieldDropdown(t,function(t){e.updateType_(t)}),this.appendDummyInput().appendField(t,"TYPE").appendField(this.newQuote_(!0)).appendField(new T.FieldTextInput(""),"TEXT").appendField(this.newQuote_(!1)),this.setOutput(!0,"String"),this.setTooltip(function(){return"TEXT"==e.getFieldValue("TYPE")?T.Msg.TEXT_PROMPT_TOOLTIP_TEXT:T.Msg.TEXT_PROMPT_TOOLTIP_NUMBER})},updateType_:T.Blocks.text_prompt_ext.updateType_,mutationToDom:T.Blocks.text_prompt_ext.mutationToDom,domToMutation:T.Blocks.text_prompt_ext.domToMutation},T.Blocks.text_count={init:function(){this.jsonInit({message0:T.Msg.TEXT_COUNT_MESSAGE0,args0:[{type:"input_value",name:"SUB",check:"String"},{type:"input_value",name:"TEXT",check:"String"}],output:"Number",inputsInline:!0,style:"text_blocks",tooltip:T.Msg.TEXT_COUNT_TOOLTIP,helpUrl:T.Msg.TEXT_COUNT_HELPURL})}},T.Blocks.text_replace={init:function(){this.jsonInit({message0:T.Msg.TEXT_REPLACE_MESSAGE0,args0:[{type:"input_value",name:"FROM",check:"String"},{type:"input_value",name:"TO",check:"String"},{type:"input_value",name:"TEXT",check:"String"}],output:"String",inputsInline:!0,style:"text_blocks",tooltip:T.Msg.TEXT_REPLACE_TOOLTIP,helpUrl:T.Msg.TEXT_REPLACE_HELPURL})}},T.Blocks.text_reverse={init:function(){this.jsonInit({message0:T.Msg.TEXT_REVERSE_MESSAGE0,args0:[{type:"input_value",name:"TEXT",check:"String"}],output:"String",inputsInline:!0,style:"text_blocks",tooltip:T.Msg.TEXT_REVERSE_TOOLTIP,helpUrl:T.Msg.TEXT_REVERSE_HELPURL})}},T.Constants.Text.QUOTE_IMAGE_MIXIN={QUOTE_IMAGE_LEFT_DATAURI:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAKCAQAAAAqJXdxAAAAn0lEQVQI1z3OMa5BURSF4f/cQhAKjUQhuQmFNwGJEUi0RKN5rU7FHKhpjEH3TEMtkdBSCY1EIv8r7nFX9e29V7EBAOvu7RPjwmWGH/VuF8CyN9/OAdvqIXYLvtRaNjx9mMTDyo+NjAN1HNcl9ZQ5oQMM3dgDUqDo1l8DzvwmtZN7mnD+PkmLa+4mhrxVA9fRowBWmVBhFy5gYEjKMfz9AylsaRRgGzvZAAAAAElFTkSuQmCC",QUOTE_IMAGE_RIGHT_DATAURI:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAKCAQAAAAqJXdxAAAAqUlEQVQI1z3KvUpCcRiA8ef9E4JNHhI0aFEacm1o0BsI0Slx8wa8gLauoDnoBhq7DcfWhggONDmJJgqCPA7neJ7p934EOOKOnM8Q7PDElo/4x4lFb2DmuUjcUzS3URnGib9qaPNbuXvBO3sGPHJDRG6fGVdMSeWDP2q99FQdFrz26Gu5Tq7dFMzUvbXy8KXeAj57cOklgA+u1B5AoslLtGIHQMaCVnwDnADZIFIrXsoXrgAAAABJRU5ErkJggg==",QUOTE_IMAGE_WIDTH:12,QUOTE_IMAGE_HEIGHT:12,quoteField_:function(t){for(var e=0,o;o=this.inputList[e];e++)for(var i=0,s;s=o.fieldRow[i];i++)if(t==s.name)return o.insertFieldAt(i,this.newQuote_(!0)),void o.insertFieldAt(i+2,this.newQuote_(!1));console.warn('field named "'+t+'" not found in '+this.toDevString())},newQuote_:function(t){return t=this.RTL?!t:t,new T.FieldImage(t?this.QUOTE_IMAGE_LEFT_DATAURI:this.QUOTE_IMAGE_RIGHT_DATAURI,this.QUOTE_IMAGE_WIDTH,this.QUOTE_IMAGE_HEIGHT,t?"“":"”")}},T.Constants.Text.TEXT_QUOTES_EXTENSION=function(){this.mixin(T.Constants.Text.QUOTE_IMAGE_MIXIN),this.quoteField_("TEXT")},T.Constants.Text.TEXT_JOIN_MUTATOR_MIXIN={mutationToDom:function(){var t=T.utils.xml.createElement("mutation");return t.setAttribute("items",this.itemCount_),t},domToMutation:function(t){this.itemCount_=parseInt(t.getAttribute("items"),10),this.updateShape_()},decompose:function(t){var e=t.newBlock("text_create_join_container");e.initSvg();for(var o=e.getInput("STACK").connection,i=0;i<this.itemCount_;i++){var s=t.newBlock("text_create_join_item");s.initSvg(),o.connect(s.previousConnection),o=s.nextConnection}return e},compose:function(t){var e=t.getInputTargetBlock("STACK");for(t=[];e&&!e.isInsertionMarker();)t.push(e.valueConnection_),e=e.nextConnection&&e.nextConnection.targetBlock();for(e=0;e<this.itemCount_;e++){var o=this.getInput("ADD"+e).connection.targetConnection;o&&-1==t.indexOf(o)&&o.disconnect()}for(this.itemCount_=t.length,this.updateShape_(),e=0;e<this.itemCount_;e++)T.Mutator.reconnect(t[e],this,"ADD"+e)},saveConnections:function(t){t=t.getInputTargetBlock("STACK");for(var e=0;t;){var o=this.getInput("ADD"+e);t.valueConnection_=o&&o.connection.targetConnection,e++,t=t.nextConnection&&t.nextConnection.targetBlock()}},updateShape_:function(){this.itemCount_&&this.getInput("EMPTY")?this.removeInput("EMPTY"):this.itemCount_||this.getInput("EMPTY")||this.appendDummyInput("EMPTY").appendField(this.newQuote_(!0)).appendField(this.newQuote_(!1));for(var t=0,e;t<this.itemCount_;t++){this.getInput("ADD"+t)||(e=this.appendValueInput("ADD"+t).setAlign(T.ALIGN_RIGHT),0==t&&e.appendField(T.Msg.TEXT_JOIN_TITLE_CREATEWITH))}for(;this.getInput("ADD"+t);)this.removeInput("ADD"+t),t++}},T.Constants.Text.TEXT_JOIN_EXTENSION=function(){this.mixin(T.Constants.Text.QUOTE_IMAGE_MIXIN),this.itemCount_=2,this.updateShape_(),this.setMutator(new T.Mutator(["text_create_join_item"]))},T.Extensions.register("text_append_tooltip",T.Extensions.buildTooltipWithFieldText("%{BKY_TEXT_APPEND_TOOLTIP}","VAR")),T.Constants.Text.TEXT_INDEXOF_TOOLTIP_EXTENSION=function(){var t=this;this.setTooltip(function(){return T.Msg.TEXT_INDEXOF_TOOLTIP.replace("%1",t.workspace.options.oneBasedIndex?"0":"-1")})},T.Constants.Text.TEXT_CHARAT_MUTATOR_MIXIN={mutationToDom:function(){var t=T.utils.xml.createElement("mutation");return t.setAttribute("at",!!this.isAt_),t},domToMutation:function(t){t="false"!=t.getAttribute("at"),this.updateAt_(t)},updateAt_:function(t){this.removeInput("AT",!0),this.removeInput("ORDINAL",!0),t&&(this.appendValueInput("AT").setCheck("Number"),T.Msg.ORDINAL_NUMBER_SUFFIX)&&this.appendDummyInput("ORDINAL").appendField(T.Msg.ORDINAL_NUMBER_SUFFIX),T.Msg.TEXT_CHARAT_TAIL&&(this.removeInput("TAIL",!0),this.appendDummyInput("TAIL").appendField(T.Msg.TEXT_CHARAT_TAIL)),this.isAt_=t}},T.Constants.Text.TEXT_CHARAT_EXTENSION=function(){this.getField("WHERE").setValidator(function(t){(t="FROM_START"==t||"FROM_END"==t)!=this.isAt_&&this.getSourceBlock().updateAt_(t)}),this.updateAt_(!0);var o=this;this.setTooltip(function(){var t=o.getFieldValue("WHERE"),e=T.Msg.TEXT_CHARAT_TOOLTIP;return"FROM_START"!=t&&"FROM_END"!=t||!(t="FROM_START"==t?T.Msg.LISTS_INDEX_FROM_START_TOOLTIP:T.Msg.LISTS_INDEX_FROM_END_TOOLTIP)||(e+="  "+t.replace("%1",o.workspace.options.oneBasedIndex?"#1":"#0")),e})},T.Extensions.register("text_indexOf_tooltip",T.Constants.Text.TEXT_INDEXOF_TOOLTIP_EXTENSION),T.Extensions.register("text_quotes",T.Constants.Text.TEXT_QUOTES_EXTENSION),T.Extensions.registerMutator("text_join_mutator",T.Constants.Text.TEXT_JOIN_MUTATOR_MIXIN,T.Constants.Text.TEXT_JOIN_EXTENSION),T.Extensions.registerMutator("text_charAt_mutator",T.Constants.Text.TEXT_CHARAT_MUTATOR_MIXIN,T.Constants.Text.TEXT_CHARAT_EXTENSION),T.Blocks.variables={},T.Constants.Variables={},T.Constants.Variables.HUE=330,T.defineBlocksWithJsonArray([{type:"variables_get",message0:"%1",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_VARIABLES_DEFAULT_NAME}"}],output:null,style:"variable_blocks",helpUrl:"%{BKY_VARIABLES_GET_HELPURL}",tooltip:"%{BKY_VARIABLES_GET_TOOLTIP}",extensions:["contextMenu_variableSetterGetter"]},{type:"variables_set",message0:"%{BKY_VARIABLES_SET}",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_VARIABLES_DEFAULT_NAME}"},{type:"input_value",name:"VALUE"}],previousStatement:null,nextStatement:null,style:"variable_blocks",tooltip:"%{BKY_VARIABLES_SET_TOOLTIP}",helpUrl:"%{BKY_VARIABLES_SET_HELPURL}",extensions:["contextMenu_variableSetterGetter"]}]),T.Constants.Variables.CUSTOM_CONTEXT_MENU_VARIABLE_GETTER_SETTER_MIXIN={customContextMenu:function(t){var e,o,o,i,s;this.isInFlyout?"variables_get"!=this.type&&"variables_get_reporter"!=this.type||(e={text:T.Msg.RENAME_VARIABLE,enabled:!0,callback:T.Constants.Variables.RENAME_OPTION_CALLBACK_FACTORY(this)},s=this.getField("VAR").getText(),i={text:T.Msg.DELETE_VARIABLE.replace("%1",s),enabled:!0,callback:T.Constants.Variables.DELETE_OPTION_CALLBACK_FACTORY(this)},t.unshift(e),t.unshift(i)):(o="variables_get"==this.type?(e="variables_set",T.Msg.VARIABLES_GET_CREATE_SET):(e="variables_get",T.Msg.VARIABLES_SET_CREATE_GET),i={enabled:0<this.workspace.remainingCapacity()},s=this.getField("VAR").getText(),i.text=o.replace("%1",s),(o=T.utils.xml.createElement("field")).setAttribute("name","VAR"),o.appendChild(T.utils.xml.createTextNode(s)),(s=T.utils.xml.createElement("block")).setAttribute("type",e),s.appendChild(o),i.callback=T.ContextMenu.callbackFactory(this,s),t.push(i))}},T.Constants.Variables.RENAME_OPTION_CALLBACK_FACTORY=function(o){return function(){var t=o.workspace,e=o.getField("VAR").getVariable();T.Variables.renameVariable(t,e)}},T.Constants.Variables.DELETE_OPTION_CALLBACK_FACTORY=function(o){return function(){var t=o.workspace,e=o.getField("VAR").getVariable();t.deleteVariableById(e.getId()),t.refreshToolboxSelection()}},T.Extensions.registerMixin("contextMenu_variableSetterGetter",T.Constants.Variables.CUSTOM_CONTEXT_MENU_VARIABLE_GETTER_SETTER_MIXIN),T.Constants.VariablesDynamic={},T.Constants.VariablesDynamic.HUE=310,T.defineBlocksWithJsonArray([{type:"variables_get_dynamic",message0:"%1",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_VARIABLES_DEFAULT_NAME}"}],output:null,style:"variable_dynamic_blocks",helpUrl:"%{BKY_VARIABLES_GET_HELPURL}",tooltip:"%{BKY_VARIABLES_GET_TOOLTIP}",extensions:["contextMenu_variableDynamicSetterGetter"]},{type:"variables_set_dynamic",message0:"%{BKY_VARIABLES_SET}",args0:[{type:"field_variable",name:"VAR",variable:"%{BKY_VARIABLES_DEFAULT_NAME}"},{type:"input_value",name:"VALUE"}],previousStatement:null,nextStatement:null,style:"variable_dynamic_blocks",tooltip:"%{BKY_VARIABLES_SET_TOOLTIP}",helpUrl:"%{BKY_VARIABLES_SET_HELPURL}",extensions:["contextMenu_variableDynamicSetterGetter"]}]),T.Constants.VariablesDynamic.CUSTOM_CONTEXT_MENU_VARIABLE_GETTER_SETTER_MIXIN={customContextMenu:function(t){var e,o,e,i,i,s,n;this.isInFlyout?"variables_get_dynamic"!=this.type&&"variables_get_reporter_dynamic"!=this.type||(e={text:T.Msg.RENAME_VARIABLE,enabled:!0,callback:T.Constants.Variables.RENAME_OPTION_CALLBACK_FACTORY(this)},n=this.getField("VAR").getText(),s={text:T.Msg.DELETE_VARIABLE.replace("%1",n),enabled:!0,callback:T.Constants.Variables.DELETE_OPTION_CALLBACK_FACTORY(this)},t.unshift(e),t.unshift(s)):(e=this.getFieldValue("VAR"),o=this.workspace.getVariableById(e).type,i="variables_get_dynamic"==this.type?(e="variables_set_dynamic",T.Msg.VARIABLES_GET_CREATE_SET):(e="variables_get_dynamic",T.Msg.VARIABLES_SET_CREATE_GET),s={enabled:0<this.workspace.remainingCapacity()},n=this.getField("VAR").getText(),s.text=i.replace("%1",n),(i=T.utils.xml.createElement("field")).setAttribute("name","VAR"),i.setAttribute("variabletype",o),i.appendChild(T.utils.xml.createTextNode(n)),(n=T.utils.xml.createElement("block")).setAttribute("type",e),n.appendChild(i),s.callback=T.ContextMenu.callbackFactory(this,n),t.push(s))},onchange:function(t){t=this.getFieldValue("VAR"),t=T.Variables.getVariable(this.workspace,t),("variables_get_dynamic"==this.type?this.outputConnection:this.getInput("VALUE").connection).setCheck(t.type)}},T.Constants.VariablesDynamic.RENAME_OPTION_CALLBACK_FACTORY=function(o){return function(){var t=o.workspace,e=o.getField("VAR").getVariable();T.Variables.renameVariable(t,e)}},T.Constants.VariablesDynamic.DELETE_OPTION_CALLBACK_FACTORY=function(o){return function(){var t=o.workspace,e=o.getField("VAR").getVariable();t.deleteVariableById(e.getId()),t.refreshToolboxSelection()}},T.Extensions.registerMixin("contextMenu_variableDynamicSetterGetter",T.Constants.VariablesDynamic.CUSTOM_CONTEXT_MENU_VARIABLE_GETTER_SETTER_MIXIN),T.Msg["ADD_COMMENT"]="Add Comment",T.Msg["CANNOT_DELETE_VARIABLE_PROCEDURE"]="Can't delete the variable '%1' because it's part of the definition of the function '%2'",T.Msg["CHANGE_VALUE_TITLE"]="Change value:",T.Msg["CLEAN_UP"]="Clean up Blocks",T.Msg["COLLAPSED_WARNINGS_WARNING"]="Collapsed blocks contain warnings.",T.Msg["COLLAPSE_ALL"]="Collapse Blocks",T.Msg["COLLAPSE_BLOCK"]="Collapse Block",T.Msg["COLOUR_BLEND_COLOUR1"]="colour 1",T.Msg["COLOUR_BLEND_COLOUR2"]="colour 2",T.Msg["COLOUR_BLEND_HELPURL"]="https://meyerweb.com/eric/tools/color-blend/#:::rgbp",T.Msg["COLOUR_BLEND_RATIO"]="ratio",T.Msg["COLOUR_BLEND_TITLE"]="blend",T.Msg["COLOUR_BLEND_TOOLTIP"]="Blends two colours together with a given ratio (0.0 - 1.0).",T.Msg["COLOUR_PICKER_HELPURL"]="https://en.wikipedia.org/wiki/Color",T.Msg["COLOUR_PICKER_TOOLTIP"]="Choose a colour from the palette.",T.Msg["COLOUR_RANDOM_HELPURL"]="http://randomcolour.com",T.Msg["COLOUR_RANDOM_TITLE"]="random colour",T.Msg["COLOUR_RANDOM_TOOLTIP"]="Choose a colour at random.",T.Msg["COLOUR_RGB_BLUE"]="blue",T.Msg["COLOUR_RGB_GREEN"]="green",T.Msg["COLOUR_RGB_HELPURL"]="https://www.december.com/html/spec/colorpercompact.html",T.Msg["COLOUR_RGB_RED"]="red",T.Msg["COLOUR_RGB_TITLE"]="colour with",T.Msg["COLOUR_RGB_TOOLTIP"]="Create a colour with the specified amount of red, green, and blue. All values must be between 0 and 100.",T.Msg["CONTROLS_FLOW_STATEMENTS_HELPURL"]="https://github.com/google/blockly/wiki/Loops#loop-termination-blocks",T.Msg["CONTROLS_FLOW_STATEMENTS_OPERATOR_BREAK"]="break out of loop",T.Msg["CONTROLS_FLOW_STATEMENTS_OPERATOR_CONTINUE"]="continue with next iteration of loop",T.Msg["CONTROLS_FLOW_STATEMENTS_TOOLTIP_BREAK"]="Break out of the containing loop.",T.Msg["CONTROLS_FLOW_STATEMENTS_TOOLTIP_CONTINUE"]="Skip the rest of this loop, and continue with the next iteration.",T.Msg["CONTROLS_FLOW_STATEMENTS_WARNING"]="Warning: This block may only be used within a loop.",T.Msg["CONTROLS_FOREACH_HELPURL"]="https://github.com/google/blockly/wiki/Loops#for-each",T.Msg["CONTROLS_FOREACH_TITLE"]="for each item %1 in list %2",T.Msg["CONTROLS_FOREACH_TOOLTIP"]="For each item in a list, set the variable '%1' to the item, and then do some statements.",T.Msg["CONTROLS_FOR_HELPURL"]="https://github.com/google/blockly/wiki/Loops#count-with",T.Msg["CONTROLS_FOR_TITLE"]="count with %1 from %2 to %3 by %4",T.Msg["CONTROLS_FOR_TOOLTIP"]="Have the variable '%1' take on the values from the start number to the end number, counting by the specified interval, and do the specified blocks.",T.Msg["CONTROLS_IF_ELSEIF_TOOLTIP"]="Add a condition to the if block.",T.Msg["CONTROLS_IF_ELSE_TOOLTIP"]="Add a final, catch-all condition to the if block.",T.Msg["CONTROLS_IF_HELPURL"]="https://github.com/google/blockly/wiki/IfElse",T.Msg["CONTROLS_IF_IF_TOOLTIP"]="Add, remove, or reorder sections to reconfigure this if block.",T.Msg["CONTROLS_IF_MSG_ELSE"]="else",T.Msg["CONTROLS_IF_MSG_ELSEIF"]="else if",T.Msg["CONTROLS_IF_MSG_IF"]="if",T.Msg["CONTROLS_IF_TOOLTIP_1"]="If a value is true, then do some statements.",T.Msg["CONTROLS_IF_TOOLTIP_2"]="If a value is true, then do the first block of statements. Otherwise, do the second block of statements.",T.Msg["CONTROLS_IF_TOOLTIP_3"]="If the first value is true, then do the first block of statements. Otherwise, if the second value is true, do the second block of statements.",T.Msg["CONTROLS_IF_TOOLTIP_4"]="If the first value is true, then do the first block of statements. Otherwise, if the second value is true, do the second block of statements. If none of the values are true, do the last block of statements.",T.Msg["CONTROLS_REPEAT_HELPURL"]="https://en.wikipedia.org/wiki/For_loop",T.Msg["CONTROLS_REPEAT_INPUT_DO"]="do",T.Msg["CONTROLS_REPEAT_TITLE"]="repeat %1 times",T.Msg["CONTROLS_REPEAT_TOOLTIP"]="Do some statements several times.",T.Msg["CONTROLS_WHILEUNTIL_HELPURL"]="https://github.com/google/blockly/wiki/Loops#repeat",T.Msg["CONTROLS_WHILEUNTIL_OPERATOR_UNTIL"]="repeat until",T.Msg["CONTROLS_WHILEUNTIL_OPERATOR_WHILE"]="repeat while",T.Msg["CONTROLS_WHILEUNTIL_TOOLTIP_UNTIL"]="While a value is false, then do some statements.",T.Msg["CONTROLS_WHILEUNTIL_TOOLTIP_WHILE"]="While a value is true, then do some statements.",T.Msg["DELETE_ALL_BLOCKS"]="Delete all %1 blocks?",T.Msg["DELETE_BLOCK"]="Delete Block",T.Msg["DELETE_VARIABLE"]="Delete the '%1' variable",T.Msg["DELETE_VARIABLE_CONFIRMATION"]="Delete %1 uses of the '%2' variable?",T.Msg["DELETE_X_BLOCKS"]="Delete %1 Blocks",T.Msg["DISABLE_BLOCK"]="Disable Block",T.Msg["DUPLICATE_BLOCK"]="Duplicate",T.Msg["DUPLICATE_COMMENT"]="Duplicate Comment",T.Msg["ENABLE_BLOCK"]="Enable Block",T.Msg["EXPAND_ALL"]="Expand Blocks",T.Msg["EXPAND_BLOCK"]="Expand Block",T.Msg["EXTERNAL_INPUTS"]="External Inputs",T.Msg["HELP"]="Help",T.Msg["INLINE_INPUTS"]="Inline Inputs",T.Msg["IOS_CANCEL"]="Cancel",T.Msg["IOS_ERROR"]="Error",T.Msg["IOS_OK"]="OK",T.Msg["IOS_PROCEDURES_ADD_INPUT"]="+ Add Input",T.Msg["IOS_PROCEDURES_ALLOW_STATEMENTS"]="Allow statements",T.Msg["IOS_PROCEDURES_DUPLICATE_INPUTS_ERROR"]="This function has duplicate inputs.",T.Msg["IOS_PROCEDURES_INPUTS"]="INPUTS",T.Msg["IOS_VARIABLES_ADD_BUTTON"]="Add",T.Msg["IOS_VARIABLES_ADD_VARIABLE"]="+ Add Variable",T.Msg["IOS_VARIABLES_DELETE_BUTTON"]="Delete",T.Msg["IOS_VARIABLES_EMPTY_NAME_ERROR"]="You can't use an empty variable name.",T.Msg["IOS_VARIABLES_RENAME_BUTTON"]="Rename",T.Msg["IOS_VARIABLES_VARIABLE_NAME"]="Variable name",T.Msg["LISTS_CREATE_EMPTY_HELPURL"]="https://github.com/google/blockly/wiki/Lists#create-empty-list",T.Msg["LISTS_CREATE_EMPTY_TITLE"]="create empty list",T.Msg["LISTS_CREATE_EMPTY_TOOLTIP"]="Returns a list, of length 0, containing no data records",T.Msg["LISTS_CREATE_WITH_CONTAINER_TITLE_ADD"]="list",T.Msg["LISTS_CREATE_WITH_CONTAINER_TOOLTIP"]="Add, remove, or reorder sections to reconfigure this list block.",T.Msg["LISTS_CREATE_WITH_HELPURL"]="https://github.com/google/blockly/wiki/Lists#create-list-with",T.Msg["LISTS_CREATE_WITH_INPUT_WITH"]="create list with",T.Msg["LISTS_CREATE_WITH_ITEM_TOOLTIP"]="Add an item to the list.",T.Msg["LISTS_CREATE_WITH_TOOLTIP"]="Create a list with any number of items.",T.Msg["LISTS_GET_INDEX_FIRST"]="first",T.Msg["LISTS_GET_INDEX_FROM_END"]="# from end",T.Msg["LISTS_GET_INDEX_FROM_START"]="#",T.Msg["LISTS_GET_INDEX_GET"]="get",T.Msg["LISTS_GET_INDEX_GET_REMOVE"]="get and remove",T.Msg["LISTS_GET_INDEX_LAST"]="last",T.Msg["LISTS_GET_INDEX_RANDOM"]="random",T.Msg["LISTS_GET_INDEX_REMOVE"]="remove",T.Msg["LISTS_GET_INDEX_TAIL"]="",T.Msg["LISTS_GET_INDEX_TOOLTIP_GET_FIRST"]="Returns the first item in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_GET_FROM"]="Returns the item at the specified position in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_GET_LAST"]="Returns the last item in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_GET_RANDOM"]="Returns a random item in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_FIRST"]="Removes and returns the first item in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_FROM"]="Removes and returns the item at the specified position in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_LAST"]="Removes and returns the last item in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_GET_REMOVE_RANDOM"]="Removes and returns a random item in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_REMOVE_FIRST"]="Removes the first item in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_REMOVE_FROM"]="Removes the item at the specified position in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_REMOVE_LAST"]="Removes the last item in a list.",T.Msg["LISTS_GET_INDEX_TOOLTIP_REMOVE_RANDOM"]="Removes a random item in a list.",T.Msg["LISTS_GET_SUBLIST_END_FROM_END"]="to # from end",T.Msg["LISTS_GET_SUBLIST_END_FROM_START"]="to #",T.Msg["LISTS_GET_SUBLIST_END_LAST"]="to last",T.Msg["LISTS_GET_SUBLIST_HELPURL"]="https://github.com/google/blockly/wiki/Lists#getting-a-sublist",T.Msg["LISTS_GET_SUBLIST_START_FIRST"]="get sub-list from first",T.Msg["LISTS_GET_SUBLIST_START_FROM_END"]="get sub-list from # from end",T.Msg["LISTS_GET_SUBLIST_START_FROM_START"]="get sub-list from #",T.Msg["LISTS_GET_SUBLIST_TAIL"]="",T.Msg["LISTS_GET_SUBLIST_TOOLTIP"]="Creates a copy of the specified portion of a list.",T.Msg["LISTS_INDEX_FROM_END_TOOLTIP"]="%1 is the last item.",T.Msg["LISTS_INDEX_FROM_START_TOOLTIP"]="%1 is the first item.",T.Msg["LISTS_INDEX_OF_FIRST"]="find first occurrence of item",T.Msg["LISTS_INDEX_OF_HELPURL"]="https://github.com/google/blockly/wiki/Lists#getting-items-from-a-list",T.Msg["LISTS_INDEX_OF_LAST"]="find last occurrence of item",T.Msg["LISTS_INDEX_OF_TOOLTIP"]="Returns the index of the first/last occurrence of the item in the list. Returns %1 if item is not found.",T.Msg["LISTS_INLIST"]="in list",T.Msg["LISTS_ISEMPTY_HELPURL"]="https://github.com/google/blockly/wiki/Lists#is-empty",T.Msg["LISTS_ISEMPTY_TITLE"]="%1 is empty",T.Msg["LISTS_ISEMPTY_TOOLTIP"]="Returns true if the list is empty.",T.Msg["LISTS_LENGTH_HELPURL"]="https://github.com/google/blockly/wiki/Lists#length-of",T.Msg["LISTS_LENGTH_TITLE"]="length of %1",T.Msg["LISTS_LENGTH_TOOLTIP"]="Returns the length of a list.",T.Msg["LISTS_REPEAT_HELPURL"]="https://github.com/google/blockly/wiki/Lists#create-list-with",T.Msg["LISTS_REPEAT_TITLE"]="create list with item %1 repeated %2 times",T.Msg["LISTS_REPEAT_TOOLTIP"]="Creates a list consisting of the given value repeated the specified number of times.",T.Msg["LISTS_REVERSE_HELPURL"]="https://github.com/google/blockly/wiki/Lists#reversing-a-list",T.Msg["LISTS_REVERSE_MESSAGE0"]="reverse %1",T.Msg["LISTS_REVERSE_TOOLTIP"]="Reverse a copy of a list.",T.Msg["LISTS_SET_INDEX_HELPURL"]="https://github.com/google/blockly/wiki/Lists#in-list--set",T.Msg["LISTS_SET_INDEX_INPUT_TO"]="as",T.Msg["LISTS_SET_INDEX_INSERT"]="insert at",T.Msg["LISTS_SET_INDEX_SET"]="set",T.Msg["LISTS_SET_INDEX_TOOLTIP_INSERT_FIRST"]="Inserts the item at the start of a list.",T.Msg["LISTS_SET_INDEX_TOOLTIP_INSERT_FROM"]="Inserts the item at the specified position in a list.",T.Msg["LISTS_SET_INDEX_TOOLTIP_INSERT_LAST"]="Append the item to the end of a list.",T.Msg["LISTS_SET_INDEX_TOOLTIP_INSERT_RANDOM"]="Inserts the item randomly in a list.",T.Msg["LISTS_SET_INDEX_TOOLTIP_SET_FIRST"]="Sets the first item in a list.",T.Msg["LISTS_SET_INDEX_TOOLTIP_SET_FROM"]="Sets the item at the specified position in a list.",T.Msg["LISTS_SET_INDEX_TOOLTIP_SET_LAST"]="Sets the last item in a list.",T.Msg["LISTS_SET_INDEX_TOOLTIP_SET_RANDOM"]="Sets a random item in a list.",T.Msg["LISTS_SORT_HELPURL"]="https://github.com/google/blockly/wiki/Lists#sorting-a-list",T.Msg["LISTS_SORT_ORDER_ASCENDING"]="ascending",T.Msg["LISTS_SORT_ORDER_DESCENDING"]="descending",T.Msg["LISTS_SORT_TITLE"]="sort %1 %2 %3",T.Msg["LISTS_SORT_TOOLTIP"]="Sort a copy of a list.",T.Msg["LISTS_SORT_TYPE_IGNORECASE"]="alphabetic, ignore case",T.Msg["LISTS_SORT_TYPE_NUMERIC"]="numeric",T.Msg["LISTS_SORT_TYPE_TEXT"]="alphabetic",T.Msg["LISTS_SPLIT_HELPURL"]="https://github.com/google/blockly/wiki/Lists#splitting-strings-and-joining-lists",T.Msg["LISTS_SPLIT_LIST_FROM_TEXT"]="make list from text",T.Msg["LISTS_SPLIT_TEXT_FROM_LIST"]="make text from list",T.Msg["LISTS_SPLIT_TOOLTIP_JOIN"]="Join a list of texts into one text, separated by a delimiter.",T.Msg["LISTS_SPLIT_TOOLTIP_SPLIT"]="Split text into a list of texts, breaking at each delimiter.",T.Msg["LISTS_SPLIT_WITH_DELIMITER"]="with delimiter",T.Msg["LOGIC_BOOLEAN_FALSE"]="false",T.Msg["LOGIC_BOOLEAN_HELPURL"]="https://github.com/google/blockly/wiki/Logic#values",T.Msg["LOGIC_BOOLEAN_TOOLTIP"]="Returns either true or false.",T.Msg["LOGIC_BOOLEAN_TRUE"]="true",T.Msg["LOGIC_COMPARE_HELPURL"]="https://en.wikipedia.org/wiki/Inequality_(mathematics)",T.Msg["LOGIC_COMPARE_TOOLTIP_EQ"]="Return true if both inputs equal each other.",T.Msg["LOGIC_COMPARE_TOOLTIP_GT"]="Return true if the first input is greater than the second input.",T.Msg["LOGIC_COMPARE_TOOLTIP_GTE"]="Return true if the first input is greater than or equal to the second input.",T.Msg["LOGIC_COMPARE_TOOLTIP_LT"]="Return true if the first input is smaller than the second input.",T.Msg["LOGIC_COMPARE_TOOLTIP_LTE"]="Return true if the first input is smaller than or equal to the second input.",T.Msg["LOGIC_COMPARE_TOOLTIP_NEQ"]="Return true if both inputs are not equal to each other.",T.Msg["LOGIC_NEGATE_HELPURL"]="https://github.com/google/blockly/wiki/Logic#not",T.Msg["LOGIC_NEGATE_TITLE"]="not %1",T.Msg["LOGIC_NEGATE_TOOLTIP"]="Returns true if the input is false. Returns false if the input is true.",T.Msg["LOGIC_NULL"]="null",T.Msg["LOGIC_NULL_HELPURL"]="https://en.wikipedia.org/wiki/Nullable_type",T.Msg["LOGIC_NULL_TOOLTIP"]="Returns null.",T.Msg["LOGIC_OPERATION_AND"]="and",T.Msg["LOGIC_OPERATION_HELPURL"]="https://github.com/google/blockly/wiki/Logic#logical-operations",T.Msg["LOGIC_OPERATION_OR"]="or",T.Msg["LOGIC_OPERATION_TOOLTIP_AND"]="Return true if both inputs are true.",T.Msg["LOGIC_OPERATION_TOOLTIP_OR"]="Return true if at least one of the inputs is true.",T.Msg["LOGIC_TERNARY_CONDITION"]="test",T.Msg["LOGIC_TERNARY_HELPURL"]="https://en.wikipedia.org/wiki/%3F:",T.Msg["LOGIC_TERNARY_IF_FALSE"]="if false",T.Msg["LOGIC_TERNARY_IF_TRUE"]="if true",T.Msg["LOGIC_TERNARY_TOOLTIP"]="Check the condition in 'test'. If the condition is true, returns the 'if true' value; otherwise returns the 'if false' value.",T.Msg["MATH_ADDITION_SYMBOL"]="+",T.Msg["MATH_ARITHMETIC_HELPURL"]="https://en.wikipedia.org/wiki/Arithmetic",T.Msg["MATH_ARITHMETIC_TOOLTIP_ADD"]="Return the sum of the two numbers.",T.Msg["MATH_ARITHMETIC_TOOLTIP_DIVIDE"]="Return the quotient of the two numbers.",T.Msg["MATH_ARITHMETIC_TOOLTIP_MINUS"]="Return the difference of the two numbers.",T.Msg["MATH_ARITHMETIC_TOOLTIP_MULTIPLY"]="Return the product of the two numbers.",T.Msg["MATH_ARITHMETIC_TOOLTIP_POWER"]="Return the first number raised to the power of the second number.",T.Msg["MATH_ATAN2_HELPURL"]="https://en.wikipedia.org/wiki/Atan2",T.Msg["MATH_ATAN2_TITLE"]="atan2 of X:%1 Y:%2",T.Msg["MATH_ATAN2_TOOLTIP"]="Return the arctangent of point (X, Y) in degrees from -180 to 180.",T.Msg["MATH_CHANGE_HELPURL"]="https://en.wikipedia.org/wiki/Programming_idiom#Incrementing_a_counter",T.Msg["MATH_CHANGE_TITLE"]="change %1 by %2",T.Msg["MATH_CHANGE_TOOLTIP"]="Add a number to variable '%1'.",T.Msg["MATH_CONSTANT_HELPURL"]="https://en.wikipedia.org/wiki/Mathematical_constant",T.Msg["MATH_CONSTANT_TOOLTIP"]="Return one of the common constants: π (3.141…), e (2.718…), φ (1.618…), sqrt(2) (1.414…), sqrt(½) (0.707…), or ∞ (infinity).",T.Msg["MATH_CONSTRAIN_HELPURL"]="https://en.wikipedia.org/wiki/Clamping_(graphics)",T.Msg["MATH_CONSTRAIN_TITLE"]="constrain %1 low %2 high %3",T.Msg["MATH_CONSTRAIN_TOOLTIP"]="Constrain a number to be between the specified limits (inclusive).",T.Msg["MATH_DIVISION_SYMBOL"]="÷",T.Msg["MATH_IS_DIVISIBLE_BY"]="is divisible by",T.Msg["MATH_IS_EVEN"]="is even",T.Msg["MATH_IS_NEGATIVE"]="is negative",T.Msg["MATH_IS_ODD"]="is odd",T.Msg["MATH_IS_POSITIVE"]="is positive",T.Msg["MATH_IS_PRIME"]="is prime",T.Msg["MATH_IS_TOOLTIP"]="Check if a number is an even, odd, prime, whole, positive, negative, or if it is divisible by certain number. Returns true or false.",T.Msg["MATH_IS_WHOLE"]="is whole",T.Msg["MATH_MODULO_HELPURL"]="https://en.wikipedia.org/wiki/Modulo_operation",T.Msg["MATH_MODULO_TITLE"]="remainder of %1 ÷ %2",T.Msg["MATH_MODULO_TOOLTIP"]="Return the remainder from dividing the two numbers.",T.Msg["MATH_MULTIPLICATION_SYMBOL"]="×",T.Msg["MATH_NUMBER_HELPURL"]="https://en.wikipedia.org/wiki/Number",T.Msg["MATH_NUMBER_TOOLTIP"]="A number.",T.Msg["MATH_ONLIST_HELPURL"]="",T.Msg["MATH_ONLIST_OPERATOR_AVERAGE"]="average of list",T.Msg["MATH_ONLIST_OPERATOR_MAX"]="max of list",T.Msg["MATH_ONLIST_OPERATOR_MEDIAN"]="median of list",T.Msg["MATH_ONLIST_OPERATOR_MIN"]="min of list",T.Msg["MATH_ONLIST_OPERATOR_MODE"]="modes of list",T.Msg["MATH_ONLIST_OPERATOR_RANDOM"]="random item of list",T.Msg["MATH_ONLIST_OPERATOR_STD_DEV"]="standard deviation of list",T.Msg["MATH_ONLIST_OPERATOR_SUM"]="sum of list",T.Msg["MATH_ONLIST_TOOLTIP_AVERAGE"]="Return the average (arithmetic mean) of the numeric values in the list.",T.Msg["MATH_ONLIST_TOOLTIP_MAX"]="Return the largest number in the list.",T.Msg["MATH_ONLIST_TOOLTIP_MEDIAN"]="Return the median number in the list.",T.Msg["MATH_ONLIST_TOOLTIP_MIN"]="Return the smallest number in the list.",T.Msg["MATH_ONLIST_TOOLTIP_MODE"]="Return a list of the most common item(s) in the list.",T.Msg["MATH_ONLIST_TOOLTIP_RANDOM"]="Return a random element from the list.",T.Msg["MATH_ONLIST_TOOLTIP_STD_DEV"]="Return the standard deviation of the list.",T.Msg["MATH_ONLIST_TOOLTIP_SUM"]="Return the sum of all the numbers in the list.",T.Msg["MATH_POWER_SYMBOL"]="^",T.Msg["MATH_RANDOM_FLOAT_HELPURL"]="https://en.wikipedia.org/wiki/Random_number_generation",T.Msg["MATH_RANDOM_FLOAT_TITLE_RANDOM"]="random fraction",T.Msg["MATH_RANDOM_FLOAT_TOOLTIP"]="Return a random fraction between 0.0 (inclusive) and 1.0 (exclusive).",T.Msg["MATH_RANDOM_INT_HELPURL"]="https://en.wikipedia.org/wiki/Random_number_generation",T.Msg["MATH_RANDOM_INT_TITLE"]="random integer from %1 to %2",T.Msg["MATH_RANDOM_INT_TOOLTIP"]="Return a random integer between the two specified limits, inclusive.",T.Msg["MATH_ROUND_HELPURL"]="https://en.wikipedia.org/wiki/Rounding",T.Msg["MATH_ROUND_OPERATOR_ROUND"]="round",T.Msg["MATH_ROUND_OPERATOR_ROUNDDOWN"]="round down",T.Msg["MATH_ROUND_OPERATOR_ROUNDUP"]="round up",T.Msg["MATH_ROUND_TOOLTIP"]="Round a number up or down.",T.Msg["MATH_SINGLE_HELPURL"]="https://en.wikipedia.org/wiki/Square_root",T.Msg["MATH_SINGLE_OP_ABSOLUTE"]="absolute",T.Msg["MATH_SINGLE_OP_ROOT"]="square root",T.Msg["MATH_SINGLE_TOOLTIP_ABS"]="Return the absolute value of a number.",T.Msg["MATH_SINGLE_TOOLTIP_EXP"]="Return e to the power of a number.",T.Msg["MATH_SINGLE_TOOLTIP_LN"]="Return the natural logarithm of a number.",T.Msg["MATH_SINGLE_TOOLTIP_LOG10"]="Return the base 10 logarithm of a number.",T.Msg["MATH_SINGLE_TOOLTIP_NEG"]="Return the negation of a number.",T.Msg["MATH_SINGLE_TOOLTIP_POW10"]="Return 10 to the power of a number.",T.Msg["MATH_SINGLE_TOOLTIP_ROOT"]="Return the square root of a number.",T.Msg["MATH_SUBTRACTION_SYMBOL"]="-",T.Msg["MATH_TRIG_ACOS"]="acos",T.Msg["MATH_TRIG_ASIN"]="asin",T.Msg["MATH_TRIG_ATAN"]="atan",T.Msg["MATH_TRIG_COS"]="cos",T.Msg["MATH_TRIG_HELPURL"]="https://en.wikipedia.org/wiki/Trigonometric_functions",T.Msg["MATH_TRIG_SIN"]="sin",T.Msg["MATH_TRIG_TAN"]="tan",T.Msg["MATH_TRIG_TOOLTIP_ACOS"]="Return the arccosine of a number.",T.Msg["MATH_TRIG_TOOLTIP_ASIN"]="Return the arcsine of a number.",T.Msg["MATH_TRIG_TOOLTIP_ATAN"]="Return the arctangent of a number.",T.Msg["MATH_TRIG_TOOLTIP_COS"]="Return the cosine of a degree (not radian).",T.Msg["MATH_TRIG_TOOLTIP_SIN"]="Return the sine of a degree (not radian).",T.Msg["MATH_TRIG_TOOLTIP_TAN"]="Return the tangent of a degree (not radian).",T.Msg["NEW_COLOUR_VARIABLE"]="Create colour variable...",T.Msg["NEW_NUMBER_VARIABLE"]="Create number variable...",T.Msg["NEW_STRING_VARIABLE"]="Create string variable...",T.Msg["NEW_VARIABLE"]="Create variable...",T.Msg["NEW_VARIABLE_TITLE"]="New variable name:",T.Msg["NEW_VARIABLE_TYPE_TITLE"]="New variable type:",T.Msg["ORDINAL_NUMBER_SUFFIX"]="",T.Msg["PROCEDURES_ALLOW_STATEMENTS"]="allow statements",T.Msg["PROCEDURES_BEFORE_PARAMS"]="with:",T.Msg["PROCEDURES_CALLNORETURN_HELPURL"]="https://en.wikipedia.org/wiki/Subroutine",T.Msg["PROCEDURES_CALLNORETURN_TOOLTIP"]="Run the user-defined function '%1'.",T.Msg["PROCEDURES_CALLRETURN_HELPURL"]="https://en.wikipedia.org/wiki/Subroutine",T.Msg["PROCEDURES_CALLRETURN_TOOLTIP"]="Run the user-defined function '%1' and use its output.",T.Msg["PROCEDURES_CALL_BEFORE_PARAMS"]="with:",T.Msg["PROCEDURES_CREATE_DO"]="Create '%1'",T.Msg["PROCEDURES_DEFNORETURN_COMMENT"]="Describe this function...",T.Msg["PROCEDURES_DEFNORETURN_DO"]="",T.Msg["PROCEDURES_DEFNORETURN_HELPURL"]="https://en.wikipedia.org/wiki/Subroutine",T.Msg["PROCEDURES_DEFNORETURN_PROCEDURE"]="do something",T.Msg["PROCEDURES_DEFNORETURN_TITLE"]="to",T.Msg["PROCEDURES_DEFNORETURN_TOOLTIP"]="Creates a function with no output.",T.Msg["PROCEDURES_DEFRETURN_HELPURL"]="https://en.wikipedia.org/wiki/Subroutine",T.Msg["PROCEDURES_DEFRETURN_RETURN"]="return",T.Msg["PROCEDURES_DEFRETURN_TOOLTIP"]="Creates a function with an output.",T.Msg["PROCEDURES_DEF_DUPLICATE_WARNING"]="Warning: This function has duplicate parameters.",T.Msg["PROCEDURES_HIGHLIGHT_DEF"]="Highlight function definition",T.Msg["PROCEDURES_IFRETURN_HELPURL"]="http://c2.com/cgi/wiki?GuardClause",T.Msg["PROCEDURES_IFRETURN_TOOLTIP"]="If a value is true, then return a second value.",T.Msg["PROCEDURES_IFRETURN_WARNING"]="Warning: This block may be used only within a function definition.",T.Msg["PROCEDURES_MUTATORARG_TITLE"]="input name:",T.Msg["PROCEDURES_MUTATORARG_TOOLTIP"]="Add an input to the function.",T.Msg["PROCEDURES_MUTATORCONTAINER_TITLE"]="inputs",T.Msg["PROCEDURES_MUTATORCONTAINER_TOOLTIP"]="Add, remove, or reorder inputs to this function.",T.Msg["REDO"]="Redo",T.Msg["REMOVE_COMMENT"]="Remove Comment",T.Msg["RENAME_VARIABLE"]="Rename variable...",T.Msg["RENAME_VARIABLE_TITLE"]="Rename all '%1' variables to:",T.Msg["TEXT_APPEND_HELPURL"]="https://github.com/google/blockly/wiki/Text#text-modification",T.Msg["TEXT_APPEND_TITLE"]="to %1 append text %2",T.Msg["TEXT_APPEND_TOOLTIP"]="Append some text to variable '%1'.",T.Msg["TEXT_CHANGECASE_HELPURL"]="https://github.com/google/blockly/wiki/Text#adjusting-text-case",T.Msg["TEXT_CHANGECASE_OPERATOR_LOWERCASE"]="to lower case",T.Msg["TEXT_CHANGECASE_OPERATOR_TITLECASE"]="to Title Case",T.Msg["TEXT_CHANGECASE_OPERATOR_UPPERCASE"]="to UPPER CASE",T.Msg["TEXT_CHANGECASE_TOOLTIP"]="Return a copy of the text in a different case.",T.Msg["TEXT_CHARAT_FIRST"]="get first letter",T.Msg["TEXT_CHARAT_FROM_END"]="get letter # from end",T.Msg["TEXT_CHARAT_FROM_START"]="get letter #",T.Msg["TEXT_CHARAT_HELPURL"]="https://github.com/google/blockly/wiki/Text#extracting-text",T.Msg["TEXT_CHARAT_LAST"]="get last letter",T.Msg["TEXT_CHARAT_RANDOM"]="get random letter",T.Msg["TEXT_CHARAT_TAIL"]="",T.Msg["TEXT_CHARAT_TITLE"]="in text %1 %2",T.Msg["TEXT_CHARAT_TOOLTIP"]="Returns the letter at the specified position.",T.Msg["TEXT_COUNT_HELPURL"]="https://github.com/google/blockly/wiki/Text#counting-substrings",T.Msg["TEXT_COUNT_MESSAGE0"]="count %1 in %2",T.Msg["TEXT_COUNT_TOOLTIP"]="Count how many times some text occurs within some other text.",T.Msg["TEXT_CREATE_JOIN_ITEM_TOOLTIP"]="Add an item to the text.",T.Msg["TEXT_CREATE_JOIN_TITLE_JOIN"]="join",T.Msg["TEXT_CREATE_JOIN_TOOLTIP"]="Add, remove, or reorder sections to reconfigure this text block.",T.Msg["TEXT_GET_SUBSTRING_END_FROM_END"]="to letter # from end",T.Msg["TEXT_GET_SUBSTRING_END_FROM_START"]="to letter #",T.Msg["TEXT_GET_SUBSTRING_END_LAST"]="to last letter",T.Msg["TEXT_GET_SUBSTRING_HELPURL"]="https://github.com/google/blockly/wiki/Text#extracting-a-region-of-text",T.Msg["TEXT_GET_SUBSTRING_INPUT_IN_TEXT"]="in text",T.Msg["TEXT_GET_SUBSTRING_START_FIRST"]="get substring from first letter",T.Msg["TEXT_GET_SUBSTRING_START_FROM_END"]="get substring from letter # from end",T.Msg["TEXT_GET_SUBSTRING_START_FROM_START"]="get substring from letter #",T.Msg["TEXT_GET_SUBSTRING_TAIL"]="",T.Msg["TEXT_GET_SUBSTRING_TOOLTIP"]="Returns a specified portion of the text.",T.Msg["TEXT_INDEXOF_HELPURL"]="https://github.com/google/blockly/wiki/Text#finding-text",T.Msg["TEXT_INDEXOF_OPERATOR_FIRST"]="find first occurrence of text",T.Msg["TEXT_INDEXOF_OPERATOR_LAST"]="find last occurrence of text",T.Msg["TEXT_INDEXOF_TITLE"]="in text %1 %2 %3",T.Msg["TEXT_INDEXOF_TOOLTIP"]="Returns the index of the first/last occurrence of the first text in the second text. Returns %1 if text is not found.",T.Msg["TEXT_ISEMPTY_HELPURL"]="https://github.com/google/blockly/wiki/Text#checking-for-empty-text",T.Msg["TEXT_ISEMPTY_TITLE"]="%1 is empty",T.Msg["TEXT_ISEMPTY_TOOLTIP"]="Returns true if the provided text is empty.",T.Msg["TEXT_JOIN_HELPURL"]="https://github.com/google/blockly/wiki/Text#text-creation",T.Msg["TEXT_JOIN_TITLE_CREATEWITH"]="create text with",T.Msg["TEXT_JOIN_TOOLTIP"]="Create a piece of text by joining together any number of items.",T.Msg["TEXT_LENGTH_HELPURL"]="https://github.com/google/blockly/wiki/Text#text-modification",T.Msg["TEXT_LENGTH_TITLE"]="length of %1",T.Msg["TEXT_LENGTH_TOOLTIP"]="Returns the number of letters (including spaces) in the provided text.",T.Msg["TEXT_PRINT_HELPURL"]="https://github.com/google/blockly/wiki/Text#printing-text",T.Msg["TEXT_PRINT_TITLE"]="print %1",T.Msg["TEXT_PRINT_TOOLTIP"]="Print the specified text, number or other value.",T.Msg["TEXT_PROMPT_HELPURL"]="https://github.com/google/blockly/wiki/Text#getting-input-from-the-user",T.Msg["TEXT_PROMPT_TOOLTIP_NUMBER"]="Prompt for user for a number.",T.Msg["TEXT_PROMPT_TOOLTIP_TEXT"]="Prompt for user for some text.",T.Msg["TEXT_PROMPT_TYPE_NUMBER"]="prompt for number with message",T.Msg["TEXT_PROMPT_TYPE_TEXT"]="prompt for text with message",T.Msg["TEXT_REPLACE_HELPURL"]="https://github.com/google/blockly/wiki/Text#replacing-substrings",T.Msg["TEXT_REPLACE_MESSAGE0"]="replace %1 with %2 in %3",T.Msg["TEXT_REPLACE_TOOLTIP"]="Replace all occurances of some text within some other text.",T.Msg["TEXT_REVERSE_HELPURL"]="https://github.com/google/blockly/wiki/Text#reversing-text",T.Msg["TEXT_REVERSE_MESSAGE0"]="reverse %1",T.Msg["TEXT_REVERSE_TOOLTIP"]="Reverses the order of the characters in the text.",T.Msg["TEXT_TEXT_HELPURL"]="https://en.wikipedia.org/wiki/String_(computer_science)",T.Msg["TEXT_TEXT_TOOLTIP"]="A letter, word, or line of text.",T.Msg["TEXT_TRIM_HELPURL"]="https://github.com/google/blockly/wiki/Text#trimming-removing-spaces",T.Msg["TEXT_TRIM_OPERATOR_BOTH"]="trim spaces from both sides of",T.Msg["TEXT_TRIM_OPERATOR_LEFT"]="trim spaces from left side of",T.Msg["TEXT_TRIM_OPERATOR_RIGHT"]="trim spaces from right side of",T.Msg["TEXT_TRIM_TOOLTIP"]="Return a copy of the text with spaces removed from one or both ends.",T.Msg["TODAY"]="Today",T.Msg["UNDO"]="Undo",T.Msg["UNNAMED_KEY"]="unnamed",T.Msg["VARIABLES_DEFAULT_NAME"]="item",T.Msg["VARIABLES_GET_CREATE_SET"]="Create 'set %1'",T.Msg["VARIABLES_GET_HELPURL"]="https://github.com/google/blockly/wiki/Variables#get",T.Msg["VARIABLES_GET_TOOLTIP"]="Returns the value of this variable.",T.Msg["VARIABLES_SET"]="set %1 to %2",T.Msg["VARIABLES_SET_CREATE_GET"]="Create 'get %1'",T.Msg["VARIABLES_SET_HELPURL"]="https://github.com/google/blockly/wiki/Variables#set",T.Msg["VARIABLES_SET_TOOLTIP"]="Sets this variable to be equal to the input.",T.Msg["VARIABLE_ALREADY_EXISTS"]="A variable named '%1' already exists.",T.Msg["VARIABLE_ALREADY_EXISTS_FOR_ANOTHER_TYPE"]="A variable named '%1' already exists for another type: '%2'.",T.Msg["WORKSPACE_ARIA_LABEL"]="Blockly Workspace",T.Msg["WORKSPACE_COMMENT_DEFAULT_TEXT"]="Say something...",T.Msg["CONTROLS_FOREACH_INPUT_DO"]=T.Msg["CONTROLS_REPEAT_INPUT_DO"],T.Msg["CONTROLS_FOR_INPUT_DO"]=T.Msg["CONTROLS_REPEAT_INPUT_DO"],T.Msg["CONTROLS_IF_ELSEIF_TITLE_ELSEIF"]=T.Msg["CONTROLS_IF_MSG_ELSEIF"],T.Msg["CONTROLS_IF_ELSE_TITLE_ELSE"]=T.Msg["CONTROLS_IF_MSG_ELSE"],T.Msg["CONTROLS_IF_IF_TITLE_IF"]=T.Msg["CONTROLS_IF_MSG_IF"],T.Msg["CONTROLS_IF_MSG_THEN"]=T.Msg["CONTROLS_REPEAT_INPUT_DO"],T.Msg["CONTROLS_WHILEUNTIL_INPUT_DO"]=T.Msg["CONTROLS_REPEAT_INPUT_DO"],T.Msg["LISTS_CREATE_WITH_ITEM_TITLE"]=T.Msg["VARIABLES_DEFAULT_NAME"],T.Msg["LISTS_GET_INDEX_HELPURL"]=T.Msg["LISTS_INDEX_OF_HELPURL"],T.Msg["LISTS_GET_INDEX_INPUT_IN_LIST"]=T.Msg["LISTS_INLIST"],T.Msg["LISTS_GET_SUBLIST_INPUT_IN_LIST"]=T.Msg["LISTS_INLIST"],T.Msg["LISTS_INDEX_OF_INPUT_IN_LIST"]=T.Msg["LISTS_INLIST"],T.Msg["LISTS_SET_INDEX_INPUT_IN_LIST"]=T.Msg["LISTS_INLIST"],T.Msg["MATH_CHANGE_TITLE_ITEM"]=T.Msg["VARIABLES_DEFAULT_NAME"],T.Msg["PROCEDURES_DEFRETURN_COMMENT"]=T.Msg["PROCEDURES_DEFNORETURN_COMMENT"],T.Msg["PROCEDURES_DEFRETURN_DO"]=T.Msg["PROCEDURES_DEFNORETURN_DO"],T.Msg["PROCEDURES_DEFRETURN_PROCEDURE"]=T.Msg["PROCEDURES_DEFNORETURN_PROCEDURE"],T.Msg["PROCEDURES_DEFRETURN_TITLE"]=T.Msg["PROCEDURES_DEFNORETURN_TITLE"],T.Msg["TEXT_APPEND_VARIABLE"]=T.Msg["VARIABLES_DEFAULT_NAME"],T.Msg["TEXT_CREATE_JOIN_ITEM_TITLE_ITEM"]=T.Msg["VARIABLES_DEFAULT_NAME"],T.Msg["MATH_HUE"]="230",T.Msg["LOOPS_HUE"]="120",T.Msg["LISTS_HUE"]="260",T.Msg["LOGIC_HUE"]="210",T.Msg["VARIABLES_HUE"]="330",T.Msg["TEXTS_HUE"]="160",T.Msg["PROCEDURES_HUE"]="290",T.Msg["COLOUR_HUE"]="20",T.Msg["VARIABLES_DYNAMIC_HUE"]="310",T.blocklyToolbox="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",T.blocklyToolboxCurrentValue="PGJsb2NrIHR5cGU9InN0aV9nZXRfY3VycmVudF92YWx1ZSI+PC9ibG9jaz4KPGJsb2NrIHR5cGU9InN0aV9zZXRfY3VycmVudF92YWx1ZSI+CiAgPHZhbHVlIG5hbWU9IlZhbHVlIj4KICAgIDxzaGFkb3cgdHlwZT0idGV4dCI+CiAgICAgIDxmaWVsZCBuYW1lPSJURVhUIj48L2ZpZWxkPgogICAgPC9zaGFkb3c+CiAgPC92YWx1ZT4KPC9ibG9jaz4=",T.blocklyWorkspace="PHhtbCB4bWxucz0iaHR0cHM6Ly9kZXZlbG9wZXJzLmdvb2dsZS5jb20vYmxvY2tseS94bWwiPjwveG1sPg==",T.blocklyBlocks="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",T},s.Blockly=n(),t.ExternalLibrary.Blockly=s.Blockly,"object"==typeof module&&(module.exports=t),{Stimulsoft:t}});