import { ModelService } from './model.service';
import { ControllerService } from './controller.service';
import { ExportService } from './export.service';
import { HelperService } from './helper.service';
import { MailService } from './mail.service';
import { FindService } from './find.service';
import * as i0 from "@angular/core";
export declare class ApiService {
    private model;
    private controller;
    private exportService;
    private helper;
    private mailService;
    private findService;
    EXPORT_FORMATS: string[];
    constructor(model: ModelService, controller: ControllerService, exportService: ExportService, helper: HelperService, mailService: MailService, findService: FindService);
    /**
     * The current page number
     */
    get currentPage(): number;
    set currentPage(value: number);
    /**
     * The total pages count
     */
    get pageCount(): any;
    /**
     * The view mode, can be 'SinglePage', 'Continuous' & 'MultiplePages'
     */
    get viewMode(): string;
    set viewMode(value: string);
    /**
     * The page zoom in percent
     * From 1 to 1000
     */
    get zoom(): number;
    set zoom(value: number);
    /**
     * Zoom page in height
     */
    zoomPageHeight(): void;
    /**
     * Zoom page in width
     */
    zoomPageWidth(): void;
    /**
     * Print to PDF
     */
    printPdf(): void;
    /**
     * Print with preview
     */
    printWithPreview(): void;
    /**
     * Print without preview
     */
    printWithoutPreview(): void;
    /**
     * Show export form
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportForm(format: string): void;
    /**
     * Show export form & email
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportEmailForm(format: string): void;
    /**
     * Export report/dashboard to selected format
     * Use default settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     */
    export(format: string, settings?: any): void;
    /**
     * Export report/dashboard to seleted format & email
     * Use default settings if not specified
     * Use default email settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     *
     * @param email The email
     *
     * @param message The email message
     *
     * @param subject The email subject
     */
    exportEmail(format: string, settings?: any, email?: string, subject?: string, message?: string): void;
    /**
     * Search text in report
     *
     * @param text text to search
     *
     * @param matchCase
     *
     * @param matchWholeWord
     */
    search(text: string, matchCase: boolean, matchWholeWord: boolean): void;
    /**
     * Select next or previous search
     *
     * @param direction 'Next' or 'Previous'
     *
     */
    selectSearchLabel(direction: string): void;
    /**
     * Hide search
     */
    hideSearchLabels(): void;
    private getExportSettings;
    static ɵfac: i0.ɵɵFactoryDeclaration<ApiService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ApiService>;
}
