import { ElementRef, EventEmitter } from '@angular/core';
import { MenuItem } from './meni-item.component';
import { HelperService } from '../services/helper.service';
import { ModelService } from '../services/model.service';
import { MouseService } from '../services/mouse.service';
import { Variable, Item } from '../services/objects';
import { Observable } from 'rxjs';
import * as i0 from "@angular/core";
export declare class Menu {
    private _state?;
    name: string;
    items: MenuItem[];
    parent: ElementRef;
    type: string;
    menuEl?: ElementRef;
    top?: number;
    left?: number;
    innerContent?: ElementRef;
    width?: number;
    height?: number;
    menuStyleName?: string;
    params?: Variable;
    verticalItems?: Item[];
    action?: EventEmitter<any>;
    itemStyleName?: string;
    value?: any;
    sizeStyle?: string;
    onCloseEvent?: any;
    constructor();
    get state(): string;
    set state(value: string);
}
export declare class MenuService {
    private helper;
    private model;
    private mouseService;
    VERTICAL_MENU_NAME: string;
    menuMouseUp: string;
    private _menus;
    private subject;
    constructor(helper: HelperService, model: ModelService, mouseService: MouseService);
    getVisibility(): Observable<Menu>;
    addMenu(menu: Menu): void;
    closeAllMenus(): void;
    isMenuVisible(): boolean;
    showMenu(menuName: string): void;
    private showMenuInternal;
    getMenuCoordinates(parentButton: any, innerContent: any, offsetHeight: number, style: any, isVertMenu: boolean): any;
    get menus(): Menu[];
    getVerticalMenu(): Menu;
    getMenu(name: string): Menu;
    static ɵfac: i0.ɵɵFactoryDeclaration<MenuService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<MenuService>;
}
