import { OnInit, OnChanges } from '@angular/core';
import { ModelService } from '../services/model.service';
import { ExportFormSettings, ExportComponent } from '../services/objects';
import { ExportService } from '../services/export.service';
import { BaseFormComponent } from './base-form.component';
import { HelperService } from '../services/helper.service';
import { FormService } from './form.service';
import { MenuService } from '../menu/menu.service';
import { ButtonComponent } from '../controls/button.component';
import { CollectionsService } from '../services/collections.service';
import { RadioButtonComponent } from '../controls/radio-button.components';
import { ControllerService } from '../services/controller.service';
import * as i0 from "@angular/core";
export declare class ExportFormComponent implements OnInit, OnChanges {
    model: ModelService;
    exportService: ExportService;
    helper: HelperService;
    formService: FormService;
    menuService: MenuService;
    collections: CollectionsService;
    controller: ControllerService;
    private PROPERTY_ALIAS;
    baseForm: BaseFormComponent;
    saveReportMdc: RadioButtonComponent;
    pagesRangeAll: RadioButtonComponent;
    pageRangeCurrentPage: RadioButtonComponent;
    exportFormSettings: ExportFormSettings;
    formVisible: boolean;
    disabledComponents: any;
    constructor(model: ModelService, exportService: ExportService, helper: HelperService, formService: FormService, menuService: MenuService, collections: CollectionsService, controller: ControllerService);
    ngOnChanges(changes: import('@angular/core').SimpleChanges): void;
    ngOnInit(): void;
    action(): void;
    updateDisabledComponents(): void;
    componentAction(comp: ExportComponent, value?: any): void;
    getValue(comp: ExportComponent, component?: string): string;
    changeVisibility(state: string): void;
    showMenu(comp: ExportComponent, button: ButtonComponent): void;
    getTextBoxType(name: string): "password" | "";
    static ɵfac: i0.ɵɵFactoryDeclaration<ExportFormComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<ExportFormComponent, "sti-export-form", never, { "exportFormSettings": "exportFormSettings"; }, {}, never, never, false>;
}
