import * as i0 from '@angular/core';
import { Injectable, EventEmitter, Component, Input, Output, ViewChild, NgModule } from '@angular/core';
import { Subject, throwError } from 'rxjs';
import { timeout, catchError } from 'rxjs/operators';
import * as i1 from '@angular/common/http';
import * as i4 from '@angular/common';
import { CommonModule } from '@angular/common';
import { trigger, state, style, transition, animate, keyframes } from '@angular/animations';

class ComponentDescription {
    constructor(type, caption, img, action, tooltip, arrow, menuItems, margin, selected) {
        this.type = type;
        this.caption = caption;
        this.img = img;
        this.action = action;
        this.tooltip = tooltip;
        this.arrow = arrow;
        this.menuItems = menuItems;
        this.margin = margin;
        this.selected = selected;
        this.selected = false;
    }
}
class ViewerEvent {
    constructor(name, value, bookmarkPage, bookmarkAnchor, componentGuid) {
        this.name = name;
        this.value = value;
        this.bookmarkPage = bookmarkPage;
        this.bookmarkAnchor = bookmarkAnchor;
        this.componentGuid = componentGuid;
    }
}
class ControlClass {
    constructor() {
        this.toolbar = new ControlProps();
        this.reportPanel = new ControlProps();
        this.drillDownPanel = new ControlProps();
        this.findPanel = new ControlProps();
        this.resourcesPanel = new ControlProps();
        this.bookmarksPanel = new ControlProps();
        this.navigatePanel = new ControlProps();
        this.parametersPanel = new ControlProps();
        this.dashboardsPanel = new ControlProps();
        this.viewer = new ControlProps();
        this.tooltip = new ControlProps();
        this.aboutPanel = new ControlProps();
    }
    get head() {
        return document.getElementsByTagName('head')[0];
    }
}
class ControlProps {
    constructor(pageService, el) {
        this.pageService = pageService;
        this.el = el;
        this._visible = false;
        this.subject = new Subject();
        this.enabled = true;
        this.layout = new Rectangle();
    }
    get offsetHeight() {
        var _a;
        return ((_a = this.el) === null || _a === void 0 ? void 0 : _a.nativeElement.offsetHeight) || 0;
    }
    get offsetWidth() {
        var _a;
        return ((_a = this.el) === null || _a === void 0 ? void 0 : _a.nativeElement.offsetWidth) || 0;
    }
    set visible(value) {
        var _a;
        this._visible = value;
        this.subject.next(value);
        (_a = this.pageService) === null || _a === void 0 ? void 0 : _a.calculateLayout();
    }
    get visible() {
        return this._visible;
    }
    getVisibility() {
        return this.subject.asObservable();
    }
    get exists() {
        return this.el != null;
    }
}
class Rectangle {
    constructor(width = 0, height = 0, left = 0, bottom = 0, right = 0) {
        this.width = width;
        this.height = height;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this._top = 0;
    }
    set top(value) {
        this._top = value;
    }
    get top() {
        return this._top;
    }
}
class BookmarkNode {
    constructor(name, url, page, compunentGuid, nodes, open, selected) {
        this.name = name;
        this.url = url;
        this.page = page;
        this.compunentGuid = compunentGuid;
        this.nodes = nodes;
        this.open = open;
        this.selected = selected;
    }
}
class InteractionParams {
    constructor(action, drillDownParameters, drillDownGuid, dashboardDrillDownGuid, variables, sortingParameters, collapsingParameters, isBindingVariable) {
        this.action = action;
        this.drillDownParameters = drillDownParameters;
        this.drillDownGuid = drillDownGuid;
        this.dashboardDrillDownGuid = dashboardDrillDownGuid;
        this.variables = variables;
        this.sortingParameters = sortingParameters;
        this.collapsingParameters = collapsingParameters;
        this.isBindingVariable = isBindingVariable;
    }
}
class InteractionObject {
    constructor(paramsVariables, countColumns, countInColumn) {
        this.paramsVariables = paramsVariables;
        this.countColumns = countColumns;
        this.countInColumn = countInColumn;
    }
}
class Variable {
    constructor(name, alias, description, basicType, type, allowUserValues, dateTimeType, items, key, value, keyTo, isChecked = true, focusOnCreate, visible = true, binding, isNull, isFirstInitialization, checkedStates, isChanged, allowNullableString) {
        this.name = name;
        this.alias = alias;
        this.description = description;
        this.basicType = basicType;
        this.type = type;
        this.allowUserValues = allowUserValues;
        this.dateTimeType = dateTimeType;
        this.items = items;
        this.key = key;
        this.value = value;
        this.keyTo = keyTo;
        this.isChecked = isChecked;
        this.focusOnCreate = focusOnCreate;
        this.visible = visible;
        this.binding = binding;
        this.isNull = isNull;
        this.isFirstInitialization = isFirstInitialization;
        this.checkedStates = checkedStates;
        this.isChanged = isChanged;
        this.allowNullableString = allowNullableString;
    }
}
class DateTimeObject {
    constructor(year, month, day, hours, minutes, seconds) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }
}
class Item {
    constructor(name, caption, imageName, key, haveSubMenu, imageSizes, selected, type) {
        this.name = name;
        this.caption = caption;
        this.imageName = imageName;
        this.key = key;
        this.haveSubMenu = haveSubMenu;
        this.imageSizes = imageSizes;
        this.selected = selected;
        this.type = type;
    }
}
class Message {
    constructor(action, data, subAction) {
        this.action = action;
        this.data = data;
        this.subAction = subAction;
    }
}
class Form {
    constructor(name, left, top, isMooving = false, level, formData) {
        this.name = name;
        this.left = left;
        this.top = top;
        this.isMooving = isMooving;
        this.level = level;
        this.formData = formData;
    }
}
class ExportFormSettings {
    constructor(components, cSettings, openAfterExport, groups, update) {
        this.components = components;
        this.cSettings = cSettings;
        this.openAfterExport = openAfterExport;
        this.groups = groups;
        this.update = update;
    }
}
class ExportGroup {
    constructor(opened) {
        this.opened = opened;
    }
}
class ExportComponent {
    constructor(name, type, margin, label, tooltip, caption, checked, width, disabled, items, key) {
        this.name = name;
        this.type = type;
        this.margin = margin;
        this.label = label;
        this.tooltip = tooltip;
        this.caption = caption;
        this.checked = checked;
        this.width = width;
        this.disabled = disabled;
        this.items = items;
        this.key = key;
    }
}
class DrillDown {
    constructor(caption, selected = false, reportParams, visible) {
        this.caption = caption;
        this.selected = selected;
        this.reportParams = reportParams;
        this.visible = visible;
    }
}
class ErrorMessage {
    constructor(error, type) {
        this.error = error;
        this.type = type;
    }
}
class Resource {
    constructor(name, type, alias, id) {
        this.name = name;
        this.type = type;
        this.alias = alias;
        this.id = id;
    }
}
class NotificationFormOptions {
    constructor(image, message, description, buttonCaption, cancelAction, action) {
        this.image = image;
        this.message = message;
        this.description = description;
        this.buttonCaption = buttonCaption;
        this.cancelAction = cancelAction;
        this.action = action;
    }
}

class ModelService {
    constructor() {
        this._reportParams = {};
        this.controls = new ControlClass();
        this.pages = [];
        this.months = [];
        this.dayOfWeek = [];
        this.dateRanges = [];
        this.encodingData = [];
        this.pdfSecurityCertificates = [];
        this.paperSizes = [];
        this.drillDownButtons = [];
        this.showProgress = false;
    }
    get reportParams() {
        return this._reportParams;
    }
    set reportParams(parameters) {
        this._reportParams.pagesArray = parameters.pagesArray;
        // Apply new report parameters, if not update current page
        if (parameters.action && parameters.action !== 'GetPages') {
            this.reportParams.type = parameters.reportType;
            this.reportParams.drillDownGuid = parameters.drillDownGuid;
            this.reportParams.dashboardDrillDownGuid = parameters.dashboardDrillDownGuid;
            this.reportParams.pagesCount = parameters.pagesCount;
            if (parameters.pageNumber != null) {
                this.reportParams.pageNumber = parameters.pageNumber;
            }
            this.reportParams.zoom = parameters.zoom;
            this.reportParams.viewMode = parameters.viewMode;
            this.reportParams.reportFileName = parameters.reportFileName;
            this.reportParams.collapsingStates = parameters.collapsingStates;
            if (parameters.bookmarksContent) {
                this.reportParams.bookmarksContent = parameters.bookmarksContent;
            }
            if (parameters.resources) {
                this.reportParams.resources = parameters.resources;
            }
            this.reportParams.isCompilationMode = parameters.isCompilationMode;
            if (parameters.variablesValues) {
                this.reportParams.variablesValues = parameters.variablesValues;
            }
            if (parameters.parametersDateFormat) {
                this.options.appearance.parametersPanelDateFormat = parameters.parametersDateFormat;
            }
            if (parameters.tableOfContentsPointers)
                this.reportParams.tableOfContentsPointers = parameters.tableOfContentsPointers;
            this.reportParams.isEditableReport = parameters.isEditableReport;
            if (parameters.userValues) {
                this.options.userValues = parameters.userValues;
            }
            this.reportParams.dashboards = parameters.dashboards;
            this.reportParams.previewSettings = parameters.previewSettings;
        }
    }
    setReportParams(parameters) {
        this._reportParams = parameters;
    }
    getReportParams() {
        return this.copyObject(this._reportParams);
    }
    copyObject(o) {
        if (!o || 'object' !== typeof o) {
            return o;
        }
        const c = 'function' === typeof o.pop ? [] : {};
        let p;
        let v;
        for (p in o) {
            if (o.hasOwnProperty(p) && p !== 'pagesArray') {
                v = o[p];
                if (v && 'object' === typeof v) {
                    c[p] = this.copyObject(v);
                }
                else {
                    c[p] = v;
                }
            }
        }
        return c;
    }
    set options(data) {
        this._options = this.toLower(data.options);
        if (data.jsOptions) {
            for (const key in data.jsOptions) {
                if (data.jsOptions.hasOwnProperty(key)) {
                    this._options[key] = data.jsOptions[key];
                }
            }
        }
        this._options.exports.defaultSettings = data.defaultSettings;
        this.localization = data.loc;
        this.months = data.months;
        this.dayOfWeek = data.dayOfWeek;
        this.images = data.images;
        this.dateRanges = data.dateRanges;
        this.paperSizes = data.paperSizes;
        this.encodingData = data.encodingData;
        this.pdfSecurityCertificates = data.pdfSecurityCertificates;
        this.clearViewerState();
        this.setupOptions();
    }
    get options() {
        return this._options;
    }
    loc(attr) {
        var _a;
        return (_a = this.localization[attr]) !== null && _a !== void 0 ? _a : attr;
    }
    img(name) {
        var _a;
        if (name != null && name.length > 0 && !this.images[name]) {
            //console.warn(`Image: ${name} not found`);
        }
        return (_a = this.images[name]) !== null && _a !== void 0 ? _a : '';
    }
    toLower(obj) {
        const result = {};
        Object.keys(obj).forEach(key => {
            result[key.substr(0, 1).toLowerCase() + key.substr(1)] = (typeof (obj[key]) === 'object' && obj[key] !== null) ? this.toLower(obj[key]) : obj[key];
        });
        return result;
    }
    clear() {
        this._options = undefined;
        this._reportParams = {};
        this._imagesForBookmark = undefined;
        this.pages = [];
        this.form = null;
    }
    clearViewerState() {
        this.reportParams = {};
        this.reportParams.type = 'Auto';
        this.reportParams.pageNumber = 0;
        this.reportParams.originalPageNumber = 0;
        this.reportParams.drillDownGuid = null;
        this.reportParams.dashboardDrillDownGuid = null;
        this.reportParams.collapsingStates = null;
        this.reportParams.bookmarksContent = null;
        this.reportParams.editableParameters = null;
        this.reportParams.resources = null;
        this.reportParams.drillDownParameters = [];
        this.reportParams.elementName = null;
        this.reportParams.variablesValues = null;
        this.reportParams.tableOfContentsPointers = [];
        this.reportParams.isEditableReport = false;
        //this.options.viewerId = this.newToken();
        this.options.clientGuid = this.newToken();
        this.options.paramsVariables = null;
        this.options.multiFilterStates = null;
        this.options.isParametersReceived = false;
        this.options.drillDownInProgress = false;
        this.options.displayModeFromReport = null;
        // this.controls.mainPanel.style.background = '';
        // this.tableElementGridStates = {};
        // Restore current page number, if reload current report
        if (this.reportParams.prevPageNumber) {
            this.reportParams.pageNumber = this.reportParams.prevPageNumber;
            delete this.reportParams.prevPageNumber;
        }
        this.fullScreenOptions = null;
        this.drillDownButtons = [];
        this.controls.parametersPanel.visible = false;
        this.controls.bookmarksPanel.visible = false;
        this.interactions = null;
        /*
        this.controls.drillDownPanel.visible = false;
        this.controls.findPanel.visible = false;
        this.controls.parametersPanel.visible = false;
        this.controls.resourcesPanel.visible = false;*/
    }
    style(value) {
        return value !== '' && value != null ? value : '';
    }
    createPostParameters(data, asObject = true, useOptions = true) {
        var _a, _b, _c, _d;
        let params;
        // Object params
        const postParams = {
            stiweb_component: 'Viewer',
            stiweb_imagesScalingFactor: this.getImagesScalingFactor()
        };
        if (this.properties) {
            postParams['properties'] = this.encode(JSON.stringify(this.properties));
        }
        if (this.options && useOptions) {
            params = {
                viewerId: this.options.viewerId,
                routes: this.options.routes,
                formValues: this.options.formValues,
                clientGuid: this.options.clientGuid,
                drillDownGuid: this.reportParams.drillDownGuid,
                dashboardDrillDownGuid: this.reportParams.dashboardDrillDownGuid,
                cacheMode: this.options.server.cacheMode,
                cacheTimeout: this.options.server.cacheTimeout,
                cacheItemPriority: this.options.server.cacheItemPriority,
                pageNumber: this.reportParams.pageNumber,
                originalPageNumber: this.reportParams.originalPageNumber,
                reportType: this.reportParams.type,
                zoom: (this.reportParams.zoom && this.reportParams.zoom > 0) ? this.reportParams.zoom : (((_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.toolbar) === null || _b === void 0 ? void 0 : _b.zoom) > 0 ? (_d = (_c = this.options) === null || _c === void 0 ? void 0 : _c.toolbar) === null || _d === void 0 ? void 0 : _d.zoom : 100),
                viewMode: this.reportParams.viewMode || this.options.toolbar.viewMode,
                multiPageWidthCount: this.reportParams.multiPageWidthCount,
                multiPageHeightCount: this.reportParams.multiPageHeightCount,
                multiPageContainerWidth: this.reportParams.multiPageContainerWidth,
                multiPageContainerHeight: this.reportParams.multiPageContainerHeight,
                multiPageMargins: this.reportParams.multiPageMargins,
                showBookmarks: this.options.toolbar.showBookmarksButton,
                openLinksWindow: this.options.appearance.openLinksWindow,
                chartRenderType: this.options.appearance.chartRenderType,
                reportDisplayMode: (this.options.displayModeFromReport || this.options.appearance.reportDisplayMode),
                drillDownParameters: this.reportParams.drillDownParameters,
                editableParameters: this.reportParams.editableParameters,
                useRelativeUrls: this.options.server.useRelativeUrls,
                passQueryParametersForResources: this.options.server.passQueryParametersForResources,
                passQueryParametersToReport: this.options.server.passQueryParametersToReport,
                version: this.options.shortProductVersion,
                reportDesignerMode: this.options.reportDesignerMode,
                imagesQuality: this.options.appearance.imagesQuality,
                parametersPanelSortDataItems: this.options.appearance.parametersPanelSortDataItems,
                combineReportPages: this.options.appearance.combineReportPages,
                isAngular: true,
                allowAutoUpdateCookies: this.options.server.allowAutoUpdateCookies
            };
            if (this.options.server.useLocalizedCache && this.options.localization) {
                params['useLocalizedCache'] = true;
                params['localization'] = this.options.localization;
            }
            if (this.options.userValues) {
                params['userValues'] = this.options.userValues;
            }
        }
        else {
            params = {};
        }
        if (data) {
            Object.keys(data).forEach(key => params[key] = data[key]);
        }
        // Object params
        if (params.action) {
            postParams['stiweb_action'] = params.action;
            delete params.action;
        }
        if (params.base64Data) {
            postParams['stiweb_data'] = params.base64Data;
            delete params.base64Data;
        }
        if (this.options && useOptions) {
            // Params
            const jsonParams = JSON.stringify(params);
            if (this.options.server.useCompression) {
                // postParams['stiweb_packed_parameters'] = StiGZipHelper.pack(jsonParams);
                postParams['stiweb_parameters'] = this.encode(jsonParams);
            }
            else {
                postParams['stiweb_parameters'] = this.encode(jsonParams);
            }
        }
        if (this.postParametersFunction) {
            let postParamsF = this.postParametersFunction(data);
            if (postParamsF) {
                Object.keys(postParamsF).forEach(key => postParams[key] = postParamsF[key]);
            }
        }
        if (asObject) {
            return postParams;
        }
    }
    newToken() {
        const a = '1234567890abcdefghijklmnopqrstuvwxyz'.split('');
        const b = [];
        const length = 32;
        b[0] = "s";
        for (let i = 1; i < length; i++) {
            const j = (Math.random() * (a.length - 1)).toFixed(0);
            b[i] = a[j];
        }
        return b.join('');
    }
    setupOptions() {
        var _a, _b, _c, _d, _e, _f;
        if (!this.options.exports.showExportToPowerPoint && !this.options.exports.showExportToPdf && !this.options.exports.showExportToXps &&
            !this.options.exports.showExportToOpenDocumentWriter && !this.options.exports.showExportToOpenDocumentCalc && !this.options.exports.showExportToText &&
            !this.options.exports.showExportToRtf && !this.options.exports.showExportToWord2007 && !this.options.exports.showExportToCsv && !this.options.exports.showExportToJson &&
            !this.options.exports.showExportToDbf && !this.options.exports.showExportToXml && !this.options.exports.showExportToDif && !this.options.exports.showExportToSylk &&
            !this.options.exports.showExportToExcel && !this.options.exports.showExportToExcel2007 && !this.options.exports.showExportToExcelXml && !this.options.exports.showExportToHtml &&
            !this.options.exports.showExportToHtml5 && !this.options.exports.showExportToMht && !this.options.exports.showExportToImageBmp && !this.options.exports.showExportToImageGif &&
            !this.options.exports.showExportToImageJpeg && !this.options.exports.showExportToImageMetafile && !this.options.exports.showExportToImagePcx &&
            !this.options.exports.showExportToImagePng && !this.options.exports.showExportToImageTiff && !this.options.exports.showExportToImageSvg && !this.options.exports.showExportToImageSvgz) {
            if (!this.options.exports.showExportToDocument) {
                this.options.toolbar.showSaveButton = false;
            }
            this.options.toolbar.showSendEmailButton = false;
        }
        // Options
        this.options.isTouchDevice = this.options.appearance.interfaceType === 'Auto'
            ? this.isTouchDevice() && this.isMobileDevice()
            : this.options.appearance.interfaceType === 'Touch';
        this.options.isMobileDevice = this.options.appearance.interfaceType === 'Auto' && !this.options.reportDesignerMode
            ? this.isTouchDevice() && this.isMobileDevice()
            : this.options.appearance.interfaceType === 'Mobile';
        if (this.options.isMobileDevice) {
            this.initializeMobile();
        }
        else {
            this.options.toolbar.showPinToolbarButton = false;
        }
        this.controls.toolbar.visible = this.options.toolbar.visible;
        this.options.menuAnimDuration = 150;
        this.options.formAnimDuration = 200;
        this.options.scrollDuration = 350;
        this.options.menuHideDelay = 250;
        this.options.server.timeoutAutoUpdateCache = 180000;
        this.options.toolbar.backgroundColor = this.getHTMLColor(this.options.toolbar.backgroundColor);
        this.options.toolbar.borderColor = this.getHTMLColor(this.options.toolbar.borderColor);
        this.options.toolbar.fontColor = this.getHTMLColor(this.options.toolbar.fontColor);
        this.options.appearance.pageBorderColor = this.getHTMLColor(this.options.appearance.pageBorderColor);
        this.options.parametersValues = {};
        this.options.parameterRowHeight = this.options.isTouchDevice ? 35 : 30;
        this.options.minParametersCountForMultiColumns = 5;
        // First Day Of Week
        if (this.options.appearance.datePickerFirstDayOfWeek === 'Sunday') {
            this.dayOfWeek.splice(6, 1);
            this.dayOfWeek.splice(0, 0, 'Sunday');
        }
        if (((_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.toolbar) === null || _b === void 0 ? void 0 : _b.zoom) === -1 || ((_d = (_c = this.options) === null || _c === void 0 ? void 0 : _c.toolbar) === null || _d === void 0 ? void 0 : _d.zoom) === -2) {
            this.reportParams.autoZoom = (_f = (_e = this.options) === null || _e === void 0 ? void 0 : _e.toolbar) === null || _f === void 0 ? void 0 : _f.zoom;
        }
        // Actions
        if (!this.options.actions.getReport) {
            this.options.actions.getReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.printReport) {
            this.options.actions.printReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.openReport) {
            this.options.actions.openReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.exportReport) {
            this.options.actions.exportReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.interaction) {
            this.options.actions.interaction = this.options.actions.viewerEvent;
        }
        if (!(window.File && window.FileReader && window.FileList && window.Blob)) {
            this.options.toolbar.showOpenButton = false;
        }
        // Render JsViewer styles into HEAD
        if (this.options.requestResourcesUrl || this.options.appearance.customStylesUrl) {
            const viewerStyles = document.createElement('link');
            viewerStyles.setAttribute('type', 'text/css');
            viewerStyles.setAttribute('rel', 'stylesheet');
            viewerStyles.setAttribute('href', this.options.appearance.customStylesUrl || this.getResourceUrl('styles'));
            this.controls.head.appendChild(viewerStyles);
        }
        this.options.viewerId = this.options.viewerId || this.newToken();
    }
    pagesNavigationIsActive() {
        return (this.options.appearance.fullScreenMode || this.options.appearance.scrollbarsMode) && this.reportParams.viewMode === 'Continuous';
    }
    get imagesForBookmark() {
        if (!this._imagesForBookmark) {
            const names = ['root', 'folder', 'folderOpen', 'node', 'empty', 'line', 'join', 'joinBottom', 'plus', 'plusBottom', 'minus', 'minusBottom'];
            const imagesForBookmarks = {};
            names.forEach(name => imagesForBookmarks[name] = this.images['Bookmarks' + name + '.png']);
            this._imagesForBookmark = imagesForBookmarks;
        }
        return this._imagesForBookmark;
    }
    isTouchDevice() {
        return ('ontouchstart' in document.documentElement);
    }
    isMobileDevice() {
        return /iPhone|iPad|iPod|Macintosh|Android|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    }
    initializeMobile() {
        let isViewPortExist = false;
        const metas = this.controls.head.getElementsByTagName('meta');
        for (const meta of metas) {
            if (meta.name && meta.name.toLowerCase() === 'viewport') {
                isViewPortExist = true;
                break;
            }
        }
        if (!isViewPortExist) {
            const viewPortTag = document.createElement('meta');
            viewPortTag.id = 'viewport';
            viewPortTag.name = 'viewport';
            viewPortTag.content = 'initial-scale=1.0,width=device-width,user-scalable=0';
            this.controls.head.appendChild(viewPortTag);
        }
        this.options.appearance.fullScreenMode = true;
        this.options.appearance.scrollbarsMode = true;
        this.options.appearance.parametersPanelPosition = 'Left';
        this.options.appearance.parametersPanelColumnsCount = 1;
        this.options.toolbar.displayMode = 'Separated';
        this.options.toolbar.viewMode = 'SinglePage';
        this.options.toolbar.showZoomButton = false;
        const defaultZoom = this.options.toolbar.zoom === -2 ? -2 : -1; // PageWidth or PageHeight
        this.options.toolbar.zoom = this.reportParams.zoom = defaultZoom;
        this.options.toolbar.showButtonCaptions = false;
        this.options.toolbar.showOpenButton = false;
        this.options.toolbar.showFindButton = false;
        this.options.toolbar.showEditorButton = false;
        this.options.toolbar.showFullScreenButton = false;
        this.options.toolbar.showAboutButton = false;
        this.options.toolbar.showViewModeButton = false;
    }
    getImagesScalingFactor() {
        const wnd = window;
        const devicePixelRatio = window.devicePixelRatio || (wnd.deviceXDPI && wnd.logicalXDPI ? wnd.deviceXDPI / wnd.logicalXDPI : 1);
        if (!devicePixelRatio || devicePixelRatio <= 1) {
            return '1';
        }
        else {
            return devicePixelRatio.toString();
        }
    }
    getHTMLColor(color) {
        if (color.indexOf(',') > 0 && color.indexOf('rgb') < 0) {
            return `rgb(${color})`;
        }
        return color;
    }
    getResourceUrl(resourceParameter) {
        let url = this.getActionRequestUrl(this.options.requestResourcesUrl, this.options.actions.viewerEvent);
        url += url.indexOf('?') > 0 ? '&' : '?';
        url += 'stiweb_component=Viewer&stiweb_action=Resource&stiweb_data=' + resourceParameter + '&stiweb_theme=' + this.options.theme;
        url += '&stiweb_cachemode=' + (this.options.server.useCacheForResources
            ? this.options.server.cacheMode === 'ObjectSession' || this.options.server.cacheMode === 'StringSession'
                ? 'session'
                : 'cache'
            : 'none');
        url += '&stiweb_version=' + this.options.shortProductVersion;
        return url;
    }
    getActionRequestUrl(requestUrl, action) {
        if (!action) {
            return requestUrl;
        }
        if (action.indexOf('?') < 0) {
            return requestUrl.replace('{action}', action);
        }
        const query = action.substring(action.indexOf('?') + 1);
        action = action.substring(0, action.indexOf('?'));
        return requestUrl.replace('{action}', action) + (requestUrl.indexOf('?') > 0 ? '&' : '?') + query;
    }
    encode(input) {
        // Decode from UTF-8 text
        if (typeof unescape != 'undefined') {
            input = unescape(encodeURIComponent(input));
        }
        else {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if ((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            input = utftext;
        }
        // Encode to Base64 string
        if (typeof window.btoa != 'undefined')
            return window.btoa(input);
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2))
                enc3 = enc4 = 64;
            else if (isNaN(chr3))
                enc4 = 64;
            output = output +
                this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
                this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
        }
        return output;
    }
    decode(input) {
        var output = "";
        // Decode from Base64 string
        if (typeof window.atob != 'undefined') {
            output = window.atob(input);
        }
        else {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
        }
        // Encode to UTF-8 string
        if (typeof escape != 'undefined')
            return decodeURIComponent(escape(output));
        var string = "";
        var i = 0;
        var c = 0;
        var c1 = 0;
        var c2 = 0;
        var c3 = 0;
        while (i < output.length) {
            c = output.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = output.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = output.charCodeAt(i + 1);
                c3 = output.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
}
ModelService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ModelService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
ModelService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ModelService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ModelService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class AnimationService {
    constructor(model) {
        this.model = model;
    }
    showAnimationForScroll(reportPanel, finishScrollTop, endTime, completeFunction) {
        if (!reportPanel) {
            return;
        }
        let currentScrollTop = 0;
        if (this.model.options.appearance.scrollbarsMode) {
            currentScrollTop = reportPanel.scrollTop;
        }
        else {
            currentScrollTop = document.documentElement.scrollTop;
            if (currentScrollTop === 0) {
                currentScrollTop = document.getElementsByTagName('BODY')[0].scrollTop;
            }
        }
        clearTimeout(reportPanel.animationTimer);
        const d = new Date();
        const t = d.getTime();
        let step = Math.round((finishScrollTop - currentScrollTop) / ((Math.abs(endTime - t) + 1) / 30));
        // Last step
        if (Math.abs(step) > Math.abs(finishScrollTop - currentScrollTop)) {
            step = finishScrollTop - currentScrollTop;
        }
        currentScrollTop += step;
        let resultScrollTop;
        if (t < endTime) {
            resultScrollTop = currentScrollTop;
            reportPanel.animationTimer = setTimeout(() => {
                this.showAnimationForScroll(reportPanel, finishScrollTop, endTime, completeFunction);
            }, 30);
        }
        else {
            resultScrollTop = finishScrollTop;
            if (completeFunction) {
                completeFunction();
            }
        }
        if (this.model.options.appearance.scrollbarsMode) {
            reportPanel.scrollTop = resultScrollTop;
        }
        else {
            window.scrollTo(0, resultScrollTop);
        }
    }
}
AnimationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AnimationService, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Injectable });
AnimationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AnimationService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AnimationService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }]; } });

class HelperService {
    constructor(model, animationService) {
        this.model = model;
        this.animationService = animationService;
    }
    val(value, def) {
        return value != null && value.trim() !== '' ? value : (def || '');
    }
    findPosY(obj, mainClassName, noScroll) {
        let curtop = noScroll ? 0 : this.getScrollYOffset(obj, mainClassName);
        if (obj.offsetParent) {
            while (obj.className !== mainClassName) {
                curtop += obj.offsetTop;
                if (!obj.offsetParent) {
                    break;
                }
                obj = obj.offsetParent;
            }
        }
        else if (obj.y) {
            curtop += obj.y;
        }
        return curtop;
    }
    getScrollYOffset(obj, mainClassName) {
        let scrolltop = 0;
        if (obj.parentElement) {
            while (obj.className !== mainClassName) {
                if ('scrollTop' in obj) {
                    scrolltop -= obj.scrollTop;
                }
                if (!obj.parentElement) {
                    break;
                }
                obj = obj.parentElement;
            }
        }
        return scrolltop;
    }
    findPosX(obj, mainClassName, noScroll) {
        let curleft = noScroll ? 0 : this.getScrollXOffset(obj, mainClassName);
        if (obj.offsetParent) {
            while (obj.className !== mainClassName) {
                curleft += obj.offsetLeft;
                if (!obj.offsetParent) {
                    break;
                }
                obj = obj.offsetParent;
            }
        }
        else if (obj.x) {
            curleft += obj.x;
        }
        return curleft;
    }
    getScrollXOffset(obj, mainClassName) {
        let scrollleft = 0;
        if (obj.parentElement) {
            while (obj.className !== mainClassName) {
                if ('scrollLeft' in obj) {
                    scrollleft -= obj.scrollLeft;
                }
                if (!obj.parentElement) {
                    break;
                }
                obj = obj.parentElement;
            }
        }
        return scrollleft;
    }
    showHelpWindow(url) {
        let helpLanguage = 'en';
        switch (this.model.options.cultureName) {
            case 'ru': helpLanguage = 'ru';
            // case 'de': helpLanguage = 'de';
        }
        this.openNewWindow('https://www.stimulsoft.com/' + helpLanguage + '/documentation/online/' + url);
    }
    openNewWindow(url, name, specs) {
        return window.open(url, name, specs);
    }
    scrollToAnchor(anchorName, componentGuid) {
        let aHyperlinks = this.model.controls.reportPanel.el.nativeElement.getElementsByTagName("a");
        const identicalAnchors = [];
        if (anchorName) {
            anchorName = anchorName.replace(/!!#92/g, '\\');
        }
        if (componentGuid) {
            for (let i = 0; i < aHyperlinks.length; i++) {
                if (aHyperlinks[i].getAttribute('guid') === componentGuid) {
                    identicalAnchors.push(aHyperlinks[i]);
                }
            }
        }
        if (identicalAnchors.length === 0) {
            let guidIndex = anchorName.indexOf("#GUID#");
            if (identicalAnchors.length == 0) {
                let aHyperlinks = this.model.controls.reportPanel.el.nativeElement.getElementsByTagName("a");
                for (var i = 0; i < aHyperlinks.length; i++) {
                    if (aHyperlinks[i].name && ((guidIndex >= 0 && (aHyperlinks[i].name.indexOf(anchorName.substring(guidIndex + 6)) >= 0 || anchorName.substring(0, guidIndex) == aHyperlinks[i].name)) || aHyperlinks[i].name == anchorName))
                        identicalAnchors.push(aHyperlinks[i]);
                }
            }
        }
        if (identicalAnchors.length > 0) {
            const anchor = identicalAnchors[0];
            const anchorParent = anchor.parentElement || anchor;
            let anchorHeight = anchorParent.offsetHeight;
            const anchorOffsetTop = anchorParent.offsetTop;
            identicalAnchors.forEach((identicalAnchor) => {
                const nextAnchorParent = identicalAnchor.parentElement || identicalAnchor;
                if (nextAnchorParent.offsetTop > anchorOffsetTop) {
                    anchorHeight = Math.max(anchorHeight, nextAnchorParent.offsetTop - anchorOffsetTop + nextAnchorParent.offsetHeight);
                }
            });
            const date = new Date();
            const endTime = date.getTime() + this.model.options.scrollDuration;
            const targetTop = this.findPosY(anchor, this.model.options.appearance.scrollbarsMode ? 'stiJsViewerReportPanel' : null, true) - anchorParent.offsetHeight * 2;
            this.animationService.showAnimationForScroll(this.model.controls.reportPanel.el.nativeElement, targetTop, endTime, () => {
                var _a;
                const page = this.getPageFromAnchorElement(anchor);
                const anchorParentTopPos = this.findPosY(anchorParent, 'stiJsViewerReportPanel', true);
                const pageTopPos = page ? this.findPosY(page, 'stiJsViewerReportPanel', true) : anchorParentTopPos;
                this.removeBookmarksLabel();
                const label = document.createElement('div');
                this.model.controls.bookmarksLabel = label;
                label.className = 'stiJsViewerBookmarksLabel';
                const labelMargin = 20 * (this.model.reportParams.zoom / 100);
                const labelWidth = page ? page.offsetWidth - labelMargin - 6 : anchorParent.offsetWidth;
                const labelHeight = anchorHeight - 2;
                label.style.width = labelWidth + 'px';
                label.style.height = labelHeight + 'px';
                const margins = (_a = page.pageAttributes.margins) === null || _a === void 0 ? void 0 : _a.replace('px', '').split(' ');
                const pageLeftMargin = page.pageAttributes.margins ? this.strToInt(margins[3]) : 0;
                const pageTopMargin = page.pageAttributes.margins ? this.strToInt(margins[0]) : 0;
                label.style.marginLeft = (labelMargin / 2 - pageLeftMargin) + 'px';
                label.style.marginTop = (anchorParentTopPos - pageTopPos - pageTopMargin - (this.model.reportParams.zoom / 100) - 1) + 'px';
                page.insertBefore(label, page.childNodes[0]);
            });
        }
    }
    removeBookmarksLabel() {
        if (this.model.controls.bookmarksLabel) {
            this.model.controls.bookmarksLabel.parentElement.removeChild(this.model.controls.bookmarksLabel);
            this.model.controls.bookmarksLabel = null;
        }
    }
    getPageFromAnchorElement(anchorElement) {
        let obj = anchorElement;
        while (obj.parentElement) {
            if (obj.className && obj.className.indexOf('stiJsViewerPage') === 0) {
                return obj;
            }
            obj = obj.parentElement;
        }
        return obj;
    }
    strToInt(value) {
        const result = parseInt(value, 10);
        return result || 0;
    }
    strToDouble(value) {
        if (value === null) {
            return null;
        }
        const result = parseFloat(value.toString().replace(',', '.').trim());
        return result || 0;
    }
    copyObject(o) {
        if (!o || 'object' !== typeof o) {
            return o;
        }
        const c = 'function' === typeof o.pop ? [] : {};
        let p;
        let v;
        for (p in o) {
            if (o.hasOwnProperty(p)) {
                v = o[p];
                if (v && 'object' === typeof v) {
                    c[p] = this.copyObject(v);
                }
                else {
                    c[p] = v;
                }
            }
        }
        return c;
    }
    getCountObjects(objectArray) {
        let count = 0;
        if (objectArray) {
            for (const singleObject in objectArray) {
                count++;
            }
        }
        return count;
    }
    replaceMonths(value) {
        for (let i = 1; i <= 12; i++) {
            let enName = '';
            let locName = '';
            switch (i) {
                case 1:
                    enName = 'January';
                    locName = this.model.loc('MonthJanuary');
                    break;
                case 2:
                    enName = 'February';
                    locName = this.model.loc('MonthFebruary');
                    break;
                case 3:
                    enName = 'March';
                    locName = this.model.loc('MonthMarch');
                    break;
                case 4:
                    enName = 'April';
                    locName = this.model.loc('MonthApril');
                    break;
                case 5:
                    enName = 'May';
                    locName = this.model.loc('MonthMay');
                    break;
                case 6:
                    enName = 'June';
                    locName = this.model.loc('MonthJune');
                    break;
                case 7:
                    enName = 'July';
                    locName = this.model.loc('MonthJuly');
                    break;
                case 8:
                    enName = 'August';
                    locName = this.model.loc('MonthAugust');
                    break;
                case 9:
                    enName = 'September';
                    locName = this.model.loc('MonthSeptember');
                    break;
                case 10:
                    enName = 'October';
                    locName = this.model.loc('MonthOctober');
                    break;
                case 11:
                    enName = 'November';
                    locName = this.model.loc('MonthNovember');
                    break;
                case 12:
                    enName = 'December';
                    locName = this.model.loc('MonthDecember');
                    break;
            }
            const enShortName = enName.substring(0, 3);
            const locShortName = locName.substring(0, 3);
            value = value.replace(enName, i).replace(enName.toLowerCase(), i).replace(enShortName, i).replace(enShortName.toLowerCase(), i);
            value = value.replace(locName, i).replace(locName.toLowerCase(), i).replace(locShortName, i).replace(locShortName.toLowerCase(), i);
        }
        return value;
    }
    getDate(dateTimeObj) {
        return new Date(dateTimeObj.year, dateTimeObj.month - 1, dateTimeObj.day, dateTimeObj.hours, dateTimeObj.minutes, dateTimeObj.seconds);
    }
    getDateTimeObject(date) {
        if (!date) {
            date = new Date();
        }
        const dateTimeObject = new DateTimeObject();
        dateTimeObject.year = date.getFullYear();
        dateTimeObject.month = date.getMonth() + 1;
        dateTimeObject.day = date.getDate();
        dateTimeObject.hours = date.getHours();
        dateTimeObject.minutes = date.getMinutes();
        dateTimeObject.seconds = date.getSeconds();
        return dateTimeObject;
    }
    getDateTimeFromString(value, format) {
        const charIsDigit = (ch) => {
            return ('0123456789'.indexOf(ch) >= 0);
        };
        if (!value) {
            return new Date();
        }
        value = this.replaceMonths(value);
        let dateTime = new Date();
        // If the date format is not specified, then deserializator for getting date and time is applied
        if (format === null) {
            format = 'dd.MM.yyyy hh:mm:ss';
        }
        // Otherwise the format is parsed. Now only numeric date and time formats are supported
        let year = 1970;
        let month = 1;
        let day = 1;
        let hour = 0;
        let minute = 0;
        let second = 0;
        let millisecond = 0;
        let char = '';
        let pos = 0;
        const values = [];
        // Parse date and time into separate numeric values
        while (pos < value.length) {
            char = value.charAt(pos);
            if (charIsDigit(char)) {
                values.push(char);
                pos++;
                while (pos < value.length && charIsDigit(value.charAt(pos))) {
                    values[values.length - 1] += value.charAt(pos);
                    pos++;
                }
                values[values.length - 1] = this.strToInt(values[values.length - 1]);
            }
            pos++;
        }
        pos = 0;
        let charCount = 0;
        let index = -1;
        let is12hour = false;
        // Parsing format and replacement of appropriate values of date and time
        while (pos < format.length) {
            char = format.charAt(pos);
            charCount = 0;
            if (char === 'Y' || char === 'y' || char === 'M' || char === 'd' || char === 'h' || char === 'H' ||
                char === 'm' || char === 's' || char === 'f' || char === 'F' || char === 't' || char === 'z') {
                index++;
                while (pos < format.length && format.charAt(pos) === char) {
                    pos++;
                    charCount++;
                }
            }
            switch (char) {
                case 'Y': // full year
                    year = values[index];
                    break;
                case 'y': // year
                    if (values[index] < 1000) {
                        year = 2000 + values[index];
                    }
                    else {
                        year = values[index];
                    }
                    break;
                case 'M': // month
                    month = values[index];
                    break;
                case 'd': // day
                    day = values[index];
                    break;
                case 'h': // (hour 12)
                    is12hour = true;
                    hour = values[index];
                    break;
                case 'H': // (hour 24)
                    hour = values[index];
                    break;
                case 'm': // minute
                    minute = values[index];
                    break;
                case 's': // second
                    second = values[index];
                    break;
                case 'f': // second fraction
                case 'F': // second fraction, trailing zeroes are trimmed
                    millisecond = values[index];
                    break;
                case 't': // PM or AM
                    if (value.toLowerCase().indexOf('am') >= 0 && hour === 12) {
                        hour = 0;
                    }
                    if (value.toLowerCase().indexOf('pm') >= 0 && hour < 12) {
                        hour += 12;
                    }
                    break;
                default:
                    pos++;
                    break;
            }
        }
        dateTime = new Date(year || new Date().getFullYear(), month - 1 || 0, day || 1, hour || 0, minute || 0, second, millisecond || 0);
        if (!dateTime || isNaN(dateTime)) {
            return new Date();
        }
        return dateTime;
    }
    getStringDateTime(object, dateTimeType) {
        if (dateTimeType === 'Date') {
            object.hours = 0;
            object.minutes = 0;
            object.seconds = 0;
        }
        return object.month + '/' + object.day + '/' + object.year + ' ' +
            (object.hours > 12 ? object.hours - 12 : object.hours) + ':' + object.minutes + ':' + object.seconds + ' ' +
            (object.hours < 12 ? 'AM' : 'PM');
    }
    dateTimeObjectToString(dateTimeObject, typeDateTimeObject) {
        const date = new Date(dateTimeObject.year, dateTimeObject.month - 1, dateTimeObject.day, dateTimeObject.hours, dateTimeObject.minutes, dateTimeObject.seconds);
        if (this.model.options.appearance.parametersPanelDateFormat !== '') {
            return this.formatDate(date, this.model.options.appearance.parametersPanelDateFormat);
        }
        return this.dateToLocaleString(date, typeDateTimeObject);
    }
    dateToLocaleString(date, dateTimeType) {
        const timeString = date.toLocaleTimeString();
        const isAmericanFormat = timeString.toLowerCase().indexOf('am') >= 0 || timeString.toLowerCase().indexOf('pm') >= 0;
        let formatDate = isAmericanFormat ? 'MM/dd/yyyy' : 'dd.MM.yyyy';
        const yyyy = date.getFullYear();
        const yy = yyyy.toString().substring(2);
        const M = date.getMonth() + 1;
        const MM = M < 10 ? '0' + M : M;
        const d = date.getDate();
        const dd = d < 10 ? '0' + d : d;
        formatDate = formatDate.replace(/yyyy/i, yyyy);
        formatDate = formatDate.replace(/yy/i, yy);
        formatDate = formatDate.replace(/MM/i, MM);
        formatDate = formatDate.replace(/M/i, M);
        formatDate = formatDate.replace(/dd/i, dd);
        formatDate = formatDate.replace(/d/i, d);
        let h = date.getHours();
        let tt = '';
        if (isAmericanFormat) {
            tt = h < 12 ? ' AM' : ' PM';
            h = h > 12 ? h - 12 : h;
            if (h === 0) {
                h = 12;
            }
        }
        else {
            h = h < 10 ? '0' + h : h;
        }
        let m = date.getMinutes();
        m = m < 10 ? '0' + m : m;
        let s = date.getSeconds();
        s = s < 10 ? '0' + s : s;
        const formatTime = h + ':' + m + ':' + s + tt;
        if (dateTimeType === 'Time') {
            return formatTime;
        }
        if (dateTimeType === 'Date') {
            return formatDate;
        }
        return formatDate + ' ' + formatTime;
    }
    formatDate(formatDate, formatString) {
        const yyyy = formatDate.getFullYear();
        const yy = yyyy.toString().substring(2);
        const m = formatDate.getMonth() + 1;
        const mm = m < 10 ? '0' + m : m;
        const d = formatDate.getDate();
        const dd = d < 10 ? '0' + d : d;
        const h = formatDate.getHours();
        const hh = h < 10 ? '0' + h : h;
        const h12 = h > 12 ? h - 12 : (h > 0 ? h : 12);
        const hh12 = h12 < 10 ? '0' + h12 : h12;
        const n = formatDate.getMinutes();
        const nn = n < 10 ? '0' + n : n;
        const s = formatDate.getSeconds();
        const ss = s < 10 ? '0' + s : s;
        const tt = h < 12 ? 'AM' : 'PM';
        formatString = formatString.replace(/yyyy/gi, yyyy);
        formatString = formatString.replace(/yy/gi, yy);
        formatString = formatString.replace(/Y/, yyyy);
        formatString = formatString.replace(/MM/g, mm);
        formatString = formatString.replace(/M/g, m);
        formatString = formatString.replace(/dd/g, dd);
        formatString = formatString.replace(/d/g, d);
        formatString = formatString.replace(/hh/g, hh12);
        formatString = formatString.replace(/h/g, h12);
        formatString = formatString.replace(/HH/g, hh);
        formatString = formatString.replace(/H/g, h);
        formatString = formatString.replace(/mm/g, nn);
        formatString = formatString.replace(/m/g, n);
        formatString = formatString.replace(/ss/g, ss);
        formatString = formatString.replace(/s/g, s);
        formatString = formatString.replace(/tt/gi, tt);
        formatString = formatString.replace(/t/gi, tt.substr(0, 1));
        return formatString;
    }
    getStringKey(key, params) {
        if (key === null) {
            return '';
        }
        return ((params.type === 'DateTime') ? this.dateTimeObjectToString(key, params.dateTimeType) : key);
    }
    stringToTime(timeStr) {
        const timeArray = timeStr.split(':');
        const time = { hours: 0, minutes: 0, seconds: 0 };
        time.hours = this.strToInt(timeArray[0]);
        if (timeArray.length > 1) {
            time.minutes = this.strToInt(timeArray[1]);
        }
        if (timeArray.length > 2) {
            time.seconds = this.strToInt(timeArray[2]);
        }
        if (time.hours < 0) {
            time.hours = 0;
        }
        if (time.minutes < 0) {
            time.minutes = 0;
        }
        if (time.seconds < 0) {
            time.seconds = 0;
        }
        if (time.hours > 23) {
            time.hours = 23;
        }
        if (time.minutes > 59) {
            time.minutes = 59;
        }
        if (time.seconds > 59) {
            time.seconds = 59;
        }
        return time;
    }
    newGuid() {
        const chars = '0123456789abcdefghijklmnopqrstuvwxyz'.split('');
        const uuid = [];
        const rnd = Math.random;
        let r;
        uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
        uuid[14] = '4';
        for (let i = 0; i < 36; i++) {
            if (!uuid[i]) {
                r = 0 | rnd() * 16;
                uuid[i] = chars[(i === 19) ? (r & 0x3) | 0x8 : r & 0xf];
            }
        }
        return uuid.join('');
    }
    getCountDaysOfMonth(year, month) {
        const countDaysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        let count = countDaysInMonth[month];
        if (month === 1) {
            if (year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0)) {
                count = 29;
            }
            else {
                count = 28;
            }
        }
        return count;
    }
    setObjectToCenter(object, defaultTop) {
        const leftPos = (this.model.viewerSize.width / 2 - object.offsetWidth / 2);
        const topPos = this.model.options.appearance.fullScreenMode ? (this.model.viewerSize.height / 2 - object.offsetHeight / 2) : (defaultTop ? defaultTop : 250);
        return { left: Math.max(leftPos, 0), top: Math.max(topPos, 0) };
    }
    checkCloudAuthorization(action) {
        return true;
    }
    getCookie_(name) {
        const cookie = ' ' + document.cookie;
        const search = ' ' + name + '=';
        let setStr = null;
        let offset = 0;
        let end = 0;
        if (cookie.length > 0) {
            offset = cookie.indexOf(search);
            if (offset !== -1) {
                offset += search.length;
                end = cookie.indexOf(';', offset);
                if (end === -1) {
                    end = cookie.length;
                }
                setStr = unescape(cookie.substring(offset, end));
            }
        }
        return setStr;
    }
    getCookie(name) {
        if (this.model.options.standaloneJsMode || typeof localStorage === 'undefined' || name.indexOf('sti_') == 0 || name.indexOf('login') == 0) {
            return this.getCookie_(name);
        }
        let value = localStorage.getItem(name);
        if (value != null) {
            return value;
        }
        else {
            value = this.getCookie_(name);
            if (value != null) {
                this.removeCookie(name);
                localStorage.setItem(name, value);
            }
            return value;
        }
    }
    removeCookie(name) {
        document.cookie = name + '=;expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/';
    }
    setCookie(name, value, path, domain, secure, expires) {
        if (this.model.options.standaloneJsMode || typeof localStorage === 'undefined' || name.indexOf('sti_') === 0 || name.indexOf('login') === 0) {
            // save to cookies
            if (value && typeof (value) === 'string' && value.length >= 4096) {
                return;
            }
            const pathName = location.pathname;
            const expDate = new Date();
            expDate.setTime(expDate.getTime() + (365 * 24 * 3600 * 1000));
            document.cookie = name + '=' + escape(value) +
                '; expires=' + (expires || expDate['toGMTString']()) +
                ((path) ? '; path=' + path : '; path=/') +
                ((domain) ? '; domain=' + domain : '') +
                ((secure) ? '; secure' : '');
        }
        else {
            // save to localstorage
            localStorage.setItem(name, value);
        }
    }
    getNavigatorName() {
        if (!navigator) {
            return 'Unknown';
        }
        const userAgent = navigator.userAgent;
        if (userAgent.indexOf('Edge') >= 0) {
            return 'Edge';
        }
        if (userAgent.indexOf('MSIE') >= 0 || userAgent.indexOf('Trident') >= 0) {
            return 'MSIE';
        }
        if (userAgent.indexOf('Gecko') >= 0) {
            if (userAgent.indexOf('Chrome') >= 0) {
                return 'Chrome';
            }
            if (userAgent.indexOf('Safari') >= 0) {
                return 'Safari';
            }
            return 'Mozilla';
        }
        if (userAgent.indexOf('Opera') >= 0) {
            return 'Opera';
        }
    }
    isTouchDevice() {
        return ('ontouchstart' in document.documentElement);
    }
    isMobileDevice() {
        return /iPhone|iPad|iPod|Macintosh|Android|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    }
    getHumanFileSize(value, decimals) {
        const i = Math.floor(Math.log(value) / Math.log(1024));
        return ((value / Math.pow(1024, i)).toFixed(decimals)) + ' ' + ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'][i];
    }
    getZoomMenuItems() {
        const items = [{ name: 'Zoom25', caption: '25%', img: '' },
            { name: 'Zoom50', caption: '50%', img: '' },
            { name: 'Zoom75', caption: '75%', img: '' },
            { name: 'Zoom100', caption: '100%', img: '' },
            { name: 'Zoom150', caption: '150%', img: '' },
            { name: 'Zoom200', caption: '200%', img: '' }];
        if (this.model.options.toolbar.displayMode !== 'Separated') {
            items.push({ type: 'separator' });
            items.push({ name: 'ZoomOnePage', caption: this.model.loc('ZoomOnePage'), img: 'ZoomOnePage.png' });
            items.push({ name: 'ZoomPageWidth', caption: this.model.loc('ZoomPageWidth'), img: 'ZoomPageWidth.png' });
        }
        return items;
    }
    get helpLinks() {
        return {
            Print: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Save: 'user-manual/index.html?viewer_reports.htm#toolbar',
            SendEmail: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Bookmarks: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Parameters: 'user-manual/index.html?viewer_reports.htm#toolbar',
            FirstPage: 'user-manual/index.html?viewer_reports.htm#statusbar',
            PrevPage: 'user-manual/index.html?viewer_reports.htm#statusbar',
            NextPage: 'user-manual/index.html?viewer_reports.htm#statusbar',
            LastPage: 'user-manual/index.html?viewer_reports.htm#statusbar',
            FullScreen: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Zoom: 'user-manual/index.html?viewer_reports.htm#statusbar',
            ViewMode: 'user-manual/index.html?viewer_reports.htm#displayingmode',
            Editor: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Find: 'user-manual/index.html?viewer_reports.htm#searchpanel',
            DashboardToolbar: 'user-manual/index.html?viewer_dashboards.htm#controlbuttonsofthedashboard',
            DashboardElementToolbar: 'user-manual/index.html?viewer_dashboards.htm#elementcontrols',
            DashboardExport: 'user-manual/index.html?exports_dashboards.htm',
            DashboardPdfExport: 'user-manual/index.html?exports_dashboards.htm#pdfexportsettings',
            DashboardExcelExport: 'user-manual/index.html?exports_dashboards.htm#excelexportsettings',
            DashboardImageExport: 'user-manual/index.html?exports_dashboards.htm#imageexportsettings',
            DashboardDataExport: 'user-manual/index.html?exports_dashboards.htm#exportsettingsofdata'
        };
    }
    getBackText(withoutBrackets) {
        const backText = String.fromCharCode(84) + 'r' + String.fromCharCode(105) + 'a';
        if (withoutBrackets) {
            return backText + String.fromCharCode(108);
        }
        return String.fromCharCode(91) + backText + String.fromCharCode(108) + String.fromCharCode(93);
    }
}
HelperService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: HelperService, deps: [{ token: ModelService }, { token: AnimationService }], target: i0.ɵɵFactoryTarget.Injectable });
HelperService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: HelperService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: HelperService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: AnimationService }]; } });

class StiHttpClientService {
    constructor(httpClient, model, helper) {
        this.httpClient = httpClient;
        this.model = model;
        this.helper = helper;
    }
    post(url, data, responseType = 'json') {
        var _a, _b, _c, _d;
        const model = this.model;
        model.showProgress = true;
        const reqTimeout = ((_b = (_a = this.model.options) === null || _a === void 0 ? void 0 : _a.server) === null || _b === void 0 ? void 0 : _b.requestTimeout) > 0 ? ((_d = (_c = this.model.options) === null || _c === void 0 ? void 0 : _c.server) === null || _d === void 0 ? void 0 : _d.requestTimeout) * 1000 : 1000 * 1000;
        if (responseType === 'json') {
            return this.httpClient.post(url, this.getFormData(data)).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                model.httpError = error;
                model.showProgress = false;
                this.model.controls.navigatePanel.enabled = true;
                this.model.controls.toolbar.enabled = true;
                return throwError('Something bad happened; please try again later.');
            }));
        }
        else {
            return this.httpClient.post(url, this.getFormData(data), { responseType: 'text' }).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                model.httpError = error;
                model.showProgress = false;
                this.model.controls.navigatePanel.enabled = true;
                this.model.controls.toolbar.enabled = true;
                return throwError('Something bad happened; please try again later.');
            }));
        }
    }
    getFormData(data) {
        const formData = new FormData();
        Object.keys(data).forEach(key => formData.append(key, data[key]));
        return formData;
    }
    postForm(url, data, doc, postOnlyData = false) {
        if (!doc) {
            doc = document;
        }
        const form = doc.createElement('FORM');
        form.setAttribute('method', 'POST');
        form.setAttribute('action', url);
        const params = postOnlyData ? data : this.model.createPostParameters(data, true);
        Object.keys(params).forEach(key => {
            const paramsField = doc.createElement('INPUT');
            paramsField.setAttribute('type', 'hidden');
            paramsField.setAttribute('name', key);
            paramsField.setAttribute('value', params[key]);
            form.appendChild(paramsField);
        });
        if (this.model.options.jsDesigner) {
            this.model.options.jsDesigner.options.ignoreBeforeUnload = true;
        }
        doc.body.appendChild(form);
        form.submit();
        doc.body.removeChild(form);
        setTimeout(() => {
            if (this.model.options.jsDesigner) {
                this.model.options.jsDesigner.options.ignoreBeforeUnload = false;
            }
        }, 500);
    }
}
StiHttpClientService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService, deps: [{ token: i1.HttpClient }, { token: ModelService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Injectable });
StiHttpClientService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.HttpClient }, { type: ModelService }, { type: HelperService }]; } });

class StylesService {
    constructor(model) {
        this.model = model;
        this.pagesCss = {};
    }
    setupStyle(style, id) {
        var _a;
        if (this.pagesCss[id] == null) {
            this.pagesCss[id] = document.createElement('STYLE');
            this.pagesCss[id].id = ((_a = this.model.options) === null || _a === void 0 ? void 0 : _a.viewerId) + 'Styles';
            this.pagesCss[id].setAttribute('type', 'text/css');
            this.model.controls.head.appendChild(this.pagesCss[id]);
        }
        if (this.pagesCss[id].styleSheet) {
            this.pagesCss[id].styleSheet.cssText = style;
        }
        else {
            this.pagesCss[id].innerHTML = style;
        }
    }
    addCustomFontStyles(customFonts) {
        if (!customFonts) {
            return;
        }
        let existsStyles = [];
        try {
            existsStyles = document.getElementsByTagName('head')[0].getElementsByTagName('style');
        }
        catch (e) { }
        customFonts.forEach((customFont) => {
            if (customFont.contentForCss && customFont.originalFontFamily) {
                const style = document.createElement('style');
                style.innerHTML = `@font-face {\r\nfont-family: '${customFont.originalFontFamily}';\r\n src: url(${customFont.contentForCss});\r\n }`;
                let existsThisStyle = false;
                for (const estyle of existsStyles) {
                    if (estyle.innerHTML.indexOf(`font-family: '${customFont.originalFontFamily}'`) > 0) {
                        existsThisStyle = true;
                        break;
                    }
                }
                if (!existsThisStyle) {
                    document.getElementsByTagName('head')[0].appendChild(style);
                }
            }
        });
    }
    addChartScript(script) {
        const currChartScripts = document.getElementById(this.model.options.viewerId + 'chartScriptJsViewer');
        if (currChartScripts) {
            this.model.controls.head.removeChild(currChartScripts);
        }
        if (script) {
            const chartScripts = document.createElement('Script');
            chartScripts.setAttribute('type', 'text/javascript');
            chartScripts.id = this.model.options.viewerId + 'chartScriptJsViewer';
            chartScripts.textContent = script;
            this.model.controls.head.appendChild(chartScripts);
        }
    }
}
StylesService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StylesService, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StylesService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StylesService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StylesService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }]; } });

class PageService {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
        Object.keys(model.controls).forEach(k => model.controls[k].pageService = this);
    }
    calculateLayout() {
        setTimeout(() => {
            this.calculateLayoutInner();
        });
    }
    calculateLayoutInner() {
        var _a;
        const reportLayout = new Rectangle();
        const paramsLayout = new Rectangle();
        if (!this.model.controls.reportPanel.el) {
            return reportLayout;
        }
        if (this.model.controls.dashboardsPanel.el) {
            reportLayout.top += this.model.controls.dashboardsPanel.offsetHeight;
        }
        if (this.model.reportParams.type === 'Report') {
            if (this.model.controls.toolbar && this.model.controls.toolbar.visible && !(this.model.options.isMobileDevice && this.model.options.toolbar.autoHide)) {
                reportLayout.top += this.model.controls.toolbar.offsetHeight;
            }
            if (this.model.controls.drillDownPanel && this.model.controls.drillDownPanel.visible) {
                reportLayout.top += this.model.controls.drillDownPanel.offsetHeight;
            }
            if (this.model.controls.findPanel && this.model.controls.findPanel.visible) {
                reportLayout.top += this.model.controls.findPanel.offsetHeight;
            }
            if (this.model.controls.resourcesPanel && this.model.controls.resourcesPanel.visible) {
                reportLayout.top += this.model.controls.resourcesPanel.offsetHeight;
            }
            if (this.model.controls.bookmarksPanel && this.model.controls.bookmarksPanel.visible) {
                reportLayout.left += this.model.options.appearance.bookmarksTreeWidth;
                if (this.model.options.toolbar.displayMode === 'Simple') {
                    reportLayout.left += 2;
                }
            }
            if (this.model.controls.navigatePanel && this.model.controls.navigatePanel.visible && !(this.model.options.isMobileDevice && this.model.options.toolbar.autoHide)) {
                reportLayout.bottom = this.model.controls.navigatePanel.offsetHeight;
            }
        }
        if (this.model.controls.parametersPanel && this.model.controls.parametersPanel.visible) {
            this.model.controls.parametersPanel.layout = paramsLayout;
            paramsLayout.top = reportLayout.top;
            if (this.model.options.appearance.parametersPanelPosition === 'Left') {
                paramsLayout.left = reportLayout.left;
                paramsLayout.width = this.model.controls.parametersPanel.el.nativeElement.firstChild.offsetWidth;
                reportLayout.left += paramsLayout.width;
                if (this.model.options.toolbar.displayMode === 'Simple') {
                    reportLayout.left += 2;
                }
            }
            if (this.model.options.appearance.parametersPanelPosition === 'Top') {
                paramsLayout.height = this.model.controls.parametersPanel.offsetHeight;
                reportLayout.top += paramsLayout.height;
            }
        }
        if (this.model.controls.bookmarksPanel) {
            // this.model.controls.bookmarksPanel.layout = new Rectangle();
            let styleTop = this.model.options.toolbar.visible ? this.model.controls.toolbar.offsetHeight : 0;
            if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
                styleTop = 0;
            }
            styleTop += this.model.controls.parametersPanel.exists && this.model.options.appearance.parametersPanelPosition === 'Top' ? this.model.controls.parametersPanel.offsetHeight : 0;
            styleTop += this.model.controls.findPanel.exists ? this.model.controls.findPanel.offsetHeight : 0;
            styleTop += this.model.controls.drillDownPanel.exists ? this.model.controls.drillDownPanel.offsetHeight : 0;
            styleTop += this.model.controls.resourcesPanel.exists ? this.model.controls.resourcesPanel.offsetHeight : 0;
            this.model.controls.bookmarksPanel.layout.top = styleTop; // reportLayout.top;
        }
        if (this.model.options.toolbar.displayMode === 'Simple' && reportLayout.top > 0) {
            reportLayout.top += 2;
        }
        if (((_a = this.model.controls.reportPanel.el) === null || _a === void 0 ? void 0 : _a.nativeElement.style.position) === 'relative') {
            reportLayout.top = paramsLayout.height;
        }
        const reportMargins = {
            top: parseInt(this.model.controls.reportPanel.el.nativeElement.style.marginTop ? this.model.controls.reportPanel.el.nativeElement.style.marginTop : 0),
            right: parseInt(this.model.controls.reportPanel.el.nativeElement.style.marginRight ? this.model.controls.reportPanel.el.nativeElement.style.marginRight : 0),
            bottom: parseInt(this.model.controls.reportPanel.el.nativeElement.style.marginBottom ? this.model.controls.reportPanel.el.nativeElement.style.marginBottom : 0),
            left: parseInt(this.model.controls.reportPanel.el.nativeElement.style.marginLeft ? this.model.controls.reportPanel.el.nativeElement.style.marginLeft : 0)
        };
        reportLayout.width = this.model.controls.reportPanel.offsetWidth - reportLayout.left - reportLayout.right + reportMargins.left + reportMargins.right;
        reportLayout.height = this.model.controls.reportPanel.el.nativeElement.style.position === 'absolute'
            ? this.model.controls.reportPanel.offsetHeight - reportLayout.top - reportLayout.bottom + reportMargins.top + reportMargins.bottom
            : Math.round(reportLayout.width * 0.56); // use 16:9 aspect ratio for automatic height
        this.model.controls.reportPanel.layout = reportLayout;
    }
    getZoomByPageWidth() {
        var _a, _b;
        const pageNumber = this.model.reportParams.viewMode === 'SinglePage' ? 0 : (this.model.reportParams.pageNumber || 0);
        return (this.model.controls.reportPanel.layout.width - 40) * this.getZoom() / (((_b = (_a = this.model.pages[pageNumber]) === null || _a === void 0 ? void 0 : _a.page) === null || _b === void 0 ? void 0 : _b.offsetWidth) || 1);
    }
    getZoomByPageHeight() {
        var _a, _b;
        const pageNumber = this.model.reportParams.viewMode === 'SinglePage' ? 0 : (this.model.reportParams.pageNumber || 0);
        return (this.model.controls.reportPanel.layout.height - 40) * this.getZoom() / (((_b = (_a = this.model.pages[pageNumber]) === null || _a === void 0 ? void 0 : _a.page) === null || _b === void 0 ? void 0 : _b.offsetHeight) || 1);
    }
    getZoom() {
        return this.model.reportParams.zoom < 0 ? 100 : this.model.reportParams.zoom;
    }
}
PageService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageService, deps: [{ token: ModelService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Injectable });
PageService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }]; } });

class MouseService {
    constructor() {
        this.documetMouseDown = new Subject();
        this.documetMouseMove = new Subject();
        this.documetMouseUp = new Subject();
        document.addEventListener('mouseup', (event) => {
            this.documetMouseUp.next(event);
        });
        document.addEventListener('mousemove', (event) => {
            this.documetMouseMove.next(event);
        });
        document.addEventListener('mousedown', (event) => {
            this.documetMouseDown.next(event);
        });
    }
    getDocumentMouseUp() {
        return this.documetMouseUp.asObservable();
    }
    getDocumentMouseMove() {
        return this.documetMouseMove.asObservable();
    }
    getDocumentMouseDown() {
        return this.documetMouseDown.asObservable();
    }
}
MouseService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MouseService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
MouseService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MouseService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MouseService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class Menu {
    constructor() { }
    get state() {
        return this._state;
    }
    set state(value) {
        let oldState = this._state;
        this._state = value;
        if (oldState != 'initialDown' && oldState != '' && value == 'initialDown' && this.onCloseEvent) {
            this.onCloseEvent();
        }
    }
}
class MenuService {
    constructor(helper, model, mouseService) {
        this.helper = helper;
        this.model = model;
        this.mouseService = mouseService;
        this.VERTICAL_MENU_NAME = 'verticalMenu';
        this.menuMouseUp = '';
        this._menus = {};
        this.subject = new Subject();
        this.mouseService.getDocumentMouseUp().subscribe((event) => {
            if (this.menuMouseUp === '') {
                this.closeAllMenus();
            }
            else if (this.menuMouseUp !== 'datePickerMenu' && this.menuMouseUp !== this.VERTICAL_MENU_NAME) {
                const datePicker = Object.values(this._menus).find(m => m.type === 'datePickerMenu');
                if (datePicker != null) {
                    datePicker.state = 'initialDown';
                }
            }
            this.menuMouseUp = '';
        });
    }
    getVisibility() {
        return this.subject.asObservable();
    }
    addMenu(menu) {
        let inMenu = new Menu();
        for (let key in menu) {
            inMenu[key] = menu[key];
        }
        this._menus[menu.name] = inMenu;
    }
    closeAllMenus() {
        Object.values(this._menus).forEach((m) => m.state = m.type === 'buttonMenu' && this.model.options.isMobileDevice ? 'initialLeft' : 'initialDown');
    }
    isMenuVisible() {
        return Object.values(this._menus).find(m => m.state === 'expanded') != null;
    }
    showMenu(menuName) {
        const menu = this._menus[menuName];
        if ((menu === null || menu === void 0 ? void 0 : menu.type) !== 'datePickerMenu' && (menu === null || menu === void 0 ? void 0 : menu.type) !== this.VERTICAL_MENU_NAME) {
            this.closeAllMenus();
        }
        if (menu) {
            menu.sizeStyle = 'opacity: 0;';
            if (this.model.options.isMobileDevice && menu.type === 'buttonMenu') {
                setTimeout(() => {
                    const innerContent = menu.innerContent.nativeElement;
                    menu.left = 0;
                    menu.top = 0;
                    menu.width = innerContent.offsetWidth;
                    menu.height = innerContent.offsetHeight;
                    menu.state = 'initialLeft';
                    menu.sizeStyle = null;
                    setTimeout(() => {
                        menu.state = 'expanded';
                    });
                });
            }
            else {
                setTimeout(() => {
                    menu.sizeStyle = null;
                    this.showMenuInternal(menu);
                });
            }
            this.subject.next(menu);
        }
    }
    showMenuInternal(menu) {
        const isVertMenu = true;
        const parentButton = menu.parent.nativeElement;
        const innerContent = menu.innerContent.nativeElement;
        const offsetHeight = menu.menuEl.nativeElement.offsetHeight;
        const style = menu.menuEl.nativeElement.style;
        const coords = this.getMenuCoordinates(parentButton, innerContent, offsetHeight, style, isVertMenu);
        menu.left = coords.left;
        menu.top = coords.top;
        menu.width = menu.width || coords.width;
        menu.height = coords.height;
        menu.state = coords.state;
        setTimeout(() => {
            menu.state = 'expanded';
        });
    }
    getMenuCoordinates(parentButton, innerContent, offsetHeight, style, isVertMenu) {
        const menu = {};
        const browserWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
        const browserHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
        const rightAlign = false;
        const mainClassName = 'stiJsViewerMainPanel';
        let animDirect = 'Down';
        const leftOffset = 0;
        let left = (isVertMenu)
            ? (this.model.options.appearance.rightToLeft || rightAlign
                ? (this.helper.findPosX(parentButton, mainClassName) - innerContent.offsetWidth + parentButton.offsetWidth) - (leftOffset || 0)
                : this.helper.findPosX(parentButton, mainClassName) - (leftOffset || 0))
            : ((animDirect === 'Right')
                ? (this.helper.findPosX(parentButton, mainClassName) + parentButton.offsetWidth + 2)
                : (this.helper.findPosX(parentButton, mainClassName) - parentButton.offsetWidth - 2));
        if (left + innerContent.offsetWidth > browserWidth) {
            left = browserWidth - innerContent.offsetWidth - 15;
        }
        if (left < 0) {
            left = 10;
        }
        menu.left = left;
        if (animDirect === 'Down' &&
            this.helper.findPosY(parentButton) + parentButton.offsetHeight + innerContent.offsetHeight > browserHeight &&
            this.helper.findPosY(parentButton) - innerContent.offsetHeight > 0) {
            animDirect = 'Up';
        }
        menu.top = (isVertMenu)
            ? ((animDirect === 'Down')
                ? (this.helper.findPosY(parentButton, mainClassName) + parentButton.offsetHeight + 2)
                : (this.helper.findPosY(parentButton, mainClassName) - offsetHeight))
            : (this.helper.findPosY(parentButton, mainClassName) + parentButton.offsetHeight + innerContent.offsetHeight > browserHeight &&
                (browserHeight - innerContent.offsetHeight - 10) > 0)
                ? (browserHeight - innerContent.offsetHeight - 10)
                : this.helper.findPosY(parentButton, mainClassName);
        menu.width = innerContent.offsetWidth;
        menu.height = innerContent.offsetHeight;
        if (menu.top + innerContent.offsetHeight > browserHeight) {
            menu.top = (browserHeight - innerContent.offsetHeight - 10);
        }
        if (menu.top < 0) {
            menu.top = 10;
        }
        menu.state = animDirect === 'Down' ? 'initialDown' : 'initialUp';
        return menu;
    }
    get menus() {
        return Object.values(this._menus);
    }
    getVerticalMenu() {
        return this._menus[this.VERTICAL_MENU_NAME];
    }
    getMenu(name) {
        return this._menus[name];
    }
}
MenuService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuService, deps: [{ token: HelperService }, { token: ModelService }, { token: MouseService }], target: i0.ɵɵFactoryTarget.Injectable });
MenuService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: HelperService }, { type: ModelService }, { type: MouseService }]; } });

class FormService {
    constructor(mouseService, menuService, helper, model) {
        this.mouseService = mouseService;
        this.menuService = menuService;
        this.helper = helper;
        this.model = model;
        this.mouseX = 0;
        this.mouseY = 0;
        this.formX = 0;
        this.formY = 0;
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.move(event);
        });
        mouseService.getDocumentMouseUp().subscribe((event) => {
            this.stopMove();
        });
    }
    get form() {
        return this.model.form;
    }
    set form(form) {
        this.model.form = form;
    }
    showForm(name, formData) {
        this.form = { name, left: 0, top: 0, isMooving: false, formData };
    }
    closeForm(name) {
        var _a, _b;
        if (((_a = this.form) === null || _a === void 0 ? void 0 : _a.name) === 'notificationForm' && ((_b = this.model.notificationFormOptions) === null || _b === void 0 ? void 0 : _b.action)) {
            this.model.notificationFormOptions.action();
        }
        this.form = null;
    }
    centerForm(baseForm, defaultTop) {
        if (this.form != null) {
            setTimeout(() => {
                const position = this.helper.setObjectToCenter(baseForm.element.nativeElement, defaultTop);
                this.form.left = position.left;
                this.form.top = position.top;
                this.form.level = baseForm.level;
            });
        }
    }
    startMove(name, event, touchEvent) {
        if (event || touchEvent && touchEvent.changedTouches.length > 0) {
            this.formX = this.form.left;
            this.formY = this.form.top;
            this.mouseX = (event === null || event === void 0 ? void 0 : event.screenX) || touchEvent.changedTouches[0].screenX;
            this.mouseY = (event === null || event === void 0 ? void 0 : event.screenY) || touchEvent.changedTouches[0].screenY;
            this.form.isMooving = true;
        }
    }
    move(event) {
        var _a;
        if ((_a = this.form) === null || _a === void 0 ? void 0 : _a.isMooving) {
            const screenX = event.screenX || (event.changedTouches.length > 0 ? event.changedTouches[0].screenX : -1);
            const screenY = event.screenY || (event.changedTouches.length > 0 ? event.changedTouches[0].screenY : -1);
            this.form.left = this.formX + (screenX - this.mouseX);
            this.form.top = this.formY + (screenY - this.mouseY);
            this.menuService.closeAllMenus();
        }
    }
    stopMove() {
        var _a;
        if ((_a = this.form) === null || _a === void 0 ? void 0 : _a.isMooving) {
            this.form.isMooving = false;
        }
    }
}
FormService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormService, deps: [{ token: MouseService }, { token: MenuService }, { token: HelperService }, { token: ModelService }], target: i0.ɵɵFactoryTarget.Injectable });
FormService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: MouseService }, { type: MenuService }, { type: HelperService }, { type: ModelService }]; } });

class FullScreenService {
    constructor(model, pageService) {
        this.model = model;
        this.pageService = pageService;
    }
    changeFullScreenMode(fullScreenMode) {
        this.model.options.appearance.fullScreenMode = fullScreenMode;
        const viewer = this.model.controls.viewer.el.nativeElement;
        if (fullScreenMode) {
            this.model.fullScreenOptions = {
                scrollbarsMode: this.model.options.appearance.scrollbarsMode,
                zIndex: viewer.style.zIndex,
                position: viewer.style.position,
                width: viewer.style.width,
                height: viewer.style.height,
                overflow: document.body.style.overflow
            };
            this.model.options.appearance.scrollbarsMode = true;
            viewer.style.zIndex = '1000000';
            viewer.style.position = this.model.options.reportDesignerMode ? 'absolute' : 'fixed';
            viewer.style.width = null;
            viewer.style.height = null;
            document.body.style.overflow = 'hidden';
        }
        else if (this.model.fullScreenOptions) {
            this.model.options.appearance.scrollbarsMode = this.model.fullScreenOptions.scrollbarsMode;
            viewer.style.zIndex = this.model.fullScreenOptions.zIndex;
            viewer.style.position = this.model.fullScreenOptions.position;
            viewer.style.width = this.model.fullScreenOptions.width;
            viewer.style.height = this.model.fullScreenOptions.height;
            document.body.style.overflow = this.model.fullScreenOptions.overflow;
            this.model.fullScreenOptions = null;
        }
        this.pageService.calculateLayout();
    }
}
FullScreenService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FullScreenService, deps: [{ token: ModelService }, { token: PageService }], target: i0.ɵɵFactoryTarget.Injectable });
FullScreenService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FullScreenService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FullScreenService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: PageService }]; } });

class ControllerService {
    constructor(httpClient, model, stylesService, pageService, helper, formService, fullScreenService, menuService, styleService, animationService) {
        this.httpClient = httpClient;
        this.model = model;
        this.stylesService = stylesService;
        this.pageService = pageService;
        this.helper = helper;
        this.formService = formService;
        this.fullScreenService = fullScreenService;
        this.menuService = menuService;
        this.styleService = styleService;
        this.animationService = animationService;
        this.subject = new Subject();
        this.actionSubject = new Subject();
        setInterval(() => {
            var _a, _b;
            if (this.model.httpError) {
                if ((_a = this.model.httpError.error) === null || _a === void 0 ? void 0 : _a.text) {
                    this.showError((_b = this.model.httpError.error) === null || _b === void 0 ? void 0 : _b.text);
                }
                else if (this.model.httpError.message) {
                    this.showError(null, this.model.httpError.message);
                }
                else if (this.model.httpError.error instanceof ErrorEvent) {
                    this.showError(this.model.httpError.error.message);
                }
                this.model.httpError = null;
            }
            if (this.model.navigateNode) {
                this.postBookmarkNodeAction(this.model.navigateNode);
                this.model.navigateNode = null;
            }
        }, 250);
        this.setupHandlers();
    }
    setupHandlers() {
        this.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'GetReport':
                case 'OpenReport':
                    setTimeout(() => {
                        var _a, _b;
                        this.styleService.addCustomFontStyles((_a = message.data) === null || _a === void 0 ? void 0 : _a.customFonts);
                        if (this.model.options.appearance.fullScreenMode) {
                            this.fullScreenService.changeFullScreenMode(true);
                        }
                        if (((_b = message.data) === null || _b === void 0 ? void 0 : _b.stimulsoftFontContent) && !this.model.options.stimulsoftFontContentLoaded) {
                            this.model.options.stimulsoftFontContentLoaded = message.data.stimulsoftFontContent;
                            this.styleService.addCustomFontStyles([{
                                    contentForCss: message.data.stimulsoftFontContent,
                                    originalFontFamily: 'Stimulsoft'
                                }]);
                        }
                    });
                    break;
            }
        });
        this.model.controls.bookmarksPanel.getVisibility().subscribe((value) => {
            if (value && this.model.options.isMobileDevice) {
                this.model.controls.parametersPanel.visible = false;
            }
            if (value) {
                this.hideToolbar();
            }
            else {
                this.showToolbar();
            }
        });
        this.model.controls.parametersPanel.getVisibility().subscribe((value) => {
            if (value && this.model.options.isMobileDevice) {
                this.model.controls.bookmarksPanel.visible = false;
            }
            if (value) {
                this.hideToolbar();
            }
            else {
                this.showToolbar();
            }
        });
        this.menuService.getVisibility().subscribe((menu) => {
            this.hideToolbar();
        });
    }
    hideToolbar() {
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            this.model.controls.toolbar.visible = false;
            this.model.controls.navigatePanel.visible = false;
        }
    }
    showToolbar() {
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            this.model.controls.toolbar.visible = true;
            this.model.controls.navigatePanel.visible = true;
            setTimeout(() => {
                this.keepToolbar();
            }, 300);
        }
    }
    keepToolbar() {
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            clearTimeout(this.model.toolbarHideTimer);
            this.model.toolbarHideTimer = setTimeout(() => {
                this.hideToolbar();
            }, 4000);
        }
    }
    getMessage() {
        return this.subject.asObservable();
    }
    getActionMessage() {
        return this.actionSubject.asObservable();
    }
    post(action, cAction, postData, responseType = 'json', subAction) {
        this.model.controls.navigatePanel.enabled = false;
        this.model.controls.toolbar.enabled = false;
        let url;
        if (!cAction) {
            url = this.model.requestUrl.replace('{action}', action === 'GetReport' || this.model.options.server.cacheMode === 'None' ? this.model.options.actions.getReport : this.model.options.actions.viewerEvent);
        }
        else {
            url = this.model.requestUrl.replace('{action}', cAction);
        }
        if (postData) {
            postData.action = action;
        }
        else {
            postData = { action };
        }
        this.httpClient.post(url, this.model.createPostParameters(postData), responseType).subscribe(data => {
            var _a;
            this.model.showProgress = false;
            this.model.controls.navigatePanel.enabled = true;
            this.model.controls.toolbar.enabled = true;
            if (data === 'ServerError:The report is not specified.' && ((_a = this.model.options) === null || _a === void 0 ? void 0 : _a.isReportRecieved)) {
                this.model.options.isReportRecieved = false;
                this.model.reportParams.prevPageNumber = this.model.reportParams.pageNumber;
                this.post('GetReport');
                return;
            }
            if (data) {
                this.model.reportParams = data;
                this.startRefreshReportTimer(data.refreshTime);
                if (data.reportDisplayMode) {
                    this.model.options.displayModeFromReport = data.reportDisplayMode;
                }
            }
            this.subject.next({ action, data, subAction });
        });
    }
    loadViewer() {
        const url = this.model.requestUrl.replace('{action}', this.model.action);
        this.httpClient.post(url, this.model.createPostParameters({ action: 'AngularViewerData' }, true, false), 'json').subscribe(data => {
            this.model.clear();
            this.stylesService.setupStyle(atob(data['styles']), 'viewer');
            this.model.options = data;
            this.checkTrExp();
            this.initAutoUpdateCache();
            this.subject.next({ action: 'viewer_loaded' });
            this.getReport();
        });
    }
    getReport() {
        this.model.options.paramsVariablesStartValues = null;
        this.post('GetReport');
    }
    getPages() {
        this.post('GetPages');
    }
    postExport(format, settings, elementName, isDashboardExport = false) {
        const data = {
            action: isDashboardExport ? 'ExportDashboard' : 'ExportReport',
            exportFormat: format,
            exportSettings: settings,
            elementName
        };
        const doc = settings && settings.OpenAfterExport && this.model.options.appearance.openExportedReportWindow === '_blank' ? this.helper.openNewWindow('about:blank', '_blank').document : null;
        const url = this.model.requestUrl;
        this.httpClient.postForm(url.replace('{action}', this.model.options.actions.exportReport), data, doc);
        this.actionSubject.next({ action: 'ExportReport', data });
    }
    loadFile(fileName, content) {
        if (typeof content !== 'string' || content === '') {
            return;
        }
        if (content.indexOf('<?xml') === 0 || content.indexOf('{') === 0) {
            content = btoa(content);
        }
        const data = {
            action: 'OpenReport',
            openingFileName: fileName || 'Report.mdc',
            base64Data: content.indexOf('base64,') > 0 ? content.substr(content.indexOf('base64,') + 7) : content
        };
        if (fileName && (fileName.toLowerCase().indexOf('.mdx') >= 0 || fileName.toLowerCase().indexOf('.mrx') >= 0)) {
            this.formService.showForm('passwordForm', data);
        }
        else {
            this.postOpen(data);
        }
    }
    postOpen(data) {
        this.model.clearViewerState();
        this.model.reportParams.reportFileName = data.openingFileName;
        this.post('OpenReport', this.model.options.actions.openReport, data);
    }
    action(event) {
        switch (event.name) {
            case 'Find':
                this.model.controls.findPanel.visible = !this.model.controls.findPanel.visible;
                return;
            case 'Bookmarks':
                this.model.controls.bookmarksPanel.visible = !this.model.controls.bookmarksPanel.visible;
                return;
            case 'Parameters':
                this.model.controls.parametersPanel.visible = !this.model.controls.parametersPanel.visible;
                return;
            case 'BookmarkAction':
                if (this.model.reportParams.pageNumber === event.bookmarkPage || this.model.reportParams.viewMode !== 'SinglePage') {
                    this.helper.scrollToAnchor(event.bookmarkAnchor, event.componentGuid);
                    return;
                }
                else {
                    this.model.reportParams.pageNumber = event.bookmarkPage;
                    this.model.options.bookmarkAnchor = event.bookmarkAnchor;
                    this.model.options.componentGuid = event.componentGuid;
                }
                break;
            case 'GoToPage':
                this.model.reportParams.pageNumber = event.value;
                this.scrollToPage();
                break;
            case 'FirstPage':
                this.model.reportParams.pageNumber = 0;
                this.scrollToPage();
                break;
            case 'PrevPage':
                this.model.reportParams.pageNumber = Math.max(0, this.model.reportParams.pageNumber - 1);
                this.scrollToPage();
                break;
            case 'NextPage':
                this.model.reportParams.pageNumber = Math.min(this.model.reportParams.pagesCount - 1, this.model.reportParams.pageNumber + 1);
                this.scrollToPage();
                break;
            case 'LastPage':
                this.model.reportParams.pageNumber = this.model.reportParams.pagesCount - 1;
                this.scrollToPage();
                break;
            case 'ViewModeSinglePage':
                this.model.reportParams.viewMode = 'SinglePage';
                break;
            case 'ViewModeContinuous':
                this.model.reportParams.viewMode = 'Continuous';
                break;
            case 'ViewModeMultiplePages':
                this.model.reportParams.viewMode = 'MultiplePages';
                break;
            case 'Zoom25':
                this.model.reportParams.zoom = 25;
                break;
            case 'Zoom50':
                this.model.reportParams.zoom = 50;
                break;
            case 'Zoom75':
                this.model.reportParams.zoom = 75;
                break;
            case 'Zoom100':
                this.model.reportParams.zoom = 100;
                break;
            case 'Zoom150':
                this.model.reportParams.zoom = 150;
                break;
            case 'Zoom200':
                this.model.reportParams.zoom = 200;
                break;
            case 'ZoomOnePage':
            case 'ZoomPageWidth':
                this.model.reportParams.zoom = event.name === 'ZoomPageWidth' ? this.pageService.getZoomByPageWidth() : this.pageService.getZoomByPageHeight();
                break;
            case 'Submit':
                this.model.reportParams.editableParameters = null;
                if (this.model.reportParams.type === 'Report') {
                    this.model.reportParams.pageNumber = 0;
                }
                if (this.model.options.isMobileDevice) {
                    this.model.controls.parametersPanel.visible = false;
                }
                this.actionSubject.next({ action: 'Variables' });
                return;
            case 'Reset':
                if (this.model.options.paramsVariablesStartValues) {
                    this.model.options.paramsVariables = this.model.options.paramsVariablesStartValues;
                }
                this.actionSubject.next({ action: 'Reset' });
                return;
            case 'Editor':
                this.actionSubject.next({ action: 'Editor', data: {} });
                return;
            case 'Resources':
                this.model.controls.resourcesPanel.visible = !this.model.controls.resourcesPanel.visible;
                return;
            case 'PrintPdf':
            case 'PrintWithPreview':
            case 'PrintWithoutPreview':
                this.actionSubject.next({ action: 'Print', data: { format: event.name } });
                return;
            case 'Print':
                let format = 'PrintPdf';
                switch (this.model.options.toolbar.printDestination) {
                    case 'Pdf':
                        format = 'PrintPdf';
                        break;
                    case 'Direct':
                        format = 'PrintWithoutPreview';
                        break;
                    case 'WithPreview':
                        format = 'PrintWithPreview';
                        break;
                }
                this.actionSubject.next({ action: 'Print', data: { format } });
                return;
            case 'Open':
                this.model.openDialogFileMask = null;
                setTimeout(() => {
                    this.model.openDialogFileMask = '.mdc,.mdz,.mdx,.mrt,.mrz,.mrx';
                });
                return;
            case 'ResourceView':
                this.postReportResource(event.value.name, 'View');
                return;
            case 'ResourceSaveFile':
                this.postReportResource(event.value.name, 'SaveFile');
                return;
            case 'FullScreen':
                this.fullScreenService.changeFullScreenMode(!this.model.options.appearance.fullScreenMode);
                return;
            case 'About':
                this.actionSubject.next({ action: 'About' });
                return;
            case 'Pin':
                this.model.options.toolbar.autoHide = !this.model.options.toolbar.autoHide;
                this.pageService.calculateLayout();
                if (this.model.options.toolbar.autoHide) {
                    setTimeout(() => {
                        this.hideToolbar();
                    }, 200);
                }
                return;
            case 'Design':
                this.actionSubject.next({ action: 'Design' });
                break;
            default:
                if (event.name.indexOf('saveMenu') === 0) {
                    this.actionSubject.next({ action: 'Export', data: { format: event.name.substr(8) } });
                    return;
                }
                else if (event.name.indexOf('sendEmailMenu') === 0) {
                    this.actionSubject.next({ action: 'SendEmail', data: { format: event.name.substr(13) } });
                    return;
                }
        }
        this.getPages();
    }
    scrollToPage() {
        if (this.model.reportParams.viewMode === 'Continuous') {
            let panel = this.model.controls.reportPanel.el.nativeElement;
            const endTime = (new Date()).getTime() + this.model.options.scrollDuration;
            let targetTop = this.model.pages[this.model.reportParams.pageNumber].page.offsetTop;
            this.animationService.showAnimationForScroll(panel, targetTop, endTime, () => { });
        }
    }
    showError(message, messageText) {
        let type = 'Error';
        // Check for error in 'ServerError:' string format
        if (message != null && typeof (message) === 'string' && message.substr(0, 12) === 'ServerError:') {
            if (message.length <= 13) {
                messageText = 'An unknown error occurred (the server returned an empty value).';
            }
            else {
                messageText = message.substr(12);
            }
        }
        // Check for error in JSON format
        if (message != null && message.success === false && message.type && message.text) {
            type = message.type;
            messageText = message.text;
        }
        this.model.errorMessage = { error: 'Unknown error', type };
        if (messageText != null) {
            if (messageText === 'The report is not specified.' && !this.model.options.appearance.showReportIsNotSpecifiedMessage) {
                return true;
            }
            this.model.errorMessage = { error: messageText.replace('\n', '<br>'), type };
            if (this.model.images) {
                this.formService.showForm('errorMessageForm');
            }
            else {
                alert(messageText);
            }
            this.actionSubject.next({ action: 'Error' });
            return true;
        }
        return false;
    }
    postReportResource(resourceName, viewType) {
        const data = {
            action: 'ReportResource',
            reportResourceParams: {
                resourceName,
                viewType
            }
        };
        const doc = viewType === 'View' ? this.helper.openNewWindow('about:blank', '_blank').document : null;
        const url = this.model.requestUrl;
        this.httpClient.postForm(url.replace('{action}', this.model.options.actions.viewerEvent), data, doc);
    }
    postBookmarkNodeAction(node) {
        node.selected = true;
        this.action({ name: 'BookmarkAction', bookmarkPage: node.page, bookmarkAnchor: node.url.replace(/\\\'/g, '\'').substr(1), componentGuid: node.compunentGuid });
    }
    viewerResized() {
        this.menuService.closeAllMenus();
    }
    initAutoUpdateCache() {
        if (this.model.options.server.allowAutoUpdateCache) {
            if (this.model.timerAutoUpdateCache) {
                clearInterval(this.model.timerAutoUpdateCache);
            }
            this.model.timerAutoUpdateCache = setInterval(() => this.post('UpdateCache'), this.model.options.server.timeoutAutoUpdateCache);
        }
    }
    startRefreshReportTimer(timeout) {
        if (this.model.refreshReportTimer != null) {
            clearInterval(this.model.refreshReportTimer);
            this.model.refreshReportTimer = null;
        }
        if (timeout && timeout > 0) {
            this.model.refreshReportTimer = setInterval(() => {
                if (!this.model.showProgress) {
                    this.post('Refresh');
                }
            }, timeout * 1000);
        }
    }
    checkTrExp() {
        if (!this.model.options.cloudMode && !this.model.options.serverMode && !this.model.options.standaloneJsMode && !this.model.options.reportDesignerMode && !this.model.options.alternateValid) {
            let buildDate = new Date();
            try {
                buildDate = new Date(this.model.options.buildDate);
            }
            catch (_a) { }
            const trDays = Math.floor(((new Date()).getTime() - buildDate.getTime()) / 1000 / 60 / 60 / 24);
            if (trDays > 45) {
                setTimeout(() => {
                    const message = trDays > 60 ? this.model.loc('NoticesYourTrialHasExpired') : this.model.loc('NoticesYouUsingTrialVersion');
                    const image = 'Notifications.Warning.png';
                    const buttonCaption = this.model.loc('ButtonOk');
                    let cancelAction;
                    let action;
                    if (trDays > 60) {
                        action = cancelAction = () => { window.location.href = 'https://www.stimulsoft.com/en/online-store'; };
                    }
                    this.model.notificationFormOptions = { message, image, buttonCaption, cancelAction, action };
                    this.formService.showForm('notificationForm');
                }, 3000);
            }
        }
    }
}
ControllerService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ControllerService, deps: [{ token: StiHttpClientService }, { token: ModelService }, { token: StylesService }, { token: PageService }, { token: HelperService }, { token: FormService }, { token: FullScreenService }, { token: MenuService }, { token: StylesService }, { token: AnimationService }], target: i0.ɵɵFactoryTarget.Injectable });
ControllerService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ControllerService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ControllerService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: StiHttpClientService }, { type: ModelService }, { type: StylesService }, { type: PageService }, { type: HelperService }, { type: FormService }, { type: FullScreenService }, { type: MenuService }, { type: StylesService }, { type: AnimationService }]; } });

class CollectionsService {
    constructor(model) {
        this.model = model;
    }
    getImageTypesItems() {
        const items = [];
        if (this.model.options.exports.showExportToImageBmp) {
            items.push(new Item('Bmp', 'Bmp', null, 'Bmp'));
        }
        if (this.model.options.exports.showExportToImageGif) {
            items.push(new Item('Gif', 'Gif', null, 'Gif'));
        }
        if (this.model.options.exports.showExportToImageJpeg) {
            items.push(new Item('Jpeg', 'Jpeg', null, 'Jpeg'));
        }
        if (this.model.options.exports.showExportToImagePcx) {
            items.push(new Item('Pcx', 'Pcx', null, 'Pcx'));
        }
        if (this.model.options.exports.showExportToImagePng) {
            items.push(new Item('Png', 'Png', null, 'Png'));
        }
        if (this.model.options.exports.showExportToImageTiff) {
            items.push(new Item('Tiff', 'Tiff', null, 'Tiff'));
        }
        if (this.model.options.exports.showExportToImageMetafile) {
            items.push(new Item('Emf', 'Emf', null, 'Emf'));
        }
        if (this.model.options.exports.showExportToImageSvg) {
            items.push(new Item('Svg', 'Svg', null, 'Svg'));
        }
        if (this.model.options.exports.showExportToImageSvgz) {
            items.push(new Item('Svgz', 'Svgz', null, 'Svgz'));
        }
        return items;
    }
    getDataTypesItems() {
        const items = [];
        if (this.model.options.exports.showExportToCsv) {
            items.push(new Item('Csv', 'Csv', null, 'Csv'));
        }
        if (this.model.options.exports.showExportToDbf) {
            items.push(new Item('Dbf', 'Dbf', null, 'Dbf'));
        }
        if (this.model.options.exports.showExportToXml) {
            items.push(new Item('Xml', 'Xml', null, 'Xml'));
        }
        if (this.model.options.exports.showExportToDif) {
            items.push(new Item('Dif', 'Dif', null, 'Dif'));
        }
        if (this.model.options.exports.showExportToSylk) {
            items.push(new Item('Sylk', 'Sylk', null, 'Sylk'));
        }
        if (this.model.options.exports.showExportToJson) {
            items.push(new Item('Json', 'Json', null, 'Json'));
        }
        return items;
    }
    getExcelTypesItems() {
        const items = [];
        if (this.model.options.exports.showExportToExcel2007) {
            items.push(new Item('Excel2007', 'Excel', null, 'Excel2007'));
        }
        if (this.model.options.exports.showExportToExcel) {
            items.push(new Item('ExcelBinary', 'Excel 97-2003', null, 'ExcelBinary'));
        }
        if (this.model.options.exports.showExportToExcelXml) {
            items.push(new Item('ExcelXml', 'Excel Xml 2003', null, 'ExcelXml'));
        }
        return items;
    }
    getHtmlTypesItems() {
        const items = [];
        if (this.model.options.exports.showExportToHtml) {
            items.push(new Item('Html', 'Html', null, 'Html'));
        }
        if (this.model.options.exports.showExportToHtml5) {
            items.push(new Item('Html5', 'Html5', null, 'Html5'));
        }
        if (this.model.options.exports.showExportToMht) {
            items.push(new Item('Mht', 'Mht', null, 'Mht'));
        }
        return items;
    }
    getZoomItems() {
        const items = [];
        [0.25, 0.5, 0.75, 1, 1.25, 1.5, 2].forEach((item, i) => items.push(new Item('item' + i, (item * 100) + '%', null, item)));
        return items;
    }
    getImageFormatForHtmlItems() {
        const items = [];
        items.push(new Item('item0', 'Jpeg', null, 'Jpeg'));
        items.push(new Item('item1', 'Gif', null, 'Gif'));
        items.push(new Item('item2', 'Bmp', null, 'Bmp'));
        items.push(new Item('item3', 'Png', null, 'Png'));
        return items;
    }
    getExportModeItems() {
        const items = [];
        items.push(new Item('item0', 'Table', null, 'Table'));
        items.push(new Item('item1', 'Span', null, 'Span'));
        items.push(new Item('item2', 'Div', null, 'Div'));
        return items;
    }
    getImageResolutionItems() {
        const items = [];
        ['10', '25', '50', '75', '100', '200', '300', '400', '500'].forEach((item, i) => items.push(new Item('item' + i, item, null, parseInt(item, 10))));
        return items;
    }
    getImageCompressionMethodItems() {
        const items = [];
        items.push(new Item('item0', 'Jpeg', null, 'Jpeg'));
        items.push(new Item('item1', 'Flate', null, 'Flate'));
        return items;
    }
    getImageQualityItems() {
        const items = [];
        [0.25, 0.5, 0.75, 0.85, 0.9, 0.95, 1].forEach((item, i) => items.push(new Item('item' + i, (item * 100).toString(), null, item)));
        return items;
    }
    getBorderTypeItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('BorderTypeSimple'), null, 'Simple'));
        items.push(new Item('item1', this.model.loc('BorderTypeSingle'), null, 'UnicodeSingle'));
        items.push(new Item('item2', this.model.loc('BorderTypeDouble'), null, 'UnicodeDouble'));
        return items;
    }
    getEncodingDataItems() {
        const items = [];
        this.model.encodingData.forEach((item, i) => items.push(new Item('item' + i, item.value, null, item.key)));
        return items;
    }
    getImageFormatItems(withoutMonochrome = false) {
        const items = [];
        items.push(new Item('item0', this.model.loc('ImageFormatColor'), null, 'Color'));
        items.push(new Item('item1', this.model.loc('ImageFormatGrayscale'), null, 'Grayscale'));
        if (!withoutMonochrome) {
            items.push(new Item('item2', this.model.loc('ImageFormatMonochrome'), null, 'Monochrome'));
        }
        return items;
    }
    getMonochromeDitheringTypeItems() {
        const items = [];
        items.push(new Item('item0', 'None', null, 'None'));
        items.push(new Item('item1', 'FloydSteinberg', null, 'FloydSteinberg'));
        items.push(new Item('item2', 'Ordered', null, 'Ordered'));
        return items;
    }
    getTiffCompressionSchemeItems() {
        const items = [];
        items.push(new Item('item0', 'Default', null, 'Default'));
        items.push(new Item('item1', 'CCITT3', null, 'CCITT3'));
        items.push(new Item('item2', 'CCITT4', null, 'CCITT4'));
        items.push(new Item('item3', 'LZW', null, 'LZW'));
        items.push(new Item('item4', 'None', null, 'None'));
        items.push(new Item('item5', 'Rle', null, 'Rle'));
        return items;
    }
    getEncodingDifFileItems() {
        const items = [];
        items.push(new Item('item0', '437', null, '437'));
        items.push(new Item('item1', '850', null, '850'));
        items.push(new Item('item2', '852', null, '852'));
        items.push(new Item('item3', '857', null, '857'));
        items.push(new Item('item4', '860', null, '860'));
        items.push(new Item('item5', '861', null, '861'));
        items.push(new Item('item6', '862', null, '862'));
        items.push(new Item('item7', '863', null, '863'));
        items.push(new Item('item8', '865', null, '865'));
        items.push(new Item('item9', '866', null, '866'));
        items.push(new Item('item10', '869', null, '869'));
        return items;
    }
    getExportModeRtfItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('ExportModeRtfTable'), null, 'Table'));
        items.push(new Item('item1', this.model.loc('ExportModeRtfFrame'), null, 'Frame'));
        return items;
    }
    getEncodingDbfFileItems() {
        const items = [];
        items.push(new Item('item0', 'Default', null, 'Default'));
        items.push(new Item('item1', '437 U.S. MS-DOS', null, 'USDOS'));
        items.push(new Item('item2', '620 Mazovia(Polish) MS-DOS', null, 'MazoviaDOS'));
        items.push(new Item('item3', '737 Greek MS-DOS(437G)', null, 'GreekDOS'));
        items.push(new Item('item4', '850 International MS-DOS', null, 'InternationalDOS'));
        items.push(new Item('item5', '852 Eastern European MS-DOS', null, 'EasternEuropeanDOS'));
        items.push(new Item('item6', '857 Turkish MS-DOS', null, 'TurkishDOS'));
        items.push(new Item('item7', '861 Icelandic MS-DOS', null, 'IcelandicDOS'));
        items.push(new Item('item8', '865 Nordic MS-DOS', null, 'NordicDOS'));
        items.push(new Item('item9', '866 Russian MS-DOS', null, 'RussianDOS'));
        items.push(new Item('item10', '895 Kamenicky(Czech) MS-DOS', null, 'KamenickyDOS'));
        items.push(new Item('item11', '1250 Eastern European Windows', null, 'EasternEuropeanWindows'));
        items.push(new Item('item12', '1251 Russian Windows', null, 'RussianWindows'));
        items.push(new Item('item13', '1252 WindowsANSI', null, 'WindowsANSI'));
        items.push(new Item('item14', '1253 GreekWindows', null, 'GreekWindows'));
        items.push(new Item('item15', '1254 TurkishWindows', null, 'TurkishWindows'));
        items.push(new Item('item16', '10000 StandardMacintosh', null, 'StandardMacintosh'));
        items.push(new Item('item17', '10006 GreekMacintosh', null, 'GreekMacintosh'));
        items.push(new Item('item18', '10007 RussianMacintosh', null, 'RussianMacintosh'));
        items.push(new Item('item19', '10029 EasternEuropeanMacintosh', null, 'EasternEuropeanMacintosh'));
        return items;
    }
    getAllowEditableItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('NameYes'), null, 'Yes'));
        items.push(new Item('item1', this.model.loc('NameNo'), null, 'No'));
        return items;
    }
    getEncryptionKeyLengthItems() {
        const items = [];
        items.push(new Item('item0', '40 bit RC4 (Acrobat 3)', null, 'Bit40'));
        items.push(new Item('item1', '128 bit RC4 (Acrobat 5)', null, 'Bit128'));
        items.push(new Item('item2', '128 bit AES (Acrobat 7)', null, 'Bit128_r4'));
        items.push(new Item('item3', '256 bit AES (Acrobat 9)', null, 'Bit256_r5'));
        items.push(new Item('item4', '256 bit AES (Acrobat X)', null, 'Bit256_r6'));
        return items;
    }
    getDataExportModeItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('BandsFilterDataOnly'), null, 'Data'));
        items.push(new Item('item1', this.model.loc('BandsFilterDataAndHeaders'), null, 'DataAndHeaders'));
        items.push(new Item('item2', this.model.loc('BandsFilterDataAndHeadersFooters'), null, 'DataAndHeadersFooters'));
        items.push(new Item('item3', this.model.loc('BandsFilterAllBands'), null, 'AllBands'));
        return items;
    }
    getFilterConditionItems(dataType) {
        const items = [];
        switch (dataType) {
            case 'String':
                items.push(new Item('item0', this.model.loc('ConditionEqualTo'), '', 'EqualTo'));
                items.push(new Item('item1', this.model.loc('ConditionNotEqualTo'), '', 'NotEqualTo'));
                items.push('separator1');
                items.push(new Item('item2', this.model.loc('ConditionContaining'), '', 'Containing'));
                items.push(new Item('item3', this.model.loc('ConditionNotContaining'), '', 'NotContaining'));
                items.push('separator2');
                items.push(new Item('item4', this.model.loc('ConditionBeginningWith'), '', 'BeginningWith'));
                items.push(new Item('item5', this.model.loc('ConditionEndingWith'), '', 'EndingWith'));
                items.push('separator3');
                items.push(new Item('item2', this.model.loc('ConditionBetween'), '', 'Between'));
                items.push(new Item('item3', this.model.loc('ConditionNotBetween'), '', 'NotBetween'));
                items.push('separator4');
                items.push(new Item('item6', this.model.loc('ConditionGreaterThan'), '', 'GreaterThan'));
                items.push(new Item('item7', this.model.loc('ConditionGreaterThanOrEqualTo'), '', 'GreaterThanOrEqualTo'));
                items.push('separator5');
                items.push(new Item('item8', this.model.loc('ConditionLessThan'), '', 'LessThan'));
                items.push(new Item('item9', this.model.loc('ConditionLessThanOrEqualTo'), '', 'LessThanOrEqualTo'));
                items.push('separator6');
                items.push(new Item('item10', this.model.loc('ConditionIsNull'), '', 'IsNull'));
                items.push(new Item('item11', this.model.loc('ConditionIsNotNull'), '', 'IsNotNull'));
                items.push('separator7');
                items.push(new Item('item12', this.model.loc('ConditionIsBlank'), '', 'IsBlank'));
                items.push(new Item('item13', this.model.loc('ConditionIsNotBlank'), '', 'IsNotBlank'));
                break;
            case 'Numeric':
            case 'DateTime':
                {
                    items.push(new Item('item0', this.model.loc('ConditionEqualTo'), '', 'EqualTo'));
                }
                items.push(new Item('item1', this.model.loc('ConditionNotEqualTo'), '', 'NotEqualTo'));
                items.push('separator1');
                items.push(new Item('item2', this.model.loc('ConditionBetween'), '', 'Between'));
                items.push(new Item('item3', this.model.loc('ConditionNotBetween'), '', 'NotBetween'));
                items.push('separator2');
                items.push(new Item('item4', this.model.loc('ConditionGreaterThan'), '', 'GreaterThan'));
                items.push(new Item('item5', this.model.loc('ConditionGreaterThanOrEqualTo'), '', 'GreaterThanOrEqualTo'));
                items.push('separator3');
                items.push(new Item('item6', this.model.loc('ConditionLessThan'), '', 'LessThan'));
                items.push(new Item('item7', this.model.loc('ConditionLessThanOrEqualTo'), '', 'LessThanOrEqualTo'));
                items.push('separator4');
                items.push(new Item('item8', this.model.loc('ConditionIsNull'), '', 'IsNull'));
                items.push(new Item('item9', this.model.loc('ConditionIsNotNull'), '', 'IsNotNull'));
                break;
            case 'Boolean':
                {
                    items.push(new Item('item0', this.model.loc('ConditionEqualTo'), '', 'EqualTo'));
                }
                items.push(new Item('item1', this.model.loc('ConditionNotEqualTo'), '', 'NotEqualTo'));
                break;
        }
        return items;
    }
    getBoolItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('NameTrue'), null, 'True'));
        items.push(new Item('item1', this.model.loc('NameFalse'), null, 'False'));
        return items;
    }
    getPaperSizesItems() {
        const items = [];
        this.model.paperSizes.forEach((item, i) => items.push(new Item('item' + i, item, null, item)));
        return items;
    }
    getOrientationItems() {
        const items = [];
        items.push(new Item('item0', this.model.loc('Portrait'), null, 'Portrait'));
        items.push(new Item('item1', this.model.loc('Landscape'), null, 'Landscape'));
        return items;
    }
    getDashboardImageQualityItems() {
        const items = [];
        [50, 75, 100, 150, 200, 300, 500].forEach((item, i) => items.push(new Item('item' + i, item + '%', null, item.toString())));
        return items;
    }
    getPdfSecurityCertificatesItems() {
        let items = [];
        if (this.model.pdfSecurityCertificates) {
            for (var i = 0; i < this.model.pdfSecurityCertificates.length; i++) {
                var item = this.model.pdfSecurityCertificates[i];
                items.push(new Item('item' + i, "Name: " + item.name + "<br>Issuer: " + item.issuer + "<br>Valid from: " + item.from + " to " + item.to, null, item.thumbprint, null, null, null, 'DigitalSignature'));
            }
        }
        return items;
    }
}
CollectionsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CollectionsService, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Injectable });
CollectionsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CollectionsService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CollectionsService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }]; } });

class ExportService {
    constructor(formService, helper, model, collections, controller) {
        this.formService = formService;
        this.helper = helper;
        this.model = model;
        this.collections = collections;
        this.controller = controller;
        this.exportSettings = {};
        this.sendMail = false;
        this.subject = new Subject();
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Export':
                    this.export(message.data.format);
                    break;
                case 'SendEmail':
                    this.export(message.data.format, false, true);
                    break;
            }
        });
    }
    getMessage() {
        return this.subject.asObservable();
    }
    export(format, update = false, sendMail = false) {
        if (!this.helper.checkCloudAuthorization('export')) {
            return;
        }
        this.sendMail = sendMail;
        this.format = format;
        this.exportSettings = this.getDefaultExportSettings(this.format);
        if ((this.model.options.exports.showExportDialog && !sendMail) || (this.model.options.email.showExportDialog && sendMail)) {
            this.exportFormSettings = this.getExportSetings(update);
            if (!update) {
                this.formService.closeForm('exportForm');
                setTimeout(() => {
                    this.formService.showForm('exportForm');
                });
            }
        }
        else {
            this.postExport();
        }
    }
    postExport() {
        if (!this.sendMail) {
            this.controller.postExport(this.format, this.exportSettings);
        }
        else {
            this.subject.next('postMail');
        }
    }
    getExportSetings(update) {
        let result;
        this.getDefaultSettings();
        switch (this.format) {
            case 'Document':
                result = { components: this.getComponents(['SaveReportMdc', 'SaveReportMdz', 'SaveReportMdx', 'SaveReportPassword']) };
                break;
            case 'Pdf':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ImageResolution', 'ImageCompressionMethod',
                        'AllowEditable', 'ImageQuality', /*'StandardPdfFonts',*/ 'EmbeddedFonts', /*'UseUnicode', 'Compressed',*/ 'ExportRtfTextAsImage', 'PdfACompliance', 'UseDigitalSignature', 'DocumentSecurityButton', 'DigitalSignatureButton',
                        'OpenAfterExport', 'PasswordInputUser', 'PasswordInputOwner', 'PrintDocument', 'ModifyContents', 'CopyTextAndGraphics',
                        'AddOrModifyTextAnnotations', 'KeyLength', 'GetCertificateFromCryptoUI', 'SubjectNameString']),
                    openAfterExport: true
                };
                break;
            case 'Xps':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ImageResolution', 'ImageQuality', 'OpenAfterExport',
                        'ExportRtfTextAsImage']),
                    openAfterExport: true
                };
                break;
            case 'Ppt2007':
                result = { components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ImageResolution', 'ImageQuality']) };
                break;
            case 'Html':
                result = {
                    components: this.getComponents(['HtmlType', 'Zoom', 'ImageFormatForHtml', 'ExportMode', 'UseEmbeddedImages', 'AddPageBreaks']),
                    openAfterExport: true
                };
                break;
            case 'Html5':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'HtmlType', 'ImageFormatForHtml', 'ImageResolution',
                        'ImageQuality', 'ContinuousPages', 'OpenAfterExport']),
                    openAfterExport: true
                };
                break;
            case 'Mht':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'HtmlType', 'Zoom', 'ImageFormatForHtml',
                        'ExportMode', 'AddPageBreaks'])
                };
                break;
            case 'Text':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'KillSpaceLines',
                        'PutFeedPageCode', 'DrawBorder', 'CutLongLines', 'BorderType', 'ZoomX', 'ZoomY', 'EncodingTextOrCsvFile'])
                };
                break;
            case 'Rtf':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ImageResolution',
                        'ImageQuality', 'ExportModeRtf', 'UsePageHeadersAndFooters', 'RemoveEmptySpaceAtBottom'])
                };
                break;
            case 'Word2007':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ImageResolution',
                        'ImageQuality', 'UsePageHeadersAndFooters', 'RemoveEmptySpaceAtBottom'])
                };
                break;
            case 'Odt':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ImageResolution',
                        'ImageQuality', 'RemoveEmptySpaceAtBottom'])
                };
                break;
            case 'Excel':
            case 'ExcelBinary':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ExcelType', 'ImageResolution',
                        'ImageQuality', 'DataExportMode', 'ExportObjectFormatting', 'UseOnePageHeaderAndFooter', 'ExportEachPageToSheet', 'ExportPageBreaks']),
                    openAfterExport: true
                };
                break;
            case 'ExcelXml':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ExcelType'])
                };
                break;
            case 'Excel2007':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ExcelType', 'ImageResolution',
                        'ImageQuality', 'DataExportMode', 'ExportObjectFormatting', 'UseOnePageHeaderAndFooter', 'ExportEachPageToSheet', 'ExportPageBreaks'])
                };
                break;
            case 'Ods':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ImageResolution',
                        'ImageQuality'])
                };
                break;
            case 'Csv':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'DataType', 'EncodingTextOrCsvFile',
                        'Separator', 'DataExportMode', 'SkipColumnHeaders'])
                };
                break;
            case 'Dbf':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'DataType', 'EncodingDbfFile'])
                };
                break;
            case 'Dif':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'DataType', 'ExportDataOnly',
                        'UseDefaultSystemEncoding', 'EncodingDifFile'])
                };
                break;
            case 'Sylk':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'DataType', 'ExportDataOnly',
                        'UseDefaultSystemEncoding', 'EncodingDifFile'])
                };
                break;
            case 'Json':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'DataType', 'DataExportMode'])
                };
                break;
            case 'Xml':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'DataType'])
                };
                break;
            case 'ImageBmp':
            case 'ImageGif':
            case 'ImageJpeg':
            case 'ImagePcx':
            case 'ImagePng':
            case 'ImageTiff':
            case 'ImageEmf':
            case 'ImageSvg':
            case 'ImageSvgz':
                result = {
                    components: this.getComponents(['PageRangeGroup', 'PageRangeAll', 'PageRangeCurrentPage', 'PageRangePages', 'PageRangePagesText', 'SettingsGroup', 'ImageType', 'ImageZoom', 'ImageResolution',
                        'ImageFormat', 'DitheringType', 'TiffCompressionScheme', 'CompressToArchive', 'CutEdges'])
                };
                break;
        }
        result.groups = this.getGroups(this.format);
        result.update = update;
        return result;
    }
    getComponents(names) {
        const mrgn = '8px';
        const components = [];
        names.forEach(name => {
            switch (name) {
                case 'ImageType':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('Type'), width: 160, tooltip: this.model.loc('TypeTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getImageTypesItems()
                    });
                    break;
                case 'DataType':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('Type'), width: 160, tooltip: this.model.loc('TypeTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getDataTypesItems()
                    });
                    break;
                case 'ExcelType':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('Type'), width: 160, tooltip: this.model.loc('TypeTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getExcelTypesItems()
                    });
                    break;
                case 'HtmlType':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('Type'), width: 160, tooltip: this.model.loc('TypeTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getHtmlTypesItems()
                    });
                    break;
                case 'Zoom':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ZoomHtml'), width: 160, tooltip: this.model.loc('ZoomHtmlTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getZoomItems()
                    });
                    break;
                case 'ImageZoom':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ZoomHtml'), width: 160, tooltip: this.model.loc('ZoomHtmlTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getZoomItems()
                    });
                    break;
                case 'ImageFormatForHtml':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ImageFormatForHtml'), width: 160, tooltip: this.model.loc('ImageFormatForHtmlTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getImageFormatForHtmlItems()
                    });
                    break;
                case 'ExportMode':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ExportMode'), width: 160, tooltip: this.model.loc('ExportModeTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getExportModeItems()
                    });
                    break;
                case 'CompressToArchive':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('CompressToArchive'), tooltip: this.model.loc('CompressToArchiveTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'UseEmbeddedImages':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('EmbeddedImageData'), tooltip: this.model.loc('EmbeddedImageDataTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'AddPageBreaks':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('AddPageBreaks'), tooltip: this.model.loc('AddPageBreaksTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'ImageResolution':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ImageResolution'), width: 160, tooltip: this.model.loc('ImageResolutionTooltip'),
                        margin: '2px 4px 2px ' + mrgn, items: this.collections.getImageResolutionItems()
                    });
                    break;
                case 'ImageCompressionMethod':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ImageCompressionMethod'), width: 160, tooltip: this.model.loc('ImageCompressionMethodTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getImageCompressionMethodItems()
                    });
                    break;
                case 'AllowEditable':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('AllowEditable'), width: 160, tooltip: this.model.loc('AllowEditableTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getAllowEditableItems()
                    });
                    break;
                case 'ImageQuality':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ImageQuality'), width: 160, tooltip: this.model.loc('ImageQualityTooltip'),
                        margin: '2px 4px 2px ' + mrgn, items: this.collections.getImageQualityItems()
                    });
                    break;
                case 'ContinuousPages':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('ContinuousPages'), tooltip: this.model.loc('ContinuousPagesTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'StandardPdfFonts':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('StandardPDFFonts'), tooltip: this.model.loc('StandardPDFFontsTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'EmbeddedFonts':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('EmbeddedFonts'), tooltip: this.model.loc('EmbeddedFontsTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'UseUnicode':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('UseUnicode'), tooltip: this.model.loc('UseUnicodeTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'Compressed':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('Compressed'), tooltip: this.model.loc('CompressedTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'ExportRtfTextAsImage':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('ExportRtfTextAsImage'), tooltip: this.model.loc('ExportRtfTextAsImageTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'PdfACompliance':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('PdfACompliance'), tooltip: this.model.loc('PdfAComplianceTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'KillSpaceLines':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('KillSpaceLines'), tooltip: this.model.loc('KillSpaceLinesTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'PutFeedPageCode':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('PutFeedPageCode'), tooltip: this.model.loc('PutFeedPageCodeTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'DrawBorder':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('DrawBorder'), tooltip: this.model.loc('DrawBorderTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'CutLongLines':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('CutLongLines'), tooltip: this.model.loc('CutLongLinesTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'BorderType':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('BorderType'), width: 160, tooltip: this.model.loc('BorderTypeTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getBorderTypeItems()
                    });
                    break;
                case 'ZoomX':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ZoomXY').replace(':', '') + ' X ', width: 160, tooltip: this.model.loc('ZoomXYTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getZoomItems()
                    });
                    break;
                case 'ZoomY':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ZoomXY').replace(':', '') + ' Y ', width: 160, tooltip: this.model.loc('ZoomXYTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getZoomItems()
                    });
                    break;
                case 'EncodingTextOrCsvFile':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('EncodingData'), width: 160, tooltip: this.model.loc('EncodingDataTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getEncodingDataItems()
                    });
                    break;
                case 'ImageFormat':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ImageFormat'), width: 160, tooltip: this.model.loc('ImageFormatTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getImageFormatItems()
                    });
                    break;
                case 'DitheringType':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('MonochromeDitheringType'), width: 160, tooltip: this.model.loc('MonochromeDitheringTypeTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getMonochromeDitheringTypeItems()
                    });
                    break;
                case 'TiffCompressionScheme':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('TiffCompressionScheme'), width: 160, tooltip: this.model.loc('TiffCompressionSchemeTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getTiffCompressionSchemeItems()
                    });
                    break;
                case 'CutEdges':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('CutEdges'), tooltip: this.model.loc('CutEdgesTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'MultipleFiles':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('MultipleFiles'), tooltip: this.model.loc('MultipleFilesTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'ExportDataOnly':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('ExportDataOnly'), tooltip: this.model.loc('ExportDataOnlyTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'UseDefaultSystemEncoding':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('UseDefaultSystemEncoding'), tooltip: this.model.loc('UseDefaultSystemEncodingTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'EncodingDifFile':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('EncodingDifFile'), width: 160, tooltip: this.model.loc('EncodingDifFileTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getEncodingDifFileItems()
                    });
                    break;
                case 'ExportModeRtf':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('ExportModeRtf'), width: 160, tooltip: this.model.loc('ExportModeRtfTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getExportModeRtfItems()
                    });
                    break;
                case 'UsePageHeadersAndFooters':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('UsePageHeadersFooters'), tooltip: this.model.loc('UsePageHeadersFootersTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'RemoveEmptySpaceAtBottom':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('RemoveEmptySpace'), tooltip: this.model.loc('RemoveEmptySpaceTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'Separator':
                    components.push({
                        name, type: 'TextBox', label: this.model.loc('Separator'), tooltip: this.model.loc('SeparatorTooltip'), width: 160,
                        margin: '2px ' + mrgn + ' 2px ' + mrgn
                    });
                    break;
                case 'DataExportMode':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('BandsFilter'), width: 160, tooltip: this.model.loc('BandsFilterTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getDataExportModeItems()
                    });
                    break;
                case 'SkipColumnHeaders':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('SkipColumnHeaders'), tooltip: this.model.loc('SkipColumnHeadersTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'ExportObjectFormatting':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('ExportObjectFormatting'), tooltip: this.model.loc('ExportObjectFormattingTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'UseOnePageHeaderAndFooter':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('UseOnePageHeaderFooter'), tooltip: this.model.loc('UseOnePageHeaderFooterTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'ExportEachPageToSheet':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('ExportEachPageToSheet'), tooltip: this.model.loc('ExportEachPageToSheetTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'ExportPageBreaks':
                    components.push({
                        name, type: 'CheckBox', caption: this.model.loc('ExportPageBreaks'), tooltip: this.model.loc('ExportPageBreaksTooltip'),
                        margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                case 'EncodingDbfFile':
                    components.push({
                        name, type: 'DropDownListForExportForm', label: this.model.loc('EncodingDbfFile'), width: 160, tooltip: this.model.loc('EncodingDbfFileTooltip'),
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getEncodingDbfFileItems()
                    });
                    break;
                case 'DocumentSecurityButton':
                    components.push({
                        name, type: 'SmallButton', caption: this.model.loc('DocumentSecurityButton'), width: 160,
                        margin: '2px ' + mrgn + ' 2px ' + mrgn, items: this.collections.getEncodingDbfFileItems()
                    });
                    break;
                case 'UseDigitalSignature':
                    components.push({
                        name, caption: this.model.loc('DigitalSignatureButton'), type: 'DropDownListForExportForm', tooltip: this.model.loc('UseDigitalSignatureTooltip'), width: 160,
                        items: this.collections.getPdfSecurityCertificatesItems(), margin: '4px ' + mrgn + ' 4px ' + mrgn
                    });
                    break;
                default:
                    break;
            }
        });
        return components;
    }
    getGroups(format) {
        const openingGroupsStr = this.helper.getCookie('StimulsoftWebViewerExportSettingsOpeningGroups');
        const openingGroups = openingGroupsStr ? JSON.parse(openingGroupsStr) : null;
        const pageRangeAllIsDisabled = format.indexOf('Image') === 0 && format !== 'ImageTiff';
        return {
            savingReportGroup: { visible: format === 'Document', opened: openingGroups ? openingGroups.SavingReportGroup : true },
            pageRangeGroup: { visible: format !== 'Document', opened: openingGroups ? openingGroups.PageRangeGroup : true, pageRangeAllIsDisabled },
            settingsGroup: { visible: format !== 'Document', opened: openingGroups ? openingGroups.SettingsGroup : false }
        };
    }
    getDefaultSettings() {
        let settings;
        if (this.model.options.exports.storeExportSettings && this.helper.getCookie('StimulsoftWebViewerExportSettings' + this.getCommonExportFormat())) {
            const exportSettingsStr = this.helper.getCookie('StimulsoftWebViewerExportSettings' + this.getCommonExportFormat());
            const exportSettings = JSON.parse(exportSettingsStr);
            let exportFormat = exportSettings.ImageType || exportSettings.DataType || exportSettings.ExcelType || exportSettings.HtmlType;
            if (exportFormat === 'ExcelBinary') {
                exportFormat = 'Excel';
            }
            this.format = exportFormat ? (exportSettings.ImageType ? 'Image' + exportFormat : exportFormat) : this.format;
            const defSettings = this.getDefaultExportSettings(this.format);
            const resultSettings = {};
            Object.keys(defSettings).forEach(key => resultSettings[key] = exportSettings[key] || defSettings[key]);
            Object.keys(exportSettings).forEach(key => resultSettings[key] = exportSettings[key] || defSettings[key]);
            if (this.model.options.exports.showOpenAfterExport === false) {
                resultSettings.OpenAfterExport = true;
            }
            else if (!(this.format === 'Pdf' || this.format === 'Xps' || this.format === 'Html' || this.format === 'Excel' || this.format === 'ExcelBinary')) {
                resultSettings.OpenAfterExport = false;
            }
            if (this.model.options.exports.openAfterExport === true || this.model.options.exports.openAfterExport === false) {
                resultSettings.OpenAfterExport = this.model.options.exports.openAfterExport;
            }
            settings = resultSettings;
        }
        else {
            settings = this.getDefaultExportSettings(this.format);
        }
        this.updateTypes(settings);
        this.exportSettings = this.helper.copyObject(settings);
    }
    updateTypes(defaultExportSettings) {
        const types = ['ImageType', 'DataType', 'ExcelType', 'HtmlType'];
        types.forEach((propertyName) => {
            if (defaultExportSettings[propertyName]) {
                switch (propertyName) {
                    case 'ImageType':
                        if (!this.model.options.exports.showExportToImageBmp && defaultExportSettings[propertyName] === 'Bmp') {
                            defaultExportSettings[propertyName] = 'Gif';
                        }
                        if (!this.model.options.exports.showExportToImageGif && defaultExportSettings[propertyName] === 'Gif') {
                            defaultExportSettings[propertyName] = 'Jpeg';
                        }
                        if (!this.model.options.exports.showExportToImageJpeg && defaultExportSettings[propertyName] === 'Jpeg') {
                            defaultExportSettings[propertyName] = 'Pcx';
                        }
                        if (!this.model.options.exports.showExportToImagePcx && defaultExportSettings[propertyName] === 'Pcx') {
                            defaultExportSettings[propertyName] = 'Png';
                        }
                        if (!this.model.options.exports.showExportToImagePng && defaultExportSettings[propertyName] === 'Png') {
                            defaultExportSettings[propertyName] = 'Tiff';
                        }
                        if (!this.model.options.exports.showExportToImageTiff && defaultExportSettings[propertyName] === 'Tiff') {
                            defaultExportSettings[propertyName] = 'Emf';
                        }
                        if (!this.model.options.exports.showExportToImageMetafile && defaultExportSettings[propertyName] === 'Emf') {
                            defaultExportSettings[propertyName] = 'Svg';
                        }
                        if (!this.model.options.exports.showExportToImageSvg && defaultExportSettings[propertyName] === 'Svg') {
                            defaultExportSettings[propertyName] = 'Svgz';
                        }
                        if (!this.model.options.exports.showExportToImageSvgz && defaultExportSettings[propertyName] === 'Svgz') {
                            defaultExportSettings[propertyName] = 'Bmp';
                        }
                        break;
                    case 'DataType':
                        if (!this.model.options.exports.showExportToCsv && defaultExportSettings[propertyName] === 'Csv') {
                            defaultExportSettings[propertyName] = 'Dbf';
                        }
                        if (!this.model.options.exports.showExportToDbf && defaultExportSettings[propertyName] === 'Dbf') {
                            defaultExportSettings[propertyName] = 'Xml';
                        }
                        if (!this.model.options.exports.showExportToXml && defaultExportSettings[propertyName] === 'Xml') {
                            defaultExportSettings[propertyName] = 'Dif';
                        }
                        if (!this.model.options.exports.showExportToDif && defaultExportSettings[propertyName] === 'Dif') {
                            defaultExportSettings[propertyName] = 'Sylk';
                        }
                        if (!this.model.options.exports.showExportToSylk && defaultExportSettings[propertyName] === 'Sylk') {
                            defaultExportSettings[propertyName] = 'Csv';
                        }
                        if (!this.model.options.exports.showExportToJson && defaultExportSettings[propertyName] === 'Json') {
                            defaultExportSettings[propertyName] = 'Json';
                        }
                        break;
                    case 'ExcelType':
                        if (!this.model.options.exports.showExportToExcel2007 && defaultExportSettings[propertyName] === 'Excel2007') {
                            defaultExportSettings[propertyName] = 'ExcelBinary';
                        }
                        if (!this.model.options.exports.showExportToExcel && defaultExportSettings[propertyName] === 'ExcelBinary') {
                            defaultExportSettings[propertyName] = 'ExcelXml';
                        }
                        if (!this.model.options.exports.showExportToExcelXml && defaultExportSettings[propertyName] === 'ExcelXml') {
                            defaultExportSettings[propertyName] = 'Excel2007';
                        }
                        break;
                    case 'HtmlType':
                        if (!this.model.options.exports.showExportToHtml && defaultExportSettings[propertyName] === 'Html') {
                            defaultExportSettings[propertyName] = 'Html5';
                        }
                        if (!this.model.options.exports.showExportToHtml5 && defaultExportSettings[propertyName] === 'Html5') {
                            defaultExportSettings[propertyName] = 'Mht';
                        }
                        if (!this.model.options.exports.showExportToMht && defaultExportSettings[propertyName] === 'Mht') {
                            defaultExportSettings[propertyName] = 'Html';
                        }
                        break;
                }
            }
        });
    }
    getCommonExportFormat() {
        if (this.format === 'Html' || this.format === 'Html5' || this.format === 'Mht') {
            return 'Html';
        }
        if (this.format === 'Excel' || this.format === 'Excel2007' || this.format === 'ExcelXml') {
            return 'Excel';
        }
        if (this.format === 'Csv' || this.format === 'Dbf' || this.format === 'Xml' || this.format === 'Dif' || this.format === 'Sylk') {
            return 'Data';
        }
        if (this.format === 'ImageBmp' || this.format === 'ImageGif' || this.format === 'ImageJpeg' || this.format === 'ImagePcx' || this.format === 'ImagePng' ||
            this.format === 'ImageTiff' || this.format === 'ImageEmf' || this.format === 'ImageSvg' || this.format === 'ImageSvgz') {
            return 'Image';
        }
        return this.format;
    }
    getDefaultExportSettings(format, isDashboardExport = false) {
        let exportSettings = null;
        if (isDashboardExport) {
            return this.model.options.exports.defaultSettings['Dashboard' + format];
        }
        switch (format) {
            case 'Document':
                exportSettings = { Format: 'Mdc' };
                break;
            case 'Pdf':
                exportSettings = this.model.options.exports.defaultSettings['StiPdfExportSettings'];
                break;
            case 'Xps':
                exportSettings = this.model.options.exports.defaultSettings['StiXpsExportSettings'];
                break;
            case 'Ppt2007':
                exportSettings = this.model.options.exports.defaultSettings['StiPpt2007ExportSettings'];
                break;
            case 'Html':
                exportSettings = this.model.options.exports.defaultSettings['StiHtmlExportSettings'];
                exportSettings.HtmlType = 'Html';
                break;
            case 'Html5':
                exportSettings = this.model.options.exports.defaultSettings['StiHtmlExportSettings'];
                exportSettings.HtmlType = 'Html5';
                break;
            case 'Mht':
                exportSettings = this.model.options.exports.defaultSettings['StiHtmlExportSettings'];
                exportSettings.HtmlType = 'Mht';
                break;
            case 'Text':
                exportSettings = this.model.options.exports.defaultSettings['StiTxtExportSettings'];
                break;
            case 'Rtf':
                exportSettings = this.model.options.exports.defaultSettings['StiRtfExportSettings'];
                break;
            case 'Word2007':
                exportSettings = this.model.options.exports.defaultSettings['StiWord2007ExportSettings'];
                break;
            case 'Odt':
                exportSettings = this.model.options.exports.defaultSettings['StiOdtExportSettings'];
                break;
            case 'Excel':
                exportSettings = this.model.options.exports.defaultSettings['StiExcelExportSettings'];
                exportSettings.ExcelType = 'ExcelBinary';
                break;
            case 'ExcelXml':
                exportSettings = this.model.options.exports.defaultSettings['StiExcelExportSettings'];
                exportSettings.ExcelType = 'ExcelXml';
                break;
            case 'Excel2007':
                exportSettings = this.model.options.exports.defaultSettings['StiExcelExportSettings'];
                exportSettings.ExcelType = 'Excel2007';
                break;
            case 'Ods':
                exportSettings = this.model.options.exports.defaultSettings['StiOdsExportSettings'];
                break;
            case 'ImageBmp':
                exportSettings = this.model.options.exports.defaultSettings['StiImageExportSettings'];
                exportSettings.ImageType = 'Bmp';
                break;
            case 'ImageGif':
                exportSettings = this.model.options.exports.defaultSettings['StiImageExportSettings'];
                exportSettings.ImageType = 'Gif';
                break;
            case 'ImageJpeg':
                exportSettings = this.model.options.exports.defaultSettings['StiImageExportSettings'];
                exportSettings.ImageType = 'Jpeg';
                break;
            case 'ImagePcx':
                exportSettings = this.model.options.exports.defaultSettings['StiImageExportSettings'];
                exportSettings.ImageType = 'Pcx';
                break;
            case 'ImagePng':
                exportSettings = this.model.options.exports.defaultSettings['StiImageExportSettings'];
                exportSettings.ImageType = 'Png';
                break;
            case 'ImageTiff':
                exportSettings = this.model.options.exports.defaultSettings['StiImageExportSettings'];
                exportSettings.ImageType = 'Tiff';
                break;
            case 'ImageSvg':
                exportSettings = this.model.options.exports.defaultSettings['StiImageExportSettings'];
                exportSettings.ImageType = 'Svg';
                break;
            case 'ImageSvgz':
                exportSettings = this.model.options.exports.defaultSettings['StiImageExportSettings'];
                exportSettings.ImageType = 'Svgz';
                break;
            case 'ImageEmf':
                exportSettings = this.model.options.exports.defaultSettings['StiImageExportSettings'];
                exportSettings.ImageType = 'Emf';
                break;
            case 'Xml':
                exportSettings = this.model.options.exports.defaultSettings['StiDataExportSettings'];
                exportSettings.DataType = 'Xml';
                break;
            case 'Csv':
                exportSettings = this.model.options.exports.defaultSettings['StiDataExportSettings'];
                exportSettings.DataType = 'Csv';
                break;
            case 'Dbf':
                exportSettings = this.model.options.exports.defaultSettings['StiDataExportSettings'];
                exportSettings.DataType = 'Dbf';
                break;
            case 'Dif':
                exportSettings = this.model.options.exports.defaultSettings['StiDataExportSettings'];
                exportSettings.DataType = 'Dif';
                break;
            case 'Sylk':
                exportSettings = this.model.options.exports.defaultSettings['StiDataExportSettings'];
                exportSettings.DataType = 'Sylk';
                break;
        }
        exportSettings.OpenAfterExport = !(this.model.options.exports.showOpenAfterExport === false);
        if (!(format === 'Pdf' || format === 'Xps' || format === 'Html' || format === 'Excel' || format === 'ExcelBinary')) {
            exportSettings.OpenAfterExport = false;
        }
        return exportSettings;
    }
}
ExportService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ExportService, deps: [{ token: FormService }, { token: HelperService }, { token: ModelService }, { token: CollectionsService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Injectable });
ExportService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ExportService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ExportService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: FormService }, { type: HelperService }, { type: ModelService }, { type: CollectionsService }, { type: ControllerService }]; } });

class MailService {
    constructor(model, exportService, formService, controller) {
        this.model = model;
        this.exportService = exportService;
        this.formService = formService;
        this.controller = controller;
        exportService.getMessage().subscribe(event => {
            if (event === 'postMail') {
                this.postMail();
            }
        });
    }
    postMail() {
        this.fillDefaults();
        if (this.model.options.email.showEmailDialog) {
            this.formService.showForm('sendEmailForm');
        }
        else {
            this.sendMail();
        }
    }
    sendMail() {
        const data = {
            exportFormat: this.exportService.format,
            exportSettings: this.exportService.exportSettings
        };
        this.formService.closeForm('sendEmailForm');
        this.controller.post('EmailReport', this.model.options.actions.emailReport, data);
        this.controller.actionSubject.next({ action: 'Email', data });
    }
    fillDefaults() {
        this.exportService.exportSettings.Email = this.model.options.email.defaultEmailAddress;
        this.exportService.exportSettings.Message = this.model.options.email.defaultEmailMessage;
        this.exportService.exportSettings.Subject = this.model.options.email.defaultEmailSubject;
        let ext = this.exportService.format.toLowerCase().replace('image', '');
        switch (ext) {
            case 'excel':
                ext = 'xls';
                break;
            case 'excel2007':
                ext = 'xlsx';
                break;
            case 'excelxml':
                ext = 'xls';
                break;
            case 'html5':
                ext = 'html';
                break;
            case 'jpeg':
                ext = 'jpg';
                break;
            case 'ppt2007':
                ext = 'ppt';
                break;
            case 'text':
                ext = 'txt';
                break;
            case 'word2007':
                ext = 'docx';
                break;
        }
        this.exportService.exportSettings.Attachment = this.model.reportParams.reportFileName + '.' + ext;
    }
}
MailService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MailService, deps: [{ token: ModelService }, { token: ExportService }, { token: FormService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Injectable });
MailService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MailService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MailService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ExportService }, { type: FormService }, { type: ControllerService }]; } });

class FindService {
    constructor(model, helper, animationService) {
        this.model = model;
        this.helper = helper;
        this.animationService = animationService;
        this.symbols = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';
        this.findLabels = [];
        this.text = '';
        this.lastFindText = '';
        this.matchCase = false;
        this.matchWholeWord = false;
        this.findMode = false;
        model.controls.findPanel.getVisibility().subscribe((value) => {
            if (!value) {
                this.hideFindLabels();
                this.lastFindText = '';
            }
        });
    }
    hideFindLabels() {
        this.findLabels.forEach((findLabel) => {
            const parentElement = findLabel.parentElement;
            parentElement.removeChild(findLabel);
            if (parentElement.oldPositionStyle) {
                parentElement.style.position = parentElement.oldPositionStyle;
            }
        });
        this.findLabels = [];
        this.findMode = false;
        this.lastFindText = '';
    }
    selectFindLabel(direction) {
        if (this.findLabels.length === 0) {
            return;
        }
        let selectedIndex = 0;
        const labels = this.findLabels;
        for (let i = 0; i < labels.length; i++) {
            if (labels[i].isSelected) {
                labels[i].setSelected(false);
                selectedIndex = i;
                break;
            }
        }
        if (direction === 'Next') {
            selectedIndex++;
            if (selectedIndex > labels.length - 1) {
                selectedIndex = 0;
            }
        }
        else {
            selectedIndex--;
            if (selectedIndex < 0) {
                selectedIndex = labels.length - 1;
            }
        }
        labels[selectedIndex].setSelected(true);
        this.goToFindedElement(labels[selectedIndex]);
    }
    showFindLabels() {
        this.hideFindLabels();
        this.findMode = true;
        this.lastFindText = this.text;
        const text = this.matchCase ? this.text : this.text.toLowerCase();
        this.model.pages.forEach(page => {
            const pageElements = page.page.getElementsByTagName('*');
            for (const pageElement of pageElements) {
                let innerText = pageElement.innerHTML;
                if (innerText && pageElement.childNodes.length === 1 && pageElement.childNodes[0].nodeName === '#text') {
                    if (!this.matchCase) {
                        innerText = innerText.toLowerCase();
                    }
                    if (innerText.indexOf(text) >= 0) {
                        if (this.matchWholeWord && !this.isWholeWord(innerText, text)) {
                            continue;
                        }
                        const label = document.createElement('div');
                        label.ownerElement = pageElement;
                        label.className = 'stiJsViewerFindLabel';
                        label.style.width = (pageElement.offsetWidth - 4) + 'px';
                        const labelHeight = pageElement.offsetHeight - 4;
                        label.style.height = labelHeight + 'px';
                        label.style.top = '0px';
                        label.style.left = '0px';
                        label.ownerElement.oldPositionStyle = label.ownerElement.style.position;
                        if (label.ownerElement.style.position !== 'absolute' && label.ownerElement.style.position !== 'fixed') {
                            label.ownerElement.style.position = 'relative';
                        }
                        pageElement.insertBefore(label, pageElement.childNodes[0]);
                        label.setSelected = function (state) {
                            this.isSelected = state;
                            this.style.border = '2px solid ' + (state ? 'red' : '#8a8a8a');
                        };
                        if (this.findLabels.length === 0) {
                            label.setSelected(true);
                        }
                        this.findLabels.push(label);
                    }
                }
            }
        });
        if (this.findLabels.length > 0) {
            this.goToFindedElement(this.findLabels[0]);
        }
    }
    goToFindedElement(findLabel) {
        if (findLabel && findLabel.ownerElement) {
            const targetTop = this.helper.findPosY(findLabel.ownerElement, this.model.options.appearance.scrollbarsMode ? 'stiJsViewerReportPanel' : null, true) - findLabel.ownerElement.offsetHeight - 50;
            const d = new Date();
            const endTime = d.getTime() + this.model.options.scrollDuration;
            this.animationService.showAnimationForScroll(this.model.controls.reportPanel.el.nativeElement, targetTop, endTime, () => { });
        }
    }
    isWholeWord(str, word) {
        const index = str.indexOf(word);
        const preSymbol = str.substring(index - 1, index);
        const nextSymbol = str.substring(index + word.length, index + word.length + 1);
        return ((preSymbol === '' || this.symbols.indexOf(preSymbol) === -1) && (nextSymbol === '' || this.symbols.indexOf(nextSymbol) === -1));
    }
}
FindService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindService, deps: [{ token: ModelService }, { token: HelperService }, { token: AnimationService }], target: i0.ɵɵFactoryTarget.Injectable });
FindService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }, { type: AnimationService }]; } });

class ApiService {
    constructor(model, controller, exportService, helper, mailService, findService) {
        this.model = model;
        this.controller = controller;
        this.exportService = exportService;
        this.helper = helper;
        this.mailService = mailService;
        this.findService = findService;
        this.EXPORT_FORMATS = ['Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
            'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
            'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'];
    }
    /**
     * The current page number
     */
    get currentPage() {
        return this.model.reportParams.pageNumber;
    }
    set currentPage(value) {
        if (value >= 0 && value < this.model.reportParams.pagesCount) {
            this.model.reportParams.pageNumber = value;
            this.controller.getPages();
        }
    }
    /**
     * The total pages count
     */
    get pageCount() {
        return this.model.reportParams.pageNumber;
    }
    /**
     * The view mode, can be 'SinglePage', 'Continuous' & 'MultiplePages'
     */
    get viewMode() {
        return this.model.reportParams.viewMode;
    }
    set viewMode(value) {
        if (value === 'SinglePage' || value === 'Continuous' || value === 'MultiplePages') {
            this.model.reportParams.viewMode = value;
            this.controller.getPages();
        }
    }
    /**
     * The page zoom in percent
     * From 1 to 1000
     */
    get zoom() {
        return this.model.reportParams.zoom;
    }
    set zoom(value) {
        if (value >= 1 && value <= 1000) {
            this.model.reportParams.zoom = value;
            this.controller.getPages();
        }
    }
    /**
     * Zoom page in height
     */
    zoomPageHeight() {
        this.controller.action({ name: 'ZoomOnePage' });
    }
    /**
     * Zoom page in width
     */
    zoomPageWidth() {
        this.controller.action({ name: 'ZoomPageWidth' });
    }
    /**
     * Print to PDF
     */
    printPdf() {
        this.controller.action({ name: 'PrintPdf' });
    }
    /**
     * Print with preview
     */
    printWithPreview() {
        this.controller.action({ name: 'PrintWithPreview' });
    }
    /**
     * Print without preview
     */
    printWithoutPreview() {
        this.controller.action({ name: 'PrintWithoutPreview' });
    }
    /**
     * Show export form
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportForm(format) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            this.controller.actionSubject.next({ action: 'Export', data: { format } });
        }
    }
    /**
     * Show export form & email
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportEmailForm(format) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            this.controller.actionSubject.next({ action: 'SendEmail', data: { format } });
        }
    }
    /**
     * Export report/dashboard to selected format
     * Use default settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     */
    export(format, settings) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            const exportSettings = this.getExportSettings(format, settings);
            this.controller.postExport(format, exportSettings);
        }
    }
    /**
     * Export report/dashboard to seleted format & email
     * Use default settings if not specified
     * Use default email settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     *
     * @param email The email
     *
     * @param message The email message
     *
     * @param subject The email subject
     */
    exportEmail(format, settings, email, subject, message) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            this.exportService.exportSettings = this.getExportSettings(format, settings);
            this.exportService.format = format;
            this.mailService.fillDefaults();
            if (email) {
                this.exportService.exportSettings.Email = email;
            }
            if (message) {
                this.exportService.exportSettings.Message = message;
            }
            if (subject) {
                this.exportService.exportSettings.Subject = subject;
            }
            this.mailService.sendMail();
        }
    }
    /**
     * Search text in report
     *
     * @param text text to search
     *
     * @param matchCase
     *
     * @param matchWholeWord
     */
    search(text, matchCase, matchWholeWord) {
        this.findService.text = text;
        this.findService.matchCase = matchCase;
        this.findService.matchWholeWord = matchWholeWord;
        this.findService.showFindLabels();
    }
    /**
     * Select next or previous search
     *
     * @param direction 'Next' or 'Previous'
     *
     */
    selectSearchLabel(direction) {
        this.findService.selectFindLabel(direction);
    }
    /**
     * Hide search
     */
    hideSearchLabels() {
        this.findService.hideFindLabels();
    }
    getExportSettings(format, settings) {
        this.exportService.sendMail = false;
        this.exportService.format = format;
        const exportSettings = this.helper.copyObject(this.exportService.getDefaultExportSettings(format));
        if (settings) {
            Object.keys(settings).forEach(key => exportSettings[key] = settings[key]);
        }
        return exportSettings;
    }
}
ApiService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ApiService, deps: [{ token: ModelService }, { token: ControllerService }, { token: ExportService }, { token: HelperService }, { token: MailService }, { token: FindService }], target: i0.ɵɵFactoryTarget.Injectable });
ApiService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ApiService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ApiService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: ExportService }, { type: HelperService }, { type: MailService }, { type: FindService }]; } });

class PrintService {
    constructor(model, exportService, helper, httpClient, controller) {
        this.model = model;
        this.exportService = exportService;
        this.helper = helper;
        this.httpClient = httpClient;
        this.controller = controller;
        controller.getActionMessage().subscribe((message) => {
            if (message.action === 'Print') {
                this.postPrint(message.data.format);
            }
        });
        controller.getMessage().subscribe((message) => {
            if (message.action === 'PrintReport') {
                switch (message.subAction) {
                    case 'PrintWithPreview':
                        this.printAsPopup(message.data);
                        break;
                    case 'PrintWithoutPreview':
                        this.printAsHtml(message.data);
                        break;
                }
            }
        });
    }
    postPrint(printAction) {
        if (printAction === 'PrintPdf' && /iPhone|iPad|iPod|Macintosh/i.test(navigator.userAgent) && this.helper.isTouchDevice()) {
            const settings = this.exportService.getDefaultExportSettings('Pdf');
            settings.OpenAfterExport = true;
            this.postExport('Pdf', settings);
            return;
        }
        const data = {
            action: 'PrintReport',
            printAction,
            bookmarksPrint: this.model.options.appearance.bookmarksPrint
        };
        const url = ''; // this.model.options.requestUrl.replace('{action}', this.model.options.actions.printReport);
        switch (printAction) {
            case 'PrintPdf':
                if (this.model.options.appearance.printToPdfMode === 'Popup' || this.helper.getNavigatorName() == 'Safari' || this.helper.getNavigatorName() == 'iPad') {
                    this.printAsPdfPopup(data);
                }
                else {
                    this.printAsPdf(url, data);
                }
                break;
            default:
                this.controller.post('PrintReport', this.model.options.actions.printReport, data, 'text', printAction);
                break;
        }
    }
    postExport(format, settings, elementName, isDashboardExport) {
        const data = {
            action: isDashboardExport ? 'ExportDashboard' : 'ExportReport',
            exportFormat: format,
            exportSettings: settings,
            elementName
        };
        const doc = settings && settings.OpenAfterExport && this.model.options.appearance.openExportedReportWindow === '_blank' ? this.helper.openNewWindow('about:blank', '_blank').document : null;
        const url = this.model.requestUrl;
        this.httpClient.postForm(url.replace('{action}', this.model.options.actions.exportReport), data, doc);
    }
    printAsPdfPopup(data) {
        const url = this.model.requestUrl.replace('{action}', this.model.options.actions.printReport);
        const win = this.helper.openNewWindow('about:blank', '_blank');
        if (win != null) {
            this.httpClient.postForm(url, data, win.document);
        }
    }
    printAsPdf(url, data) {
        data.responseType = 'blob';
        const viewer = this.model.controls.viewer.el.nativeElement;
        const printFrameId = this.model.options.viewerId + '_PdfPrintFrame';
        let printFrame = document.getElementById(printFrameId);
        if (printFrame) {
            viewer.removeChild(printFrame);
        }
        printFrame = document.createElement('iframe');
        printFrame.id = printFrameId;
        printFrame.name = printFrameId;
        printFrame.width = '0';
        printFrame.height = '0';
        printFrame.style.position = 'absolute';
        printFrame.style.border = 'none';
        // Firefox does not load the invisible content of the iframe
        if (this.helper.getNavigatorName() === 'Mozilla') {
            printFrame.width = '100px';
            printFrame.height = '100px';
            printFrame.style.visibility = 'hidden';
            printFrame.style.zIndex = '-100';
            printFrame.style.pointerEvents = 'none';
        }
        viewer.insertBefore(printFrame, viewer.firstChild);
        // Manual printing in browsers that do not support automatic PDF printing
        if (this.helper.getNavigatorName() !== 'Mozilla') {
            printFrame.onload = () => {
                printFrame.contentWindow.focus();
                printFrame.contentWindow.print();
            };
        }
        const form = document.createElement('FORM');
        form.setAttribute('id', 'printForm');
        form.setAttribute('method', 'POST');
        form.setAttribute('action', this.model.requestUrl.replace('{action}', this.model.options.actions.printReport));
        form.setAttribute('target', this.model.options.viewerId + '_PdfPrintFrame');
        const params = this.model.createPostParameters(data, true);
        Object.keys(params).forEach(key => {
            const paramsField = document.createElement('INPUT');
            paramsField.setAttribute('type', 'hidden');
            paramsField.setAttribute('name', key);
            paramsField.setAttribute('value', params[key]);
            form.appendChild(paramsField);
        });
        document.body.appendChild(form);
        form.submit();
        document.body.removeChild(form);
    }
    printAsPopup(text) {
        const width = this.model.reportParams.pagesWidth || 790;
        const win = this.helper.openNewWindow('about:blank', 'PrintReport', 'height=900,width=' + width + ',toolbar=no,menubar=yes,scrollbars=yes,resizable=yes,location=no,directories=no,status=no');
        if (win != null) {
            win.document.open();
            win.document.write(text);
            win.document.close();
        }
    }
    printAsHtml(text) {
        if (this.controller.showError(text)) {
            return;
        }
        const viewer = this.model.controls.viewer.el.nativeElement;
        // Remove '_PdfPrintFrame', this should fix IE strange error
        let printFrameId = this.model.options.viewerId + '_PdfPrintFrame';
        let printFrame = document.getElementById(printFrameId);
        if (printFrame) {
            viewer.removeChild(printFrame);
        }
        printFrameId = this.model.options.viewerId + '_HtmlPrintFrame';
        printFrame = document.getElementById(printFrameId);
        if (printFrame) {
            viewer.removeChild(printFrame);
        }
        printFrame = document.createElement('iframe');
        printFrame.id = printFrameId;
        printFrame.name = printFrameId;
        printFrame.width = '0';
        printFrame.height = '0';
        printFrame.style.position = 'absolute';
        printFrame.style.border = 'none';
        viewer.insertBefore(printFrame, viewer.firstChild);
        printFrame.contentWindow.document.open();
        printFrame.contentWindow.document.write(text);
        printFrame.contentWindow.document.close();
        setTimeout(() => {
            printFrame.contentWindow.focus();
            printFrame.contentWindow.print();
        });
    }
}
PrintService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PrintService, deps: [{ token: ModelService }, { token: ExportService }, { token: HelperService }, { token: StiHttpClientService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Injectable });
PrintService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PrintService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PrintService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ExportService }, { type: HelperService }, { type: StiHttpClientService }, { type: ControllerService }]; } });

class DashboardService {
    constructor(controller, model) {
        this.controller = controller;
        this.model = model;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                setTimeout(() => {
                    if (this.model.reportParams.autoZoom) {
                    }
                });
            }
        });
    }
}
DashboardService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DashboardService, deps: [{ token: ControllerService }, { token: ModelService }], target: i0.ɵɵFactoryTarget.Injectable });
DashboardService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DashboardService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DashboardService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ControllerService }, { type: ModelService }]; } });

class TooltipService {
    constructor(model, menuService) {
        this.model = model;
        this.menuService = menuService;
        this.state = 'initial';
        this.caption = '';
        this.helpLink = '';
        this.top = 0;
        this.left = 0;
        this.innerState = 'initial';
    }
    show(left, top, caption, below = true, helpLink) {
        if (this.menuService.isMenuVisible() || !this.model.options.appearance.showTooltips) {
            this.hideImmediately();
            return;
        }
        if (this.caption === caption && this.helpLink === helpLink && this.state !== 'initial') {
            this.showInternal();
            return;
        }
        this.caption = caption;
        this.helpLink = helpLink;
        this.state = this.innerState = this.state !== 'expanded' ? 'preInitial' : 'preInitial2';
        setTimeout(() => {
            const tooltip = this.model.controls.tooltip.el.nativeElement;
            const browserWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
            if (!below) {
                top -= tooltip.offsetHeight;
            }
            if (left + tooltip.offsetWidth > browserWidth) {
                left = browserWidth - tooltip.offsetWidth;
            }
            this.left = left;
            this.top = top;
            if (this.innerState !== 'initial') {
                this.showInternal();
            }
        });
    }
    showInternal() {
        this.state = 'expanded';
        this.innerState = 'expanded';
    }
    showFromTooltip() {
        if (this.state !== 'preInitial') {
            this.state = 'expanded';
            this.innerState = 'expanded';
        }
    }
    hideImmediately() {
        this.innerState = 'initial';
        this.state = 'initial';
    }
    hide() {
        this.innerState = 'initial';
        if (this.timeout) {
            clearTimeout(this.timeout);
        }
        this.timeout = setTimeout(() => {
            if (this.innerState === 'initial') {
                this.state = 'initial';
            }
            this.timeout = null;
        }, 1000);
    }
}
TooltipService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipService, deps: [{ token: ModelService }, { token: MenuService }], target: i0.ɵɵFactoryTarget.Injectable });
TooltipService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: MenuService }]; } });

class Md5Service {
    constructor() {
        this.hexcase = 0;
    }
    hex_md5(a) { return this.rstr2hex(this.rstr_md5(this.str2rstr_utf8(a))); }
    hex_hmac_md5(a, b) { return this.rstr2hex(this.rstr_hmac_md5(this.str2rstr_utf8(a), this.str2rstr_utf8(b))); }
    md5_vm_test() { return this.hex_md5('abc').toLowerCase() == '900150983cd24fb0d6963f7d28e17f72'; }
    rstr_md5(a) { return this.binl2rstr(this.binl_md5(this.rstr2binl(a), a.length * 8)); }
    rstr_hmac_md5(c, f) {
        let e = this.rstr2binl(c);
        if (e.length > 16) {
            e = this.binl_md5(e, c.length * 8);
        }
        let a = Array(16), d = Array(16);
        for (let b = 0; b < 16; b++) {
            a[b] = e[b] ^ 909522486;
            d[b] = e[b] ^ 1549556828;
        }
        let g = this.binl_md5(a.concat(this.rstr2binl(f)), 512 + f.length * 8);
        return this.binl2rstr(this.binl_md5(d.concat(g), 512 + 128));
    }
    rstr2hex(c) {
        try {
            this.hexcase;
        }
        catch (g) {
            this.hexcase = 0;
        }
        let f = this.hexcase ? '0123456789ABCDEF' : '0123456789abcdef';
        let b = '';
        let a;
        for (let d = 0; d < c.length; d++) {
            a = c.charCodeAt(d);
            b += f.charAt((a >>> 4) & 15) + f.charAt(a & 15);
        }
        return b;
    }
    str2rstr_utf8(c) {
        let b = '';
        let d = -1;
        let a, e;
        while (++d < c.length) {
            a = c.charCodeAt(d);
            e = d + 1 < c.length ? c.charCodeAt(d + 1) : 0;
            if (55296 <= a && a <= 56319 && 56320 <= e && e <= 57343) {
                a = 65536 + ((a & 1023) << 10) + (e & 1023);
                d++;
            }
            if (a <= 127) {
                b += String.fromCharCode(a);
            }
            else {
                if (a <= 2047) {
                    b += String.fromCharCode(192 | ((a >>> 6) & 31), 128 | (a & 63));
                }
                else {
                    if (a <= 65535) {
                        b += String.fromCharCode(224 | ((a >>> 12) & 15), 128 | ((a >>> 6) & 63), 128 | (a & 63));
                    }
                    else {
                        if (a <= 2097151) {
                            b += String.fromCharCode(240 | ((a >>> 18) & 7), 128 | ((a >>> 12) & 63), 128 | ((a >>> 6) & 63), 128 | (a & 63));
                        }
                    }
                }
            }
        }
        return b;
    }
    rstr2binl(b) {
        let a = Array(b.length >> 2);
        for (let c = 0; c < a.length; c++) {
            a[c] = 0;
        }
        for (let c = 0; c < b.length * 8; c += 8) {
            a[c >> 5] |= (b.charCodeAt(c / 8) & 255) << (c % 32);
        }
        return a;
    }
    binl2rstr(b) {
        let a = '';
        for (let c = 0; c < b.length * 32; c += 8) {
            a += String.fromCharCode((b[c >> 5] >>> (c % 32)) & 255);
        }
        return a;
    }
    binl_md5(p, k) {
        p[k >> 5] |= 128 << ((k) % 32);
        p[(((k + 64) >>> 9) << 4) + 14] = k;
        let o = 1732584193;
        let n = -271733879;
        let m = -1732584194;
        let l = 271733878;
        for (let g = 0; g < p.length; g += 16) {
            let j = o;
            let h = n;
            let f = m;
            let e = l;
            o = this.md5_ff(o, n, m, l, p[g + 0], 7, -680876936);
            l = this.md5_ff(l, o, n, m, p[g + 1], 12, -389564586);
            m = this.md5_ff(m, l, o, n, p[g + 2], 17, 606105819);
            n = this.md5_ff(n, m, l, o, p[g + 3], 22, -1044525330);
            o = this.md5_ff(o, n, m, l, p[g + 4], 7, -176418897);
            l = this.md5_ff(l, o, n, m, p[g + 5], 12, 1200080426);
            m = this.md5_ff(m, l, o, n, p[g + 6], 17, -1473231341);
            n = this.md5_ff(n, m, l, o, p[g + 7], 22, -45705983);
            o = this.md5_ff(o, n, m, l, p[g + 8], 7, 1770035416);
            l = this.md5_ff(l, o, n, m, p[g + 9], 12, -1958414417);
            m = this.md5_ff(m, l, o, n, p[g + 10], 17, -42063);
            n = this.md5_ff(n, m, l, o, p[g + 11], 22, -1990404162);
            o = this.md5_ff(o, n, m, l, p[g + 12], 7, 1804603682);
            l = this.md5_ff(l, o, n, m, p[g + 13], 12, -40341101);
            m = this.md5_ff(m, l, o, n, p[g + 14], 17, -1502002290);
            n = this.md5_ff(n, m, l, o, p[g + 15], 22, 1236535329);
            o = this.md5_gg(o, n, m, l, p[g + 1], 5, -165796510);
            l = this.md5_gg(l, o, n, m, p[g + 6], 9, -1069501632);
            m = this.md5_gg(m, l, o, n, p[g + 11], 14, 643717713);
            n = this.md5_gg(n, m, l, o, p[g + 0], 20, -373897302);
            o = this.md5_gg(o, n, m, l, p[g + 5], 5, -701558691);
            l = this.md5_gg(l, o, n, m, p[g + 10], 9, 38016083);
            m = this.md5_gg(m, l, o, n, p[g + 15], 14, -660478335);
            n = this.md5_gg(n, m, l, o, p[g + 4], 20, -405537848);
            o = this.md5_gg(o, n, m, l, p[g + 9], 5, 568446438);
            l = this.md5_gg(l, o, n, m, p[g + 14], 9, -1019803690);
            m = this.md5_gg(m, l, o, n, p[g + 3], 14, -187363961);
            n = this.md5_gg(n, m, l, o, p[g + 8], 20, 1163531501);
            o = this.md5_gg(o, n, m, l, p[g + 13], 5, -1444681467);
            l = this.md5_gg(l, o, n, m, p[g + 2], 9, -51403784);
            m = this.md5_gg(m, l, o, n, p[g + 7], 14, 1735328473);
            n = this.md5_gg(n, m, l, o, p[g + 12], 20, -1926607734);
            o = this.md5_hh(o, n, m, l, p[g + 5], 4, -378558);
            l = this.md5_hh(l, o, n, m, p[g + 8], 11, -2022574463);
            m = this.md5_hh(m, l, o, n, p[g + 11], 16, 1839030562);
            n = this.md5_hh(n, m, l, o, p[g + 14], 23, -35309556);
            o = this.md5_hh(o, n, m, l, p[g + 1], 4, -1530992060);
            l = this.md5_hh(l, o, n, m, p[g + 4], 11, 1272893353);
            m = this.md5_hh(m, l, o, n, p[g + 7], 16, -155497632);
            n = this.md5_hh(n, m, l, o, p[g + 10], 23, -1094730640);
            o = this.md5_hh(o, n, m, l, p[g + 13], 4, 681279174);
            l = this.md5_hh(l, o, n, m, p[g + 0], 11, -358537222);
            m = this.md5_hh(m, l, o, n, p[g + 3], 16, -722521979);
            n = this.md5_hh(n, m, l, o, p[g + 6], 23, 76029189);
            o = this.md5_hh(o, n, m, l, p[g + 9], 4, -640364487);
            l = this.md5_hh(l, o, n, m, p[g + 12], 11, -421815835);
            m = this.md5_hh(m, l, o, n, p[g + 15], 16, 530742520);
            n = this.md5_hh(n, m, l, o, p[g + 2], 23, -995338651);
            o = this.md5_ii(o, n, m, l, p[g + 0], 6, -198630844);
            l = this.md5_ii(l, o, n, m, p[g + 7], 10, 1126891415);
            m = this.md5_ii(m, l, o, n, p[g + 14], 15, -1416354905);
            n = this.md5_ii(n, m, l, o, p[g + 5], 21, -57434055);
            o = this.md5_ii(o, n, m, l, p[g + 12], 6, 1700485571);
            l = this.md5_ii(l, o, n, m, p[g + 3], 10, -1894986606);
            m = this.md5_ii(m, l, o, n, p[g + 10], 15, -1051523);
            n = this.md5_ii(n, m, l, o, p[g + 1], 21, -2054922799);
            o = this.md5_ii(o, n, m, l, p[g + 8], 6, 1873313359);
            l = this.md5_ii(l, o, n, m, p[g + 15], 10, -30611744);
            m = this.md5_ii(m, l, o, n, p[g + 6], 15, -1560198380);
            n = this.md5_ii(n, m, l, o, p[g + 13], 21, 1309151649);
            o = this.md5_ii(o, n, m, l, p[g + 4], 6, -145523070);
            l = this.md5_ii(l, o, n, m, p[g + 11], 10, -1120210379);
            m = this.md5_ii(m, l, o, n, p[g + 2], 15, 718787259);
            n = this.md5_ii(n, m, l, o, p[g + 9], 21, -343485551);
            o = this.safe_add(o, j);
            n = this.safe_add(n, h);
            m = this.safe_add(m, f);
            l = this.safe_add(l, e);
        }
        return Array(o, n, m, l);
    }
    md5_cmn(h, e, d, c, g, f) { return this.safe_add(this.bit_rol(this.safe_add(this.safe_add(e, h), this.safe_add(c, f)), g), d); }
    md5_ff(g, f, k, j, e, i, h) { return this.md5_cmn((f & k) | ((~f) & j), g, f, e, i, h); }
    md5_gg(g, f, k, j, e, i, h) { return this.md5_cmn((f & j) | (k & (~j)), g, f, e, i, h); }
    md5_hh(g, f, k, j, e, i, h) { return this.md5_cmn(f ^ k ^ j, g, f, e, i, h); }
    md5_ii(g, f, k, j, e, i, h) { return this.md5_cmn(k ^ (f | (~j)), g, f, e, i, h); }
    safe_add(a, d) { let c = (a & 65535) + (d & 65535); let b = (a >> 16) + (d >> 16) + (c >> 16); return (b << 16) | (c & 65535); }
    bit_rol(a, b) { return (a << b) | (a >>> (32 - b)); }
    ;
}
Md5Service.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: Md5Service, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
Md5Service.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: Md5Service });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: Md5Service, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class DrillDownService {
    constructor(controller, model, helper) {
        this.controller = controller;
        this.model = model;
        this.helper = helper;
        controller.getMessage().subscribe((message) => {
            if (message.action !== 'InitVars' && message.action !== 'viewer_loaded') {
                this.model.options.drillDownInProgress = false;
                const parameters = message.data;
                if (this.model.drillDownButtons.length === 0) {
                    this.addButton(parameters.reportFileName, {});
                }
                if (message.action === 'DrillDown') {
                    const useDbsDrillDownPanel = false; // jsObject.controls.dashboardsPanel && jsObject.controls.dashboardsPanel.visible && jsObject.controls.dashboardsPanel.selectedButton;
                    if (useDbsDrillDownPanel) {
                        // jsObject.controls.dashboardsPanel.addDrillDownButton(null, parameters.drillDownGuid, parameters.drillDownParameters, parameters.previewSettings, parameters.reportFileName);
                    }
                    this.showDrillDownPage(parameters.reportFileName, parameters.drillDownGuid, parameters.drillDownParameters, useDbsDrillDownPanel);
                }
            }
        });
    }
    showDrillDownPage(reportFileName, drillDownGuid, drillDownParameters, useDbsDrillDownPanel) {
        if (useDbsDrillDownPanel) {
            return;
        }
        let buttonExist = false;
        this.model.drillDownButtons.forEach((b) => {
            if (b.reportParams.drillDownGuid === drillDownGuid) {
                this.model.drillDownButtons.forEach(bt => bt.selected = false);
                buttonExist = b.selected = b.visible = true;
                this.model.reportParams.drillDownParameters = b.reportParams.drillDownParameters;
            }
        });
        if (!buttonExist) {
            this.addButton(reportFileName);
            this.model.reportParams.drillDownParameters = drillDownParameters;
            this.model.reportParams.pageNumber = 0;
            this.model.reportParams.pagesWidth = 0;
            this.model.reportParams.pagesHeight = 0;
        }
    }
    addButton(caption, reportParams = {}) {
        this.model.drillDownButtons.forEach(b => b.selected = false);
        this.model.drillDownButtons.push({ caption, selected: true, reportParams, visible: true });
        this.updateVisibility();
    }
    updateVisibility() {
        this.model.controls.drillDownPanel.visible = this.model.drillDownButtons.length > 1;
    }
    saveState() {
        const sButton = this.model.drillDownButtons.find(b => b.selected);
        if (sButton) {
            sButton.reportParams = this.model.getReportParams();
        }
    }
}
DrillDownService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownService, deps: [{ token: ControllerService }, { token: ModelService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Injectable });
DrillDownService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ControllerService }, { type: ModelService }, { type: HelperService }]; } });

class InteractionsService {
    constructor(model, md5, controller, helper, drillDownService) {
        this.model = model;
        this.md5 = md5;
        this.controller = controller;
        this.helper = helper;
        this.drillDownService = drillDownService;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'InitVars') {
                this.showParametersPanel(message.data);
            }
        });
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Variables':
                    this.postInteraction({ action: 'Variables', variables: this.getParametersValues() });
                    break;
                case 'Reset':
                    this.showParametersPanel(this.model.options.paramsVariables);
                    break;
                default:
                    break;
            }
        });
    }
    postInteraction(params) {
        this.drillDownService.saveState();
        // Add new drill-down parameters to drill-down queue and calc guid
        if (params.action !== 'InitVars' && (params.action === 'DrillDown' || params.action === 'DashboardDrillDown')) {
            if (this.model.options.drillDownInProgress) {
                return;
            }
            if (params.action === 'DashboardDrillDown' && params.drillDownParameters) {
                params.drillDownParameters.isDashboardDrillDown = true; // add dbs flag
            }
            const drillDownParameters = this.model.reportParams.drillDownParameters || [];
            params.drillDownParameters = params.drillDownParameters ? drillDownParameters.concat(params.drillDownParameters) : drillDownParameters;
            if (params.action === 'DrillDown') {
                params.drillDownGuid = this.md5.hex_md5(JSON.stringify(this.sortPropsInDrillDownParameters(params.drillDownParameters)));
            }
            else {
                params.dashboardDrillDownGuid = this.md5.hex_md5(JSON.stringify(this.sortPropsInDrillDownParameters(params.drillDownParameters)));
            }
            this.model.options.drillDownInProgress = true;
        }
        this.controller.post(params.action, this.model.options.actions.interaction, params);
    }
    showParametersPanel(data) {
        if (!data) {
            return;
        }
        if (this.controller.showError(data)) {
            data = null;
        }
        this.model.options.isParametersReceived = true;
        this.model.options.paramsVariables = typeof data === 'string' ? JSON.parse(data) : data;
        this.model.controls.parametersPanel.visible = !this.model.options.isMobileDevice;
        // if (this.model.reportParams.type === 'Dashboard') jsObject.postAction('GetPages');
        const paramsVariables = this.helper.copyObject(this.model.options.paramsVariables);
        const countParameters = this.helper.getCountObjects(paramsVariables);
        const countColumns = (countParameters <= this.model.options.minParametersCountForMultiColumns)
            ? 1 : this.model.options.appearance.parametersPanelColumnsCount;
        let countInColumn = Math.trunc(countParameters / countColumns);
        if (countInColumn * countColumns < countParameters) {
            countInColumn++;
        }
        // setup lists
        for (let i = 0; i < countParameters; i++) {
            const variable = paramsVariables[i];
            if (variable.items) {
                variable.items.forEach((v, index) => {
                    let isChecked = true;
                    if (variable.value instanceof Array && !variable.allowUserValues &&
                        variable.value.indexOf(variable.items[index].value) < 0 && variable.value.indexOf(variable.items[index].key) < 0)
                        isChecked = false;
                    if (variable.isFirstInitialization && variable.checkedStates && index < variable.checkedStates.length) {
                        isChecked = variable.checkedStates[index];
                    }
                    v.isChecked = isChecked;
                    v.visible = true;
                });
            }
            variable.isNull = (variable.type === 'DateTime' && variable.value === null && variable.basicType === 'NullableValue');
        }
        this.model.interactions = { paramsVariables, countColumns: new Array(countColumns), countInColumn: new Array(countInColumn) };
    }
    sortPropsInDrillDownParameters(inArray) {
        if (!inArray || !inArray.length) {
            return inArray;
        }
        const outArray = [];
        for (let i = 0; i < inArray.length; i++) {
            const propNames = [];
            const el = inArray[i];
            const copyEl = {};
            Object.keys(el).forEach(p => {
                if (el.hasOwnProperty(p)) {
                    propNames.push(p);
                }
            });
            propNames.sort();
            propNames.forEach(propName => copyEl[propName] = el[propName]);
            outArray[i] = copyEl;
        }
        return outArray;
    }
    getParametersValues() {
        const parametersValues = {};
        Object.keys(this.model.interactions.paramsVariables).forEach(i => {
            const parameter = this.model.interactions.paramsVariables[i];
            parametersValues[parameter.name] = this.getVariableValue(parameter);
        });
        return parametersValues;
    }
    getVariableValue(parameter) {
        if (parameter.isNull) {
            return null;
        }
        switch (parameter.basicType) {
            case 'Value':
            case 'NullableValue':
                return this.val(parameter.key, parameter, parameter.allowUserValues ? parameter.value : parameter.key);
            case 'Range':
                return { from: this.val(parameter.key, parameter), to: this.val(parameter.keyTo, parameter) };
            case 'List':
                const value = [];
                if (parameter.items) {
                    parameter.items.filter(i => parameter.allowUserValues || i.isChecked).forEach(item => value.push(this.val(item.key, parameter)));
                }
                return value;
        }
    }
    val(key, parameter, value) {
        return parameter.type === 'DateTime' ? this.helper.getStringDateTime(key, parameter.dateTimeType) : (value === undefined ? key : value);
    }
    initializeInteractions(page) {
        if (!page) {
            return;
        }
        const elems = page.querySelectorAll ? page.querySelectorAll('td,div,span,rect,path,ellipse') : page.getElementsByTagName('td');
        const collapsedHash = [];
        for (const elem of elems) {
            if (elem.getAttribute('interaction') && (elem.getAttribute('pageguid') ||
                elem.getAttribute('reportfile') ||
                elem.getAttribute('collapsed') ||
                elem.getAttribute('databandsort'))) {
                elem.style.cursor = 'pointer';
                const sort = elem.getAttribute('sort');
                if (sort) {
                    this.paintSortingArrow(elem, sort);
                }
                const collapsed = elem.getAttribute('collapsed');
                if (collapsed) {
                    const compId = elem.getAttribute('compindex') + '|' + elem.getAttribute('interaction');
                    if (collapsedHash.indexOf(compId) < 0) {
                        this.paintCollapsingIcon(elem, collapsed === 'true');
                        collapsedHash.push(compId);
                    }
                }
                elem.onclick = (e) => {
                    if (elem.getAttribute('pageguid') || elem.getAttribute('reportfile')) {
                        this.postInteractionDrillDown(elem);
                    }
                    else if (elem.getAttribute('collapsed')) {
                        this.postInteractionCollapsing(elem);
                    }
                    else {
                        this.postInteractionSorting(elem, e.ctrlKey);
                    }
                };
                if (elem.getAttribute('pageguid') || elem.getAttribute('reportfile')) {
                    elem.onmouseover = () => elem.style.opacity = 0.75;
                    elem.onmouseout = () => elem.style.opacity = 1;
                }
            }
        }
    }
    getComponentOffset(component) {
        let offsetX = 0;
        let offsetY = 0;
        const startComponent = component;
        while (component && !isNaN(component.offsetLeft) && !isNaN(component.offsetTop)
            && (component === startComponent || component.style.position === '' || component.style.position === 'static')) {
            offsetX += component.offsetLeft - component.scrollLeft;
            offsetY += component.offsetTop - component.scrollTop;
            component = component.offsetParent;
        }
        return { top: offsetY, left: offsetX };
    }
    paintSortingArrow(component, sort) {
        if (component.arrowImg) {
            return;
        }
        const arrowImg = document.createElement("div");
        let sortUpSrc = "<svg xmlns='http://www.w3.org/2000/svg' width='12' height='12'><path d='M1 9l5-4 5 4z' fill='#eeeeee' stroke='#666'/></svg>";
        let sortDownSrc = "<svg xmlns='http://www.w3.org/2000/svg' width='12' height='12'><path d='M1 5l5 4 5-4z' fill='#eeeeee' stroke='#666'/></svg>";
        arrowImg.innerHTML = sort == "asc" ? sortDownSrc : sortUpSrc;
        const arrowWidth = (this.model.reportParams.zoom / 100) * 16;
        const arrowHeight = (this.model.reportParams.zoom / 100) * 16;
        arrowImg.style.position = 'absolute';
        arrowImg.style.width = arrowWidth + 'px';
        arrowImg.style.height = arrowHeight + 'px';
        component.appendChild(arrowImg);
        component.arrowImg = arrowImg;
        const oldPosition = component.style.position;
        const oldClassName = component.className;
        let reportDisplayMode = this.model.options.displayModeFromReport || this.model.options.appearance.reportDisplayMode;
        if (reportDisplayMode == "Table")
            component.style.position = "relative";
        if (!oldClassName) {
            component.className = 'stiSortingParentElement';
        }
        const arrowLeftPos = this.helper.findPosX(arrowImg, component.className);
        const arrowTopPos = this.helper.findPosY(arrowImg, component.className);
        arrowImg.style.marginLeft = (component.offsetWidth - arrowLeftPos - arrowWidth - ((this.model.reportParams.zoom / 100) * 3)) + 'px';
        arrowImg.style.marginTop = (component.offsetHeight / 2 - arrowHeight / 2 - arrowTopPos) + 'px';
        if (oldPosition && reportDisplayMode == "Table")
            component.style.position = oldPosition;
        component.className = oldClassName;
    }
    paintCollapsingIcon(component, collapsed) {
        if (component.collapsImg) {
            return;
        }
        const collapsImg = document.createElement('img');
        collapsImg.src = collapsed ? this.model.img('CollapsingPlus.png') : this.model.img('CollapsingMinus.png');
        collapsImg.style.position = 'absolute';
        const collapsWidth = (this.model.reportParams.zoom / 100) * 10;
        const collapsHeight = (this.model.reportParams.zoom / 100) * 10;
        collapsImg.style.width = collapsWidth + 'px';
        collapsImg.style.height = collapsHeight + 'px';
        component.appendChild(collapsImg);
        component.collapsImg = collapsImg;
        const componentOffset = this.getComponentOffset(component);
        const collapsOffset = this.getComponentOffset(collapsImg);
        collapsImg.style.marginLeft = (componentOffset.left - collapsOffset.left + collapsWidth / 3) + 'px';
        collapsImg.style.marginTop = (componentOffset.top - collapsOffset.top + collapsWidth / 3) + 'px';
    }
    postInteractionSorting(component, isCtrl) {
        const params = {
            action: 'Sorting',
            sortingParameters: {
                ComponentName: component.getAttribute('interaction') + ';' + isCtrl.toString(),
                DataBand: component.getAttribute('databandsort')
            }
        };
        if (this.model.options.isParametersReceived) {
            params.variables = this.getParametersValues();
        }
        this.postInteraction(params);
    }
    postInteractionDrillDown(component) {
        const params = {
            action: 'DrillDown',
            drillDownParameters: {
                ComponentIndex: component.getAttribute('compindex'),
                ElementIndex: component.getAttribute('elementindex'),
                PageIndex: component.getAttribute('pageindex'),
                PageGuid: component.getAttribute('pageguid'),
                ReportFile: component.getAttribute('reportfile')
            }
        };
        this.postInteraction(params);
    }
    postInteractionCollapsing(component) {
        const componentName = component.getAttribute('interaction');
        const collapsingIndex = component.getAttribute('compindex');
        const collapsed = component.getAttribute('collapsed') === 'true' ? false : true;
        if (!this.model.reportParams.collapsingStates) {
            this.model.reportParams.collapsingStates = {};
        }
        if (!this.model.reportParams.collapsingStates[componentName]) {
            this.model.reportParams.collapsingStates[componentName] = {};
        }
        this.model.reportParams.collapsingStates[componentName][collapsingIndex] = collapsed;
        const params = {
            action: 'Collapsing',
            collapsingParameters: {
                ComponentName: componentName,
                CollapsingStates: this.model.reportParams.collapsingStates
            }
        };
        if (this.model.options.isParametersReceived) {
            params.variables = this.getParametersValues();
        }
        this.postInteraction(params);
    }
    updateAllHyperLinks() {
        let pointers = this.model.reportParams.tableOfContentsPointers;
        //var bookmarksPanel = this.controls.bookmarksPanel;
        if (this.model.reportParams.bookmarksContent != null || (pointers && pointers.length > 0)) {
            this.model.pages.forEach(p => {
                const page = p.page;
                if (page) {
                    const aHyperlinks = page.getElementsByTagName('a');
                    for (const aHyperlink of aHyperlinks) {
                        aHyperlink.hrefContent = aHyperlink.getAttribute('href');
                        if (aHyperlink.hrefContent) {
                            if (aHyperlink.hrefContent.indexOf("#") == 0) {
                                let anchorParams = aHyperlink.hrefContent.substring(1).split("#GUID#");
                                aHyperlink.anchorName = anchorParams[0];
                                aHyperlink.componentGuid = anchorParams.length > 1 ? anchorParams[1] : "";
                                aHyperlink.onclick = () => {
                                    let currAnchorName = aHyperlink.anchorName;
                                    let cuurCompGuid = aHyperlink.componentGuid;
                                    try {
                                        currAnchorName = decodeURI(aHyperlink.anchorName);
                                    }
                                    catch (e) {
                                        currAnchorName = aHyperlink.anchorName;
                                    }
                                    if (pointers.length > 0) {
                                        let pageIndex = 1;
                                        for (let i = 0; i < pointers.length; i++) {
                                            if (cuurCompGuid) {
                                                if (pointers[i].componentGuid == cuurCompGuid) {
                                                    pageIndex = pointers[i].pageIndex;
                                                    break;
                                                }
                                            }
                                            else if (currAnchorName) {
                                                let pointerAnchor = pointers[i].anchor.indexOf("#") == 0 ? pointers[i].anchor.substring(1) : pointers[i].anchor;
                                                if (pointerAnchor == currAnchorName) {
                                                    pageIndex = pointers[i].pageIndex;
                                                    break;
                                                }
                                            }
                                        }
                                        let anchorName = "";
                                        if (currAnchorName)
                                            anchorName += currAnchorName;
                                        if (cuurCompGuid)
                                            anchorName += ("#GUID#" + cuurCompGuid);
                                        if (anchorName) {
                                            this.controller.action({ name: 'BookmarkAction', bookmarkPage: Math.max(pageIndex - 1, 0), bookmarkAnchor: anchorName, componentGuid: aHyperlink.compunentGuid });
                                            return false;
                                        }
                                    }
                                    if (this.model.reportParams.bookmarksContent != null) {
                                        const node = this.model.nodes.find(n => n.name === currAnchorName);
                                        if (node) {
                                            this.model.navigateNode = node;
                                        }
                                        else {
                                            for (let k = 0; k < document.anchors.length; k++) {
                                                if (document.anchors[k].name == currAnchorName) {
                                                    //jsObject.scrollToAnchor(currAnchorName);
                                                    this.helper.scrollToAnchor(currAnchorName);
                                                    return;
                                                }
                                            }
                                        }
                                        this.controller.post('BookmarkAction', null, 0);
                                        /*let aBookmarks = bookmarksPanel.getElementsByTagName("a");
                                        for (let k = 0; k < aBookmarks.length; k++) {
                                          let clickFunc = aBookmarks[k].getAttribute("onclick");
                                          if (clickFunc && clickFunc.indexOf("'" + currAnchorName + "'") >= 0) {
                                            try {
                                              eval(clickFunc);
                                              return false;
                                            }
                                            catch (e) { }
                                          }
                                        }
                    
                                        this.controller.post('BookmarkAction', null, 0);*/
                                        return false;
                                    }
                                    //=================================
                                    /*let pageIndex = 1;
                                    for (let i = 0; i < pointers.length; i++) {
                                      if (aHyperlink.componentGuid) {
                                        if (pointers[i].componentGuid == aHyperlink.componentGuid) {
                                          pageIndex = pointers[i].pageIndex;
                                          break;
                                        }
                                      }
                                      else if (aHyperlink.bookmarkAnchor) {
                                        if (pointers[i].anchor == decodeURI(aHyperlink.bookmarkAnchor)) {
                                          pageIndex = pointers[i].pageIndex;
                                          break;
                                        }
                                      }
                                    }
                                    this.controller.action({ name: 'BookmarkAction', bookmarkPage: pageIndex - 1, bookmarkAnchor: decodeURI(aHyperlink.bookmarkAnchor), componentGuid: aHyperlink.compunentGuid });
                                    return false;
                                    };
                                    } else if (this.model.reportParams.bookmarksContent != null) {
                                    aHyperlink.anchorName = aHyperlink.hrefContent.replace('#', '');
                  
                                    aHyperlink.onclick = () => {
                                    const node = this.model.nodes.find(n => n.url.replace(/\\\'/g, '\'').substr(1) === aHyperlink.anchorName);
                                    if (node) {
                                      this.model.navigateNode = node;
                                    } else if (aHyperlink.hrefContent.indexOf('#') === 0) {
                                      for (let i = 0; i < document.anchors.length; i++) {
                                        const anchor = document.anchors[i];
                                        if (anchor.name === aHyperlink.anchorName) {
                                          this.helper.scrollToAnchor(aHyperlink.anchorName);
                                          return;
                                        }
                                      }
                                      this.controller.post('BookmarkAction', null, 0);
                                    }
                                    return false;
                                    };*/
                                };
                            }
                        }
                    }
                }
            });
        }
    }
}
InteractionsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsService, deps: [{ token: ModelService }, { token: Md5Service }, { token: ControllerService }, { token: HelperService }, { token: DrillDownService }], target: i0.ɵɵFactoryTarget.Injectable });
InteractionsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: Md5Service }, { type: ControllerService }, { type: HelperService }, { type: DrillDownService }]; } });

class RadioButtonService {
    constructor() {
        this.groups = {};
    }
    addButton(button) {
        if (!this.groups[button.groupName]) {
            this.groups[button.groupName] = [];
        }
        this.groups[button.groupName].push(button);
    }
    removeButton(button) {
        const buttons = this.groups[button.groupName];
        buttons === null || buttons === void 0 ? void 0 : buttons.splice(buttons.indexOf(button), 1);
    }
    check(button) {
        const buttons = this.groups[button.groupName];
        buttons === null || buttons === void 0 ? void 0 : buttons.filter(b => b.name !== button.name).forEach(b => b.uncheck());
    }
}
RadioButtonService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: RadioButtonService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
RadioButtonService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: RadioButtonService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: RadioButtonService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class EditableFieldsService {
    constructor(controller, model, helper) {
        this.controller = controller;
        this.model = model;
        this.helper = helper;
        this.visible = false;
        this.editableFields = [];
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Editor':
                    this.visible = !this.visible;
                    if (this.visible) {
                        this.showAllEditableFields();
                    }
                    else {
                        this.hideAllEditableFields();
                    }
                    break;
            }
        });
        controller.getMessage().subscribe((message) => {
            if (message.action === 'GetPages' && this.visible) {
                setTimeout(() => this.showAllEditableFields());
            }
            else {
                this.visible = false;
            }
        });
    }
    showAllEditableFields() {
        this.editableFields = [];
        this.model.pages.forEach((page, pageIndex) => {
            const pageElements = page.page.getElementsByTagName('*');
            for (const pageElement of pageElements) {
                const editableStrAttr = pageElement.getAttribute('editable');
                if (editableStrAttr) {
                    const attrArray = editableStrAttr.split(';');
                    const params = {};
                    params.compIndex = attrArray[0];
                    params.pageIndex = this.model.reportParams.viewMode === 'SinglePage' ? this.model.reportParams.pageNumber : pageIndex.toString();
                    params.type = attrArray[1];
                    if (params.type === 'CheckBox') {
                        this.showCheckBoxEditableField(pageElement, params, attrArray);
                    }
                    else if (params.type === 'Text') {
                        this.showTextEditableField(pageElement, params);
                    }
                    else if (params.type === 'RichText') {
                        this.showRichTextEditableField(pageElement, params);
                    }
                }
            }
        });
    }
    hideAllEditableFields() {
        if (this.currentEditableTextArea) {
            this.currentEditableTextArea.onblur();
        }
        this.editableFields.forEach((eField) => {
            eField.className = eField.className.replace(' stiEditableField stiEditableFieldSelected', '');
            eField.onclick = null;
            eField.style.outline = '';
        });
    }
    showCheckBoxEditableField(editableCell, params, attrArray) {
        if (!editableCell.sizes) {
            let imgElements = editableCell.getElementsByTagName('IMG');
            if (imgElements.length === 0) {
                imgElements = editableCell.getElementsByTagName('SVG');
            }
            if (imgElements.length === 0) {
                imgElements = editableCell.getElementsByTagName('svg');
            }
            const imgElement = (imgElements.length > 0) ? imgElements[0] : null;
            if (!imgElement) {
                return;
            }
            if (imgElement.offsetWidth) {
                editableCell.sizes = {
                    inPixels: imgElement.offsetWidth > imgElement.offsetHeight ? imgElement.offsetHeight : imgElement.offsetWidth,
                    widthStyle: imgElement.style.width,
                    heightStyle: imgElement.style.height
                };
            }
            else {
                editableCell.sizes = {
                    inPixels: imgElement.clientWidth > imgElement.clientHeight ? imgElement.clientHeight : imgElement.clientWidth,
                    widthStyle: imgElement.clientWidth + 'px',
                    heightStyle: imgElement.clientHeight + 'px'
                };
            }
        }
        if (this.helper.getNavigatorName() !== 'Google Chrome') {
            editableCell.style.outline = '1px solid gray';
        }
        editableCell.style.textAlign = 'center';
        editableCell.className += ' stiEditableField stiEditableFieldSelected';
        const trueSvgImage = this.getSvgCheckBox(attrArray[3], attrArray[5], this.helper.strToInt(attrArray[6]), attrArray[7], editableCell.sizes.inPixels);
        const falseSvgImage = this.getSvgCheckBox(attrArray[4], attrArray[5], this.helper.strToInt(attrArray[6]), attrArray[7], editableCell.sizes.inPixels);
        params.falseImage = `<div style="width: ${editableCell.sizes.widthStyle}; height: ${editableCell.sizes.heightStyle}; "> ${trueSvgImage}  </div>`;
        params.trueImage = `<div style="width: ${editableCell.sizes.widthStyle}; height: ${editableCell.sizes.heightStyle}; "> ${falseSvgImage} </div>`;
        params.checked = attrArray[2] === 'true' || attrArray[2] === 'True';
        editableCell.params = params;
        if (!editableCell.hasChanged) {
            editableCell.checked = params.checked;
            editableCell.innerHTML = params.checked ? params.trueImage : params.falseImage;
        }
        editableCell.onclick = () => {
            editableCell.checked = !editableCell.checked;
            editableCell.innerHTML = editableCell.checked ? params.trueImage : params.falseImage;
            editableCell.hasChanged = true;
            this.addEditableParameters(editableCell);
        };
        this.editableFields.push(editableCell);
    }
    showTextEditableField(editableCell, params) {
        editableCell.className += ' stiEditableField stiEditableFieldSelected';
        if (this.helper.getNavigatorName() !== 'Google Chrome') {
            editableCell.style.outline = '1px solid gray';
        }
        editableCell.params = params;
        editableCell.jsObject = this;
        editableCell.onclick = () => {
            if (editableCell.editMode) {
                return;
            }
            if (this.currentEditableTextArea) {
                this.currentEditableTextArea.onblur();
            }
            editableCell.editMode = true;
            const textArea = document.createElement('textarea');
            textArea.style.width = (editableCell.offsetWidth - 5) + 'px';
            textArea.style.height = (editableCell.offsetHeight - 5) + 'px';
            textArea.style.maxWidth = (editableCell.offsetWidth - 5) + 'px';
            textArea.style.maxHeight = (editableCell.offsetHeight - 5) + 'px';
            textArea.className = editableCell.className.replace(' stiEditableField stiEditableFieldSelected', '') + ' stiEditableTextArea';
            textArea.style.border = '0px';
            let textContainer = editableCell;
            var includedInnerDiv = function (el) {
                return (el.firstChild && el.firstChild.nodeName && el.firstChild.nodeName.toLowerCase() == "div");
            };
            while (includedInnerDiv(textContainer)) {
                textContainer = textContainer.childNodes[0];
            }
            textArea.value = textContainer.innerHTML.replace(/<br>/g, '\n');
            editableCell.appendChild(textArea);
            textArea.focus();
            this.currentEditableTextArea = textArea;
            textArea.onblur = () => {
                editableCell.editMode = false;
                const newText = textArea.value;
                textContainer.innerHTML = newText.replace(/\n/g, '<br>');
                if (this && textArea.parentNode) {
                    textArea.parentNode.removeChild(textArea);
                }
                this.currentEditableTextArea = null;
                this.addEditableParameters(editableCell, newText);
            };
            let this_ = this;
            let textArea_ = textArea;
            textArea_.getPrevTextField = (index) => {
                if (index > 0) {
                    for (var i = index - 1; i >= 0; i--) {
                        var field = this_.editableFields[i];
                        if (field.params.type == "Text") {
                            return field;
                        }
                    }
                }
                return null;
            };
            textArea_.getNextTextField = (index) => {
                if (index < this_.editableFields.length - 1) {
                    for (var i = index + 1; i < this_.editableFields.length; i++) {
                        var field = this_.editableFields[i];
                        if (field.params.type == "Text") {
                            return field;
                        }
                    }
                }
                return null;
            };
            textArea_.onkeydown = function (e) {
                if (e && e.keyCode == 9) {
                    if (this_.editableFields) {
                        var index = this_.editableFields.indexOf(editableCell);
                        var field = /*this_.SHIFT_pressed ? textArea_.getPrevTextField(index) : */ textArea_.getNextTextField(index);
                        if (field) {
                            e.preventDefault();
                            field.onclick();
                        }
                    }
                }
            };
        };
        this.editableFields.push(editableCell);
    }
    showRichTextEditableField(editableCell, params) {
    }
    addEditableParameters(editableCell, newText) {
        if (!this.model.reportParams.editableParameters) {
            this.model.reportParams.editableParameters = {};
        }
        const params = {};
        params.type = editableCell.params.type;
        if (params.type === 'CheckBox') {
            params.checked = editableCell.checked;
        }
        if (params.type === 'Text') {
            params.text = newText != null ? newText : editableCell.innerHTML;
        }
        if (!this.model.reportParams.editableParameters[editableCell.params.pageIndex]) {
            this.model.reportParams.editableParameters[editableCell.params.pageIndex] = {};
        }
        this.model.reportParams.editableParameters[editableCell.params.pageIndex][editableCell.params.compIndex] = params;
    }
    getSvgCheckBox(style, contourColor, size, backColor, width) {
        const head = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" width="${width}px" height="${width}px">`;
        const path = `<path stroke="${contourColor}" stroke-width="${size}" fill="${backColor}" stroke-linecap="round" stroke-linejoin="round" transform="scale(${(1 / (200 / width))})" d="`;
        let shape = '';
        switch (style) {
            case 'Cross':
                shape = 'm 62.567796,147.97593 c -0.55,-0.14223 -2.162828,-0.5128 -3.584062,-0.82348 -3.647667,-0.79738 -9.670499,-5.83775 -14.242817,-11.91949 l ' +
                    '-3.902341,-5.19058 5.080199,-1.13481 c 7.353071,-1.64253 13.640456,-5.71752 21.826811,-14.14646 l 7.208128,-7.42171 ' +
                    '-6.410736,-7.513354 c -11.773129,-13.79803 -14.346726,-23.01954 -8.627769,-30.91434 2.894109,-3.9952 11.818482,-12.369333 ' +
                    '13.182086,-12.369333 0.411356,0 1.063049,1.6875 1.448207,3.750003 0.980474,5.25038 6.456187,16.76587 10.936694,23 2.075266,2.8875 ' +
                    '3.991125,5.25 4.257464,5.25 0.266339,0 3.775242,-3.4875 7.797566,-7.75 16.397034,-17.37615 29.674184,-19.76481 38.280564,-6.88699 ' +
                    '4.15523,6.21753 4.18631,8.07093 0.14012,8.3552 -5.84833,0.41088 -17.16241,8.5342 -25.51465,18.319104 l -4.63153,5.42599 ' +
                    '4.87803,4.31529 c 6.55108,5.79533 18.8991,11.89272 25.84076,12.76002 3.0455,0.38051 5.53727,1.10582 5.53727,1.6118 0,2.7809 ' +
                    '-9.26611,14.41872 -13.03,16.36511 -7.96116,4.11687 -16.36991,0.71207 -32.764584,-13.26677 l -4.985957,-4.25125 -7.086791,8.97188 c ' +
                    '-3.897736,4.93454 -8.82141,10.1198 -10.9415,11.52281 -3.906121,2.58495 -8.86588,4.41339 -10.691162,3.94136 z';
                break;
            case 'Check':
                shape = 'M 60.972125,162.49704 C 51.172676,136.72254 43.561975,123.37669 35.370344,117.6027 l -4.45827,-3.14248 2.75159,-2.89559 c 3.875121,-4.07793 ' +
                    '10.034743,-7.49924 14.902472,-8.27747 3.859874,-0.61709 4.458306,-0.38024 8.535897,3.37835 2.660692,2.45254 6.265525,7.60856 9.167226,13.11196 ' +
                    '2.630218,4.98849 4.910542,9.06999 5.067388,9.06999 0.156846,0 2.31372,-3.0375 4.793052,-6.75 C 96.259164,91.956015 129.68299,58.786374 157.56485,41.281603 l ' +
                    '8.84913,-5.555656 2.2633,2.631238 2.26329,2.631237 -7.76266,6.294183 C 139.859,66.19023 108.01682,105.51363 89.042715,138.83563 c -6.680477,11.73214 ' +
                    '-7.172359,12.31296 -15.090788,17.81963 -4.501873,3.13071 -9.044031,6.30443 -10.093684,7.05271 -1.708923,1.21826 -2.010678,1.09165 -2.886118,-1.21093 z';
                break;
            case 'CrossRectangle':
                shape = 'm 24.152542,102.04237 0,-72.499996 74.5,0 74.499998,0 0,72.499996 0,72.5 -74.499998,0 -74.5,0 0,-72.5 z m 133.758188,0.25 -0.25819,-57.249996 ' +
                    '-58.999998,0 -59,0 -0.259695,55.999996 c -0.142833,30.8 -0.04446,56.5625 0.218615,57.25 0.375181,0.98048 13.207991,1.25 59.517885,1.25 l ' +
                    '59.039573,0 -0.25819,-57.25 z m -90.574091,43.18692 c -1.823747,-0.3912 -4.926397,-1.85716 -6.894778,-3.25768 -3.319254,-2.36169 -12.289319,-12.40741 ' +
                    '-12.289319,-13.76302 0,-0.32888 2.417494,-1.13897 5.372209,-1.80021 7.185193,-1.60797 13.747505,-5.93496 21.803114,-14.3763 l 6.675323,-6.99496 ' +
                    '-6.379078,-7.31436 C 64.931387,85.71231 61.643682,76.29465 65.471903,68.89169 67.054097,65.83207 78.56175,54.542374 80.098251,54.542374 c 0.45744,0 ' +
                    '1.146839,1.6875 1.531997,3.75 0.980474,5.250386 6.456187,16.765876 10.936694,22.999996 2.075266,2.8875 3.991125,5.25 4.257464,5.25 0.266339,0 ' +
                    '3.775244,-3.4875 7.797564,-7.75 16.39704,-17.376139 29.67419,-19.764806 38.28057,-6.88698 4.15523,6.21752 4.18631,8.07092 0.14012,8.35519 -5.82996,0.40959 ' +
                    '-18.23707,9.34942 -25.91566,18.67328 -3.90068,4.73647 -3.97203,4.95414 -2.2514,6.86861 3.19054,3.54997 13.7039,10.54321 18.97191,12.61967 2.83427,1.11716 ' +
                    '7.43737,2.33421 10.22912,2.70455 2.79175,0.37034 5.07591,0.9956 5.07591,1.38947 0,2.11419 -8.37504,13.20895 -11.6517,15.4355 -8.39423,5.70403 ' +
                    '-16.63203,2.77 -34.14289,-12.16054 l -4.985955,-4.25125 -7.086791,8.97188 c -9.722344,12.3085 -16.524852,16.55998 -23.948565,14.96754 z';
                break;
            case 'CheckRectangle':
                shape = 'm 19.915254,103.5 0,-72.5 71.942245,0 71.942241,0 6.55727,-4.11139 6.55726,-4.11139 1.96722,2.36139 c 1.08197,1.298765 1.98219,2.644166 2.00049,2.98978 ' +
                    '0.0183,0.345615 -2.44173,2.53784 -5.46673,4.87161 l -5.5,4.243219 0,69.378391 0,69.37839 -74.999991,0 -75.000005,0 0,-72.5 z m 133.999996,3.87756 c ' +
                    '0,-49.33933 -0.12953,-53.514947 -1.62169,-52.276568 -2.78014,2.307312 -15.68408,17.90053 -24.32871,29.399008 -10.4919,13.955575 -23.47926,33.53736 ' +
                    '-29.514025,44.5 -4.457326,8.09707 -5.134776,8.80812 -14.291256,15 -5.28667,3.575 -9.903486,6.62471 -10.259592,6.77712 -0.356107,0.15242 -1.912439,-2.99758 ' +
                    '-3.458515,-7 -1.546077,-4.00241 -5.258394,-12.41205 -8.249593,-18.68809 -4.285436,-8.99155 -6.676569,-12.64898 -11.27758,-17.25 C 47.70282,104.62757 ' +
                    '44.364254,102 43.495254,102 c -2.798369,0 -1.704872,-1.66044 3.983717,-6.049158 5.593548,-4.31539 13.183139,-7.091307 16.801313,-6.145133 3.559412,0.930807 ' +
                    '9.408491,8.154973 13.919775,17.192241 l 4.46286,8.94025 4.54378,-6.83321 C 95.518219,96.605618 108.21371,81.688517 125.80695,63.75 L 143.21531,46 l ' +
                    '-53.650021,0 -53.650035,0 0,57.5 0,57.5 59.000005,0 58.999991,0 0,-53.62244 z';
                break;
            case 'CrossCircle':
                shape = 'M 83.347458,173.13597 C 61.069754,168.04956 42.193415,152.8724 32.202285,132.01368 23.4014,113.63986 23.679644,89.965903 32.91889,71.042373 ' +
                    '41.881579,52.685283 60.867647,37.139882 80.847458,31.799452 c 10.235111,-2.735756 31.264662,-2.427393 40.964762,0.600679 26.18668,8.174684 ' +
                    '46.06876,28.926852 51.62012,53.879155 2.43666,10.952327 1.56754,28.058524 -1.98036,38.977594 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 ' +
                    '-6.3909,2.08202 -10.18566,2.59644 -21.27805,2.88446 -9.033911,0.23456 -15.484931,-0.10267 -19.500002,-1.01939 z M 112.4138,158.45825 c 17.13137,-3.13002 ' +
                    '33.71724,-15.96081 41.41353,-32.03742 14.8975,-31.119027 -1.10807,-67.659584 -34.40232,-78.540141 -6.71328,-2.193899 -9.93541,-2.643501 ' +
                    '-19.07755,-2.661999 -9.354252,-0.01893 -12.16228,0.37753 -18.768532,2.649866 -17.155451,5.900919 -29.669426,17.531424 -36.438658,33.866137 ' +
                    '-2.152301,5.193678 -2.694658,8.35455 -3.070923,17.89744 -0.518057,13.139047 0.741843,19.201887 6.111644,29.410237 4.106815,7.80733 15.431893,19.09359 ' +
                    '23.36818,23.28808 12.061362,6.37467 27.138828,8.6356 40.864629,6.1278 z M 69.097458,133.41654 c -2.8875,-2.75881 -5.25,-5.35869 -5.25,-5.77751 ' +
                    '0,-0.41882 5.658529,-6.30954 12.57451,-13.0905 l 12.57451,-12.329 L 76.198053,89.392633 63.399628,76.565738 68.335951,71.554056 c 2.714978,-2.756426 ' +
                    '5.304859,-5.011683 5.75529,-5.011683 0.450432,0 6.574351,5.611554 13.608709,12.470121 l 12.78974,12.470119 4.42889,-4.553471 c 2.43588,-2.50441 ' +
                    '8.39186,-8.187924 13.23551,-12.630032 l 8.80663,-8.076559 5.34744,5.281006 5.34743,5.281007 -12.96155,12.557899 -12.96154,12.557897 13.13318,13.16027 ' +
                    '13.13319,13.16027 -5.18386,4.66074 c -2.85112,2.5634 -5.70472,4.66073 -6.34134,4.66073 -0.63661,0 -6.5434,-5.4 -13.12621,-12 -6.58281,-6.6 -12.3871,-12 ' +
                    '-12.89844,-12 -0.511329,0 -6.593363,5.60029 -13.515627,12.44509 l -12.585935,12.44508 -5.25,-5.016 z';
                break;
            case 'DotCircle':
                shape = 'M 81.652542,170.5936 C 59.374838,165.50719 40.498499,150.33003 30.507369,129.47131 21.706484,111.09749 21.984728,87.42353 31.223974,68.5 ' +
                    '40.186663,50.14291 59.172731,34.597509 79.152542,29.257079 89.387653,26.521323 110.4172,26.829686 120.1173,29.857758 c 26.18668,8.174684 ' +
                    '46.06876,28.926852 51.62012,53.879152 2.43666,10.95233 1.56754,28.05853 -1.98036,38.9776 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 ' +
                    '-6.3909,2.08202 -10.18566,2.59644 -21.27805,2.88446 -9.033907,0.23456 -15.484927,-0.10267 -19.499998,-1.01939 z m 29.999998,-15.098 c 20.68862,-4.34363 ' +
                    '38.01874,-20.45437 44.09844,-40.9956 2.36228,-7.9813 2.36228,-22.0187 0,-30 C 150.08927,65.371023 134.63549,50.297336 114.65254,44.412396 ' +
                    '106.5531,42.027127 90.741304,42.026386 82.695253,44.4109 62.460276,50.407701 46.686742,66.039241 41.6053,85.13096 c -1.948821,7.32201 -1.86506,23.11641 ' +
                    '0.158766,29.93754 8.730326,29.42481 38.97193,46.91812 69.888474,40.4271 z M 90.004747,122.6703 C 76.550209,117.63801 69.825047,101.82445 ' +
                    '75.898143,89.5 c 2.136718,-4.33615 7.147144,-9.356192 11.754399,-11.776953 5.578622,-2.931141 16.413098,-2.927504 22.052908,0.0074 18.03,9.382663 ' +
                    '19.07573,32.784373 1.91442,42.841563 -5.57282,3.26589 -15.830952,4.2617 -21.615123,2.09829 z';
                break;
            case 'DotRectangle':
                shape = 'm 23.847458,101.19491 0,-72.499995 74.5,0 74.499992,0 0,72.499995 0,72.5 -74.499992,0 -74.5,0 0,-72.5 z m 133.999992,-0.008 0,-57.507925 ' +
                    '-59.249992,0.25793 -59.25,0.25793 -0.25819,57.249995 -0.258189,57.25 59.508189,0 59.508182,0 0,-57.50793 z m -94.320573,33.85402 c -0.37368,-0.37368 ' +
                    '-0.679419,-15.67942 -0.679419,-34.01275 l 0,-33.333335 35.513302,0 35.51329,0 -0.2633,33.749995 -0.2633,33.75 -34.570573,0.26275 c -19.013819,0.14452 ' +
                    '-34.876319,-0.043 -35.25,-0.41666 z';
                break;
            case 'NoneCircle':
                shape = 'M 83.5,170.5936 C 61.222296,165.50719 42.345957,150.33003 32.354827,129.47131 23.553942,111.09749 23.832186,87.423523 33.071432,68.5 ' +
                    '42.034121,50.14291 61.020189,34.597509 81,29.257079 c 10.235111,-2.735756 31.26466,-2.427393 40.96476,0.600679 26.18668,8.174684 46.06876,28.926852 ' +
                    '51.62012,53.879155 2.43666,10.95232 1.56754,28.058527 -1.98036,38.977597 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 -6.3909,2.08202 ' +
                    '-10.18566,2.59644 -21.27805,2.88446 -9.033909,0.23456 -15.484929,-0.10267 -19.5,-1.01939 z m 30,-15.098 c 20.68862,-4.34363 38.01874,-20.45437 ' +
                    '44.09844,-40.9956 2.36228,-7.9813 2.36228,-22.018707 0,-29.999997 C 151.93673,65.371023 136.48295,50.297336 116.5,44.412396 108.40056,42.027127 ' +
                    '92.588762,42.026386 84.542711,44.410896 64.307734,50.407697 48.5342,66.039237 43.452758,85.130959 c -1.948821,7.322 -1.86506,23.116411 ' +
                    '0.158766,29.937541 8.730326,29.42481 38.97193,46.91812 69.888476,40.4271 z';
                break;
            case 'NoneRectangle':
                shape = 'm 24.152542,102.04237 0,-72.499997 74.5,0 74.500008,0 0,72.499997 0,72.5 -74.500008,0 -74.5,0 0,-72.5 z m 133.758198,0.25 ' +
                    '-0.25819,-57.249997 -59.000008,0 -59,0 -0.259695,55.999997 c -0.142833,30.8 -0.04446,56.5625 0.218615,57.25 0.375181,0.98048 ' +
                    '13.207991,1.25 59.517885,1.25 l 59.039583,0 -0.25819,-57.25 z';
                break;
        }
        return head + path + shape + '" /></svg>';
    }
}
EditableFieldsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: EditableFieldsService, deps: [{ token: ControllerService }, { token: ModelService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Injectable });
EditableFieldsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: EditableFieldsService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: EditableFieldsService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ControllerService }, { type: ModelService }, { type: HelperService }]; } });

class ToolbarService {
    constructor(model, controller, editableFieldsService, interactionService, helper) {
        this.model = model;
        this.controller = controller;
        this.editableFieldsService = editableFieldsService;
        this.interactionService = interactionService;
        this.helper = helper;
        this.comps = [];
        this.dopComps = [];
        this.controller.getMessage().subscribe((message) => {
            if (message.action !== 'viewer_loaded') {
                this.updateButtons();
            }
        });
    }
    updateButtons() {
        this.comps.filter(i => i.action === 'ViewMode').forEach(m => m.caption = this.model.loc(this.model.reportParams.viewMode));
        this.comps.filter(i => i.action === 'Zoom').forEach((m) => {
            m.menuItems.forEach(n => n.selected = n.name === ('Zoom' + this.model.reportParams.zoom));
            m.caption = this.model.reportParams.zoom ? Math.round(this.model.reportParams.zoom) + '%' : '';
        });
        this.comps.filter(i => i.action === 'ShowFind').forEach((m) => {
            m.selected = this.model.controls.findPanel.visible;
        });
    }
    initButtons() {
        const comps = [];
        const dopComps = [];
        let isFirst = false;
        if (this.model.options.toolbar.showAboutButton) {
            dopComps.push({ type: 'button', action: 'About', img: 'Help.png' });
        }
        if (this.model.options.toolbar.showAboutButton && this.model.options.toolbar.showDesignButton) {
            dopComps.push({ type: 'separator' });
        }
        if (this.model.options.toolbar.showDesignButton) {
            dopComps.push({ type: 'button', action: 'Design', caption: this.model.loc('Design'), img: 'Design.png' });
        }
        if (this.model.options.toolbar.showPinToolbarButton && this.model.options.toolbar.showDesignButton) {
            dopComps.push({ type: 'separator' });
        }
        if (this.model.options.toolbar.showPinToolbarButton) {
            dopComps.push({ type: 'button', action: 'Pin', img: 'Pin.png' });
        }
        if (this.model.options.toolbar.showPrintButton) {
            comps.push({
                type: 'button', action: 'Print', caption: this.model.loc('Print'), img: 'Print.png', tooltip: true,
                arrow: this.model.options.toolbar.printDestination === 'Default' ? 'Down' : null,
                menuItems: this.model.options.toolbar.printDestination === 'Default' ?
                    [{ name: 'PrintPdf', caption: this.model.loc('PrintPdf'), img: 'Save.Small.Pdf.png' },
                        { name: 'PrintWithPreview', caption: this.model.loc('PrintWithPreview'), img: 'ViewMode.png' },
                        { name: 'PrintWithoutPreview', caption: this.model.loc('PrintWithoutPreview'), img: 'Print.png' }] :
                    null
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showOpenButton) {
            comps.push({ type: 'button', action: 'Open', caption: this.model.loc('Open'), img: 'Open.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showSaveButton) {
            comps.push({
                type: 'button', action: 'Save', caption: this.model.loc('Save'), img: 'Save.png', tooltip: true, arrow: 'Down',
                menuItems: this.getSaveMenuItems('saveMenu')
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showSendEmailButton) {
            comps.push({
                type: 'button', action: 'SendEmail', caption: this.model.loc('SendEmail'), img: 'SendEmail.png', tooltip: true, arrow: 'Down',
                menuItems: this.getSaveMenuItems('sendEmailMenu')
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showBookmarksButton || this.model.options.toolbar.showParametersButton) {
            if (!isFirst) {
                comps.push({ type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.toolbar.showBookmarksButton) {
            comps.push({ type: 'button', action: 'Bookmarks', caption: this.model.options.toolbar.displayMode === 'Separated' ? this.model.loc('Bookmarks') : null, img: 'Bookmarks.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showParametersButton) {
            comps.push({ type: 'button', action: 'Parameters', caption: this.model.options.toolbar.displayMode === 'Separated' ? this.model.loc('Parameters') : null, img: 'Parameters.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showResourcesButton) {
            comps.push({ type: 'button', action: 'Resources', caption: this.model.options.toolbar.displayMode === 'Separated' ? this.model.loc('Resources') : null, img: 'Resources.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showFindButton || this.model.options.toolbar.showEditorButton) {
            if (!isFirst) {
                comps.push({ type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.toolbar.showFindButton) {
            comps.push({ type: 'button', action: 'Find', img: 'Find.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showEditorButton) {
            comps.push({ type: 'button', action: 'Editor', img: 'Editor.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.displayMode !== 'Separated') {
            if (this.model.options.toolbar.showFirstPageButton || this.model.options.toolbar.showPreviousPageButton || this.model.options.toolbar.showNextPageButton ||
                this.model.options.toolbar.showLastPageButton || this.model.options.toolbar.showCurrentPageControl) {
                if (!isFirst) {
                    comps.push({ type: 'separator' });
                }
                isFirst = false;
            }
            if (this.model.options.toolbar.showFirstPageButton) {
                comps.push({ type: 'button', action: 'FirstPage', img: this.model.options.appearance.rightToLeft ? 'LastPage.png' : 'FirstPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showPreviousPageButton) {
                comps.push({ type: 'button', action: 'PrevPage', img: this.model.options.appearance.rightToLeft ? 'NextPage.png' : 'PrevPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showCurrentPageControl) {
                comps.push({ type: 'pageControl' });
                isFirst = false;
            }
            if (this.model.options.toolbar.showNextPageButton) {
                comps.push({ type: 'button', action: 'NextPage', img: this.model.options.appearance.rightToLeft ? 'PrevPage.png' : 'NextPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showLastPageButton) {
                comps.push({ type: 'button', action: 'LastPage', img: this.model.options.appearance.rightToLeft ? 'FirstPage.png' : 'LastPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showViewModeButton || this.model.options.toolbar.showZoomButton) {
                if (!isFirst) {
                    comps.push({ type: 'separator' });
                }
                isFirst = false;
            }
        }
        if (this.model.options.toolbar.showFullScreenButton) {
            comps.push({ type: 'button', action: 'FullScreen', img: 'FullScreen.png', tooltip: true });
            comps.push({ type: 'separator' });
            isFirst = false;
        }
        if (this.model.options.toolbar.showZoomButton && this.model.options.toolbar.displayMode !== 'Separated') {
            comps.push({
                type: 'button', action: 'Zoom', caption: '100%', img: 'Zoom.png', tooltip: true, arrow: 'Down',
                menuItems: this.helper.getZoomMenuItems()
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showViewModeButton) {
            comps.push({
                type: 'button', action: 'ViewMode', caption: this.model.loc('SinglePage'), img: 'SinglePage.png', tooltip: true, arrow: 'Down',
                menuItems: [{ name: 'ViewModeSinglePage', caption: this.model.loc('SinglePage'), img: 'SinglePage.png' },
                    { name: 'ViewModeContinuous', caption: this.model.loc('Continuous'), img: 'Continuous.png' },
                    { name: 'ViewModeMultiplePages', caption: this.model.loc('MultiplePages'), img: 'MultiplePages.png' }]
            });
            isFirst = false;
        }
        if (typeof (this.model.options.toolbar.multiPageWidthCount) !== 'undefined') {
            this.model.reportParams.multiPageWidthCount = this.model.options.toolbar.multiPageWidthCount;
        }
        if (typeof (this.model.options.toolbar.multiPageHeightCount) !== 'undefined') {
            this.model.reportParams.multiPageHeightCount = this.model.options.toolbar.multiPageHeightCount;
        }
        if (!this.model.options.appearance.rightToLeft && this.model.options.toolbar.alignment === 'right' &&
            (this.model.options.toolbar.showPinToolbarButton || this.model.options.toolbar.showAboutButton || this.model.options.toolbar.showDesignButton)) {
            comps.push({ type: 'separator6' });
        }
        this.comps = this.model.options.appearance.rightToLeft ? comps.reverse() : comps;
        this.dopComps = this.model.options.appearance.rightToLeft ? dopComps.reverse() : dopComps;
    }
    disableNaviButtons() {
        return this.model.reportParams.viewMode === 'MultiplePages' || this.model.reportParams.viewMode === 'WholeReport' ||
            (this.model.reportParams.viewMode === 'Continuous' && !this.model.options.appearance.scrollbarsMode && !this.model.options.appearance.fullScreenMode);
    }
    getImage(imageName) {
        switch (this.model.options.appearance.saveMenuImageSize) {
            case 'Big':
                return `Save.Big.${imageName}.png`;
            case 'None':
                return null;
            default:
                return `Save.Small.${imageName}.png`;
        }
    }
    getSaveMenuItems(menuName) {
        let isFirst = true;
        const items = [];
        const imageSize = this.model.options.appearance.saveMenuImageSize;
        if (this.model.options.exports.showExportToDocument && menuName === 'saveMenu') {
            items.push({ name: menuName + 'Document', caption: this.model.loc('ReportSnapshot'), imageSize, img: this.getImage('Document') });
            isFirst = false;
        }
        if (menuName === 'saveMenu' && this.model.options.exports.showExportToPdf || this.model.options.exports.showExportToXps || this.model.options.exports.showExportToPowerPoint) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.exports.showExportToPdf) {
            items.push({ name: menuName + 'Pdf', caption: 'Adobe PDF', imageSize, img: this.getImage('Pdf') });
        }
        if (this.model.options.exports.showExportToXps) {
            items.push({ name: menuName + 'Xps', caption: 'Microsoft XPS', imageSize, img: this.getImage('Xps') });
        }
        if (this.model.options.exports.showExportToPowerPoint) {
            items.push({ name: menuName + 'Ppt2007', caption: 'Microsoft PowerPoint', imageSize, img: this.getImage('Ppt') });
        }
        if (this.model.options.exports.showExportToHtml || this.model.options.exports.showExportToHtml5 || this.model.options.exports.showExportToMht) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
            let htmlType = this.model.options.exports.defaultSettings['StiHtmlExportSettings'].HtmlType;
            if (!this.model.options.exports['showExportTo' + htmlType]) {
                if (this.model.options.exports.showExportToHtml) {
                    htmlType = 'Html';
                }
                else if (this.model.options.exports.showExportToHtml5) {
                    htmlType = 'Html5';
                }
                else if (this.model.options.exports.showExportToMht) {
                    htmlType = 'Mht';
                }
            }
            items.push({ name: menuName + htmlType, caption: 'HTML', imageSize, img: this.getImage('Html') });
        }
        if (this.model.options.exports.showExportToText || this.model.options.exports.showExportToRtf || this.model.options.exports.showExportToWord2007 || this.model.options.exports.showExportToOdt) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.exports.showExportToText) {
            items.push({ name: menuName + 'Text', caption: this.model.loc('Text'), imageSize, img: this.getImage('Text') });
        }
        if (this.model.options.exports.showExportToRtf) {
            items.push({ name: menuName + 'Rtf', caption: 'RTF', imageSize, img: this.getImage('Rtf') });
        }
        if (this.model.options.exports.showExportToWord2007) {
            items.push({ name: menuName + 'Word2007', caption: 'Microsoft Word', imageSize, img: this.getImage('Word') });
        }
        if (this.model.options.exports.showExportToOpenDocumentWriter) {
            items.push({ name: menuName + 'Odt', caption: 'OpenDocument Writer', imageSize, img: this.getImage('Odt') });
        }
        if (this.model.options.exports.showExportToExcel || this.model.options.exports.showExportToExcel2007 || this.model.options.exports.showExportToExcelXml || this.model.options.exports.showExportToOpenDocumentWriter) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.exports.showExportToExcel || this.model.options.exports.showExportToExcelXml || this.model.options.exports.showExportToExcel2007) {
            let excelType = this.model.options.exports.defaultSettings['StiExcelExportSettings'].ExcelType;
            if (excelType === 'ExcelBinary') {
                excelType = 'Excel';
            }
            if (!this.model.options.exports['showExportTo' + excelType]) {
                if (this.model.options.exports.showExportToExcel) {
                    excelType = 'Excel';
                }
                else if (this.model.options.exports.showExportToExcel2007) {
                    excelType = 'Excel2007';
                }
                else if (this.model.options.exports.showExportToExcelXml) {
                    excelType = 'ExcelXml';
                }
            }
            items.push({ name: menuName + excelType, caption: 'Microsoft Excel', imageSize, img: this.getImage('Excel') });
        }
        if (this.model.options.exports.showExportToOpenDocumentCalc) {
            items.push({ name: menuName + 'Ods', caption: 'OpenDocument Calc', imageSize, img: this.getImage('Ods') });
        }
        if (this.model.options.exports.showExportToCsv || this.model.options.exports.showExportToDbf || this.model.options.exports.showExportToXml ||
            this.model.options.exports.showExportToDif || this.model.options.exports.showExportToSylk || this.model.options.exports.showExportToJson) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
            let dataType = this.model.options.exports.defaultSettings['StiDataExportSettings'].DataType;
            if (!this.model.options.exports['showExportTo' + dataType]) {
                if (this.model.options.exports.showExportToCsv) {
                    dataType = 'Csv';
                }
                else if (this.model.options.exports.showExportToDbf) {
                    dataType = 'Dbf';
                }
                else if (this.model.options.exports.showExportToXml) {
                    dataType = 'Xml';
                }
                else if (this.model.options.exports.showExportToDif) {
                    dataType = 'Dif';
                }
                else if (this.model.options.exports.showExportToSylk) {
                    dataType = 'Sylk';
                }
                else if (this.model.options.exports.showExportToJson) {
                    dataType = 'Json';
                }
            }
            items.push({ name: menuName + dataType, caption: this.model.loc('Data'), imageSize, img: this.getImage('Data') });
        }
        if (this.model.options.exports.showExportToImageBmp || this.model.options.exports.showExportToImageGif || this.model.options.exports.showExportToImageJpeg || this.model.options.exports.showExportToImagePcx ||
            this.model.options.exports.showExportToImagePng || this.model.options.exports.showExportToImageTiff || this.model.options.exports.showExportToImageMetafile || this.model.options.exports.showExportToImageSvg || this.model.options.exports.showExportToImageSvgz) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
            let imageType = this.model.options.exports.defaultSettings['StiImageExportSettings'].ImageType;
            let imageType_ = imageType === 'Emf' ? 'Metafile' : imageType;
            if (!this.model.options.exports['showExportToImage' + imageType_]) {
                if (this.model.options.exports.showExportToImageBmp) {
                    imageType = 'Bmp';
                }
                else if (this.model.options.exports.showExportToImageGif) {
                    imageType = 'Gif';
                }
                else if (this.model.options.exports.showExportToImageJpeg) {
                    imageType = 'Jpeg';
                }
                else if (this.model.options.exports.showExportToImagePcx) {
                    imageType = 'Pcx';
                }
                else if (this.model.options.exports.showExportToImagePng) {
                    imageType = 'Png';
                }
                else if (this.model.options.exports.showExportToImageTiff) {
                    imageType = 'Tiff';
                }
                else if (this.model.options.exports.showExportToImageMetafile) {
                    imageType = 'Emf';
                }
                else if (this.model.options.exports.showExportToImageSvg) {
                    imageType = 'Svg';
                }
                else if (this.model.options.exports.showExportToImageSvgz) {
                    imageType = 'Svgz';
                }
            }
            items.push({ name: menuName + 'Image' + imageType, caption: this.model.loc('Image'), imageSize, img: this.getImage('Image') });
        }
        return items;
    }
    enabled(desc) {
        var _a, _b;
        const disableNaviButtons = this.disableNaviButtons();
        switch (desc.action) {
            case 'FirstPage':
            case 'PrevPage':
                return this.model.reportParams.pageNumber > 0 && !disableNaviButtons;
            case 'NextPage':
            case 'LastPage':
                return this.model.reportParams.pageNumber < this.model.reportParams.pagesCount - 1 && !disableNaviButtons;
            case 'Bookmarks':
                return this.model.reportParams.bookmarksContent != null;
            case 'Parameters':
                return ((_a = this.model.interactions) === null || _a === void 0 ? void 0 : _a.paramsVariables) != null;
            case 'Resources':
                return ((_b = this.model.reportParams.resources) === null || _b === void 0 ? void 0 : _b.length) > 0;
        }
        return true;
    }
    selected(desc) {
        switch (desc.action) {
            case 'Find':
                return this.model.controls.findPanel.visible;
            case 'Bookmarks':
                return this.model.controls.bookmarksPanel.visible;
            case 'Parameters':
                return this.model.controls.parametersPanel.visible;
            case 'Editor':
                return this.editableFieldsService.visible;
            case 'Resources':
                return this.model.controls.resourcesPanel.visible;
            case 'FullScreen':
                return this.model.options.appearance.fullScreenMode;
            case 'Pin':
                return !this.model.options.toolbar.autoHide;
        }
        return false;
    }
    display(desc) {
        switch (desc.action) {
            case 'Editor':
                return this.model.reportParams.isEditableReport ? '' : 'none';
        }
        return '';
    }
    getButonWidth(comp) {
        if (this.model.options.toolbar.displayMode === 'Separated') {
            if (comp.action === 'Find' || comp.action === 'Editor' || comp.action === 'FullScreen' || comp.action === 'About') {
                return '28px';
            }
            if (this.model.options.isMobileDevice) {
                return '0.4in';
            }
        }
        return null;
    }
    getInnerTableWidth(comp) {
        if (this.model.options.toolbar.displayMode === 'Separated' &&
            (this.model.options.isMobileDevice || comp.action === 'Find' || comp.action === 'Editor' || comp.action === 'FullScreen' || comp.action === 'About')) {
            return '100%';
        }
        return null;
    }
}
ToolbarService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarService, deps: [{ token: ModelService }, { token: ControllerService }, { token: EditableFieldsService }, { token: InteractionsService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Injectable });
ToolbarService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: EditableFieldsService }, { type: InteractionsService }, { type: HelperService }]; } });

class ButtonComponent {
    constructor(model, menuService, tooltipService, helper) {
        this.model = model;
        this.menuService = menuService;
        this.tooltipService = tooltipService;
        this.helper = helper;
        this.margin = '1px';
        this.height = '23px';
        this.selected = false;
        this.imageCellTextAlign = 'center';
        this.imageSizesWidth = 16;
        this.imageSizesHeight = 16;
        this.closeButton = false;
        this.resourceButton = false;
        this.navagationPanelTooltip = false;
        this.helpLink = 'user-manual/index.html?viewer_reports.htm';
        this.action = new EventEmitter();
        this.closeButtonAction = new EventEmitter();
        this.over = false;
        this.showMenu = false;
        this.closeButtonPressed = false;
        this.resourceButtonPressed = false;
        this._enabled = true;
        this.canShowTooltip = true;
    }
    ngOnInit() {
        if (this.menuItems) {
            setTimeout(() => {
                this.menuObj = { type: 'buttonMenu', name: this.actionName, items: this.menuItems, parent: !this.resourceButton ? this.button : this.resButtonEl, state: '' };
                this.menuService.addMenu(this.menuObj);
            }, 500);
        }
    }
    get styleName() {
        return this._styleName || 'stiJsViewerStandartSmallButton';
    }
    set styleName(value) {
        this._styleName = value;
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
        if (this.model.options.toolbar.showMenuMode === 'Hover' && ['Print', 'Save', 'SendEmail', 'Zoom', 'ViewMode'].some(a => a === this.actionName)) {
            this.tooltipService.hideImmediately();
            this.menuService.showMenu(this.actionName);
        }
        else if (this.tooltip && !this.menuService.menus.some(e => e.state === 'expanded') && this.canShowTooltip) {
            const top = !this.navagationPanelTooltip ? this.model.controls.toolbar.offsetHeight + this.model.controls.dashboardsPanel.offsetHeight :
                this.helper.findPosY(this.model.controls.navigatePanel.el.nativeElement, 'stiJsViewerMainPanel');
            const tooltip = this.tooltip === true ? (this.model.localization[this.actionName + 'ToolTip'] != null ? this.model.loc(this.actionName + 'ToolTip') : this.model.loc(this.actionName)) : this.tooltip;
            this.tooltipService.show(this.helper.findPosX(this.button.nativeElement, 'stiJsViewerMainPanel'), top, tooltip, !this.navagationPanelTooltip, this.helpLink);
        }
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
        this.tooltipService.hide();
        setTimeout(() => {
            this.canShowTooltip = true;
        }, 1000);
    }
    click() {
        if (this.enabled && !this.closeButtonPressed) {
            this.tooltipService.hideImmediately();
            if (this.menuItems == null || (this.resourceButton && !this.resourceButtonPressed)) {
                this.action.emit();
            }
            else {
                this.menuService.showMenu(this.actionName);
            }
        }
        this.canShowTooltip = false;
        this.closeButtonPressed = false;
        this.resourceButtonPressed = false;
    }
    get className() {
        var _a;
        return this.styleName ? this.styleName + ' ' + (this.enabled ? (this.styleName + ((this.selected || ((_a = this.menuObj) === null || _a === void 0 ? void 0 : _a.state) === 'expanded') ? 'Selected' : (this.over ? 'Over' : 'Default'))) : this.styleName + 'Disabled') : '';
    }
}
ButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ButtonComponent, deps: [{ token: ModelService }, { token: MenuService }, { token: TooltipService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
ButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ButtonComponent, selector: "sti-button", inputs: { caption: "caption", caption2: "caption2", captionAlign: "captionAlign", captionPadding: "captionPadding", captionPaddingLeft: "captionPaddingLeft", captionWhiteSpace: "captionWhiteSpace", captionOverflow: "captionOverflow", captionTextOverflow: "captionTextOverflow", captionWidth: "captionWidth", captionMaxWidth: "captionMaxWidth", captionLineHeight: "captionLineHeight", imageName: "imageName", arrow: "arrow", arrowMarginTop: "arrowMarginTop", margin: "margin", height: "height", selected: "selected", minWidth: "minWidth", innerTableWidth: "innerTableWidth", menuItems: "menuItems", actionName: "actionName", tooltip: "tooltip", imageCellTextAlign: "imageCellTextAlign", imageCellWidth: "imageCellWidth", imageCellPadding: "imageCellPadding", imageSizesWidth: "imageSizesWidth", imageSizesHeight: "imageSizesHeight", imageMargin: "imageMargin", width: "width", display: "display", closeButton: "closeButton", resourceButton: "resourceButton", styleColors: "styleColors", boxSizing: "boxSizing", navagationPanelTooltip: "navagationPanelTooltip", cursor: "cursor", fontSize: "fontSize", helpLink: "helpLink", borderColor: "borderColor", styleName: "styleName", enabled: "enabled" }, outputs: { action: "action", closeButtonAction: "closeButtonAction" }, viewQueries: [{ propertyName: "button", first: true, predicate: ["button"], descendants: true }, { propertyName: "resButtonEl", first: true, predicate: ["resButtonEl"], descendants: true }], ngImport: i0, template: `
  <div #button
    [style.fontFamily]="model.options.toolbar.fontFamily"
    [style.cursor]="cursor"
    [style.borderColor]="borderColor"
    [class]="className"
    [style]="{height: helper.val(height, '23px'), boxSizing: helper.val(boxSizing, 'content-box'), margin: helper.val(margin, '1px'), minWidth: minWidth, width: width, display: display }"
    [style.fontSize]="fontSize"
    (mouseover)="mouseover()"
    (mouseout)="mouseout()"
    (click)="click()" >
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%;width:100%" [style.width]="innerTableWidth">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngIf="imageName != null" [style]="{lineHeight:'0', padding:helper.val(imageCellPadding, '0 3px'), textAlign: imageCellTextAlign, width: imageCellWidth}" class="stiJsViewerClearAllStyles">
            <img src="{{model.img(imageName)}}" [style.opacity]="enabled ? '1' : '0.5'"
                [style.width.px]="imageSizesWidth"
                [style.height.px]="imageSizesHeight"
                [style.margin]="imageMargin">
          </td>
          <td *ngIf="caption != null"
             [style]="{whiteSpace:'nowrap', textAlign: captionAlign || 'left', padding:captionPadding || ((arrow ? '1px 0' : '1px 5px') + (imageName ? ' 0 0' : ' 0 5px')), width: captionWidth}"
             [style.maxWidth]="captionMaxWidth"
             [style.lineHeight]="captionLineHeight"
             [style.paddingLeft]="captionPaddingLeft"
             [style.whiteSpace]="captionWhiteSpace"
             [style.overflow]="captionOverflow"
             [style.textOverflow]="captionTextOverflow"
             class="stiJsViewerClearAllStyles">
            {{caption}}
            <div *ngIf="caption2 != null">
            {{caption2}}
            </div>
          </td>
          <td *ngIf="arrow" class="stiJsViewerClearAllStyles">
            <img src="{{arrow == 'Up' || arrow == 'Down' ? model.img('Arrows.SmallArrow' + arrow + (arrow == 'Down' && styleColors && styleColors.isDarkStyle ? 'White.png' : '.png')) : model.img(arrow)}}"
            [style]="{lineHeight:'0', width:'8px', height:'8px', verticalAlign:'baseline', padding:caption ? '0 5px 0 5px' : '0 5px 0 2px', marginTop: arrowMarginTop}"
            [style.opacity]="enabled ? '1' : '0.5'"/>
          </td>

          <td *ngIf="closeButton" class="stiJsViewerClearAllStyles">
            <sti-button [imageName]="'CloseForm.png'"
              [imageMargin]="'1px 0 0 -1px'"
              [margin]="'0 2px 0 0'"
              [imageCellPadding]="'0'"
              [width]="model.options.isTouchDevice ? '22px' : '17px'"
              [height]="model.options.isTouchDevice ? '22px' : '17px'"
              (action)="closeButtonPressed = true; closeButtonAction.emit()">
            </sti-button>
          </td>

          <td #resButtonEl *ngIf="resourceButton" style="width: 1px;">
            <sti-button [imageName]="'Arrows.SmallArrowDown.png'"
              [styleName]="'stiJsViewerResourceDropDownButton'"
              [innerTableWidth]="'100%'"
              [margin]="'0 7px 0 3px'"
              [imageCellTextAlign]="'center'"
              [imageSizesWidth]="8"
              [imageSizesHeight]="8"
              [height]="model.options.isTouchDevice ? '23px' : '17px'"
              [width]="model.options.isTouchDevice ? '23px' : '17px'"
              (action)="resourceButtonPressed = true;">>
            </sti-button>
          </td>

        </tr>
      </tbody>
    </table>
  </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-button',
                    template: `
  <div #button
    [style.fontFamily]="model.options.toolbar.fontFamily"
    [style.cursor]="cursor"
    [style.borderColor]="borderColor"
    [class]="className"
    [style]="{height: helper.val(height, '23px'), boxSizing: helper.val(boxSizing, 'content-box'), margin: helper.val(margin, '1px'), minWidth: minWidth, width: width, display: display }"
    [style.fontSize]="fontSize"
    (mouseover)="mouseover()"
    (mouseout)="mouseout()"
    (click)="click()" >
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%;width:100%" [style.width]="innerTableWidth">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngIf="imageName != null" [style]="{lineHeight:'0', padding:helper.val(imageCellPadding, '0 3px'), textAlign: imageCellTextAlign, width: imageCellWidth}" class="stiJsViewerClearAllStyles">
            <img src="{{model.img(imageName)}}" [style.opacity]="enabled ? '1' : '0.5'"
                [style.width.px]="imageSizesWidth"
                [style.height.px]="imageSizesHeight"
                [style.margin]="imageMargin">
          </td>
          <td *ngIf="caption != null"
             [style]="{whiteSpace:'nowrap', textAlign: captionAlign || 'left', padding:captionPadding || ((arrow ? '1px 0' : '1px 5px') + (imageName ? ' 0 0' : ' 0 5px')), width: captionWidth}"
             [style.maxWidth]="captionMaxWidth"
             [style.lineHeight]="captionLineHeight"
             [style.paddingLeft]="captionPaddingLeft"
             [style.whiteSpace]="captionWhiteSpace"
             [style.overflow]="captionOverflow"
             [style.textOverflow]="captionTextOverflow"
             class="stiJsViewerClearAllStyles">
            {{caption}}
            <div *ngIf="caption2 != null">
            {{caption2}}
            </div>
          </td>
          <td *ngIf="arrow" class="stiJsViewerClearAllStyles">
            <img src="{{arrow == 'Up' || arrow == 'Down' ? model.img('Arrows.SmallArrow' + arrow + (arrow == 'Down' && styleColors && styleColors.isDarkStyle ? 'White.png' : '.png')) : model.img(arrow)}}"
            [style]="{lineHeight:'0', width:'8px', height:'8px', verticalAlign:'baseline', padding:caption ? '0 5px 0 5px' : '0 5px 0 2px', marginTop: arrowMarginTop}"
            [style.opacity]="enabled ? '1' : '0.5'"/>
          </td>

          <td *ngIf="closeButton" class="stiJsViewerClearAllStyles">
            <sti-button [imageName]="'CloseForm.png'"
              [imageMargin]="'1px 0 0 -1px'"
              [margin]="'0 2px 0 0'"
              [imageCellPadding]="'0'"
              [width]="model.options.isTouchDevice ? '22px' : '17px'"
              [height]="model.options.isTouchDevice ? '22px' : '17px'"
              (action)="closeButtonPressed = true; closeButtonAction.emit()">
            </sti-button>
          </td>

          <td #resButtonEl *ngIf="resourceButton" style="width: 1px;">
            <sti-button [imageName]="'Arrows.SmallArrowDown.png'"
              [styleName]="'stiJsViewerResourceDropDownButton'"
              [innerTableWidth]="'100%'"
              [margin]="'0 7px 0 3px'"
              [imageCellTextAlign]="'center'"
              [imageSizesWidth]="8"
              [imageSizesHeight]="8"
              [height]="model.options.isTouchDevice ? '23px' : '17px'"
              [width]="model.options.isTouchDevice ? '23px' : '17px'"
              (action)="resourceButtonPressed = true;">>
            </sti-button>
          </td>

        </tr>
      </tbody>
    </table>
  </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: MenuService }, { type: TooltipService }, { type: HelperService }]; }, propDecorators: { caption: [{
                type: Input
            }], caption2: [{
                type: Input
            }], captionAlign: [{
                type: Input
            }], captionPadding: [{
                type: Input
            }], captionPaddingLeft: [{
                type: Input
            }], captionWhiteSpace: [{
                type: Input
            }], captionOverflow: [{
                type: Input
            }], captionTextOverflow: [{
                type: Input
            }], captionWidth: [{
                type: Input
            }], captionMaxWidth: [{
                type: Input
            }], captionLineHeight: [{
                type: Input
            }], imageName: [{
                type: Input
            }], arrow: [{
                type: Input
            }], arrowMarginTop: [{
                type: Input
            }], margin: [{
                type: Input
            }], height: [{
                type: Input
            }], selected: [{
                type: Input
            }], minWidth: [{
                type: Input
            }], innerTableWidth: [{
                type: Input
            }], menuItems: [{
                type: Input
            }], actionName: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], imageCellTextAlign: [{
                type: Input
            }], imageCellWidth: [{
                type: Input
            }], imageCellPadding: [{
                type: Input
            }], imageSizesWidth: [{
                type: Input
            }], imageSizesHeight: [{
                type: Input
            }], imageMargin: [{
                type: Input
            }], width: [{
                type: Input
            }], display: [{
                type: Input
            }], closeButton: [{
                type: Input
            }], resourceButton: [{
                type: Input
            }], styleColors: [{
                type: Input
            }], boxSizing: [{
                type: Input
            }], navagationPanelTooltip: [{
                type: Input
            }], cursor: [{
                type: Input
            }], fontSize: [{
                type: Input
            }], helpLink: [{
                type: Input
            }], borderColor: [{
                type: Input
            }], action: [{
                type: Output
            }], closeButtonAction: [{
                type: Output
            }], button: [{
                type: ViewChild,
                args: ['button']
            }], resButtonEl: [{
                type: ViewChild,
                args: ['resButtonEl']
            }], styleName: [{
                type: Input
            }], enabled: [{
                type: Input
            }] } });

class ToolbarSeparatorComponent {
    constructor(model) {
        this.model = model;
    }
    ngOnInit() { }
}
ToolbarSeparatorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarSeparatorComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
ToolbarSeparatorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ToolbarSeparatorComponent, selector: "sti-toolbar-separator", ngImport: i0, template: `
    <div style="width:1px" [style.height]="model.options.isMobileDevice ? '0.4in' : (model.options.isTouchDevice ? '26px' : '21px')" class="stiJsViewerToolBarSeparator"></div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarSeparatorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-toolbar-separator',
                    template: `
    <div style="width:1px" [style.height]="model.options.isMobileDevice ? '0.4in' : (model.options.isTouchDevice ? '26px' : '21px')" class="stiJsViewerToolBarSeparator"></div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; } });

class CheckboxComponent {
    constructor(model) {
        this.model = model;
        this.isEnabled = true;
        this.isChecked = false;
        this.indeterminate = false;
        this.nullable = false;
        this.action = new EventEmitter();
        this.over = false;
        this.isNull = false;
    }
    ngOnInit() { }
    mouseover() {
        this.over = true;
    }
    mouseleave() {
        this.over = false;
    }
    click() {
        if (this.isEnabled) {
            this.isChecked = !this.isChecked || this.isNull;
            this.isNull = this.nullable && this.isChecked && !this.isNull;
            this.action.emit(this.isNull ? null : this.isChecked);
        }
    }
}
CheckboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CheckboxComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
CheckboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: CheckboxComponent, selector: "sti-check-box", inputs: { isEnabled: "isEnabled", isChecked: "isChecked", indeterminate: "indeterminate", captionText: "captionText", tooltip: "tooltip", margin: "margin", width: "width", styleColors: "styleColors", imageBlockParentWidth: "imageBlockParentWidth", nullable: "nullable" }, outputs: { action: "action" }, ngImport: i0, template: `
    <table cellpadding="0" cellspacing="0"
      [class]="isEnabled ? 'stiJsViewerCheckBox' : 'stiJsViewerCheckBoxDisabled'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [attr.title]="tooltip"
      [style.margin]="margin"
      [style.width]="width"
      style="box-sizing:content-box"
      (mouseover)="mouseover()"
      (mouseleave)="mouseleave()"
      (click)="click()">
       <tbody>
          <tr class="stiJsViewerClearAllStyles">
             <td style="line-height: 0"
                 [style.padding]="model.options.isTouchDevice ? '1px 3px 1px 1px' : ''"
                 [style.width]="imageBlockParentWidth"
                 class="stiJsViewerClearAllStyles">
                <div [style.width.px]="model.options.isTouchDevice ? 16 : 13"
                     [style.height.px]="model.options.isTouchDevice ? 16 : 13"
                     [class]="isEnabled ? (over ? 'stiJsViewerCheckBoxImageBlockOver' : 'stiJsViewerCheckBoxImageBlock') : 'stiJsViewerCheckBoxImageBlockDisabled'"
                     style="box-sizing: content-box">
                     <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%; height: 100%;">
                        <tbody>
                          <tr class="stiJsViewerClearAllStyles">
                            <td [style.textAlign]="model.options.isTouchDevice ? 'center' : 'right'"
                                [style.verticalAlign]="model.options.isTouchDevice ? 'middle' : 'top'"
                                style="position: relative;">
                                <img *ngIf="!isNull" [src]="model.img((indeterminate ? 'CheckBoxIndeterminate' : 'CheckBox') + (styleColors && styleColors.isDarkStyle ? 'White.png' : '.png'))"
                                    [style.visibility]="isChecked ? 'visible' : 'hidden'"
                                    [style.width.px]="indeterminate ? 13 : 12"
                                    [style.height.px]="indeterminate ? 13 : 12"
                                    [style.opacity]="isEnabled ? 1 : 0.5"
                                    style="vertical-align: baseline"/>
                                <div *ngIf="isNull" class="stiJsViewerCheckBoxNullBlock" style="left: 2px; top: 6px; width: 9px; " [style.opacity]="isEnabled ? 1 : 0.5"></div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                </div>
             </td>
             <td *ngIf="captionText != null"
                 [style.padding]="!model.options.isTouchDevice ? '1px 0 0 4px' : ''"
                 style="white-space: nowrap">
                 {{captionText}}
             </td>
          </tr>
       </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CheckboxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-check-box',
                    template: `
    <table cellpadding="0" cellspacing="0"
      [class]="isEnabled ? 'stiJsViewerCheckBox' : 'stiJsViewerCheckBoxDisabled'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [attr.title]="tooltip"
      [style.margin]="margin"
      [style.width]="width"
      style="box-sizing:content-box"
      (mouseover)="mouseover()"
      (mouseleave)="mouseleave()"
      (click)="click()">
       <tbody>
          <tr class="stiJsViewerClearAllStyles">
             <td style="line-height: 0"
                 [style.padding]="model.options.isTouchDevice ? '1px 3px 1px 1px' : ''"
                 [style.width]="imageBlockParentWidth"
                 class="stiJsViewerClearAllStyles">
                <div [style.width.px]="model.options.isTouchDevice ? 16 : 13"
                     [style.height.px]="model.options.isTouchDevice ? 16 : 13"
                     [class]="isEnabled ? (over ? 'stiJsViewerCheckBoxImageBlockOver' : 'stiJsViewerCheckBoxImageBlock') : 'stiJsViewerCheckBoxImageBlockDisabled'"
                     style="box-sizing: content-box">
                     <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%; height: 100%;">
                        <tbody>
                          <tr class="stiJsViewerClearAllStyles">
                            <td [style.textAlign]="model.options.isTouchDevice ? 'center' : 'right'"
                                [style.verticalAlign]="model.options.isTouchDevice ? 'middle' : 'top'"
                                style="position: relative;">
                                <img *ngIf="!isNull" [src]="model.img((indeterminate ? 'CheckBoxIndeterminate' : 'CheckBox') + (styleColors && styleColors.isDarkStyle ? 'White.png' : '.png'))"
                                    [style.visibility]="isChecked ? 'visible' : 'hidden'"
                                    [style.width.px]="indeterminate ? 13 : 12"
                                    [style.height.px]="indeterminate ? 13 : 12"
                                    [style.opacity]="isEnabled ? 1 : 0.5"
                                    style="vertical-align: baseline"/>
                                <div *ngIf="isNull" class="stiJsViewerCheckBoxNullBlock" style="left: 2px; top: 6px; width: 9px; " [style.opacity]="isEnabled ? 1 : 0.5"></div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                </div>
             </td>
             <td *ngIf="captionText != null"
                 [style.padding]="!model.options.isTouchDevice ? '1px 0 0 4px' : ''"
                 style="white-space: nowrap">
                 {{captionText}}
             </td>
          </tr>
       </tbody>
    </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; }, propDecorators: { isEnabled: [{
                type: Input
            }], isChecked: [{
                type: Input
            }], indeterminate: [{
                type: Input
            }], captionText: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], margin: [{
                type: Input
            }], width: [{
                type: Input
            }], styleColors: [{
                type: Input
            }], imageBlockParentWidth: [{
                type: Input
            }], nullable: [{
                type: Input
            }], action: [{
                type: Output
            }] } });

class ParameterCheckboxComponent {
    constructor() {
        this.isEnabled = true;
        this.isMenuParameter = false;
        this.paramNull = false;
        this.nullable = false;
        this.action = new EventEmitter();
    }
    ngOnInit() { }
    onAction(checked) {
        this.action.emit(checked);
    }
    get checked() {
        if (this.paramNull) {
            return this.params.isNull;
        }
        else {
            return this.isMenuParameter ? this.params.isChecked : (typeof (this.params.value) === 'boolean' && this.params.value) || this.params.value === 'true' || this.params.value === 'True';
        }
    }
}
ParameterCheckboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterCheckboxComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
ParameterCheckboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: { params: "params", captionText: "captionText", margin: "margin", width: "width", imageBlockParentWidth: "imageBlockParentWidth", isEnabled: "isEnabled", isMenuParameter: "isMenuParameter", paramNull: "paramNull", nullable: "nullable" }, outputs: { action: "action" }, ngImport: i0, template: `
    <sti-check-box [isEnabled]="isEnabled"
                   [isChecked]="checked"
                   [nullable]="nullable"
                   [captionText]="captionText"
                   [margin]="margin"
                   [width]="width"
                   [imageBlockParentWidth]="imageBlockParentWidth"
                   (action)="onAction($event)">
    </sti-check-box>
    `, isInline: true, dependencies: [{ kind: "component", type: CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterCheckboxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-checkbox',
                    template: `
    <sti-check-box [isEnabled]="isEnabled"
                   [isChecked]="checked"
                   [nullable]="nullable"
                   [captionText]="captionText"
                   [margin]="margin"
                   [width]="width"
                   [imageBlockParentWidth]="imageBlockParentWidth"
                   (action)="onAction($event)">
    </sti-check-box>
    `
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { params: [{
                type: Input
            }], captionText: [{
                type: Input
            }], margin: [{
                type: Input
            }], width: [{
                type: Input
            }], imageBlockParentWidth: [{
                type: Input
            }], isEnabled: [{
                type: Input
            }], isMenuParameter: [{
                type: Input
            }], paramNull: [{
                type: Input
            }], nullable: [{
                type: Input
            }], action: [{
                type: Output
            }] } });

class TextBoxComponent {
    constructor(model) {
        this.model = model;
        this.enabled = true;
        this.focusOnCreate = false;
        this.action = new EventEmitter();
        this.onchange = new EventEmitter();
        this.onblur = new EventEmitter();
        this.selected = false;
        this.focused = false;
        this.over = false;
        this._readOnly = false;
        this.styleName = 'stiJsViewerTextBox';
    }
    ngAfterViewInit() {
        if (this.focusOnCreate) {
            setTimeout(() => {
                this.element.nativeElement.focus();
            });
        }
    }
    keypress(event) {
        if (!this.enabled) {
            return false;
        }
        if (event.keyCode === 13) {
            this.action.emit(event.target);
        }
    }
    onchanged(event) {
        this.onchange.emit(event.target);
    }
    get paddingInt() {
        return this.isNullableParam ? "0 0 0 22px" : this.padding;
    }
    focus() {
        this.oldValue = this.element.nativeElement.value;
    }
    get isNullableParam() {
        var _a, _b;
        return ((_a = this.variable) === null || _a === void 0 ? void 0 : _a.basicType) == 'NullableValue' || ((_b = this.variable) === null || _b === void 0 ? void 0 : _b.allowNullableString);
    }
    nullableAction(checked) {
        this.variable.isNull = !this.variable.isNull;
    }
    get height() {
        return this.model.options.isTouchDevice ? '26px' : '21px';
    }
    get className() {
        if (this._readOnly) {
            return this.styleName + ' ' + this.styleName + 'Default';
        }
        return this.styleName + ' ' + this.styleName + (this.selected ? 'Over' : (this.enabled ? (this.over ? 'Over' : 'Default') : 'Disabled'));
    }
    set readOnly(value) {
        this._readOnly = value;
        setTimeout(() => {
            try {
                this.element.nativeElement.setAttribute('unselectable', value ? 'on' : 'off');
                this.element.nativeElement.setAttribute('onselectstart', value ? 'return false' : '');
                this.element.nativeElement.readOnly = value;
            }
            catch (e) { }
        });
    }
    get readOnly() {
        return this._readOnly;
    }
    ngOnInit() { }
}
TextBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextBoxComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
TextBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: TextBoxComponent, selector: "sti-text-box", inputs: { width: "width", actionLostFocus: "actionLostFocus", tooltip: "tooltip", enabled: "enabled", value: "value", margin: "margin", focusOnCreate: "focusOnCreate", maxLength: "maxLength", color: "color", type: "type", padding: "padding", border: "border", variable: "variable", readOnly: "readOnly" }, outputs: { action: "action", onchange: "onchange", onblur: "onblur" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <input #element
    [style]="{fontFamily:model.options.toolbar.fontFamily, height: height, lineHeight: height, boxSizing:'content-box'}"
    [style.color]="color ? color : (model.options.toolbar.fontColor != '' ? model.options.toolbar.fontColor : '')"
    [style.width]="width != null ? width + 'px' : ''"
    [style.margin]="margin"
    [style.cursor]="readOnly ? 'default' : ''"
    [style.padding]="paddingInt"
    [style.border]="border"
    [title]="tooltip || ''"
    [class]="className"
    [value]="value || ''"
    [attr.maxLength]="maxLength"
    [attr.type]="type"
    (mouseover)="over=true"
    (mouseleave)="over=false"
    (focused)="focused=true; selected=true"
    (blur)="focused=false; selected=false; onblur.emit($event.target)"
    (keypress)="keypress($event)"
    (keyup)="onchanged($event)"
    (focus)="focus()"/>
    <sti-parameter-checkbox *ngIf="isNullableParam"
      [style]="{left: '6px', top: 'calc(50% - 7px)', position: 'absolute'}"
      [params]="variable"
      [isEnabled]="variable.allowUserValues"
      (action)="nullableAction($event)"
      [paramNull]="true" >
    </sti-parameter-checkbox>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: ["params", "captionText", "margin", "width", "imageBlockParentWidth", "isEnabled", "isMenuParameter", "paramNull", "nullable"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextBoxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-text-box',
                    template: `
    <input #element
    [style]="{fontFamily:model.options.toolbar.fontFamily, height: height, lineHeight: height, boxSizing:'content-box'}"
    [style.color]="color ? color : (model.options.toolbar.fontColor != '' ? model.options.toolbar.fontColor : '')"
    [style.width]="width != null ? width + 'px' : ''"
    [style.margin]="margin"
    [style.cursor]="readOnly ? 'default' : ''"
    [style.padding]="paddingInt"
    [style.border]="border"
    [title]="tooltip || ''"
    [class]="className"
    [value]="value || ''"
    [attr.maxLength]="maxLength"
    [attr.type]="type"
    (mouseover)="over=true"
    (mouseleave)="over=false"
    (focused)="focused=true; selected=true"
    (blur)="focused=false; selected=false; onblur.emit($event.target)"
    (keypress)="keypress($event)"
    (keyup)="onchanged($event)"
    (focus)="focus()"/>
    <sti-parameter-checkbox *ngIf="isNullableParam"
      [style]="{left: '6px', top: 'calc(50% - 7px)', position: 'absolute'}"
      [params]="variable"
      [isEnabled]="variable.allowUserValues"
      (action)="nullableAction($event)"
      [paramNull]="true" >
    </sti-parameter-checkbox>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], width: [{
                type: Input
            }], actionLostFocus: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], enabled: [{
                type: Input
            }], value: [{
                type: Input
            }], margin: [{
                type: Input
            }], focusOnCreate: [{
                type: Input
            }], maxLength: [{
                type: Input
            }], color: [{
                type: Input
            }], type: [{
                type: Input
            }], padding: [{
                type: Input
            }], border: [{
                type: Input
            }], variable: [{
                type: Input
            }], action: [{
                type: Output
            }], onchange: [{
                type: Output
            }], onblur: [{
                type: Output
            }], readOnly: [{
                type: Input
            }] } });

class PageControlComponent {
    constructor(model, controller, helper) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.enabled = true;
        this.count = '?';
    }
    ngOnInit() { }
    textBoxAction(target) {
        if (this.model.reportParams.pagesCount > 0 && this.model.reportParams.pageNumber !== this.getCorrectValue(target.value) - 1) {
            this.controller.action({ name: 'GoToPage', value: this.getCorrectValue(target.value) - 1 });
        }
    }
    getCorrectValue(value) {
        value = parseInt(value, 10);
        if (value < 1 || !value) {
            value = 1;
        }
        if (value > this.model.reportParams.pagesCount) {
            value = this.model.reportParams.pagesCount;
        }
        return value;
    }
    get textBoxColor() {
        const toolbarFontColor = this.model.options.toolbar.fontColor;
        return this.enabled ? (toolbarFontColor && toolbarFontColor !== 'Empty' ? toolbarFontColor : '#444444')
            : (this.model.reportParams && this.model.reportParams.viewMode !== 'SinglePage' ? 'transparent' : toolbarFontColor);
    }
}
PageControlComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageControlComponent, deps: [{ token: ModelService }, { token: ControllerService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
PageControlComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: PageControlComponent, selector: "sti-page-control", inputs: { enabled: "enabled", count: "count", textBoxBorder: "textBoxBorder", margin: "margin" }, ngImport: i0, template: `
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin]="helper.val(margin, '1px')">
      <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              {{model.loc('Page')}}
            </td>
            <td *ngIf="model.options.isMobileDevice" class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              <span>{{model.reportParams.pageNumber + 1}}</span>
            </td>
            <td *ngIf="!model.options.isMobileDevice" class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              <sti-text-box [width]="45" [enabled]="enabled" [style.color]="textBoxColor" [style.opacity]="enabled ? 1 : 0.5"
              (action)="textBoxAction($event)" [value]="model.reportParams.pageNumber + 1" [border]="textBoxBorder"></sti-text-box>
            </td>
            <td class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              {{model.loc('PageOf')}}
            </td>
            <td class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              {{count}}
            </td>
          </tr>
      </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageControlComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-page-control',
                    template: `
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" [style.margin]="helper.val(margin, '1px')">
      <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              {{model.loc('Page')}}
            </td>
            <td *ngIf="model.options.isMobileDevice" class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              <span>{{model.reportParams.pageNumber + 1}}</span>
            </td>
            <td *ngIf="!model.options.isMobileDevice" class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              <sti-text-box [width]="45" [enabled]="enabled" [style.color]="textBoxColor" [style.opacity]="enabled ? 1 : 0.5"
              (action)="textBoxAction($event)" [value]="model.reportParams.pageNumber + 1" [border]="textBoxBorder"></sti-text-box>
            </td>
            <td class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              {{model.loc('PageOf')}}
            </td>
            <td class="stiJsViewerClearAllStyles" style="padding: '0 2px 0 2px' ">
              {{count}}
            </td>
          </tr>
      </tbody>
    </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: HelperService }]; }, propDecorators: { enabled: [{
                type: Input
            }], count: [{
                type: Input
            }], textBoxBorder: [{
                type: Input
            }], margin: [{
                type: Input
            }] } });

class ToolbarDopComponent {
    constructor(model, controller, toolbarService) {
        this.model = model;
        this.controller = controller;
        this.toolbarService = toolbarService;
        this.marginLeft = '1px';
        this.viewInit = false;
    }
    ngAfterViewInit() {
        this.viewInit = true;
        setTimeout(() => {
            var _a, _b;
            const width = (_b = (_a = this.mainTable) === null || _a === void 0 ? void 0 : _a.nativeElement) === null || _b === void 0 ? void 0 : _b.offsetWidth;
            this.marginLeft = this.viewInit && this.model.options.toolbar.alignment === 'Center' && width ? `calc(50% - ${Math.trunc(width / 2)}px)` : '1px';
        });
    }
    ngOnInit() { }
}
ToolbarDopComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarDopComponent, deps: [{ token: ModelService }, { token: ControllerService }, { token: ToolbarService }], target: i0.ɵɵFactoryTarget.Component });
ToolbarDopComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ToolbarDopComponent, selector: "sti-toolbar-dop", inputs: { comps: "comps", align: "align" }, viewQueries: [{ propertyName: "mainTable", first: true, predicate: ["mainTable"], descendants: true }], ngImport: i0, template: `
    <table #mainTable
      class="stiJsViewerClearAllStyles"
      cellpadding="0"
      cellspacing="0"
      style="margin: 1px;"
      [attr.align]="align"
      [style.marginLeft]="marginLeft">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="model.options.toolbar.showButtonCaptions ? comp.caption : null"
              [imageName]="comp.img"
              [arrow]="!model.options.isMobileDevice ? comp.arrow : null"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [enabled]="toolbarService.enabled(comp)"
              [display]="toolbarService.display(comp)"
              [innerTableWidth]="toolbarService.getInnerTableWidth(comp)"
              [width]="toolbarService.getButonWidth(comp)"
              [height]="model.options.toolbar.displayMode == 'Separated' ? (model.options.isMobileDevice ? '0.5in' : '28px') : null"
              (action)="controller.action({ name: comp.action });"
              [selected]="toolbarService.selected(comp)"></sti-button>
            <sti-toolbar-separator *ngIf="comp.type=='separator'"></sti-toolbar-separator>
            <sti-page-control *ngIf="comp.type=='pageControl'" [enabled]="!(model.reportParams.pagesCount <= 1 || toolbarService.disableNaviButtons())" [count]="model.reportParams.pagesCount" ></sti-page-control>
        </td>
      </tr>
    </tbody>
  </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: ToolbarSeparatorComponent, selector: "sti-toolbar-separator" }, { kind: "component", type: PageControlComponent, selector: "sti-page-control", inputs: ["enabled", "count", "textBoxBorder", "margin"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarDopComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-toolbar-dop',
                    template: `
    <table #mainTable
      class="stiJsViewerClearAllStyles"
      cellpadding="0"
      cellspacing="0"
      style="margin: 1px;"
      [attr.align]="align"
      [style.marginLeft]="marginLeft">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="model.options.toolbar.showButtonCaptions ? comp.caption : null"
              [imageName]="comp.img"
              [arrow]="!model.options.isMobileDevice ? comp.arrow : null"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [enabled]="toolbarService.enabled(comp)"
              [display]="toolbarService.display(comp)"
              [innerTableWidth]="toolbarService.getInnerTableWidth(comp)"
              [width]="toolbarService.getButonWidth(comp)"
              [height]="model.options.toolbar.displayMode == 'Separated' ? (model.options.isMobileDevice ? '0.5in' : '28px') : null"
              (action)="controller.action({ name: comp.action });"
              [selected]="toolbarService.selected(comp)"></sti-button>
            <sti-toolbar-separator *ngIf="comp.type=='separator'"></sti-toolbar-separator>
            <sti-page-control *ngIf="comp.type=='pageControl'" [enabled]="!(model.reportParams.pagesCount <= 1 || toolbarService.disableNaviButtons())" [count]="model.reportParams.pagesCount" ></sti-page-control>
        </td>
      </tr>
    </tbody>
  </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: ToolbarService }]; }, propDecorators: { mainTable: [{
                type: ViewChild,
                args: ['mainTable']
            }], comps: [{
                type: Input
            }], align: [{
                type: Input
            }] } });

class ToolbarComponent {
    constructor(model, controller, toolbarService) {
        this.model = model;
        this.controller = controller;
        this.toolbarService = toolbarService;
    }
    ngAfterViewInit() {
        this.model.controls.toolbar.el = this.element;
    }
    ngOnInit() {
        this.toolbarService.initButtons();
    }
}
ToolbarComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarComponent, deps: [{ token: ModelService }, { token: ControllerService }, { token: ToolbarService }], target: i0.ɵɵFactoryTarget.Component });
ToolbarComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ToolbarComponent, selector: "sti-toolbar", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode === 'Separated' ? '  stiJsViewerToolBarSeparated' : '')" style="display: block"
         [style.width.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.height.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.display]="!model.options.isMobileDevice ? (this.model.controls.toolbar.visible ? '' : 'none') : ''"
         [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
         [style.zIndex]="model.options.toolbar.autoHide ? 5 : 2"
         [style.position]="model.options.toolbar.autoHide ? 'absolute' : 'relative'"
         [style.opacity]="model.options.isMobileDevice ? (model.controls.toolbar.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
         [style.marginTop]="model.options.isMobileDevice && !model.controls.toolbar.visible ? '-0.55in' : 0">
      <div [style]="model.options.toolbar.displayMode === 'Simple' ? 'paddingTop: 2px' : ''">
        <table class="stiJsViewerToolBarTable" style="margin: 0px; box-sizing: border-box;"
               cellpadding="0" cellspacing="0"
               [style.background]="model.options.toolbar.backgroundColor !== '' ? model.options.toolbar.backgroundColor : ''"
               [style.border]="model.options.toolbar.displayMode === 'Separated' ? '0px' : (model.options.toolbar.borderColor !== '' ?  '1px solid ' + model.options.toolbar.borderColor : '')"
               [style.color]="model.options.toolbar.fontColor !== '' ? model.options.toolbar.fontColor : ''"
               [style.fontFamily]="model.options.toolbar.fontFamily">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngIf="model.options.appearance.rightToLeft">
              <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>

              <td class="stiJsViewerClearAllStyles" style="width: 100%">
                <sti-toolbar-dop
                  [align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment === 'default' ? 'left' : model.options.toolbar.alignment)"
                  [comps]="toolbarService.comps">
                </sti-toolbar-dop>
              </td>

              <td *ngIf="!model.options.appearance.rightToLeft">
                <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
      <div class="stiJsViewerDisabledPanel" [style.display]="this.model.controls.toolbar.enabled ? 'none' : 'block'"></div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ToolbarDopComponent, selector: "sti-toolbar-dop", inputs: ["comps", "align"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-toolbar',
                    template: `
    <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode === 'Separated' ? '  stiJsViewerToolBarSeparated' : '')" style="display: block"
         [style.width.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.height.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.display]="!model.options.isMobileDevice ? (this.model.controls.toolbar.visible ? '' : 'none') : ''"
         [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
         [style.zIndex]="model.options.toolbar.autoHide ? 5 : 2"
         [style.position]="model.options.toolbar.autoHide ? 'absolute' : 'relative'"
         [style.opacity]="model.options.isMobileDevice ? (model.controls.toolbar.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
         [style.marginTop]="model.options.isMobileDevice && !model.controls.toolbar.visible ? '-0.55in' : 0">
      <div [style]="model.options.toolbar.displayMode === 'Simple' ? 'paddingTop: 2px' : ''">
        <table class="stiJsViewerToolBarTable" style="margin: 0px; box-sizing: border-box;"
               cellpadding="0" cellspacing="0"
               [style.background]="model.options.toolbar.backgroundColor !== '' ? model.options.toolbar.backgroundColor : ''"
               [style.border]="model.options.toolbar.displayMode === 'Separated' ? '0px' : (model.options.toolbar.borderColor !== '' ?  '1px solid ' + model.options.toolbar.borderColor : '')"
               [style.color]="model.options.toolbar.fontColor !== '' ? model.options.toolbar.fontColor : ''"
               [style.fontFamily]="model.options.toolbar.fontFamily">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngIf="model.options.appearance.rightToLeft">
              <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>

              <td class="stiJsViewerClearAllStyles" style="width: 100%">
                <sti-toolbar-dop
                  [align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment === 'default' ? 'left' : model.options.toolbar.alignment)"
                  [comps]="toolbarService.comps">
                </sti-toolbar-dop>
              </td>

              <td *ngIf="!model.options.appearance.rightToLeft">
                <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
      <div class="stiJsViewerDisabledPanel" [style.display]="this.model.controls.toolbar.enabled ? 'none' : 'block'"></div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: ToolbarService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

class PageComponent {
    constructor(model, controller) {
        this.model = model;
        this.controller = controller;
        this.touchesLength = 0;
        this.lastTouches = [{ x: 0, y: 0, time: 0 }, { x: 0, y: 0, time: 0 }];
        this.touchAllowPageAction = false;
        this.touchAllowScroll = false;
    }
    ngOnInit() {
    }
    ngAfterViewInit() {
        const page = this.element.nativeElement;
        page.innerHTML = this.pageAttributes.content;
        this.pageAttributes.page = page;
        // Correct Watermark
        if (this.pageAttributes.existsWatermark) {
            page.style.position = 'relative';
            for (const childNode of page.childNodes) {
                if (childNode.className === 'stiWatermarkImage') {
                    childNode.style.width = 'auto';
                    childNode.style.height = 'auto';
                    break;
                }
            }
        }
        let reportDisplayMode = this.model.options.displayModeFromReport || this.model.options.appearance.reportDisplayMode;
        if (reportDisplayMode == "Div" || reportDisplayMode == "Span") {
            const childs = page.getElementsByClassName('StiPageContainer');
            if (childs && childs.length > 0) {
                const pageContainer = childs[0];
                pageContainer.style.position = 'relative';
                if (reportDisplayMode == "Span") {
                    pageContainer.style.margin = '0 1px'; // fix Chrome bug with SPAN position
                }
                page.style.width = (this.pageWidth - this.margins[1] - this.margins[3]) + 'px';
                page.style.height = (this.pageHeight - this.margins[0] - this.margins[2]) + 'px';
            }
        }
        this.element.nativeElement.pageAttributes = this.pageAttributes;
        /*const pageHeight = this.pageHeight;
        if (pageHeight !== 0) {
          // fixed bug with long time execute
          if (this.model.options.appearance.reportDisplayMode !== 'Table' && this.model.reportParams.viewMode !== 'SinglePage') {
            setTimeout(() => {
              const currentPageHeight = page.offsetHeight - this.margins[0] - this.margins[2];
              if (this.reportPanel.maxHeights[pageHeight] == null || currentPageHeight > this.reportPanel.maxHeights[pageHeight]) {
                this.reportPanel.maxHeights[pageHeight] = currentPageHeight;
              }
            });
          } else {
            const currentPageHeight = page.offsetHeight - this.margins[0] - this.margins[2];
            if (this.reportPanel.maxHeights[pageHeight] === null || currentPageHeight > this.reportPanel.maxHeights[pageHeight]) {
              this.reportPanel.maxHeights[pageHeight] = currentPageHeight;
            }
          }
        }*/
    }
    get margins() {
        const margins = [0, 0, 0, 0];
        if (this.pageAttributes.margins) {
            const marginsPx = this.pageAttributes.margins.split(' ');
            for (let i = 0; i < marginsPx.length; i++) {
                margins[i] = parseInt(marginsPx[i].replace('px', ''), 10);
            }
        }
        return margins;
    }
    get pageWidth() {
        const pageSizes = this.pageAttributes.sizes ? this.pageAttributes.sizes.split(';') : null;
        if (pageSizes) {
            return parseInt(pageSizes[0], 10);
        }
        return 0;
    }
    get pageHeight() {
        const pageSizes = this.pageAttributes.sizes ? this.pageAttributes.sizes.split(';') : null;
        if (pageSizes) {
            return parseInt(pageSizes[1], 10);
        }
        return 0;
    }
    eventTouchStart(e) {
        const reportPanel = this.model.controls.reportPanel.el.nativeElement;
        this.touchAllowPageAction = this.touchesLength === 0 && Math.abs(reportPanel.offsetWidth - reportPanel.scrollWidth) <= 10;
        this.touchAllowScroll = reportPanel.offsetWidth === reportPanel.scrollWidth;
        this.touchesLength++;
        if (this.touchAllowPageAction) {
            this.touchStartX = parseInt(e.changedTouches[0].clientX, 10);
            this.touchStartScrollY = reportPanel.scrollTop;
        }
    }
    eventTouchMove(e) {
        const reportPanel = this.model.controls.reportPanel.el.nativeElement;
        if (this.touchAllowPageAction) {
            this.lastTouches.shift();
            this.lastTouches.push({
                x: e.changedTouches[0].clientX,
                y: e.changedTouches[0].clientY,
                time: new Date().getTime()
            });
            if (this.touchAllowScroll && this.touchStartScrollY === reportPanel.scrollTop) {
                this.touchPosX = Math.trunc(this.lastTouches[1].x - this.touchStartX);
                if (scrollX === 0) {
                    this.element.nativeElement.style.transform = `translateX(${this.touchPosX}px)`;
                }
            }
        }
    }
    eventTouchEnd(e) {
        const reportPanel = this.model.controls.reportPanel.el.nativeElement;
        if (this.touchesLength > 0) {
            this.touchesLength--;
        }
        if (this.touchAllowPageAction && this.touchesLength === 0) {
            const dX = this.lastTouches[1].x - this.lastTouches[0].x;
            const dT = new Date().getTime() - this.lastTouches[1].time;
            if (this.touchStartScrollY !== reportPanel.scrollTop ||
                (dX <= 0 && this.model.reportParams.pageNumber >= this.model.reportParams.pagesCount - 1) ||
                (dX >= 0 && this.model.reportParams.pageNumber <= 0)) {
                this.translateX(0);
            }
            else if ((dX < -5 && dT <= 14 && this.lastTouches[1].x < this.touchStartX) ||
                (dX < 0 && this.touchPosX < -this.pageWidth / 3)) {
                this.controller.action({ name: 'NextPage' });
                this.translateX(-this.pageWidth);
            }
            else if ((dX > 5 && dT <= 14 && this.lastTouches[1].x > this.touchStartX) ||
                (dX > 0 && this.touchPosX > this.pageWidth / 3)) {
                this.controller.action({ name: 'PrevPage' });
                this.translateX(this.pageWidth);
            }
            else {
                this.translateX(0);
            }
        }
    }
    translateX(value) {
        this.element.nativeElement.style.transitionDuration = '300ms';
        this.element.nativeElement.style.transform = value === 0 ? '' : `translateX(${value}px)`;
        setTimeout(() => {
            this.element.nativeElement.style.transitionDuration = '';
        }, 300);
    }
}
PageComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageComponent, deps: [{ token: ModelService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Component });
PageComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: PageComponent, selector: "sti-page", inputs: { pageAttributes: "pageAttributes" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
      style="overflow: hidden; text-align: left; vertical-align: top; color: #000000; box-sizing: content-box; display:inline-block"
      [style.margin]="model.reportParams.viewMode === 'Continuous' ? '10px auto 10px auto' : '10px'"
      [style.display]="this.model.reportParams.viewMode === 'Continuous' ? 'table' : 'inline-block'"
      [style.border]="'1px solid ' + this.model.options.appearance.pageBorderColor"
      [style.background]="pageAttributes['background'] == 'Transparent' || pageAttributes.background == 'rgba(255,255,255,0)' ? 'White' : pageAttributes['background']"
      [style.padding]="pageAttributes['margins']"
      [style.width]="!pageAttributes['content'] ? pageWidth + 'px' : ''"
      [style.height]="!pageAttributes['content'] ? pageHeight + 'px' : ''"
      [class]="model.options.appearance.showPageShadow ? 'stiJsViewerPageShadow' : 'stiJsViewerPage'"
      (touchstart)="eventTouchStart($event)"
      (touchmove)="eventTouchMove($event)"
      (touchend)="eventTouchEnd($event)">
      </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-page',
                    template: `
    <div #element
      style="overflow: hidden; text-align: left; vertical-align: top; color: #000000; box-sizing: content-box; display:inline-block"
      [style.margin]="model.reportParams.viewMode === 'Continuous' ? '10px auto 10px auto' : '10px'"
      [style.display]="this.model.reportParams.viewMode === 'Continuous' ? 'table' : 'inline-block'"
      [style.border]="'1px solid ' + this.model.options.appearance.pageBorderColor"
      [style.background]="pageAttributes['background'] == 'Transparent' || pageAttributes.background == 'rgba(255,255,255,0)' ? 'White' : pageAttributes['background']"
      [style.padding]="pageAttributes['margins']"
      [style.width]="!pageAttributes['content'] ? pageWidth + 'px' : ''"
      [style.height]="!pageAttributes['content'] ? pageHeight + 'px' : ''"
      [class]="model.options.appearance.showPageShadow ? 'stiJsViewerPageShadow' : 'stiJsViewerPage'"
      (touchstart)="eventTouchStart($event)"
      (touchmove)="eventTouchMove($event)"
      (touchend)="eventTouchEnd($event)">
      </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], pageAttributes: [{
                type: Input
            }] } });

class ReportPanelComponent {
    constructor(controller, model, stylesService, interactionService) {
        this.controller = controller;
        this.model = model;
        this.stylesService = stylesService;
        this.interactionService = interactionService;
        this.touchZoomFirstDistance = 0;
        this.touchZoomSecondDistance = 0;
        this.touchZoomValue = 0;
        this.maxHeights = {};
        controller.getMessage().subscribe((message) => {
            if (message.action !== 'viewer_loaded' && this.model.reportParams.pagesArray) {
                if (this.model.reportParams.repaintOnlyDashboardContent) {
                    // jsObject.controls.reportPanel.repaintDashboardContent(parameters);
                }
                else {
                    this.loadPages();
                }
            }
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                setTimeout(() => {
                    if (!this.model.options.isParametersReceived && ((this.model.reportParams.type === 'Report' && this.model.options.toolbar.showParametersButton) || this.model.reportParams.type === 'Dashboard')) {
                        interactionService.postInteraction({ action: 'InitVars' });
                    }
                    if (this.model.reportParams.autoZoom) {
                        this.controller.action({ name: this.model.reportParams.autoZoom === -1 ? 'ZoomPageWidth' : 'ZoomOnePage' });
                        this.model.reportParams.autoZoom = null;
                    }
                });
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.reportPanel.el = this.element;
    }
    loadPages() {
        this.maxHeights = {};
        const pagesArray = this.model.reportParams.pagesArray;
        this.stylesService.setupStyle(pagesArray[pagesArray.length - 2], 'page');
        const chartScript = pagesArray[pagesArray.length - 1];
        this.model.pages = pagesArray.slice(0, pagesArray.length - 2);
        setTimeout(() => {
            this.model.pages.forEach(page => this.interactionService.initializeInteractions(page.page));
            this.interactionService.updateAllHyperLinks();
            this.stylesService.addChartScript(chartScript);
        });
    }
    get position() {
        return this.model.options.heightType !== 'Percentage' || this.model.options.appearance.scrollbarsMode ? 'absolute' : 'relative';
    }
    scroll() {
        if (this.model.pagesNavigationIsActive()) {
            clearTimeout(this.scrollTimeout);
            // update current page number
            this.scrollTimeout = setTimeout(() => {
                let commonPagesHeight = 0;
                let index = 0;
                for (index = 0; index < this.model.pages.length; index++) {
                    commonPagesHeight += this.model.pages[index].page.offsetHeight + 10;
                    if (commonPagesHeight > this.element.nativeElement.scrollTop) {
                        break;
                    }
                }
                if (index < this.model.reportParams.pagesCount && index >= 0 && index !== this.model.reportParams.pageNumber) {
                    this.model.reportParams.pageNumber = index;
                }
            }, 300);
        }
    }
    eventTouchStart(e) {
        this.touchesLength++;
        this.touchStartX = parseInt(e.changedTouches[0].clientX, 10);
        if (this.model.options.appearance.allowTouchZoom && this.touchesLength === 1) {
            this.touchZoomFirstDistance = 0;
            this.touchZoomSecondDistance = 0;
            this.touchZoomValue = 0;
        }
    }
    eventTouchMove(e) {
        if (this.model.options.appearance.allowTouchZoom && e.touches.length > 1) {
            if ('preventDefault' in e) {
                e.preventDefault();
            }
            this.touchZoomSecondDistance = Math.sqrt(Math.pow(e.touches[0].pageX - e.touches[1].pageX, 2) + Math.pow(e.touches[0].pageY - e.touches[1].pageY, 2));
            if (this.touchZoomFirstDistance === 0) {
                this.touchZoomFirstDistance = Math.sqrt(Math.pow(e.touches[0].pageX - e.touches[1].pageX, 2) + Math.pow(e.touches[0].pageY - e.touches[1].pageY, 2));
            }
            const touchZoomOffset = Math.trunc((this.touchZoomSecondDistance - this.touchZoomFirstDistance) / 2.5);
            if (Math.abs(touchZoomOffset) >= 5) {
                this.touchZoomValue = Math.trunc((this.model.reportParams.zoom + touchZoomOffset) / 5) * 5;
                this.touchZoomValue = Math.min(Math.max(this.touchZoomValue, 20), 200);
                this.controller.actionSubject.next({ action: 'centerText', data: this.touchZoomValue.toString() });
            }
        }
    }
    eventTouchEnd(e) {
        if (this.touchesLength > 0) {
            this.touchesLength--;
        }
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            if (Math.trunc(this.touchStartX - e.changedTouches[0].clientX) !== 0) {
                this.controller.keepToolbar();
            }
            else {
                if (!this.model.controls.toolbar.visible) {
                    this.controller.showToolbar();
                }
                else {
                    this.controller.hideToolbar();
                }
            }
        }
        if (this.model.options.appearance.allowTouchZoom && this.touchZoomValue !== 0 && this.touchesLength === 0) {
            this.controller.actionSubject.next({ action: 'hideCenterText' });
            this.model.reportParams.zoom = this.touchZoomValue;
            this.controller.post('GetPages');
        }
    }
}
ReportPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ReportPanelComponent, deps: [{ token: ControllerService }, { token: ModelService }, { token: StylesService }, { token: InteractionsService }], target: i0.ɵɵFactoryTarget.Component });
ReportPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ReportPanelComponent, selector: "sti-report-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
         [style.textAlign]="model.options.appearance.pageAlignment == 'default' ? 'center' : model.options.appearance.pageAlignment"
         [style.top]="0"
         [style.bottom]="0"
         [style.position]="position"
         [style.height]="model.options.heightType != 'Percentage' || model.options.appearance.scrollbarsMode ? 'auto' : 'calc(100% - 35px)'"
         [style.overflow] = "model.reportParams.type == 'Report' && model.options.appearance.scrollbarsMode ? 'auto' : 'hidden'"
         [style.marginTop.px]="model.controls.reportPanel.layout.top"
         [style.marginLeft.px]="model.controls.reportPanel.layout.left"
         [style.marginBottom.px]="position == 'absolute' ? model.controls.reportPanel.layout.bottom : 0"
         [style.paddingBottom.px]="position == 'relative' ? model.controls.reportPanel.layout.bottom : 0"
         [style.transition]="model.options.isMobileDevice ? 'margin 200ms ease' : null"
         (scroll)="scroll()"
         class="stiJsViewerReportPanel"
         (touchstart)="eventTouchStart($event)"
         (touchmove)="eventTouchMove($event)"
         (touchend)="eventTouchEnd($event)">
      <sti-page *ngFor="let page of model.pages" [pageAttributes]="page"></sti-page>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: PageComponent, selector: "sti-page", inputs: ["pageAttributes"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ReportPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-report-panel',
                    template: `
    <div #element
         [style.textAlign]="model.options.appearance.pageAlignment == 'default' ? 'center' : model.options.appearance.pageAlignment"
         [style.top]="0"
         [style.bottom]="0"
         [style.position]="position"
         [style.height]="model.options.heightType != 'Percentage' || model.options.appearance.scrollbarsMode ? 'auto' : 'calc(100% - 35px)'"
         [style.overflow] = "model.reportParams.type == 'Report' && model.options.appearance.scrollbarsMode ? 'auto' : 'hidden'"
         [style.marginTop.px]="model.controls.reportPanel.layout.top"
         [style.marginLeft.px]="model.controls.reportPanel.layout.left"
         [style.marginBottom.px]="position == 'absolute' ? model.controls.reportPanel.layout.bottom : 0"
         [style.paddingBottom.px]="position == 'relative' ? model.controls.reportPanel.layout.bottom : 0"
         [style.transition]="model.options.isMobileDevice ? 'margin 200ms ease' : null"
         (scroll)="scroll()"
         class="stiJsViewerReportPanel"
         (touchstart)="eventTouchStart($event)"
         (touchmove)="eventTouchMove($event)"
         (touchend)="eventTouchEnd($event)">
      <sti-page *ngFor="let page of model.pages" [pageAttributes]="page"></sti-page>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ControllerService }, { type: ModelService }, { type: StylesService }, { type: InteractionsService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

class MenuItem {
    constructor(name, caption, img, type, selected, imageSize, value) {
        this.name = name;
        this.caption = caption;
        this.img = img;
        this.type = type;
        this.selected = selected;
        this.imageSize = imageSize;
        this.value = value;
    }
}
class MenuItemComponent {
    constructor(model) {
        this.model = model;
        this.styleName = 'stiJsViewerMenuStandartItem';
        this.selected = false;
        this.over = false;
        this._enabled = true;
    }
    ngOnInit() { }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    mouseover() {
        if (!this.enabled || !this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled || !this.enabled) {
            return;
        }
        this.over = false;
    }
    get height() {
        if (this.item.imageSize === 'Big') {
            return '38px';
        }
        else {
            return this.model.options.isMobileDevice ? '0.4in' : (this.model.options.isTouchDevice ? '30px' : '24px');
        }
    }
    get className() {
        return this.styleName ? this.styleName + ' ' + (this.enabled ? (this.styleName + ((this.selected || this.item.selected) ? 'Selected' : (this.over ? 'Over' : ''))) : this.styleName + 'Disabled') : '';
    }
}
MenuItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuItemComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
MenuItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: MenuItemComponent, selector: "sti-menu-item", inputs: { item: "item", styleName: "styleName", enabled: "enabled" }, ngImport: i0, template: `
    <div *ngIf="item.type!='separator'" [class]="className" (mouseover)="mouseover()"
         (mouseout)="mouseout()" [style.height]="height">
         <table style="height: 100%; width: 100%" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tr class="stiJsViewerClearAllStyles">
                <td *ngIf="item.img != null && !model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" style="width:22px; min-width:22px; padding: 0; text-align:center; line-height: 0;">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>

                <td *ngIf="item.caption != null" class="stiJsViewerClearAllStyles" style="white-space:nowrap"
                  [style.textAlign]="model.options.appearance.rightToLeft ? 'right' : 'left'"
                  [style.padding]="item.imageSize == 'None' ? '0 20px 0 30px' : '0 20px 0 7px'">
                  {{item.caption}}
                </td>

                <td *ngIf="item.img != null && model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" style="width:22px; min-width:22px; padding: 0; text-align:center; line-height: 0;">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>
            </tr>
         </table>
    </div>
    <div *ngIf="item.type=='separator'" class="stiJsViewerVerticalMenuSeparator" [style.margin]="item.imageSize == 'Big' ? '1px 2px 1px 2px' : ''">
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuItemComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-menu-item',
                    template: `
    <div *ngIf="item.type!='separator'" [class]="className" (mouseover)="mouseover()"
         (mouseout)="mouseout()" [style.height]="height">
         <table style="height: 100%; width: 100%" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tr class="stiJsViewerClearAllStyles">
                <td *ngIf="item.img != null && !model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" style="width:22px; min-width:22px; padding: 0; text-align:center; line-height: 0;">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>

                <td *ngIf="item.caption != null" class="stiJsViewerClearAllStyles" style="white-space:nowrap"
                  [style.textAlign]="model.options.appearance.rightToLeft ? 'right' : 'left'"
                  [style.padding]="item.imageSize == 'None' ? '0 20px 0 30px' : '0 20px 0 7px'">
                  {{item.caption}}
                </td>

                <td *ngIf="item.img != null && model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" style="width:22px; min-width:22px; padding: 0; text-align:center; line-height: 0;">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>
            </tr>
         </table>
    </div>
    <div *ngIf="item.type=='separator'" class="stiJsViewerVerticalMenuSeparator" [style.margin]="item.imageSize == 'Big' ? '1px 2px 1px 2px' : ''">
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; }, propDecorators: { item: [{
                type: Input
            }], styleName: [{
                type: Input
            }], enabled: [{
                type: Input
            }] } });

class ParameterTextBoxComponent {
    constructor(helper, model) {
        this.helper = helper;
        this.model = model;
        this.focusOnCreate = false;
        this.isMenu = false;
        this.value = '';
        this.secondTextBox = false;
    }
    ngOnInit() { }
    onchange(target) {
        if (this.element.oldValue === target.value) {
            return;
        }
        const value = this.getValue(target);
        if (this.isMenu) {
            if (!this.secondTextBox) {
                this.item.key = value;
            }
            else {
                this.item.keyTo = value;
            }
        }
        else {
            if (!this.secondTextBox) {
                if (this.variable.basicType === 'Range' || this.variable.type === 'DateTime') {
                    this.variable.key = value;
                }
                else {
                    this.variable.value = value;
                    if (this.variable.basicType === 'Value') {
                        this.variable.key = value;
                    }
                }
            }
            else {
                this.variable.keyTo = value;
            }
        }
    }
    getValue(target) {
        if (this.variable.type === 'DateTime') {
            if (this.element.oldValue === target.value) {
                return;
            }
            try {
                const timeString = new Date().toLocaleTimeString();
                const isAmericanFormat = timeString.toLowerCase().indexOf('am') >= 0 || timeString.toLowerCase().indexOf('pm') >= 0;
                const formatDate = isAmericanFormat ? 'MM/dd/yyyy' : 'dd.MM.yyyy';
                let format = formatDate + (isAmericanFormat ? ' h:mm:ss tt' : ' hh:mm:ss');
                if (this.variable.dateTimeType === 'Date') {
                    format = formatDate;
                }
                if (this.variable.dateTimeType === 'Time') {
                    format = 'hh:mm:ss';
                }
                const date = this.helper.getDateTimeFromString(target.value, this.model.options.appearance.parametersPanelDateFormat || format);
                return this.helper.getDateTimeObject(date);
            }
            catch (e) {
                alert(e);
            }
        }
        else {
            return target.value;
        }
    }
    get width() {
        let width = 210;
        if (this.variable.basicType === 'Range') {
            width = 140;
            if (this.variable.type === 'Guid' || this.variable.type === 'String') {
                width = 190;
            }
            if (this.variable.type === 'DateTime') {
                width = 235;
            }
            if (this.variable.type === 'Char') {
                width = 60;
            }
        }
        else {
            if (this.variable.type === 'Guid') {
                width = 265;
            }
            else {
                width = 210;
            }
        }
        return width;
    }
    get color() {
        return !this.variable.isNull
            ? (this.model.options.toolbar.fontColor && this.model.options.toolbar.fontColor !== 'Empty' ? this.model.options.toolbar.fontColor : '#444444')
            : this.variable.type === 'DateTime' ? 'transparent' : '#c6c6c6';
    }
}
ParameterTextBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterTextBoxComponent, deps: [{ token: HelperService }, { token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
ParameterTextBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterTextBoxComponent, selector: "sti-parameter-text-box", inputs: { item: "item", variable: "variable", readOnly: "readOnly", focusOnCreate: "focusOnCreate", isMenu: "isMenu", value: "value", secondTextBox: "secondTextBox" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <sti-text-box #element
      [maxLength]="variable.type === 'Char' ? 1 : ''"
      [value]="isMenu ? helper.getStringKey(item.key, variable): value"
      [width]="width"
      [readOnly]="readOnly"
      [focusOnCreate]="focusOnCreate"
      [enabled]="!variable?.isNull"
      [color]="color"
      [variable]="variable"
      (onblur)="onchange($event)">
    </sti-text-box>
  `, isInline: true, dependencies: [{ kind: "component", type: TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterTextBoxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-text-box',
                    template: `
    <sti-text-box #element
      [maxLength]="variable.type === 'Char' ? 1 : ''"
      [value]="isMenu ? helper.getStringKey(item.key, variable): value"
      [width]="width"
      [readOnly]="readOnly"
      [focusOnCreate]="focusOnCreate"
      [enabled]="!variable?.isNull"
      [color]="color"
      [variable]="variable"
      (onblur)="onchange($event)">
    </sti-text-box>
  `
                }]
        }], ctorParameters: function () { return [{ type: HelperService }, { type: ModelService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], item: [{
                type: Input
            }], variable: [{
                type: Input
            }], readOnly: [{
                type: Input
            }], focusOnCreate: [{
                type: Input
            }], isMenu: [{
                type: Input
            }], value: [{
                type: Input
            }], secondTextBox: [{
                type: Input
            }] } });

class ParameterButtonComponent {
    constructor(model) {
        this.model = model;
        this.action = new EventEmitter();
    }
    ngOnInit() { }
    onaction() {
        this.action.emit(this.params);
    }
}
ParameterButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterButtonComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
ParameterButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterButtonComponent, selector: "sti-parameter-button", inputs: { params: "params", buttonType: "buttonType" }, outputs: { action: "action" }, ngImport: i0, template: `
    <sti-button [imageName]="buttonType + '.png'"
        [styleName]="'stiJsViewerFormButton'"
        [height]="model.options.isTouchDevice ? '26px' : '21px'"
        [innerTableWidth]="'100%'"
        [enabled]="!params?.isNull"
        (action)="onaction()">
    </sti-button>
  `, isInline: true, dependencies: [{ kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-button',
                    template: `
    <sti-button [imageName]="buttonType + '.png'"
        [styleName]="'stiJsViewerFormButton'"
        [height]="model.options.isTouchDevice ? '26px' : '21px'"
        [innerTableWidth]="'100%'"
        [enabled]="!params?.isNull"
        (action)="onaction()">
    </sti-button>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; }, propDecorators: { params: [{
                type: Input
            }], buttonType: [{
                type: Input
            }], action: [{
                type: Output
            }] } });

class ParameterMenuItemComponent {
    constructor(model) {
        this.model = model;
        this.action = new EventEmitter();
        this.active = true;
        this.padding = '0px 5px';
        this.isOver = false;
        this.mouseDown = false;
    }
    ngOnInit() { }
    mouseover() {
        this.isOver = true;
    }
    mouseout() {
        this.isOver = false;
        this.mouseDown = false;
    }
    mousedown() {
        this.mouseDown = true;
    }
    mouseup() {
        this.mouseDown = false;
        this.action.emit();
    }
    get className() {
        return this.active ? this.mouseDown ? 'stiJsViewerParametersMenuItemPressed' : (this.isOver ? 'stiJsViewerParametersMenuItemOver' : 'stiJsViewerParametersMenuItem') : 'stiJsViewerParametersMenuItem';
    }
}
ParameterMenuItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuItemComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: { active: "active", padding: "padding" }, outputs: { action: "action" }, ngImport: i0, template: `
      <div [class]="className"
        [style.height.px]="model.options.isTouchDevice ? 30 : 24"
        (mouseover)="mouseover()"
        (mouseout)="mouseout()"
        (mousedown)="mousedown()"
        (mouseup)="mouseup()">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuItemInnerTable" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" [style.padding]="padding">
                <ng-content>
                </ng-content>
              </td>
            </tr>
          </tbody>
        </table>

      </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuItemComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-item',
                    template: `
      <div [class]="className"
        [style.height.px]="model.options.isTouchDevice ? 30 : 24"
        (mouseover)="mouseover()"
        (mouseout)="mouseout()"
        (mousedown)="mousedown()"
        (mouseup)="mouseup()">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuItemInnerTable" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" [style.padding]="padding">
                <ng-content>
                </ng-content>
              </td>
            </tr>
          </tbody>
        </table>

      </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; }, propDecorators: { action: [{
                type: Output
            }], active: [{
                type: Input
            }], padding: [{
                type: Input
            }] } });

class ParameterMenuSeparatorComponent {
    constructor() { }
    ngOnInit() { }
}
ParameterMenuSeparatorComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuSeparatorComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuSeparatorComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator", ngImport: i0, template: `
        <div class="stiJsViewerParametersMenuSeparator">
        </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuSeparatorComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-separator',
                    template: `
        <div class="stiJsViewerParametersMenuSeparator">
        </div>
  `
                }]
        }], ctorParameters: function () { return []; } });

class ParameterMenuEditListComponent {
    constructor(model, helper, menuService) {
        this.model = model;
        this.helper = helper;
        this.menuService = menuService;
    }
    ngOnInit() { }
    newItem(event) {
        const item = new Variable();
        if (this.menu.params.type === 'DateTime') {
            item.key = this.helper.getDateTimeObject();
            item.value = this.helper.dateTimeObjectToString(item.key);
        }
        else if (this.menu.params.type === 'TimeSpan') {
            item.key = '00:00:00';
            item.value = '00:00:00';
        }
        else if (this.menu.params.type === 'Bool') {
            item.key = 'False';
            item.value = 'False';
        }
        else {
            item.key = '';
            item.value = '';
        }
        item.focusOnCreate = true;
        if (!this.menu.params.items) {
            this.menu.params.items = [];
        }
        this.menu.params.items.push(item);
        setTimeout(() => {
            item.focusOnCreate = false;
        });
    }
    dateTimeButtonAction(item) {
        this.menuService.addMenu({
            type: 'datePickerMenu', name: 'datePickerMenu', items: [], parent: this.dateTimeButton,
            params: item,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu('datePickerMenu');
        });
    }
    guidButtonAction(item) {
        item.key = this.helper.newGuid();
    }
    removeButtonAction(item) {
        this.menu.params.items.splice(this.menu.params.items.indexOf(item), 1);
    }
    removeAllAction() {
        this.menu.params.items.splice(0, this.menu.params.items.length);
    }
    closeAction() {
        this.menu.state = 'initialDown';
    }
}
ParameterMenuEditListComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuEditListComponent, deps: [{ token: ModelService }, { token: HelperService }, { token: MenuService }], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuEditListComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuEditListComponent, selector: "sti-parameter-menu-edit-list", inputs: { menu: "menu" }, viewQueries: [{ propertyName: "dateTimeButton", first: true, predicate: ["dateTimeButton"], descendants: true }], ngImport: i0, template: `
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontSize]="'12px'"
        [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <!--New Item Button -->
                <sti-parameter-menu-item (action)="newItem($event)">
                  {{model.loc('NewItem')}}
                </sti-parameter-menu-item>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-parameter-menu-item *ngFor="let item of menu.params.items" [active]="false">
                  <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                    <tbody>
                      <tr class="stiJsViewerClearAllStyles">
                         <td class="stiJsViewerClearAllStyles" style="padding: 0px 1px 0px 0px;">
                            <sti-parameter-text-box [item]="item" [isMenu]="true"
                              [variable]="menu.params" [focusOnCreate]="item.focusOnCreate">
                            </sti-parameter-text-box>
                         </td>

                         <td *ngIf="menu.params.type == 'DateTime'" class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;" #dateTimeButton>
                           <sti-parameter-button [buttonType]="'DateTimeButton'" (action)="dateTimeButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td *ngIf="menu.params.type == 'Guid'" class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;">
                           <sti-parameter-button [buttonType]="'GuidButton'" (action)="guidButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;">
                           <sti-parameter-button [buttonType]="'RemoveItemButton'" (action)="removeButtonAction(item)" [params]="item">
                           </sti-parameter-button>
                         </td>
                       </tr>
                     </tbody>
                  </table>
                </sti-parameter-menu-item>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item (action)="removeAllAction()">
                      {{model.loc('RemoveAll')}}
                  </sti-parameter-menu-item>

                  <sti-parameter-menu-separator></sti-parameter-menu-separator>

                  <sti-parameter-menu-item (action)="closeAction()">
                      {{model.loc('Close')}}
                  </sti-parameter-menu-item>
              </td>
            </tr>
          </tbody>
        </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ParameterTextBoxComponent, selector: "sti-parameter-text-box", inputs: ["item", "variable", "readOnly", "focusOnCreate", "isMenu", "value", "secondTextBox"] }, { kind: "component", type: ParameterButtonComponent, selector: "sti-parameter-button", inputs: ["params", "buttonType"], outputs: ["action"] }, { kind: "component", type: ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuEditListComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-edit-list',
                    template: `
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontSize]="'12px'"
        [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <!--New Item Button -->
                <sti-parameter-menu-item (action)="newItem($event)">
                  {{model.loc('NewItem')}}
                </sti-parameter-menu-item>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-parameter-menu-item *ngFor="let item of menu.params.items" [active]="false">
                  <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                    <tbody>
                      <tr class="stiJsViewerClearAllStyles">
                         <td class="stiJsViewerClearAllStyles" style="padding: 0px 1px 0px 0px;">
                            <sti-parameter-text-box [item]="item" [isMenu]="true"
                              [variable]="menu.params" [focusOnCreate]="item.focusOnCreate">
                            </sti-parameter-text-box>
                         </td>

                         <td *ngIf="menu.params.type == 'DateTime'" class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;" #dateTimeButton>
                           <sti-parameter-button [buttonType]="'DateTimeButton'" (action)="dateTimeButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td *ngIf="menu.params.type == 'Guid'" class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;">
                           <sti-parameter-button [buttonType]="'GuidButton'" (action)="guidButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;">
                           <sti-parameter-button [buttonType]="'RemoveItemButton'" (action)="removeButtonAction(item)" [params]="item">
                           </sti-parameter-button>
                         </td>
                       </tr>
                     </tbody>
                  </table>
                </sti-parameter-menu-item>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item (action)="removeAllAction()">
                      {{model.loc('RemoveAll')}}
                  </sti-parameter-menu-item>

                  <sti-parameter-menu-separator></sti-parameter-menu-separator>

                  <sti-parameter-menu-item (action)="closeAction()">
                      {{model.loc('Close')}}
                  </sti-parameter-menu-item>
              </td>
            </tr>
          </tbody>
        </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }, { type: MenuService }]; }, propDecorators: { dateTimeButton: [{
                type: ViewChild,
                args: ['dateTimeButton']
            }], menu: [{
                type: Input
            }] } });

class TextBlockComponent {
    constructor(model) {
        this.model = model;
    }
    ngOnInit() { }
}
TextBlockComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextBlockComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
TextBlockComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: TextBlockComponent, selector: "sti-text-block", inputs: { text: "text", margin: "margin" }, ngImport: i0, template: `
    <div [style]="{fontFamily: model.options.toolbar.fontFamily, fontSize: '12px', paddingTop: '2px', margin: margin}">
      {{text || ''}}
    </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextBlockComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-text-block',
                    template: `
    <div [style]="{fontFamily: model.options.toolbar.fontFamily, fontSize: '12px', paddingTop: '2px', margin: margin}">
      {{text || ''}}
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; }, propDecorators: { text: [{
                type: Input
            }], margin: [{
                type: Input
            }] } });

class ParameterFindComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    onchange(event) {
        const text = event.value.toLowerCase();
        this.variable.items.forEach((item) => {
            const itemText = this.helper.val(item.value, this.helper.getStringKey(item.key, this.variable)).toLowerCase();
            item.visible = itemText.indexOf(text) >= 0;
        });
    }
}
ParameterFindComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterFindComponent, deps: [{ token: ModelService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
ParameterFindComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterFindComponent, selector: "sti-parameter-find", inputs: { variable: "variable" }, ngImport: i0, template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding-left: 8px;">
                <sti-text-block [text]="model.loc('FindWhat')"></sti-text-block>
              </td>

              <td class="stiJsViewerClearAllStyles" style="padding-left: 8px;">
                <sti-text-box [width]="80"
                  [margin]="'4px'"
                  [focusOnCreate]="true"
                  (onchange)="onchange($event)">
                </sti-text-box>
              </td>
            </tr>
          </tbody>
      </table>

  `, isInline: true, dependencies: [{ kind: "component", type: TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: TextBlockComponent, selector: "sti-text-block", inputs: ["text", "margin"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterFindComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-find',
                    template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding-left: 8px;">
                <sti-text-block [text]="model.loc('FindWhat')"></sti-text-block>
              </td>

              <td class="stiJsViewerClearAllStyles" style="padding-left: 8px;">
                <sti-text-box [width]="80"
                  [margin]="'4px'"
                  [focusOnCreate]="true"
                  (onchange)="onchange($event)">
                </sti-text-box>
              </td>
            </tr>
          </tbody>
      </table>

  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }]; }, propDecorators: { variable: [{
                type: Input
            }] } });

class ParameterMenuNotEditListComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    selectAll() {
        const isAllSelected = this.isAllSelected();
        if (this.menu.params.items) {
            this.menu.params.items.forEach(e => e.isChecked = !isAllSelected);
        }
    }
    isAllSelected() {
        return this.menu.params.items.every(e => e.isChecked);
    }
    check(item) {
        item.isChecked = !item.isChecked;
    }
    closeAction() {
        this.menu.state = 'initialDown';
    }
}
ParameterMenuNotEditListComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuNotEditListComponent, deps: [{ token: ModelService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuNotEditListComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuNotEditListComponent, selector: "sti-parameter-menu-not-edit-list", inputs: { menu: "menu" }, ngImport: i0, template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px; overflow: hidden auto;">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-check-box [captionText]="model.loc('SelectAll')"
                    [margin]="'8px 7px 8px 7px'"
                    [isChecked]="isAllSelected()"
                    (action)="selectAll()" >
                  </sti-check-box>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-checkbox [params]="item"
                                      [captionText]="helper.val(item.value, helper.getStringKey(item.key, menu.params))"
                                      [margin]="'0 5px 0 0'"
                                      [width]="'100%'"
                                      [imageBlockParentWidth]="'1px'"
                                      [isMenuParameter]="true"
                                      (action)="check(item)">
                                  </sti-parameter-checkbox>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                    <sti-parameter-menu-item [padding]="'0px 5px 0px 13px'" (action)="closeAction()">
                      {{model.loc('Close')}}
                    </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }, { kind: "component", type: ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: ["params", "captionText", "margin", "width", "imageBlockParentWidth", "isEnabled", "isMenuParameter", "paramNull", "nullable"], outputs: ["action"] }, { kind: "component", type: ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }, { kind: "component", type: ParameterFindComponent, selector: "sti-parameter-find", inputs: ["variable"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuNotEditListComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-not-edit-list',
                    template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px; overflow: hidden auto;">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-check-box [captionText]="model.loc('SelectAll')"
                    [margin]="'8px 7px 8px 7px'"
                    [isChecked]="isAllSelected()"
                    (action)="selectAll()" >
                  </sti-check-box>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-checkbox [params]="item"
                                      [captionText]="helper.val(item.value, helper.getStringKey(item.key, menu.params))"
                                      [margin]="'0 5px 0 0'"
                                      [width]="'100%'"
                                      [imageBlockParentWidth]="'1px'"
                                      [isMenuParameter]="true"
                                      (action)="check(item)">
                                  </sti-parameter-checkbox>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                    <sti-parameter-menu-item [padding]="'0px 5px 0px 13px'" (action)="closeAction()">
                      {{model.loc('Close')}}
                    </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }]; }, propDecorators: { menu: [{
                type: Input
            }] } });

class ParameterMenuForValueComponent {
    constructor(model, helper, intearctionService) {
        this.model = model;
        this.helper = helper;
        this.intearctionService = intearctionService;
    }
    ngOnInit() { }
    action(item) {
        this.menu.params.value = this.menu.params.allowUserValues ? item.key : item.value;
        this.menu.params.key = item.key;
        this.menu.params.isChanged = true;
        this.menu.state = 'initialDown';
        if (this.menu.params.binding) {
            if (!this.model.options.paramsVariablesStartValues) {
                this.model.options.paramsVariablesStartValues = this.helper.copyObject(this.model.options.paramsVariables);
            }
            this.intearctionService.postInteraction({ action: 'InitVars', variables: this.intearctionService.getParametersValues() });
        }
    }
    getValue(item) {
        return (item.value !== '' && this.menu.params.type !== 'DateTime' && this.menu.params.type !== 'TimeSpan')
            ? item.value
            : this.helper.getStringKey(item.key, this.menu.params);
    }
}
ParameterMenuForValueComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuForValueComponent, deps: [{ token: ModelService }, { token: HelperService }, { token: InteractionsService }], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuForValueComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuForValueComponent, selector: "sti-parameter-menu-for-value", inputs: { menu: "menu" }, ngImport: i0, template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px" [style.overflow]="menu.params.items.length > 10 ? 'hidden auto' : 'hidden'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-menu-item (action)="action(item)">
                                    {{getValue(item)}}
                                  </sti-parameter-menu-item>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }, { kind: "component", type: ParameterFindComponent, selector: "sti-parameter-find", inputs: ["variable"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuForValueComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-for-value',
                    template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px" [style.overflow]="menu.params.items.length > 10 ? 'hidden auto' : 'hidden'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-menu-item (action)="action(item)">
                                    {{getValue(item)}}
                                  </sti-parameter-menu-item>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }, { type: InteractionsService }]; }, propDecorators: { menu: [{
                type: Input
            }] } });

class ParameterMenuForRangeComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    action(item) {
        this.menu.params.key = item.key;
        this.menu.params.keyTo = item.keyTo;
        this.menu.state = 'initialDown';
    }
    getValue(item) {
        return `${item.value} [${this.helper.getStringKey(item.key, this.menu.params)} - ${this.helper.getStringKey(item.keyTo, this.menu.params)}]`;
    }
}
ParameterMenuForRangeComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuForRangeComponent, deps: [{ token: ModelService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuForRangeComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuForRangeComponent, selector: "sti-parameter-menu-for-range", inputs: { menu: "menu" }, ngImport: i0, template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px" [style.overflow]="menu.params.items.length > 10 ? 'hidden auto' : 'hidden'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-menu-item (action)="action(item)">
                                    {{getValue(item)}}
                                  </sti-parameter-menu-item>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }, { kind: "component", type: ParameterFindComponent, selector: "sti-parameter-find", inputs: ["variable"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuForRangeComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-for-range',
                    template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px" [style.overflow]="menu.params.items.length > 10 ? 'hidden auto' : 'hidden'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-menu-item (action)="action(item)">
                                    {{getValue(item)}}
                                  </sti-parameter-menu-item>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }]; }, propDecorators: { menu: [{
                type: Input
            }] } });

class DropDownListComponent {
    constructor(model, mouseService, menuService) {
        this.model = model;
        this.mouseService = mouseService;
        this.menuService = menuService;
        this.showImage = false;
        this.action = new EventEmitter();
        this.over = false;
        this._readOnly = false;
        this._enabled = true;
        this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.hideListMenu();
        });
    }
    ngOnInit() { }
    set readOnly(value) {
        this._readOnly = value;
        setTimeout(() => {
            try {
                this.input.nativeElement.setAttribute('unselectable', value ? 'on' : 'off');
                this.input.nativeElement.setAttribute('onselectstart', value ? 'return false' : '');
                this.input.nativeElement.readOnly = value;
            }
            catch (e) { }
        });
    }
    get readOnly() {
        return this._readOnly;
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    get key() {
        return this._key;
    }
    set key(key) {
        if (this.items != null) {
            this.items.forEach(i => i.selected = i.key === key);
        }
        this._key = key;
    }
    get inputValue() {
        var _a;
        if (this.items != null) {
            return ((_a = this.items.find(i => i.key === this._key)) === null || _a === void 0 ? void 0 : _a.caption) || '';
        }
        return '';
    }
    get selected() {
        const vm = this.menuService.getVerticalMenu();
        return (vm === null || vm === void 0 ? void 0 : vm.state) === 'expanded' && (vm === null || vm === void 0 ? void 0 : vm.parent) === this.element;
    }
    get className() {
        return this.selected ? 'stiJsViewerDropDownListOver' : (this.enabled ? (this.over ? 'stiJsViewerDropDownListOver' : 'stiJsViewerDropDownList') : 'stiJsViewerDropDownListDisabled');
    }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
    }
    inputClick() {
        if (this.readOnly) {
            this.showListMenu();
        }
    }
    showListMenu() {
        this.menuService.addMenu({
            type: this.menuService.VERTICAL_MENU_NAME, name: this.menuService.VERTICAL_MENU_NAME, items: [], parent: this.element,
            verticalItems: this.items, itemStyleName: 'stiJsViewerMenuStandartItem', menuStyleName: 'stiJsViewerDropdownMenu',
            action: this.action, width: this.element.nativeElement.offsetWidth,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu(this.menuService.VERTICAL_MENU_NAME);
        });
    }
    hideListMenu() {
        if (this.menuService.getVerticalMenu()) {
            this.menuService.getVerticalMenu().state = 'initialDown';
        }
    }
}
DropDownListComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DropDownListComponent, deps: [{ token: ModelService }, { token: MouseService }, { token: MenuService }], target: i0.ɵɵFactoryTarget.Component });
DropDownListComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DropDownListComponent, selector: "sti-drop-down-list", inputs: { toolTip: "toolTip", showImage: "showImage", width: "width", margin: "margin", items: "items", styleDisplay: "styleDisplay", verticalAlign: "verticalAlign", readOnly: "readOnly", enabled: "enabled", key: "key" }, outputs: { action: "action" }, viewQueries: [{ propertyName: "input", first: true, predicate: ["input"], descendants: true }, { propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
        <table #element [class]="className" cellpadding="0" cellspacing="0"
              [style.fontFamily]="model.options.toolbar.fontFamily"
              [style.color]="model.options.toolbar.fontColor"
              [style.margin]="margin"
              [style.verticalAlign]="verticalAlign"
              [style.display]="styleDisplay"
              [attr.title]="toolTip"
              (mouseover)="mouseover()"
              (mouseout)="mouseout()">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <input #input
                [style.width.px]="width - (model.options.isTouchDevice ? 23 : 15) - (showImage ? 38 : 0)"
                [style.border]="0"
                [style.cursor]="readOnly ? 'default' : 'text'"
                [style.fontFamily]="model.options.toolbar.fontFamily"
                [style.color]="model.options.toolbar.fontColor"
                [style.height]="model.options.isTouchDevice ? '23px' : '18px'"
                [style.lineHeight]="model.options.isTouchDevice ? '23px' : '18px'"
                [style.visibility]="enabled ? 'visible' : 'hidden'"
                [value]="inputValue"
                (click)="inputClick()"
                class="stiJsViewerDropDownList_TextBox">
              </td>

              <td class="stiJsViewerClearAllStyles">
                  <sti-button [imageName]="'Arrows.' + (model.options.isTouchDevice ? 'Big' : 'Small') + 'ArrowDown.png'"
                     [styleName]="'stiJsViewerDropDownListButton'"
                     [imageSizesWidth]="model.options.isTouchDevice ? 16 : 8"
                     [imageSizesHeight]="model.options.isTouchDevice ? 16 : 8"
                     [height]="model.options.isTouchDevice ? '26px' : '21px'"
                     [enabled]="enabled"
                     [selected]="selected"
                     [margin]="'0'"
                     (action)="showListMenu()">
                  </sti-button>
              </td>
            </tr>
          </tbody>
        </table>

  `, isInline: true, dependencies: [{ kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DropDownListComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-drop-down-list',
                    template: `
        <table #element [class]="className" cellpadding="0" cellspacing="0"
              [style.fontFamily]="model.options.toolbar.fontFamily"
              [style.color]="model.options.toolbar.fontColor"
              [style.margin]="margin"
              [style.verticalAlign]="verticalAlign"
              [style.display]="styleDisplay"
              [attr.title]="toolTip"
              (mouseover)="mouseover()"
              (mouseout)="mouseout()">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <input #input
                [style.width.px]="width - (model.options.isTouchDevice ? 23 : 15) - (showImage ? 38 : 0)"
                [style.border]="0"
                [style.cursor]="readOnly ? 'default' : 'text'"
                [style.fontFamily]="model.options.toolbar.fontFamily"
                [style.color]="model.options.toolbar.fontColor"
                [style.height]="model.options.isTouchDevice ? '23px' : '18px'"
                [style.lineHeight]="model.options.isTouchDevice ? '23px' : '18px'"
                [style.visibility]="enabled ? 'visible' : 'hidden'"
                [value]="inputValue"
                (click)="inputClick()"
                class="stiJsViewerDropDownList_TextBox">
              </td>

              <td class="stiJsViewerClearAllStyles">
                  <sti-button [imageName]="'Arrows.' + (model.options.isTouchDevice ? 'Big' : 'Small') + 'ArrowDown.png'"
                     [styleName]="'stiJsViewerDropDownListButton'"
                     [imageSizesWidth]="model.options.isTouchDevice ? 16 : 8"
                     [imageSizesHeight]="model.options.isTouchDevice ? 16 : 8"
                     [height]="model.options.isTouchDevice ? '26px' : '21px'"
                     [enabled]="enabled"
                     [selected]="selected"
                     [margin]="'0'"
                     (action)="showListMenu()">
                  </sti-button>
              </td>
            </tr>
          </tbody>
        </table>

  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: MouseService }, { type: MenuService }]; }, propDecorators: { input: [{
                type: ViewChild,
                args: ['input']
            }], element: [{
                type: ViewChild,
                args: ['element']
            }], toolTip: [{
                type: Input
            }], showImage: [{
                type: Input
            }], width: [{
                type: Input
            }], margin: [{
                type: Input
            }], items: [{
                type: Input
            }], styleDisplay: [{
                type: Input
            }], verticalAlign: [{
                type: Input
            }], action: [{
                type: Output
            }], readOnly: [{
                type: Input
            }], enabled: [{
                type: Input
            }], key: [{
                type: Input
            }] } });

class DatePickerDayButtonComponent {
    constructor(model, helper, menuService) {
        this.model = model;
        this.helper = helper;
        this.menuService = menuService;
        this.caption = '';
        this.enabled = false;
        this.selected = false;
        this.closeOnAction = true;
    }
    action() {
        this.date.day = this.row * 7 + this.col - this.getFirstDay() + 1;
        if (this.closeOnAction && this.menuService.getMenu('datePickerMenu') != null) {
            this.menuService.getMenu('datePickerMenu').state = 'initialUp';
        }
    }
    getFirstDay() {
        let firstDay = new Date(this.date.year, this.date.month - 1, 1).getDay();
        if (firstDay === 0) {
            firstDay = 7;
        }
        if (this.model.options.appearance.datePickerFirstDayOfWeek !== 'Sunday') {
            firstDay--;
        }
        return firstDay;
    }
    ngOnInit() { }
}
DatePickerDayButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DatePickerDayButtonComponent, deps: [{ token: ModelService }, { token: HelperService }, { token: MenuService }], target: i0.ɵɵFactoryTarget.Component });
DatePickerDayButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DatePickerDayButtonComponent, selector: "sti-date-picker-day-button", inputs: { col: "col", row: "row", caption: "caption", enabled: "enabled", selected: "selected", date: "date", closeOnAction: "closeOnAction" }, ngImport: i0, template: `
    <sti-button [styleName]="'stiJsViewerDatePickerDayButton'"
                [width]="model.options.isTouchDevice ? '25px' : '23px'"
                [height]="model.options.isTouchDevice ? '25px' : '23px'"
                [captionAlign]="'center'"
                [innerTableWidth]="'100%'"
                [captionPadding]="'0px'"
                [margin]="'1px'"
                [caption]="caption"
                [enabled]="enabled"
                [selected]="selected"
                (action)="action()">
    </sti-button>
  `, isInline: true, dependencies: [{ kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DatePickerDayButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-date-picker-day-button',
                    template: `
    <sti-button [styleName]="'stiJsViewerDatePickerDayButton'"
                [width]="model.options.isTouchDevice ? '25px' : '23px'"
                [height]="model.options.isTouchDevice ? '25px' : '23px'"
                [captionAlign]="'center'"
                [innerTableWidth]="'100%'"
                [captionPadding]="'0px'"
                [margin]="'1px'"
                [caption]="caption"
                [enabled]="enabled"
                [selected]="selected"
                (action)="action()">
    </sti-button>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }, { type: MenuService }]; }, propDecorators: { col: [{
                type: Input
            }], row: [{
                type: Input
            }], caption: [{
                type: Input
            }], enabled: [{
                type: Input
            }], selected: [{
                type: Input
            }], date: [{
                type: Input
            }], closeOnAction: [{
                type: Input
            }] } });

class DatePickerMenuComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
        this.keyTo = false;
        this.closeOnAction = true;
        this.monthesForDatePickerItems = [];
        this.cols = [0, 1, 2, 3, 4, 5, 6];
        this.rows = [0, 1, 2, 3, 4, 5];
        this.model.months.forEach((m, i) => this.monthesForDatePickerItems.push({ name: 'Month' + i, caption: this.model.loc('Month' + m), key: i }));
        const firstLetters = {};
        this.model.dayOfWeek.forEach((d) => {
            const dayName = this.model.loc('Day' + d);
            firstLetters[dayName.toString().substring(0, 1).toUpperCase()] = true;
        });
        this.countLetters = Object.keys(firstLetters).length < 5 ? 2 : 1;
    }
    ngOnInit() { }
    getButtonSelected(col, row) {
        const firstDay = this.getFirstDay();
        const curDay = row * 7 + col;
        const day = curDay - firstDay + 1;
        return day === this.key.day;
    }
    getButtonCaption(col, row) {
        const firstDay = this.getFirstDay();
        const daysInMonth = this.helper.getCountDaysOfMonth(this.key.year, this.key.month - 1);
        const curDay = row * 7 + col;
        const day = curDay - firstDay + 1;
        if (curDay >= firstDay && day <= daysInMonth) {
            return day.toString();
        }
        return '';
    }
    getTime() {
        return this.helper.formatDate(this.helper.getDate(this.key), 'H:mm:ss');
    }
    getFirstDay() {
        let firstDay = new Date(this.key.year, this.key.month - 1, 1).getDay();
        if (firstDay === 0) {
            firstDay = 7;
        }
        if (this.model.options.appearance.datePickerFirstDayOfWeek !== 'Sunday') {
            firstDay--;
        }
        return firstDay;
    }
    get showTime() {
        var _a, _b;
        return ((_b = (_a = this.menu) === null || _a === void 0 ? void 0 : _a.params) === null || _b === void 0 ? void 0 : _b.dateTimeType) !== 'Date';
    }
    get key() {
        return this.keyTo ? this.menu.params.keyTo : this.menu.params.key;
    }
    yearAction(input) {
        try {
            this.key.year = parseInt(input.value, 10);
        }
        catch (_a) { }
    }
    timeAction(input) {
        const time = this.helper.stringToTime(input.value);
        this.key.seconds = time.seconds;
        this.key.minutes = time.minutes;
        this.key.hours = time.hours;
    }
    getShortDayName(index) {
        const dayName = this.model.loc('Day' + this.model.dayOfWeek[index]);
        if (dayName) {
            return dayName.toString().substring(0, this.countLetters <= dayName.length ? this.countLetters : 1).toUpperCase();
        }
        return '';
    }
    getShortDayColor(index) {
        if (index === (this.model.options.appearance.datePickerFirstDayOfWeek === 'Sunday' ? 6 : 5)) {
            return '#0000ff';
        }
        if (index === (this.model.options.appearance.datePickerFirstDayOfWeek === 'Sunday' ? 0 : 6)) {
            return '#ff0000';
        }
        return '';
    }
    prevMonthButtonAction() {
        let month = this.key.month;
        let year = this.key.year;
        month--;
        if (month === 0) {
            month = 12;
            year--;
        }
        const countDaysInMonth = this.helper.getCountDaysOfMonth(year, month - 1);
        if (countDaysInMonth < this.key.day) {
            this.key.day = countDaysInMonth;
        }
        this.key.month = month;
        this.key.year = year;
    }
    nextMonthButtonAction() {
        let month = this.key.month;
        let year = this.key.year;
        month++;
        if (month === 13) {
            month = 1;
            year++;
        }
        const countDaysInMonth = this.helper.getCountDaysOfMonth(year, month - 1);
        if (countDaysInMonth < this.key.day) {
            this.key.day = countDaysInMonth;
        }
        this.key.month = month;
        this.key.year = year;
    }
}
DatePickerMenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DatePickerMenuComponent, deps: [{ token: ModelService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
DatePickerMenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DatePickerMenuComponent, selector: "sti-date-picker-menu", inputs: { menu: "menu", keyTo: "keyTo", closeOnAction: "closeOnAction" }, ngImport: i0, template: `
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-button [imageName]="'Arrows.BigArrowLeft.png'" [margin]="'1px 2px 0 1px'" (action)="prevMonthButtonAction()">
                </sti-button>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-drop-down-list
                  [width]="model.options.isTouchDevice ? 79 : 81"
                  [readOnly]="true"
                  [margin]="'1px 2px 0 0'"
                  [items]="monthesForDatePickerItems"
                  [key]="key.month - 1"
                  (action)="key.month = $event.key + 1">
                </sti-drop-down-list>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [width]="40" [margin]="'1px 2px 0 0'" [value]="key.year" (onchange)="yearAction($event)">
                </sti-text-box>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-button [imageName]="'Arrows.BigArrowRight.png'" [margin]="'1px 1px 0 0'" (action)="nextMonthButtonAction()">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
        <div class="stiJsViewerDatePickerSeparator" style="margin: 2px 0px;"></div>

        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngFor="let item of model.dayOfWeek; let i = index" class="stiJsViewerDatePickerDayOfWeekCell"
                  [style.fontSize]="countLetters == 2 ? '11px' : ''"
                  [style.color]="getShortDayColor(i)">
                  {{getShortDayName(i)}}
              </td>
            </tr>
            <tr *ngFor="let row of rows" class="stiJsViewerClearAllStyles">
                <td *ngFor="let col of cols" class="stiJsViewerClearAllStyles">
                  <sti-date-picker-day-button
                      [col]="col"
                      [row]="row"
                      [date]="key"
                      [selected]="getButtonSelected(col, row)"
                      [caption]="getButtonCaption(col, row)"
                      [enabled]="getButtonCaption(col, row) != ''">
                      [closeOnAction]="closeOnAction"
                  </sti-date-picker-day-button>
                </td>
            </tr>
          </tbody>
        </table>

        <div *ngIf="showTime" class="stiJsViewerDatePickerSeparator" style="margin: 2px 0px;"></div>
        <table *ngIf="showTime" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width:100%">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding: 0 4px 0 4px; white-space: nowrap;">
                {{this.model.loc('Time') + ':'}}
              </td>

              <td class="stiJsViewerClearAllStyles" style="text-align: right;">
                <sti-text-box [width]="90"
                    [margin]="'1px 2px 2px 2px'"
                    [value]="getTime()"
                    (action)="timeAction($event)">
                </sti-text-box>
              </td>
            </tr>
          </tbody>
        </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: DropDownListComponent, selector: "sti-drop-down-list", inputs: ["toolTip", "showImage", "width", "margin", "items", "styleDisplay", "verticalAlign", "readOnly", "enabled", "key"], outputs: ["action"] }, { kind: "component", type: DatePickerDayButtonComponent, selector: "sti-date-picker-day-button", inputs: ["col", "row", "caption", "enabled", "selected", "date", "closeOnAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DatePickerMenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-date-picker-menu',
                    template: `
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-button [imageName]="'Arrows.BigArrowLeft.png'" [margin]="'1px 2px 0 1px'" (action)="prevMonthButtonAction()">
                </sti-button>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-drop-down-list
                  [width]="model.options.isTouchDevice ? 79 : 81"
                  [readOnly]="true"
                  [margin]="'1px 2px 0 0'"
                  [items]="monthesForDatePickerItems"
                  [key]="key.month - 1"
                  (action)="key.month = $event.key + 1">
                </sti-drop-down-list>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [width]="40" [margin]="'1px 2px 0 0'" [value]="key.year" (onchange)="yearAction($event)">
                </sti-text-box>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-button [imageName]="'Arrows.BigArrowRight.png'" [margin]="'1px 1px 0 0'" (action)="nextMonthButtonAction()">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
        <div class="stiJsViewerDatePickerSeparator" style="margin: 2px 0px;"></div>

        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngFor="let item of model.dayOfWeek; let i = index" class="stiJsViewerDatePickerDayOfWeekCell"
                  [style.fontSize]="countLetters == 2 ? '11px' : ''"
                  [style.color]="getShortDayColor(i)">
                  {{getShortDayName(i)}}
              </td>
            </tr>
            <tr *ngFor="let row of rows" class="stiJsViewerClearAllStyles">
                <td *ngFor="let col of cols" class="stiJsViewerClearAllStyles">
                  <sti-date-picker-day-button
                      [col]="col"
                      [row]="row"
                      [date]="key"
                      [selected]="getButtonSelected(col, row)"
                      [caption]="getButtonCaption(col, row)"
                      [enabled]="getButtonCaption(col, row) != ''">
                      [closeOnAction]="closeOnAction"
                  </sti-date-picker-day-button>
                </td>
            </tr>
          </tbody>
        </table>

        <div *ngIf="showTime" class="stiJsViewerDatePickerSeparator" style="margin: 2px 0px;"></div>
        <table *ngIf="showTime" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width:100%">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding: 0 4px 0 4px; white-space: nowrap;">
                {{this.model.loc('Time') + ':'}}
              </td>

              <td class="stiJsViewerClearAllStyles" style="text-align: right;">
                <sti-text-box [width]="90"
                    [margin]="'1px 2px 2px 2px'"
                    [value]="getTime()"
                    (action)="timeAction($event)">
                </sti-text-box>
              </td>
            </tr>
          </tbody>
        </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }]; }, propDecorators: { menu: [{
                type: Input
            }], keyTo: [{
                type: Input
            }], closeOnAction: [{
                type: Input
            }] } });

class VerticalMenuItemComponent {
    constructor(model, menuService) {
        this.model = model;
        this.menuService = menuService;
        this.styleName = 'stiJsViewerMenuStandartItem';
        this.action = new EventEmitter();
        this.over = false;
        this._enabled = true;
    }
    ngOnInit() { }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    get className() {
        var _a;
        return this.styleName ? this.styleName + ' ' + (this.enabled ? (this.styleName + (this.over ? 'Over' : (((_a = this.item) === null || _a === void 0 ? void 0 : _a.selected) ? 'Selected' : 'Default'))) : this.styleName + 'Disabled') : '';
    }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
    }
    click() {
        if (this._enabled) {
            this.action.emit(this.item);
        }
    }
    get isSmallItem() {
        return this.styleName && this.styleName.indexOf('MenuStandartItem') >= 0;
    }
}
VerticalMenuItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: VerticalMenuItemComponent, deps: [{ token: ModelService }, { token: MenuService }], target: i0.ɵɵFactoryTarget.Component });
VerticalMenuItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: VerticalMenuItemComponent, selector: "sti-vertical-menu-item", inputs: { styleName: "styleName", item: "item", imageSizesWidth: "imageSizesWidth", imageSizesHeight: "imageSizesHeight", enabled: "enabled" }, outputs: { action: "action" }, ngImport: i0, template: `
    <div [style.height]="item?.type == 'DigitalSignature' ? 'auto' :(model.options.isMobileDevice ? '0.4in' : (model.options.isTouchDevice ? '30px' : '24px'))"
         [class]="className"
         [style.width]="item?.type == 'DigitalSignature' ? '100%' :  menuService.getVerticalMenu().width + 'px'"
         [style.lineHeight]="item?.type == 'DigitalSignature' ? 1.3 : null"
         (mouseover)="mouseover()"
         (mouseout)="mouseout()"
         (click)="click()">
         <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%; width: 100%">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                 <td *ngIf="item?.imageName != null && !model.options.appearance.rightToLeft"
                     style="width:22px; min-width = 22px; padding: 0; textAlign: center; lineHeight: 0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     style="padding: 0px 20px 0px 7px; text-align: left; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     style="padding: 8px 20px 8px 8px ; text-align: left; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <!-- right-to-left -->
                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     style="padding: 8px 20px 8px 8px; text-align: right; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     style="padding: 0 7px 0 20px; text-align: right; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.imageName != null && model.options.appearance.rightToLeft"
                     style="width:22px; min-width = 22px; padding: 0; textAlign: center; lineHeight: 0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>
              </tr>
            </tbody>
          </table>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: VerticalMenuItemComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-vertical-menu-item',
                    template: `
    <div [style.height]="item?.type == 'DigitalSignature' ? 'auto' :(model.options.isMobileDevice ? '0.4in' : (model.options.isTouchDevice ? '30px' : '24px'))"
         [class]="className"
         [style.width]="item?.type == 'DigitalSignature' ? '100%' :  menuService.getVerticalMenu().width + 'px'"
         [style.lineHeight]="item?.type == 'DigitalSignature' ? 1.3 : null"
         (mouseover)="mouseover()"
         (mouseout)="mouseout()"
         (click)="click()">
         <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%; width: 100%">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                 <td *ngIf="item?.imageName != null && !model.options.appearance.rightToLeft"
                     style="width:22px; min-width = 22px; padding: 0; textAlign: center; lineHeight: 0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     style="padding: 0px 20px 0px 7px; text-align: left; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     style="padding: 8px 20px 8px 8px ; text-align: left; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <!-- right-to-left -->
                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     style="padding: 8px 20px 8px 8px; text-align: right; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     style="padding: 0 7px 0 20px; text-align: right; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.imageName != null && model.options.appearance.rightToLeft"
                     style="width:22px; min-width = 22px; padding: 0; textAlign: center; lineHeight: 0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>
              </tr>
            </tbody>
          </table>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: MenuService }]; }, propDecorators: { styleName: [{
                type: Input
            }], item: [{
                type: Input
            }], imageSizesWidth: [{
                type: Input
            }], imageSizesHeight: [{
                type: Input
            }], action: [{
                type: Output
            }], enabled: [{
                type: Input
            }] } });

class VerticalMenuComponent {
    constructor() { }
    ngOnInit() { }
    action(item) {
        var _a, _b;
        (_b = (_a = this.menu) === null || _a === void 0 ? void 0 : _a.action) === null || _b === void 0 ? void 0 : _b.emit(item);
    }
}
VerticalMenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: VerticalMenuComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
VerticalMenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: VerticalMenuComponent, selector: "sti-vertical-menu", inputs: { menu: "menu" }, ngImport: i0, template: `
    <sti-vertical-menu-item *ngFor="let item of menu.verticalItems" [item]="item" [styleName]="menu.itemStyleName" (action)="action(item)">
    </sti-vertical-menu-item>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: VerticalMenuItemComponent, selector: "sti-vertical-menu-item", inputs: ["styleName", "item", "imageSizesWidth", "imageSizesHeight", "enabled"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: VerticalMenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-vertical-menu',
                    template: `
    <sti-vertical-menu-item *ngFor="let item of menu.verticalItems" [item]="item" [styleName]="menu.itemStyleName" (action)="action(item)">
    </sti-vertical-menu-item>
  `
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { menu: [{
                type: Input
            }] } });

class DoubleDatePickerMenuComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    get showTime() {
        var _a, _b;
        return ((_b = (_a = this.menu) === null || _a === void 0 ? void 0 : _a.params) === null || _b === void 0 ? void 0 : _b.dateTimeType) !== 'Date';
    }
    setTimeInterval(firstDate, secondDate) {
        firstDate.setHours(0);
        firstDate.setMinutes(0);
        firstDate.setSeconds(0);
        secondDate.setHours(23);
        secondDate.setMinutes(59);
        secondDate.setSeconds(59);
    }
    getFirstDayOfWeek() {
        const date = new Date();
        const timeString = date.toLocaleTimeString();
        return (timeString.toLowerCase().indexOf('am') >= 0 || timeString.toLowerCase().indexOf('pm') >= 0 ? 0 : 1);
    }
    getWeekInterval(now) {
        const startDay = this.getFirstDayOfWeek();
        let dayWeek = startDay === 0 ? now.getDay() : now.getDay() - 1;
        if (dayWeek < 0) {
            dayWeek = 6;
        }
        const values = [new Date(now.valueOf() - dayWeek * 86400000)];
        values.push(new Date(values[0].valueOf() + 6 * 86400000));
        this.setTimeInterval(values[0], values[1]);
        return values;
    }
    getValuesByDateRangeName(item) {
        const now = new Date();
        let values = [new Date(), new Date()];
        switch (item) {
            case 'CurrentMonth': {
                values[0].setDate(1);
                values[1].setDate(this.helper.getCountDaysOfMonth(now.getFullYear(), now.getMonth()));
                break;
            }
            case 'CurrentQuarter': {
                const firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3;
                values[0] = new Date(now.getFullYear(), firstMonth, 1);
                values[1] = new Date(now.getFullYear(), firstMonth + 2, this.helper.getCountDaysOfMonth(now.getFullYear(), firstMonth + 2));
                break;
            }
            case 'CurrentWeek': {
                values = this.getWeekInterval(now);
                break;
            }
            case 'CurrentYear': {
                values[0] = new Date(now.getFullYear(), 0, 1);
                values[1] = new Date(now.getFullYear(), 11, 31);
                break;
            }
            case 'NextMonth': {
                let month = now.getMonth() + 1;
                let year = now.getFullYear();
                if (month > 11) {
                    month = 0;
                    year++;
                }
                values[0] = new Date(year, month, 1);
                values[1] = new Date(year, month, this.helper.getCountDaysOfMonth(year, month));
                break;
            }
            case 'NextQuarter': {
                let year = now.getFullYear();
                let firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3 + 3;
                if (firstMonth > 11) {
                    firstMonth = 0;
                    year++;
                }
                values[0] = new Date(year, firstMonth, 1);
                values[1] = new Date(year, firstMonth + 2, this.helper.getCountDaysOfMonth(year, firstMonth + 2));
                break;
            }
            case 'NextWeek': {
                values = this.getWeekInterval(now);
                values[0] = new Date(values[0].valueOf() + 7 * 86400000);
                values[1] = new Date(values[1].valueOf() + 7 * 86400000);
                break;
            }
            case 'NextYear': {
                values[0] = new Date(now.getFullYear() + 1, 0, 1);
                values[1] = new Date(now.getFullYear() + 1, 11, 31);
                break;
            }
            case 'PreviousMonth': {
                let month = now.getMonth() - 1;
                let year = now.getFullYear();
                if (month < 0) {
                    month = 11;
                    year--;
                }
                values[0] = new Date(year, month, 1);
                values[1] = new Date(year, month, this.helper.getCountDaysOfMonth(year, month));
                break;
            }
            case 'PreviousQuarter': {
                let year = now.getFullYear();
                let firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3 - 3;
                if (firstMonth < 0) {
                    firstMonth = 9;
                    year--;
                }
                values[0] = new Date(year, firstMonth, 1);
                values[1] = new Date(year, firstMonth + 2, this.helper.getCountDaysOfMonth(year, firstMonth + 2));
                break;
            }
            case 'PreviousWeek': {
                values = this.getWeekInterval(now);
                values[0] = new Date(values[0].valueOf() - 7 * 86400000);
                values[1] = new Date(values[1].valueOf() - 7 * 86400000);
                break;
            }
            case 'PreviousYear': {
                values[0] = new Date(now.getFullYear() - 1, 0, 1);
                values[1] = new Date(now.getFullYear() - 1, 11, 31);
                break;
            }
            case 'FirstQuarter': {
                values[0] = new Date(now.getFullYear(), 0, 1);
                values[1] = new Date(now.getFullYear(), 2, this.helper.getCountDaysOfMonth(now.getFullYear(), 2));
                break;
            }
            case 'SecondQuarter': {
                values[0] = new Date(now.getFullYear(), 3, 1);
                values[1] = new Date(now.getFullYear(), 5, this.helper.getCountDaysOfMonth(now.getFullYear(), 5));
                break;
            }
            case 'ThirdQuarter': {
                values[0] = new Date(now.getFullYear(), 6, 1);
                values[1] = new Date(now.getFullYear(), 8, this.helper.getCountDaysOfMonth(now.getFullYear(), 8));
                break;
            }
            case 'FourthQuarter': {
                values[0] = new Date(now.getFullYear(), 9, 1);
                values[1] = new Date(now.getFullYear(), 11, this.helper.getCountDaysOfMonth(now.getFullYear(), 11));
                break;
            }
            case 'MonthToDate': {
                values[0].setDate(1);
                break;
            }
            case 'QuarterToDate': {
                const firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3;
                values[0].setDate(1);
                values[0].setMonth(firstMonth);
                break;
            }
            case 'WeekToDate': {
                const weekValues = this.getWeekInterval(now);
                values[0] = weekValues[0];
                break;
            }
            case 'YearToDate': {
                values[0].setDate(1);
                values[0].setMonth(0);
                break;
            }
            case 'Today': {
                break;
            }
            case 'Tomorrow': {
                values[0] = new Date(values[0].valueOf() + 86400000);
                values[1] = new Date(values[1].valueOf() + 86400000);
                break;
            }
            case 'Yesterday': {
                values[0] = new Date(values[0].valueOf() - 86400000);
                values[1] = new Date(values[1].valueOf() - 86400000);
                break;
            }
            case 'Last7Days': {
                if (this.model.options.appearance.datePickerIncludeCurrentDayForRanges) {
                    values[0] = new Date(values[0].valueOf() - 6 * 86400000);
                }
                else {
                    values[0] = new Date(values[0].valueOf() - 7 * 86400000);
                }
                break;
            }
            case 'Last14Days': {
                if (this.model.options.appearance.datePickerIncludeCurrentDayForRanges) {
                    values[0] = new Date(values[0].valueOf() - 13 * 86400000);
                }
                else {
                    values[0] = new Date(values[0].valueOf() - 14 * 86400000);
                }
                break;
            }
            case 'Last30Days': {
                if (this.model.options.appearance.datePickerIncludeCurrentDayForRanges) {
                    values[0] = new Date(values[0].valueOf() - 29 * 86400000);
                }
                else {
                    values[0] = new Date(values[0].valueOf() - 30 * 86400000);
                }
                break;
            }
        }
        this.setTimeInterval(values[0], values[1]);
        this.menu.params.key = this.helper.getDateTimeObject(values[0]);
        this.menu.params.keyTo = this.helper.getDateTimeObject(values[1]);
    }
}
DoubleDatePickerMenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DoubleDatePickerMenuComponent, deps: [{ token: ModelService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
DoubleDatePickerMenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DoubleDatePickerMenuComponent, selector: "sti-double-date-picker-menu", inputs: { menu: "menu" }, ngImport: i0, template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 4px; border: 1px dotted rgb(198, 198, 198);">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="vertical-align: top;">
                  <div style="margin:4px">
                    <sti-date-picker-menu [menu]="menu" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" style="border-left: 1px dotted rgb(198, 198, 198); vertical-align: top;">
                  <div style="margin:4px">
                    <sti-date-picker-menu [menu]="menu" [keyTo]="true" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" style="border-left: 1px dotted rgb(198, 198, 198); vertical-align: top;">
                <div style="width: 150px; overflow: auto; margin: 4px;" [style.height.px]="showTime ? 250 : 220">
                    <ng-container *ngFor="let item of model.dateRanges">
                        <sti-button [caption]="model.loc(item)" (action)="getValuesByDateRangeName(item)">
                        </sti-button>

                        <div *ngIf="item=='Yesterday' || item=='PreviousWeek' || item=='PreviousMonth' || item=='PreviousQuarter' || item=='PreviousYear' || item=='FourthQuarter' || item=='Last30Days'"
                            class="stiJsViewerVerticalMenuSeparator" style="margin:2px"></div>
                    </ng-container>
                </div>
              </td>
            </tr>
          </tbody>
      </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: DatePickerMenuComponent, selector: "sti-date-picker-menu", inputs: ["menu", "keyTo", "closeOnAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DoubleDatePickerMenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-double-date-picker-menu',
                    template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 4px; border: 1px dotted rgb(198, 198, 198);">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="vertical-align: top;">
                  <div style="margin:4px">
                    <sti-date-picker-menu [menu]="menu" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" style="border-left: 1px dotted rgb(198, 198, 198); vertical-align: top;">
                  <div style="margin:4px">
                    <sti-date-picker-menu [menu]="menu" [keyTo]="true" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" style="border-left: 1px dotted rgb(198, 198, 198); vertical-align: top;">
                <div style="width: 150px; overflow: auto; margin: 4px;" [style.height.px]="showTime ? 250 : 220">
                    <ng-container *ngFor="let item of model.dateRanges">
                        <sti-button [caption]="model.loc(item)" (action)="getValuesByDateRangeName(item)">
                        </sti-button>

                        <div *ngIf="item=='Yesterday' || item=='PreviousWeek' || item=='PreviousMonth' || item=='PreviousQuarter' || item=='PreviousYear' || item=='FourthQuarter' || item=='Last30Days'"
                            class="stiJsViewerVerticalMenuSeparator" style="margin:2px"></div>
                    </ng-container>
                </div>
              </td>
            </tr>
          </tbody>
      </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }]; }, propDecorators: { menu: [{
                type: Input
            }] } });

class DropDownListForExportFormComponent {
    constructor() {
        this.enabled = true;
        this.action = new EventEmitter();
    }
    ngOnInit() { }
}
DropDownListForExportFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DropDownListForExportFormComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
DropDownListForExportFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DropDownListForExportFormComponent, selector: "sti-drop-down-list-for-export-form", inputs: { items: "items", width: "width", key: "key", margin: "margin", enabled: "enabled", styleDisplay: "styleDisplay", verticalAlign: "verticalAlign" }, outputs: { action: "action" }, ngImport: i0, template: `
    <sti-drop-down-list [items]="items"
      [width]="width"
      [readOnly]="true"
      [key]="key"
      [margin]="margin"
      [enabled]="enabled"
      [styleDisplay]="styleDisplay"
      [verticalAlign]="verticalAlign"
      (action)="key = $event.key; action.emit($event)">
    </sti-drop-down-list>
  `, isInline: true, dependencies: [{ kind: "component", type: DropDownListComponent, selector: "sti-drop-down-list", inputs: ["toolTip", "showImage", "width", "margin", "items", "styleDisplay", "verticalAlign", "readOnly", "enabled", "key"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DropDownListForExportFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-drop-down-list-for-export-form',
                    template: `
    <sti-drop-down-list [items]="items"
      [width]="width"
      [readOnly]="true"
      [key]="key"
      [margin]="margin"
      [enabled]="enabled"
      [styleDisplay]="styleDisplay"
      [verticalAlign]="verticalAlign"
      (action)="key = $event.key; action.emit($event)">
    </sti-drop-down-list>
  `
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { items: [{
                type: Input
            }], width: [{
                type: Input
            }], key: [{
                type: Input
            }], margin: [{
                type: Input
            }], enabled: [{
                type: Input
            }], styleDisplay: [{
                type: Input
            }], verticalAlign: [{
                type: Input
            }], action: [{
                type: Output
            }] } });

class DocumentSecurityMenuComponent {
    constructor(model, formService, exportService, collections) {
        this.model = model;
        this.formService = formService;
        this.exportService = exportService;
        this.collections = collections;
    }
    ngOnInit() { }
    getTextBoxType() {
        var _a;
        return ((_a = this.formService.form) === null || _a === void 0 ? void 0 : _a.name) === 'exportForm' ? 'password' : '';
    }
    updateUserAccessPrivileges() {
        const privileges = [];
        if (this.allowPrintDocument.isChecked) {
            privileges.push('PrintDocument');
        }
        if (this.allowModifyContents.isChecked) {
            privileges.push('ModifyContents');
        }
        if (this.allowCopyTextAndGraphics.isChecked) {
            privileges.push('CopyTextAndGraphics');
        }
        if (this.allowAddOrModifyTextAnnotations.isChecked) {
            privileges.push('AddOrModifyTextAnnotations');
        }
        this.exportService.exportSettings.UserAccessPrivileges = privileges.join(',');
    }
    getUserAccessPrivileges(name) {
        var _a, _b, _c;
        return ((_a = this.exportService.exportSettings) === null || _a === void 0 ? void 0 : _a.UserAccessPrivileges) === 'All' || ((_c = (_b = this.exportService.exportSettings) === null || _b === void 0 ? void 0 : _b.UserAccessPrivileges) === null || _c === void 0 ? void 0 : _c.indexOf(name)) >= 0;
    }
}
DocumentSecurityMenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DocumentSecurityMenuComponent, deps: [{ token: ModelService }, { token: FormService }, { token: ExportService }, { token: CollectionsService }], target: i0.ɵɵFactoryTarget.Component });
DocumentSecurityMenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DocumentSecurityMenuComponent, selector: "sti-document-security-menu", viewQueries: [{ propertyName: "allowPrintDocument", first: true, predicate: ["AllowPrintDocument"], descendants: true }, { propertyName: "allowModifyContents", first: true, predicate: ["AllowModifyContents"], descendants: true }, { propertyName: "allowCopyTextAndGraphics", first: true, predicate: ["AllowCopyTextAndGraphics"], descendants: true }, { propertyName: "allowAddOrModifyTextAnnotations", first: true, predicate: ["AllowAddOrModifyTextAnnotations"], descendants: true }], ngImport: i0, template: `
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('UserPasswordTooltip')">
                        {{model.loc('UserPassword')}}
                      </td>
                      <td class="stiJsViewerClearAllStyles">
                        <sti-text-box
                           [width]="160"
                           [tooltip]="model.loc('UserPasswordTooltip')"
                           [margin]="'8px 8px 2px 8px'"
                           [type]="getTextBoxType()"
                           [value]="exportService.exportSettings?.PasswordInputUser"
                           (onchange)="exportService.exportSettings.PasswordInputUser =  $event.value">
                        </sti-text-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles" [attr.title]="model.loc('OwnerPasswordTooltip')">
                      <td style="padding: 0px 8px; min-width: 150px;">
                        {{model.loc('OwnerPassword')}}
                      </td>
                      <td class="stiJsViewerClearAllStyles">
                        <sti-text-box
                           [width]="160"
                           [tooltip]="model.loc('OwnerPasswordTooltip')"
                           [margin]="'2px 8px 2px 8px'"
                           [type]="getTextBoxType()"
                           [value]="exportService.exportSettings?.PasswordInputOwner"
                           (onchange)="exportService.exportSettings.PasswordInputOwner =  $event.value">
                        </sti-text-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowPrintDocument
                           [captionText]="model.loc('AllowPrintDocument')"
                           [tooltip]="model.loc('AllowPrintDocumentTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('PrintDocument')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowModifyContents
                           [captionText]="model.loc('AllowModifyContents')"
                           [tooltip]="model.loc('AllowModifyContentsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('ModifyContents')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowCopyTextAndGraphics
                           [captionText]="model.loc('AllowCopyTextAndGraphics')"
                           [tooltip]="model.loc('AllowCopyTextAndGraphicsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('CopyTextAndGraphics')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowAddOrModifyTextAnnotations
                           [captionText]="model.loc('AllowAddOrModifyTextAnnotations')"
                           [tooltip]="model.loc('AllowAddOrModifyTextAnnotationsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('AddOrModifyTextAnnotations')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('EncryptionKeyLengthTooltip')">
                        {{model.loc('EncryptionKeyLength')}}
                      </td>
                      <td>
                        <sti-drop-down-list-for-export-form
                           [width]="160"
                           [items]="collections.getEncryptionKeyLengthItems()"
                           [key]="exportService.exportSettings?.KeyLength"
                           [margin]="'2px 8px 4px 8px'"
                           (action)="exportService.exportSettings.KeyLength = $event.key">
                        </sti-drop-down-list-for-export-form>
                      </td>
                    </tr>
                  </tbody>
                </table>
`, isInline: true, dependencies: [{ kind: "component", type: TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }, { kind: "component", type: DropDownListForExportFormComponent, selector: "sti-drop-down-list-for-export-form", inputs: ["items", "width", "key", "margin", "enabled", "styleDisplay", "verticalAlign"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DocumentSecurityMenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-document-security-menu',
                    template: `
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('UserPasswordTooltip')">
                        {{model.loc('UserPassword')}}
                      </td>
                      <td class="stiJsViewerClearAllStyles">
                        <sti-text-box
                           [width]="160"
                           [tooltip]="model.loc('UserPasswordTooltip')"
                           [margin]="'8px 8px 2px 8px'"
                           [type]="getTextBoxType()"
                           [value]="exportService.exportSettings?.PasswordInputUser"
                           (onchange)="exportService.exportSettings.PasswordInputUser =  $event.value">
                        </sti-text-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles" [attr.title]="model.loc('OwnerPasswordTooltip')">
                      <td style="padding: 0px 8px; min-width: 150px;">
                        {{model.loc('OwnerPassword')}}
                      </td>
                      <td class="stiJsViewerClearAllStyles">
                        <sti-text-box
                           [width]="160"
                           [tooltip]="model.loc('OwnerPasswordTooltip')"
                           [margin]="'2px 8px 2px 8px'"
                           [type]="getTextBoxType()"
                           [value]="exportService.exportSettings?.PasswordInputOwner"
                           (onchange)="exportService.exportSettings.PasswordInputOwner =  $event.value">
                        </sti-text-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowPrintDocument
                           [captionText]="model.loc('AllowPrintDocument')"
                           [tooltip]="model.loc('AllowPrintDocumentTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('PrintDocument')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowModifyContents
                           [captionText]="model.loc('AllowModifyContents')"
                           [tooltip]="model.loc('AllowModifyContentsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('ModifyContents')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowCopyTextAndGraphics
                           [captionText]="model.loc('AllowCopyTextAndGraphics')"
                           [tooltip]="model.loc('AllowCopyTextAndGraphicsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('CopyTextAndGraphics')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowAddOrModifyTextAnnotations
                           [captionText]="model.loc('AllowAddOrModifyTextAnnotations')"
                           [tooltip]="model.loc('AllowAddOrModifyTextAnnotationsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('AddOrModifyTextAnnotations')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('EncryptionKeyLengthTooltip')">
                        {{model.loc('EncryptionKeyLength')}}
                      </td>
                      <td>
                        <sti-drop-down-list-for-export-form
                           [width]="160"
                           [items]="collections.getEncryptionKeyLengthItems()"
                           [key]="exportService.exportSettings?.KeyLength"
                           [margin]="'2px 8px 4px 8px'"
                           (action)="exportService.exportSettings.KeyLength = $event.key">
                        </sti-drop-down-list-for-export-form>
                      </td>
                    </tr>
                  </tbody>
                </table>
`
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: FormService }, { type: ExportService }, { type: CollectionsService }]; }, propDecorators: { allowPrintDocument: [{
                type: ViewChild,
                args: ['AllowPrintDocument']
            }], allowModifyContents: [{
                type: ViewChild,
                args: ['AllowModifyContents']
            }], allowCopyTextAndGraphics: [{
                type: ViewChild,
                args: ['AllowCopyTextAndGraphics']
            }], allowAddOrModifyTextAnnotations: [{
                type: ViewChild,
                args: ['AllowAddOrModifyTextAnnotations']
            }] } });

class DigitalSignatureMenuComponent {
    constructor(model, exportService) {
        this.model = model;
        this.exportService = exportService;
    }
    ngOnInit() { }
}
DigitalSignatureMenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DigitalSignatureMenuComponent, deps: [{ token: ModelService }, { token: ExportService }], target: i0.ɵɵFactoryTarget.Component });
DigitalSignatureMenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DigitalSignatureMenuComponent, selector: "sti-digital-signature-menu", ngImport: i0, template: `
    <div *ngFor="let item of model.pdfSecurityCertificates" class="stiJsViewerMenuStandartItem stiJsViewerMenuStandartItemSelected" style="height: auto; line-height: 1.3;">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%; width: 100%;">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="padding: 8px 20px 8px 8px; text-align: left; white-space: nowrap;">
            </td>
          </tr>
        </tbody>
      </table>
    </div>
`, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DigitalSignatureMenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-digital-signature-menu',
                    template: `
    <div *ngFor="let item of model.pdfSecurityCertificates" class="stiJsViewerMenuStandartItem stiJsViewerMenuStandartItemSelected" style="height: auto; line-height: 1.3;">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%; width: 100%;">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="padding: 8px 20px 8px 8px; text-align: left; white-space: nowrap;">
            </td>
          </tr>
        </tbody>
      </table>
    </div>
`
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ExportService }]; } });

class MenuComponent {
    constructor(model, controller, helper, menuService) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.menuService = menuService;
        this.style = 'display: none';
        this.overflow = 'hidden';
    }
    ngAfterViewInit() {
        this.menu.menuEl = this.menuEl;
        this.menu.innerContent = this.innerContent;
    }
    ngOnInit() {
    }
    startAnimation(event) {
        if (event.toState === 'expanded') {
            this.style = 'width: 350px; overflow: hidden';
            this.overflow = 'hidden';
        }
    }
    doneAnimation(event) {
        if (event.toState === 'expanded') {
            this.style = 'overflow: visible;';
            this.overflow = this.menu.type.indexOf('parameterMenu') === 0 || this.model.options.isMobileDevice ? 'auto' : 'hidden';
        }
        else if (event.toState === 'initialUp' || event.toState === 'initialDown') {
            this.style = 'display: none';
            this.overflow = 'hidden';
        }
    }
    menuClick(item) {
        this.menuService.closeAllMenus();
        this.controller.action({ name: item.name, value: item.value });
    }
    mouseup() {
        this.menuService.menuMouseUp = this.menu.type;
    }
    get zIndex() {
        return this.menu.type === 'datePickerMenu' ? 36 : (this.menu.type === 'verticalMenu' ? 37 : 35);
    }
}
MenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuComponent, deps: [{ token: ModelService }, { token: ControllerService }, { token: HelperService }, { token: MenuService }], target: i0.ɵɵFactoryTarget.Component });
MenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: MenuComponent, selector: "sti-menu", inputs: { menu: "menu" }, viewQueries: [{ propertyName: "menuEl", first: true, predicate: ["menuEl"], descendants: true }, { propertyName: "innerContent", first: true, predicate: ["innerContent"], descendants: true }], ngImport: i0, template: `
      <div #menuEl class="stiJsViewerParentMenu"
      [style]="menu.sizeStyle || style"
      [style.top.px]="menu.top"
      [style.left.px]="menu.left"
      [style.zIndex]="zIndex"
      [style.height]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : menu.height + 'px'"
      [@.disabled]="!model.options.toolbar.menuAnimation"
      (mouseup)="mouseup()">
        <div #innerContent [style]="{overflowX: 'hidden', overflowY: overflow}"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.maxHeight]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : '450px'"
        [style.height]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : null"
        [@expand]="menu.state || 'initialDown'"
        (@expand.start)="startAnimation($event)"
        (@expand.done)="doneAnimation($event)"
        [class]="helper.val(menu.menuStyleName, 'stiJsViewerMenu')">
            <ng-container *ngIf="menu.type=='buttonMenu'">
              <sti-menu-item *ngFor="let item of menu.items" [item]="item" (click)="menuClick(item)"></sti-menu-item>
            </ng-container>

            <sti-parameter-menu-edit-list *ngIf="menu.type=='parameterMenuForEditList'" [menu]="menu">
            </sti-parameter-menu-edit-list>

            <sti-parameter-menu-not-edit-list *ngIf="menu.type=='parameterMenuForNotEditList'" [menu]="menu">
            </sti-parameter-menu-not-edit-list>

            <sti-parameter-menu-for-value *ngIf="menu.type=='parameterMenuForValue'" [menu]="menu">
            </sti-parameter-menu-for-value>

            <sti-parameter-menu-for-range *ngIf="menu.type=='parameterMenuForRange'" [menu]="menu">
            </sti-parameter-menu-for-range>

            <sti-date-picker-menu *ngIf="menu.type=='datePickerMenu'" [menu]="menu">
            </sti-date-picker-menu>

            <sti-double-date-picker-menu *ngIf="menu.type=='doubleDatePickerMenu'" [menu]="menu">
            </sti-double-date-picker-menu>

            <sti-document-security-menu *ngIf="menu.type=='documentSecurityMenu'">
            </sti-document-security-menu>

            <sti-digital-signature-menu *ngIf="menu.type=='useDigitalSignatureMenu'">
            </sti-digital-signature-menu>

            <sti-vertical-menu *ngIf="menu.type=='verticalMenu'" [menu]="menu">
            </sti-vertical-menu>
        </div>
      </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: MenuItemComponent, selector: "sti-menu-item", inputs: ["item", "styleName", "enabled"] }, { kind: "component", type: ParameterMenuEditListComponent, selector: "sti-parameter-menu-edit-list", inputs: ["menu"] }, { kind: "component", type: ParameterMenuNotEditListComponent, selector: "sti-parameter-menu-not-edit-list", inputs: ["menu"] }, { kind: "component", type: ParameterMenuForValueComponent, selector: "sti-parameter-menu-for-value", inputs: ["menu"] }, { kind: "component", type: ParameterMenuForRangeComponent, selector: "sti-parameter-menu-for-range", inputs: ["menu"] }, { kind: "component", type: DatePickerMenuComponent, selector: "sti-date-picker-menu", inputs: ["menu", "keyTo", "closeOnAction"] }, { kind: "component", type: VerticalMenuComponent, selector: "sti-vertical-menu", inputs: ["menu"] }, { kind: "component", type: DoubleDatePickerMenuComponent, selector: "sti-double-date-picker-menu", inputs: ["menu"] }, { kind: "component", type: DocumentSecurityMenuComponent, selector: "sti-document-security-menu" }, { kind: "component", type: DigitalSignatureMenuComponent, selector: "sti-digital-signature-menu" }], animations: [
        trigger('expand', [
            state('initialDown', style({ transform: 'translateY(-100%)' })),
            state('initialUp', style({ transform: 'translateY(100%)' })),
            state('initialLeft', style({ transform: 'translateX(-100%)' })),
            state('expanded', style({ transform: 'translateY(0) translateX(0)' })),
            transition('initialUp => expanded', [
                animate('150ms ease-in-out')
            ]),
            transition('initialDown => expanded', [
                animate('150ms ease-in-out')
            ]),
            transition('initialLeft => expanded', [
                animate('150ms ease-in-out')
            ]),
            transition('expanded => initialLeft', [
                animate('150ms ease-in-out')
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-menu',
                    template: `
      <div #menuEl class="stiJsViewerParentMenu"
      [style]="menu.sizeStyle || style"
      [style.top.px]="menu.top"
      [style.left.px]="menu.left"
      [style.zIndex]="zIndex"
      [style.height]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : menu.height + 'px'"
      [@.disabled]="!model.options.toolbar.menuAnimation"
      (mouseup)="mouseup()">
        <div #innerContent [style]="{overflowX: 'hidden', overflowY: overflow}"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.maxHeight]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : '450px'"
        [style.height]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : null"
        [@expand]="menu.state || 'initialDown'"
        (@expand.start)="startAnimation($event)"
        (@expand.done)="doneAnimation($event)"
        [class]="helper.val(menu.menuStyleName, 'stiJsViewerMenu')">
            <ng-container *ngIf="menu.type=='buttonMenu'">
              <sti-menu-item *ngFor="let item of menu.items" [item]="item" (click)="menuClick(item)"></sti-menu-item>
            </ng-container>

            <sti-parameter-menu-edit-list *ngIf="menu.type=='parameterMenuForEditList'" [menu]="menu">
            </sti-parameter-menu-edit-list>

            <sti-parameter-menu-not-edit-list *ngIf="menu.type=='parameterMenuForNotEditList'" [menu]="menu">
            </sti-parameter-menu-not-edit-list>

            <sti-parameter-menu-for-value *ngIf="menu.type=='parameterMenuForValue'" [menu]="menu">
            </sti-parameter-menu-for-value>

            <sti-parameter-menu-for-range *ngIf="menu.type=='parameterMenuForRange'" [menu]="menu">
            </sti-parameter-menu-for-range>

            <sti-date-picker-menu *ngIf="menu.type=='datePickerMenu'" [menu]="menu">
            </sti-date-picker-menu>

            <sti-double-date-picker-menu *ngIf="menu.type=='doubleDatePickerMenu'" [menu]="menu">
            </sti-double-date-picker-menu>

            <sti-document-security-menu *ngIf="menu.type=='documentSecurityMenu'">
            </sti-document-security-menu>

            <sti-digital-signature-menu *ngIf="menu.type=='useDigitalSignatureMenu'">
            </sti-digital-signature-menu>

            <sti-vertical-menu *ngIf="menu.type=='verticalMenu'" [menu]="menu">
            </sti-vertical-menu>
        </div>
      </div>
  `,
                    animations: [
                        trigger('expand', [
                            state('initialDown', style({ transform: 'translateY(-100%)' })),
                            state('initialUp', style({ transform: 'translateY(100%)' })),
                            state('initialLeft', style({ transform: 'translateX(-100%)' })),
                            state('expanded', style({ transform: 'translateY(0) translateX(0)' })),
                            transition('initialUp => expanded', [
                                animate('150ms ease-in-out')
                            ]),
                            transition('initialDown => expanded', [
                                animate('150ms ease-in-out')
                            ]),
                            transition('initialLeft => expanded', [
                                animate('150ms ease-in-out')
                            ]),
                            transition('expanded => initialLeft', [
                                animate('150ms ease-in-out')
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: HelperService }, { type: MenuService }]; }, propDecorators: { menu: [{
                type: Input
            }], menuEl: [{
                type: ViewChild,
                args: ['menuEl']
            }], innerContent: [{
                type: ViewChild,
                args: ['innerContent']
            }] } });

class TooltipComponent {
    constructor(model, tooltipService, helper) {
        this.model = model;
        this.tooltipService = tooltipService;
        this.helper = helper;
    }
    ngAfterViewInit() {
        this.model.controls.tooltip.el = this.element;
    }
    ngOnInit() { }
    action() {
        this.helper.showHelpWindow(this.tooltipService.helpLink);
    }
}
TooltipComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipComponent, deps: [{ token: ModelService }, { token: TooltipService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
TooltipComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: TooltipComponent, selector: "sti-tooltip", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
      <div #element class='stiJsViewerToolTip' [@expandDown]="tooltipService.state"
        [style.left.px]='tooltipService.left' [style.top.px]='tooltipService.top'
        (mouseover)="tooltipService.showFromTooltip()" (mouseout)="tooltipService.hide()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%;"
          [style.border]="model.options.appearance.showTooltipsHelp ? '' : 0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerToolTipTextCell">
                {{tooltipService.caption}}
              </td>
            </tr>
            <tr *ngIf="model.options.appearance.showTooltipsHelp" class="stiJsViewerClearAllStyles">
              <td  class="stiJsViewerClearAllStyles">
                <sti-button [caption]="model.loc('TellMeMore')"
                    [imageName]="'HelpIcon.png'"
                    [margin]="'4px 8px 4px 8px'"
                    (action)='action()'
                    [styleName]="'stiJsViewerHyperlinkButton'">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }], animations: [
        trigger('expandDown', [
            state('initial', style({ opacity: 0, display: 'none' })),
            state('preInitial', style({ opacity: 0, display: 'block' })),
            state('preInitial2', style({ opacity: 0, display: 'block' })),
            state('expanded', style({ opacity: 1, display: 'block' })),
            transition('preInitial => expanded', [
                animate('300ms 300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 0, offset: 0 }),
                    style({ display: 'block', opacity: 1, offset: 1 }),
                ]))
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-tooltip',
                    template: `
      <div #element class='stiJsViewerToolTip' [@expandDown]="tooltipService.state"
        [style.left.px]='tooltipService.left' [style.top.px]='tooltipService.top'
        (mouseover)="tooltipService.showFromTooltip()" (mouseout)="tooltipService.hide()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%;"
          [style.border]="model.options.appearance.showTooltipsHelp ? '' : 0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerToolTipTextCell">
                {{tooltipService.caption}}
              </td>
            </tr>
            <tr *ngIf="model.options.appearance.showTooltipsHelp" class="stiJsViewerClearAllStyles">
              <td  class="stiJsViewerClearAllStyles">
                <sti-button [caption]="model.loc('TellMeMore')"
                    [imageName]="'HelpIcon.png'"
                    [margin]="'4px 8px 4px 8px'"
                    (action)='action()'
                    [styleName]="'stiJsViewerHyperlinkButton'">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
    </div>
  `,
                    animations: [
                        trigger('expandDown', [
                            state('initial', style({ opacity: 0, display: 'none' })),
                            state('preInitial', style({ opacity: 0, display: 'block' })),
                            state('preInitial2', style({ opacity: 0, display: 'block' })),
                            state('expanded', style({ opacity: 1, display: 'block' })),
                            transition('preInitial => expanded', [
                                animate('300ms 300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 0, offset: 0 }),
                                    style({ display: 'block', opacity: 1, offset: 1 }),
                                ]))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: TooltipService }, { type: HelperService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

class FindPanelComponent {
    constructor(model, findService, controller) {
        this.model = model;
        this.findService = findService;
        this.controller = controller;
        this.changeFind = false;
        this.initItems();
        controller.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'GetReport':
                case 'GetPages':
                case 'OpenReport':
                case 'Variables':
                    if (model.controls.findPanel.visible) {
                        setTimeout(() => {
                            this.findService.hideFindLabels();
                            this.find('Next');
                        });
                    }
                    break;
            }
        });
    }
    ngAfterViewInit() {
        this.model.controls.findPanel.el = this.element;
        this.model.controls.findPanel.getVisibility().subscribe(() => {
            if (this.model.controls.findPanel.visible) {
                this.findService.text = '';
                setTimeout(() => {
                    this.textBox.element.nativeElement.focus();
                });
            }
        });
    }
    ngOnInit() { }
    selected(item) {
        switch (item.action) {
            case 'MatchCase':
                return this.findService.matchCase;
            case 'MatchWholeWord':
                return this.findService.matchWholeWord;
        }
        return false;
    }
    textBoxAction(target) {
        this.findService.text = target.value;
        this.find('Next');
    }
    find(direction) {
        if (this.findService.text === '') {
            this.findService.hideFindLabels();
            return;
        }
        if (this.findService.lastFindText !== this.findService.text || this.changeFind) {
            this.changeFind = false;
            this.findService.showFindLabels();
        }
        else {
            this.findService.selectFindLabel(direction);
        }
    }
    initItems() {
        this.items = [
            { type: 'button', action: 'close', img: 'CloseForm.png', margin: '2px' },
            { type: 'textBlock', action: 'text', caption: this.model.loc('FindWhat').replace(":", ""), margin: '2px' },
            { type: 'textBox', action: 'findTextBox', margin: '2px' },
            { type: 'button', action: 'FindPreviows', caption: this.model.loc('FindPrevious'), img: 'Arrows.ArrowUpBlue.png', margin: '2px' },
            { type: 'button', action: 'FindNext', caption: this.model.loc('FindNext'), img: 'Arrows.ArrowDownBlue.png', margin: '2px' },
            { type: 'button', action: 'MatchCase', caption: this.model.loc('MatchCase').replace('&', ''), margin: '2px' },
            { type: 'button', action: 'MatchWholeWord', caption: this.model.loc('MatchWholeWord').replace('&', ''), margin: '2px' }
        ];
    }
    action(action) {
        switch (action) {
            case 'close':
                this.model.controls.findPanel.visible = false;
                break;
            case 'MatchCase':
                this.findService.matchCase = !this.findService.matchCase;
                this.changeFind = true;
                break;
            case 'MatchWholeWord':
                this.findService.matchWholeWord = !this.findService.matchWholeWord;
                this.changeFind = true;
                break;
            case 'FindPreviows':
                this.findService.text = this.textBox.element.nativeElement.value;
                this.find('Previous');
                break;
            case 'FindNext':
                this.findService.text = this.textBox.element.nativeElement.value;
                this.find('Next');
                break;
        }
    }
}
FindPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindPanelComponent, deps: [{ token: ModelService }, { token: FindService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Component });
FindPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: FindPanelComponent, selector: "sti-find-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }, { propertyName: "textBox", first: true, predicate: ["textBox"], descendants: true }], ngImport: i0, template: `
    <div #element [style.display]="model.controls.findPanel.visible ? '' : 'none'"
    [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''" style="box-sizing: border-box">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 0">
            <tbody>
                <tr class="stiJsViewerClearAllStyles">
                   <td *ngFor="let item of items"  class="stiJsViewerClearAllStyles">
                      <sti-button *ngIf="item.type=='button'"
                        [actionName]="item.action"
                        [imageName]="item.img"
                        [caption]="item.caption"
                        [margin]="item.margin"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : ''"
                        (action)="action(item.action)"
                        [selected]="selected(item)"
                        ></sti-button>
                      <sti-text-box #textBox *ngIf="item.type=='textBox'" [width]="170"
                        [margin]="item.margin"
                        [focusOnCreate]="true"
                        (action)="textBoxAction($event)"
                        [value]="findService.text"></sti-text-box>
                      <sti-text-block *ngIf="item.type=='textBlock'" [margin]="item.margin" [text]="item.caption"></sti-text-block>
                  </td>
                </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: TextBlockComponent, selector: "sti-text-block", inputs: ["text", "margin"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-find-panel',
                    template: `
    <div #element [style.display]="model.controls.findPanel.visible ? '' : 'none'"
    [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''" style="box-sizing: border-box">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 0">
            <tbody>
                <tr class="stiJsViewerClearAllStyles">
                   <td *ngFor="let item of items"  class="stiJsViewerClearAllStyles">
                      <sti-button *ngIf="item.type=='button'"
                        [actionName]="item.action"
                        [imageName]="item.img"
                        [caption]="item.caption"
                        [margin]="item.margin"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : ''"
                        (action)="action(item.action)"
                        [selected]="selected(item)"
                        ></sti-button>
                      <sti-text-box #textBox *ngIf="item.type=='textBox'" [width]="170"
                        [margin]="item.margin"
                        [focusOnCreate]="true"
                        (action)="textBoxAction($event)"
                        [value]="findService.text"></sti-text-box>
                      <sti-text-block *ngIf="item.type=='textBlock'" [margin]="item.margin" [text]="item.caption"></sti-text-block>
                  </td>
                </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: FindService }, { type: ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], textBox: [{
                type: ViewChild,
                args: ['textBox']
            }] } });

class BookmarksPanelComponent {
    constructor(model, helper, controller) {
        this.model = model;
        this.helper = helper;
        this.controller = controller;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                setTimeout(() => {
                    if (this.model.reportParams.bookmarksContent != null) {
                        this.create();
                    }
                    this.model.controls.bookmarksPanel.visible = this.model.reportParams.bookmarksContent !== null && !this.model.options.isMobileDevice;
                });
            }
            else {
                // Go to the bookmark, if it present
                setTimeout(() => {
                    if (this.model.options.bookmarkAnchor != null) {
                        this.helper.scrollToAnchor(this.model.options.bookmarkAnchor, this.model.options.componentGuid);
                        this.model.options.bookmarkAnchor = null;
                        this.model.options.componentGuid = null;
                    }
                });
            }
        });
        this.model.controls.bookmarksPanel.getVisibility().subscribe((value) => {
            if (!value) {
                this.helper.removeBookmarksLabel();
                this.clearSelected();
            }
        });
    }
    ngAfterViewInit() {
        this.model.controls.bookmarksPanel.el = this.element;
    }
    ngOnInit() { }
    getImg1(node, i) {
        var _a;
        if (((_a = node.nodes) === null || _a === void 0 ? void 0 : _a.length) === 0) {
            return i !== this.model.nodes.length - 1 ? this.model.imagesForBookmark['join'] : this.model.imagesForBookmark['joinBottom'];
        }
        return node.open ? (i === this.model.nodes.length - 1 ? this.model.imagesForBookmark['minusBottom'] : this.model.imagesForBookmark['minus']) :
            (i === this.model.nodes.length - 1 ? this.model.imagesForBookmark['plusBottom'] : this.model.imagesForBookmark['plus']);
    }
    postAction(node) {
        this.clearSelected();
        this.controller.postBookmarkNodeAction(node);
    }
    clearSelected() {
        var _a;
        (_a = this.model.nodes) === null || _a === void 0 ? void 0 : _a.forEach((n) => {
            n.selected = false;
            n.nodes.forEach(element => element.selected = false);
        });
    }
    create() {
        let bookmarks;
        if (this.model.reportParams.bookmarksContent.indexOf('bookmarks.add(') >= 0) {
            bookmarks = this.model.reportParams.bookmarksContent.split('bookmarks.add(');
        }
        else {
            bookmarks = this.model.reportParams.bookmarksContent.split('window.StiBookmarks.add(');
        }
        const root = bookmarks[1].replace('0,-1,\'', '');
        this.rootName = root.substr(0, root.indexOf('\''));
        const nodes = [];
        this.parseNodes(bookmarks.splice(2), 0, nodes);
        this.model.nodes = nodes;
    }
    parseNodes(bookmarks, index, nodes) {
        let folder;
        bookmarks.forEach((bookmark) => {
            const str = bookmark.substr(bookmark.indexOf(',') + 1);
            const nodeType = parseInt(str.substr(0, str.indexOf(',')), 10);
            const node = this.parseNode(str);
            if (nodeType === 0) {
                nodes.push(node);
                folder = node;
            }
            else {
                folder.nodes.push(node);
            }
        });
    }
    parseNode(str) {
        str = str.substr(str.indexOf(',') + 2);
        const name = this.unescape(str.substr(0, str.indexOf('\',')));
        str = str.substr(str.indexOf('\',') + 3);
        const url = str.substr(0, str.indexOf('\','));
        str = str.substr(str.indexOf('\',') + 3);
        const pageTitle = str.substr(0, str.indexOf('\','));
        str = str.substr(str.indexOf('\',') + 3);
        const componentGuid = str.substr(0, str.length - 3);
        return { name, url, page: parseInt(pageTitle.substr(5), 10) - 1, compunentGuid: componentGuid, nodes: [], open: false, selected: false };
    }
    unescape(str) {
        return str.replace(/\\&apos;/g, '\'')
            .replace(/\\&quot;/g, '"')
            .replace(/\\&gt;/g, '>')
            .replace(/\\&lt;/g, '<')
            .replace(/\\&amp;/g, '&');
    }
    get bottom() {
        if (this.model.options.isMobileDevice) {
            return this.model.options.toolbar.autoHide ? '0' : '0.5in';
        }
        else {
            return this.model.options.toolbar.displayMode === 'Separated' && this.model.options.toolbar.visible ? '35px' : '0';
        }
    }
}
BookmarksPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: BookmarksPanelComponent, deps: [{ token: ModelService }, { token: HelperService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Component });
BookmarksPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: BookmarksPanelComponent, selector: "sti-bookmarks-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }, { propertyName: "bookmarksPanel", first: true, predicate: ["bookmarksPanel"], descendants: true }], ngImport: i0, template: `
    <div #element [style]="{fontFamily: model.options.toolbar.fontFamily, fontColor: helper.val(model.options.toolbar.fontColor)}"
      [class]="'stiJsViewerBookmarksPanel' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerBookmarksPanelSeparated' : '')"
      [style.width.px]="model.options.appearance.bookmarksTreeWidth - (model.options.toolbar.displayMode == 'Simple' ? 0 : 1)"
      [style.bottom]="bottom"
      [style.top.px]="model.controls.bookmarksPanel.layout.top"
      [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
      [style.display]="!this.model.options.isMobileDevice ? (model.controls.bookmarksPanel.visible ? '' : 'none') : null"
      [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.bookmarksPanel.visible ? 'visible' : 'hidden')">
      <div #bookmarksPanel [class]="'stiJsViewerBookmarksContainer' + (model.options.toolbar.displayMode == 'Simple' ? ' stiJsViewerBookmarksContainerSimple' : '')"
           [style.background]="helper.val(model.options.toolbar.backgroundColor)"
           [style.border]="helper.val(model.options.toolbar.borderColor) != '' ? '1px solid ' + helper.val(model.options.toolbar.borderColor): ''">
           <div class="stiTree">
              <div class="stiTreeNode">
                <img style="width: 16px; height: 16px;" [src]="model.imagesForBookmark['root']"/>
                <a class="node">{{rootName}}</a>
              </div>
              <div class="clip" style="display:block;">
                <ng-container *ngFor="let node of model.nodes; index as i">
                    <div class="stiTreeNode">
                        <a (click)="node.open = !node.open">
                            <img style="width: 18px; height: 18px"
                             [src]="getImg1(node, i)"/>
                        </a>
                        <img style="width: 16px; height: 16px;" [src]="node.nodes?.length == 0 ? model.imagesForBookmark['node'] :(node.open ? model.imagesForBookmark['folderOpen'] : model.imagesForBookmark['folder'])"/>
                        <a [class]="node.selected ? 'nodeSel' : 'node'" (click)="postAction(node)">{{node.name}}</a>
                    </div>
                    <div class="clip" [style.display]="node.open ? 'block' : 'none'">
                      <div *ngFor="let subNode of node.nodes; index as k" class="stiTreeNode">
                        <img style="width: 18px; height: 18px;" [src]="i != model.nodes.length - 1 ? model.imagesForBookmark['line'] : model.imagesForBookmark['empty']"/>
                        <img style="width: 18px; height: 18px;" [src]="k == node.nodes.length - 1 ? model.imagesForBookmark['joinBottom'] : model.imagesForBookmark['join']"/>
                        <img style="width: 16px; height: 16px;" [src]="model.imagesForBookmark['node']" />
                        <a [class]="subNode.selected ? 'nodeSel' : 'node'" (click)="postAction(subNode)">{{subNode.name}}</a>
                      </div>
                    </div>
                </ng-container>
              </div>
          </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }], animations: [
        trigger('visibility', [
            state('visible', style({ opacity: 1, display: 'block' })),
            state('hidden', style({ opacity: 0, display: 'none' })),
            transition('hidden => visible', [
                animate('300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 0, offset: 0 }),
                    style({ display: 'block', opacity: 1, offset: 1 }),
                ]))
            ]),
            transition('visible => hidden', [
                animate('300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 1, offset: 0 }),
                    style({ display: 'none', opacity: 0, offset: 1 }),
                ]))
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: BookmarksPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-bookmarks-panel',
                    template: `
    <div #element [style]="{fontFamily: model.options.toolbar.fontFamily, fontColor: helper.val(model.options.toolbar.fontColor)}"
      [class]="'stiJsViewerBookmarksPanel' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerBookmarksPanelSeparated' : '')"
      [style.width.px]="model.options.appearance.bookmarksTreeWidth - (model.options.toolbar.displayMode == 'Simple' ? 0 : 1)"
      [style.bottom]="bottom"
      [style.top.px]="model.controls.bookmarksPanel.layout.top"
      [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
      [style.display]="!this.model.options.isMobileDevice ? (model.controls.bookmarksPanel.visible ? '' : 'none') : null"
      [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.bookmarksPanel.visible ? 'visible' : 'hidden')">
      <div #bookmarksPanel [class]="'stiJsViewerBookmarksContainer' + (model.options.toolbar.displayMode == 'Simple' ? ' stiJsViewerBookmarksContainerSimple' : '')"
           [style.background]="helper.val(model.options.toolbar.backgroundColor)"
           [style.border]="helper.val(model.options.toolbar.borderColor) != '' ? '1px solid ' + helper.val(model.options.toolbar.borderColor): ''">
           <div class="stiTree">
              <div class="stiTreeNode">
                <img style="width: 16px; height: 16px;" [src]="model.imagesForBookmark['root']"/>
                <a class="node">{{rootName}}</a>
              </div>
              <div class="clip" style="display:block;">
                <ng-container *ngFor="let node of model.nodes; index as i">
                    <div class="stiTreeNode">
                        <a (click)="node.open = !node.open">
                            <img style="width: 18px; height: 18px"
                             [src]="getImg1(node, i)"/>
                        </a>
                        <img style="width: 16px; height: 16px;" [src]="node.nodes?.length == 0 ? model.imagesForBookmark['node'] :(node.open ? model.imagesForBookmark['folderOpen'] : model.imagesForBookmark['folder'])"/>
                        <a [class]="node.selected ? 'nodeSel' : 'node'" (click)="postAction(node)">{{node.name}}</a>
                    </div>
                    <div class="clip" [style.display]="node.open ? 'block' : 'none'">
                      <div *ngFor="let subNode of node.nodes; index as k" class="stiTreeNode">
                        <img style="width: 18px; height: 18px;" [src]="i != model.nodes.length - 1 ? model.imagesForBookmark['line'] : model.imagesForBookmark['empty']"/>
                        <img style="width: 18px; height: 18px;" [src]="k == node.nodes.length - 1 ? model.imagesForBookmark['joinBottom'] : model.imagesForBookmark['join']"/>
                        <img style="width: 16px; height: 16px;" [src]="model.imagesForBookmark['node']" />
                        <a [class]="subNode.selected ? 'nodeSel' : 'node'" (click)="postAction(subNode)">{{subNode.name}}</a>
                      </div>
                    </div>
                </ng-container>
              </div>
          </div>
      </div>
    </div>
  `,
                    animations: [
                        trigger('visibility', [
                            state('visible', style({ opacity: 1, display: 'block' })),
                            state('hidden', style({ opacity: 0, display: 'none' })),
                            transition('hidden => visible', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 0, offset: 0 }),
                                    style({ display: 'block', opacity: 1, offset: 1 }),
                                ]))
                            ]),
                            transition('visible => hidden', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 1, offset: 0 }),
                                    style({ display: 'none', opacity: 0, offset: 1 }),
                                ]))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }, { type: ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], bookmarksPanel: [{
                type: ViewChild,
                args: ['bookmarksPanel']
            }] } });

class FormButtonComponent {
    constructor() {
        this.captionAlign = 'center';
        this.action = new EventEmitter();
    }
    ngOnInit() { }
    onaction(event) {
        this.action.emit(event);
    }
}
FormButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
FormButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: FormButtonComponent, selector: "sti-form-button", inputs: { caption: "caption", actionName: "actionName", imageName: "imageName", imageCellWidth: "imageCellWidth", captionPadding: "captionPadding", margin: "margin", captionAlign: "captionAlign" }, outputs: { action: "action" }, ngImport: i0, template: `
      <sti-button [styleName]="'stiJsViewerFormButton'"
                  [caption]="caption"
                  [actionName]="actionName"
                  [captionAlign]="captionAlign"
                  [innerTableWidth]="'100%'"
                  [minWidth]="'80px'"
                  [imageName]="imageName"
                  [imageCellWidth]="imageCellWidth"
                  [captionPadding]="captionPadding"
                  [margin]="margin"
                  (action)="onaction($event)">
      </sti-button>
  `, isInline: true, dependencies: [{ kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-form-button',
                    template: `
      <sti-button [styleName]="'stiJsViewerFormButton'"
                  [caption]="caption"
                  [actionName]="actionName"
                  [captionAlign]="captionAlign"
                  [innerTableWidth]="'100%'"
                  [minWidth]="'80px'"
                  [imageName]="imageName"
                  [imageCellWidth]="imageCellWidth"
                  [captionPadding]="captionPadding"
                  [margin]="margin"
                  (action)="onaction($event)">
      </sti-button>
  `
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { caption: [{
                type: Input
            }], actionName: [{
                type: Input
            }], imageName: [{
                type: Input
            }], imageCellWidth: [{
                type: Input
            }], captionPadding: [{
                type: Input
            }], margin: [{
                type: Input
            }], captionAlign: [{
                type: Input
            }], action: [{
                type: Output
            }] } });

class ParameterComponent {
    constructor(model, helper, menuService, intearctionService) {
        this.model = model;
        this.helper = helper;
        this.menuService = menuService;
        this.intearctionService = intearctionService;
    }
    ngOnInit() { }
    get params() {
        return this._params;
    }
    set params(params) {
        this._params = params;
        if (params.basicType === 'Range') {
            if (params.type === 'DateTime' && params.keyTo && params.keyTo.isNull) {
                params.keyTo = this.helper.getDateTimeObject(new Date());
            }
        }
    }
    get showParameterInTwoRows() {
        return this.params.basicType === 'Range' && this.model.options.appearance.parametersPanelPosition === 'Left';
    }
    getReadOnlyCheckbox() {
        return this.params.basicType === 'List' || !this.params.allowUserValues;
    }
    getFirstTextBoxValue() {
        let value = '';
        if (this.params.basicType === 'Value' || this.params.basicType === 'NullableValue') {
            if (this.params.type === 'DateTime' && this.params.value === null) {
                this.params.value = new Date();
                this.params.key = this.helper.getDateTimeObject(this.params.value);
            }
            value = (this.params.type === 'DateTime') ? this.helper.getStringKey(this.params.key, this.params) : (this.params.allowUserValues ? this.params.key :
                (this.params.value != "" || !this.params.isChanged ? this.params.value : this.params.key));
        }
        // Range
        if (this.params.basicType === 'Range') {
            if (this.params.type === 'DateTime' && this.params.key && this.params.key.isNull) {
                this.params.key = this.helper.getDateTimeObject(new Date());
            }
            value = this.helper.getStringKey(this.params.key, this.params);
        }
        // List
        if (this.params.basicType === 'List' && this.params.items) {
            this.params.items.forEach((item) => {
                if (item.isChecked) {
                    if (value !== '') {
                        value += (this.model.options.listSeparator ? this.model.options.listSeparator + " " : "; ");
                    }
                    if (this.params.allowUserValues) {
                        value += this.helper.getStringKey(item.key, this.params);
                    }
                    else {
                        value += item.value !== '' ? item.value : this.helper.getStringKey(item.key, this.params);
                    }
                }
            });
        }
        return value != null ? value.toString() : value;
    }
    firstGuidAction() {
        if (this.params.basicType === 'Range') {
            this.params.key = this.helper.newGuid();
        }
        else {
            this.params.key = this.params.value = this.helper.newGuid();
        }
    }
    doubleDateTimeAction(event) {
        this.menuService.addMenu({
            type: 'doubleDatePickerMenu', name: 'doubleDatePickerMenu', items: [], parent: this.rangeFrom,
            params: this.params,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu('doubleDatePickerMenu');
        });
    }
    firstDateTimeAction(event) {
        this.menuService.addMenu({
            type: 'datePickerMenu', name: 'datePickerMenu', items: [], parent: this.firstDateTimeButton,
            params: this.params,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu('datePickerMenu');
        });
    }
    dropDownButtonAction(event) {
        let menuType = 'parameterMenuForValue';
        switch (this.params.basicType) {
            case 'Range':
                menuType = 'parameterMenuForRange';
                break;
            case 'List':
                menuType = this.params.allowUserValues ? 'parameterMenuForEditList' : 'parameterMenuForNotEditList';
                break;
        }
        if (this.params.items) {
            this.params.items.forEach(i => i.visible = true);
        }
        let this_ = this;
        this.menuService.addMenu({
            type: menuType, name: 'parameterMenu', items: [], parent: this.element,
            params: this.params,
            state: '',
            onCloseEvent: () => {
                this_.onCloseMenuEvent();
            }
        });
        setTimeout(() => {
            this.menuService.showMenu('parameterMenu');
        });
    }
    onCloseMenuEvent() {
        if (this.params.binding) {
            if (!this.model.options.paramsVariablesStartValues) {
                this.model.options.paramsVariablesStartValues = this.helper.copyObject(this.model.options.paramsVariables);
            }
            this.intearctionService.postInteraction({ action: 'InitVars', variables: this.intearctionService.getParametersValues(), isBindingVariable: true });
        }
    }
}
ParameterComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterComponent, deps: [{ token: ModelService }, { token: HelperService }, { token: MenuService }, { token: InteractionsService }], target: i0.ɵɵFactoryTarget.Component });
ParameterComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterComponent, selector: "sti-parameter", inputs: { params: "params" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }, { propertyName: "firstDateTimeButton", first: true, predicate: ["firstDateTimeButton"], descendants: true }, { propertyName: "doubleDateTimeButton", first: true, predicate: ["doubleDateTimeButton"], descendants: true }, { propertyName: "rangeFrom", first: true, predicate: ["rangeFrom"], descendants: true }], ngImport: i0, template: `
    <table #element class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" #rangeFrom>
       <tbody>
          <tr class="stiJsViewerClearAllStyles" >
            <td *ngIf="params.type == 'Bool' && (params.basicType == 'Value' || params.basicType == 'NullableValue')"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-checkbox [params]="params" [isEnabled]="params.allowUserValues" (action)="params.value = $event" [nullable]="params.basicType == 'NullableValue'">
                </sti-parameter-checkbox>
            </td>

            <td *ngIf="params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'"  style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                {{model.loc('RangeFrom')}}
            </td>

            <td *ngIf="params.type != 'Bool' || params.basicType == 'List'"
                [style.position]="(params.basicType == 'NullableValue' || params.allowNullableString) && params.allowUserValues ? 'relative' : ''"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-text-box [variable]="params"
                    [readOnly]="getReadOnlyCheckbox()"
                    [value]="getFirstTextBoxValue()">
                </sti-parameter-text-box>
            </td>

            <td *ngIf="params.type == 'DateTime' && params.allowUserValues && params.basicType != 'List' && params.basicType != 'Range'"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight" #firstDateTimeButton>
                <sti-parameter-button [buttonType]="'DateTimeButton'" [params]="params"  (action)="firstDateTimeAction($event)">
                </sti-parameter-button>
            </td>

            <td *ngIf="params.type == 'Guid' && params.allowUserValues && params.basicType != 'List'"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="firstGuidAction()">
                </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>

          <!-- NEW LINE -->
          <tr *ngIf="showParameterInTwoRows">
            <td *ngIf="params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="params.basicType == 'Range'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>
       </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ParameterTextBoxComponent, selector: "sti-parameter-text-box", inputs: ["item", "variable", "readOnly", "focusOnCreate", "isMenu", "value", "secondTextBox"] }, { kind: "component", type: ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: ["params", "captionText", "margin", "width", "imageBlockParentWidth", "isEnabled", "isMenuParameter", "paramNull", "nullable"], outputs: ["action"] }, { kind: "component", type: ParameterButtonComponent, selector: "sti-parameter-button", inputs: ["params", "buttonType"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter',
                    template: `
    <table #element class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" #rangeFrom>
       <tbody>
          <tr class="stiJsViewerClearAllStyles" >
            <td *ngIf="params.type == 'Bool' && (params.basicType == 'Value' || params.basicType == 'NullableValue')"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-checkbox [params]="params" [isEnabled]="params.allowUserValues" (action)="params.value = $event" [nullable]="params.basicType == 'NullableValue'">
                </sti-parameter-checkbox>
            </td>

            <td *ngIf="params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'"  style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                {{model.loc('RangeFrom')}}
            </td>

            <td *ngIf="params.type != 'Bool' || params.basicType == 'List'"
                [style.position]="(params.basicType == 'NullableValue' || params.allowNullableString) && params.allowUserValues ? 'relative' : ''"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-text-box [variable]="params"
                    [readOnly]="getReadOnlyCheckbox()"
                    [value]="getFirstTextBoxValue()">
                </sti-parameter-text-box>
            </td>

            <td *ngIf="params.type == 'DateTime' && params.allowUserValues && params.basicType != 'List' && params.basicType != 'Range'"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight" #firstDateTimeButton>
                <sti-parameter-button [buttonType]="'DateTimeButton'" [params]="params"  (action)="firstDateTimeAction($event)">
                </sti-parameter-button>
            </td>

            <td *ngIf="params.type == 'Guid' && params.allowUserValues && params.basicType != 'List'"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="firstGuidAction()">
                </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>

          <!-- NEW LINE -->
          <tr *ngIf="showParameterInTwoRows">
            <td *ngIf="params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="params.basicType == 'Range'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>
       </tbody>
    </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }, { type: MenuService }, { type: InteractionsService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], firstDateTimeButton: [{
                type: ViewChild,
                args: ['firstDateTimeButton']
            }], doubleDateTimeButton: [{
                type: ViewChild,
                args: ['doubleDateTimeButton']
            }], rangeFrom: [{
                type: ViewChild,
                args: ['rangeFrom']
            }], params: [{
                type: Input
            }] } });

class InteractionsPanelComponent {
    constructor(model, helper, interactionService, menuService, controller) {
        this.model = model;
        this.helper = helper;
        this.interactionService = interactionService;
        this.menuService = menuService;
        this.controller = controller;
        this.currentOpeningParameter = null;
        this.dropDownButtonWasClicked = false;
        this.dateTimeButtonWasClicked = false;
    }
    ngAfterViewInit() {
        this.model.controls.parametersPanel.el = this.element;
    }
    ngOnInit() { }
    getNameAlign(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        if (index < this.length() &&
            this.model.interactions.paramsVariables[index].basicType === 'Range' &&
            this.model.options.appearance.parametersPanelPosition === 'Left') {
            return 'top';
        }
        return '';
    }
    getNamePadding(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        if (index < this.length() &&
            this.model.interactions.paramsVariables[index].basicType === 'Range' &&
            this.model.options.appearance.parametersPanelPosition === 'Left') {
            return this.model.options.isTouchDevice ? '11px' : '9px';
        }
        return '';
    }
    getCaption(indexRow, indexColumn, checkLeft = true) {
        const index = this.index(indexRow, indexColumn);
        if (checkLeft && this.ifLeftRange(indexRow, indexColumn)) {
            return '';
        }
        return index < this.length() ? this.model.interactions.paramsVariables[index].alias : '';
    }
    ifLeftRange(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        return this.model.interactions.paramsVariables[index].basicType === 'Range' && this.model.options.appearance.parametersPanelPosition === 'Left';
    }
    getTitle(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        return index < this.length() ? this.model.interactions.paramsVariables[index].description : '';
    }
    index(indexRow, indexColumn) {
        return indexColumn * this.model.interactions.countInColumn.length + indexRow;
    }
    length() {
        var _a, _b;
        return ((_a = this.model.interactions) === null || _a === void 0 ? void 0 : _a.paramsVariables) != null ? Object.keys((_b = this.model.interactions) === null || _b === void 0 ? void 0 : _b.paramsVariables).length : 0;
    }
    get className() {
        let className = 'stiJsViewerParametersPanel';
        if (this.model.options.appearance.parametersPanelPosition === 'Top') {
            className += ' stiJsViewerParametersPanelTop';
            if (this.model.options.toolbar.displayMode === 'Separated') {
                className += ' stiJsViewerParametersPanelSeparatedTop';
            }
        }
        return className;
    }
    get top() {
        let styleTop = this.model.options.toolbar.visible ? this.model.controls.toolbar.offsetHeight : 0;
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            styleTop = 0;
        }
        styleTop += this.model.controls.drillDownPanel.exists ? this.model.controls.drillDownPanel.offsetHeight : 0;
        styleTop += this.model.controls.findPanel.exists ? this.model.controls.findPanel.offsetHeight : 0;
        styleTop += this.model.controls.resourcesPanel.exists ? this.model.controls.resourcesPanel.offsetHeight : 0;
        return styleTop;
    }
    get bottom() {
        if (this.model.options.appearance.parametersPanelPosition === 'Left') {
            if (this.model.options.isMobileDevice) {
                return this.model.options.toolbar.autoHide ? '0' : '0.5in';
            }
            else {
                return this.model.options.toolbar.displayMode === 'Separated' && this.model.options.toolbar.visible ? '35px' : '0';
            }
        }
        return '';
    }
    get innerClassName() {
        let className = this.model.options.toolbar.displayMode === 'Simple' ? 'stiJsViewerInnerParametersPanelSimple' : '';
        if (this.model.options.appearance.parametersPanelPosition === 'Left') {
            className += ' stiJsViewerInnerParametersPanelLeft';
            if (this.model.options.toolbar.displayMode === 'Separated') {
                className += ' stiJsViewerInnerParametersPanelSeparatedLeft';
            }
        }
        return className;
    }
}
InteractionsPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsPanelComponent, deps: [{ token: ModelService }, { token: HelperService }, { token: InteractionsService }, { token: MenuService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Component });
InteractionsPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: InteractionsPanelComponent, selector: "sti-interactions-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element [class]="className"
       [style.display]="!this.model.options.isMobileDevice ? (model.controls.parametersPanel.visible ? '' : 'none') : null"
       [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbar.fontColor"
       [style.top.px]="top"
       [style.left.px]="model.controls.parametersPanel.layout.left"
       [style.bottom]="bottom"
       [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
       [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.parametersPanel.visible ? 'visible' : 'hidden')">
       <div [class]="innerClassName" [style.marginTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''" (scroll)="menuService.closeAllMenus()">
         <div class="stiJsViewerInnerContainerParametersPanel"
              [style.background]="helper.val(model.options.toolbar.backgroundColor, '')"
              [style.border]="helper.val(model.options.toolbar.backgroundColor, '') != '' ? '1px solid ' + helper.val(model.options.toolbar.backgroundColor, '') : ''"
              [style.maxHeight]="model.options.appearance.parametersPanelPosition == 'Top' ? model.options.appearance.parametersPanelMaxHeight + 'px' : ''"
              (scroll)="menuService.closeAllMenus()">
            <table *ngIf="model.interactions" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="border: 0px;">
              <tbody>
                <tr *ngFor="let item of model.interactions.countInColumn; let indexRow=index" >
                  <ng-container *ngFor="let item2 of model.interactions.countColumns; let indexColumn=index">
                    <ng-container *ngIf="index(indexRow, indexColumn) < length()">
                        <td [style.padding]="'0 10px 0 ' + (indexColumn > 0 ? '30px' : '0')"
                            [style.whiteSpace]="'nowrap'"
                            [style.verticalAlign]='getNameAlign(indexRow, indexColumn)'
                            [style.paddingTop]='getNamePadding(indexRow, indexColumn)'
                            [attr.title]='getTitle(indexRow, indexColumn)'>
                            {{getCaption(indexRow, indexColumn)}}
                              <table *ngIf="ifLeftRange(indexRow, indexColumn)" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 60px;">
                                <tbody>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" rowspan="2" style="vertical-align: top; padding-top: 9px;">
                                      {{getCaption(indexRow, indexColumn, false)}}
                                    </td>
                                    <td class="stiJsViewerClearAllStyles" style="padding-left: 12px;">
                                      {{model.loc('RangeFrom')}}
                                    </td>
                                  </tr>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" style="padding-left: 12px;">
                                      {{model.loc('RangeTo')}}
                                    </td>
                                  </tr>
                                </tbody>
                              </table>
                            </td>
                        <td [style.padding]="'0px'">
                          <sti-parameter *ngIf="index(indexRow, indexColumn) != length()"  [params]="model.interactions.paramsVariables[index(indexRow, indexColumn)]"></sti-parameter>

                          <!--table *ngIf="index(indexRow, indexColumn) == length()" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                            align="right" style="margin: 5px 2px 10px 0px;">
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                              </td>
                              <td class="stiJsViewerClearAllStyles" style="padding-left: 10px;">
                                <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                              </td>
                            </tr>
                          </table-->
                        </td>
                    </ng-container>
                  </ng-container>
                </tr>
                <tr><!--*ngIf="length() == model.interactions.countInColumn.length * model.interactions.countColumns.length"-->
                  <td></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td [style.padding]="'0px'">
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                         align="right" style="margin: 5px 2px 10px 0px;">
                         <tr class="stiJsViewerClearAllStyles">
                           <td class="stiJsViewerClearAllStyles">
                             <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                           </td>
                           <td class="stiJsViewerClearAllStyles" style="padding-left: 10px;">
                              <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                           </td>
                         </tr>
                       </table>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: FormButtonComponent, selector: "sti-form-button", inputs: ["caption", "actionName", "imageName", "imageCellWidth", "captionPadding", "margin", "captionAlign"], outputs: ["action"] }, { kind: "component", type: ParameterComponent, selector: "sti-parameter", inputs: ["params"] }], animations: [
        trigger('visibility', [
            state('visible', style({ opacity: 1, display: 'block' })),
            state('hidden', style({ opacity: 0, display: 'none' })),
            transition('hidden => visible', [
                animate('300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 0, offset: 0 }),
                    style({ display: 'block', opacity: 1, offset: 1 }),
                ]))
            ]),
            transition('visible => hidden', [
                animate('300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 1, offset: 0 }),
                    style({ display: 'none', opacity: 0, offset: 1 }),
                ]))
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-interactions-panel',
                    template: `
    <div #element [class]="className"
       [style.display]="!this.model.options.isMobileDevice ? (model.controls.parametersPanel.visible ? '' : 'none') : null"
       [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbar.fontColor"
       [style.top.px]="top"
       [style.left.px]="model.controls.parametersPanel.layout.left"
       [style.bottom]="bottom"
       [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
       [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.parametersPanel.visible ? 'visible' : 'hidden')">
       <div [class]="innerClassName" [style.marginTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''" (scroll)="menuService.closeAllMenus()">
         <div class="stiJsViewerInnerContainerParametersPanel"
              [style.background]="helper.val(model.options.toolbar.backgroundColor, '')"
              [style.border]="helper.val(model.options.toolbar.backgroundColor, '') != '' ? '1px solid ' + helper.val(model.options.toolbar.backgroundColor, '') : ''"
              [style.maxHeight]="model.options.appearance.parametersPanelPosition == 'Top' ? model.options.appearance.parametersPanelMaxHeight + 'px' : ''"
              (scroll)="menuService.closeAllMenus()">
            <table *ngIf="model.interactions" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="border: 0px;">
              <tbody>
                <tr *ngFor="let item of model.interactions.countInColumn; let indexRow=index" >
                  <ng-container *ngFor="let item2 of model.interactions.countColumns; let indexColumn=index">
                    <ng-container *ngIf="index(indexRow, indexColumn) < length()">
                        <td [style.padding]="'0 10px 0 ' + (indexColumn > 0 ? '30px' : '0')"
                            [style.whiteSpace]="'nowrap'"
                            [style.verticalAlign]='getNameAlign(indexRow, indexColumn)'
                            [style.paddingTop]='getNamePadding(indexRow, indexColumn)'
                            [attr.title]='getTitle(indexRow, indexColumn)'>
                            {{getCaption(indexRow, indexColumn)}}
                              <table *ngIf="ifLeftRange(indexRow, indexColumn)" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 60px;">
                                <tbody>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" rowspan="2" style="vertical-align: top; padding-top: 9px;">
                                      {{getCaption(indexRow, indexColumn, false)}}
                                    </td>
                                    <td class="stiJsViewerClearAllStyles" style="padding-left: 12px;">
                                      {{model.loc('RangeFrom')}}
                                    </td>
                                  </tr>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" style="padding-left: 12px;">
                                      {{model.loc('RangeTo')}}
                                    </td>
                                  </tr>
                                </tbody>
                              </table>
                            </td>
                        <td [style.padding]="'0px'">
                          <sti-parameter *ngIf="index(indexRow, indexColumn) != length()"  [params]="model.interactions.paramsVariables[index(indexRow, indexColumn)]"></sti-parameter>

                          <!--table *ngIf="index(indexRow, indexColumn) == length()" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                            align="right" style="margin: 5px 2px 10px 0px;">
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                              </td>
                              <td class="stiJsViewerClearAllStyles" style="padding-left: 10px;">
                                <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                              </td>
                            </tr>
                          </table-->
                        </td>
                    </ng-container>
                  </ng-container>
                </tr>
                <tr><!--*ngIf="length() == model.interactions.countInColumn.length * model.interactions.countColumns.length"-->
                  <td></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td [style.padding]="'0px'">
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                         align="right" style="margin: 5px 2px 10px 0px;">
                         <tr class="stiJsViewerClearAllStyles">
                           <td class="stiJsViewerClearAllStyles">
                             <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                           </td>
                           <td class="stiJsViewerClearAllStyles" style="padding-left: 10px;">
                              <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                           </td>
                         </tr>
                       </table>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
      </div>
    </div>
  `,
                    animations: [
                        trigger('visibility', [
                            state('visible', style({ opacity: 1, display: 'block' })),
                            state('hidden', style({ opacity: 0, display: 'none' })),
                            transition('hidden => visible', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 0, offset: 0 }),
                                    style({ display: 'block', opacity: 1, offset: 1 }),
                                ]))
                            ]),
                            transition('visible => hidden', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 1, offset: 0 }),
                                    style({ display: 'none', opacity: 0, offset: 1 }),
                                ]))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }, { type: InteractionsService }, { type: MenuService }, { type: ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

class BaseFormComponent {
    constructor(model, helper, formService) {
        this.model = model;
        this.helper = helper;
        this.formService = formService;
        this.changeVisibility = new EventEmitter();
        this.action = new EventEmitter();
        this.level = 1;
        this.showCancel = true;
        this.showButtons = true;
        this.showSeparator = true;
        this.display = 'none';
    }
    ngOnInit() { }
    startAnimation(event) {
        if (event.toState === 'visible') {
            this.display = '';
            if (this.defaultTop != null) {
                this.formService.centerForm(this, this.defaultTop);
            }
        }
    }
    doneAnimation(event) {
        if (event.toState === 'hidden') {
            this.display = 'none';
        }
        this.changeVisibility.emit(event.toState);
    }
}
BaseFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: BaseFormComponent, deps: [{ token: ModelService }, { token: HelperService }, { token: FormService }], target: i0.ɵɵFactoryTarget.Component });
BaseFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: BaseFormComponent, selector: "sti-base-form", inputs: { level: "level", caption: "caption", helpUrl: "helpUrl", fontFamily: "fontFamily", color: "color", fontSize: "fontSize", containerPadding: "containerPadding", name: "name", defaultTop: "defaultTop", showCancel: "showCancel", showButtons: "showButtons", showSeparator: "showSeparator" }, outputs: { changeVisibility: "changeVisibility", action: "action" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element class="stiJsViewerForm"
      [style.zIndex]="level * 10 + 1"
      [@.disabled]="!model.options.toolbar.menuAnimation"
      [style.fontFamily]="fontFamily"
      [style.color]="color"
      [style.fontSize]="fontSize"
      [style.left.px]="formService.form?.left"
      [style.top.px]="formService.form?.top"
      [style.display]="display"
      [@showForm]="formService.form?.name == name ? 'visible' : 'hidden'"
      (@showForm.start)="startAnimation($event)"
      (@showForm.done)="doneAnimation($event)">
      <div class="stiJsViewerFormHeader"
        (mousedown)="formService.startMove(name, $event)"
        (touchstart)="formService.startMove(name, null, $event)"
        (touchmove)="formService.move($event)"
        (touchend)="formService.stopMove()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="text-align: left; padding: 5px 10px 8px 15px;">
                {{caption}}
              </td>
              <td *ngIf="helpUrl != null && model.options.appearance.showDialogsHelp" class="stiJsViewerClearAllStyles" style="width: 20px; text-align: right; padding: 2px 0px 1px 0px; vertical-align: top;">
                <sti-button [imageMargin]="'0 2px 0 2px'" [display]="'inline-block'" (action)="helper.showHelpWindow(helpUrl)">
                </sti-button>
              </td>
              <td class="stiJsViewerClearAllStyles" style="vertical-align: top; width: 30px; text-align: right; padding: 2px 1px 1px;">
                <sti-button [imageMargin]="'0 2px 0 2px'" [display]="'inline-block'" [imageName]="'CloseForm.png'" (action)="formService.closeForm(name)">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
      </div>

      <div class="stiJsViewerFormContainer" [style.padding]="containerPadding">
        <ng-content>
        </ng-content>
      </div>

      <div *ngIf="showSeparator" class="stiJsViewerFormSeparator"></div>

      <div *ngIf="showButtons" class="stiJsViewerFormButtonsPanel">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding: 8px;">
                <sti-form-button [caption]="model.loc('ButtonOk')" (action)="action.emit()">
                </sti-form-button>
              </td>
              <td *ngIf="showCancel" class="stiJsViewerClearAllStyles" style="padding: 8px 8px 8px 0px;">
                <sti-form-button [caption]="model.loc('ButtonCancel')" (action)="formService.closeForm(name)">
                </sti-form-button>
              </td>
            </tr>
          </tbody>
        </table>
      </div>

    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: FormButtonComponent, selector: "sti-form-button", inputs: ["caption", "actionName", "imageName", "imageCellWidth", "captionPadding", "margin", "captionAlign"], outputs: ["action"] }], animations: [
        trigger('showForm', [
            state('hidden', style({ opacity: '0' })),
            state('visible', style({ opacity: '1' })),
            transition('hidden => visible', [
                animate('200ms ease-in-out')
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: BaseFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-base-form',
                    template: `
    <div #element class="stiJsViewerForm"
      [style.zIndex]="level * 10 + 1"
      [@.disabled]="!model.options.toolbar.menuAnimation"
      [style.fontFamily]="fontFamily"
      [style.color]="color"
      [style.fontSize]="fontSize"
      [style.left.px]="formService.form?.left"
      [style.top.px]="formService.form?.top"
      [style.display]="display"
      [@showForm]="formService.form?.name == name ? 'visible' : 'hidden'"
      (@showForm.start)="startAnimation($event)"
      (@showForm.done)="doneAnimation($event)">
      <div class="stiJsViewerFormHeader"
        (mousedown)="formService.startMove(name, $event)"
        (touchstart)="formService.startMove(name, null, $event)"
        (touchmove)="formService.move($event)"
        (touchend)="formService.stopMove()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="text-align: left; padding: 5px 10px 8px 15px;">
                {{caption}}
              </td>
              <td *ngIf="helpUrl != null && model.options.appearance.showDialogsHelp" class="stiJsViewerClearAllStyles" style="width: 20px; text-align: right; padding: 2px 0px 1px 0px; vertical-align: top;">
                <sti-button [imageMargin]="'0 2px 0 2px'" [display]="'inline-block'" (action)="helper.showHelpWindow(helpUrl)">
                </sti-button>
              </td>
              <td class="stiJsViewerClearAllStyles" style="vertical-align: top; width: 30px; text-align: right; padding: 2px 1px 1px;">
                <sti-button [imageMargin]="'0 2px 0 2px'" [display]="'inline-block'" [imageName]="'CloseForm.png'" (action)="formService.closeForm(name)">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
      </div>

      <div class="stiJsViewerFormContainer" [style.padding]="containerPadding">
        <ng-content>
        </ng-content>
      </div>

      <div *ngIf="showSeparator" class="stiJsViewerFormSeparator"></div>

      <div *ngIf="showButtons" class="stiJsViewerFormButtonsPanel">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding: 8px;">
                <sti-form-button [caption]="model.loc('ButtonOk')" (action)="action.emit()">
                </sti-form-button>
              </td>
              <td *ngIf="showCancel" class="stiJsViewerClearAllStyles" style="padding: 8px 8px 8px 0px;">
                <sti-form-button [caption]="model.loc('ButtonCancel')" (action)="formService.closeForm(name)">
                </sti-form-button>
              </td>
            </tr>
          </tbody>
        </table>
      </div>

    </div>
  `,
                    animations: [
                        trigger('showForm', [
                            state('hidden', style({ opacity: '0' })),
                            state('visible', style({ opacity: '1' })),
                            transition('hidden => visible', [
                                animate('200ms ease-in-out')
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }, { type: FormService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], changeVisibility: [{
                type: Output
            }], action: [{
                type: Output
            }], level: [{
                type: Input
            }], caption: [{
                type: Input
            }], helpUrl: [{
                type: Input
            }], fontFamily: [{
                type: Input
            }], color: [{
                type: Input
            }], fontSize: [{
                type: Input
            }], containerPadding: [{
                type: Input
            }], name: [{
                type: Input
            }], defaultTop: [{
                type: Input
            }], showCancel: [{
                type: Input
            }], showButtons: [{
                type: Input
            }], showSeparator: [{
                type: Input
            }] } });

class GroupPanelComponent {
    constructor(model) {
        this.model = model;
        this.opened = false;
        this.action = new EventEmitter();
        this.display = 'none';
    }
    ngOnInit() { }
    startAnimation(event) {
        if (event.toState === 'opened') {
            this.display = '';
        }
    }
    doneAnimation(event) {
        if (event.toState === 'closed') {
            this.display = 'none';
        }
    }
}
GroupPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: GroupPanelComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
GroupPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: GroupPanelComponent, selector: "sti-group-panel", inputs: { width: "width", caption: "caption", innerPadding: "innerPadding", opened: "opened", margin: "margin" }, outputs: { action: "action" }, ngImport: i0, template: `
  <div #groupPanel [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbarFontColor"
       [style.minWidth.px]="width"
       [style.margin]="margin"
       style="overflow: hidden">
      <sti-form-button [caption]="caption"
          [imageName]="opened ? 'Arrows.BigArrowDown.png' : 'Arrows.BigArrowRight.png'"
          [imageCellWidth]="'1px'"
          [captionPadding]="'0 15px 0 5px'"
          [margin]="'0px'"
          [captionAlign]="'left'"
          (action)="opened = !opened; action.emit(opened)">
      </sti-form-button>

      <div class="stiJsViewerGroupPanelContainer"
           [style.padding]="innerPadding"
           [style.display]="display"
           [@state]="opened ? 'opened' : 'closed'"
           (@state.start)="startAnimation($event)"
           (@state.done)="doneAnimation($event)">
          <ng-content>

          </ng-content>
      </div>


  </div>
  `, isInline: true, dependencies: [{ kind: "component", type: FormButtonComponent, selector: "sti-form-button", inputs: ["caption", "actionName", "imageName", "imageCellWidth", "captionPadding", "margin", "captionAlign"], outputs: ["action"] }], animations: [
        trigger('state', [
            state('opened', style({ height: '*' })),
            state('closed', style({ height: '0px' })),
            transition('* => *', [
                animate('150ms ease-in-out')
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: GroupPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-group-panel',
                    template: `
  <div #groupPanel [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbarFontColor"
       [style.minWidth.px]="width"
       [style.margin]="margin"
       style="overflow: hidden">
      <sti-form-button [caption]="caption"
          [imageName]="opened ? 'Arrows.BigArrowDown.png' : 'Arrows.BigArrowRight.png'"
          [imageCellWidth]="'1px'"
          [captionPadding]="'0 15px 0 5px'"
          [margin]="'0px'"
          [captionAlign]="'left'"
          (action)="opened = !opened; action.emit(opened)">
      </sti-form-button>

      <div class="stiJsViewerGroupPanelContainer"
           [style.padding]="innerPadding"
           [style.display]="display"
           [@state]="opened ? 'opened' : 'closed'"
           (@state.start)="startAnimation($event)"
           (@state.done)="doneAnimation($event)">
          <ng-content>

          </ng-content>
      </div>


  </div>
  `,
                    animations: [
                        trigger('state', [
                            state('opened', style({ height: '*' })),
                            state('closed', style({ height: '0px' })),
                            transition('* => *', [
                                animate('150ms ease-in-out')
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; }, propDecorators: { width: [{
                type: Input
            }], caption: [{
                type: Input
            }], innerPadding: [{
                type: Input
            }], opened: [{
                type: Input
            }], margin: [{
                type: Input
            }], action: [{
                type: Output
            }] } });

class RadioButtonComponent {
    constructor(model, radioService) {
        this.model = model;
        this.radioService = radioService;
        this.action = new EventEmitter();
        this.enabled = true;
        this.checked = false;
        this.over = false;
    }
    ngAfterViewInit() {
        this.radioService.addButton(this);
    }
    ngOnDestroy() {
        this.radioService.removeButton(this);
    }
    ngOnInit() { }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
    }
    click() {
        if (this.enabled) {
            this.checked = true;
            this.radioService.check(this);
            this.action.emit(true);
        }
    }
    uncheck() {
        this.checked = false;
        this.action.emit(false);
    }
    get outClass() {
        return !this.enabled ? 'stiJsViewerRadioButtonOutCircleDisabled' : (this.over ? 'stiJsViewerRadioButtonOutCircleOver' : 'stiJsViewerRadioButtonOutCircle');
    }
}
RadioButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: RadioButtonComponent, deps: [{ token: ModelService }, { token: RadioButtonService }], target: i0.ɵɵFactoryTarget.Component });
RadioButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: RadioButtonComponent, selector: "sti-radio-button", inputs: { groupName: "groupName", name: "name", enabled: "enabled", checked: "checked", tooltip: "tooltip", caption: "caption", margin: "margin", paddingLeftLastCell: "paddingLeftLastCell" }, outputs: { action: "action" }, ngImport: i0, template: `
    <table [class]="enabled ? 'stiJsViewerRadioButton' : 'stiJsViewerRadioButtonDisabled'" cellpadding="0" cellspacing="0"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.margin]="margin"
      [attr.title]="tooltip"
      (mouseover)="mouseover()" (mouseout)="mouseout()" (click)="click()">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td class="stiJsViewerClearAllStyles">
            <div class="stiJsViewerRadioButtonOutCircle" [class]="outClass">
              <div class="stiJsViewerRadioButtonInnerCircle"
                  [style.margin]="model.options.isTouchDevice ? '4px' : '3px'"
                  [style.width]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.height]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.visibility]="checked ? 'visible' : 'hidden'"
                  [style.opacity]="enabled ? 1 : 0.5">
              </div>
            </div>
          </td>
          <td *ngIf="caption != null" class="stiJsViewerClearAllStyles" style="padding-left: 4px; white-space: nowrap;">
            {{caption}}
          </td>
          <td class="stiJsViewerClearAllStyles" [style.paddingLeft]="paddingLeftLastCell">
            <ng-content></ng-content>
          </td>
        </tr>
      </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: RadioButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-radio-button',
                    template: `
    <table [class]="enabled ? 'stiJsViewerRadioButton' : 'stiJsViewerRadioButtonDisabled'" cellpadding="0" cellspacing="0"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.margin]="margin"
      [attr.title]="tooltip"
      (mouseover)="mouseover()" (mouseout)="mouseout()" (click)="click()">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td class="stiJsViewerClearAllStyles">
            <div class="stiJsViewerRadioButtonOutCircle" [class]="outClass">
              <div class="stiJsViewerRadioButtonInnerCircle"
                  [style.margin]="model.options.isTouchDevice ? '4px' : '3px'"
                  [style.width]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.height]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.visibility]="checked ? 'visible' : 'hidden'"
                  [style.opacity]="enabled ? 1 : 0.5">
              </div>
            </div>
          </td>
          <td *ngIf="caption != null" class="stiJsViewerClearAllStyles" style="padding-left: 4px; white-space: nowrap;">
            {{caption}}
          </td>
          <td class="stiJsViewerClearAllStyles" [style.paddingLeft]="paddingLeftLastCell">
            <ng-content></ng-content>
          </td>
        </tr>
      </tbody>
    </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: RadioButtonService }]; }, propDecorators: { action: [{
                type: Output
            }], groupName: [{
                type: Input
            }], name: [{
                type: Input
            }], enabled: [{
                type: Input
            }], checked: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], caption: [{
                type: Input
            }], margin: [{
                type: Input
            }], paddingLeftLastCell: [{
                type: Input
            }] } });

class ExportFormComponent {
    constructor(model, exportService, helper, formService, menuService, collections, controller) {
        this.model = model;
        this.exportService = exportService;
        this.helper = helper;
        this.formService = formService;
        this.menuService = menuService;
        this.collections = collections;
        this.controller = controller;
        this.PROPERTY_ALIAS = {
            ImageFormatForHtml: 'ImageFormat',
            EncodingTextOrCsvFile: 'Encoding',
            ExportModeRtf: 'ExportMode',
            EncodingDifFile: 'Encoding',
            EncodingDbfFile: 'CodePage'
        };
        this.formVisible = false;
        this.disabledComponents = {};
    }
    ngOnChanges(changes) {
        var _a, _b;
        if (this.baseForm && ((_b = (_a = this.formService) === null || _a === void 0 ? void 0 : _a.form) === null || _b === void 0 ? void 0 : _b.name) === this.baseForm.name) {
            setTimeout(() => this.updateDisabledComponents());
        }
    }
    ngOnInit() { }
    action() {
        this.formService.closeForm(this.baseForm.name);
        if (this.model.options.exports.storeExportSettings) {
            this.helper.setCookie('StimulsoftWebViewerExportSettings' + this.exportService.getCommonExportFormat(), JSON.stringify(this.exportService.exportSettings));
        }
        this.exportService.postExport();
    }
    updateDisabledComponents() {
        var _a;
        ['StandardPdfFonts', 'EmbeddedFonts', 'UseUnicode'].forEach(n => this.disabledComponents[n] = (this.exportService.exportSettings.PdfACompliance === true));
        this.disabledComponents.ImageQuality = this.exportService.exportSettings.ImageCompressionMethod && this.exportService.exportSettings.ImageCompressionMethod !== 'Jpeg';
        this.disabledComponents.ExportObjectFormatting = this.exportService.exportSettings.DataExportMode === 'AllBands';
        this.disabledComponents.UseOnePageHeaderAndFooter = this.exportService.exportSettings.DataExportMode != 'AllBands';
        this.disabledComponents.EncodingDifFile = this.exportService.exportSettings.UseDefaultSystemEncoding;
        this.disabledComponents.TiffCompressionScheme = this.exportService.exportSettings.ImageType !== 'Tiff';
        this.disabledComponents.UseDigitalSignature = !this.exportService.exportSettings.UseDigitalSignature || !(((_a = this.model.pdfSecurityCertificates) === null || _a === void 0 ? void 0 : _a.length) > 0);
        this.disabledComponents.RemoveEmptySpaceAtBottom = this.exportService.exportSettings.UsePageHeadersAndFooters;
        if (this.exportService.exportSettings.ImageType != null) {
            const ifComponent = this.exportService.exportFormSettings.components.find(c => c.name === 'ImageFormat');
            if (ifComponent != null) {
                ifComponent.items = this.collections.getImageFormatItems(this.exportService.exportSettings.ImageType === 'Emf');
            }
        }
        this.disabledComponents.DitheringType = this.exportService.exportSettings.ImageFormat !== 'Monochrome';
        if (this.saveReportMdc) {
            this.saveReportMdc.click();
        }
        if (this.pagesRangeAll && !this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled) {
            this.pagesRangeAll.click();
        }
        if (this.pageRangeCurrentPage && this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled) {
            this.pageRangeCurrentPage.click();
        }
        if (this.exportService.exportSettings.CompressToArchive === true) {
            this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled = false;
        }
        if (this.exportService.exportSettings.CompressToArchive === false) {
            this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled = true;
        }
    }
    componentAction(comp, value) {
        let property = this.PROPERTY_ALIAS[comp.name] || comp.name;
        switch (property) {
            case 'EmbeddedFonts':
            case 'UseUnicode':
                if (value) {
                    this.exportService.exportSettings.StandardPdfFonts = false;
                }
                break;
            case 'StandardPdfFonts':
                if (value) {
                    this.exportService.exportSettings.EmbeddedFonts = false;
                    this.exportService.exportSettings.UseUnicode = false;
                }
                break;
            case 'ImageType':
                this.exportService.export('Image' + value, true);
                break;
            case 'DataType':
            case 'HtmlType':
                this.exportService.export(value, true);
                break;
            case 'ExcelType':
                const exportFormat = value === 'ExcelBinary' ? 'Excel' : value;
                this.exportService.export(exportFormat, true);
                break;
            case 'UseDigitalSignature':
                if (!(value === true || value === false)) {
                    property = 'CertificateThumbprint';
                }
                if (value === true && this.collections.getPdfSecurityCertificatesItems().length == 0) {
                    value = false;
                    this.controller.showError('Warning', 'Certificate Not Found!');
                }
                break;
            case 'UsePageHeadersAndFooters':
                if (value === true) {
                    this.exportService.exportSettings.RemoveEmptySpaceAtBottom = true;
                }
                break;
        }
        this.exportService.exportSettings[property] = value;
        this.updateDisabledComponents();
    }
    getValue(comp, component) {
        const property = this.PROPERTY_ALIAS[comp.name] || comp.name;
        switch (property) {
            case 'Zoom2':
                return this.exportService.exportSettings[property].toString();
            case 'UseDigitalSignature':
                if (component == 'dropDownList') {
                    return this.exportService.exportSettings['CertificateThumbprint'];
                }
            default:
                return this.exportService.exportSettings[property];
        }
    }
    changeVisibility(state) {
        var _a, _b;
        this.formVisible = state === 'visible';
        if (state === 'hidden' && ((_b = (_a = this.exportFormSettings) === null || _a === void 0 ? void 0 : _a.groups) === null || _b === void 0 ? void 0 : _b.savingReportGroup)) {
            this.helper.setCookie('StimulsoftWebViewerExportSettingsOpeningGroups', JSON.stringify({
                SavingReportGroup: this.exportFormSettings.groups.savingReportGroup.opened,
                PageRangeGroup: this.exportFormSettings.groups.pageRangeGroup.opened,
                SettingsGroup: this.exportFormSettings.groups.settingsGroup.opened
            }));
        }
        if (state === 'visible') {
            this.updateDisabledComponents();
        }
    }
    showMenu(comp, button) {
        let menuName = 'documentSecurityMenu';
        if (comp.name === 'DocumentSecurityButton') {
            this.menuService.addMenu({
                type: menuName, name: menuName, items: [], parent: button.button,
                itemStyleName: 'stiJsViewerMenuStandartItem', menuStyleName: 'stiJsViewerDropdownMenu',
                state: ''
            });
        }
        else {
            menuName = this.menuService.VERTICAL_MENU_NAME;
            this.menuService.addMenu({
                type: 'buttonMenu', name: menuName, items: this.collections.getPdfSecurityCertificatesItems(), parent: button.button,
                itemStyleName: 'stiJsViewerMenuStandartItem', menuStyleName: 'stiJsViewerDropdownMenu',
                state: ''
            });
        }
        setTimeout(() => {
            this.menuService.showMenu(menuName);
        });
    }
    getTextBoxType(name) {
        if (name === 'SaveReportPassword' || name === 'PasswordInputUser' || name === 'PasswordInputOwner') {
            return this.formVisible ? 'password' : '';
        }
        return null;
    }
}
ExportFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ExportFormComponent, deps: [{ token: ModelService }, { token: ExportService }, { token: HelperService }, { token: FormService }, { token: MenuService }, { token: CollectionsService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Component });
ExportFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ExportFormComponent, selector: "sti-export-form", inputs: { exportFormSettings: "exportFormSettings" }, viewQueries: [{ propertyName: "baseForm", first: true, predicate: ["baseForm"], descendants: true }, { propertyName: "saveReportMdc", first: true, predicate: ["saveReportMdc"], descendants: true }, { propertyName: "pagesRangeAll", first: true, predicate: ["pagesRangeAll"], descendants: true }, { propertyName: "pageRangeCurrentPage", first: true, predicate: ["pageRangeCurrentPage"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
    [color]="model.options.toolbar.fontColor"
    [fontSize]="'12px'"
    [containerPadding]="'3px'"
    [name]="'exportForm'"
    [caption]="model.loc('ExportFormTitle')"
    [defaultTop]="150"
    (changeVisibility)="changeVisibility($event)"
    (action)="action()">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
      <tbody>
          <tr *ngIf="exportFormSettings?.groups.savingReportGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SavingReport')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.savingReportGroup.opened"
               (action)="exportFormSettings.groups.savingReportGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #saveReportMdc
                           [name]="baseForm.name + 'SaveReportMdc'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdc')"
                           [margin]="'6px 8px 3px 8px'"
                           [checked]="true"
                           (action)="exportService.exportSettings.Format = 'Mdc'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdz'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdz')"
                           [margin]="'3px 8px 3px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdz'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdx'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdx')"
                           [margin]="'3px 8px 0px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdx'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('PasswordSaveReportTooltip')">
                      {{model.loc('PasswordSaveReport')}}
                      </td>
                      <td>
                        <sti-text-box
                           [width]="140"
                           [tooltip]="model.loc('PasswordSaveReportTooltip')"
                           [margin]="'4px 8px 0px 8px'"
                           [type]="getTextBoxType('SaveReportPassword')"
                           [enabled]="exportService.exportSettings.Format == 'Mdx'"
                           (onchange)="exportService.exportSettings.Password = $event.value">
                        </sti-text-box>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

          <tr *ngIf="exportFormSettings?.groups.pageRangeGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('PagesRange')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.pageRangeGroup.opened"
               (action)="exportFormSettings.groups.pageRangeGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pagesRangeAll
                           [name]="baseForm.name + 'PagesRangeAll'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeAll')"
                           [tooltip]="model.loc('PagesRangeAllTooltip')"
                           [margin]="'6px 8px 6px 8px'"
                           [checked]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           [enabled]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = 'All'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pageRangeCurrentPage
                           [name]="baseForm.name + 'PageRangeCurrentPage'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeCurrentPage')"
                           [tooltip]="model.loc('PagesRangeCurrentPageTooltip')"
                           [margin]="'0px 8px 4px 8px'"
                           [checked]="exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = (model.reportParams.pageNumber + 1).toString()">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'PageRangePages'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangePages')"
                           [tooltip]="model.loc('PagesRangePagesTooltip')"
                           [margin]="'0px 8px 0px 8px'"
                           [paddingLeftLastCell]="'60px'"
                           (action)="exportService.exportSettings.PageRange = pagesRange.element.nativeElement.value">
                              <sti-text-box #pagesRange
                                [width]="130"
                                [tooltip]="model.loc('PagesRangePagesTooltip')"
                                [margin]="'0px 0px 0px 30px'"
                                (onchange)="exportService.exportSettings.PageRange = $event.value"
                                (onblur)="exportService.exportSettings.PageRange = $event.value">
                              </sti-text-box>
                        </sti-radio-button>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

        <tr *ngIf="exportFormSettings?.groups.settingsGroup.visible"class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SettingsGroup')"
                [opened]="exportFormSettings.groups.settingsGroup.opened"
                [width]="390"
                [margin]="'4px'"
                [innerPadding]="'4px 0 4px 0'"
                (action)="exportFormSettings.groups.settingsGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr *ngFor="let comp of exportFormSettings.components">
                      <td *ngIf="comp.label != null" style="padding: 0px 8px; min-width: 150px;" [attr.title]="comp.tooltip">
                        {{comp.label}}
                      </td>

                      <td *ngIf="comp.name == 'UseDigitalSignature'">
                        <sti-check-box
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>
                      </td>

                      <td [attr.colSpan]="comp.label != null || comp.name == 'DocumentSecurityButton' || comp.name == 'UseDigitalSignature' ? 1 : 2">
                        <sti-drop-down-list-for-export-form *ngIf="comp.type == 'DropDownListForExportForm'"
                           [width]="comp.width"
                           [items]="comp.items"
                           [key]="getValue(comp, 'dropDownList')"
                           [margin]="comp.margin"
                           [verticalAlign]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'middle' : null"
                           [styleDisplay]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'inline-block' : null"
                           [enabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event.key)">
                        </sti-drop-down-list-for-export-form>

                        <div *ngIf="comp.name == 'ImageQuality' || comp.name == 'ImageResolution'"
                           [style.display]="'inline-block'">
                          {{comp.name == 'ImageQuality' ? '%' : 'dpi'}}
                        </div>

                        <sti-text-box *ngIf="comp.type == 'TextBox'"
                           [width]="comp.width"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [type]="getTextBoxType(comp.name)"
                           [enabled]="!comp.disabled"
                           [value]="getValue(comp)"
                           [enabled]="!disabledComponents[comp.name]"
                           (onchange)="componentAction(comp, $event.value)">
                        </sti-text-box>

                        <sti-check-box *ngIf="comp.type == 'CheckBox' || comp.type == 'DigitalSignature'"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           [isEnabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>

                      </td>

                      <td *ngIf="comp.name == 'DocumentSecurityButton'">
                        <sti-button #button
                           [width]="comp.width"
                           [arrow]="'Down'"
                           [minWidth]="'163px'"
                           [captionAlign]="'center'"
                           [display]="'inline-block'"
                           [styleName]="'stiJsViewerFormButton'"
                           [margin]="'2px 8px'"
                           [innerTableWidth]="'100%'"
                           [captionWidth]="'100%'"
                           [caption]="comp.name == 'DocumentSecurityButton' ? comp.caption : ''"
                           [enabled]="!disabledComponents[comp.name + 'Button']"
                           (action)="showMenu(comp, button)">
                        </sti-button>
                      </td>
                    </tr>
                  </tbody>
                </table>

              </sti-group-panel>
            </td>
        </tr>

        <tr *ngIf="model.options.exports.showOpenAfterExport && exportFormSettings?.openAfterExport && !exportService.sendMail" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
                <sti-check-box [captionText]="model.loc('OpenAfterExport')"
                  [tooltip]="model.loc('OpenAfterExportTooltip')"
                  [margin]="'4px 8px 4px 8px'"
                  [isChecked]="exportService.exportSettings.OpenAfterExport"
                  (action)="exportService.exportSettings.OpenAfterExport = $event">
                </sti-check-box>
            </td>
        </tr>
      </tbody>
    </table>

    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }, { kind: "component", type: BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }, { kind: "component", type: GroupPanelComponent, selector: "sti-group-panel", inputs: ["width", "caption", "innerPadding", "opened", "margin"], outputs: ["action"] }, { kind: "component", type: RadioButtonComponent, selector: "sti-radio-button", inputs: ["groupName", "name", "enabled", "checked", "tooltip", "caption", "margin", "paddingLeftLastCell"], outputs: ["action"] }, { kind: "component", type: DropDownListForExportFormComponent, selector: "sti-drop-down-list-for-export-form", inputs: ["items", "width", "key", "margin", "enabled", "styleDisplay", "verticalAlign"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ExportFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-export-form',
                    template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
    [color]="model.options.toolbar.fontColor"
    [fontSize]="'12px'"
    [containerPadding]="'3px'"
    [name]="'exportForm'"
    [caption]="model.loc('ExportFormTitle')"
    [defaultTop]="150"
    (changeVisibility)="changeVisibility($event)"
    (action)="action()">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
      <tbody>
          <tr *ngIf="exportFormSettings?.groups.savingReportGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SavingReport')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.savingReportGroup.opened"
               (action)="exportFormSettings.groups.savingReportGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #saveReportMdc
                           [name]="baseForm.name + 'SaveReportMdc'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdc')"
                           [margin]="'6px 8px 3px 8px'"
                           [checked]="true"
                           (action)="exportService.exportSettings.Format = 'Mdc'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdz'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdz')"
                           [margin]="'3px 8px 3px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdz'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdx'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdx')"
                           [margin]="'3px 8px 0px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdx'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('PasswordSaveReportTooltip')">
                      {{model.loc('PasswordSaveReport')}}
                      </td>
                      <td>
                        <sti-text-box
                           [width]="140"
                           [tooltip]="model.loc('PasswordSaveReportTooltip')"
                           [margin]="'4px 8px 0px 8px'"
                           [type]="getTextBoxType('SaveReportPassword')"
                           [enabled]="exportService.exportSettings.Format == 'Mdx'"
                           (onchange)="exportService.exportSettings.Password = $event.value">
                        </sti-text-box>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

          <tr *ngIf="exportFormSettings?.groups.pageRangeGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('PagesRange')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.pageRangeGroup.opened"
               (action)="exportFormSettings.groups.pageRangeGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pagesRangeAll
                           [name]="baseForm.name + 'PagesRangeAll'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeAll')"
                           [tooltip]="model.loc('PagesRangeAllTooltip')"
                           [margin]="'6px 8px 6px 8px'"
                           [checked]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           [enabled]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = 'All'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pageRangeCurrentPage
                           [name]="baseForm.name + 'PageRangeCurrentPage'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeCurrentPage')"
                           [tooltip]="model.loc('PagesRangeCurrentPageTooltip')"
                           [margin]="'0px 8px 4px 8px'"
                           [checked]="exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = (model.reportParams.pageNumber + 1).toString()">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'PageRangePages'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangePages')"
                           [tooltip]="model.loc('PagesRangePagesTooltip')"
                           [margin]="'0px 8px 0px 8px'"
                           [paddingLeftLastCell]="'60px'"
                           (action)="exportService.exportSettings.PageRange = pagesRange.element.nativeElement.value">
                              <sti-text-box #pagesRange
                                [width]="130"
                                [tooltip]="model.loc('PagesRangePagesTooltip')"
                                [margin]="'0px 0px 0px 30px'"
                                (onchange)="exportService.exportSettings.PageRange = $event.value"
                                (onblur)="exportService.exportSettings.PageRange = $event.value">
                              </sti-text-box>
                        </sti-radio-button>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

        <tr *ngIf="exportFormSettings?.groups.settingsGroup.visible"class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SettingsGroup')"
                [opened]="exportFormSettings.groups.settingsGroup.opened"
                [width]="390"
                [margin]="'4px'"
                [innerPadding]="'4px 0 4px 0'"
                (action)="exportFormSettings.groups.settingsGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr *ngFor="let comp of exportFormSettings.components">
                      <td *ngIf="comp.label != null" style="padding: 0px 8px; min-width: 150px;" [attr.title]="comp.tooltip">
                        {{comp.label}}
                      </td>

                      <td *ngIf="comp.name == 'UseDigitalSignature'">
                        <sti-check-box
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>
                      </td>

                      <td [attr.colSpan]="comp.label != null || comp.name == 'DocumentSecurityButton' || comp.name == 'UseDigitalSignature' ? 1 : 2">
                        <sti-drop-down-list-for-export-form *ngIf="comp.type == 'DropDownListForExportForm'"
                           [width]="comp.width"
                           [items]="comp.items"
                           [key]="getValue(comp, 'dropDownList')"
                           [margin]="comp.margin"
                           [verticalAlign]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'middle' : null"
                           [styleDisplay]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'inline-block' : null"
                           [enabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event.key)">
                        </sti-drop-down-list-for-export-form>

                        <div *ngIf="comp.name == 'ImageQuality' || comp.name == 'ImageResolution'"
                           [style.display]="'inline-block'">
                          {{comp.name == 'ImageQuality' ? '%' : 'dpi'}}
                        </div>

                        <sti-text-box *ngIf="comp.type == 'TextBox'"
                           [width]="comp.width"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [type]="getTextBoxType(comp.name)"
                           [enabled]="!comp.disabled"
                           [value]="getValue(comp)"
                           [enabled]="!disabledComponents[comp.name]"
                           (onchange)="componentAction(comp, $event.value)">
                        </sti-text-box>

                        <sti-check-box *ngIf="comp.type == 'CheckBox' || comp.type == 'DigitalSignature'"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           [isEnabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>

                      </td>

                      <td *ngIf="comp.name == 'DocumentSecurityButton'">
                        <sti-button #button
                           [width]="comp.width"
                           [arrow]="'Down'"
                           [minWidth]="'163px'"
                           [captionAlign]="'center'"
                           [display]="'inline-block'"
                           [styleName]="'stiJsViewerFormButton'"
                           [margin]="'2px 8px'"
                           [innerTableWidth]="'100%'"
                           [captionWidth]="'100%'"
                           [caption]="comp.name == 'DocumentSecurityButton' ? comp.caption : ''"
                           [enabled]="!disabledComponents[comp.name + 'Button']"
                           (action)="showMenu(comp, button)">
                        </sti-button>
                      </td>
                    </tr>
                  </tbody>
                </table>

              </sti-group-panel>
            </td>
        </tr>

        <tr *ngIf="model.options.exports.showOpenAfterExport && exportFormSettings?.openAfterExport && !exportService.sendMail" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
                <sti-check-box [captionText]="model.loc('OpenAfterExport')"
                  [tooltip]="model.loc('OpenAfterExportTooltip')"
                  [margin]="'4px 8px 4px 8px'"
                  [isChecked]="exportService.exportSettings.OpenAfterExport"
                  (action)="exportService.exportSettings.OpenAfterExport = $event">
                </sti-check-box>
            </td>
        </tr>
      </tbody>
    </table>

    </sti-base-form>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ExportService }, { type: HelperService }, { type: FormService }, { type: MenuService }, { type: CollectionsService }, { type: ControllerService }]; }, propDecorators: { baseForm: [{
                type: ViewChild,
                args: ['baseForm']
            }], saveReportMdc: [{
                type: ViewChild,
                args: ['saveReportMdc']
            }], pagesRangeAll: [{
                type: ViewChild,
                args: ['pagesRangeAll']
            }], pageRangeCurrentPage: [{
                type: ViewChild,
                args: ['pageRangeCurrentPage']
            }], exportFormSettings: [{
                type: Input
            }] } });

class TextAreaComponent {
    constructor() {
        this.enabled = true;
        this.action = new EventEmitter();
        this.onchange = new EventEmitter();
        this.onblur = new EventEmitter();
        this.selected = false;
        this.focused = false;
        this.over = false;
        this._readOnly = false;
        this.styleName = 'stiJsViewerTextBox';
    }
    ngOnInit() { }
    keypress(event) {
        if (!this.enabled) {
            return false;
        }
        if (event.keyCode === 13) {
            this.action.emit(event.target);
        }
    }
    onchanged(event) {
        this.onchange.emit(event.target);
    }
    get className() {
        if (this._readOnly) {
            return this.styleName + ' ' + this.styleName + 'Default';
        }
        return this.styleName + ' ' + this.styleName + (this.selected ? 'Over' : (this.enabled ? (this.over ? 'Over' : 'Default') : 'Disabled'));
    }
    get readOnly() {
        return this._readOnly;
    }
}
TextAreaComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextAreaComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
TextAreaComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: TextAreaComponent, selector: "sti-text-area", inputs: { width: "width", height: "height", enabled: "enabled", value: "value", padding: "padding", margin: "margin" }, outputs: { action: "action", onchange: "onchange", onblur: "onblur" }, ngImport: i0, template: `
    <textarea
      [style.width.px]="width"
      [style.minWidth.px]="width"
      [style.height.px]="height"
      [style.minHeight.px]="height"
      [class]="className"
      [value]="value || ''"
      [style.margin]="margin"
      [style.cursor]="readOnly ? 'default' : ''"
      [style.padding]="padding"
      style="padding-top: 3px, font-family: Arial"
      (mouseover)="over=true"
      (mouseleave)="over=false"
      (focused)="focused=true; selected=true"
      (blur)="focused=false; selected=false; onblur.emit($event.target)"
      (keypress)="keypress($event)"
      (keyup)="onchanged($event)">
    </textarea>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextAreaComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-text-area',
                    template: `
    <textarea
      [style.width.px]="width"
      [style.minWidth.px]="width"
      [style.height.px]="height"
      [style.minHeight.px]="height"
      [class]="className"
      [value]="value || ''"
      [style.margin]="margin"
      [style.cursor]="readOnly ? 'default' : ''"
      [style.padding]="padding"
      style="padding-top: 3px, font-family: Arial"
      (mouseover)="over=true"
      (mouseleave)="over=false"
      (focused)="focused=true; selected=true"
      (blur)="focused=false; selected=false; onblur.emit($event.target)"
      (keypress)="keypress($event)"
      (keyup)="onchanged($event)">
    </textarea>
  `
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { width: [{
                type: Input
            }], height: [{
                type: Input
            }], enabled: [{
                type: Input
            }], value: [{
                type: Input
            }], padding: [{
                type: Input
            }], margin: [{
                type: Input
            }], action: [{
                type: Output
            }], onchange: [{
                type: Output
            }], onblur: [{
                type: Output
            }] } });

class SendEmailFormComponent {
    constructor(model, mailService, exportService) {
        this.model = model;
        this.mailService = mailService;
        this.exportService = exportService;
    }
    ngOnInit() { }
}
SendEmailFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: SendEmailFormComponent, deps: [{ token: ModelService }, { token: MailService }, { token: ExportService }], target: i0.ɵɵFactoryTarget.Component });
SendEmailFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: SendEmailFormComponent, selector: "sti-send-email-form", ngImport: i0, template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [fontSize]="'12px'"
      [name]="'sendEmailForm'"
      [caption]="model.loc('EmailOptions')"
      [level]="1"
      [defaultTop]="150"
      (action)="this.mailService.sendMail()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
        <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Email')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Email"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Email = $event.value">
                </sti-text-box>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Email"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Email = $event.value">
                </sti-text-box>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Subject')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Subject"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Subject = $event.value">
                </sti-text-box>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Subject"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Subject = $event.value">
                </sti-text-box>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Message')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-area [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Message"
                  [height]="70"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Message = $event.value">
                </sti-text-area>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-area [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Message"
                  [height]="70"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Message = $event.value">
                </sti-text-area>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Attachment')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <div style="margin: 4px">
                  {{exportService.exportSettings.Attachment}}
                </div>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <div style="margin: 4px">
                  {{exportService.exportSettings.Attachment}}
                </div>
              </td>
            </tr>
        </tbody>
      </table>
    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }, { kind: "component", type: TextAreaComponent, selector: "sti-text-area", inputs: ["width", "height", "enabled", "value", "padding", "margin"], outputs: ["action", "onchange", "onblur"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: SendEmailFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-send-email-form',
                    template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [fontSize]="'12px'"
      [name]="'sendEmailForm'"
      [caption]="model.loc('EmailOptions')"
      [level]="1"
      [defaultTop]="150"
      (action)="this.mailService.sendMail()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
        <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Email')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Email"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Email = $event.value">
                </sti-text-box>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Email"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Email = $event.value">
                </sti-text-box>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Subject')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Subject"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Subject = $event.value">
                </sti-text-box>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Subject"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Subject = $event.value">
                </sti-text-box>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Message')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <sti-text-area [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Message"
                  [height]="70"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Message = $event.value">
                </sti-text-area>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <sti-text-area [margin]="model.options.isMobileDevice ? '4px 4px 12px 4px' : '4px'"
                  [value]="exportService.exportSettings.Message"
                  [height]="70"
                  [width]="model.options.isMobileDevice ? 200 : 280"
                  (onchange)="exportService.exportSettings.Message = $event.value">
                </sti-text-area>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerCaptionControls" [style.padding]="model.options.isMobileDevice ? '0 25px 0 4px' : ''">
                {{model.loc('Attachment')}}
              </td>
              <td *ngIf="!model.options.isMobileDevice">
                <div style="margin: 4px">
                  {{exportService.exportSettings.Attachment}}
                </div>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles" *ngIf="model.options.isMobileDevice">
              <td class="stiJsViewerClearAllStyles">
                <div style="margin: 4px">
                  {{exportService.exportSettings.Attachment}}
                </div>
              </td>
            </tr>
        </tbody>
      </table>
    </sti-base-form>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: MailService }, { type: ExportService }]; } });

class DrillDownPanelComponent {
    constructor(model, drillDownService, controller) {
        this.model = model;
        this.drillDownService = drillDownService;
        this.controller = controller;
        controller.getMessage().subscribe((message) => {
            if ((message === null || message === void 0 ? void 0 : message.action) === 'DrillDown' && this.element) {
                this.element.nativeElement.scrollTop = 0;
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.drillDownPanel.el = this.element;
    }
    action(button) {
        this.drillDownService.saveState();
        this.model.drillDownButtons.forEach(b => b.selected = false);
        button.selected = true;
        this.model.setReportParams(button.reportParams);
        this.element.nativeElement.scrollTop = 0;
        this.controller.getPages();
    }
    close(button) {
        this.model.drillDownButtons.splice(this.model.drillDownButtons.indexOf(button), 1);
        button.visible = false;
        if (button.selected) {
            this.action(this.model.drillDownButtons[0]);
        }
    }
}
DrillDownPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownPanelComponent, deps: [{ token: ModelService }, { token: DrillDownService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Component });
DrillDownPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DrillDownPanelComponent, selector: "sti-drill-down-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
  <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
    [style.display]="model.controls.drillDownPanel.visible ? '' : 'none'">
    <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
      <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin: 0px; box-sizing: border-box;"
        [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                <tbody>
                  <tr class="stiJsViewerClearAllStyles">
                    <td *ngFor="let button of model.drillDownButtons; index as i" class="stiJsViewerClearAllStyles" style="padding: 0px; border: 0px; line-height: 0;">
                      <sti-button [display]="button.visible ? 'inline-block': 'none'"
                        [margin]="'2px 1px 2px 2px'"
                        [caption]="button.caption"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : null"
                        [display]="'inline-block'"
                        [selected]="button.selected"
                        [closeButton]="i > 0"
                        (action)="action(button)"
                        (closeButtonAction)="close(button)">
                      </sti-button>
                    </td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-drill-down-panel',
                    template: `
  <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
    [style.display]="model.controls.drillDownPanel.visible ? '' : 'none'">
    <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
      <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin: 0px; box-sizing: border-box;"
        [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                <tbody>
                  <tr class="stiJsViewerClearAllStyles">
                    <td *ngFor="let button of model.drillDownButtons; index as i" class="stiJsViewerClearAllStyles" style="padding: 0px; border: 0px; line-height: 0;">
                      <sti-button [display]="button.visible ? 'inline-block': 'none'"
                        [margin]="'2px 1px 2px 2px'"
                        [caption]="button.caption"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : null"
                        [display]="'inline-block'"
                        [selected]="button.selected"
                        [closeButton]="i > 0"
                        (action)="action(button)"
                        (closeButtonAction)="close(button)">
                      </sti-button>
                    </td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: DrillDownService }, { type: ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

class OpenDialogComponent {
    constructor(model, controller) {
        this.model = model;
        this.controller = controller;
    }
    ngOnChanges(changes) {
        if (this.fileMask != null && this.model.openDialogFileMask != null) {
            setTimeout(() => {
                this.element.nativeElement.focus();
                this.element.nativeElement.click();
            });
        }
    }
    ngOnInit() { }
    onchange(event) {
        const files = event.target.files;
        const fileName = files[0] ? files[0].name : 'Report';
        const filePath = event.target.value;
        const reader = new FileReader();
        reader.onload = (e) => {
            this.controller.loadFile(fileName, e.target.result);
        };
        this.model.openDialogFileMask = null;
        reader.readAsDataURL(files[0]);
    }
}
OpenDialogComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: OpenDialogComponent, deps: [{ token: ModelService }, { token: ControllerService }], target: i0.ɵɵFactoryTarget.Component });
OpenDialogComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: OpenDialogComponent, selector: "sti-open-dialog", inputs: { fileMask: "fileMask" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <input #element *ngIf="model.openDialogFileMask != null"  type="file" name="files[]" multiple="" style="display: none;"
      [attr.accept]="model.openDialogFileMask"
      (change)="onchange($event)">
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: OpenDialogComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-open-dialog',
                    template: `
    <input #element *ngIf="model.openDialogFileMask != null"  type="file" name="files[]" multiple="" style="display: none;"
      [attr.accept]="model.openDialogFileMask"
      (change)="onchange($event)">
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], fileMask: [{
                type: Input
            }] } });

class PasswordFormComponent {
    constructor(model, controller, formService) {
        this.model = model;
        this.controller = controller;
        this.formService = formService;
    }
    ngOnInit() { }
    changeVisibility(state) {
        if (state === 'visible') {
            this.password = '';
            this.textBox.element.nativeElement.focus();
        }
    }
    action() {
        const data = this.formService.form.formData;
        data.openingFilePassword = this.password;
        this.formService.closeForm('passwordForm');
        this.controller.postOpen(data);
    }
}
PasswordFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PasswordFormComponent, deps: [{ token: ModelService }, { token: ControllerService }, { token: FormService }], target: i0.ɵɵFactoryTarget.Component });
PasswordFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: PasswordFormComponent, selector: "sti-password-form", viewQueries: [{ propertyName: "textBox", first: true, predicate: ["textBox"], descendants: true }], ngImport: i0, template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'passwordForm'"
      [caption]="model.loc('PasswordSaveReport').replace(':', '')"
      [level]="2"
      [defaultTop]="150"
      (changeVisibility)="changeVisibility($event)"
      (action)="action()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 5px;">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerCaptionControls">
              {{model.loc('PasswordEnter')}}
            </td>
            <td class="stiJsViewerCaptionControls">
              <sti-text-box #textBox [type]="'password'" [width]="200" [focusOnCreate]="true" [value]="password" (onchange)="password = $event.value">
              </sti-text-box>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "component", type: TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PasswordFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-password-form',
                    template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'passwordForm'"
      [caption]="model.loc('PasswordSaveReport').replace(':', '')"
      [level]="2"
      [defaultTop]="150"
      (changeVisibility)="changeVisibility($event)"
      (action)="action()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 5px;">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerCaptionControls">
              {{model.loc('PasswordEnter')}}
            </td>
            <td class="stiJsViewerCaptionControls">
              <sti-text-box #textBox [type]="'password'" [width]="200" [focusOnCreate]="true" [value]="password" (onchange)="password = $event.value">
              </sti-text-box>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: FormService }]; }, propDecorators: { textBox: [{
                type: ViewChild,
                args: ['textBox']
            }] } });

class ErrorMessageFormComponent {
    constructor(model, formService) {
        this.model = model;
        this.formService = formService;
    }
    ngOnInit() { }
    getImage() {
        var _a;
        const messageType = (_a = this.model.errorMessage) === null || _a === void 0 ? void 0 : _a.type;
        if (messageType === 'Warning') {
            return this.model.img('MsgFormWarning.png');
        }
        else if (messageType === true || messageType === 'Info') {
            return this.model.img('MsgFormInfo.png');
        }
        else {
            return this.model.img('MsgFormError.png');
        }
    }
}
ErrorMessageFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ErrorMessageFormComponent, deps: [{ token: ModelService }, { token: FormService }], target: i0.ɵɵFactoryTarget.Component });
ErrorMessageFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ErrorMessageFormComponent, selector: "sti-error-message-form", ngImport: i0, template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'errorMessageForm'"
      [caption]="model.loc(model.errorMessage?.type == 'Error' ? 'Error' : 'FormViewerTitle')"
      [level]="4"
      [defaultTop]="150"
      [showCancel]="false"
      (action)="formService.closeForm('errorMessageForm')">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <img [attr.src]="getImage()" style="padding: 15px; height: 32px; width: 32px;">
            </td>
            <td class="stiJsViewerMessagesFormDescription" style="max-width: 600px;"
              [style.color]="model.options.toolbar.fontColor" [innerHTML]="model.errorMessage?.error">
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "component", type: BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ErrorMessageFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-error-message-form',
                    template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'errorMessageForm'"
      [caption]="model.loc(model.errorMessage?.type == 'Error' ? 'Error' : 'FormViewerTitle')"
      [level]="4"
      [defaultTop]="150"
      [showCancel]="false"
      (action)="formService.closeForm('errorMessageForm')">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <img [attr.src]="getImage()" style="padding: 15px; height: 32px; width: 32px;">
            </td>
            <td class="stiJsViewerMessagesFormDescription" style="max-width: 600px;"
              [style.color]="model.options.toolbar.fontColor" [innerHTML]="model.errorMessage?.error">
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: FormService }]; } });

class ResourcesPanelComponent {
    constructor(model, controller, helper) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        controller.getMessage().subscribe((message) => {
            var _a;
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                this.model.controls.resourcesPanel.visible = ((_a = this.model.reportParams.resources) === null || _a === void 0 ? void 0 : _a.length) > 0;
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.resourcesPanel.el = this.element;
    }
    action(resource) {
        const resTypesAllowedViewInBrowser = ['Image', 'Pdf', 'Txt'];
        const viewType = resTypesAllowedViewInBrowser.indexOf(resource.type) >= 0 ? 'View' : 'SaveFile';
        this.controller.postReportResource(resource.name, this.model.options.jsMode ? 'SaveFile' : viewType);
    }
    getResourceImage(resourceType) {
        if (this.model.img('BigResource' + resourceType + '.png') !== '') {
            return 'BigResource' + resourceType + '.png';
        }
        else {
            return 'BigResource.png';
        }
    }
    getMenuItems(resource) {
        const items = [];
        items.push({ name: 'Resource' + 'View', caption: this.model.loc('ButtonView'), value: resource });
        items.push({ name: 'Resource' + 'SaveFile', caption: this.model.loc('SaveFile'), value: resource });
        return items;
    }
    getActionName(resource) {
        if (!resource.id) {
            resource.id = Math.random().toString();
        }
        return 'resource' + resource.name + resource.id;
    }
}
ResourcesPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ResourcesPanelComponent, deps: [{ token: ModelService }, { token: ControllerService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
ResourcesPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ResourcesPanelComponent, selector: "sti-resources-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element style="z-index: 3"
      [style.display]="this.model.controls.resourcesPanel.visible ? '' : 'none'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="model.options.toolbar.fontColor"
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" style="box-sizing: border-box; display: table;"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td *ngFor="let resource of model.reportParams.resources" class="stiJsViewerClearAllStyles">
                  <sti-button [caption]="resource.name"
                    [caption2]="helper.getHumanFileSize(resource.size, 1)"
                    [imageName]="getResourceImage(resource.type)"
                    [styleName]="'stiJsViewerFormButton'"
                    [height]="'auto'"
                    [margin]="'3px 0 3px 3px'"
                    [innerTableWidth]="'100%'"
                    [minWidth]="'80px'"
                    [captionAlign]="'left'"
                    [captionPaddingLeft]="'3px'"
                    [captionMaxWidth]="'150px'"
                    [captionLineHeight]="'14px'"
                    [captionWhiteSpace]="'nowrap'"
                    [captionOverflow]="'hidden'"
                    [captionTextOverflow]="'ellipsis'"
                    [imageCellWidth]="'1px'"
                    [imageCellPadding]="'4px 8px 4px 4px'"
                    [menuItems]="getMenuItems(resource)"
                    [resourceButton]="true"
                    [imageSizesWidth]="32"
                    [imageSizesHeight]="32"
                    [actionName]="getActionName(resource)"
                    (action)="action(resource)">
                  </sti-button>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ResourcesPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-resources-panel',
                    template: `
    <div #element style="z-index: 3"
      [style.display]="this.model.controls.resourcesPanel.visible ? '' : 'none'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="model.options.toolbar.fontColor"
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" style="box-sizing: border-box; display: table;"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td *ngFor="let resource of model.reportParams.resources" class="stiJsViewerClearAllStyles">
                  <sti-button [caption]="resource.name"
                    [caption2]="helper.getHumanFileSize(resource.size, 1)"
                    [imageName]="getResourceImage(resource.type)"
                    [styleName]="'stiJsViewerFormButton'"
                    [height]="'auto'"
                    [margin]="'3px 0 3px 3px'"
                    [innerTableWidth]="'100%'"
                    [minWidth]="'80px'"
                    [captionAlign]="'left'"
                    [captionPaddingLeft]="'3px'"
                    [captionMaxWidth]="'150px'"
                    [captionLineHeight]="'14px'"
                    [captionWhiteSpace]="'nowrap'"
                    [captionOverflow]="'hidden'"
                    [captionTextOverflow]="'ellipsis'"
                    [imageCellWidth]="'1px'"
                    [imageCellPadding]="'4px 8px 4px 4px'"
                    [menuItems]="getMenuItems(resource)"
                    [resourceButton]="true"
                    [imageSizesWidth]="32"
                    [imageSizesHeight]="32"
                    [actionName]="getActionName(resource)"
                    (action)="action(resource)">
                  </sti-button>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: HelperService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

class ProgressComponent {
    constructor(model) {
        this.model = model;
    }
    ngOnInit() { }
}
ProgressComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ProgressComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
ProgressComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ProgressComponent, selector: "sti-progress", ngImport: i0, template: `
    <div style="position: absolute; z-index: 1000; left: calc(50% - 35px);"
        [style.top]="model.options.appearance.fullScreenMode ? 'calc(50% - 100px)' : '250px'"
        [style.display]="model.showProgress ? '' : 'none'">
      <div class="js_viewer_loader js_viewer_loader_default"></div>
    </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ProgressComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-progress',
                    template: `
    <div style="position: absolute; z-index: 1000; left: calc(50% - 35px);"
        [style.top]="model.options.appearance.fullScreenMode ? 'calc(50% - 100px)' : '250px'"
        [style.display]="model.showProgress ? '' : 'none'">
      <div class="js_viewer_loader js_viewer_loader_default"></div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; } });

class NavigatePanelComponent {
    constructor(model, controller, helper, pageService) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.pageService = pageService;
        this.comps = [];
    }
    ngOnInit() {
        if (this.model.options.toolbar.displayMode === 'Separated') {
            this.initButtons();
        }
        this.controller.getMessage().subscribe((message) => {
            if (message.action !== 'viewer_loaded') {
                this.updateButtons();
            }
        });
        this.model.controls.navigatePanel.visible = this.model.options.toolbar.displayMode === 'Separated';
    }
    ngAfterViewInit() {
        this.model.controls.navigatePanel.el = this.element;
    }
    updateButtons() {
        this.comps.filter(i => i.action === 'ViewMode').forEach(m => m.caption = this.model.loc(this.model.reportParams.viewMode));
        this.comps.filter(i => i.action === 'Zoom').forEach((m) => {
            m.menuItems.forEach(n => n.selected = n.name === ('Zoom' + this.model.reportParams.zoom));
            m.caption = Math.round(this.model.reportParams.zoom) + '%';
        });
        this.comps.filter(i => i.action === 'ShowFind').forEach((m) => {
            m.selected = this.model.controls.findPanel.visible;
        });
    }
    initButtons() {
        const comps = [];
        if (this.model.options.toolbar.showFirstPageButton) {
            comps.push({ type: 'button', action: 'FirstPage', img: 'PageFirst20.png', tooltip: true });
        }
        if (this.model.options.toolbar.showPreviousPageButton) {
            comps.push({ type: 'button', action: 'PrevPage', img: 'PagePrevious20.png', tooltip: true });
        }
        if (this.model.options.toolbar.showCurrentPageControl) {
            comps.push({ type: 'separator' });
            comps.push({ type: 'pageControl' });
            comps.push({ type: 'separator' });
        }
        if (this.model.options.toolbar.showNextPageButton) {
            comps.push({ type: 'button', action: 'NextPage', img: 'PageNext20.png', tooltip: true });
        }
        if (this.model.options.toolbar.showLastPageButton) {
            comps.push({ type: 'button', action: 'LastPage', img: 'PageLast20.png', tooltip: true });
        }
        comps.push({ type: 'space' });
        comps.push({ type: 'button', action: 'ZoomPageWidth', img: 'ZoomPageWidth20.png', tooltip: true });
        comps.push({ type: 'button', action: 'ZoomOnePage', img: 'ZoomOnePage20.png', tooltip: true });
        if (this.model.options.toolbar.showZoomButton) {
            comps.push({ type: 'separator' });
            comps.push({
                type: 'button', action: 'Zoom', caption: '100%', tooltip: true, arrow: 'Arrows.SmallArrowUpWhite.png',
                menuItems: this.helper.getZoomMenuItems()
            });
        }
        this.comps = comps;
    }
    enabled(desc) {
        const disableNaviButtons = this.disableNaviButtons();
        switch (desc.action) {
            case 'FirstPage':
            case 'PrevPage':
                return this.model.reportParams.pageNumber > 0 && !disableNaviButtons;
            case 'NextPage':
            case 'LastPage':
                return this.model.reportParams.pageNumber < this.model.reportParams.pagesCount - 1 && !disableNaviButtons;
        }
        return true;
    }
    selected(desc) {
        switch (desc.action) {
            case 'ZoomPageWidth':
                return Math.round(this.model.reportParams.zoom) === Math.round(this.pageService.getZoomByPageWidth());
            case 'ZoomOnePage':
                return Math.round(this.model.reportParams.zoom) === Math.round(this.pageService.getZoomByPageHeight());
        }
        return false;
    }
    disableNaviButtons() {
        return this.model.reportParams.viewMode === 'MultiplePages' || this.model.reportParams.viewMode === 'WholeReport' ||
            (this.model.reportParams.viewMode === 'Continuous' && !this.model.options.appearance.scrollbarsMode && !this.model.options.appearance.fullScreenMode);
    }
}
NavigatePanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NavigatePanelComponent, deps: [{ token: ModelService }, { token: ControllerService }, { token: HelperService }, { token: PageService }], target: i0.ɵɵFactoryTarget.Component });
NavigatePanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: NavigatePanelComponent, selector: "sti-navigate-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
  <div #element class="stiJsViewerNavigatePanel" style="display: block;"
    [style.display]="!model.options.isMobileDevice ? (this.model.controls.navigatePanel.visible ? '' : 'none') : ''"
    [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
    [style.zIndex]="model.options.isMobileDevice ? (model.options.toolbar.autoHide ? 5 : 2) : null"
    [style.opacity]="model.options.isMobileDevice ? (model.controls.navigatePanel.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
    [style.marginBottom]="model.options.isMobileDevice && !model.controls.navigatePanel.visible ? '-0.55in' : 0">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles" [style.width]="comp.type == 'space' ? '100%' : null">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="comp.caption"
              [imageName]="comp.img"
              [arrow]="comp.arrow"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [styleName]="'stiJsViewerNavigateButton'"
              [height]="model.options.isMobileDevice ? '0.5in' : '35px'"
              [width]="model.options.isMobileDevice ? '0.4in' : '35px'"
              [boxSizing]="'border-box'"
              [arrowMarginTop]="'1px'"
              [enabled]="enabled(comp)"
              [imageCellTextAlign]="'center'"
              [innerTableWidth]="'100%'"
              [navagationPanelTooltip]="true"
              [margin]="comp.action == 'FirstPage' ? '0 1px 0 3px' : (comp.action == 'Zoom' ? '0 3px 0 1px' : '0px 1px 0 1px')"
              [selected]="selected(comp)"
              (action)="controller.action({ name: comp.action })">
            </sti-button>

            <div *ngIf="comp.type=='separator'"
              [style.height]="model.options.isMobileDevice ? '0.5in' : '35px'"
              [style.margin]="'0px 1px 0 1px'"
              class="stiJsViewerNavigatePanelSeparator"></div>

            <sti-page-control *ngIf="comp.type=='pageControl'"
              [enabled]="!(model.reportParams.pagesCount <= 1 || disableNaviButtons())"
              [count]="model.reportParams.pagesCount"
              [margin]="'0px 1px 0 1px'"
              [textBoxBorder]="'0px'"></sti-page-control>
          </td>
        </tr>
      </tbody>
    </table>
    <div class="stiJsViewerNavigatePanelDisabledPanel" [style.display]="this.model.controls.navigatePanel.enabled ? 'none' : 'block'"></div>
  </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: PageControlComponent, selector: "sti-page-control", inputs: ["enabled", "count", "textBoxBorder", "margin"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NavigatePanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-navigate-panel',
                    template: `
  <div #element class="stiJsViewerNavigatePanel" style="display: block;"
    [style.display]="!model.options.isMobileDevice ? (this.model.controls.navigatePanel.visible ? '' : 'none') : ''"
    [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
    [style.zIndex]="model.options.isMobileDevice ? (model.options.toolbar.autoHide ? 5 : 2) : null"
    [style.opacity]="model.options.isMobileDevice ? (model.controls.navigatePanel.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
    [style.marginBottom]="model.options.isMobileDevice && !model.controls.navigatePanel.visible ? '-0.55in' : 0">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles" [style.width]="comp.type == 'space' ? '100%' : null">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="comp.caption"
              [imageName]="comp.img"
              [arrow]="comp.arrow"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [styleName]="'stiJsViewerNavigateButton'"
              [height]="model.options.isMobileDevice ? '0.5in' : '35px'"
              [width]="model.options.isMobileDevice ? '0.4in' : '35px'"
              [boxSizing]="'border-box'"
              [arrowMarginTop]="'1px'"
              [enabled]="enabled(comp)"
              [imageCellTextAlign]="'center'"
              [innerTableWidth]="'100%'"
              [navagationPanelTooltip]="true"
              [margin]="comp.action == 'FirstPage' ? '0 1px 0 3px' : (comp.action == 'Zoom' ? '0 3px 0 1px' : '0px 1px 0 1px')"
              [selected]="selected(comp)"
              (action)="controller.action({ name: comp.action })">
            </sti-button>

            <div *ngIf="comp.type=='separator'"
              [style.height]="model.options.isMobileDevice ? '0.5in' : '35px'"
              [style.margin]="'0px 1px 0 1px'"
              class="stiJsViewerNavigatePanelSeparator"></div>

            <sti-page-control *ngIf="comp.type=='pageControl'"
              [enabled]="!(model.reportParams.pagesCount <= 1 || disableNaviButtons())"
              [count]="model.reportParams.pagesCount"
              [margin]="'0px 1px 0 1px'"
              [textBoxBorder]="'0px'"></sti-page-control>
          </td>
        </tr>
      </tbody>
    </table>
    <div class="stiJsViewerNavigatePanelDisabledPanel" [style.display]="this.model.controls.navigatePanel.enabled ? 'none' : 'block'"></div>
  </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: HelperService }, { type: PageService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

class AboutPanelComponent {
    constructor(model, controller, helper, formService) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.formService = formService;
        this.year = new Date().getFullYear();
        this.top = 0;
        this.left = 0;
        this.opacity = 0;
        controller.getActionMessage().subscribe((message) => {
            if (message.action === 'About') {
                this.formService.form = { name: 'about', left: 0, top: 0, isMooving: false, level: 2 };
                this.opacity = 0;
                setTimeout(() => {
                    this.top = this.model.viewerSize.height / 2 - this.element.nativeElement.offsetHeight / 2;
                    this.left = this.model.viewerSize.width / 2 - this.element.nativeElement.offsetWidth / 2;
                    this.opacity = 1;
                });
            }
        });
    }
    ngOnInit() { }
    close() {
        this.formService.closeForm('about');
    }
    click(event) {
        if (event) {
            event.stopPropagation();
            event.preventDefault();
        }
        this.helper.openNewWindow('https://www.stimulsoft.com');
    }
    isLicensed() {
        return !this.model.options.cloudMode && !this.model.options.serverMode && !this.model.options.standaloneJsMode &&
            !this.model.options.reportDesignerMode && !this.model.options.licenseIsValid;
    }
    get userLabel() {
        let userName = this.model.options.licenseUserName || '';
        if (this.isLicensed()) {
            if (userName) {
                userName += ', ';
            }
            return userName + this.helper.getBackText(true) + ' Version';
        }
        else {
            return userName;
        }
    }
}
AboutPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AboutPanelComponent, deps: [{ token: ModelService }, { token: ControllerService }, { token: HelperService }, { token: FormService }], target: i0.ɵɵFactoryTarget.Component });
AboutPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: AboutPanelComponent, selector: "sti-about-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element class="stiJsViewerAboutPanel" style="background-size: contain;"
      [style.display]="formService.form?.name == 'about' ? '' : 'none'"
      [style.left.px]="left"
      [style.top.px]="top"
      [style.opacity]="opacity"
      (click)="close()" >
      <div class="stiJsViewerAboutPanelHeader">
        Stimulsoft Reports
      </div>
      <img src="{{model.img('About.png')}}" style="margin-top: 30px; height: 94px; width: 94px;">
      <div class="stiJsViewerAboutPanelCopyright">
        {{'Copyright 2003-' + year + ' Stimulsoft'}}
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        {{model.options.productVersion?.trim()}}, {{model.options?.frameworkType}}, Angular
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        All rights reserved
      </div>
      <div class="stiJsViewerAboutPanelVersion" style="margin-top: 20px;font-weight: bold; "
        [style.color]="isLicensed() ? 'red' : '#444444'"
        [style.display]="isLicensed() || userLabel ? '' : 'none'">
        {{userLabel}}
      </div>
      <div class="stiJsViewerFormSeparator" style="margin-top: 20px;">
      </div>
      <div class="stiJsViewerAboutPanelStiLink" (click)='click($event)'>
        www.stimulsoft.com
      </div>
    </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AboutPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-about-panel',
                    template: `
    <div #element class="stiJsViewerAboutPanel" style="background-size: contain;"
      [style.display]="formService.form?.name == 'about' ? '' : 'none'"
      [style.left.px]="left"
      [style.top.px]="top"
      [style.opacity]="opacity"
      (click)="close()" >
      <div class="stiJsViewerAboutPanelHeader">
        Stimulsoft Reports
      </div>
      <img src="{{model.img('About.png')}}" style="margin-top: 30px; height: 94px; width: 94px;">
      <div class="stiJsViewerAboutPanelCopyright">
        {{'Copyright 2003-' + year + ' Stimulsoft'}}
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        {{model.options.productVersion?.trim()}}, {{model.options?.frameworkType}}, Angular
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        All rights reserved
      </div>
      <div class="stiJsViewerAboutPanelVersion" style="margin-top: 20px;font-weight: bold; "
        [style.color]="isLicensed() ? 'red' : '#444444'"
        [style.display]="isLicensed() || userLabel ? '' : 'none'">
        {{userLabel}}
      </div>
      <div class="stiJsViewerFormSeparator" style="margin-top: 20px;">
      </div>
      <div class="stiJsViewerAboutPanelStiLink" (click)='click($event)'>
        www.stimulsoft.com
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: HelperService }, { type: FormService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

class CenterTextComponent {
    constructor(model, controller, helper) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.text = '';
        this.opacity = 0;
        this.display = 'none';
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'centerText':
                    this.show(message.data);
                    break;
                case 'hideCenterText':
                    this.hide();
                    break;
            }
        });
    }
    ngOnInit() { }
    show(text) {
        this.display = '';
        this.opacity = 0;
        this.text = text;
        setTimeout(() => {
            this.helper.setObjectToCenter(this.element.nativeElement);
            this.opacity = 1;
        });
        if (this.hideTimer) {
            clearTimeout(this.hideTimer);
        }
        this.hideTimer = setTimeout(() => {
            this.hide();
        }, 2000);
    }
    hide() {
        this.opacity = 0;
        if (this.hideTimer) {
            clearTimeout(this.hideTimer);
        }
        this.hideTimer = setTimeout(() => {
            this.display = 'none';
        }, 300);
    }
}
CenterTextComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CenterTextComponent, deps: [{ token: ModelService }, { token: ControllerService }, { token: HelperService }], target: i0.ɵɵFactoryTarget.Component });
CenterTextComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: CenterTextComponent, selector: "sti-center-text", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
      style="position: absolute; z-index: 1000; transition-property: opacity; transition-duration: 300ms; text-shadow: rgb(0, 0, 0) -1px -1px 0px, rgb(0, 0, 0) 1px -1px 0px, rgb(0, 0, 0) -1px 1px 0px, rgb(0, 0, 0) 1px 1px 0px; font-size: 100px;"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [style.opacity]="opacity"
      [style.display]="display">
      <div>
        {{text}}
      </div>
    </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CenterTextComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-center-text',
                    template: `
    <div #element
      style="position: absolute; z-index: 1000; transition-property: opacity; transition-duration: 300ms; text-shadow: rgb(0, 0, 0) -1px -1px 0px, rgb(0, 0, 0) 1px -1px 0px, rgb(0, 0, 0) -1px 1px 0px, rgb(0, 0, 0) 1px 1px 0px; font-size: 100px;"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [style.opacity]="opacity"
      [style.display]="display">
      <div>
        {{text}}
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: ControllerService }, { type: HelperService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

class NotificationFormComponent {
    constructor(model, formService) {
        this.model = model;
        this.formService = formService;
    }
    ngOnInit() { }
    changeVisibility(state) {
        var _a;
        if (state === 'hidden' && ((_a = this.model.notificationFormOptions) === null || _a === void 0 ? void 0 : _a.cancelAction)) {
            this.model.notificationFormOptions.cancelAction();
        }
    }
    action() {
        var _a;
        ((_a = this.model.notificationFormOptions) === null || _a === void 0 ? void 0 : _a.action) ? this.model.notificationFormOptions.action() : this.formService.closeForm('notificationForm');
    }
}
NotificationFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NotificationFormComponent, deps: [{ token: ModelService }, { token: FormService }], target: i0.ɵɵFactoryTarget.Component });
NotificationFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: NotificationFormComponent, selector: "sti-notification-form", ngImport: i0, template: `
  <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'notificationForm'"
      [defaultTop]="150"
      [caption]="model.loc('Viewer')"
      [level]="4"
      [showButtons]="false"
      [showSeparator]="false"
      (changeVisibility)="changeVisibility($event)">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr *ngIf="model.notificationFormOptions?.image" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="text-align: center;">
              <img src="{{model.img(model.notificationFormOptions?.image)}}" style="margin-top: 20px; width: 112px; height: 112px;">
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.message" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormMessage">
                {{model.notificationFormOptions?.message}}
              </div>
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.description" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormDescription">
                {{model.notificationFormOptions?.description}}
              </div>
            </td>
          </tr>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="text-align: center;">
              <sti-button
                [caption]="model.notificationFormOptions?.buttonCaption"
                [styleName]="'stiJsViewerLoginButton'"
                [innerTableWidth]="'100%'"
                [height]="'40px'"
                [minWidth]="'80px'"
                [captionAlign]="'center'"
                [cursor]="'pointer'"
                [display]="'inline-block'"
                [minWidth]="'200px'"
                [width]="'auto'"
                [margin]="'20px 30px 30px 30px'"
                [fontSize]="'14px'"
                (action)="action()">
              </sti-button>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
    `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NotificationFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-notification-form',
                    template: `
  <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'notificationForm'"
      [defaultTop]="150"
      [caption]="model.loc('Viewer')"
      [level]="4"
      [showButtons]="false"
      [showSeparator]="false"
      (changeVisibility)="changeVisibility($event)">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr *ngIf="model.notificationFormOptions?.image" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="text-align: center;">
              <img src="{{model.img(model.notificationFormOptions?.image)}}" style="margin-top: 20px; width: 112px; height: 112px;">
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.message" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormMessage">
                {{model.notificationFormOptions?.message}}
              </div>
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.description" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormDescription">
                {{model.notificationFormOptions?.description}}
              </div>
            </td>
          </tr>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="text-align: center;">
              <sti-button
                [caption]="model.notificationFormOptions?.buttonCaption"
                [styleName]="'stiJsViewerLoginButton'"
                [innerTableWidth]="'100%'"
                [height]="'40px'"
                [minWidth]="'80px'"
                [captionAlign]="'center'"
                [cursor]="'pointer'"
                [display]="'inline-block'"
                [minWidth]="'200px'"
                [width]="'auto'"
                [margin]="'20px 30px 30px 30px'"
                [fontSize]="'14px'"
                (action)="action()">
              </sti-button>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
    `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: FormService }]; } });

class DashboardButtonComponent {
    constructor(model) {
        this.model = model;
        this.showCloseButton = false;
    }
    ngOnInit() { }
}
DashboardButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DashboardButtonComponent, deps: [{ token: ModelService }], target: i0.ɵɵFactoryTarget.Component });
DashboardButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DashboardButtonComponent, selector: "sti-dashboard-button", inputs: { showCloseButton: "showCloseButton", info: "info", dbsMode: "dbsMode", display: "display" }, ngImport: i0, template: `
    <sti-button
      [margin]="'2px 1px 2px 2px'"
      [display]="display"
      [borderColor]="!dbsMode ? 'transparent' : ''"
      [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null">
    </sti-button>
  `, isInline: true, dependencies: [{ kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DashboardButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-dashboard-button',
                    template: `
    <sti-button
      [margin]="'2px 1px 2px 2px'"
      [display]="display"
      [borderColor]="!dbsMode ? 'transparent' : ''"
      [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null">
    </sti-button>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }]; }, propDecorators: { showCloseButton: [{
                type: Input
            }], info: [{
                type: Input
            }], dbsMode: [{
                type: Input
            }], display: [{
                type: Input
            }] } });

class DashboardsPanelComponent {
    constructor(model, helper, dashboardService) {
        this.model = model;
        this.helper = helper;
        this.dashboardService = dashboardService;
        this.imagesPath = 'Dashboards.Actions.Light.';
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.navigatePanel.el = this.element;
    }
    get dbsMode() {
        return this.dashboardsCount > 0 && this.reportsCount === 0;
    }
    get dashboardsCount() {
        var _a, _b;
        let count = 0;
        if ((_b = (_a = this.model) === null || _a === void 0 ? void 0 : _a.reportParams) === null || _b === void 0 ? void 0 : _b.dashboards) {
            this.model.reportParams.dashboards.forEach(i => {
                if (i['type'] === 'Dashboard') {
                    count++;
                }
            });
        }
        return count;
    }
    get reportsCount() {
        var _a, _b;
        if ((_b = (_a = this.model) === null || _a === void 0 ? void 0 : _a.reportParams) === null || _b === void 0 ? void 0 : _b.dashboards) {
            return this.model.reportParams.dashboards.length - this.dashboardsCount;
        }
        return 0;
    }
    get previewSettings() {
        return this.model.reportParams.previewSettings || {};
    }
}
DashboardsPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DashboardsPanelComponent, deps: [{ token: ModelService }, { token: HelperService }, { token: DashboardService }], target: i0.ɵɵFactoryTarget.Component });
DashboardsPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DashboardsPanelComponent, selector: "sti-dashboards-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="helper.val(model.options.toolbar.fontColor)"
      [style.display]="model.controls.dashboardsPanel.visible ? '' : 'none'"
      [style.background]="dbsMode ? 'transparent' : ''"
      [style.borderColor]="dbsMode ? 'transparent' : ''">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin: 0px; box-sizing: border-box;"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
          [style.background]="dbsMode ? 'transparent' : ''"
          [style.borderColor]="dbsMode ? 'transparent' : ''">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="width: 100%;">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0"
                  [style.align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment == 'default' ? 'left' : model.options.toolbar.alignment)">
                  <tbody>
                      <tr>
                         <td *ngFor="let info of model.reportParams.dashboards; let i=index">
                            <sti-dashboard-button
                              [info]="info"
                              [dbsMode]="dbsMode"
                              [display]="dashboardsCount == 1 && reportsCount == 0 ? 'none': null">
                            </sti-dashboard-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>

              <!-- actions table -->
              <td class="stiJsViewerClearAllStyles">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin-right:2px">
                  <tbody>
                      <tr>
                        <td *ngIf="model.options.toolbar.showRefreshButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Refresh.png'"
                            [tooltip]="model.loc('Refresh')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Refresh'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardRefreshButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showParametersButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Parameters.png'"
                            [tooltip]="model.loc('Parameters')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Parameters'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showOpenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Open.png'"
                            [tooltip]="model.loc('Open')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'OpenDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardOpenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showDesignButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Edit.png'"
                            [tooltip]="model.loc('Edit')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postDesign'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardEditButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showFullScreenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'CloseFullScreen.png'"
                            [caption]="model.loc('Close')"
                            [tooltip]="model.loc('FullScreen')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postFullScreen'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardFullScreenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showSaveButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Menu.png'"
                            [tooltip]="model.loc('Save')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'ExportDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardMenuButton && ((previewSettings.dashboardShowReportSnapshots && !model.options.jsMode) || previewSettings.dashboardShowExports) ? '' :'none'">
                          </sti-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: DashboardButtonComponent, selector: "sti-dashboard-button", inputs: ["showCloseButton", "info", "dbsMode", "display"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DashboardsPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-dashboards-panel',
                    template: `
    <div #element
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="helper.val(model.options.toolbar.fontColor)"
      [style.display]="model.controls.dashboardsPanel.visible ? '' : 'none'"
      [style.background]="dbsMode ? 'transparent' : ''"
      [style.borderColor]="dbsMode ? 'transparent' : ''">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin: 0px; box-sizing: border-box;"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
          [style.background]="dbsMode ? 'transparent' : ''"
          [style.borderColor]="dbsMode ? 'transparent' : ''">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="width: 100%;">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0"
                  [style.align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment == 'default' ? 'left' : model.options.toolbar.alignment)">
                  <tbody>
                      <tr>
                         <td *ngFor="let info of model.reportParams.dashboards; let i=index">
                            <sti-dashboard-button
                              [info]="info"
                              [dbsMode]="dbsMode"
                              [display]="dashboardsCount == 1 && reportsCount == 0 ? 'none': null">
                            </sti-dashboard-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>

              <!-- actions table -->
              <td class="stiJsViewerClearAllStyles">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin-right:2px">
                  <tbody>
                      <tr>
                        <td *ngIf="model.options.toolbar.showRefreshButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Refresh.png'"
                            [tooltip]="model.loc('Refresh')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Refresh'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardRefreshButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showParametersButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Parameters.png'"
                            [tooltip]="model.loc('Parameters')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Parameters'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showOpenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Open.png'"
                            [tooltip]="model.loc('Open')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'OpenDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardOpenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showDesignButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Edit.png'"
                            [tooltip]="model.loc('Edit')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postDesign'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardEditButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showFullScreenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'CloseFullScreen.png'"
                            [caption]="model.loc('Close')"
                            [tooltip]="model.loc('FullScreen')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postFullScreen'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardFullScreenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showSaveButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Menu.png'"
                            [tooltip]="model.loc('Save')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'ExportDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardMenuButton && ((previewSettings.dashboardShowReportSnapshots && !model.options.jsMode) || previewSettings.dashboardShowExports) ? '' :'none'">
                          </sti-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: ModelService }, { type: HelperService }, { type: DashboardService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });

//1bfb351c1add27b1537ffce9c723e3cb1f5b27bb 02.03.2021 17:29:20
class StimulsoftViewerComponent {
    constructor(controller, menuService, model, exportService, formService, api, printService, dashboardService) {
        this.controller = controller;
        this.menuService = menuService;
        this.model = model;
        this.exportService = exportService;
        this.formService = formService;
        this.api = api;
        this.printService = printService;
        this.dashboardService = dashboardService;
        /**
         * Occurs when report/dashboard loaded
         */
        this.loaded = new EventEmitter();
        /**
         * Occurs on error, $event is ErrorMessage object contains error: string & type: any  (if present)
         */
        this.error = new EventEmitter();
        /**
         * Occurs on export, $event object contains exportFormat: string & exportSettings: {}
         */
        this.export = new EventEmitter();
        /**
         * Occurs on export & email, $event object contains exportFormat: string & exportSettings: {}
         */
        this.email = new EventEmitter();
        /**
         * Occurs on export & email, $event object contains format: string : 'PrintPdf' or 'PrintWithoutPreview' or 'PrintWithPreview'
         */
        this.print = new EventEmitter();
        /**
         * Occurs on pressing 'Design' button
         */
        this.design = new EventEmitter();
        /**
         * Controller action that handle viewer initial request
         */
        this.action = 'InitViewer';
        /**
         * Viewer background color
         */
        this.backgroundColor = 'White';
        this.initialized = false;
        this.viewInit = false;
        window.onresize = () => this.resize();
        this.initEvents();
    }
    ngOnDestroy() {
        try {
            clearInterval(this.model.timerAutoUpdateCache);
            clearInterval(this.model.refreshReportTimer);
        }
        catch (_a) { }
    }
    ngOnChanges(changes) {
        this.loadViewer();
    }
    ngOnInit() {
        this.model.postParametersFunction = this.postParametersFunction;
        this.controller.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'viewer_loaded':
                    this.initialized = true;
                    break;
            }
        });
    }
    ngAfterViewInit() {
        this.viewInit = true;
        this.loadViewer();
    }
    initEvents() {
        this.controller.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'GetReport':
                case 'OpenReport':
                    setTimeout(() => {
                        this.loaded.next(null);
                    });
                    this.showTr();
                    break;
            }
        });
        this.controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Error':
                    setTimeout(() => {
                        this.error.next(this.model.errorMessage);
                    });
                    break;
                case 'ExportReport':
                    setTimeout(() => {
                        this.export.next(message.data);
                    });
                    break;
                case 'Email':
                    setTimeout(() => {
                        this.email.next(message.data);
                    });
                    break;
                case 'Print':
                    setTimeout(() => {
                        this.print.next(message.data);
                    });
                    break;
                case 'Design':
                    setTimeout(() => {
                        this.design.next(null);
                    });
                    break;
            }
            this.showTr();
        });
    }
    loadViewer() {
        if (this.viewInit) {
            this.model.requestUrl = this.requestUrl;
            this.model.action = this.action || 'InitViewer';
            this.model.properties = this.properties;
            this.controller.loadViewer();
            this.resize();
            this.model.controls.viewer.el = this.viewerElement;
        }
    }
    resize() {
        var _a;
        if ((_a = this.viewerElement) === null || _a === void 0 ? void 0 : _a.nativeElement) {
            this.model.viewerSize = { width: this.viewerElement.nativeElement.offsetWidth, height: this.viewerElement.nativeElement.offsetHeight };
            this.controller.viewerResized();
        }
    }
    showTr() {
        if (!this.model.options.alternateValid) {
            console.warn("You are using a trial version of the Stimulsoft product!");
        }
    }
}
StimulsoftViewerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftViewerComponent, deps: [{ token: ControllerService }, { token: MenuService }, { token: ModelService }, { token: ExportService }, { token: FormService }, { token: ApiService }, { token: PrintService }, { token: DashboardService }], target: i0.ɵɵFactoryTarget.Component });
StimulsoftViewerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StimulsoftViewerComponent, selector: "stimulsoft-viewer-angular", inputs: { requestUrl: "requestUrl", action: "action", properties: "properties", width: "width", height: "height", backgroundColor: "backgroundColor", style: "style", postParametersFunction: "postParametersFunction" }, outputs: { loaded: "loaded", error: "error", export: "export", email: "email", print: "print", design: "design" }, providers: [ModelService, StiHttpClientService, ControllerService, StylesService, HelperService, MenuService,
        MouseService, PageService, TooltipService, FindService, AnimationService, Md5Service, InteractionsService, FormService, RadioButtonService, ExportService,
        CollectionsService, MailService, EditableFieldsService, DrillDownService, PrintService, FullScreenService, ToolbarService, ApiService, DashboardService], viewQueries: [{ propertyName: "viewerElement", first: true, predicate: ["viewer"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <span #viewer [style]="style"
      [style.top.px]="0"
      [style.right.px]="0"
      [style.bottom.px]="0"
      [style.left.px]="0"
      [style.display]="'inline-block'"
      [style.backgroundColor]="backgroundColor"
      [style.width]="this.width != null ? this.width : '100%'"
      [style.height]="this.height != null ? this.height : (model.options?.appearance.scrollbarsMode ? '650px' : '100%')"
      [id]="model.options?.viewerId">
      <div class="stiJsViewerMainPanel">
        <sti-center-text *ngIf="initialized"></sti-center-text>
        <sti-toolbar *ngIf="initialized"></sti-toolbar>
        <div *ngFor="let i of [1,2,3,4,5]" [style.zIndex]="i * 10" [style.display]="formService.form?.level == i ? '' : 'none'" class="stiJsViewerDisabledPanel"></div>
        <sti-about-panel *ngIf="initialized"></sti-about-panel>

        <sti-dashboards-panel *ngIf="initialized"></sti-dashboards-panel>
        <sti-report-panel *ngIf="initialized"></sti-report-panel>
        <sti-progress *ngIf="initialized"></sti-progress>
        <sti-find-panel *ngIf="initialized"></sti-find-panel>
        <sti-drill-down-panel *ngIf="initialized"></sti-drill-down-panel>
        <sti-resources-panel *ngIf="initialized"></sti-resources-panel>
        <sti-navigate-panel *ngIf="initialized"></sti-navigate-panel>

        <sti-export-form *ngIf="initialized" [exportFormSettings]="exportService.exportFormSettings"></sti-export-form>
        <sti-send-email-form *ngIf="initialized"></sti-send-email-form>
        <sti-password-form *ngIf="initialized"></sti-password-form>
        <sti-error-message-form *ngIf="initialized"></sti-error-message-form>
        <sti-notification-form *ngIf="initialized"></sti-notification-form>

        <sti-tooltip *ngIf="initialized"></sti-tooltip>
        <sti-menu *ngFor="let menu of menuService.menus" [menu]="menu"></sti-menu>
        <sti-bookmarks-panel *ngIf="initialized"></sti-bookmarks-panel>
        <sti-interactions-panel *ngIf="initialized"></sti-interactions-panel>

        <sti-open-dialog *ngIf="initialized" [fileMask]="model.openDialogFileMask"></sti-open-dialog>
      </div>
    </span>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ToolbarComponent, selector: "sti-toolbar" }, { kind: "component", type: ReportPanelComponent, selector: "sti-report-panel" }, { kind: "component", type: MenuComponent, selector: "sti-menu", inputs: ["menu"] }, { kind: "component", type: TooltipComponent, selector: "sti-tooltip" }, { kind: "component", type: FindPanelComponent, selector: "sti-find-panel" }, { kind: "component", type: BookmarksPanelComponent, selector: "sti-bookmarks-panel" }, { kind: "component", type: InteractionsPanelComponent, selector: "sti-interactions-panel" }, { kind: "component", type: ExportFormComponent, selector: "sti-export-form", inputs: ["exportFormSettings"] }, { kind: "component", type: SendEmailFormComponent, selector: "sti-send-email-form" }, { kind: "component", type: DrillDownPanelComponent, selector: "sti-drill-down-panel" }, { kind: "component", type: OpenDialogComponent, selector: "sti-open-dialog", inputs: ["fileMask"] }, { kind: "component", type: PasswordFormComponent, selector: "sti-password-form" }, { kind: "component", type: ErrorMessageFormComponent, selector: "sti-error-message-form" }, { kind: "component", type: ResourcesPanelComponent, selector: "sti-resources-panel" }, { kind: "component", type: ProgressComponent, selector: "sti-progress" }, { kind: "component", type: NavigatePanelComponent, selector: "sti-navigate-panel" }, { kind: "component", type: AboutPanelComponent, selector: "sti-about-panel" }, { kind: "component", type: CenterTextComponent, selector: "sti-center-text" }, { kind: "component", type: NotificationFormComponent, selector: "sti-notification-form" }, { kind: "component", type: DashboardsPanelComponent, selector: "sti-dashboards-panel" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftViewerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'stimulsoft-viewer-angular',
                    template: `
    <span #viewer [style]="style"
      [style.top.px]="0"
      [style.right.px]="0"
      [style.bottom.px]="0"
      [style.left.px]="0"
      [style.display]="'inline-block'"
      [style.backgroundColor]="backgroundColor"
      [style.width]="this.width != null ? this.width : '100%'"
      [style.height]="this.height != null ? this.height : (model.options?.appearance.scrollbarsMode ? '650px' : '100%')"
      [id]="model.options?.viewerId">
      <div class="stiJsViewerMainPanel">
        <sti-center-text *ngIf="initialized"></sti-center-text>
        <sti-toolbar *ngIf="initialized"></sti-toolbar>
        <div *ngFor="let i of [1,2,3,4,5]" [style.zIndex]="i * 10" [style.display]="formService.form?.level == i ? '' : 'none'" class="stiJsViewerDisabledPanel"></div>
        <sti-about-panel *ngIf="initialized"></sti-about-panel>

        <sti-dashboards-panel *ngIf="initialized"></sti-dashboards-panel>
        <sti-report-panel *ngIf="initialized"></sti-report-panel>
        <sti-progress *ngIf="initialized"></sti-progress>
        <sti-find-panel *ngIf="initialized"></sti-find-panel>
        <sti-drill-down-panel *ngIf="initialized"></sti-drill-down-panel>
        <sti-resources-panel *ngIf="initialized"></sti-resources-panel>
        <sti-navigate-panel *ngIf="initialized"></sti-navigate-panel>

        <sti-export-form *ngIf="initialized" [exportFormSettings]="exportService.exportFormSettings"></sti-export-form>
        <sti-send-email-form *ngIf="initialized"></sti-send-email-form>
        <sti-password-form *ngIf="initialized"></sti-password-form>
        <sti-error-message-form *ngIf="initialized"></sti-error-message-form>
        <sti-notification-form *ngIf="initialized"></sti-notification-form>

        <sti-tooltip *ngIf="initialized"></sti-tooltip>
        <sti-menu *ngFor="let menu of menuService.menus" [menu]="menu"></sti-menu>
        <sti-bookmarks-panel *ngIf="initialized"></sti-bookmarks-panel>
        <sti-interactions-panel *ngIf="initialized"></sti-interactions-panel>

        <sti-open-dialog *ngIf="initialized" [fileMask]="model.openDialogFileMask"></sti-open-dialog>
      </div>
    </span>
  `,
                    providers: [ModelService, StiHttpClientService, ControllerService, StylesService, HelperService, MenuService,
                        MouseService, PageService, TooltipService, FindService, AnimationService, Md5Service, InteractionsService, FormService, RadioButtonService, ExportService,
                        CollectionsService, MailService, EditableFieldsService, DrillDownService, PrintService, FullScreenService, ToolbarService, ApiService, DashboardService]
                }]
        }], ctorParameters: function () { return [{ type: ControllerService }, { type: MenuService }, { type: ModelService }, { type: ExportService }, { type: FormService }, { type: ApiService }, { type: PrintService }, { type: DashboardService }]; }, propDecorators: { viewerElement: [{
                type: ViewChild,
                args: ['viewer']
            }], loaded: [{
                type: Output
            }], error: [{
                type: Output
            }], export: [{
                type: Output
            }], email: [{
                type: Output
            }], print: [{
                type: Output
            }], design: [{
                type: Output
            }], requestUrl: [{
                type: Input
            }], action: [{
                type: Input
            }], properties: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }], backgroundColor: [{
                type: Input
            }], style: [{
                type: Input
            }], postParametersFunction: [{
                type: Input
            }] } });

class StimulsoftViewerModule {
}
StimulsoftViewerModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftViewerModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
StimulsoftViewerModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftViewerModule, declarations: [StimulsoftViewerComponent, ToolbarComponent, ButtonComponent, PageComponent, ReportPanelComponent, ToolbarSeparatorComponent, PageControlComponent, TextBoxComponent,
        MenuComponent, MenuItemComponent, TooltipComponent, FindPanelComponent, TextBlockComponent, BookmarksPanelComponent, InteractionsPanelComponent, FormButtonComponent,
        ParameterComponent, ParameterTextBoxComponent, CheckboxComponent, ParameterCheckboxComponent, ParameterButtonComponent, ParameterMenuEditListComponent,
        ParameterMenuItemComponent, ParameterMenuSeparatorComponent, ParameterFindComponent, ParameterMenuNotEditListComponent, ParameterMenuForValueComponent,
        ParameterMenuForRangeComponent, DatePickerMenuComponent, DropDownListComponent, VerticalMenuComponent, VerticalMenuItemComponent, DatePickerDayButtonComponent,
        DoubleDatePickerMenuComponent, BaseFormComponent, ExportFormComponent, GroupPanelComponent, RadioButtonComponent, DropDownListForExportFormComponent,
        DocumentSecurityMenuComponent, DigitalSignatureMenuComponent, SendEmailFormComponent, TextAreaComponent, DrillDownPanelComponent, OpenDialogComponent,
        PasswordFormComponent, ErrorMessageFormComponent, ResourcesPanelComponent, ProgressComponent, NavigatePanelComponent, AboutPanelComponent, ToolbarDopComponent,
        CenterTextComponent, NotificationFormComponent, DashboardsPanelComponent, DashboardButtonComponent], imports: [CommonModule], exports: [StimulsoftViewerComponent] });
StimulsoftViewerModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftViewerModule, imports: [CommonModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftViewerModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [StimulsoftViewerComponent, ToolbarComponent, ButtonComponent, PageComponent, ReportPanelComponent, ToolbarSeparatorComponent, PageControlComponent, TextBoxComponent,
                        MenuComponent, MenuItemComponent, TooltipComponent, FindPanelComponent, TextBlockComponent, BookmarksPanelComponent, InteractionsPanelComponent, FormButtonComponent,
                        ParameterComponent, ParameterTextBoxComponent, CheckboxComponent, ParameterCheckboxComponent, ParameterButtonComponent, ParameterMenuEditListComponent,
                        ParameterMenuItemComponent, ParameterMenuSeparatorComponent, ParameterFindComponent, ParameterMenuNotEditListComponent, ParameterMenuForValueComponent,
                        ParameterMenuForRangeComponent, DatePickerMenuComponent, DropDownListComponent, VerticalMenuComponent, VerticalMenuItemComponent, DatePickerDayButtonComponent,
                        DoubleDatePickerMenuComponent, BaseFormComponent, ExportFormComponent, GroupPanelComponent, RadioButtonComponent, DropDownListForExportFormComponent,
                        DocumentSecurityMenuComponent, DigitalSignatureMenuComponent, SendEmailFormComponent, TextAreaComponent, DrillDownPanelComponent, OpenDialogComponent,
                        PasswordFormComponent, ErrorMessageFormComponent, ResourcesPanelComponent, ProgressComponent, NavigatePanelComponent, AboutPanelComponent, ToolbarDopComponent,
                        CenterTextComponent, NotificationFormComponent, DashboardsPanelComponent, DashboardButtonComponent],
                    imports: [
                        CommonModule
                    ],
                    providers: [],
                    exports: [StimulsoftViewerComponent]
                }]
        }] });

/*
 * Public API Surface of stimulsoft-viewer-angular
 */

/**
 * Generated bundle index. Do not edit.
 */

export { StimulsoftViewerComponent, StimulsoftViewerModule };
//# sourceMappingURL=stimulsoft-viewer-angular.mjs.map
