import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import { ControllerService } from './services/controller.service';
import { MenuService } from './menu/menu.service';
import { ModelService } from './services/model.service';
import { ExportService } from './services/export.service';
import { FormService } from './forms/form.service';
import { ApiService } from './services/api.service';
import { PrintService } from './services/print.service';
import { DashboardService } from './services/dashboard.service';
import { StiHttpClientService } from './services/http-client.service';
import { StylesService } from './services/styles.service';
import { HelperService } from './services/helper.service';
import { MouseService } from './services/mouse.service';
import { PageService } from './services/page.service';
import { TooltipService } from './services/tooltip.service';
import { FindService } from './services/find.service';
import { AnimationService } from './services/animation.service';
import { InteractionsService } from './services/interactions.service';
import { RadioButtonService } from './services/radio-button.service';
import { CollectionsService } from './services/collections.service';
import { MailService } from './services/mail.service';
import { EditableFieldsService } from './services/editable-fields.service';
import { DrillDownService } from './services/drill-down.service';
import { Md5Service } from './services/md5.service';
import { FullScreenService } from './services/full-screen.service';
import { ToolbarService } from './services/toolbar.service';
import * as i0 from "@angular/core";
import * as i1 from "./services/controller.service";
import * as i2 from "./menu/menu.service";
import * as i3 from "./services/model.service";
import * as i4 from "./services/export.service";
import * as i5 from "./forms/form.service";
import * as i6 from "./services/api.service";
import * as i7 from "./services/print.service";
import * as i8 from "./services/dashboard.service";
import * as i9 from "@angular/common";
import * as i10 from "./components/toolbar.component";
import * as i11 from "./components/report-panel.component";
import * as i12 from "./menu/menu.component";
import * as i13 from "./controls/tooltip.component";
import * as i14 from "./components/find-panel.component";
import * as i15 from "./components/bookmarks-panel.component";
import * as i16 from "./components/interactions-panel.component";
import * as i17 from "./forms/export-form.component";
import * as i18 from "./forms/send-email-form.component";
import * as i19 from "./components/drill-down-panel.component";
import * as i20 from "./components/open-dialog.component";
import * as i21 from "./forms/password-form.component";
import * as i22 from "./forms/error-message-form.component";
import * as i23 from "./components/resources-panel.component";
import * as i24 from "./components/progress.component";
import * as i25 from "./components/navigate-panel.component";
import * as i26 from "./components/about-panel.component";
import * as i27 from "./components/center-text.component";
import * as i28 from "./forms/notification-form.component";
import * as i29 from "./components/dashboards-panel.component";
//1bfb351c1add27b1537ffce9c723e3cb1f5b27bb 02.03.2021 17:29:20
export class StimulsoftViewerComponent {
    constructor(controller, menuService, model, exportService, formService, api, printService, dashboardService) {
        this.controller = controller;
        this.menuService = menuService;
        this.model = model;
        this.exportService = exportService;
        this.formService = formService;
        this.api = api;
        this.printService = printService;
        this.dashboardService = dashboardService;
        /**
         * Occurs when report/dashboard loaded
         */
        this.loaded = new EventEmitter();
        /**
         * Occurs on error, $event is ErrorMessage object contains error: string & type: any  (if present)
         */
        this.error = new EventEmitter();
        /**
         * Occurs on export, $event object contains exportFormat: string & exportSettings: {}
         */
        this.export = new EventEmitter();
        /**
         * Occurs on export & email, $event object contains exportFormat: string & exportSettings: {}
         */
        this.email = new EventEmitter();
        /**
         * Occurs on export & email, $event object contains format: string : 'PrintPdf' or 'PrintWithoutPreview' or 'PrintWithPreview'
         */
        this.print = new EventEmitter();
        /**
         * Occurs on pressing 'Design' button
         */
        this.design = new EventEmitter();
        /**
         * Controller action that handle viewer initial request
         */
        this.action = 'InitViewer';
        /**
         * Viewer background color
         */
        this.backgroundColor = 'White';
        this.initialized = false;
        this.viewInit = false;
        window.onresize = () => this.resize();
        this.initEvents();
    }
    ngOnDestroy() {
        try {
            clearInterval(this.model.timerAutoUpdateCache);
            clearInterval(this.model.refreshReportTimer);
        }
        catch { }
    }
    ngOnChanges(changes) {
        this.loadViewer();
    }
    ngOnInit() {
        this.model.postParametersFunction = this.postParametersFunction;
        this.controller.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'viewer_loaded':
                    this.initialized = true;
                    break;
            }
        });
    }
    ngAfterViewInit() {
        this.viewInit = true;
        this.loadViewer();
    }
    initEvents() {
        this.controller.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'GetReport':
                case 'OpenReport':
                    setTimeout(() => {
                        this.loaded.next(null);
                    });
                    this.showTr();
                    break;
            }
        });
        this.controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Error':
                    setTimeout(() => {
                        this.error.next(this.model.errorMessage);
                    });
                    break;
                case 'ExportReport':
                    setTimeout(() => {
                        this.export.next(message.data);
                    });
                    break;
                case 'Email':
                    setTimeout(() => {
                        this.email.next(message.data);
                    });
                    break;
                case 'Print':
                    setTimeout(() => {
                        this.print.next(message.data);
                    });
                    break;
                case 'Design':
                    setTimeout(() => {
                        this.design.next(null);
                    });
                    break;
            }
            this.showTr();
        });
    }
    loadViewer() {
        if (this.viewInit) {
            this.model.requestUrl = this.requestUrl;
            this.model.action = this.action || 'InitViewer';
            this.model.properties = this.properties;
            this.controller.loadViewer();
            this.resize();
            this.model.controls.viewer.el = this.viewerElement;
        }
    }
    resize() {
        if (this.viewerElement?.nativeElement) {
            this.model.viewerSize = { width: this.viewerElement.nativeElement.offsetWidth, height: this.viewerElement.nativeElement.offsetHeight };
            this.controller.viewerResized();
        }
    }
    showTr() {
        if (!this.model.options.alternateValid) {
            console.warn("You are using a trial version of the Stimulsoft product!");
        }
    }
}
StimulsoftViewerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftViewerComponent, deps: [{ token: i1.ControllerService }, { token: i2.MenuService }, { token: i3.ModelService }, { token: i4.ExportService }, { token: i5.FormService }, { token: i6.ApiService }, { token: i7.PrintService }, { token: i8.DashboardService }], target: i0.ɵɵFactoryTarget.Component });
StimulsoftViewerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StimulsoftViewerComponent, selector: "stimulsoft-viewer-angular", inputs: { requestUrl: "requestUrl", action: "action", properties: "properties", width: "width", height: "height", backgroundColor: "backgroundColor", style: "style", postParametersFunction: "postParametersFunction" }, outputs: { loaded: "loaded", error: "error", export: "export", email: "email", print: "print", design: "design" }, providers: [ModelService, StiHttpClientService, ControllerService, StylesService, HelperService, MenuService,
        MouseService, PageService, TooltipService, FindService, AnimationService, Md5Service, InteractionsService, FormService, RadioButtonService, ExportService,
        CollectionsService, MailService, EditableFieldsService, DrillDownService, PrintService, FullScreenService, ToolbarService, ApiService, DashboardService], viewQueries: [{ propertyName: "viewerElement", first: true, predicate: ["viewer"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <span #viewer [style]="style"
      [style.top.px]="0"
      [style.right.px]="0"
      [style.bottom.px]="0"
      [style.left.px]="0"
      [style.display]="'inline-block'"
      [style.backgroundColor]="backgroundColor"
      [style.width]="this.width != null ? this.width : '100%'"
      [style.height]="this.height != null ? this.height : (model.options?.appearance.scrollbarsMode ? '650px' : '100%')"
      [id]="model.options?.viewerId">
      <div class="stiJsViewerMainPanel">
        <sti-center-text *ngIf="initialized"></sti-center-text>
        <sti-toolbar *ngIf="initialized"></sti-toolbar>
        <div *ngFor="let i of [1,2,3,4,5]" [style.zIndex]="i * 10" [style.display]="formService.form?.level == i ? '' : 'none'" class="stiJsViewerDisabledPanel"></div>
        <sti-about-panel *ngIf="initialized"></sti-about-panel>

        <sti-dashboards-panel *ngIf="initialized"></sti-dashboards-panel>
        <sti-report-panel *ngIf="initialized"></sti-report-panel>
        <sti-progress *ngIf="initialized"></sti-progress>
        <sti-find-panel *ngIf="initialized"></sti-find-panel>
        <sti-drill-down-panel *ngIf="initialized"></sti-drill-down-panel>
        <sti-resources-panel *ngIf="initialized"></sti-resources-panel>
        <sti-navigate-panel *ngIf="initialized"></sti-navigate-panel>

        <sti-export-form *ngIf="initialized" [exportFormSettings]="exportService.exportFormSettings"></sti-export-form>
        <sti-send-email-form *ngIf="initialized"></sti-send-email-form>
        <sti-password-form *ngIf="initialized"></sti-password-form>
        <sti-error-message-form *ngIf="initialized"></sti-error-message-form>
        <sti-notification-form *ngIf="initialized"></sti-notification-form>

        <sti-tooltip *ngIf="initialized"></sti-tooltip>
        <sti-menu *ngFor="let menu of menuService.menus" [menu]="menu"></sti-menu>
        <sti-bookmarks-panel *ngIf="initialized"></sti-bookmarks-panel>
        <sti-interactions-panel *ngIf="initialized"></sti-interactions-panel>

        <sti-open-dialog *ngIf="initialized" [fileMask]="model.openDialogFileMask"></sti-open-dialog>
      </div>
    </span>
  `, isInline: true, dependencies: [{ kind: "directive", type: i9.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i9.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i10.ToolbarComponent, selector: "sti-toolbar" }, { kind: "component", type: i11.ReportPanelComponent, selector: "sti-report-panel" }, { kind: "component", type: i12.MenuComponent, selector: "sti-menu", inputs: ["menu"] }, { kind: "component", type: i13.TooltipComponent, selector: "sti-tooltip" }, { kind: "component", type: i14.FindPanelComponent, selector: "sti-find-panel" }, { kind: "component", type: i15.BookmarksPanelComponent, selector: "sti-bookmarks-panel" }, { kind: "component", type: i16.InteractionsPanelComponent, selector: "sti-interactions-panel" }, { kind: "component", type: i17.ExportFormComponent, selector: "sti-export-form", inputs: ["exportFormSettings"] }, { kind: "component", type: i18.SendEmailFormComponent, selector: "sti-send-email-form" }, { kind: "component", type: i19.DrillDownPanelComponent, selector: "sti-drill-down-panel" }, { kind: "component", type: i20.OpenDialogComponent, selector: "sti-open-dialog", inputs: ["fileMask"] }, { kind: "component", type: i21.PasswordFormComponent, selector: "sti-password-form" }, { kind: "component", type: i22.ErrorMessageFormComponent, selector: "sti-error-message-form" }, { kind: "component", type: i23.ResourcesPanelComponent, selector: "sti-resources-panel" }, { kind: "component", type: i24.ProgressComponent, selector: "sti-progress" }, { kind: "component", type: i25.NavigatePanelComponent, selector: "sti-navigate-panel" }, { kind: "component", type: i26.AboutPanelComponent, selector: "sti-about-panel" }, { kind: "component", type: i27.CenterTextComponent, selector: "sti-center-text" }, { kind: "component", type: i28.NotificationFormComponent, selector: "sti-notification-form" }, { kind: "component", type: i29.DashboardsPanelComponent, selector: "sti-dashboards-panel" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftViewerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'stimulsoft-viewer-angular',
                    template: `
    <span #viewer [style]="style"
      [style.top.px]="0"
      [style.right.px]="0"
      [style.bottom.px]="0"
      [style.left.px]="0"
      [style.display]="'inline-block'"
      [style.backgroundColor]="backgroundColor"
      [style.width]="this.width != null ? this.width : '100%'"
      [style.height]="this.height != null ? this.height : (model.options?.appearance.scrollbarsMode ? '650px' : '100%')"
      [id]="model.options?.viewerId">
      <div class="stiJsViewerMainPanel">
        <sti-center-text *ngIf="initialized"></sti-center-text>
        <sti-toolbar *ngIf="initialized"></sti-toolbar>
        <div *ngFor="let i of [1,2,3,4,5]" [style.zIndex]="i * 10" [style.display]="formService.form?.level == i ? '' : 'none'" class="stiJsViewerDisabledPanel"></div>
        <sti-about-panel *ngIf="initialized"></sti-about-panel>

        <sti-dashboards-panel *ngIf="initialized"></sti-dashboards-panel>
        <sti-report-panel *ngIf="initialized"></sti-report-panel>
        <sti-progress *ngIf="initialized"></sti-progress>
        <sti-find-panel *ngIf="initialized"></sti-find-panel>
        <sti-drill-down-panel *ngIf="initialized"></sti-drill-down-panel>
        <sti-resources-panel *ngIf="initialized"></sti-resources-panel>
        <sti-navigate-panel *ngIf="initialized"></sti-navigate-panel>

        <sti-export-form *ngIf="initialized" [exportFormSettings]="exportService.exportFormSettings"></sti-export-form>
        <sti-send-email-form *ngIf="initialized"></sti-send-email-form>
        <sti-password-form *ngIf="initialized"></sti-password-form>
        <sti-error-message-form *ngIf="initialized"></sti-error-message-form>
        <sti-notification-form *ngIf="initialized"></sti-notification-form>

        <sti-tooltip *ngIf="initialized"></sti-tooltip>
        <sti-menu *ngFor="let menu of menuService.menus" [menu]="menu"></sti-menu>
        <sti-bookmarks-panel *ngIf="initialized"></sti-bookmarks-panel>
        <sti-interactions-panel *ngIf="initialized"></sti-interactions-panel>

        <sti-open-dialog *ngIf="initialized" [fileMask]="model.openDialogFileMask"></sti-open-dialog>
      </div>
    </span>
  `,
                    providers: [ModelService, StiHttpClientService, ControllerService, StylesService, HelperService, MenuService,
                        MouseService, PageService, TooltipService, FindService, AnimationService, Md5Service, InteractionsService, FormService, RadioButtonService, ExportService,
                        CollectionsService, MailService, EditableFieldsService, DrillDownService, PrintService, FullScreenService, ToolbarService, ApiService, DashboardService]
                }]
        }], ctorParameters: function () { return [{ type: i1.ControllerService }, { type: i2.MenuService }, { type: i3.ModelService }, { type: i4.ExportService }, { type: i5.FormService }, { type: i6.ApiService }, { type: i7.PrintService }, { type: i8.DashboardService }]; }, propDecorators: { viewerElement: [{
                type: ViewChild,
                args: ['viewer']
            }], loaded: [{
                type: Output
            }], error: [{
                type: Output
            }], export: [{
                type: Output
            }], email: [{
                type: Output
            }], print: [{
                type: Output
            }], design: [{
                type: Output
            }], requestUrl: [{
                type: Input
            }], action: [{
                type: Input
            }], properties: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }], backgroundColor: [{
                type: Input
            }], style: [{
                type: Input
            }], postParametersFunction: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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