import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "../menu/menu.service";
export class TooltipService {
    constructor(model, menuService) {
        this.model = model;
        this.menuService = menuService;
        this.state = 'initial';
        this.caption = '';
        this.helpLink = '';
        this.top = 0;
        this.left = 0;
        this.innerState = 'initial';
    }
    show(left, top, caption, below = true, helpLink) {
        if (this.menuService.isMenuVisible() || !this.model.options.appearance.showTooltips) {
            this.hideImmediately();
            return;
        }
        if (this.caption === caption && this.helpLink === helpLink && this.state !== 'initial') {
            this.showInternal();
            return;
        }
        this.caption = caption;
        this.helpLink = helpLink;
        this.state = this.innerState = this.state !== 'expanded' ? 'preInitial' : 'preInitial2';
        setTimeout(() => {
            const tooltip = this.model.controls.tooltip.el.nativeElement;
            const browserWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
            if (!below) {
                top -= tooltip.offsetHeight;
            }
            if (left + tooltip.offsetWidth > browserWidth) {
                left = browserWidth - tooltip.offsetWidth;
            }
            this.left = left;
            this.top = top;
            if (this.innerState !== 'initial') {
                this.showInternal();
            }
        });
    }
    showInternal() {
        this.state = 'expanded';
        this.innerState = 'expanded';
    }
    showFromTooltip() {
        if (this.state !== 'preInitial') {
            this.state = 'expanded';
            this.innerState = 'expanded';
        }
    }
    hideImmediately() {
        this.innerState = 'initial';
        this.state = 'initial';
    }
    hide() {
        this.innerState = 'initial';
        if (this.timeout) {
            clearTimeout(this.timeout);
        }
        this.timeout = setTimeout(() => {
            if (this.innerState === 'initial') {
                this.state = 'initial';
            }
            this.timeout = null;
        }, 1000);
    }
}
TooltipService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipService, deps: [{ token: i1.ModelService }, { token: i2.MenuService }], target: i0.ɵɵFactoryTarget.Injectable });
TooltipService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.MenuService }]; } });
//# sourceMappingURL=data:application/json;base64,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