import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./controller.service";
import * as i3 from "./editable-fields.service";
import * as i4 from "./interactions.service";
import * as i5 from "./helper.service";
export class ToolbarService {
    constructor(model, controller, editableFieldsService, interactionService, helper) {
        this.model = model;
        this.controller = controller;
        this.editableFieldsService = editableFieldsService;
        this.interactionService = interactionService;
        this.helper = helper;
        this.comps = [];
        this.dopComps = [];
        this.controller.getMessage().subscribe((message) => {
            if (message.action !== 'viewer_loaded') {
                this.updateButtons();
            }
        });
    }
    updateButtons() {
        this.comps.filter(i => i.action === 'ViewMode').forEach(m => m.caption = this.model.loc(this.model.reportParams.viewMode));
        this.comps.filter(i => i.action === 'Zoom').forEach((m) => {
            m.menuItems.forEach(n => n.selected = n.name === ('Zoom' + this.model.reportParams.zoom));
            m.caption = this.model.reportParams.zoom ? Math.round(this.model.reportParams.zoom) + '%' : '';
        });
        this.comps.filter(i => i.action === 'ShowFind').forEach((m) => {
            m.selected = this.model.controls.findPanel.visible;
        });
    }
    initButtons() {
        const comps = [];
        const dopComps = [];
        let isFirst = false;
        if (this.model.options.toolbar.showAboutButton) {
            dopComps.push({ type: 'button', action: 'About', img: 'Help.png' });
        }
        if (this.model.options.toolbar.showAboutButton && this.model.options.toolbar.showDesignButton) {
            dopComps.push({ type: 'separator' });
        }
        if (this.model.options.toolbar.showDesignButton) {
            dopComps.push({ type: 'button', action: 'Design', caption: this.model.loc('Design'), img: 'Design.png' });
        }
        if (this.model.options.toolbar.showPinToolbarButton && this.model.options.toolbar.showDesignButton) {
            dopComps.push({ type: 'separator' });
        }
        if (this.model.options.toolbar.showPinToolbarButton) {
            dopComps.push({ type: 'button', action: 'Pin', img: 'Pin.png' });
        }
        if (this.model.options.toolbar.showPrintButton) {
            comps.push({
                type: 'button', action: 'Print', caption: this.model.loc('Print'), img: 'Print.png', tooltip: true,
                arrow: this.model.options.toolbar.printDestination === 'Default' ? 'Down' : null,
                menuItems: this.model.options.toolbar.printDestination === 'Default' ?
                    [{ name: 'PrintPdf', caption: this.model.loc('PrintPdf'), img: 'Save.Small.Pdf.png' },
                        { name: 'PrintWithPreview', caption: this.model.loc('PrintWithPreview'), img: 'ViewMode.png' },
                        { name: 'PrintWithoutPreview', caption: this.model.loc('PrintWithoutPreview'), img: 'Print.png' }] :
                    null
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showOpenButton) {
            comps.push({ type: 'button', action: 'Open', caption: this.model.loc('Open'), img: 'Open.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showSaveButton) {
            comps.push({
                type: 'button', action: 'Save', caption: this.model.loc('Save'), img: 'Save.png', tooltip: true, arrow: 'Down',
                menuItems: this.getSaveMenuItems('saveMenu')
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showSendEmailButton) {
            comps.push({
                type: 'button', action: 'SendEmail', caption: this.model.loc('SendEmail'), img: 'SendEmail.png', tooltip: true, arrow: 'Down',
                menuItems: this.getSaveMenuItems('sendEmailMenu')
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showBookmarksButton || this.model.options.toolbar.showParametersButton) {
            if (!isFirst) {
                comps.push({ type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.toolbar.showBookmarksButton) {
            comps.push({ type: 'button', action: 'Bookmarks', caption: this.model.options.toolbar.displayMode === 'Separated' ? this.model.loc('Bookmarks') : null, img: 'Bookmarks.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showParametersButton) {
            comps.push({ type: 'button', action: 'Parameters', caption: this.model.options.toolbar.displayMode === 'Separated' ? this.model.loc('Parameters') : null, img: 'Parameters.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showResourcesButton) {
            comps.push({ type: 'button', action: 'Resources', caption: this.model.options.toolbar.displayMode === 'Separated' ? this.model.loc('Resources') : null, img: 'Resources.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showFindButton || this.model.options.toolbar.showEditorButton) {
            if (!isFirst) {
                comps.push({ type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.toolbar.showFindButton) {
            comps.push({ type: 'button', action: 'Find', img: 'Find.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.showEditorButton) {
            comps.push({ type: 'button', action: 'Editor', img: 'Editor.png', tooltip: true });
            isFirst = false;
        }
        if (this.model.options.toolbar.displayMode !== 'Separated') {
            if (this.model.options.toolbar.showFirstPageButton || this.model.options.toolbar.showPreviousPageButton || this.model.options.toolbar.showNextPageButton ||
                this.model.options.toolbar.showLastPageButton || this.model.options.toolbar.showCurrentPageControl) {
                if (!isFirst) {
                    comps.push({ type: 'separator' });
                }
                isFirst = false;
            }
            if (this.model.options.toolbar.showFirstPageButton) {
                comps.push({ type: 'button', action: 'FirstPage', img: this.model.options.appearance.rightToLeft ? 'LastPage.png' : 'FirstPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showPreviousPageButton) {
                comps.push({ type: 'button', action: 'PrevPage', img: this.model.options.appearance.rightToLeft ? 'NextPage.png' : 'PrevPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showCurrentPageControl) {
                comps.push({ type: 'pageControl' });
                isFirst = false;
            }
            if (this.model.options.toolbar.showNextPageButton) {
                comps.push({ type: 'button', action: 'NextPage', img: this.model.options.appearance.rightToLeft ? 'PrevPage.png' : 'NextPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showLastPageButton) {
                comps.push({ type: 'button', action: 'LastPage', img: this.model.options.appearance.rightToLeft ? 'FirstPage.png' : 'LastPage.png', tooltip: true });
                isFirst = false;
            }
            if (this.model.options.toolbar.showViewModeButton || this.model.options.toolbar.showZoomButton) {
                if (!isFirst) {
                    comps.push({ type: 'separator' });
                }
                isFirst = false;
            }
        }
        if (this.model.options.toolbar.showFullScreenButton) {
            comps.push({ type: 'button', action: 'FullScreen', img: 'FullScreen.png', tooltip: true });
            comps.push({ type: 'separator' });
            isFirst = false;
        }
        if (this.model.options.toolbar.showZoomButton && this.model.options.toolbar.displayMode !== 'Separated') {
            comps.push({
                type: 'button', action: 'Zoom', caption: '100%', img: 'Zoom.png', tooltip: true, arrow: 'Down',
                menuItems: this.helper.getZoomMenuItems()
            });
            isFirst = false;
        }
        if (this.model.options.toolbar.showViewModeButton) {
            comps.push({
                type: 'button', action: 'ViewMode', caption: this.model.loc('SinglePage'), img: 'SinglePage.png', tooltip: true, arrow: 'Down',
                menuItems: [{ name: 'ViewModeSinglePage', caption: this.model.loc('SinglePage'), img: 'SinglePage.png' },
                    { name: 'ViewModeContinuous', caption: this.model.loc('Continuous'), img: 'Continuous.png' },
                    { name: 'ViewModeMultiplePages', caption: this.model.loc('MultiplePages'), img: 'MultiplePages.png' }]
            });
            isFirst = false;
        }
        if (typeof (this.model.options.toolbar.multiPageWidthCount) !== 'undefined') {
            this.model.reportParams.multiPageWidthCount = this.model.options.toolbar.multiPageWidthCount;
        }
        if (typeof (this.model.options.toolbar.multiPageHeightCount) !== 'undefined') {
            this.model.reportParams.multiPageHeightCount = this.model.options.toolbar.multiPageHeightCount;
        }
        if (!this.model.options.appearance.rightToLeft && this.model.options.toolbar.alignment === 'right' &&
            (this.model.options.toolbar.showPinToolbarButton || this.model.options.toolbar.showAboutButton || this.model.options.toolbar.showDesignButton)) {
            comps.push({ type: 'separator6' });
        }
        this.comps = this.model.options.appearance.rightToLeft ? comps.reverse() : comps;
        this.dopComps = this.model.options.appearance.rightToLeft ? dopComps.reverse() : dopComps;
    }
    disableNaviButtons() {
        return this.model.reportParams.viewMode === 'MultiplePages' || this.model.reportParams.viewMode === 'WholeReport' ||
            (this.model.reportParams.viewMode === 'Continuous' && !this.model.options.appearance.scrollbarsMode && !this.model.options.appearance.fullScreenMode);
    }
    getImage(imageName) {
        switch (this.model.options.appearance.saveMenuImageSize) {
            case 'Big':
                return `Save.Big.${imageName}.png`;
            case 'None':
                return null;
            default:
                return `Save.Small.${imageName}.png`;
        }
    }
    getSaveMenuItems(menuName) {
        let isFirst = true;
        const items = [];
        const imageSize = this.model.options.appearance.saveMenuImageSize;
        if (this.model.options.exports.showExportToDocument && menuName === 'saveMenu') {
            items.push({ name: menuName + 'Document', caption: this.model.loc('ReportSnapshot'), imageSize, img: this.getImage('Document') });
            isFirst = false;
        }
        if (menuName === 'saveMenu' && this.model.options.exports.showExportToPdf || this.model.options.exports.showExportToXps || this.model.options.exports.showExportToPowerPoint) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.exports.showExportToPdf) {
            items.push({ name: menuName + 'Pdf', caption: 'Adobe PDF', imageSize, img: this.getImage('Pdf') });
        }
        if (this.model.options.exports.showExportToXps) {
            items.push({ name: menuName + 'Xps', caption: 'Microsoft XPS', imageSize, img: this.getImage('Xps') });
        }
        if (this.model.options.exports.showExportToPowerPoint) {
            items.push({ name: menuName + 'Ppt2007', caption: 'Microsoft PowerPoint', imageSize, img: this.getImage('Ppt') });
        }
        if (this.model.options.exports.showExportToHtml || this.model.options.exports.showExportToHtml5 || this.model.options.exports.showExportToMht) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
            let htmlType = this.model.options.exports.defaultSettings['StiHtmlExportSettings'].HtmlType;
            if (!this.model.options.exports['showExportTo' + htmlType]) {
                if (this.model.options.exports.showExportToHtml) {
                    htmlType = 'Html';
                }
                else if (this.model.options.exports.showExportToHtml5) {
                    htmlType = 'Html5';
                }
                else if (this.model.options.exports.showExportToMht) {
                    htmlType = 'Mht';
                }
            }
            items.push({ name: menuName + htmlType, caption: 'HTML', imageSize, img: this.getImage('Html') });
        }
        if (this.model.options.exports.showExportToText || this.model.options.exports.showExportToRtf || this.model.options.exports.showExportToWord2007 || this.model.options.exports.showExportToOdt) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.exports.showExportToText) {
            items.push({ name: menuName + 'Text', caption: this.model.loc('Text'), imageSize, img: this.getImage('Text') });
        }
        if (this.model.options.exports.showExportToRtf) {
            items.push({ name: menuName + 'Rtf', caption: 'RTF', imageSize, img: this.getImage('Rtf') });
        }
        if (this.model.options.exports.showExportToWord2007) {
            items.push({ name: menuName + 'Word2007', caption: 'Microsoft Word', imageSize, img: this.getImage('Word') });
        }
        if (this.model.options.exports.showExportToOpenDocumentWriter) {
            items.push({ name: menuName + 'Odt', caption: 'OpenDocument Writer', imageSize, img: this.getImage('Odt') });
        }
        if (this.model.options.exports.showExportToExcel || this.model.options.exports.showExportToExcel2007 || this.model.options.exports.showExportToExcelXml || this.model.options.exports.showExportToOpenDocumentWriter) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
        }
        if (this.model.options.exports.showExportToExcel || this.model.options.exports.showExportToExcelXml || this.model.options.exports.showExportToExcel2007) {
            let excelType = this.model.options.exports.defaultSettings['StiExcelExportSettings'].ExcelType;
            if (excelType === 'ExcelBinary') {
                excelType = 'Excel';
            }
            if (!this.model.options.exports['showExportTo' + excelType]) {
                if (this.model.options.exports.showExportToExcel) {
                    excelType = 'Excel';
                }
                else if (this.model.options.exports.showExportToExcel2007) {
                    excelType = 'Excel2007';
                }
                else if (this.model.options.exports.showExportToExcelXml) {
                    excelType = 'ExcelXml';
                }
            }
            items.push({ name: menuName + excelType, caption: 'Microsoft Excel', imageSize, img: this.getImage('Excel') });
        }
        if (this.model.options.exports.showExportToOpenDocumentCalc) {
            items.push({ name: menuName + 'Ods', caption: 'OpenDocument Calc', imageSize, img: this.getImage('Ods') });
        }
        if (this.model.options.exports.showExportToCsv || this.model.options.exports.showExportToDbf || this.model.options.exports.showExportToXml ||
            this.model.options.exports.showExportToDif || this.model.options.exports.showExportToSylk || this.model.options.exports.showExportToJson) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
            let dataType = this.model.options.exports.defaultSettings['StiDataExportSettings'].DataType;
            if (!this.model.options.exports['showExportTo' + dataType]) {
                if (this.model.options.exports.showExportToCsv) {
                    dataType = 'Csv';
                }
                else if (this.model.options.exports.showExportToDbf) {
                    dataType = 'Dbf';
                }
                else if (this.model.options.exports.showExportToXml) {
                    dataType = 'Xml';
                }
                else if (this.model.options.exports.showExportToDif) {
                    dataType = 'Dif';
                }
                else if (this.model.options.exports.showExportToSylk) {
                    dataType = 'Sylk';
                }
                else if (this.model.options.exports.showExportToJson) {
                    dataType = 'Json';
                }
            }
            items.push({ name: menuName + dataType, caption: this.model.loc('Data'), imageSize, img: this.getImage('Data') });
        }
        if (this.model.options.exports.showExportToImageBmp || this.model.options.exports.showExportToImageGif || this.model.options.exports.showExportToImageJpeg || this.model.options.exports.showExportToImagePcx ||
            this.model.options.exports.showExportToImagePng || this.model.options.exports.showExportToImageTiff || this.model.options.exports.showExportToImageMetafile || this.model.options.exports.showExportToImageSvg || this.model.options.exports.showExportToImageSvgz) {
            if (!isFirst) {
                items.push({ imageSize, type: 'separator' });
            }
            isFirst = false;
            let imageType = this.model.options.exports.defaultSettings['StiImageExportSettings'].ImageType;
            let imageType_ = imageType === 'Emf' ? 'Metafile' : imageType;
            if (!this.model.options.exports['showExportToImage' + imageType_]) {
                if (this.model.options.exports.showExportToImageBmp) {
                    imageType = 'Bmp';
                }
                else if (this.model.options.exports.showExportToImageGif) {
                    imageType = 'Gif';
                }
                else if (this.model.options.exports.showExportToImageJpeg) {
                    imageType = 'Jpeg';
                }
                else if (this.model.options.exports.showExportToImagePcx) {
                    imageType = 'Pcx';
                }
                else if (this.model.options.exports.showExportToImagePng) {
                    imageType = 'Png';
                }
                else if (this.model.options.exports.showExportToImageTiff) {
                    imageType = 'Tiff';
                }
                else if (this.model.options.exports.showExportToImageMetafile) {
                    imageType = 'Emf';
                }
                else if (this.model.options.exports.showExportToImageSvg) {
                    imageType = 'Svg';
                }
                else if (this.model.options.exports.showExportToImageSvgz) {
                    imageType = 'Svgz';
                }
            }
            items.push({ name: menuName + 'Image' + imageType, caption: this.model.loc('Image'), imageSize, img: this.getImage('Image') });
        }
        return items;
    }
    enabled(desc) {
        const disableNaviButtons = this.disableNaviButtons();
        switch (desc.action) {
            case 'FirstPage':
            case 'PrevPage':
                return this.model.reportParams.pageNumber > 0 && !disableNaviButtons;
            case 'NextPage':
            case 'LastPage':
                return this.model.reportParams.pageNumber < this.model.reportParams.pagesCount - 1 && !disableNaviButtons;
            case 'Bookmarks':
                return this.model.reportParams.bookmarksContent != null;
            case 'Parameters':
                return this.model.interactions?.paramsVariables != null;
            case 'Resources':
                return this.model.reportParams.resources?.length > 0;
        }
        return true;
    }
    selected(desc) {
        switch (desc.action) {
            case 'Find':
                return this.model.controls.findPanel.visible;
            case 'Bookmarks':
                return this.model.controls.bookmarksPanel.visible;
            case 'Parameters':
                return this.model.controls.parametersPanel.visible;
            case 'Editor':
                return this.editableFieldsService.visible;
            case 'Resources':
                return this.model.controls.resourcesPanel.visible;
            case 'FullScreen':
                return this.model.options.appearance.fullScreenMode;
            case 'Pin':
                return !this.model.options.toolbar.autoHide;
        }
        return false;
    }
    display(desc) {
        switch (desc.action) {
            case 'Editor':
                return this.model.reportParams.isEditableReport ? '' : 'none';
        }
        return '';
    }
    getButonWidth(comp) {
        if (this.model.options.toolbar.displayMode === 'Separated') {
            if (comp.action === 'Find' || comp.action === 'Editor' || comp.action === 'FullScreen' || comp.action === 'About') {
                return '28px';
            }
            if (this.model.options.isMobileDevice) {
                return '0.4in';
            }
        }
        return null;
    }
    getInnerTableWidth(comp) {
        if (this.model.options.toolbar.displayMode === 'Separated' &&
            (this.model.options.isMobileDevice || comp.action === 'Find' || comp.action === 'Editor' || comp.action === 'FullScreen' || comp.action === 'About')) {
            return '100%';
        }
        return null;
    }
}
ToolbarService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarService, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.EditableFieldsService }, { token: i4.InteractionsService }, { token: i5.HelperService }], target: i0.ɵɵFactoryTarget.Injectable });
ToolbarService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.EditableFieldsService }, { type: i4.InteractionsService }, { type: i5.HelperService }]; } });
//# sourceMappingURL=data:application/json;base64,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