import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StylesService {
    constructor(model) {
        this.model = model;
        this.pagesCss = {};
    }
    setupStyle(style, id) {
        if (this.pagesCss[id] == null) {
            this.pagesCss[id] = document.createElement('STYLE');
            this.pagesCss[id].id = this.model.options?.viewerId + 'Styles';
            this.pagesCss[id].setAttribute('type', 'text/css');
            this.model.controls.head.appendChild(this.pagesCss[id]);
        }
        if (this.pagesCss[id].styleSheet) {
            this.pagesCss[id].styleSheet.cssText = style;
        }
        else {
            this.pagesCss[id].innerHTML = style;
        }
    }
    addCustomFontStyles(customFonts) {
        if (!customFonts) {
            return;
        }
        let existsStyles = [];
        try {
            existsStyles = document.getElementsByTagName('head')[0].getElementsByTagName('style');
        }
        catch (e) { }
        customFonts.forEach((customFont) => {
            if (customFont.contentForCss && customFont.originalFontFamily) {
                const style = document.createElement('style');
                style.innerHTML = `@font-face {\r\nfont-family: '${customFont.originalFontFamily}';\r\n src: url(${customFont.contentForCss});\r\n }`;
                let existsThisStyle = false;
                for (const estyle of existsStyles) {
                    if (estyle.innerHTML.indexOf(`font-family: '${customFont.originalFontFamily}'`) > 0) {
                        existsThisStyle = true;
                        break;
                    }
                }
                if (!existsThisStyle) {
                    document.getElementsByTagName('head')[0].appendChild(style);
                }
            }
        });
    }
    addChartScript(script) {
        const currChartScripts = document.getElementById(this.model.options.viewerId + 'chartScriptJsViewer');
        if (currChartScripts) {
            this.model.controls.head.removeChild(currChartScripts);
        }
        if (script) {
            const chartScripts = document.createElement('Script');
            chartScripts.setAttribute('type', 'text/javascript');
            chartScripts.id = this.model.options.viewerId + 'chartScriptJsViewer';
            chartScripts.textContent = script;
            this.model.controls.head.appendChild(chartScripts);
        }
    }
}
StylesService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StylesService, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StylesService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StylesService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StylesService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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