import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./export.service";
import * as i3 from "./helper.service";
import * as i4 from "./http-client.service";
import * as i5 from "./controller.service";
export class PrintService {
    constructor(model, exportService, helper, httpClient, controller) {
        this.model = model;
        this.exportService = exportService;
        this.helper = helper;
        this.httpClient = httpClient;
        this.controller = controller;
        controller.getActionMessage().subscribe((message) => {
            if (message.action === 'Print') {
                this.postPrint(message.data.format);
            }
        });
        controller.getMessage().subscribe((message) => {
            if (message.action === 'PrintReport') {
                switch (message.subAction) {
                    case 'PrintWithPreview':
                        this.printAsPopup(message.data);
                        break;
                    case 'PrintWithoutPreview':
                        this.printAsHtml(message.data);
                        break;
                }
            }
        });
    }
    postPrint(printAction) {
        if (printAction === 'PrintPdf' && /iPhone|iPad|iPod|Macintosh/i.test(navigator.userAgent) && this.helper.isTouchDevice()) {
            const settings = this.exportService.getDefaultExportSettings('Pdf');
            settings.OpenAfterExport = true;
            this.postExport('Pdf', settings);
            return;
        }
        const data = {
            action: 'PrintReport',
            printAction,
            bookmarksPrint: this.model.options.appearance.bookmarksPrint
        };
        const url = ''; // this.model.options.requestUrl.replace('{action}', this.model.options.actions.printReport);
        switch (printAction) {
            case 'PrintPdf':
                if (this.model.options.appearance.printToPdfMode === 'Popup' || this.helper.getNavigatorName() == 'Safari' || this.helper.getNavigatorName() == 'iPad') {
                    this.printAsPdfPopup(data);
                }
                else {
                    this.printAsPdf(url, data);
                }
                break;
            default:
                this.controller.post('PrintReport', this.model.options.actions.printReport, data, 'text', printAction);
                break;
        }
    }
    postExport(format, settings, elementName, isDashboardExport) {
        const data = {
            action: isDashboardExport ? 'ExportDashboard' : 'ExportReport',
            exportFormat: format,
            exportSettings: settings,
            elementName
        };
        const doc = settings && settings.OpenAfterExport && this.model.options.appearance.openExportedReportWindow === '_blank' ? this.helper.openNewWindow('about:blank', '_blank').document : null;
        const url = this.model.requestUrl;
        this.httpClient.postForm(url.replace('{action}', this.model.options.actions.exportReport), data, doc);
    }
    printAsPdfPopup(data) {
        const url = this.model.requestUrl.replace('{action}', this.model.options.actions.printReport);
        const win = this.helper.openNewWindow('about:blank', '_blank');
        if (win != null) {
            this.httpClient.postForm(url, data, win.document);
        }
    }
    printAsPdf(url, data) {
        data.responseType = 'blob';
        const viewer = this.model.controls.viewer.el.nativeElement;
        const printFrameId = this.model.options.viewerId + '_PdfPrintFrame';
        let printFrame = document.getElementById(printFrameId);
        if (printFrame) {
            viewer.removeChild(printFrame);
        }
        printFrame = document.createElement('iframe');
        printFrame.id = printFrameId;
        printFrame.name = printFrameId;
        printFrame.width = '0';
        printFrame.height = '0';
        printFrame.style.position = 'absolute';
        printFrame.style.border = 'none';
        // Firefox does not load the invisible content of the iframe
        if (this.helper.getNavigatorName() === 'Mozilla') {
            printFrame.width = '100px';
            printFrame.height = '100px';
            printFrame.style.visibility = 'hidden';
            printFrame.style.zIndex = '-100';
            printFrame.style.pointerEvents = 'none';
        }
        viewer.insertBefore(printFrame, viewer.firstChild);
        // Manual printing in browsers that do not support automatic PDF printing
        if (this.helper.getNavigatorName() !== 'Mozilla') {
            printFrame.onload = () => {
                printFrame.contentWindow.focus();
                printFrame.contentWindow.print();
            };
        }
        const form = document.createElement('FORM');
        form.setAttribute('id', 'printForm');
        form.setAttribute('method', 'POST');
        form.setAttribute('action', this.model.requestUrl.replace('{action}', this.model.options.actions.printReport));
        form.setAttribute('target', this.model.options.viewerId + '_PdfPrintFrame');
        const params = this.model.createPostParameters(data, true);
        Object.keys(params).forEach(key => {
            const paramsField = document.createElement('INPUT');
            paramsField.setAttribute('type', 'hidden');
            paramsField.setAttribute('name', key);
            paramsField.setAttribute('value', params[key]);
            form.appendChild(paramsField);
        });
        document.body.appendChild(form);
        form.submit();
        document.body.removeChild(form);
    }
    printAsPopup(text) {
        const width = this.model.reportParams.pagesWidth || 790;
        const win = this.helper.openNewWindow('about:blank', 'PrintReport', 'height=900,width=' + width + ',toolbar=no,menubar=yes,scrollbars=yes,resizable=yes,location=no,directories=no,status=no');
        if (win != null) {
            win.document.open();
            win.document.write(text);
            win.document.close();
        }
    }
    printAsHtml(text) {
        if (this.controller.showError(text)) {
            return;
        }
        const viewer = this.model.controls.viewer.el.nativeElement;
        // Remove '_PdfPrintFrame', this should fix IE strange error
        let printFrameId = this.model.options.viewerId + '_PdfPrintFrame';
        let printFrame = document.getElementById(printFrameId);
        if (printFrame) {
            viewer.removeChild(printFrame);
        }
        printFrameId = this.model.options.viewerId + '_HtmlPrintFrame';
        printFrame = document.getElementById(printFrameId);
        if (printFrame) {
            viewer.removeChild(printFrame);
        }
        printFrame = document.createElement('iframe');
        printFrame.id = printFrameId;
        printFrame.name = printFrameId;
        printFrame.width = '0';
        printFrame.height = '0';
        printFrame.style.position = 'absolute';
        printFrame.style.border = 'none';
        viewer.insertBefore(printFrame, viewer.firstChild);
        printFrame.contentWindow.document.open();
        printFrame.contentWindow.document.write(text);
        printFrame.contentWindow.document.close();
        setTimeout(() => {
            printFrame.contentWindow.focus();
            printFrame.contentWindow.print();
        });
    }
}
PrintService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PrintService, deps: [{ token: i1.ModelService }, { token: i2.ExportService }, { token: i3.HelperService }, { token: i4.StiHttpClientService }, { token: i5.ControllerService }], target: i0.ɵɵFactoryTarget.Injectable });
PrintService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PrintService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PrintService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ExportService }, { type: i3.HelperService }, { type: i4.StiHttpClientService }, { type: i5.ControllerService }]; } });
//# sourceMappingURL=data:application/json;base64,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