import { Subject } from 'rxjs';
export class ComponentDescription {
    constructor(type, caption, img, action, tooltip, arrow, menuItems, margin, selected) {
        this.type = type;
        this.caption = caption;
        this.img = img;
        this.action = action;
        this.tooltip = tooltip;
        this.arrow = arrow;
        this.menuItems = menuItems;
        this.margin = margin;
        this.selected = selected;
        this.selected = false;
    }
}
export class ViewerEvent {
    constructor(name, value, bookmarkPage, bookmarkAnchor, componentGuid) {
        this.name = name;
        this.value = value;
        this.bookmarkPage = bookmarkPage;
        this.bookmarkAnchor = bookmarkAnchor;
        this.componentGuid = componentGuid;
    }
}
export class ControlClass {
    constructor() {
        this.toolbar = new ControlProps();
        this.reportPanel = new ControlProps();
        this.drillDownPanel = new ControlProps();
        this.findPanel = new ControlProps();
        this.resourcesPanel = new ControlProps();
        this.bookmarksPanel = new ControlProps();
        this.navigatePanel = new ControlProps();
        this.parametersPanel = new ControlProps();
        this.dashboardsPanel = new ControlProps();
        this.viewer = new ControlProps();
        this.tooltip = new ControlProps();
        this.aboutPanel = new ControlProps();
    }
    get head() {
        return document.getElementsByTagName('head')[0];
    }
}
export class ControlProps {
    constructor(pageService, el) {
        this.pageService = pageService;
        this.el = el;
        this._visible = false;
        this.subject = new Subject();
        this.enabled = true;
        this.layout = new Rectangle();
    }
    get offsetHeight() {
        return this.el?.nativeElement.offsetHeight || 0;
    }
    get offsetWidth() {
        return this.el?.nativeElement.offsetWidth || 0;
    }
    set visible(value) {
        this._visible = value;
        this.subject.next(value);
        this.pageService?.calculateLayout();
    }
    get visible() {
        return this._visible;
    }
    getVisibility() {
        return this.subject.asObservable();
    }
    get exists() {
        return this.el != null;
    }
}
export class Rectangle {
    constructor(width = 0, height = 0, left = 0, bottom = 0, right = 0) {
        this.width = width;
        this.height = height;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this._top = 0;
    }
    set top(value) {
        this._top = value;
    }
    get top() {
        return this._top;
    }
}
export class BookmarkNode {
    constructor(name, url, page, compunentGuid, nodes, open, selected) {
        this.name = name;
        this.url = url;
        this.page = page;
        this.compunentGuid = compunentGuid;
        this.nodes = nodes;
        this.open = open;
        this.selected = selected;
    }
}
export class InteractionParams {
    constructor(action, drillDownParameters, drillDownGuid, dashboardDrillDownGuid, variables, sortingParameters, collapsingParameters, isBindingVariable) {
        this.action = action;
        this.drillDownParameters = drillDownParameters;
        this.drillDownGuid = drillDownGuid;
        this.dashboardDrillDownGuid = dashboardDrillDownGuid;
        this.variables = variables;
        this.sortingParameters = sortingParameters;
        this.collapsingParameters = collapsingParameters;
        this.isBindingVariable = isBindingVariable;
    }
}
export class InteractionObject {
    constructor(paramsVariables, countColumns, countInColumn) {
        this.paramsVariables = paramsVariables;
        this.countColumns = countColumns;
        this.countInColumn = countInColumn;
    }
}
export class Variable {
    constructor(name, alias, description, basicType, type, allowUserValues, dateTimeType, items, key, value, keyTo, isChecked = true, focusOnCreate, visible = true, binding, isNull, isFirstInitialization, checkedStates, isChanged, allowNullableString) {
        this.name = name;
        this.alias = alias;
        this.description = description;
        this.basicType = basicType;
        this.type = type;
        this.allowUserValues = allowUserValues;
        this.dateTimeType = dateTimeType;
        this.items = items;
        this.key = key;
        this.value = value;
        this.keyTo = keyTo;
        this.isChecked = isChecked;
        this.focusOnCreate = focusOnCreate;
        this.visible = visible;
        this.binding = binding;
        this.isNull = isNull;
        this.isFirstInitialization = isFirstInitialization;
        this.checkedStates = checkedStates;
        this.isChanged = isChanged;
        this.allowNullableString = allowNullableString;
    }
}
export class DateTimeObject {
    constructor(year, month, day, hours, minutes, seconds) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }
}
export class Item {
    constructor(name, caption, imageName, key, haveSubMenu, imageSizes, selected, type) {
        this.name = name;
        this.caption = caption;
        this.imageName = imageName;
        this.key = key;
        this.haveSubMenu = haveSubMenu;
        this.imageSizes = imageSizes;
        this.selected = selected;
        this.type = type;
    }
}
export class Message {
    constructor(action, data, subAction) {
        this.action = action;
        this.data = data;
        this.subAction = subAction;
    }
}
export class Form {
    constructor(name, left, top, isMooving = false, level, formData) {
        this.name = name;
        this.left = left;
        this.top = top;
        this.isMooving = isMooving;
        this.level = level;
        this.formData = formData;
    }
}
export class ExportFormSettings {
    constructor(components, cSettings, openAfterExport, groups, update) {
        this.components = components;
        this.cSettings = cSettings;
        this.openAfterExport = openAfterExport;
        this.groups = groups;
        this.update = update;
    }
}
export class ExportGroup {
    constructor(opened) {
        this.opened = opened;
    }
}
export class ExportComponent {
    constructor(name, type, margin, label, tooltip, caption, checked, width, disabled, items, key) {
        this.name = name;
        this.type = type;
        this.margin = margin;
        this.label = label;
        this.tooltip = tooltip;
        this.caption = caption;
        this.checked = checked;
        this.width = width;
        this.disabled = disabled;
        this.items = items;
        this.key = key;
    }
}
export class DrillDown {
    constructor(caption, selected = false, reportParams, visible) {
        this.caption = caption;
        this.selected = selected;
        this.reportParams = reportParams;
        this.visible = visible;
    }
}
export class ErrorMessage {
    constructor(error, type) {
        this.error = error;
        this.type = type;
    }
}
export class Resource {
    constructor(name, type, alias, id) {
        this.name = name;
        this.type = type;
        this.alias = alias;
        this.id = id;
    }
}
export class NotificationFormOptions {
    constructor(image, message, description, buttonCaption, cancelAction, action) {
        this.image = image;
        this.message = message;
        this.description = description;
        this.buttonCaption = buttonCaption;
        this.cancelAction = cancelAction;
        this.action = action;
    }
}
//# sourceMappingURL=data:application/json;base64,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