import { Injectable } from '@angular/core';
import { ControlClass } from './objects';
import * as i0 from "@angular/core";
export class ModelService {
    constructor() {
        this._reportParams = {};
        this.controls = new ControlClass();
        this.pages = [];
        this.months = [];
        this.dayOfWeek = [];
        this.dateRanges = [];
        this.encodingData = [];
        this.pdfSecurityCertificates = [];
        this.paperSizes = [];
        this.drillDownButtons = [];
        this.showProgress = false;
    }
    get reportParams() {
        return this._reportParams;
    }
    set reportParams(parameters) {
        this._reportParams.pagesArray = parameters.pagesArray;
        // Apply new report parameters, if not update current page
        if (parameters.action && parameters.action !== 'GetPages') {
            this.reportParams.type = parameters.reportType;
            this.reportParams.drillDownGuid = parameters.drillDownGuid;
            this.reportParams.dashboardDrillDownGuid = parameters.dashboardDrillDownGuid;
            this.reportParams.pagesCount = parameters.pagesCount;
            if (parameters.pageNumber != null) {
                this.reportParams.pageNumber = parameters.pageNumber;
            }
            this.reportParams.zoom = parameters.zoom;
            this.reportParams.viewMode = parameters.viewMode;
            this.reportParams.reportFileName = parameters.reportFileName;
            this.reportParams.collapsingStates = parameters.collapsingStates;
            if (parameters.bookmarksContent) {
                this.reportParams.bookmarksContent = parameters.bookmarksContent;
            }
            if (parameters.resources) {
                this.reportParams.resources = parameters.resources;
            }
            this.reportParams.isCompilationMode = parameters.isCompilationMode;
            if (parameters.variablesValues) {
                this.reportParams.variablesValues = parameters.variablesValues;
            }
            if (parameters.parametersDateFormat) {
                this.options.appearance.parametersPanelDateFormat = parameters.parametersDateFormat;
            }
            if (parameters.tableOfContentsPointers)
                this.reportParams.tableOfContentsPointers = parameters.tableOfContentsPointers;
            this.reportParams.isEditableReport = parameters.isEditableReport;
            if (parameters.userValues) {
                this.options.userValues = parameters.userValues;
            }
            this.reportParams.dashboards = parameters.dashboards;
            this.reportParams.previewSettings = parameters.previewSettings;
        }
    }
    setReportParams(parameters) {
        this._reportParams = parameters;
    }
    getReportParams() {
        return this.copyObject(this._reportParams);
    }
    copyObject(o) {
        if (!o || 'object' !== typeof o) {
            return o;
        }
        const c = 'function' === typeof o.pop ? [] : {};
        let p;
        let v;
        for (p in o) {
            if (o.hasOwnProperty(p) && p !== 'pagesArray') {
                v = o[p];
                if (v && 'object' === typeof v) {
                    c[p] = this.copyObject(v);
                }
                else {
                    c[p] = v;
                }
            }
        }
        return c;
    }
    set options(data) {
        this._options = this.toLower(data.options);
        if (data.jsOptions) {
            for (const key in data.jsOptions) {
                if (data.jsOptions.hasOwnProperty(key)) {
                    this._options[key] = data.jsOptions[key];
                }
            }
        }
        this._options.exports.defaultSettings = data.defaultSettings;
        this.localization = data.loc;
        this.months = data.months;
        this.dayOfWeek = data.dayOfWeek;
        this.images = data.images;
        this.dateRanges = data.dateRanges;
        this.paperSizes = data.paperSizes;
        this.encodingData = data.encodingData;
        this.pdfSecurityCertificates = data.pdfSecurityCertificates;
        this.clearViewerState();
        this.setupOptions();
    }
    get options() {
        return this._options;
    }
    loc(attr) {
        return this.localization[attr] ?? attr;
    }
    img(name) {
        if (name != null && name.length > 0 && !this.images[name]) {
            //console.warn(`Image: ${name} not found`);
        }
        return this.images[name] ?? '';
    }
    toLower(obj) {
        const result = {};
        Object.keys(obj).forEach(key => {
            result[key.substr(0, 1).toLowerCase() + key.substr(1)] = (typeof (obj[key]) === 'object' && obj[key] !== null) ? this.toLower(obj[key]) : obj[key];
        });
        return result;
    }
    clear() {
        this._options = undefined;
        this._reportParams = {};
        this._imagesForBookmark = undefined;
        this.pages = [];
        this.form = null;
    }
    clearViewerState() {
        this.reportParams = {};
        this.reportParams.type = 'Auto';
        this.reportParams.pageNumber = 0;
        this.reportParams.originalPageNumber = 0;
        this.reportParams.drillDownGuid = null;
        this.reportParams.dashboardDrillDownGuid = null;
        this.reportParams.collapsingStates = null;
        this.reportParams.bookmarksContent = null;
        this.reportParams.editableParameters = null;
        this.reportParams.resources = null;
        this.reportParams.drillDownParameters = [];
        this.reportParams.elementName = null;
        this.reportParams.variablesValues = null;
        this.reportParams.tableOfContentsPointers = [];
        this.reportParams.isEditableReport = false;
        //this.options.viewerId = this.newToken();
        this.options.clientGuid = this.newToken();
        this.options.paramsVariables = null;
        this.options.multiFilterStates = null;
        this.options.isParametersReceived = false;
        this.options.drillDownInProgress = false;
        this.options.displayModeFromReport = null;
        // this.controls.mainPanel.style.background = '';
        // this.tableElementGridStates = {};
        // Restore current page number, if reload current report
        if (this.reportParams.prevPageNumber) {
            this.reportParams.pageNumber = this.reportParams.prevPageNumber;
            delete this.reportParams.prevPageNumber;
        }
        this.fullScreenOptions = null;
        this.drillDownButtons = [];
        this.controls.parametersPanel.visible = false;
        this.controls.bookmarksPanel.visible = false;
        this.interactions = null;
        /*
        this.controls.drillDownPanel.visible = false;
        this.controls.findPanel.visible = false;
        this.controls.parametersPanel.visible = false;
        this.controls.resourcesPanel.visible = false;*/
    }
    style(value) {
        return value !== '' && value != null ? value : '';
    }
    createPostParameters(data, asObject = true, useOptions = true) {
        let params;
        // Object params
        const postParams = {
            stiweb_component: 'Viewer',
            stiweb_imagesScalingFactor: this.getImagesScalingFactor()
        };
        if (this.properties) {
            postParams['properties'] = this.encode(JSON.stringify(this.properties));
        }
        if (this.options && useOptions) {
            params = {
                viewerId: this.options.viewerId,
                routes: this.options.routes,
                formValues: this.options.formValues,
                clientGuid: this.options.clientGuid,
                drillDownGuid: this.reportParams.drillDownGuid,
                dashboardDrillDownGuid: this.reportParams.dashboardDrillDownGuid,
                cacheMode: this.options.server.cacheMode,
                cacheTimeout: this.options.server.cacheTimeout,
                cacheItemPriority: this.options.server.cacheItemPriority,
                pageNumber: this.reportParams.pageNumber,
                originalPageNumber: this.reportParams.originalPageNumber,
                reportType: this.reportParams.type,
                zoom: (this.reportParams.zoom && this.reportParams.zoom > 0) ? this.reportParams.zoom : (this.options?.toolbar?.zoom > 0 ? this.options?.toolbar?.zoom : 100),
                viewMode: this.reportParams.viewMode || this.options.toolbar.viewMode,
                multiPageWidthCount: this.reportParams.multiPageWidthCount,
                multiPageHeightCount: this.reportParams.multiPageHeightCount,
                multiPageContainerWidth: this.reportParams.multiPageContainerWidth,
                multiPageContainerHeight: this.reportParams.multiPageContainerHeight,
                multiPageMargins: this.reportParams.multiPageMargins,
                showBookmarks: this.options.toolbar.showBookmarksButton,
                openLinksWindow: this.options.appearance.openLinksWindow,
                chartRenderType: this.options.appearance.chartRenderType,
                reportDisplayMode: (this.options.displayModeFromReport || this.options.appearance.reportDisplayMode),
                drillDownParameters: this.reportParams.drillDownParameters,
                editableParameters: this.reportParams.editableParameters,
                useRelativeUrls: this.options.server.useRelativeUrls,
                passQueryParametersForResources: this.options.server.passQueryParametersForResources,
                passQueryParametersToReport: this.options.server.passQueryParametersToReport,
                version: this.options.shortProductVersion,
                reportDesignerMode: this.options.reportDesignerMode,
                imagesQuality: this.options.appearance.imagesQuality,
                parametersPanelSortDataItems: this.options.appearance.parametersPanelSortDataItems,
                combineReportPages: this.options.appearance.combineReportPages,
                isAngular: true,
                allowAutoUpdateCookies: this.options.server.allowAutoUpdateCookies
            };
            if (this.options.server.useLocalizedCache && this.options.localization) {
                params['useLocalizedCache'] = true;
                params['localization'] = this.options.localization;
            }
            if (this.options.userValues) {
                params['userValues'] = this.options.userValues;
            }
        }
        else {
            params = {};
        }
        if (data) {
            Object.keys(data).forEach(key => params[key] = data[key]);
        }
        // Object params
        if (params.action) {
            postParams['stiweb_action'] = params.action;
            delete params.action;
        }
        if (params.base64Data) {
            postParams['stiweb_data'] = params.base64Data;
            delete params.base64Data;
        }
        if (this.options && useOptions) {
            // Params
            const jsonParams = JSON.stringify(params);
            if (this.options.server.useCompression) {
                // postParams['stiweb_packed_parameters'] = StiGZipHelper.pack(jsonParams);
                postParams['stiweb_parameters'] = this.encode(jsonParams);
            }
            else {
                postParams['stiweb_parameters'] = this.encode(jsonParams);
            }
        }
        if (this.postParametersFunction) {
            let postParamsF = this.postParametersFunction(data);
            if (postParamsF) {
                Object.keys(postParamsF).forEach(key => postParams[key] = postParamsF[key]);
            }
        }
        if (asObject) {
            return postParams;
        }
    }
    newToken() {
        const a = '1234567890abcdefghijklmnopqrstuvwxyz'.split('');
        const b = [];
        const length = 32;
        b[0] = "s";
        for (let i = 1; i < length; i++) {
            const j = (Math.random() * (a.length - 1)).toFixed(0);
            b[i] = a[j];
        }
        return b.join('');
    }
    setupOptions() {
        if (!this.options.exports.showExportToPowerPoint && !this.options.exports.showExportToPdf && !this.options.exports.showExportToXps &&
            !this.options.exports.showExportToOpenDocumentWriter && !this.options.exports.showExportToOpenDocumentCalc && !this.options.exports.showExportToText &&
            !this.options.exports.showExportToRtf && !this.options.exports.showExportToWord2007 && !this.options.exports.showExportToCsv && !this.options.exports.showExportToJson &&
            !this.options.exports.showExportToDbf && !this.options.exports.showExportToXml && !this.options.exports.showExportToDif && !this.options.exports.showExportToSylk &&
            !this.options.exports.showExportToExcel && !this.options.exports.showExportToExcel2007 && !this.options.exports.showExportToExcelXml && !this.options.exports.showExportToHtml &&
            !this.options.exports.showExportToHtml5 && !this.options.exports.showExportToMht && !this.options.exports.showExportToImageBmp && !this.options.exports.showExportToImageGif &&
            !this.options.exports.showExportToImageJpeg && !this.options.exports.showExportToImageMetafile && !this.options.exports.showExportToImagePcx &&
            !this.options.exports.showExportToImagePng && !this.options.exports.showExportToImageTiff && !this.options.exports.showExportToImageSvg && !this.options.exports.showExportToImageSvgz) {
            if (!this.options.exports.showExportToDocument) {
                this.options.toolbar.showSaveButton = false;
            }
            this.options.toolbar.showSendEmailButton = false;
        }
        // Options
        this.options.isTouchDevice = this.options.appearance.interfaceType === 'Auto'
            ? this.isTouchDevice() && this.isMobileDevice()
            : this.options.appearance.interfaceType === 'Touch';
        this.options.isMobileDevice = this.options.appearance.interfaceType === 'Auto' && !this.options.reportDesignerMode
            ? this.isTouchDevice() && this.isMobileDevice()
            : this.options.appearance.interfaceType === 'Mobile';
        if (this.options.isMobileDevice) {
            this.initializeMobile();
        }
        else {
            this.options.toolbar.showPinToolbarButton = false;
        }
        this.controls.toolbar.visible = this.options.toolbar.visible;
        this.options.menuAnimDuration = 150;
        this.options.formAnimDuration = 200;
        this.options.scrollDuration = 350;
        this.options.menuHideDelay = 250;
        this.options.server.timeoutAutoUpdateCache = 180000;
        this.options.toolbar.backgroundColor = this.getHTMLColor(this.options.toolbar.backgroundColor);
        this.options.toolbar.borderColor = this.getHTMLColor(this.options.toolbar.borderColor);
        this.options.toolbar.fontColor = this.getHTMLColor(this.options.toolbar.fontColor);
        this.options.appearance.pageBorderColor = this.getHTMLColor(this.options.appearance.pageBorderColor);
        this.options.parametersValues = {};
        this.options.parameterRowHeight = this.options.isTouchDevice ? 35 : 30;
        this.options.minParametersCountForMultiColumns = 5;
        // First Day Of Week
        if (this.options.appearance.datePickerFirstDayOfWeek === 'Sunday') {
            this.dayOfWeek.splice(6, 1);
            this.dayOfWeek.splice(0, 0, 'Sunday');
        }
        if (this.options?.toolbar?.zoom === -1 || this.options?.toolbar?.zoom === -2) {
            this.reportParams.autoZoom = this.options?.toolbar?.zoom;
        }
        // Actions
        if (!this.options.actions.getReport) {
            this.options.actions.getReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.printReport) {
            this.options.actions.printReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.openReport) {
            this.options.actions.openReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.exportReport) {
            this.options.actions.exportReport = this.options.actions.viewerEvent;
        }
        if (!this.options.actions.interaction) {
            this.options.actions.interaction = this.options.actions.viewerEvent;
        }
        if (!(window.File && window.FileReader && window.FileList && window.Blob)) {
            this.options.toolbar.showOpenButton = false;
        }
        // Render JsViewer styles into HEAD
        if (this.options.requestResourcesUrl || this.options.appearance.customStylesUrl) {
            const viewerStyles = document.createElement('link');
            viewerStyles.setAttribute('type', 'text/css');
            viewerStyles.setAttribute('rel', 'stylesheet');
            viewerStyles.setAttribute('href', this.options.appearance.customStylesUrl || this.getResourceUrl('styles'));
            this.controls.head.appendChild(viewerStyles);
        }
        this.options.viewerId = this.options.viewerId || this.newToken();
    }
    pagesNavigationIsActive() {
        return (this.options.appearance.fullScreenMode || this.options.appearance.scrollbarsMode) && this.reportParams.viewMode === 'Continuous';
    }
    get imagesForBookmark() {
        if (!this._imagesForBookmark) {
            const names = ['root', 'folder', 'folderOpen', 'node', 'empty', 'line', 'join', 'joinBottom', 'plus', 'plusBottom', 'minus', 'minusBottom'];
            const imagesForBookmarks = {};
            names.forEach(name => imagesForBookmarks[name] = this.images['Bookmarks' + name + '.png']);
            this._imagesForBookmark = imagesForBookmarks;
        }
        return this._imagesForBookmark;
    }
    isTouchDevice() {
        return ('ontouchstart' in document.documentElement);
    }
    isMobileDevice() {
        return /iPhone|iPad|iPod|Macintosh|Android|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    }
    initializeMobile() {
        let isViewPortExist = false;
        const metas = this.controls.head.getElementsByTagName('meta');
        for (const meta of metas) {
            if (meta.name && meta.name.toLowerCase() === 'viewport') {
                isViewPortExist = true;
                break;
            }
        }
        if (!isViewPortExist) {
            const viewPortTag = document.createElement('meta');
            viewPortTag.id = 'viewport';
            viewPortTag.name = 'viewport';
            viewPortTag.content = 'initial-scale=1.0,width=device-width,user-scalable=0';
            this.controls.head.appendChild(viewPortTag);
        }
        this.options.appearance.fullScreenMode = true;
        this.options.appearance.scrollbarsMode = true;
        this.options.appearance.parametersPanelPosition = 'Left';
        this.options.appearance.parametersPanelColumnsCount = 1;
        this.options.toolbar.displayMode = 'Separated';
        this.options.toolbar.viewMode = 'SinglePage';
        this.options.toolbar.showZoomButton = false;
        const defaultZoom = this.options.toolbar.zoom === -2 ? -2 : -1; // PageWidth or PageHeight
        this.options.toolbar.zoom = this.reportParams.zoom = defaultZoom;
        this.options.toolbar.showButtonCaptions = false;
        this.options.toolbar.showOpenButton = false;
        this.options.toolbar.showFindButton = false;
        this.options.toolbar.showEditorButton = false;
        this.options.toolbar.showFullScreenButton = false;
        this.options.toolbar.showAboutButton = false;
        this.options.toolbar.showViewModeButton = false;
    }
    getImagesScalingFactor() {
        const wnd = window;
        const devicePixelRatio = window.devicePixelRatio || (wnd.deviceXDPI && wnd.logicalXDPI ? wnd.deviceXDPI / wnd.logicalXDPI : 1);
        if (!devicePixelRatio || devicePixelRatio <= 1) {
            return '1';
        }
        else {
            return devicePixelRatio.toString();
        }
    }
    getHTMLColor(color) {
        if (color.indexOf(',') > 0 && color.indexOf('rgb') < 0) {
            return `rgb(${color})`;
        }
        return color;
    }
    getResourceUrl(resourceParameter) {
        let url = this.getActionRequestUrl(this.options.requestResourcesUrl, this.options.actions.viewerEvent);
        url += url.indexOf('?') > 0 ? '&' : '?';
        url += 'stiweb_component=Viewer&stiweb_action=Resource&stiweb_data=' + resourceParameter + '&stiweb_theme=' + this.options.theme;
        url += '&stiweb_cachemode=' + (this.options.server.useCacheForResources
            ? this.options.server.cacheMode === 'ObjectSession' || this.options.server.cacheMode === 'StringSession'
                ? 'session'
                : 'cache'
            : 'none');
        url += '&stiweb_version=' + this.options.shortProductVersion;
        return url;
    }
    getActionRequestUrl(requestUrl, action) {
        if (!action) {
            return requestUrl;
        }
        if (action.indexOf('?') < 0) {
            return requestUrl.replace('{action}', action);
        }
        const query = action.substring(action.indexOf('?') + 1);
        action = action.substring(0, action.indexOf('?'));
        return requestUrl.replace('{action}', action) + (requestUrl.indexOf('?') > 0 ? '&' : '?') + query;
    }
    encode(input) {
        // Decode from UTF-8 text
        if (typeof unescape != 'undefined') {
            input = unescape(encodeURIComponent(input));
        }
        else {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if ((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            input = utftext;
        }
        // Encode to Base64 string
        if (typeof window.btoa != 'undefined')
            return window.btoa(input);
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2))
                enc3 = enc4 = 64;
            else if (isNaN(chr3))
                enc4 = 64;
            output = output +
                this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
                this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
        }
        return output;
    }
    decode(input) {
        var output = "";
        // Decode from Base64 string
        if (typeof window.atob != 'undefined') {
            output = window.atob(input);
        }
        else {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
        }
        // Encode to UTF-8 string
        if (typeof escape != 'undefined')
            return decodeURIComponent(escape(output));
        var string = "";
        var i = 0;
        var c = 0;
        var c1 = 0;
        var c2 = 0;
        var c3 = 0;
        while (i < output.length) {
            c = output.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = output.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = output.charCodeAt(i + 1);
                c3 = output.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
}
ModelService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ModelService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
ModelService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ModelService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ModelService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });
//# sourceMappingURL=data:application/json;base64,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