import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./export.service";
import * as i3 from "../forms/form.service";
import * as i4 from "./controller.service";
export class MailService {
    constructor(model, exportService, formService, controller) {
        this.model = model;
        this.exportService = exportService;
        this.formService = formService;
        this.controller = controller;
        exportService.getMessage().subscribe(event => {
            if (event === 'postMail') {
                this.postMail();
            }
        });
    }
    postMail() {
        this.fillDefaults();
        if (this.model.options.email.showEmailDialog) {
            this.formService.showForm('sendEmailForm');
        }
        else {
            this.sendMail();
        }
    }
    sendMail() {
        const data = {
            exportFormat: this.exportService.format,
            exportSettings: this.exportService.exportSettings
        };
        this.formService.closeForm('sendEmailForm');
        this.controller.post('EmailReport', this.model.options.actions.emailReport, data);
        this.controller.actionSubject.next({ action: 'Email', data });
    }
    fillDefaults() {
        this.exportService.exportSettings.Email = this.model.options.email.defaultEmailAddress;
        this.exportService.exportSettings.Message = this.model.options.email.defaultEmailMessage;
        this.exportService.exportSettings.Subject = this.model.options.email.defaultEmailSubject;
        let ext = this.exportService.format.toLowerCase().replace('image', '');
        switch (ext) {
            case 'excel':
                ext = 'xls';
                break;
            case 'excel2007':
                ext = 'xlsx';
                break;
            case 'excelxml':
                ext = 'xls';
                break;
            case 'html5':
                ext = 'html';
                break;
            case 'jpeg':
                ext = 'jpg';
                break;
            case 'ppt2007':
                ext = 'ppt';
                break;
            case 'text':
                ext = 'txt';
                break;
            case 'word2007':
                ext = 'docx';
                break;
        }
        this.exportService.exportSettings.Attachment = this.model.reportParams.reportFileName + '.' + ext;
    }
}
MailService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MailService, deps: [{ token: i1.ModelService }, { token: i2.ExportService }, { token: i3.FormService }, { token: i4.ControllerService }], target: i0.ɵɵFactoryTarget.Injectable });
MailService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MailService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MailService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ExportService }, { type: i3.FormService }, { type: i4.ControllerService }]; } });
//# sourceMappingURL=data:application/json;base64,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