import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./md5.service";
import * as i3 from "./controller.service";
import * as i4 from "./helper.service";
import * as i5 from "./drill-down.service";
export class InteractionsService {
    constructor(model, md5, controller, helper, drillDownService) {
        this.model = model;
        this.md5 = md5;
        this.controller = controller;
        this.helper = helper;
        this.drillDownService = drillDownService;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'InitVars') {
                this.showParametersPanel(message.data);
            }
        });
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Variables':
                    this.postInteraction({ action: 'Variables', variables: this.getParametersValues() });
                    break;
                case 'Reset':
                    this.showParametersPanel(this.model.options.paramsVariables);
                    break;
                default:
                    break;
            }
        });
    }
    postInteraction(params) {
        this.drillDownService.saveState();
        // Add new drill-down parameters to drill-down queue and calc guid
        if (params.action !== 'InitVars' && (params.action === 'DrillDown' || params.action === 'DashboardDrillDown')) {
            if (this.model.options.drillDownInProgress) {
                return;
            }
            if (params.action === 'DashboardDrillDown' && params.drillDownParameters) {
                params.drillDownParameters.isDashboardDrillDown = true; // add dbs flag
            }
            const drillDownParameters = this.model.reportParams.drillDownParameters || [];
            params.drillDownParameters = params.drillDownParameters ? drillDownParameters.concat(params.drillDownParameters) : drillDownParameters;
            if (params.action === 'DrillDown') {
                params.drillDownGuid = this.md5.hex_md5(JSON.stringify(this.sortPropsInDrillDownParameters(params.drillDownParameters)));
            }
            else {
                params.dashboardDrillDownGuid = this.md5.hex_md5(JSON.stringify(this.sortPropsInDrillDownParameters(params.drillDownParameters)));
            }
            this.model.options.drillDownInProgress = true;
        }
        this.controller.post(params.action, this.model.options.actions.interaction, params);
    }
    showParametersPanel(data) {
        if (!data) {
            return;
        }
        if (this.controller.showError(data)) {
            data = null;
        }
        this.model.options.isParametersReceived = true;
        this.model.options.paramsVariables = typeof data === 'string' ? JSON.parse(data) : data;
        this.model.controls.parametersPanel.visible = !this.model.options.isMobileDevice;
        // if (this.model.reportParams.type === 'Dashboard') jsObject.postAction('GetPages');
        const paramsVariables = this.helper.copyObject(this.model.options.paramsVariables);
        const countParameters = this.helper.getCountObjects(paramsVariables);
        const countColumns = (countParameters <= this.model.options.minParametersCountForMultiColumns)
            ? 1 : this.model.options.appearance.parametersPanelColumnsCount;
        let countInColumn = Math.trunc(countParameters / countColumns);
        if (countInColumn * countColumns < countParameters) {
            countInColumn++;
        }
        // setup lists
        for (let i = 0; i < countParameters; i++) {
            const variable = paramsVariables[i];
            if (variable.items) {
                variable.items.forEach((v, index) => {
                    let isChecked = true;
                    if (variable.value instanceof Array && !variable.allowUserValues &&
                        variable.value.indexOf(variable.items[index].value) < 0 && variable.value.indexOf(variable.items[index].key) < 0)
                        isChecked = false;
                    if (variable.isFirstInitialization && variable.checkedStates && index < variable.checkedStates.length) {
                        isChecked = variable.checkedStates[index];
                    }
                    v.isChecked = isChecked;
                    v.visible = true;
                });
            }
            variable.isNull = (variable.type === 'DateTime' && variable.value === null && variable.basicType === 'NullableValue');
        }
        this.model.interactions = { paramsVariables, countColumns: new Array(countColumns), countInColumn: new Array(countInColumn) };
    }
    sortPropsInDrillDownParameters(inArray) {
        if (!inArray || !inArray.length) {
            return inArray;
        }
        const outArray = [];
        for (let i = 0; i < inArray.length; i++) {
            const propNames = [];
            const el = inArray[i];
            const copyEl = {};
            Object.keys(el).forEach(p => {
                if (el.hasOwnProperty(p)) {
                    propNames.push(p);
                }
            });
            propNames.sort();
            propNames.forEach(propName => copyEl[propName] = el[propName]);
            outArray[i] = copyEl;
        }
        return outArray;
    }
    getParametersValues() {
        const parametersValues = {};
        Object.keys(this.model.interactions.paramsVariables).forEach(i => {
            const parameter = this.model.interactions.paramsVariables[i];
            parametersValues[parameter.name] = this.getVariableValue(parameter);
        });
        return parametersValues;
    }
    getVariableValue(parameter) {
        if (parameter.isNull) {
            return null;
        }
        switch (parameter.basicType) {
            case 'Value':
            case 'NullableValue':
                return this.val(parameter.key, parameter, parameter.allowUserValues ? parameter.value : parameter.key);
            case 'Range':
                return { from: this.val(parameter.key, parameter), to: this.val(parameter.keyTo, parameter) };
            case 'List':
                const value = [];
                if (parameter.items) {
                    parameter.items.filter(i => parameter.allowUserValues || i.isChecked).forEach(item => value.push(this.val(item.key, parameter)));
                }
                return value;
        }
    }
    val(key, parameter, value) {
        return parameter.type === 'DateTime' ? this.helper.getStringDateTime(key, parameter.dateTimeType) : (value === undefined ? key : value);
    }
    initializeInteractions(page) {
        if (!page) {
            return;
        }
        const elems = page.querySelectorAll ? page.querySelectorAll('td,div,span,rect,path,ellipse') : page.getElementsByTagName('td');
        const collapsedHash = [];
        for (const elem of elems) {
            if (elem.getAttribute('interaction') && (elem.getAttribute('pageguid') ||
                elem.getAttribute('reportfile') ||
                elem.getAttribute('collapsed') ||
                elem.getAttribute('databandsort'))) {
                elem.style.cursor = 'pointer';
                const sort = elem.getAttribute('sort');
                if (sort) {
                    this.paintSortingArrow(elem, sort);
                }
                const collapsed = elem.getAttribute('collapsed');
                if (collapsed) {
                    const compId = elem.getAttribute('compindex') + '|' + elem.getAttribute('interaction');
                    if (collapsedHash.indexOf(compId) < 0) {
                        this.paintCollapsingIcon(elem, collapsed === 'true');
                        collapsedHash.push(compId);
                    }
                }
                elem.onclick = (e) => {
                    if (elem.getAttribute('pageguid') || elem.getAttribute('reportfile')) {
                        this.postInteractionDrillDown(elem);
                    }
                    else if (elem.getAttribute('collapsed')) {
                        this.postInteractionCollapsing(elem);
                    }
                    else {
                        this.postInteractionSorting(elem, e.ctrlKey);
                    }
                };
                if (elem.getAttribute('pageguid') || elem.getAttribute('reportfile')) {
                    elem.onmouseover = () => elem.style.opacity = 0.75;
                    elem.onmouseout = () => elem.style.opacity = 1;
                }
            }
        }
    }
    getComponentOffset(component) {
        let offsetX = 0;
        let offsetY = 0;
        const startComponent = component;
        while (component && !isNaN(component.offsetLeft) && !isNaN(component.offsetTop)
            && (component === startComponent || component.style.position === '' || component.style.position === 'static')) {
            offsetX += component.offsetLeft - component.scrollLeft;
            offsetY += component.offsetTop - component.scrollTop;
            component = component.offsetParent;
        }
        return { top: offsetY, left: offsetX };
    }
    paintSortingArrow(component, sort) {
        if (component.arrowImg) {
            return;
        }
        const arrowImg = document.createElement("div");
        let sortUpSrc = "<svg xmlns='http://www.w3.org/2000/svg' width='12' height='12'><path d='M1 9l5-4 5 4z' fill='#eeeeee' stroke='#666'/></svg>";
        let sortDownSrc = "<svg xmlns='http://www.w3.org/2000/svg' width='12' height='12'><path d='M1 5l5 4 5-4z' fill='#eeeeee' stroke='#666'/></svg>";
        arrowImg.innerHTML = sort == "asc" ? sortDownSrc : sortUpSrc;
        const arrowWidth = (this.model.reportParams.zoom / 100) * 16;
        const arrowHeight = (this.model.reportParams.zoom / 100) * 16;
        arrowImg.style.position = 'absolute';
        arrowImg.style.width = arrowWidth + 'px';
        arrowImg.style.height = arrowHeight + 'px';
        component.appendChild(arrowImg);
        component.arrowImg = arrowImg;
        const oldPosition = component.style.position;
        const oldClassName = component.className;
        let reportDisplayMode = this.model.options.displayModeFromReport || this.model.options.appearance.reportDisplayMode;
        if (reportDisplayMode == "Table")
            component.style.position = "relative";
        if (!oldClassName) {
            component.className = 'stiSortingParentElement';
        }
        const arrowLeftPos = this.helper.findPosX(arrowImg, component.className);
        const arrowTopPos = this.helper.findPosY(arrowImg, component.className);
        arrowImg.style.marginLeft = (component.offsetWidth - arrowLeftPos - arrowWidth - ((this.model.reportParams.zoom / 100) * 3)) + 'px';
        arrowImg.style.marginTop = (component.offsetHeight / 2 - arrowHeight / 2 - arrowTopPos) + 'px';
        if (oldPosition && reportDisplayMode == "Table")
            component.style.position = oldPosition;
        component.className = oldClassName;
    }
    paintCollapsingIcon(component, collapsed) {
        if (component.collapsImg) {
            return;
        }
        const collapsImg = document.createElement('img');
        collapsImg.src = collapsed ? this.model.img('CollapsingPlus.png') : this.model.img('CollapsingMinus.png');
        collapsImg.style.position = 'absolute';
        const collapsWidth = (this.model.reportParams.zoom / 100) * 10;
        const collapsHeight = (this.model.reportParams.zoom / 100) * 10;
        collapsImg.style.width = collapsWidth + 'px';
        collapsImg.style.height = collapsHeight + 'px';
        component.appendChild(collapsImg);
        component.collapsImg = collapsImg;
        const componentOffset = this.getComponentOffset(component);
        const collapsOffset = this.getComponentOffset(collapsImg);
        collapsImg.style.marginLeft = (componentOffset.left - collapsOffset.left + collapsWidth / 3) + 'px';
        collapsImg.style.marginTop = (componentOffset.top - collapsOffset.top + collapsWidth / 3) + 'px';
    }
    postInteractionSorting(component, isCtrl) {
        const params = {
            action: 'Sorting',
            sortingParameters: {
                ComponentName: component.getAttribute('interaction') + ';' + isCtrl.toString(),
                DataBand: component.getAttribute('databandsort')
            }
        };
        if (this.model.options.isParametersReceived) {
            params.variables = this.getParametersValues();
        }
        this.postInteraction(params);
    }
    postInteractionDrillDown(component) {
        const params = {
            action: 'DrillDown',
            drillDownParameters: {
                ComponentIndex: component.getAttribute('compindex'),
                ElementIndex: component.getAttribute('elementindex'),
                PageIndex: component.getAttribute('pageindex'),
                PageGuid: component.getAttribute('pageguid'),
                ReportFile: component.getAttribute('reportfile')
            }
        };
        this.postInteraction(params);
    }
    postInteractionCollapsing(component) {
        const componentName = component.getAttribute('interaction');
        const collapsingIndex = component.getAttribute('compindex');
        const collapsed = component.getAttribute('collapsed') === 'true' ? false : true;
        if (!this.model.reportParams.collapsingStates) {
            this.model.reportParams.collapsingStates = {};
        }
        if (!this.model.reportParams.collapsingStates[componentName]) {
            this.model.reportParams.collapsingStates[componentName] = {};
        }
        this.model.reportParams.collapsingStates[componentName][collapsingIndex] = collapsed;
        const params = {
            action: 'Collapsing',
            collapsingParameters: {
                ComponentName: componentName,
                CollapsingStates: this.model.reportParams.collapsingStates
            }
        };
        if (this.model.options.isParametersReceived) {
            params.variables = this.getParametersValues();
        }
        this.postInteraction(params);
    }
    updateAllHyperLinks() {
        let pointers = this.model.reportParams.tableOfContentsPointers;
        //var bookmarksPanel = this.controls.bookmarksPanel;
        if (this.model.reportParams.bookmarksContent != null || (pointers && pointers.length > 0)) {
            this.model.pages.forEach(p => {
                const page = p.page;
                if (page) {
                    const aHyperlinks = page.getElementsByTagName('a');
                    for (const aHyperlink of aHyperlinks) {
                        aHyperlink.hrefContent = aHyperlink.getAttribute('href');
                        if (aHyperlink.hrefContent) {
                            if (aHyperlink.hrefContent.indexOf("#") == 0) {
                                let anchorParams = aHyperlink.hrefContent.substring(1).split("#GUID#");
                                aHyperlink.anchorName = anchorParams[0];
                                aHyperlink.componentGuid = anchorParams.length > 1 ? anchorParams[1] : "";
                                aHyperlink.onclick = () => {
                                    let currAnchorName = aHyperlink.anchorName;
                                    let cuurCompGuid = aHyperlink.componentGuid;
                                    try {
                                        currAnchorName = decodeURI(aHyperlink.anchorName);
                                    }
                                    catch (e) {
                                        currAnchorName = aHyperlink.anchorName;
                                    }
                                    if (pointers.length > 0) {
                                        let pageIndex = 1;
                                        for (let i = 0; i < pointers.length; i++) {
                                            if (cuurCompGuid) {
                                                if (pointers[i].componentGuid == cuurCompGuid) {
                                                    pageIndex = pointers[i].pageIndex;
                                                    break;
                                                }
                                            }
                                            else if (currAnchorName) {
                                                let pointerAnchor = pointers[i].anchor.indexOf("#") == 0 ? pointers[i].anchor.substring(1) : pointers[i].anchor;
                                                if (pointerAnchor == currAnchorName) {
                                                    pageIndex = pointers[i].pageIndex;
                                                    break;
                                                }
                                            }
                                        }
                                        let anchorName = "";
                                        if (currAnchorName)
                                            anchorName += currAnchorName;
                                        if (cuurCompGuid)
                                            anchorName += ("#GUID#" + cuurCompGuid);
                                        if (anchorName) {
                                            this.controller.action({ name: 'BookmarkAction', bookmarkPage: Math.max(pageIndex - 1, 0), bookmarkAnchor: anchorName, componentGuid: aHyperlink.compunentGuid });
                                            return false;
                                        }
                                    }
                                    if (this.model.reportParams.bookmarksContent != null) {
                                        const node = this.model.nodes.find(n => n.name === currAnchorName);
                                        if (node) {
                                            this.model.navigateNode = node;
                                        }
                                        else {
                                            for (let k = 0; k < document.anchors.length; k++) {
                                                if (document.anchors[k].name == currAnchorName) {
                                                    //jsObject.scrollToAnchor(currAnchorName);
                                                    this.helper.scrollToAnchor(currAnchorName);
                                                    return;
                                                }
                                            }
                                        }
                                        this.controller.post('BookmarkAction', null, 0);
                                        /*let aBookmarks = bookmarksPanel.getElementsByTagName("a");
                                        for (let k = 0; k < aBookmarks.length; k++) {
                                          let clickFunc = aBookmarks[k].getAttribute("onclick");
                                          if (clickFunc && clickFunc.indexOf("'" + currAnchorName + "'") >= 0) {
                                            try {
                                              eval(clickFunc);
                                              return false;
                                            }
                                            catch (e) { }
                                          }
                                        }
                    
                                        this.controller.post('BookmarkAction', null, 0);*/
                                        return false;
                                    }
                                    //=================================
                                    /*let pageIndex = 1;
                                    for (let i = 0; i < pointers.length; i++) {
                                      if (aHyperlink.componentGuid) {
                                        if (pointers[i].componentGuid == aHyperlink.componentGuid) {
                                          pageIndex = pointers[i].pageIndex;
                                          break;
                                        }
                                      }
                                      else if (aHyperlink.bookmarkAnchor) {
                                        if (pointers[i].anchor == decodeURI(aHyperlink.bookmarkAnchor)) {
                                          pageIndex = pointers[i].pageIndex;
                                          break;
                                        }
                                      }
                                    }
                                    this.controller.action({ name: 'BookmarkAction', bookmarkPage: pageIndex - 1, bookmarkAnchor: decodeURI(aHyperlink.bookmarkAnchor), componentGuid: aHyperlink.compunentGuid });
                                    return false;
                                    };
                                    } else if (this.model.reportParams.bookmarksContent != null) {
                                    aHyperlink.anchorName = aHyperlink.hrefContent.replace('#', '');
                  
                                    aHyperlink.onclick = () => {
                                    const node = this.model.nodes.find(n => n.url.replace(/\\\'/g, '\'').substr(1) === aHyperlink.anchorName);
                                    if (node) {
                                      this.model.navigateNode = node;
                                    } else if (aHyperlink.hrefContent.indexOf('#') === 0) {
                                      for (let i = 0; i < document.anchors.length; i++) {
                                        const anchor = document.anchors[i];
                                        if (anchor.name === aHyperlink.anchorName) {
                                          this.helper.scrollToAnchor(aHyperlink.anchorName);
                                          return;
                                        }
                                      }
                                      this.controller.post('BookmarkAction', null, 0);
                                    }
                                    return false;
                                    };*/
                                };
                            }
                        }
                    }
                }
            });
        }
    }
}
InteractionsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsService, deps: [{ token: i1.ModelService }, { token: i2.Md5Service }, { token: i3.ControllerService }, { token: i4.HelperService }, { token: i5.DrillDownService }], target: i0.ɵɵFactoryTarget.Injectable });
InteractionsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.Md5Service }, { type: i3.ControllerService }, { type: i4.HelperService }, { type: i5.DrillDownService }]; } });
//# sourceMappingURL=data:application/json;base64,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