import { Injectable } from '@angular/core';
import { throwError } from 'rxjs';
import { catchError, timeout } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./model.service";
import * as i3 from "./helper.service";
export class StiHttpClientService {
    constructor(httpClient, model, helper) {
        this.httpClient = httpClient;
        this.model = model;
        this.helper = helper;
    }
    post(url, data, responseType = 'json') {
        const model = this.model;
        model.showProgress = true;
        const reqTimeout = this.model.options?.server?.requestTimeout > 0 ? this.model.options?.server?.requestTimeout * 1000 : 1000 * 1000;
        if (responseType === 'json') {
            return this.httpClient.post(url, this.getFormData(data)).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                model.httpError = error;
                model.showProgress = false;
                this.model.controls.navigatePanel.enabled = true;
                this.model.controls.toolbar.enabled = true;
                return throwError('Something bad happened; please try again later.');
            }));
        }
        else {
            return this.httpClient.post(url, this.getFormData(data), { responseType: 'text' }).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                model.httpError = error;
                model.showProgress = false;
                this.model.controls.navigatePanel.enabled = true;
                this.model.controls.toolbar.enabled = true;
                return throwError('Something bad happened; please try again later.');
            }));
        }
    }
    getFormData(data) {
        const formData = new FormData();
        Object.keys(data).forEach(key => formData.append(key, data[key]));
        return formData;
    }
    postForm(url, data, doc, postOnlyData = false) {
        if (!doc) {
            doc = document;
        }
        const form = doc.createElement('FORM');
        form.setAttribute('method', 'POST');
        form.setAttribute('action', url);
        const params = postOnlyData ? data : this.model.createPostParameters(data, true);
        Object.keys(params).forEach(key => {
            const paramsField = doc.createElement('INPUT');
            paramsField.setAttribute('type', 'hidden');
            paramsField.setAttribute('name', key);
            paramsField.setAttribute('value', params[key]);
            form.appendChild(paramsField);
        });
        if (this.model.options.jsDesigner) {
            this.model.options.jsDesigner.options.ignoreBeforeUnload = true;
        }
        doc.body.appendChild(form);
        form.submit();
        doc.body.removeChild(form);
        setTimeout(() => {
            if (this.model.options.jsDesigner) {
                this.model.options.jsDesigner.options.ignoreBeforeUnload = false;
            }
        }, 500);
    }
}
StiHttpClientService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService, deps: [{ token: i1.HttpClient }, { token: i2.ModelService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Injectable });
StiHttpClientService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.HttpClient }, { type: i2.ModelService }, { type: i3.HelperService }]; } });
//# sourceMappingURL=data:application/json;base64,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